import re
import os

from zope.interface import implements
from twisted.plugin import IPlugin

from sdfs.interfaces import IMetadata
from sdfs.enum import *
from sdfs.mixins import MetadataMixin

class IMDBMetadataHandler(object, MetadataMixin):
    implements(IPlugin, IMetadata)
    
    filetypes = re.compile(r'(?i).+\.nfo$')
    name = 'imdb'
    
    def found_file(self, root, virtual_root, f):
        with open(os.path.join(root, f)) as fn:
            d = fn.read()
        
        ids = re.findall(r'imdb\.com[^ ]+?(?:tt|\?|IMDB ID: )([0-9]{7})', d)
        if ids:
            self.set_metadata(DatabaseType.DIRECTORY, virtual_root, 'id',
                              ids[0].lstrip('0'))

    
imdbmetadatahandler = IMDBMetadataHandler()