import re
import os

from zope.interface import implements
from twisted.plugin import IPlugin

from mutagen.easyid3 import EasyID3
from mutagen.mp3 import MP3

from sdfs.interfaces import IMetadata
from sdfs.enum import *
from sdfs.mixins import MetadataMixin

class ID3URIHandler(object, MetadataMixin):
    implements(IPlugin, IMetadata)
    
    filetypes = re.compile(r'(?i).+\.mp3$')
    name = 'id3'
    
    def found_file(self, root, virtual_root, f):
        try:
            audio = MP3(os.path.join(root, f), ID3=EasyID3)
        except:
            return
        
        tags = {}
        for k in [k for k in ['album', 'title', 'artist', 'genre'] if k in audio]:
            tags[k] = audio[k][0]
        
        if 'tracknumber' in audio:
            try:
                tags['tracknumber'] = int(audio['tracknumber'][0].split('/')[0])
            except ValueError:
                pass
        
        if tags:
            vf = '%s/%s' % (virtual_root, f)
            
            for k, v in tags.items():
                self.set_metadata(DatabaseType.FILE, vf, k, v)

    
id3urihandler = ID3URIHandler()