from zope.interface import Interface, Attribute


class ISDFSPlugin(Interface):
    """
    A plugin usable by SDFS.
    """
    
    is_initialized = Attribute("""
        @type is_initialized: C{boolean}
        @ivar is_initialized: Has this plugin been initialized.
        """)
    
    name = Attribute("""
        @type name: C{string}
        @ivar name: Name of the plugin, used for identify.
        """)

class IURIHandler(ISDFSPlugin):
    """
    URI Scheme Handler.
    """

    scheme = Attribute("""
        @type scheme: C{string}
        @ivar scheme: Protocol scheme to support
    """)

class IMetadata(ISDFSPlugin):
    """
    Metadata creator.
    """
    def found_file(root, virtual_root, file): # pragma: no cover
        """
        Handed files to parse.

        @type root: C{string}
        @param root: Real path to folder with file
        
        @type virtual_root: C{string}
        @param virtual_root: Virtual path to file
        
        @type file: C{string}
        @param file: Filename

        @rtype: C{None}
        @return: returns nothing.
        """

    filetypes = Attribute("""
        @type filter: C{re}
        @ivar filter: File patterns to hand to found_file.
        """)

class ICrontab(ISDFSPlugin):
    """
    Uses crontabs
    """
    
    def schedule():
        """
        Creates the crontab

        @rtype: C{tuple}
        @return: A tuple with a (crontab_syntax, function), i.e. when to call function.
        """