class WebException(Exception):
    """Renderable exception, supports datatypes"""

class UnknownSchemeException(WebException):
    """The scheme attempted to use have no protocol handler"""

class FileOrFolderNotFoundException(WebException):
    """File or folder not found"""

class ConfigNotFoundException(Exception):
    """Configfile was not found"""

class UnableToStoreFile(Exception):
    """
    Raised when manually trying to add file
    that cannot be stored anywhere
    """