import unittest
import numpy as np
from thLib.signals import savgol
from time import sleep

class TestSequenceFunctions(unittest.TestCase):
    def setUp(self):
        t = np.arange(0,10,0.1)
        x = np.sin(t)
        self.data = x
    
    def test_windowSize(self):
        # should raise an exception 
        self.assertRaises(TypeError, savgol, np.arange(3), window_size=5)
        self.assertRaises(TypeError, savgol, self.data, window_size=0)
        self.assertRaises(TypeError, savgol, self.data, window_size=4)
        self.assertRaises(TypeError, savgol, self.data, window_size=2, order=3)
        
    def test_order(self):
        # should raise an exception
        self.assertRaises(TypeError, savgol, self.data, order=2, deriv=2)

    def test_smoothing(self):
        smoothed = savgol(self.data)

        self.assertTrue(np.abs(1-smoothed[round(np.pi/2*10)]<0.001))
        self.assertTrue(np.abs(smoothed[round(np.pi*10)]<0.05))

    def test_firstDeriv(self):
        firstDeriv = savgol(self.data, window_size=7, order=3, deriv=1, rate=10)
        fD = savgol(self.data, 7, 3, 1, 10)
        
        self.assertAlmostEqual(firstDeriv[14], fD[14])
        self.assertTrue(np.abs(1-firstDeriv[0])<0.001)
        self.assertTrue(np.abs(1+firstDeriv[np.round(np.pi*10)])<0.001)
        self.assertTrue(np.abs(firstDeriv[np.round(np.pi/2*10)])<0.03)
        
    def test_secondDeriv(self):
        secondDeriv = savgol(self.data, window_size=7, order=3, deriv=2, rate=10)
        
        self.assertTrue( np.abs(secondDeriv[0]) < 0.01)
        self.assertTrue( np.abs(1+secondDeriv[round(np.pi/2*10)]) < 0.01)
        self.assertTrue( np.abs(secondDeriv[round(np.pi*10)]) < 0.05)
        
    def test_matrix(self):
        smoothed = savgol(self.data)
        dataMat = np.tile(self.data, (3,1)).T
        smoothedMat = savgol(dataMat)
        self.assertEqual(smoothed[10], smoothedMat[10,1])

if __name__ == '__main__':
    unittest.main()
    print('Thanks for using programs from Thomas!')    
    sleep(2)
