import thLib.rotmat as rotmat
import unittest
import numpy as np

class TestSequenceFunctions(unittest.TestCase):
    def test_R1(self):
        R1 = np.array([[1,0,0],
                    [0, np.sqrt(2)/2, -np.sqrt(2)/2],
                    [0, np.sqrt(2)/2,  np.sqrt(2)/2]])
        
        self.assertTrue(np.all(np.abs(R1 - rotmat.R1(45))<1e-5))
        
    def test_R2(self):
        R2 = np.array([[ np.sqrt(2)/2, 0, np.sqrt(2)/2],
                       [0, 1, 0],
                       [-np.sqrt(2)/2, 0, np.sqrt(2)/2]])
        
        self.assertTrue(np.all(np.abs(R2 - rotmat.R2(45))<1e-5))
        
    def test_R3(self):
        R3 = np.array([[np.sqrt(2)/2, -np.sqrt(2)/2, 0],
                       [np.sqrt(2)/2,  np.sqrt(2)/2, 0],
                       [0, 0, 1]])
        
        self.assertTrue(np.all(np.abs(R3 - rotmat.R3(45))<1e-5))

    def test_symbolic(self):
        R_Fick = rotmat.R3_s()*rotmat.R2_s()*rotmat.R1_s()
    
if __name__ == '__main__':
    unittest.main()
