'''
Linear regression and confidence intervals
Similar to the MATLAB command "regress"

Call: (kd, ci) = regress(x,y,[alpha=0.05])
'''

'''
ThH, Dec-2011
Ver 1.0
'''

import scipy.stats as ss
import numpy as np

def regress(x, y, alpha=0.05):
    ''' Calculate linear regression and confidence intervals '''

    stats = ss.linregress(x,y)
    kd = stats[0:2]
    se_k = stats[4]
    
    level = (1.-alpha/2.)
    tVal = ss.t.ppf(level,len(x)-2)
    ci = kd[0] + se_k*tVal*np.array([-1, 1])
    
    return(kd, ci)
    

if __name__=='__main__':
    # Test function
    data = np.genfromtxt(r'C:\Users\p20529\Coding\R\Stats\exampleData_clean.txt')
    x = data[:,0]
    y = data[:,1]
    (kd, ci) = regress(x,y)
    
    print 'k = %.3f, d = %.3f, CIs = [%.3f - %.3f]' % (kd + tuple(ci))
