"""
Power Spectrum, calculated via FFT
"""

"""
Author: Thomas Haslwanter
Date:   Jan 2011
Ver:    1.0
"""
import numpy as np

def pSpect(data, rate):
    ''' Power spectrum '''

    nData = len(data)
    window = np.hamming(nData)
    fftData = np.fft.fftpack.fft(data*window)
    PowerSpect = fftData * fftData.conj() / nData
    freq = np.arange(nData) * float(rate) / nData
    return (PowerSpect, freq)

if __name__ == '__main__':
    rate = float(10)
    t =  np.arange(0,10,1/rate)
    x = np.sin(t) + np.random.randn(len(t))
    myPower, myFreq = pSpect(x,rate)
    print 'done'
