'''
Miscellaneous user interface utilities for selecting files or directories.
If nothing or a non-existing file/direcoty is selected, the return is "0". 
Otherwise the file/directory is returned.

Examples:
(myFile, myPath) = uigetfile('\*.py', 'Testing file-selection', r'c:\temp\test.py')
(myFile, myPath) = uisavefile('Testing file-saving', r'c:\temp\test.txt')
myDir = uigetdir(r'c:\temp', 'Pick your directory')
'''

'''
ThH, May 2012
Ver 1.0
'''

import sys
import wx
import os

def getfile(FilterSpec='*', DialogTitle='Select File: ', DefaultName='.'):
    '''Getting an existing file:
    FilterSpec ... file filters
    DialogTitle ... Window title
    DefaultName ... Can be a directory AND filename '''
        
    application = wx.PySimpleApp()
    
    dialog = wx.FileDialog ( None, message = DialogTitle, wildcard = FilterSpec, 
                            style = wx.OPEN, defaultFile = DefaultName)
    
    if dialog.ShowModal() == wx.ID_OK:
       selected = dialog.GetPath()
       selectionFlag = 1
#       print 'Selected:', selected
    else:
       print 'Nothing was selected.'
       selectionFlag = 0
    
    dialog.Destroy()     
    
    if selectionFlag == 1:
        fullInFile = selected
#        print 'Selection: ' + fullInFile
        dirName = os.path.dirname(fullInFile)
        fileName = os.path.basename(fullInFile)
        return (fileName, dirName)
    else:
        return(0,0)

def savefile(DialogTitle='Save File: ', DefaultName='.'):
    '''Selecting an existing or new file:
    DialogTitle ... Window title
    DefaultName ... Can be a directory AND filename '''
        
    application = wx.PySimpleApp()
    
    dialog = wx.FileDialog ( None, message = DialogTitle, style = wx.SAVE,
                            defaultFile = DefaultName)
    
    if dialog.ShowModal() == wx.ID_OK:
       selected = dialog.GetPath()
       selectionFlag = 1
#       print 'Selected:', selected
    else:
       print 'Nothing was selected.'
       selectionFlag = 0
    
    dialog.Destroy()     
    
    if selectionFlag == 1:
        fullInFile = selected
#        print 'Selection: ' + fullInFile
        dirName = os.path.dirname(fullInFile)
        fileName = os.path.basename(fullInFile)
        return (fileName, dirName)
    else:
        return(0,0)
        
def getdir(DefaultName='.',DialogTitle='Select Directory'):
    ''' Select an existing directory '''
    
    application = wx.PySimpleApp()
    
    # Create the dialog    
    dialog = wx.DirDialog ( None, message = 'Pick a directory.', 
                           defaultPath = DefaultName)
    
    # Show the dialog and get user input    
    if dialog.ShowModal() == wx.ID_OK:    
       print 'Directory:', dialog.GetPath()
       selectionFlag = 1
    # The user cancelled    
    else:    
       print 'No directory.'
       selectionFlag = 0
    # Get rid of the dialog
    dialog.Destroy()

    if selectionFlag == 1:
        return dialog.GetPath()
    else:
        return 0
    
if __name__ == "__main__":   
    # Test functions

    (myFile, myPath) = getfile('*.py', 'Testing file-selection', r'c:\temp\test.py')
    if myFile > 0:          
        print 'File: %s, Path: %s' % (myFile, myPath)
    else:
        print 0

    (myFile, myPath) = savefile('Testing file-saving', r'c:\temp\test.txt')
    if myFile > 0:          
        print 'File: %s, Path: %s' % (myFile, myPath)
    else:
        print 0        

    myDir = getdir(r'c:\temp', 'Pick your directory')
    print myDir
