'''
 - Definition of 3D rotation matrices
 - Conversion from quaternions to rotation matrices
'''
 
'''
Created on July, 2013

@author: Thomas Haslwanter
Ver. 1.4
'''

import numpy as np
import sympy

def R1(psi):
    '''Rotation about the 1-axis.
    The argument is entered in degree.'''
    
    # convert from degrees into radian:
    psi = psi * np.pi/180;
    
    R = np.array([[1, 0, 0],
            [0, np.cos(psi), -np.sin(psi)],
            [0, np.sin(psi),  np.cos(psi)]])
    
    return R

def R2(phi):
    '''Rotation about the 2-axis.
    The argument is entered in degree.'''
    
    # convert from degrees into radian:
    phi = phi * np.pi/180;
    
    R = np.array([[np.cos(phi), 0, np.sin(phi)],
            [0, 1, 0],
            [  -np.sin(phi), 0, np.cos(phi)]])
    
    return R

def R3(theta):
    '''Rotation about the 3-axis.
    The argument is entered in degree.'''

    
    # convert from degrees into radian:
    theta = theta * np.pi/180;
    
    R = np.array([[np.cos(theta), -np.sin(theta), 0],
               [np.sin(theta),  np.cos(theta), 0],
               [0, 0, 1]])
    
    return R

def Quat2Rotmat(quat):
    '''Rotation matrix corresponding to a unit quaternion.'''

    q1, q2, q3 = quat
    q0 = np.sqrt(1-sum(quat**2))

    R = np.array([[q0**2+q1**2-q2**2-q3**2, 2*(q1*q2-q0*q3), 2*(q1*q3+q0*q2)],
    [2*(q1*q2+q0*q3), q0**2-q1**2+q2**2-q3**2, 2*(q2*q3-q0*q1)],
    [2*(q1*q3-q0*q2),2*(q2*q3+q0*q1), q0**2-q1**2-q2**2+q3**2]])

    return R
