from os.path import exists
from envoy import run
from its import osx

if not osx:
    raise OSError("""tempmonitor is Mac OS only :)
http://www.bresink.com/osx/TemperatureMonitor.html""")
bin="/Applications/TemperatureMonitor.app/Contents/MacOS/tempmonitor"
if not exists(bin):
    raise IOError("%s not exists" % bin)

def get(arg):
    """execute tempmonitor with given arg"""
    cmd="%s %s" % (bin,arg.replace(" ","\\ "))
    r=run(cmd)
    if r.status_code==0:
        return r.std_out
    else:
        raise Exception(r.std_err)

def sensors():
    """return list of aviable sensors, tempmonitor -th"""
    return map(
        lambda s:s.replace('"',"").strip(),
        get("-th").split(",")[1:]
    )

def grep(v):
    """grep sensor and return int value"""
    result=get("-c -l -a")
    for l in result.splitlines():
        if l.find(v)>=0:
            a=[int(s) for s in l.split() if s.isdigit()]
            return a[-1]

def air():
    """return value of AMBIENT AIR sensor"""
    return grep("AMBIENT AIR")