#!/usr/bin/env python
# -*- coding: utf-8 -*-
""" Setup file for tempmonitor package """

from setuptools import find_packages, setup
from os.path import abspath, dirname, join


dir=dirname(abspath(__file__))
description = open(join(dir,'description')).read()
readme = open(join(dir,'README.rst')).read()


setup(name='tempmonitor',
      version='0.0.1',
      description=description,
      long_description=readme,
      author='cancerhermit',
      author_email='cancerhermit@gmail.com',
      url='http://github.com/cancerhermit/tempmonitor.py/',
      packages = find_packages(),
      install_requires=[
        "envoy",
        "its"
      ],
      platforms = ["MacOS X"],
      keywords="tempmonitor wrapper",
      classifiers=(
          'License :: OSI Approved :: GNU General Public License (GPL)',
          'Environment :: Console',
          'Environment :: MacOS X',

          'Natural Language :: English',

          'Operating System :: MacOS',

          'Programming Language :: Python',

          'Topic :: Software Development :: Libraries :: Python Modules',
          'Topic :: Utilities'
        ),
      license="GPL"
     )