#!/usr/bin/env python
import os
import sys

from setuptools import setup, find_packages

here = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, os.path.join(here, 'src'))

from quant import __version__

basePath = os.path.abspath(os.path.dirname(sys.argv[0]))
scripts = [ 
    os.path.join('bin', 'quant-makeconfig'),
    os.path.join('bin', 'quant-admin'),
    os.path.join('bin', 'quant-test'),
]

setup(
    name='quant',
    version=__version__,

    package_dir={'': 'src'},
    packages=find_packages('src'),
    scripts=scripts,
    # just use auto-include and specify special items in MANIFEST.in
    include_package_data = True,
    zip_safe = False,
    install_requires = [
        'domainmodel==0.10',
        'python-dateutil',
        # Installing scipy with setuptools doesn't work.
        #'scipy', 
        #'numpy',
    ],
    author='Appropriate Software Foundation',
    author_email='john.bywater@appropriatesoftware.net',
    license='GPL',
    url='http://appropriatesoftware.net/quant',
    description='Enterprise architecture for quantitative analysis',
    long_description = """

The Quant system is a Python enterprise application for quantitative analysis.

Quant contains a domain model for quantitative analysis which can used and extended to support different contexts.


Install Guide
-------------

The easiest way to deploy the Quant system is with the quant installer (called quant-virtualenv)::

    $ wget http://appropriatesoftware.net/provide/docs/quant-virtualenv
    $ chmod +x quant-virtualenv

The installer will build a virtual Python environment with Quant installed, and will
set up a new site with an sqlite database, and an Apache config file to be included in
the main Apache configuration (see below).

Before running the installer, make sure the following packages are installed::

    $ sudo aptitude install build-essential gcc python-numpy python-scipy

Also, make sure Apache mod_python is enabled (sorry, this is being fixed)::

    $ sudo a2enmod python

If you're instested, find out about the installer options by running::

    $ ./quant-virtualenv --help

Run the installer, at least with a path argument::

    $ ./quant-virtualenv ./my-quant-site
 
Then change ownership of the entire site to the Apache server::

    $ sudo chown -R www-data:www-data ./my-quant-site

You can do more complicated things with the installer (see --help) and
with the file permissions and ownerships, but those few lines should work.

Finally, follow the instructions about configuring Apache that are shown
by the installer. Pick a fully qualified domain name, create a new virtual
host for it, that includes the auto-generated Quant configuration mentioned
by the installer. Then configure your DNS.

A new Apache virtual host could simply look like this:

    <VirtualHost *:80>
        ServerName YOUR-QUANT-SITE-DOMAIN-NAME
        Include /path/to/my-quant-site/var/httpd-autogenerated.conf
    </VirtualHost>

After restarting, your virtual host should show a page saying 'Welcome to Quant'.


Contact
-------

If you have any questions about Quant, please contact::

    john.bywater@appropriatesoftware.net


At the moment, Quant is currently being developed and tested on Ubuntu 10.10 (64 bit) with Python 2.6 only, although it should work on any recent Linux distribution.


Website
-------

Please refer to the Features page of the `Quant website 
<http://appropriatesoftware.net/quant/Home.html>`_ for more information.


""",
    classifiers = [
#        'Development Status :: 5 - Production/Stable',
        'Environment :: Console',
        'Environment :: Web Environment',
#        'Intended Audience :: Developers',
        'License :: OSI Approved :: GNU General Public License (GPL)',
#        'Operating System :: OS Independent',
        'Programming Language :: Python',
        'Topic :: Software Development :: Libraries :: Python Modules'],
)
