from winrm.protocol import Protocol


class Response(object):
    """Response from a remote command execution"""
    def __init__(self, args):
        self.std_out, self.std_err, self.status_code = args

    def __repr__(self):
        #TODO put tree dots at the end if out/err was truncated
        return '<Response code {}, out "{}", err "{}">'.format(
            self.status_code, self.std_out[:20], self.std_err[:20])


class Session(object):
    #TODO implement context manager methods
    def __init__(self, url, auth):
        #TODO convert short urls into well-formed endpoint
        username, password = auth
        self.protocol = Protocol(url, username=username, password=password)

    def run_cmd(self, command, args=()):
        #TODO optimize perf. Do not call open/close shell every time
        shell_id = self.protocol.open_shell()
        command_id = self.protocol.run_command(shell_id, command, args)
        rs = Response(self.protocol.get_command_output(shell_id, command_id))
        self.protocol.cleanup_command(shell_id, command_id)
        self.protocol.close_shell(shell_id)
        return rs