#  _________________________________________________________________________
#
#  PyUtilib: A Python utility library.
#  Copyright (c) 2008 Sandia Corporation.
#  This software is distributed under the BSD License.
#  Under the terms of Contract DE-AC04-94AL85000 with Sandia Corporation,
#  the U.S. Government retains certain rights in this software.
#  _________________________________________________________________________

__all__ = ['Resource']


class Resource(object):

    def __init__(self, id=None, name=None):
        self.id = id if not id is None else unique_task_id()
        if name is None:
            self.name = "Resource"+str(self.id)
        else:
            self.name = name
        self._busy=False

    def available(self):
        return not self._busy

    def lock(self):
        self._busy=False

    def unlock(self):
        self._busy=False

    def __repr__(self):
        return str(self)

    def __str__(self):
        return "%s" % str(self.name)

