/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk;

import com.unboundid.ldap.protocol.LDAPResponse;
import com.unboundid.ldap.sdk.AbstractConnectionPool;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.ConnectionClosedResponse;
import com.unboundid.ldap.sdk.DisconnectType;
import com.unboundid.ldap.sdk.ExtendedResult;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheck;
import com.unboundid.ldap.sdk.LDAPConnectionPoolHealthCheckThread;
import com.unboundid.ldap.sdk.LDAPConnectionPoolStatistics;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPMessages;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.OperationType;
import com.unboundid.ldap.sdk.PostConnectProcessor;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.ldap.sdk.SingleServerSet;
import com.unboundid.ldap.sdk.UnsolicitedNotificationHandler;
import com.unboundid.util.Debug;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class LDAPConnectionPool
extends AbstractConnectionPool {
    private static final long DEFAULT_HEALTH_CHECK_INTERVAL = 60000L;
    private final AtomicInteger failedReplaceCount;
    private final AtomicReference<Set<OperationType>> retryOperationTypes;
    private volatile boolean closed;
    private boolean createIfNecessary;
    private volatile boolean trySynchronousReadDuringHealthCheck;
    private final BindRequest bindRequest;
    private final int numConnections;
    private LDAPConnectionPoolHealthCheck healthCheck;
    private final LDAPConnectionPoolHealthCheckThread healthCheckThread;
    private final LDAPConnectionPoolStatistics poolStatistics;
    private final LinkedBlockingQueue<LDAPConnection> availableConnections;
    private volatile long healthCheckInterval;
    private volatile long lastExpiredDisconnectTime;
    private volatile long maxConnectionAge;
    private long maxWaitTime;
    private volatile long minDisconnectInterval;
    private final PostConnectProcessor postConnectProcessor;
    private final ServerSet serverSet;
    private String connectionPoolName;

    public LDAPConnectionPool(LDAPConnection connection, int numConnections) throws LDAPException {
        this(connection, 1, numConnections, null);
    }

    public LDAPConnectionPool(LDAPConnection connection, int initialConnections, int maxConnections) throws LDAPException {
        this(connection, initialConnections, maxConnections, null);
    }

    public LDAPConnectionPool(LDAPConnection connection, int initialConnections, int maxConnections, PostConnectProcessor postConnectProcessor) throws LDAPException {
        Validator.ensureNotNull(connection);
        Validator.ensureTrue(initialConnections >= 1, "LDAPConnectionPool.initialConnections must be at least 1.");
        Validator.ensureTrue(maxConnections >= initialConnections, "LDAPConnectionPool.initialConnections must not be greater than maxConnections.");
        this.postConnectProcessor = postConnectProcessor;
        this.trySynchronousReadDuringHealthCheck = true;
        this.healthCheck = new LDAPConnectionPoolHealthCheck();
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        if (!connection.isConnected()) {
            throw new LDAPException(ResultCode.PARAM_ERROR, LDAPMessages.ERR_POOL_CONN_NOT_ESTABLISHED.get());
        }
        this.serverSet = new SingleServerSet(connection.getConnectedAddress(), connection.getConnectedPort(), connection.getLastUsedSocketFactory(), connection.getConnectionOptions());
        this.bindRequest = connection.getLastBindRequest();
        ArrayList<LDAPConnection> connList = new ArrayList<LDAPConnection>(initialConnections);
        connection.setConnectionName(null);
        connection.setConnectionPool(this);
        connList.add(connection);
        for (int i = 1; i < initialConnections; ++i) {
            try {
                connList.add(this.createConnection());
                continue;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                for (LDAPConnection c : connList) {
                    try {
                        c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, le);
                        c.terminate(null);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                throw le;
            }
        }
        this.numConnections = maxConnections;
        this.availableConnections = new LinkedBlockingQueue(this.numConnections);
        this.availableConnections.addAll(connList);
        this.failedReplaceCount = new AtomicInteger(maxConnections - initialConnections);
        this.createIfNecessary = true;
        this.maxConnectionAge = 0L;
        this.minDisconnectInterval = 0L;
        this.lastExpiredDisconnectTime = 0L;
        this.maxWaitTime = 5000L;
        this.closed = false;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int numConnections) throws LDAPException {
        this(serverSet, bindRequest, 1, numConnections, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int initialConnections, int maxConnections) throws LDAPException {
        this(serverSet, bindRequest, initialConnections, maxConnections, null);
    }

    public LDAPConnectionPool(ServerSet serverSet, BindRequest bindRequest, int initialConnections, int maxConnections, PostConnectProcessor postConnectProcessor) throws LDAPException {
        Validator.ensureNotNull(serverSet);
        Validator.ensureTrue(initialConnections >= 0, "LDAPConnectionPool.initialConnections must be greater than or equal to 0.");
        Validator.ensureTrue(maxConnections > 0, "LDAPConnectionPool.maxConnections must be greater than 0.");
        Validator.ensureTrue(maxConnections >= initialConnections, "LDAPConnectionPool.initialConnections must not be greater than maxConnections.");
        this.serverSet = serverSet;
        this.bindRequest = bindRequest;
        this.postConnectProcessor = postConnectProcessor;
        this.healthCheck = new LDAPConnectionPoolHealthCheck();
        this.healthCheckInterval = 60000L;
        this.poolStatistics = new LDAPConnectionPoolStatistics(this);
        this.connectionPoolName = null;
        this.retryOperationTypes = new AtomicReference<Set<OperationType>>(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        ArrayList<LDAPConnection> connList = new ArrayList<LDAPConnection>(initialConnections);
        for (int i = 0; i < initialConnections; ++i) {
            try {
                connList.add(this.createConnection());
                continue;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                for (LDAPConnection c : connList) {
                    try {
                        c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, le);
                        c.terminate(null);
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                    }
                }
                throw le;
            }
        }
        this.numConnections = maxConnections;
        this.availableConnections = new LinkedBlockingQueue(this.numConnections);
        this.availableConnections.addAll(connList);
        this.failedReplaceCount = new AtomicInteger(maxConnections - initialConnections);
        this.createIfNecessary = true;
        this.maxConnectionAge = 0L;
        this.minDisconnectInterval = 0L;
        this.lastExpiredDisconnectTime = 0L;
        this.maxWaitTime = 5000L;
        this.closed = false;
        this.healthCheckThread = new LDAPConnectionPoolHealthCheckThread(this);
        this.healthCheckThread.start();
    }

    private LDAPConnection createConnection() throws LDAPException {
        LDAPConnection c = this.serverSet.getConnection(this.healthCheck);
        c.setConnectionPool(this);
        LDAPConnectionOptions opts = c.getConnectionOptions();
        if (opts.autoReconnect()) {
            opts = opts.duplicate();
            opts.setAutoReconnect(false);
            c.setConnectionOptions(opts);
        }
        if (this.postConnectProcessor != null) {
            try {
                this.postConnectProcessor.processPreAuthenticatedConnection(c);
            }
            catch (Exception e) {
                Debug.debugException(e);
                try {
                    this.poolStatistics.incrementNumFailedConnectionAttempts();
                    c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, e);
                    c.terminate(null);
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
                if (e instanceof LDAPException) {
                    throw (LDAPException)e;
                }
                throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        try {
            if (this.bindRequest != null) {
                c.bind(this.bindRequest.duplicate());
            }
        }
        catch (Exception e) {
            Debug.debugException(e);
            try {
                this.poolStatistics.incrementNumFailedConnectionAttempts();
                c.setDisconnectInfo(DisconnectType.BIND_FAILED, null, e);
                c.terminate(null);
            }
            catch (Exception e2) {
                Debug.debugException(e2);
            }
            if (e instanceof LDAPException) {
                throw (LDAPException)e;
            }
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
        }
        if (this.postConnectProcessor != null) {
            try {
                this.postConnectProcessor.processPostAuthenticatedConnection(c);
            }
            catch (Exception e) {
                Debug.debugException(e);
                try {
                    this.poolStatistics.incrementNumFailedConnectionAttempts();
                    c.setDisconnectInfo(DisconnectType.POOL_CREATION_FAILURE, null, e);
                    c.terminate(null);
                }
                catch (Exception e2) {
                    Debug.debugException(e2);
                }
                if (e instanceof LDAPException) {
                    throw (LDAPException)e;
                }
                throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_POST_CONNECT_ERROR.get(StaticUtils.getExceptionMessage(e)), e);
            }
        }
        c.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumSuccessfulConnectionAttempts();
        return c;
    }

    @Override
    public void close() {
        this.closed = true;
        this.healthCheckThread.stopRunning();
        LDAPConnection conn;
        while ((conn = this.availableConnections.poll()) != null) {
            this.poolStatistics.incrementNumConnectionsClosedUnneeded();
            conn.setDisconnectInfo(DisconnectType.POOL_CLOSED, null, null);
            conn.terminate(null);
        }
        return;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public LDAPConnection getConnection() throws LDAPException {
        if (this.closed) {
            this.poolStatistics.incrementNumFailedCheckouts();
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        LDAPConnection conn = this.availableConnections.poll();
        if (conn != null) {
            if (conn.isConnected()) {
                try {
                    this.healthCheck.ensureConnectionValidForCheckout(conn);
                    this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                    return conn;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                }
            }
            this.handleDefunctConnection(conn);
            for (int i = 0; i < this.numConnections && (conn = this.availableConnections.poll()) != null; ++i) {
                if (conn.isConnected()) {
                    try {
                        this.healthCheck.ensureConnectionValidForCheckout(conn);
                        this.poolStatistics.incrementNumSuccessfulCheckoutsWithoutWaiting();
                        return conn;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.handleDefunctConnection(conn);
                        continue;
                    }
                }
                this.handleDefunctConnection(conn);
            }
        }
        if (this.failedReplaceCount.get() > 0) {
            int newReplaceCount = this.failedReplaceCount.getAndDecrement();
            if (newReplaceCount > 0) {
                try {
                    conn = this.createConnection();
                    this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
                    return conn;
                }
                catch (LDAPException le) {
                    Debug.debugException(le);
                    this.failedReplaceCount.incrementAndGet();
                    this.poolStatistics.incrementNumFailedCheckouts();
                    throw le;
                }
            }
            this.failedReplaceCount.incrementAndGet();
            this.poolStatistics.incrementNumFailedCheckouts();
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_NO_CONNECTIONS.get());
        }
        if (this.maxWaitTime > 0L) {
            try {
                conn = this.availableConnections.poll(this.maxWaitTime, TimeUnit.MILLISECONDS);
                if (conn != null) {
                    try {
                        this.healthCheck.ensureConnectionValidForCheckout(conn);
                        this.poolStatistics.incrementNumSuccessfulCheckoutsAfterWaiting();
                        return conn;
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                        this.handleDefunctConnection(conn);
                    }
                }
            }
            catch (InterruptedException ie) {
                Debug.debugException(ie);
            }
        }
        if (this.createIfNecessary) {
            try {
                conn = this.createConnection();
                this.poolStatistics.incrementNumSuccessfulCheckoutsNewConnection();
                return conn;
            }
            catch (LDAPException le) {
                Debug.debugException(le);
                this.poolStatistics.incrementNumFailedCheckouts();
                throw le;
            }
        }
        this.poolStatistics.incrementNumFailedCheckouts();
        throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_NO_CONNECTIONS.get());
    }

    @Override
    public void releaseConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        connection.setConnectionPoolName(this.connectionPoolName);
        if (this.connectionIsExpired(connection)) {
            try {
                LDAPConnection newConnection = this.createConnection();
                if (this.availableConnections.offer(newConnection)) {
                    connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_EXPIRED, null, null);
                    connection.terminate(null);
                    this.poolStatistics.incrementNumConnectionsClosedExpired();
                    this.lastExpiredDisconnectTime = System.currentTimeMillis();
                    return;
                }
                newConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                newConnection.terminate(null);
                this.poolStatistics.incrementNumConnectionsClosedUnneeded();
            }
            catch (LDAPException le) {
                Debug.debugException(le);
            }
        }
        try {
            this.healthCheck.ensureConnectionValidForRelease(connection);
        }
        catch (LDAPException le) {
            this.releaseDefunctConnection(connection);
            return;
        }
        if (!this.availableConnections.offer(connection)) {
            connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
            this.poolStatistics.incrementNumConnectionsClosedUnneeded();
            connection.terminate(null);
            return;
        }
        this.poolStatistics.incrementNumReleasedValid();
        if (this.closed) {
            this.close();
        }
    }

    @Override
    public void releaseDefunctConnection(LDAPConnection connection) {
        if (connection == null) {
            return;
        }
        connection.setConnectionPoolName(this.connectionPoolName);
        this.poolStatistics.incrementNumConnectionsClosedDefunct();
        this.handleDefunctConnection(connection);
    }

    private LDAPConnection handleDefunctConnection(LDAPConnection connection) {
        connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        connection.terminate(null);
        if (this.closed) {
            return null;
        }
        if (this.createIfNecessary && this.availableConnections.remainingCapacity() <= 0) {
            return null;
        }
        try {
            LDAPConnection conn = this.createConnection();
            if (!this.availableConnections.offer(conn)) {
                conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                conn.terminate(null);
                return null;
            }
            return conn;
        }
        catch (LDAPException le) {
            Debug.debugException(le);
            this.failedReplaceCount.incrementAndGet();
            return null;
        }
    }

    @Override
    public LDAPConnection replaceDefunctConnection(LDAPConnection connection) throws LDAPException {
        connection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, null);
        connection.terminate(null);
        if (this.closed) {
            throw new LDAPException(ResultCode.CONNECT_ERROR, LDAPMessages.ERR_POOL_CLOSED.get());
        }
        return this.createConnection();
    }

    @Override
    public Set<OperationType> getOperationTypesToRetryDueToInvalidConnections() {
        return this.retryOperationTypes.get();
    }

    @Override
    public void setRetryFailedOperationsDueToInvalidConnections(Set<OperationType> operationTypes) {
        if (operationTypes == null || operationTypes.isEmpty()) {
            this.retryOperationTypes.set(Collections.unmodifiableSet(EnumSet.noneOf(OperationType.class)));
        } else {
            EnumSet<OperationType> s = EnumSet.noneOf(OperationType.class);
            s.addAll(operationTypes);
            this.retryOperationTypes.set(Collections.unmodifiableSet(s));
        }
    }

    private boolean connectionIsExpired(LDAPConnection connection) {
        if (this.maxConnectionAge <= 0L) {
            return false;
        }
        long currentTime = System.currentTimeMillis();
        if (currentTime - this.lastExpiredDisconnectTime < this.minDisconnectInterval) {
            return false;
        }
        long connectionAge = currentTime - connection.getConnectTime();
        return connectionAge > this.maxConnectionAge;
    }

    @Override
    public String getConnectionPoolName() {
        return this.connectionPoolName;
    }

    @Override
    public void setConnectionPoolName(String connectionPoolName) {
        this.connectionPoolName = connectionPoolName;
        for (LDAPConnection c : this.availableConnections) {
            c.setConnectionPoolName(connectionPoolName);
        }
    }

    public boolean getCreateIfNecessary() {
        return this.createIfNecessary;
    }

    public void setCreateIfNecessary(boolean createIfNecessary) {
        this.createIfNecessary = createIfNecessary;
    }

    public long getMaxWaitTimeMillis() {
        return this.maxWaitTime;
    }

    public void setMaxWaitTimeMillis(long maxWaitTime) {
        this.maxWaitTime = maxWaitTime > 0L ? maxWaitTime : 0L;
    }

    public long getMaxConnectionAgeMillis() {
        return this.maxConnectionAge;
    }

    public void setMaxConnectionAgeMillis(long maxConnectionAge) {
        this.maxConnectionAge = maxConnectionAge > 0L ? maxConnectionAge : 0L;
    }

    public long getMinDisconnectIntervalMillis() {
        return this.minDisconnectInterval;
    }

    public void setMinDisconnectIntervalMillis(long minDisconnectInterval) {
        this.minDisconnectInterval = minDisconnectInterval > 0L ? minDisconnectInterval : 0L;
    }

    @Override
    public LDAPConnectionPoolHealthCheck getHealthCheck() {
        return this.healthCheck;
    }

    public void setHealthCheck(LDAPConnectionPoolHealthCheck healthCheck) {
        Validator.ensureNotNull(healthCheck);
        this.healthCheck = healthCheck;
    }

    @Override
    public long getHealthCheckIntervalMillis() {
        return this.healthCheckInterval;
    }

    @Override
    public void setHealthCheckIntervalMillis(long healthCheckInterval) {
        Validator.ensureTrue(healthCheckInterval > 0L, "LDAPConnectionPool.healthCheckInterval must be greater than 0.");
        this.healthCheckInterval = healthCheckInterval;
        this.healthCheckThread.wakeUp();
    }

    public boolean trySynchronousReadDuringHealthCheck() {
        return this.trySynchronousReadDuringHealthCheck;
    }

    public void setTrySynchronousReadDuringHealthCheck(boolean trySynchronousReadDuringHealthCheck) {
        this.trySynchronousReadDuringHealthCheck = trySynchronousReadDuringHealthCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doHealthCheck() {
        LDAPConnection conn;
        HashSet<LDAPConnection> examinedConnections = new HashSet<LDAPConnection>(this.numConnections);
        for (int i = 0; i < this.numConnections && (conn = this.availableConnections.poll()) != null; ++i) {
            block40: {
                if (examinedConnections.contains(conn)) {
                    if (this.availableConnections.offer(conn)) break;
                    conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                    this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    conn.terminate(null);
                    break;
                }
                if (!conn.isConnected()) {
                    if ((conn = this.handleDefunctConnection(conn)) == null) continue;
                    examinedConnections.add(conn);
                    continue;
                }
                if (this.connectionIsExpired(conn)) {
                    try {
                        LDAPConnection newConnection = this.createConnection();
                        if (this.availableConnections.offer(newConnection)) {
                            examinedConnections.add(newConnection);
                            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_EXPIRED, null, null);
                            conn.terminate(null);
                            this.poolStatistics.incrementNumConnectionsClosedExpired();
                            this.lastExpiredDisconnectTime = System.currentTimeMillis();
                            continue;
                        }
                        newConnection.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                        newConnection.terminate(null);
                        this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                    }
                    catch (LDAPException le) {
                        Debug.debugException(le);
                    }
                }
                if (this.trySynchronousReadDuringHealthCheck && conn.synchronousMode()) {
                    int previousTimeout = Integer.MIN_VALUE;
                    Socket s = conn.getConnectionInternals().getSocket();
                    try {
                        LDAPResult r;
                        previousTimeout = s.getSoTimeout();
                        s.setSoTimeout(1);
                        LDAPResponse response = conn.readResponse(0);
                        if (response instanceof ConnectionClosedResponse) {
                            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_CONN_CLOSED.get(), null);
                            this.poolStatistics.incrementNumConnectionsClosedDefunct();
                            conn = this.handleDefunctConnection(conn);
                            if (conn == null) continue;
                            examinedConnections.add(conn);
                            continue;
                        }
                        if (response instanceof ExtendedResult) {
                            UnsolicitedNotificationHandler h = conn.getConnectionOptions().getUnsolicitedNotificationHandler();
                            if (h != null) {
                                h.handleUnsolicitedNotification(conn, (ExtendedResult)response);
                            }
                        } else if (response instanceof LDAPResult && (r = (LDAPResult)response).getResultCode() == ResultCode.SERVER_DOWN) {
                            conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_CONN_CLOSED.get(), null);
                            this.poolStatistics.incrementNumConnectionsClosedDefunct();
                            conn = this.handleDefunctConnection(conn);
                            if (conn == null) continue;
                            examinedConnections.add(conn);
                            continue;
                        }
                    }
                    catch (LDAPException le) {
                        if (le.getResultCode() == ResultCode.TIMEOUT) {
                            Debug.debugException(Level.FINEST, le);
                            break block40;
                        }
                        Debug.debugException(le);
                        conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_READ_FAILURE.get(StaticUtils.getExceptionMessage(le)), le);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        conn = this.handleDefunctConnection(conn);
                        if (conn == null) continue;
                        examinedConnections.add(conn);
                        continue;
                    }
                    catch (Exception e) {
                        Debug.debugException(e);
                        conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, LDAPMessages.ERR_POOL_HEALTH_CHECK_READ_FAILURE.get(StaticUtils.getExceptionMessage(e)), e);
                        this.poolStatistics.incrementNumConnectionsClosedDefunct();
                        conn = this.handleDefunctConnection(conn);
                        if (conn == null) continue;
                        examinedConnections.add(conn);
                        continue;
                    }
                    finally {
                        if (previousTimeout != Integer.MIN_VALUE) {
                            try {
                                s.setSoTimeout(previousTimeout);
                            }
                            catch (Exception e) {
                                Debug.debugException(e);
                                conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_DEFUNCT, null, e);
                                this.poolStatistics.incrementNumConnectionsClosedDefunct();
                                conn = this.handleDefunctConnection(conn);
                                if (conn == null) continue;
                                examinedConnections.add(conn);
                                continue;
                            }
                        }
                    }
                }
            }
            try {
                this.healthCheck.ensureConnectionValidForContinuedUse(conn);
                if (this.availableConnections.offer(conn)) {
                    examinedConnections.add(conn);
                    continue;
                }
                conn.setDisconnectInfo(DisconnectType.POOLED_CONNECTION_UNNEEDED, null, null);
                this.poolStatistics.incrementNumConnectionsClosedUnneeded();
                conn.terminate(null);
                continue;
            }
            catch (Exception e) {
                Debug.debugException(e);
                conn = this.handleDefunctConnection(conn);
                if (conn == null) continue;
                examinedConnections.add(conn);
            }
        }
    }

    @Override
    public int getCurrentAvailableConnections() {
        return this.availableConnections.size();
    }

    @Override
    public int getMaximumAvailableConnections() {
        return this.numConnections;
    }

    @Override
    public LDAPConnectionPoolStatistics getConnectionPoolStatistics() {
        return this.poolStatistics;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    @Override
    public void toString(StringBuilder buffer) {
        buffer.append("LDAPConnectionPool(");
        String name = this.connectionPoolName;
        if (name != null) {
            buffer.append("name='");
            buffer.append(name);
            buffer.append("', ");
        }
        buffer.append("serverSet=");
        this.serverSet.toString(buffer);
        buffer.append(", maxConnections=");
        buffer.append(this.numConnections);
        buffer.append(')');
    }
}

