from PyObjCTools.TestSupport import *
import objc
from objc import YES, NO, nil
from PyObjCTest.fnd import NSPriorDayDesignations
import sys

from PyObjCTest import ctests

# Several types are encoded slightly different on 32-bit vs. 64-bit
# - NSPoint and NSRect: the actual type is different
# - @encode(long) is _C_LNG_LNG instead of _C_LNG on 64-bit builds
if sys.maxint > 2 ** 32:
    NSPoint_tp = '{_NSPoint=dd}'
    NSRect_tp = '{_NSRect={_NSPoint=dd}{_NSSize=dd}}'
    long_tp = 'q'
    ulong_tp = 'Q'

else:
    NSPoint_tp = '{_NSPoint=ff}'
    NSRect_tp = '{_NSRect={_NSPoint=ff}{_NSSize=ff}}'
    long_tp = 'l'
    ulong_tp = 'L'


#
# NSInvocation in MacOS X 10.2 doesn't like some struct definition, it
# garbles the contents of those structs. These unittests disable NSInvocation
# tests that fail because of this problem.
#
# ctests.CheckNSInvoke checks if NSInvocation has this problem, it does so
# in pure Objective-C code and will therefore not mask problems with the
# bridge.
#
try:
    ctests.CheckNSInvoke()
    nsinvoke_ok = 1
except AssertionError:
    nsinvoke_ok = 0

NSArray = objc.lookUpClass('NSArray')

# First make sure that the pass-by-reference methods have the correct signature
setSignature = objc.setSignatureForSelector

# FIXME
import sys

# Note: @encode(unsigned char*) gives the wrong result at least upto 9A337a,
# hence the 'type=' annotations in several lines
for method, argmeta in [
            ( "BOOLInArg:", { 2: dict(type_modifier='n') }),
            ( "BOOLInOutArg:", { 2: dict(type_modifier='N') }),
            ( "BOOLOutArg:", { 2: dict(type_modifier='o') }),
            ( "NSPointInArg:", { 2: dict(type_modifier='n') }),
            ( "NSPointInOutArg:", { 2: dict(type_modifier='N') }),
            ( "NSPointOutArg:", { 2: dict(type_modifier='o') }),
            ( "NSRectInArg:", { 2: dict(type_modifier='n') }),
            ( "NSRectInOutArg:", { 2: dict(type_modifier='N') }),
            ( "NSRectOutArg:", { 2: dict(type_modifier='o') }),
            ( "boolInArg:", { 2: dict(type_modifier='n') }),
            ( "boolInOutArg:", { 2: dict(type_modifier='N') }),
            ( "boolOutArg:", { 2: dict(type_modifier='o') }),
            ( "charInArg:", { 2: dict(type_modifier='n') }),
            ( "charInOutArg:", { 2: dict(type_modifier='N') }),
            ( "charOutArg:", { 2: dict(type_modifier='o') }),
            ( "charPtrInArg:", { 2: dict(type_modifier='n') }),
            ( "charPtrInOutArg:", { 2: dict(type_modifier='N') }),
            ( "charPtrOutArg:", { 2: dict(type_modifier='o') }),
            ( "doubleInArg:", { 2: dict(type_modifier='n') }),
            ( "doubleInOutArg:", { 2: dict(type_modifier='N') }),
            ( "doubleOutArg:", { 2: dict(type_modifier='o') }),
            ( "floatInArg:", { 2: dict(type_modifier='n') }),
            ( "floatInOutArg:", { 2: dict(type_modifier='N') }),
            ( "floatOutArg:", { 2: dict(type_modifier='o') }),
            ( "idInArg:", { 2: dict(type_modifier='n') }),
            ( "idInOutArg:", { 2: dict(type_modifier='N') }),
            ( "idOutArg:", { 2: dict(type_modifier='o') }),
            ( "signedintInArg:", { 2: dict(type_modifier='n') }),
            ( "signedintInOutArg:", { 2: dict(type_modifier='N') }),
            ( "signedintOutArg:", { 2: dict(type_modifier='o') }),
            ( "signedlongInArg:", { 2: dict(type_modifier='n') }),
            ( "signedlongInOutArg:", { 2: dict(type_modifier='N') }),
            ( "signedlongOutArg:", { 2: dict(type_modifier='o') }),
            ( "signedlonglongInArg:", { 2: dict(type_modifier='n') }),
            ( "signedlonglongInOutArg:", { 2: dict(type_modifier='N') }),
            ( "signedlonglongOutArg:", { 2: dict(type_modifier='o') }),
            ( "signedshortInArg:", { 2: dict(type_modifier='n') }),
            ( "signedshortInOutArg:", { 2: dict(type_modifier='N') }),
            ( "signedshortOutArg:", { 2: dict(type_modifier='o') }),
            ( "structTestStruct1InArg:", { 2: dict(type_modifier='n') }),
            ( "structTestStruct1InOutArg:", { 2: dict(type_modifier='N') }),
            ( "structTestStruct1OutArg:", { 2: dict(type_modifier='o') }),
            ( "structTestStruct2InArg:", { 2: dict(type_modifier='n') }),
            ( "structTestStruct2InOutArg:", { 2: dict(type_modifier='N') }),
            ( "structTestStruct2OutArg:", { 2: dict(type_modifier='o') }),
            ( "structTestStruct3InArg:", { 2: dict(type_modifier='n') }),
            ( "structTestStruct3InOutArg:", { 2: dict(type_modifier='N') }),
            ( "structTestStruct3OutArg:", { 2: dict(type_modifier='o') }),
            ( "structTestStruct4InArg:", { 2: dict(type_modifier='n') }),
            ( "structTestStruct4InOutArg:", { 2: dict(type_modifier='N') }),
            ( "structTestStruct4OutArg:", { 2: dict(type_modifier='o') }),
            ( "structTestStruct5InArg:", { 2: dict(type_modifier='n') }),
            ( "structTestStruct5InOutArg:", { 2: dict(type_modifier='N') }),
            ( "structTestStruct5OutArg:", { 2: dict(type_modifier='o') }),
            ( "unsignedcharInArg:", { 2: dict(type_modifier='n', type='^C') }),
            ( "unsignedcharInOutArg:", { 2: dict(type_modifier='N', type='^C') }),
            ( "unsignedcharOutArg:", { 2: dict(type_modifier='o', type='^C') }),
            ( "unsignedintInArg:", { 2: dict(type_modifier='n') }),
            ( "unsignedintInOutArg:", { 2: dict(type_modifier='N') }),
            ( "unsignedintOutArg:", { 2: dict(type_modifier='o') }),
            ( "unsignedlongInArg:", { 2: dict(type_modifier='n') }),
            ( "unsignedlongInOutArg:", { 2: dict(type_modifier='N') }),
            ( "unsignedlongOutArg:", { 2: dict(type_modifier='o') }),
            ( "unsignedlonglongInArg:", { 2: dict(type_modifier='n') }),
            ( "unsignedlonglongInOutArg:", { 2: dict(type_modifier='N') }),
            ( "unsignedlonglongOutArg:", { 2: dict(type_modifier='o') }),
            ( "unsignedshortInArg:", { 2: dict(type_modifier='n') }),
            ( "unsignedshortInOutArg:", { 2: dict(type_modifier='N') }),
            ( "unsignedshortOutArg:", { 2: dict(type_modifier='o') }),
    ]:

    objc.registerMetaDataForSelector("PyObjC_TestClass1", method,
                                dict(arguments=argmeta))


for method, argmeta in [
        ( "callBOOLInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callBOOLInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callBOOLOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callNSPointInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callNSPointInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callNSPointOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callNSRectInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callNSRectInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callNSRectOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callboolInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callboolInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callboolOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callcharInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callcharInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callcharOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callcharPtrInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callcharPtrInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callcharPtrOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "calldoubleInArg:of:", { 2: dict(type_modifier='n') }),
        ( "calldoubleInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "calldoubleOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callfloatInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callfloatInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callfloatOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callidInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callidInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callidOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callsignedintInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callsignedintInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callsignedintOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callsignedlongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callsignedlongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callsignedlongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callsignedlonglongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callsignedlonglongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callsignedlonglongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callsignedshortInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callsignedshortInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callsignedshortOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callstructTestStruct1InArg:of:", { 2: dict(type_modifier='n') }),
        ( "callstructTestStruct1InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callstructTestStruct1OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callstructTestStruct2InArg:of:", { 2: dict(type_modifier='n') }),
        ( "callstructTestStruct2InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callstructTestStruct2OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callstructTestStruct3InArg:of:", { 2: dict(type_modifier='n') }),
        ( "callstructTestStruct3InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callstructTestStruct3OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callstructTestStruct4InArg:of:", { 2: dict(type_modifier='n') }),
        ( "callstructTestStruct4InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callstructTestStruct4OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callstructTestStruct5InArg:of:", { 2: dict(type_modifier='n') }),
        ( "callstructTestStruct5InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callstructTestStruct5OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callunsignedcharInArg:of:", { 2: dict(type_modifier='n', type='^C') }),
        ( "callunsignedcharInOutArg:of:", { 2: dict(type_modifier='N', type='^C') }),
        ( "callunsignedcharOutArg:of:", { 2: dict(type_modifier='o', type='^C') }),
        ( "callunsignedintInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callunsignedintInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callunsignedintOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callunsignedlongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callunsignedlongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callunsignedlongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callunsignedlonglongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callunsignedlonglongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callunsignedlonglongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "callunsignedshortInArg:of:", { 2: dict(type_modifier='n') }),
        ( "callunsignedshortInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "callunsignedshortOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeBOOLInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeBOOLInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeBOOLOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeNSPointInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeNSPointInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeNSPointOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeNSRectInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeNSRectInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeNSRectOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeboolInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeboolInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeboolOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokecharInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokecharInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokecharOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokecharPtrInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokecharPtrInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokecharPtrOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokedoubleInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokedoubleInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokedoubleOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokefloatInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokefloatInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokefloatOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeidInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeidInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeidOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokesignedintInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokesignedintInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokesignedintOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokesignedlongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokesignedlongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokesignedlongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokesignedlonglongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokesignedlonglongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokesignedlonglongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokesignedshortInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokesignedshortInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokesignedshortOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokestructTestStruct1InArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokestructTestStruct1InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokestructTestStruct1OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokestructTestStruct2InArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokestructTestStruct2InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokestructTestStruct2OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokestructTestStruct3InArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokestructTestStruct3InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokestructTestStruct3OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokestructTestStruct4InArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokestructTestStruct4InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokestructTestStruct4OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokestructTestStruct5InArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokestructTestStruct5InOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokestructTestStruct5OutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeunsignedcharInArg:of:", { 2: dict(type_modifier='n', type='^C') }),
        ( "invokeunsignedcharInOutArg:of:", { 2: dict(type_modifier='N', type='^C') }),
        ( "invokeunsignedcharOutArg:of:", { 2: dict(type_modifier='o', type='^C') }),
        ( "invokeunsignedintInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeunsignedintInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeunsignedintOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeunsignedlongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeunsignedlongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeunsignedlongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeunsignedlonglongInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeunsignedlonglongInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeunsignedlonglongOutArg:of:", { 2: dict(type_modifier='o') }),
        ( "invokeunsignedshortInArg:of:", { 2: dict(type_modifier='n') }),
        ( "invokeunsignedshortInOutArg:of:", { 2: dict(type_modifier='N') }),
        ( "invokeunsignedshortOutArg:of:", { 2: dict(type_modifier='o') }),
    ]:

    objc.registerMetaDataForSelector("PyObjC_TestClass2", method,
                                dict(arguments=argmeta))


from PyObjCTest.testbndl2 import *

class PyToObjC (TestCase):
	# Test calling Objective-C from Python
	# Simple returns from class methods

	def testClsboolResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.boolClsMethod(), YES)
		self.assertEquals(PyObjC_TestClass1.boolClsMethod(), NO)


	def testClsBOOLResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.BOOLClsMethod(), YES)
		self.assertEquals(PyObjC_TestClass1.BOOLClsMethod(), NO)


	def testClscharResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.charClsMethod(), -128)
		self.assertEquals(PyObjC_TestClass1.charClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.charClsMethod(), 127)


	def testClssignedshortResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.signedshortClsMethod(), -(1<<14))
		self.assertEquals(PyObjC_TestClass1.signedshortClsMethod(), -42)
		self.assertEquals(PyObjC_TestClass1.signedshortClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.signedshortClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.signedshortClsMethod(), 1 << 14)


	def testClssignedintResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.signedintClsMethod(), -(1<<30))
		self.assertEquals(PyObjC_TestClass1.signedintClsMethod(), -42)
		self.assertEquals(PyObjC_TestClass1.signedintClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.signedintClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.signedintClsMethod(), 1 << 30)


	def testClssignedlongResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.signedlongClsMethod(), -(1<<30))
		self.assertEquals(PyObjC_TestClass1.signedlongClsMethod(), -42)
		self.assertEquals(PyObjC_TestClass1.signedlongClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.signedlongClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.signedlongClsMethod(), 1 << 30)


	def testClssignedlonglongResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.signedlonglongClsMethod(), -(1L << 60))
		self.assertEquals(PyObjC_TestClass1.signedlonglongClsMethod(), -42)
		self.assertEquals(PyObjC_TestClass1.signedlonglongClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.signedlonglongClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.signedlonglongClsMethod(), 1L << 60)


	def testClsunsignedcharResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.unsignedcharClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.unsignedcharClsMethod(), 128)
		self.assertEquals(PyObjC_TestClass1.unsignedcharClsMethod(), 255)


	def testClsunsignedshortResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.unsignedshortClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.unsignedshortClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.unsignedshortClsMethod(), 1<<14)


	def testClsunsignedintResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.unsignedintClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.unsignedintClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.unsignedintClsMethod(), 1 << 30)


	def testClsunsignedlongResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.unsignedlongClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.unsignedlongClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.unsignedlongClsMethod(), 1L << 30)


	def testClsunsignedlonglongResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.unsignedlonglongClsMethod(), 0)
		self.assertEquals(PyObjC_TestClass1.unsignedlonglongClsMethod(), 42)
		self.assertEquals(PyObjC_TestClass1.unsignedlonglongClsMethod(), 1L << 62)


	def testClsfloatResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertAlmostEquals(PyObjC_TestClass1.floatClsMethod(), 0.128)
		self.assertAlmostEquals(PyObjC_TestClass1.floatClsMethod(), 1.0)
		self.assertAlmostEquals(PyObjC_TestClass1.floatClsMethod(), 42.0)
		self.assertAlmostEquals(PyObjC_TestClass1.floatClsMethod(), 1e10)


	def testClsdoubleResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertAlmostEquals(PyObjC_TestClass1.doubleClsMethod(), 0.128)
		self.assertAlmostEquals(PyObjC_TestClass1.doubleClsMethod(), 1.0)
		self.assertAlmostEquals(PyObjC_TestClass1.doubleClsMethod(), 42.0)
		self.assertAlmostEquals(PyObjC_TestClass1.doubleClsMethod(), 1e10)


	def testClsidResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.idClsMethod(), NSPriorDayDesignations)


	def testClscharPtrResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.charPtrClsMethod(), "hello")
		self.assertEquals(PyObjC_TestClass1.charPtrClsMethod(), "world")
		self.assertEquals(PyObjC_TestClass1.charPtrClsMethod(), "foobar")


	def testClsNSPointResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.NSPointClsMethod(), (1, 2))
		self.assertEquals(PyObjC_TestClass1.NSPointClsMethod(), (3, 4))


	def testClsNSRectResult(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.NSRectClsMethod(), ((1, 2), (3, 4)))
		self.assertEquals(PyObjC_TestClass1.NSRectClsMethod(), ((7, 8), (9, 10)))


	def testClsstructTestStruct1Result(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.structTestStruct1ClsMethod(), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(PyObjC_TestClass1.structTestStruct1ClsMethod(), (9, 8, (-1, -2, -3, -4, -5)))


	def testClsstructTestStruct2Result(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.structTestStruct2ClsMethod(), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(PyObjC_TestClass1.structTestStruct2ClsMethod(), (9, 8, (-1, -2, -3, -4, -5)))


	def testClsstructTestStruct3Result(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.structTestStruct3ClsMethod(), (1, 2))
		self.assertEquals(PyObjC_TestClass1.structTestStruct3ClsMethod(), (2, 4))


	def testClsstructTestStruct4Result(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.structTestStruct4ClsMethod(), (1, 1L<<60))
		self.assertEquals(PyObjC_TestClass1.structTestStruct4ClsMethod(), (2, 4))


	def testClsstructTestStruct5Result(self):
		PyObjC_TestClass1.clsReset()
		self.assertEquals(PyObjC_TestClass1.structTestStruct5ClsMethod(), (1, 2.5))
		self.assertEquals(PyObjC_TestClass1.structTestStruct5ClsMethod(), (2, 4.5))


	# Simple returns from instance methods

	def testboolResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.boolMethod(), YES)
		self.assertEquals(o.boolMethod(), NO)


	def testBOOLResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.BOOLMethod(), YES)
		self.assertEquals(o.BOOLMethod(), NO)


	def testcharResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.charMethod(), -128)
		self.assertEquals(o.charMethod(), 0)
		self.assertEquals(o.charMethod(), 127)


	def testsignedshortResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.signedshortMethod(), -(1<<14))
		self.assertEquals(o.signedshortMethod(), -42)
		self.assertEquals(o.signedshortMethod(), 0)
		self.assertEquals(o.signedshortMethod(), 42)
		self.assertEquals(o.signedshortMethod(), 1 << 14)


	def testsignedintResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.signedintMethod(), -(1<<30))
		self.assertEquals(o.signedintMethod(), -42)
		self.assertEquals(o.signedintMethod(), 0)
		self.assertEquals(o.signedintMethod(), 42)
		self.assertEquals(o.signedintMethod(), 1 << 30)


	def testsignedlongResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.signedlongMethod(), -(1<<30))
		self.assertEquals(o.signedlongMethod(), -42)
		self.assertEquals(o.signedlongMethod(), 0)
		self.assertEquals(o.signedlongMethod(), 42)
		self.assertEquals(o.signedlongMethod(), 1 << 30)


	def testsignedlonglongResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.signedlonglongMethod(), -(1L << 60))
		self.assertEquals(o.signedlonglongMethod(), -42)
		self.assertEquals(o.signedlonglongMethod(), 0)
		self.assertEquals(o.signedlonglongMethod(), 42)
		self.assertEquals(o.signedlonglongMethod(), 1L << 60)


	def testunsignedcharResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.unsignedcharMethod(), 0)
		self.assertEquals(o.unsignedcharMethod(), 128)
		self.assertEquals(o.unsignedcharMethod(), 255)


	def testunsignedshortResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.unsignedshortMethod(), 0)
		self.assertEquals(o.unsignedshortMethod(), 42)
		self.assertEquals(o.unsignedshortMethod(), 1<<14)


	def testunsignedintResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.unsignedintMethod(), 0)
		self.assertEquals(o.unsignedintMethod(), 42)
		self.assertEquals(o.unsignedintMethod(), 1 << 30)


	def testunsignedlongResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.unsignedlongMethod(), 0)
		self.assertEquals(o.unsignedlongMethod(), 42)
		self.assertEquals(o.unsignedlongMethod(), 1L << 30)


	def testunsignedlonglongResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.unsignedlonglongMethod(), 0)
		self.assertEquals(o.unsignedlonglongMethod(), 42)
		self.assertEquals(o.unsignedlonglongMethod(), 1L << 62)


	def testfloatResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertAlmostEquals(o.floatMethod(), 0.128)
		self.assertAlmostEquals(o.floatMethod(), 1.0)
		self.assertAlmostEquals(o.floatMethod(), 42.0)
		self.assertAlmostEquals(o.floatMethod(), 1e10)


	def testdoubleResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertAlmostEquals(o.doubleMethod(), 0.128)
		self.assertAlmostEquals(o.doubleMethod(), 1.0)
		self.assertAlmostEquals(o.doubleMethod(), 42.0)
		self.assertAlmostEquals(o.doubleMethod(), 1e10)


	def testidResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.idMethod(), NSPriorDayDesignations)


	def testcharPtrResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.charPtrMethod(), "hello")
		self.assertEquals(o.charPtrMethod(), "world")
		self.assertEquals(o.charPtrMethod(), "foobar")


	def testNSPointResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.NSPointMethod(), (1, 2))
		self.assertEquals(o.NSPointMethod(), (3, 4))


	def testNSRectResult(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.NSRectMethod(), ((1, 2), (3, 4)))
		self.assertEquals(o.NSRectMethod(), ((7, 8), (9, 10)))


	def teststructTestStruct1Result(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.structTestStruct1Method(), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(o.structTestStruct1Method(), (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct2Result(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.structTestStruct2Method(), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(o.structTestStruct2Method(), (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct3Result(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.structTestStruct3Method(), (1, 2))
		self.assertEquals(o.structTestStruct3Method(), (2, 4))


	def teststructTestStruct4Result(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.structTestStruct4Method(), (1, 1L<<60))
		self.assertEquals(o.structTestStruct4Method(), (2, 4))


	def teststructTestStruct5Result(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(o.structTestStruct5Method(), (1, 2.5))
		self.assertEquals(o.structTestStruct5Method(), (2, 4.5))


	# One argument

	def testboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_(YES)
		self.assertEquals(r, YES)
		r = o.boolArg_(NO)
		self.assertEquals(r, NO)


	def testBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_(YES)
		self.assertEquals(r, YES)
		r = o.BOOLArg_(NO)
		self.assertEquals(r, NO)


	def testcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_(-128)
		self.assertEquals(r, -128)
		r = o.charArg_(0)
		self.assertEquals(r, 0)
		r = o.charArg_(127)
		self.assertEquals(r, 127)


	def testsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_(-(1<<14))
		self.assertEquals(r, -(1<<14))
		r = o.signedshortArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedshortArg_(0)
		self.assertEquals(r, 0)
		r = o.signedshortArg_(42)
		self.assertEquals(r, 42)
		r = o.signedshortArg_(1 << 14)
		self.assertEquals(r, 1 << 14)


	def testsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_(-(1<<30))
		self.assertEquals(r, -(1<<30))
		r = o.signedintArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedintArg_(0)
		self.assertEquals(r, 0)
		r = o.signedintArg_(42)
		self.assertEquals(r, 42)
		r = o.signedintArg_(1 << 30)
		self.assertEquals(r, 1 << 30)


	def testsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_(-(1<<30))
		self.assertEquals(r, -(1<<30))
		r = o.signedlongArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedlongArg_(0)
		self.assertEquals(r, 0)
		r = o.signedlongArg_(42)
		self.assertEquals(r, 42)
		r = o.signedlongArg_(1 << 30)
		self.assertEquals(r, 1 << 30)


	def testsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_(-(1L << 60))
		self.assertEquals(r, -(1L << 60))
		r = o.signedlonglongArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedlonglongArg_(0)
		self.assertEquals(r, 0)
		r = o.signedlonglongArg_(42)
		self.assertEquals(r, 42)
		r = o.signedlonglongArg_(1L << 60)
		self.assertEquals(r, 1L << 60)


	def testunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedcharArg_(128)
		self.assertEquals(r, 128)
		r = o.unsignedcharArg_(255)
		self.assertEquals(r, 255)


	def testunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedshortArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedshortArg_(1<<14)
		self.assertEquals(r, 1<<14)


	def testunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedintArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedintArg_(1 << 30)
		self.assertEquals(r, 1 << 30)


	def testunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedlongArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedlongArg_(1L << 30)
		self.assertEquals(r, 1L << 30)


	def testunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedlonglongArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedlonglongArg_(1L << 62)
		self.assertEquals(r, 1L << 62)


	def testfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_(0.128)
		self.assertAlmostEquals(r, 0.128)
		r = o.floatArg_(1.0)
		self.assertAlmostEquals(r, 1.0)
		r = o.floatArg_(42.0)
		self.assertAlmostEquals(r, 42.0)
		r = o.floatArg_(1e10)
		self.assertAlmostEquals(r, 1e10)


	def testdoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_(0.128)
		self.assertAlmostEquals(r, 0.128)
		r = o.doubleArg_(1.0)
		self.assertAlmostEquals(r, 1.0)
		r = o.doubleArg_(42.0)
		self.assertAlmostEquals(r, 42.0)
		r = o.doubleArg_(1e10)
		self.assertAlmostEquals(r, 1e10)


	def testidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_(NSPriorDayDesignations)
		self.assertEquals(r, NSPriorDayDesignations)


	def testcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_("hello")
		self.assertEquals(r, "hello")
		r = o.charPtrArg_("world")
		self.assertEquals(r, "world")
		r = o.charPtrArg_("foobar")
		self.assertEquals(r, "foobar")


	def testNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_((1, 2))
		self.assertEquals(r, (1, 2))
		r = o.NSPointArg_((3, 4))
		self.assertEquals(r, (3, 4))


	def testNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_(((1, 2), (3, 4)))
		self.assertEquals(r, ((1, 2), (3, 4)))
		r = o.NSRectArg_(((7, 8), (9, 10)))
		self.assertEquals(r, ((7, 8), (9, 10)))


	def teststructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_((1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1Arg_((9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_((1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2Arg_((9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_((1, 2))
		self.assertEquals(r, (1, 2))
		r = o.structTestStruct3Arg_((2, 4))
		self.assertEquals(r, (2, 4))


	def teststructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_((1, 1L<<60))
		self.assertEquals(r, (1, 1L<<60))
		r = o.structTestStruct4Arg_((2, 4))
		self.assertEquals(r, (2, 4))


	def teststructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_((1, 2.5))
		self.assertEquals(r, (1, 2.5))
		r = o.structTestStruct5Arg_((2, 4.5))
		self.assertEquals(r, (2, 4.5))


	# Two arguments

	def testboolAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andboolArg_(YES, YES)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], YES)
		r = o.boolArg_andboolArg_(YES, NO)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)
		r = o.boolArg_andboolArg_(NO, YES)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = o.boolArg_andboolArg_(NO, NO)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NO)


	def testboolAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andBOOLArg_(YES, YES)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], YES)
		r = o.boolArg_andBOOLArg_(YES, NO)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)
		r = o.boolArg_andBOOLArg_(NO, YES)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = o.boolArg_andBOOLArg_(NO, NO)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NO)


	def testboolAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andcharArg_(YES, -128)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -128)
		r = o.boolArg_andcharArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andcharArg_(YES, 127)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 127)
		r = o.boolArg_andcharArg_(NO, -128)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -128)
		r = o.boolArg_andcharArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andcharArg_(NO, 127)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 127)


	def testboolAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andsignedshortArg_(YES, -(1<<14))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<14))
		r = o.boolArg_andsignedshortArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedshortArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedshortArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedshortArg_(YES, 1 << 14)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 14)
		r = o.boolArg_andsignedshortArg_(NO, -(1<<14))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<14))
		r = o.boolArg_andsignedshortArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedshortArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedshortArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedshortArg_(NO, 1 << 14)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 14)


	def testboolAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andsignedintArg_(YES, -(1<<30))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = o.boolArg_andsignedintArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedintArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedintArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedintArg_(YES, 1 << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = o.boolArg_andsignedintArg_(NO, -(1<<30))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = o.boolArg_andsignedintArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedintArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedintArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedintArg_(NO, 1 << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testboolAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andsignedlongArg_(YES, -(1<<30))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = o.boolArg_andsignedlongArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedlongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedlongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedlongArg_(YES, 1 << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = o.boolArg_andsignedlongArg_(NO, -(1<<30))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = o.boolArg_andsignedlongArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedlongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedlongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedlongArg_(NO, 1 << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testboolAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andsignedlonglongArg_(YES, -(1L << 60))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1L << 60))
		r = o.boolArg_andsignedlonglongArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedlonglongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedlonglongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedlonglongArg_(YES, 1L << 60)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 60)
		r = o.boolArg_andsignedlonglongArg_(NO, -(1L << 60))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1L << 60))
		r = o.boolArg_andsignedlonglongArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.boolArg_andsignedlonglongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andsignedlonglongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andsignedlonglongArg_(NO, 1L << 60)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 60)


	def testboolAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andunsignedcharArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedcharArg_(YES, 128)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 128)
		r = o.boolArg_andunsignedcharArg_(YES, 255)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 255)
		r = o.boolArg_andunsignedcharArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedcharArg_(NO, 128)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 128)
		r = o.boolArg_andunsignedcharArg_(NO, 255)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 255)


	def testboolAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andunsignedshortArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedshortArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedshortArg_(YES, 1<<14)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1<<14)
		r = o.boolArg_andunsignedshortArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedshortArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedshortArg_(NO, 1<<14)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1<<14)


	def testboolAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andunsignedintArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedintArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedintArg_(YES, 1 << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = o.boolArg_andunsignedintArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedintArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedintArg_(NO, 1 << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testboolAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andunsignedlongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedlongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedlongArg_(YES, 1L << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 30)
		r = o.boolArg_andunsignedlongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedlongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedlongArg_(NO, 1L << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 30)


	def testboolAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andunsignedlonglongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedlonglongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedlonglongArg_(YES, 1L << 62)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 62)
		r = o.boolArg_andunsignedlonglongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.boolArg_andunsignedlonglongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.boolArg_andunsignedlonglongArg_(NO, 1L << 62)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 62)


	def testboolAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andfloatArg_(YES, 0.128)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.boolArg_andfloatArg_(YES, 1.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.boolArg_andfloatArg_(YES, 42.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.boolArg_andfloatArg_(YES, 1e10)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.boolArg_andfloatArg_(NO, 0.128)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.boolArg_andfloatArg_(NO, 1.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.boolArg_andfloatArg_(NO, 42.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.boolArg_andfloatArg_(NO, 1e10)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testboolAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_anddoubleArg_(YES, 0.128)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.boolArg_anddoubleArg_(YES, 1.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.boolArg_anddoubleArg_(YES, 42.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.boolArg_anddoubleArg_(YES, 1e10)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.boolArg_anddoubleArg_(NO, 0.128)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.boolArg_anddoubleArg_(NO, 1.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.boolArg_anddoubleArg_(NO, 42.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.boolArg_anddoubleArg_(NO, 1e10)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testboolAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andidArg_(YES, NSPriorDayDesignations)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.boolArg_andidArg_(NO, NSPriorDayDesignations)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testboolAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andcharPtrArg_(YES, "hello")
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "hello")
		r = o.boolArg_andcharPtrArg_(YES, "world")
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "world")
		r = o.boolArg_andcharPtrArg_(YES, "foobar")
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "foobar")
		r = o.boolArg_andcharPtrArg_(NO, "hello")
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "hello")
		r = o.boolArg_andcharPtrArg_(NO, "world")
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "world")
		r = o.boolArg_andcharPtrArg_(NO, "foobar")
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "foobar")


	def testboolAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andNSPointArg_(YES, (1, 2))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = o.boolArg_andNSPointArg_(YES, (3, 4))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (3, 4))
		r = o.boolArg_andNSPointArg_(NO, (1, 2))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = o.boolArg_andNSPointArg_(NO, (3, 4))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (3, 4))


	def testboolAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andNSRectArg_(YES, ((1, 2), (3, 4)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.boolArg_andNSRectArg_(YES, ((7, 8), (9, 10)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.boolArg_andNSRectArg_(NO, ((1, 2), (3, 4)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.boolArg_andNSRectArg_(NO, ((7, 8), (9, 10)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testboolAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andstructTestStruct1Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.boolArg_andstructTestStruct1Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.boolArg_andstructTestStruct1Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.boolArg_andstructTestStruct1Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testboolAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andstructTestStruct2Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.boolArg_andstructTestStruct2Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.boolArg_andstructTestStruct2Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.boolArg_andstructTestStruct2Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testboolAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andstructTestStruct3Arg_(YES, (1, 2))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = o.boolArg_andstructTestStruct3Arg_(YES, (2, 4))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = o.boolArg_andstructTestStruct3Arg_(NO, (1, 2))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = o.boolArg_andstructTestStruct3Arg_(NO, (2, 4))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testboolAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andstructTestStruct4Arg_(YES, (1, 1L<<60))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.boolArg_andstructTestStruct4Arg_(YES, (2, 4))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = o.boolArg_andstructTestStruct4Arg_(NO, (1, 1L<<60))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.boolArg_andstructTestStruct4Arg_(NO, (2, 4))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testboolAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolArg_andstructTestStruct5Arg_(YES, (1, 2.5))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2.5))
		r = o.boolArg_andstructTestStruct5Arg_(YES, (2, 4.5))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4.5))
		r = o.boolArg_andstructTestStruct5Arg_(NO, (1, 2.5))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2.5))
		r = o.boolArg_andstructTestStruct5Arg_(NO, (2, 4.5))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4.5))


	def testBOOLAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andboolArg_(YES, YES)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], YES)
		r = o.BOOLArg_andboolArg_(YES, NO)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)
		r = o.BOOLArg_andboolArg_(NO, YES)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = o.BOOLArg_andboolArg_(NO, NO)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NO)


	def testBOOLAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andBOOLArg_(YES, YES)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], YES)
		r = o.BOOLArg_andBOOLArg_(YES, NO)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)
		r = o.BOOLArg_andBOOLArg_(NO, YES)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = o.BOOLArg_andBOOLArg_(NO, NO)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NO)


	def testBOOLAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andcharArg_(YES, -128)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -128)
		r = o.BOOLArg_andcharArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andcharArg_(YES, 127)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 127)
		r = o.BOOLArg_andcharArg_(NO, -128)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -128)
		r = o.BOOLArg_andcharArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andcharArg_(NO, 127)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 127)


	def testBOOLAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andsignedshortArg_(YES, -(1<<14))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<14))
		r = o.BOOLArg_andsignedshortArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedshortArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedshortArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedshortArg_(YES, 1 << 14)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 14)
		r = o.BOOLArg_andsignedshortArg_(NO, -(1<<14))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<14))
		r = o.BOOLArg_andsignedshortArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedshortArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedshortArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedshortArg_(NO, 1 << 14)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 14)


	def testBOOLAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andsignedintArg_(YES, -(1<<30))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = o.BOOLArg_andsignedintArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedintArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedintArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedintArg_(YES, 1 << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = o.BOOLArg_andsignedintArg_(NO, -(1<<30))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = o.BOOLArg_andsignedintArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedintArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedintArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedintArg_(NO, 1 << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testBOOLAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andsignedlongArg_(YES, -(1<<30))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = o.BOOLArg_andsignedlongArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedlongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedlongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedlongArg_(YES, 1 << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = o.BOOLArg_andsignedlongArg_(NO, -(1<<30))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = o.BOOLArg_andsignedlongArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedlongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedlongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedlongArg_(NO, 1 << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testBOOLAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andsignedlonglongArg_(YES, -(1L << 60))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1L << 60))
		r = o.BOOLArg_andsignedlonglongArg_(YES, -42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedlonglongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedlonglongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedlonglongArg_(YES, 1L << 60)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 60)
		r = o.BOOLArg_andsignedlonglongArg_(NO, -(1L << 60))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1L << 60))
		r = o.BOOLArg_andsignedlonglongArg_(NO, -42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = o.BOOLArg_andsignedlonglongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andsignedlonglongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andsignedlonglongArg_(NO, 1L << 60)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 60)


	def testBOOLAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andunsignedcharArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedcharArg_(YES, 128)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 128)
		r = o.BOOLArg_andunsignedcharArg_(YES, 255)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 255)
		r = o.BOOLArg_andunsignedcharArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedcharArg_(NO, 128)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 128)
		r = o.BOOLArg_andunsignedcharArg_(NO, 255)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 255)


	def testBOOLAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andunsignedshortArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedshortArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedshortArg_(YES, 1<<14)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1<<14)
		r = o.BOOLArg_andunsignedshortArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedshortArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedshortArg_(NO, 1<<14)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1<<14)


	def testBOOLAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andunsignedintArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedintArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedintArg_(YES, 1 << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = o.BOOLArg_andunsignedintArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedintArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedintArg_(NO, 1 << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testBOOLAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andunsignedlongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedlongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedlongArg_(YES, 1L << 30)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 30)
		r = o.BOOLArg_andunsignedlongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedlongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedlongArg_(NO, 1L << 30)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 30)


	def testBOOLAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andunsignedlonglongArg_(YES, 0)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedlonglongArg_(YES, 42)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedlonglongArg_(YES, 1L << 62)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 62)
		r = o.BOOLArg_andunsignedlonglongArg_(NO, 0)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = o.BOOLArg_andunsignedlonglongArg_(NO, 42)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = o.BOOLArg_andunsignedlonglongArg_(NO, 1L << 62)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 62)


	def testBOOLAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andfloatArg_(YES, 0.128)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.BOOLArg_andfloatArg_(YES, 1.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.BOOLArg_andfloatArg_(YES, 42.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.BOOLArg_andfloatArg_(YES, 1e10)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.BOOLArg_andfloatArg_(NO, 0.128)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.BOOLArg_andfloatArg_(NO, 1.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.BOOLArg_andfloatArg_(NO, 42.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.BOOLArg_andfloatArg_(NO, 1e10)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testBOOLAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_anddoubleArg_(YES, 0.128)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.BOOLArg_anddoubleArg_(YES, 1.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.BOOLArg_anddoubleArg_(YES, 42.0)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.BOOLArg_anddoubleArg_(YES, 1e10)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.BOOLArg_anddoubleArg_(NO, 0.128)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.BOOLArg_anddoubleArg_(NO, 1.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.BOOLArg_anddoubleArg_(NO, 42.0)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.BOOLArg_anddoubleArg_(NO, 1e10)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testBOOLAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andidArg_(YES, NSPriorDayDesignations)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.BOOLArg_andidArg_(NO, NSPriorDayDesignations)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testBOOLAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andcharPtrArg_(YES, "hello")
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "hello")
		r = o.BOOLArg_andcharPtrArg_(YES, "world")
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "world")
		r = o.BOOLArg_andcharPtrArg_(YES, "foobar")
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "foobar")
		r = o.BOOLArg_andcharPtrArg_(NO, "hello")
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "hello")
		r = o.BOOLArg_andcharPtrArg_(NO, "world")
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "world")
		r = o.BOOLArg_andcharPtrArg_(NO, "foobar")
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "foobar")


	def testBOOLAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andNSPointArg_(YES, (1, 2))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = o.BOOLArg_andNSPointArg_(YES, (3, 4))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (3, 4))
		r = o.BOOLArg_andNSPointArg_(NO, (1, 2))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = o.BOOLArg_andNSPointArg_(NO, (3, 4))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (3, 4))


	def testBOOLAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andNSRectArg_(YES, ((1, 2), (3, 4)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.BOOLArg_andNSRectArg_(YES, ((7, 8), (9, 10)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.BOOLArg_andNSRectArg_(NO, ((1, 2), (3, 4)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.BOOLArg_andNSRectArg_(NO, ((7, 8), (9, 10)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testBOOLAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andstructTestStruct1Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.BOOLArg_andstructTestStruct1Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.BOOLArg_andstructTestStruct1Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.BOOLArg_andstructTestStruct1Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testBOOLAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andstructTestStruct2Arg_(YES, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.BOOLArg_andstructTestStruct2Arg_(YES, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.BOOLArg_andstructTestStruct2Arg_(NO, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.BOOLArg_andstructTestStruct2Arg_(NO, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testBOOLAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andstructTestStruct3Arg_(YES, (1, 2))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = o.BOOLArg_andstructTestStruct3Arg_(YES, (2, 4))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = o.BOOLArg_andstructTestStruct3Arg_(NO, (1, 2))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = o.BOOLArg_andstructTestStruct3Arg_(NO, (2, 4))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testBOOLAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andstructTestStruct4Arg_(YES, (1, 1L<<60))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.BOOLArg_andstructTestStruct4Arg_(YES, (2, 4))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = o.BOOLArg_andstructTestStruct4Arg_(NO, (1, 1L<<60))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.BOOLArg_andstructTestStruct4Arg_(NO, (2, 4))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testBOOLAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLArg_andstructTestStruct5Arg_(YES, (1, 2.5))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2.5))
		r = o.BOOLArg_andstructTestStruct5Arg_(YES, (2, 4.5))
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4.5))
		r = o.BOOLArg_andstructTestStruct5Arg_(NO, (1, 2.5))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2.5))
		r = o.BOOLArg_andstructTestStruct5Arg_(NO, (2, 4.5))
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4.5))


	def testcharAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andboolArg_(-128, YES)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], YES)
		r = o.charArg_andboolArg_(-128, NO)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], NO)
		r = o.charArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.charArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.charArg_andboolArg_(127, YES)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], YES)
		r = o.charArg_andboolArg_(127, NO)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], NO)


	def testcharAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andBOOLArg_(-128, YES)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], YES)
		r = o.charArg_andBOOLArg_(-128, NO)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], NO)
		r = o.charArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.charArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.charArg_andBOOLArg_(127, YES)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], YES)
		r = o.charArg_andBOOLArg_(127, NO)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], NO)


	def testcharAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andcharArg_(-128, -128)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -128)
		r = o.charArg_andcharArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andcharArg_(-128, 127)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 127)
		r = o.charArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.charArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.charArg_andcharArg_(127, -128)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -128)
		r = o.charArg_andcharArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andcharArg_(127, 127)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 127)


	def testcharAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andsignedshortArg_(-128, -(1<<14))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<14))
		r = o.charArg_andsignedshortArg_(-128, -42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedshortArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedshortArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedshortArg_(-128, 1 << 14)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 14)
		r = o.charArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.charArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.charArg_andsignedshortArg_(127, -(1<<14))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<14))
		r = o.charArg_andsignedshortArg_(127, -42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedshortArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedshortArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedshortArg_(127, 1 << 14)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 14)


	def testcharAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andsignedintArg_(-128, -(1<<30))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<30))
		r = o.charArg_andsignedintArg_(-128, -42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedintArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedintArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedintArg_(-128, 1 << 30)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 30)
		r = o.charArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.charArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.charArg_andsignedintArg_(127, -(1<<30))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<30))
		r = o.charArg_andsignedintArg_(127, -42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedintArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedintArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedintArg_(127, 1 << 30)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 30)


	def testcharAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andsignedlongArg_(-128, -(1<<30))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<30))
		r = o.charArg_andsignedlongArg_(-128, -42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedlongArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedlongArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedlongArg_(-128, 1 << 30)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 30)
		r = o.charArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.charArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.charArg_andsignedlongArg_(127, -(1<<30))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<30))
		r = o.charArg_andsignedlongArg_(127, -42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedlongArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedlongArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedlongArg_(127, 1 << 30)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 30)


	def testcharAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andsignedlonglongArg_(-128, -(1L << 60))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1L << 60))
		r = o.charArg_andsignedlonglongArg_(-128, -42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedlonglongArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedlonglongArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedlonglongArg_(-128, 1L << 60)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1L << 60)
		r = o.charArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.charArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.charArg_andsignedlonglongArg_(127, -(1L << 60))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1L << 60))
		r = o.charArg_andsignedlonglongArg_(127, -42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = o.charArg_andsignedlonglongArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andsignedlonglongArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andsignedlonglongArg_(127, 1L << 60)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1L << 60)


	def testcharAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andunsignedcharArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedcharArg_(-128, 128)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 128)
		r = o.charArg_andunsignedcharArg_(-128, 255)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 255)
		r = o.charArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.charArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.charArg_andunsignedcharArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedcharArg_(127, 128)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 128)
		r = o.charArg_andunsignedcharArg_(127, 255)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 255)


	def testcharAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andunsignedshortArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedshortArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedshortArg_(-128, 1<<14)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1<<14)
		r = o.charArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.charArg_andunsignedshortArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedshortArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedshortArg_(127, 1<<14)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1<<14)


	def testcharAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andunsignedintArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedintArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedintArg_(-128, 1 << 30)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 30)
		r = o.charArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.charArg_andunsignedintArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedintArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedintArg_(127, 1 << 30)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 30)


	def testcharAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andunsignedlongArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedlongArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedlongArg_(-128, 1L << 30)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1L << 30)
		r = o.charArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.charArg_andunsignedlongArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedlongArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedlongArg_(127, 1L << 30)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1L << 30)


	def testcharAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andunsignedlonglongArg_(-128, 0)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedlonglongArg_(-128, 42)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedlonglongArg_(-128, 1L << 62)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1L << 62)
		r = o.charArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.charArg_andunsignedlonglongArg_(127, 0)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = o.charArg_andunsignedlonglongArg_(127, 42)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = o.charArg_andunsignedlonglongArg_(127, 1L << 62)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1L << 62)


	def testcharAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andfloatArg_(-128, 0.128)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charArg_andfloatArg_(-128, 1.0)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charArg_andfloatArg_(-128, 42.0)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charArg_andfloatArg_(-128, 1e10)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charArg_andfloatArg_(127, 0.128)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charArg_andfloatArg_(127, 1.0)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charArg_andfloatArg_(127, 42.0)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charArg_andfloatArg_(127, 1e10)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 1e10)


	def testcharAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_anddoubleArg_(-128, 0.128)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charArg_anddoubleArg_(-128, 1.0)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charArg_anddoubleArg_(-128, 42.0)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charArg_anddoubleArg_(-128, 1e10)
		self.assertEquals(r[0], -128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charArg_anddoubleArg_(127, 0.128)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charArg_anddoubleArg_(127, 1.0)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charArg_anddoubleArg_(127, 42.0)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charArg_anddoubleArg_(127, 1e10)
		self.assertEquals(r[0], 127)
		self.assertAlmostEquals(r[1], 1e10)


	def testcharAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andidArg_(-128, NSPriorDayDesignations)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.charArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.charArg_andidArg_(127, NSPriorDayDesignations)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testcharAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andcharPtrArg_(-128, "hello")
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], "hello")
		r = o.charArg_andcharPtrArg_(-128, "world")
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], "world")
		r = o.charArg_andcharPtrArg_(-128, "foobar")
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], "foobar")
		r = o.charArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.charArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.charArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.charArg_andcharPtrArg_(127, "hello")
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], "hello")
		r = o.charArg_andcharPtrArg_(127, "world")
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], "world")
		r = o.charArg_andcharPtrArg_(127, "foobar")
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], "foobar")


	def testcharAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andNSPointArg_(-128, (1, 2))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (1, 2))
		r = o.charArg_andNSPointArg_(-128, (3, 4))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (3, 4))
		r = o.charArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.charArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.charArg_andNSPointArg_(127, (1, 2))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (1, 2))
		r = o.charArg_andNSPointArg_(127, (3, 4))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (3, 4))


	def testcharAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andNSRectArg_(-128, ((1, 2), (3, 4)))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.charArg_andNSRectArg_(-128, ((7, 8), (9, 10)))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.charArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.charArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.charArg_andNSRectArg_(127, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.charArg_andNSRectArg_(127, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testcharAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andstructTestStruct1Arg_(-128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charArg_andstructTestStruct1Arg_(-128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charArg_andstructTestStruct1Arg_(127, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charArg_andstructTestStruct1Arg_(127, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testcharAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andstructTestStruct2Arg_(-128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charArg_andstructTestStruct2Arg_(-128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charArg_andstructTestStruct2Arg_(127, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charArg_andstructTestStruct2Arg_(127, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testcharAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andstructTestStruct3Arg_(-128, (1, 2))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (1, 2))
		r = o.charArg_andstructTestStruct3Arg_(-128, (2, 4))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (2, 4))
		r = o.charArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.charArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.charArg_andstructTestStruct3Arg_(127, (1, 2))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (1, 2))
		r = o.charArg_andstructTestStruct3Arg_(127, (2, 4))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (2, 4))


	def testcharAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andstructTestStruct4Arg_(-128, (1, 1L<<60))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.charArg_andstructTestStruct4Arg_(-128, (2, 4))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (2, 4))
		r = o.charArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.charArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.charArg_andstructTestStruct4Arg_(127, (1, 1L<<60))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.charArg_andstructTestStruct4Arg_(127, (2, 4))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (2, 4))


	def testcharAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charArg_andstructTestStruct5Arg_(-128, (1, 2.5))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (1, 2.5))
		r = o.charArg_andstructTestStruct5Arg_(-128, (2, 4.5))
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], (2, 4.5))
		r = o.charArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.charArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.charArg_andstructTestStruct5Arg_(127, (1, 2.5))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (1, 2.5))
		r = o.charArg_andstructTestStruct5Arg_(127, (2, 4.5))
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], (2, 4.5))


	def testsignedshortAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andboolArg_(-(1<<14), YES)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andboolArg_(-(1<<14), NO)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andboolArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andboolArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andboolArg_(1 << 14, YES)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andboolArg_(1 << 14, NO)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], NO)


	def testsignedshortAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andBOOLArg_(-(1<<14), YES)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andBOOLArg_(-(1<<14), NO)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andBOOLArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andBOOLArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedshortArg_andBOOLArg_(1 << 14, YES)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], YES)
		r = o.signedshortArg_andBOOLArg_(1 << 14, NO)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], NO)


	def testsignedshortAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andcharArg_(-(1<<14), -128)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -128)
		r = o.signedshortArg_andcharArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andcharArg_(-(1<<14), 127)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 127)
		r = o.signedshortArg_andcharArg_(-42, -128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -128)
		r = o.signedshortArg_andcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andcharArg_(-42, 127)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 127)
		r = o.signedshortArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.signedshortArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.signedshortArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.signedshortArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.signedshortArg_andcharArg_(1 << 14, -128)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -128)
		r = o.signedshortArg_andcharArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andcharArg_(1 << 14, 127)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 127)


	def testsignedshortAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andsignedshortArg_(-(1<<14), -(1<<14))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -(1<<14))
		r = o.signedshortArg_andsignedshortArg_(-(1<<14), -42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedshortArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedshortArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedshortArg_(-(1<<14), 1 << 14)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1 << 14)
		r = o.signedshortArg_andsignedshortArg_(-42, -(1<<14))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedshortArg_andsignedshortArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedshortArg_(-42, 1 << 14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedshortArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedshortArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedshortArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedshortArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedshortArg_andsignedshortArg_(1 << 14, -(1<<14))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedshortArg_andsignedshortArg_(1 << 14, -42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedshortArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedshortArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedshortArg_(1 << 14, 1 << 14)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1 << 14)


	def testsignedshortAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andsignedintArg_(-(1<<14), -(1<<30))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedintArg_(-(1<<14), -42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedintArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedintArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedintArg_(-(1<<14), 1 << 30)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedintArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedintArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedintArg_(1 << 14, -(1<<30))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedintArg_(1 << 14, -42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedintArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedintArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedintArg_(1 << 14, 1 << 30)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1 << 30)


	def testsignedshortAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andsignedlongArg_(-(1<<14), -(1<<30))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedlongArg_(-(1<<14), -42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlongArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlongArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlongArg_(-(1<<14), 1 << 30)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedlongArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedlongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlongArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andsignedlongArg_(1 << 14, -(1<<30))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedshortArg_andsignedlongArg_(1 << 14, -42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlongArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlongArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlongArg_(1 << 14, 1 << 30)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1 << 30)


	def testsignedshortAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andsignedlonglongArg_(-(1<<14), -(1L << 60))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedshortArg_andsignedlonglongArg_(-(1<<14), -42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlonglongArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlonglongArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlonglongArg_(-(1<<14), 1L << 60)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1L << 60)
		r = o.signedshortArg_andsignedlonglongArg_(-42, -(1L << 60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedshortArg_andsignedlonglongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlonglongArg_(-42, 1L << 60)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedshortArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedshortArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedshortArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedshortArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedshortArg_andsignedlonglongArg_(1 << 14, -(1L << 60))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedshortArg_andsignedlonglongArg_(1 << 14, -42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -42)
		r = o.signedshortArg_andsignedlonglongArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andsignedlonglongArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andsignedlonglongArg_(1 << 14, 1L << 60)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1L << 60)


	def testsignedshortAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andunsignedcharArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedcharArg_(-(1<<14), 128)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 128)
		r = o.signedshortArg_andunsignedcharArg_(-(1<<14), 255)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 255)
		r = o.signedshortArg_andunsignedcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedcharArg_(-42, 128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 128)
		r = o.signedshortArg_andunsignedcharArg_(-42, 255)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 255)
		r = o.signedshortArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.signedshortArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.signedshortArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.signedshortArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.signedshortArg_andunsignedcharArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedcharArg_(1 << 14, 128)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 128)
		r = o.signedshortArg_andunsignedcharArg_(1 << 14, 255)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 255)


	def testsignedshortAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andunsignedshortArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedshortArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedshortArg_(-(1<<14), 1<<14)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1<<14)
		r = o.signedshortArg_andunsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedshortArg_(-42, 1<<14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedshortArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.signedshortArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedshortArg_andunsignedshortArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedshortArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedshortArg_(1 << 14, 1<<14)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1<<14)


	def testsignedshortAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andunsignedintArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedintArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedintArg_(-(1<<14), 1 << 30)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andunsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedshortArg_andunsignedintArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedintArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedintArg_(1 << 14, 1 << 30)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1 << 30)


	def testsignedshortAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andunsignedlongArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlongArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlongArg_(-(1<<14), 1L << 30)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1L << 30)
		r = o.signedshortArg_andunsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlongArg_(-42, 1L << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedshortArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedshortArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedshortArg_andunsignedlongArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlongArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlongArg_(1 << 14, 1L << 30)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1L << 30)


	def testsignedshortAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andunsignedlonglongArg_(-(1<<14), 0)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlonglongArg_(-(1<<14), 42)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlonglongArg_(-(1<<14), 1L << 62)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1L << 62)
		r = o.signedshortArg_andunsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlonglongArg_(-42, 1L << 62)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedshortArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedshortArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedshortArg_andunsignedlonglongArg_(1 << 14, 0)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 0)
		r = o.signedshortArg_andunsignedlonglongArg_(1 << 14, 42)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 42)
		r = o.signedshortArg_andunsignedlonglongArg_(1 << 14, 1L << 62)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], 1L << 62)


	def testsignedshortAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andfloatArg_(-(1<<14), 0.128)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_andfloatArg_(-(1<<14), 1.0)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_andfloatArg_(-(1<<14), 42.0)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_andfloatArg_(-(1<<14), 1e10)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_andfloatArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_andfloatArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_andfloatArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_andfloatArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_andfloatArg_(1 << 14, 0.128)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_andfloatArg_(1 << 14, 1.0)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_andfloatArg_(1 << 14, 42.0)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_andfloatArg_(1 << 14, 1e10)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedshortAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_anddoubleArg_(-(1<<14), 0.128)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_anddoubleArg_(-(1<<14), 1.0)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_anddoubleArg_(-(1<<14), 42.0)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_anddoubleArg_(-(1<<14), 1e10)
		self.assertEquals(r[0], -(1<<14))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_anddoubleArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_anddoubleArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_anddoubleArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_anddoubleArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedshortArg_anddoubleArg_(1 << 14, 0.128)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedshortArg_anddoubleArg_(1 << 14, 1.0)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedshortArg_anddoubleArg_(1 << 14, 42.0)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedshortArg_anddoubleArg_(1 << 14, 1e10)
		self.assertEquals(r[0], 1 << 14)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedshortAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andidArg_(-(1<<14), NSPriorDayDesignations)
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedshortArg_andidArg_(-42, NSPriorDayDesignations)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedshortArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedshortArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedshortArg_andidArg_(1 << 14, NSPriorDayDesignations)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testsignedshortAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andcharPtrArg_(-(1<<14), "hello")
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], "hello")
		r = o.signedshortArg_andcharPtrArg_(-(1<<14), "world")
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], "world")
		r = o.signedshortArg_andcharPtrArg_(-(1<<14), "foobar")
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], "foobar")
		r = o.signedshortArg_andcharPtrArg_(-42, "hello")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "hello")
		r = o.signedshortArg_andcharPtrArg_(-42, "world")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "world")
		r = o.signedshortArg_andcharPtrArg_(-42, "foobar")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "foobar")
		r = o.signedshortArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.signedshortArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.signedshortArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.signedshortArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.signedshortArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.signedshortArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.signedshortArg_andcharPtrArg_(1 << 14, "hello")
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], "hello")
		r = o.signedshortArg_andcharPtrArg_(1 << 14, "world")
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], "world")
		r = o.signedshortArg_andcharPtrArg_(1 << 14, "foobar")
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], "foobar")


	def testsignedshortAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andNSPointArg_(-(1<<14), (1, 2))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andNSPointArg_(-(1<<14), (3, 4))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (3, 4))
		r = o.signedshortArg_andNSPointArg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andNSPointArg_(-42, (3, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedshortArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.signedshortArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedshortArg_andNSPointArg_(1 << 14, (1, 2))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andNSPointArg_(1 << 14, (3, 4))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (3, 4))


	def testsignedshortAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andNSRectArg_(-(1<<14), ((1, 2), (3, 4)))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedshortArg_andNSRectArg_(-(1<<14), ((7, 8), (9, 10)))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedshortArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedshortArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedshortArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedshortArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedshortArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedshortArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedshortArg_andNSRectArg_(1 << 14, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedshortArg_andNSRectArg_(1 << 14, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testsignedshortAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andstructTestStruct1Arg_(-(1<<14), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(-(1<<14), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(1 << 14, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct1Arg_(1 << 14, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedshortAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andstructTestStruct2Arg_(-(1<<14), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(-(1<<14), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(1 << 14, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedshortArg_andstructTestStruct2Arg_(1 << 14, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedshortAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andstructTestStruct3Arg_(-(1<<14), (1, 2))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andstructTestStruct3Arg_(-(1<<14), (2, 4))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct3Arg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andstructTestStruct3Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct3Arg_(1 << 14, (1, 2))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (1, 2))
		r = o.signedshortArg_andstructTestStruct3Arg_(1 << 14, (2, 4))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (2, 4))


	def testsignedshortAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andstructTestStruct4Arg_(-(1<<14), (1, 1L<<60))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedshortArg_andstructTestStruct4Arg_(-(1<<14), (2, 4))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct4Arg_(-42, (1, 1L<<60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedshortArg_andstructTestStruct4Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedshortArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedshortArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedshortArg_andstructTestStruct4Arg_(1 << 14, (1, 1L<<60))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedshortArg_andstructTestStruct4Arg_(1 << 14, (2, 4))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (2, 4))


	def testsignedshortAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortArg_andstructTestStruct5Arg_(-(1<<14), (1, 2.5))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(-(1<<14), (2, 4.5))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(-42, (1, 2.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(-42, (2, 4.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(1 << 14, (1, 2.5))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedshortArg_andstructTestStruct5Arg_(1 << 14, (2, 4.5))
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], (2, 4.5))


	def testsignedintAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andboolArg_(-(1<<30), YES)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andboolArg_(-(1<<30), NO)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andboolArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andboolArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andboolArg_(1 << 30, YES)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andboolArg_(1 << 30, NO)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NO)


	def testsignedintAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andBOOLArg_(-(1<<30), YES)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andBOOLArg_(-(1<<30), NO)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andBOOLArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andBOOLArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedintArg_andBOOLArg_(1 << 30, YES)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], YES)
		r = o.signedintArg_andBOOLArg_(1 << 30, NO)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NO)


	def testsignedintAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andcharArg_(-(1<<30), -128)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -128)
		r = o.signedintArg_andcharArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andcharArg_(-(1<<30), 127)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 127)
		r = o.signedintArg_andcharArg_(-42, -128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -128)
		r = o.signedintArg_andcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andcharArg_(-42, 127)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 127)
		r = o.signedintArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.signedintArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.signedintArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.signedintArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.signedintArg_andcharArg_(1 << 30, -128)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -128)
		r = o.signedintArg_andcharArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andcharArg_(1 << 30, 127)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 127)


	def testsignedintAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andsignedshortArg_(-(1<<30), -(1<<14))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1<<14))
		r = o.signedintArg_andsignedshortArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedshortArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedshortArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedshortArg_(-(1<<30), 1 << 14)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 14)
		r = o.signedintArg_andsignedshortArg_(-42, -(1<<14))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedintArg_andsignedshortArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedshortArg_(-42, 1 << 14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedintArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedintArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedintArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedintArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedintArg_andsignedshortArg_(1 << 30, -(1<<14))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedintArg_andsignedshortArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedshortArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedshortArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedshortArg_(1 << 30, 1 << 14)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 14)


	def testsignedintAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andsignedintArg_(-(1<<30), -(1<<30))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedintArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedintArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedintArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedintArg_(-(1<<30), 1 << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedintArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedintArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedintArg_(1 << 30, -(1<<30))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedintArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedintArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedintArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedintArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testsignedintAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andsignedlongArg_(-(1<<30), -(1<<30))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedlongArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlongArg_(-(1<<30), 1 << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedlongArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedlongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlongArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andsignedlongArg_(1 << 30, -(1<<30))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintArg_andsignedlongArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlongArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testsignedintAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andsignedlonglongArg_(-(1<<30), -(1L << 60))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedintArg_andsignedlonglongArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlonglongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlonglongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlonglongArg_(-(1<<30), 1L << 60)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1L << 60)
		r = o.signedintArg_andsignedlonglongArg_(-42, -(1L << 60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedintArg_andsignedlonglongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlonglongArg_(-42, 1L << 60)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedintArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedintArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedintArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedintArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedintArg_andsignedlonglongArg_(1 << 30, -(1L << 60))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedintArg_andsignedlonglongArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedintArg_andsignedlonglongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andsignedlonglongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andsignedlonglongArg_(1 << 30, 1L << 60)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 60)


	def testsignedintAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andunsignedcharArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedcharArg_(-(1<<30), 128)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 128)
		r = o.signedintArg_andunsignedcharArg_(-(1<<30), 255)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 255)
		r = o.signedintArg_andunsignedcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedcharArg_(-42, 128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 128)
		r = o.signedintArg_andunsignedcharArg_(-42, 255)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 255)
		r = o.signedintArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.signedintArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.signedintArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.signedintArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.signedintArg_andunsignedcharArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedcharArg_(1 << 30, 128)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 128)
		r = o.signedintArg_andunsignedcharArg_(1 << 30, 255)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 255)


	def testsignedintAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andunsignedshortArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedshortArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedshortArg_(-(1<<30), 1<<14)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1<<14)
		r = o.signedintArg_andunsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedshortArg_(-42, 1<<14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedintArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.signedintArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedintArg_andunsignedshortArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedshortArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedshortArg_(1 << 30, 1<<14)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1<<14)


	def testsignedintAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andunsignedintArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedintArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedintArg_(-(1<<30), 1 << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andunsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedintArg_andunsignedintArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedintArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedintArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testsignedintAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andunsignedlongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlongArg_(-(1<<30), 1L << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1L << 30)
		r = o.signedintArg_andunsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlongArg_(-42, 1L << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedintArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedintArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedintArg_andunsignedlongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlongArg_(1 << 30, 1L << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 30)


	def testsignedintAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andunsignedlonglongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlonglongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlonglongArg_(-(1<<30), 1L << 62)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1L << 62)
		r = o.signedintArg_andunsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlonglongArg_(-42, 1L << 62)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedintArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedintArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedintArg_andunsignedlonglongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedintArg_andunsignedlonglongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedintArg_andunsignedlonglongArg_(1 << 30, 1L << 62)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 62)


	def testsignedintAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andfloatArg_(-(1<<30), 0.128)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_andfloatArg_(-(1<<30), 1.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_andfloatArg_(-(1<<30), 42.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_andfloatArg_(-(1<<30), 1e10)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_andfloatArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_andfloatArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_andfloatArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_andfloatArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_andfloatArg_(1 << 30, 0.128)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_andfloatArg_(1 << 30, 1.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_andfloatArg_(1 << 30, 42.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_andfloatArg_(1 << 30, 1e10)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedintAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_anddoubleArg_(-(1<<30), 0.128)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_anddoubleArg_(-(1<<30), 1.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_anddoubleArg_(-(1<<30), 42.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_anddoubleArg_(-(1<<30), 1e10)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_anddoubleArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_anddoubleArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_anddoubleArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_anddoubleArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedintArg_anddoubleArg_(1 << 30, 0.128)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedintArg_anddoubleArg_(1 << 30, 1.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedintArg_anddoubleArg_(1 << 30, 42.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedintArg_anddoubleArg_(1 << 30, 1e10)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedintAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andidArg_(-(1<<30), NSPriorDayDesignations)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedintArg_andidArg_(-42, NSPriorDayDesignations)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedintArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedintArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedintArg_andidArg_(1 << 30, NSPriorDayDesignations)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testsignedintAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andcharPtrArg_(-(1<<30), "hello")
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], "hello")
		r = o.signedintArg_andcharPtrArg_(-(1<<30), "world")
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], "world")
		r = o.signedintArg_andcharPtrArg_(-(1<<30), "foobar")
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], "foobar")
		r = o.signedintArg_andcharPtrArg_(-42, "hello")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "hello")
		r = o.signedintArg_andcharPtrArg_(-42, "world")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "world")
		r = o.signedintArg_andcharPtrArg_(-42, "foobar")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "foobar")
		r = o.signedintArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.signedintArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.signedintArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.signedintArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.signedintArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.signedintArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.signedintArg_andcharPtrArg_(1 << 30, "hello")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "hello")
		r = o.signedintArg_andcharPtrArg_(1 << 30, "world")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "world")
		r = o.signedintArg_andcharPtrArg_(1 << 30, "foobar")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "foobar")


	def testsignedintAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andNSPointArg_(-(1<<30), (1, 2))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andNSPointArg_(-(1<<30), (3, 4))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (3, 4))
		r = o.signedintArg_andNSPointArg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andNSPointArg_(-42, (3, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedintArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.signedintArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedintArg_andNSPointArg_(1 << 30, (1, 2))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andNSPointArg_(1 << 30, (3, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (3, 4))


	def testsignedintAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andNSRectArg_(-(1<<30), ((1, 2), (3, 4)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedintArg_andNSRectArg_(-(1<<30), ((7, 8), (9, 10)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedintArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedintArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedintArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedintArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedintArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedintArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedintArg_andNSRectArg_(1 << 30, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedintArg_andNSRectArg_(1 << 30, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testsignedintAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andstructTestStruct1Arg_(-(1<<30), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct1Arg_(-(1<<30), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct1Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct1Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct1Arg_(1 << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedintAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andstructTestStruct2Arg_(-(1<<30), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct2Arg_(-(1<<30), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct2Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedintArg_andstructTestStruct2Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedintArg_andstructTestStruct2Arg_(1 << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedintAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andstructTestStruct3Arg_(-(1<<30), (1, 2))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andstructTestStruct3Arg_(-(1<<30), (2, 4))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct3Arg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andstructTestStruct3Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct3Arg_(1 << 30, (1, 2))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.signedintArg_andstructTestStruct3Arg_(1 << 30, (2, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4))


	def testsignedintAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andstructTestStruct4Arg_(-(1<<30), (1, 1L<<60))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedintArg_andstructTestStruct4Arg_(-(1<<30), (2, 4))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct4Arg_(-42, (1, 1L<<60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedintArg_andstructTestStruct4Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedintArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedintArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedintArg_andstructTestStruct4Arg_(1 << 30, (1, 1L<<60))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedintArg_andstructTestStruct4Arg_(1 << 30, (2, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4))


	def testsignedintAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintArg_andstructTestStruct5Arg_(-(1<<30), (1, 2.5))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedintArg_andstructTestStruct5Arg_(-(1<<30), (2, 4.5))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedintArg_andstructTestStruct5Arg_(-42, (1, 2.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedintArg_andstructTestStruct5Arg_(-42, (2, 4.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedintArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedintArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedintArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedintArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedintArg_andstructTestStruct5Arg_(1 << 30, (1, 2.5))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedintArg_andstructTestStruct5Arg_(1 << 30, (2, 4.5))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4.5))


	def testsignedlongAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andboolArg_(-(1<<30), YES)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andboolArg_(-(1<<30), NO)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andboolArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andboolArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andboolArg_(1 << 30, YES)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andboolArg_(1 << 30, NO)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NO)


	def testsignedlongAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andBOOLArg_(-(1<<30), YES)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andBOOLArg_(-(1<<30), NO)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andBOOLArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andBOOLArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedlongArg_andBOOLArg_(1 << 30, YES)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], YES)
		r = o.signedlongArg_andBOOLArg_(1 << 30, NO)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NO)


	def testsignedlongAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andcharArg_(-(1<<30), -128)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -128)
		r = o.signedlongArg_andcharArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andcharArg_(-(1<<30), 127)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 127)
		r = o.signedlongArg_andcharArg_(-42, -128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -128)
		r = o.signedlongArg_andcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andcharArg_(-42, 127)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 127)
		r = o.signedlongArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.signedlongArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.signedlongArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.signedlongArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.signedlongArg_andcharArg_(1 << 30, -128)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -128)
		r = o.signedlongArg_andcharArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andcharArg_(1 << 30, 127)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 127)


	def testsignedlongAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andsignedshortArg_(-(1<<30), -(1<<14))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlongArg_andsignedshortArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedshortArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedshortArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedshortArg_(-(1<<30), 1 << 14)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlongArg_andsignedshortArg_(-42, -(1<<14))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlongArg_andsignedshortArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedshortArg_(-42, 1 << 14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlongArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlongArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlongArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlongArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlongArg_andsignedshortArg_(1 << 30, -(1<<14))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlongArg_andsignedshortArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedshortArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedshortArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedshortArg_(1 << 30, 1 << 14)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 14)


	def testsignedlongAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andsignedintArg_(-(1<<30), -(1<<30))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedintArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedintArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedintArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedintArg_(-(1<<30), 1 << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedintArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedintArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedintArg_(1 << 30, -(1<<30))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedintArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedintArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedintArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedintArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testsignedlongAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andsignedlongArg_(-(1<<30), -(1<<30))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedlongArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlongArg_(-(1<<30), 1 << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedlongArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedlongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlongArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andsignedlongArg_(1 << 30, -(1<<30))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongArg_andsignedlongArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlongArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testsignedlongAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andsignedlonglongArg_(-(1<<30), -(1L << 60))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlongArg_andsignedlonglongArg_(-(1<<30), -42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlonglongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlonglongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlonglongArg_(-(1<<30), 1L << 60)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlongArg_andsignedlonglongArg_(-42, -(1L << 60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlongArg_andsignedlonglongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlonglongArg_(-42, 1L << 60)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlongArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlongArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlongArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlongArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlongArg_andsignedlonglongArg_(1 << 30, -(1L << 60))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlongArg_andsignedlonglongArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.signedlongArg_andsignedlonglongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andsignedlonglongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andsignedlonglongArg_(1 << 30, 1L << 60)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 60)


	def testsignedlongAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andunsignedcharArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedcharArg_(-(1<<30), 128)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 128)
		r = o.signedlongArg_andunsignedcharArg_(-(1<<30), 255)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 255)
		r = o.signedlongArg_andunsignedcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedcharArg_(-42, 128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 128)
		r = o.signedlongArg_andunsignedcharArg_(-42, 255)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 255)
		r = o.signedlongArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.signedlongArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.signedlongArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.signedlongArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.signedlongArg_andunsignedcharArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedcharArg_(1 << 30, 128)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 128)
		r = o.signedlongArg_andunsignedcharArg_(1 << 30, 255)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 255)


	def testsignedlongAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andunsignedshortArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedshortArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedshortArg_(-(1<<30), 1<<14)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1<<14)
		r = o.signedlongArg_andunsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedshortArg_(-42, 1<<14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedlongArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.signedlongArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedlongArg_andunsignedshortArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedshortArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedshortArg_(1 << 30, 1<<14)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1<<14)


	def testsignedlongAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andunsignedintArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedintArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedintArg_(-(1<<30), 1 << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andunsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlongArg_andunsignedintArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedintArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedintArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testsignedlongAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andunsignedlongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlongArg_(-(1<<30), 1L << 30)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlongArg_andunsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlongArg_(-42, 1L << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlongArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlongArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlongArg_andunsignedlongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlongArg_(1 << 30, 1L << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 30)


	def testsignedlongAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andunsignedlonglongArg_(-(1<<30), 0)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlonglongArg_(-(1<<30), 42)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlonglongArg_(-(1<<30), 1L << 62)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlongArg_andunsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlonglongArg_(-42, 1L << 62)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlongArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlongArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlongArg_andunsignedlonglongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.signedlongArg_andunsignedlonglongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.signedlongArg_andunsignedlonglongArg_(1 << 30, 1L << 62)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 62)


	def testsignedlongAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andfloatArg_(-(1<<30), 0.128)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_andfloatArg_(-(1<<30), 1.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_andfloatArg_(-(1<<30), 42.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_andfloatArg_(-(1<<30), 1e10)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_andfloatArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_andfloatArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_andfloatArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_andfloatArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_andfloatArg_(1 << 30, 0.128)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_andfloatArg_(1 << 30, 1.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_andfloatArg_(1 << 30, 42.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_andfloatArg_(1 << 30, 1e10)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedlongAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_anddoubleArg_(-(1<<30), 0.128)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_anddoubleArg_(-(1<<30), 1.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_anddoubleArg_(-(1<<30), 42.0)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_anddoubleArg_(-(1<<30), 1e10)
		self.assertEquals(r[0], -(1<<30))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_anddoubleArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_anddoubleArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_anddoubleArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_anddoubleArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlongArg_anddoubleArg_(1 << 30, 0.128)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlongArg_anddoubleArg_(1 << 30, 1.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlongArg_anddoubleArg_(1 << 30, 42.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlongArg_anddoubleArg_(1 << 30, 1e10)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedlongAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andidArg_(-(1<<30), NSPriorDayDesignations)
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlongArg_andidArg_(-42, NSPriorDayDesignations)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlongArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlongArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlongArg_andidArg_(1 << 30, NSPriorDayDesignations)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testsignedlongAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andcharPtrArg_(-(1<<30), "hello")
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], "hello")
		r = o.signedlongArg_andcharPtrArg_(-(1<<30), "world")
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], "world")
		r = o.signedlongArg_andcharPtrArg_(-(1<<30), "foobar")
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], "foobar")
		r = o.signedlongArg_andcharPtrArg_(-42, "hello")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "hello")
		r = o.signedlongArg_andcharPtrArg_(-42, "world")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "world")
		r = o.signedlongArg_andcharPtrArg_(-42, "foobar")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "foobar")
		r = o.signedlongArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.signedlongArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.signedlongArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.signedlongArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.signedlongArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.signedlongArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.signedlongArg_andcharPtrArg_(1 << 30, "hello")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "hello")
		r = o.signedlongArg_andcharPtrArg_(1 << 30, "world")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "world")
		r = o.signedlongArg_andcharPtrArg_(1 << 30, "foobar")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "foobar")


	def testsignedlongAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andNSPointArg_(-(1<<30), (1, 2))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andNSPointArg_(-(1<<30), (3, 4))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (3, 4))
		r = o.signedlongArg_andNSPointArg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andNSPointArg_(-42, (3, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedlongArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.signedlongArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedlongArg_andNSPointArg_(1 << 30, (1, 2))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andNSPointArg_(1 << 30, (3, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (3, 4))


	def testsignedlongAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andNSRectArg_(-(1<<30), ((1, 2), (3, 4)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlongArg_andNSRectArg_(-(1<<30), ((7, 8), (9, 10)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlongArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlongArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlongArg_andNSRectArg_(1 << 30, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlongArg_andNSRectArg_(1 << 30, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testsignedlongAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andstructTestStruct1Arg_(-(1<<30), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(-(1<<30), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct1Arg_(1 << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedlongAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andstructTestStruct2Arg_(-(1<<30), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(-(1<<30), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlongArg_andstructTestStruct2Arg_(1 << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedlongAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andstructTestStruct3Arg_(-(1<<30), (1, 2))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andstructTestStruct3Arg_(-(1<<30), (2, 4))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct3Arg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andstructTestStruct3Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct3Arg_(1 << 30, (1, 2))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlongArg_andstructTestStruct3Arg_(1 << 30, (2, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4))


	def testsignedlongAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andstructTestStruct4Arg_(-(1<<30), (1, 1L<<60))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlongArg_andstructTestStruct4Arg_(-(1<<30), (2, 4))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct4Arg_(-42, (1, 1L<<60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlongArg_andstructTestStruct4Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlongArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlongArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlongArg_andstructTestStruct4Arg_(1 << 30, (1, 1L<<60))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlongArg_andstructTestStruct4Arg_(1 << 30, (2, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4))


	def testsignedlongAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongArg_andstructTestStruct5Arg_(-(1<<30), (1, 2.5))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(-(1<<30), (2, 4.5))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(-42, (1, 2.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(-42, (2, 4.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(1 << 30, (1, 2.5))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlongArg_andstructTestStruct5Arg_(1 << 30, (2, 4.5))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4.5))


	def testsignedlonglongAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andboolArg_(-(1L << 60), YES)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andboolArg_(-(1L << 60), NO)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andboolArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andboolArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andboolArg_(1L << 60, YES)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andboolArg_(1L << 60, NO)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], NO)


	def testsignedlonglongAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andBOOLArg_(-(1L << 60), YES)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andBOOLArg_(-(1L << 60), NO)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andBOOLArg_(-42, YES)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andBOOLArg_(-42, NO)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.signedlonglongArg_andBOOLArg_(1L << 60, YES)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], YES)
		r = o.signedlonglongArg_andBOOLArg_(1L << 60, NO)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], NO)


	def testsignedlonglongAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andcharArg_(-(1L << 60), -128)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -128)
		r = o.signedlonglongArg_andcharArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andcharArg_(-(1L << 60), 127)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 127)
		r = o.signedlonglongArg_andcharArg_(-42, -128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -128)
		r = o.signedlonglongArg_andcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andcharArg_(-42, 127)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 127)
		r = o.signedlonglongArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.signedlonglongArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.signedlonglongArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.signedlonglongArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.signedlonglongArg_andcharArg_(1L << 60, -128)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -128)
		r = o.signedlonglongArg_andcharArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andcharArg_(1L << 60, 127)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 127)


	def testsignedlonglongAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andsignedshortArg_(-(1L << 60), -(1<<14))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlonglongArg_andsignedshortArg_(-(1L << 60), -42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedshortArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedshortArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedshortArg_(-(1L << 60), 1 << 14)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlonglongArg_andsignedshortArg_(-42, -(1<<14))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlonglongArg_andsignedshortArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedshortArg_(-42, 1 << 14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlonglongArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlonglongArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlonglongArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlonglongArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.signedlonglongArg_andsignedshortArg_(1L << 60, -(1<<14))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedlonglongArg_andsignedshortArg_(1L << 60, -42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedshortArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedshortArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedshortArg_(1L << 60, 1 << 14)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1 << 14)


	def testsignedlonglongAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andsignedintArg_(-(1L << 60), -(1<<30))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedintArg_(-(1L << 60), -42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedintArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedintArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedintArg_(-(1L << 60), 1 << 30)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedintArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedintArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedintArg_(1L << 60, -(1<<30))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedintArg_(1L << 60, -42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedintArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedintArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedintArg_(1L << 60, 1 << 30)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1 << 30)


	def testsignedlonglongAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andsignedlongArg_(-(1L << 60), -(1<<30))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedlongArg_(-(1L << 60), -42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlongArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlongArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlongArg_(-(1L << 60), 1 << 30)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedlongArg_(-42, -(1<<30))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedlongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlongArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andsignedlongArg_(1L << 60, -(1<<30))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlonglongArg_andsignedlongArg_(1L << 60, -42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlongArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlongArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlongArg_(1L << 60, 1 << 30)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1 << 30)


	def testsignedlonglongAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andsignedlonglongArg_(-(1L << 60), -(1L << 60))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlonglongArg_andsignedlonglongArg_(-(1L << 60), -42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlonglongArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlonglongArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlonglongArg_(-(1L << 60), 1L << 60)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlonglongArg_andsignedlonglongArg_(-42, -(1L << 60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlonglongArg_andsignedlonglongArg_(-42, -42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlonglongArg_(-42, 1L << 60)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlonglongArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlonglongArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlonglongArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlonglongArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.signedlonglongArg_andsignedlonglongArg_(1L << 60, -(1L << 60))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlonglongArg_andsignedlonglongArg_(1L << 60, -42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongArg_andsignedlonglongArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andsignedlonglongArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andsignedlonglongArg_(1L << 60, 1L << 60)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1L << 60)


	def testsignedlonglongAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andunsignedcharArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedcharArg_(-(1L << 60), 128)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 128)
		r = o.signedlonglongArg_andunsignedcharArg_(-(1L << 60), 255)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 255)
		r = o.signedlonglongArg_andunsignedcharArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedcharArg_(-42, 128)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 128)
		r = o.signedlonglongArg_andunsignedcharArg_(-42, 255)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 255)
		r = o.signedlonglongArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.signedlonglongArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.signedlonglongArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.signedlonglongArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.signedlonglongArg_andunsignedcharArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedcharArg_(1L << 60, 128)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 128)
		r = o.signedlonglongArg_andunsignedcharArg_(1L << 60, 255)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 255)


	def testsignedlonglongAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andunsignedshortArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedshortArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedshortArg_(-(1L << 60), 1<<14)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1<<14)
		r = o.signedlonglongArg_andunsignedshortArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedshortArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedshortArg_(-42, 1<<14)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedlonglongArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.signedlonglongArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.signedlonglongArg_andunsignedshortArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedshortArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedshortArg_(1L << 60, 1<<14)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1<<14)


	def testsignedlonglongAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andunsignedintArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedintArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedintArg_(-(1L << 60), 1 << 30)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andunsignedintArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedintArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedintArg_(-42, 1 << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.signedlonglongArg_andunsignedintArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedintArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedintArg_(1L << 60, 1 << 30)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1 << 30)


	def testsignedlonglongAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andunsignedlongArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlongArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlongArg_(-(1L << 60), 1L << 30)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlonglongArg_andunsignedlongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlongArg_(-42, 1L << 30)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlonglongArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlonglongArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.signedlonglongArg_andunsignedlongArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlongArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlongArg_(1L << 60, 1L << 30)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1L << 30)


	def testsignedlonglongAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andunsignedlonglongArg_(-(1L << 60), 0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlonglongArg_(-(1L << 60), 42)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlonglongArg_(-(1L << 60), 1L << 62)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlonglongArg_andunsignedlonglongArg_(-42, 0)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlonglongArg_(-42, 42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlonglongArg_(-42, 1L << 62)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlonglongArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlonglongArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.signedlonglongArg_andunsignedlonglongArg_(1L << 60, 0)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongArg_andunsignedlonglongArg_(1L << 60, 42)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongArg_andunsignedlonglongArg_(1L << 60, 1L << 62)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], 1L << 62)


	def testsignedlonglongAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andfloatArg_(-(1L << 60), 0.128)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_andfloatArg_(-(1L << 60), 1.0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_andfloatArg_(-(1L << 60), 42.0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_andfloatArg_(-(1L << 60), 1e10)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_andfloatArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_andfloatArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_andfloatArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_andfloatArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_andfloatArg_(1L << 60, 0.128)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_andfloatArg_(1L << 60, 1.0)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_andfloatArg_(1L << 60, 42.0)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_andfloatArg_(1L << 60, 1e10)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedlonglongAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_anddoubleArg_(-(1L << 60), 0.128)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_anddoubleArg_(-(1L << 60), 1.0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_anddoubleArg_(-(1L << 60), 42.0)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_anddoubleArg_(-(1L << 60), 1e10)
		self.assertEquals(r[0], -(1L << 60))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_anddoubleArg_(-42, 0.128)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_anddoubleArg_(-42, 1.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_anddoubleArg_(-42, 42.0)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_anddoubleArg_(-42, 1e10)
		self.assertEquals(r[0], -42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.signedlonglongArg_anddoubleArg_(1L << 60, 0.128)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.signedlonglongArg_anddoubleArg_(1L << 60, 1.0)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.signedlonglongArg_anddoubleArg_(1L << 60, 42.0)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.signedlonglongArg_anddoubleArg_(1L << 60, 1e10)
		self.assertEquals(r[0], 1L << 60)
		self.assertAlmostEquals(r[1], 1e10)


	def testsignedlonglongAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andidArg_(-(1L << 60), NSPriorDayDesignations)
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlonglongArg_andidArg_(-42, NSPriorDayDesignations)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlonglongArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlonglongArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.signedlonglongArg_andidArg_(1L << 60, NSPriorDayDesignations)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testsignedlonglongAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andcharPtrArg_(-(1L << 60), "hello")
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], "hello")
		r = o.signedlonglongArg_andcharPtrArg_(-(1L << 60), "world")
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], "world")
		r = o.signedlonglongArg_andcharPtrArg_(-(1L << 60), "foobar")
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], "foobar")
		r = o.signedlonglongArg_andcharPtrArg_(-42, "hello")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "hello")
		r = o.signedlonglongArg_andcharPtrArg_(-42, "world")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "world")
		r = o.signedlonglongArg_andcharPtrArg_(-42, "foobar")
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], "foobar")
		r = o.signedlonglongArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.signedlonglongArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.signedlonglongArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.signedlonglongArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.signedlonglongArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.signedlonglongArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.signedlonglongArg_andcharPtrArg_(1L << 60, "hello")
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], "hello")
		r = o.signedlonglongArg_andcharPtrArg_(1L << 60, "world")
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], "world")
		r = o.signedlonglongArg_andcharPtrArg_(1L << 60, "foobar")
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], "foobar")


	def testsignedlonglongAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andNSPointArg_(-(1L << 60), (1, 2))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andNSPointArg_(-(1L << 60), (3, 4))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (3, 4))
		r = o.signedlonglongArg_andNSPointArg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andNSPointArg_(-42, (3, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedlonglongArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.signedlonglongArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.signedlonglongArg_andNSPointArg_(1L << 60, (1, 2))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andNSPointArg_(1L << 60, (3, 4))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (3, 4))


	def testsignedlonglongAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andNSRectArg_(-(1L << 60), ((1, 2), (3, 4)))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlonglongArg_andNSRectArg_(-(1L << 60), ((7, 8), (9, 10)))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlonglongArg_andNSRectArg_(-42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlonglongArg_andNSRectArg_(-42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlonglongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlonglongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlonglongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlonglongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.signedlonglongArg_andNSRectArg_(1L << 60, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.signedlonglongArg_andNSRectArg_(1L << 60, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testsignedlonglongAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andstructTestStruct1Arg_(-(1L << 60), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(-(1L << 60), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(1L << 60, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct1Arg_(1L << 60, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedlonglongAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andstructTestStruct2Arg_(-(1L << 60), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(-(1L << 60), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(-42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(-42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(1L << 60, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.signedlonglongArg_andstructTestStruct2Arg_(1L << 60, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testsignedlonglongAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andstructTestStruct3Arg_(-(1L << 60), (1, 2))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(-(1L << 60), (2, 4))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(-42, (1, 2))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(1L << 60, (1, 2))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (1, 2))
		r = o.signedlonglongArg_andstructTestStruct3Arg_(1L << 60, (2, 4))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (2, 4))


	def testsignedlonglongAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andstructTestStruct4Arg_(-(1L << 60), (1, 1L<<60))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(-(1L << 60), (2, 4))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(-42, (1, 1L<<60))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(-42, (2, 4))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(1L << 60, (1, 1L<<60))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.signedlonglongArg_andstructTestStruct4Arg_(1L << 60, (2, 4))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (2, 4))


	def testsignedlonglongAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongArg_andstructTestStruct5Arg_(-(1L << 60), (1, 2.5))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(-(1L << 60), (2, 4.5))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(-42, (1, 2.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(-42, (2, 4.5))
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(1L << 60, (1, 2.5))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (1, 2.5))
		r = o.signedlonglongArg_andstructTestStruct5Arg_(1L << 60, (2, 4.5))
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], (2, 4.5))


	def testunsignedcharAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedcharArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedcharArg_andboolArg_(128, YES)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], YES)
		r = o.unsignedcharArg_andboolArg_(128, NO)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], NO)
		r = o.unsignedcharArg_andboolArg_(255, YES)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], YES)
		r = o.unsignedcharArg_andboolArg_(255, NO)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], NO)


	def testunsignedcharAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedcharArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedcharArg_andBOOLArg_(128, YES)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], YES)
		r = o.unsignedcharArg_andBOOLArg_(128, NO)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], NO)
		r = o.unsignedcharArg_andBOOLArg_(255, YES)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], YES)
		r = o.unsignedcharArg_andBOOLArg_(255, NO)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], NO)


	def testunsignedcharAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.unsignedcharArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.unsignedcharArg_andcharArg_(128, -128)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -128)
		r = o.unsignedcharArg_andcharArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andcharArg_(128, 127)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 127)
		r = o.unsignedcharArg_andcharArg_(255, -128)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -128)
		r = o.unsignedcharArg_andcharArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andcharArg_(255, 127)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 127)


	def testunsignedcharAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedcharArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedcharArg_andsignedshortArg_(128, -(1<<14))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedcharArg_andsignedshortArg_(128, -42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedshortArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedshortArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedshortArg_(128, 1 << 14)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedcharArg_andsignedshortArg_(255, -(1<<14))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedcharArg_andsignedshortArg_(255, -42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedshortArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedshortArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedshortArg_(255, 1 << 14)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1 << 14)


	def testunsignedcharAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedcharArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedcharArg_andsignedintArg_(128, -(1<<30))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedcharArg_andsignedintArg_(128, -42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedintArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedintArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedintArg_(128, 1 << 30)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedcharArg_andsignedintArg_(255, -(1<<30))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedcharArg_andsignedintArg_(255, -42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedintArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedintArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedintArg_(255, 1 << 30)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedcharAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedcharArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedcharArg_andsignedlongArg_(128, -(1<<30))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedcharArg_andsignedlongArg_(128, -42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedlongArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedlongArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedlongArg_(128, 1 << 30)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedcharArg_andsignedlongArg_(255, -(1<<30))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedcharArg_andsignedlongArg_(255, -42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedlongArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedlongArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedlongArg_(255, 1 << 30)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedcharAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedcharArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedcharArg_andsignedlonglongArg_(128, -(1L << 60))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedcharArg_andsignedlonglongArg_(128, -42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedlonglongArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedlonglongArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedlonglongArg_(128, 1L << 60)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedcharArg_andsignedlonglongArg_(255, -(1L << 60))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedcharArg_andsignedlonglongArg_(255, -42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], -42)
		r = o.unsignedcharArg_andsignedlonglongArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andsignedlonglongArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andsignedlonglongArg_(255, 1L << 60)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1L << 60)


	def testunsignedcharAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.unsignedcharArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.unsignedcharArg_andunsignedcharArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedcharArg_(128, 128)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 128)
		r = o.unsignedcharArg_andunsignedcharArg_(128, 255)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 255)
		r = o.unsignedcharArg_andunsignedcharArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedcharArg_(255, 128)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 128)
		r = o.unsignedcharArg_andunsignedcharArg_(255, 255)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 255)


	def testunsignedcharAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedcharArg_andunsignedshortArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedshortArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedshortArg_(128, 1<<14)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedcharArg_andunsignedshortArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedshortArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedshortArg_(255, 1<<14)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1<<14)


	def testunsignedcharAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedcharArg_andunsignedintArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedintArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedintArg_(128, 1 << 30)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedcharArg_andunsignedintArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedintArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedintArg_(255, 1 << 30)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedcharAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedcharArg_andunsignedlongArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedlongArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedlongArg_(128, 1L << 30)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedcharArg_andunsignedlongArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedlongArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedlongArg_(255, 1L << 30)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1L << 30)


	def testunsignedcharAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedcharArg_andunsignedlonglongArg_(128, 0)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedlonglongArg_(128, 42)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedlonglongArg_(128, 1L << 62)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedcharArg_andunsignedlonglongArg_(255, 0)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharArg_andunsignedlonglongArg_(255, 42)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 42)
		r = o.unsignedcharArg_andunsignedlonglongArg_(255, 1L << 62)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 1L << 62)


	def testunsignedcharAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedcharArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedcharArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedcharArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedcharArg_andfloatArg_(128, 0.128)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedcharArg_andfloatArg_(128, 1.0)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedcharArg_andfloatArg_(128, 42.0)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedcharArg_andfloatArg_(128, 1e10)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedcharArg_andfloatArg_(255, 0.128)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedcharArg_andfloatArg_(255, 1.0)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedcharArg_andfloatArg_(255, 42.0)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedcharArg_andfloatArg_(255, 1e10)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedcharAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedcharArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedcharArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedcharArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedcharArg_anddoubleArg_(128, 0.128)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedcharArg_anddoubleArg_(128, 1.0)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedcharArg_anddoubleArg_(128, 42.0)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedcharArg_anddoubleArg_(128, 1e10)
		self.assertEquals(r[0], 128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedcharArg_anddoubleArg_(255, 0.128)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedcharArg_anddoubleArg_(255, 1.0)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedcharArg_anddoubleArg_(255, 42.0)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedcharArg_anddoubleArg_(255, 1e10)
		self.assertEquals(r[0], 255)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedcharAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedcharArg_andidArg_(128, NSPriorDayDesignations)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedcharArg_andidArg_(255, NSPriorDayDesignations)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testunsignedcharAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.unsignedcharArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.unsignedcharArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedcharArg_andcharPtrArg_(128, "hello")
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], "hello")
		r = o.unsignedcharArg_andcharPtrArg_(128, "world")
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], "world")
		r = o.unsignedcharArg_andcharPtrArg_(128, "foobar")
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedcharArg_andcharPtrArg_(255, "hello")
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], "hello")
		r = o.unsignedcharArg_andcharPtrArg_(255, "world")
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], "world")
		r = o.unsignedcharArg_andcharPtrArg_(255, "foobar")
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], "foobar")


	def testunsignedcharAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedcharArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedcharArg_andNSPointArg_(128, (1, 2))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedcharArg_andNSPointArg_(128, (3, 4))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedcharArg_andNSPointArg_(255, (1, 2))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedcharArg_andNSPointArg_(255, (3, 4))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (3, 4))


	def testunsignedcharAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedcharArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedcharArg_andNSRectArg_(128, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedcharArg_andNSRectArg_(128, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedcharArg_andNSRectArg_(255, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedcharArg_andNSRectArg_(255, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testunsignedcharAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedcharArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedcharArg_andstructTestStruct1Arg_(128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedcharArg_andstructTestStruct1Arg_(128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedcharArg_andstructTestStruct1Arg_(255, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedcharArg_andstructTestStruct1Arg_(255, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedcharAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedcharArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedcharArg_andstructTestStruct2Arg_(128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedcharArg_andstructTestStruct2Arg_(128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedcharArg_andstructTestStruct2Arg_(255, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedcharArg_andstructTestStruct2Arg_(255, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedcharAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedcharArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedcharArg_andstructTestStruct3Arg_(128, (1, 2))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedcharArg_andstructTestStruct3Arg_(128, (2, 4))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedcharArg_andstructTestStruct3Arg_(255, (1, 2))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedcharArg_andstructTestStruct3Arg_(255, (2, 4))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (2, 4))


	def testunsignedcharAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedcharArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedcharArg_andstructTestStruct4Arg_(128, (1, 1L<<60))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedcharArg_andstructTestStruct4Arg_(128, (2, 4))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedcharArg_andstructTestStruct4Arg_(255, (1, 1L<<60))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedcharArg_andstructTestStruct4Arg_(255, (2, 4))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (2, 4))


	def testunsignedcharAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedcharArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedcharArg_andstructTestStruct5Arg_(128, (1, 2.5))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedcharArg_andstructTestStruct5Arg_(128, (2, 4.5))
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedcharArg_andstructTestStruct5Arg_(255, (1, 2.5))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedcharArg_andstructTestStruct5Arg_(255, (2, 4.5))
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], (2, 4.5))


	def testunsignedshortAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedshortArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedshortArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedshortArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedshortArg_andboolArg_(1<<14, YES)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], YES)
		r = o.unsignedshortArg_andboolArg_(1<<14, NO)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], NO)


	def testunsignedshortAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedshortArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedshortArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedshortArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedshortArg_andBOOLArg_(1<<14, YES)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], YES)
		r = o.unsignedshortArg_andBOOLArg_(1<<14, NO)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], NO)


	def testunsignedshortAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.unsignedshortArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.unsignedshortArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.unsignedshortArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.unsignedshortArg_andcharArg_(1<<14, -128)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -128)
		r = o.unsignedshortArg_andcharArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andcharArg_(1<<14, 127)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 127)


	def testunsignedshortAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedshortArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedshortArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedshortArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedshortArg_andsignedshortArg_(1<<14, -(1<<14))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedshortArg_andsignedshortArg_(1<<14, -42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedshortArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedshortArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedshortArg_(1<<14, 1 << 14)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1 << 14)


	def testunsignedshortAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedshortArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedshortArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedshortArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedshortArg_andsignedintArg_(1<<14, -(1<<30))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedshortArg_andsignedintArg_(1<<14, -42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedintArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedintArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedintArg_(1<<14, 1 << 30)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedshortAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedshortArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedshortArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedshortArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedshortArg_andsignedlongArg_(1<<14, -(1<<30))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedshortArg_andsignedlongArg_(1<<14, -42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedlongArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedlongArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedlongArg_(1<<14, 1 << 30)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedshortAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedshortArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedshortArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedshortArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedshortArg_andsignedlonglongArg_(1<<14, -(1L << 60))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedshortArg_andsignedlonglongArg_(1<<14, -42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], -42)
		r = o.unsignedshortArg_andsignedlonglongArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andsignedlonglongArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andsignedlonglongArg_(1<<14, 1L << 60)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1L << 60)


	def testunsignedshortAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.unsignedshortArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.unsignedshortArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.unsignedshortArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.unsignedshortArg_andunsignedcharArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedcharArg_(1<<14, 128)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 128)
		r = o.unsignedshortArg_andunsignedcharArg_(1<<14, 255)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 255)


	def testunsignedshortAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedshortArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedshortArg_andunsignedshortArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedshortArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedshortArg_(1<<14, 1<<14)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1<<14)


	def testunsignedshortAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedshortArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedshortArg_andunsignedintArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedintArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedintArg_(1<<14, 1 << 30)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedshortAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedshortArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedshortArg_andunsignedlongArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedlongArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedlongArg_(1<<14, 1L << 30)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1L << 30)


	def testunsignedshortAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedshortArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedshortArg_andunsignedlonglongArg_(1<<14, 0)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortArg_andunsignedlonglongArg_(1<<14, 42)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortArg_andunsignedlonglongArg_(1<<14, 1L << 62)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 1L << 62)


	def testunsignedshortAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedshortArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedshortArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedshortArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedshortArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedshortArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedshortArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedshortArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedshortArg_andfloatArg_(1<<14, 0.128)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedshortArg_andfloatArg_(1<<14, 1.0)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedshortArg_andfloatArg_(1<<14, 42.0)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedshortArg_andfloatArg_(1<<14, 1e10)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedshortAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedshortArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedshortArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedshortArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedshortArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedshortArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedshortArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedshortArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedshortArg_anddoubleArg_(1<<14, 0.128)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedshortArg_anddoubleArg_(1<<14, 1.0)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedshortArg_anddoubleArg_(1<<14, 42.0)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedshortArg_anddoubleArg_(1<<14, 1e10)
		self.assertEquals(r[0], 1<<14)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedshortAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedshortArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedshortArg_andidArg_(1<<14, NSPriorDayDesignations)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testunsignedshortAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.unsignedshortArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.unsignedshortArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedshortArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.unsignedshortArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.unsignedshortArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedshortArg_andcharPtrArg_(1<<14, "hello")
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], "hello")
		r = o.unsignedshortArg_andcharPtrArg_(1<<14, "world")
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], "world")
		r = o.unsignedshortArg_andcharPtrArg_(1<<14, "foobar")
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], "foobar")


	def testunsignedshortAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedshortArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedshortArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedshortArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedshortArg_andNSPointArg_(1<<14, (1, 2))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedshortArg_andNSPointArg_(1<<14, (3, 4))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (3, 4))


	def testunsignedshortAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedshortArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedshortArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedshortArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedshortArg_andNSRectArg_(1<<14, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedshortArg_andNSRectArg_(1<<14, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testunsignedshortAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedshortArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedshortArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedshortArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedshortArg_andstructTestStruct1Arg_(1<<14, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedshortArg_andstructTestStruct1Arg_(1<<14, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedshortAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedshortArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedshortArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedshortArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedshortArg_andstructTestStruct2Arg_(1<<14, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedshortArg_andstructTestStruct2Arg_(1<<14, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedshortAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedshortArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedshortArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedshortArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedshortArg_andstructTestStruct3Arg_(1<<14, (1, 2))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedshortArg_andstructTestStruct3Arg_(1<<14, (2, 4))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (2, 4))


	def testunsignedshortAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedshortArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedshortArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedshortArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedshortArg_andstructTestStruct4Arg_(1<<14, (1, 1L<<60))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedshortArg_andstructTestStruct4Arg_(1<<14, (2, 4))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (2, 4))


	def testunsignedshortAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedshortArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedshortArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedshortArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedshortArg_andstructTestStruct5Arg_(1<<14, (1, 2.5))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedshortArg_andstructTestStruct5Arg_(1<<14, (2, 4.5))
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], (2, 4.5))


	def testunsignedintAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedintArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedintArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedintArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedintArg_andboolArg_(1 << 30, YES)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], YES)
		r = o.unsignedintArg_andboolArg_(1 << 30, NO)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NO)


	def testunsignedintAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedintArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedintArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedintArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedintArg_andBOOLArg_(1 << 30, YES)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], YES)
		r = o.unsignedintArg_andBOOLArg_(1 << 30, NO)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NO)


	def testunsignedintAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.unsignedintArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.unsignedintArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.unsignedintArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.unsignedintArg_andcharArg_(1 << 30, -128)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -128)
		r = o.unsignedintArg_andcharArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andcharArg_(1 << 30, 127)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 127)


	def testunsignedintAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedintArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedintArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedintArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedintArg_andsignedshortArg_(1 << 30, -(1<<14))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedintArg_andsignedshortArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedshortArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedshortArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedshortArg_(1 << 30, 1 << 14)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 14)


	def testunsignedintAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedintArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedintArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedintArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedintArg_andsignedintArg_(1 << 30, -(1<<30))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedintArg_andsignedintArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedintArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedintArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedintArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedintAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedintArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedintArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedintArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedintArg_andsignedlongArg_(1 << 30, -(1<<30))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedintArg_andsignedlongArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedlongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedlongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedlongArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedintAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedintArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedintArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedintArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, -(1L << 60))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, -42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andsignedlonglongArg_(1 << 30, 1L << 60)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 60)


	def testunsignedintAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.unsignedintArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.unsignedintArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.unsignedintArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.unsignedintArg_andunsignedcharArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedcharArg_(1 << 30, 128)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 128)
		r = o.unsignedintArg_andunsignedcharArg_(1 << 30, 255)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 255)


	def testunsignedintAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedintArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedintArg_andunsignedshortArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedshortArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedshortArg_(1 << 30, 1<<14)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1<<14)


	def testunsignedintAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedintArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedintArg_andunsignedintArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedintArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedintArg_(1 << 30, 1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedintAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedintArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedintArg_andunsignedlongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedlongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedlongArg_(1 << 30, 1L << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 30)


	def testunsignedintAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedintArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedintArg_andunsignedlonglongArg_(1 << 30, 0)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintArg_andunsignedlonglongArg_(1 << 30, 42)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedintArg_andunsignedlonglongArg_(1 << 30, 1L << 62)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 1L << 62)


	def testunsignedintAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedintArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedintArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedintArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedintArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedintArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedintArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedintArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedintArg_andfloatArg_(1 << 30, 0.128)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedintArg_andfloatArg_(1 << 30, 1.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedintArg_andfloatArg_(1 << 30, 42.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedintArg_andfloatArg_(1 << 30, 1e10)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedintAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedintArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedintArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedintArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedintArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedintArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedintArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedintArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedintArg_anddoubleArg_(1 << 30, 0.128)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedintArg_anddoubleArg_(1 << 30, 1.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedintArg_anddoubleArg_(1 << 30, 42.0)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedintArg_anddoubleArg_(1 << 30, 1e10)
		self.assertEquals(r[0], 1 << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedintAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedintArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedintArg_andidArg_(1 << 30, NSPriorDayDesignations)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testunsignedintAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.unsignedintArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.unsignedintArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedintArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.unsignedintArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.unsignedintArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedintArg_andcharPtrArg_(1 << 30, "hello")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "hello")
		r = o.unsignedintArg_andcharPtrArg_(1 << 30, "world")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "world")
		r = o.unsignedintArg_andcharPtrArg_(1 << 30, "foobar")
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], "foobar")


	def testunsignedintAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedintArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedintArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedintArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedintArg_andNSPointArg_(1 << 30, (1, 2))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedintArg_andNSPointArg_(1 << 30, (3, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (3, 4))


	def testunsignedintAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedintArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedintArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedintArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedintArg_andNSRectArg_(1 << 30, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedintArg_andNSRectArg_(1 << 30, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testunsignedintAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedintArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedintArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedintArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedintArg_andstructTestStruct1Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedintArg_andstructTestStruct1Arg_(1 << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedintAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedintArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedintArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedintArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedintArg_andstructTestStruct2Arg_(1 << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedintArg_andstructTestStruct2Arg_(1 << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedintAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedintArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedintArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedintArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedintArg_andstructTestStruct3Arg_(1 << 30, (1, 2))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedintArg_andstructTestStruct3Arg_(1 << 30, (2, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4))


	def testunsignedintAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedintArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedintArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedintArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedintArg_andstructTestStruct4Arg_(1 << 30, (1, 1L<<60))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedintArg_andstructTestStruct4Arg_(1 << 30, (2, 4))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4))


	def testunsignedintAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedintArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedintArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedintArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedintArg_andstructTestStruct5Arg_(1 << 30, (1, 2.5))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedintArg_andstructTestStruct5Arg_(1 << 30, (2, 4.5))
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], (2, 4.5))


	def testunsignedlongAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedlongArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedlongArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedlongArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedlongArg_andboolArg_(1L << 30, YES)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], YES)
		r = o.unsignedlongArg_andboolArg_(1L << 30, NO)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], NO)


	def testunsignedlongAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedlongArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedlongArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedlongArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedlongArg_andBOOLArg_(1L << 30, YES)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], YES)
		r = o.unsignedlongArg_andBOOLArg_(1L << 30, NO)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], NO)


	def testunsignedlongAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.unsignedlongArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.unsignedlongArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.unsignedlongArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.unsignedlongArg_andcharArg_(1L << 30, -128)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -128)
		r = o.unsignedlongArg_andcharArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andcharArg_(1L << 30, 127)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 127)


	def testunsignedlongAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedlongArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedlongArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedlongArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedlongArg_andsignedshortArg_(1L << 30, -(1<<14))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedlongArg_andsignedshortArg_(1L << 30, -42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedshortArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedshortArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedshortArg_(1L << 30, 1 << 14)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1 << 14)


	def testunsignedlongAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlongArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlongArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlongArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlongArg_andsignedintArg_(1L << 30, -(1<<30))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlongArg_andsignedintArg_(1L << 30, -42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedintArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedintArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedintArg_(1L << 30, 1 << 30)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedlongAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlongArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlongArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlongArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlongArg_andsignedlongArg_(1L << 30, -(1<<30))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlongArg_andsignedlongArg_(1L << 30, -42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedlongArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedlongArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedlongArg_(1L << 30, 1 << 30)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedlongAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedlongArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedlongArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedlongArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedlongArg_andsignedlonglongArg_(1L << 30, -(1L << 60))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedlongArg_andsignedlonglongArg_(1L << 30, -42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], -42)
		r = o.unsignedlongArg_andsignedlonglongArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andsignedlonglongArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andsignedlonglongArg_(1L << 30, 1L << 60)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1L << 60)


	def testunsignedlongAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.unsignedlongArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.unsignedlongArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.unsignedlongArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.unsignedlongArg_andunsignedcharArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedcharArg_(1L << 30, 128)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 128)
		r = o.unsignedlongArg_andunsignedcharArg_(1L << 30, 255)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 255)


	def testunsignedlongAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedlongArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedlongArg_andunsignedshortArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedshortArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedshortArg_(1L << 30, 1<<14)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1<<14)


	def testunsignedlongAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlongArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlongArg_andunsignedintArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedintArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedintArg_(1L << 30, 1 << 30)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedlongAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedlongArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedlongArg_andunsignedlongArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedlongArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedlongArg_(1L << 30, 1L << 30)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1L << 30)


	def testunsignedlongAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedlongArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedlongArg_andunsignedlonglongArg_(1L << 30, 0)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongArg_andunsignedlonglongArg_(1L << 30, 42)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongArg_andunsignedlonglongArg_(1L << 30, 1L << 62)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 1L << 62)


	def testunsignedlongAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlongArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlongArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlongArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlongArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlongArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlongArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlongArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlongArg_andfloatArg_(1L << 30, 0.128)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlongArg_andfloatArg_(1L << 30, 1.0)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlongArg_andfloatArg_(1L << 30, 42.0)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlongArg_andfloatArg_(1L << 30, 1e10)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedlongAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlongArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlongArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlongArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlongArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlongArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlongArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlongArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlongArg_anddoubleArg_(1L << 30, 0.128)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlongArg_anddoubleArg_(1L << 30, 1.0)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlongArg_anddoubleArg_(1L << 30, 42.0)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlongArg_anddoubleArg_(1L << 30, 1e10)
		self.assertEquals(r[0], 1L << 30)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedlongAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedlongArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedlongArg_andidArg_(1L << 30, NSPriorDayDesignations)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testunsignedlongAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.unsignedlongArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.unsignedlongArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedlongArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.unsignedlongArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.unsignedlongArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedlongArg_andcharPtrArg_(1L << 30, "hello")
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], "hello")
		r = o.unsignedlongArg_andcharPtrArg_(1L << 30, "world")
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], "world")
		r = o.unsignedlongArg_andcharPtrArg_(1L << 30, "foobar")
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], "foobar")


	def testunsignedlongAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlongArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedlongArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlongArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedlongArg_andNSPointArg_(1L << 30, (1, 2))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlongArg_andNSPointArg_(1L << 30, (3, 4))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (3, 4))


	def testunsignedlongAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedlongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedlongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedlongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedlongArg_andNSRectArg_(1L << 30, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedlongArg_andNSRectArg_(1L << 30, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testunsignedlongAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlongArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlongArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlongArg_andstructTestStruct1Arg_(1L << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlongArg_andstructTestStruct1Arg_(1L << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedlongAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlongArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlongArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlongArg_andstructTestStruct2Arg_(1L << 30, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlongArg_andstructTestStruct2Arg_(1L << 30, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedlongAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlongArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlongArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlongArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlongArg_andstructTestStruct3Arg_(1L << 30, (1, 2))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlongArg_andstructTestStruct3Arg_(1L << 30, (2, 4))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (2, 4))


	def testunsignedlongAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedlongArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlongArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedlongArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlongArg_andstructTestStruct4Arg_(1L << 30, (1, 1L<<60))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedlongArg_andstructTestStruct4Arg_(1L << 30, (2, 4))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (2, 4))


	def testunsignedlongAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedlongArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedlongArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedlongArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedlongArg_andstructTestStruct5Arg_(1L << 30, (1, 2.5))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedlongArg_andstructTestStruct5Arg_(1L << 30, (2, 4.5))
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], (2, 4.5))


	def testunsignedlonglongAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andboolArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedlonglongArg_andboolArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedlonglongArg_andboolArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedlonglongArg_andboolArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedlonglongArg_andboolArg_(1L << 62, YES)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], YES)
		r = o.unsignedlonglongArg_andboolArg_(1L << 62, NO)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], NO)


	def testunsignedlonglongAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andBOOLArg_(0, YES)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = o.unsignedlonglongArg_andBOOLArg_(0, NO)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = o.unsignedlonglongArg_andBOOLArg_(42, YES)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], YES)
		r = o.unsignedlonglongArg_andBOOLArg_(42, NO)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NO)
		r = o.unsignedlonglongArg_andBOOLArg_(1L << 62, YES)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], YES)
		r = o.unsignedlonglongArg_andBOOLArg_(1L << 62, NO)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], NO)


	def testunsignedlonglongAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andcharArg_(0, -128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = o.unsignedlonglongArg_andcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andcharArg_(0, 127)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = o.unsignedlonglongArg_andcharArg_(42, -128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -128)
		r = o.unsignedlonglongArg_andcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andcharArg_(42, 127)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 127)
		r = o.unsignedlonglongArg_andcharArg_(1L << 62, -128)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -128)
		r = o.unsignedlonglongArg_andcharArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andcharArg_(1L << 62, 127)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 127)


	def testunsignedlonglongAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andsignedshortArg_(0, -(1<<14))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedlonglongArg_andsignedshortArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedshortArg_(0, 1 << 14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedlonglongArg_andsignedshortArg_(42, -(1<<14))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedlonglongArg_andsignedshortArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedshortArg_(42, 1 << 14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 14)
		r = o.unsignedlonglongArg_andsignedshortArg_(1L << 62, -(1<<14))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -(1<<14))
		r = o.unsignedlonglongArg_andsignedshortArg_(1L << 62, -42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedshortArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedshortArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedshortArg_(1L << 62, 1 << 14)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1 << 14)


	def testunsignedlonglongAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andsignedintArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlonglongArg_andsignedintArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlonglongArg_andsignedintArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlonglongArg_andsignedintArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlonglongArg_andsignedintArg_(1L << 62, -(1<<30))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlonglongArg_andsignedintArg_(1L << 62, -42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedintArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedintArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedintArg_(1L << 62, 1 << 30)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedlonglongAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andsignedlongArg_(0, -(1<<30))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlonglongArg_andsignedlongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedlongArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlonglongArg_andsignedlongArg_(42, -(1<<30))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlonglongArg_andsignedlongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedlongArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlonglongArg_andsignedlongArg_(1L << 62, -(1<<30))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -(1<<30))
		r = o.unsignedlonglongArg_andsignedlongArg_(1L << 62, -42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedlongArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedlongArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedlongArg_(1L << 62, 1 << 30)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedlonglongAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(0, -(1L << 60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedlonglongArg_andsignedlonglongArg_(0, -42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(0, 1L << 60)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(42, -(1L << 60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedlonglongArg_andsignedlonglongArg_(42, -42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(42, 1L << 60)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 60)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(1L << 62, -(1L << 60))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -(1L << 60))
		r = o.unsignedlonglongArg_andsignedlonglongArg_(1L << 62, -42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], -42)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andsignedlonglongArg_(1L << 62, 1L << 60)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1L << 60)


	def testunsignedlonglongAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andunsignedcharArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedcharArg_(0, 128)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = o.unsignedlonglongArg_andunsignedcharArg_(0, 255)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = o.unsignedlonglongArg_andunsignedcharArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedcharArg_(42, 128)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 128)
		r = o.unsignedlonglongArg_andunsignedcharArg_(42, 255)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 255)
		r = o.unsignedlonglongArg_andunsignedcharArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedcharArg_(1L << 62, 128)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 128)
		r = o.unsignedlonglongArg_andunsignedcharArg_(1L << 62, 255)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 255)


	def testunsignedlonglongAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andunsignedshortArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedshortArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedshortArg_(0, 1<<14)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedlonglongArg_andunsignedshortArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedshortArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedshortArg_(42, 1<<14)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1<<14)
		r = o.unsignedlonglongArg_andunsignedshortArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedshortArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedshortArg_(1L << 62, 1<<14)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1<<14)


	def testunsignedlonglongAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andunsignedintArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedintArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedintArg_(0, 1 << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlonglongArg_andunsignedintArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedintArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedintArg_(42, 1 << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1 << 30)
		r = o.unsignedlonglongArg_andunsignedintArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedintArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedintArg_(1L << 62, 1 << 30)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedlonglongAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andunsignedlongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedlongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedlongArg_(0, 1L << 30)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedlonglongArg_andunsignedlongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedlongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedlongArg_(42, 1L << 30)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 30)
		r = o.unsignedlonglongArg_andunsignedlongArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedlongArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedlongArg_(1L << 62, 1L << 30)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1L << 30)


	def testunsignedlonglongAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(0, 0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(0, 42)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(0, 1L << 62)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(42, 0)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(42, 42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(42, 1L << 62)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 1L << 62)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(1L << 62, 0)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(1L << 62, 42)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongArg_andunsignedlonglongArg_(1L << 62, 1L << 62)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 1L << 62)


	def testunsignedlonglongAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andfloatArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlonglongArg_andfloatArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlonglongArg_andfloatArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlonglongArg_andfloatArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlonglongArg_andfloatArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlonglongArg_andfloatArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlonglongArg_andfloatArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlonglongArg_andfloatArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlonglongArg_andfloatArg_(1L << 62, 0.128)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlonglongArg_andfloatArg_(1L << 62, 1.0)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlonglongArg_andfloatArg_(1L << 62, 42.0)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlonglongArg_andfloatArg_(1L << 62, 1e10)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedlonglongAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_anddoubleArg_(0, 0.128)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlonglongArg_anddoubleArg_(0, 1.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlonglongArg_anddoubleArg_(0, 42.0)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlonglongArg_anddoubleArg_(0, 1e10)
		self.assertEquals(r[0], 0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlonglongArg_anddoubleArg_(42, 0.128)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlonglongArg_anddoubleArg_(42, 1.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlonglongArg_anddoubleArg_(42, 42.0)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlonglongArg_anddoubleArg_(42, 1e10)
		self.assertEquals(r[0], 42)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.unsignedlonglongArg_anddoubleArg_(1L << 62, 0.128)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.unsignedlonglongArg_anddoubleArg_(1L << 62, 1.0)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.unsignedlonglongArg_anddoubleArg_(1L << 62, 42.0)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.unsignedlonglongArg_anddoubleArg_(1L << 62, 1e10)
		self.assertEquals(r[0], 1L << 62)
		self.assertAlmostEquals(r[1], 1e10)


	def testunsignedlonglongAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andidArg_(0, NSPriorDayDesignations)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedlonglongArg_andidArg_(42, NSPriorDayDesignations)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.unsignedlonglongArg_andidArg_(1L << 62, NSPriorDayDesignations)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testunsignedlonglongAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andcharPtrArg_(0, "hello")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "hello")
		r = o.unsignedlonglongArg_andcharPtrArg_(0, "world")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "world")
		r = o.unsignedlonglongArg_andcharPtrArg_(0, "foobar")
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedlonglongArg_andcharPtrArg_(42, "hello")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "hello")
		r = o.unsignedlonglongArg_andcharPtrArg_(42, "world")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "world")
		r = o.unsignedlonglongArg_andcharPtrArg_(42, "foobar")
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], "foobar")
		r = o.unsignedlonglongArg_andcharPtrArg_(1L << 62, "hello")
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], "hello")
		r = o.unsignedlonglongArg_andcharPtrArg_(1L << 62, "world")
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], "world")
		r = o.unsignedlonglongArg_andcharPtrArg_(1L << 62, "foobar")
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], "foobar")


	def testunsignedlonglongAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andNSPointArg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlonglongArg_andNSPointArg_(0, (3, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedlonglongArg_andNSPointArg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlonglongArg_andNSPointArg_(42, (3, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (3, 4))
		r = o.unsignedlonglongArg_andNSPointArg_(1L << 62, (1, 2))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlonglongArg_andNSPointArg_(1L << 62, (3, 4))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (3, 4))


	def testunsignedlonglongAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andNSRectArg_(0, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedlonglongArg_andNSRectArg_(0, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedlonglongArg_andNSRectArg_(42, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedlonglongArg_andNSRectArg_(42, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.unsignedlonglongArg_andNSRectArg_(1L << 62, ((1, 2), (3, 4)))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.unsignedlonglongArg_andNSRectArg_(1L << 62, ((7, 8), (9, 10)))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testunsignedlonglongAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andstructTestStruct1Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlonglongArg_andstructTestStruct1Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlonglongArg_andstructTestStruct1Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlonglongArg_andstructTestStruct1Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlonglongArg_andstructTestStruct1Arg_(1L << 62, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlonglongArg_andstructTestStruct1Arg_(1L << 62, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedlonglongAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andstructTestStruct2Arg_(0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlonglongArg_andstructTestStruct2Arg_(0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlonglongArg_andstructTestStruct2Arg_(42, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlonglongArg_andstructTestStruct2Arg_(42, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.unsignedlonglongArg_andstructTestStruct2Arg_(1L << 62, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.unsignedlonglongArg_andstructTestStruct2Arg_(1L << 62, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testunsignedlonglongAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andstructTestStruct3Arg_(0, (1, 2))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlonglongArg_andstructTestStruct3Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlonglongArg_andstructTestStruct3Arg_(42, (1, 2))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlonglongArg_andstructTestStruct3Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlonglongArg_andstructTestStruct3Arg_(1L << 62, (1, 2))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (1, 2))
		r = o.unsignedlonglongArg_andstructTestStruct3Arg_(1L << 62, (2, 4))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (2, 4))


	def testunsignedlonglongAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andstructTestStruct4Arg_(0, (1, 1L<<60))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedlonglongArg_andstructTestStruct4Arg_(0, (2, 4))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlonglongArg_andstructTestStruct4Arg_(42, (1, 1L<<60))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedlonglongArg_andstructTestStruct4Arg_(42, (2, 4))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4))
		r = o.unsignedlonglongArg_andstructTestStruct4Arg_(1L << 62, (1, 1L<<60))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.unsignedlonglongArg_andstructTestStruct4Arg_(1L << 62, (2, 4))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (2, 4))


	def testunsignedlonglongAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongArg_andstructTestStruct5Arg_(0, (1, 2.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedlonglongArg_andstructTestStruct5Arg_(0, (2, 4.5))
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedlonglongArg_andstructTestStruct5Arg_(42, (1, 2.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedlonglongArg_andstructTestStruct5Arg_(42, (2, 4.5))
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], (2, 4.5))
		r = o.unsignedlonglongArg_andstructTestStruct5Arg_(1L << 62, (1, 2.5))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (1, 2.5))
		r = o.unsignedlonglongArg_andstructTestStruct5Arg_(1L << 62, (2, 4.5))
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], (2, 4.5))


	def testfloatAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andboolArg_(0.128, YES)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andboolArg_(0.128, NO)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], NO)
		r = o.floatArg_andboolArg_(1.0, YES)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andboolArg_(1.0, NO)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], NO)
		r = o.floatArg_andboolArg_(42.0, YES)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andboolArg_(42.0, NO)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], NO)
		r = o.floatArg_andboolArg_(1e10, YES)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andboolArg_(1e10, NO)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], NO)


	def testfloatAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andBOOLArg_(0.128, YES)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andBOOLArg_(0.128, NO)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], NO)
		r = o.floatArg_andBOOLArg_(1.0, YES)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andBOOLArg_(1.0, NO)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], NO)
		r = o.floatArg_andBOOLArg_(42.0, YES)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andBOOLArg_(42.0, NO)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], NO)
		r = o.floatArg_andBOOLArg_(1e10, YES)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], YES)
		r = o.floatArg_andBOOLArg_(1e10, NO)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], NO)


	def testfloatAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andcharArg_(0.128, -128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -128)
		r = o.floatArg_andcharArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andcharArg_(0.128, 127)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 127)
		r = o.floatArg_andcharArg_(1.0, -128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -128)
		r = o.floatArg_andcharArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andcharArg_(1.0, 127)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 127)
		r = o.floatArg_andcharArg_(42.0, -128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -128)
		r = o.floatArg_andcharArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andcharArg_(42.0, 127)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 127)
		r = o.floatArg_andcharArg_(1e10, -128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -128)
		r = o.floatArg_andcharArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andcharArg_(1e10, 127)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 127)


	def testfloatAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andsignedshortArg_(0.128, -(1<<14))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1<<14))
		r = o.floatArg_andsignedshortArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedshortArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedshortArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedshortArg_(0.128, 1 << 14)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 14)
		r = o.floatArg_andsignedshortArg_(1.0, -(1<<14))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1<<14))
		r = o.floatArg_andsignedshortArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedshortArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedshortArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedshortArg_(1.0, 1 << 14)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 14)
		r = o.floatArg_andsignedshortArg_(42.0, -(1<<14))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1<<14))
		r = o.floatArg_andsignedshortArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedshortArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedshortArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedshortArg_(42.0, 1 << 14)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 14)
		r = o.floatArg_andsignedshortArg_(1e10, -(1<<14))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1<<14))
		r = o.floatArg_andsignedshortArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedshortArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedshortArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedshortArg_(1e10, 1 << 14)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 14)


	def testfloatAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andsignedintArg_(0.128, -(1<<30))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedintArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedintArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedintArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedintArg_(0.128, 1 << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andsignedintArg_(1.0, -(1<<30))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedintArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedintArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedintArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedintArg_(1.0, 1 << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andsignedintArg_(42.0, -(1<<30))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedintArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedintArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedintArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedintArg_(42.0, 1 << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andsignedintArg_(1e10, -(1<<30))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedintArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedintArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedintArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedintArg_(1e10, 1 << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 30)


	def testfloatAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andsignedlongArg_(0.128, -(1<<30))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedlongArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlongArg_(0.128, 1 << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andsignedlongArg_(1.0, -(1<<30))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedlongArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlongArg_(1.0, 1 << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andsignedlongArg_(42.0, -(1<<30))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedlongArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlongArg_(42.0, 1 << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andsignedlongArg_(1e10, -(1<<30))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1<<30))
		r = o.floatArg_andsignedlongArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlongArg_(1e10, 1 << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 30)


	def testfloatAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andsignedlonglongArg_(0.128, -(1L << 60))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1L << 60))
		r = o.floatArg_andsignedlonglongArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlonglongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlonglongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlonglongArg_(0.128, 1L << 60)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1L << 60)
		r = o.floatArg_andsignedlonglongArg_(1.0, -(1L << 60))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.floatArg_andsignedlonglongArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlonglongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlonglongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlonglongArg_(1.0, 1L << 60)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1L << 60)
		r = o.floatArg_andsignedlonglongArg_(42.0, -(1L << 60))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.floatArg_andsignedlonglongArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlonglongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlonglongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlonglongArg_(42.0, 1L << 60)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1L << 60)
		r = o.floatArg_andsignedlonglongArg_(1e10, -(1L << 60))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1L << 60))
		r = o.floatArg_andsignedlonglongArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.floatArg_andsignedlonglongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andsignedlonglongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andsignedlonglongArg_(1e10, 1L << 60)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1L << 60)


	def testfloatAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andunsignedcharArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedcharArg_(0.128, 128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 128)
		r = o.floatArg_andunsignedcharArg_(0.128, 255)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 255)
		r = o.floatArg_andunsignedcharArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedcharArg_(1.0, 128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 128)
		r = o.floatArg_andunsignedcharArg_(1.0, 255)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 255)
		r = o.floatArg_andunsignedcharArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedcharArg_(42.0, 128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 128)
		r = o.floatArg_andunsignedcharArg_(42.0, 255)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 255)
		r = o.floatArg_andunsignedcharArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedcharArg_(1e10, 128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 128)
		r = o.floatArg_andunsignedcharArg_(1e10, 255)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 255)


	def testfloatAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andunsignedshortArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedshortArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedshortArg_(0.128, 1<<14)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1<<14)
		r = o.floatArg_andunsignedshortArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedshortArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedshortArg_(1.0, 1<<14)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1<<14)
		r = o.floatArg_andunsignedshortArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedshortArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedshortArg_(42.0, 1<<14)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1<<14)
		r = o.floatArg_andunsignedshortArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedshortArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedshortArg_(1e10, 1<<14)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1<<14)


	def testfloatAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andunsignedintArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedintArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedintArg_(0.128, 1 << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andunsignedintArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedintArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedintArg_(1.0, 1 << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andunsignedintArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedintArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedintArg_(42.0, 1 << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.floatArg_andunsignedintArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedintArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedintArg_(1e10, 1 << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 30)


	def testfloatAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andunsignedlongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlongArg_(0.128, 1L << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1L << 30)
		r = o.floatArg_andunsignedlongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlongArg_(1.0, 1L << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1L << 30)
		r = o.floatArg_andunsignedlongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlongArg_(42.0, 1L << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1L << 30)
		r = o.floatArg_andunsignedlongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlongArg_(1e10, 1L << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1L << 30)


	def testfloatAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andunsignedlonglongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlonglongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlonglongArg_(0.128, 1L << 62)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1L << 62)
		r = o.floatArg_andunsignedlonglongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlonglongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlonglongArg_(1.0, 1L << 62)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1L << 62)
		r = o.floatArg_andunsignedlonglongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlonglongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlonglongArg_(42.0, 1L << 62)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1L << 62)
		r = o.floatArg_andunsignedlonglongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.floatArg_andunsignedlonglongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.floatArg_andunsignedlonglongArg_(1e10, 1L << 62)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1L << 62)


	def testfloatAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andfloatArg_(0.128, 0.128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_andfloatArg_(0.128, 1.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_andfloatArg_(0.128, 42.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_andfloatArg_(0.128, 1e10)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.floatArg_andfloatArg_(1.0, 0.128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_andfloatArg_(1.0, 1.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_andfloatArg_(1.0, 42.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_andfloatArg_(1.0, 1e10)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.floatArg_andfloatArg_(42.0, 0.128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_andfloatArg_(42.0, 1.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_andfloatArg_(42.0, 42.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_andfloatArg_(42.0, 1e10)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.floatArg_andfloatArg_(1e10, 0.128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_andfloatArg_(1e10, 1.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_andfloatArg_(1e10, 42.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_andfloatArg_(1e10, 1e10)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1e10)


	def testfloatAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_anddoubleArg_(0.128, 0.128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_anddoubleArg_(0.128, 1.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_anddoubleArg_(0.128, 42.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_anddoubleArg_(0.128, 1e10)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.floatArg_anddoubleArg_(1.0, 0.128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_anddoubleArg_(1.0, 1.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_anddoubleArg_(1.0, 42.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_anddoubleArg_(1.0, 1e10)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.floatArg_anddoubleArg_(42.0, 0.128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_anddoubleArg_(42.0, 1.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_anddoubleArg_(42.0, 42.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_anddoubleArg_(42.0, 1e10)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.floatArg_anddoubleArg_(1e10, 0.128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatArg_anddoubleArg_(1e10, 1.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatArg_anddoubleArg_(1e10, 42.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatArg_anddoubleArg_(1e10, 1e10)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1e10)


	def testfloatAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andidArg_(0.128, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.floatArg_andidArg_(1.0, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.floatArg_andidArg_(42.0, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.floatArg_andidArg_(1e10, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testfloatAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andcharPtrArg_(0.128, "hello")
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], "hello")
		r = o.floatArg_andcharPtrArg_(0.128, "world")
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], "world")
		r = o.floatArg_andcharPtrArg_(0.128, "foobar")
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], "foobar")
		r = o.floatArg_andcharPtrArg_(1.0, "hello")
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], "hello")
		r = o.floatArg_andcharPtrArg_(1.0, "world")
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], "world")
		r = o.floatArg_andcharPtrArg_(1.0, "foobar")
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], "foobar")
		r = o.floatArg_andcharPtrArg_(42.0, "hello")
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], "hello")
		r = o.floatArg_andcharPtrArg_(42.0, "world")
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], "world")
		r = o.floatArg_andcharPtrArg_(42.0, "foobar")
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], "foobar")
		r = o.floatArg_andcharPtrArg_(1e10, "hello")
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], "hello")
		r = o.floatArg_andcharPtrArg_(1e10, "world")
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], "world")
		r = o.floatArg_andcharPtrArg_(1e10, "foobar")
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], "foobar")


	def testfloatAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andNSPointArg_(0.128, (1, 2))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andNSPointArg_(0.128, (3, 4))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (3, 4))
		r = o.floatArg_andNSPointArg_(1.0, (1, 2))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andNSPointArg_(1.0, (3, 4))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (3, 4))
		r = o.floatArg_andNSPointArg_(42.0, (1, 2))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andNSPointArg_(42.0, (3, 4))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (3, 4))
		r = o.floatArg_andNSPointArg_(1e10, (1, 2))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andNSPointArg_(1e10, (3, 4))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (3, 4))


	def testfloatAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andNSRectArg_(0.128, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.floatArg_andNSRectArg_(0.128, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.floatArg_andNSRectArg_(1.0, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.floatArg_andNSRectArg_(1.0, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.floatArg_andNSRectArg_(42.0, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.floatArg_andNSRectArg_(42.0, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.floatArg_andNSRectArg_(1e10, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.floatArg_andNSRectArg_(1e10, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testfloatAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andstructTestStruct1Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct1Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.floatArg_andstructTestStruct1Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct1Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.floatArg_andstructTestStruct1Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct1Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.floatArg_andstructTestStruct1Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct1Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testfloatAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andstructTestStruct2Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct2Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.floatArg_andstructTestStruct2Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct2Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.floatArg_andstructTestStruct2Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct2Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.floatArg_andstructTestStruct2Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.floatArg_andstructTestStruct2Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testfloatAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andstructTestStruct3Arg_(0.128, (1, 2))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andstructTestStruct3Arg_(0.128, (2, 4))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (2, 4))
		r = o.floatArg_andstructTestStruct3Arg_(1.0, (1, 2))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andstructTestStruct3Arg_(1.0, (2, 4))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (2, 4))
		r = o.floatArg_andstructTestStruct3Arg_(42.0, (1, 2))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andstructTestStruct3Arg_(42.0, (2, 4))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (2, 4))
		r = o.floatArg_andstructTestStruct3Arg_(1e10, (1, 2))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2))
		r = o.floatArg_andstructTestStruct3Arg_(1e10, (2, 4))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (2, 4))


	def testfloatAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andstructTestStruct4Arg_(0.128, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.floatArg_andstructTestStruct4Arg_(0.128, (2, 4))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (2, 4))
		r = o.floatArg_andstructTestStruct4Arg_(1.0, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.floatArg_andstructTestStruct4Arg_(1.0, (2, 4))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (2, 4))
		r = o.floatArg_andstructTestStruct4Arg_(42.0, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.floatArg_andstructTestStruct4Arg_(42.0, (2, 4))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (2, 4))
		r = o.floatArg_andstructTestStruct4Arg_(1e10, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.floatArg_andstructTestStruct4Arg_(1e10, (2, 4))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (2, 4))


	def testfloatAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatArg_andstructTestStruct5Arg_(0.128, (1, 2.5))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2.5))
		r = o.floatArg_andstructTestStruct5Arg_(0.128, (2, 4.5))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (2, 4.5))
		r = o.floatArg_andstructTestStruct5Arg_(1.0, (1, 2.5))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.floatArg_andstructTestStruct5Arg_(1.0, (2, 4.5))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.floatArg_andstructTestStruct5Arg_(42.0, (1, 2.5))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.floatArg_andstructTestStruct5Arg_(42.0, (2, 4.5))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.floatArg_andstructTestStruct5Arg_(1e10, (1, 2.5))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2.5))
		r = o.floatArg_andstructTestStruct5Arg_(1e10, (2, 4.5))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (2, 4.5))


	def testdoubleAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andboolArg_(0.128, YES)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andboolArg_(0.128, NO)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], NO)
		r = o.doubleArg_andboolArg_(1.0, YES)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andboolArg_(1.0, NO)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], NO)
		r = o.doubleArg_andboolArg_(42.0, YES)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andboolArg_(42.0, NO)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], NO)
		r = o.doubleArg_andboolArg_(1e10, YES)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andboolArg_(1e10, NO)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], NO)


	def testdoubleAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andBOOLArg_(0.128, YES)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andBOOLArg_(0.128, NO)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], NO)
		r = o.doubleArg_andBOOLArg_(1.0, YES)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andBOOLArg_(1.0, NO)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], NO)
		r = o.doubleArg_andBOOLArg_(42.0, YES)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andBOOLArg_(42.0, NO)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], NO)
		r = o.doubleArg_andBOOLArg_(1e10, YES)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], YES)
		r = o.doubleArg_andBOOLArg_(1e10, NO)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], NO)


	def testdoubleAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andcharArg_(0.128, -128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -128)
		r = o.doubleArg_andcharArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andcharArg_(0.128, 127)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 127)
		r = o.doubleArg_andcharArg_(1.0, -128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -128)
		r = o.doubleArg_andcharArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andcharArg_(1.0, 127)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 127)
		r = o.doubleArg_andcharArg_(42.0, -128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -128)
		r = o.doubleArg_andcharArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andcharArg_(42.0, 127)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 127)
		r = o.doubleArg_andcharArg_(1e10, -128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -128)
		r = o.doubleArg_andcharArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andcharArg_(1e10, 127)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 127)


	def testdoubleAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andsignedshortArg_(0.128, -(1<<14))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1<<14))
		r = o.doubleArg_andsignedshortArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedshortArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedshortArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedshortArg_(0.128, 1 << 14)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 14)
		r = o.doubleArg_andsignedshortArg_(1.0, -(1<<14))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1<<14))
		r = o.doubleArg_andsignedshortArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedshortArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedshortArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedshortArg_(1.0, 1 << 14)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 14)
		r = o.doubleArg_andsignedshortArg_(42.0, -(1<<14))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1<<14))
		r = o.doubleArg_andsignedshortArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedshortArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedshortArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedshortArg_(42.0, 1 << 14)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 14)
		r = o.doubleArg_andsignedshortArg_(1e10, -(1<<14))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1<<14))
		r = o.doubleArg_andsignedshortArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedshortArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedshortArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedshortArg_(1e10, 1 << 14)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 14)


	def testdoubleAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andsignedintArg_(0.128, -(1<<30))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedintArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedintArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedintArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedintArg_(0.128, 1 << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andsignedintArg_(1.0, -(1<<30))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedintArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedintArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedintArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedintArg_(1.0, 1 << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andsignedintArg_(42.0, -(1<<30))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedintArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedintArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedintArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedintArg_(42.0, 1 << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andsignedintArg_(1e10, -(1<<30))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedintArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedintArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedintArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedintArg_(1e10, 1 << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 30)


	def testdoubleAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andsignedlongArg_(0.128, -(1<<30))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedlongArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlongArg_(0.128, 1 << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andsignedlongArg_(1.0, -(1<<30))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedlongArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlongArg_(1.0, 1 << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andsignedlongArg_(42.0, -(1<<30))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedlongArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlongArg_(42.0, 1 << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andsignedlongArg_(1e10, -(1<<30))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1<<30))
		r = o.doubleArg_andsignedlongArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlongArg_(1e10, 1 << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 30)


	def testdoubleAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andsignedlonglongArg_(0.128, -(1L << 60))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -(1L << 60))
		r = o.doubleArg_andsignedlonglongArg_(0.128, -42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlonglongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlonglongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlonglongArg_(0.128, 1L << 60)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1L << 60)
		r = o.doubleArg_andsignedlonglongArg_(1.0, -(1L << 60))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.doubleArg_andsignedlonglongArg_(1.0, -42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlonglongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlonglongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlonglongArg_(1.0, 1L << 60)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1L << 60)
		r = o.doubleArg_andsignedlonglongArg_(42.0, -(1L << 60))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -(1L << 60))
		r = o.doubleArg_andsignedlonglongArg_(42.0, -42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlonglongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlonglongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlonglongArg_(42.0, 1L << 60)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1L << 60)
		r = o.doubleArg_andsignedlonglongArg_(1e10, -(1L << 60))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -(1L << 60))
		r = o.doubleArg_andsignedlonglongArg_(1e10, -42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], -42)
		r = o.doubleArg_andsignedlonglongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andsignedlonglongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andsignedlonglongArg_(1e10, 1L << 60)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1L << 60)


	def testdoubleAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andunsignedcharArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedcharArg_(0.128, 128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 128)
		r = o.doubleArg_andunsignedcharArg_(0.128, 255)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 255)
		r = o.doubleArg_andunsignedcharArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedcharArg_(1.0, 128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 128)
		r = o.doubleArg_andunsignedcharArg_(1.0, 255)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 255)
		r = o.doubleArg_andunsignedcharArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedcharArg_(42.0, 128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 128)
		r = o.doubleArg_andunsignedcharArg_(42.0, 255)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 255)
		r = o.doubleArg_andunsignedcharArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedcharArg_(1e10, 128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 128)
		r = o.doubleArg_andunsignedcharArg_(1e10, 255)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 255)


	def testdoubleAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andunsignedshortArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedshortArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedshortArg_(0.128, 1<<14)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1<<14)
		r = o.doubleArg_andunsignedshortArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedshortArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedshortArg_(1.0, 1<<14)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1<<14)
		r = o.doubleArg_andunsignedshortArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedshortArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedshortArg_(42.0, 1<<14)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1<<14)
		r = o.doubleArg_andunsignedshortArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedshortArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedshortArg_(1e10, 1<<14)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1<<14)


	def testdoubleAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andunsignedintArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedintArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedintArg_(0.128, 1 << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andunsignedintArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedintArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedintArg_(1.0, 1 << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andunsignedintArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedintArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedintArg_(42.0, 1 << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1 << 30)
		r = o.doubleArg_andunsignedintArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedintArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedintArg_(1e10, 1 << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1 << 30)


	def testdoubleAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andunsignedlongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlongArg_(0.128, 1L << 30)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1L << 30)
		r = o.doubleArg_andunsignedlongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlongArg_(1.0, 1L << 30)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1L << 30)
		r = o.doubleArg_andunsignedlongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlongArg_(42.0, 1L << 30)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1L << 30)
		r = o.doubleArg_andunsignedlongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlongArg_(1e10, 1L << 30)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1L << 30)


	def testdoubleAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andunsignedlonglongArg_(0.128, 0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlonglongArg_(0.128, 42)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlonglongArg_(0.128, 1L << 62)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], 1L << 62)
		r = o.doubleArg_andunsignedlonglongArg_(1.0, 0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlonglongArg_(1.0, 42)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlonglongArg_(1.0, 1L << 62)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], 1L << 62)
		r = o.doubleArg_andunsignedlonglongArg_(42.0, 0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlonglongArg_(42.0, 42)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlonglongArg_(42.0, 1L << 62)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], 1L << 62)
		r = o.doubleArg_andunsignedlonglongArg_(1e10, 0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 0)
		r = o.doubleArg_andunsignedlonglongArg_(1e10, 42)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 42)
		r = o.doubleArg_andunsignedlonglongArg_(1e10, 1L << 62)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], 1L << 62)


	def testdoubleAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andfloatArg_(0.128, 0.128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_andfloatArg_(0.128, 1.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_andfloatArg_(0.128, 42.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_andfloatArg_(0.128, 1e10)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.doubleArg_andfloatArg_(1.0, 0.128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_andfloatArg_(1.0, 1.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_andfloatArg_(1.0, 42.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_andfloatArg_(1.0, 1e10)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.doubleArg_andfloatArg_(42.0, 0.128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_andfloatArg_(42.0, 1.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_andfloatArg_(42.0, 42.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_andfloatArg_(42.0, 1e10)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.doubleArg_andfloatArg_(1e10, 0.128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_andfloatArg_(1e10, 1.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_andfloatArg_(1e10, 42.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_andfloatArg_(1e10, 1e10)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1e10)


	def testdoubleAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_anddoubleArg_(0.128, 0.128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_anddoubleArg_(0.128, 1.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_anddoubleArg_(0.128, 42.0)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_anddoubleArg_(0.128, 1e10)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.doubleArg_anddoubleArg_(1.0, 0.128)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_anddoubleArg_(1.0, 1.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_anddoubleArg_(1.0, 42.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_anddoubleArg_(1.0, 1e10)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.doubleArg_anddoubleArg_(42.0, 0.128)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_anddoubleArg_(42.0, 1.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_anddoubleArg_(42.0, 42.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_anddoubleArg_(42.0, 1e10)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1e10)
		r = o.doubleArg_anddoubleArg_(1e10, 0.128)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleArg_anddoubleArg_(1e10, 1.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleArg_anddoubleArg_(1e10, 42.0)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleArg_anddoubleArg_(1e10, 1e10)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 1e10)


	def testdoubleAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andidArg_(0.128, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.doubleArg_andidArg_(1.0, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.doubleArg_andidArg_(42.0, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.doubleArg_andidArg_(1e10, NSPriorDayDesignations)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testdoubleAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andcharPtrArg_(0.128, "hello")
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], "hello")
		r = o.doubleArg_andcharPtrArg_(0.128, "world")
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], "world")
		r = o.doubleArg_andcharPtrArg_(0.128, "foobar")
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], "foobar")
		r = o.doubleArg_andcharPtrArg_(1.0, "hello")
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], "hello")
		r = o.doubleArg_andcharPtrArg_(1.0, "world")
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], "world")
		r = o.doubleArg_andcharPtrArg_(1.0, "foobar")
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], "foobar")
		r = o.doubleArg_andcharPtrArg_(42.0, "hello")
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], "hello")
		r = o.doubleArg_andcharPtrArg_(42.0, "world")
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], "world")
		r = o.doubleArg_andcharPtrArg_(42.0, "foobar")
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], "foobar")
		r = o.doubleArg_andcharPtrArg_(1e10, "hello")
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], "hello")
		r = o.doubleArg_andcharPtrArg_(1e10, "world")
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], "world")
		r = o.doubleArg_andcharPtrArg_(1e10, "foobar")
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], "foobar")


	def testdoubleAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andNSPointArg_(0.128, (1, 2))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andNSPointArg_(0.128, (3, 4))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (3, 4))
		r = o.doubleArg_andNSPointArg_(1.0, (1, 2))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andNSPointArg_(1.0, (3, 4))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (3, 4))
		r = o.doubleArg_andNSPointArg_(42.0, (1, 2))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andNSPointArg_(42.0, (3, 4))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (3, 4))
		r = o.doubleArg_andNSPointArg_(1e10, (1, 2))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andNSPointArg_(1e10, (3, 4))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (3, 4))


	def testdoubleAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andNSRectArg_(0.128, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.doubleArg_andNSRectArg_(0.128, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.doubleArg_andNSRectArg_(1.0, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.doubleArg_andNSRectArg_(1.0, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.doubleArg_andNSRectArg_(42.0, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.doubleArg_andNSRectArg_(42.0, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.doubleArg_andNSRectArg_(1e10, ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.doubleArg_andNSRectArg_(1e10, ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testdoubleAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andstructTestStruct1Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct1Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.doubleArg_andstructTestStruct1Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct1Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.doubleArg_andstructTestStruct1Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct1Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.doubleArg_andstructTestStruct1Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct1Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testdoubleAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andstructTestStruct2Arg_(0.128, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct2Arg_(0.128, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.doubleArg_andstructTestStruct2Arg_(1.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct2Arg_(1.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.doubleArg_andstructTestStruct2Arg_(42.0, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct2Arg_(42.0, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.doubleArg_andstructTestStruct2Arg_(1e10, (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.doubleArg_andstructTestStruct2Arg_(1e10, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testdoubleAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andstructTestStruct3Arg_(0.128, (1, 2))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andstructTestStruct3Arg_(0.128, (2, 4))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (2, 4))
		r = o.doubleArg_andstructTestStruct3Arg_(1.0, (1, 2))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andstructTestStruct3Arg_(1.0, (2, 4))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (2, 4))
		r = o.doubleArg_andstructTestStruct3Arg_(42.0, (1, 2))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andstructTestStruct3Arg_(42.0, (2, 4))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (2, 4))
		r = o.doubleArg_andstructTestStruct3Arg_(1e10, (1, 2))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2))
		r = o.doubleArg_andstructTestStruct3Arg_(1e10, (2, 4))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (2, 4))


	def testdoubleAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andstructTestStruct4Arg_(0.128, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.doubleArg_andstructTestStruct4Arg_(0.128, (2, 4))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (2, 4))
		r = o.doubleArg_andstructTestStruct4Arg_(1.0, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.doubleArg_andstructTestStruct4Arg_(1.0, (2, 4))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (2, 4))
		r = o.doubleArg_andstructTestStruct4Arg_(42.0, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.doubleArg_andstructTestStruct4Arg_(42.0, (2, 4))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (2, 4))
		r = o.doubleArg_andstructTestStruct4Arg_(1e10, (1, 1L<<60))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.doubleArg_andstructTestStruct4Arg_(1e10, (2, 4))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (2, 4))


	def testdoubleAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleArg_andstructTestStruct5Arg_(0.128, (1, 2.5))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (1, 2.5))
		r = o.doubleArg_andstructTestStruct5Arg_(0.128, (2, 4.5))
		self.assertAlmostEquals(r[0], 0.128)
		self.assertEquals(r[1], (2, 4.5))
		r = o.doubleArg_andstructTestStruct5Arg_(1.0, (1, 2.5))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.doubleArg_andstructTestStruct5Arg_(1.0, (2, 4.5))
		self.assertAlmostEquals(r[0], 1.0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.doubleArg_andstructTestStruct5Arg_(42.0, (1, 2.5))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (1, 2.5))
		r = o.doubleArg_andstructTestStruct5Arg_(42.0, (2, 4.5))
		self.assertAlmostEquals(r[0], 42.0)
		self.assertEquals(r[1], (2, 4.5))
		r = o.doubleArg_andstructTestStruct5Arg_(1e10, (1, 2.5))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (1, 2.5))
		r = o.doubleArg_andstructTestStruct5Arg_(1e10, (2, 4.5))
		self.assertAlmostEquals(r[0], 1e10)
		self.assertEquals(r[1], (2, 4.5))


	def testidAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andboolArg_(NSPriorDayDesignations, YES)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], YES)
		r = o.idArg_andboolArg_(NSPriorDayDesignations, NO)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], NO)


	def testidAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andBOOLArg_(NSPriorDayDesignations, YES)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], YES)
		r = o.idArg_andBOOLArg_(NSPriorDayDesignations, NO)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], NO)


	def testidAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andcharArg_(NSPriorDayDesignations, -128)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -128)
		r = o.idArg_andcharArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andcharArg_(NSPriorDayDesignations, 127)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 127)


	def testidAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, -(1<<14))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -(1<<14))
		r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, -42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -42)
		r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andsignedshortArg_(NSPriorDayDesignations, 1 << 14)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1 << 14)


	def testidAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andsignedintArg_(NSPriorDayDesignations, -(1<<30))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -(1<<30))
		r = o.idArg_andsignedintArg_(NSPriorDayDesignations, -42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -42)
		r = o.idArg_andsignedintArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andsignedintArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andsignedintArg_(NSPriorDayDesignations, 1 << 30)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1 << 30)


	def testidAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, -(1<<30))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -(1<<30))
		r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, -42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -42)
		r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andsignedlongArg_(NSPriorDayDesignations, 1 << 30)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1 << 30)


	def testidAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, -(1L << 60))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -(1L << 60))
		r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, -42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], -42)
		r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andsignedlonglongArg_(NSPriorDayDesignations, 1L << 60)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1L << 60)


	def testidAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andunsignedcharArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andunsignedcharArg_(NSPriorDayDesignations, 128)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 128)
		r = o.idArg_andunsignedcharArg_(NSPriorDayDesignations, 255)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 255)


	def testidAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andunsignedshortArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andunsignedshortArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andunsignedshortArg_(NSPriorDayDesignations, 1<<14)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1<<14)


	def testidAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andunsignedintArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andunsignedintArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andunsignedintArg_(NSPriorDayDesignations, 1 << 30)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1 << 30)


	def testidAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andunsignedlongArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andunsignedlongArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andunsignedlongArg_(NSPriorDayDesignations, 1L << 30)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1L << 30)


	def testidAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andunsignedlonglongArg_(NSPriorDayDesignations, 0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 0)
		r = o.idArg_andunsignedlonglongArg_(NSPriorDayDesignations, 42)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 42)
		r = o.idArg_andunsignedlonglongArg_(NSPriorDayDesignations, 1L << 62)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], 1L << 62)


	def testidAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andfloatArg_(NSPriorDayDesignations, 0.128)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.idArg_andfloatArg_(NSPriorDayDesignations, 1.0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.idArg_andfloatArg_(NSPriorDayDesignations, 42.0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.idArg_andfloatArg_(NSPriorDayDesignations, 1e10)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 1e10)


	def testidAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 0.128)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 1.0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 42.0)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.idArg_anddoubleArg_(NSPriorDayDesignations, 1e10)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertAlmostEquals(r[1], 1e10)


	def testidAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andidArg_(NSPriorDayDesignations, NSPriorDayDesignations)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testidAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andcharPtrArg_(NSPriorDayDesignations, "hello")
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], "hello")
		r = o.idArg_andcharPtrArg_(NSPriorDayDesignations, "world")
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], "world")
		r = o.idArg_andcharPtrArg_(NSPriorDayDesignations, "foobar")
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], "foobar")


	def testidAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andNSPointArg_(NSPriorDayDesignations, (1, 2))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (1, 2))
		r = o.idArg_andNSPointArg_(NSPriorDayDesignations, (3, 4))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (3, 4))


	def testidAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andNSRectArg_(NSPriorDayDesignations, ((1, 2), (3, 4)))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.idArg_andNSRectArg_(NSPriorDayDesignations, ((7, 8), (9, 10)))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testidAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andstructTestStruct1Arg_(NSPriorDayDesignations, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.idArg_andstructTestStruct1Arg_(NSPriorDayDesignations, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testidAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andstructTestStruct2Arg_(NSPriorDayDesignations, (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.idArg_andstructTestStruct2Arg_(NSPriorDayDesignations, (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testidAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andstructTestStruct3Arg_(NSPriorDayDesignations, (1, 2))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (1, 2))
		r = o.idArg_andstructTestStruct3Arg_(NSPriorDayDesignations, (2, 4))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (2, 4))


	def testidAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andstructTestStruct4Arg_(NSPriorDayDesignations, (1, 1L<<60))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.idArg_andstructTestStruct4Arg_(NSPriorDayDesignations, (2, 4))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (2, 4))


	def testidAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idArg_andstructTestStruct5Arg_(NSPriorDayDesignations, (1, 2.5))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (1, 2.5))
		r = o.idArg_andstructTestStruct5Arg_(NSPriorDayDesignations, (2, 4.5))
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], (2, 4.5))


	def testcharPtrAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andboolArg_("hello", YES)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], YES)
		r = o.charPtrArg_andboolArg_("hello", NO)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], NO)
		r = o.charPtrArg_andboolArg_("world", YES)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], YES)
		r = o.charPtrArg_andboolArg_("world", NO)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], NO)
		r = o.charPtrArg_andboolArg_("foobar", YES)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], YES)
		r = o.charPtrArg_andboolArg_("foobar", NO)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], NO)


	def testcharPtrAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andBOOLArg_("hello", YES)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], YES)
		r = o.charPtrArg_andBOOLArg_("hello", NO)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], NO)
		r = o.charPtrArg_andBOOLArg_("world", YES)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], YES)
		r = o.charPtrArg_andBOOLArg_("world", NO)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], NO)
		r = o.charPtrArg_andBOOLArg_("foobar", YES)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], YES)
		r = o.charPtrArg_andBOOLArg_("foobar", NO)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], NO)


	def testcharPtrAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andcharArg_("hello", -128)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -128)
		r = o.charPtrArg_andcharArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andcharArg_("hello", 127)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 127)
		r = o.charPtrArg_andcharArg_("world", -128)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -128)
		r = o.charPtrArg_andcharArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andcharArg_("world", 127)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 127)
		r = o.charPtrArg_andcharArg_("foobar", -128)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -128)
		r = o.charPtrArg_andcharArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andcharArg_("foobar", 127)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 127)


	def testcharPtrAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andsignedshortArg_("hello", -(1<<14))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -(1<<14))
		r = o.charPtrArg_andsignedshortArg_("hello", -42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedshortArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedshortArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedshortArg_("hello", 1 << 14)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1 << 14)
		r = o.charPtrArg_andsignedshortArg_("world", -(1<<14))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -(1<<14))
		r = o.charPtrArg_andsignedshortArg_("world", -42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedshortArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedshortArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedshortArg_("world", 1 << 14)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1 << 14)
		r = o.charPtrArg_andsignedshortArg_("foobar", -(1<<14))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -(1<<14))
		r = o.charPtrArg_andsignedshortArg_("foobar", -42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedshortArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedshortArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedshortArg_("foobar", 1 << 14)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1 << 14)


	def testcharPtrAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andsignedintArg_("hello", -(1<<30))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -(1<<30))
		r = o.charPtrArg_andsignedintArg_("hello", -42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedintArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedintArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedintArg_("hello", 1 << 30)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1 << 30)
		r = o.charPtrArg_andsignedintArg_("world", -(1<<30))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -(1<<30))
		r = o.charPtrArg_andsignedintArg_("world", -42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedintArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedintArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedintArg_("world", 1 << 30)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1 << 30)
		r = o.charPtrArg_andsignedintArg_("foobar", -(1<<30))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -(1<<30))
		r = o.charPtrArg_andsignedintArg_("foobar", -42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedintArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedintArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedintArg_("foobar", 1 << 30)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1 << 30)


	def testcharPtrAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andsignedlongArg_("hello", -(1<<30))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -(1<<30))
		r = o.charPtrArg_andsignedlongArg_("hello", -42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedlongArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedlongArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedlongArg_("hello", 1 << 30)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1 << 30)
		r = o.charPtrArg_andsignedlongArg_("world", -(1<<30))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -(1<<30))
		r = o.charPtrArg_andsignedlongArg_("world", -42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedlongArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedlongArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedlongArg_("world", 1 << 30)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1 << 30)
		r = o.charPtrArg_andsignedlongArg_("foobar", -(1<<30))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -(1<<30))
		r = o.charPtrArg_andsignedlongArg_("foobar", -42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedlongArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedlongArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedlongArg_("foobar", 1 << 30)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1 << 30)


	def testcharPtrAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andsignedlonglongArg_("hello", -(1L << 60))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -(1L << 60))
		r = o.charPtrArg_andsignedlonglongArg_("hello", -42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedlonglongArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedlonglongArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedlonglongArg_("hello", 1L << 60)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1L << 60)
		r = o.charPtrArg_andsignedlonglongArg_("world", -(1L << 60))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -(1L << 60))
		r = o.charPtrArg_andsignedlonglongArg_("world", -42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedlonglongArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedlonglongArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedlonglongArg_("world", 1L << 60)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1L << 60)
		r = o.charPtrArg_andsignedlonglongArg_("foobar", -(1L << 60))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -(1L << 60))
		r = o.charPtrArg_andsignedlonglongArg_("foobar", -42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], -42)
		r = o.charPtrArg_andsignedlonglongArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andsignedlonglongArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andsignedlonglongArg_("foobar", 1L << 60)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1L << 60)


	def testcharPtrAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andunsignedcharArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedcharArg_("hello", 128)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 128)
		r = o.charPtrArg_andunsignedcharArg_("hello", 255)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 255)
		r = o.charPtrArg_andunsignedcharArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedcharArg_("world", 128)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 128)
		r = o.charPtrArg_andunsignedcharArg_("world", 255)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 255)
		r = o.charPtrArg_andunsignedcharArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedcharArg_("foobar", 128)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 128)
		r = o.charPtrArg_andunsignedcharArg_("foobar", 255)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 255)


	def testcharPtrAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andunsignedshortArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedshortArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedshortArg_("hello", 1<<14)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1<<14)
		r = o.charPtrArg_andunsignedshortArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedshortArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedshortArg_("world", 1<<14)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1<<14)
		r = o.charPtrArg_andunsignedshortArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedshortArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedshortArg_("foobar", 1<<14)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1<<14)


	def testcharPtrAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andunsignedintArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedintArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedintArg_("hello", 1 << 30)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1 << 30)
		r = o.charPtrArg_andunsignedintArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedintArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedintArg_("world", 1 << 30)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1 << 30)
		r = o.charPtrArg_andunsignedintArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedintArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedintArg_("foobar", 1 << 30)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1 << 30)


	def testcharPtrAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andunsignedlongArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedlongArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedlongArg_("hello", 1L << 30)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1L << 30)
		r = o.charPtrArg_andunsignedlongArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedlongArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedlongArg_("world", 1L << 30)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1L << 30)
		r = o.charPtrArg_andunsignedlongArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedlongArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedlongArg_("foobar", 1L << 30)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1L << 30)


	def testcharPtrAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andunsignedlonglongArg_("hello", 0)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedlonglongArg_("hello", 42)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedlonglongArg_("hello", 1L << 62)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], 1L << 62)
		r = o.charPtrArg_andunsignedlonglongArg_("world", 0)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedlonglongArg_("world", 42)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedlonglongArg_("world", 1L << 62)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], 1L << 62)
		r = o.charPtrArg_andunsignedlonglongArg_("foobar", 0)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 0)
		r = o.charPtrArg_andunsignedlonglongArg_("foobar", 42)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 42)
		r = o.charPtrArg_andunsignedlonglongArg_("foobar", 1L << 62)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], 1L << 62)


	def testcharPtrAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andfloatArg_("hello", 0.128)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charPtrArg_andfloatArg_("hello", 1.0)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charPtrArg_andfloatArg_("hello", 42.0)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charPtrArg_andfloatArg_("hello", 1e10)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charPtrArg_andfloatArg_("world", 0.128)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charPtrArg_andfloatArg_("world", 1.0)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charPtrArg_andfloatArg_("world", 42.0)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charPtrArg_andfloatArg_("world", 1e10)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charPtrArg_andfloatArg_("foobar", 0.128)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charPtrArg_andfloatArg_("foobar", 1.0)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charPtrArg_andfloatArg_("foobar", 42.0)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charPtrArg_andfloatArg_("foobar", 1e10)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 1e10)


	def testcharPtrAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_anddoubleArg_("hello", 0.128)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charPtrArg_anddoubleArg_("hello", 1.0)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charPtrArg_anddoubleArg_("hello", 42.0)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charPtrArg_anddoubleArg_("hello", 1e10)
		self.assertEquals(r[0], "hello")
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charPtrArg_anddoubleArg_("world", 0.128)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charPtrArg_anddoubleArg_("world", 1.0)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charPtrArg_anddoubleArg_("world", 42.0)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charPtrArg_anddoubleArg_("world", 1e10)
		self.assertEquals(r[0], "world")
		self.assertAlmostEquals(r[1], 1e10)
		r = o.charPtrArg_anddoubleArg_("foobar", 0.128)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 0.128)
		r = o.charPtrArg_anddoubleArg_("foobar", 1.0)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 1.0)
		r = o.charPtrArg_anddoubleArg_("foobar", 42.0)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 42.0)
		r = o.charPtrArg_anddoubleArg_("foobar", 1e10)
		self.assertEquals(r[0], "foobar")
		self.assertAlmostEquals(r[1], 1e10)


	def testcharPtrAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andidArg_("hello", NSPriorDayDesignations)
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.charPtrArg_andidArg_("world", NSPriorDayDesignations)
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.charPtrArg_andidArg_("foobar", NSPriorDayDesignations)
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testcharPtrAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andcharPtrArg_("hello", "hello")
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], "hello")
		r = o.charPtrArg_andcharPtrArg_("hello", "world")
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], "world")
		r = o.charPtrArg_andcharPtrArg_("hello", "foobar")
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], "foobar")
		r = o.charPtrArg_andcharPtrArg_("world", "hello")
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], "hello")
		r = o.charPtrArg_andcharPtrArg_("world", "world")
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], "world")
		r = o.charPtrArg_andcharPtrArg_("world", "foobar")
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], "foobar")
		r = o.charPtrArg_andcharPtrArg_("foobar", "hello")
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], "hello")
		r = o.charPtrArg_andcharPtrArg_("foobar", "world")
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], "world")
		r = o.charPtrArg_andcharPtrArg_("foobar", "foobar")
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], "foobar")


	def testcharPtrAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andNSPointArg_("hello", (1, 2))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (1, 2))
		r = o.charPtrArg_andNSPointArg_("hello", (3, 4))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (3, 4))
		r = o.charPtrArg_andNSPointArg_("world", (1, 2))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (1, 2))
		r = o.charPtrArg_andNSPointArg_("world", (3, 4))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (3, 4))
		r = o.charPtrArg_andNSPointArg_("foobar", (1, 2))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (1, 2))
		r = o.charPtrArg_andNSPointArg_("foobar", (3, 4))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (3, 4))


	def testcharPtrAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andNSRectArg_("hello", ((1, 2), (3, 4)))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.charPtrArg_andNSRectArg_("hello", ((7, 8), (9, 10)))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.charPtrArg_andNSRectArg_("world", ((1, 2), (3, 4)))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.charPtrArg_andNSRectArg_("world", ((7, 8), (9, 10)))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.charPtrArg_andNSRectArg_("foobar", ((1, 2), (3, 4)))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.charPtrArg_andNSRectArg_("foobar", ((7, 8), (9, 10)))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testcharPtrAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andstructTestStruct1Arg_("hello", (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charPtrArg_andstructTestStruct1Arg_("hello", (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charPtrArg_andstructTestStruct1Arg_("world", (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charPtrArg_andstructTestStruct1Arg_("world", (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charPtrArg_andstructTestStruct1Arg_("foobar", (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charPtrArg_andstructTestStruct1Arg_("foobar", (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testcharPtrAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andstructTestStruct2Arg_("hello", (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charPtrArg_andstructTestStruct2Arg_("hello", (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charPtrArg_andstructTestStruct2Arg_("world", (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charPtrArg_andstructTestStruct2Arg_("world", (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.charPtrArg_andstructTestStruct2Arg_("foobar", (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.charPtrArg_andstructTestStruct2Arg_("foobar", (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testcharPtrAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andstructTestStruct3Arg_("hello", (1, 2))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (1, 2))
		r = o.charPtrArg_andstructTestStruct3Arg_("hello", (2, 4))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (2, 4))
		r = o.charPtrArg_andstructTestStruct3Arg_("world", (1, 2))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (1, 2))
		r = o.charPtrArg_andstructTestStruct3Arg_("world", (2, 4))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (2, 4))
		r = o.charPtrArg_andstructTestStruct3Arg_("foobar", (1, 2))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (1, 2))
		r = o.charPtrArg_andstructTestStruct3Arg_("foobar", (2, 4))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (2, 4))


	def testcharPtrAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andstructTestStruct4Arg_("hello", (1, 1L<<60))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.charPtrArg_andstructTestStruct4Arg_("hello", (2, 4))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (2, 4))
		r = o.charPtrArg_andstructTestStruct4Arg_("world", (1, 1L<<60))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.charPtrArg_andstructTestStruct4Arg_("world", (2, 4))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (2, 4))
		r = o.charPtrArg_andstructTestStruct4Arg_("foobar", (1, 1L<<60))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.charPtrArg_andstructTestStruct4Arg_("foobar", (2, 4))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (2, 4))


	def testcharPtrAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrArg_andstructTestStruct5Arg_("hello", (1, 2.5))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (1, 2.5))
		r = o.charPtrArg_andstructTestStruct5Arg_("hello", (2, 4.5))
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], (2, 4.5))
		r = o.charPtrArg_andstructTestStruct5Arg_("world", (1, 2.5))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (1, 2.5))
		r = o.charPtrArg_andstructTestStruct5Arg_("world", (2, 4.5))
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], (2, 4.5))
		r = o.charPtrArg_andstructTestStruct5Arg_("foobar", (1, 2.5))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (1, 2.5))
		r = o.charPtrArg_andstructTestStruct5Arg_("foobar", (2, 4.5))
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], (2, 4.5))


	def testNSPointAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andboolArg_((1, 2), YES)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], YES)
		r = o.NSPointArg_andboolArg_((1, 2), NO)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], NO)
		r = o.NSPointArg_andboolArg_((3, 4), YES)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], YES)
		r = o.NSPointArg_andboolArg_((3, 4), NO)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], NO)


	def testNSPointAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andBOOLArg_((1, 2), YES)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], YES)
		r = o.NSPointArg_andBOOLArg_((1, 2), NO)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], NO)
		r = o.NSPointArg_andBOOLArg_((3, 4), YES)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], YES)
		r = o.NSPointArg_andBOOLArg_((3, 4), NO)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], NO)


	def testNSPointAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andcharArg_((1, 2), -128)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -128)
		r = o.NSPointArg_andcharArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andcharArg_((1, 2), 127)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 127)
		r = o.NSPointArg_andcharArg_((3, 4), -128)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -128)
		r = o.NSPointArg_andcharArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andcharArg_((3, 4), 127)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 127)


	def testNSPointAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andsignedshortArg_((1, 2), -(1<<14))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1<<14))
		r = o.NSPointArg_andsignedshortArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedshortArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedshortArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedshortArg_((1, 2), 1 << 14)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 14)
		r = o.NSPointArg_andsignedshortArg_((3, 4), -(1<<14))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -(1<<14))
		r = o.NSPointArg_andsignedshortArg_((3, 4), -42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedshortArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedshortArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedshortArg_((3, 4), 1 << 14)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1 << 14)


	def testNSPointAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andsignedintArg_((1, 2), -(1<<30))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSPointArg_andsignedintArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedintArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedintArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedintArg_((1, 2), 1 << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 30)
		r = o.NSPointArg_andsignedintArg_((3, 4), -(1<<30))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSPointArg_andsignedintArg_((3, 4), -42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedintArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedintArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedintArg_((3, 4), 1 << 30)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1 << 30)


	def testNSPointAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andsignedlongArg_((1, 2), -(1<<30))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSPointArg_andsignedlongArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedlongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedlongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedlongArg_((1, 2), 1 << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 30)
		r = o.NSPointArg_andsignedlongArg_((3, 4), -(1<<30))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSPointArg_andsignedlongArg_((3, 4), -42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedlongArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedlongArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedlongArg_((3, 4), 1 << 30)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1 << 30)


	def testNSPointAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andsignedlonglongArg_((1, 2), -(1L << 60))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1L << 60))
		r = o.NSPointArg_andsignedlonglongArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedlonglongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedlonglongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedlonglongArg_((1, 2), 1L << 60)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1L << 60)
		r = o.NSPointArg_andsignedlonglongArg_((3, 4), -(1L << 60))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -(1L << 60))
		r = o.NSPointArg_andsignedlonglongArg_((3, 4), -42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], -42)
		r = o.NSPointArg_andsignedlonglongArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andsignedlonglongArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andsignedlonglongArg_((3, 4), 1L << 60)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1L << 60)


	def testNSPointAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andunsignedcharArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedcharArg_((1, 2), 128)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 128)
		r = o.NSPointArg_andunsignedcharArg_((1, 2), 255)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 255)
		r = o.NSPointArg_andunsignedcharArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedcharArg_((3, 4), 128)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 128)
		r = o.NSPointArg_andunsignedcharArg_((3, 4), 255)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 255)


	def testNSPointAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andunsignedshortArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedshortArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedshortArg_((1, 2), 1<<14)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1<<14)
		r = o.NSPointArg_andunsignedshortArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedshortArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedshortArg_((3, 4), 1<<14)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1<<14)


	def testNSPointAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andunsignedintArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedintArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedintArg_((1, 2), 1 << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 30)
		r = o.NSPointArg_andunsignedintArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedintArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedintArg_((3, 4), 1 << 30)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1 << 30)


	def testNSPointAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andunsignedlongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedlongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedlongArg_((1, 2), 1L << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1L << 30)
		r = o.NSPointArg_andunsignedlongArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedlongArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedlongArg_((3, 4), 1L << 30)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1L << 30)


	def testNSPointAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andunsignedlonglongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedlonglongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedlonglongArg_((1, 2), 1L << 62)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1L << 62)
		r = o.NSPointArg_andunsignedlonglongArg_((3, 4), 0)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 0)
		r = o.NSPointArg_andunsignedlonglongArg_((3, 4), 42)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 42)
		r = o.NSPointArg_andunsignedlonglongArg_((3, 4), 1L << 62)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], 1L << 62)


	def testNSPointAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andfloatArg_((1, 2), 0.128)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSPointArg_andfloatArg_((1, 2), 1.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSPointArg_andfloatArg_((1, 2), 42.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSPointArg_andfloatArg_((1, 2), 1e10)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.NSPointArg_andfloatArg_((3, 4), 0.128)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSPointArg_andfloatArg_((3, 4), 1.0)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSPointArg_andfloatArg_((3, 4), 42.0)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSPointArg_andfloatArg_((3, 4), 1e10)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 1e10)


	def testNSPointAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_anddoubleArg_((1, 2), 0.128)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSPointArg_anddoubleArg_((1, 2), 1.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSPointArg_anddoubleArg_((1, 2), 42.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSPointArg_anddoubleArg_((1, 2), 1e10)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.NSPointArg_anddoubleArg_((3, 4), 0.128)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSPointArg_anddoubleArg_((3, 4), 1.0)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSPointArg_anddoubleArg_((3, 4), 42.0)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSPointArg_anddoubleArg_((3, 4), 1e10)
		self.assertEquals(r[0], (3, 4))
		self.assertAlmostEquals(r[1], 1e10)


	def testNSPointAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andidArg_((1, 2), NSPriorDayDesignations)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.NSPointArg_andidArg_((3, 4), NSPriorDayDesignations)
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testNSPointAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andcharPtrArg_((1, 2), "hello")
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], "hello")
		r = o.NSPointArg_andcharPtrArg_((1, 2), "world")
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], "world")
		r = o.NSPointArg_andcharPtrArg_((1, 2), "foobar")
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], "foobar")
		r = o.NSPointArg_andcharPtrArg_((3, 4), "hello")
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], "hello")
		r = o.NSPointArg_andcharPtrArg_((3, 4), "world")
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], "world")
		r = o.NSPointArg_andcharPtrArg_((3, 4), "foobar")
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], "foobar")


	def testNSPointAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andNSPointArg_((1, 2), (1, 2))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2))
		r = o.NSPointArg_andNSPointArg_((1, 2), (3, 4))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (3, 4))
		r = o.NSPointArg_andNSPointArg_((3, 4), (1, 2))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.NSPointArg_andNSPointArg_((3, 4), (3, 4))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (3, 4))


	def testNSPointAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andNSRectArg_((1, 2), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.NSPointArg_andNSRectArg_((1, 2), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.NSPointArg_andNSRectArg_((3, 4), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.NSPointArg_andNSRectArg_((3, 4), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testNSPointAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andstructTestStruct1Arg_((1, 2), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSPointArg_andstructTestStruct1Arg_((1, 2), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.NSPointArg_andstructTestStruct1Arg_((3, 4), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSPointArg_andstructTestStruct1Arg_((3, 4), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testNSPointAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andstructTestStruct2Arg_((1, 2), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSPointArg_andstructTestStruct2Arg_((1, 2), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.NSPointArg_andstructTestStruct2Arg_((3, 4), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSPointArg_andstructTestStruct2Arg_((3, 4), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testNSPointAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andstructTestStruct3Arg_((1, 2), (1, 2))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2))
		r = o.NSPointArg_andstructTestStruct3Arg_((1, 2), (2, 4))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (2, 4))
		r = o.NSPointArg_andstructTestStruct3Arg_((3, 4), (1, 2))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.NSPointArg_andstructTestStruct3Arg_((3, 4), (2, 4))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (2, 4))


	def testNSPointAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andstructTestStruct4Arg_((1, 2), (1, 1L<<60))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.NSPointArg_andstructTestStruct4Arg_((1, 2), (2, 4))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (2, 4))
		r = o.NSPointArg_andstructTestStruct4Arg_((3, 4), (1, 1L<<60))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.NSPointArg_andstructTestStruct4Arg_((3, 4), (2, 4))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (2, 4))


	def testNSPointAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointArg_andstructTestStruct5Arg_((1, 2), (1, 2.5))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2.5))
		r = o.NSPointArg_andstructTestStruct5Arg_((1, 2), (2, 4.5))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (2, 4.5))
		r = o.NSPointArg_andstructTestStruct5Arg_((3, 4), (1, 2.5))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (1, 2.5))
		r = o.NSPointArg_andstructTestStruct5Arg_((3, 4), (2, 4.5))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (2, 4.5))


	def testNSRectAndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andboolArg_(((1, 2), (3, 4)), YES)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], YES)
		r = o.NSRectArg_andboolArg_(((1, 2), (3, 4)), NO)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], NO)
		r = o.NSRectArg_andboolArg_(((7, 8), (9, 10)), YES)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], YES)
		r = o.NSRectArg_andboolArg_(((7, 8), (9, 10)), NO)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], NO)


	def testNSRectAndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andBOOLArg_(((1, 2), (3, 4)), YES)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], YES)
		r = o.NSRectArg_andBOOLArg_(((1, 2), (3, 4)), NO)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], NO)
		r = o.NSRectArg_andBOOLArg_(((7, 8), (9, 10)), YES)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], YES)
		r = o.NSRectArg_andBOOLArg_(((7, 8), (9, 10)), NO)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], NO)


	def testNSRectAndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andcharArg_(((1, 2), (3, 4)), -128)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -128)
		r = o.NSRectArg_andcharArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andcharArg_(((1, 2), (3, 4)), 127)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 127)
		r = o.NSRectArg_andcharArg_(((7, 8), (9, 10)), -128)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -128)
		r = o.NSRectArg_andcharArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andcharArg_(((7, 8), (9, 10)), 127)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 127)


	def testNSRectAndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), -(1<<14))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -(1<<14))
		r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), -42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedshortArg_(((1, 2), (3, 4)), 1 << 14)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1 << 14)
		r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), -(1<<14))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -(1<<14))
		r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), -42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedshortArg_(((7, 8), (9, 10)), 1 << 14)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1 << 14)


	def testNSRectAndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), -(1<<30))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), -42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedintArg_(((1, 2), (3, 4)), 1 << 30)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1 << 30)
		r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), -(1<<30))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), -42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedintArg_(((7, 8), (9, 10)), 1 << 30)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1 << 30)


	def testNSRectAndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), -(1<<30))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), -42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedlongArg_(((1, 2), (3, 4)), 1 << 30)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1 << 30)
		r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), -(1<<30))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -(1<<30))
		r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), -42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedlongArg_(((7, 8), (9, 10)), 1 << 30)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1 << 30)


	def testNSRectAndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), -(1L << 60))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -(1L << 60))
		r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), -42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedlonglongArg_(((1, 2), (3, 4)), 1L << 60)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1L << 60)
		r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), -(1L << 60))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -(1L << 60))
		r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), -42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], -42)
		r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andsignedlonglongArg_(((7, 8), (9, 10)), 1L << 60)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1L << 60)


	def testNSRectAndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andunsignedcharArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedcharArg_(((1, 2), (3, 4)), 128)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 128)
		r = o.NSRectArg_andunsignedcharArg_(((1, 2), (3, 4)), 255)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 255)
		r = o.NSRectArg_andunsignedcharArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedcharArg_(((7, 8), (9, 10)), 128)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 128)
		r = o.NSRectArg_andunsignedcharArg_(((7, 8), (9, 10)), 255)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 255)


	def testNSRectAndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andunsignedshortArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedshortArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedshortArg_(((1, 2), (3, 4)), 1<<14)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1<<14)
		r = o.NSRectArg_andunsignedshortArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedshortArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedshortArg_(((7, 8), (9, 10)), 1<<14)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1<<14)


	def testNSRectAndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andunsignedintArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedintArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedintArg_(((1, 2), (3, 4)), 1 << 30)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1 << 30)
		r = o.NSRectArg_andunsignedintArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedintArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedintArg_(((7, 8), (9, 10)), 1 << 30)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1 << 30)


	def testNSRectAndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andunsignedlongArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedlongArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedlongArg_(((1, 2), (3, 4)), 1L << 30)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1L << 30)
		r = o.NSRectArg_andunsignedlongArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedlongArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedlongArg_(((7, 8), (9, 10)), 1L << 30)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1L << 30)


	def testNSRectAndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andunsignedlonglongArg_(((1, 2), (3, 4)), 0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedlonglongArg_(((1, 2), (3, 4)), 42)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedlonglongArg_(((1, 2), (3, 4)), 1L << 62)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], 1L << 62)
		r = o.NSRectArg_andunsignedlonglongArg_(((7, 8), (9, 10)), 0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 0)
		r = o.NSRectArg_andunsignedlonglongArg_(((7, 8), (9, 10)), 42)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 42)
		r = o.NSRectArg_andunsignedlonglongArg_(((7, 8), (9, 10)), 1L << 62)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], 1L << 62)


	def testNSRectAndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 0.128)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 1.0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 42.0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSRectArg_andfloatArg_(((1, 2), (3, 4)), 1e10)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 0.128)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 1.0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 42.0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSRectArg_andfloatArg_(((7, 8), (9, 10)), 1e10)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 1e10)


	def testNSRectAnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 0.128)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 1.0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 42.0)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSRectArg_anddoubleArg_(((1, 2), (3, 4)), 1e10)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 0.128)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 1.0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 42.0)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.NSRectArg_anddoubleArg_(((7, 8), (9, 10)), 1e10)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertAlmostEquals(r[1], 1e10)


	def testNSRectAndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andidArg_(((1, 2), (3, 4)), NSPriorDayDesignations)
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.NSRectArg_andidArg_(((7, 8), (9, 10)), NSPriorDayDesignations)
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testNSRectAndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andcharPtrArg_(((1, 2), (3, 4)), "hello")
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], "hello")
		r = o.NSRectArg_andcharPtrArg_(((1, 2), (3, 4)), "world")
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], "world")
		r = o.NSRectArg_andcharPtrArg_(((1, 2), (3, 4)), "foobar")
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], "foobar")
		r = o.NSRectArg_andcharPtrArg_(((7, 8), (9, 10)), "hello")
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], "hello")
		r = o.NSRectArg_andcharPtrArg_(((7, 8), (9, 10)), "world")
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], "world")
		r = o.NSRectArg_andcharPtrArg_(((7, 8), (9, 10)), "foobar")
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], "foobar")


	def testNSRectAndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andNSPointArg_(((1, 2), (3, 4)), (1, 2))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (1, 2))
		r = o.NSRectArg_andNSPointArg_(((1, 2), (3, 4)), (3, 4))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (3, 4))
		r = o.NSRectArg_andNSPointArg_(((7, 8), (9, 10)), (1, 2))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (1, 2))
		r = o.NSRectArg_andNSPointArg_(((7, 8), (9, 10)), (3, 4))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (3, 4))


	def testNSRectAndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andNSRectArg_(((1, 2), (3, 4)), ((1, 2), (3, 4)))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.NSRectArg_andNSRectArg_(((1, 2), (3, 4)), ((7, 8), (9, 10)))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.NSRectArg_andNSRectArg_(((7, 8), (9, 10)), ((1, 2), (3, 4)))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.NSRectArg_andNSRectArg_(((7, 8), (9, 10)), ((7, 8), (9, 10)))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testNSRectAndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andstructTestStruct1Arg_(((1, 2), (3, 4)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSRectArg_andstructTestStruct1Arg_(((1, 2), (3, 4)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.NSRectArg_andstructTestStruct1Arg_(((7, 8), (9, 10)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSRectArg_andstructTestStruct1Arg_(((7, 8), (9, 10)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testNSRectAndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andstructTestStruct2Arg_(((1, 2), (3, 4)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSRectArg_andstructTestStruct2Arg_(((1, 2), (3, 4)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.NSRectArg_andstructTestStruct2Arg_(((7, 8), (9, 10)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.NSRectArg_andstructTestStruct2Arg_(((7, 8), (9, 10)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testNSRectAndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andstructTestStruct3Arg_(((1, 2), (3, 4)), (1, 2))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (1, 2))
		r = o.NSRectArg_andstructTestStruct3Arg_(((1, 2), (3, 4)), (2, 4))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (2, 4))
		r = o.NSRectArg_andstructTestStruct3Arg_(((7, 8), (9, 10)), (1, 2))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (1, 2))
		r = o.NSRectArg_andstructTestStruct3Arg_(((7, 8), (9, 10)), (2, 4))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (2, 4))


	def testNSRectAndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andstructTestStruct4Arg_(((1, 2), (3, 4)), (1, 1L<<60))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.NSRectArg_andstructTestStruct4Arg_(((1, 2), (3, 4)), (2, 4))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (2, 4))
		r = o.NSRectArg_andstructTestStruct4Arg_(((7, 8), (9, 10)), (1, 1L<<60))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.NSRectArg_andstructTestStruct4Arg_(((7, 8), (9, 10)), (2, 4))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (2, 4))


	def testNSRectAndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectArg_andstructTestStruct5Arg_(((1, 2), (3, 4)), (1, 2.5))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (1, 2.5))
		r = o.NSRectArg_andstructTestStruct5Arg_(((1, 2), (3, 4)), (2, 4.5))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], (2, 4.5))
		r = o.NSRectArg_andstructTestStruct5Arg_(((7, 8), (9, 10)), (1, 2.5))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (1, 2.5))
		r = o.NSRectArg_andstructTestStruct5Arg_(((7, 8), (9, 10)), (2, 4.5))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], (2, 4.5))


	def teststructTestStruct1AndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), YES)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct1Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), NO)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct1Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct1Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], NO)


	def teststructTestStruct1AndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), YES)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct1Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), NO)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct1Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct1Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], NO)


	def teststructTestStruct1AndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), -128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct1Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 127)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 127)
		r = o.structTestStruct1Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), -128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct1Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 127)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 127)


	def teststructTestStruct1AndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), -(1<<14))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 14)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 14)
		r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), -(1<<14))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 14)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 14)


	def teststructTestStruct1AndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -(1<<30))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), -(1<<30))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct1AndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), -(1<<30))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), -(1<<30))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct1AndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), -(1L << 60))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 1L << 60)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1L << 60)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), -(1L << 60))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct1Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 1L << 60)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1L << 60)


	def teststructTestStruct1AndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct1Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 255)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 255)
		r = o.structTestStruct1Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct1Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 255)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 255)


	def teststructTestStruct1AndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 1<<14)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1<<14)
		r = o.structTestStruct1Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 1<<14)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1<<14)


	def teststructTestStruct1AndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct1Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct1AndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1L << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1L << 30)
		r = o.structTestStruct1Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 1L << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1L << 30)


	def teststructTestStruct1AndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 1L << 62)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1L << 62)
		r = o.structTestStruct1Arg_andunsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct1Arg_andunsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct1Arg_andunsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 1L << 62)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1L << 62)


	def teststructTestStruct1AndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct1Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct1Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct1AnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct1Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct1Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct1AndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andidArg_((1, 2, (1, 2, 3, 4, 5)), NSPriorDayDesignations)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.structTestStruct1Arg_andidArg_((9, 8, (-1, -2, -3, -4, -5)), NSPriorDayDesignations)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], NSPriorDayDesignations)


	def teststructTestStruct1AndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), "hello")
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct1Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), "world")
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct1Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), "foobar")
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], "foobar")
		r = o.structTestStruct1Arg_andcharPtrArg_((9, 8, (-1, -2, -3, -4, -5)), "hello")
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct1Arg_andcharPtrArg_((9, 8, (-1, -2, -3, -4, -5)), "world")
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct1Arg_andcharPtrArg_((9, 8, (-1, -2, -3, -4, -5)), "foobar")
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], "foobar")


	def teststructTestStruct1AndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (1, 2))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct1Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (3, 4))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (3, 4))
		r = o.structTestStruct1Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct1Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (3, 4))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (3, 4))


	def teststructTestStruct1AndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andNSRectArg_((1, 2, (1, 2, 3, 4, 5)), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct1Arg_andNSRectArg_((1, 2, (1, 2, 3, 4, 5)), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.structTestStruct1Arg_andNSRectArg_((9, 8, (-1, -2, -3, -4, -5)), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct1Arg_andNSRectArg_((9, 8, (-1, -2, -3, -4, -5)), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def teststructTestStruct1AndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andstructTestStruct1Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1Arg_andstructTestStruct1Arg_((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct1Arg_andstructTestStruct1Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1Arg_andstructTestStruct1Arg_((9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct1AndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andstructTestStruct2Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1Arg_andstructTestStruct2Arg_((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct1Arg_andstructTestStruct2Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1Arg_andstructTestStruct2Arg_((9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct1AndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andstructTestStruct3Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct1Arg_andstructTestStruct3Arg_((1, 2, (1, 2, 3, 4, 5)), (2, 4))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct1Arg_andstructTestStruct3Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct1Arg_andstructTestStruct3Arg_((9, 8, (-1, -2, -3, -4, -5)), (2, 4))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct1AndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andstructTestStruct4Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 1L<<60))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct1Arg_andstructTestStruct4Arg_((1, 2, (1, 2, 3, 4, 5)), (2, 4))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct1Arg_andstructTestStruct4Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 1L<<60))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct1Arg_andstructTestStruct4Arg_((9, 8, (-1, -2, -3, -4, -5)), (2, 4))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct1AndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1Arg_andstructTestStruct5Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2.5))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct1Arg_andstructTestStruct5Arg_((1, 2, (1, 2, 3, 4, 5)), (2, 4.5))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (2, 4.5))
		r = o.structTestStruct1Arg_andstructTestStruct5Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2.5))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct1Arg_andstructTestStruct5Arg_((9, 8, (-1, -2, -3, -4, -5)), (2, 4.5))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (2, 4.5))


	def teststructTestStruct2AndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), YES)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct2Arg_andboolArg_((1, 2, (1, 2, 3, 4, 5)), NO)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct2Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct2Arg_andboolArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], NO)


	def teststructTestStruct2AndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), YES)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct2Arg_andBOOLArg_((1, 2, (1, 2, 3, 4, 5)), NO)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct2Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), YES)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct2Arg_andBOOLArg_((9, 8, (-1, -2, -3, -4, -5)), NO)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], NO)


	def teststructTestStruct2AndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), -128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct2Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andcharArg_((1, 2, (1, 2, 3, 4, 5)), 127)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 127)
		r = o.structTestStruct2Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), -128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct2Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andcharArg_((9, 8, (-1, -2, -3, -4, -5)), 127)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 127)


	def teststructTestStruct2AndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), -(1<<14))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 14)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 14)
		r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), -(1<<14))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 14)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 14)


	def teststructTestStruct2AndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -(1<<30))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), -(1<<30))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct2AndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), -(1<<30))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), -(1<<30))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct2AndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), -(1L << 60))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), -42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 1L << 60)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1L << 60)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), -(1L << 60))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct2Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), -42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 1L << 60)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1L << 60)


	def teststructTestStruct2AndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct2Arg_andunsignedcharArg_((1, 2, (1, 2, 3, 4, 5)), 255)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 255)
		r = o.structTestStruct2Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct2Arg_andunsignedcharArg_((9, 8, (-1, -2, -3, -4, -5)), 255)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 255)


	def teststructTestStruct2AndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedshortArg_((1, 2, (1, 2, 3, 4, 5)), 1<<14)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1<<14)
		r = o.structTestStruct2Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedshortArg_((9, 8, (-1, -2, -3, -4, -5)), 1<<14)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1<<14)


	def teststructTestStruct2AndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedintArg_((1, 2, (1, 2, 3, 4, 5)), 1 << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct2Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedintArg_((9, 8, (-1, -2, -3, -4, -5)), 1 << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct2AndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedlongArg_((1, 2, (1, 2, 3, 4, 5)), 1L << 30)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1L << 30)
		r = o.structTestStruct2Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedlongArg_((9, 8, (-1, -2, -3, -4, -5)), 1L << 30)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1L << 30)


	def teststructTestStruct2AndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 42)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedlonglongArg_((1, 2, (1, 2, 3, 4, 5)), 1L << 62)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], 1L << 62)
		r = o.structTestStruct2Arg_andunsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct2Arg_andunsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 42)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct2Arg_andunsignedlonglongArg_((9, 8, (-1, -2, -3, -4, -5)), 1L << 62)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], 1L << 62)


	def teststructTestStruct2AndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct2Arg_andfloatArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct2Arg_andfloatArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct2AnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 0.128)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 42.0)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct2Arg_anddoubleArg_((1, 2, (1, 2, 3, 4, 5)), 1e10)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 0.128)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 42.0)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct2Arg_anddoubleArg_((9, 8, (-1, -2, -3, -4, -5)), 1e10)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct2AndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andidArg_((1, 2, (1, 2, 3, 4, 5)), NSPriorDayDesignations)
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.structTestStruct2Arg_andidArg_((9, 8, (-1, -2, -3, -4, -5)), NSPriorDayDesignations)
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], NSPriorDayDesignations)


	def teststructTestStruct2AndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), "hello")
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct2Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), "world")
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct2Arg_andcharPtrArg_((1, 2, (1, 2, 3, 4, 5)), "foobar")
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], "foobar")
		r = o.structTestStruct2Arg_andcharPtrArg_((9, 8, (-1, -2, -3, -4, -5)), "hello")
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct2Arg_andcharPtrArg_((9, 8, (-1, -2, -3, -4, -5)), "world")
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct2Arg_andcharPtrArg_((9, 8, (-1, -2, -3, -4, -5)), "foobar")
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], "foobar")


	def teststructTestStruct2AndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (1, 2))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct2Arg_andNSPointArg_((1, 2, (1, 2, 3, 4, 5)), (3, 4))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (3, 4))
		r = o.structTestStruct2Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct2Arg_andNSPointArg_((9, 8, (-1, -2, -3, -4, -5)), (3, 4))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (3, 4))


	def teststructTestStruct2AndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andNSRectArg_((1, 2, (1, 2, 3, 4, 5)), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct2Arg_andNSRectArg_((1, 2, (1, 2, 3, 4, 5)), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.structTestStruct2Arg_andNSRectArg_((9, 8, (-1, -2, -3, -4, -5)), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct2Arg_andNSRectArg_((9, 8, (-1, -2, -3, -4, -5)), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def teststructTestStruct2AndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andstructTestStruct1Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2Arg_andstructTestStruct1Arg_((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct2Arg_andstructTestStruct1Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2Arg_andstructTestStruct1Arg_((9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct2AndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andstructTestStruct2Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2Arg_andstructTestStruct2Arg_((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct2Arg_andstructTestStruct2Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2Arg_andstructTestStruct2Arg_((9, 8, (-1, -2, -3, -4, -5)), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct2AndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andstructTestStruct3Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct2Arg_andstructTestStruct3Arg_((1, 2, (1, 2, 3, 4, 5)), (2, 4))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct2Arg_andstructTestStruct3Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct2Arg_andstructTestStruct3Arg_((9, 8, (-1, -2, -3, -4, -5)), (2, 4))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct2AndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andstructTestStruct4Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 1L<<60))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct2Arg_andstructTestStruct4Arg_((1, 2, (1, 2, 3, 4, 5)), (2, 4))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct2Arg_andstructTestStruct4Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 1L<<60))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct2Arg_andstructTestStruct4Arg_((9, 8, (-1, -2, -3, -4, -5)), (2, 4))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct2AndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2Arg_andstructTestStruct5Arg_((1, 2, (1, 2, 3, 4, 5)), (1, 2.5))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct2Arg_andstructTestStruct5Arg_((1, 2, (1, 2, 3, 4, 5)), (2, 4.5))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (2, 4.5))
		r = o.structTestStruct2Arg_andstructTestStruct5Arg_((9, 8, (-1, -2, -3, -4, -5)), (1, 2.5))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct2Arg_andstructTestStruct5Arg_((9, 8, (-1, -2, -3, -4, -5)), (2, 4.5))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (2, 4.5))


	def teststructTestStruct3AndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andboolArg_((1, 2), YES)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct3Arg_andboolArg_((1, 2), NO)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct3Arg_andboolArg_((2, 4), YES)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct3Arg_andboolArg_((2, 4), NO)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], NO)


	def teststructTestStruct3AndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andBOOLArg_((1, 2), YES)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct3Arg_andBOOLArg_((1, 2), NO)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct3Arg_andBOOLArg_((2, 4), YES)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct3Arg_andBOOLArg_((2, 4), NO)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], NO)


	def teststructTestStruct3AndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andcharArg_((1, 2), -128)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct3Arg_andcharArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andcharArg_((1, 2), 127)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 127)
		r = o.structTestStruct3Arg_andcharArg_((2, 4), -128)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct3Arg_andcharArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andcharArg_((2, 4), 127)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 127)


	def teststructTestStruct3AndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), -(1<<14))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedshortArg_((1, 2), 1 << 14)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 14)
		r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), -(1<<14))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedshortArg_((2, 4), 1 << 14)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 14)


	def teststructTestStruct3AndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andsignedintArg_((1, 2), -(1<<30))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct3Arg_andsignedintArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedintArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedintArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedintArg_((1, 2), 1 << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct3Arg_andsignedintArg_((2, 4), -(1<<30))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct3Arg_andsignedintArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedintArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedintArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedintArg_((2, 4), 1 << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct3AndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), -(1<<30))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedlongArg_((1, 2), 1 << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), -(1<<30))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedlongArg_((2, 4), 1 << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct3AndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), -(1L << 60))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), -42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((1, 2), 1L << 60)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1L << 60)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), -(1L << 60))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andsignedlonglongArg_((2, 4), 1L << 60)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1L << 60)


	def teststructTestStruct3AndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andunsignedcharArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedcharArg_((1, 2), 128)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct3Arg_andunsignedcharArg_((1, 2), 255)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 255)
		r = o.structTestStruct3Arg_andunsignedcharArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedcharArg_((2, 4), 128)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct3Arg_andunsignedcharArg_((2, 4), 255)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 255)


	def teststructTestStruct3AndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andunsignedshortArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedshortArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedshortArg_((1, 2), 1<<14)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1<<14)
		r = o.structTestStruct3Arg_andunsignedshortArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedshortArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedshortArg_((2, 4), 1<<14)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1<<14)


	def teststructTestStruct3AndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andunsignedintArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedintArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedintArg_((1, 2), 1 << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct3Arg_andunsignedintArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedintArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedintArg_((2, 4), 1 << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct3AndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andunsignedlongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedlongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedlongArg_((1, 2), 1L << 30)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1L << 30)
		r = o.structTestStruct3Arg_andunsignedlongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedlongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedlongArg_((2, 4), 1L << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1L << 30)


	def teststructTestStruct3AndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andunsignedlonglongArg_((1, 2), 0)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedlonglongArg_((1, 2), 42)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedlonglongArg_((1, 2), 1L << 62)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], 1L << 62)
		r = o.structTestStruct3Arg_andunsignedlonglongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct3Arg_andunsignedlonglongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct3Arg_andunsignedlonglongArg_((2, 4), 1L << 62)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1L << 62)


	def teststructTestStruct3AndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andfloatArg_((1, 2), 0.128)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct3Arg_andfloatArg_((1, 2), 1.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct3Arg_andfloatArg_((1, 2), 42.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct3Arg_andfloatArg_((1, 2), 1e10)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct3Arg_andfloatArg_((2, 4), 0.128)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct3Arg_andfloatArg_((2, 4), 1.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct3Arg_andfloatArg_((2, 4), 42.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct3Arg_andfloatArg_((2, 4), 1e10)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct3AnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 0.128)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 1.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 42.0)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct3Arg_anddoubleArg_((1, 2), 1e10)
		self.assertEquals(r[0], (1, 2))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 0.128)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 1.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 42.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct3Arg_anddoubleArg_((2, 4), 1e10)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct3AndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andidArg_((1, 2), NSPriorDayDesignations)
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.structTestStruct3Arg_andidArg_((2, 4), NSPriorDayDesignations)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], NSPriorDayDesignations)


	def teststructTestStruct3AndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andcharPtrArg_((1, 2), "hello")
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct3Arg_andcharPtrArg_((1, 2), "world")
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct3Arg_andcharPtrArg_((1, 2), "foobar")
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], "foobar")
		r = o.structTestStruct3Arg_andcharPtrArg_((2, 4), "hello")
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct3Arg_andcharPtrArg_((2, 4), "world")
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct3Arg_andcharPtrArg_((2, 4), "foobar")
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], "foobar")


	def teststructTestStruct3AndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andNSPointArg_((1, 2), (1, 2))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct3Arg_andNSPointArg_((1, 2), (3, 4))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (3, 4))
		r = o.structTestStruct3Arg_andNSPointArg_((2, 4), (1, 2))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct3Arg_andNSPointArg_((2, 4), (3, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (3, 4))


	def teststructTestStruct3AndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andNSRectArg_((1, 2), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct3Arg_andNSRectArg_((1, 2), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.structTestStruct3Arg_andNSRectArg_((2, 4), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct3Arg_andNSRectArg_((2, 4), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def teststructTestStruct3AndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andstructTestStruct1Arg_((1, 2), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct3Arg_andstructTestStruct1Arg_((1, 2), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct3Arg_andstructTestStruct1Arg_((2, 4), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct3Arg_andstructTestStruct1Arg_((2, 4), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct3AndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andstructTestStruct2Arg_((1, 2), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct3Arg_andstructTestStruct2Arg_((1, 2), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct3Arg_andstructTestStruct2Arg_((2, 4), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct3Arg_andstructTestStruct2Arg_((2, 4), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct3AndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andstructTestStruct3Arg_((1, 2), (1, 2))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct3Arg_andstructTestStruct3Arg_((1, 2), (2, 4))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct3Arg_andstructTestStruct3Arg_((2, 4), (1, 2))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct3Arg_andstructTestStruct3Arg_((2, 4), (2, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct3AndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andstructTestStruct4Arg_((1, 2), (1, 1L<<60))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct3Arg_andstructTestStruct4Arg_((1, 2), (2, 4))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct3Arg_andstructTestStruct4Arg_((2, 4), (1, 1L<<60))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct3Arg_andstructTestStruct4Arg_((2, 4), (2, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct3AndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3Arg_andstructTestStruct5Arg_((1, 2), (1, 2.5))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct3Arg_andstructTestStruct5Arg_((1, 2), (2, 4.5))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (2, 4.5))
		r = o.structTestStruct3Arg_andstructTestStruct5Arg_((2, 4), (1, 2.5))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct3Arg_andstructTestStruct5Arg_((2, 4), (2, 4.5))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (2, 4.5))


	def teststructTestStruct4AndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andboolArg_((1, 1L<<60), YES)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct4Arg_andboolArg_((1, 1L<<60), NO)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct4Arg_andboolArg_((2, 4), YES)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct4Arg_andboolArg_((2, 4), NO)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], NO)


	def teststructTestStruct4AndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andBOOLArg_((1, 1L<<60), YES)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct4Arg_andBOOLArg_((1, 1L<<60), NO)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct4Arg_andBOOLArg_((2, 4), YES)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct4Arg_andBOOLArg_((2, 4), NO)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], NO)


	def teststructTestStruct4AndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andcharArg_((1, 1L<<60), -128)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct4Arg_andcharArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andcharArg_((1, 1L<<60), 127)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 127)
		r = o.structTestStruct4Arg_andcharArg_((2, 4), -128)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct4Arg_andcharArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andcharArg_((2, 4), 127)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 127)


	def teststructTestStruct4AndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andsignedshortArg_((1, 1L<<60), -(1<<14))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct4Arg_andsignedshortArg_((1, 1L<<60), -42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedshortArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedshortArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedshortArg_((1, 1L<<60), 1 << 14)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1 << 14)
		r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), -(1<<14))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedshortArg_((2, 4), 1 << 14)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 14)


	def teststructTestStruct4AndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andsignedintArg_((1, 1L<<60), -(1<<30))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct4Arg_andsignedintArg_((1, 1L<<60), -42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedintArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedintArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedintArg_((1, 1L<<60), 1 << 30)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct4Arg_andsignedintArg_((2, 4), -(1<<30))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct4Arg_andsignedintArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedintArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedintArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedintArg_((2, 4), 1 << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct4AndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andsignedlongArg_((1, 1L<<60), -(1<<30))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct4Arg_andsignedlongArg_((1, 1L<<60), -42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedlongArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedlongArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedlongArg_((1, 1L<<60), 1 << 30)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), -(1<<30))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedlongArg_((2, 4), 1 << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct4AndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1L<<60), -(1L << 60))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1L<<60), -42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((1, 1L<<60), 1L << 60)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1L << 60)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), -(1L << 60))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), -42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andsignedlonglongArg_((2, 4), 1L << 60)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1L << 60)


	def teststructTestStruct4AndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andunsignedcharArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedcharArg_((1, 1L<<60), 128)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct4Arg_andunsignedcharArg_((1, 1L<<60), 255)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 255)
		r = o.structTestStruct4Arg_andunsignedcharArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedcharArg_((2, 4), 128)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct4Arg_andunsignedcharArg_((2, 4), 255)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 255)


	def teststructTestStruct4AndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andunsignedshortArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedshortArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedshortArg_((1, 1L<<60), 1<<14)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1<<14)
		r = o.structTestStruct4Arg_andunsignedshortArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedshortArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedshortArg_((2, 4), 1<<14)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1<<14)


	def teststructTestStruct4AndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andunsignedintArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedintArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedintArg_((1, 1L<<60), 1 << 30)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct4Arg_andunsignedintArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedintArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedintArg_((2, 4), 1 << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct4AndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andunsignedlongArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedlongArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedlongArg_((1, 1L<<60), 1L << 30)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1L << 30)
		r = o.structTestStruct4Arg_andunsignedlongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedlongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedlongArg_((2, 4), 1L << 30)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1L << 30)


	def teststructTestStruct4AndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andunsignedlonglongArg_((1, 1L<<60), 0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedlonglongArg_((1, 1L<<60), 42)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedlonglongArg_((1, 1L<<60), 1L << 62)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], 1L << 62)
		r = o.structTestStruct4Arg_andunsignedlonglongArg_((2, 4), 0)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct4Arg_andunsignedlonglongArg_((2, 4), 42)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct4Arg_andunsignedlonglongArg_((2, 4), 1L << 62)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], 1L << 62)


	def teststructTestStruct4AndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andfloatArg_((1, 1L<<60), 0.128)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct4Arg_andfloatArg_((1, 1L<<60), 1.0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct4Arg_andfloatArg_((1, 1L<<60), 42.0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct4Arg_andfloatArg_((1, 1L<<60), 1e10)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct4Arg_andfloatArg_((2, 4), 0.128)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct4Arg_andfloatArg_((2, 4), 1.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct4Arg_andfloatArg_((2, 4), 42.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct4Arg_andfloatArg_((2, 4), 1e10)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct4AnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_anddoubleArg_((1, 1L<<60), 0.128)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct4Arg_anddoubleArg_((1, 1L<<60), 1.0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct4Arg_anddoubleArg_((1, 1L<<60), 42.0)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct4Arg_anddoubleArg_((1, 1L<<60), 1e10)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 0.128)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 1.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 42.0)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct4Arg_anddoubleArg_((2, 4), 1e10)
		self.assertEquals(r[0], (2, 4))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct4AndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andidArg_((1, 1L<<60), NSPriorDayDesignations)
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.structTestStruct4Arg_andidArg_((2, 4), NSPriorDayDesignations)
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], NSPriorDayDesignations)


	def teststructTestStruct4AndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andcharPtrArg_((1, 1L<<60), "hello")
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct4Arg_andcharPtrArg_((1, 1L<<60), "world")
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct4Arg_andcharPtrArg_((1, 1L<<60), "foobar")
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], "foobar")
		r = o.structTestStruct4Arg_andcharPtrArg_((2, 4), "hello")
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct4Arg_andcharPtrArg_((2, 4), "world")
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct4Arg_andcharPtrArg_((2, 4), "foobar")
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], "foobar")


	def teststructTestStruct4AndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andNSPointArg_((1, 1L<<60), (1, 2))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct4Arg_andNSPointArg_((1, 1L<<60), (3, 4))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (3, 4))
		r = o.structTestStruct4Arg_andNSPointArg_((2, 4), (1, 2))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct4Arg_andNSPointArg_((2, 4), (3, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (3, 4))


	def teststructTestStruct4AndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andNSRectArg_((1, 1L<<60), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct4Arg_andNSRectArg_((1, 1L<<60), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.structTestStruct4Arg_andNSRectArg_((2, 4), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct4Arg_andNSRectArg_((2, 4), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def teststructTestStruct4AndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andstructTestStruct1Arg_((1, 1L<<60), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct4Arg_andstructTestStruct1Arg_((1, 1L<<60), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct4Arg_andstructTestStruct1Arg_((2, 4), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct4Arg_andstructTestStruct1Arg_((2, 4), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct4AndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andstructTestStruct2Arg_((1, 1L<<60), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct4Arg_andstructTestStruct2Arg_((1, 1L<<60), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct4Arg_andstructTestStruct2Arg_((2, 4), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct4Arg_andstructTestStruct2Arg_((2, 4), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct4AndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andstructTestStruct3Arg_((1, 1L<<60), (1, 2))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct4Arg_andstructTestStruct3Arg_((1, 1L<<60), (2, 4))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct4Arg_andstructTestStruct3Arg_((2, 4), (1, 2))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct4Arg_andstructTestStruct3Arg_((2, 4), (2, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct4AndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andstructTestStruct4Arg_((1, 1L<<60), (1, 1L<<60))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct4Arg_andstructTestStruct4Arg_((1, 1L<<60), (2, 4))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct4Arg_andstructTestStruct4Arg_((2, 4), (1, 1L<<60))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct4Arg_andstructTestStruct4Arg_((2, 4), (2, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct4AndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4Arg_andstructTestStruct5Arg_((1, 1L<<60), (1, 2.5))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct4Arg_andstructTestStruct5Arg_((1, 1L<<60), (2, 4.5))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (2, 4.5))
		r = o.structTestStruct4Arg_andstructTestStruct5Arg_((2, 4), (1, 2.5))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct4Arg_andstructTestStruct5Arg_((2, 4), (2, 4.5))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (2, 4.5))


	def teststructTestStruct5AndboolArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andboolArg_((1, 2.5), YES)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct5Arg_andboolArg_((1, 2.5), NO)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct5Arg_andboolArg_((2, 4.5), YES)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct5Arg_andboolArg_((2, 4.5), NO)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], NO)


	def teststructTestStruct5AndBOOLArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andBOOLArg_((1, 2.5), YES)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct5Arg_andBOOLArg_((1, 2.5), NO)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], NO)
		r = o.structTestStruct5Arg_andBOOLArg_((2, 4.5), YES)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], YES)
		r = o.structTestStruct5Arg_andBOOLArg_((2, 4.5), NO)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], NO)


	def teststructTestStruct5AndcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andcharArg_((1, 2.5), -128)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct5Arg_andcharArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andcharArg_((1, 2.5), 127)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 127)
		r = o.structTestStruct5Arg_andcharArg_((2, 4.5), -128)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -128)
		r = o.structTestStruct5Arg_andcharArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andcharArg_((2, 4.5), 127)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 127)


	def teststructTestStruct5AndsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), -(1<<14))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), -42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedshortArg_((1, 2.5), 1 << 14)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1 << 14)
		r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), -(1<<14))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -(1<<14))
		r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), -42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedshortArg_((2, 4.5), 1 << 14)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1 << 14)


	def teststructTestStruct5AndsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), -(1<<30))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), -42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedintArg_((1, 2.5), 1 << 30)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), -(1<<30))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), -42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedintArg_((2, 4.5), 1 << 30)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct5AndsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), -(1<<30))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), -42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedlongArg_((1, 2.5), 1 << 30)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), -(1<<30))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -(1<<30))
		r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), -42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedlongArg_((2, 4.5), 1 << 30)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct5AndsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), -(1L << 60))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), -42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((1, 2.5), 1L << 60)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1L << 60)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), -(1L << 60))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -(1L << 60))
		r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), -42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], -42)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andsignedlonglongArg_((2, 4.5), 1L << 60)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1L << 60)


	def teststructTestStruct5AndunsignedcharArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andunsignedcharArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedcharArg_((1, 2.5), 128)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct5Arg_andunsignedcharArg_((1, 2.5), 255)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 255)
		r = o.structTestStruct5Arg_andunsignedcharArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedcharArg_((2, 4.5), 128)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 128)
		r = o.structTestStruct5Arg_andunsignedcharArg_((2, 4.5), 255)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 255)


	def teststructTestStruct5AndunsignedshortArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andunsignedshortArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedshortArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedshortArg_((1, 2.5), 1<<14)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1<<14)
		r = o.structTestStruct5Arg_andunsignedshortArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedshortArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedshortArg_((2, 4.5), 1<<14)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1<<14)


	def teststructTestStruct5AndunsignedintArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andunsignedintArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedintArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedintArg_((1, 2.5), 1 << 30)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1 << 30)
		r = o.structTestStruct5Arg_andunsignedintArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedintArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedintArg_((2, 4.5), 1 << 30)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1 << 30)


	def teststructTestStruct5AndunsignedlongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andunsignedlongArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedlongArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedlongArg_((1, 2.5), 1L << 30)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1L << 30)
		r = o.structTestStruct5Arg_andunsignedlongArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedlongArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedlongArg_((2, 4.5), 1L << 30)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1L << 30)


	def teststructTestStruct5AndunsignedlonglongArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andunsignedlonglongArg_((1, 2.5), 0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedlonglongArg_((1, 2.5), 42)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedlonglongArg_((1, 2.5), 1L << 62)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], 1L << 62)
		r = o.structTestStruct5Arg_andunsignedlonglongArg_((2, 4.5), 0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 0)
		r = o.structTestStruct5Arg_andunsignedlonglongArg_((2, 4.5), 42)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 42)
		r = o.structTestStruct5Arg_andunsignedlonglongArg_((2, 4.5), 1L << 62)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], 1L << 62)


	def teststructTestStruct5AndfloatArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 0.128)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 1.0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 42.0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct5Arg_andfloatArg_((1, 2.5), 1e10)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 0.128)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 1.0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 42.0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct5Arg_andfloatArg_((2, 4.5), 1e10)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct5AnddoubleArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 0.128)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 1.0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 42.0)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct5Arg_anddoubleArg_((1, 2.5), 1e10)
		self.assertEquals(r[0], (1, 2.5))
		self.assertAlmostEquals(r[1], 1e10)
		r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 0.128)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 0.128)
		r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 1.0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 1.0)
		r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 42.0)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 42.0)
		r = o.structTestStruct5Arg_anddoubleArg_((2, 4.5), 1e10)
		self.assertEquals(r[0], (2, 4.5))
		self.assertAlmostEquals(r[1], 1e10)


	def teststructTestStruct5AndidArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andidArg_((1, 2.5), NSPriorDayDesignations)
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = o.structTestStruct5Arg_andidArg_((2, 4.5), NSPriorDayDesignations)
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], NSPriorDayDesignations)


	def teststructTestStruct5AndcharPtrArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andcharPtrArg_((1, 2.5), "hello")
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct5Arg_andcharPtrArg_((1, 2.5), "world")
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct5Arg_andcharPtrArg_((1, 2.5), "foobar")
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], "foobar")
		r = o.structTestStruct5Arg_andcharPtrArg_((2, 4.5), "hello")
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], "hello")
		r = o.structTestStruct5Arg_andcharPtrArg_((2, 4.5), "world")
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], "world")
		r = o.structTestStruct5Arg_andcharPtrArg_((2, 4.5), "foobar")
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], "foobar")


	def teststructTestStruct5AndNSPointArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andNSPointArg_((1, 2.5), (1, 2))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct5Arg_andNSPointArg_((1, 2.5), (3, 4))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (3, 4))
		r = o.structTestStruct5Arg_andNSPointArg_((2, 4.5), (1, 2))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct5Arg_andNSPointArg_((2, 4.5), (3, 4))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (3, 4))


	def teststructTestStruct5AndNSRectArg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andNSRectArg_((1, 2.5), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct5Arg_andNSRectArg_((1, 2.5), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = o.structTestStruct5Arg_andNSRectArg_((2, 4.5), ((1, 2), (3, 4)))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.structTestStruct5Arg_andNSRectArg_((2, 4.5), ((7, 8), (9, 10)))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def teststructTestStruct5AndstructTestStruct1Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andstructTestStruct1Arg_((1, 2.5), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct5Arg_andstructTestStruct1Arg_((1, 2.5), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct5Arg_andstructTestStruct1Arg_((2, 4.5), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct5Arg_andstructTestStruct1Arg_((2, 4.5), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct5AndstructTestStruct2Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andstructTestStruct2Arg_((1, 2.5), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct5Arg_andstructTestStruct2Arg_((1, 2.5), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = o.structTestStruct5Arg_andstructTestStruct2Arg_((2, 4.5), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct5Arg_andstructTestStruct2Arg_((2, 4.5), (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct5AndstructTestStruct3Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andstructTestStruct3Arg_((1, 2.5), (1, 2))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct5Arg_andstructTestStruct3Arg_((1, 2.5), (2, 4))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct5Arg_andstructTestStruct3Arg_((2, 4.5), (1, 2))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct5Arg_andstructTestStruct3Arg_((2, 4.5), (2, 4))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct5AndstructTestStruct4Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andstructTestStruct4Arg_((1, 2.5), (1, 1L<<60))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct5Arg_andstructTestStruct4Arg_((1, 2.5), (2, 4))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (2, 4))
		r = o.structTestStruct5Arg_andstructTestStruct4Arg_((2, 4.5), (1, 1L<<60))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct5Arg_andstructTestStruct4Arg_((2, 4.5), (2, 4))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct5AndstructTestStruct5Arg(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5Arg_andstructTestStruct5Arg_((1, 2.5), (1, 2.5))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct5Arg_andstructTestStruct5Arg_((1, 2.5), (2, 4.5))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (2, 4.5))
		r = o.structTestStruct5Arg_andstructTestStruct5Arg_((2, 4.5), (1, 2.5))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct5Arg_andstructTestStruct5Arg_((2, 4.5), (2, 4.5))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (2, 4.5))


	# Pass by reference arguments (in)

	def testboolIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.boolInArg_(YES)
		self.assertEquals(r, YES)
		r = o.boolInArg_(NO)
		self.assertEquals(r, NO)


	def testBOOLIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.BOOLInArg_(YES)
		self.assertEquals(r, YES)
		r = o.BOOLInArg_(NO)
		self.assertEquals(r, NO)


	def testcharIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charInArg_(-128)
		self.assertEquals(r, -128)
		r = o.charInArg_(0)
		self.assertEquals(r, 0)
		r = o.charInArg_(127)
		self.assertEquals(r, 127)


	def testsignedshortIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedshortInArg_(-(1<<14))
		self.assertEquals(r, -(1<<14))
		r = o.signedshortInArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedshortInArg_(0)
		self.assertEquals(r, 0)
		r = o.signedshortInArg_(42)
		self.assertEquals(r, 42)
		r = o.signedshortInArg_(1 << 14)
		self.assertEquals(r, 1 << 14)


	def testsignedintIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedintInArg_(-(1<<30))
		self.assertEquals(r, -(1<<30))
		r = o.signedintInArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedintInArg_(0)
		self.assertEquals(r, 0)
		r = o.signedintInArg_(42)
		self.assertEquals(r, 42)
		r = o.signedintInArg_(1 << 30)
		self.assertEquals(r, 1 << 30)


	def testsignedlongIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlongInArg_(-(1<<30))
		self.assertEquals(r, -(1<<30))
		r = o.signedlongInArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedlongInArg_(0)
		self.assertEquals(r, 0)
		r = o.signedlongInArg_(42)
		self.assertEquals(r, 42)
		r = o.signedlongInArg_(1 << 30)
		self.assertEquals(r, 1 << 30)


	def testsignedlonglongIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.signedlonglongInArg_(-(1L << 60))
		self.assertEquals(r, -(1L << 60))
		r = o.signedlonglongInArg_(-42)
		self.assertEquals(r, -42)
		r = o.signedlonglongInArg_(0)
		self.assertEquals(r, 0)
		r = o.signedlonglongInArg_(42)
		self.assertEquals(r, 42)
		r = o.signedlonglongInArg_(1L << 60)
		self.assertEquals(r, 1L << 60)


	def testunsignedcharIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedcharInArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedcharInArg_(128)
		self.assertEquals(r, 128)
		r = o.unsignedcharInArg_(255)
		self.assertEquals(r, 255)


	def testunsignedshortIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedshortInArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedshortInArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedshortInArg_(1<<14)
		self.assertEquals(r, 1<<14)


	def testunsignedintIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedintInArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedintInArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedintInArg_(1 << 30)
		self.assertEquals(r, 1 << 30)


	def testunsignedlongIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlongInArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedlongInArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedlongInArg_(1L << 30)
		self.assertEquals(r, 1L << 30)


	def testunsignedlonglongIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.unsignedlonglongInArg_(0)
		self.assertEquals(r, 0)
		r = o.unsignedlonglongInArg_(42)
		self.assertEquals(r, 42)
		r = o.unsignedlonglongInArg_(1L << 62)
		self.assertEquals(r, 1L << 62)


	def testfloatIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.floatInArg_(0.128)
		self.assertAlmostEquals(r, 0.128)
		r = o.floatInArg_(1.0)
		self.assertAlmostEquals(r, 1.0)
		r = o.floatInArg_(42.0)
		self.assertAlmostEquals(r, 42.0)
		r = o.floatInArg_(1e10)
		self.assertAlmostEquals(r, 1e10)


	def testdoubleIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.doubleInArg_(0.128)
		self.assertAlmostEquals(r, 0.128)
		r = o.doubleInArg_(1.0)
		self.assertAlmostEquals(r, 1.0)
		r = o.doubleInArg_(42.0)
		self.assertAlmostEquals(r, 42.0)
		r = o.doubleInArg_(1e10)
		self.assertAlmostEquals(r, 1e10)


	def testidIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.idInArg_(NSPriorDayDesignations)
		self.assertEquals(r, NSPriorDayDesignations)


	def testcharPtrIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.charPtrInArg_("hello")
		self.assertEquals(r, "hello")
		r = o.charPtrInArg_("world")
		self.assertEquals(r, "world")
		r = o.charPtrInArg_("foobar")
		self.assertEquals(r, "foobar")


	def testNSPointIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSPointInArg_((1, 2))
		self.assertEquals(r, (1, 2))
		r = o.NSPointInArg_((3, 4))
		self.assertEquals(r, (3, 4))


	def testNSRectIn(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.NSRectInArg_(((1, 2), (3, 4)))
		self.assertEquals(r, ((1, 2), (3, 4)))
		r = o.NSRectInArg_(((7, 8), (9, 10)))
		self.assertEquals(r, ((7, 8), (9, 10)))


	def teststructTestStruct1In(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct1InArg_((1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1InArg_((9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct2In(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct2InArg_((1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2InArg_((9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct3In(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct3InArg_((1, 2))
		self.assertEquals(r, (1, 2))
		r = o.structTestStruct3InArg_((2, 4))
		self.assertEquals(r, (2, 4))


	def teststructTestStruct4In(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct4InArg_((1, 1L<<60))
		self.assertEquals(r, (1, 1L<<60))
		r = o.structTestStruct4InArg_((2, 4))
		self.assertEquals(r, (2, 4))


	def teststructTestStruct5In(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		r = o.structTestStruct5InArg_((1, 2.5))
		self.assertEquals(r, (1, 2.5))
		r = o.structTestStruct5InArg_((2, 4.5))
		self.assertEquals(r, (2, 4.5))


	# Pass by reference arguments (out)

        if 0:
            def testboolOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.boolOutArg_(None)
		self.assertEquals(r, YES)
		r = o.boolOutArg_(None)
		self.assertEquals(r, NO)


	def testBOOLOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.BOOLOutArg_(None)
		self.assertEquals(r, YES)
		r = o.BOOLOutArg_(None)
		self.assertEquals(r, NO)


	def testcharOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.charOutArg_(None)
		self.assertEquals(r, -128)
		r = o.charOutArg_(None)
		self.assertEquals(r, 0)
		r = o.charOutArg_(None)
		self.assertEquals(r, 127)


	def testsignedshortOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedshortOutArg_(None)
		self.assertEquals(r, -(1<<14))
		r = o.signedshortOutArg_(None)
		self.assertEquals(r, -42)
		r = o.signedshortOutArg_(None)
		self.assertEquals(r, 0)
		r = o.signedshortOutArg_(None)
		self.assertEquals(r, 42)
		r = o.signedshortOutArg_(None)
		self.assertEquals(r, 1 << 14)


	def testsignedintOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedintOutArg_(None)
		self.assertEquals(r, -(1<<30))
		r = o.signedintOutArg_(None)
		self.assertEquals(r, -42)
		r = o.signedintOutArg_(None)
		self.assertEquals(r, 0)
		r = o.signedintOutArg_(None)
		self.assertEquals(r, 42)
		r = o.signedintOutArg_(None)
		self.assertEquals(r, 1 << 30)


	def testsignedlongOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedlongOutArg_(None)
		self.assertEquals(r, -(1<<30))
		r = o.signedlongOutArg_(None)
		self.assertEquals(r, -42)
		r = o.signedlongOutArg_(None)
		self.assertEquals(r, 0)
		r = o.signedlongOutArg_(None)
		self.assertEquals(r, 42)
		r = o.signedlongOutArg_(None)
		self.assertEquals(r, 1 << 30)


	def testsignedlonglongOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedlonglongOutArg_(None)
		self.assertEquals(r, -(1L << 60))
		r = o.signedlonglongOutArg_(None)
		self.assertEquals(r, -42)
		r = o.signedlonglongOutArg_(None)
		self.assertEquals(r, 0)
		r = o.signedlonglongOutArg_(None)
		self.assertEquals(r, 42)
		r = o.signedlonglongOutArg_(None)
		self.assertEquals(r, 1L << 60)


	def testunsignedcharOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedcharOutArg_(None)
		self.assertEquals(r, 0)
		r = o.unsignedcharOutArg_(None)
		self.assertEquals(r, 128)
		r = o.unsignedcharOutArg_(None)
		self.assertEquals(r, 255)


	def testunsignedshortOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedshortOutArg_(None)
		self.assertEquals(r, 0)
		r = o.unsignedshortOutArg_(None)
		self.assertEquals(r, 42)
		r = o.unsignedshortOutArg_(None)
		self.assertEquals(r, 1<<14)


	def testunsignedintOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedintOutArg_(None)
		self.assertEquals(r, 0)
		r = o.unsignedintOutArg_(None)
		self.assertEquals(r, 42)
		r = o.unsignedintOutArg_(None)
		self.assertEquals(r, 1 << 30)


	def testunsignedlongOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedlongOutArg_(None)
		self.assertEquals(r, 0)
		r = o.unsignedlongOutArg_(None)
		self.assertEquals(r, 42)
		r = o.unsignedlongOutArg_(None)
		self.assertEquals(r, 1L << 30)


	def testunsignedlonglongOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedlonglongOutArg_(None)
		self.assertEquals(r, 0)
		r = o.unsignedlonglongOutArg_(None)
		self.assertEquals(r, 42)
		r = o.unsignedlonglongOutArg_(None)
		self.assertEquals(r, 1L << 62)


	def testfloatOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.floatOutArg_(None)
		self.assertAlmostEquals(r, 0.128)
		r = o.floatOutArg_(None)
		self.assertAlmostEquals(r, 1.0)
		r = o.floatOutArg_(None)
		self.assertAlmostEquals(r, 42.0)
		r = o.floatOutArg_(None)
		self.assertAlmostEquals(r, 1e10)


	def testdoubleOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.doubleOutArg_(None)
		self.assertAlmostEquals(r, 0.128)
		r = o.doubleOutArg_(None)
		self.assertAlmostEquals(r, 1.0)
		r = o.doubleOutArg_(None)
		self.assertAlmostEquals(r, 42.0)
		r = o.doubleOutArg_(None)
		self.assertAlmostEquals(r, 1e10)


	def testidOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.idOutArg_(None)
		self.assertEquals(r, NSPriorDayDesignations)


	def testcharPtrOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.charPtrOutArg_(None)
		self.assertEquals(r, "hello")
		r = o.charPtrOutArg_(None)
		self.assertEquals(r, "world")
		r = o.charPtrOutArg_(None)
		self.assertEquals(r, "foobar")


	def testNSPointOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.NSPointOutArg_(None)
		self.assertEquals(r, (1, 2))
		r = o.NSPointOutArg_(None)
		self.assertEquals(r, (3, 4))


	def testNSRectOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.NSRectOutArg_(None)
		self.assertEquals(r, ((1, 2), (3, 4)))
		r = o.NSRectOutArg_(None)
		self.assertEquals(r, ((7, 8), (9, 10)))


	def teststructTestStruct1Out(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct1OutArg_(None)
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1OutArg_(None)
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct2Out(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct2OutArg_(None)
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2OutArg_(None)
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct3Out(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct3OutArg_(None)
		self.assertEquals(r, (1, 2))
		r = o.structTestStruct3OutArg_(None)
		self.assertEquals(r, (2, 4))


	def teststructTestStruct4Out(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct4OutArg_(None)
		self.assertEquals(r, (1, 1L<<60))
		r = o.structTestStruct4OutArg_(None)
		self.assertEquals(r, (2, 4))


	def teststructTestStruct5Out(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct5OutArg_(None)
		self.assertEquals(r, (1, 2.5))
		r = o.structTestStruct5OutArg_(None)
		self.assertEquals(r, (2, 4.5))


	# Pass by reference arguments (inout)

        if 0:
            def testboolInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.boolInOutArg_(NO)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = o.boolInOutArg_(YES)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)


	def testBOOLInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.BOOLInOutArg_(NO)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = o.BOOLInOutArg_(YES)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)


	def testcharInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.charInOutArg_(127)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -128)
		r = o.charInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.charInOutArg_(-128)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 127)


	def testsignedshortInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedshortInOutArg_(1 << 14)
		self.assertEquals(r[0], 1 << 14)
		self.assertEquals(r[1], -(1<<14))
		r = o.signedshortInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedshortInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedshortInOutArg_(-42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedshortInOutArg_(-(1<<14))
		self.assertEquals(r[0], -(1<<14))
		self.assertEquals(r[1], 1 << 14)


	def testsignedintInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedintInOutArg_(1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedintInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedintInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedintInOutArg_(-42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedintInOutArg_(-(1<<30))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)


	def testsignedlongInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedlongInOutArg_(1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], -(1<<30))
		r = o.signedlongInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlongInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlongInOutArg_(-42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlongInOutArg_(-(1<<30))
		self.assertEquals(r[0], -(1<<30))
		self.assertEquals(r[1], 1 << 30)


	def testsignedlonglongInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.signedlonglongInOutArg_(1L << 60)
		self.assertEquals(r[0], 1L << 60)
		self.assertEquals(r[1], -(1L << 60))
		r = o.signedlonglongInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], -42)
		r = o.signedlonglongInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = o.signedlonglongInOutArg_(-42)
		self.assertEquals(r[0], -42)
		self.assertEquals(r[1], 42)
		r = o.signedlonglongInOutArg_(-(1L << 60))
		self.assertEquals(r[0], -(1L << 60))
		self.assertEquals(r[1], 1L << 60)


	def testunsignedcharInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedcharInOutArg_(255)
		self.assertEquals(r[0], 255)
		self.assertEquals(r[1], 0)
		r = o.unsignedcharInOutArg_(128)
		self.assertEquals(r[0], 128)
		self.assertEquals(r[1], 128)
		r = o.unsignedcharInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)


	def testunsignedshortInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedshortInOutArg_(1<<14)
		self.assertEquals(r[0], 1<<14)
		self.assertEquals(r[1], 0)
		r = o.unsignedshortInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedshortInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1<<14)


	def testunsignedintInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedintInOutArg_(1 << 30)
		self.assertEquals(r[0], 1 << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedintInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedintInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)


	def testunsignedlongInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedlongInOutArg_(1L << 30)
		self.assertEquals(r[0], 1L << 30)
		self.assertEquals(r[1], 0)
		r = o.unsignedlongInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlongInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 30)


	def testunsignedlonglongInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.unsignedlonglongInOutArg_(1L << 62)
		self.assertEquals(r[0], 1L << 62)
		self.assertEquals(r[1], 0)
		r = o.unsignedlonglongInOutArg_(42)
		self.assertEquals(r[0], 42)
		self.assertEquals(r[1], 42)
		r = o.unsignedlonglongInOutArg_(0)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 62)


	def testfloatInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.floatInOutArg_(1e10)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.floatInOutArg_(42.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.floatInOutArg_(1.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.floatInOutArg_(0.128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1e10)


	def testdoubleInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.doubleInOutArg_(1e10)
		self.assertAlmostEquals(r[0], 1e10)
		self.assertAlmostEquals(r[1], 0.128)
		r = o.doubleInOutArg_(42.0)
		self.assertAlmostEquals(r[0], 42.0)
		self.assertAlmostEquals(r[1], 1.0)
		r = o.doubleInOutArg_(1.0)
		self.assertAlmostEquals(r[0], 1.0)
		self.assertAlmostEquals(r[1], 42.0)
		r = o.doubleInOutArg_(0.128)
		self.assertAlmostEquals(r[0], 0.128)
		self.assertAlmostEquals(r[1], 1e10)


	def testidInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.idInOutArg_(NSPriorDayDesignations)
		self.assertEquals(r[0], NSPriorDayDesignations)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testcharPtrInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.charPtrInOutArg_("foobar")
		self.assertEquals(r[0], "foobar")
		self.assertEquals(r[1], "hello")
		r = o.charPtrInOutArg_("world")
		self.assertEquals(r[0], "world")
		self.assertEquals(r[1], "world")
		r = o.charPtrInOutArg_("hello")
		self.assertEquals(r[0], "hello")
		self.assertEquals(r[1], "foobar")


	def testNSPointInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.NSPointInOutArg_((3, 4))
		self.assertEquals(r[0], (3, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.NSPointInOutArg_((1, 2))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (3, 4))


	def testNSRectInOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.NSRectInOutArg_(((7, 8), (9, 10)))
		self.assertEquals(r[0], ((7, 8), (9, 10)))
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = o.NSRectInOutArg_(((1, 2), (3, 4)))
		self.assertEquals(r[0], ((1, 2), (3, 4)))
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def teststructTestStruct1InOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct1InOutArg_((9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct1InOutArg_((1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct2InOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct2InOutArg_((9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[0], (9, 8, (-1, -2, -3, -4, -5)))
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = o.structTestStruct2InOutArg_((1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[0], (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def teststructTestStruct3InOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct3InOutArg_((2, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 2))
		r = o.structTestStruct3InOutArg_((1, 2))
		self.assertEquals(r[0], (1, 2))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct4InOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct4InOutArg_((2, 4))
		self.assertEquals(r[0], (2, 4))
		self.assertEquals(r[1], (1, 1L<<60))
		r = o.structTestStruct4InOutArg_((1, 1L<<60))
		self.assertEquals(r[0], (1, 1L<<60))
		self.assertEquals(r[1], (2, 4))


	def teststructTestStruct5InOut(self):
		o = PyObjC_TestClass1.alloc().init()
		self.assert_(o is not None)
		o.reset()
		r = o.structTestStruct5InOutArg_((2, 4.5))
		self.assertEquals(r[0], (2, 4.5))
		self.assertEquals(r[1], (1, 2.5))
		r = o.structTestStruct5InOutArg_((1, 2.5))
		self.assertEquals(r[0], (1, 2.5))
		self.assertEquals(r[1], (2, 4.5))


# Helper arrays
g_bool_values = (YES, NO)
g_BOOL_values = (YES, NO)
g_char_values = (-128, 0, 127)
g_signedshort_values = (-(1<<14), -42, 0, 42, 1 << 14)
g_signedint_values = (-(1<<30), -42, 0, 42, 1 << 30)
g_signedlong_values = (-(1<<30), -42, 0, 42, 1 << 30)
g_signedlonglong_values = (-(1L << 60), -42, 0, 42, 1L << 60)
g_unsignedchar_values = (0, 128, 255)
g_unsignedshort_values = (0, 42, 1<<14)
g_unsignedint_values = (0, 42, 1 << 30)
g_unsignedlong_values = (0, 42, 1L << 30)
g_unsignedlonglong_values = (0, 42, 1L << 62)
g_float_values = (0.128, 1.0, 42.0, 1e10)
g_double_values = (0.128, 1.0, 42.0, 1e10)
g_id_values = (NSPriorDayDesignations,)
g_charPtr_values = ("hello", "world", "foobar")
g_NSPoint_values = ((1, 2), (3, 4))
g_NSRect_values = (((1, 2), (3, 4)), ((7, 8), (9, 10)))
g_structTestStruct1_values = ((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
g_structTestStruct2_values = ((1, 2, (1, 2, 3, 4, 5)), (9, 8, (-1, -2, -3, -4, -5)))
g_structTestStruct3_values = ((1, 2), (2, 4))
g_structTestStruct4_values = ((1, 1L<<60), (2, 4))
g_structTestStruct5_values = ((1, 2.5), (2, 4.5))


class Python_TestClass (objc.lookUpClass("NSObject")):
	def init(self):
		self = super(Python_TestClass, self).init()
		self.reset()
		return self


	def reset(self):
		self.counter = 0


        def boolMethod(self):
                if self.counter > 2: self.reset()
                idx = self.counter
                self.counter += 1
                return g_bool_values[idx]
        boolMethod = objc.selector(boolMethod, signature="B@:")


	def BOOLMethod(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_BOOL_values[idx]
	BOOLMethod = objc.selector(BOOLMethod, signature="c@:")


	def charMethod(self):
		if self.counter > 3: self.reset()
		idx = self.counter
		self.counter += 1
		return g_char_values[idx]
	charMethod = objc.selector(charMethod, signature="c@:")


	def signedshortMethod(self):
		if self.counter > 5: self.reset()
		idx = self.counter
		self.counter += 1
		return g_signedshort_values[idx]
	signedshortMethod = objc.selector(signedshortMethod, signature="s@:")


	def signedintMethod(self):
		if self.counter > 5: self.reset()
		idx = self.counter
		self.counter += 1
		return g_signedint_values[idx]
	signedintMethod = objc.selector(signedintMethod, signature="i@:")


	def signedlongMethod(self):
		if self.counter > 5: self.reset()
		idx = self.counter
		self.counter += 1
		return g_signedlong_values[idx]
	signedlongMethod = objc.selector(signedlongMethod, signature="" + long_tp + "@:")


	def signedlonglongMethod(self):
		if self.counter > 5: self.reset()
		idx = self.counter
		self.counter += 1
		return g_signedlonglong_values[idx]
	signedlonglongMethod = objc.selector(signedlonglongMethod, signature="q@:")


	def unsignedcharMethod(self):
		if self.counter > 3: self.reset()
		idx = self.counter
		self.counter += 1
		return g_unsignedchar_values[idx]
	unsignedcharMethod = objc.selector(unsignedcharMethod, signature="C@:")


	def unsignedshortMethod(self):
		if self.counter > 3: self.reset()
		idx = self.counter
		self.counter += 1
		return g_unsignedshort_values[idx]
	unsignedshortMethod = objc.selector(unsignedshortMethod, signature="S@:")


	def unsignedintMethod(self):
		if self.counter > 3: self.reset()
		idx = self.counter
		self.counter += 1
		return g_unsignedint_values[idx]
	unsignedintMethod = objc.selector(unsignedintMethod, signature="I@:")


	def unsignedlongMethod(self):
		if self.counter > 3: self.reset()
		idx = self.counter
		self.counter += 1
		return g_unsignedlong_values[idx]
	unsignedlongMethod = objc.selector(unsignedlongMethod, signature="" + ulong_tp + "@:")


	def unsignedlonglongMethod(self):
		if self.counter > 3: self.reset()
		idx = self.counter
		self.counter += 1
		return g_unsignedlonglong_values[idx]
	unsignedlonglongMethod = objc.selector(unsignedlonglongMethod, signature="Q@:")


	def floatMethod(self):
		if self.counter > 4: self.reset()
		idx = self.counter
		self.counter += 1
		return g_float_values[idx]
	floatMethod = objc.selector(floatMethod, signature="f@:")


	def doubleMethod(self):
		if self.counter > 4: self.reset()
		idx = self.counter
		self.counter += 1
		return g_double_values[idx]
	doubleMethod = objc.selector(doubleMethod, signature="d@:")


	def idMethod(self):
		if self.counter > 1: self.reset()
		idx = self.counter
		self.counter += 1
		return g_id_values[idx]
	idMethod = objc.selector(idMethod, signature="@@:")


	def charPtrMethod(self):
		if self.counter > 3: self.reset()
		idx = self.counter
		self.counter += 1
		return g_charPtr_values[idx]
	charPtrMethod = objc.selector(charPtrMethod, signature="*@:")


	def NSPointMethod(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_NSPoint_values[idx]
	NSPointMethod = objc.selector(NSPointMethod, signature=NSPoint_tp + "@:")


	def NSRectMethod(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_NSRect_values[idx]
	NSRectMethod = objc.selector(NSRectMethod, signature=NSRect_tp + "@:")


	def structTestStruct1Method(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_structTestStruct1_values[idx]
	structTestStruct1Method = objc.selector(structTestStruct1Method, signature="{_TestStruct1=ii[5s]}@:")


	def structTestStruct2Method(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_structTestStruct2_values[idx]
	structTestStruct2Method = objc.selector(structTestStruct2Method, signature="{_TestStruct2=id[5s]}@:")


	def structTestStruct3Method(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_structTestStruct3_values[idx]
	structTestStruct3Method = objc.selector(structTestStruct3Method, signature="{_TestStruct3=ci}@:")


	def structTestStruct4Method(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_structTestStruct4_values[idx]
	structTestStruct4Method = objc.selector(structTestStruct4Method, signature="{_TestStruct4=cq}@:")


	def structTestStruct5Method(self):
		if self.counter > 2: self.reset()
		idx = self.counter
		self.counter += 1
		return g_structTestStruct5_values[idx]
	structTestStruct5Method = objc.selector(structTestStruct5Method, signature="{_TestStruct5=cd}@:")


        def boolArg_(self, arg):
                return arg # return the same
        boolArg_ = objc.selector(boolArg_, signature="@@:B")


	def BOOLArg_(self, arg):
		return arg # return the same
	BOOLArg_ = objc.selector(BOOLArg_, signature="@@:c")


	def charArg_(self, arg):
		return arg # return the same
	charArg_ = objc.selector(charArg_, signature="@@:c")


	def signedshortArg_(self, arg):
		return arg # return the same
	signedshortArg_ = objc.selector(signedshortArg_, signature="@@:s")


	def signedintArg_(self, arg):
		return arg # return the same
	signedintArg_ = objc.selector(signedintArg_, signature="@@:i")


	def signedlongArg_(self, arg):
		return arg # return the same
	signedlongArg_ = objc.selector(signedlongArg_, signature="@@:" + long_tp + "")


	def signedlonglongArg_(self, arg):
		return arg # return the same
	signedlonglongArg_ = objc.selector(signedlonglongArg_, signature="@@:q")


	def unsignedcharArg_(self, arg):
		return arg # return the same
	unsignedcharArg_ = objc.selector(unsignedcharArg_, signature="@@:C")


	def unsignedshortArg_(self, arg):
		return arg # return the same
	unsignedshortArg_ = objc.selector(unsignedshortArg_, signature="@@:S")


	def unsignedintArg_(self, arg):
		return arg # return the same
	unsignedintArg_ = objc.selector(unsignedintArg_, signature="@@:I")


	def unsignedlongArg_(self, arg):
		return arg # return the same
	unsignedlongArg_ = objc.selector(unsignedlongArg_, signature="@@:" + ulong_tp + "")


	def unsignedlonglongArg_(self, arg):
		return arg # return the same
	unsignedlonglongArg_ = objc.selector(unsignedlonglongArg_, signature="@@:Q")


	def floatArg_(self, arg):
		return arg # return the same
	floatArg_ = objc.selector(floatArg_, signature="@@:f")


	def doubleArg_(self, arg):
		return arg # return the same
	doubleArg_ = objc.selector(doubleArg_, signature="@@:d")


	def idArg_(self, arg):
		return arg # return the same
	idArg_ = objc.selector(idArg_, signature="@@:@")


	def charPtrArg_(self, arg):
            return unicode(arg) # return the unicode
	charPtrArg_ = objc.selector(charPtrArg_, signature="@@:*")


	def NSPointArg_(self, arg):
            return arg # return the same
	NSPointArg_ = objc.selector(NSPointArg_, signature="@@:" + NSPoint_tp)


	def NSRectArg_(self, arg):
		return arg # return the same
	NSRectArg_ = objc.selector(NSRectArg_, signature="@@:" + NSRect_tp)


	def structTestStruct1Arg_(self, arg):
		return arg # return the same
	structTestStruct1Arg_ = objc.selector(structTestStruct1Arg_, signature="@@:{_TestStruct1=ii[5s]}")


	def structTestStruct2Arg_(self, arg):
		return arg # return the same
	structTestStruct2Arg_ = objc.selector(structTestStruct2Arg_, signature="@@:{_TestStruct2=id[5s]}")


	def structTestStruct3Arg_(self, arg):
		return arg # return the same
	structTestStruct3Arg_ = objc.selector(structTestStruct3Arg_, signature="@@:{_TestStruct3=ci}")


	def structTestStruct4Arg_(self, arg):
		return arg # return the same
	structTestStruct4Arg_ = objc.selector(structTestStruct4Arg_, signature="@@:{_TestStruct4=cq}")


	def structTestStruct5Arg_(self, arg):
		return arg # return the same
	structTestStruct5Arg_ = objc.selector(structTestStruct5Arg_, signature="@@:{_TestStruct5=cd}")


        def boolArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andboolArg_ = objc.selector(boolArg_andboolArg_, signature="@@:BB")


        def boolArg_andBOOLArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andBOOLArg_ = objc.selector(boolArg_andBOOLArg_, signature="@@:Bc")


        def boolArg_andcharArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andcharArg_ = objc.selector(boolArg_andcharArg_, signature="@@:Bc")


        def boolArg_andsignedshortArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andsignedshortArg_ = objc.selector(boolArg_andsignedshortArg_, signature="@@:Bs")


        def boolArg_andsignedintArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andsignedintArg_ = objc.selector(boolArg_andsignedintArg_, signature="@@:Bi")


        def boolArg_andsignedlongArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andsignedlongArg_ = objc.selector(boolArg_andsignedlongArg_, signature="@@:B" + long_tp + "")


        def boolArg_andsignedlonglongArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andsignedlonglongArg_ = objc.selector(boolArg_andsignedlonglongArg_, signature="@@:Bq")


        def boolArg_andunsignedcharArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andunsignedcharArg_ = objc.selector(boolArg_andunsignedcharArg_, signature="@@:BC")


        def boolArg_andunsignedshortArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andunsignedshortArg_ = objc.selector(boolArg_andunsignedshortArg_, signature="@@:BS")


        def boolArg_andunsignedintArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andunsignedintArg_ = objc.selector(boolArg_andunsignedintArg_, signature="@@:BI")


        def boolArg_andunsignedlongArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andunsignedlongArg_ = objc.selector(boolArg_andunsignedlongArg_, signature="@@:B" + ulong_tp + "")


        def boolArg_andunsignedlonglongArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andunsignedlonglongArg_ = objc.selector(boolArg_andunsignedlonglongArg_, signature="@@:BQ")


        def boolArg_andfloatArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andfloatArg_ = objc.selector(boolArg_andfloatArg_, signature="@@:Bf")


        def boolArg_anddoubleArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_anddoubleArg_ = objc.selector(boolArg_anddoubleArg_, signature="@@:Bd")


        def boolArg_andidArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andidArg_ = objc.selector(boolArg_andidArg_, signature="@@:B@")


        def boolArg_andcharPtrArg_(self, arg1, arg2):
            arg2 = unicode(arg2)
            return [ arg1, arg2 ]
        boolArg_andcharPtrArg_ = objc.selector(boolArg_andcharPtrArg_, signature="@@:B*")


        def boolArg_andNSPointArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andNSPointArg_ = objc.selector(boolArg_andNSPointArg_, signature="@@:B" + NSPoint_tp)


        def boolArg_andNSRectArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andNSRectArg_ = objc.selector(boolArg_andNSRectArg_, signature="@@:B" + NSRect_tp)


        def boolArg_andstructTestStruct1Arg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andstructTestStruct1Arg_ = objc.selector(boolArg_andstructTestStruct1Arg_, signature="@@:B{_TestStruct1=ii[5s]}")


        def boolArg_andstructTestStruct2Arg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andstructTestStruct2Arg_ = objc.selector(boolArg_andstructTestStruct2Arg_, signature="@@:B{_TestStruct2=id[5s]}")


        def boolArg_andstructTestStruct3Arg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andstructTestStruct3Arg_ = objc.selector(boolArg_andstructTestStruct3Arg_, signature="@@:B{_TestStruct3=ci}")


        def boolArg_andstructTestStruct4Arg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andstructTestStruct4Arg_ = objc.selector(boolArg_andstructTestStruct4Arg_, signature="@@:B{_TestStruct4=cq}")


        def boolArg_andstructTestStruct5Arg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        boolArg_andstructTestStruct5Arg_ = objc.selector(boolArg_andstructTestStruct5Arg_, signature="@@:B{_TestStruct5=cd}")


        def BOOLArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        BOOLArg_andboolArg_ = objc.selector(BOOLArg_andboolArg_, signature="@@:cB")


	def BOOLArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andBOOLArg_ = objc.selector(BOOLArg_andBOOLArg_, signature="@@:cc")


	def BOOLArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andcharArg_ = objc.selector(BOOLArg_andcharArg_, signature="@@:cc")


	def BOOLArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andsignedshortArg_ = objc.selector(BOOLArg_andsignedshortArg_, signature="@@:cs")


	def BOOLArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andsignedintArg_ = objc.selector(BOOLArg_andsignedintArg_, signature="@@:ci")


	def BOOLArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andsignedlongArg_ = objc.selector(BOOLArg_andsignedlongArg_, signature="@@:c" + long_tp + "")


	def BOOLArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andsignedlonglongArg_ = objc.selector(BOOLArg_andsignedlonglongArg_, signature="@@:cq")


	def BOOLArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andunsignedcharArg_ = objc.selector(BOOLArg_andunsignedcharArg_, signature="@@:cC")


	def BOOLArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andunsignedshortArg_ = objc.selector(BOOLArg_andunsignedshortArg_, signature="@@:cS")


	def BOOLArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andunsignedintArg_ = objc.selector(BOOLArg_andunsignedintArg_, signature="@@:cI")


	def BOOLArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andunsignedlongArg_ = objc.selector(BOOLArg_andunsignedlongArg_, signature="@@:c" + ulong_tp + "")


	def BOOLArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andunsignedlonglongArg_ = objc.selector(BOOLArg_andunsignedlonglongArg_, signature="@@:cQ")


	def BOOLArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andfloatArg_ = objc.selector(BOOLArg_andfloatArg_, signature="@@:cf")


	def BOOLArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_anddoubleArg_ = objc.selector(BOOLArg_anddoubleArg_, signature="@@:cd")


	def BOOLArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andidArg_ = objc.selector(BOOLArg_andidArg_, signature="@@:c@")


	def BOOLArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	BOOLArg_andcharPtrArg_ = objc.selector(BOOLArg_andcharPtrArg_, signature="@@:c*")


	def BOOLArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andNSPointArg_ = objc.selector(BOOLArg_andNSPointArg_, signature="@@:c" + NSPoint_tp)


	def BOOLArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andNSRectArg_ = objc.selector(BOOLArg_andNSRectArg_, signature="@@:c" + NSRect_tp)


	def BOOLArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andstructTestStruct1Arg_ = objc.selector(BOOLArg_andstructTestStruct1Arg_, signature="@@:c{_TestStruct1=ii[5s]}")


	def BOOLArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andstructTestStruct2Arg_ = objc.selector(BOOLArg_andstructTestStruct2Arg_, signature="@@:c{_TestStruct2=id[5s]}")


	def BOOLArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andstructTestStruct3Arg_ = objc.selector(BOOLArg_andstructTestStruct3Arg_, signature="@@:c{_TestStruct3=ci}")


	def BOOLArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andstructTestStruct4Arg_ = objc.selector(BOOLArg_andstructTestStruct4Arg_, signature="@@:c{_TestStruct4=cq}")


	def BOOLArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	BOOLArg_andstructTestStruct5Arg_ = objc.selector(BOOLArg_andstructTestStruct5Arg_, signature="@@:c{_TestStruct5=cd}")


        def charArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        charArg_andboolArg_ = objc.selector(charArg_andboolArg_, signature="@@:cB")


	def charArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andBOOLArg_ = objc.selector(charArg_andBOOLArg_, signature="@@:cc")


	def charArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andcharArg_ = objc.selector(charArg_andcharArg_, signature="@@:cc")


	def charArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andsignedshortArg_ = objc.selector(charArg_andsignedshortArg_, signature="@@:cs")


	def charArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andsignedintArg_ = objc.selector(charArg_andsignedintArg_, signature="@@:ci")


	def charArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andsignedlongArg_ = objc.selector(charArg_andsignedlongArg_, signature="@@:c" + long_tp + "")


	def charArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andsignedlonglongArg_ = objc.selector(charArg_andsignedlonglongArg_, signature="@@:cq")


	def charArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andunsignedcharArg_ = objc.selector(charArg_andunsignedcharArg_, signature="@@:cC")


	def charArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andunsignedshortArg_ = objc.selector(charArg_andunsignedshortArg_, signature="@@:cS")


	def charArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andunsignedintArg_ = objc.selector(charArg_andunsignedintArg_, signature="@@:cI")


	def charArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andunsignedlongArg_ = objc.selector(charArg_andunsignedlongArg_, signature="@@:c" + ulong_tp + "")


	def charArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andunsignedlonglongArg_ = objc.selector(charArg_andunsignedlonglongArg_, signature="@@:cQ")


	def charArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andfloatArg_ = objc.selector(charArg_andfloatArg_, signature="@@:cf")


	def charArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_anddoubleArg_ = objc.selector(charArg_anddoubleArg_, signature="@@:cd")


	def charArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andidArg_ = objc.selector(charArg_andidArg_, signature="@@:c@")


	def charArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	charArg_andcharPtrArg_ = objc.selector(charArg_andcharPtrArg_, signature="@@:c*")


	def charArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andNSPointArg_ = objc.selector(charArg_andNSPointArg_, signature="@@:c" + NSPoint_tp)


	def charArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andNSRectArg_ = objc.selector(charArg_andNSRectArg_, signature="@@:c" + NSRect_tp)


	def charArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andstructTestStruct1Arg_ = objc.selector(charArg_andstructTestStruct1Arg_, signature="@@:c{_TestStruct1=ii[5s]}")


	def charArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andstructTestStruct2Arg_ = objc.selector(charArg_andstructTestStruct2Arg_, signature="@@:c{_TestStruct2=id[5s]}")


	def charArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andstructTestStruct3Arg_ = objc.selector(charArg_andstructTestStruct3Arg_, signature="@@:c{_TestStruct3=ci}")


	def charArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andstructTestStruct4Arg_ = objc.selector(charArg_andstructTestStruct4Arg_, signature="@@:c{_TestStruct4=cq}")


	def charArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	charArg_andstructTestStruct5Arg_ = objc.selector(charArg_andstructTestStruct5Arg_, signature="@@:c{_TestStruct5=cd}")


        def signedshortArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        signedshortArg_andboolArg_ = objc.selector(signedshortArg_andboolArg_, signature="@@:sB")


	def signedshortArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andBOOLArg_ = objc.selector(signedshortArg_andBOOLArg_, signature="@@:sc")


	def signedshortArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andcharArg_ = objc.selector(signedshortArg_andcharArg_, signature="@@:sc")


	def signedshortArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andsignedshortArg_ = objc.selector(signedshortArg_andsignedshortArg_, signature="@@:ss")


	def signedshortArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andsignedintArg_ = objc.selector(signedshortArg_andsignedintArg_, signature="@@:si")


	def signedshortArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andsignedlongArg_ = objc.selector(signedshortArg_andsignedlongArg_, signature="@@:s" + long_tp + "")


	def signedshortArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andsignedlonglongArg_ = objc.selector(signedshortArg_andsignedlonglongArg_, signature="@@:sq")


	def signedshortArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andunsignedcharArg_ = objc.selector(signedshortArg_andunsignedcharArg_, signature="@@:sC")


	def signedshortArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andunsignedshortArg_ = objc.selector(signedshortArg_andunsignedshortArg_, signature="@@:sS")


	def signedshortArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andunsignedintArg_ = objc.selector(signedshortArg_andunsignedintArg_, signature="@@:sI")


	def signedshortArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andunsignedlongArg_ = objc.selector(signedshortArg_andunsignedlongArg_, signature="@@:s" + ulong_tp + "")


	def signedshortArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andunsignedlonglongArg_ = objc.selector(signedshortArg_andunsignedlonglongArg_, signature="@@:sQ")


	def signedshortArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andfloatArg_ = objc.selector(signedshortArg_andfloatArg_, signature="@@:sf")


	def signedshortArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_anddoubleArg_ = objc.selector(signedshortArg_anddoubleArg_, signature="@@:sd")


	def signedshortArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andidArg_ = objc.selector(signedshortArg_andidArg_, signature="@@:s@")


	def signedshortArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	signedshortArg_andcharPtrArg_ = objc.selector(signedshortArg_andcharPtrArg_, signature="@@:s*")


	def signedshortArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andNSPointArg_ = objc.selector(signedshortArg_andNSPointArg_, signature="@@:s" + NSPoint_tp)


	def signedshortArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andNSRectArg_ = objc.selector(signedshortArg_andNSRectArg_, signature="@@:s" + NSRect_tp)


	def signedshortArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andstructTestStruct1Arg_ = objc.selector(signedshortArg_andstructTestStruct1Arg_, signature="@@:s{_TestStruct1=ii[5s]}")


	def signedshortArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andstructTestStruct2Arg_ = objc.selector(signedshortArg_andstructTestStruct2Arg_, signature="@@:s{_TestStruct2=id[5s]}")


	def signedshortArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andstructTestStruct3Arg_ = objc.selector(signedshortArg_andstructTestStruct3Arg_, signature="@@:s{_TestStruct3=ci}")


	def signedshortArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andstructTestStruct4Arg_ = objc.selector(signedshortArg_andstructTestStruct4Arg_, signature="@@:s{_TestStruct4=cq}")


	def signedshortArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedshortArg_andstructTestStruct5Arg_ = objc.selector(signedshortArg_andstructTestStruct5Arg_, signature="@@:s{_TestStruct5=cd}")


        def signedintArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        signedintArg_andboolArg_ = objc.selector(signedintArg_andboolArg_, signature="@@:iB")


	def signedintArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andBOOLArg_ = objc.selector(signedintArg_andBOOLArg_, signature="@@:ic")


	def signedintArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andcharArg_ = objc.selector(signedintArg_andcharArg_, signature="@@:ic")


	def signedintArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andsignedshortArg_ = objc.selector(signedintArg_andsignedshortArg_, signature="@@:is")


	def signedintArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andsignedintArg_ = objc.selector(signedintArg_andsignedintArg_, signature="@@:ii")


	def signedintArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andsignedlongArg_ = objc.selector(signedintArg_andsignedlongArg_, signature="@@:i" + long_tp + "")


	def signedintArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andsignedlonglongArg_ = objc.selector(signedintArg_andsignedlonglongArg_, signature="@@:iq")


	def signedintArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andunsignedcharArg_ = objc.selector(signedintArg_andunsignedcharArg_, signature="@@:iC")


	def signedintArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andunsignedshortArg_ = objc.selector(signedintArg_andunsignedshortArg_, signature="@@:iS")


	def signedintArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andunsignedintArg_ = objc.selector(signedintArg_andunsignedintArg_, signature="@@:iI")


	def signedintArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andunsignedlongArg_ = objc.selector(signedintArg_andunsignedlongArg_, signature="@@:i" + ulong_tp + "")


	def signedintArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andunsignedlonglongArg_ = objc.selector(signedintArg_andunsignedlonglongArg_, signature="@@:iQ")


	def signedintArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andfloatArg_ = objc.selector(signedintArg_andfloatArg_, signature="@@:if")


	def signedintArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_anddoubleArg_ = objc.selector(signedintArg_anddoubleArg_, signature="@@:id")


	def signedintArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andidArg_ = objc.selector(signedintArg_andidArg_, signature="@@:i@")


	def signedintArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	signedintArg_andcharPtrArg_ = objc.selector(signedintArg_andcharPtrArg_, signature="@@:i*")


	def signedintArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andNSPointArg_ = objc.selector(signedintArg_andNSPointArg_, signature="@@:i" + NSPoint_tp)


	def signedintArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andNSRectArg_ = objc.selector(signedintArg_andNSRectArg_, signature="@@:i" + NSRect_tp)


	def signedintArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andstructTestStruct1Arg_ = objc.selector(signedintArg_andstructTestStruct1Arg_, signature="@@:i{_TestStruct1=ii[5s]}")


	def signedintArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andstructTestStruct2Arg_ = objc.selector(signedintArg_andstructTestStruct2Arg_, signature="@@:i{_TestStruct2=id[5s]}")


	def signedintArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andstructTestStruct3Arg_ = objc.selector(signedintArg_andstructTestStruct3Arg_, signature="@@:i{_TestStruct3=ci}")


	def signedintArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andstructTestStruct4Arg_ = objc.selector(signedintArg_andstructTestStruct4Arg_, signature="@@:i{_TestStruct4=cq}")


	def signedintArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedintArg_andstructTestStruct5Arg_ = objc.selector(signedintArg_andstructTestStruct5Arg_, signature="@@:i{_TestStruct5=cd}")


        def signedlongArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        signedlongArg_andboolArg_ = objc.selector(signedlongArg_andboolArg_, signature="@@:" + long_tp + "B")


	def signedlongArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andBOOLArg_ = objc.selector(signedlongArg_andBOOLArg_, signature="@@:" + long_tp + "c")


	def signedlongArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andcharArg_ = objc.selector(signedlongArg_andcharArg_, signature="@@:" + long_tp + "c")


	def signedlongArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andsignedshortArg_ = objc.selector(signedlongArg_andsignedshortArg_, signature="@@:" + long_tp + "s")


	def signedlongArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andsignedintArg_ = objc.selector(signedlongArg_andsignedintArg_, signature="@@:" + long_tp + "i")


	def signedlongArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andsignedlongArg_ = objc.selector(signedlongArg_andsignedlongArg_, signature="@@:" + long_tp + "" + long_tp + "")


	def signedlongArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andsignedlonglongArg_ = objc.selector(signedlongArg_andsignedlonglongArg_, signature="@@:" + long_tp + "q")


	def signedlongArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andunsignedcharArg_ = objc.selector(signedlongArg_andunsignedcharArg_, signature="@@:" + long_tp + "C")


	def signedlongArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andunsignedshortArg_ = objc.selector(signedlongArg_andunsignedshortArg_, signature="@@:" + long_tp + "S")


	def signedlongArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andunsignedintArg_ = objc.selector(signedlongArg_andunsignedintArg_, signature="@@:" + long_tp + "I")


	def signedlongArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andunsignedlongArg_ = objc.selector(signedlongArg_andunsignedlongArg_, signature="@@:" + long_tp + "" + ulong_tp + "")


	def signedlongArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andunsignedlonglongArg_ = objc.selector(signedlongArg_andunsignedlonglongArg_, signature="@@:" + long_tp + "Q")


	def signedlongArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andfloatArg_ = objc.selector(signedlongArg_andfloatArg_, signature="@@:" + long_tp + "f")


	def signedlongArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_anddoubleArg_ = objc.selector(signedlongArg_anddoubleArg_, signature="@@:" + long_tp + "d")


	def signedlongArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andidArg_ = objc.selector(signedlongArg_andidArg_, signature="@@:" + long_tp + "@")


	def signedlongArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	signedlongArg_andcharPtrArg_ = objc.selector(signedlongArg_andcharPtrArg_, signature="@@:" + long_tp + "*")


	def signedlongArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andNSPointArg_ = objc.selector(signedlongArg_andNSPointArg_, signature="@@:" + long_tp + "" + NSPoint_tp)


	def signedlongArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andNSRectArg_ = objc.selector(signedlongArg_andNSRectArg_, signature="@@:" + long_tp + "" + NSRect_tp)


	def signedlongArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andstructTestStruct1Arg_ = objc.selector(signedlongArg_andstructTestStruct1Arg_, signature="@@:" + long_tp + "{_TestStruct1=ii[5s]}")


	def signedlongArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andstructTestStruct2Arg_ = objc.selector(signedlongArg_andstructTestStruct2Arg_, signature="@@:" + long_tp + "{_TestStruct2=id[5s]}")


	def signedlongArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andstructTestStruct3Arg_ = objc.selector(signedlongArg_andstructTestStruct3Arg_, signature="@@:" + long_tp + "{_TestStruct3=ci}")


	def signedlongArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andstructTestStruct4Arg_ = objc.selector(signedlongArg_andstructTestStruct4Arg_, signature="@@:" + long_tp + "{_TestStruct4=cq}")


	def signedlongArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlongArg_andstructTestStruct5Arg_ = objc.selector(signedlongArg_andstructTestStruct5Arg_, signature="@@:" + long_tp + "{_TestStruct5=cd}")


        def signedlonglongArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        signedlonglongArg_andboolArg_ = objc.selector(signedlonglongArg_andboolArg_, signature="@@:qB")


	def signedlonglongArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andBOOLArg_ = objc.selector(signedlonglongArg_andBOOLArg_, signature="@@:qc")


	def signedlonglongArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andcharArg_ = objc.selector(signedlonglongArg_andcharArg_, signature="@@:qc")


	def signedlonglongArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andsignedshortArg_ = objc.selector(signedlonglongArg_andsignedshortArg_, signature="@@:qs")


	def signedlonglongArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andsignedintArg_ = objc.selector(signedlonglongArg_andsignedintArg_, signature="@@:qi")


	def signedlonglongArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andsignedlongArg_ = objc.selector(signedlonglongArg_andsignedlongArg_, signature="@@:q" + long_tp + "")


	def signedlonglongArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andsignedlonglongArg_ = objc.selector(signedlonglongArg_andsignedlonglongArg_, signature="@@:qq")


	def signedlonglongArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andunsignedcharArg_ = objc.selector(signedlonglongArg_andunsignedcharArg_, signature="@@:qC")


	def signedlonglongArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andunsignedshortArg_ = objc.selector(signedlonglongArg_andunsignedshortArg_, signature="@@:qS")


	def signedlonglongArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andunsignedintArg_ = objc.selector(signedlonglongArg_andunsignedintArg_, signature="@@:qI")


	def signedlonglongArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andunsignedlongArg_ = objc.selector(signedlonglongArg_andunsignedlongArg_, signature="@@:q" + ulong_tp + "")


	def signedlonglongArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andunsignedlonglongArg_ = objc.selector(signedlonglongArg_andunsignedlonglongArg_, signature="@@:qQ")


	def signedlonglongArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andfloatArg_ = objc.selector(signedlonglongArg_andfloatArg_, signature="@@:qf")


	def signedlonglongArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_anddoubleArg_ = objc.selector(signedlonglongArg_anddoubleArg_, signature="@@:qd")


	def signedlonglongArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andidArg_ = objc.selector(signedlonglongArg_andidArg_, signature="@@:q@")


	def signedlonglongArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	signedlonglongArg_andcharPtrArg_ = objc.selector(signedlonglongArg_andcharPtrArg_, signature="@@:q*")


	def signedlonglongArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andNSPointArg_ = objc.selector(signedlonglongArg_andNSPointArg_, signature="@@:q" + NSPoint_tp)


	def signedlonglongArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andNSRectArg_ = objc.selector(signedlonglongArg_andNSRectArg_, signature="@@:q" + NSRect_tp)


	def signedlonglongArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andstructTestStruct1Arg_ = objc.selector(signedlonglongArg_andstructTestStruct1Arg_, signature="@@:q{_TestStruct1=ii[5s]}")


	def signedlonglongArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andstructTestStruct2Arg_ = objc.selector(signedlonglongArg_andstructTestStruct2Arg_, signature="@@:q{_TestStruct2=id[5s]}")


	def signedlonglongArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andstructTestStruct3Arg_ = objc.selector(signedlonglongArg_andstructTestStruct3Arg_, signature="@@:q{_TestStruct3=ci}")


	def signedlonglongArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andstructTestStruct4Arg_ = objc.selector(signedlonglongArg_andstructTestStruct4Arg_, signature="@@:q{_TestStruct4=cq}")


	def signedlonglongArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	signedlonglongArg_andstructTestStruct5Arg_ = objc.selector(signedlonglongArg_andstructTestStruct5Arg_, signature="@@:q{_TestStruct5=cd}")


        def unsignedcharArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        unsignedcharArg_andboolArg_ = objc.selector(unsignedcharArg_andboolArg_, signature="@@:CB")


	def unsignedcharArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andBOOLArg_ = objc.selector(unsignedcharArg_andBOOLArg_, signature="@@:Cc")


	def unsignedcharArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andcharArg_ = objc.selector(unsignedcharArg_andcharArg_, signature="@@:Cc")


	def unsignedcharArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andsignedshortArg_ = objc.selector(unsignedcharArg_andsignedshortArg_, signature="@@:Cs")


	def unsignedcharArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andsignedintArg_ = objc.selector(unsignedcharArg_andsignedintArg_, signature="@@:Ci")


	def unsignedcharArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andsignedlongArg_ = objc.selector(unsignedcharArg_andsignedlongArg_, signature="@@:C" + long_tp + "")


	def unsignedcharArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andsignedlonglongArg_ = objc.selector(unsignedcharArg_andsignedlonglongArg_, signature="@@:Cq")


	def unsignedcharArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andunsignedcharArg_ = objc.selector(unsignedcharArg_andunsignedcharArg_, signature="@@:CC")


	def unsignedcharArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andunsignedshortArg_ = objc.selector(unsignedcharArg_andunsignedshortArg_, signature="@@:CS")


	def unsignedcharArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andunsignedintArg_ = objc.selector(unsignedcharArg_andunsignedintArg_, signature="@@:CI")


	def unsignedcharArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andunsignedlongArg_ = objc.selector(unsignedcharArg_andunsignedlongArg_, signature="@@:C" + ulong_tp + "")


	def unsignedcharArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andunsignedlonglongArg_ = objc.selector(unsignedcharArg_andunsignedlonglongArg_, signature="@@:CQ")


	def unsignedcharArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andfloatArg_ = objc.selector(unsignedcharArg_andfloatArg_, signature="@@:Cf")


	def unsignedcharArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_anddoubleArg_ = objc.selector(unsignedcharArg_anddoubleArg_, signature="@@:Cd")


	def unsignedcharArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andidArg_ = objc.selector(unsignedcharArg_andidArg_, signature="@@:C@")


	def unsignedcharArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	unsignedcharArg_andcharPtrArg_ = objc.selector(unsignedcharArg_andcharPtrArg_, signature="@@:C*")


	def unsignedcharArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andNSPointArg_ = objc.selector(unsignedcharArg_andNSPointArg_, signature="@@:C" + NSPoint_tp)


	def unsignedcharArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andNSRectArg_ = objc.selector(unsignedcharArg_andNSRectArg_, signature="@@:C" + NSRect_tp)


	def unsignedcharArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andstructTestStruct1Arg_ = objc.selector(unsignedcharArg_andstructTestStruct1Arg_, signature="@@:C{_TestStruct1=ii[5s]}")


	def unsignedcharArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andstructTestStruct2Arg_ = objc.selector(unsignedcharArg_andstructTestStruct2Arg_, signature="@@:C{_TestStruct2=id[5s]}")


	def unsignedcharArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andstructTestStruct3Arg_ = objc.selector(unsignedcharArg_andstructTestStruct3Arg_, signature="@@:C{_TestStruct3=ci}")


	def unsignedcharArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andstructTestStruct4Arg_ = objc.selector(unsignedcharArg_andstructTestStruct4Arg_, signature="@@:C{_TestStruct4=cq}")


	def unsignedcharArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedcharArg_andstructTestStruct5Arg_ = objc.selector(unsignedcharArg_andstructTestStruct5Arg_, signature="@@:C{_TestStruct5=cd}")


        def unsignedshortArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        unsignedshortArg_andboolArg_ = objc.selector(unsignedshortArg_andboolArg_, signature="@@:SB")


	def unsignedshortArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andBOOLArg_ = objc.selector(unsignedshortArg_andBOOLArg_, signature="@@:Sc")


	def unsignedshortArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andcharArg_ = objc.selector(unsignedshortArg_andcharArg_, signature="@@:Sc")


	def unsignedshortArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andsignedshortArg_ = objc.selector(unsignedshortArg_andsignedshortArg_, signature="@@:Ss")


	def unsignedshortArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andsignedintArg_ = objc.selector(unsignedshortArg_andsignedintArg_, signature="@@:Si")


	def unsignedshortArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andsignedlongArg_ = objc.selector(unsignedshortArg_andsignedlongArg_, signature="@@:S" + long_tp + "")


	def unsignedshortArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andsignedlonglongArg_ = objc.selector(unsignedshortArg_andsignedlonglongArg_, signature="@@:Sq")


	def unsignedshortArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andunsignedcharArg_ = objc.selector(unsignedshortArg_andunsignedcharArg_, signature="@@:SC")


	def unsignedshortArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andunsignedshortArg_ = objc.selector(unsignedshortArg_andunsignedshortArg_, signature="@@:SS")


	def unsignedshortArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andunsignedintArg_ = objc.selector(unsignedshortArg_andunsignedintArg_, signature="@@:SI")


	def unsignedshortArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andunsignedlongArg_ = objc.selector(unsignedshortArg_andunsignedlongArg_, signature="@@:S" + ulong_tp + "")


	def unsignedshortArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andunsignedlonglongArg_ = objc.selector(unsignedshortArg_andunsignedlonglongArg_, signature="@@:SQ")


	def unsignedshortArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andfloatArg_ = objc.selector(unsignedshortArg_andfloatArg_, signature="@@:Sf")


	def unsignedshortArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_anddoubleArg_ = objc.selector(unsignedshortArg_anddoubleArg_, signature="@@:Sd")


	def unsignedshortArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andidArg_ = objc.selector(unsignedshortArg_andidArg_, signature="@@:S@")


	def unsignedshortArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	unsignedshortArg_andcharPtrArg_ = objc.selector(unsignedshortArg_andcharPtrArg_, signature="@@:S*")


	def unsignedshortArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andNSPointArg_ = objc.selector(unsignedshortArg_andNSPointArg_, signature="@@:S" + NSPoint_tp)


	def unsignedshortArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andNSRectArg_ = objc.selector(unsignedshortArg_andNSRectArg_, signature="@@:S" + NSRect_tp)


	def unsignedshortArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andstructTestStruct1Arg_ = objc.selector(unsignedshortArg_andstructTestStruct1Arg_, signature="@@:S{_TestStruct1=ii[5s]}")


	def unsignedshortArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andstructTestStruct2Arg_ = objc.selector(unsignedshortArg_andstructTestStruct2Arg_, signature="@@:S{_TestStruct2=id[5s]}")


	def unsignedshortArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andstructTestStruct3Arg_ = objc.selector(unsignedshortArg_andstructTestStruct3Arg_, signature="@@:S{_TestStruct3=ci}")


	def unsignedshortArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andstructTestStruct4Arg_ = objc.selector(unsignedshortArg_andstructTestStruct4Arg_, signature="@@:S{_TestStruct4=cq}")


	def unsignedshortArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedshortArg_andstructTestStruct5Arg_ = objc.selector(unsignedshortArg_andstructTestStruct5Arg_, signature="@@:S{_TestStruct5=cd}")


        def unsignedintArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        unsignedintArg_andboolArg_ = objc.selector(unsignedintArg_andboolArg_, signature="@@:IB")


	def unsignedintArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andBOOLArg_ = objc.selector(unsignedintArg_andBOOLArg_, signature="@@:Ic")


	def unsignedintArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andcharArg_ = objc.selector(unsignedintArg_andcharArg_, signature="@@:Ic")


	def unsignedintArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andsignedshortArg_ = objc.selector(unsignedintArg_andsignedshortArg_, signature="@@:Is")


	def unsignedintArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andsignedintArg_ = objc.selector(unsignedintArg_andsignedintArg_, signature="@@:Ii")


	def unsignedintArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andsignedlongArg_ = objc.selector(unsignedintArg_andsignedlongArg_, signature="@@:I" + long_tp + "")


	def unsignedintArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andsignedlonglongArg_ = objc.selector(unsignedintArg_andsignedlonglongArg_, signature="@@:Iq")


	def unsignedintArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andunsignedcharArg_ = objc.selector(unsignedintArg_andunsignedcharArg_, signature="@@:IC")


	def unsignedintArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andunsignedshortArg_ = objc.selector(unsignedintArg_andunsignedshortArg_, signature="@@:IS")


	def unsignedintArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andunsignedintArg_ = objc.selector(unsignedintArg_andunsignedintArg_, signature="@@:II")


	def unsignedintArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andunsignedlongArg_ = objc.selector(unsignedintArg_andunsignedlongArg_, signature="@@:I" + ulong_tp + "")


	def unsignedintArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andunsignedlonglongArg_ = objc.selector(unsignedintArg_andunsignedlonglongArg_, signature="@@:IQ")


	def unsignedintArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andfloatArg_ = objc.selector(unsignedintArg_andfloatArg_, signature="@@:If")


	def unsignedintArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_anddoubleArg_ = objc.selector(unsignedintArg_anddoubleArg_, signature="@@:Id")


	def unsignedintArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andidArg_ = objc.selector(unsignedintArg_andidArg_, signature="@@:I@")


	def unsignedintArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	unsignedintArg_andcharPtrArg_ = objc.selector(unsignedintArg_andcharPtrArg_, signature="@@:I*")


	def unsignedintArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andNSPointArg_ = objc.selector(unsignedintArg_andNSPointArg_, signature="@@:I" + NSPoint_tp)


	def unsignedintArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andNSRectArg_ = objc.selector(unsignedintArg_andNSRectArg_, signature="@@:I" + NSRect_tp)


	def unsignedintArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andstructTestStruct1Arg_ = objc.selector(unsignedintArg_andstructTestStruct1Arg_, signature="@@:I{_TestStruct1=ii[5s]}")


	def unsignedintArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andstructTestStruct2Arg_ = objc.selector(unsignedintArg_andstructTestStruct2Arg_, signature="@@:I{_TestStruct2=id[5s]}")


	def unsignedintArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andstructTestStruct3Arg_ = objc.selector(unsignedintArg_andstructTestStruct3Arg_, signature="@@:I{_TestStruct3=ci}")


	def unsignedintArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andstructTestStruct4Arg_ = objc.selector(unsignedintArg_andstructTestStruct4Arg_, signature="@@:I{_TestStruct4=cq}")


	def unsignedintArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedintArg_andstructTestStruct5Arg_ = objc.selector(unsignedintArg_andstructTestStruct5Arg_, signature="@@:I{_TestStruct5=cd}")


        def unsignedlongArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        unsignedlongArg_andboolArg_ = objc.selector(unsignedlongArg_andboolArg_, signature="@@:" + ulong_tp + "B")


	def unsignedlongArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andBOOLArg_ = objc.selector(unsignedlongArg_andBOOLArg_, signature="@@:" + ulong_tp + "c")


	def unsignedlongArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andcharArg_ = objc.selector(unsignedlongArg_andcharArg_, signature="@@:" + ulong_tp + "c")


	def unsignedlongArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andsignedshortArg_ = objc.selector(unsignedlongArg_andsignedshortArg_, signature="@@:" + ulong_tp + "s")


	def unsignedlongArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andsignedintArg_ = objc.selector(unsignedlongArg_andsignedintArg_, signature="@@:" + ulong_tp + "i")


	def unsignedlongArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andsignedlongArg_ = objc.selector(unsignedlongArg_andsignedlongArg_, signature="@@:" + ulong_tp + "" + long_tp + "")


	def unsignedlongArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andsignedlonglongArg_ = objc.selector(unsignedlongArg_andsignedlonglongArg_, signature="@@:" + ulong_tp + "q")


	def unsignedlongArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andunsignedcharArg_ = objc.selector(unsignedlongArg_andunsignedcharArg_, signature="@@:" + ulong_tp + "C")


	def unsignedlongArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andunsignedshortArg_ = objc.selector(unsignedlongArg_andunsignedshortArg_, signature="@@:" + ulong_tp + "S")


	def unsignedlongArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andunsignedintArg_ = objc.selector(unsignedlongArg_andunsignedintArg_, signature="@@:" + ulong_tp + "I")


	def unsignedlongArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andunsignedlongArg_ = objc.selector(unsignedlongArg_andunsignedlongArg_, signature="@@:" + ulong_tp + "" + ulong_tp + "")


	def unsignedlongArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andunsignedlonglongArg_ = objc.selector(unsignedlongArg_andunsignedlonglongArg_, signature="@@:" + ulong_tp + "Q")


	def unsignedlongArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andfloatArg_ = objc.selector(unsignedlongArg_andfloatArg_, signature="@@:" + ulong_tp + "f")


	def unsignedlongArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_anddoubleArg_ = objc.selector(unsignedlongArg_anddoubleArg_, signature="@@:" + ulong_tp + "d")


	def unsignedlongArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andidArg_ = objc.selector(unsignedlongArg_andidArg_, signature="@@:" + ulong_tp + "@")


	def unsignedlongArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	unsignedlongArg_andcharPtrArg_ = objc.selector(unsignedlongArg_andcharPtrArg_, signature="@@:" + ulong_tp + "*")


	def unsignedlongArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andNSPointArg_ = objc.selector(unsignedlongArg_andNSPointArg_, signature="@@:" + ulong_tp + "" + NSPoint_tp)


	def unsignedlongArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andNSRectArg_ = objc.selector(unsignedlongArg_andNSRectArg_, signature="@@:" + ulong_tp + "" +  NSRect_tp)


	def unsignedlongArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andstructTestStruct1Arg_ = objc.selector(unsignedlongArg_andstructTestStruct1Arg_, signature="@@:" + ulong_tp + "{_TestStruct1=ii[5s]}")


	def unsignedlongArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andstructTestStruct2Arg_ = objc.selector(unsignedlongArg_andstructTestStruct2Arg_, signature="@@:" + ulong_tp + "{_TestStruct2=id[5s]}")


	def unsignedlongArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andstructTestStruct3Arg_ = objc.selector(unsignedlongArg_andstructTestStruct3Arg_, signature="@@:" + ulong_tp + "{_TestStruct3=ci}")


	def unsignedlongArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andstructTestStruct4Arg_ = objc.selector(unsignedlongArg_andstructTestStruct4Arg_, signature="@@:" + ulong_tp + "{_TestStruct4=cq}")


	def unsignedlongArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlongArg_andstructTestStruct5Arg_ = objc.selector(unsignedlongArg_andstructTestStruct5Arg_, signature="@@:" + ulong_tp + "{_TestStruct5=cd}")


        def unsignedlonglongArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        unsignedlonglongArg_andboolArg_ = objc.selector(unsignedlonglongArg_andboolArg_, signature="@@:QB")


	def unsignedlonglongArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andBOOLArg_ = objc.selector(unsignedlonglongArg_andBOOLArg_, signature="@@:Qc")


	def unsignedlonglongArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andcharArg_ = objc.selector(unsignedlonglongArg_andcharArg_, signature="@@:Qc")


	def unsignedlonglongArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andsignedshortArg_ = objc.selector(unsignedlonglongArg_andsignedshortArg_, signature="@@:Qs")


	def unsignedlonglongArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andsignedintArg_ = objc.selector(unsignedlonglongArg_andsignedintArg_, signature="@@:Qi")


	def unsignedlonglongArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andsignedlongArg_ = objc.selector(unsignedlonglongArg_andsignedlongArg_, signature="@@:Q" + long_tp + "")


	def unsignedlonglongArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andsignedlonglongArg_ = objc.selector(unsignedlonglongArg_andsignedlonglongArg_, signature="@@:Qq")


	def unsignedlonglongArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andunsignedcharArg_ = objc.selector(unsignedlonglongArg_andunsignedcharArg_, signature="@@:QC")


	def unsignedlonglongArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andunsignedshortArg_ = objc.selector(unsignedlonglongArg_andunsignedshortArg_, signature="@@:QS")


	def unsignedlonglongArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andunsignedintArg_ = objc.selector(unsignedlonglongArg_andunsignedintArg_, signature="@@:QI")


	def unsignedlonglongArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andunsignedlongArg_ = objc.selector(unsignedlonglongArg_andunsignedlongArg_, signature="@@:Q" + ulong_tp + "")


	def unsignedlonglongArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andunsignedlonglongArg_ = objc.selector(unsignedlonglongArg_andunsignedlonglongArg_, signature="@@:QQ")


	def unsignedlonglongArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andfloatArg_ = objc.selector(unsignedlonglongArg_andfloatArg_, signature="@@:Qf")


	def unsignedlonglongArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_anddoubleArg_ = objc.selector(unsignedlonglongArg_anddoubleArg_, signature="@@:Qd")


	def unsignedlonglongArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andidArg_ = objc.selector(unsignedlonglongArg_andidArg_, signature="@@:Q@")


	def unsignedlonglongArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	unsignedlonglongArg_andcharPtrArg_ = objc.selector(unsignedlonglongArg_andcharPtrArg_, signature="@@:Q*")


	def unsignedlonglongArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andNSPointArg_ = objc.selector(unsignedlonglongArg_andNSPointArg_, signature="@@:Q" + NSPoint_tp)


	def unsignedlonglongArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andNSRectArg_ = objc.selector(unsignedlonglongArg_andNSRectArg_, signature="@@:Q" + NSRect_tp)


	def unsignedlonglongArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andstructTestStruct1Arg_ = objc.selector(unsignedlonglongArg_andstructTestStruct1Arg_, signature="@@:Q{_TestStruct1=ii[5s]}")


	def unsignedlonglongArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andstructTestStruct2Arg_ = objc.selector(unsignedlonglongArg_andstructTestStruct2Arg_, signature="@@:Q{_TestStruct2=id[5s]}")


	def unsignedlonglongArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andstructTestStruct3Arg_ = objc.selector(unsignedlonglongArg_andstructTestStruct3Arg_, signature="@@:Q{_TestStruct3=ci}")


	def unsignedlonglongArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andstructTestStruct4Arg_ = objc.selector(unsignedlonglongArg_andstructTestStruct4Arg_, signature="@@:Q{_TestStruct4=cq}")


	def unsignedlonglongArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	unsignedlonglongArg_andstructTestStruct5Arg_ = objc.selector(unsignedlonglongArg_andstructTestStruct5Arg_, signature="@@:Q{_TestStruct5=cd}")


        def floatArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        floatArg_andboolArg_ = objc.selector(floatArg_andboolArg_, signature="@@:fB")


	def floatArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andBOOLArg_ = objc.selector(floatArg_andBOOLArg_, signature="@@:fc")


	def floatArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andcharArg_ = objc.selector(floatArg_andcharArg_, signature="@@:fc")


	def floatArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andsignedshortArg_ = objc.selector(floatArg_andsignedshortArg_, signature="@@:fs")


	def floatArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andsignedintArg_ = objc.selector(floatArg_andsignedintArg_, signature="@@:fi")


	def floatArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andsignedlongArg_ = objc.selector(floatArg_andsignedlongArg_, signature="@@:f" + long_tp + "")


	def floatArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andsignedlonglongArg_ = objc.selector(floatArg_andsignedlonglongArg_, signature="@@:fq")


	def floatArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andunsignedcharArg_ = objc.selector(floatArg_andunsignedcharArg_, signature="@@:fC")


	def floatArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andunsignedshortArg_ = objc.selector(floatArg_andunsignedshortArg_, signature="@@:fS")


	def floatArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andunsignedintArg_ = objc.selector(floatArg_andunsignedintArg_, signature="@@:fI")


	def floatArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andunsignedlongArg_ = objc.selector(floatArg_andunsignedlongArg_, signature="@@:f" + ulong_tp + "")


	def floatArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andunsignedlonglongArg_ = objc.selector(floatArg_andunsignedlonglongArg_, signature="@@:fQ")


	def floatArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andfloatArg_ = objc.selector(floatArg_andfloatArg_, signature="@@:ff")


	def floatArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_anddoubleArg_ = objc.selector(floatArg_anddoubleArg_, signature="@@:fd")


	def floatArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andidArg_ = objc.selector(floatArg_andidArg_, signature="@@:f@")


	def floatArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	floatArg_andcharPtrArg_ = objc.selector(floatArg_andcharPtrArg_, signature="@@:f*")


	def floatArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andNSPointArg_ = objc.selector(floatArg_andNSPointArg_, signature="@@:f" + NSPoint_tp)


	def floatArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andNSRectArg_ = objc.selector(floatArg_andNSRectArg_, signature="@@:f" + NSRect_tp)


	def floatArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andstructTestStruct1Arg_ = objc.selector(floatArg_andstructTestStruct1Arg_, signature="@@:f{_TestStruct1=ii[5s]}")


	def floatArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andstructTestStruct2Arg_ = objc.selector(floatArg_andstructTestStruct2Arg_, signature="@@:f{_TestStruct2=id[5s]}")


	def floatArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andstructTestStruct3Arg_ = objc.selector(floatArg_andstructTestStruct3Arg_, signature="@@:f{_TestStruct3=ci}")


	def floatArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andstructTestStruct4Arg_ = objc.selector(floatArg_andstructTestStruct4Arg_, signature="@@:f{_TestStruct4=cq}")


	def floatArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	floatArg_andstructTestStruct5Arg_ = objc.selector(floatArg_andstructTestStruct5Arg_, signature="@@:f{_TestStruct5=cd}")


        def doubleArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        doubleArg_andboolArg_ = objc.selector(doubleArg_andboolArg_, signature="@@:dB")


	def doubleArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andBOOLArg_ = objc.selector(doubleArg_andBOOLArg_, signature="@@:dc")


	def doubleArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andcharArg_ = objc.selector(doubleArg_andcharArg_, signature="@@:dc")


	def doubleArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andsignedshortArg_ = objc.selector(doubleArg_andsignedshortArg_, signature="@@:ds")


	def doubleArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andsignedintArg_ = objc.selector(doubleArg_andsignedintArg_, signature="@@:di")


	def doubleArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andsignedlongArg_ = objc.selector(doubleArg_andsignedlongArg_, signature="@@:d" + long_tp + "")


	def doubleArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andsignedlonglongArg_ = objc.selector(doubleArg_andsignedlonglongArg_, signature="@@:dq")


	def doubleArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andunsignedcharArg_ = objc.selector(doubleArg_andunsignedcharArg_, signature="@@:dC")


	def doubleArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andunsignedshortArg_ = objc.selector(doubleArg_andunsignedshortArg_, signature="@@:dS")


	def doubleArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andunsignedintArg_ = objc.selector(doubleArg_andunsignedintArg_, signature="@@:dI")


	def doubleArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andunsignedlongArg_ = objc.selector(doubleArg_andunsignedlongArg_, signature="@@:d" + ulong_tp + "")


	def doubleArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andunsignedlonglongArg_ = objc.selector(doubleArg_andunsignedlonglongArg_, signature="@@:dQ")


	def doubleArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andfloatArg_ = objc.selector(doubleArg_andfloatArg_, signature="@@:df")


	def doubleArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_anddoubleArg_ = objc.selector(doubleArg_anddoubleArg_, signature="@@:dd")


	def doubleArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andidArg_ = objc.selector(doubleArg_andidArg_, signature="@@:d@")


	def doubleArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	doubleArg_andcharPtrArg_ = objc.selector(doubleArg_andcharPtrArg_, signature="@@:d*")


	def doubleArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andNSPointArg_ = objc.selector(doubleArg_andNSPointArg_, signature="@@:d" + NSPoint_tp)


	def doubleArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andNSRectArg_ = objc.selector(doubleArg_andNSRectArg_, signature="@@:d" + NSRect_tp)


	def doubleArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andstructTestStruct1Arg_ = objc.selector(doubleArg_andstructTestStruct1Arg_, signature="@@:d{_TestStruct1=ii[5s]}")


	def doubleArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andstructTestStruct2Arg_ = objc.selector(doubleArg_andstructTestStruct2Arg_, signature="@@:d{_TestStruct2=id[5s]}")


	def doubleArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andstructTestStruct3Arg_ = objc.selector(doubleArg_andstructTestStruct3Arg_, signature="@@:d{_TestStruct3=ci}")


	def doubleArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andstructTestStruct4Arg_ = objc.selector(doubleArg_andstructTestStruct4Arg_, signature="@@:d{_TestStruct4=cq}")


	def doubleArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	doubleArg_andstructTestStruct5Arg_ = objc.selector(doubleArg_andstructTestStruct5Arg_, signature="@@:d{_TestStruct5=cd}")


        def idArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        idArg_andboolArg_ = objc.selector(idArg_andboolArg_, signature="@@:@B")


	def idArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andBOOLArg_ = objc.selector(idArg_andBOOLArg_, signature="@@:@c")


	def idArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andcharArg_ = objc.selector(idArg_andcharArg_, signature="@@:@c")


	def idArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andsignedshortArg_ = objc.selector(idArg_andsignedshortArg_, signature="@@:@s")


	def idArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andsignedintArg_ = objc.selector(idArg_andsignedintArg_, signature="@@:@i")


	def idArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andsignedlongArg_ = objc.selector(idArg_andsignedlongArg_, signature="@@:@" + long_tp + "")


	def idArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andsignedlonglongArg_ = objc.selector(idArg_andsignedlonglongArg_, signature="@@:@q")


	def idArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andunsignedcharArg_ = objc.selector(idArg_andunsignedcharArg_, signature="@@:@C")


	def idArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andunsignedshortArg_ = objc.selector(idArg_andunsignedshortArg_, signature="@@:@S")


	def idArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andunsignedintArg_ = objc.selector(idArg_andunsignedintArg_, signature="@@:@I")


	def idArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andunsignedlongArg_ = objc.selector(idArg_andunsignedlongArg_, signature="@@:@" + ulong_tp + "")


	def idArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andunsignedlonglongArg_ = objc.selector(idArg_andunsignedlonglongArg_, signature="@@:@Q")


	def idArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andfloatArg_ = objc.selector(idArg_andfloatArg_, signature="@@:@f")


	def idArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_anddoubleArg_ = objc.selector(idArg_anddoubleArg_, signature="@@:@d")


	def idArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andidArg_ = objc.selector(idArg_andidArg_, signature="@@:@@")


	def idArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	idArg_andcharPtrArg_ = objc.selector(idArg_andcharPtrArg_, signature="@@:@*")


	def idArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andNSPointArg_ = objc.selector(idArg_andNSPointArg_, signature="@@:@" + NSPoint_tp)


	def idArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andNSRectArg_ = objc.selector(idArg_andNSRectArg_, signature="@@:@" + NSRect_tp)


	def idArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andstructTestStruct1Arg_ = objc.selector(idArg_andstructTestStruct1Arg_, signature="@@:@{_TestStruct1=ii[5s]}")


	def idArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andstructTestStruct2Arg_ = objc.selector(idArg_andstructTestStruct2Arg_, signature="@@:@{_TestStruct2=id[5s]}")


	def idArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andstructTestStruct3Arg_ = objc.selector(idArg_andstructTestStruct3Arg_, signature="@@:@{_TestStruct3=ci}")


	def idArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andstructTestStruct4Arg_ = objc.selector(idArg_andstructTestStruct4Arg_, signature="@@:@{_TestStruct4=cq}")


	def idArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	idArg_andstructTestStruct5Arg_ = objc.selector(idArg_andstructTestStruct5Arg_, signature="@@:@{_TestStruct5=cd}")


        def charPtrArg_andboolArg_(self, arg1, arg2):
                arg1 = unicode(arg1)
                return [ arg1, arg2 ]
        charPtrArg_andboolArg_ = objc.selector(charPtrArg_andboolArg_, signature="@@:*B")


	def charPtrArg_andBOOLArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andBOOLArg_ = objc.selector(charPtrArg_andBOOLArg_, signature="@@:*c")


	def charPtrArg_andcharArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andcharArg_ = objc.selector(charPtrArg_andcharArg_, signature="@@:*c")


	def charPtrArg_andsignedshortArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andsignedshortArg_ = objc.selector(charPtrArg_andsignedshortArg_, signature="@@:*s")


	def charPtrArg_andsignedintArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andsignedintArg_ = objc.selector(charPtrArg_andsignedintArg_, signature="@@:*i")


	def charPtrArg_andsignedlongArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andsignedlongArg_ = objc.selector(charPtrArg_andsignedlongArg_, signature="@@:*" + long_tp + "")


	def charPtrArg_andsignedlonglongArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andsignedlonglongArg_ = objc.selector(charPtrArg_andsignedlonglongArg_, signature="@@:*q")


	def charPtrArg_andunsignedcharArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andunsignedcharArg_ = objc.selector(charPtrArg_andunsignedcharArg_, signature="@@:*C")


	def charPtrArg_andunsignedshortArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andunsignedshortArg_ = objc.selector(charPtrArg_andunsignedshortArg_, signature="@@:*S")


	def charPtrArg_andunsignedintArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andunsignedintArg_ = objc.selector(charPtrArg_andunsignedintArg_, signature="@@:*I")


	def charPtrArg_andunsignedlongArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andunsignedlongArg_ = objc.selector(charPtrArg_andunsignedlongArg_, signature="@@:*" + ulong_tp + "")


	def charPtrArg_andunsignedlonglongArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andunsignedlonglongArg_ = objc.selector(charPtrArg_andunsignedlonglongArg_, signature="@@:*Q")


	def charPtrArg_andfloatArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andfloatArg_ = objc.selector(charPtrArg_andfloatArg_, signature="@@:*f")


	def charPtrArg_anddoubleArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_anddoubleArg_ = objc.selector(charPtrArg_anddoubleArg_, signature="@@:*d")


	def charPtrArg_andidArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andidArg_ = objc.selector(charPtrArg_andidArg_, signature="@@:*@")


	def charPtrArg_andcharPtrArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	charPtrArg_andcharPtrArg_ = objc.selector(charPtrArg_andcharPtrArg_, signature="@@:**")


	def charPtrArg_andNSPointArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andNSPointArg_ = objc.selector(charPtrArg_andNSPointArg_, signature="@@:*" + NSPoint_tp)


	def charPtrArg_andNSRectArg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andNSRectArg_ = objc.selector(charPtrArg_andNSRectArg_, signature="@@:*" + NSRect_tp)


	def charPtrArg_andstructTestStruct1Arg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andstructTestStruct1Arg_ = objc.selector(charPtrArg_andstructTestStruct1Arg_, signature="@@:*{_TestStruct1=ii[5s]}")


	def charPtrArg_andstructTestStruct2Arg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andstructTestStruct2Arg_ = objc.selector(charPtrArg_andstructTestStruct2Arg_, signature="@@:*{_TestStruct2=id[5s]}")


	def charPtrArg_andstructTestStruct3Arg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andstructTestStruct3Arg_ = objc.selector(charPtrArg_andstructTestStruct3Arg_, signature="@@:*{_TestStruct3=ci}")


	def charPtrArg_andstructTestStruct4Arg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andstructTestStruct4Arg_ = objc.selector(charPtrArg_andstructTestStruct4Arg_, signature="@@:*{_TestStruct4=cq}")


	def charPtrArg_andstructTestStruct5Arg_(self, arg1, arg2):
		arg1 = unicode(arg1)
		return [ arg1, arg2 ]
	charPtrArg_andstructTestStruct5Arg_ = objc.selector(charPtrArg_andstructTestStruct5Arg_, signature="@@:*{_TestStruct5=cd}")


        def NSPointArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        NSPointArg_andboolArg_ = objc.selector(NSPointArg_andboolArg_, signature="@@:" + NSPoint_tp + "B")


	def NSPointArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andBOOLArg_ = objc.selector(NSPointArg_andBOOLArg_, signature="@@:" + NSPoint_tp + "c")


	def NSPointArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andcharArg_ = objc.selector(NSPointArg_andcharArg_, signature="@@:" + NSPoint_tp + "c")


	def NSPointArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andsignedshortArg_ = objc.selector(NSPointArg_andsignedshortArg_, signature="@@:" + NSPoint_tp + "s")


	def NSPointArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andsignedintArg_ = objc.selector(NSPointArg_andsignedintArg_, signature="@@:" + NSPoint_tp + "i")


	def NSPointArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andsignedlongArg_ = objc.selector(NSPointArg_andsignedlongArg_, signature="@@:" + NSPoint_tp + "" + long_tp + "")


	def NSPointArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andsignedlonglongArg_ = objc.selector(NSPointArg_andsignedlonglongArg_, signature="@@:" + NSPoint_tp + "q")


	def NSPointArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andunsignedcharArg_ = objc.selector(NSPointArg_andunsignedcharArg_, signature="@@:" + NSPoint_tp + "C")


	def NSPointArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andunsignedshortArg_ = objc.selector(NSPointArg_andunsignedshortArg_, signature="@@:" + NSPoint_tp + "S")


	def NSPointArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andunsignedintArg_ = objc.selector(NSPointArg_andunsignedintArg_, signature="@@:" + NSPoint_tp + "I")


	def NSPointArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andunsignedlongArg_ = objc.selector(NSPointArg_andunsignedlongArg_, signature="@@:" + NSPoint_tp + "" + ulong_tp + "")


	def NSPointArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andunsignedlonglongArg_ = objc.selector(NSPointArg_andunsignedlonglongArg_, signature="@@:" + NSPoint_tp + "Q")


	def NSPointArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andfloatArg_ = objc.selector(NSPointArg_andfloatArg_, signature="@@:" + NSPoint_tp + "f")


	def NSPointArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_anddoubleArg_ = objc.selector(NSPointArg_anddoubleArg_, signature="@@:" + NSPoint_tp + "d")


	def NSPointArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andidArg_ = objc.selector(NSPointArg_andidArg_, signature="@@:" + NSPoint_tp + "@")


	def NSPointArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	NSPointArg_andcharPtrArg_ = objc.selector(NSPointArg_andcharPtrArg_, signature="@@:" + NSPoint_tp + "*")


	def NSPointArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andNSPointArg_ = objc.selector(NSPointArg_andNSPointArg_, signature="@@:" + NSPoint_tp + NSPoint_tp)


	def NSPointArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andNSRectArg_ = objc.selector(NSPointArg_andNSRectArg_, signature="@@:" + NSPoint_tp + NSRect_tp)


	def NSPointArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andstructTestStruct1Arg_ = objc.selector(NSPointArg_andstructTestStruct1Arg_, signature="@@:" + NSPoint_tp + "{_TestStruct1=ii[5s]}")


	def NSPointArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andstructTestStruct2Arg_ = objc.selector(NSPointArg_andstructTestStruct2Arg_, signature="@@:" + NSPoint_tp + "{_TestStruct2=id[5s]}")


	def NSPointArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andstructTestStruct3Arg_ = objc.selector(NSPointArg_andstructTestStruct3Arg_, signature="@@:" + NSPoint_tp + "{_TestStruct3=ci}")


	def NSPointArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andstructTestStruct4Arg_ = objc.selector(NSPointArg_andstructTestStruct4Arg_, signature="@@:" + NSPoint_tp + "{_TestStruct4=cq}")


	def NSPointArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSPointArg_andstructTestStruct5Arg_ = objc.selector(NSPointArg_andstructTestStruct5Arg_, signature="@@:" + NSPoint_tp + "{_TestStruct5=cd}")


        def NSRectArg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        NSRectArg_andboolArg_ = objc.selector(NSRectArg_andboolArg_, signature="@@:" + NSRect_tp + "B")


	def NSRectArg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andBOOLArg_ = objc.selector(NSRectArg_andBOOLArg_, signature="@@:" + NSRect_tp + "c")


	def NSRectArg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andcharArg_ = objc.selector(NSRectArg_andcharArg_, signature="@@:" + NSRect_tp + "c")


	def NSRectArg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andsignedshortArg_ = objc.selector(NSRectArg_andsignedshortArg_, signature="@@:" + NSRect_tp + "s")


	def NSRectArg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andsignedintArg_ = objc.selector(NSRectArg_andsignedintArg_, signature="@@:" + NSRect_tp + "i")


	def NSRectArg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andsignedlongArg_ = objc.selector(NSRectArg_andsignedlongArg_, signature="@@:" + NSRect_tp + "" + long_tp + "")


	def NSRectArg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andsignedlonglongArg_ = objc.selector(NSRectArg_andsignedlonglongArg_, signature="@@:" + NSRect_tp + "q")


	def NSRectArg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andunsignedcharArg_ = objc.selector(NSRectArg_andunsignedcharArg_, signature="@@:" + NSRect_tp + "C")


	def NSRectArg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andunsignedshortArg_ = objc.selector(NSRectArg_andunsignedshortArg_, signature="@@:" + NSRect_tp + "S")


	def NSRectArg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andunsignedintArg_ = objc.selector(NSRectArg_andunsignedintArg_, signature="@@:" + NSRect_tp + "I")


	def NSRectArg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andunsignedlongArg_ = objc.selector(NSRectArg_andunsignedlongArg_, signature="@@:" + NSRect_tp + "" + ulong_tp + "")


	def NSRectArg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andunsignedlonglongArg_ = objc.selector(NSRectArg_andunsignedlonglongArg_, signature="@@:" + NSRect_tp + "Q")


	def NSRectArg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andfloatArg_ = objc.selector(NSRectArg_andfloatArg_, signature="@@:" + NSRect_tp + "f")


	def NSRectArg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_anddoubleArg_ = objc.selector(NSRectArg_anddoubleArg_, signature="@@:" + NSRect_tp + "d")


	def NSRectArg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andidArg_ = objc.selector(NSRectArg_andidArg_, signature="@@:" + NSRect_tp + "@")


	def NSRectArg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	NSRectArg_andcharPtrArg_ = objc.selector(NSRectArg_andcharPtrArg_, signature="@@:" + NSRect_tp + "*")


	def NSRectArg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andNSPointArg_ = objc.selector(NSRectArg_andNSPointArg_, signature="@@:" + NSRect_tp + NSPoint_tp)


	def NSRectArg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andNSRectArg_ = objc.selector(NSRectArg_andNSRectArg_, signature="@@:" + NSRect_tp + NSRect_tp)


	def NSRectArg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andstructTestStruct1Arg_ = objc.selector(NSRectArg_andstructTestStruct1Arg_, signature="@@:" + NSRect_tp + "{_TestStruct1=ii[5s]}")


	def NSRectArg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andstructTestStruct2Arg_ = objc.selector(NSRectArg_andstructTestStruct2Arg_, signature="@@:" + NSRect_tp + "{_TestStruct2=id[5s]}")


	def NSRectArg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andstructTestStruct3Arg_ = objc.selector(NSRectArg_andstructTestStruct3Arg_, signature="@@:" + NSRect_tp + "{_TestStruct3=ci}")


	def NSRectArg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andstructTestStruct4Arg_ = objc.selector(NSRectArg_andstructTestStruct4Arg_, signature="@@:" + NSRect_tp + "{_TestStruct4=cq}")


	def NSRectArg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	NSRectArg_andstructTestStruct5Arg_ = objc.selector(NSRectArg_andstructTestStruct5Arg_, signature="@@:" + NSRect_tp + "{_TestStruct5=cd}")


        def structTestStruct1Arg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        structTestStruct1Arg_andboolArg_ = objc.selector(structTestStruct1Arg_andboolArg_, signature="@@:{_TestStruct1=ii[5s]}B")


	def structTestStruct1Arg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andBOOLArg_ = objc.selector(structTestStruct1Arg_andBOOLArg_, signature="@@:{_TestStruct1=ii[5s]}c")


	def structTestStruct1Arg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andcharArg_ = objc.selector(structTestStruct1Arg_andcharArg_, signature="@@:{_TestStruct1=ii[5s]}c")


	def structTestStruct1Arg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andsignedshortArg_ = objc.selector(structTestStruct1Arg_andsignedshortArg_, signature="@@:{_TestStruct1=ii[5s]}s")


	def structTestStruct1Arg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andsignedintArg_ = objc.selector(structTestStruct1Arg_andsignedintArg_, signature="@@:{_TestStruct1=ii[5s]}i")


	def structTestStruct1Arg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andsignedlongArg_ = objc.selector(structTestStruct1Arg_andsignedlongArg_, signature="@@:{_TestStruct1=ii[5s]}" + long_tp + "")


	def structTestStruct1Arg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andsignedlonglongArg_ = objc.selector(structTestStruct1Arg_andsignedlonglongArg_, signature="@@:{_TestStruct1=ii[5s]}q")


	def structTestStruct1Arg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andunsignedcharArg_ = objc.selector(structTestStruct1Arg_andunsignedcharArg_, signature="@@:{_TestStruct1=ii[5s]}C")


	def structTestStruct1Arg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andunsignedshortArg_ = objc.selector(structTestStruct1Arg_andunsignedshortArg_, signature="@@:{_TestStruct1=ii[5s]}S")


	def structTestStruct1Arg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andunsignedintArg_ = objc.selector(structTestStruct1Arg_andunsignedintArg_, signature="@@:{_TestStruct1=ii[5s]}I")


	def structTestStruct1Arg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andunsignedlongArg_ = objc.selector(structTestStruct1Arg_andunsignedlongArg_, signature="@@:{_TestStruct1=ii[5s]}" + ulong_tp + "")


	def structTestStruct1Arg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andunsignedlonglongArg_ = objc.selector(structTestStruct1Arg_andunsignedlonglongArg_, signature="@@:{_TestStruct1=ii[5s]}Q")


	def structTestStruct1Arg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andfloatArg_ = objc.selector(structTestStruct1Arg_andfloatArg_, signature="@@:{_TestStruct1=ii[5s]}f")


	def structTestStruct1Arg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_anddoubleArg_ = objc.selector(structTestStruct1Arg_anddoubleArg_, signature="@@:{_TestStruct1=ii[5s]}d")


	def structTestStruct1Arg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andidArg_ = objc.selector(structTestStruct1Arg_andidArg_, signature="@@:{_TestStruct1=ii[5s]}@")


	def structTestStruct1Arg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	structTestStruct1Arg_andcharPtrArg_ = objc.selector(structTestStruct1Arg_andcharPtrArg_, signature="@@:{_TestStruct1=ii[5s]}*")


	def structTestStruct1Arg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andNSPointArg_ = objc.selector(structTestStruct1Arg_andNSPointArg_, signature="@@:{_TestStruct1=ii[5s]}" + NSPoint_tp)


	def structTestStruct1Arg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andNSRectArg_ = objc.selector(structTestStruct1Arg_andNSRectArg_, signature="@@:{_TestStruct1=ii[5s]}" + NSRect_tp)


	def structTestStruct1Arg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andstructTestStruct1Arg_ = objc.selector(structTestStruct1Arg_andstructTestStruct1Arg_, signature="@@:{_TestStruct1=ii[5s]}{_TestStruct1=ii[5s]}")


	def structTestStruct1Arg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andstructTestStruct2Arg_ = objc.selector(structTestStruct1Arg_andstructTestStruct2Arg_, signature="@@:{_TestStruct1=ii[5s]}{_TestStruct2=id[5s]}")


	def structTestStruct1Arg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andstructTestStruct3Arg_ = objc.selector(structTestStruct1Arg_andstructTestStruct3Arg_, signature="@@:{_TestStruct1=ii[5s]}{_TestStruct3=ci}")


	def structTestStruct1Arg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andstructTestStruct4Arg_ = objc.selector(structTestStruct1Arg_andstructTestStruct4Arg_, signature="@@:{_TestStruct1=ii[5s]}{_TestStruct4=cq}")


	def structTestStruct1Arg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct1Arg_andstructTestStruct5Arg_ = objc.selector(structTestStruct1Arg_andstructTestStruct5Arg_, signature="@@:{_TestStruct1=ii[5s]}{_TestStruct5=cd}")


        def structTestStruct2Arg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        structTestStruct2Arg_andboolArg_ = objc.selector(structTestStruct2Arg_andboolArg_, signature="@@:{_TestStruct2=id[5s]}B")


	def structTestStruct2Arg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andBOOLArg_ = objc.selector(structTestStruct2Arg_andBOOLArg_, signature="@@:{_TestStruct2=id[5s]}c")


	def structTestStruct2Arg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andcharArg_ = objc.selector(structTestStruct2Arg_andcharArg_, signature="@@:{_TestStruct2=id[5s]}c")


	def structTestStruct2Arg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andsignedshortArg_ = objc.selector(structTestStruct2Arg_andsignedshortArg_, signature="@@:{_TestStruct2=id[5s]}s")


	def structTestStruct2Arg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andsignedintArg_ = objc.selector(structTestStruct2Arg_andsignedintArg_, signature="@@:{_TestStruct2=id[5s]}i")


	def structTestStruct2Arg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andsignedlongArg_ = objc.selector(structTestStruct2Arg_andsignedlongArg_, signature="@@:{_TestStruct2=id[5s]}" + long_tp + "")


	def structTestStruct2Arg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andsignedlonglongArg_ = objc.selector(structTestStruct2Arg_andsignedlonglongArg_, signature="@@:{_TestStruct2=id[5s]}q")


	def structTestStruct2Arg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andunsignedcharArg_ = objc.selector(structTestStruct2Arg_andunsignedcharArg_, signature="@@:{_TestStruct2=id[5s]}C")


	def structTestStruct2Arg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andunsignedshortArg_ = objc.selector(structTestStruct2Arg_andunsignedshortArg_, signature="@@:{_TestStruct2=id[5s]}S")


	def structTestStruct2Arg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andunsignedintArg_ = objc.selector(structTestStruct2Arg_andunsignedintArg_, signature="@@:{_TestStruct2=id[5s]}I")


	def structTestStruct2Arg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andunsignedlongArg_ = objc.selector(structTestStruct2Arg_andunsignedlongArg_, signature="@@:{_TestStruct2=id[5s]}" + ulong_tp + "")


	def structTestStruct2Arg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andunsignedlonglongArg_ = objc.selector(structTestStruct2Arg_andunsignedlonglongArg_, signature="@@:{_TestStruct2=id[5s]}Q")


	def structTestStruct2Arg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andfloatArg_ = objc.selector(structTestStruct2Arg_andfloatArg_, signature="@@:{_TestStruct2=id[5s]}f")


	def structTestStruct2Arg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_anddoubleArg_ = objc.selector(structTestStruct2Arg_anddoubleArg_, signature="@@:{_TestStruct2=id[5s]}d")


	def structTestStruct2Arg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andidArg_ = objc.selector(structTestStruct2Arg_andidArg_, signature="@@:{_TestStruct2=id[5s]}@")


	def structTestStruct2Arg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	structTestStruct2Arg_andcharPtrArg_ = objc.selector(structTestStruct2Arg_andcharPtrArg_, signature="@@:{_TestStruct2=id[5s]}*")


	def structTestStruct2Arg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andNSPointArg_ = objc.selector(structTestStruct2Arg_andNSPointArg_, signature="@@:{_TestStruct2=id[5s]}" + NSPoint_tp)


	def structTestStruct2Arg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andNSRectArg_ = objc.selector(structTestStruct2Arg_andNSRectArg_, signature="@@:{_TestStruct2=id[5s]}" + NSRect_tp)


	def structTestStruct2Arg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andstructTestStruct1Arg_ = objc.selector(structTestStruct2Arg_andstructTestStruct1Arg_, signature="@@:{_TestStruct2=id[5s]}{_TestStruct1=ii[5s]}")


	def structTestStruct2Arg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andstructTestStruct2Arg_ = objc.selector(structTestStruct2Arg_andstructTestStruct2Arg_, signature="@@:{_TestStruct2=id[5s]}{_TestStruct2=id[5s]}")


	def structTestStruct2Arg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andstructTestStruct3Arg_ = objc.selector(structTestStruct2Arg_andstructTestStruct3Arg_, signature="@@:{_TestStruct2=id[5s]}{_TestStruct3=ci}")


	def structTestStruct2Arg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andstructTestStruct4Arg_ = objc.selector(structTestStruct2Arg_andstructTestStruct4Arg_, signature="@@:{_TestStruct2=id[5s]}{_TestStruct4=cq}")


	def structTestStruct2Arg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct2Arg_andstructTestStruct5Arg_ = objc.selector(structTestStruct2Arg_andstructTestStruct5Arg_, signature="@@:{_TestStruct2=id[5s]}{_TestStruct5=cd}")


        def structTestStruct3Arg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        structTestStruct3Arg_andboolArg_ = objc.selector(structTestStruct3Arg_andboolArg_, signature="@@:{_TestStruct3=ci}B")


	def structTestStruct3Arg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andBOOLArg_ = objc.selector(structTestStruct3Arg_andBOOLArg_, signature="@@:{_TestStruct3=ci}c")


	def structTestStruct3Arg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andcharArg_ = objc.selector(structTestStruct3Arg_andcharArg_, signature="@@:{_TestStruct3=ci}c")


	def structTestStruct3Arg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andsignedshortArg_ = objc.selector(structTestStruct3Arg_andsignedshortArg_, signature="@@:{_TestStruct3=ci}s")


	def structTestStruct3Arg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andsignedintArg_ = objc.selector(structTestStruct3Arg_andsignedintArg_, signature="@@:{_TestStruct3=ci}i")


	def structTestStruct3Arg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andsignedlongArg_ = objc.selector(structTestStruct3Arg_andsignedlongArg_, signature="@@:{_TestStruct3=ci}" + long_tp + "")


	def structTestStruct3Arg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andsignedlonglongArg_ = objc.selector(structTestStruct3Arg_andsignedlonglongArg_, signature="@@:{_TestStruct3=ci}q")


	def structTestStruct3Arg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andunsignedcharArg_ = objc.selector(structTestStruct3Arg_andunsignedcharArg_, signature="@@:{_TestStruct3=ci}C")


	def structTestStruct3Arg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andunsignedshortArg_ = objc.selector(structTestStruct3Arg_andunsignedshortArg_, signature="@@:{_TestStruct3=ci}S")


	def structTestStruct3Arg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andunsignedintArg_ = objc.selector(structTestStruct3Arg_andunsignedintArg_, signature="@@:{_TestStruct3=ci}I")


	def structTestStruct3Arg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andunsignedlongArg_ = objc.selector(structTestStruct3Arg_andunsignedlongArg_, signature="@@:{_TestStruct3=ci}" + ulong_tp + "")


	def structTestStruct3Arg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andunsignedlonglongArg_ = objc.selector(structTestStruct3Arg_andunsignedlonglongArg_, signature="@@:{_TestStruct3=ci}Q")


	def structTestStruct3Arg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andfloatArg_ = objc.selector(structTestStruct3Arg_andfloatArg_, signature="@@:{_TestStruct3=ci}f")


	def structTestStruct3Arg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_anddoubleArg_ = objc.selector(structTestStruct3Arg_anddoubleArg_, signature="@@:{_TestStruct3=ci}d")


	def structTestStruct3Arg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andidArg_ = objc.selector(structTestStruct3Arg_andidArg_, signature="@@:{_TestStruct3=ci}@")


	def structTestStruct3Arg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	structTestStruct3Arg_andcharPtrArg_ = objc.selector(structTestStruct3Arg_andcharPtrArg_, signature="@@:{_TestStruct3=ci}*")


	def structTestStruct3Arg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andNSPointArg_ = objc.selector(structTestStruct3Arg_andNSPointArg_, signature="@@:{_TestStruct3=ci}" + NSPoint_tp)


	def structTestStruct3Arg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andNSRectArg_ = objc.selector(structTestStruct3Arg_andNSRectArg_, signature="@@:{_TestStruct3=ci}" + NSRect_tp)


	def structTestStruct3Arg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andstructTestStruct1Arg_ = objc.selector(structTestStruct3Arg_andstructTestStruct1Arg_, signature="@@:{_TestStruct3=ci}{_TestStruct1=ii[5s]}")


	def structTestStruct3Arg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andstructTestStruct2Arg_ = objc.selector(structTestStruct3Arg_andstructTestStruct2Arg_, signature="@@:{_TestStruct3=ci}{_TestStruct2=id[5s]}")


	def structTestStruct3Arg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andstructTestStruct3Arg_ = objc.selector(structTestStruct3Arg_andstructTestStruct3Arg_, signature="@@:{_TestStruct3=ci}{_TestStruct3=ci}")


	def structTestStruct3Arg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andstructTestStruct4Arg_ = objc.selector(structTestStruct3Arg_andstructTestStruct4Arg_, signature="@@:{_TestStruct3=ci}{_TestStruct4=cq}")


	def structTestStruct3Arg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct3Arg_andstructTestStruct5Arg_ = objc.selector(structTestStruct3Arg_andstructTestStruct5Arg_, signature="@@:{_TestStruct3=ci}{_TestStruct5=cd}")


        def structTestStruct4Arg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        structTestStruct4Arg_andboolArg_ = objc.selector(structTestStruct4Arg_andboolArg_, signature="@@:{_TestStruct4=cq}B")


	def structTestStruct4Arg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andBOOLArg_ = objc.selector(structTestStruct4Arg_andBOOLArg_, signature="@@:{_TestStruct4=cq}c")


	def structTestStruct4Arg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andcharArg_ = objc.selector(structTestStruct4Arg_andcharArg_, signature="@@:{_TestStruct4=cq}c")


	def structTestStruct4Arg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andsignedshortArg_ = objc.selector(structTestStruct4Arg_andsignedshortArg_, signature="@@:{_TestStruct4=cq}s")


	def structTestStruct4Arg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andsignedintArg_ = objc.selector(structTestStruct4Arg_andsignedintArg_, signature="@@:{_TestStruct4=cq}i")


	def structTestStruct4Arg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andsignedlongArg_ = objc.selector(structTestStruct4Arg_andsignedlongArg_, signature="@@:{_TestStruct4=cq}" + long_tp + "")


	def structTestStruct4Arg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andsignedlonglongArg_ = objc.selector(structTestStruct4Arg_andsignedlonglongArg_, signature="@@:{_TestStruct4=cq}q")


	def structTestStruct4Arg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andunsignedcharArg_ = objc.selector(structTestStruct4Arg_andunsignedcharArg_, signature="@@:{_TestStruct4=cq}C")


	def structTestStruct4Arg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andunsignedshortArg_ = objc.selector(structTestStruct4Arg_andunsignedshortArg_, signature="@@:{_TestStruct4=cq}S")


	def structTestStruct4Arg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andunsignedintArg_ = objc.selector(structTestStruct4Arg_andunsignedintArg_, signature="@@:{_TestStruct4=cq}I")


	def structTestStruct4Arg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andunsignedlongArg_ = objc.selector(structTestStruct4Arg_andunsignedlongArg_, signature="@@:{_TestStruct4=cq}" + ulong_tp + "")


	def structTestStruct4Arg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andunsignedlonglongArg_ = objc.selector(structTestStruct4Arg_andunsignedlonglongArg_, signature="@@:{_TestStruct4=cq}Q")


	def structTestStruct4Arg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andfloatArg_ = objc.selector(structTestStruct4Arg_andfloatArg_, signature="@@:{_TestStruct4=cq}f")


	def structTestStruct4Arg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_anddoubleArg_ = objc.selector(structTestStruct4Arg_anddoubleArg_, signature="@@:{_TestStruct4=cq}d")


	def structTestStruct4Arg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andidArg_ = objc.selector(structTestStruct4Arg_andidArg_, signature="@@:{_TestStruct4=cq}@")


	def structTestStruct4Arg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	structTestStruct4Arg_andcharPtrArg_ = objc.selector(structTestStruct4Arg_andcharPtrArg_, signature="@@:{_TestStruct4=cq}*")


	def structTestStruct4Arg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andNSPointArg_ = objc.selector(structTestStruct4Arg_andNSPointArg_, signature="@@:{_TestStruct4=cq}" + NSPoint_tp)


	def structTestStruct4Arg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andNSRectArg_ = objc.selector(structTestStruct4Arg_andNSRectArg_, signature="@@:{_TestStruct4=cq}" + NSRect_tp)


	def structTestStruct4Arg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andstructTestStruct1Arg_ = objc.selector(structTestStruct4Arg_andstructTestStruct1Arg_, signature="@@:{_TestStruct4=cq}{_TestStruct1=ii[5s]}")


	def structTestStruct4Arg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andstructTestStruct2Arg_ = objc.selector(structTestStruct4Arg_andstructTestStruct2Arg_, signature="@@:{_TestStruct4=cq}{_TestStruct2=id[5s]}")


	def structTestStruct4Arg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andstructTestStruct3Arg_ = objc.selector(structTestStruct4Arg_andstructTestStruct3Arg_, signature="@@:{_TestStruct4=cq}{_TestStruct3=ci}")


	def structTestStruct4Arg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andstructTestStruct4Arg_ = objc.selector(structTestStruct4Arg_andstructTestStruct4Arg_, signature="@@:{_TestStruct4=cq}{_TestStruct4=cq}")


	def structTestStruct4Arg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct4Arg_andstructTestStruct5Arg_ = objc.selector(structTestStruct4Arg_andstructTestStruct5Arg_, signature="@@:{_TestStruct4=cq}{_TestStruct5=cd}")


        def structTestStruct5Arg_andboolArg_(self, arg1, arg2):
                return [ arg1, arg2 ]
        structTestStruct5Arg_andboolArg_ = objc.selector(structTestStruct5Arg_andboolArg_, signature="@@:{_TestStruct5=cd}B")


	def structTestStruct5Arg_andBOOLArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andBOOLArg_ = objc.selector(structTestStruct5Arg_andBOOLArg_, signature="@@:{_TestStruct5=cd}c")


	def structTestStruct5Arg_andcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andcharArg_ = objc.selector(structTestStruct5Arg_andcharArg_, signature="@@:{_TestStruct5=cd}c")


	def structTestStruct5Arg_andsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andsignedshortArg_ = objc.selector(structTestStruct5Arg_andsignedshortArg_, signature="@@:{_TestStruct5=cd}s")


	def structTestStruct5Arg_andsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andsignedintArg_ = objc.selector(structTestStruct5Arg_andsignedintArg_, signature="@@:{_TestStruct5=cd}i")


	def structTestStruct5Arg_andsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andsignedlongArg_ = objc.selector(structTestStruct5Arg_andsignedlongArg_, signature="@@:{_TestStruct5=cd}" + long_tp + "")


	def structTestStruct5Arg_andsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andsignedlonglongArg_ = objc.selector(structTestStruct5Arg_andsignedlonglongArg_, signature="@@:{_TestStruct5=cd}q")


	def structTestStruct5Arg_andunsignedcharArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andunsignedcharArg_ = objc.selector(structTestStruct5Arg_andunsignedcharArg_, signature="@@:{_TestStruct5=cd}C")


	def structTestStruct5Arg_andunsignedshortArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andunsignedshortArg_ = objc.selector(structTestStruct5Arg_andunsignedshortArg_, signature="@@:{_TestStruct5=cd}S")


	def structTestStruct5Arg_andunsignedintArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andunsignedintArg_ = objc.selector(structTestStruct5Arg_andunsignedintArg_, signature="@@:{_TestStruct5=cd}I")


	def structTestStruct5Arg_andunsignedlongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andunsignedlongArg_ = objc.selector(structTestStruct5Arg_andunsignedlongArg_, signature="@@:{_TestStruct5=cd}" + ulong_tp + "")


	def structTestStruct5Arg_andunsignedlonglongArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andunsignedlonglongArg_ = objc.selector(structTestStruct5Arg_andunsignedlonglongArg_, signature="@@:{_TestStruct5=cd}Q")


	def structTestStruct5Arg_andfloatArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andfloatArg_ = objc.selector(structTestStruct5Arg_andfloatArg_, signature="@@:{_TestStruct5=cd}f")


	def structTestStruct5Arg_anddoubleArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_anddoubleArg_ = objc.selector(structTestStruct5Arg_anddoubleArg_, signature="@@:{_TestStruct5=cd}d")


	def structTestStruct5Arg_andidArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andidArg_ = objc.selector(structTestStruct5Arg_andidArg_, signature="@@:{_TestStruct5=cd}@")


	def structTestStruct5Arg_andcharPtrArg_(self, arg1, arg2):
		arg2 = unicode(arg2)
		return [ arg1, arg2 ]
	structTestStruct5Arg_andcharPtrArg_ = objc.selector(structTestStruct5Arg_andcharPtrArg_, signature="@@:{_TestStruct5=cd}*")


	def structTestStruct5Arg_andNSPointArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andNSPointArg_ = objc.selector(structTestStruct5Arg_andNSPointArg_, signature="@@:{_TestStruct5=cd}" + NSPoint_tp)


	def structTestStruct5Arg_andNSRectArg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andNSRectArg_ = objc.selector(structTestStruct5Arg_andNSRectArg_, signature="@@:{_TestStruct5=cd}" + NSRect_tp)


	def structTestStruct5Arg_andstructTestStruct1Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andstructTestStruct1Arg_ = objc.selector(structTestStruct5Arg_andstructTestStruct1Arg_, signature="@@:{_TestStruct5=cd}{_TestStruct1=ii[5s]}")


	def structTestStruct5Arg_andstructTestStruct2Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andstructTestStruct2Arg_ = objc.selector(structTestStruct5Arg_andstructTestStruct2Arg_, signature="@@:{_TestStruct5=cd}{_TestStruct2=id[5s]}")


	def structTestStruct5Arg_andstructTestStruct3Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andstructTestStruct3Arg_ = objc.selector(structTestStruct5Arg_andstructTestStruct3Arg_, signature="@@:{_TestStruct5=cd}{_TestStruct3=ci}")


	def structTestStruct5Arg_andstructTestStruct4Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andstructTestStruct4Arg_ = objc.selector(structTestStruct5Arg_andstructTestStruct4Arg_, signature="@@:{_TestStruct5=cd}{_TestStruct4=cq}")


	def structTestStruct5Arg_andstructTestStruct5Arg_(self, arg1, arg2):
		return [ arg1, arg2 ]
	structTestStruct5Arg_andstructTestStruct5Arg_ = objc.selector(structTestStruct5Arg_andstructTestStruct5Arg_, signature="@@:{_TestStruct5=cd}{_TestStruct5=cd}")


        def boolInArg_(self, arg):
                return arg # return the same
        boolInArg_ = objc.selector(boolInArg_, signature="@@:n^B")


        def boolOutArg_(self, arg):
                assert arg is None
                if (self.counter > 2): self.reset()
                res = g_bool_values[self.counter]
                self.counter += 1
                return res
        boolOutArg_ = objc.selector(boolOutArg_, signature="v@:o^B")


        def boolInOutArg_(self, arg):
                if (self.counter > 2): self.reset()
                res = g_bool_values[self.counter];
                self.counter += 1
                return (arg, res)
        boolInOutArg_ = objc.selector(boolInOutArg_, signature="@@:N^B")


	def BOOLInArg_(self, arg):
		return arg # return the same
	BOOLInArg_ = objc.selector(BOOLInArg_, signature="@@:n^c")


	def BOOLOutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_BOOL_values[self.counter]
		self.counter += 1
		return res
	BOOLOutArg_ = objc.selector(BOOLOutArg_, signature="v@:o^c")


	def BOOLInOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_BOOL_values[self.counter];
		self.counter += 1
		return (arg, res)
	BOOLInOutArg_ = objc.selector(BOOLInOutArg_, signature="@@:N^c")


	def charInArg_(self, arg):
		return arg # return the same
	charInArg_ = objc.selector(charInArg_, signature="@@:n^c")


	def charOutArg_(self, arg):
                assert arg is None
		if (self.counter > 3): self.reset()
		res = g_char_values[self.counter]
		self.counter += 1
		return res
	charOutArg_ = objc.selector(charOutArg_, signature="v@:o^c")


	def charInOutArg_(self, arg):
		if (self.counter > 3): self.reset()
		res = g_char_values[self.counter];
		self.counter += 1
		return (arg, res)
	charInOutArg_ = objc.selector(charInOutArg_, signature="@@:N^c")


	def signedshortInArg_(self, arg):
		return arg # return the same
	signedshortInArg_ = objc.selector(signedshortInArg_, signature="@@:n^s")


	def signedshortOutArg_(self, arg):
                assert arg is None
		if (self.counter > 5): self.reset()
		res = g_signedshort_values[self.counter]
		self.counter += 1
		return res
	signedshortOutArg_ = objc.selector(signedshortOutArg_, signature="v@:o^s")


	def signedshortInOutArg_(self, arg):
		if (self.counter > 5): self.reset()
		res = g_signedshort_values[self.counter];
		self.counter += 1
		return (arg, res)
	signedshortInOutArg_ = objc.selector(signedshortInOutArg_, signature="@@:N^s")


	def signedintInArg_(self, arg):
		return arg # return the same
	signedintInArg_ = objc.selector(signedintInArg_, signature="@@:n^i")


	def signedintOutArg_(self, arg):
                assert arg is None
		if (self.counter > 5): self.reset()
		res = g_signedint_values[self.counter]
		self.counter += 1
		return res
	signedintOutArg_ = objc.selector(signedintOutArg_, signature="v@:o^i")


	def signedintInOutArg_(self, arg):
		if (self.counter > 5): self.reset()
		res = g_signedint_values[self.counter];
		self.counter += 1
		return (arg, res)
	signedintInOutArg_ = objc.selector(signedintInOutArg_, signature="@@:N^i")


	def signedlongInArg_(self, arg):
		return arg # return the same
	signedlongInArg_ = objc.selector(signedlongInArg_, signature="@@:n^" + long_tp + "")


	def signedlongOutArg_(self, arg):
                assert arg is None
		if (self.counter > 5): self.reset()
		res = g_signedlong_values[self.counter]
		self.counter += 1
		return res
	signedlongOutArg_ = objc.selector(signedlongOutArg_, signature="v@:o^" + long_tp + "")


	def signedlongInOutArg_(self, arg):
		if (self.counter > 5): self.reset()
		res = g_signedlong_values[self.counter];
		self.counter += 1
		return (arg, res)
	signedlongInOutArg_ = objc.selector(signedlongInOutArg_, signature="@@:N^" + long_tp + "")


	def signedlonglongInArg_(self, arg):
		return arg # return the same
	signedlonglongInArg_ = objc.selector(signedlonglongInArg_, signature="@@:n^q")


	def signedlonglongOutArg_(self, arg):
                assert arg is None
		if (self.counter > 5): self.reset()
		res = g_signedlonglong_values[self.counter]
		self.counter += 1
		return res
	signedlonglongOutArg_ = objc.selector(signedlonglongOutArg_, signature="v@:o^q")


	def signedlonglongInOutArg_(self, arg):
		if (self.counter > 5): self.reset()
		res = g_signedlonglong_values[self.counter];
		self.counter += 1
		return (arg, res)
	signedlonglongInOutArg_ = objc.selector(signedlonglongInOutArg_, signature="@@:N^q")


	def unsignedcharInArg_(self, arg):
		return arg # return the same
	unsignedcharInArg_ = objc.selector(unsignedcharInArg_, signature="@@:n^C")


	def unsignedcharOutArg_(self, arg):
                assert arg is None
		if (self.counter > 3): self.reset()
		res = g_unsignedchar_values[self.counter]
		self.counter += 1
		return res
	unsignedcharOutArg_ = objc.selector(unsignedcharOutArg_, signature="v@:o^C")


	def unsignedcharInOutArg_(self, arg):
		if (self.counter > 3): self.reset()
		res = g_unsignedchar_values[self.counter];
		self.counter += 1
		return (arg, res)
	unsignedcharInOutArg_ = objc.selector(unsignedcharInOutArg_, signature="@@:N^C")


	def unsignedshortInArg_(self, arg):
		return arg # return the same
	unsignedshortInArg_ = objc.selector(unsignedshortInArg_, signature="@@:n^S")


	def unsignedshortOutArg_(self, arg):
                assert arg is None
		if (self.counter > 3): self.reset()
		res = g_unsignedshort_values[self.counter]
		self.counter += 1
		return res
	unsignedshortOutArg_ = objc.selector(unsignedshortOutArg_, signature="v@:o^S")


	def unsignedshortInOutArg_(self, arg):
		if (self.counter > 3): self.reset()
		res = g_unsignedshort_values[self.counter];
		self.counter += 1
		return (arg, res)
	unsignedshortInOutArg_ = objc.selector(unsignedshortInOutArg_, signature="@@:N^S")


	def unsignedintInArg_(self, arg):
		return arg # return the same
	unsignedintInArg_ = objc.selector(unsignedintInArg_, signature="@@:n^I")


	def unsignedintOutArg_(self, arg):
                assert arg is None
		if (self.counter > 3): self.reset()
		res = g_unsignedint_values[self.counter]
		self.counter += 1
		return res
	unsignedintOutArg_ = objc.selector(unsignedintOutArg_, signature="v@:o^I")


	def unsignedintInOutArg_(self, arg):
		if (self.counter > 3): self.reset()
		res = g_unsignedint_values[self.counter];
		self.counter += 1
		return (arg, res)
	unsignedintInOutArg_ = objc.selector(unsignedintInOutArg_, signature="@@:N^I")


	def unsignedlongInArg_(self, arg):
		return arg # return the same
	unsignedlongInArg_ = objc.selector(unsignedlongInArg_, signature="@@:n^" + ulong_tp + "")


	def unsignedlongOutArg_(self, arg):
                assert arg is None
		if (self.counter > 3): self.reset()
		res = g_unsignedlong_values[self.counter]
		self.counter += 1
		return res
	unsignedlongOutArg_ = objc.selector(unsignedlongOutArg_, signature="v@:o^" + ulong_tp + "")


	def unsignedlongInOutArg_(self, arg):
		if (self.counter > 3): self.reset()
		res = g_unsignedlong_values[self.counter];
		self.counter += 1
		return (arg, res)
	unsignedlongInOutArg_ = objc.selector(unsignedlongInOutArg_, signature="@@:N^" + ulong_tp + "")


	def unsignedlonglongInArg_(self, arg):
		return arg # return the same
	unsignedlonglongInArg_ = objc.selector(unsignedlonglongInArg_, signature="@@:n^Q")


	def unsignedlonglongOutArg_(self, arg):
                assert arg is None
		if (self.counter > 3): self.reset()
		res = g_unsignedlonglong_values[self.counter]
		self.counter += 1
		return res
	unsignedlonglongOutArg_ = objc.selector(unsignedlonglongOutArg_, signature="v@:o^Q")


	def unsignedlonglongInOutArg_(self, arg):
		if (self.counter > 3): self.reset()
		res = g_unsignedlonglong_values[self.counter];
		self.counter += 1
		return (arg, res)
	unsignedlonglongInOutArg_ = objc.selector(unsignedlonglongInOutArg_, signature="@@:N^Q")


	def floatInArg_(self, arg):
		return arg # return the same
	floatInArg_ = objc.selector(floatInArg_, signature="@@:n^f")


	def floatOutArg_(self, arg):
                assert arg is None
		if (self.counter > 4): self.reset()
		res = g_float_values[self.counter]
		self.counter += 1
		return res
	floatOutArg_ = objc.selector(floatOutArg_, signature="v@:o^f")


	def floatInOutArg_(self, arg):
		if (self.counter > 4): self.reset()
		res = g_float_values[self.counter];
		self.counter += 1
		return (arg, res)
	floatInOutArg_ = objc.selector(floatInOutArg_, signature="@@:N^f")


	def doubleInArg_(self, arg):
		return arg # return the same
	doubleInArg_ = objc.selector(doubleInArg_, signature="@@:n^d")


	def doubleOutArg_(self, arg):
                assert arg is None
		if (self.counter > 4): self.reset()
		res = g_double_values[self.counter]
		self.counter += 1
		return res
	doubleOutArg_ = objc.selector(doubleOutArg_, signature="v@:o^d")


	def doubleInOutArg_(self, arg):
		if (self.counter > 4): self.reset()
		res = g_double_values[self.counter];
		self.counter += 1
		return (arg, res)
	doubleInOutArg_ = objc.selector(doubleInOutArg_, signature="@@:N^d")


	def idInArg_(self, arg):
		return arg # return the same
	idInArg_ = objc.selector(idInArg_, signature="@@:n^@")


	def idOutArg_(self, arg):
                assert arg is None
		if (self.counter > 1): self.reset()
		res = g_id_values[self.counter]
		self.counter += 1
		return res
	idOutArg_ = objc.selector(idOutArg_, signature="v@:o^@")


	def idInOutArg_(self, arg):
		if (self.counter > 1): self.reset()
		res = g_id_values[self.counter];
		self.counter += 1
		return (arg, res)
	idInOutArg_ = objc.selector(idInOutArg_, signature="@@:N^@")


	def charPtrInArg_(self, arg):
		return unicode(arg) # return the unicode
	charPtrInArg_ = objc.selector(charPtrInArg_, signature="@@:n^*")


	def charPtrOutArg_(self, arg):
                assert arg is None
		if (self.counter > 3): self.reset()
		res = g_charPtr_values[self.counter]
		self.counter += 1
		return res
	charPtrOutArg_ = objc.selector(charPtrOutArg_, signature="v@:o^*")


	def charPtrInOutArg_(self, arg):
		if (self.counter > 3): self.reset()
		res = g_charPtr_values[self.counter];
		self.counter += 1
		return (arg, res)
	charPtrInOutArg_ = objc.selector(charPtrInOutArg_, signature="@@:N^*")


	def NSPointInArg_(self, arg):
		return arg # return the same
	NSPointInArg_ = objc.selector(NSPointInArg_, signature="@@:n^" + NSPoint_tp)


	def NSPointOutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_NSPoint_values[self.counter]
		self.counter += 1
		return res
	NSPointOutArg_ = objc.selector(NSPointOutArg_, signature="v@:o^" + NSPoint_tp)


	def NSPointInOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_NSPoint_values[self.counter];
		self.counter += 1
		return (arg, res)
	NSPointInOutArg_ = objc.selector(NSPointInOutArg_, signature="@@:N^" + NSPoint_tp)


	def NSRectInArg_(self, arg):
		return arg # return the same
	NSRectInArg_ = objc.selector(NSRectInArg_, signature="@@:n^" + NSRect_tp)


	def NSRectOutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_NSRect_values[self.counter]
		self.counter += 1
		return res
	NSRectOutArg_ = objc.selector(NSRectOutArg_, signature="v@:o^" + NSRect_tp)


	def NSRectInOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_NSRect_values[self.counter];
		self.counter += 1
		return (arg, res)
	NSRectInOutArg_ = objc.selector(NSRectInOutArg_, signature="@@:N^" + NSRect_tp)


	def structTestStruct1InArg_(self, arg):
		return arg # return the same
	structTestStruct1InArg_ = objc.selector(structTestStruct1InArg_, signature="@@:n^{_TestStruct1=ii[5s]}")


	def structTestStruct1OutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_structTestStruct1_values[self.counter]
		self.counter += 1
		return res
	structTestStruct1OutArg_ = objc.selector(structTestStruct1OutArg_, signature="v@:o^{_TestStruct1=ii[5s]}")


	def structTestStruct1InOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_structTestStruct1_values[self.counter];
		self.counter += 1
		return (arg, res)
	structTestStruct1InOutArg_ = objc.selector(structTestStruct1InOutArg_, signature="@@:N^{_TestStruct1=ii[5s]}")


	def structTestStruct2InArg_(self, arg):
		return arg # return the same
	structTestStruct2InArg_ = objc.selector(structTestStruct2InArg_, signature="@@:n^{_TestStruct2=id[5s]}")


	def structTestStruct2OutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_structTestStruct2_values[self.counter]
		self.counter += 1
		return res
	structTestStruct2OutArg_ = objc.selector(structTestStruct2OutArg_, signature="v@:o^{_TestStruct2=id[5s]}")


	def structTestStruct2InOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_structTestStruct2_values[self.counter];
		self.counter += 1
		return (arg, res)
	structTestStruct2InOutArg_ = objc.selector(structTestStruct2InOutArg_, signature="@@:N^{_TestStruct2=id[5s]}")


	def structTestStruct3InArg_(self, arg):
		return arg # return the same
	structTestStruct3InArg_ = objc.selector(structTestStruct3InArg_, signature="@@:n^{_TestStruct3=ci}")


	def structTestStruct3OutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_structTestStruct3_values[self.counter]
		self.counter += 1
		return res
	structTestStruct3OutArg_ = objc.selector(structTestStruct3OutArg_, signature="v@:o^{_TestStruct3=ci}")


	def structTestStruct3InOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_structTestStruct3_values[self.counter];
		self.counter += 1
		return (arg, res)
	structTestStruct3InOutArg_ = objc.selector(structTestStruct3InOutArg_, signature="@@:N^{_TestStruct3=ci}")


	def structTestStruct4InArg_(self, arg):
		return arg # return the same
	structTestStruct4InArg_ = objc.selector(structTestStruct4InArg_, signature="@@:n^{_TestStruct4=cq}")


	def structTestStruct4OutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_structTestStruct4_values[self.counter]
		self.counter += 1
		return res
	structTestStruct4OutArg_ = objc.selector(structTestStruct4OutArg_, signature="v@:o^{_TestStruct4=cq}")


	def structTestStruct4InOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_structTestStruct4_values[self.counter];
		self.counter += 1
		return (arg, res)
	structTestStruct4InOutArg_ = objc.selector(structTestStruct4InOutArg_, signature="@@:N^{_TestStruct4=cq}")


	def structTestStruct5InArg_(self, arg):
		return arg # return the same
	structTestStruct5InArg_ = objc.selector(structTestStruct5InArg_, signature="@@:n^{_TestStruct5=cd}")


	def structTestStruct5OutArg_(self, arg):
                assert arg is None
		if (self.counter > 2): self.reset()
		res = g_structTestStruct5_values[self.counter]
		self.counter += 1
		return res
	structTestStruct5OutArg_ = objc.selector(structTestStruct5OutArg_, signature="v@:o^{_TestStruct5=cd}")


	def structTestStruct5InOutArg_(self, arg):
		if (self.counter > 2): self.reset()
		res = g_structTestStruct5_values[self.counter];
		self.counter += 1
		return (arg, res)
	structTestStruct5InOutArg_ = objc.selector(structTestStruct5InOutArg_, signature="@@:N^{_TestStruct5=cd}")


class ObjCToPy (TestCase):
	# Test calling Python from Objective-C
	# Simple returns from instance methods

        def testcallboolResult(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                o.reset()
                self.assertEquals(PyObjC_TestClass2.callboolMethodOf_(o), YES)
                self.assertEquals(PyObjC_TestClass2.callboolMethodOf_(o), NO)


        def testinvokeboolResult(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                o.reset()
                self.assertEquals(PyObjC_TestClass2.invokeboolMethodOf_(o), YES)
                self.assertEquals(PyObjC_TestClass2.invokeboolMethodOf_(o), NO)


	def testcallBOOLResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callBOOLMethodOf_(o), YES)
		self.assertEquals(PyObjC_TestClass2.callBOOLMethodOf_(o), NO)


	def testinvokeBOOLResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeBOOLMethodOf_(o), YES)
		self.assertEquals(PyObjC_TestClass2.invokeBOOLMethodOf_(o), NO)


	def testcallcharResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callcharMethodOf_(o), -128)
		self.assertEquals(PyObjC_TestClass2.callcharMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callcharMethodOf_(o), 127)


	def testinvokecharResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokecharMethodOf_(o), -128)
		self.assertEquals(PyObjC_TestClass2.invokecharMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokecharMethodOf_(o), 127)


	def testcallsignedshortResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callsignedshortMethodOf_(o), -(1<<14))
		self.assertEquals(PyObjC_TestClass2.callsignedshortMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.callsignedshortMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callsignedshortMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callsignedshortMethodOf_(o), 1 << 14)


	def testinvokesignedshortResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokesignedshortMethodOf_(o), -(1<<14))
		self.assertEquals(PyObjC_TestClass2.invokesignedshortMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.invokesignedshortMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokesignedshortMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokesignedshortMethodOf_(o), 1 << 14)


	def testcallsignedintResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callsignedintMethodOf_(o), -(1<<30))
		self.assertEquals(PyObjC_TestClass2.callsignedintMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.callsignedintMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callsignedintMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callsignedintMethodOf_(o), 1 << 30)


	def testinvokesignedintResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokesignedintMethodOf_(o), -(1<<30))
		self.assertEquals(PyObjC_TestClass2.invokesignedintMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.invokesignedintMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokesignedintMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokesignedintMethodOf_(o), 1 << 30)


	def testcallsignedlongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callsignedlongMethodOf_(o), -(1<<30))
		self.assertEquals(PyObjC_TestClass2.callsignedlongMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.callsignedlongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callsignedlongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callsignedlongMethodOf_(o), 1 << 30)


	def testinvokesignedlongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokesignedlongMethodOf_(o), -(1<<30))
		self.assertEquals(PyObjC_TestClass2.invokesignedlongMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.invokesignedlongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokesignedlongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokesignedlongMethodOf_(o), 1 << 30)


	def testcallsignedlonglongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), -(1L << 60))
		self.assertEquals(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callsignedlonglongMethodOf_(o), 1L << 60)


	def testinvokesignedlonglongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), -(1L << 60))
		self.assertEquals(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), -42)
		self.assertEquals(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokesignedlonglongMethodOf_(o), 1L << 60)


	def testcallunsignedcharResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callunsignedcharMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callunsignedcharMethodOf_(o), 128)
		self.assertEquals(PyObjC_TestClass2.callunsignedcharMethodOf_(o), 255)


	def testinvokeunsignedcharResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeunsignedcharMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedcharMethodOf_(o), 128)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedcharMethodOf_(o), 255)


	def testcallunsignedshortResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callunsignedshortMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callunsignedshortMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callunsignedshortMethodOf_(o), 1<<14)


	def testinvokeunsignedshortResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeunsignedshortMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedshortMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedshortMethodOf_(o), 1<<14)


	def testcallunsignedintResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callunsignedintMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callunsignedintMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callunsignedintMethodOf_(o), 1 << 30)


	def testinvokeunsignedintResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeunsignedintMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedintMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedintMethodOf_(o), 1 << 30)


	def testcallunsignedlongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callunsignedlongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callunsignedlongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callunsignedlongMethodOf_(o), 1L << 30)


	def testinvokeunsignedlongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeunsignedlongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedlongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedlongMethodOf_(o), 1L << 30)


	def testcallunsignedlonglongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callunsignedlonglongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.callunsignedlonglongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.callunsignedlonglongMethodOf_(o), 1L << 62)


	def testinvokeunsignedlonglongResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeunsignedlonglongMethodOf_(o), 0)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedlonglongMethodOf_(o), 42)
		self.assertEquals(PyObjC_TestClass2.invokeunsignedlonglongMethodOf_(o), 1L << 62)


	def testcallfloatResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertAlmostEquals(PyObjC_TestClass2.callfloatMethodOf_(o), 0.128)
		self.assertAlmostEquals(PyObjC_TestClass2.callfloatMethodOf_(o), 1.0)
		self.assertAlmostEquals(PyObjC_TestClass2.callfloatMethodOf_(o), 42.0)
		self.assertAlmostEquals(PyObjC_TestClass2.callfloatMethodOf_(o), 1e10)


	def testinvokefloatResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertAlmostEquals(PyObjC_TestClass2.invokefloatMethodOf_(o), 0.128)
		self.assertAlmostEquals(PyObjC_TestClass2.invokefloatMethodOf_(o), 1.0)
		self.assertAlmostEquals(PyObjC_TestClass2.invokefloatMethodOf_(o), 42.0)
		self.assertAlmostEquals(PyObjC_TestClass2.invokefloatMethodOf_(o), 1e10)


	def testcalldoubleResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertAlmostEquals(PyObjC_TestClass2.calldoubleMethodOf_(o), 0.128)
		self.assertAlmostEquals(PyObjC_TestClass2.calldoubleMethodOf_(o), 1.0)
		self.assertAlmostEquals(PyObjC_TestClass2.calldoubleMethodOf_(o), 42.0)
		self.assertAlmostEquals(PyObjC_TestClass2.calldoubleMethodOf_(o), 1e10)


	def testinvokedoubleResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertAlmostEquals(PyObjC_TestClass2.invokedoubleMethodOf_(o), 0.128)
		self.assertAlmostEquals(PyObjC_TestClass2.invokedoubleMethodOf_(o), 1.0)
		self.assertAlmostEquals(PyObjC_TestClass2.invokedoubleMethodOf_(o), 42.0)
		self.assertAlmostEquals(PyObjC_TestClass2.invokedoubleMethodOf_(o), 1e10)


	def testcallidResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callidMethodOf_(o), NSPriorDayDesignations)


	def testinvokeidResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeidMethodOf_(o), NSPriorDayDesignations)


	def testcallcharPtrResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callcharPtrMethodOf_(o), "hello")
		self.assertEquals(PyObjC_TestClass2.callcharPtrMethodOf_(o), "world")
		self.assertEquals(PyObjC_TestClass2.callcharPtrMethodOf_(o), "foobar")


	def testinvokecharPtrResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokecharPtrMethodOf_(o), "hello")
		self.assertEquals(PyObjC_TestClass2.invokecharPtrMethodOf_(o), "world")
		self.assertEquals(PyObjC_TestClass2.invokecharPtrMethodOf_(o), "foobar")


	def testcallNSPointResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callNSPointMethodOf_(o), (1, 2))
		self.assertEquals(PyObjC_TestClass2.callNSPointMethodOf_(o), (3, 4))


	def testinvokeNSPointResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeNSPointMethodOf_(o), (1, 2))
		self.assertEquals(PyObjC_TestClass2.invokeNSPointMethodOf_(o), (3, 4))


	def testcallNSRectResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callNSRectMethodOf_(o), ((1, 2), (3, 4)))
		self.assertEquals(PyObjC_TestClass2.callNSRectMethodOf_(o), ((7, 8), (9, 10)))


	def testinvokeNSRectResult(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokeNSRectMethodOf_(o), ((1, 2), (3, 4)))
		self.assertEquals(PyObjC_TestClass2.invokeNSRectMethodOf_(o), ((7, 8), (9, 10)))


	def testcallstructTestStruct1Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct1MethodOf_(o), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct1MethodOf_(o), (9, 8, (-1, -2, -3, -4, -5)))


	def testinvokestructTestStruct1Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct1MethodOf_(o), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct1MethodOf_(o), (9, 8, (-1, -2, -3, -4, -5)))


	def testcallstructTestStruct2Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct2MethodOf_(o), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct2MethodOf_(o), (9, 8, (-1, -2, -3, -4, -5)))


	def testinvokestructTestStruct2Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct2MethodOf_(o), (1, 2, (1, 2, 3, 4, 5)))
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct2MethodOf_(o), (9, 8, (-1, -2, -3, -4, -5)))


	def testcallstructTestStruct3Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct3MethodOf_(o), (1, 2))
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct3MethodOf_(o), (2, 4))


	def testinvokestructTestStruct3Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct3MethodOf_(o), (1, 2))
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct3MethodOf_(o), (2, 4))


	def testcallstructTestStruct4Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct4MethodOf_(o), (1, 1L<<60))
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct4MethodOf_(o), (2, 4))


	def testinvokestructTestStruct4Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct4MethodOf_(o), (1, 1L<<60))
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct4MethodOf_(o), (2, 4))


	def testcallstructTestStruct5Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct5MethodOf_(o), (1, 2.5))
		self.assertEquals(PyObjC_TestClass2.callstructTestStruct5MethodOf_(o), (2, 4.5))


	def testinvokestructTestStruct5Result(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		o.reset()
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct5MethodOf_(o), (1, 2.5))
		self.assertEquals(PyObjC_TestClass2.invokestructTestStruct5MethodOf_(o), (2, 4.5))


	# One argument

        def testcallboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_of_(YES, o)
                self.assertEquals(r, YES)
                r = PyObjC_TestClass2.invokeboolArg_of_(NO, o)
                self.assertEquals(r, NO)


        def testinvokeboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_of_(YES, o)
                self.assertEquals(r, YES)
                r = PyObjC_TestClass2.invokeboolArg_of_(NO, o)
                self.assertEquals(r, NO)


	def testcallBOOLArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_of_(YES, o)
		self.assertEquals(r, YES)
		r = PyObjC_TestClass2.invokeBOOLArg_of_(NO, o)
		self.assertEquals(r, NO)


	def testinvokeBOOLArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_of_(YES, o)
		self.assertEquals(r, YES)
		r = PyObjC_TestClass2.invokeBOOLArg_of_(NO, o)
		self.assertEquals(r, NO)


	def testcallcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_of_(-128, o)
		self.assertEquals(r, -128)
		r = PyObjC_TestClass2.invokecharArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokecharArg_of_(127, o)
		self.assertEquals(r, 127)


	def testinvokecharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_of_(-128, o)
		self.assertEquals(r, -128)
		r = PyObjC_TestClass2.invokecharArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokecharArg_of_(127, o)
		self.assertEquals(r, 127)


	def testcallsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(-(1<<14), o)
		self.assertEquals(r, -(1<<14))
		r = PyObjC_TestClass2.invokesignedshortArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(1 << 14, o)
		self.assertEquals(r, 1 << 14)


	def testinvokesignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(-(1<<14), o)
		self.assertEquals(r, -(1<<14))
		r = PyObjC_TestClass2.invokesignedshortArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedshortArg_of_(1 << 14, o)
		self.assertEquals(r, 1 << 14)


	def testcallsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedintArg_of_(-(1<<30), o)
		self.assertEquals(r, -(1<<30))
		r = PyObjC_TestClass2.invokesignedintArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedintArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedintArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedintArg_of_(1 << 30, o)
		self.assertEquals(r, 1 << 30)


	def testinvokesignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedintArg_of_(-(1<<30), o)
		self.assertEquals(r, -(1<<30))
		r = PyObjC_TestClass2.invokesignedintArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedintArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedintArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedintArg_of_(1 << 30, o)
		self.assertEquals(r, 1 << 30)


	def testcallsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(-(1<<30), o)
		self.assertEquals(r, -(1<<30))
		r = PyObjC_TestClass2.invokesignedlongArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(1 << 30, o)
		self.assertEquals(r, 1 << 30)


	def testinvokesignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(-(1<<30), o)
		self.assertEquals(r, -(1<<30))
		r = PyObjC_TestClass2.invokesignedlongArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedlongArg_of_(1 << 30, o)
		self.assertEquals(r, 1 << 30)


	def testcallsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-(1L << 60), o)
		self.assertEquals(r, -(1L << 60))
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(1L << 60, o)
		self.assertEquals(r, 1L << 60)


	def testinvokesignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-(1L << 60), o)
		self.assertEquals(r, -(1L << 60))
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(-42, o)
		self.assertEquals(r, -42)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokesignedlonglongArg_of_(1L << 60, o)
		self.assertEquals(r, 1L << 60)


	def testcallunsignedcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedcharArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedcharArg_of_(128, o)
		self.assertEquals(r, 128)
		r = PyObjC_TestClass2.invokeunsignedcharArg_of_(255, o)
		self.assertEquals(r, 255)


	def testinvokeunsignedcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedcharArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedcharArg_of_(128, o)
		self.assertEquals(r, 128)
		r = PyObjC_TestClass2.invokeunsignedcharArg_of_(255, o)
		self.assertEquals(r, 255)


	def testcallunsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedshortArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedshortArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedshortArg_of_(1<<14, o)
		self.assertEquals(r, 1<<14)


	def testinvokeunsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedshortArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedshortArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedshortArg_of_(1<<14, o)
		self.assertEquals(r, 1<<14)


	def testcallunsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedintArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedintArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedintArg_of_(1 << 30, o)
		self.assertEquals(r, 1 << 30)


	def testinvokeunsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedintArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedintArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedintArg_of_(1 << 30, o)
		self.assertEquals(r, 1 << 30)


	def testcallunsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedlongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedlongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedlongArg_of_(1L << 30, o)
		self.assertEquals(r, 1L << 30)


	def testinvokeunsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedlongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedlongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedlongArg_of_(1L << 30, o)
		self.assertEquals(r, 1L << 30)


	def testcallunsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(1L << 62, o)
		self.assertEquals(r, 1L << 62)


	def testinvokeunsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(0, o)
		self.assertEquals(r, 0)
		r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(42, o)
		self.assertEquals(r, 42)
		r = PyObjC_TestClass2.invokeunsignedlonglongArg_of_(1L << 62, o)
		self.assertEquals(r, 1L << 62)


	def testcallfloatArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokefloatArg_of_(0.128, o)
		self.assertAlmostEquals(r, 0.128)
		r = PyObjC_TestClass2.invokefloatArg_of_(1.0, o)
		self.assertAlmostEquals(r, 1.0)
		r = PyObjC_TestClass2.invokefloatArg_of_(42.0, o)
		self.assertAlmostEquals(r, 42.0)
		r = PyObjC_TestClass2.invokefloatArg_of_(1e10, o)
		self.assertAlmostEquals(r, 1e10)


	def testinvokefloatArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokefloatArg_of_(0.128, o)
		self.assertAlmostEquals(r, 0.128)
		r = PyObjC_TestClass2.invokefloatArg_of_(1.0, o)
		self.assertAlmostEquals(r, 1.0)
		r = PyObjC_TestClass2.invokefloatArg_of_(42.0, o)
		self.assertAlmostEquals(r, 42.0)
		r = PyObjC_TestClass2.invokefloatArg_of_(1e10, o)
		self.assertAlmostEquals(r, 1e10)


	def testcalldoubleArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokedoubleArg_of_(0.128, o)
		self.assertAlmostEquals(r, 0.128)
		r = PyObjC_TestClass2.invokedoubleArg_of_(1.0, o)
		self.assertAlmostEquals(r, 1.0)
		r = PyObjC_TestClass2.invokedoubleArg_of_(42.0, o)
		self.assertAlmostEquals(r, 42.0)
		r = PyObjC_TestClass2.invokedoubleArg_of_(1e10, o)
		self.assertAlmostEquals(r, 1e10)


	def testinvokedoubleArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokedoubleArg_of_(0.128, o)
		self.assertAlmostEquals(r, 0.128)
		r = PyObjC_TestClass2.invokedoubleArg_of_(1.0, o)
		self.assertAlmostEquals(r, 1.0)
		r = PyObjC_TestClass2.invokedoubleArg_of_(42.0, o)
		self.assertAlmostEquals(r, 42.0)
		r = PyObjC_TestClass2.invokedoubleArg_of_(1e10, o)
		self.assertAlmostEquals(r, 1e10)


	def testcallidArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeidArg_of_(NSPriorDayDesignations, o)
		self.assertEquals(r, NSPriorDayDesignations)


	def testinvokeidArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeidArg_of_(NSPriorDayDesignations, o)
		self.assertEquals(r, NSPriorDayDesignations)


	def testcallcharPtrArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharPtrArg_of_("hello", o)
		self.assertEquals(r, "hello")
		r = PyObjC_TestClass2.invokecharPtrArg_of_("world", o)
		self.assertEquals(r, "world")
		r = PyObjC_TestClass2.invokecharPtrArg_of_("foobar", o)
		self.assertEquals(r, "foobar")


	def testinvokecharPtrArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharPtrArg_of_("hello", o)
		self.assertEquals(r, "hello")
		r = PyObjC_TestClass2.invokecharPtrArg_of_("world", o)
		self.assertEquals(r, "world")
		r = PyObjC_TestClass2.invokecharPtrArg_of_("foobar", o)
		self.assertEquals(r, "foobar")


	def testcallNSPointArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeNSPointArg_of_((1, 2), o)
		self.assertEquals(r, (1, 2))
		r = PyObjC_TestClass2.invokeNSPointArg_of_((3, 4), o)
		self.assertEquals(r, (3, 4))


	def testinvokeNSPointArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeNSPointArg_of_((1, 2), o)
		self.assertEquals(r, (1, 2))
		r = PyObjC_TestClass2.invokeNSPointArg_of_((3, 4), o)
		self.assertEquals(r, (3, 4))


	def testcallNSRectArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeNSRectArg_of_(((1, 2), (3, 4)), o)
		self.assertEquals(r, ((1, 2), (3, 4)))
		r = PyObjC_TestClass2.invokeNSRectArg_of_(((7, 8), (9, 10)), o)
		self.assertEquals(r, ((7, 8), (9, 10)))


	def testinvokeNSRectArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeNSRectArg_of_(((1, 2), (3, 4)), o)
		self.assertEquals(r, ((1, 2), (3, 4)))
		r = PyObjC_TestClass2.invokeNSRectArg_of_(((7, 8), (9, 10)), o)
		self.assertEquals(r, ((7, 8), (9, 10)))


	def testcallstructTestStruct1Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_((9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def testinvokestructTestStruct1Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokestructTestStruct1Arg_of_((9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def testcallstructTestStruct2Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_((9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def testinvokestructTestStruct2Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_((1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r, (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokestructTestStruct2Arg_of_((9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r, (9, 8, (-1, -2, -3, -4, -5)))


	def testcallstructTestStruct3Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((1, 2), o)
		self.assertEquals(r, (1, 2))
		r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((2, 4), o)
		self.assertEquals(r, (2, 4))


	def testinvokestructTestStruct3Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((1, 2), o)
		self.assertEquals(r, (1, 2))
		r = PyObjC_TestClass2.invokestructTestStruct3Arg_of_((2, 4), o)
		self.assertEquals(r, (2, 4))


	def testcallstructTestStruct4Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((1, 1L<<60), o)
		self.assertEquals(r, (1, 1L<<60))
		r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((2, 4), o)
		self.assertEquals(r, (2, 4))


	def testinvokestructTestStruct4Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((1, 1L<<60), o)
		self.assertEquals(r, (1, 1L<<60))
		r = PyObjC_TestClass2.invokestructTestStruct4Arg_of_((2, 4), o)
		self.assertEquals(r, (2, 4))


	def testcallstructTestStruct5Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((1, 2.5), o)
		self.assertEquals(r, (1, 2.5))
		r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((2, 4.5), o)
		self.assertEquals(r, (2, 4.5))


	def testinvokestructTestStruct5Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((1, 2.5), o)
		self.assertEquals(r, (1, 2.5))
		r = PyObjC_TestClass2.invokestructTestStruct5Arg_of_((2, 4.5), o)
		self.assertEquals(r, (2, 4.5))


	# Two arguments

        def testcallboolAndboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andboolArg_of_(YES, YES, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callboolArg_andboolArg_of_(YES, NO, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.callboolArg_andboolArg_of_(NO, YES, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callboolArg_andboolArg_of_(NO, NO, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NO)


        def testinvokeboolAndboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(YES, YES, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(YES, NO, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(NO, YES, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokeboolArg_andboolArg_of_(NO, NO, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NO)


        def testcallboolAndBOOLArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(YES, YES, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(YES, NO, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(NO, YES, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callboolArg_andBOOLArg_of_(NO, NO, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NO)


        def testinvokeboolAndBOOLArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(YES, YES, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(YES, NO, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(NO, YES, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokeboolArg_andBOOLArg_of_(NO, NO, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NO)


        def testcallboolAndcharArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andcharArg_of_(YES, -128, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -128)
                r = PyObjC_TestClass2.callboolArg_andcharArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andcharArg_of_(YES, 127, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 127)
                r = PyObjC_TestClass2.callboolArg_andcharArg_of_(NO, -128, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -128)
                r = PyObjC_TestClass2.callboolArg_andcharArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andcharArg_of_(NO, 127, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 127)


        def testinvokeboolAndcharArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(YES, -128, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -128)
                r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(YES, 127, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 127)
                r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(NO, -128, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -128)
                r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andcharArg_of_(NO, 127, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 127)


        def testcallboolAndsignedshortArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, -(1<<14), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1<<14))
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(YES, 1 << 14, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 14)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, -(1<<14), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1<<14))
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedshortArg_of_(NO, 1 << 14, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 14)


        def testinvokeboolAndsignedshortArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, -(1<<14), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1<<14))
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(YES, 1 << 14, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 14)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, -(1<<14), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1<<14))
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedshortArg_of_(NO, 1 << 14, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 14)


        def testcallboolAndsignedintArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, -(1<<30), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(YES, 1 << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 30)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, -(1<<30), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedintArg_of_(NO, 1 << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 30)


        def testinvokeboolAndsignedintArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, -(1<<30), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(YES, 1 << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 30)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, -(1<<30), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedintArg_of_(NO, 1 << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 30)


        def testcallboolAndsignedlongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, -(1<<30), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(YES, 1 << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 30)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, -(1<<30), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedlongArg_of_(NO, 1 << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 30)


        def testinvokeboolAndsignedlongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, -(1<<30), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(YES, 1 << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 30)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, -(1<<30), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1<<30))
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlongArg_of_(NO, 1 << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 30)


        def testcallboolAndsignedlonglongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, -(1L << 60), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1L << 60))
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(YES, 1L << 60, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1L << 60)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, -(1L << 60), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1L << 60))
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andsignedlonglongArg_of_(NO, 1L << 60, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1L << 60)


        def testinvokeboolAndsignedlonglongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, -(1L << 60), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -(1L << 60))
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, -42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(YES, 1L << 60, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1L << 60)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, -(1L << 60), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -(1L << 60))
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, -42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], -42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andsignedlonglongArg_of_(NO, 1L << 60, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1L << 60)


        def testcallboolAndunsignedcharArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andunsignedcharArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedcharArg_of_(YES, 128, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 128)
                r = PyObjC_TestClass2.callboolArg_andunsignedcharArg_of_(YES, 255, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 255)
                r = PyObjC_TestClass2.callboolArg_andunsignedcharArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedcharArg_of_(NO, 128, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 128)
                r = PyObjC_TestClass2.callboolArg_andunsignedcharArg_of_(NO, 255, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 255)


        def testinvokeboolAndunsignedcharArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedcharArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedcharArg_of_(YES, 128, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 128)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedcharArg_of_(YES, 255, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 255)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedcharArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedcharArg_of_(NO, 128, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 128)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedcharArg_of_(NO, 255, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 255)


        def testcallboolAndunsignedshortArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andunsignedshortArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedshortArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedshortArg_of_(YES, 1<<14, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1<<14)
                r = PyObjC_TestClass2.callboolArg_andunsignedshortArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedshortArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedshortArg_of_(NO, 1<<14, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1<<14)


        def testinvokeboolAndunsignedshortArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedshortArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedshortArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedshortArg_of_(YES, 1<<14, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1<<14)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedshortArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedshortArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedshortArg_of_(NO, 1<<14, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1<<14)


        def testcallboolAndunsignedintArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andunsignedintArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedintArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedintArg_of_(YES, 1 << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 30)
                r = PyObjC_TestClass2.callboolArg_andunsignedintArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedintArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedintArg_of_(NO, 1 << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 30)


        def testinvokeboolAndunsignedintArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedintArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedintArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedintArg_of_(YES, 1 << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1 << 30)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedintArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedintArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedintArg_of_(NO, 1 << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1 << 30)


        def testcallboolAndunsignedlongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andunsignedlongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedlongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedlongArg_of_(YES, 1L << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1L << 30)
                r = PyObjC_TestClass2.callboolArg_andunsignedlongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedlongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedlongArg_of_(NO, 1L << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1L << 30)


        def testinvokeboolAndunsignedlongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlongArg_of_(YES, 1L << 30, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1L << 30)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlongArg_of_(NO, 1L << 30, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1L << 30)


        def testcallboolAndunsignedlonglongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andunsignedlonglongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedlonglongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedlonglongArg_of_(YES, 1L << 62, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1L << 62)
                r = PyObjC_TestClass2.callboolArg_andunsignedlonglongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.callboolArg_andunsignedlonglongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.callboolArg_andunsignedlonglongArg_of_(NO, 1L << 62, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1L << 62)


        def testinvokeboolAndunsignedlonglongArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlonglongArg_of_(YES, 0, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlonglongArg_of_(YES, 42, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlonglongArg_of_(YES, 1L << 62, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], 1L << 62)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlonglongArg_of_(NO, 0, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 0)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlonglongArg_of_(NO, 42, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 42)
                r = PyObjC_TestClass2.invokeboolArg_andunsignedlonglongArg_of_(NO, 1L << 62, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], 1L << 62)


        def testcallboolAndfloatArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(YES, 0.128, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(YES, 1.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(YES, 42.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(YES, 1e10, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1e10)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(NO, 0.128, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(NO, 1.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(NO, 42.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.callboolArg_andfloatArg_of_(NO, 1e10, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1e10)


        def testinvokeboolAndfloatArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(YES, 0.128, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(YES, 1.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(YES, 42.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(YES, 1e10, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1e10)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(NO, 0.128, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(NO, 1.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(NO, 42.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.invokeboolArg_andfloatArg_of_(NO, 1e10, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1e10)


        def testcallboolAnddoubleArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(YES, 0.128, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(YES, 1.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(YES, 42.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(YES, 1e10, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1e10)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(NO, 0.128, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(NO, 1.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(NO, 42.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.callboolArg_anddoubleArg_of_(NO, 1e10, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1e10)


        def testinvokeboolAnddoubleArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(YES, 0.128, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(YES, 1.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(YES, 42.0, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(YES, 1e10, o)
                self.assertEquals(r[0], YES)
                self.assertAlmostEquals(r[1], 1e10)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(NO, 0.128, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 0.128)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(NO, 1.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1.0)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(NO, 42.0, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 42.0)
                r = PyObjC_TestClass2.invokeboolArg_anddoubleArg_of_(NO, 1e10, o)
                self.assertEquals(r[0], NO)
                self.assertAlmostEquals(r[1], 1e10)


        def testcallboolAndidArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andidArg_of_(YES, NSPriorDayDesignations, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NSPriorDayDesignations)
                r = PyObjC_TestClass2.callboolArg_andidArg_of_(NO, NSPriorDayDesignations, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NSPriorDayDesignations)


        def testinvokeboolAndidArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andidArg_of_(YES, NSPriorDayDesignations, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NSPriorDayDesignations)
                r = PyObjC_TestClass2.invokeboolArg_andidArg_of_(NO, NSPriorDayDesignations, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NSPriorDayDesignations)


        def testcallboolAndcharPtrArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andcharPtrArg_of_(YES, "hello", o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], "hello")
                r = PyObjC_TestClass2.callboolArg_andcharPtrArg_of_(YES, "world", o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], "world")
                r = PyObjC_TestClass2.callboolArg_andcharPtrArg_of_(YES, "foobar", o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], "foobar")
                r = PyObjC_TestClass2.callboolArg_andcharPtrArg_of_(NO, "hello", o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], "hello")
                r = PyObjC_TestClass2.callboolArg_andcharPtrArg_of_(NO, "world", o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], "world")
                r = PyObjC_TestClass2.callboolArg_andcharPtrArg_of_(NO, "foobar", o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], "foobar")


        def testinvokeboolAndcharPtrArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andcharPtrArg_of_(YES, "hello", o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], "hello")
                r = PyObjC_TestClass2.invokeboolArg_andcharPtrArg_of_(YES, "world", o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], "world")
                r = PyObjC_TestClass2.invokeboolArg_andcharPtrArg_of_(YES, "foobar", o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], "foobar")
                r = PyObjC_TestClass2.invokeboolArg_andcharPtrArg_of_(NO, "hello", o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], "hello")
                r = PyObjC_TestClass2.invokeboolArg_andcharPtrArg_of_(NO, "world", o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], "world")
                r = PyObjC_TestClass2.invokeboolArg_andcharPtrArg_of_(NO, "foobar", o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], "foobar")


        def testcallboolAndNSPointArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andNSPointArg_of_(YES, (1, 2), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.callboolArg_andNSPointArg_of_(YES, (3, 4), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (3, 4))
                r = PyObjC_TestClass2.callboolArg_andNSPointArg_of_(NO, (1, 2), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.callboolArg_andNSPointArg_of_(NO, (3, 4), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (3, 4))


        def testinvokeboolAndNSPointArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andNSPointArg_of_(YES, (1, 2), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.invokeboolArg_andNSPointArg_of_(YES, (3, 4), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (3, 4))
                r = PyObjC_TestClass2.invokeboolArg_andNSPointArg_of_(NO, (1, 2), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.invokeboolArg_andNSPointArg_of_(NO, (3, 4), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (3, 4))


        def testcallboolAndNSRectArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andNSRectArg_of_(YES, ((1, 2), (3, 4)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], ((1, 2), (3, 4)))
                r = PyObjC_TestClass2.callboolArg_andNSRectArg_of_(YES, ((7, 8), (9, 10)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], ((7, 8), (9, 10)))
                r = PyObjC_TestClass2.callboolArg_andNSRectArg_of_(NO, ((1, 2), (3, 4)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], ((1, 2), (3, 4)))
                r = PyObjC_TestClass2.callboolArg_andNSRectArg_of_(NO, ((7, 8), (9, 10)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], ((7, 8), (9, 10)))


        def testinvokeboolAndNSRectArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andNSRectArg_of_(YES, ((1, 2), (3, 4)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], ((1, 2), (3, 4)))
                r = PyObjC_TestClass2.invokeboolArg_andNSRectArg_of_(YES, ((7, 8), (9, 10)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], ((7, 8), (9, 10)))
                r = PyObjC_TestClass2.invokeboolArg_andNSRectArg_of_(NO, ((1, 2), (3, 4)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], ((1, 2), (3, 4)))
                r = PyObjC_TestClass2.invokeboolArg_andNSRectArg_of_(NO, ((7, 8), (9, 10)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], ((7, 8), (9, 10)))


        def testcallboolAndstructTestStruct1Arg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct1Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct1Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct1Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct1Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


        def testinvokeboolAndstructTestStruct1Arg(self):
                if not nsinvoke_ok:
                        return
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct1Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct1Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct1Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct1Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


        def testcallboolAndstructTestStruct2Arg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct2Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct2Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct2Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct2Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


        def testinvokeboolAndstructTestStruct2Arg(self):
                if not nsinvoke_ok:
                        return
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct2Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct2Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct2Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct2Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


        def testcallboolAndstructTestStruct3Arg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct3Arg_of_(YES, (1, 2), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct3Arg_of_(YES, (2, 4), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (2, 4))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct3Arg_of_(NO, (1, 2), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct3Arg_of_(NO, (2, 4), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (2, 4))


        def testinvokeboolAndstructTestStruct3Arg(self):
                if not nsinvoke_ok:
                        return
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct3Arg_of_(YES, (1, 2), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct3Arg_of_(YES, (2, 4), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (2, 4))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct3Arg_of_(NO, (1, 2), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct3Arg_of_(NO, (2, 4), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (2, 4))


        def testcallboolAndstructTestStruct4Arg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct4Arg_of_(YES, (1, 1L<<60), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 1L<<60))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct4Arg_of_(YES, (2, 4), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (2, 4))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct4Arg_of_(NO, (1, 1L<<60), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 1L<<60))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct4Arg_of_(NO, (2, 4), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (2, 4))


        def testinvokeboolAndstructTestStruct4Arg(self):
                if not nsinvoke_ok:
                        return
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct4Arg_of_(YES, (1, 1L<<60), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 1L<<60))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct4Arg_of_(YES, (2, 4), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (2, 4))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct4Arg_of_(NO, (1, 1L<<60), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 1L<<60))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct4Arg_of_(NO, (2, 4), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (2, 4))


        def testcallboolAndstructTestStruct5Arg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct5Arg_of_(YES, (1, 2.5), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2.5))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct5Arg_of_(YES, (2, 4.5), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (2, 4.5))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct5Arg_of_(NO, (1, 2.5), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2.5))
                r = PyObjC_TestClass2.callboolArg_andstructTestStruct5Arg_of_(NO, (2, 4.5), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (2, 4.5))


        def testinvokeboolAndstructTestStruct5Arg(self):
                if not nsinvoke_ok:
                        return
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct5Arg_of_(YES, (1, 2.5), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (1, 2.5))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct5Arg_of_(YES, (2, 4.5), o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], (2, 4.5))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct5Arg_of_(NO, (1, 2.5), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (1, 2.5))
                r = PyObjC_TestClass2.invokeboolArg_andstructTestStruct5Arg_of_(NO, (2, 4.5), o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], (2, 4.5))


        def testcallBOOLAndboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callBOOLArg_andboolArg_of_(YES, YES, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callBOOLArg_andboolArg_of_(YES, NO, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.callBOOLArg_andboolArg_of_(NO, YES, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callBOOLArg_andboolArg_of_(NO, NO, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NO)


        def testinvokeBOOLAndboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokeBOOLArg_andboolArg_of_(YES, YES, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokeBOOLArg_andboolArg_of_(YES, NO, o)
                self.assertEquals(r[0], YES)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.invokeBOOLArg_andboolArg_of_(NO, YES, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokeBOOLArg_andboolArg_of_(NO, NO, o)
                self.assertEquals(r[0], NO)
                self.assertEquals(r[1], NO)


	def testcallBOOLAndBOOLArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andBOOLArg_of_(YES, YES, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.callBOOLArg_andBOOLArg_of_(YES, NO, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)
		r = PyObjC_TestClass2.callBOOLArg_andBOOLArg_of_(NO, YES, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.callBOOLArg_andBOOLArg_of_(NO, NO, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NO)


	def testinvokeBOOLAndBOOLArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andBOOLArg_of_(YES, YES, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.invokeBOOLArg_andBOOLArg_of_(YES, NO, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NO)
		r = PyObjC_TestClass2.invokeBOOLArg_andBOOLArg_of_(NO, YES, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.invokeBOOLArg_andBOOLArg_of_(NO, NO, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NO)


	def testcallBOOLAndcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andcharArg_of_(YES, -128, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.callBOOLArg_andcharArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andcharArg_of_(YES, 127, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 127)
		r = PyObjC_TestClass2.callBOOLArg_andcharArg_of_(NO, -128, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.callBOOLArg_andcharArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andcharArg_of_(NO, 127, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 127)


	def testinvokeBOOLAndcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andcharArg_of_(YES, -128, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.invokeBOOLArg_andcharArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andcharArg_of_(YES, 127, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 127)
		r = PyObjC_TestClass2.invokeBOOLArg_andcharArg_of_(NO, -128, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.invokeBOOLArg_andcharArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andcharArg_of_(NO, 127, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 127)


	def testcallBOOLAndsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(YES, -(1<<14), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(YES, 1 << 14, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 14)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(NO, -(1<<14), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedshortArg_of_(NO, 1 << 14, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 14)


	def testinvokeBOOLAndsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(YES, -(1<<14), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(YES, 1 << 14, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 14)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(NO, -(1<<14), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedshortArg_of_(NO, 1 << 14, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 14)


	def testcallBOOLAndsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(YES, -(1<<30), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(YES, 1 << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(NO, -(1<<30), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedintArg_of_(NO, 1 << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testinvokeBOOLAndsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(YES, -(1<<30), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(YES, 1 << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(NO, -(1<<30), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedintArg_of_(NO, 1 << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testcallBOOLAndsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(YES, -(1<<30), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(YES, 1 << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(NO, -(1<<30), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlongArg_of_(NO, 1 << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testinvokeBOOLAndsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(YES, -(1<<30), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(YES, 1 << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(NO, -(1<<30), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlongArg_of_(NO, 1 << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testcallBOOLAndsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(YES, -(1L << 60), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(YES, 1L << 60, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 60)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(NO, -(1L << 60), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andsignedlonglongArg_of_(NO, 1L << 60, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 60)


	def testinvokeBOOLAndsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(YES, -(1L << 60), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(YES, -42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(YES, 1L << 60, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 60)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(NO, -(1L << 60), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(NO, -42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andsignedlonglongArg_of_(NO, 1L << 60, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 60)


	def testcallBOOLAndunsignedcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedcharArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedcharArg_of_(YES, 128, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedcharArg_of_(YES, 255, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 255)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedcharArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedcharArg_of_(NO, 128, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedcharArg_of_(NO, 255, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 255)


	def testinvokeBOOLAndunsignedcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedcharArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedcharArg_of_(YES, 128, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedcharArg_of_(YES, 255, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 255)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedcharArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedcharArg_of_(NO, 128, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedcharArg_of_(NO, 255, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 255)


	def testcallBOOLAndunsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedshortArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedshortArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedshortArg_of_(YES, 1<<14, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1<<14)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedshortArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedshortArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedshortArg_of_(NO, 1<<14, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1<<14)


	def testinvokeBOOLAndunsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedshortArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedshortArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedshortArg_of_(YES, 1<<14, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1<<14)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedshortArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedshortArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedshortArg_of_(NO, 1<<14, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1<<14)


	def testcallBOOLAndunsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedintArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedintArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedintArg_of_(YES, 1 << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedintArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedintArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedintArg_of_(NO, 1 << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testinvokeBOOLAndunsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedintArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedintArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedintArg_of_(YES, 1 << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedintArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedintArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedintArg_of_(NO, 1 << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1 << 30)


	def testcallBOOLAndunsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlongArg_of_(YES, 1L << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 30)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlongArg_of_(NO, 1L << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 30)


	def testinvokeBOOLAndunsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlongArg_of_(YES, 1L << 30, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 30)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlongArg_of_(NO, 1L << 30, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 30)


	def testcallBOOLAndunsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlonglongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlonglongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlonglongArg_of_(YES, 1L << 62, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 62)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlonglongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlonglongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callBOOLArg_andunsignedlonglongArg_of_(NO, 1L << 62, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 62)


	def testinvokeBOOLAndunsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlonglongArg_of_(YES, 0, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlonglongArg_of_(YES, 42, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlonglongArg_of_(YES, 1L << 62, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], 1L << 62)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlonglongArg_of_(NO, 0, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlonglongArg_of_(NO, 42, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokeBOOLArg_andunsignedlonglongArg_of_(NO, 1L << 62, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], 1L << 62)


	def testcallBOOLAndfloatArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(YES, 0.128, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(YES, 1.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(YES, 42.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(YES, 1e10, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(NO, 0.128, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(NO, 1.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(NO, 42.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.callBOOLArg_andfloatArg_of_(NO, 1e10, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testinvokeBOOLAndfloatArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(YES, 0.128, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(YES, 1.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(YES, 42.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(YES, 1e10, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(NO, 0.128, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(NO, 1.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(NO, 42.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.invokeBOOLArg_andfloatArg_of_(NO, 1e10, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testcallBOOLAnddoubleArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(YES, 0.128, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(YES, 1.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(YES, 42.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(YES, 1e10, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(NO, 0.128, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(NO, 1.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(NO, 42.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.callBOOLArg_anddoubleArg_of_(NO, 1e10, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testinvokeBOOLAnddoubleArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(YES, 0.128, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(YES, 1.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(YES, 42.0, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(YES, 1e10, o)
		self.assertEquals(r[0], YES)
		self.assertAlmostEquals(r[1], 1e10)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(NO, 0.128, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 0.128)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(NO, 1.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1.0)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(NO, 42.0, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 42.0)
		r = PyObjC_TestClass2.invokeBOOLArg_anddoubleArg_of_(NO, 1e10, o)
		self.assertEquals(r[0], NO)
		self.assertAlmostEquals(r[1], 1e10)


	def testcallBOOLAndidArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andidArg_of_(YES, NSPriorDayDesignations, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = PyObjC_TestClass2.callBOOLArg_andidArg_of_(NO, NSPriorDayDesignations, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testinvokeBOOLAndidArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andidArg_of_(YES, NSPriorDayDesignations, o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], NSPriorDayDesignations)
		r = PyObjC_TestClass2.invokeBOOLArg_andidArg_of_(NO, NSPriorDayDesignations, o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], NSPriorDayDesignations)


	def testcallBOOLAndcharPtrArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andcharPtrArg_of_(YES, "hello", o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "hello")
		r = PyObjC_TestClass2.callBOOLArg_andcharPtrArg_of_(YES, "world", o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "world")
		r = PyObjC_TestClass2.callBOOLArg_andcharPtrArg_of_(YES, "foobar", o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "foobar")
		r = PyObjC_TestClass2.callBOOLArg_andcharPtrArg_of_(NO, "hello", o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "hello")
		r = PyObjC_TestClass2.callBOOLArg_andcharPtrArg_of_(NO, "world", o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "world")
		r = PyObjC_TestClass2.callBOOLArg_andcharPtrArg_of_(NO, "foobar", o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "foobar")


	def testinvokeBOOLAndcharPtrArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andcharPtrArg_of_(YES, "hello", o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "hello")
		r = PyObjC_TestClass2.invokeBOOLArg_andcharPtrArg_of_(YES, "world", o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "world")
		r = PyObjC_TestClass2.invokeBOOLArg_andcharPtrArg_of_(YES, "foobar", o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], "foobar")
		r = PyObjC_TestClass2.invokeBOOLArg_andcharPtrArg_of_(NO, "hello", o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "hello")
		r = PyObjC_TestClass2.invokeBOOLArg_andcharPtrArg_of_(NO, "world", o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "world")
		r = PyObjC_TestClass2.invokeBOOLArg_andcharPtrArg_of_(NO, "foobar", o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], "foobar")


	def testcallBOOLAndNSPointArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andNSPointArg_of_(YES, (1, 2), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.callBOOLArg_andNSPointArg_of_(YES, (3, 4), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (3, 4))
		r = PyObjC_TestClass2.callBOOLArg_andNSPointArg_of_(NO, (1, 2), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.callBOOLArg_andNSPointArg_of_(NO, (3, 4), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (3, 4))


	def testinvokeBOOLAndNSPointArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andNSPointArg_of_(YES, (1, 2), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.invokeBOOLArg_andNSPointArg_of_(YES, (3, 4), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (3, 4))
		r = PyObjC_TestClass2.invokeBOOLArg_andNSPointArg_of_(NO, (1, 2), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.invokeBOOLArg_andNSPointArg_of_(NO, (3, 4), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (3, 4))


	def testcallBOOLAndNSRectArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andNSRectArg_of_(YES, ((1, 2), (3, 4)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = PyObjC_TestClass2.callBOOLArg_andNSRectArg_of_(YES, ((7, 8), (9, 10)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = PyObjC_TestClass2.callBOOLArg_andNSRectArg_of_(NO, ((1, 2), (3, 4)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = PyObjC_TestClass2.callBOOLArg_andNSRectArg_of_(NO, ((7, 8), (9, 10)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testinvokeBOOLAndNSRectArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andNSRectArg_of_(YES, ((1, 2), (3, 4)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = PyObjC_TestClass2.invokeBOOLArg_andNSRectArg_of_(YES, ((7, 8), (9, 10)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], ((7, 8), (9, 10)))
		r = PyObjC_TestClass2.invokeBOOLArg_andNSRectArg_of_(NO, ((1, 2), (3, 4)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((1, 2), (3, 4)))
		r = PyObjC_TestClass2.invokeBOOLArg_andNSRectArg_of_(NO, ((7, 8), (9, 10)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], ((7, 8), (9, 10)))


	def testcallBOOLAndstructTestStruct1Arg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct1Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct1Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct1Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct1Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testinvokeBOOLAndstructTestStruct1Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct1Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct1Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct1Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct1Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testcallBOOLAndstructTestStruct2Arg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct2Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct2Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct2Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct2Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testinvokeBOOLAndstructTestStruct2Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct2Arg_of_(YES, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct2Arg_of_(YES, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct2Arg_of_(NO, (1, 2, (1, 2, 3, 4, 5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2, (1, 2, 3, 4, 5)))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct2Arg_of_(NO, (9, 8, (-1, -2, -3, -4, -5)), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (9, 8, (-1, -2, -3, -4, -5)))


	def testcallBOOLAndstructTestStruct3Arg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct3Arg_of_(YES, (1, 2), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct3Arg_of_(YES, (2, 4), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct3Arg_of_(NO, (1, 2), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct3Arg_of_(NO, (2, 4), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testinvokeBOOLAndstructTestStruct3Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct3Arg_of_(YES, (1, 2), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct3Arg_of_(YES, (2, 4), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct3Arg_of_(NO, (1, 2), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct3Arg_of_(NO, (2, 4), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testcallBOOLAndstructTestStruct4Arg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct4Arg_of_(YES, (1, 1L<<60), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 1L<<60))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct4Arg_of_(YES, (2, 4), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct4Arg_of_(NO, (1, 1L<<60), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 1L<<60))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct4Arg_of_(NO, (2, 4), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testinvokeBOOLAndstructTestStruct4Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct4Arg_of_(YES, (1, 1L<<60), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 1L<<60))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct4Arg_of_(YES, (2, 4), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct4Arg_of_(NO, (1, 1L<<60), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 1L<<60))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct4Arg_of_(NO, (2, 4), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4))


	def testcallBOOLAndstructTestStruct5Arg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct5Arg_of_(YES, (1, 2.5), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2.5))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct5Arg_of_(YES, (2, 4.5), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4.5))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct5Arg_of_(NO, (1, 2.5), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2.5))
		r = PyObjC_TestClass2.callBOOLArg_andstructTestStruct5Arg_of_(NO, (2, 4.5), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4.5))


	def testinvokeBOOLAndstructTestStruct5Arg(self):
		if not nsinvoke_ok:
			return
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct5Arg_of_(YES, (1, 2.5), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (1, 2.5))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct5Arg_of_(YES, (2, 4.5), o)
		self.assertEquals(r[0], YES)
		self.assertEquals(r[1], (2, 4.5))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct5Arg_of_(NO, (1, 2.5), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (1, 2.5))
		r = PyObjC_TestClass2.invokeBOOLArg_andstructTestStruct5Arg_of_(NO, (2, 4.5), o)
		self.assertEquals(r[0], NO)
		self.assertEquals(r[1], (2, 4.5))


        def testcallcharAndboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.callcharArg_andboolArg_of_(-128, YES, o)
                self.assertEquals(r[0], -128)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callcharArg_andboolArg_of_(-128, NO, o)
                self.assertEquals(r[0], -128)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.callcharArg_andboolArg_of_(0, YES, o)
                self.assertEquals(r[0], 0)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callcharArg_andboolArg_of_(0, NO, o)
                self.assertEquals(r[0], 0)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.callcharArg_andboolArg_of_(127, YES, o)
                self.assertEquals(r[0], 127)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.callcharArg_andboolArg_of_(127, NO, o)
                self.assertEquals(r[0], 127)
                self.assertEquals(r[1], NO)


        def testinvokecharAndboolArg(self):
                o = Python_TestClass.alloc().init()
                self.assert_(o is not None)
                r = PyObjC_TestClass2.invokecharArg_andboolArg_of_(-128, YES, o)
                self.assertEquals(r[0], -128)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokecharArg_andboolArg_of_(-128, NO, o)
                self.assertEquals(r[0], -128)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.invokecharArg_andboolArg_of_(0, YES, o)
                self.assertEquals(r[0], 0)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokecharArg_andboolArg_of_(0, NO, o)
                self.assertEquals(r[0], 0)
                self.assertEquals(r[1], NO)
                r = PyObjC_TestClass2.invokecharArg_andboolArg_of_(127, YES, o)
                self.assertEquals(r[0], 127)
                self.assertEquals(r[1], YES)
                r = PyObjC_TestClass2.invokecharArg_andboolArg_of_(127, NO, o)
                self.assertEquals(r[0], 127)
                self.assertEquals(r[1], NO)


	def testcallcharAndBOOLArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andBOOLArg_of_(-128, YES, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.callcharArg_andBOOLArg_of_(-128, NO, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], NO)
		r = PyObjC_TestClass2.callcharArg_andBOOLArg_of_(0, YES, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.callcharArg_andBOOLArg_of_(0, NO, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = PyObjC_TestClass2.callcharArg_andBOOLArg_of_(127, YES, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.callcharArg_andBOOLArg_of_(127, NO, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], NO)


	def testinvokecharAndBOOLArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_andBOOLArg_of_(-128, YES, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.invokecharArg_andBOOLArg_of_(-128, NO, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], NO)
		r = PyObjC_TestClass2.invokecharArg_andBOOLArg_of_(0, YES, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.invokecharArg_andBOOLArg_of_(0, NO, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], NO)
		r = PyObjC_TestClass2.invokecharArg_andBOOLArg_of_(127, YES, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], YES)
		r = PyObjC_TestClass2.invokecharArg_andBOOLArg_of_(127, NO, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], NO)


	def testcallcharAndcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(-128, -128, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(-128, 127, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 127)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(0, -128, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(0, 127, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(127, -128, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andcharArg_of_(127, 127, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 127)


	def testinvokecharAndcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(-128, -128, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(-128, 127, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 127)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(0, -128, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(0, 127, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 127)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(127, -128, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -128)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andcharArg_of_(127, 127, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 127)


	def testcallcharAndsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(-128, -(1<<14), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(-128, 1 << 14, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 14)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(0, -(1<<14), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(0, 1 << 14, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(127, -(1<<14), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedshortArg_of_(127, 1 << 14, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 14)


	def testinvokecharAndsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(-128, -(1<<14), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(-128, 1 << 14, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 14)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(0, -(1<<14), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(0, 1 << 14, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 14)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(127, -(1<<14), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<14))
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedshortArg_of_(127, 1 << 14, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 14)


	def testcallcharAndsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(-128, -(1<<30), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(-128, 1 << 30, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(0, -(1<<30), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(0, 1 << 30, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(127, -(1<<30), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedintArg_of_(127, 1 << 30, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 30)


	def testinvokecharAndsignedintArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(-128, -(1<<30), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(-128, 1 << 30, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(0, -(1<<30), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(0, 1 << 30, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(127, -(1<<30), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedintArg_of_(127, 1 << 30, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 30)


	def testcallcharAndsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(-128, -(1<<30), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(-128, 1 << 30, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(0, -(1<<30), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(0, 1 << 30, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(127, -(1<<30), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedlongArg_of_(127, 1 << 30, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 30)


	def testinvokecharAndsignedlongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(-128, -(1<<30), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(-128, 1 << 30, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(0, -(1<<30), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(0, 1 << 30, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1 << 30)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(127, -(1<<30), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1<<30))
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlongArg_of_(127, 1 << 30, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1 << 30)


	def testcallcharAndsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(-128, -(1L << 60), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(-128, 1L << 60, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1L << 60)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(0, -(1L << 60), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(0, 1L << 60, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(127, -(1L << 60), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andsignedlonglongArg_of_(127, 1L << 60, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1L << 60)


	def testinvokecharAndsignedlonglongArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(-128, -(1L << 60), o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(-128, -42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(-128, 1L << 60, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1L << 60)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(0, -(1L << 60), o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(0, -42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(0, 42, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(0, 1L << 60, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 1L << 60)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(127, -(1L << 60), o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -(1L << 60))
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(127, -42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], -42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(127, 42, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.invokecharArg_andsignedlonglongArg_of_(127, 1L << 60, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 1L << 60)


	def testcallcharAndunsignedcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(-128, 128, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(-128, 255, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 255)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(0, 128, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(0, 255, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(127, 128, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.callcharArg_andunsignedcharArg_of_(127, 255, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 255)


	def testinvokecharAndunsignedcharArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(-128, 128, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(-128, 255, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 255)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(0, 128, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(0, 255, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 255)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(127, 0, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(127, 128, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 128)
		r = PyObjC_TestClass2.invokecharArg_andunsignedcharArg_of_(127, 255, o)
		self.assertEquals(r[0], 127)
		self.assertEquals(r[1], 255)


	def testcallcharAndunsignedshortArg(self):
		o = Python_TestClass.alloc().init()
		self.assert_(o is not None)
		r = PyObjC_TestClass2.callcharArg_andunsignedshortArg_of_(-128, 0, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andunsignedshortArg_of_(-128, 42, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 42)
		r = PyObjC_TestClass2.callcharArg_andunsignedshortArg_of_(-128, 1<<14, o)
		self.assertEquals(r[0], -128)
		self.assertEquals(r[1], 1<<14)
		r = PyObjC_TestClass2.callcharArg_andunsignedshortArg_of_(0, 0, o)
		self.assertEquals(r[0], 0)
		self.assertEquals(r[1], 0)
		r = PyObjC_TestClass2.callcharArg_andunsignedshortArg_