"""
Chromsize dictionaries, as downloaded from UCSC.  Need more? Use::

    pybedtools.get_chromsizes_from_ucsc('assemblyname')

"""
# Figure out which version of OrderedDict we want....
import sys
if (sys.version_info[0] == 2) and (sys.version_info[1] < 7):
    from ordereddict import OrderedDict
else:
    from collections import OrderedDict


dm3 = OrderedDict((
    ('chr2L', (0, 23011544)),
    ('chr2R', (0, 21146708)),
    ('chr3L', (0, 24543557)),
    ('chr3R', (0, 27905053)),
    ('chr4', (0, 1351857)),
    ('chrX', (0, 22422827)),
    ('chr2LHet', (0, 368872)),
    ('chr2RHet', (0, 3288761)),
    ('chr3LHet', (0, 2555491)),
    ('chr3RHet', (0, 2517507)),
    ('chrM', (0, 19517)),
    ('chrU', (0, 10049037)),
    ('chrUextra', (0, 29004656)),
    ('chrXHet', (0, 204112)),
    ('chrYHet', (0, 347038)),
))

# No chrUextra or chrM
dm3.default = OrderedDict()
for chrom, size in dm3.items():
    if chrom in ['chrUextra', 'chrM']:
        continue
    dm3.default[chrom] = size

# No chrU*, chr*Het, or chrM
dm3.euchromatic = OrderedDict()
for chrom, size in dm3.default.items():
    if 'chrU' in chrom:
        continue
    if 'Het' in chrom:
        continue
    dm3.euchromatic[chrom] = size


mm9 = OrderedDict((
    ('chr1', (0, 197195432)),
    ('chr2', (0, 181748087)),
    ('chr3', (0, 159599783)),
    ('chr4', (0, 155630120)),
    ('chr5', (0, 152537259)),
    ('chr6', (0, 149517037)),
    ('chr7', (0, 152524553)),
    ('chr8', (0, 131738871)),
    ('chr9', (0, 124076172)),
    ('chr10', (0, 129993255)),
    ('chr11', (0, 121843856)),
    ('chr12', (0, 121257530)),
    ('chr13', (0, 120284312)),
    ('chr14', (0, 125194864)),
    ('chr15', (0, 103494974)),
    ('chr16', (0, 98319150)),
    ('chr17', (0, 95272651)),
    ('chr18', (0, 90772031)),
    ('chr19', (0, 61342430)),
    ('chrX', (0, 166650296)),
    ('chrY', (0, 15902555)),
    ('chrM', (0, 16299)),
    ('chr13_random', (0, 400311)),
    ('chr16_random', (0, 3994)),
    ('chr17_random', (0, 628739)),
    ('chr1_random', (0, 1231697)),
    ('chr3_random', (0, 41899)),
    ('chr4_random', (0, 160594)),
    ('chr5_random', (0, 357350)),
    ('chr7_random', (0, 362490)),
    ('chr8_random', (0, 849593)),
    ('chr9_random', (0, 449403)),
    ('chrUn_random', (0, 5900358)),
    ('chrX_random', (0, 1785075)),
    ('chrY_random', (0, 58682461)),
))

mm9.default = OrderedDict()
for chrom, size in mm9.items():
    if '_random' in chrom:
        continue
    if chrom == 'chrM':
        continue
    mm9.default[chrom] = size


hg18 = OrderedDict((
    ('chr1', (0, 247249719)),
    ('chr2', (0, 242951149)),
    ('chr3', (0, 199501827)),
    ('chr4', (0, 191273063)),
    ('chr5', (0, 180857866)),
    ('chr6', (0, 170899992)),
    ('chr7', (0, 158821424)),
    ('chr8', (0, 146274826)),
    ('chr9', (0, 140273252)),
    ('chr10', (0, 135374737)),
    ('chr11', (0, 134452384)),
    ('chr12', (0, 132349534)),
    ('chr13', (0, 114142980)),
    ('chr14', (0, 106368585)),
    ('chr15', (0, 100338915)),
    ('chr16', (0, 88827254)),
    ('chr17', (0, 78774742)),
    ('chr18', (0, 76117153)),
    ('chr19', (0, 63811651)),
    ('chr20', (0, 62435964)),
    ('chr21', (0, 46944323)),
    ('chr22', (0, 49691432)),
    ('chrX', (0, 154913754)),
    ('chrY', (0, 57772954)),
    ('chrM', (0, 16571)),
    ('chr10_random', (0, 113275)),
    ('chr11_random', (0, 215294)),
    ('chr13_random', (0, 186858)),
    ('chr15_random', (0, 784346)),
    ('chr16_random', (0, 105485)),
    ('chr17_random', (0, 2617613)),
    ('chr18_random', (0, 4262)),
    ('chr19_random', (0, 301858)),
    ('chr1_random', (0, 1663265)),
    ('chr21_random', (0, 1679693)),
    ('chr22_h2_hap1', (0, 63661)),
    ('chr22_random', (0, 257318)),
    ('chr2_random', (0, 185571)),
    ('chr3_random', (0, 749256)),
    ('chr4_random', (0, 842648)),
    ('chr5_h2_hap1', (0, 1794870)),
    ('chr5_random', (0, 143687)),
    ('chr6_cox_hap1', (0, 4731698)),
    ('chr6_qbl_hap2', (0, 4565931)),
    ('chr6_random', (0, 1875562)),
    ('chr7_random', (0, 549659)),
    ('chr8_random', (0, 943810)),
    ('chr9_random', (0, 1146434)),
    ('chrX_random', (0, 1719168)),
))

hg18.default = OrderedDict()
for chrom, size in hg18.items():
    if '_' in chrom:
        continue
    if chrom == 'chrM':
        continue
    hg18.default[chrom] = size


hg19 = OrderedDict((
    ('chr1', (0, 249250621)),
    ('chr2', (0, 243199373)),
    ('chr3', (0, 198022430)),
    ('chr4', (0, 191154276)),
    ('chr5', (0, 180915260)),
    ('chr6', (0, 171115067)),
    ('chr7', (0, 159138663)),
    ('chr8', (0, 146364022)),
    ('chr9', (0, 141213431)),
    ('chr10', (0, 135534747)),
    ('chr11', (0, 135006516)),
    ('chr12', (0, 133851895)),
    ('chr13', (0, 115169878)),
    ('chr14', (0, 107349540)),
    ('chr15', (0, 102531392)),
    ('chr16', (0, 90354753)),
    ('chr17', (0, 81195210)),
    ('chr18', (0, 78077248)),
    ('chr19', (0, 59128983)),
    ('chr20', (0, 63025520)),
    ('chr21', (0, 48129895)),
    ('chr22', (0, 51304566)),
    ('chrX', (0, 155270560)),
    ('chrY', (0, 59373566)),
    ('chrM', (0, 16571)),
    ('chr6_ssto_hap7', (0, 4928567)),
    ('chr6_mcf_hap5', (0, 4833398)),
    ('chr6_cox_hap2', (0, 4795371)),
    ('chr6_mann_hap4', (0, 4683263)),
    ('chr6_apd_hap1', (0, 4622290)),
    ('chr6_qbl_hap6', (0, 4611984)),
    ('chr6_dbb_hap3', (0, 4610396)),
    ('chr17_ctg5_hap1', (0, 1680828)),
    ('chr4_ctg9_hap1', (0, 590426)),
    ('chr1_gl000192_random', (0, 547496)),
    ('chrUn_gl000225', (0, 211173)),
    ('chr4_gl000194_random', (0, 191469)),
    ('chr4_gl000193_random', (0, 189789)),
    ('chr9_gl000200_random', (0, 187035)),
    ('chrUn_gl000222', (0, 186861)),
    ('chrUn_gl000212', (0, 186858)),
    ('chr7_gl000195_random', (0, 182896)),
    ('chrUn_gl000223', (0, 180455)),
    ('chrUn_gl000224', (0, 179693)),
    ('chrUn_gl000219', (0, 179198)),
    ('chr17_gl000205_random', (0, 174588)),
    ('chrUn_gl000215', (0, 172545)),
    ('chrUn_gl000216', (0, 172294)),
    ('chrUn_gl000217', (0, 172149)),
    ('chr9_gl000199_random', (0, 169874)),
    ('chrUn_gl000211', (0, 166566)),
    ('chrUn_gl000213', (0, 164239)),
    ('chrUn_gl000220', (0, 161802)),
    ('chrUn_gl000218', (0, 161147)),
    ('chr19_gl000209_random', (0, 159169)),
    ('chrUn_gl000221', (0, 155397)),
    ('chrUn_gl000214', (0, 137718)),
    ('chrUn_gl000228', (0, 129120)),
    ('chrUn_gl000227', (0, 128374)),
    ('chr1_gl000191_random', (0, 106433)),
    ('chr19_gl000208_random', (0, 92689)),
    ('chr9_gl000198_random', (0, 90085)),
    ('chr17_gl000204_random', (0, 81310)),
    ('chrUn_gl000233', (0, 45941)),
    ('chrUn_gl000237', (0, 45867)),
    ('chrUn_gl000230', (0, 43691)),
    ('chrUn_gl000242', (0, 43523)),
    ('chrUn_gl000243', (0, 43341)),
    ('chrUn_gl000241', (0, 42152)),
    ('chrUn_gl000236', (0, 41934)),
    ('chrUn_gl000240', (0, 41933)),
    ('chr17_gl000206_random', (0, 41001)),
    ('chrUn_gl000232', (0, 40652)),
    ('chrUn_gl000234', (0, 40531)),
    ('chr11_gl000202_random', (0, 40103)),
    ('chrUn_gl000238', (0, 39939)),
    ('chrUn_gl000244', (0, 39929)),
    ('chrUn_gl000248', (0, 39786)),
    ('chr8_gl000196_random', (0, 38914)),
    ('chrUn_gl000249', (0, 38502)),
    ('chrUn_gl000246', (0, 38154)),
    ('chr17_gl000203_random', (0, 37498)),
    ('chr8_gl000197_random', (0, 37175)),
    ('chrUn_gl000245', (0, 36651)),
    ('chrUn_gl000247', (0, 36422)),
    ('chr9_gl000201_random', (0, 36148)),
    ('chrUn_gl000235', (0, 34474)),
    ('chrUn_gl000239', (0, 33824)),
    ('chr21_gl000210_random', (0, 27682)),
    ('chrUn_gl000231', (0, 27386)),
    ('chrUn_gl000229', (0, 19913)),
    ('chrUn_gl000226', (0, 15008)),
    ('chr18_gl000207_random', (0, 4262)),
))

hg19.default = OrderedDict()
for chrom, size in hg19.items():
    if '_' in chrom:
        continue
    if chrom == 'chrM':
        continue
    hg19.default[chrom] = size



hg38 = OrderedDict((
    ('chr1', (0, 248956422)),
    ('chr2', (0, 242193529)),
    ('chr3', (0, 198295559)),
    ('chr4', (0, 190214555)),
    ('chr5', (0, 181538259)),
    ('chr6', (0, 170805979)),
    ('chr7', (0, 159345973)),
    ('chrX', (0, 156040895)),
    ('chr8', (0, 145138636)),
    ('chr9', (0, 138394717)),
    ('chr11', (0, 135086622)),
    ('chr10', (0, 133797422)),
    ('chr12', (0, 133275309)),
    ('chr13', (0, 114364328)),
    ('chr14', (0, 107043718)),
    ('chr15', (0, 101991189)),
    ('chr16', (0, 90338345)),
    ('chr17', (0, 83257441)),
    ('chr18', (0, 80373285)),
    ('chr20', (0, 64444167)),
    ('chr19', (0, 58617616)),
    ('chrY', (0, 57227415)),
    ('chr22', (0, 50818468)),
    ('chr21', (0, 46709983)),
    ('chr15_KI270905v1_alt', (0, 5161414)),
    ('chr6_GL000256v2_alt', (0, 4929269)),
    ('chr6_GL000254v2_alt', (0, 4827813)),
    ('chr6_GL000251v2_alt', (0, 4795265)),
    ('chr6_GL000253v2_alt', (0, 4677643)),
    ('chr6_GL000250v2_alt', (0, 4672374)),
    ('chr6_GL000255v2_alt', (0, 4606388)),
    ('chr6_GL000252v2_alt', (0, 4604811)),
    ('chr17_KI270857v1_alt', (0, 2877074)),
    ('chr16_KI270853v1_alt', (0, 2659700)),
    ('chr16_KI270728v1_random', (0, 1872759)),
    ('chr17_GL000258v2_alt', (0, 1821992)),
    ('chr5_GL339449v2_alt', (0, 1612928)),
    ('chr14_KI270847v1_alt', (0, 1511111)),
    ('chr17_KI270908v1_alt', (0, 1423190)),
    ('chr14_KI270846v1_alt', (0, 1351393)),
    ('chr5_KI270897v1_alt', (0, 1144418)),
    ('chr7_KI270803v1_alt', (0, 1111570)),
    ('chr19_GL949749v2_alt', (0, 1091841)),
    ('chr19_KI270938v1_alt', (0, 1066800)),
    ('chr19_GL949750v2_alt', (0, 1066390)),
    ('chr19_GL949748v2_alt', (0, 1064304)),
    ('chr19_GL949751v2_alt', (0, 1002683)),
    ('chr19_GL949746v1_alt', (0, 987716)),
    ('chr19_GL949752v1_alt', (0, 987100)),
    ('chr8_KI270821v1_alt', (0, 985506)),
    ('chr1_KI270763v1_alt', (0, 911658)),
    ('chr6_KI270801v1_alt', (0, 870480)),
    ('chr19_GL949753v2_alt', (0, 796479)),
    ('chr19_GL949747v2_alt', (0, 729520)),
    ('chr8_KI270822v1_alt', (0, 624492)),
    ('chr4_GL000257v2_alt', (0, 586476)),
    ('chr12_KI270904v1_alt', (0, 572349)),
    ('chr4_KI270925v1_alt', (0, 555799)),
    ('chr15_KI270852v1_alt', (0, 478999)),
    ('chr15_KI270727v1_random', (0, 448248)),
    ('chr9_KI270823v1_alt', (0, 439082)),
    ('chr15_KI270850v1_alt', (0, 430880)),
    ('chr1_KI270759v1_alt', (0, 425601)),
    ('chr12_GL877876v1_alt', (0, 408271)),
    ('chrUn_KI270442v1', (0, 392061)),
    ('chr17_KI270862v1_alt', (0, 391357)),
    ('chr15_GL383555v2_alt', (0, 388773)),
    ('chr19_GL383573v1_alt', (0, 385657)),
    ('chr4_KI270896v1_alt', (0, 378547)),
    ('chr4_GL383528v1_alt', (0, 376187)),
    ('chr17_GL383563v3_alt', (0, 375691)),
    ('chr8_KI270810v1_alt', (0, 374415)),
    ('chr1_GL383520v2_alt', (0, 366580)),
    ('chr1_KI270762v1_alt', (0, 354444)),
    ('chr15_KI270848v1_alt', (0, 327382)),
    ('chr17_KI270909v1_alt', (0, 325800)),
    ('chr14_KI270844v1_alt', (0, 322166)),
    ('chr8_KI270900v1_alt', (0, 318687)),
    ('chr10_GL383546v1_alt', (0, 309802)),
    ('chr13_KI270838v1_alt', (0, 306913)),
    ('chr8_KI270816v1_alt', (0, 305841)),
    ('chr22_KI270879v1_alt', (0, 304135)),
    ('chr8_KI270813v1_alt', (0, 300230)),
    ('chr11_KI270831v1_alt', (0, 296895)),
    ('chr15_GL383554v1_alt', (0, 296527)),
    ('chr8_KI270811v1_alt', (0, 292436)),
    ('chr18_GL383567v1_alt', (0, 289831)),
    ('chrX_KI270880v1_alt', (0, 284869)),
    ('chr8_KI270812v1_alt', (0, 282736)),
    ('chr19_KI270921v1_alt', (0, 282224)),
    ('chr17_KI270729v1_random', (0, 280839)),
    ('chr17_JH159146v1_alt', (0, 278131)),
    ('chrX_KI270913v1_alt', (0, 274009)),
    ('chr6_KI270798v1_alt', (0, 271782)),
    ('chr7_KI270808v1_alt', (0, 271455)),
    ('chr22_KI270876v1_alt', (0, 263666)),
    ('chr15_KI270851v1_alt', (0, 263054)),
    ('chr22_KI270875v1_alt', (0, 259914)),
    ('chr1_KI270766v1_alt', (0, 256271)),
    ('chr19_KI270882v1_alt', (0, 248807)),
    ('chr3_KI270778v1_alt', (0, 248252)),
    ('chr15_KI270849v1_alt', (0, 244917)),
    ('chr4_KI270786v1_alt', (0, 244096)),
    ('chr12_KI270835v1_alt', (0, 238139)),
    ('chr17_KI270858v1_alt', (0, 235827)),
    ('chr19_KI270867v1_alt', (0, 233762)),
    ('chr16_KI270855v1_alt', (0, 232857)),
    ('chr8_KI270926v1_alt', (0, 229282)),
    ('chr5_GL949742v1_alt', (0, 226852)),
    ('chr3_KI270780v1_alt', (0, 224108)),
    ('chr17_GL383565v1_alt', (0, 223995)),
    ('chr2_KI270774v1_alt', (0, 223625)),
    ('chr4_KI270790v1_alt', (0, 220246)),
    ('chr11_KI270927v1_alt', (0, 218612)),
    ('chr19_KI270932v1_alt', (0, 215732)),
    ('chr11_KI270903v1_alt', (0, 214625)),
    ('chr2_KI270894v1_alt', (0, 214158)),
    ('chr14_GL000225v1_random', (0, 211173)),
    ('chrUn_KI270743v1', (0, 210658)),
    ('chr11_KI270832v1_alt', (0, 210133)),
    ('chr7_KI270805v1_alt', (0, 209988)),
    ('chr4_GL000008v2_random', (0, 209709)),
    ('chr7_KI270809v1_alt', (0, 209586)),
    ('chr19_KI270887v1_alt', (0, 209512)),
    ('chr4_KI270789v1_alt', (0, 205944)),
    ('chr3_KI270779v1_alt', (0, 205312)),
    ('chr19_KI270914v1_alt', (0, 205194)),
    ('chr19_KI270886v1_alt', (0, 204239)),
    ('chr11_KI270829v1_alt', (0, 204059)),
    ('chr14_GL000009v2_random', (0, 201709)),
    ('chr21_GL383579v2_alt', (0, 201197)),
    ('chr11_JH159136v1_alt', (0, 200998)),
    ('chr19_KI270930v1_alt', (0, 200773)),
    ('chrUn_KI270747v1', (0, 198735)),
    ('chr18_GL383571v1_alt', (0, 198278)),
    ('chr19_KI270920v1_alt', (0, 198005)),
    ('chr6_KI270797v1_alt', (0, 197536)),
    ('chr3_KI270935v1_alt', (0, 197351)),
    ('chr17_KI270861v1_alt', (0, 196688)),
    ('chr15_KI270906v1_alt', (0, 196384)),
    ('chr5_KI270791v1_alt', (0, 195710)),
    ('chr14_KI270722v1_random', (0, 194050)),
    ('chr16_GL383556v1_alt', (0, 192462)),
    ('chr13_KI270840v1_alt', (0, 191684)),
    ('chr14_GL000194v1_random', (0, 191469)),
    ('chr11_JH159137v1_alt', (0, 191409)),
    ('chr19_KI270917v1_alt', (0, 190932)),
    ('chr7_KI270899v1_alt', (0, 190869)),
    ('chr19_KI270923v1_alt', (0, 189352)),
    ('chr10_KI270825v1_alt', (0, 188315)),
    ('chr19_GL383576v1_alt', (0, 188024)),
    ('chr19_KI270922v1_alt', (0, 187935)),
    ('chrUn_KI270742v1', (0, 186739)),
    ('chr22_KI270878v1_alt', (0, 186262)),
    ('chr19_KI270929v1_alt', (0, 186203)),
    ('chr11_KI270826v1_alt', (0, 186169)),
    ('chr6_KB021644v2_alt', (0, 185823)),
    ('chr17_GL000205v2_random', (0, 185591)),
    ('chr1_KI270765v1_alt', (0, 185285)),
    ('chr19_KI270916v1_alt', (0, 184516)),
    ('chr19_KI270890v1_alt', (0, 184499)),
    ('chr3_KI270784v1_alt', (0, 184404)),
    ('chr12_GL383551v1_alt', (0, 184319)),
    ('chr20_KI270870v1_alt', (0, 183433)),
    ('chrUn_GL000195v1', (0, 182896)),
    ('chr1_GL383518v1_alt', (0, 182439)),
    ('chr22_KI270736v1_random', (0, 181920)),
    ('chr10_KI270824v1_alt', (0, 181496)),
    ('chr14_KI270845v1_alt', (0, 180703)),
    ('chr3_GL383526v1_alt', (0, 180671)),
    ('chr13_KI270839v1_alt', (0, 180306)),
    ('chr22_KI270733v1_random', (0, 179772)),
    ('chrUn_GL000224v1', (0, 179693)),
    ('chr10_GL383545v1_alt', (0, 179254)),
    ('chrUn_GL000219v1', (0, 179198)),
    ('chr5_KI270792v1_alt', (0, 179043)),
    ('chr17_KI270860v1_alt', (0, 178921)),
    ('chr19_GL000209v2_alt', (0, 177381)),
    ('chr11_KI270830v1_alt', (0, 177092)),
    ('chr9_KI270719v1_random', (0, 176845)),
    ('chrUn_GL000216v2', (0, 176608)),
    ('chr22_KI270928v1_alt', (0, 176103)),
    ('chr1_KI270712v1_random', (0, 176043)),
    ('chr6_KI270800v1_alt', (0, 175808)),
    ('chr1_KI270706v1_random', (0, 175055)),
    ('chr2_KI270776v1_alt', (0, 174166)),
    ('chr18_KI270912v1_alt', (0, 174061)),
    ('chr3_KI270777v1_alt', (0, 173649)),
    ('chr5_GL383531v1_alt', (0, 173459)),
    ('chr3_JH636055v2_alt', (0, 173151)),
    ('chr14_KI270725v1_random', (0, 172810)),
    ('chr5_KI270796v1_alt', (0, 172708)),
    ('chr9_GL383541v1_alt', (0, 171286)),
    ('chr19_KI270885v1_alt', (0, 171027)),
    ('chr19_KI270919v1_alt', (0, 170701)),
    ('chr19_KI270889v1_alt', (0, 170698)),
    ('chr19_KI270891v1_alt', (0, 170680)),
    ('chr19_KI270915v1_alt', (0, 170665)),
    ('chr19_KI270933v1_alt', (0, 170537)),
    ('chr19_KI270883v1_alt', (0, 170399)),
    ('chr19_GL383575v2_alt', (0, 170222)),
    ('chr19_KI270931v1_alt', (0, 170148)),
    ('chr12_GL383550v2_alt', (0, 169178)),
    ('chr13_KI270841v1_alt', (0, 169134)),
    ('chrUn_KI270744v1', (0, 168472)),
    ('chr18_KI270863v1_alt', (0, 167999)),
    ('chr18_GL383569v1_alt', (0, 167950)),
    ('chr12_GL877875v1_alt', (0, 167313)),
    ('chr21_KI270874v1_alt', (0, 166743)),
    ('chr3_KI270924v1_alt', (0, 166540)),
    ('chr1_KI270761v1_alt', (0, 165834)),
    ('chr3_KI270937v1_alt', (0, 165607)),
    ('chr22_KI270734v1_random', (0, 165050)),
    ('chr18_GL383570v1_alt', (0, 164789)),
    ('chr5_KI270794v1_alt', (0, 164558)),
    ('chr4_GL383527v1_alt', (0, 164536)),
    ('chrUn_GL000213v1', (0, 164239)),
    ('chr3_KI270936v1_alt', (0, 164170)),
    ('chr3_KI270934v1_alt', (0, 163458)),
    ('chr9_GL383539v1_alt', (0, 162988)),
    ('chr3_KI270895v1_alt', (0, 162896)),
    ('chr22_GL383582v2_alt', (0, 162811)),
    ('chr3_KI270782v1_alt', (0, 162429)),
    ('chr1_KI270892v1_alt', (0, 162212)),
    ('chrUn_GL000220v1', (0, 161802)),
    ('chr2_KI270767v1_alt', (0, 161578)),
    ('chr2_KI270715v1_random', (0, 161471)),
    ('chr2_KI270893v1_alt', (0, 161218)),
    ('chrUn_GL000218v1', (0, 161147)),
    ('chr18_GL383572v1_alt', (0, 159547)),
    ('chr8_KI270817v1_alt', (0, 158983)),
    ('chr4_KI270788v1_alt', (0, 158965)),
    ('chrUn_KI270749v1', (0, 158759)),
    ('chr7_KI270806v1_alt', (0, 158166)),
    ('chr7_KI270804v1_alt', (0, 157952)),
    ('chr18_KI270911v1_alt', (0, 157710)),
    ('chrUn_KI270741v1', (0, 157432)),
    ('chr17_KI270910v1_alt', (0, 157099)),
    ('chr19_KI270884v1_alt', (0, 157053)),
    ('chr19_GL383574v1_alt', (0, 155864)),
    ('chr19_KI270888v1_alt', (0, 155532)),
    ('chr3_GL000221v1_random', (0, 155397)),
    ('chr11_GL383547v1_alt', (0, 154407)),
    ('chr2_KI270716v1_random', (0, 153799)),
    ('chr12_GL383553v2_alt', (0, 152874)),
    ('chr6_KI270799v1_alt', (0, 152148)),
    ('chr22_KI270731v1_random', (0, 150754)),
    ('chrUn_KI270751v1', (0, 150742)),
    ('chrUn_KI270750v1', (0, 148850)),
    ('chr8_KI270818v1_alt', (0, 145606)),
    ('chrX_KI270881v1_alt', (0, 144206)),
    ('chr21_KI270873v1_alt', (0, 143900)),
    ('chr2_GL383521v1_alt', (0, 143390)),
    ('chr8_KI270814v1_alt', (0, 141812)),
    ('chr12_GL383552v1_alt', (0, 138655)),
    ('chrUn_KI270519v1', (0, 138126)),
    ('chr2_KI270775v1_alt', (0, 138019)),
    ('chr17_KI270907v1_alt', (0, 137721)),
    ('chrUn_GL000214v1', (0, 137718)),
    ('chr8_KI270901v1_alt', (0, 136959)),
    ('chr2_KI270770v1_alt', (0, 136240)),
    ('chr16_KI270854v1_alt', (0, 134193)),
    ('chr8_KI270819v1_alt', (0, 133535)),
    ('chr17_GL383564v2_alt', (0, 133151)),
    ('chr2_KI270772v1_alt', (0, 133041)),
    ('chr8_KI270815v1_alt', (0, 132244)),
    ('chr5_KI270795v1_alt', (0, 131892)),
    ('chr5_KI270898v1_alt', (0, 130957)),
    ('chr20_GL383577v2_alt', (0, 128386)),
    ('chr1_KI270708v1_random', (0, 127682)),
    ('chr7_KI270807v1_alt', (0, 126434)),
    ('chr5_KI270793v1_alt', (0, 126136)),
    ('chr6_GL383533v1_alt', (0, 124736)),
    ('chr2_GL383522v1_alt', (0, 123821)),
    ('chr19_KI270918v1_alt', (0, 123111)),
    ('chr12_GL383549v1_alt', (0, 120804)),
    ('chr2_KI270769v1_alt', (0, 120616)),
    ('chr4_KI270785v1_alt', (0, 119912)),
    ('chr12_KI270834v1_alt', (0, 119498)),
    ('chr7_GL383534v2_alt', (0, 119183)),
    ('chr20_KI270869v1_alt', (0, 118774)),
    ('chr21_GL383581v2_alt', (0, 116689)),
    ('chr3_KI270781v1_alt', (0, 113034)),
    ('chr17_KI270730v1_random', (0, 112551)),
    ('chrUn_KI270438v1', (0, 112505)),
    ('chr4_KI270787v1_alt', (0, 111943)),
    ('chr18_KI270864v1_alt', (0, 111737)),
    ('chr2_KI270771v1_alt', (0, 110395)),
    ('chr1_GL383519v1_alt', (0, 110268)),
    ('chr2_KI270768v1_alt', (0, 110099)),
    ('chr1_KI270760v1_alt', (0, 109528)),
    ('chr3_KI270783v1_alt', (0, 109187)),
    ('chr17_KI270859v1_alt', (0, 108763)),
    ('chr11_KI270902v1_alt', (0, 106711)),
    ('chr18_GL383568v1_alt', (0, 104552)),
    ('chr22_KI270737v1_random', (0, 103838)),
    ('chr13_KI270843v1_alt', (0, 103832)),
    ('chr22_KI270877v1_alt', (0, 101331)),
    ('chr5_GL383530v1_alt', (0, 101241)),
    ('chr11_KI270721v1_random', (0, 100316)),
    ('chr22_KI270738v1_random', (0, 99375)),
    ('chr22_GL383583v2_alt', (0, 96924)),
    ('chr2_GL582966v2_alt', (0, 96131)),
    ('chrUn_KI270748v1', (0, 93321)),
    ('chrUn_KI270435v1', (0, 92983)),
    ('chr5_GL000208v1_random', (0, 92689)),
    ('chrUn_KI270538v1', (0, 91309)),
    ('chr17_GL383566v1_alt', (0, 90219)),
    ('chr16_GL383557v1_alt', (0, 89672)),
    ('chr17_JH159148v1_alt', (0, 88070)),
    ('chr5_GL383532v1_alt', (0, 82728)),
    ('chr21_KI270872v1_alt', (0, 82692)),
    ('chrUn_KI270756v1', (0, 79590)),
    ('chr6_KI270758v1_alt', (0, 76752)),
    ('chr12_KI270833v1_alt', (0, 76061)),
    ('chr6_KI270802v1_alt', (0, 75005)),
    ('chr21_GL383580v2_alt', (0, 74653)),
    ('chr22_KB663609v1_alt', (0, 74013)),
    ('chr22_KI270739v1_random', (0, 73985)),
    ('chr9_GL383540v1_alt', (0, 71551)),
    ('chrUn_KI270757v1', (0, 71251)),
    ('chr2_KI270773v1_alt', (0, 70887)),
    ('chr17_JH159147v1_alt', (0, 70345)),
    ('chr11_KI270827v1_alt', (0, 67707)),
    ('chr1_KI270709v1_random', (0, 66860)),
    ('chrUn_KI270746v1', (0, 66486)),
    ('chr16_KI270856v1_alt', (0, 63982)),
    ('chr21_GL383578v2_alt', (0, 63917)),
    ('chrUn_KI270753v1', (0, 62944)),
    ('chr19_KI270868v1_alt', (0, 61734)),
    ('chr9_GL383542v1_alt', (0, 60032)),
    ('chr20_KI270871v1_alt', (0, 58661)),
    ('chr12_KI270836v1_alt', (0, 56134)),
    ('chr19_KI270865v1_alt', (0, 52969)),
    ('chr1_KI270764v1_alt', (0, 50258)),
    ('chrUn_KI270589v1', (0, 44474)),
    ('chr14_KI270726v1_random', (0, 43739)),
    ('chr19_KI270866v1_alt', (0, 43156)),
    ('chr22_KI270735v1_random', (0, 42811)),
    ('chr1_KI270711v1_random', (0, 42210)),
    ('chrUn_KI270745v1', (0, 41891)),
    ('chr1_KI270714v1_random', (0, 41717)),
    ('chr22_KI270732v1_random', (0, 41543)),
    ('chr1_KI270713v1_random', (0, 40745)),
    ('chrUn_KI270754v1', (0, 40191)),
    ('chr1_KI270710v1_random', (0, 40176)),
    ('chr12_KI270837v1_alt', (0, 40090)),
    ('chr9_KI270717v1_random', (0, 40062)),
    ('chr14_KI270724v1_random', (0, 39555)),
    ('chr9_KI270720v1_random', (0, 39050)),
    ('chr14_KI270723v1_random', (0, 38115)),
    ('chr9_KI270718v1_random', (0, 38054)),
    ('chrUn_KI270317v1', (0, 37690)),
    ('chr13_KI270842v1_alt', (0, 37287)),
    ('chrY_KI270740v1_random', (0, 37240)),
    ('chrUn_KI270755v1', (0, 36723)),
    ('chr8_KI270820v1_alt', (0, 36640)),
    ('chr1_KI270707v1_random', (0, 32032)),
    ('chrUn_KI270579v1', (0, 31033)),
    ('chrUn_KI270752v1', (0, 27745)),
    ('chrUn_KI270512v1', (0, 22689)),
    ('chrUn_KI270322v1', (0, 21476)),
    ('chrM', (0, 16569)),
    ('chrUn_GL000226v1', (0, 15008)),
    ('chrUn_KI270311v1', (0, 12399)),
    ('chrUn_KI270366v1', (0, 8320)),
    ('chrUn_KI270511v1', (0, 8127)),
    ('chrUn_KI270448v1', (0, 7992)),
    ('chrUn_KI270521v1', (0, 7642)),
    ('chrUn_KI270581v1', (0, 7046)),
    ('chrUn_KI270582v1', (0, 6504)),
    ('chrUn_KI270515v1', (0, 6361)),
    ('chrUn_KI270588v1', (0, 6158)),
    ('chrUn_KI270591v1', (0, 5796)),
    ('chrUn_KI270522v1', (0, 5674)),
    ('chrUn_KI270507v1', (0, 5353)),
    ('chrUn_KI270590v1', (0, 4685)),
    ('chrUn_KI270584v1', (0, 4513)),
    ('chrUn_KI270320v1', (0, 4416)),
    ('chrUn_KI270382v1', (0, 4215)),
    ('chrUn_KI270468v1', (0, 4055)),
    ('chrUn_KI270467v1', (0, 3920)),
    ('chrUn_KI270362v1', (0, 3530)),
    ('chrUn_KI270517v1', (0, 3253)),
    ('chrUn_KI270593v1', (0, 3041)),
    ('chrUn_KI270528v1', (0, 2983)),
    ('chrUn_KI270587v1', (0, 2969)),
    ('chrUn_KI270364v1', (0, 2855)),
    ('chrUn_KI270371v1', (0, 2805)),
    ('chrUn_KI270333v1', (0, 2699)),
    ('chrUn_KI270374v1', (0, 2656)),
    ('chrUn_KI270411v1', (0, 2646)),
    ('chrUn_KI270414v1', (0, 2489)),
    ('chrUn_KI270510v1', (0, 2415)),
    ('chrUn_KI270390v1', (0, 2387)),
    ('chrUn_KI270375v1', (0, 2378)),
    ('chrUn_KI270420v1', (0, 2321)),
    ('chrUn_KI270509v1', (0, 2318)),
    ('chrUn_KI270315v1', (0, 2276)),
    ('chrUn_KI270302v1', (0, 2274)),
    ('chrUn_KI270518v1', (0, 2186)),
    ('chrUn_KI270530v1', (0, 2168)),
    ('chrUn_KI270304v1', (0, 2165)),
    ('chrUn_KI270418v1', (0, 2145)),
    ('chrUn_KI270424v1', (0, 2140)),
    ('chrUn_KI270417v1', (0, 2043)),
    ('chrUn_KI270508v1', (0, 1951)),
    ('chrUn_KI270303v1', (0, 1942)),
    ('chrUn_KI270381v1', (0, 1930)),
    ('chrUn_KI270529v1', (0, 1899)),
    ('chrUn_KI270425v1', (0, 1884)),
    ('chrUn_KI270396v1', (0, 1880)),
    ('chrUn_KI270363v1', (0, 1803)),
    ('chrUn_KI270386v1', (0, 1788)),
    ('chrUn_KI270465v1', (0, 1774)),
    ('chrUn_KI270383v1', (0, 1750)),
    ('chrUn_KI270384v1', (0, 1658)),
    ('chrUn_KI270330v1', (0, 1652)),
    ('chrUn_KI270372v1', (0, 1650)),
    ('chrUn_KI270548v1', (0, 1599)),
    ('chrUn_KI270580v1', (0, 1553)),
    ('chrUn_KI270387v1', (0, 1537)),
    ('chrUn_KI270391v1', (0, 1484)),
    ('chrUn_KI270305v1', (0, 1472)),
    ('chrUn_KI270373v1', (0, 1451)),
    ('chrUn_KI270422v1', (0, 1445)),
    ('chrUn_KI270316v1', (0, 1444)),
    ('chrUn_KI270338v1', (0, 1428)),
    ('chrUn_KI270340v1', (0, 1428)),
    ('chrUn_KI270583v1', (0, 1400)),
    ('chrUn_KI270334v1', (0, 1368)),
    ('chrUn_KI270429v1', (0, 1361)),
    ('chrUn_KI270393v1', (0, 1308)),
    ('chrUn_KI270516v1', (0, 1300)),
    ('chrUn_KI270389v1', (0, 1298)),
    ('chrUn_KI270466v1', (0, 1233)),
    ('chrUn_KI270388v1', (0, 1216)),
    ('chrUn_KI270544v1', (0, 1202)),
    ('chrUn_KI270310v1', (0, 1201)),
    ('chrUn_KI270412v1', (0, 1179)),
    ('chrUn_KI270395v1', (0, 1143)),
    ('chrUn_KI270376v1', (0, 1136)),
    ('chrUn_KI270337v1', (0, 1121)),
    ('chrUn_KI270335v1', (0, 1048)),
    ('chrUn_KI270378v1', (0, 1048)),
    ('chrUn_KI270379v1', (0, 1045)),
    ('chrUn_KI270329v1', (0, 1040)),
    ('chrUn_KI270419v1', (0, 1029)),
    ('chrUn_KI270336v1', (0, 1026)),
    ('chrUn_KI270312v1', (0, 998)),
    ('chrUn_KI270539v1', (0, 993)),
    ('chrUn_KI270385v1', (0, 990)),
    ('chrUn_KI270423v1', (0, 981)),
    ('chrUn_KI270392v1', (0, 971)),
    ('chrUn_KI270394v1', (0, 970)),
))

hg38.default = OrderedDict()
for chrom, size in hg38.items():
    if '_' in chrom:
        continue
    if chrom == 'chrM':
        continue
    hg38.default[chrom] = size

