#!/usr/bin/env python
# encoding: utf-8

# The MIT License (MIT)

# Copyright (c) 2012-2014 CNRS (Hervé BREDIN - http://herve.niderb.fr)

# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:

# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.

# THE SOFTWARE S PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
# SOFTWARE.

from __future__ import unicode_literals

# import sys
# import pandas
# import numpy as np
# from pyannote.core import Segment, Timeline, Annotation, Scores
# from pyannote.core.feature import SlidingWindowFeature
# from pyannote.core import PYANNOTE_URI, PYANNOTE_MODALITY, \
#     PYANNOTE_SEGMENT, PYANNOTE_TRACK, PYANNOTE_LABEL, PYANNOTE_SCORE


from abc import ABCMeta, abstractmethod


class Parser(object):

    __metaclass__ = ABCMeta

    @classmethod
    @abstractmethod
    def file_extensions(cls):
        pass

    @abstractmethod
    def read(self, path, **kwargs):
        pass

    @abstractmethod
    def empty(self, uri=None, modality=None, **kwargs):
        pass

    def __call__(self, uri=None, modality=None, **kwargs):

        match = dict(self._loaded)

        # filter out all annotations
        # but the ones for the requested resource
        if uri is not None:
            match = {(v, m): ann for (v, m), ann in match.iteritems()
                     if v == uri}

        # filter out all remaining annotations
        # but the ones for the requested modality
        if modality is not None:
            match = {(v, m): ann for (v, m), ann in match.iteritems()
                     if m == modality}

        if len(match) == 0:
            A = self.empty(uri=uri, modality=modality, **kwargs)

        elif len(match) == 1:
            A = match.values()[0]

        else:
            msg = 'Found more than one matching annotation: %s'
            raise ValueError(msg % match.keys())

        return A
