#!/usr/bin/env python
"""
================================================================================
:mod:`settings` -- Fix of QSettings
================================================================================

.. module:: settings
   :synopsis: Fix of QSettings

.. inheritance-diagram:: pyhmsa.gui.util.settings

"""

# Script information for the file.
__author__ = "Philippe T. Pinard"
__email__ = "philippe.pinard@gmail.com"
__version__ = "0.1"
__copyright__ = "Copyright (c) 2014 Philippe T. Pinard"
__license__ = "GPL v3"

# Standard library modules.

# Third party modules.
from PySide.QtCore import QSettings

import six

# Local modules.

# Globals and constants variables.

class Settings(QSettings):

    def valueBool(self, key, default):
        value = self.value(key, default)
        if isinstance(value, six.string_types):
            value = True if value.lower() == 'true' else False
        return value
