#!/usr/bin/env python
"""
================================================================================
:mod:`registry` -- Utility functions to access the entry points registry
================================================================================

.. module:: registry
   :synopsis: Utility functions to access the entry points registry

.. inheritance-diagram:: pyhmsa.gui.util.registry

"""

# Standard library modules.
from operator import attrgetter

# Third party modules.
from pkg_resources import iter_entry_points

# Local modules.

# Globals and constants variables.

def _iter_entry_points(group, name=None, *args, **kwargs):
    entry_points = list(iter_entry_points(group, name))
    entry_points.sort(key=attrgetter('name'))

    for entry_point in entry_points:
        yield entry_point.name, entry_point.load()(*args, **kwargs)

def iter_condition_widgets(name=None, *args, **kwargs):
    return _iter_entry_points('pyhmsa.gui.spec.condition', name, *args, **kwargs)

def iter_datum_widgets(name=None, *args, **kwargs):
    return _iter_entry_points('pyhmsa.gui.spec.datum', name, *args, **kwargs)

def _iter_porters(group, name=None, *args, **kwargs):
    for name, importer in _iter_entry_points(group, name, *args, **kwargs):
        for ext in importer.SUPPORTED_EXTENSIONS:
            yield name, ext, importer

def iter_importers(name=None, *args, **kwargs):
    for name, importer in _iter_entry_points('pyhmsa.fileformat.importer', name,
                                             *args, **kwargs):
        for ext in importer.SUPPORTED_EXTENSIONS:
            yield name, ext, importer

def iter_exporters(name=None, *args, **kwargs):
    return _iter_entry_points('pyhmsa.fileformat.exporter', name, *args, **kwargs)
