#!/usr/bin/env python
"""
================================================================================
:mod:`condition` -- Base widget for conditions
================================================================================

.. module:: condition
   :synopsis: Base widget for conditions

.. inheritance-diagram:: pyhmsa.gui.spec.condition.condition

"""

# Standard library modules.

# Third party modules.

# Local modules.
from pyhmsa.gui.util.parameter import ParameterWidget

# Globals and constants variables.

class _ConditionWidget(ParameterWidget):

    def __init__(self, clasz, condition=None, parent=None):
        ParameterWidget.__init__(self, clasz, parent)

        name = clasz.TEMPLATE
        if clasz.CLASS is not None:
            name += ' (%s)' % clasz.CLASS
        self.setAccessibleName(name)

        # Set condition (if present)
        if condition:
            self.setCondition(condition)

    def condition(self):
        return self.parameter()

    def setCondition(self, condition):
        self.setParameter(condition)
