"""
Copyright (c) 2014 Marta Nabozny

This file is part of OverCluster project.

OverCluster is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program.  If not, see <http://www.gnu.org/licenses/>.
"""

from pyCore.utils import request
from task import Task
from pyCore.models.base_model import BaseModel


class VM(BaseModel):
    def __str__(self):
        return self.name
        
    def reset(self):
        request(self.oc_address, '/api/vm/reset/', {'token': self.token,
                                                    'vm_id': self.id})
        
    def poweroff(self):
        request(self.oc_address, '/api/vm/poweroff/', {'token': self.token,
                                                       'vm_id': self.id})
        
    def shutdown(self):
        request(self.oc_address, '/api/vm/shutdown/', {'token': self.token,
                                                       'vm_id': self.id})
        
    def cleanup(self):
        request(self.oc_address, '/api/vm/cleanup/', {'token': self.token,
                                                      'vm_id': self.id})
        
    def start(self):
        request(self.oc_address, '/api/vm/start/', {'token': self.token,
                                                    'vm_id': self.id})

    def save_image(self):
        request(self.oc_address, '/api/vm/save_image/', {'token': self.token,
                                                         'vm_id': self.id})

    def cancel_tasks(self):
        request(self.oc_address, '/api/vm/cancel_tasks/', {'token': self.token,
                                                           'vm_id': self.id})

    def edit(self, **kwargs):
        for key in kwargs.keys():
            if hasattr(self, key):
                setattr(self, key, kwargs[key])
                request(self.oc_address, '/api/vm/edit/', {'token': self.token,
                                                           'vm_id': self.id,
                                                           key: kwargs[key]})
