import pymongo
import flask

from helpers import get, json_response

def MongoServer(database="database", table="data", server=None, port=None):
    db = pymongo.Connection(server, port)[database]
    table = db[table]

    app = flask.Flask(__name__)

    @app.route("/insert/")
    def insert():
        table.insert(get())
        return ""

    @app.route("/insert/<table>/")
    def insert2(table):
        db[table].inset(get())
        return ""

    @app.route("/find/")
    def find():
        return json_response(list(table.find(get())))

    @app.route("/find/<table>/")
    def find2(table):
        return json_response(list(db[table].find(get())))

    return app
