/*!
 * jQuery UI Autocomplete 1.10.3
 * http://jqueryui.com
 *
 * Copyright 2013 jQuery Foundation and other contributors
 * Released under the MIT license.
 * http://jquery.org/license
 *
 * http://api.jqueryui.com/autocomplete/
 *
 * Depends:
 *	jquery.ui.core.js
 *	jquery.ui.widget.js
 *	jquery.ui.position.js
 *	jquery.ui.menu.js
 */
(function(a,b){var c=0;a.widget("ui.autocomplete",{version:"1.10.3",defaultElement:"<input>",options:{appendTo:null,autoFocus:false,delay:300,minLength:1,position:{my:"left top",at:"left bottom",collision:"none"},source:null,change:null,close:null,focus:null,open:null,response:null,search:null,select:null},pending:0,_create:function(){var f,d,g,i=this.element[0].nodeName.toLowerCase(),h=i==="textarea",e=i==="input";this.isMultiLine=h?true:e?false:this.element.prop("isContentEditable");this.valueMethod=this.element[h||e?"val":"text"];this.isNewMenu=true;this.element.addClass("ui-autocomplete-input").attr("autocomplete","off");this._on(this.element,{keydown:function(j){if(this.element.prop("readOnly")){f=true;g=true;d=true;return}f=false;g=false;d=false;var k=a.ui.keyCode;switch(j.keyCode){case k.PAGE_UP:f=true;this._move("previousPage",j);break;case k.PAGE_DOWN:f=true;this._move("nextPage",j);break;case k.UP:f=true;this._keyEvent("previous",j);break;case k.DOWN:f=true;this._keyEvent("next",j);break;case k.ENTER:case k.NUMPAD_ENTER:if(this.menu.active){f=true;j.preventDefault();this.menu.select(j)}break;case k.TAB:if(this.menu.active){this.menu.select(j)}break;case k.ESCAPE:if(this.menu.element.is(":visible")){this._value(this.term);this.close(j);j.preventDefault()}break;default:d=true;this._searchTimeout(j);break}},keypress:function(j){if(f){f=false;if(!this.isMultiLine||this.menu.element.is(":visible")){j.preventDefault()}return}if(d){return}var k=a.ui.keyCode;switch(j.keyCode){case k.PAGE_UP:this._move("previousPage",j);break;case k.PAGE_DOWN:this._move("nextPage",j);break;case k.UP:this._keyEvent("previous",j);break;case k.DOWN:this._keyEvent("next",j);break}},input:function(j){if(g){g=false;j.preventDefault();return}this._searchTimeout(j)},focus:function(){this.selectedItem=null;this.previous=this._value()},blur:function(j){if(this.cancelBlur){delete this.cancelBlur;return}clearTimeout(this.searching);this.close(j);this._change(j)}});this._initSource();this.menu=a("<ul>").addClass("ui-autocomplete ui-front").appendTo(this._appendTo()).menu({role:null}).hide().data("ui-menu");this._on(this.menu.element,{mousedown:function(j){j.preventDefault();this.cancelBlur=true;this._delay(function(){delete this.cancelBlur});var k=this.menu.element[0];if(!a(j.target).closest(".ui-menu-item").length){this._delay(function(){var l=this;this.document.one("mousedown",function(m){if(m.target!==l.element[0]&&m.target!==k&&!a.contains(k,m.target)){l.close()}})})}},menufocus:function(k,l){if(this.isNewMenu){this.isNewMenu=false;if(k.originalEvent&&/^mouse/.test(k.originalEvent.type)){this.menu.blur();this.document.one("mousemove",function(){a(k.target).trigger(k.originalEvent)});return}}var j=l.item.data("ui-autocomplete-item");if(false!==this._trigger("focus",k,{item:j})){if(k.originalEvent&&/^key/.test(k.originalEvent.type)){this._value(j.value)}}else{this.liveRegion.text(j.value)}},menuselect:function(l,m){var k=m.item.data("ui-autocomplete-item"),j=this.previous;if(this.element[0]!==this.document[0].activeElement){this.element.focus();this.previous=j;this._delay(function(){this.previous=j;this.selectedItem=k})}if(false!==this._trigger("select",l,{item:k})){this._value(k.value)}this.term=this._value();this.close(l);this.selectedItem=k}});this.liveRegion=a("<span>",{role:"status","aria-live":"polite"}).addClass("ui-helper-hidden-accessible").insertBefore(this.element);this._on(this.window,{beforeunload:function(){this.element.removeAttr("autocomplete")}})},_destroy:function(){clearTimeout(this.searching);this.element.removeClass("ui-autocomplete-input").removeAttr("autocomplete");this.menu.element.remove();this.liveRegion.remove()},_setOption:function(d,e){this._super(d,e);if(d==="source"){this._initSource()}if(d==="appendTo"){this.menu.element.appendTo(this._appendTo())}if(d==="disabled"&&e&&this.xhr){this.xhr.abort()}},_appendTo:function(){var d=this.options.appendTo;if(d){d=d.jquery||d.nodeType?a(d):this.document.find(d).eq(0)}if(!d){d=this.element.closest(".ui-front")}if(!d.length){d=this.document[0].body}return d},_initSource:function(){var f,d,e=this;if(a.isArray(this.options.source)){f=this.options.source;this.source=function(h,g){g(a.ui.autocomplete.filter(f,h.term))}}else{if(typeof this.options.source==="string"){d=this.options.source;this.source=function(h,g){if(e.xhr){e.xhr.abort()}e.xhr=a.ajax({url:d,data:h,dataType:"json",success:function(i){g(i)},error:function(){g([])}})}}else{this.source=this.options.source}}},_searchTimeout:function(d){clearTimeout(this.searching);this.searching=this._delay(function(){if(this.term!==this._value()){this.selectedItem=null;this.search(null,d)}},this.options.delay)},search:function(e,d){e=e!=null?e:this._value();this.term=this._value();if(e.length<this.options.minLength){return this.close(d)}if(this._trigger("search",d)===false){return}return this._search(e)},_search:function(d){this.pending++;this.element.addClass("ui-autocomplete-loading");this.cancelSearch=false;this.source({term:d},this._response())},_response:function(){var e=this,d=++c;return function(f){if(d===c){e.__response(f)}e.pending--;if(!e.pending){e.element.removeClass("ui-autocomplete-loading")}}},__response:function(d){if(d){d=this._normalize(d)}this._trigger("response",null,{content:d});if(!this.options.disabled&&d&&d.length&&!this.cancelSearch){this._suggest(d);this._trigger("open")}else{this._close()}},close:function(d){this.cancelSearch=true;this._close(d)},_close:function(d){if(this.menu.element.is(":visible")){this.menu.element.hide();this.menu.blur();this.isNewMenu=true;this._trigger("close",d)}},_change:function(d){if(this.previous!==this._value()){this._trigger("change",d,{item:this.selectedItem})}},_normalize:function(d){if(d.length&&d[0].label&&d[0].value){return d}return a.map(d,function(e){if(typeof e==="string"){return{label:e,value:e}}return a.extend({label:e.label||e.value,value:e.value||e.label},e)})},_suggest:function(d){var e=this.menu.element.empty();this._renderMenu(e,d);this.isNewMenu=true;this.menu.refresh();e.show();this._resizeMenu();e.position(a.extend({of:this.element},this.options.position));if(this.options.autoFocus){this.menu.next()}},_resizeMenu:function(){var d=this.menu.element;d.outerWidth(Math.max(d.width("").outerWidth()+1,this.element.outerWidth()))},_renderMenu:function(e,d){var f=this;a.each(d,function(g,h){f._renderItemData(e,h)})},_renderItemData:function(d,e){return this._renderItem(d,e).data("ui-autocomplete-item",e)},_renderItem:function(d,e){return a("<li>").append(a("<a>").text(e.label)).appendTo(d)},_move:function(e,d){if(!this.menu.element.is(":visible")){this.search(null,d);return}if(this.menu.isFirstItem()&&/^previous/.test(e)||this.menu.isLastItem()&&/^next/.test(e)){this._value(this.term);this.menu.blur();return}this.menu[e](d)},widget:function(){return this.menu.element},_value:function(){return this.valueMethod.apply(this.element,arguments)},_keyEvent:function(e,d){if(!this.isMultiLine||this.menu.element.is(":visible")){this._move(e,d);d.preventDefault()}}});a.extend(a.ui.autocomplete,{escapeRegex:function(d){return d.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")},filter:function(f,d){var e=new RegExp(a.ui.autocomplete.escapeRegex(d),"i");return a.grep(f,function(g){return e.test(g.label||g.value||g)})}});a.widget("ui.autocomplete",a.ui.autocomplete,{options:{messages:{noResults:"No search results.",results:function(d){return d+(d>1?" results are":" result is")+" available, use up and down arrow keys to navigate."}}},__response:function(e){var d;this._superApply(arguments);if(this.options.disabled||this.cancelSearch){return}if(e&&e.length){d=this.options.messages.results(e.length)}else{d=this.options.messages.noResults}this.liveRegion.text(d)}})}(jQuery));