#!/usr/bin/env python
# -*- noplot -*-
# Code taken from http://matplotlib.sourceforge.net/examples/pylab_examples/colours.py
# under new BSD-style license
"""
Some simple functions to generate colours.
"""
import numpy as np

def pastel(colour, weight=2.4):
    """ Convert colour into a nice pastel shade"""
    rgb = np.asarray(tuple(colour))
    # scale colour
    maxc = max(rgb)
    if maxc < 1.0 and maxc > 0:
        # scale colour
        scale = 1.0 / maxc
        rgb = rgb * scale
    # now decrease saturation
    total = rgb.sum()
    slack = 0
    for x in rgb:
        slack += 1.0 - x

    # want to increase weight from total to weight
    # pick x s.t.  slack * x == weight - total
    # x = (weight - total) / slack
    x = (weight - total) / slack

    rgb = [c + (x * (1.0-c)) for c in rgb]

    return rgb

base = np.asarray([[1,0,0], [0,1,0], [0,0,1]])

def get_colours(n):
    """ Return n pastel colours. """
    if n <= 3:
        return base[0:n]

    # how many new colours to we need to insert between
    # red and green and between green and blue?
    needed = (((n - 3) + 1) / 2, (n - 3) / 2)

    colours = []
    for start in (0, 1):
        for x in np.linspace(0, 1, needed[start]+2)[:-1]:
            colours.append((base[start] * (1.0 - x)) +
                           (base[start+1] * x))
    colours.append(base[2])

    return [pastel(c) for c in colours[0:n]]

