#!/usr/bin/env python

#
# member_specs_test.py
#

import sys
from xml.dom import minidom
import member_specs_upper

def process(infilename):
    doc = minidom.parse(infilename)
    rootNode = doc.documentElement
    rootObj = member_specs_upper.contactlistTypeSub.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="contact-list", 
        namespacedef_='')
    rootObj.upper()
    sys.stdout.write('-' * 60)
    sys.stdout.write('\n')
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="contact-list", 
        namespacedef_='')
    return rootObj

USAGE_MSG = """\
Usage:
    python member_specs_test.py infilename
"""

def usage():
    print USAGE_MSG
    sys.exit(1)

def main():
    args = sys.argv[1:]
    if len(args) != 1:
        usage()
    infilename = args[0]
    process(infilename)

if __name__ == '__main__':
    main()



