#!/usr/bin/env python

#
# Generated Tue Sep 29 16:00:11 2009 by generateDS.py version 1.18f.
#

import sys
import getopt
from string import lower as str_lower
from xml.dom import minidom
from xml.dom import Node

#
# User methods
#
# Calls to the methods in these classes are generated by generateDS.py.
# You can replace these methods by re-implementing the following class
#   in a module named generatedssuper.py.

try:
    from generatedssuper import GeneratedsSuper
except ImportError, exp:

    class GeneratedsSuper(object):
        def format_string(self, input_data, input_name=''):
            return input_data
        def format_integer(self, input_data, input_name=''):
            return '%d' % input_data
        def format_float(self, input_data, input_name=''):
            return '%f' % input_data
        def format_double(self, input_data, input_name=''):
            return '%e' % input_data
        def format_boolean(self, input_data, input_name=''):
            return '%s' % input_data


#
# If you have installed IPython you can uncomment and use the following.
# IPython is available from http://ipython.scipy.org/.
#

## from IPython.Shell import IPShellEmbed
## args = ''
## ipshell = IPShellEmbed(args,
##     banner = 'Dropping into IPython',
##     exit_msg = 'Leaving Interpreter, back to program.')

# Then use the following line where and when you want to drop into the
# IPython shell:
#    ipshell('<some message> -- Entering ipshell.\nHit Ctrl-D to exit')

#
# Globals
#

ExternalEncoding = 'ascii'

#
# Support/utility functions.
#

def showIndent(outfile, level):
    for idx in range(level):
        outfile.write('    ')

def quote_xml(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    return s1

def quote_attrib(inStr):
    s1 = (isinstance(inStr, basestring) and inStr or
          '%s' % inStr)
    s1 = s1.replace('&', '&amp;')
    s1 = s1.replace('<', '&lt;')
    s1 = s1.replace('>', '&gt;')
    if '"' in s1:
        if "'" in s1:
            s1 = '"%s"' % s1.replace('"', "&quot;")
        else:
            s1 = "'%s'" % s1
    else:
        s1 = '"%s"' % s1
    return s1

def quote_python(inStr):
    s1 = inStr
    if s1.find("'") == -1:
        if s1.find('\n') == -1:
            return "'%s'" % s1
        else:
            return "'''%s'''" % s1
    else:
        if s1.find('"') != -1:
            s1 = s1.replace('"', '\\"')
        if s1.find('\n') == -1:
            return '"%s"' % s1
        else:
            return '"""%s"""' % s1


class MixedContainer:
    # Constants for category:
    CategoryNone = 0
    CategoryText = 1
    CategorySimple = 2
    CategoryComplex = 3
    # Constants for content_type:
    TypeNone = 0
    TypeText = 1
    TypeString = 2
    TypeInteger = 3
    TypeFloat = 4
    TypeDecimal = 5
    TypeDouble = 6
    TypeBoolean = 7
    def __init__(self, category, content_type, name, value):
        self.category = category
        self.content_type = content_type
        self.name = name
        self.value = value
    def getCategory(self):
        return self.category
    def getContenttype(self, content_type):
        return self.content_type
    def getValue(self):
        return self.value
    def getName(self):
        return self.name
    def export(self, outfile, level, name, namespace):
        if self.category == MixedContainer.CategoryText:
            outfile.write(self.value)
        elif self.category == MixedContainer.CategorySimple:
            self.exportSimple(outfile, level, name)
        else:    # category == MixedContainer.CategoryComplex
            self.value.export(outfile, level, namespace,name)
    def exportSimple(self, outfile, level, name):
        if self.content_type == MixedContainer.TypeString:
            outfile.write('<%s>%s</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeInteger or \
                self.content_type == MixedContainer.TypeBoolean:
            outfile.write('<%s>%d</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeFloat or \
                self.content_type == MixedContainer.TypeDecimal:
            outfile.write('<%s>%f</%s>' % (self.name, self.value, self.name))
        elif self.content_type == MixedContainer.TypeDouble:
            outfile.write('<%s>%g</%s>' % (self.name, self.value, self.name))
    def exportLiteral(self, outfile, level, name):
        if self.category == MixedContainer.CategoryText:
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        elif self.category == MixedContainer.CategorySimple:
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s", "%s"),\n' % \
                (self.category, self.content_type, self.name, self.value))
        else:    # category == MixedContainer.CategoryComplex
            showIndent(outfile, level)
            outfile.write('MixedContainer(%d, %d, "%s",\n' % \
                (self.category, self.content_type, self.name,))
            self.value.exportLiteral(outfile, level + 1)
            showIndent(outfile, level)
            outfile.write(')\n')


class MemberSpec_(object):
    def __init__(self, name='', data_type='', container=0):
        self.name = name
        self.data_type = data_type
        self.container = container
    def set_name(self, name): self.name = name
    def get_name(self): return self.name
    def set_data_type(self, data_type): self.data_type = data_type
    def get_data_type_chain(self): return self.data_type
    def get_data_type(self):
        if isinstance(self.data_type, list):
            return self.data_type[-1]
        else:
            return self.data_type
    def set_container(self, container): self.container = container
    def get_container(self): return self.container

def _cast(typ, value):
    if typ is None or value is None:
        return value
    return typ(value)

#
# Data representation classes.
#

class contactlistType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('locator', 'xs:string', 0),
        MemberSpec_('description', 'xs:string', 0),
        MemberSpec_('contact', 'contactType', 1),
        ]
    subclass = None
    superclass = None
    def __init__(self, locator=None, description=None, contact=None):
        self.locator = _cast(None, locator)
        self.description = description
        if contact is None:
            self.contact = []
        else:
            self.contact = contact
    def factory(*args_, **kwargs_):
        if contactlistType.subclass:
            return contactlistType.subclass(*args_, **kwargs_)
        else:
            return contactlistType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_description(self): return self.description
    def set_description(self, description): self.description = description
    def get_contact(self): return self.contact
    def set_contact(self, contact): self.contact = contact
    def add_contact(self, value): self.contact.append(value)
    def insert_contact(self, index, value): self.contact[index] = value
    def get_locator(self): return self.locator
    def set_locator(self, locator): self.locator = locator
    def export(self, outfile, level, namespace_='', name_='contactlistType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='contactlistType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='contactlistType'):
        if self.locator is not None:
            outfile.write(' locator=%s' % (self.format_string(quote_attrib(self.locator).encode(ExternalEncoding), input_name='locator'), ))
    def exportChildren(self, outfile, level, namespace_='', name_='contactlistType'):
        if self.description is not None:
            showIndent(outfile, level)
            outfile.write('<%sdescription>%s</%sdescription>\n' % (namespace_, self.format_string(quote_xml(self.description).encode(ExternalEncoding), input_name='description'), namespace_))
        for contact_ in self.contact:
            contact_.export(outfile, level, namespace_, name_='contact')
    def hasContent_(self):
        if (
            self.description is not None or
            self.contact
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='contactlistType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.locator is not None:
            showIndent(outfile, level)
            outfile.write('locator = %s,\n' % (self.locator,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('description=%s,\n' % quote_python(self.description).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('contact=[\n')
        level += 1
        for contact in self.contact:
            showIndent(outfile, level)
            outfile.write('model_.contact(\n')
            contact.exportLiteral(outfile, level, name_='contact')
            showIndent(outfile, level)
            outfile.write('),\n')
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('locator'):
            self.locator = attrs.get('locator').value
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'description':
            description_ = ''
            for text__content_ in child_.childNodes:
                description_ += text__content_.nodeValue
            self.description = description_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'contact':
            obj_ = contactType.factory()
            obj_.build(child_)
            self.contact.append(obj_)
# end class contactlistType


class contactType(GeneratedsSuper):
    member_data_items_ = [
        MemberSpec_('priority', 'xs:float', 0),
        MemberSpec_('color-code', 'xs:string', 0),
        MemberSpec_('id', 'xs:integer', 0),
        MemberSpec_('first_name', 'xs:string', 0),
        MemberSpec_('last_name', 'xs:string', 0),
        MemberSpec_('interest', 'xs:string', 1),
        MemberSpec_('category', 'xs:integer', 0),
        ]
    subclass = None
    superclass = None
    def __init__(self, priority=None, color_code=None, id=None, first_name=None, last_name=None, interest=None, category=None):
        self.priority = _cast(float, priority)
        self.color_code = _cast(None, color_code)
        self.id = _cast(int, id)
        self.first_name = first_name
        self.last_name = last_name
        if interest is None:
            self.interest = []
        else:
            self.interest = interest
        self.category = category
    def factory(*args_, **kwargs_):
        if contactType.subclass:
            return contactType.subclass(*args_, **kwargs_)
        else:
            return contactType(*args_, **kwargs_)
    factory = staticmethod(factory)
    def get_first_name(self): return self.first_name
    def set_first_name(self, first_name): self.first_name = first_name
    def get_last_name(self): return self.last_name
    def set_last_name(self, last_name): self.last_name = last_name
    def get_interest(self): return self.interest
    def set_interest(self, interest): self.interest = interest
    def add_interest(self, value): self.interest.append(value)
    def insert_interest(self, index, value): self.interest[index] = value
    def get_category(self): return self.category
    def set_category(self, category): self.category = category
    def get_priority(self): return self.priority
    def set_priority(self, priority): self.priority = priority
    def get_color_code(self): return self.color_code
    def set_color_code(self, color_code): self.color_code = color_code
    def get_id(self): return self.id
    def set_id(self, id): self.id = id
    def export(self, outfile, level, namespace_='', name_='contactType', namespacedef_=''):
        showIndent(outfile, level)
        outfile.write('<%s%s%s' % (namespace_, name_, namespacedef_ and ' ' + namespacedef_ or '', ))
        self.exportAttributes(outfile, level, namespace_, name_='contactType')
        if self.hasContent_():
            outfile.write('>\n')
            self.exportChildren(outfile, level + 1, namespace_, name_)
            showIndent(outfile, level)
            outfile.write('</%s%s>\n' % (namespace_, name_))
        else:
            outfile.write('/>\n')
    def exportAttributes(self, outfile, level, namespace_='', name_='contactType'):
        if self.priority is not None:
            outfile.write(' priority="%s"' % self.format_float(self.priority, input_name='priority'))
        if self.color_code is not None:
            outfile.write(' color-code=%s' % (self.format_string(quote_attrib(self.color_code).encode(ExternalEncoding), input_name='color-code'), ))
        if self.id is not None:
            outfile.write(' id="%s"' % self.format_integer(self.id, input_name='id'))
    def exportChildren(self, outfile, level, namespace_='', name_='contactType'):
        if self.first_name is not None:
            showIndent(outfile, level)
            outfile.write('<%sfirst-name>%s</%sfirst-name>\n' % (namespace_, self.format_string(quote_xml(self.first_name).encode(ExternalEncoding), input_name='first-name'), namespace_))
        if self.last_name is not None:
            showIndent(outfile, level)
            outfile.write('<%slast-name>%s</%slast-name>\n' % (namespace_, self.format_string(quote_xml(self.last_name).encode(ExternalEncoding), input_name='last-name'), namespace_))
        for interest_ in self.interest:
            showIndent(outfile, level)
            outfile.write('<%sinterest>%s</%sinterest>\n' % (namespace_, self.format_string(quote_xml(interest_).encode(ExternalEncoding), input_name='interest'), namespace_))
        if self.category is not None:
            showIndent(outfile, level)
            outfile.write('<%scategory>%s</%scategory>\n' % (namespace_, self.format_integer(self.category, input_name='category'), namespace_))
    def hasContent_(self):
        if (
            self.first_name is not None or
            self.last_name is not None or
            self.interest or
            self.category is not None
            ):
            return True
        else:
            return False
    def exportLiteral(self, outfile, level, name_='contactType'):
        level += 1
        self.exportLiteralAttributes(outfile, level, name_)
        if self.hasContent_():
            self.exportLiteralChildren(outfile, level, name_)
    def exportLiteralAttributes(self, outfile, level, name_):
        if self.priority is not None:
            showIndent(outfile, level)
            outfile.write('priority = %s,\n' % (self.priority,))
        if self.color_code is not None:
            showIndent(outfile, level)
            outfile.write('color_code = %s,\n' % (self.color_code,))
        if self.id is not None:
            showIndent(outfile, level)
            outfile.write('id = %s,\n' % (self.id,))
    def exportLiteralChildren(self, outfile, level, name_):
        showIndent(outfile, level)
        outfile.write('first_name=%s,\n' % quote_python(self.first_name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('last_name=%s,\n' % quote_python(self.last_name).encode(ExternalEncoding))
        showIndent(outfile, level)
        outfile.write('interest=[\n')
        level += 1
        for interest in self.interest:
            showIndent(outfile, level)
            outfile.write('%s,\n' % quote_python(interest).encode(ExternalEncoding))
        level -= 1
        showIndent(outfile, level)
        outfile.write('],\n')
        showIndent(outfile, level)
        outfile.write('category=%d,\n' % self.category)
    def build(self, node_):
        attrs = node_.attributes
        self.buildAttributes(attrs)
        for child_ in node_.childNodes:
            nodeName_ = child_.nodeName.split(':')[-1]
            self.buildChildren(child_, nodeName_)
    def buildAttributes(self, attrs):
        if attrs.get('priority'):
            try:
                self.priority = float(attrs.get('priority').value)
            except ValueError, exp:
                raise ValueError('Bad float/double attribute (priority): %s' % exp)
        if attrs.get('color-code'):
            self.color_code = attrs.get('color-code').value
        if attrs.get('id'):
            try:
                self.id = int(attrs.get('id').value)
            except ValueError, exp:
                raise ValueError('Bad integer attribute (id): %s' % exp)
    def buildChildren(self, child_, nodeName_):
        if child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'first-name':
            first_name_ = ''
            for text__content_ in child_.childNodes:
                first_name_ += text__content_.nodeValue
            self.first_name = first_name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'last-name':
            last_name_ = ''
            for text__content_ in child_.childNodes:
                last_name_ += text__content_.nodeValue
            self.last_name = last_name_
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'interest':
            interest_ = ''
            for text__content_ in child_.childNodes:
                interest_ += text__content_.nodeValue
            self.interest.append(interest_)
        elif child_.nodeType == Node.ELEMENT_NODE and \
            nodeName_ == 'category':
            if child_.firstChild:
                sval_ = child_.firstChild.nodeValue
                try:
                    ival_ = int(sval_)
                except ValueError, exp:
                    raise ValueError('requires integer (category): %s' % exp)
                self.category = ival_
# end class contactType


USAGE_TEXT = """
Usage: python <Parser>.py [ -s ] <in_xml_file>
"""

def usage():
    print USAGE_TEXT
    sys.exit(1)


def parse(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = contactlistType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="contact-list", 
        namespacedef_='')
    return rootObj


def parseString(inString):
    doc = minidom.parseString(inString)
    rootNode = doc.documentElement
    rootObj = contactlistType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('<?xml version="1.0" ?>\n')
    rootObj.export(sys.stdout, 0, name_="contact-list",
        namespacedef_='')
    return rootObj


def parseLiteral(inFileName):
    doc = minidom.parse(inFileName)
    rootNode = doc.documentElement
    rootObj = contactlistType.factory()
    rootObj.build(rootNode)
    # Enable Python to collect the space used by the DOM.
    doc = None
    sys.stdout.write('from member_specs_api import *\n\n')
    sys.stdout.write('rootObj = contact_list(\n')
    rootObj.exportLiteral(sys.stdout, 0, name_="contact_list")
    sys.stdout.write(')\n')
    return rootObj


def main():
    args = sys.argv[1:]
    if len(args) == 1:
        parse(args[0])
    else:
        usage()


if __name__ == '__main__':
    #import pdb; pdb.set_trace()
    main()

