# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Adding model 'Tag'
        db.create_table('simpleblog_tag', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('name', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('url_key', self.gf('django.db.models.fields.SlugField')(max_length=128, blank=True)),
        ))
        db.send_create_signal('simpleblog', ['Tag'])

        # Adding model 'Article'
        db.create_table('simpleblog_article', (
            ('id', self.gf('django.db.models.fields.AutoField')(primary_key=True)),
            ('title', self.gf('django.db.models.fields.CharField')(max_length=128)),
            ('url_key', self.gf('django.db.models.fields.SlugField')(max_length=128, blank=True)),
            ('created_at', self.gf('django.db.models.fields.DateField')(auto_now_add=True, blank=True)),
            ('description', self.gf('django.db.models.fields.TextField')()),
            ('content', self.gf('django.db.models.fields.TextField')()),
        ))
        db.send_create_signal('simpleblog', ['Article'])

        # Adding M2M table for field tags on 'Article'
        db.create_table('simpleblog_article_tags', (
            ('id', models.AutoField(verbose_name='ID', primary_key=True, auto_created=True)),
            ('article', models.ForeignKey(orm['simpleblog.article'], null=False)),
            ('tag', models.ForeignKey(orm['simpleblog.tag'], null=False))
        ))
        db.create_unique('simpleblog_article_tags', ['article_id', 'tag_id'])


    def backwards(self, orm):
        # Deleting model 'Tag'
        db.delete_table('simpleblog_tag')

        # Deleting model 'Article'
        db.delete_table('simpleblog_article')

        # Removing M2M table for field tags on 'Article'
        db.delete_table('simpleblog_article_tags')


    models = {
        'simpleblog.article': {
            'Meta': {'object_name': 'Article'},
            'content': ('django.db.models.fields.TextField', [], {}),
            'created_at': ('django.db.models.fields.DateField', [], {'auto_now_add': 'True', 'blank': 'True'}),
            'description': ('django.db.models.fields.TextField', [], {}),
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'tags': ('django.db.models.fields.related.ManyToManyField', [], {'to': "orm['simpleblog.Tag']", 'symmetrical': 'False'}),
            'title': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'url_key': ('django.db.models.fields.SlugField', [], {'max_length': '128', 'blank': 'True'})
        },
        'simpleblog.tag': {
            'Meta': {'object_name': 'Tag'},
            'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'name': ('django.db.models.fields.CharField', [], {'max_length': '128'}),
            'url_key': ('django.db.models.fields.SlugField', [], {'max_length': '128', 'blank': 'True'})
        }
    }

    complete_apps = ['simpleblog']