Easymode : toolkit for making xml based flash websites
======================================================

Easymode is an aspect oriented toolkit that helps making xml based flash websites easy.
The tools included in the toolkit to help you make these kind of sites include:

.. toctree::
   :maxdepth: 1

    Internationalization of models, with admin support <i18n/index.md>
    Translation of model data using gettext <i18n/translation.md>
    Automatic generation of xml from model trees using xslt<xslt/index.md>
    Admin support for model trees with more than 2 levels of related items <tree/index.md>
    Basic approval support for models <easypublisher.md>

The best way to learn how easymode works, is to read the above topics in sequence
and then look at the :ref:`example_app`.

Version naming convention
-------------------------

* Each update to the development status will increase the first digit. (eg beta or alpha or production ready)
* Each new feature will increase the second digit.
* Each bugfix or refactor will increase the last digit

.. _example_app:

Example
=======

Easymode comes with an example app which is available from github:

http://github.com/LUKKIEN/django-easymode/

To run the example app, you must clone the repository, install the dependencies
and initialize the database::

    git clone http://github.com/LUKKIEN/django-easymode.git
    cd django-easymode
    pip install -r requirements.txt
    cd example
    python manage.py syncdb
    python manage.py loaddata example_data.xml
    python manage.py runserver
    open http://127.0.0.1:8000/
    
Unsupported django features
===========================

The following features, which django supports, are not supported by easymode:

- :attr:`~django.db.models.Options.unique_together`
- :attr:`~django.db.models.Field.unique_for_date`, :attr:`~django.db.models.Field.unique_for_month`,
  :attr:`~django.db.models.Field.unique_for_year`
- :attr:`django.contrib.admin.ModelAdmin.fields`, use :attr:`django.contrib.admin.ModelAdmin.fieldsets` instead.
- Automatic serialization of :class:`~django.db.models.ManyToManyField`. The model tree should 
  be a `DAG <http://en.wikipedia.org/wiki/Directed_acyclic_graph>`_.
- Inheritance for models is restricted to :attr:`~django.db.models.Options.abstract` base classes. 
  This is a direct result of the fact that :class:`~django.db.models.OneToOneField` are *not* supported by
  the serializer.

All these features are not supported because the ammount of work to have them was greater than the benefit of having them.

Additional subjects
===================

.. toctree::
    :maxdepth: 1
    
    settings
    commands
    templatetags
    middlewares <middleware.md>
    Injecting extra data into the XSLT <xslt/helpers.md>

Getting easymode
================

You can download easymode from:

http://github.com/LUKKIEN/django-easymode/downloads/

Or you can do:

- ``pip install django-easymode``

Or:
- ``pip install -e git://github.com/LUKKIEN/django-easymode.git#egg=easymode``

Note the version number in the top left corner and use:

- ``easy_install http://github.com/LUKKIEN/django-easymode/tarball/[VERSION]``

Which, if the version was v0.1.0 would become http://github.com/LUKKIEN/django-easymode/tarball/v0.1.0.

Api docs
========

.. toctree::
    :maxdepth: 2

    i18n/api
    tree/api
    xslt/api
    utils/api
    fields    
    