import os
from setuptools import setup

README = open(os.path.join(os.path.dirname(__file__), 'README.md')).read()

# allow setup.py to be run from any path
os.chdir(os.path.normpath(os.path.join(os.path.abspath(__file__), os.pardir)))

setup(
    name='django-crm',
    version='0.1.0',
    packages=['crm'],
    include_package_data=True,
    license='BSD License',  # example license
    description='Customer relation management system',
    long_description=README,
    url='http://www.de-nieuwbouwmakelaar.nl',
    author='Vincent van Bergen',
    author_email='v.vanbergen@gmail.com',
    install_requires=[
        "django-mailchimp-v1.3",
    ],
    classifiers=[
        'Environment :: Web Environment',
        'Framework :: Django',
        'Intended Audience :: Developers',
        'License :: OSI Approved :: BSD License', # example license
        'Operating System :: OS Independent',
        'Programming Language :: Python',
        # replace these appropriately if you are using Python 3
        'Programming Language :: Python :: 2',
        'Programming Language :: Python :: 2.7',
        'Topic :: Internet :: WWW/HTTP',
        'Topic :: Internet :: WWW/HTTP :: Dynamic Content',
    ],
)