# -*- coding: utf-8 -*-
import datetime
from south.db import db
from south.v2 import SchemaMigration
from django.db import models


class Migration(SchemaMigration):

    def forwards(self, orm):
        # Removing unique constraint on 'Notification', fields ['receipt']
        db.delete_unique(u'django_clickbank_notification', ['receipt'])

        # Adding field 'Notification.rebill_parent_receipt'
        db.add_column(u'django_clickbank_notification', 'rebill_parent_receipt',
                      self.gf('django.db.models.fields.CharField')(db_index=True, max_length=13, null=True, blank=True),
                      keep_default=False)

        # Adding index on 'Notification', fields ['parent_receipt']
        db.create_index(u'django_clickbank_notification', ['parent_receipt'])

        # Adding unique constraint on 'Notification', fields ['receipt', 'transaction_type']
        db.create_unique(u'django_clickbank_notification', ['receipt', 'transaction_type'])

        if not db.dry_run:
            for notification in orm.Notification.objects.filter(transaction_type='BILL'):
                notification.rebill_parent_receipt = notification.receipt.split('-')[0]
                notification.save()


    def backwards(self, orm):
        # Removing unique constraint on 'Notification', fields ['receipt', 'transaction_type']
        db.delete_unique(u'django_clickbank_notification', ['receipt', 'transaction_type'])

        # Removing index on 'Notification', fields ['parent_receipt']
        db.delete_index(u'django_clickbank_notification', ['parent_receipt'])

        # Deleting field 'Notification.rebill_parent_receipt'
        db.delete_column(u'django_clickbank_notification', 'rebill_parent_receipt')

        # Adding unique constraint on 'Notification', fields ['receipt']
        db.create_unique(u'django_clickbank_notification', ['receipt'])


    models = {
        u'django_clickbank.notification': {
            'Meta': {'unique_together': "(('receipt', 'transaction_type'),)", 'object_name': 'Notification'},
            'address1': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'address2': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'city': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'country': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'country_code': ('django.db.models.fields.CharField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'currency': ('django.db.models.fields.CharField', [], {'max_length': '3'}),
            'email': ('django.db.models.fields.CharField', [], {'max_length': '255'}),
            'extra_data': ('django.db.models.fields.CharField', [], {'max_length': '1024', 'null': 'True', 'blank': 'True'}),
            'first_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'full_name': ('django.db.models.fields.CharField', [], {'max_length': '510'}),
            'future_payments': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'last_name': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'next_payment_date': ('django.db.models.fields.DateField', [], {'null': 'True', 'blank': 'True'}),
            'notification_version': ('django.db.models.fields.CharField', [], {'max_length': '5', 'null': 'True', 'blank': 'True'}),
            'order_amount': ('django.db.models.fields.DecimalField', [], {'max_digits': '8', 'decimal_places': '2'}),
            'order_language': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True', 'blank': 'True'}),
            'parent_receipt': ('django.db.models.fields.CharField', [], {'db_index': 'True', 'max_length': '13', 'null': 'True', 'blank': 'True'}),
            'payment_method': ('django.db.models.fields.CharField', [], {'max_length': '4', 'null': 'True', 'blank': 'True'}),
            'post_data': ('django.db.models.fields.related.ForeignKey', [], {'to': u"orm['django_clickbank.Post']", 'null': 'True', 'blank': 'True'}),
            'postal_code': ('django.db.models.fields.CharField', [], {'max_length': '16', 'null': 'True', 'blank': 'True'}),
            'processed_payments': ('django.db.models.fields.IntegerField', [], {'null': 'True', 'blank': 'True'}),
            'product_id': ('django.db.models.fields.CharField', [], {'max_length': '5'}),
            'product_title': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'product_type': ('django.db.models.fields.CharField', [], {'max_length': '11'}),
            'province': ('django.db.models.fields.CharField', [], {'max_length': '2', 'null': 'True', 'blank': 'True'}),
            'rebill_amount': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '8', 'decimal_places': '2', 'blank': 'True'}),
            'rebill_frequency': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True', 'blank': 'True'}),
            'rebill_parent_receipt': ('django.db.models.fields.CharField', [], {'db_index': 'True', 'max_length': '13', 'null': 'True', 'blank': 'True'}),
            'rebill_status': ('django.db.models.fields.CharField', [], {'max_length': '10', 'null': 'True', 'blank': 'True'}),
            'receipt': ('django.db.models.fields.CharField', [], {'max_length': '13', 'db_index': 'True'}),
            'recieved_amount': ('django.db.models.fields.DecimalField', [], {'max_digits': '8', 'decimal_places': '2'}),
            'role': ('django.db.models.fields.CharField', [], {'max_length': '9'}),
            'sender_ip': ('django.db.models.fields.IPAddressField', [], {'max_length': '15', 'blank': 'True'}),
            'shipping_address1': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'shipping_address2': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'shipping_amount': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '8', 'decimal_places': '2', 'blank': 'True'}),
            'shipping_city': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'shipping_country': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'shipping_county': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'shipping_postal_code': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'shipping_province': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'tax_amount': ('django.db.models.fields.DecimalField', [], {'null': 'True', 'max_digits': '8', 'decimal_places': '2', 'blank': 'True'}),
            'tracking_id': ('django.db.models.fields.CharField', [], {'max_length': '255', 'null': 'True', 'blank': 'True'}),
            'transaction_affiliate': ('django.db.models.fields.CharField', [], {'max_length': '10', 'null': 'True', 'blank': 'True'}),
            'transaction_date': ('django.db.models.fields.DateTimeField', [], {}),
            'transaction_type': ('django.db.models.fields.CharField', [], {'max_length': '15'}),
            'transaction_vendor': ('django.db.models.fields.CharField', [], {'max_length': '10', 'blank': 'True'}),
            'upsell_flow': ('django.db.models.fields.CharField', [], {'max_length': '20', 'null': 'True', 'blank': 'True'}),
            'verification_passed': ('django.db.models.fields.BooleanField', [], {'default': 'True'})
        },
        u'django_clickbank.post': {
            'Meta': {'object_name': 'Post'},
            'failed': ('django.db.models.fields.BooleanField', [], {'default': 'False'}),
            'get_data': ('django.db.models.fields.CharField', [], {'max_length': '4096', 'null': 'True', 'blank': 'True'}),
            u'id': ('django.db.models.fields.AutoField', [], {'primary_key': 'True'}),
            'post_data': ('django.db.models.fields.CharField', [], {'max_length': '4096', 'null': 'True', 'blank': 'True'}),
            'time': ('django.db.models.fields.DateTimeField', [], {'auto_now_add': 'True', 'blank': 'True'})
        }
    }

    complete_apps = ['django_clickbank']