"""replacement patterns manipulated from data originally from Perseus
licensed under the `Mozilla Public License 1.1 (MPL 1.1)
[http://www.mozilla.org/MPL/1.1/]
"""

__author__ = 'Kyle P. Johnson <kyle@kyle-p-johnson.com>'
__license__ = 'MIT License. See LICENSE.'

REPLACEMENT_PATTERNS = [
    (r'\b-nam\b', 'nam'),
    (r'\b-namque\b', 'nam'),
    (r'\b-sed\b', 'sed'),
    (r'\ba\b', 'a'),
    (r'\ba\b', 'ab'),
    (r'\bAaron\b', 'a-aro'),
    (r'\baaron\b', 'a-aro'),
    (r'\bAaroni\b', 'a-aro'),
    (r'\bab\b', 'ab'),
    (r'\babaci\b', 'abax'),
    (r'\babacis\b', 'abax'),
    (r'\babaco\b', 'abactor'),
    (r'\babacta\b', 'abigo'),
    (r'\babactae\b', 'abigo'),
    (r'\babactam\b', 'abigo'),
    (r'\babactas\b', 'abigo'),
    (r'\babacti\b', 'abigo'),
    (r'\babactis\b', 'abigo'),
    (r'\babacto\b', 'abigo'),
    (r'\babactorem\b', 'abactor'),
    (r'\babactores\b', 'abactor'),
    (r'\babactos\b', 'abigo'),
    (r'\babactum\b', 'abactus2'),
    (r'\babactum\b', 'abigo'),
    (r'\babactumve\b', 'abactus2'),
    (r'\babactumve\b', 'abigo'),
    (r'\babactus\b', 'abactus2'),
    (r'\babactus\b', 'abigo'),
    (r'\babacum\b', 'abax'),
    (r'\babaddon\b', 'ab-addo'),
    (r'\babaestumo\b', 'ab-aestimo'),
    (r'\babalati\b', 'ab-alo'),
    (r'\babale\b', 'ab-alo'),
    (r'\babali\b', 'ab-alo'),
    (r'\babalienabantur\b', 'abalieno'),
    (r'\babalienabas\b', 'abalieno'),
    (r'\babalienabit\b', 'abalieno'),
    (r'\babalienabuntur\b', 'abalieno'),
    (r'\babalienanda\b', 'abalieno'),
    (r'\babalienantque\b', 'abalieno'),
    (r'\babalienare\b', 'abalieno'),
    (r'\babalienarent\b', 'abalieno'),
    (r'\babalienarentur\b', 'abalieno'),
    (r'\babalienaret\b', 'abalieno'),
    (r'\babalienari\b', 'abalieno'),
    (r'\babalienarier\b', 'abalieno'),
    (r'\babalienarit\b', 'abalieno'),
    (r'\babalienarunt\b', 'abalieno'),
    (r'\babalienasse\b', 'abalieno'),
    (r'\babalienasti\b', 'abalieno'),
    (r'\babalienat\b', 'abalieno'),
    (r'\babalienata\b', 'abalieno'),
    (r'\babalienatam\b', 'abalieno'),
    (r'\babalienati\b', 'abalieno'),
    (r'\babalienatio\b', 'abalienatio'),
    (r'\babalienatis\b', 'abalieno'),
    (r'\babalienato\b', 'abalieno'),
    (r'\babalienatum\b', 'abalieno'),
    (r'\babalienatur\b', 'abalieno'),
    (r'\babalienauerant\b', 'abalieno'),
    (r'\babalienauero\b', 'abalieno'),
    (r'\babalienauit\b', 'abalieno'),
    (r'\babalienaverit\b', 'abalieno'),
    (r'\babalienavit\b', 'abalieno'),
    (r'\babalienemur\b', 'abalieno'),
    (r'\babalienent\b', 'abalieno'),
    (r'\babalienentur\b', 'abalieno'),
    (r'\babalienes\b', 'abalieno'),
    (r'\babalienetur\b', 'abalieno'),
    (r'\babamita\b', 'abamita'),
    (r'\babamitas\b', 'abamita'),
    (r'\bAbante\b', 'ab-aro'),
    (r'\bAbanteis\b', 'ab-anteeo'),
    (r'\babanteis\b', 'ab-anteeo'),
    (r'\bAbantem\b', 'ab-aro'),
    (r'\bAbantes\b', 'ab-aro'),
    (r'\bAbanti\b', 'ab-aro'),
    (r'\bAbanti\b', 'ab-anteeo'),
    (r'\bAbantia\b', 'ab-anteeo'),
    (r'\bAbantiadas\b', 'ab-anteeo'),
    (r'\bAbantiades\b', 'ab-anteeo'),
    (r'\bAbantias\b', 'ab-anteeo'),
    (r'\bAbantis\b', 'ab-aro'),
    (r'\bAbarin\b', 'Abaris'),
    (r'\bAbarinque\b', 'Abaris'),
    (r'\bAbaritana\b', 'Abaritanus'),
    (r'\babaron\b', 'ab-aro'),
    (r'\bAbas\b', 'Aba'),
    (r'\bAbas\b', 'ab-aro'),
    (r'\babascanto\b', 'abascantus'),
    (r'\bAbaton\b', 'Abatos'),
    (r'\bAbatos\b', 'Abatos'),
    (r'\babaui\b', 'abavus'),
    (r'\babauia\b', 'abavia'),
    (r'\babauiae\b', 'abavia'),
    (r'\babauiaeue\b', 'abavia'),
    (r'\babauum\b', 'abavus'),
    (r'\babauunculos\b', 'abavunculus'),
    (r'\babauunculus\b', 'abavunculus'),
    (r'\babauus\b', 'abavus'),
    (r'\babauusque\b', 'abavus'),
    (r'\babavi\b', 'abavus'),
    (r'\babavo\b', 'abavus'),
    (r'\babavorum\b', 'abavus'),
    (r'\babavos\b', 'abavus'),
    (r'\babavum\b', 'abavus'),
    (r'\babavus\b', 'abavus'),
    (r'\bAbba\b', 'Abba'),
    (r'\babcessus\b', 'ab-cedo1'),
    (r'\babcondit\b', 'ab-condio'),
    (r'\babda\b', 'abdo'),
    (r'\bAbdalonymi\b', 'ab-condio'),
    (r'\bAbdalonymo\b', 'ab-condio'),
    (r'\bAbdalonymum\b', 'ab-condio'),
    (r'\bAbdalonymus\b', 'ab-condio'),
    (r'\babdas\b', 'abdo'),
    (r'\babdemus\b', 'abdo'),
    (r'\babdentur\b', 'abdo'),
    (r'\bAbdera\b', 'ab-defleo'),
    (r'\bAbderam\b', 'ab-defleo'),
    (r'\babderam\b', 'ab-defleo'),
    (r'\babdere\b', 'abdo'),
    (r'\bAbderita\b', 'abdicatio'),
    (r'\bAbderitae\b', 'abdicatio'),
    (r'\bAbderitanae\b', 'abdicatio'),
    (r'\bAbderitarum\b', 'abdicatio'),
    (r'\bAbderitas\b', 'abdicatio'),
    (r'\bAbderitis\b', 'abdicatio'),
    (r'\babderitis\b', 'ab-defleo'),
    (r'\babdet\b', 'abdo'),
    (r'\babdica\b', 'abdico1'),
    (r'\babdicabat\b', 'abdico1'),
    (r'\babdicabis\b', 'abdico1'),
    (r'\babdicabit\b', 'abdico1'),
    (r'\babdicabo\b', 'abdico1'),
    (r'\babdicabor\b', 'abdico1'),
    (r'\babdicamus\b', 'abdico1'),
    (r'\babdicamus\b', 'abdico2'),
    (r'\babdicandae\b', 'abdico1'),
    (r'\babdicandi\b', 'abdico1'),
    (r'\babdicando\b', 'abdico1'),
    (r'\babdicandum\b', 'abdico1'),
    (r'\babdicandus\b', 'abdico1'),
    (r'\babdicans\b', 'abdico1'),
    (r'\babdicant\b', 'abdico1'),
    (r'\babdicant\b', 'abdico2'),
    (r'\babdicantem\b', 'abdico1'),
    (r'\babdicantes\b', 'abdico1'),
    (r'\babdicanti\b', 'abdico1'),
    (r'\babdicantis\b', 'abdico1'),
    (r'\babdicantque\b', 'abdico1'),
    (r'\babdicantque\b', 'abdico2'),
    (r'\babdicantur\b', 'abdico1'),
    (r'\babdicantur\b', 'abdico2'),
    (r'\babdicare\b', 'abdico1'),
    (r'\babdicare\b', 'abdico2'),
    (r'\babdicarem\b', 'abdico1'),
    (r'\babdicarent\b', 'abdico1'),
    (r'\babdicarer\b', 'abdico1'),
    (r'\babdicareris\b', 'abdico1'),
    (r'\babdicares\b', 'abdico1'),
    (r'\babdicaret\b', 'abdico1'),
    (r'\babdicaretur\b', 'abdico1'),
    (r'\babdicari\b', 'abdico1'),
    (r'\babdicarit\b', 'abdico1'),
    (r'\babdicarunt\b', 'abdico1'),
    (r'\babdicas\b', 'abdico1'),
    (r'\babdicas\b', 'abdico2'),
    (r'\babdicasse\b', 'abdico1'),
    (r'\babdicassent\b', 'abdico1'),
    (r'\babdicasset\b', 'abdico1'),
    (r'\babdicasti\b', 'abdico1'),
    (r'\babdicat\b', 'abdico1'),
    (r'\babdicat\b', 'abdico2'),
    (r'\babdicata\b', 'abdico1'),
    (r'\babdicatam\b', 'abdico1'),
    (r'\babdicati\b', 'abdico1'),
    (r'\babdicatio\b', 'abdicatio'),
    (r'\babdicatione\b', 'abdicatio'),
    (r'\babdicationem\b', 'abdicatio'),
    (r'\babdicationes\b', 'abdicatio'),
    (r'\babdicationi\b', 'abdicatio'),
    (r'\babdicationibus\b', 'abdicatio'),
    (r'\babdicationis\b', 'abdicatio'),
    (r'\babdicationum\b', 'abdicatio'),
    (r'\babdicatis\b', 'abdico1'),
    (r'\babdicatis\b', 'abdico2'),
    (r'\babdicato\b', 'abdico1'),
    (r'\babdicatorum\b', 'abdico1'),
    (r'\babdicatos\b', 'abdico1'),
    (r'\babdicatum\b', 'abdico1'),
    (r'\babdicatur\b', 'abdico1'),
    (r'\babdicatur\b', 'abdico2'),
    (r'\babdicatura\b', 'abdico1'),
    (r'\babdicaturum\b', 'abdico1'),
    (r'\babdicaturus\b', 'abdico1'),
    (r'\babdicatus\b', 'abdico1'),
    (r'\babdicauerat\b', 'abdico1'),
    (r'\babdicauere\b', 'abdico1'),
    (r'\babdicauerit\b', 'abdico1'),
    (r'\babdicauerunt\b', 'abdico1'),
    (r'\babdicauit\b', 'abdico1'),
    (r'\babdicaveras\b', 'abdico1'),
    (r'\babdicaverim\b', 'abdico1'),
    (r'\babdicaveris\b', 'abdico1'),
    (r'\babdicaverunt\b', 'abdico1'),
    (r'\babdicavi\b', 'abdico1'),
    (r'\babdicavit\b', 'abdico1'),
    (r'\babdicavitque\b', 'abdico1'),
    (r'\babdicem\b', 'abdico1'),
    (r'\babdicent\b', 'abdico2'),
    (r'\babdicent\b', 'abdico1'),
    (r'\babdicer\b', 'abdico1'),
    (r'\babdices\b', 'abdico2'),
    (r'\babdices\b', 'abdico1'),
    (r'\babdicet\b', 'abdico2'),
    (r'\babdicet\b', 'abdico1'),
    (r'\babdicetur\b', 'abdico2'),
    (r'\babdicetur\b', 'abdico1'),
    (r'\babdico\b', 'abdico1'),
    (r'\babdicor\b', 'abdico1'),
    (r'\babdiderant\b', 'abdo'),
    (r'\babdiderat\b', 'abdo'),
    (r'\babdiderim\b', 'abdo'),
    (r'\babdiderint\b', 'abdo'),
    (r'\babdideris\b', 'abdo'),
    (r'\babdiderit\b', 'abdo'),
    (r'\babdiderunt\b', 'abdo'),
    (r'\babdidi\b', 'abdo'),
    (r'\babdidisse\b', 'abdo'),
    (r'\babdidisset\b', 'abdo'),
    (r'\babdidit\b', 'abdo'),
    (r'\babdita\b', 'abditus'),
    (r'\babdita\b', 'abdo'),
    (r'\babditae\b', 'abditus'),
    (r'\babditae\b', 'abdo'),
    (r'\babditam\b', 'abditus'),
    (r'\babditam\b', 'abdo'),
    (r'\babditaque\b', 'abditus'),
    (r'\babditaque\b', 'abdo'),
    (r'\babditarum\b', 'abditus'),
    (r'\babditarum\b', 'abdo'),
    (r'\babditas\b', 'abditus'),
    (r'\babditas\b', 'abdo'),
    (r'\babditasque\b', 'abditus'),
    (r'\babditasque\b', 'abdo'),
    (r'\babdite\b', 'abditus'),
    (r'\babdite\b', 'abdo'),
    (r'\babditi\b', 'abditus'),
    (r'\babditi\b', 'abdo'),
    (r'\babditique\b', 'abditus'),
    (r'\babditique\b', 'abdo'),
    (r'\babditis\b', 'abditus'),
    (r'\babditis\b', 'abdo'),
    (r'\babdito\b', 'abditus'),
    (r'\babdito\b', 'abdo'),
    (r'\babditos\b', 'abditus'),
    (r'\babditos\b', 'abdo'),
    (r'\babditum\b', 'abditus'),
    (r'\babditum\b', 'abdo'),
    (r'\babditus\b', 'abditus'),
    (r'\babditus\b', 'abdo'),
    (r'\babditusque\b', 'abditus'),
    (r'\babditusque\b', 'abdo'),
    (r'\babdixisse\b', 'abdico2'),
    (r'\babdixissent\b', 'abdico2'),
    (r'\babdo\b', 'abdo'),
    (r'\babdomen\b', 'abdomen'),
    (r'\babdomina\b', 'abdomen'),
    (r'\babdomine\b', 'abdomen'),
    (r'\babdomini\b', 'abdomen'),
    (r'\babdominis\b', 'abdomen'),
    (r'\babdon\b', 'abdo'),
    (r'\babduc\b', 'abduco'),
    (r'\babducam\b', 'abduco'),
    (r'\babducamus\b', 'abduco'),
    (r'\babducant\b', 'abduco'),
    (r'\babducantur\b', 'abduco'),
    (r'\babducar\b', 'abduco'),
    (r'\babducas\b', 'abduco'),
    (r'\babducat\b', 'abduco'),
    (r'\babducatis\b', 'abduco'),
    (r'\babducatur\b', 'abduco'),
    (r'\babduce\b', 'abduco'),
    (r'\babducebam\b', 'abduco'),
    (r'\babducebat\b', 'abduco'),
    (r'\babducemini\b', 'abduco'),
    (r'\babducenda\b', 'abduco'),
    (r'\babducendi\b', 'abduco'),
    (r'\babducendo\b', 'abduco'),
    (r'\babducendum\b', 'abduco'),
    (r'\babducendumque\b', 'abduco'),
    (r'\babducendus\b', 'abduco'),
    (r'\babducentes\b', 'abduco'),
    (r'\babducentque\b', 'abduco'),
    (r'\babducentur\b', 'abduco'),
    (r'\babducere\b', 'abduco'),
    (r'\babducerem\b', 'abduco'),
    (r'\babducerent\b', 'abduco'),
    (r'\babducerentur\b', 'abduco'),
    (r'\babduceres\b', 'abduco'),
    (r'\babduceret\b', 'abduco'),
    (r'\babduceretur\b', 'abduco'),
    (r'\babduces\b', 'abduco'),
    (r'\babducet\b', 'abduco'),
    (r'\babducetque\b', 'abduco'),
    (r'\babducetur\b', 'abduco'),
    (r'\babduci\b', 'abduco'),
    (r'\babducimur\b', 'abduco'),
    (r'\babducimus\b', 'abduco'),
    (r'\babducis\b', 'abduco'),
    (r'\babducit\b', 'abduco'),
    (r'\babducite\b', 'abduco'),
    (r'\babducitis\b', 'abduco'),
    (r'\babducito\b', 'abduco'),
    (r'\babducitque\b', 'abduco'),
    (r'\babducitur\b', 'abduco'),
    (r'\babduco\b', 'abduco'),
    (r'\babducta\b', 'abduco'),
    (r'\babductae\b', 'abduco'),
    (r'\babductam\b', 'abduco'),
    (r'\babductaque\b', 'abduco'),
    (r'\babductas\b', 'abduco'),
    (r'\babductast\b', 'abduco'),
    (r'\babducti\b', 'abduco'),
    (r'\babductione\b', 'abductio'),
    (r'\babductique\b', 'abduco'),
    (r'\babductis\b', 'abduco'),
    (r'\babductisque\b', 'abduco'),
    (r'\babducto\b', 'abduco'),
    (r'\babductos\b', 'abduco'),
    (r'\babductosque\b', 'abduco'),
    (r'\babductum\b', 'abduco'),
    (r'\babducturam\b', 'abduco'),
    (r'\babducturum\b', 'abduco'),
    (r'\babducturus\b', 'abduco'),
    (r'\babducturusque\b', 'abduco'),
    (r'\babductus\b', 'abduco'),
    (r'\babducunt\b', 'abduco'),
    (r'\babducuntur\b', 'abduco'),
    (r'\babduxerat\b', 'abduco'),
    (r'\babduxere\b', 'abduco'),
    (r'\babduxerim\b', 'abduco'),
    (r'\babduxerint\b', 'abduco'),
    (r'\babduxeris\b', 'abduco'),
    (r'\babduxerit\b', 'abduco'),
    (r'\babduxero\b', 'abduco'),
    (r'\babduxerunt\b', 'abduco'),
    (r'\babduxi\b', 'abduco'),
    (r'\babduximus\b', 'abduco'),
    (r'\babduxisse\b', 'abduco'),
    (r'\babduxisses\b', 'abduco'),
    (r'\babduxisset\b', 'abduco'),
    (r'\babduxisti\b', 'abduco'),
    (r'\babduxit\b', 'abduco'),
    (r'\babduxitque\b', 'abduco'),
    (r'\babeam\b', 'abeo'),
    (r'\babeamus\b', 'abeo'),
    (r'\babeant\b', 'abeo'),
    (r'\babeantve\b', 'abeo'),
    (r'\babeas\b', 'abeo'),
    (r'\babeasque\b', 'abeo'),
    (r'\babeat\b', 'abeo'),
    (r'\bAbeatae\b', 'Abeatae'),
    (r'\babeatae\b', 'abeo'),
    (r'\babeatis\b', 'abeo'),
    (r'\babeatque\b', 'abeo'),
    (r'\babeatur\b', 'abeo'),
    (r'\babegere\b', 'abigo'),
    (r'\babegerit\b', 'abigo'),
    (r'\babegerunt\b', 'abigo'),
    (r'\babegi\b', 'abigo'),
    (r'\babegimusque\b', 'abigo'),
    (r'\babegisse\b', 'abigo'),
    (r'\babegisset\b', 'abigo'),
    (r'\babegisti\b', 'abigo'),
    (r'\babegit\b', 'abigo'),
    (r'\bAbella\b', 'Abella'),
    (r'\bAbellae\b', 'Abella'),
    (r'\bAbellam\b', 'Abella'),
    (r'\bAbellinates\b', 'Abellinum'),
    (r'\bAbellino\b', 'Abellinum'),
    (r'\bAbellinum\b', 'Abellinum'),
    (r'\babeo\b', 'abeo'),
    (r'\babequitauerint\b', 'abequito'),
    (r'\baberam\b', 'absum'),
    (r'\baberamque\b', 'absum'),
    (r'\baberant\b', 'absum'),
    (r'\baberas\b', 'absum'),
    (r'\baberat\b', 'absum'),
    (r'\babere\b', 'abeo'),
    (r'\baberis\b', 'absum'),
    (r'\baberit\b', 'absum'),
    (r'\baberitis\b', 'absum'),
    (r'\baberitque\b', 'absum'),
    (r'\babero\b', 'absum'),
    (r'\baberrabimus\b', 'aberro'),
    (r'\baberrabis\b', 'aberro'),
    (r'\baberramus\b', 'aberro'),
    (r'\baberrant\b', 'aberro'),
    (r'\baberrante\b', 'aberro'),
    (r'\baberrantem\b', 'aberro'),
    (r'\baberrantes\b', 'aberro'),
    (r'\baberranti\b', 'aberro'),
    (r'\baberrantia\b', 'aberro'),
    (r'\baberrantibus\b', 'aberro'),
    (r'\baberrantis\b', 'aberro'),
    (r'\baberrare\b', 'aberro'),
    (r'\baberrarent\b', 'aberro'),
    (r'\baberrarunt\b', 'aberro'),
    (r'\baberrasse\b', 'aberro'),
    (r'\baberrasset\b', 'aberro'),
    (r'\baberrat\b', 'aberro'),
    (r'\baberrationem\b', 'aberratio'),
    (r'\baberrauerit\b', 'aberro'),
    (r'\baberrauerunt\b', 'aberro'),
    (r'\baberrauit\b', 'aberro'),
    (r'\baberravi\b', 'aberro'),
    (r'\baberravisset\b', 'aberro'),
    (r'\baberravit\b', 'aberro'),
    (r'\baberrem\b', 'aberro'),
    (r'\baberrent\b', 'aberro'),
    (r'\baberret\b', 'aberro'),
    (r'\baberro\b', 'aberro'),
    (r'\baberunt\b', 'absum'),
    (r'\baberunt\b', 'abeo'),
    (r'\babes\b', 'absum'),
    (r'\babesse\b', 'absum'),
    (r'\babessem\b', 'absum'),
    (r'\babessemque\b', 'absum'),
    (r'\babessemus\b', 'absum'),
    (r'\babessent\b', 'absum'),
    (r'\babesses\b', 'absum'),
    (r'\babesset\b', 'absum'),
    (r'\babest\b', 'absum'),
    (r'\babestis\b', 'absum'),
    (r'\babesto\b', 'absum'),
    (r'\babestque\b', 'absum'),
    (r'\babesus\b', 'ab-edo1'),
    (r'\babeundi\b', 'abeo'),
    (r'\babeundo\b', 'abeo'),
    (r'\babeundum\b', 'abeo'),
    (r'\babeunt\b', 'abeo'),
    (r'\babeunte\b', 'abeo'),
    (r'\babeuntem\b', 'abeo'),
    (r'\babeuntemque\b', 'abeo'),
    (r'\babeuntes\b', 'abeo'),
    (r'\babeunti\b', 'abeo'),
    (r'\babeuntia\b', 'abeo'),
    (r'\babeuntibus\b', 'abeo'),
    (r'\babeuntique\b', 'abeo'),
    (r'\babeuntis\b', 'abeo'),
    (r'\babeuntium\b', 'abeo'),
    (r'\babeuntque\b', 'abeo'),
    (r'\babfer\b', 'ab-for'),
    (r'\babfer\b', 'ab-for'),
    (r'\babfero\b', 'ab-for'),
    (r'\babfuat\b', 'absum'),
    (r'\babfugio\b', 'ab-fugio'),
    (r'\babfugit\b', 'ab-fugio'),
    (r'\babfuimus\b', 'absum'),
    (r'\babfuisse\b', 'absum'),
    (r'\babfuisset\b', 'absum'),
    (r'\babfuit\b', 'absum'),
    (r'\babfuturam\b', 'absum'),
    (r'\babhinc\b', 'abhinc'),
    (r'\babhorre\b', 'abhorreo'),
    (r'\babhorreant\b', 'abhorreo'),
    (r'\babhorreas\b', 'abhorreo'),
    (r'\babhorreat\b', 'abhorreo'),
    (r'\babhorrebant\b', 'abhorreo'),
    (r'\babhorrebat\b', 'abhorreo'),
    (r'\babhorrebit\b', 'abhorreo'),
    (r'\babhorrebunt\b', 'abhorreo'),
    (r'\babhorrens\b', 'abhorreo'),
    (r'\babhorrent\b', 'abhorreo'),
    (r'\babhorrente\b', 'abhorreo'),
    (r'\babhorrentem\b', 'abhorreo'),
    (r'\babhorrentes\b', 'abhorreo'),
    (r'\babhorrenti\b', 'abhorreo'),
    (r'\babhorrentia\b', 'abhorreo'),
    (r'\babhorrentibus\b', 'abhorreo'),
    (r'\babhorrentis\b', 'abhorreo'),
    (r'\babhorrentium\b', 'abhorreo'),
    (r'\babhorreo\b', 'abhorreo'),
    (r'\babhorrere\b', 'abhorreo'),
    (r'\babhorrerem\b', 'abhorreo'),
    (r'\babhorrerent\b', 'abhorreo'),
    (r'\babhorreret\b', 'abhorreo'),
    (r'\babhorres\b', 'abhorreo'),
    (r'\babhorrescant\b', 'abhorresco'),
    (r'\babhorret\b', 'abhorreo'),
    (r'\babhorruerit\b', 'abhorreo'),
    (r'\babhorruisse\b', 'abhorreo'),
    (r'\babhorruit\b', 'abhorreo'),
    (r'\babi\b', 'abeo'),
    (r'\babibam\b', 'abeo'),
    (r'\babibant\b', 'abeo'),
    (r'\babibas\b', 'abeo'),
    (r'\babibat\b', 'abeo'),
    (r'\babibis\b', 'abeo'),
    (r'\babibit\b', 'abeo'),
    (r'\babibitur\b', 'abeo'),
    (r'\babibo\b', 'abeo'),
    (r'\babibunt\b', 'abeo'),
    (r'\babice\b', 'abicio'),
    (r'\babicere\b', 'abicio'),
    (r'\babiceremus\b', 'abicio'),
    (r'\babicerent\b', 'abicio'),
    (r'\babicerentur\b', 'abicio'),
    (r'\babiceret\b', 'abicio'),
    (r'\babiceretur\b', 'abicio'),
    (r'\babici\b', 'abicio'),
    (r'\babiciam\b', 'abicio'),
    (r'\babiciamus\b', 'abicio'),
    (r'\babiciant\b', 'abicio'),
    (r'\babiciantur\b', 'abicio'),
    (r'\babicias\b', 'abicio'),
    (r'\babiciat\b', 'abicio'),
    (r'\babiciatur\b', 'abicio'),
    (r'\babiciebant\b', 'abicio'),
    (r'\babiciebantur\b', 'abicio'),
    (r'\babiciebas\b', 'abicio'),
    (r'\babiciebatur\b', 'abicio'),
    (r'\babicienda\b', 'abicio'),
    (r'\babiciendae\b', 'abicio'),
    (r'\babiciendam\b', 'abicio'),
    (r'\babiciendas\b', 'abicio'),
    (r'\babiciendi\b', 'abicio'),
    (r'\babiciendis\b', 'abicio'),
    (r'\babiciendo\b', 'abicio'),
    (r'\babiciendorum\b', 'abicio'),
    (r'\babiciendos\b', 'abicio'),
    (r'\babiciendum\b', 'abicio'),
    (r'\babiciendus\b', 'abicio'),
    (r'\babicient\b', 'abicio'),
    (r'\babicientem\b', 'abicio'),
    (r'\babicientes\b', 'abicio'),
    (r'\babicientis\b', 'abicio'),
    (r'\babicies\b', 'abicio'),
    (r'\babiciet\b', 'abicio'),
    (r'\babicietur\b', 'abicio'),
    (r'\babicio\b', 'abicio'),
    (r'\babicique\b', 'abicio'),
    (r'\babicis\b', 'abicio'),
    (r'\babicit\b', 'abicio'),
    (r'\babicite\b', 'abicio'),
    (r'\babicitis\b', 'abicio'),
    (r'\babicito\b', 'abicio'),
    (r'\babicitur\b', 'abicio'),
    (r'\babiciundast\b', 'abicio'),
    (r'\babiciundis\b', 'abicio'),
    (r'\babiciundus\b', 'abicio'),
    (r'\babiciunt\b', 'abicio'),
    (r'\babiciuntur\b', 'abicio'),
    (r'\babieceram\b', 'abicio'),
    (r'\babiecerant\b', 'abicio'),
    (r'\babiecerat\b', 'abicio'),
    (r'\babiecere\b', 'abicio'),
    (r'\babiecerim\b', 'abicio'),
    (r'\babiecerint\b', 'abicio'),
    (r'\babieceris\b', 'abicio'),
    (r'\babiecerit\b', 'abicio'),
    (r'\babiecero\b', 'abicio'),
    (r'\babiecerunt\b', 'abicio'),
    (r'\babieceruntque\b', 'abicio'),
    (r'\babieci\b', 'abicio'),
    (r'\babiecimus\b', 'abicio'),
    (r'\babiecisse\b', 'abicio'),
    (r'\babiecissem\b', 'abicio'),
    (r'\babiecissent\b', 'abicio'),
    (r'\babiecisset\b', 'abicio'),
    (r'\babiecisti\b', 'abicio'),
    (r'\babiecistis\b', 'abicio'),
    (r'\babiecit\b', 'abicio'),
    (r'\babiecitque\b', 'abicio'),
    (r'\babiecta\b', 'abicio'),
    (r'\babiectae\b', 'abicio'),
    (r'\babiectaeque\b', 'abicio'),
    (r'\babiectam\b', 'abicio'),
    (r'\babiectaque\b', 'abicio'),
    (r'\babiectas\b', 'abicio'),
    (r'\babiecte\b', 'abicio'),
    (r'\babiecti\b', 'abicio'),
    (r'\babiectio\b', 'abjectio'),
    (r'\babiectione\b', 'abjectio'),
    (r'\babiectionem\b', 'abjectio'),
    (r'\babiectior\b', 'abicio'),
    (r'\babiectiore\b', 'abicio'),
    (r'\babiectiorem\b', 'abicio'),
    (r'\babiectiores\b', 'abicio'),
    (r'\babiectis\b', 'abicio'),
    (r'\babiectisque\b', 'abicio'),
    (r'\babiectissimi\b', 'abicio'),
    (r'\babiectissimum\b', 'abicio'),
    (r'\babiectissimus\b', 'abicio'),
    (r'\babiectius\b', 'abicio'),
    (r'\babiecto\b', 'abicio'),
    (r'\babiectoque\b', 'abicio'),
    (r'\babiectos\b', 'abicio'),
    (r'\babiectosque\b', 'abicio'),
    (r'\babiectum\b', 'abicio'),
    (r'\babiectumque\b', 'abicio'),
    (r'\babiecturum\b', 'abicio'),
    (r'\babiectus\b', 'abicio'),
    (r'\babiegna\b', 'abiegnus'),
    (r'\babiegnae\b', 'abiegnus'),
    (r'\babiegnas\b', 'abiegnus'),
    (r'\babiegnast\b', 'abiegnus'),
    (r'\babiegni\b', 'abiegnus'),
    (r'\babiegnis\b', 'abiegnus'),
    (r'\babiegno\b', 'abiegnus'),
    (r'\babiendi\b', 'abeo'),
    (r'\babiens\b', 'abeo'),
    (r'\babieram\b', 'abeo'),
    (r'\babierant\b', 'abeo'),
    (r'\babierat\b', 'abeo'),
    (r'\babiere\b', 'abeo'),
    (r'\babierim\b', 'abeo'),
    (r'\babierint\b', 'abeo'),
    (r'\babieris\b', 'abeo'),
    (r'\babierit\b', 'abeo'),
    (r'\babieritis\b', 'abeo'),
    (r'\babiero\b', 'abeo'),
    (r'\babierunt\b', 'abeo'),
    (r'\babieruntque\b', 'abeo'),
    (r'\babies\b', 'abies'),
    (r'\babietarii\b', 'abietarius'),
    (r'\babiete\b', 'abies'),
    (r'\babietem\b', 'abies'),
    (r'\babietes\b', 'abies'),
    (r'\babieti\b', 'abies'),
    (r'\babietibus\b', 'abies'),
    (r'\babietis\b', 'abies'),
    (r'\babiga\b', 'abiga'),
    (r'\babigam\b', 'abiga'),
    (r'\babigam\b', 'abigo'),
    (r'\babigant\b', 'abigo'),
    (r'\babigantur\b', 'abigo'),
    (r'\babigas\b', 'abiga'),
    (r'\babigas\b', 'abigo'),
    (r'\babigat\b', 'abigo'),
    (r'\babigatque\b', 'abigo'),
    (r'\babige\b', 'abigo'),
    (r'\babigeatus\b', 'abigeatus'),
    (r'\babigebat\b', 'abigo'),
    (r'\babigei\b', 'abigeus'),
    (r'\babigeis\b', 'abigeus'),
    (r'\babigende\b', 'abigo'),
    (r'\babigendi\b', 'abigo'),
    (r'\babigendis\b', 'abigo'),
    (r'\babigendo\b', 'abigo'),
    (r'\babigendos\b', 'abigo'),
    (r'\babigens\b', 'abigo'),
    (r'\babigente\b', 'abigo'),
    (r'\babigentem\b', 'abigo'),
    (r'\babigentes\b', 'abigo'),
    (r'\babigenti\b', 'abigo'),
    (r'\babigeo\b', 'abigeus'),
    (r'\babigeorum\b', 'abigeus'),
    (r'\babigere\b', 'abigo'),
    (r'\babigerent\b', 'abigo'),
    (r'\babigeres\b', 'abigo'),
    (r'\babigeret\b', 'abigo'),
    (r'\babigeris\b', 'abigo'),
    (r'\babiget\b', 'abigo'),
    (r'\babigeum\b', 'abigeus'),
    (r'\babigeus\b', 'abigeus'),
    (r'\babigi\b', 'abigo'),
    (r'\babigis\b', 'abiga'),
    (r'\babigis\b', 'abigo'),
    (r'\babigit\b', 'abigo'),
    (r'\babigitque\b', 'abigo'),
    (r'\babigo\b', 'abigo'),
    (r'\babigoque\b', 'abigo'),
    (r'\babigor\b', 'abigo'),
    (r'\babigunt\b', 'abigo'),
    (r'\babiguntque\b', 'abigo'),
    (r'\babiguntur\b', 'abigo'),
    (r'\babii\b', 'abeo'),
    (r'\babiimus\b', 'abeo'),
    (r'\babiisse\b', 'abeo'),
    (r'\babiisses\b', 'abeo'),
    (r'\babiisti\b', 'abeo'),
    (r'\babiit\b', 'abeo'),
    (r'\babiitque\b', 'abeo'),
    (r'\babimus\b', 'abeo'),
    (r'\bAbin\b', 'Aba'),
    (r'\babin\b', 'abeo'),
    (r'\bAbiorum\b', 'Abii'),
    (r'\babire\b', 'abeo'),
    (r'\babirem\b', 'abeo'),
    (r'\babirent\b', 'abeo'),
    (r'\babires\b', 'abeo'),
    (r'\babiret\b', 'abeo'),
    (r'\babiretis\b', 'abeo'),
    (r'\babiretur\b', 'abeo'),
    (r'\babiri\b', 'abeo'),
    (r'\bAbis\b', 'Aba'),
    (r'\babis\b', 'abeo'),
    (r'\babisse\b', 'abeo'),
    (r'\babissem\b', 'abeo'),
    (r'\babissent\b', 'abeo'),
    (r'\babisset\b', 'abeo'),
    (r'\babissetis\b', 'abeo'),
    (r'\babisti\b', 'abeo'),
    (r'\babistis\b', 'abeo'),
    (r'\bAbisue\b', 'Aba'),
    (r'\babisue\b', 'abeo'),
    (r'\babit\b', 'abeo'),
    (r'\babitas\b', 'abeo'),
    (r'\babitas\b', 'abito'),
    (r'\babitat\b', 'abito'),
    (r'\babite\b', 'abeo'),
    (r'\babitio\b', 'abitio'),
    (r'\babitis\b', 'abeo'),
    (r'\babitis\b', 'abito'),
    (r'\babito\b', 'abeo'),
    (r'\babito\b', 'abito'),
    (r'\babitu\b', 'abitus'),
    (r'\babitu\b', 'abeo'),
    (r'\babitum\b', 'abitus'),
    (r'\babitum\b', 'abeo'),
    (r'\babitumque\b', 'abitus'),
    (r'\babitumque\b', 'abeo'),
    (r'\babituque\b', 'abitus'),
    (r'\babituque\b', 'abeo'),
    (r'\babitur\b', 'abeo'),
    (r'\babitura\b', 'abeo'),
    (r'\babiturae\b', 'abeo'),
    (r'\babituram\b', 'abeo'),
    (r'\babituras\b', 'abeo'),
    (r'\babituri\b', 'abeo'),
    (r'\babituris\b', 'abeo'),
    (r'\babituros\b', 'abeo'),
    (r'\babiturum\b', 'abeo'),
    (r'\babiturun\b', 'abeo'),
    (r'\babiturus\b', 'abeo'),
    (r'\babitus\b', 'abitus'),
    (r'\babitus\b', 'abeo'),
    (r'\babitusque\b', 'abitus'),
    (r'\babitusque\b', 'abeo'),
    (r'\babiudicabit\b', 'abjudico'),
    (r'\babiudicabo\b', 'abjudico'),
    (r'\babiudicaretur\b', 'abjudico'),
    (r'\babiudicari\b', 'abjudico'),
    (r'\babiudicata\b', 'abjudico'),
    (r'\babiudicati\b', 'abjudico'),
    (r'\babiudicatis\b', 'abjudico'),
    (r'\babiudicatur\b', 'abjudico'),
    (r'\babiudicavisse\b', 'abjudico'),
    (r'\babiudicetur\b', 'abjudico'),
    (r'\babiudico\b', 'abjudico'),
    (r'\babiugat\b', 'abjugo'),
    (r'\babiunctae\b', 'abjungo'),
    (r'\babiuncto\b', 'abjungo'),
    (r'\babiunctos\b', 'abjungo'),
    (r'\babiunctus\b', 'abjungo'),
    (r'\babiungas\b', 'abjungo'),
    (r'\babiungens\b', 'abjungo'),
    (r'\babiungere\b', 'abjungo'),
    (r'\babiunget\b', 'abjungo'),
    (r'\babiunxerat\b', 'abjungo'),
    (r'\babiurans\b', 'abjuro'),
    (r'\babiurant\b', 'abjuro'),
    (r'\babiurare\b', 'abjuro'),
    (r'\babiurasse\b', 'abjuro'),
    (r'\babiurataeque\b', 'abjuro'),
    (r'\babiuratas\b', 'abjuro'),
    (r'\babiuraverat\b', 'abjuro'),
    (r'\babiurgata\b', 'abjurgo'),
    (r'\babivimus\b', 'abeo'),
    (r'\bablactata\b', 'ablacto'),
    (r'\bablactationis\b', 'ablactatio'),
    (r'\bablactatos\b', 'ablacto'),
    (r'\bablactatum\b', 'ablacto'),
    (r'\bablactatus\b', 'ablacto'),
    (r'\bablactaverat\b', 'ablacto'),
    (r'\bablactavit\b', 'ablacto'),
    (r'\bablactes\b', 'ablacto'),
    (r'\bablactetur\b', 'ablacto'),
    (r'\bablaqueatio\b', 'ablaqueatio'),
    (r'\bablaqueatione\b', 'ablaqueatio'),
    (r'\bablaqueationem\b', 'ablaqueatio'),
    (r'\bablaqueationibus\b', 'ablaqueatio'),
    (r'\bablaqueationis\b', 'ablaqueatio'),
    (r'\bablata\b', 'aufero'),
    (r'\bablatae\b', 'aufero'),
    (r'\bablatam\b', 'aufero'),
    (r'\bablataque\b', 'aufero'),
    (r'\bablatarum\b', 'aufero'),
    (r'\bablatas\b', 'aufero'),
    (r'\bablate\b', 'aufero'),
    (r'\bablati\b', 'aufero'),
    (r'\bablati\b', 'ablatio'),
    (r'\bablatis\b', 'aufero'),
    (r'\bablatis\b', 'ablatio'),
    (r'\bablatisque\b', 'aufero'),
    (r'\bablatisque\b', 'ablatio'),
    (r'\bablatiui\b', 'ablativus'),
    (r'\bablatiui\b', 'ablatio'),
    (r'\bablatiuo\b', 'ablativus'),
    (r'\bablatiuum\b', 'ablativus'),
    (r'\bablatiuus\b', 'ablativus'),
    (r'\bablativi\b', 'ablativus'),
    (r'\bablativi\b', 'ablatio'),
    (r'\bablativis\b', 'ablativus'),
    (r'\bablativo\b', 'ablativus'),
    (r'\bablativos\b', 'ablativus'),
    (r'\bablativum\b', 'ablativus'),
    (r'\bablativumque\b', 'ablativus'),
    (r'\bablativus\b', 'ablativus'),
    (r'\bablato\b', 'aufero'),
    (r'\bablatos\b', 'aufero'),
    (r'\bablatosque\b', 'aufero'),
    (r'\bablatum\b', 'aufero'),
    (r'\bablatumque\b', 'aufero'),
    (r'\bablatura\b', 'aufero'),
    (r'\bablaturos\b', 'aufero'),
    (r'\bablaturum\b', 'aufero'),
    (r'\bablaturus\b', 'aufero'),
    (r'\bablaturusque\b', 'aufero'),
    (r'\bablatus\b', 'aufero'),
    (r'\bablatusque\b', 'aufero'),
    (r'\bablega\b', 'ablego'),
    (r'\bablegabuntur\b', 'ablego'),
    (r'\bablegandae\b', 'ablego'),
    (r'\bablegandos\b', 'ablego'),
    (r'\bablegandum\b', 'ablego'),
    (r'\bablegant\b', 'ablego'),
    (r'\bablegantque\b', 'ablego'),
    (r'\bablegarat\b', 'ablego'),
    (r'\bablegare\b', 'ablego'),
    (r'\bablegarent\b', 'ablego'),
    (r'\bablegarentur\b', 'ablego'),
    (r'\bablegaret\b', 'ablego'),
    (r'\bablegaretur\b', 'ablego'),
    (r'\bablegari\b', 'ablego'),
    (r'\bablegasse\b', 'ablego'),
    (r'\bablegat\b', 'ablego'),
    (r'\bablegatam\b', 'ablego'),
    (r'\bablegati\b', 'ablego'),
    (r'\bablegatio\b', 'ablegatio'),
    (r'\bablegatione\b', 'ablegatio'),
    (r'\bablegatis\b', 'ablego'),
    (r'\bablegato\b', 'ablego'),
    (r'\bablegatos\b', 'ablego'),
    (r'\bablegatum\b', 'ablego'),
    (r'\bablegatus\b', 'ablego'),
    (r'\bablegauit\b', 'ablego'),
    (r'\bablegavi\b', 'ablego'),
    (r'\bablegavit\b', 'ablego'),
    (r'\bableget\b', 'ablego'),
    (r'\bablegetur\b', 'ablego'),
    (r'\bablepsiam\b', 'ablepsia'),
    (r'\babligurias\b', 'abligurrio'),
    (r'\babligurire\b', 'abligurrio'),
    (r'\babligurribam\b', 'abligurrio'),
    (r'\babligurritione\b', 'abligurritio'),
    (r'\babligurriuit\b', 'abligurrio'),
    (r'\bablocaret\b', 'abloco'),
    (r'\bablocata\b', 'abloco'),
    (r'\babluam\b', 'abluo'),
    (r'\babluant\b', 'abluo'),
    (r'\babluantur\b', 'abluo'),
    (r'\babluas\b', 'abluo'),
    (r'\babluatur\b', 'abluo'),
    (r'\babludit\b', 'abludo'),
    (r'\bablue\b', 'abluo'),
    (r'\babluebant\b', 'abluo'),
    (r'\babluebantur\b', 'abluo'),
    (r'\babluebat\b', 'abluo'),
    (r'\babluenda\b', 'abluo'),
    (r'\babluendarum\b', 'abluo'),
    (r'\babluendi\b', 'abluo'),
    (r'\babluendis\b', 'abluo'),
    (r'\babluendo\b', 'abluo'),
    (r'\babluendum\b', 'abluo'),
    (r'\babluens\b', 'abluo'),
    (r'\babluentem\b', 'abluo'),
    (r'\babluentes\b', 'abluo'),
    (r'\babluentis\b', 'abluo'),
    (r'\babluentium\b', 'abluo'),
    (r'\babluerat\b', 'abluo'),
    (r'\babluere\b', 'abluo'),
    (r'\bablueret\b', 'abluo'),
    (r'\babluerit\b', 'abluo'),
    (r'\babluero\b', 'abluo'),
    (r'\babluet\b', 'abluo'),
    (r'\bablui\b', 'abluo'),
    (r'\babluisset\b', 'abluo'),
    (r'\babluit\b', 'abluo'),
    (r'\babluitur\b', 'abluo'),
    (r'\babluiturque\b', 'abluo'),
    (r'\babluta\b', 'abluo'),
    (r'\babluta\b', 'ablutor'),
    (r'\bablutas\b', 'abluo'),
    (r'\bablutas\b', 'ablutor'),
    (r'\babluti\b', 'abluo'),
    (r'\bablutionem\b', 'ablutio'),
    (r'\babluto\b', 'abluo'),
    (r'\babluto\b', 'ablutor'),
    (r'\bablutum\b', 'abluo'),
    (r'\bablutus\b', 'abluo'),
    (r'\babluuium\b', 'abluvium'),
    (r'\babluunt\b', 'abluo'),
    (r'\babluuntur\b', 'abluo'),
    (r'\babluvium\b', 'abluvium'),
    (r'\babmatertera\b', 'abmatertera'),
    (r'\babmaterteras\b', 'abmatertera'),
    (r'\babnatat\b', 'abnato'),
    (r'\babnegantes\b', 'abnego'),
    (r'\babnegare\b', 'abnego'),
    (r'\babnegarent\b', 'abnego'),
    (r'\babnegat\b', 'abnego'),
    (r'\babnegatam\b', 'abnego'),
    (r'\babnegaverunt\b', 'abnego'),
    (r'\babnegavit\b', 'abnego'),
    (r'\babneges\b', 'abnego'),
    (r'\babneget\b', 'abnego'),
    (r'\babnego\b', 'abnego'),
    (r'\babnepos\b', 'abnepos'),
    (r'\babnepote\b', 'abnepos'),
    (r'\babnepotem\b', 'abnepos'),
    (r'\babnepotibusque\b', 'abnepos'),
    (r'\babnepotis\b', 'abnepos'),
    (r'\babneptem\b', 'abneptis'),
    (r'\babneptis\b', 'abneptis'),
    (r'\babneptisue\b', 'abneptis'),
    (r'\babner\b', 'ab-no1'),
    (r'\bAbnobae\b', 'ab-no1'),
    (r'\babnoctandi\b', 'abnocto'),
    (r'\babnoctantem\b', 'abnocto'),
    (r'\babnoctare\b', 'abnocto'),
    (r'\babnodare\b', 'abnodo'),
    (r'\babnormis\b', 'abnormis'),
    (r'\babnuam\b', 'abnuo'),
    (r'\babnuant\b', 'abnuo'),
    (r'\babnuat\b', 'abnuo'),
    (r'\babnuebam\b', 'abnuo'),
    (r'\babnuebant\b', 'abnuo'),
    (r'\babnuebat\b', 'abnuo'),
    (r'\babnuendamque\b', 'abnuo'),
    (r'\babnuendamue\b', 'abnuo'),
    (r'\babnuendi\b', 'abnuo'),
    (r'\babnuendo\b', 'abnuo'),
    (r'\babnuendum\b', 'abnuo'),
    (r'\babnuens\b', 'abnuo'),
    (r'\babnuente\b', 'abnuo'),
    (r'\babnuentem\b', 'abnuo'),
    (r'\babnuentes\b', 'abnuo'),
    (r'\babnuentesque\b', 'abnuo'),
    (r'\babnuenti\b', 'abnuo'),
    (r'\babnuentibus\b', 'abnuo'),
    (r'\babnuentique\b', 'abnuo'),
    (r'\babnuentis\b', 'abnuo'),
    (r'\babnueram\b', 'abnuo'),
    (r'\babnuerant\b', 'abnuo'),
    (r'\babnuerat\b', 'abnuo'),
    (r'\babnueratque\b', 'abnuo'),
    (r'\babnuere\b', 'abnuo'),
    (r'\babnuerent\b', 'abnuo'),
    (r'\babnueres\b', 'abnuo'),
    (r'\babnueret\b', 'abnuo'),
    (r'\babnuerim\b', 'abnuo'),
    (r'\babnuerint\b', 'abnuo'),
    (r'\babnuerit\b', 'abnuo'),
    (r'\babnuerunt\b', 'abnuo'),
    (r'\babnues\b', 'abnuo'),
    (r'\babnuesque\b', 'abnuo'),
    (r'\babnuet\b', 'abnuo'),
    (r'\babnui\b', 'abnuo'),
    (r'\babnuimus\b', 'abnuo'),
    (r'\babnuis\b', 'abnuo'),
    (r'\babnuisse\b', 'abnuo'),
    (r'\babnuissent\b', 'abnuo'),
    (r'\babnuisset\b', 'abnuo'),
    (r'\babnuistis\b', 'abnuo'),
    (r'\babnuit\b', 'abnuo'),
    (r'\babnuitis\b', 'abnuo'),
    (r'\babnuitur\b', 'abnuo'),
    (r'\babnumero\b', 'abnumero'),
    (r'\babnuo\b', 'abnuo'),
    (r'\babnuont\b', 'abnuo'),
    (r'\babnutas\b', 'abnuto'),
    (r'\babnutiuum\b', 'abnutivus'),
    (r'\babnutiuum\b', 'abnutivus'),
    (r'\babnutiva\b', 'abnutivus'),
    (r'\babnutiva\b', 'abnutivus'),
    (r'\babnuto\b', 'abnuto'),
    (r'\babnuunt\b', 'abnuo'),
    (r'\baboleatur\b', 'aboleo'),
    (r'\babolebantur\b', 'aboleo'),
    (r'\babolebis\b', 'aboleo'),
    (r'\babolebit\b', 'aboleo'),
    (r'\babolebitur\b', 'aboleo'),
    (r'\babolenda\b', 'aboleo'),
    (r'\babolendae\b', 'aboleo'),
    (r'\babolendam\b', 'aboleo'),
    (r'\babolendamque\b', 'aboleo'),
    (r'\babolendi\b', 'aboleo'),
    (r'\babolendis\b', 'aboleo'),
    (r'\babolendo\b', 'aboleo'),
    (r'\babolendum\b', 'aboleo'),
    (r'\babolendumque\b', 'aboleo'),
    (r'\babolent\b', 'aboleo'),
    (r'\babolere\b', 'aboleo'),
    (r'\babolerent\b', 'aboleo'),
    (r'\babolerentur\b', 'aboleo'),
    (r'\baboleret\b', 'aboleo'),
    (r'\baboleretur\b', 'aboleo'),
    (r'\baboleri\b', 'aboleo'),
    (r'\baboleriue\b', 'aboleo'),
    (r'\babolescere\b', 'ab-olesco'),
    (r'\babolescet\b', 'ab-olesco'),
    (r'\babolet\b', 'aboleo'),
    (r'\babolete\b', 'aboleo'),
    (r'\baboletque\b', 'aboleo'),
    (r'\baboletur\b', 'aboleo'),
    (r'\babolitio\b', 'abolitio'),
    (r'\babolitione\b', 'abolitio'),
    (r'\babolitionem\b', 'abolitio'),
    (r'\babolitiones\b', 'abolitio'),
    (r'\babolitionibus\b', 'abolitio'),
    (r'\babolitionis\b', 'abolitio'),
    (r'\babolla\b', 'abolla'),
    (r'\babollae\b', 'abolla'),
    (r'\babollam\b', 'abolla'),
    (r'\babominaberis\b', 'abominor'),
    (r'\babominabile\b', 'abominabilis'),
    (r'\babominabilem\b', 'abominabilis'),
    (r'\babominabiles\b', 'abominabilis'),
    (r'\babominabilis\b', 'abominabilis'),
    (r'\babominabitur\b', 'abominor'),
    (r'\babominabuntur\b', 'abominor'),
    (r'\babominamini\b', 'abominor'),
    (r'\babominamur\b', 'abominor'),
    (r'\babominanda\b', 'abominor'),
    (r'\babominandae\b', 'abominor'),
    (r'\babominandam\b', 'abominor'),
    (r'\babominandi\b', 'abominor'),
    (r'\babominando\b', 'abominor'),
    (r'\babominandoque\b', 'abominor'),
    (r'\babominandum\b', 'abominor'),
    (r'\babominandus\b', 'abominor'),
    (r'\babominantes\b', 'abominor'),
    (r'\babominantibus\b', 'abominor'),
    (r'\babominantur\b', 'abominor'),
    (r'\babominaremur\b', 'abominor'),
    (r'\babominari\b', 'abominor'),
    (r'\babominaris\b', 'abominor'),
    (r'\babominata\b', 'abominor'),
    (r'\babominatae\b', 'abominor'),
    (r'\babominatam\b', 'abominor'),
    (r'\babominati\b', 'abominor'),
    (r'\babominatio\b', 'abominatio'),
    (r'\babominationem\b', 'abominatio'),
    (r'\babominationes\b', 'abominatio'),
    (r'\babominationesque\b', 'abominatio'),
    (r'\babominationi\b', 'abominatio'),
    (r'\babominationibus\b', 'abominatio'),
    (r'\babominationis\b', 'abominatio'),
    (r'\babominationum\b', 'abominatio'),
    (r'\babominatos\b', 'abominor'),
    (r'\babominatum\b', 'abominor'),
    (r'\babominatur\b', 'abominor'),
    (r'\babominatus\b', 'abominor'),
    (r'\babominentur\b', 'abominor'),
    (r'\babominer\b', 'abominor'),
    (r'\babominetur\b', 'abominor'),
    (r'\babominor\b', 'abominor'),
    (r'\baboriantur\b', 'aborior'),
    (r'\baboriatur\b', 'aborior'),
    (r'\baboriendi\b', 'aborior'),
    (r'\baborigineo\b', 'aborior'),
    (r'\bAborigines\b', 'Aborigines'),
    (r'\bAboriginesque\b', 'Aborigines'),
    (r'\bAboriginibus\b', 'Aborigines'),
    (r'\bAboriginum\b', 'Aborigines'),
    (r'\bAboriginumque\b', 'Aborigines'),
    (r'\baboriri\b', 'aborior'),
    (r'\baboriuntur\b', 'aborior'),
    (r'\babortae\b', 'aborior'),
    (r'\babortet\b', 'aborto'),
    (r'\babortio\b', 'abortio1'),
    (r'\babortio\b', 'abortium'),
    (r'\babortio\b', 'abortio2'),
    (r'\babortione\b', 'abortio1'),
    (r'\babortioni\b', 'abortio1'),
    (r'\babortionis\b', 'abortio1'),
    (r'\babortit\b', 'abortio2'),
    (r'\babortiuis\b', 'abortivus'),
    (r'\babortiuis\b', 'abortivus'),
    (r'\babortiuo\b', 'abortivus'),
    (r'\babortiuo\b', 'abortivus'),
    (r'\babortiuum\b', 'abortivus'),
    (r'\babortiuum\b', 'abortivus'),
    (r'\babortiva\b', 'abortivus'),
    (r'\babortiva\b', 'abortivus'),
    (r'\babortivas\b', 'abortivus'),
    (r'\babortivo\b', 'abortivus'),
    (r'\babortivo\b', 'abortivus'),
    (r'\babortivum\b', 'abortivus'),
    (r'\babortivum\b', 'abortivus'),
    (r'\babortivus\b', 'abortivus'),
    (r'\babortu\b', 'abortus'),
    (r'\babortu\b', 'aborior'),
    (r'\babortum\b', 'abortus'),
    (r'\babortum\b', 'abortum'),
    (r'\babortum\b', 'aborior'),
    (r'\babortus\b', 'abortus'),
    (r'\babortus\b', 'aborior'),
    (r'\babortusque\b', 'abortus'),
    (r'\babortusque\b', 'aborior'),
    (r'\babortuum\b', 'abortus'),
    (r'\babortuve\b', 'abortus'),
    (r'\babortuve\b', 'aborior'),
    (r'\babpatruos\b', 'abpatruus'),
    (r'\babpatruus\b', 'abpatruus'),
    (r'\babradens\b', 'abrado'),
    (r'\babradere\b', 'abrado'),
    (r'\babradi\b', 'abrado'),
    (r'\babradit\b', 'abrado'),
    (r'\babradito\b', 'abrado'),
    (r'\babraditur\b', 'abrado'),
    (r'\babraduntur\b', 'abrado'),
    (r'\babrasa\b', 'abrado'),
    (r'\babrasas\b', 'abrado'),
    (r'\babrasit\b', 'abrado'),
    (r'\babrasitque\b', 'abrado'),
    (r'\babrasum\b', 'abrado'),
    (r'\babre\b', 'ab-reor'),
    (r'\babrepta\b', 'arrepo'),
    (r'\babreptae\b', 'arrepo'),
    (r'\babreptam\b', 'arrepo'),
    (r'\babreptamque\b', 'arrepo'),
    (r'\babreptaque\b', 'arrepo'),
    (r'\babreptas\b', 'arrepo'),
    (r'\babrepti\b', 'arrepo'),
    (r'\babreptique\b', 'arrepo'),
    (r'\babreptis\b', 'arrepo'),
    (r'\babrepto\b', 'arrepo'),
    (r'\babreptos\b', 'arrepo'),
    (r'\babreptum\b', 'arrepo'),
    (r'\babreptus\b', 'arrepo'),
    (r'\babripere\b', 'abripio'),
    (r'\babriperent\b', 'abripio'),
    (r'\babriperet\b', 'abripio'),
    (r'\babriperetur\b', 'abripio'),
    (r'\babripi\b', 'abripio'),
    (r'\babripiam\b', 'abripio'),
    (r'\babripiant\b', 'abripio'),
    (r'\babripiat\b', 'abripio'),
    (r'\babripiebantur\b', 'abripio'),
    (r'\babripiebat\b', 'abripio'),
    (r'\babripiendo\b', 'abripio'),
    (r'\babripiens\b', 'abripio'),
    (r'\babripiere\b', 'abripio'),
    (r'\babripiet\b', 'abripio'),
    (r'\babripimur\b', 'abripio'),
    (r'\babripis\b', 'abripio'),
    (r'\babripit\b', 'abripio'),
    (r'\babripite\b', 'abripio'),
    (r'\babripitur\b', 'abripio'),
    (r'\babripiunt\b', 'abripio'),
    (r'\babripiuntur\b', 'abripio'),
    (r'\babripuerat\b', 'abripio'),
    (r'\babripuerunt\b', 'abripio'),
    (r'\babripui\b', 'abripio'),
    (r'\babripuisse\b', 'abripio'),
    (r'\babripuisset\b', 'abripio'),
    (r'\babripuit\b', 'abripio'),
    (r'\babrodere\b', 'abrodo'),
    (r'\babrodit\b', 'abrodo'),
    (r'\babrogabat\b', 'abrogo'),
    (r'\babrogabatur\b', 'abrogo'),
    (r'\babrogamus\b', 'abrogo'),
    (r'\babroganda\b', 'abrogo'),
    (r'\babrogandam\b', 'abrogo'),
    (r'\babrogandas\b', 'abrogo'),
    (r'\babrogandi\b', 'abrogo'),
    (r'\babrogandis\b', 'abrogo'),
    (r'\babrogando\b', 'abrogo'),
    (r'\babrogant\b', 'abrogo'),
    (r'\babrogantem\b', 'abrogo'),
    (r'\babrogare\b', 'abrogo'),
    (r'\babrogarem\b', 'abrogo'),
    (r'\babrogarent\b', 'abrogo'),
    (r'\babrogarentur\b', 'abrogo'),
    (r'\babrogarenturue\b', 'abrogo'),
    (r'\babrogaret\b', 'abrogo'),
    (r'\babrogaretis\b', 'abrogo'),
    (r'\babrogaretur\b', 'abrogo'),
    (r'\babrogari\b', 'abrogo'),
    (r'\babrogaritis\b', 'abrogo'),
    (r'\babrogasset\b', 'abrogo'),
    (r'\babrogastis\b', 'abrogo'),
    (r'\babrogat\b', 'abrogo'),
    (r'\babrogata\b', 'abrogo'),
    (r'\babrogatae\b', 'abrogo'),
    (r'\babrogatam\b', 'abrogo'),
    (r'\babrogatas\b', 'abrogo'),
    (r'\babrogati\b', 'abrogo'),
    (r'\babrogatione\b', 'abrogatio'),
    (r'\babrogationi\b', 'abrogatio'),
    (r'\babrogationis\b', 'abrogatio'),
    (r'\babrogatis\b', 'abrogo'),
    (r'\babrogato\b', 'abrogo'),
    (r'\babrogatum\b', 'abrogo'),
    (r'\babrogatur\b', 'abrogo'),
    (r'\babrogatus\b', 'abrogo'),
    (r'\babrogauerat\b', 'abrogo'),
    (r'\babrogauerim\b', 'abrogo'),
    (r'\babrogauerit\b', 'abrogo'),
    (r'\babrogauit\b', 'abrogo'),
    (r'\babrogavere\b', 'abrogo'),
    (r'\babrogaverit\b', 'abrogo'),
    (r'\babrogavit\b', 'abrogo'),
    (r'\babrogemus\b', 'abrogo'),
    (r'\babrogent\b', 'abrogo'),
    (r'\babrogentur\b', 'abrogo'),
    (r'\babroges\b', 'abrogo'),
    (r'\babroget\b', 'abrogo'),
    (r'\babrogetis\b', 'abrogo'),
    (r'\babrogetur\b', 'abrogo'),
    (r'\babrogoque\b', 'abrogo'),
    (r'\babrosa\b', 'abrodo'),
    (r'\babroso\b', 'abrodo'),
    (r'\babrotoni\b', 'abrumpo'),
    (r'\babrotoni\b', 'abrotonum'),
    (r'\babrotoniten\b', 'abrotonites'),
    (r'\babrotonum\b', 'abrumpo'),
    (r'\babrotonum\b', 'abrotonum'),
    (r'\babrumpam\b', 'abrumpo'),
    (r'\babrumpant\b', 'abrumpo'),
    (r'\babrumpantur\b', 'abrumpo'),
    (r'\babrumpas\b', 'abrumpo'),
    (r'\babrumpat\b', 'abrumpo'),
    (r'\babrumpatur\b', 'abrumpo'),
    (r'\babrumpe\b', 'abrumpo'),
    (r'\babrumpendae\b', 'abrumpo'),
    (r'\babrumpendas\b', 'abrumpo'),
    (r'\babrumpendos\b', 'abrumpo'),
    (r'\babrumpens\b', 'abrumpo'),
    (r'\babrumpentes\b', 'abrumpo'),
    (r'\babrumpentium\b', 'abrumpo'),
    (r'\babrumpere\b', 'abrumpo'),
    (r'\babrumperent\b', 'abrumpo'),
    (r'\babrumperet\b', 'abrumpo'),
    (r'\babrumperetur\b', 'abrumpo'),
    (r'\babrumpes\b', 'abrumpo'),
    (r'\babrumpet\b', 'abrumpo'),
    (r'\babrumpetque\b', 'abrumpo'),
    (r'\babrumpi\b', 'abrumpo'),
    (r'\babrumpimus\b', 'abrumpo'),
    (r'\babrumpit\b', 'abrumpo'),
    (r'\babrumpitur\b', 'abrumpo'),
    (r'\babrumpo\b', 'abrumpo'),
    (r'\babrumpunt\b', 'abrumpo'),
    (r'\babrumpuntur\b', 'abrumpo'),
    (r'\babruperam\b', 'abrumpo'),
    (r'\babruperant\b', 'abrumpo'),
    (r'\babruperat\b', 'abrumpo'),
    (r'\babrupere\b', 'abrumpo'),
    (r'\babruperit\b', 'abrumpo'),
    (r'\babrupimus\b', 'abrumpo'),
    (r'\babrupisse\b', 'abrumpo'),
    (r'\babrupissent\b', 'abrumpo'),
    (r'\babrupit\b', 'abrumpo'),
    (r'\babrupta\b', 'abruptum'),
    (r'\babrupta\b', 'abrumpo'),
    (r'\babruptae\b', 'abrumpo'),
    (r'\babruptam\b', 'abrumpo'),
    (r'\babruptaque\b', 'abruptum'),
    (r'\babruptaque\b', 'abrumpo'),
    (r'\babruptas\b', 'abrumpo'),
    (r'\babrupte\b', 'abruptum'),
    (r'\babrupte\b', 'abrumpo'),
    (r'\babrupti\b', 'abruptum'),
    (r'\babrupti\b', 'abrumpo'),
    (r'\babruptio\b', 'abruptio'),
    (r'\babruptionem\b', 'abruptio'),
    (r'\babruptiora\b', 'abrumpo'),
    (r'\babruptis\b', 'abruptum'),
    (r'\babruptis\b', 'abrumpo'),
    (r'\babruptisque\b', 'abruptum'),
    (r'\babruptisque\b', 'abrumpo'),
    (r'\babruptissimas\b', 'abrumpo'),
    (r'\babruptissimis\b', 'abrumpo'),
    (r'\babruptiusque\b', 'abrumpo'),
    (r'\babrupto\b', 'abruptum'),
    (r'\babrupto\b', 'abrumpo'),
    (r'\babruptos\b', 'abrumpo'),
    (r'\babruptum\b', 'abruptum'),
    (r'\babruptum\b', 'abrumpo'),
    (r'\babruptumque\b', 'abruptum'),
    (r'\babruptumque\b', 'abrumpo'),
    (r'\babruptus\b', 'abrumpo'),
    (r'\babs\b', 'ab'),
    (r'\babscedam\b', 'abscedo'),
    (r'\babscedant\b', 'abscedo'),
    (r'\babscedat\b', 'abscedo'),
    (r'\babscede\b', 'abscedo'),
    (r'\babscedebat\b', 'abscedo'),
    (r'\babscedebatur\b', 'abscedo'),
    (r'\babscedendumque\b', 'abscedo'),
    (r'\babscedens\b', 'abscedo'),
    (r'\babscedent\b', 'abscedo'),
    (r'\babscedente\b', 'abscedo'),
    (r'\babscedentem\b', 'abscedo'),
    (r'\babscedentes\b', 'abscedo'),
    (r'\babscedentia\b', 'abscedo'),
    (r'\babscedentibus\b', 'abscedo'),
    (r'\babscedentis\b', 'abscedo'),
    (r'\babscedentium\b', 'abscedo'),
    (r'\babscedere\b', 'abscedo'),
    (r'\babscederent\b', 'abscedo'),
    (r'\babscederet\b', 'abscedo'),
    (r'\babscedet\b', 'abscedo'),
    (r'\babscedi\b', 'abscedo'),
    (r'\babscedimus\b', 'abscedo'),
    (r'\babscedit\b', 'abscedo'),
    (r'\babscedite\b', 'abscedo'),
    (r'\babscedo\b', 'abscedo'),
    (r'\babscedunt\b', 'abscedo'),
    (r'\babscessem\b', 'abscessus'),
    (r'\babscesserant\b', 'abscedo'),
    (r'\babscesserat\b', 'abscedo'),
    (r'\babscessere\b', 'abscedo'),
    (r'\babscesseris\b', 'abscedo'),
    (r'\babscesserit\b', 'abscedo'),
    (r'\babscessero\b', 'abscedo'),
    (r'\babscesserunt\b', 'abscedo'),
    (r'\babscessi\b', 'abscedo'),
    (r'\babscessibus\b', 'abscessus'),
    (r'\babscessio\b', 'abscessio'),
    (r'\babscessisse\b', 'abscedo'),
    (r'\babscessissent\b', 'abscedo'),
    (r'\babscessisset\b', 'abscedo'),
    (r'\babscessit\b', 'abscedo'),
    (r'\babscessu\b', 'abscessus'),
    (r'\babscessu\b', 'abscedo'),
    (r'\babscessum\b', 'abscessus'),
    (r'\babscessum\b', 'abscedo'),
    (r'\babscessuri\b', 'abscedo'),
    (r'\babscessuros\b', 'abscedo'),
    (r'\babscessurum\b', 'abscedo'),
    (r'\babscessurus\b', 'abscedo'),
    (r'\babscessus\b', 'abscessus'),
    (r'\babscessus\b', 'abscedo'),
    (r'\babsci\b', 'ab-scio'),
    (r'\babscidam\b', 'abscido'),
    (r'\babscidamus\b', 'abscido'),
    (r'\babscidantur\b', 'abscido'),
    (r'\babscidat\b', 'abscido'),
    (r'\babscidatur\b', 'abscido'),
    (r'\babscide\b', 'abscido'),
    (r'\babscidenda\b', 'abscido'),
    (r'\babscidendae\b', 'abscido'),
    (r'\babscidendaeque\b', 'abscido'),
    (r'\babscidendam\b', 'abscido'),
    (r'\babscidendo\b', 'abscido'),
    (r'\babscidendum\b', 'abscido'),
    (r'\babscidens\b', 'abscido'),
    (r'\babscidentur\b', 'abscido'),
    (r'\babsciderat\b', 'abscido'),
    (r'\babscideratque\b', 'abscido'),
    (r'\babscidere\b', 'abscido'),
    (r'\babsciderem\b', 'abscido'),
    (r'\babsciderent\b', 'abscido'),
    (r'\babsciderentur\b', 'abscido'),
    (r'\babscideret\b', 'abscido'),
    (r'\babscideretur\b', 'abscido'),
    (r'\babscideris\b', 'abscido'),
    (r'\babsciderit\b', 'abscido'),
    (r'\babsciderunt\b', 'abscido'),
    (r'\babscides\b', 'abscido'),
    (r'\babscidet\b', 'abscido'),
    (r'\babscidetur\b', 'abscido'),
    (r'\babscidi\b', 'abscido'),
    (r'\babscidimus\b', 'abscido'),
    (r'\babscidis\b', 'abscido'),
    (r'\babscidissent\b', 'abscido'),
    (r'\babscidisset\b', 'abscido'),
    (r'\babscidit\b', 'abscido'),
    (r'\babscidite\b', 'abscido'),
    (r'\babscidito\b', 'abscido'),
    (r'\babsciditur\b', 'abscido'),
    (r'\babscidunt\b', 'abscido'),
    (r'\babsciduntur\b', 'abscido'),
    (r'\babscindas\b', 'abscindo'),
    (r'\babscindens\b', 'abscindo'),
    (r'\babscindere\b', 'abscindo'),
    (r'\babscindet\b', 'abscindo'),
    (r'\babscindi\b', 'abscindo'),
    (r'\babscindimus\b', 'abscindo'),
    (r'\babscindit\b', 'abscindo'),
    (r'\babscindunt\b', 'abscindo'),
    (r'\babscinduntur\b', 'abscindo'),
    (r'\babsciram\b', 'ab-scio'),
    (r'\babscis\b', 'ab-scio'),
    (r'\babscisa\b', 'abscido'),
    (r'\babscisae\b', 'abscido'),
    (r'\babscisam\b', 'abscido'),
    (r'\babscisaque\b', 'abscido'),
    (r'\babscisas\b', 'abscido'),
    (r'\babscise\b', 'abscido'),
    (r'\babscisi\b', 'abscido'),
    (r'\babscisior\b', 'abscido'),
    (r'\babscisis\b', 'abscido'),
    (r'\babsciso\b', 'abscido'),
    (r'\babscisos\b', 'abscido'),
    (r'\babscissa\b', 'abscindo'),
    (r'\babscissaque\b', 'abscindo'),
    (r'\babscisso\b', 'abscindo'),
    (r'\babscissos\b', 'abscindo'),
    (r'\babscissum\b', 'abscindo'),
    (r'\babscisum\b', 'abscido'),
    (r'\babscisumque\b', 'abscido'),
    (r'\babscisurum\b', 'abscido'),
    (r'\babscisus\b', 'abscido'),
    (r'\babscondam\b', 'abscondo'),
    (r'\babscondamini\b', 'abscondo'),
    (r'\babscondamus\b', 'abscondo'),
    (r'\babscondant\b', 'abscondo'),
    (r'\babscondantur\b', 'abscondo'),
    (r'\babscondar\b', 'abscondo'),
    (r'\babscondaris\b', 'abscondo'),
    (r'\babscondas\b', 'abscondo'),
    (r'\babscondat\b', 'abscondo'),
    (r'\babscondatis\b', 'abscondo'),
    (r'\babsconde\b', 'abscondo'),
    (r'\babscondebam\b', 'abscondo'),
    (r'\babscondebantur\b', 'abscondo'),
    (r'\babscondebas\b', 'abscondo'),
    (r'\babscondenda\b', 'abscondo'),
    (r'\babscondendi\b', 'abscondo'),
    (r'\babscondendis\b', 'abscondo'),
    (r'\babscondendo\b', 'abscondo'),
    (r'\babscondens\b', 'abscondo'),
    (r'\babscondent\b', 'abscondo'),
    (r'\babscondente\b', 'abscondo'),
    (r'\babscondentur\b', 'abscondo'),
    (r'\babsconderam\b', 'abscondo'),
    (r'\babsconderant\b', 'abscondo'),
    (r'\babsconderat\b', 'abscondo'),
    (r'\babscondere\b', 'abscondo'),
    (r'\babsconderem\b', 'abscondo'),
    (r'\babsconderent\b', 'abscondo'),
    (r'\babsconderes\b', 'abscondo'),
    (r'\babsconderet\b', 'abscondo'),
    (r'\babsconderetur\b', 'abscondo'),
    (r'\babsconderim\b', 'abscondo'),
    (r'\babsconderint\b', 'abscondo'),
    (r'\babsconderis\b', 'abscondo'),
    (r'\babsconderit\b', 'abscondo'),
    (r'\babsconderunt\b', 'abscondo'),
    (r'\babscondes\b', 'abscondo'),
    (r'\babscondet\b', 'abscondo'),
    (r'\babscondetis\b', 'abscondo'),
    (r'\babscondetur\b', 'abscondo'),
    (r'\babscondi\b', 'abscondo'),
    (r'\babscondidi\b', 'abscondo'),
    (r'\babscondidisti\b', 'abscondo'),
    (r'\babscondidit\b', 'abscondo'),
    (r'\babscondimus\b', 'abscondo'),
    (r'\babscondis\b', 'abscondo'),
    (r'\babscondisse\b', 'abscondo'),
    (r'\babscondissem\b', 'abscondo'),
    (r'\babscondisti\b', 'abscondo'),
    (r'\babscondit\b', 'abscondo'),
    (r'\babscondita\b', 'abs-condio'),
    (r'\babsconditae\b', 'abs-condio'),
    (r'\babsconditam\b', 'abs-condio'),
    (r'\babsconditamque\b', 'abs-condio'),
    (r'\babsconditas\b', 'abs-condio'),
    (r'\babscondite\b', 'abscondo'),
    (r'\babsconditi\b', 'abs-condio'),
    (r'\babsconditis\b', 'abscondo'),
    (r'\babscondito\b', 'abscondo'),
    (r'\babsconditorum\b', 'absconditor'),
    (r'\babsconditos\b', 'abs-condio'),
    (r'\babsconditque\b', 'abscondo'),
    (r'\babsconditum\b', 'abs-condio'),
    (r'\babsconditur\b', 'abscondo'),
    (r'\babsconditus\b', 'abs-condio'),
    (r'\babscondo\b', 'abscondo'),
    (r'\babscondunt\b', 'abscondo'),
    (r'\babsconduntur\b', 'abscondo'),
    (r'\babsdedit\b', 'absegmen'),
    (r'\babsdedit\b', 'absegmen'),
    (r'\babsegmen\b', 'absegmen'),
    (r'\babsens\b', 'absum'),
    (r'\babsensque\b', 'absum'),
    (r'\babsentato\b', 'absento'),
    (r'\babsente\b', 'absum'),
    (r'\babsentem\b', 'absum'),
    (r'\babsentem\b', 'absento'),
    (r'\babsentemque\b', 'absum'),
    (r'\babsentemque\b', 'absento'),
    (r'\babsentes\b', 'absum'),
    (r'\babsentes\b', 'absento'),
    (r'\babsentesque\b', 'absum'),
    (r'\babsentesque\b', 'absento'),
    (r'\babsenti\b', 'absum'),
    (r'\babsentia\b', 'absentia'),
    (r'\babsentiae\b', 'absentia'),
    (r'\babsentiam\b', 'absentia'),
    (r'\babsentibus\b', 'absum'),
    (r'\babsentibusque\b', 'absum'),
    (r'\babsentique\b', 'absum'),
    (r'\babsentis\b', 'absum'),
    (r'\babsentisque\b', 'absum'),
    (r'\babsentivus\b', 'absentivus'),
    (r'\babsiet\b', 'absum'),
    (r'\babsignante\b', 'ab-signo'),
    (r'\babsim\b', 'absum'),
    (r'\babsimile\b', 'absimilis'),
    (r'\babsimilem\b', 'absimilis'),
    (r'\babsimiles\b', 'absimilis'),
    (r'\babsimili\b', 'absimilis'),
    (r'\babsimilis\b', 'absimilis'),
    (r'\babsint\b', 'absum'),
    (r'\babsinthi\b', 'absinthius'),
    (r'\babsinthia\b', 'absinthium'),
    (r'\babsinthii\b', 'absinthius'),
    (r'\babsinthii\b', 'absinthium'),
    (r'\babsinthio\b', 'absinthius'),
    (r'\babsinthio\b', 'absinthium'),
    (r'\babsinthiten\b', 'absinthites'),
    (r'\babsinthites\b', 'absinthites'),
    (r'\babsinthium\b', 'absinthius'),
    (r'\babsinthium\b', 'absinthium'),
    (r'\babsinthius\b', 'absinthius'),
    (r'\babsis\b', 'absum'),
    (r'\babsistam\b', 'absisto'),
    (r'\babsistamus\b', 'absisto'),
    (r'\babsistat\b', 'absisto'),
    (r'\babsistatur\b', 'absisto'),
    (r'\babsiste\b', 'absisto'),
    (r'\babsistemus\b', 'absisto'),
    (r'\babsistendum\b', 'absisto'),
    (r'\babsistens\b', 'absisto'),
    (r'\babsistentibus\b', 'absisto'),
    (r'\babsistere\b', 'absisto'),
    (r'\babsisterent\b', 'absisto'),
    (r'\babsisteret\b', 'absisto'),
    (r'\babsisteretur\b', 'absisto'),
    (r'\babsistet\b', 'absisto'),
    (r'\babsistimus\b', 'absisto'),
    (r'\babsistis\b', 'absisto'),
    (r'\babsistit\b', 'absisto'),
    (r'\babsistite\b', 'absisto'),
    (r'\babsistunt\b', 'absisto'),
    (r'\babsit\b', 'absum'),
    (r'\babsitis\b', 'absitus'),
    (r'\babsitis\b', 'absum'),
    (r'\babsitque\b', 'absum'),
    (r'\babsitve\b', 'absum'),
    (r'\babsoluam\b', 'absolvo'),
    (r'\babsoluar\b', 'absolvo'),
    (r'\babsoluas\b', 'absolvo'),
    (r'\babsoluat\b', 'absolvo'),
    (r'\babsoluatur\b', 'absolvo'),
    (r'\babsolue\b', 'absolvo'),
    (r'\babsoluemus\b', 'absolvo'),
    (r'\babsoluenda\b', 'absolvo'),
    (r'\babsoluendi\b', 'absolvo'),
    (r'\babsoluendiue\b', 'absolvo'),
    (r'\babsoluendos\b', 'absolvo'),
    (r'\babsoluendum\b', 'absolvo'),
    (r'\babsoluendumue\b', 'absolvo'),
    (r'\babsoluendus\b', 'absolvo'),
    (r'\babsoluens\b', 'absolvo'),
    (r'\babsoluent\b', 'absolvo'),
    (r'\babsoluentes\b', 'absolvo'),
    (r'\babsoluentibus\b', 'absolvo'),
    (r'\babsoluerat\b', 'absolvo'),
    (r'\babsoluere\b', 'absolvo'),
    (r'\babsoluerem\b', 'absolvo'),
    (r'\babsoluerent\b', 'absolvo'),
    (r'\babsoluereris\b', 'absolvo'),
    (r'\babsolueres\b', 'absolvo'),
    (r'\babsolueret\b', 'absolvo'),
    (r'\babsolueretur\b', 'absolvo'),
    (r'\babsoluerint\b', 'absolvo'),
    (r'\babsolueris\b', 'absolvo'),
    (r'\babsoluerit\b', 'absolvo'),
    (r'\babsoluerunt\b', 'absolvo'),
    (r'\babsolueruntque\b', 'absolvo'),
    (r'\babsoluet\b', 'absolvo'),
    (r'\babsoluetur\b', 'absolvo'),
    (r'\babsolui\b', 'absolvo'),
    (r'\babsoluisse\b', 'absolvo'),
    (r'\babsoluisset\b', 'absolvo'),
    (r'\babsoluit\b', 'absolvo'),
    (r'\babsoluitis\b', 'absolvo'),
    (r'\babsoluito\b', 'absolvo'),
    (r'\babsoluitur\b', 'absolvo'),
    (r'\babsoluo\b', 'absolvo'),
    (r'\babsoluor\b', 'absolvo'),
    (r'\babsoluta\b', 'absolvo'),
    (r'\babsolutae\b', 'absolvo'),
    (r'\babsolutaeque\b', 'absolvo'),
    (r'\babsolutam\b', 'absolvo'),
    (r'\babsolutamque\b', 'absolvo'),
    (r'\babsolutaque\b', 'absolvo'),
    (r'\babsolutas\b', 'absolvo'),
    (r'\babsolute\b', 'absolvo'),
    (r'\babsoluti\b', 'absolvo'),
    (r'\babsolutio\b', 'absolutio'),
    (r'\babsolutione\b', 'absolutio'),
    (r'\babsolutionem\b', 'absolutio'),
    (r'\babsolutiones\b', 'absolutio'),
    (r'\babsolutioni\b', 'absolutio'),
    (r'\babsolutionibus\b', 'absolutio'),
    (r'\babsolutionis\b', 'absolutio'),
    (r'\babsolutior\b', 'absolvo'),
    (r'\babsolutiora\b', 'absolvo'),
    (r'\babsolutis\b', 'absolvo'),
    (r'\babsolutisque\b', 'absolvo'),
    (r'\babsolutissima\b', 'absolvo'),
    (r'\babsolutissime\b', 'absolvo'),
    (r'\babsolutissimi\b', 'absolvo'),
    (r'\babsolutissimum\b', 'absolvo'),
    (r'\babsolutissimus\b', 'absolvo'),
    (r'\babsolutius\b', 'absolvo'),
    (r'\babsoluto\b', 'absolvo'),
    (r'\babsolutoque\b', 'absolvo'),
    (r'\babsolutoria\b', 'absolutorius'),
    (r'\babsolutoria\b', 'absolutorius'),
    (r'\babsolutoriam\b', 'absolutorius'),
    (r'\babsolutorias\b', 'absolutorius'),
    (r'\babsolutorium\b', 'absolutorius'),
    (r'\babsolutorium\b', 'absolutorius'),
    (r'\babsolutos\b', 'absolvo'),
    (r'\babsolutum\b', 'absolvo'),
    (r'\babsolutumque\b', 'absolvo'),
    (r'\babsoluturi\b', 'absolvo'),
    (r'\babsoluturum\b', 'absolvo'),
    (r'\babsolutus\b', 'absolvo'),
    (r'\babsolutusque\b', 'absolvo'),
    (r'\babsoluunt\b', 'absolvo'),
    (r'\babsoluuntur\b', 'absolvo'),
    (r'\babsolvam\b', 'absolvo'),
    (r'\babsolvant\b', 'absolvo'),
    (r'\babsolvantur\b', 'absolvo'),
    (r'\babsolvar\b', 'absolvo'),
    (r'\babsolvaris\b', 'absolvo'),
    (r'\babsolvas\b', 'absolvo'),
    (r'\babsolvat\b', 'absolvo'),
    (r'\babsolvatis\b', 'absolvo'),
    (r'\babsolvatur\b', 'absolvo'),
    (r'\babsolve\b', 'absolvo'),
    (r'\babsolvenda\b', 'absolvo'),
    (r'\babsolvendi\b', 'absolvo'),
    (r'\babsolvendo\b', 'absolvo'),
    (r'\babsolvendum\b', 'absolvo'),
    (r'\babsolvendus\b', 'absolvo'),
    (r'\babsolventur\b', 'absolvo'),
    (r'\babsolverat\b', 'absolvo'),
    (r'\babsolvere\b', 'absolvo'),
    (r'\babsolverem\b', 'absolvo'),
    (r'\babsolverent\b', 'absolvo'),
    (r'\babsolverentur\b', 'absolvo'),
    (r'\babsolverer\b', 'absolvo'),
    (r'\babsolvereris\b', 'absolvo'),
    (r'\babsolveret\b', 'absolvo'),
    (r'\babsolveretur\b', 'absolvo'),
    (r'\babsolverint\b', 'absolvo'),
    (r'\babsolveris\b', 'absolvo'),
    (r'\babsolverit\b', 'absolvo'),
    (r'\babsolvero\b', 'absolvo'),
    (r'\babsolverunt\b', 'absolvo'),
    (r'\babsolves\b', 'absolvo'),
    (r'\babsolvet\b', 'absolvo'),
    (r'\babsolvetur\b', 'absolvo'),
    (r'\babsolvi\b', 'absolvo'),
    (r'\babsolvimus\b', 'absolvo'),
    (r'\babsolvis\b', 'absolvo'),
    (r'\babsolvisse\b', 'absolvo'),
    (r'\babsolvissemus\b', 'absolvo'),
    (r'\babsolvissent\b', 'absolvo'),
    (r'\babsolvisset\b', 'absolvo'),
    (r'\babsolvisti\b', 'absolvo'),
    (r'\babsolvistis\b', 'absolvo'),
    (r'\babsolvit\b', 'absolvo'),
    (r'\babsolvite\b', 'absolvo'),
    (r'\babsolvito\b', 'absolvo'),
    (r'\babsolvitote\b', 'absolvo'),
    (r'\babsolvitque\b', 'absolvo'),
    (r'\babsolvitur\b', 'absolvo'),
    (r'\babsolvo\b', 'absolvo'),
    (r'\babsolvunt\b', 'absolvo'),
    (r'\babsona\b', 'absonus'),
    (r'\babsonam\b', 'absonus'),
    (r'\babsonare\b', 'absonus'),
    (r'\babsone\b', 'absonus'),
    (r'\babsoni\b', 'absonus'),
    (r'\babsonis\b', 'absonus'),
    (r'\babsono\b', 'absonus'),
    (r'\babsonos\b', 'absonus'),
    (r'\babsonum\b', 'absonus'),
    (r'\babsonumque\b', 'absonus'),
    (r'\babsorbeant\b', 'absorbeo'),
    (r'\babsorbeat\b', 'absorbeo'),
    (r'\babsorbeatur\b', 'absorbeo'),
    (r'\babsorbebant\b', 'absorbeo'),
    (r'\babsorbebat\b', 'absorbeo'),
    (r'\babsorbebatur\b', 'absorbeo'),
    (r'\babsorbebit\b', 'absorbeo'),
    (r'\babsorbebo\b', 'absorbeo'),
    (r'\babsorbendi\b', 'absorbeo'),
    (r'\babsorbendos\b', 'absorbeo'),
    (r'\babsorbens\b', 'absorbeo'),
    (r'\babsorbent\b', 'absorbeo'),
    (r'\babsorbere\b', 'absorbeo'),
    (r'\babsorberet\b', 'absorbeo'),
    (r'\babsorberi\b', 'absorbeo'),
    (r'\babsorbet\b', 'absorbeo'),
    (r'\babsorbetur\b', 'absorbeo'),
    (r'\babsorbuerat\b', 'absorbeo'),
    (r'\babsorbuerit\b', 'absorbeo'),
    (r'\babsorbui\b', 'absorbeo'),
    (r'\babsorbuimus\b', 'absorbeo'),
    (r'\babsorbuisse\b', 'absorbeo'),
    (r'\babsorbuissent\b', 'absorbeo'),
    (r'\babsorbuisset\b', 'absorbeo'),
    (r'\babsorbuit\b', 'absorbeo'),
    (r'\babsorta\b', 'abs-orior'),
    (r'\babsorti\b', 'abs-orior'),
    (r'\babsorti\b', 'abs-pello'),
    (r'\babsortus\b', 'abs-orior'),
    (r'\babspulsum\b', 'abs-pello'),
    (r'\babspulsus\b', 'abs-pello'),
    (r'\babsque\b', 'ab'),
    (r'\babstantia\b', 'abstantia'),
    (r'\babstantia\b', 'absto'),
    (r'\babstem\b', 'absto'),
    (r'\babstemia\b', 'abstemius'),
    (r'\babstemiam\b', 'abstemius'),
    (r'\babstemias\b', 'abstemius'),
    (r'\babstemii\b', 'abstemius'),
    (r'\babstemiorum\b', 'abstemius'),
    (r'\babstemium\b', 'abstemius'),
    (r'\babstemius\b', 'abstemius'),
    (r'\babstenti\b', 'abstineo'),
    (r'\babstento\b', 'abstineo'),
    (r'\babstentum\b', 'abstineo'),
    (r'\babstentus\b', 'abstineo'),
    (r'\babsterge\b', 'abstergeo'),
    (r'\babstergeant\b', 'abstergeo'),
    (r'\babstergeas\b', 'abstergeo'),
    (r'\babstergeatque\b', 'abstergeo'),
    (r'\babstergeatur\b', 'abstergeo'),
    (r'\babstergebo\b', 'abstergeo'),
    (r'\babstergenda\b', 'abstergeo'),
    (r'\babstergendae\b', 'abstergeo'),
    (r'\babstergens\b', 'abstergeo'),
    (r'\babstergent\b', 'abstergeo'),
    (r'\babstergere\b', 'abstergeo'),
    (r'\babstergerique\b', 'abstergeo'),
    (r'\babsterget\b', 'abstergeo'),
    (r'\babstergete\b', 'abstergeo'),
    (r'\babstergetur\b', 'abstergeo'),
    (r'\babsterream\b', 'absterreo'),
    (r'\babsterreant\b', 'absterreo'),
    (r'\babsterreantur\b', 'absterreo'),
    (r'\babsterreat\b', 'absterreo'),
    (r'\babsterrebant\b', 'absterreo'),
    (r'\babsterrebat\b', 'absterreo'),
    (r'\babsterrebitur\b', 'absterreo'),
    (r'\babsterrendo\b', 'absterreo'),
    (r'\babsterrent\b', 'absterreo'),
    (r'\babsterrere\b', 'absterreo'),
    (r'\babsterrerentur\b', 'absterreo'),
    (r'\babsterrereque\b', 'absterreo'),
    (r'\babsterreres\b', 'absterreo'),
    (r'\babsterreri\b', 'absterreo'),
    (r'\babsterres\b', 'absterreo'),
    (r'\babsterret\b', 'absterreo'),
    (r'\babsterrita\b', 'absterreo'),
    (r'\babsterriti\b', 'absterreo'),
    (r'\babsterrito\b', 'absterreo'),
    (r'\babsterritum\b', 'absterreo'),
    (r'\babsterritus\b', 'absterreo'),
    (r'\babsterruere\b', 'absterreo'),
    (r'\babsterrui\b', 'absterreo'),
    (r'\babsterruisset\b', 'absterreo'),
    (r'\babsterruit\b', 'absterreo'),
    (r'\babsterruitque\b', 'absterreo'),
    (r'\babstersa\b', 'abstergeo'),
    (r'\babsterserat\b', 'abstergeo'),
    (r'\babsterseris\b', 'abstergeo'),
    (r'\babsterserit\b', 'abstergeo'),
    (r'\babstersis\b', 'abstergeo'),
    (r'\babstersisque\b', 'abstergeo'),
    (r'\babstersissem\b', 'abstergeo'),
    (r'\babstersisses\b', 'abstergeo'),
    (r'\babstersit\b', 'abstergeo'),
    (r'\babsterso\b', 'abstergeo'),
    (r'\babstersos\b', 'abstergeo'),
    (r'\babstes\b', 'absto'),
    (r'\babstinax\b', 'abstinax'),
    (r'\babstine\b', 'abstineo'),
    (r'\babstineam\b', 'abstineo'),
    (r'\babstineamus\b', 'abstineo'),
    (r'\babstineant\b', 'abstineo'),
    (r'\babstineas\b', 'abstineo'),
    (r'\babstineat\b', 'abstineo'),
    (r'\babstineatis\b', 'abstineo'),
    (r'\babstineatque\b', 'abstineo'),
    (r'\babstineatur\b', 'abstineo'),
    (r'\babstinebam\b', 'abstineo'),
    (r'\babstinebant\b', 'abstineo'),
    (r'\babstinebat\b', 'abstineo'),
    (r'\babstinebatur\b', 'abstineo'),
    (r'\babstinebis\b', 'abstineo'),
    (r'\babstinebit\b', 'abstineo'),
    (r'\babstinebo\b', 'abstineo'),
    (r'\babstinebunt\b', 'abstineo'),
    (r'\babstinemus\b', 'abstineo'),
    (r'\babstinendae\b', 'abstineo'),
    (r'\babstinendi\b', 'abstineo'),
    (r'\babstinendo\b', 'abstineo'),
    (r'\babstinendum\b', 'abstineo'),
    (r'\babstinendumque\b', 'abstineo'),
    (r'\babstinendus\b', 'abstineo'),
    (r'\babstinendusque\b', 'abstineo'),
    (r'\babstinens\b', 'abstineo'),
    (r'\babstinent\b', 'abstineo'),
    (r'\babstinente\b', 'abstineo'),
    (r'\babstinentem\b', 'abstineo'),
    (r'\babstinenter\b', 'abstinenter'),
    (r'\babstinenterque\b', 'abstinenter'),
    (r'\babstinentes\b', 'abstineo'),
    (r'\babstinentesque\b', 'abstineo'),
    (r'\babstinenti\b', 'abstineo'),
    (r'\babstinentia\b', 'abstinentia'),
    (r'\babstinentia\b', 'abstineo'),
    (r'\babstinentiae\b', 'abstinentia'),
    (r'\babstinentiaeque\b', 'abstinentia'),
    (r'\babstinentiam\b', 'abstinentia'),
    (r'\babstinentibus\b', 'abstineo'),
    (r'\babstinentis\b', 'abstineo'),
    (r'\babstinentissimae\b', 'abstineo'),
    (r'\babstinentissimi\b', 'abstineo'),
    (r'\babstinentissimo\b', 'abstineo'),
    (r'\babstinentissimum\b', 'abstineo'),
    (r'\babstinentissimus\b', 'abstineo'),
    (r'\babstineo\b', 'abstineo'),
    (r'\babstinere\b', 'abstineo'),
    (r'\babstinerent\b', 'abstineo'),
    (r'\babstinerentur\b', 'abstineo'),
    (r'\babstineres\b', 'abstineo'),
    (r'\babstineret\b', 'abstineo'),
    (r'\babstineretisque\b', 'abstineo'),
    (r'\babstineretur\b', 'abstineo'),
    (r'\babstineri\b', 'abstineo'),
    (r'\babstinerique\b', 'abstineo'),
    (r'\babstines\b', 'abstineo'),
    (r'\babstinet\b', 'abstineo'),
    (r'\babstinete\b', 'abstineo'),
    (r'\babstineto\b', 'abstineo'),
    (r'\babstinetur\b', 'abstineo'),
    (r'\babstini\b', 'abstineo'),
    (r'\babstinueramus\b', 'abstineo'),
    (r'\babstinuerant\b', 'abstineo'),
    (r'\babstinuerat\b', 'abstineo'),
    (r'\babstinuere\b', 'abstineo'),
    (r'\babstinuerim\b', 'abstineo'),
    (r'\babstinuerint\b', 'abstineo'),
    (r'\babstinueris\b', 'abstineo'),
    (r'\babstinuerit\b', 'abstineo'),
    (r'\babstinuerunt\b', 'abstineo'),
    (r'\babstinui\b', 'abstineo'),
    (r'\babstinuimus\b', 'abstineo'),
    (r'\babstinuisse\b', 'abstineo'),
    (r'\babstinuissem\b', 'abstineo'),
    (r'\babstinuissent\b', 'abstineo'),
    (r'\babstinuisset\b', 'abstineo'),
    (r'\babstinuistis\b', 'abstineo'),
    (r'\babstinuit\b', 'abstineo'),
    (r'\babstinuitque\b', 'abstineo'),
    (r'\babstiterat\b', 'absisto'),
    (r'\babstiterim\b', 'absisto'),
    (r'\babstiterint\b', 'absisto'),
    (r'\babstiterit\b', 'absisto'),
    (r'\babstiterunt\b', 'absisto'),
    (r'\babstitimus\b', 'absisto'),
    (r'\babstitissent\b', 'absisto'),
    (r'\babstitit\b', 'absisto'),
    (r'\babstracta\b', 'abstractus'),
    (r'\babstracta\b', 'abstraho'),
    (r'\babstractae\b', 'abstractus'),
    (r'\babstractae\b', 'abstraho'),
    (r'\babstractaeque\b', 'abstractus'),
    (r'\babstractaeque\b', 'abstraho'),
    (r'\babstractam\b', 'abstractus'),
    (r'\babstractam\b', 'abstraho'),
    (r'\babstractaque\b', 'abstractus'),
    (r'\babstractaque\b', 'abstraho'),
    (r'\babstracti\b', 'abstractus'),
    (r'\babstracti\b', 'abstraho'),
    (r'\babstractos\b', 'abstractus'),
    (r'\babstractos\b', 'abstraho'),
    (r'\babstractum\b', 'abstractus'),
    (r'\babstractum\b', 'abstraho'),
    (r'\babstracturam\b', 'abstraho'),
    (r'\babstracturum\b', 'abstraho'),
    (r'\babstractus\b', 'abstractus'),
    (r'\babstractus\b', 'abstraho'),
    (r'\babstraham\b', 'abstraho'),
    (r'\babstrahamur\b', 'abstraho'),
    (r'\babstrahant\b', 'abstraho'),
    (r'\babstrahas\b', 'abstraho'),
    (r'\babstrahat\b', 'abstraho'),
    (r'\babstrahatur\b', 'abstraho'),
    (r'\babstrahe\b', 'abstraho'),
    (r'\babstrahebat\b', 'abstraho'),
    (r'\babstrahebatur\b', 'abstraho'),
    (r'\babstrahendique\b', 'abstraho'),
    (r'\babstrahendus\b', 'abstraho'),
    (r'\babstrahentesque\b', 'abstraho'),
    (r'\babstrahentibus\b', 'abstraho'),
    (r'\babstrahere\b', 'abstraho'),
    (r'\babstraherent\b', 'abstraho'),
    (r'\babstraherere\b', 'abstraho'),
    (r'\babstraheret\b', 'abstraho'),
    (r'\babstraheretur\b', 'abstraho'),
    (r'\babstrahet\b', 'abstraho'),
    (r'\babstrahi\b', 'abstraho'),
    (r'\babstrahit\b', 'abstraho'),
    (r'\babstrahite\b', 'abstraho'),
    (r'\babstrahitur\b', 'abstraho'),
    (r'\babstrahor\b', 'abstraho'),
    (r'\babstrahunt\b', 'abstraho'),
    (r'\babstrahuntur\b', 'abstraho'),
    (r'\babstraxerat\b', 'abstraho'),
    (r'\babstraxeris\b', 'abstraho'),
    (r'\babstraxerit\b', 'abstraho'),
    (r'\babstraxerunt\b', 'abstraho'),
    (r'\babstraxi\b', 'abstraho'),
    (r'\babstraximus\b', 'abstraho'),
    (r'\babstraxisse\b', 'abstraho'),
    (r'\babstraxissent\b', 'abstraho'),
    (r'\babstraxisset\b', 'abstraho'),
    (r'\babstraxit\b', 'abstraho'),
    (r'\babstraxitque\b', 'abstraho'),
    (r'\babstrudam\b', 'abstrudo'),
    (r'\babstrudat\b', 'abstrudo'),
    (r'\babstrudebas\b', 'abstrudo'),
    (r'\babstrudebat\b', 'abstrudo'),
    (r'\babstrudere\b', 'abstrudo'),
    (r'\babstrudi\b', 'abstrudo'),
    (r'\babstrudit\b', 'abstrudo'),
    (r'\babstruditur\b', 'abstrudo'),
    (r'\babstrudunt\b', 'abstrudo'),
    (r'\babstrusa\b', 'abstrudo'),
    (r'\babstrusam\b', 'abstrudo'),
    (r'\babstrusaque\b', 'abstrudo'),
    (r'\babstrusas\b', 'abstrudo'),
    (r'\babstruserint\b', 'abstrudo'),
    (r'\babstruserit\b', 'abstrudo'),
    (r'\babstrusi\b', 'abstrudo'),
    (r'\babstrusior\b', 'abstrudo'),
    (r'\babstrusisque\b', 'abstrudo'),
    (r'\babstrusisse\b', 'abstrudo'),
    (r'\babstrusius\b', 'abstrudo'),
    (r'\babstruso\b', 'abstrudo'),
    (r'\babstrusos\b', 'abstrudo'),
    (r'\babstrusum\b', 'abstrudo'),
    (r'\babstrusus\b', 'abstrudo'),
    (r'\babstuleram\b', 'aufero'),
    (r'\babstulerant\b', 'aufero'),
    (r'\babstuleras\b', 'aufero'),
    (r'\babstulerat\b', 'aufero'),
    (r'\babstulere\b', 'abstulo'),
    (r'\babstulere\b', 'aufero'),
    (r'\babstulerim\b', 'aufero'),
    (r'\babstulerint\b', 'aufero'),
    (r'\babstuleris\b', 'abstulo'),
    (r'\babstuleris\b', 'aufero'),
    (r'\babstulerit\b', 'aufero'),
    (r'\babstuleritis\b', 'aufero'),
    (r'\babstuleritque\b', 'aufero'),
    (r'\babstulero\b', 'aufero'),
    (r'\babstulerunt\b', 'aufero'),
    (r'\babstuleruntque\b', 'aufero'),
    (r'\babstuli\b', 'aufero'),
    (r'\babstuli\b', 'abstulo'),
    (r'\babstulimus\b', 'aufero'),
    (r'\babstulimus\b', 'abstulo'),
    (r'\babstulisse\b', 'aufero'),
    (r'\babstulissem\b', 'aufero'),
    (r'\babstulissent\b', 'aufero'),
    (r'\babstulisses\b', 'aufero'),
    (r'\babstulisset\b', 'aufero'),
    (r'\babstulissetis\b', 'aufero'),
    (r'\babstulissetque\b', 'aufero'),
    (r'\babstulisti\b', 'aufero'),
    (r'\babstulistis\b', 'aufero'),
    (r'\babstulit\b', 'aufero'),
    (r'\babstulit\b', 'abstulo'),
    (r'\babsum\b', 'absum'),
    (r'\babsumam\b', 'absumo'),
    (r'\babsumamus\b', 'absumo'),
    (r'\babsumant\b', 'absumo'),
    (r'\babsumantur\b', 'absumo'),
    (r'\babsumas\b', 'absumo'),
    (r'\babsumat\b', 'absumo'),
    (r'\babsumatur\b', 'absumo'),
    (r'\babsumebat\b', 'absumo'),
    (r'\babsumebatur\b', 'absumo'),
    (r'\babsumedo\b', 'absumedo'),
    (r'\babsumendi\b', 'absumo'),
    (r'\babsumendis\b', 'absumo'),
    (r'\babsumendosque\b', 'absumo'),
    (r'\babsumens\b', 'absumo'),
    (r'\babsument\b', 'absumo'),
    (r'\babsumere\b', 'absumo'),
    (r'\babsumerent\b', 'absumo'),
    (r'\babsumerentur\b', 'absumo'),
    (r'\babsumerer\b', 'absumo'),
    (r'\babsumeret\b', 'absumo'),
    (r'\babsumeretur\b', 'absumo'),
    (r'\babsumet\b', 'absumo'),
    (r'\babsumi\b', 'absumo'),
    (r'\babsumimus\b', 'absumo'),
    (r'\babsumique\b', 'absumo'),
    (r'\babsumis\b', 'absumo'),
    (r'\babsumit\b', 'absumo'),
    (r'\babsumite\b', 'absumo'),
    (r'\babsumito\b', 'absumo'),
    (r'\babsumitur\b', 'absumo'),
    (r'\babsumo\b', 'absumo'),
    (r'\babsumor\b', 'absumo'),
    (r'\babsumpserant\b', 'absumo'),
    (r'\babsumpserat\b', 'absumo'),
    (r'\babsumpsere\b', 'absumo'),
    (r'\babsumpserint\b', 'absumo'),
    (r'\babsumpserit\b', 'absumo'),
    (r'\babsumpserunt\b', 'absumo'),
    (r'\babsumpsi\b', 'absumo'),
    (r'\babsumpsisse\b', 'absumo'),
    (r'\babsumpsissent\b', 'absumo'),
    (r'\babsumpsisset\b', 'absumo'),
    (r'\babsumpsisti\b', 'absumo'),
    (r'\babsumpsistis\b', 'absumo'),
    (r'\babsumpsit\b', 'absumo'),
    (r'\babsumpta\b', 'absumo'),
    (r'\babsumptae\b', 'absumo'),
    (r'\babsumptam\b', 'absumo'),
    (r'\babsumptas\b', 'absumo'),
    (r'\babsumpti\b', 'absumo'),
    (r'\babsumptione\b', 'absumptio'),
    (r'\babsumptis\b', 'absumo'),
    (r'\babsumpto\b', 'absumo'),
    (r'\babsumptos\b', 'absumo'),
    (r'\babsumptu\b', 'absumo'),
    (r'\babsumptum\b', 'absumo'),
    (r'\babsumpturam\b', 'absumo'),
    (r'\babsumpturos\b', 'absumo'),
    (r'\babsumptus\b', 'absumo'),
    (r'\babsumunt\b', 'absumo'),
    (r'\babsumuntur\b', 'absumo'),
    (r'\babsumus\b', 'absum'),
    (r'\babsunt\b', 'absum'),
    (r'\babsurda\b', 'absurdus'),
    (r'\babsurdae\b', 'absurdus'),
    (r'\babsurdam\b', 'absurdus'),
    (r'\babsurde\b', 'absurdus'),
    (r'\babsurdeque\b', 'absurdus'),
    (r'\babsurdiora\b', 'absurdus'),
    (r'\babsurdis\b', 'absurdus'),
    (r'\babsurdissima\b', 'absurdus'),
    (r'\babsurdissimis\b', 'absurdus'),
    (r'\babsurdissimum\b', 'absurdus'),
    (r'\babsurdius\b', 'absurdus'),
    (r'\babsurdo\b', 'absurdus'),
    (r'\babsurdoque\b', 'absurdus'),
    (r'\babsurdum\b', 'absurdus'),
    (r'\babsurdumque\b', 'absurdus'),
    (r'\babsurdus\b', 'absurdus'),
    (r'\babsuri\b', 'abs-uro'),
    (r'\babsuri\b', 'abs-uro'),
    (r'\bAbsyrti\b', 'Absyrtus1'),
    (r'\bAbsyrtis\b', 'Absyrtus1'),
    (r'\bAbsyrto\b', 'Absyrtus1'),
    (r'\bAbsyrtum\b', 'Absyrtus1'),
    (r'\bAbsyrtus\b', 'Absyrtus1'),
    (r'\babuersis\b', 'ab-verro'),
    (r'\babundabant\b', 'abundo'),
    (r'\babundabas\b', 'abundo'),
    (r'\babundabat\b', 'abundo'),
    (r'\babundabimus\b', 'abundo'),
    (r'\babundabis\b', 'abundo'),
    (r'\babundabit\b', 'abundo'),
    (r'\babundabunt\b', 'abundo'),
    (r'\babundamus\b', 'abundo'),
    (r'\babundans\b', 'abundo'),
    (r'\babundansque\b', 'abundo'),
    (r'\babundant\b', 'abundo'),
    (r'\babundante\b', 'abundo'),
    (r'\babundantem\b', 'abundo'),
    (r'\babundanter\b', 'abundantia'),
    (r'\babundantes\b', 'abundo'),
    (r'\babundanti\b', 'abundo'),
    (r'\babundantia\b', 'abundantia'),
    (r'\babundantia\b', 'abundo'),
    (r'\babundantiae\b', 'abundantia'),
    (r'\babundantiam\b', 'abundantia'),
    (r'\babundantiamque\b', 'abundantia'),
    (r'\babundantibus\b', 'abundo'),
    (r'\babundantior\b', 'abundo'),
    (r'\babundantiorem\b', 'abundo'),
    (r'\babundantiori\b', 'abundo'),
    (r'\babundantis\b', 'abundo'),
    (r'\babundantissima\b', 'abundo'),
    (r'\babundantissimae\b', 'abundo'),
    (r'\babundantissimam\b', 'abundo'),
    (r'\babundantissime\b', 'abundo'),
    (r'\babundantissimi\b', 'abundo'),
    (r'\babundantissimis\b', 'abundo'),
    (r'\babundantissimisque\b', 'abundo'),
    (r'\babundantissimo\b', 'abundo'),
    (r'\babundantissimum\b', 'abundo'),
    (r'\babundantissimus\b', 'abundo'),
    (r'\babundantium\b', 'abundo'),
    (r'\babundantius\b', 'abundo'),
    (r'\babundarat\b', 'abundo'),
    (r'\babundare\b', 'abundo'),
    (r'\babundaremus\b', 'abundo'),
    (r'\babundarent\b', 'abundo'),
    (r'\babundares\b', 'abundo'),
    (r'\babundaret\b', 'abundo'),
    (r'\babundaretque\b', 'abundo'),
    (r'\babundarit\b', 'abundo'),
    (r'\babundarunt\b', 'abundo'),
    (r'\babundas\b', 'abundus'),
    (r'\babundas\b', 'abundo'),
    (r'\babundasse\b', 'abundo'),
    (r'\babundasset\b', 'abundo'),
    (r'\babundat\b', 'abundo'),
    (r'\babundatio\b', 'abundatio'),
    (r'\babundatione\b', 'abundatio'),
    (r'\babundatis\b', 'abundo'),
    (r'\babundaturum\b', 'abundo'),
    (r'\babundaueras\b', 'abundo'),
    (r'\babundauerat\b', 'abundo'),
    (r'\babundauerit\b', 'abundo'),
    (r'\babundauit\b', 'abundo'),
    (r'\babundaverat\b', 'abundo'),
    (r'\babundavere\b', 'abundo'),
    (r'\babundaverit\b', 'abundo'),
    (r'\babundaverunt\b', 'abundo'),
    (r'\babundavisse\b', 'abundo'),
    (r'\babundavit\b', 'abundo'),
    (r'\babunde\b', 'abundus'),
    (r'\babunde\b', 'abunde'),
    (r'\babundem\b', 'abundo'),
    (r'\babundemus\b', 'abundo'),
    (r'\babundent\b', 'abundo'),
    (r'\babundeque\b', 'abundus'),
    (r'\babundeque\b', 'abunde'),
    (r'\babundes\b', 'abundo'),
    (r'\babundet\b', 'abundo'),
    (r'\babundetis\b', 'abundo'),
    (r'\babundis\b', 'abundus'),
    (r'\babundo\b', 'abundus'),
    (r'\babundo\b', 'abundo'),
    (r'\babusa\b', 'abutor'),
    (r'\babusast\b', 'abutor'),
    (r'\babusi\b', 'abutor'),
    (r'\babusio\b', 'abusio'),
    (r'\babusione\b', 'abusio'),
    (r'\babusionem\b', 'abusio'),
    (r'\babusionis\b', 'abusio'),
    (r'\babusis\b', 'abutor'),
    (r'\babusiue\b', 'abusivus'),
    (r'\babusiue\b', 'abusive'),
    (r'\babusiue\b', 'abutor'),
    (r'\babusive\b', 'abusivus'),
    (r'\babusive\b', 'abusive'),
    (r'\babusos\b', 'abutor'),
    (r'\babusu\b', 'abusus'),
    (r'\babusu\b', 'abutor'),
    (r'\babusum\b', 'abusus'),
    (r'\babusum\b', 'abutor'),
    (r'\babusumque\b', 'abusus'),
    (r'\babusumque\b', 'abutor'),
    (r'\babusurus\b', 'abutor'),
    (r'\babusus\b', 'abusus'),
    (r'\babusus\b', 'abutor'),
    (r'\babutamini\b', 'abutor'),
    (r'\babutamur\b', 'abutor'),
    (r'\babutantur\b', 'abutor'),
    (r'\babutar\b', 'abutor'),
    (r'\babutatur\b', 'abutor'),
    (r'\babutebanturque\b', 'abutor'),
    (r'\babutebatur\b', 'abutor'),
    (r'\babutemur\b', 'abutor'),
    (r'\babutendum\b', 'abutor'),
    (r'\babutendumque\b', 'abutor'),
    (r'\babutens\b', 'abutor'),
    (r'\babutentem\b', 'abutor'),
    (r'\babutentes\b', 'abutor'),
    (r'\babutentis\b', 'abutor'),
    (r'\babutere\b', 'abutor'),
    (r'\babuterentur\b', 'abutor'),
    (r'\babuterer\b', 'abutor'),
    (r'\babuteretur\b', 'abutor'),
    (r'\babuteris\b', 'abutor'),
    (r'\babutetur\b', 'abutor'),
    (r'\babuti\b', 'abutor'),
    (r'\babutimini\b', 'abutor'),
    (r'\babutimur\b', 'abutor'),
    (r'\babutitur\b', 'abutor'),
    (r'\babutor\b', 'abutor'),
    (r'\babutuntur\b', 'abutor'),
    (r'\bAbydena\b', 'ab-verro'),
    (r'\bAbydeni\b', 'ab-verro'),
    (r'\bAbydenique\b', 'ab-verro'),
    (r'\bAbydenis\b', 'ab-verro'),
    (r'\bAbydeno\b', 'ab-verro'),
    (r'\bAbydenorum\b', 'ab-verro'),
    (r'\bAbydenos\b', 'ab-verro'),
    (r'\bAbydenus\b', 'ab-verro'),
    (r'\babyssi\b', 'abyssus'),
    (r'\babyssis\b', 'abyssus'),
    (r'\babysso\b', 'abyssus'),
    (r'\babyssos\b', 'abyssus'),
    (r'\babyssum\b', 'abyssus'),
    (r'\babyssus\b', 'abyssus'),
    (r'\bac\b', 'atque'),
    (r'\bacacia\b', 'acacia'),
    (r'\bacaciae\b', 'acacia'),
    (r'\bacaciam\b', 'acacia'),
    (r'\bAcademi\b', 'Academus'),
    (r'\bAcademia\b', 'academia'),
    (r'\bacademia\b', 'academia'),
    (r'\bAcademiae\b', 'academia'),
    (r'\bacademiae\b', 'academia'),
    (r'\bAcademiaeque\b', 'academia'),
    (r'\bacademiaeque\b', 'academia'),
    (r'\bAcademiaest\b', 'academia'),
    (r'\bacademiaest\b', 'academia'),
    (r'\bAcademiam\b', 'academia'),
    (r'\bacademiam\b', 'academia'),
    (r'\bAcademian\b', 'academia'),
    (r'\bacademian\b', 'academia'),
    (r'\bAcademias\b', 'academia'),
    (r'\bacademias\b', 'academia'),
    (r'\bacademica\b', 'academicus'),
    (r'\bacademicam\b', 'academicus'),
    (r'\bacademici\b', 'academicus'),
    (r'\bacademicis\b', 'academicus'),
    (r'\bacademicisque\b', 'academicus'),
    (r'\bacademico\b', 'academicus'),
    (r'\bacademicorum\b', 'academicus'),
    (r'\bacademicorumque\b', 'academicus'),
    (r'\bacademicos\b', 'academicus'),
    (r'\bacademicum\b', 'academicus'),
    (r'\bacademicus\b', 'academicus'),
    (r'\bacalanthis\b', 'acalanthis'),
    (r'\bAcamantem\b', 'Acamas'),
    (r'\bAcamas\b', 'Acamas'),
    (r'\bAcamasque\b', 'Acamas'),
    (r'\bAcan\b', 'Ace'),
    (r'\bacano\b', 'acanos'),
    (r'\bacantem\b', 'a-canto'),
    (r'\bAcanthi\b', 'acanthus'),
    (r'\bacanthi\b', 'acanthus'),
    (r'\bAcanthi\b', 'Acanthius'),
    (r'\bacanthina\b', 'acanthinus'),
    (r'\bacanthini\b', 'acanthinus'),
    (r'\bacanthinis\b', 'acanthinus'),
    (r'\bacanthinum\b', 'acanthinus'),
    (r'\bAcanthio\b', 'Acanthius'),
    (r'\bacanthio\b', 'acanthion'),
    (r'\bacanthion\b', 'acanthion'),
    (r'\bAcanthis\b', 'acanthus'),
    (r'\bacanthis\b', 'acanthis'),
    (r'\bacanthis\b', 'acanthus'),
    (r'\bAcanthius\b', 'Acanthius'),
    (r'\bAcantho\b', 'acanthus'),
    (r'\bacantho\b', 'acanthus'),
    (r'\bAcanthos\b', 'acanthus'),
    (r'\bacanthos\b', 'acanthus'),
    (r'\bAcanthum\b', 'acanthus'),
    (r'\bacanthum\b', 'acanthus'),
    (r'\bAcanthus\b', 'acanthus'),
    (r'\bacanthus\b', 'acanthus'),
    (r'\bacantis\b', 'acanos'),
    (r'\bacanum\b', 'acanos'),
    (r'\bAcarnania\b', 'Acarnania'),
    (r'\bAcarnaniae\b', 'Acarnania'),
    (r'\bAcarnaniam\b', 'Acarnania'),
    (r'\bAcarnaniamque\b', 'Acarnania'),
    (r'\bAcarnaniaque\b', 'Acarnania'),
    (r'\bAcarnanicae\b', 'Acarnanicus'),
    (r'\bAcaste\b', 'Acastus'),
    (r'\bAcasten\b', 'Acastus'),
    (r'\bAcasti\b', 'Acastus'),
    (r'\bacasti\b', 'a-caveo'),
    (r'\bAcasto\b', 'Acastus'),
    (r'\bAcastoque\b', 'Acastus'),
    (r'\bAcastum\b', 'Acastus'),
    (r'\bAcastus\b', 'Acastus'),
    (r'\bacati\b', 'acatus'),
    (r'\bacato\b', 'acatus'),
    (r'\bacaunumarga\b', 'acaunumarga'),
    (r'\bAcbari\b', 'a-caveo'),
    (r'\bAcbarus\b', 'a-caveo'),
    (r'\bAcca\b', 'Acca'),
    (r'\baccadens\b', 'ad-curro'),
    (r'\bAccae\b', 'Acca'),
    (r'\bAccam\b', 'Acca'),
    (r'\baccanit\b', 'accano'),
    (r'\baccaron\b', 'ad-curro'),
    (r'\baccedam\b', 'accedo'),
    (r'\baccedamus\b', 'accedo'),
    (r'\baccedant\b', 'accedo'),
    (r'\baccedas\b', 'accedo'),
    (r'\baccedat\b', 'accedo'),
    (r'\baccedatur\b', 'accedo'),
    (r'\baccede\b', 'accedo'),
    (r'\baccedebam\b', 'accedo'),
    (r'\baccedebant\b', 'accedo'),
    (r'\baccedebat\b', 'accedo'),
    (r'\baccedemus\b', 'accedo'),
    (r'\bacceden\b', 'accedo'),
    (r'\baccedendi\b', 'accedo'),
    (r'\baccedendo\b', 'accedo'),
    (r'\baccedendum\b', 'accedo'),
    (r'\baccedens\b', 'accedo'),
    (r'\baccedensque\b', 'accedo'),
    (r'\baccedent\b', 'accedo'),
    (r'\baccedente\b', 'accedo'),
    (r'\baccedentem\b', 'accedo'),
    (r'\baccedentes\b', 'accedo'),
    (r'\baccedenti\b', 'accedo'),
    (r'\baccedentia\b', 'accedo'),
    (r'\baccedentibus\b', 'accedo'),
    (r'\baccedentium\b', 'accedo'),
    (r'\baccedentque\b', 'accedo'),
    (r'\baccedere\b', 'accedo'),
    (r'\baccederem\b', 'accedo'),
    (r'\baccederemus\b', 'accedo'),
    (r'\baccederent\b', 'accedo'),
    (r'\baccederes\b', 'accedo'),
    (r'\baccederet\b', 'accedo'),
    (r'\baccederetis\b', 'accedo'),
    (r'\baccederetur\b', 'accedo'),
    (r'\baccedes\b', 'accedo'),
    (r'\baccedesque\b', 'accedo'),
    (r'\baccedet\b', 'accedo'),
    (r'\baccedetisque\b', 'accedo'),
    (r'\baccedi\b', 'accedo'),
    (r'\baccedimus\b', 'accedo'),
    (r'\baccedis\b', 'accedo'),
    (r'\baccedit\b', 'accedo'),
    (r'\baccedite\b', 'accedo'),
    (r'\baccedito\b', 'accedo'),
    (r'\bacceditque\b', 'accedo'),
    (r'\bacceditur\b', 'accedo'),
    (r'\baccedo\b', 'accedo'),
    (r'\baccedor\b', 'accedo'),
    (r'\baccedundi\b', 'accedo'),
    (r'\baccedunt\b', 'accedo'),
    (r'\bacceduntque\b', 'accedo'),
    (r'\bacceduntur\b', 'accedo'),
    (r'\baccelera\b', 'accelero'),
    (r'\baccelerant\b', 'accelero'),
    (r'\baccelerare\b', 'accelero'),
    (r'\bacceleraret\b', 'accelero'),
    (r'\bacceleraretur\b', 'accelero'),
    (r'\baccelerarunt\b', 'accelero'),
    (r'\baccelerasse\b', 'accelero'),
    (r'\baccelerat\b', 'accelero'),
    (r'\baccelerate\b', 'accelero'),
    (r'\bacceleraverunt\b', 'accelero'),
    (r'\bacceleremus\b', 'accelero'),
    (r'\baccelerent\b', 'accelero'),
    (r'\bacceleret\b', 'accelero'),
    (r'\baccendam\b', 'accendo2'),
    (r'\baccendamque\b', 'accendo2'),
    (r'\baccendamus\b', 'accendo2'),
    (r'\baccendant\b', 'accendo2'),
    (r'\baccendantur\b', 'accendo2'),
    (r'\baccendas\b', 'accendo2'),
    (r'\baccendat\b', 'accendo2'),
    (r'\baccendatis\b', 'accendo2'),
    (r'\baccendatur\b', 'accendo2'),
    (r'\baccende\b', 'accendo2'),
    (r'\baccendebant\b', 'accendo2'),
    (r'\baccendebantur\b', 'accendo2'),
    (r'\baccendebat\b', 'accendo2'),
    (r'\baccendebatur\b', 'accendo2'),
    (r'\baccendenda\b', 'accendo2'),
    (r'\baccendendam\b', 'accendo2'),
    (r'\baccendendi\b', 'accendo2'),
    (r'\baccendendis\b', 'accendo2'),
    (r'\baccendendo\b', 'accendo2'),
    (r'\baccendendos\b', 'accendo2'),
    (r'\baccendendum\b', 'accendo2'),
    (r'\baccendens\b', 'accendo2'),
    (r'\baccendent\b', 'accendo2'),
    (r'\baccendentes\b', 'accendo2'),
    (r'\baccendentibus\b', 'accendo2'),
    (r'\baccenderant\b', 'accendo2'),
    (r'\baccenderat\b', 'accendo2'),
    (r'\baccendere\b', 'accendo2'),
    (r'\baccenderem\b', 'accendo2'),
    (r'\baccenderent\b', 'accendo2'),
    (r'\baccenderentur\b', 'accendo2'),
    (r'\baccenderer\b', 'accendo2'),
    (r'\baccenderet\b', 'accendo2'),
    (r'\baccenderetur\b', 'accendo2'),
    (r'\baccenderit\b', 'accendo2'),
    (r'\baccenderunt\b', 'accendo2'),
    (r'\baccendet\b', 'accendo2'),
    (r'\baccendetur\b', 'accendo2'),
    (r'\baccendi\b', 'accendium'),
    (r'\baccendi\b', 'accendo2'),
    (r'\baccendier\b', 'accendo2'),
    (r'\baccendimur\b', 'accendo2'),
    (r'\baccendimus\b', 'accendo2'),
    (r'\baccendis\b', 'accendo2'),
    (r'\baccendisse\b', 'accendo2'),
    (r'\baccendisset\b', 'accendo2'),
    (r'\baccendit\b', 'accendo2'),
    (r'\baccendite\b', 'accendo2'),
    (r'\baccenditque\b', 'accendo2'),
    (r'\baccenditur\b', 'accendo2'),
    (r'\baccendo\b', 'accendo1'),
    (r'\baccendo\b', 'accendo2'),
    (r'\baccendor\b', 'accendo2'),
    (r'\baccendunt\b', 'accendo2'),
    (r'\baccenduntque\b', 'accendo2'),
    (r'\baccenduntur\b', 'accendo2'),
    (r'\baccensa\b', 'accendo2'),
    (r'\baccensae\b', 'accendo2'),
    (r'\baccensam\b', 'accendo2'),
    (r'\baccensaque\b', 'accendo2'),
    (r'\baccensas\b', 'accendo2'),
    (r'\baccensasque\b', 'accendo2'),
    (r'\baccenseor\b', 'accenseo'),
    (r'\baccensi\b', 'accensus'),
    (r'\baccensi\b', 'accendo2'),
    (r'\baccensibilem\b', 'accensibilis'),
    (r'\baccensis\b', 'accensus'),
    (r'\baccensis\b', 'accendo2'),
    (r'\baccensisque\b', 'accensus'),
    (r'\baccensisque\b', 'accendo2'),
    (r'\baccenso\b', 'accensus'),
    (r'\baccenso\b', 'accendo2'),
    (r'\baccensorum\b', 'accensus'),
    (r'\baccensorum\b', 'accendo2'),
    (r'\baccensos\b', 'accensus'),
    (r'\baccensos\b', 'accendo2'),
    (r'\baccensosque\b', 'accensus'),
    (r'\baccensosque\b', 'accendo2'),
    (r'\baccensu\b', 'accensus2'),
    (r'\baccensu\b', 'accendo2'),
    (r'\baccensum\b', 'accensus'),
    (r'\baccensum\b', 'accendo2'),
    (r'\baccensumque\b', 'accensus'),
    (r'\baccensumque\b', 'accendo2'),
    (r'\baccensure\b', 'accendo2'),
    (r'\baccensuros\b', 'accendo2'),
    (r'\baccensurum\b', 'accendo2'),
    (r'\baccensus\b', 'accensus2'),
    (r'\baccensus\b', 'accensus'),
    (r'\baccensus\b', 'accendo2'),
    (r'\baccensusque\b', 'accensus2'),
    (r'\baccensusque\b', 'accensus'),
    (r'\baccensusque\b', 'accendo2'),
    (r'\baccentibus\b', 'accentus'),
    (r'\baccentiunculas\b', 'accentiuncula'),
    (r'\baccentu\b', 'accentus'),
    (r'\baccentui\b', 'accentus'),
    (r'\baccentum\b', 'accentus'),
    (r'\baccentus\b', 'accentus'),
    (r'\baccentuum\b', 'accentus'),
    (r'\bacceperam\b', 'accipio'),
    (r'\bacceperamus\b', 'accipio'),
    (r'\bacceperant\b', 'accipio'),
    (r'\bacceperas\b', 'accipio'),
    (r'\bacceperat\b', 'accipio'),
    (r'\baccepere\b', 'accipio'),
    (r'\bacceperim\b', 'accipio'),
    (r'\bacceperimus\b', 'accipio'),
    (r'\bacceperint\b', 'accipio'),
    (r'\bacceperis\b', 'accipio'),
    (r'\bacceperit\b', 'accipio'),
    (r'\bacceperitis\b', 'accipio'),
    (r'\bacceperitque\b', 'accipio'),
    (r'\baccepero\b', 'accipio'),
    (r'\bacceperunt\b', 'accipio'),
    (r'\bacceperuntque\b', 'accipio'),
    (r'\baccepi\b', 'accipio'),
    (r'\baccepimus\b', 'accipio'),
    (r'\baccepique\b', 'accipio'),
    (r'\baccepisse\b', 'accipio'),
    (r'\baccepissem\b', 'accipio'),
    (r'\baccepissemus\b', 'accipio'),
    (r'\baccepissent\b', 'accipio'),
    (r'\baccepisses\b', 'accipio'),
    (r'\baccepisset\b', 'accipio'),
    (r'\baccepissetis\b', 'accipio'),
    (r'\baccepisti\b', 'accipio'),
    (r'\baccepistin\b', 'accipio'),
    (r'\baccepistis\b', 'accipio'),
    (r'\baccepit\b', 'accipio'),
    (r'\baccepitne\b', 'accipio'),
    (r'\baccepitque\b', 'accipio'),
    (r'\baccepta\b', 'accepta'),
    (r'\baccepta\b', 'acceptum'),
    (r'\baccepta\b', 'accipio'),
    (r'\baccepta\b', 'accepto'),
    (r'\bacceptabat\b', 'accepto'),
    (r'\bacceptabile\b', 'acceptabilis'),
    (r'\bacceptabilem\b', 'acceptabilis'),
    (r'\bacceptabiles\b', 'acceptabilis'),
    (r'\bacceptabilis\b', 'acceptabilis'),
    (r'\bacceptabis\b', 'accepto'),
    (r'\bacceptae\b', 'accepta'),
    (r'\bacceptae\b', 'accipio'),
    (r'\bacceptaeque\b', 'accepta'),
    (r'\bacceptaeque\b', 'accipio'),
    (r'\bacceptam\b', 'accepta'),
    (r'\bacceptam\b', 'accipio'),
    (r'\bacceptamque\b', 'accepta'),
    (r'\bacceptamque\b', 'accipio'),
    (r'\bacceptandis\b', 'accepto'),
    (r'\bacceptando\b', 'accepto'),
    (r'\bacceptans\b', 'accepto'),
    (r'\bacceptante\b', 'accepto'),
    (r'\bacceptantur\b', 'accepto'),
    (r'\bacceptaque\b', 'accepta'),
    (r'\bacceptaque\b', 'acceptum'),
    (r'\bacceptaque\b', 'accipio'),
    (r'\bacceptaque\b', 'accepto'),
    (r'\bacceptare\b', 'accepto'),
    (r'\bacceptarum\b', 'accepta'),
    (r'\bacceptarum\b', 'accipio'),
    (r'\bacceptas\b', 'accepta'),
    (r'\bacceptas\b', 'accipio'),
    (r'\bacceptas\b', 'accepto'),
    (r'\bacceptasque\b', 'accepta'),
    (r'\bacceptasque\b', 'accipio'),
    (r'\bacceptasque\b', 'accepto'),
    (r'\bacceptat\b', 'accepto'),
    (r'\bacceptatius\b', 'accepto'),
    (r'\bacceptaue\b', 'accepta'),
    (r'\bacceptaue\b', 'acceptum'),
    (r'\bacceptaue\b', 'accipio'),
    (r'\bacceptaue\b', 'accepto'),
    (r'\bacceptauerint\b', 'accepto'),
    (r'\bacceptauerit\b', 'accepto'),
    (r'\bacceptauerunt\b', 'accepto'),
    (r'\bacceptauit\b', 'accepto'),
    (r'\bacceptaveris\b', 'accepto'),
    (r'\baccepti\b', 'acceptum'),
    (r'\baccepti\b', 'accipio'),
    (r'\bacceptio\b', 'acceptio'),
    (r'\bacceptione\b', 'acceptio'),
    (r'\bacceptiones\b', 'acceptio'),
    (r'\bacceptior\b', 'accipio'),
    (r'\bacceptiores\b', 'accipio'),
    (r'\bacceptiorque\b', 'accipio'),
    (r'\bacceptique\b', 'acceptum'),
    (r'\bacceptique\b', 'accipio'),
    (r'\bacceptis\b', 'accepta'),
    (r'\bacceptis\b', 'acceptum'),
    (r'\bacceptis\b', 'accipio'),
    (r'\bacceptisque\b', 'accepta'),
    (r'\bacceptisque\b', 'acceptum'),
    (r'\bacceptisque\b', 'accipio'),
    (r'\bacceptissima\b', 'accipio'),
    (r'\bacceptissimam\b', 'accipio'),
    (r'\bacceptissimis\b', 'accipio'),
    (r'\bacceptissimo\b', 'accipio'),
    (r'\bacceptissimos\b', 'accipio'),
    (r'\bacceptissimum\b', 'accipio'),
    (r'\bacceptissimus\b', 'accipio'),
    (r'\bacceptius\b', 'accipio'),
    (r'\baccepto\b', 'acceptum'),
    (r'\baccepto\b', 'accipio'),
    (r'\baccepto\b', 'accepto'),
    (r'\bacceptoque\b', 'acceptum'),
    (r'\bacceptoque\b', 'accipio'),
    (r'\bacceptoque\b', 'accepto'),
    (r'\bacceptor\b', 'acceptor1'),
    (r'\bacceptor\b', 'accepto'),
    (r'\bacceptorio\b', 'acceptorius'),
    (r'\bacceptoris\b', 'acceptor1'),
    (r'\bacceptorum\b', 'acceptor1'),
    (r'\bacceptorum\b', 'acceptum'),
    (r'\bacceptorum\b', 'accipio'),
    (r'\bacceptorumque\b', 'acceptor1'),
    (r'\bacceptorumque\b', 'acceptum'),
    (r'\bacceptorumque\b', 'accipio'),
    (r'\bacceptos\b', 'accipio'),
    (r'\bacceptosque\b', 'accipio'),
    (r'\bacceptrici\b', 'acceptrix'),
    (r'\bacceptum\b', 'acceptum'),
    (r'\bacceptum\b', 'accipio'),
    (r'\bacceptumque\b', 'acceptum'),
    (r'\bacceptumque\b', 'accipio'),
    (r'\bacceptumst\b', 'acceptum'),
    (r'\bacceptumst\b', 'accipio'),
    (r'\bacceptumve\b', 'acceptum'),
    (r'\bacceptumve\b', 'accipio'),
    (r'\bacceptura\b', 'accipio'),
    (r'\baccepturae\b', 'accipio'),
    (r'\baccepturam\b', 'accipio'),
    (r'\baccepturas\b', 'accipio'),
    (r'\baccepturi\b', 'accipio'),
    (r'\baccepturisque\b', 'accipio'),
    (r'\baccepturo\b', 'accipio'),
    (r'\baccepturorum\b', 'accipio'),
    (r'\baccepturos\b', 'accipio'),
    (r'\baccepturum\b', 'accipio'),
    (r'\baccepturus\b', 'accipio'),
    (r'\bacceptus\b', 'accipio'),
    (r'\bacceptusque\b', 'accipio'),
    (r'\baccersam\b', 'arcesso'),
    (r'\baccersamus\b', 'arcesso'),
    (r'\baccersant\b', 'arcesso'),
    (r'\baccersantur\b', 'arcesso'),
    (r'\baccersas\b', 'arcesso'),
    (r'\baccersat\b', 'arcesso'),
    (r'\baccersatis\b', 'arcesso'),
    (r'\baccerse\b', 'arcesso'),
    (r'\baccersebant\b', 'arcesso'),
    (r'\baccersebat\b', 'arcesso'),
    (r'\baccersebatur\b', 'arcesso'),
    (r'\baccersenda\b', 'arcesso'),
    (r'\baccersendam\b', 'arcesso'),
    (r'\baccersendas\b', 'arcesso'),
    (r'\baccersendi\b', 'arcesso'),
    (r'\baccersendo\b', 'arcesso'),
    (r'\baccersendos\b', 'arcesso'),
    (r'\baccersendum\b', 'arcesso'),
    (r'\baccersendus\b', 'arcesso'),
    (r'\baccersens\b', 'arcesso'),
    (r'\baccersentibus\b', 'arcesso'),
    (r'\baccersere\b', 'arcesso'),
    (r'\baccerseremusne\b', 'arcesso'),
    (r'\baccerserent\b', 'arcesso'),
    (r'\baccerserentur\b', 'arcesso'),
    (r'\baccerserer\b', 'arcesso'),
    (r'\baccerseret\b', 'arcesso'),
    (r'\baccerseretur\b', 'arcesso'),
    (r'\baccerseris\b', 'arcesso'),
    (r'\baccerses\b', 'arcesso'),
    (r'\baccerset\b', 'arcesso'),
    (r'\baccersi\b', 'arcesso'),
    (r'\baccersiam\b', 'arcesso'),
    (r'\baccersiendum\b', 'arcesso'),
    (r'\baccersiens\b', 'arcesso'),
    (r'\baccersier\b', 'arcesso'),
    (r'\baccersimus\b', 'arcesso'),
    (r'\baccersire\b', 'arcesso'),
    (r'\baccersirent\b', 'arcesso'),
    (r'\baccersiret\b', 'arcesso'),
    (r'\baccersiri\b', 'arcesso'),
    (r'\baccersis\b', 'arcesso'),
    (r'\baccersisse\b', 'arcesso'),
    (r'\baccersisset\b', 'arcesso'),
    (r'\baccersistis\b', 'arcesso'),
    (r'\baccersit\b', 'arcesso'),
    (r'\baccersita\b', 'arcesso'),
    (r'\baccersitae\b', 'arcesso'),
    (r'\baccersitam\b', 'arcesso'),
    (r'\baccersite\b', 'arcesso'),
    (r'\baccersiti\b', 'arcesso'),
    (r'\baccersitis\b', 'arcesso'),
    (r'\baccersito\b', 'arcesso'),
    (r'\baccersitos\b', 'arcesso'),
    (r'\baccersitum\b', 'arcesso'),
    (r'\baccersitumque\b', 'arcesso'),
    (r'\baccersitur\b', 'arcesso'),
    (r'\baccersitus\b', 'arcesso'),
    (r'\baccersivit\b', 'arcesso'),
    (r'\baccerso\b', 'arcesso'),
    (r'\baccersor\b', 'arcesso'),
    (r'\baccersunt\b', 'arcesso'),
    (r'\baccersuntque\b', 'arcesso'),
    (r'\baccersuntur\b', 'arcesso'),
    (r'\baccessa\b', 'accessa'),
    (r'\baccessa\b', 'accedo'),
    (r'\baccessam\b', 'accessa'),
    (r'\baccessam\b', 'accedo'),
    (r'\baccesseram\b', 'accedo'),
    (r'\baccesseramus\b', 'accedo'),
    (r'\baccesserant\b', 'accedo'),
    (r'\baccesserat\b', 'accedo'),
    (r'\baccessere\b', 'accedo'),
    (r'\baccesserim\b', 'accedo'),
    (r'\baccesserimus\b', 'accedo'),
    (r'\baccesserint\b', 'accedo'),
    (r'\baccesseris\b', 'accedo'),
    (r'\baccesserit\b', 'accedo'),
    (r'\baccessero\b', 'accedo'),
    (r'\baccesserunt\b', 'accedo'),
    (r'\baccesseruntque\b', 'accedo'),
    (r'\baccesset\b', 'ad-curro'),
    (r'\baccessi\b', 'accedo'),
    (r'\baccessibus\b', 'accessus2'),
    (r'\baccessimus\b', 'accedo'),
    (r'\baccessio\b', 'accessio'),
    (r'\baccessione\b', 'accessio'),
    (r'\baccessionem\b', 'accessio'),
    (r'\baccessionemque\b', 'accessio'),
    (r'\baccessiones\b', 'accessio'),
    (r'\baccessionesque\b', 'accessio'),
    (r'\baccessioni\b', 'accessio'),
    (r'\baccessionibus\b', 'accessio'),
    (r'\baccessionis\b', 'accessio'),
    (r'\baccessionisue\b', 'accessio'),
    (r'\baccessionum\b', 'accessio'),
    (r'\baccessisse\b', 'accedo'),
    (r'\baccessissem\b', 'accedo'),
    (r'\baccessissemus\b', 'accedo'),
    (r'\baccessissent\b', 'accedo'),
    (r'\baccessisses\b', 'accedo'),
    (r'\baccessisset\b', 'accedo'),
    (r'\baccessisti\b', 'accedo'),
    (r'\baccessistis\b', 'accedo'),
    (r'\baccessit\b', 'accedo'),
    (r'\baccessitauere\b', 'accessito'),
    (r'\baccessitque\b', 'accedo'),
    (r'\baccessu\b', 'accessus2'),
    (r'\baccessu\b', 'accedo'),
    (r'\baccessum\b', 'accessus2'),
    (r'\baccessum\b', 'accedo'),
    (r'\baccessumque\b', 'accessus2'),
    (r'\baccessumque\b', 'accedo'),
    (r'\baccessuque\b', 'accessus2'),
    (r'\baccessuque\b', 'accedo'),
    (r'\baccessura\b', 'accedo'),
    (r'\baccessuram\b', 'accedo'),
    (r'\baccessuras\b', 'accedo'),
    (r'\baccessure\b', 'accedo'),
    (r'\baccessuri\b', 'accedo'),
    (r'\baccessuros\b', 'accedo'),
    (r'\baccessurum\b', 'accedo'),
    (r'\baccessurus\b', 'accedo'),
    (r'\baccessus\b', 'accessus2'),
    (r'\baccessus\b', 'accedo'),
    (r'\baccessusque\b', 'accessus2'),
    (r'\baccessusque\b', 'accedo'),
    (r'\bAcci\b', 'Attius'),
    (r'\bacci\b', 'accio'),
    (r'\bacciantur\b', 'accio'),
    (r'\baccibant\b', 'accio'),
    (r'\baccidam\b', 'accido1'),
    (r'\baccidant\b', 'accido1'),
    (r'\baccidas\b', 'accido1'),
    (r'\baccidat\b', 'accido1'),
    (r'\baccidebant\b', 'accido1'),
    (r'\baccidebat\b', 'accido1'),
    (r'\baccidens\b', 'accido1'),
    (r'\baccident\b', 'accido1'),
    (r'\baccidente\b', 'accido1'),
    (r'\baccidentem\b', 'accido1'),
    (r'\baccidentes\b', 'accido1'),
    (r'\baccidenti\b', 'accido1'),
    (r'\baccidentia\b', 'accidentia'),
    (r'\baccidentia\b', 'accido1'),
    (r'\baccidentibus\b', 'accido1'),
    (r'\baccidentis\b', 'accido1'),
    (r'\baccidentium\b', 'accido1'),
    (r'\bacciderant\b', 'accido1'),
    (r'\bacciderat\b', 'accido1'),
    (r'\baccidere\b', 'accido1'),
    (r'\bacciderent\b', 'accido1'),
    (r'\baccideret\b', 'accido1'),
    (r'\bacciderint\b', 'accido1'),
    (r'\bacciderit\b', 'accido1'),
    (r'\bacciderunt\b', 'accido1'),
    (r'\baccidet\b', 'accido1'),
    (r'\baccidisse\b', 'accido1'),
    (r'\baccidissent\b', 'accido1'),
    (r'\baccidisset\b', 'accido1'),
    (r'\baccidit\b', 'accido1'),
    (r'\bacciditque\b', 'accido1'),
    (r'\baccido\b', 'accido1'),
    (r'\baccidunt\b', 'accido1'),
    (r'\bacciduntque\b', 'accido1'),
    (r'\bacciebo\b', 'accieo'),
    (r'\baccienda\b', 'accieo'),
    (r'\bacciendo\b', 'accieo'),
    (r'\bacciendos\b', 'accieo'),
    (r'\bacciendum\b', 'accieo'),
    (r'\bacciendumque\b', 'accieo'),
    (r'\baccientur\b', 'accio'),
    (r'\baccientur\b', 'accieo'),
    (r'\bacciet\b', 'accio'),
    (r'\bacciet\b', 'accieo'),
    (r'\bAccii\b', 'Attius'),
    (r'\baccincta\b', 'accingo'),
    (r'\baccinctae\b', 'accingo'),
    (r'\baccinctaeque\b', 'accingo'),
    (r'\baccincti\b', 'accingo'),
    (r'\baccinctique\b', 'accingo'),
    (r'\baccinctis\b', 'accingo'),
    (r'\baccinctisque\b', 'accingo'),
    (r'\baccinctos\b', 'accingo'),
    (r'\baccinctum\b', 'accingo'),
    (r'\baccinctus\b', 'accingo'),
    (r'\baccinctusque\b', 'accingo'),
    (r'\baccingamur\b', 'accingo'),
    (r'\baccingar\b', 'accingo'),
    (r'\baccingatur\b', 'accingo'),
    (r'\baccinge\b', 'accingo'),
    (r'\baccingebantur\b', 'accingo'),
    (r'\baccingendum\b', 'accingo'),
    (r'\baccingens\b', 'accingo'),
    (r'\baccingent\b', 'accingo'),
    (r'\baccingentes\b', 'accingo'),
    (r'\baccingentur\b', 'accingo'),
    (r'\baccingere\b', 'accingo'),
    (r'\baccingerentur\b', 'accingo'),
    (r'\baccingeret\b', 'accingo'),
    (r'\baccingeretur\b', 'accingo'),
    (r'\baccingeris\b', 'accingo'),
    (r'\baccingetis\b', 'accingo'),
    (r'\baccingetur\b', 'accingo'),
    (r'\baccingi\b', 'accingo'),
    (r'\baccingier\b', 'accingo'),
    (r'\baccingimini\b', 'accingo'),
    (r'\baccingimur\b', 'accingo'),
    (r'\baccingit\b', 'accingo'),
    (r'\baccingite\b', 'accingo'),
    (r'\baccingitque\b', 'accingo'),
    (r'\baccingitur\b', 'accingo'),
    (r'\baccingor\b', 'accingo'),
    (r'\baccingunt\b', 'accingo'),
    (r'\baccinguntur\b', 'accingo'),
    (r'\baccinxerat\b', 'accingo'),
    (r'\baccinxerunt\b', 'accingo'),
    (r'\baccinxi\b', 'accingo'),
    (r'\baccinxisti\b', 'accingo'),
    (r'\baccinxit\b', 'accingo'),
    (r'\bAccio\b', 'Attius'),
    (r'\baccio\b', 'accio'),
    (r'\baccipe\b', 'accipio'),
    (r'\baccipere\b', 'accipio'),
    (r'\bacciperem\b', 'accipio'),
    (r'\bacciperemus\b', 'accipio'),
    (r'\bacciperent\b', 'accipio'),
    (r'\bacciperentque\b', 'accipio'),
    (r'\bacciperentur\b', 'accipio'),
    (r'\bacciperes\b', 'accipio'),
    (r'\bacciperet\b', 'accipio'),
    (r'\bacciperetis\b', 'accipio'),
    (r'\bacciperetque\b', 'accipio'),
    (r'\bacciperetur\b', 'accipio'),
    (r'\bacciperis\b', 'accipio'),
    (r'\baccipi\b', 'accipio'),
    (r'\baccipiam\b', 'accipio'),
    (r'\bAccipiam\b', 'Attius'),
    (r'\baccipiamur\b', 'accipio'),
    (r'\baccipiamus\b', 'accipio'),
    (r'\baccipiant\b', 'accipio'),
    (r'\baccipiantque\b', 'accipio'),
    (r'\baccipiantur\b', 'accipio'),
    (r'\baccipiar\b', 'accipio'),
    (r'\baccipias\b', 'accipio'),
    (r'\baccipiat\b', 'accipio'),
    (r'\baccipiatis\b', 'accipio'),
    (r'\baccipiatur\b', 'accipio'),
    (r'\baccipiebam\b', 'accipio'),
    (r'\baccipiebant\b', 'accipio'),
    (r'\baccipiebantur\b', 'accipio'),
    (r'\baccipiebas\b', 'accipio'),
    (r'\baccipiebat\b', 'accipio'),
    (r'\baccipiebatis\b', 'accipio'),
    (r'\baccipiebatur\b', 'accipio'),
    (r'\baccipiemus\b', 'accipio'),
    (r'\baccipien\b', 'accipio'),
    (r'\baccipienda\b', 'accipio'),
    (r'\baccipiendae\b', 'accipio'),
    (r'\baccipiendam\b', 'accipio'),
    (r'\baccipiendaque\b', 'accipio'),
    (r'\baccipiendarum\b', 'accipio'),
    (r'\baccipiendas\b', 'accipio'),
    (r'\baccipiendi\b', 'accipio'),
    (r'\baccipiendis\b', 'accipio'),
    (r'\baccipiendisque\b', 'accipio'),
    (r'\baccipiendo\b', 'accipio'),
    (r'\baccipiendoque\b', 'accipio'),
    (r'\baccipiendorum\b', 'accipio'),
    (r'\baccipiendos\b', 'accipio'),
    (r'\baccipiendum\b', 'accipio'),
    (r'\baccipiendumque\b', 'accipio'),
    (r'\baccipiendus\b', 'accipio'),
    (r'\baccipiens\b', 'accipio'),
    (r'\baccipient\b', 'accipio'),
    (r'\baccipiente\b', 'accipio'),
    (r'\baccipientem\b', 'accipio'),
    (r'\baccipientemque\b', 'accipio'),
    (r'\baccipientes\b', 'accipio'),
    (r'\baccipienti\b', 'accipio'),
    (r'\baccipientia\b', 'accipio'),
    (r'\baccipientibus\b', 'accipio'),
    (r'\baccipientis\b', 'accipio'),
    (r'\baccipientisque\b', 'accipio'),
    (r'\baccipientium\b', 'accipio'),
    (r'\baccipientque\b', 'accipio'),
    (r'\baccipientur\b', 'accipio'),
    (r'\baccipiere\b', 'accipio'),
    (r'\baccipies\b', 'accipio'),
    (r'\baccipiesque\b', 'accipio'),
    (r'\baccipiet\b', 'accipio'),
    (r'\baccipietis\b', 'accipio'),
    (r'\baccipietne\b', 'accipio'),
    (r'\baccipietur\b', 'accipio'),
    (r'\baccipimur\b', 'accipio'),
    (r'\baccipimus\b', 'accipio'),
    (r'\baccipimusque\b', 'accipio'),
    (r'\baccipin\b', 'accipio'),
    (r'\baccipio\b', 'accipio'),
    (r'\baccipioque\b', 'accipio'),
    (r'\baccipique\b', 'accipio'),
    (r'\baccipis\b', 'accipio'),
    (r'\baccipit\b', 'accipio'),
    (r'\baccipite\b', 'accipio'),
    (r'\baccipitis\b', 'accipio'),
    (r'\baccipito\b', 'accipio'),
    (r'\baccipitque\b', 'accipio'),
    (r'\baccipitrem\b', 'accipitro'),
    (r'\baccipitremque\b', 'accipitro'),
    (r'\baccipitres\b', 'accipitro'),
    (r'\baccipitret\b', 'accipitro'),
    (r'\baccipitrina\b', 'accipitrina'),
    (r'\baccipitur\b', 'accipio'),
    (r'\baccipiunda\b', 'accipio'),
    (r'\baccipiundis\b', 'accipio'),
    (r'\baccipiundo\b', 'accipio'),
    (r'\baccipiundum\b', 'accipio'),
    (r'\baccipiundumst\b', 'accipio'),
    (r'\baccipiunt\b', 'accipio'),
    (r'\baccipiuntque\b', 'accipio'),
    (r'\baccipiuntur\b', 'accipio'),
    (r'\baccire\b', 'accio'),
    (r'\baccirent\b', 'accio'),
    (r'\baccirentur\b', 'accio'),
    (r'\bacciret\b', 'accio'),
    (r'\bacciri\b', 'accio'),
    (r'\baccirique\b', 'accio'),
    (r'\baccisa\b', 'accido1'),
    (r'\baccisae\b', 'accido1'),
    (r'\baccisam\b', 'accido1'),
    (r'\baccisas\b', 'accido1'),
    (r'\baccisis\b', 'accido1'),
    (r'\bacciso\b', 'accido1'),
    (r'\baccisos\b', 'accido1'),
    (r'\baccisse\b', 'accio'),
    (r'\baccita\b', 'accio'),
    (r'\baccitae\b', 'accio'),
    (r'\baccitam\b', 'accio'),
    (r'\baccitaque\b', 'accio'),
    (r'\baccitarum\b', 'accio'),
    (r'\baccitas\b', 'accio'),
    (r'\baccite\b', 'accio'),
    (r'\bacciti\b', 'accio'),
    (r'\baccitique\b', 'accio'),
    (r'\baccitis\b', 'accio'),
    (r'\baccitisque\b', 'accio'),
    (r'\baccito\b', 'accio'),
    (r'\baccitoque\b', 'accio'),
    (r'\baccitos\b', 'accio'),
    (r'\baccitosque\b', 'accio'),
    (r'\baccitu\b', 'accitus2'),
    (r'\baccitu\b', 'accio'),
    (r'\baccitum\b', 'accitus2'),
    (r'\baccitum\b', 'accio'),
    (r'\baccitumque\b', 'accitus2'),
    (r'\baccitumque\b', 'accio'),
    (r'\baccitur\b', 'accio'),
    (r'\bacciturum\b', 'accio'),
    (r'\baccitus\b', 'accitus2'),
    (r'\baccitus\b', 'accio'),
    (r'\baccitusque\b', 'accitus2'),
    (r'\baccitusque\b', 'accio'),
    (r'\bacciuerant\b', 'accio'),
    (r'\bacciuerat\b', 'accio'),
    (r'\bacciuerint\b', 'accio'),
    (r'\bAccium\b', 'Attius'),
    (r'\bAccius\b', 'Attius'),
    (r'\bAcciusque\b', 'Attius'),
    (r'\bacciverat\b', 'accio'),
    (r'\baccivere\b', 'accio'),
    (r'\bacciverit\b', 'accio'),
    (r'\baccivi\b', 'accio'),
    (r'\baccivit\b', 'accio'),
    (r'\bacclamabamus\b', 'acclamo'),
    (r'\bacclamantibus\b', 'acclamo'),
    (r'\bacclamaretur\b', 'acclamo'),
    (r'\bacclamarunt\b', 'acclamo'),
    (r'\bacclamassent\b', 'acclamo'),
    (r'\bacclamasset\b', 'acclamo'),
    (r'\bacclamat\b', 'acclamo'),
    (r'\bacclamatio\b', 'acclamatio'),
    (r'\bacclamatione\b', 'acclamatio'),
    (r'\bacclamationes\b', 'acclamatio'),
    (r'\bacclamationibus\b', 'acclamatio'),
    (r'\bacclamationibusque\b', 'acclamatio'),
    (r'\bacclamationum\b', 'acclamatio'),
    (r'\bacclamatum\b', 'acclamo'),
    (r'\bacclametur\b', 'acclamo'),
    (r'\bacclinata\b', 'acclino'),
    (r'\bacclinaturos\b', 'acclino'),
    (r'\bacclinatus\b', 'acclino'),
    (r'\bacclinaverat\b', 'acclino'),
    (r'\bacclini\b', 'acclinis'),
    (r'\bacclinia\b', 'acclinis'),
    (r'\bacclinis\b', 'acclinis'),
    (r'\baccliue\b', 'acclivis'),
    (r'\baccliues\b', 'acclivis'),
    (r'\bacclivia\b', 'acclivis'),
    (r'\bacclivis\b', 'acclivis'),
    (r'\bacclivitate\b', 'acclivitas'),
    (r'\bAcco\b', 'Acco'),
    (r'\baccola\b', 'accola'),
    (r'\baccolae\b', 'accola'),
    (r'\baccolam\b', 'accola'),
    (r'\baccolam\b', 'accolo'),
    (r'\baccolarum\b', 'accola'),
    (r'\baccolas\b', 'accola'),
    (r'\baccolas\b', 'accolo'),
    (r'\baccolasque\b', 'accola'),
    (r'\baccolasque\b', 'accolo'),
    (r'\baccolentes\b', 'accolo'),
    (r'\baccolentibus\b', 'accolo'),
    (r'\baccolentis\b', 'accolo'),
    (r'\baccolentium\b', 'accolo'),
    (r'\baccolet\b', 'accolo'),
    (r'\baccolet\b', 'accola'),
    (r'\baccoli\b', 'accolo'),
    (r'\baccolis\b', 'accola'),
    (r'\baccolis\b', 'accolo'),
    (r'\baccolisque\b', 'accola'),
    (r'\baccolisque\b', 'accolo'),
    (r'\baccolit\b', 'accolo'),
    (r'\baccolitis\b', 'accolo'),
    (r'\baccolitur\b', 'accolo'),
    (r'\baccoluere\b', 'accolo'),
    (r'\baccolunt\b', 'accolo'),
    (r'\baccommoda\b', 'accommodus'),
    (r'\baccommoda\b', 'accommodo'),
    (r'\baccommodabat\b', 'accommodo'),
    (r'\baccommodabimus\b', 'accommodo'),
    (r'\baccommodabitur\b', 'accommodo'),
    (r'\baccommodabo\b', 'accommodo'),
    (r'\baccommodabuntur\b', 'accommodo'),
    (r'\baccommodamus\b', 'accommodo'),
    (r'\baccommodanda\b', 'accommodo'),
    (r'\baccommodandam\b', 'accommodo'),
    (r'\baccommodandis\b', 'accommodo'),
    (r'\baccommodandum\b', 'accommodo'),
    (r'\baccommodandus\b', 'accommodo'),
    (r'\baccommodans\b', 'accommodo'),
    (r'\baccommodant\b', 'accommodo'),
    (r'\baccommodantes\b', 'accommodo'),
    (r'\baccommodanti\b', 'accommodo'),
    (r'\baccommodantur\b', 'accommodo'),
    (r'\baccommodare\b', 'accommodo'),
    (r'\baccommodarent\b', 'accommodo'),
    (r'\baccommodarentur\b', 'accommodo'),
    (r'\baccommodares\b', 'accommodo'),
    (r'\baccommodaret\b', 'accommodo'),
    (r'\baccommodaretur\b', 'accommodo'),
    (r'\baccommodari\b', 'accommodo'),
    (r'\baccommodarimus\b', 'accommodo'),
    (r'\baccommodas\b', 'accommodus'),
    (r'\baccommodas\b', 'accommodo'),
    (r'\baccommodasse\b', 'accommodo'),
    (r'\baccommodassent\b', 'accommodo'),
    (r'\baccommodasset\b', 'accommodo'),
    (r'\baccommodasti\b', 'accommodo'),
    (r'\baccommodat\b', 'accommodo'),
    (r'\baccommodata\b', 'accommodo'),
    (r'\baccommodatae\b', 'accommodo'),
    (r'\baccommodatam\b', 'accommodo'),
    (r'\baccommodatarum\b', 'accommodo'),
    (r'\baccommodatas\b', 'accommodo'),
    (r'\baccommodate\b', 'accommodo'),
    (r'\baccommodati\b', 'accommodo'),
    (r'\baccommodatio\b', 'accommodatio'),
    (r'\baccommodatione\b', 'accommodatio'),
    (r'\baccommodatior\b', 'accommodo'),
    (r'\baccommodatiorem\b', 'accommodo'),
    (r'\baccommodatis\b', 'accommodo'),
    (r'\baccommodatissima\b', 'accommodo'),
    (r'\baccommodatissimam\b', 'accommodo'),
    (r'\baccommodatissime\b', 'accommodo'),
    (r'\baccommodatissimi\b', 'accommodo'),
    (r'\baccommodatissimum\b', 'accommodo'),
    (r'\baccommodatius\b', 'accommodo'),
    (r'\baccommodato\b', 'accommodo'),
    (r'\baccommodatum\b', 'accommodo'),
    (r'\baccommodatur\b', 'accommodo'),
    (r'\baccommodaturi\b', 'accommodo'),
    (r'\baccommodaturos\b', 'accommodo'),
    (r'\baccommodaturum\b', 'accommodo'),
    (r'\baccommodatus\b', 'accommodo'),
    (r'\baccommodauerat\b', 'accommodo'),
    (r'\baccommodauerint\b', 'accommodo'),
    (r'\baccommodauerit\b', 'accommodo'),
    (r'\baccommodauerunt\b', 'accommodo'),
    (r'\baccommodauit\b', 'accommodo'),
    (r'\baccommodaveris\b', 'accommodo'),
    (r'\baccommodaverunt\b', 'accommodo'),
    (r'\baccommodavi\b', 'accommodo'),
    (r'\baccommodavissem\b', 'accommodo'),
    (r'\baccommodavistis\b', 'accommodo'),
    (r'\baccommodavit\b', 'accommodo'),
    (r'\baccommodem\b', 'accommodo'),
    (r'\baccommodemus\b', 'accommodo'),
    (r'\baccommodent\b', 'accommodo'),
    (r'\baccommodentur\b', 'accommodo'),
    (r'\baccommodes\b', 'accommodo'),
    (r'\baccommodet\b', 'accommodo'),
    (r'\baccommodetis\b', 'accommodo'),
    (r'\baccommodetur\b', 'accommodo'),
    (r'\baccommodo\b', 'accommodus'),
    (r'\baccommodo\b', 'accommodo'),
    (r'\bAccone\b', 'Acco'),
    (r'\bAcconis\b', 'Acco'),
    (r'\baccredidit\b', 'accredo'),
    (r'\baccreduas\b', 'ad-curro'),
    (r'\baccrescat\b', 'accresco'),
    (r'\baccrescente\b', 'accresco'),
    (r'\baccrescere\b', 'accresco'),
    (r'\baccrescit\b', 'accresco'),
    (r'\baccrescunt\b', 'accresco'),
    (r'\baccreta\b', 'accresco'),
    (r'\baccreuerunt\b', 'accresco'),
    (r'\baccreverit\b', 'accresco'),
    (r'\baccrevit\b', 'accresco'),
    (r'\baccuba\b', 'accubo'),
    (r'\baccubabam\b', 'accubo'),
    (r'\baccubabant\b', 'accubo'),
    (r'\baccubabit\b', 'accubo'),
    (r'\baccubabo\b', 'accubo'),
    (r'\baccubabunt\b', 'accubo'),
    (r'\baccubamus\b', 'accubo'),
    (r'\baccubans\b', 'accubo'),
    (r'\baccubante\b', 'accubo'),
    (r'\baccubantem\b', 'accubo'),
    (r'\baccubantes\b', 'accubo'),
    (r'\baccubantesque\b', 'accubo'),
    (r'\baccubanti\b', 'accubo'),
    (r'\baccubantibus\b', 'accubo'),
    (r'\baccubantis\b', 'accubo'),
    (r'\baccubantium\b', 'accubo'),
    (r'\baccubare\b', 'accubo'),
    (r'\baccubarent\b', 'accubo'),
    (r'\baccubaret\b', 'accubo'),
    (r'\baccubas\b', 'accubo'),
    (r'\baccubat\b', 'accubo'),
    (r'\baccubent\b', 'accubo'),
    (r'\baccubes\b', 'accubo'),
    (r'\baccubet\b', 'accubo'),
    (r'\baccubitalium\b', 'accubitalia'),
    (r'\baccubitationes\b', 'accubitatio'),
    (r'\baccubitio\b', 'accubitio'),
    (r'\baccubitionem\b', 'accubitio'),
    (r'\baccubitis\b', 'accubitum'),
    (r'\baccubitis\b', 'accumbo'),
    (r'\baccubitor\b', 'accubito'),
    (r'\baccubitu\b', 'accubitus'),
    (r'\baccubitu\b', 'accumbo'),
    (r'\baccubitum\b', 'accubitus'),
    (r'\baccubitum\b', 'accubitum'),
    (r'\baccubitum\b', 'accumbo'),
    (r'\baccubitus\b', 'accubitus'),
    (r'\baccubitus\b', 'accumbo'),
    (r'\baccubo\b', 'accubo'),
    (r'\baccubueram\b', 'accumbo'),
    (r'\baccubuere\b', 'accumbo'),
    (r'\baccubueris\b', 'accumbo'),
    (r'\baccubuerit\b', 'accumbo'),
    (r'\baccubuerunt\b', 'accumbo'),
    (r'\baccubui\b', 'accumbo'),
    (r'\baccubuisse\b', 'accumbo'),
    (r'\baccubuissent\b', 'accumbo'),
    (r'\baccubuisset\b', 'accumbo'),
    (r'\baccubuisti\b', 'accumbo'),
    (r'\baccubuit\b', 'accumbo'),
    (r'\baccubuo\b', 'accubuo'),
    (r'\baccucurrerunt\b', 'accurro'),
    (r'\baccucurrimus\b', 'accurro'),
    (r'\baccucurrisse\b', 'accurro'),
    (r'\baccucurrit\b', 'accurro'),
    (r'\baccudere\b', 'accudo'),
    (r'\baccumbam\b', 'accumbo'),
    (r'\baccumbamus\b', 'accumbo'),
    (r'\baccumbant\b', 'accumbo'),
    (r'\baccumbas\b', 'accumbo'),
    (r'\baccumbat\b', 'accumbo'),
    (r'\baccumbe\b', 'accumbo'),
    (r'\baccumbebant\b', 'accumbo'),
    (r'\baccumbebat\b', 'accumbo'),
    (r'\baccumbent\b', 'accumbo'),
    (r'\baccumbentem\b', 'accumbo'),
    (r'\baccumbentes\b', 'accumbo'),
    (r'\baccumbenti\b', 'accumbo'),
    (r'\baccumbentis\b', 'accumbo'),
    (r'\baccumbere\b', 'accumbo'),
    (r'\baccumberem\b', 'accumbo'),
    (r'\baccumberent\b', 'accumbo'),
    (r'\baccumberes\b', 'accumbo'),
    (r'\baccumberet\b', 'accumbo'),
    (r'\baccumbes\b', 'accumbo'),
    (r'\baccumbet\b', 'accumbo'),
    (r'\baccumbimus\b', 'accumbo'),
    (r'\baccumbit\b', 'accumbo'),
    (r'\baccumbitque\b', 'accumbo'),
    (r'\baccumbo\b', 'accumbo'),
    (r'\baccumbunt\b', 'accumbo'),
    (r'\baccumula\b', 'accumulo'),
    (r'\baccumulabat\b', 'accumulo'),
    (r'\baccumulans\b', 'accumulo'),
    (r'\baccumulant\b', 'accumulo'),
    (r'\baccumulantes\b', 'accumulo'),
    (r'\baccumulare\b', 'accumulo'),
    (r'\baccumulari\b', 'accumulo'),
    (r'\baccumulat\b', 'accumulo'),
    (r'\baccumulatae\b', 'accumulo'),
    (r'\baccumulatque\b', 'accumulo'),
    (r'\baccumulatur\b', 'accumulo'),
    (r'\baccumulauit\b', 'accumulo'),
    (r'\baccumulem\b', 'accumulo'),
    (r'\baccumules\b', 'accumulo'),
    (r'\baccurabantur\b', 'accuro'),
    (r'\baccurabo\b', 'accuro'),
    (r'\baccurans\b', 'accuro'),
    (r'\baccurantur\b', 'accuro'),
    (r'\baccurare\b', 'accuro'),
    (r'\baccurari\b', 'accuro'),
    (r'\baccurarier\b', 'accuro'),
    (r'\baccurat\b', 'accuro'),
    (r'\baccurata\b', 'accuro'),
    (r'\baccuratae\b', 'accuro'),
    (r'\baccuratam\b', 'accuro'),
    (r'\baccuratas\b', 'accuro'),
    (r'\baccurate\b', 'accuro'),
    (r'\baccurateque\b', 'accuro'),
    (r'\baccuratio\b', 'accuratio'),
    (r'\baccuratior\b', 'accuro'),
    (r'\baccuratiore\b', 'accuro'),
    (r'\baccuratiorem\b', 'accuro'),
    (r'\baccuratis\b', 'accuro'),
    (r'\baccuratissima\b', 'accuro'),
    (r'\baccuratissimas\b', 'accuro'),
    (r'\baccuratissime\b', 'accuro'),
    (r'\baccuratissimis\b', 'accuro'),
    (r'\baccuratissimus\b', 'accuro'),
    (r'\baccuratissume\b', 'accuro'),
    (r'\baccuratius\b', 'accuro'),
    (r'\baccuratiusque\b', 'accuro'),
    (r'\baccurato\b', 'accuro'),
    (r'\baccuratum\b', 'accuro'),
    (r'\baccuravi\b', 'accuro'),
    (r'\baccuravit\b', 'accuro'),
    (r'\baccurentur\b', 'accuro'),
    (r'\baccures\b', 'accuro'),
    (r'\baccurram\b', 'accurro'),
    (r'\baccurrant\b', 'accurro'),
    (r'\baccurras\b', 'accurro'),
    (r'\baccurre\b', 'accurro'),
    (r'\baccurremus\b', 'accurro'),
    (r'\baccurrentis\b', 'accurro'),
    (r'\baccurrentium\b', 'accurro'),
    (r'\baccurrere\b', 'accurro'),
    (r'\baccurrerent\b', 'accurro'),
    (r'\baccurreret\b', 'accurro'),
    (r'\baccurrerunt\b', 'ad-curro'),
    (r'\baccurres\b', 'accurro'),
    (r'\baccurrisse\b', 'ad-curro'),
    (r'\baccurrisses\b', 'ad-curro'),
    (r'\baccurrisset\b', 'ad-curro'),
    (r'\baccurrit\b', 'accurro'),
    (r'\baccurrite\b', 'accurro'),
    (r'\baccurro\b', 'accurro'),
    (r'\baccurrunt\b', 'accurro'),
    (r'\baccurruntque\b', 'accurro'),
    (r'\baccursu\b', 'accursus'),
    (r'\baccursum\b', 'accursus'),
    (r'\baccursus\b', 'accursus'),
    (r'\baccusa\b', 'accuso'),
    (r'\baccusabam\b', 'accuso'),
    (r'\baccusabant\b', 'accuso'),
    (r'\baccusabantur\b', 'accuso'),
    (r'\baccusabar\b', 'accuso'),
    (r'\baccusabat\b', 'accuso'),
    (r'\baccusabatur\b', 'accuso'),
    (r'\baccusabilis\b', 'accusabilis'),
    (r'\baccusabimur\b', 'accuso'),
    (r'\baccusabis\b', 'accuso'),
    (r'\baccusabit\b', 'accuso'),
    (r'\baccusabitur\b', 'accuso'),
    (r'\baccusabo\b', 'accuso'),
    (r'\baccusabor\b', 'accuso'),
    (r'\baccusabunt\b', 'accuso'),
    (r'\baccusabuntur\b', 'accuso'),
    (r'\baccusamur\b', 'accuso'),
    (r'\baccusamus\b', 'accuso'),
    (r'\baccusanda\b', 'accuso'),
    (r'\baccusandam\b', 'accuso'),
    (r'\baccusandi\b', 'accuso'),
    (r'\baccusandis\b', 'accuso'),
    (r'\baccusando\b', 'accuso'),
    (r'\baccusandoque\b', 'accuso'),
    (r'\baccusandos\b', 'accuso'),
    (r'\baccusandum\b', 'accuso'),
    (r'\baccusandus\b', 'accuso'),
    (r'\baccusans\b', 'accuso'),
    (r'\baccusant\b', 'accuso'),
    (r'\baccusante\b', 'accuso'),
    (r'\baccusantem\b', 'accuso'),
    (r'\baccusantes\b', 'accuso'),
    (r'\baccusanti\b', 'accuso'),
    (r'\baccusantibus\b', 'accuso'),
    (r'\baccusantis\b', 'accuso'),
    (r'\baccusantium\b', 'accuso'),
    (r'\baccusantur\b', 'accuso'),
    (r'\baccusarat\b', 'accuso'),
    (r'\baccusare\b', 'accuso'),
    (r'\baccusarem\b', 'accuso'),
    (r'\baccusarent\b', 'accuso'),
    (r'\baccusarentur\b', 'accuso'),
    (r'\baccusareque\b', 'accuso'),
    (r'\baccusarer\b', 'accuso'),
    (r'\baccusares\b', 'accuso'),
    (r'\baccusaret\b', 'accuso'),
    (r'\baccusaretis\b', 'accuso'),
    (r'\baccusaretur\b', 'accuso'),
    (r'\baccusari\b', 'accuso'),
    (r'\baccusarint\b', 'accuso'),
    (r'\baccusaris\b', 'accuso'),
    (r'\baccusarit\b', 'accuso'),
    (r'\baccusarunt\b', 'accuso'),
    (r'\baccusas\b', 'accuso'),
    (r'\baccusasse\b', 'accuso'),
    (r'\baccusasses\b', 'accuso'),
    (r'\baccusasset\b', 'accuso'),
    (r'\baccusasti\b', 'accuso'),
    (r'\baccusastis\b', 'accuso'),
    (r'\baccusat\b', 'accuso'),
    (r'\baccusata\b', 'accuso'),
    (r'\baccusatae\b', 'accuso'),
    (r'\baccusatam\b', 'accuso'),
    (r'\baccusati\b', 'accuso'),
    (r'\baccusatio\b', 'accusatio'),
    (r'\baccusatione\b', 'accusatio'),
    (r'\baccusationem\b', 'accusatio'),
    (r'\baccusationemque\b', 'accusatio'),
    (r'\baccusationes\b', 'accusatio'),
    (r'\baccusationi\b', 'accusatio'),
    (r'\baccusationibus\b', 'accusatio'),
    (r'\baccusationis\b', 'accusatio'),
    (r'\baccusationum\b', 'accusatio'),
    (r'\baccusatis\b', 'accuso'),
    (r'\baccusatiui\b', 'accusativus'),
    (r'\baccusatiuo\b', 'accusativus'),
    (r'\baccusatius\b', 'accuso'),
    (r'\baccusatiuum\b', 'accusativus'),
    (r'\baccusativae\b', 'accusativus'),
    (r'\baccusativas\b', 'accusativus'),
    (r'\baccusativi\b', 'accusativus'),
    (r'\baccusativis\b', 'accusativus'),
    (r'\baccusativo\b', 'accusativus'),
    (r'\baccusativos\b', 'accusativus'),
    (r'\baccusativum\b', 'accusativus'),
    (r'\baccusativus\b', 'accusativus'),
    (r'\baccusato\b', 'accuso'),
    (r'\baccusator\b', 'accusator'),
    (r'\baccusatore\b', 'accusator'),
    (r'\baccusatorem\b', 'accusator'),
    (r'\baccusatoremne\b', 'accusator'),
    (r'\baccusatores\b', 'accusator'),
    (r'\baccusatoresque\b', 'accusator'),
    (r'\baccusatori\b', 'accusator'),
    (r'\baccusatori\b', 'accusatorius'),
    (r'\baccusatoria\b', 'accusatorius'),
    (r'\baccusatoriam\b', 'accusatorius'),
    (r'\baccusatoribus\b', 'accusator'),
    (r'\baccusatorie\b', 'accusatorius'),
    (r'\baccusatorio\b', 'accusatorius'),
    (r'\baccusatorios\b', 'accusatorius'),
    (r'\baccusatoris\b', 'accusator'),
    (r'\baccusatorque\b', 'accusator'),
    (r'\baccusatorum\b', 'accusator'),
    (r'\baccusatorum\b', 'accuso'),
    (r'\baccusatorumque\b', 'accusator'),
    (r'\baccusatorumque\b', 'accuso'),
    (r'\baccusatos\b', 'accuso'),
    (r'\baccusatote\b', 'accuso'),
    (r'\baccusatque\b', 'accuso'),
    (r'\baccusatrici\b', 'accusatrix'),
    (r'\baccusatricis\b', 'accusatrix'),
    (r'\baccusatrix\b', 'accusatrix'),
    (r'\baccusatum\b', 'accuso'),
    (r'\baccusatur\b', 'accuso'),
    (r'\baccusatura\b', 'accuso'),
    (r'\baccusaturos\b', 'accuso'),
    (r'\baccusaturum\b', 'accuso'),
    (r'\baccusaturus\b', 'accuso'),
    (r'\baccusatus\b', 'accuso'),
    (r'\baccusauerant\b', 'accuso'),
    (r'\baccusauerat\b', 'accuso'),
    (r'\baccusauerint\b', 'accuso'),
    (r'\baccusaueris\b', 'accuso'),
    (r'\baccusauerit\b', 'accuso'),
    (r'\baccusauerunt\b', 'accuso'),
    (r'\baccusaui\b', 'accuso'),
    (r'\baccusauimus\b', 'accuso'),
    (r'\baccusauit\b', 'accuso'),
    (r'\baccusaverant\b', 'accuso'),
    (r'\baccusaverat\b', 'accuso'),
    (r'\baccusaverim\b', 'accuso'),
    (r'\baccusaveris\b', 'accuso'),
    (r'\baccusaverit\b', 'accuso'),
    (r'\baccusaverunt\b', 'accuso'),
    (r'\baccusavi\b', 'accuso'),
    (r'\baccusavisti\b', 'accuso'),
    (r'\baccusavit\b', 'accuso'),
    (r'\baccusavitque\b', 'accuso'),
    (r'\baccusem\b', 'accuso'),
    (r'\baccusemus\b', 'accuso'),
    (r'\baccusent\b', 'accuso'),
    (r'\baccuser\b', 'accuso'),
    (r'\baccuseris\b', 'accuso'),
    (r'\baccuses\b', 'accuso'),
    (r'\baccuset\b', 'accuso'),
    (r'\baccusetis\b', 'accuso'),
    (r'\baccusetur\b', 'accuso'),
    (r'\baccusites\b', 'accusito'),
    (r'\baccuso\b', 'accuso'),
    (r'\baccusoque\b', 'accuso'),
    (r'\baccusor\b', 'accuso'),
    (r'\bAce\b', 'Ace'),
    (r'\bace\b', 'acus3'),
    (r'\bace\b', 'aceo'),
    (r'\baceant\b', 'aceo'),
    (r'\baceat\b', 'aceo'),
    (r'\bacediaberis\b', 'acedior'),
    (r'\bacedieris\b', 'acedior'),
    (r'\bAcen\b', 'Ace'),
    (r'\bacen\b', 'acus3'),
    (r'\bacen\b', 'aceo'),
    (r'\bacenteta\b', 'acentetus'),
    (r'\bacenteta\b', 'acentetus'),
    (r'\bacentetum\b', 'acentetus'),
    (r'\bacentetum\b', 'acentetus'),
    (r'\bacer\b', 'acer1'),
    (r'\bacer\b', 'acer1'),
    (r'\bacerba\b', 'acerbus'),
    (r'\bacerba\b', 'acerbus'),
    (r'\bacerba\b', 'acerbo'),
    (r'\bacerbae\b', 'acerbus'),
    (r'\bacerbam\b', 'acerbus'),
    (r'\bacerbamque\b', 'acerbus'),
    (r'\bacerbans\b', 'acerbo'),
    (r'\bacerbaque\b', 'acerbus'),
    (r'\bacerbaque\b', 'acerbus'),
    (r'\bacerbaque\b', 'acerbo'),
    (r'\bacerbareque\b', 'acerbo'),
    (r'\bacerbas\b', 'acerbus'),
    (r'\bacerbas\b', 'acerbo'),
    (r'\bacerbast\b', 'acerbus'),
    (r'\bacerbast\b', 'acerbus'),
    (r'\bacerbast\b', 'acerbo'),
    (r'\bacerbat\b', 'acerbo'),
    (r'\bacerbe\b', 'acerbus'),
    (r'\bacerbe\b', 'acerbus'),
    (r'\bacerbeque\b', 'acerbus'),
    (r'\bacerbeque\b', 'acerbus'),
    (r'\bacerbi\b', 'acerbus'),
    (r'\bacerbi\b', 'acerbus'),
    (r'\bacerbior\b', 'acerbus'),
    (r'\bacerbiora\b', 'acerbus'),
    (r'\bacerbioraque\b', 'acerbus'),
    (r'\bacerbiore\b', 'acerbus'),
    (r'\bacerbiorem\b', 'acerbus'),
    (r'\bacerbiores\b', 'acerbus'),
    (r'\bacerbioresque\b', 'acerbus'),
    (r'\bacerbis\b', 'acerbus'),
    (r'\bacerbis\b', 'acerbus'),
    (r'\bacerbissima\b', 'acerbus'),
    (r'\bacerbissimae\b', 'acerbus'),
    (r'\bacerbissimam\b', 'acerbus'),
    (r'\bacerbissimas\b', 'acerbus'),
    (r'\bacerbissime\b', 'acerbus'),
    (r'\bacerbissimeque\b', 'acerbus'),
    (r'\bacerbissimi\b', 'acerbus'),
    (r'\bacerbissimis\b', 'acerbus'),
    (r'\bacerbissimisque\b', 'acerbus'),
    (r'\bacerbissimo\b', 'acerbus'),
    (r'\bacerbissimoque\b', 'acerbus'),
    (r'\bacerbissimorum\b', 'acerbus'),
    (r'\bacerbissimos\b', 'acerbus'),
    (r'\bacerbissimum\b', 'acerbus'),
    (r'\bacerbissimus\b', 'acerbus'),
    (r'\bacerbissuma\b', 'acerbus'),
    (r'\bacerbissumas\b', 'acerbus'),
    (r'\bacerbitas\b', 'acerbitas'),
    (r'\bacerbitate\b', 'acerbitas'),
    (r'\bacerbitatem\b', 'acerbitas'),
    (r'\bacerbitateque\b', 'acerbitas'),
    (r'\bacerbitates\b', 'acerbitas'),
    (r'\bacerbitati\b', 'acerbitas'),
    (r'\bacerbitatibus\b', 'acerbitas'),
    (r'\bacerbitatis\b', 'acerbitas'),
    (r'\bacerbitudo\b', 'acerbitudo'),
    (r'\bacerbius\b', 'acerbus'),
    (r'\bacerbiusque\b', 'acerbus'),
    (r'\bacerbo\b', 'acerbus'),
    (r'\bacerbo\b', 'acerbus'),
    (r'\bacerbo\b', 'acerbo'),
    (r'\bacerborum\b', 'acerbus'),
    (r'\bacerborum\b', 'acerbus'),
    (r'\bacerbos\b', 'acerbus'),
    (r'\bacerbum\b', 'acerbus'),
    (r'\bacerbum\b', 'acerbus'),
    (r'\bacerbumque\b', 'acerbus'),
    (r'\bacerbumque\b', 'acerbus'),
    (r'\bacerbumst\b', 'acerbus'),
    (r'\bacerbumst\b', 'acerbus'),
    (r'\bacerbumve\b', 'acerbus'),
    (r'\bacerbumve\b', 'acerbus'),
    (r'\bacerbus\b', 'acerbus'),
    (r'\bacerbusque\b', 'acerbus'),
    (r'\bacere\b', 'acerus'),
    (r'\bacere\b', 'acer1'),
    (r'\bacere\b', 'aceo'),
    (r'\bacerem\b', 'aceo'),
    (r'\baceri\b', 'acerus'),
    (r'\baceri\b', 'acer1'),
    (r'\baceri\b', 'aceo'),
    (r'\baceris\b', 'acerus'),
    (r'\baceris\b', 'acer1'),
    (r'\baceris\b', 'aceo'),
    (r'\bacerna\b', 'acernus'),
    (r'\bacernae\b', 'acernus'),
    (r'\bacernam\b', 'acernus'),
    (r'\bacernas\b', 'acernus'),
    (r'\bacernis\b', 'acernus'),
    (r'\bacerno\b', 'acernus'),
    (r'\bacernus\b', 'acernus'),
    (r'\baceroso\b', 'acerosus'),
    (r'\bacerque\b', 'acer1'),
    (r'\bacerque\b', 'acer1'),
    (r'\bacerra\b', 'acerra'),
    (r'\bAcerrae\b', 'Acerrae'),
    (r'\bacerrae\b', 'acerra'),
    (r'\bacerram\b', 'acerra'),
    (r'\bAcerrani\b', 'acersecomes'),
    (r'\bAcerranis\b', 'acersecomes'),
    (r'\bAcerranorum\b', 'acersecomes'),
    (r'\bAcerranorumque\b', 'acersecomes'),
    (r'\bAcerranos\b', 'acersecomes'),
    (r'\bacerras\b', 'acerra'),
    (r'\bAcerras\b', 'Acerrae'),
    (r'\bacerrima\b', 'acer1'),
    (r'\bacerrimae\b', 'acer1'),
    (r'\bacerrimaeque\b', 'acer1'),
    (r'\bacerrimam\b', 'acer1'),
    (r'\bacerrimas\b', 'acer1'),
    (r'\bacerrime\b', 'acer1'),
    (r'\bacerrimeque\b', 'acer1'),
    (r'\bacerrimi\b', 'acer1'),
    (r'\bacerrimis\b', 'acer1'),
    (r'\bacerrimo\b', 'acer1'),
    (r'\bacerrimorum\b', 'acer1'),
    (r'\bacerrimos\b', 'acer1'),
    (r'\bacerrimum\b', 'acer1'),
    (r'\bacerrimumque\b', 'acer1'),
    (r'\bacerrimus\b', 'acer1'),
    (r'\bacerris\b', 'acerra'),
    (r'\bAcerris\b', 'Acerrae'),
    (r'\bAcerronio\b', 'acersecomes'),
    (r'\bAcerronium\b', 'acersecomes'),
    (r'\bAcerronius\b', 'acersecomes'),
    (r'\bacersecomes\b', 'acersecomes'),
    (r'\baceruans\b', 'acervo'),
    (r'\baceruantem\b', 'acervo'),
    (r'\baceruantur\b', 'acervo'),
    (r'\baceruat\b', 'acervo'),
    (r'\bacerui\b', 'acervus'),
    (r'\baceruis\b', 'acervus'),
    (r'\baceruo\b', 'acervus'),
    (r'\baceruo\b', 'acervo'),
    (r'\baceruos\b', 'acervus'),
    (r'\baceruum\b', 'acervus'),
    (r'\baceruumue\b', 'acervus'),
    (r'\baceruus\b', 'acervus'),
    (r'\bacerva\b', 'acervo'),
    (r'\bacervalem\b', 'acervalis'),
    (r'\bacervantur\b', 'acervo'),
    (r'\bacervat\b', 'acervo'),
    (r'\bacervata\b', 'acervo'),
    (r'\bacervatarum\b', 'acervo'),
    (r'\bacervati\b', 'acervo'),
    (r'\bacervatim\b', 'acervatim'),
    (r'\bacervatimque\b', 'acervatim'),
    (r'\bacervatio\b', 'acervatio'),
    (r'\bacervatis\b', 'acervo'),
    (r'\bacervatur\b', 'acervo'),
    (r'\bacerventur\b', 'acervo'),
    (r'\bacervi\b', 'acervus'),
    (r'\bacervis\b', 'acervus'),
    (r'\bacervisque\b', 'acervus'),
    (r'\bacervo\b', 'acervus'),
    (r'\bacervo\b', 'acervo'),
    (r'\bacervom\b', 'acervus'),
    (r'\bacervoque\b', 'acervus'),
    (r'\bacervoque\b', 'acervo'),
    (r'\bacervorum\b', 'acervus'),
    (r'\bacervos\b', 'acervus'),
    (r'\bacervum\b', 'acervus'),
    (r'\bacervus\b', 'acervus'),
    (r'\bAces\b', 'Ace'),
    (r'\baces\b', 'aceo'),
    (r'\bacesim\b', 'acesis'),
    (r'\bAcesinaque\b', 'Acesines'),
    (r'\bAcesinaque\b', 'Acesinus'),
    (r'\bacesinen\b', 'acesis'),
    (r'\bAcesinen\b', 'Acesines'),
    (r'\bAcesines\b', 'Acesines'),
    (r'\bAcesini\b', 'Acesines'),
    (r'\bAcesini\b', 'Acesinus'),
    (r'\bAcesinum\b', 'Acesinus'),
    (r'\bAcesinus\b', 'Acesinus'),
    (r'\bAcesta\b', 'Acesta'),
    (r'\bAcesta\b', 'Acestes'),
    (r'\bAcestae\b', 'Acesta'),
    (r'\bAcestae\b', 'Acestes'),
    (r'\bAcestam\b', 'Acesta'),
    (r'\bAcestam\b', 'Acestes'),
    (r'\bAceste\b', 'Acestes'),
    (r'\bAceste\b', 'Acestes'),
    (r'\bAcesten\b', 'Acestes'),
    (r'\bAcesten\b', 'Acestes'),
    (r'\bAcestensis\b', 'Acestes'),
    (r'\bAcestensium\b', 'Acestes'),
    (r'\bAcestes\b', 'Acestes'),
    (r'\bAcestes\b', 'Acestes'),
    (r'\bAcesti\b', 'Acestes'),
    (r'\bAcestis\b', 'Acesta'),
    (r'\bAcestis\b', 'Acestes'),
    (r'\bacet\b', 'aceo'),
    (r'\baceta\b', 'aceto'),
    (r'\bacetabula\b', 'acetabulum'),
    (r'\bacetabuli\b', 'acetabulum'),
    (r'\bacetabulis\b', 'acetabulum'),
    (r'\bacetabulo\b', 'acetabulum'),
    (r'\bacetabulum\b', 'acetabulum'),
    (r'\bacetaria\b', 'acetaria'),
    (r'\bacetariis\b', 'acetaria'),
    (r'\bacetat\b', 'aceto'),
    (r'\baceto\b', 'aceo'),
    (r'\baceto\b', 'aceto'),
    (r'\bacetoque\b', 'aceo'),
    (r'\bacetoque\b', 'aceto'),
    (r'\bacetove\b', 'aceo'),
    (r'\bacetove\b', 'aceto'),
    (r'\bAchae\b', 'Achaius'),
    (r'\bAchaea\b', 'Achaeus2'),
    (r'\bAchaeae\b', 'Achaeus2'),
    (r'\bAchaeas\b', 'Achaeus2'),
    (r'\bAchaei\b', 'Achaeus1'),
    (r'\bAchaei\b', 'Achaeus2'),
    (r'\bAchaeique\b', 'Achaeus1'),
    (r'\bAchaeique\b', 'Achaeus2'),
    (r'\bAchaeis\b', 'Achaeus1'),
    (r'\bAchaeis\b', 'Achaeus2'),
    (r'\bAchaemenes\b', 'Achaemenes'),
    (r'\bAchaemeniae\b', 'Achaemenius'),
    (r'\bAchaemenias\b', 'Achaemenius'),
    (r'\bachaemenide\b', 'achaemenis'),
    (r'\bAchaemenide\b', 'Achaemenides'),
    (r'\bachaemeniden\b', 'achaemenis'),
    (r'\bAchaemeniden\b', 'Achaemenides'),
    (r'\bachaemenides\b', 'achaemenis'),
    (r'\bAchaemenides\b', 'Achaemenides'),
    (r'\bachaemenidis\b', 'achaemenis'),
    (r'\bAchaemenidis\b', 'Achaemenides'),
    (r'\bAchaemeniis\b', 'Achaemenius'),
    (r'\bAchaemenio\b', 'Achaemenius'),
    (r'\bachaemenis\b', 'achaemenis'),
    (r'\bAchaemenis\b', 'Achaemenes'),
    (r'\bAchaemenium\b', 'Achaemenius'),
    (r'\bAchaemeniumque\b', 'Achaemenius'),
    (r'\bAchaemenius\b', 'Achaemenius'),
    (r'\bAchaeo\b', 'Achaeus1'),
    (r'\bAchaeo\b', 'Achaeus2'),
    (r'\bAchaeon\b', 'Achaeus1'),
    (r'\bAchaeon\b', 'Achaeus2'),
    (r'\bAchaeorum\b', 'Achaeus1'),
    (r'\bAchaeorum\b', 'Achaeus2'),
    (r'\bAchaeos\b', 'Achaeus1'),
    (r'\bAchaeti\b', 'Achaetus'),
    (r'\bAchaeum\b', 'Achaeus1'),
    (r'\bAchaeum\b', 'Achaeus2'),
    (r'\bAchaeus\b', 'Achaeus1'),
    (r'\bAchai\b', 'Achaius'),
    (r'\bAchai\b', 'Achaius'),
    (r'\bAchaia\b', 'Achaia'),
    (r'\bAchaia\b', 'Achaius'),
    (r'\bAchaiae\b', 'Achaia'),
    (r'\bAchaiam\b', 'Achaia'),
    (r'\bAchaiamque\b', 'Achaia'),
    (r'\bAchaica\b', 'Achaius'),
    (r'\bAchaicae\b', 'Achaius'),
    (r'\bAchaicam\b', 'Achaius'),
    (r'\bAchaici\b', 'Achaius'),
    (r'\bAchaicis\b', 'Achaius'),
    (r'\bAchaico\b', 'Achaius'),
    (r'\bAchaicum\b', 'Achaius'),
    (r'\bAchaicus\b', 'Achaius'),
    (r'\bAchaide\b', 'Achaius'),
    (r'\bAcharnae\b', 'Acharnae'),
    (r'\bacharnae\b', 'acharne'),
    (r'\bacharne\b', 'acharne'),
    (r'\bAcharras\b', 'Acharrae'),
    (r'\bAchata\b', 'Achates2'),
    (r'\bachata\b', 'achates'),
    (r'\bAchatae\b', 'Achates2'),
    (r'\bachatae\b', 'achates'),
    (r'\bAchate\b', 'Achates2'),
    (r'\bachate\b', 'achates'),
    (r'\bAchaten\b', 'Achates2'),
    (r'\bachaten\b', 'achates'),
    (r'\bAchates\b', 'Achates2'),
    (r'\bachates\b', 'achates'),
    (r'\bachati\b', 'achates'),
    (r'\bAchati\b', 'Achates2'),
    (r'\bAcheloe\b', 'Achelous'),
    (r'\bAcheloi\b', 'Achelous'),
    (r'\bAcheloi\b', 'Acheloius'),
    (r'\bAcheloia\b', 'Acheloius'),
    (r'\bAcheloiadumque\b', 'Acheloias'),
    (r'\bAcheloiaque\b', 'Acheloius'),
    (r'\bAcheloias\b', 'Acheloius'),
    (r'\bAcheloias\b', 'Acheloias'),
    (r'\bAcheloides\b', 'Achelois'),
    (r'\bAchelois\b', 'Achelois'),
    (r'\bAchelois\b', 'Achelous'),
    (r'\bAcheloium\b', 'Acheloius'),
    (r'\bAcheloius\b', 'Acheloius'),
    (r'\bAcheloo\b', 'Achelous'),
    (r'\bAcheloon\b', 'Achelous'),
    (r'\bAcheloum\b', 'Achelous'),
    (r'\bAchelous\b', 'Achelous'),
    (r'\bAcheron\b', 'Acheron'),
    (r'\bAcheronte\b', 'Acheron'),
    (r'\bAcherontem\b', 'Acheron'),
    (r'\bAcheronti\b', 'Acheron'),
    (r'\bAcherontis\b', 'Acheron'),
    (r'\bAcheruns\b', 'Acheruns'),
    (r'\bAcherunte\b', 'Acheruns'),
    (r'\bAcheruntem\b', 'Acheruns'),
    (r'\bAcheruntest\b', 'Acheruns'),
    (r'\bAcherunti\b', 'Acheruns'),
    (r'\bAcherunticas\b', 'Acherusia'),
    (r'\bAcherunticus\b', 'Acherusia'),
    (r'\bAcheruntis\b', 'Acheruns'),
    (r'\bAcherusia\b', 'Acherusia'),
    (r'\bAcherusia\b', 'Acherusius'),
    (r'\bAcherusiam\b', 'Acherusia'),
    (r'\bAcherusio\b', 'Acherusius'),
    (r'\bAcherusium\b', 'Acherusius'),
    (r'\bAcherusius\b', 'Acherusius'),
    (r'\bachetae\b', 'acheta'),
    (r'\bAchilla\b', 'Achillas'),
    (r'\bAchillae\b', 'Achillas'),
    (r'\bAchillam\b', 'Achillas'),
    (r'\bAchillan\b', 'Achillas'),
    (r'\bAchillas\b', 'Achillas'),
    (r'\bAchille\b', 'Achilles'),
    (r'\bachillea\b', 'achillea'),
    (r'\bAchillea\b', 'Achillides'),
    (r'\bachilleae\b', 'achillea'),
    (r'\bAchilleae\b', 'Achillides'),
    (r'\bachilleas\b', 'achillea'),
    (r'\bAchilleas\b', 'Achillides'),
    (r'\bachillei\b', 'achilleos'),
    (r'\bAchillei\b', 'Achillides'),
    (r'\bachilleis\b', 'achillea'),
    (r'\bAchilleis\b', 'Achilleis'),
    (r'\bAchilleis\b', 'Achillides'),
    (r'\bAchillem\b', 'Achilles'),
    (r'\bAchillen\b', 'Achilles'),
    (r'\bachilleo\b', 'achilleos'),
    (r'\bAchilleo\b', 'Achillides'),
    (r'\bachilleon\b', 'achilleos'),
    (r'\bAchilleon\b', 'Achillides'),
    (r'\bachilleos\b', 'achilleos'),
    (r'\bAchilleos\b', 'Achillides'),
    (r'\bAchilles\b', 'Achilles'),
    (r'\bAchilleus\b', 'Achillides'),
    (r'\bAchilli\b', 'Achilles'),
    (r'\bAchilliden\b', 'Achillides'),
    (r'\bAchillides\b', 'Achillides'),
    (r'\bAchillis\b', 'Achillas'),
    (r'\bAchillis\b', 'Achilles'),
    (r'\bAchiua\b', 'Achivus'),
    (r'\bAchiuae\b', 'Achivus'),
    (r'\bAchiui\b', 'Achivus'),
    (r'\bAchiuis\b', 'Achivus'),
    (r'\bAchiuom\b', 'Achivus'),
    (r'\bAchiuorum\b', 'Achivus'),
    (r'\bAchiuos\b', 'Achivus'),
    (r'\bAchiuum\b', 'Achivus'),
    (r'\bAchiva\b', 'Achivus'),
    (r'\bAchivae\b', 'Achivus'),
    (r'\bAchivam\b', 'Achivus'),
    (r'\bAchivi\b', 'Achivus'),
    (r'\bAchivis\b', 'Achivus'),
    (r'\bAchivo\b', 'Achivus'),
    (r'\bAchivom\b', 'Achivus'),
    (r'\bAchivorum\b', 'Achivus'),
    (r'\bAchivos\b', 'Achivus'),
    (r'\bAchivum\b', 'Achivus'),
    (r'\bachli\b', 'achlis'),
    (r'\bachlin\b', 'achlis'),
    (r'\bachor\b', 'achor'),
    (r'\bAchradina\b', 'Achradina'),
    (r'\bAchradinae\b', 'Achradina'),
    (r'\bAchradinam\b', 'Achradina'),
    (r'\baci\b', 'acus3'),
    (r'\baci\b', 'acieris'),
    (r'\bacia\b', 'acia'),
    (r'\baciam\b', 'acia'),
    (r'\baciam\b', 'acieris'),
    (r'\baciamque\b', 'acia'),
    (r'\baciamque\b', 'acieris'),
    (r'\bacian\b', 'acia'),
    (r'\bacian\b', 'acieris'),
    (r'\bacias\b', 'acia'),
    (r'\bacias\b', 'acieris'),
    (r'\baciasque\b', 'acia'),
    (r'\baciasque\b', 'acieris'),
    (r'\bacida\b', 'acidus'),
    (r'\bacidae\b', 'acidus'),
    (r'\bAcidalia\b', 'Acidalia'),
    (r'\bAcidalia\b', 'acide'),
    (r'\bAcidaliae\b', 'Acidalia'),
    (r'\bAcidalio\b', 'acide'),
    (r'\bacidam\b', 'acidus'),
    (r'\bacidam\b', 'acide'),
    (r'\bacidane\b', 'acidus'),
    (r'\bacidas\b', 'acidus'),
    (r'\bacidas\b', 'acide'),
    (r'\bacide\b', 'acidus'),
    (r'\bacide\b', 'acide'),
    (r'\bacidi\b', 'acidus'),
    (r'\bacidi\b', 'acide'),
    (r'\bAcidini\b', 'Acidinus'),
    (r'\bAcidino\b', 'Acidinus'),
    (r'\bAcidinos\b', 'Acidinus'),
    (r'\bAcidinum\b', 'Acidinus'),
    (r'\bAcidinus\b', 'Acidinus'),
    (r'\bacidior\b', 'acidus'),
    (r'\bAcidis\b', 'Acis2'),
    (r'\bAcidis\b', 'acipensis'),
    (r'\bacidis\b', 'acidus'),
    (r'\bacidis\b', 'acide'),
    (r'\bacidissumi\b', 'acidus'),
    (r'\bacidius\b', 'acidus'),
    (r'\bacido\b', 'acidus'),
    (r'\bacido\b', 'acide'),
    (r'\bacidoque\b', 'acidus'),
    (r'\bacidoque\b', 'acide'),
    (r'\bacidos\b', 'acidus'),
    (r'\bacidula\b', 'acidulus'),
    (r'\bacidulo\b', 'acidulus'),
    (r'\bAcidum\b', 'Acis2'),
    (r'\bAcidum\b', 'acipensis'),
    (r'\bacidum\b', 'acidus'),
    (r'\bacidumque\b', 'acidus'),
    (r'\bacidus\b', 'acidus'),
    (r'\bacie\b', 'acies'),
    (r'\bacie\b', 'acieris'),
    (r'\baciebus\b', 'acies'),
    (r'\baciei\b', 'acies'),
    (r'\baciem\b', 'acies'),
    (r'\baciemque\b', 'acies'),
    (r'\baciemus\b', 'acieris'),
    (r'\bacieque\b', 'acies'),
    (r'\bacieque\b', 'acieris'),
    (r'\bacieris\b', 'acieris'),
    (r'\bacies\b', 'acies'),
    (r'\bacies\b', 'acieris'),
    (r'\baciesque\b', 'acies'),
    (r'\baciesque\b', 'acieris'),
    (r'\bAcili\b', 'Acilius'),
    (r'\bAcilia\b', 'Acilius'),
    (r'\bAciliae\b', 'Acilius'),
    (r'\bAciliam\b', 'Acilius'),
    (r'\bAciliani\b', 'Acilianus'),
    (r'\bAciliano\b', 'Acilianus'),
    (r'\bAcilianos\b', 'Acilianus'),
    (r'\bAcilianus\b', 'Acilianus'),
    (r'\bAcilii\b', 'Acilius'),
    (r'\bAcilio\b', 'Acilius'),
    (r'\bAcilium\b', 'Acilius'),
    (r'\bAcilius\b', 'Acilius'),
    (r'\bAcin\b', 'Ace'),
    (r'\bAcin\b', 'Acis2'),
    (r'\bacin\b', 'acus3'),
    (r'\bAcin\b', 'acipensis'),
    (r'\bacin\b', 'acer1'),
    (r'\bacin\b', 'acieris'),
    (r'\bacina\b', 'acinus'),
    (r'\bacinace\b', 'acinaces'),
    (r'\bacinacem\b', 'acinaces'),
    (r'\bacinacen\b', 'acinaces'),
    (r'\bacinaces\b', 'acinaces'),
    (r'\bacinacis\b', 'acinaces'),
    (r'\bacinaria\b', 'acinarius'),
    (r'\bacini\b', 'acinos'),
    (r'\bacini\b', 'acinus'),
    (r'\bacini\b', 'acinus'),
    (r'\bacinique\b', 'acinos'),
    (r'\bacinique\b', 'acinus'),
    (r'\bacinique\b', 'acinus'),
    (r'\bacinis\b', 'acinos'),
    (r'\bacinis\b', 'acinus'),
    (r'\bacinis\b', 'acinus'),
    (r'\bacino\b', 'acinos'),
    (r'\bacino\b', 'acinus'),
    (r'\bacino\b', 'acinus'),
    (r'\bacinon\b', 'acinos'),
    (r'\bacinon\b', 'acinus'),
    (r'\bacinon\b', 'acinus'),
    (r'\bacinorum\b', 'acinos'),
    (r'\bacinorum\b', 'acinus'),
    (r'\bacinorum\b', 'acinus'),
    (r'\bacinos\b', 'acinos'),
    (r'\bacinos\b', 'acinus'),
    (r'\bacinosi\b', 'acinosus'),
    (r'\bacinosque\b', 'acinos'),
    (r'\bacinosque\b', 'acinus'),
    (r'\bacinosum\b', 'acinosus'),
    (r'\bacinum\b', 'acinos'),
    (r'\bacinum\b', 'acinus'),
    (r'\bacinum\b', 'acinus'),
    (r'\bacinus\b', 'acinus'),
    (r'\bacipensem\b', 'acipensis'),
    (r'\bacipensis\b', 'acipensis'),
    (r'\bacirim\b', 'acieris'),
    (r'\bAcis\b', 'Ace'),
    (r'\bAcis\b', 'Acis2'),
    (r'\bacis\b', 'acus3'),
    (r'\bAcis\b', 'acipensis'),
    (r'\bacis\b', 'acer1'),
    (r'\bacis\b', 'acieris'),
    (r'\bacisculum\b', 'acisculus'),
    (r'\bacite\b', 'acieris'),
    (r'\baciti\b', 'acieris'),
    (r'\baciunt\b', 'acieris'),
    (r'\baclyde\b', 'aclys'),
    (r'\baclydes\b', 'aclys'),
    (r'\baclydis\b', 'aclys'),
    (r'\bAcme\b', 'Acmon'),
    (r'\bAcmen\b', 'Acmon'),
    (r'\bAcmon\b', 'Acmon'),
    (r'\bAcmonenses\b', 'Acmonensis'),
    (r'\bAcmonensibus\b', 'Acmonensis'),
    (r'\bAcmonensis\b', 'Acmonensis'),
    (r'\bAcmonensium\b', 'Acmonensis'),
    (r'\bAcmonidesque\b', 'Acmonides'),
    (r'\bacnua\b', 'acnua'),
    (r'\baco\b', 'acus3'),
    (r'\bacoenonoetus\b', 'acoenonoetus'),
    (r'\bacoete\b', 'acoetis'),
    (r'\bacoeten\b', 'acoetis'),
    (r'\bacoetes\b', 'acoetis'),
    (r'\bacoeti\b', 'acoetis'),
    (r'\bacoetin\b', 'acoetis'),
    (r'\bacoetis\b', 'acoetis'),
    (r'\baconas\b', 'aconae'),
    (r'\bacondit\b', 'aconiti'),
    (r'\bacone\b', 'acus3'),
    (r'\baconita\b', 'aconitum'),
    (r'\baconitaque\b', 'aconitum'),
    (r'\baconiti\b', 'aconiti'),
    (r'\baconiti\b', 'aconitum'),
    (r'\baconito\b', 'aconitum'),
    (r'\baconito\b', 'aconiti'),
    (r'\baconiton\b', 'aconitum'),
    (r'\baconiton\b', 'aconiti'),
    (r'\baconitum\b', 'aconitum'),
    (r'\bAconti\b', 'Acontius'),
    (r'\bacontiae\b', 'acontias'),
    (r'\bacontiae\b', 'acontias'),
    (r'\bAcontius\b', 'Acontius'),
    (r'\bAcontizomenos\b', 'Acontizomenos'),
    (r'\bacopa\b', 'acopos'),
    (r'\bAcopa\b', 'acor'),
    (r'\bacopi\b', 'acopos'),
    (r'\bacopi\b', 'acopos'),
    (r'\bAcopi\b', 'acor'),
    (r'\bacopis\b', 'acopos'),
    (r'\bacopis\b', 'acopos'),
    (r'\bacopo\b', 'acopos'),
    (r'\bacopo\b', 'acopos'),
    (r'\bacopos\b', 'acopos'),
    (r'\bacopum\b', 'acopos'),
    (r'\bAcopum\b', 'acor'),
    (r'\bacopum\b', 'acopos'),
    (r'\bacopumque\b', 'acopos'),
    (r'\bacopumque\b', 'acopos'),
    (r'\bacor\b', 'acor'),
    (r'\bacore\b', 'acorum'),
    (r'\bacore\b', 'acor'),
    (r'\bacore\b', 'acorum'),
    (r'\bacorem\b', 'acor'),
    (r'\bacoremue\b', 'acor'),
    (r'\bacoren\b', 'acorum'),
    (r'\bacoren\b', 'acor'),
    (r'\bacoren\b', 'acorum'),
    (r'\bacori\b', 'acorum'),
    (r'\bacori\b', 'acor'),
    (r'\bacori\b', 'acorum'),
    (r'\bacoribus\b', 'acor'),
    (r'\bacoris\b', 'acorum'),
    (r'\bacoris\b', 'acor'),
    (r'\bacoris\b', 'acorum'),
    (r'\bacorna\b', 'acorna'),
    (r'\bacoro\b', 'acorum'),
    (r'\bacoro\b', 'acorum'),
    (r'\bacoron\b', 'acorum'),
    (r'\bacoron\b', 'acorum'),
    (r'\bacorum\b', 'acorum'),
    (r'\bacorum\b', 'acor'),
    (r'\bacorum\b', 'acorum'),
    (r'\bacos\b', 'acus3'),
    (r'\bacquiescam\b', 'acquiesco'),
    (r'\bacquiescamus\b', 'acquiesco'),
    (r'\bacquiescente\b', 'acquiesco'),
    (r'\bacquiescentis\b', 'acquiesco'),
    (r'\bacquiescere\b', 'acquiesco'),
    (r'\bacquiescerem\b', 'acquiesco'),
    (r'\bacquiesceret\b', 'acquiesco'),
    (r'\bacquiescet\b', 'acquiesco'),
    (r'\bacquiescimus\b', 'acquiesco'),
    (r'\bacquiesco\b', 'acquiesco'),
    (r'\bacquiescunt\b', 'acquiesco'),
    (r'\bacquieturum\b', 'acquiesco'),
    (r'\bacquieuerunt\b', 'acquiesco'),
    (r'\bacquieuisset\b', 'acquiesco'),
    (r'\bacquieuit\b', 'acquiesco'),
    (r'\bacquieveram\b', 'acquiesco'),
    (r'\bacquievi\b', 'acquiesco'),
    (r'\bacquirant\b', 'acquiro'),
    (r'\bacquirat\b', 'acquiro'),
    (r'\bacquirendas\b', 'acquiro'),
    (r'\bacquirendi\b', 'acquiro'),
    (r'\bacquirendo\b', 'acquiro'),
    (r'\bacquirendum\b', 'acquiro'),
    (r'\bacquirere\b', 'acquiro'),
    (r'\bacquirerem\b', 'acquiro'),
    (r'\bacquiritur\b', 'acquiro'),
    (r'\bacra\b', 'acra'),
    (r'\bAcrae\b', 'Acrae'),
    (r'\bacrae\b', 'acra'),
    (r'\bAcraeam\b', 'Acraeus'),
    (r'\bAcraei\b', 'Acraeus'),
    (r'\bAcraephiae\b', 'Acraephia'),
    (r'\bAcraephiam\b', 'Acraephia'),
    (r'\bAcragantis\b', 'Acragas1'),
    (r'\bAcragas\b', 'Acragas1'),
    (r'\bAcran\b', 'Acrae'),
    (r'\bacran\b', 'acra'),
    (r'\bAcras\b', 'Acrae'),
    (r'\bacras\b', 'acra'),
    (r'\bacrato\b', 'acra'),
    (r'\bacratophoris\b', 'acratophorum'),
    (r'\bacratophoro\b', 'acratophorum'),
    (r'\bacratum\b', 'acra'),
    (r'\bacre\b', 'acer1'),
    (r'\bacredinem\b', 'acredo'),
    (r'\bacredula\b', 'acredula'),
    (r'\bacrem\b', 'acer1'),
    (r'\bacrem\b', 'acra'),
    (r'\bacremque\b', 'acer1'),
    (r'\bacremque\b', 'acra'),
    (r'\bacres\b', 'acer1'),
    (r'\bacres\b', 'acra'),
    (r'\bacresque\b', 'acer1'),
    (r'\bacresque\b', 'acra'),
    (r'\bacri\b', 'acer1'),
    (r'\bacria\b', 'acer1'),
    (r'\bacribus\b', 'acer1'),
    (r'\bacriculus\b', 'acriculus'),
    (r'\bacrifolium\b', 'acrifolium'),
    (r'\bAcriis\b', 'Acriae'),
    (r'\bAcrillas\b', 'Acrillae'),
    (r'\bacrimonia\b', 'acrimonia'),
    (r'\bacrimoniae\b', 'acrimonia'),
    (r'\bacrimoniam\b', 'acrimonia'),
    (r'\bacrimonias\b', 'acrimonia'),
    (r'\bacrimoniis\b', 'acrimonia'),
    (r'\bacrior\b', 'acer1'),
    (r'\bacriora\b', 'acer1'),
    (r'\bacriore\b', 'acer1'),
    (r'\bacriorem\b', 'acer1'),
    (r'\bacrioremque\b', 'acer1'),
    (r'\bacriores\b', 'acer1'),
    (r'\bacrioresque\b', 'acer1'),
    (r'\bacriori\b', 'acer1'),
    (r'\bacrioribus\b', 'acer1'),
    (r'\bacrioris\b', 'acer1'),
    (r'\bacriorque\b', 'acer1'),
    (r'\bacrique\b', 'acer1'),
    (r'\bAcris\b', 'Acrae'),
    (r'\bacris\b', 'acra'),
    (r'\bacris\b', 'acer1'),
    (r'\bAcrisi\b', 'Acrisius'),
    (r'\bAcrisii\b', 'Acrisius'),
    (r'\bAcrisio\b', 'Acrisius'),
    (r'\bAcrisione\b', 'Acrisione'),
    (r'\bAcrisioneas\b', 'Acrisioneus'),
    (r'\bAcrisioneis\b', 'Acrisioneus'),
    (r'\bAcrisioneos\b', 'Acrisioneus'),
    (r'\bAcrisioniades\b', 'Acrisioniades'),
    (r'\bAcrisium\b', 'Acrisius'),
    (r'\bAcrisius\b', 'Acrisius'),
    (r'\bAcrisiusque\b', 'Acrisius'),
    (r'\bacritan\b', 'acritas1'),
    (r'\bAcritan\b', 'Acritas2'),
    (r'\bacritas\b', 'acritas1'),
    (r'\bAcritas\b', 'Acritas2'),
    (r'\bacriter\b', 'acriter'),
    (r'\bacriterque\b', 'acriter'),
    (r'\bacritudine\b', 'acritudo'),
    (r'\bacritudinem\b', 'acritudo'),
    (r'\bacritudo\b', 'acritudo'),
    (r'\bacrium\b', 'acer1'),
    (r'\bacrius\b', 'acer1'),
    (r'\bacriusque\b', 'acer1'),
    (r'\bacro\b', 'acro'),
    (r'\bacro\b', 'acra'),
    (r'\bacroama\b', 'acroama'),
    (r'\bacroamata\b', 'acroama'),
    (r'\bacroamatibus\b', 'acroama'),
    (r'\bacroasi\b', 'acroasis'),
    (r'\bacroasin\b', 'acroasis'),
    (r'\bacroasis\b', 'acroasis'),
    (r'\bacroaticas\b', 'acroaticus'),
    (r'\bacroatici\b', 'acroaticus'),
    (r'\bacroaticos\b', 'acroaticus'),
    (r'\bAcroceraunia\b', 'Acroceraunia'),
    (r'\bAcrocerauniis\b', 'Acroceraunia'),
    (r'\bAcroceraunium\b', 'Acroceraunia'),
    (r'\bacrochordon\b', 'acrochordon'),
    (r'\bAcrocorintho\b', 'Acrocorinthus'),
    (r'\bAcrocorinthon\b', 'Acrocorinthus'),
    (r'\bAcrocorinthos\b', 'Acrocorinthus'),
    (r'\bAcrocorinthum\b', 'Acrocorinthus'),
    (r'\bacrolithon\b', 'acrolithus'),
    (r'\bAcron\b', 'Acron'),
    (r'\bacron\b', 'acro'),
    (r'\bacron\b', 'acra'),
    (r'\bacrone\b', 'acro'),
    (r'\bAcrone\b', 'Acron'),
    (r'\bacronem\b', 'acro'),
    (r'\bacronum\b', 'acro'),
    (r'\bAcronum\b', 'Acron'),
    (r'\bacropodio\b', 'acropodium'),
    (r'\bAcrota\b', 'Acrota'),
    (r'\bacroteria\b', 'acroteria'),
    (r'\bacrum\b', 'acra'),
    (r'\bacta\b', 'acta1'),
    (r'\bActa\b', 'Acte2'),
    (r'\bacta\b', 'acta1'),
    (r'\bacta\b', 'ago'),
    (r'\bactae\b', 'acta1'),
    (r'\bActae\b', 'Acte2'),
    (r'\bactae\b', 'ago'),
    (r'\bActaea\b', 'actaea'),
    (r'\bactaea\b', 'actaea'),
    (r'\bActaea\b', 'Actaeus'),
    (r'\bActaeae\b', 'actaea'),
    (r'\bactaeae\b', 'actaea'),
    (r'\bActaeam\b', 'actaea'),
    (r'\bactaeam\b', 'actaea'),
    (r'\bActaeaque\b', 'actaea'),
    (r'\bactaeaque\b', 'actaea'),
    (r'\bActaeaque\b', 'Actaeus'),
    (r'\bActaeas\b', 'actaea'),
    (r'\bactaeas\b', 'actaea'),
    (r'\bActaei\b', 'Actaeon'),
    (r'\bActaei\b', 'Actaeus'),
    (r'\bActaeis\b', 'actaea'),
    (r'\bactaeis\b', 'actaea'),
    (r'\bActaeis\b', 'Actaeon'),
    (r'\bActaeis\b', 'Actaeus'),
    (r'\bActaeo\b', 'Actaeus'),
    (r'\bActaeon\b', 'Actaeon'),
    (r'\bActaeone\b', 'Actaeon'),
    (r'\bActaeonem\b', 'Actaeon'),
    (r'\bActaeonis\b', 'Actaeon'),
    (r'\bActaeorum\b', 'Actaeon'),
    (r'\bActaeorum\b', 'Actaeus'),
    (r'\bActaeos\b', 'Actaeon'),
    (r'\bactaeque\b', 'acta1'),
    (r'\bactaeque\b', 'ago'),
    (r'\bActaeus\b', 'Actaeus'),
    (r'\bactam\b', 'acta1'),
    (r'\bactam\b', 'ago'),
    (r'\bactaque\b', 'acta1'),
    (r'\bactaque\b', 'acta1'),
    (r'\bactaque\b', 'ago'),
    (r'\bactarum\b', 'acta1'),
    (r'\bactarum\b', 'ago'),
    (r'\bactas\b', 'acta1'),
    (r'\bactas\b', 'ago'),
    (r'\bactast\b', 'acta1'),
    (r'\bactast\b', 'acta1'),
    (r'\bactast\b', 'ago'),
    (r'\bacte\b', 'acte1'),
    (r'\bActe\b', 'Acte2'),
    (r'\bacte\b', 'actum'),
    (r'\bacte\b', 'ago'),
    (r'\bacten\b', 'acte1'),
    (r'\bActen\b', 'Acte2'),
    (r'\bactes\b', 'acte1'),
    (r'\bActes\b', 'Acte2'),
    (r'\bacti\b', 'actum'),
    (r'\bacti\b', 'ago'),
    (r'\bActia\b', 'Actius1'),
    (r'\bActia\b', 'Actium'),
    (r'\bActiaque\b', 'Actius1'),
    (r'\bActiaque\b', 'Actium'),
    (r'\bActias\b', 'Actius1'),
    (r'\bActias\b', 'Actias'),
    (r'\bactibus\b', 'actus2'),
    (r'\bActii\b', 'Actius1'),
    (r'\bActii\b', 'Actium'),
    (r'\bactin\b', 'acta1'),
    (r'\bactin\b', 'acta1'),
    (r'\bactin\b', 'actum'),
    (r'\bactin\b', 'ago'),
    (r'\bactio\b', 'actio'),
    (r'\bActio\b', 'Actius1'),
    (r'\bActio\b', 'Actium'),
    (r'\baction\b', 'actio'),
    (r'\bAction\b', 'Actius1'),
    (r'\bAction\b', 'Actium'),
    (r'\bactione\b', 'actio'),
    (r'\bActione\b', 'Actius1'),
    (r'\bActione\b', 'Actium'),
    (r'\bactionem\b', 'actio'),
    (r'\bactionemque\b', 'actio'),
    (r'\bactionemue\b', 'actio'),
    (r'\bactionemve\b', 'actio'),
    (r'\bactiones\b', 'actio'),
    (r'\bactionesque\b', 'actio'),
    (r'\bactioneue\b', 'actio'),
    (r'\bactioni\b', 'actio'),
    (r'\bactionibus\b', 'actio'),
    (r'\bactionibusque\b', 'actio'),
    (r'\bactionique\b', 'actio'),
    (r'\bactionis\b', 'actio'),
    (r'\bactionum\b', 'actio'),
    (r'\bactionumque\b', 'actio'),
    (r'\bactioque\b', 'actio'),
    (r'\bactis\b', 'acta1'),
    (r'\bActis\b', 'Acte2'),
    (r'\bactis\b', 'acta1'),
    (r'\bactis\b', 'ago'),
    (r'\bactisque\b', 'acta1'),
    (r'\bactisque\b', 'acta1'),
    (r'\bactisque\b', 'ago'),
    (r'\bactitando\b', 'actito'),
    (r'\bactitant\b', 'actito'),
    (r'\bactitare\b', 'actito'),
    (r'\bactitasse\b', 'actito'),
    (r'\bactitat\b', 'actito'),
    (r'\bactitata\b', 'actito'),
    (r'\bactitaui\b', 'actito'),
    (r'\bactitauit\b', 'actito'),
    (r'\bactitavisset\b', 'actito'),
    (r'\bactitavit\b', 'actito'),
    (r'\bactito\b', 'actito'),
    (r'\bactiua\b', 'activus'),
    (r'\bactiuae\b', 'activus'),
    (r'\bActium\b', 'Actius1'),
    (r'\bActium\b', 'Actium'),
    (r'\bactiunculas\b', 'actiuncula'),
    (r'\bactius\b', 'ago'),
    (r'\bActius\b', 'Actius1'),
    (r'\bactiva\b', 'activus'),
    (r'\bactivae\b', 'activus'),
    (r'\bactivam\b', 'activus'),
    (r'\bactivi\b', 'activus'),
    (r'\bactivis\b', 'activus'),
    (r'\bactivo\b', 'activus'),
    (r'\bactivorum\b', 'activus'),
    (r'\bactivum\b', 'activus'),
    (r'\bacto\b', 'actum'),
    (r'\bacto\b', 'ago'),
    (r'\bActor\b', 'Actor2'),
    (r'\bactor\b', 'actor1'),
    (r'\bactore\b', 'actor1'),
    (r'\bactorem\b', 'actor1'),
    (r'\bActorem\b', 'Actor2'),
    (r'\bactoremque\b', 'actor1'),
    (r'\bactores\b', 'actor1'),
    (r'\bActores\b', 'Actor2'),
    (r'\bactori\b', 'actor1'),
    (r'\bActori\b', 'Actor2'),
    (r'\bActori\b', 'Actorius2'),
    (r'\bactori\b', 'actorius1'),
    (r'\bactoribus\b', 'actor1'),
    (r'\bActoridae\b', 'actorius1'),
    (r'\bActoridaeque\b', 'actorius1'),
    (r'\bActoriden\b', 'actorius1'),
    (r'\bActorides\b', 'actorius1'),
    (r'\bactoris\b', 'actor1'),
    (r'\bActoris\b', 'Actor2'),
    (r'\bactorius\b', 'actorius1'),
    (r'\bActorius\b', 'Actorius2'),
    (r'\bActorque\b', 'Actor2'),
    (r'\bactorque\b', 'actor1'),
    (r'\bactorum\b', 'actor1'),
    (r'\bActorum\b', 'Actor2'),
    (r'\bactorum\b', 'acta1'),
    (r'\bactorum\b', 'ago'),
    (r'\bactos\b', 'ago'),
    (r'\bactosque\b', 'ago'),
    (r'\bactu\b', 'actus2'),
    (r'\bactu\b', 'ago'),
    (r'\bactuari\b', 'actuarius1'),
    (r'\bactuari\b', 'actuarium'),
    (r'\bactuaria\b', 'actuaria'),
    (r'\bactuaria\b', 'actuarium'),
    (r'\bactuariae\b', 'actuaria'),
    (r'\bactuariam\b', 'actuaria'),
    (r'\bactuarias\b', 'actuaria'),
    (r'\bactuarii\b', 'actuarius1'),
    (r'\bactuarii\b', 'actuarium'),
    (r'\bactuariis\b', 'actuaria'),
    (r'\bactuariis\b', 'actuarius1'),
    (r'\bactuariis\b', 'actuarium'),
    (r'\bactuario\b', 'actuarius1'),
    (r'\bactuario\b', 'actuarium'),
    (r'\bactuariola\b', 'actuariolum'),
    (r'\bactuariolis\b', 'actuariolum'),
    (r'\bactuarios\b', 'actuarius1'),
    (r'\bactuarium\b', 'actuarius1'),
    (r'\bactuarium\b', 'actuarium'),
    (r'\bactuarius\b', 'actuarius1'),
    (r'\bactui\b', 'actus2'),
    (r'\bactum\b', 'actus2'),
    (r'\bactum\b', 'acta1'),
    (r'\bactum\b', 'actum'),
    (r'\bactum\b', 'ago'),
    (r'\bactumque\b', 'actus2'),
    (r'\bactumque\b', 'acta1'),
    (r'\bactumque\b', 'actum'),
    (r'\bactumque\b', 'ago'),
    (r'\bactumst\b', 'actus2'),
    (r'\bactumst\b', 'acta1'),
    (r'\bactumst\b', 'actum'),
    (r'\bactumst\b', 'ago'),
    (r'\bactuosa\b', 'actuosus'),
    (r'\bactuosae\b', 'actuosus'),
    (r'\bactuosam\b', 'actuosus'),
    (r'\bactuose\b', 'actuosus'),
    (r'\bactuose\b', 'actuose'),
    (r'\bactuosior\b', 'actuosus'),
    (r'\bactuosus\b', 'actuosus'),
    (r'\bactuque\b', 'actus2'),
    (r'\bactuque\b', 'ago'),
    (r'\bactura\b', 'ago'),
    (r'\bacturae\b', 'ago'),
    (r'\bacturam\b', 'ago'),
    (r'\bacturi\b', 'ago'),
    (r'\bacturique\b', 'ago'),
    (r'\bacturis\b', 'ago'),
    (r'\bacturo\b', 'ago'),
    (r'\bacturos\b', 'ago'),
    (r'\bacturum\b', 'ago'),
    (r'\bacturumque\b', 'ago'),
    (r'\bacturus\b', 'ago'),
    (r'\bacturusque\b', 'ago'),
    (r'\bacturust\b', 'ago'),
    (r'\bactus\b', 'actus2'),
    (r'\bactus\b', 'ago'),
    (r'\bactusque\b', 'actus2'),
    (r'\bactusque\b', 'ago'),
    (r'\bactusue\b', 'actus2'),
    (r'\bactusue\b', 'ago'),
    (r'\bactutum\b', 'actutum'),
    (r'\bactuum\b', 'actus2'),
    (r'\bacu\b', 'acus1'),
    (r'\bacuam\b', 'acuo'),
    (r'\bacuant\b', 'acuo'),
    (r'\bacuat\b', 'acuo'),
    (r'\bacuatque\b', 'acuo'),
    (r'\bacubus\b', 'acus1'),
    (r'\bacue\b', 'acuo'),
    (r'\bacuebant\b', 'acuo'),
    (r'\bacuebantur\b', 'acuo'),
    (r'\bacuebat\b', 'acuo'),
    (r'\bacuenda\b', 'acuo'),
    (r'\bacuendaeque\b', 'acuo'),
    (r'\bacuendam\b', 'acuo'),
    (r'\bacuendi\b', 'acuo'),
    (r'\bacuendis\b', 'acuo'),
    (r'\bacuendo\b', 'acuo'),
    (r'\bacuendos\b', 'acuo'),
    (r'\bacuens\b', 'acuo'),
    (r'\bacuent\b', 'acuo'),
    (r'\bacuentes\b', 'acuo'),
    (r'\bacuentibus\b', 'acuo'),
    (r'\bacuentibusque\b', 'acuo'),
    (r'\bacueram\b', 'aceo'),
    (r'\bacuere\b', 'acuo'),
    (r'\bacuere\b', 'aceo'),
    (r'\bacueremus\b', 'acuo'),
    (r'\bacuerent\b', 'acuo'),
    (r'\bacueret\b', 'acuo'),
    (r'\bacueretur\b', 'acuo'),
    (r'\bacueris\b', 'acuo'),
    (r'\bacueris\b', 'aceo'),
    (r'\bacuerit\b', 'aceo'),
    (r'\bacuero\b', 'aceo'),
    (r'\bacuerunt\b', 'aceo'),
    (r'\bacuet\b', 'acuo'),
    (r'\bacuetur\b', 'acuo'),
    (r'\bacui\b', 'acus1'),
    (r'\bacui\b', 'aceo'),
    (r'\bacui\b', 'acuo'),
    (r'\bacuis\b', 'acuo'),
    (r'\bacuisse\b', 'aceo'),
    (r'\bacuisses\b', 'aceo'),
    (r'\bacuit\b', 'aceo'),
    (r'\bacuit\b', 'acuo'),
    (r'\bacuite\b', 'acuo'),
    (r'\bacuito\b', 'acuo'),
    (r'\bacuitque\b', 'aceo'),
    (r'\bacuitque\b', 'acuo'),
    (r'\bacuitur\b', 'acuo'),
    (r'\bacula\b', 'acula'),
    (r'\baculam\b', 'acula'),
    (r'\baculeata\b', 'aculeatus'),
    (r'\baculeatam\b', 'aculeatus'),
    (r'\baculeatarum\b', 'aculeatus'),
    (r'\baculeatas\b', 'aculeatus'),
    (r'\baculeati\b', 'aculeatus'),
    (r'\baculeatique\b', 'aculeatus'),
    (r'\baculeatis\b', 'aculeatus'),
    (r'\baculeato\b', 'aculeatus'),
    (r'\baculeatorum\b', 'aculeatus'),
    (r'\baculeatos\b', 'aculeatus'),
    (r'\baculeatum\b', 'aculeatus'),
    (r'\baculei\b', 'aculeus'),
    (r'\baculeis\b', 'aculeus'),
    (r'\baculeo\b', 'aculeus'),
    (r'\bAculeo\b', 'Aculeo'),
    (r'\bAculeone\b', 'Aculeo'),
    (r'\baculeone\b', 'aculeus'),
    (r'\bAculeonem\b', 'Aculeo'),
    (r'\bAculeonis\b', 'Aculeo'),
    (r'\baculeos\b', 'aculeus'),
    (r'\baculeum\b', 'aculeus'),
    (r'\baculeus\b', 'aculeus'),
    (r'\bacum\b', 'acus1'),
    (r'\bacum\b', 'acus3'),
    (r'\bacumen\b', 'acumen'),
    (r'\bacumina\b', 'acumen'),
    (r'\bacumina\b', 'acumino'),
    (r'\bacuminatos\b', 'acumino'),
    (r'\bacuminatum\b', 'acumino'),
    (r'\bacumine\b', 'acumen'),
    (r'\bacumini\b', 'acumen'),
    (r'\bacuminibus\b', 'acumen'),
    (r'\bacuminibusque\b', 'acumen'),
    (r'\bacuminis\b', 'acumen'),
    (r'\bacuo\b', 'acuo'),
    (r'\bacus\b', 'acus1'),
    (r'\bacus\b', 'acus3'),
    (r'\bacus\b', 'acus2'),
    (r'\bAcusilas\b', 'Acusilas'),
    (r'\bacuta\b', 'acutus'),
    (r'\bacuta\b', 'acuo'),
    (r'\bacutae\b', 'acutus'),
    (r'\bacutae\b', 'acuo'),
    (r'\bacutaeque\b', 'acutus'),
    (r'\bacutaeque\b', 'acuo'),
    (r'\bacutam\b', 'acutus'),
    (r'\bacutam\b', 'acuo'),
    (r'\bacutarum\b', 'acutus'),
    (r'\bacutarum\b', 'acutarus'),
    (r'\bacutarum\b', 'acuo'),
    (r'\bacutas\b', 'acutus'),
    (r'\bacutas\b', 'acuo'),
    (r'\bacute\b', 'acutus'),
    (r'\bacute\b', 'acuo'),
    (r'\bacuteque\b', 'acutus'),
    (r'\bacuteque\b', 'acuo'),
    (r'\bacuti\b', 'acutus'),
    (r'\bacuti\b', 'acuo'),
    (r'\bAcutiliano\b', 'acutor'),
    (r'\bAcutilio\b', 'acutor'),
    (r'\bAcutio\b', 'acutor'),
    (r'\bacutior\b', 'acuo'),
    (r'\bacutiora\b', 'acuo'),
    (r'\bacutiore\b', 'acuo'),
    (r'\bacutiorem\b', 'acuo'),
    (r'\bacutiores\b', 'acuo'),
    (r'\bacutiorque\b', 'acuo'),
    (r'\bacutique\b', 'acutus'),
    (r'\bacutique\b', 'acuo'),
    (r'\bacutis\b', 'acutus'),
    (r'\bacutis\b', 'acuo'),
    (r'\bacutisque\b', 'acutus'),
    (r'\bacutisque\b', 'acuo'),
    (r'\bacutissima\b', 'acuo'),
    (r'\bacutissimam\b', 'acuo'),
    (r'\bacutissime\b', 'acuo'),
    (r'\bacutissimi\b', 'acuo'),
    (r'\bacutissimis\b', 'acuo'),
    (r'\bacutissimo\b', 'acuo'),
    (r'\bacutissimum\b', 'acuo'),
    (r'\bacutissimus\b', 'acuo'),
    (r'\bacutissumis\b', 'acuo'),
    (r'\bacutius\b', 'acuo'),
    (r'\bAcutius\b', 'acutor'),
    (r'\bacuto\b', 'acutus'),
    (r'\bacuto\b', 'acuo'),
    (r'\bacutoque\b', 'acutus'),
    (r'\bacutoque\b', 'acuo'),
    (r'\bacutorum\b', 'acutor'),
    (r'\bacutorum\b', 'acutus'),
    (r'\bacutorum\b', 'acuo'),
    (r'\bacutos\b', 'acutus'),
    (r'\bacutos\b', 'acuo'),
    (r'\bacutosque\b', 'acutus'),
    (r'\bacutosque\b', 'acuo'),
    (r'\bacutulas\b', 'acutulus'),
    (r'\bacutulis\b', 'acutulus'),
    (r'\bacutum\b', 'acutus'),
    (r'\bacutum\b', 'acuo'),
    (r'\bacutumque\b', 'acutus'),
    (r'\bacutumque\b', 'acuo'),
    (r'\bacutus\b', 'acutus'),
    (r'\bacutus\b', 'acuo'),
    (r'\bacuum\b', 'acus1'),
    (r'\bacuunt\b', 'acuo'),
    (r'\bacuuntque\b', 'acuo'),
    (r'\bacuuntur\b', 'acuo'),
    (r'\bacven\b', 'atque'),
    (r'\bacyrologia\b', 'acyrologia'),
    (r'\bacyrologiam\b', 'acyrologia'),
    (r'\bad\b', 'ad'),
    (r'\bada\b', 'ador'),
    (r'\badacta\b', 'adigo'),
    (r'\badactae\b', 'adigo'),
    (r'\badactam\b', 'adigo'),
    (r'\badacti\b', 'adigo'),
    (r'\badactionem\b', 'adactio'),
    (r'\badactis\b', 'adigo'),
    (r'\badacto\b', 'adigo'),
    (r'\badactos\b', 'adigo'),
    (r'\badactosque\b', 'adigo'),
    (r'\badactum\b', 'adactus2'),
    (r'\badactum\b', 'adigo'),
    (r'\badacturum\b', 'adigo'),
    (r'\badactus\b', 'adactus2'),
    (r'\badactus\b', 'adigo'),
    (r'\badactusque\b', 'adactus2'),
    (r'\badactusque\b', 'adigo'),
    (r'\badaequabant\b', 'adaequo'),
    (r'\badaequabat\b', 'adaequo'),
    (r'\badaequabitur\b', 'adaequo'),
    (r'\badaequabo\b', 'adaequo'),
    (r'\badaequamus\b', 'adaequo'),
    (r'\badaequanda\b', 'adaequo'),
    (r'\badaequandam\b', 'adaequo'),
    (r'\badaequant\b', 'adaequo'),
    (r'\badaequare\b', 'adaequo'),
    (r'\badaequarent\b', 'adaequo'),
    (r'\badaequarentur\b', 'adaequo'),
    (r'\badaequaret\b', 'adaequo'),
    (r'\badaequarunt\b', 'adaequo'),
    (r'\badaequastis\b', 'adaequo'),
    (r'\badaequat\b', 'adaequo'),
    (r'\badaequata\b', 'adaequo'),
    (r'\badaequati\b', 'adaequo'),
    (r'\badaequatis\b', 'adaequo'),
    (r'\badaequato\b', 'adaequo'),
    (r'\badaequatus\b', 'adaequo'),
    (r'\badaequauimus\b', 'adaequo'),
    (r'\badaequauit\b', 'adaequo'),
    (r'\badaequaverit\b', 'adaequo'),
    (r'\badaequaverunt\b', 'adaequo'),
    (r'\badaequavit\b', 'adaequo'),
    (r'\badaeque\b', 'adaeque'),
    (r'\badaequetur\b', 'adaequo'),
    (r'\badaestuat\b', 'adaestuo'),
    (r'\badaggerantur\b', 'adaggero'),
    (r'\badaggerari\b', 'adaggero'),
    (r'\badaggeratam\b', 'adaggero'),
    (r'\badaggeratis\b', 'adaggero'),
    (r'\badaggerato\b', 'adaggero'),
    (r'\badagio\b', 'adagio'),
    (r'\badagio\b', 'adagium'),
    (r'\badagium\b', 'adagium'),
    (r'\badaias\b', 'ad-aio'),
    (r'\badali\b', 'ad-alo'),
    (r'\badalligandas\b', 'adalligo'),
    (r'\badalligandum\b', 'adalligo'),
    (r'\badalligant\b', 'adalligo'),
    (r'\badalligantes\b', 'adalligo'),
    (r'\badalligantur\b', 'adalligo'),
    (r'\badalligare\b', 'adalligo'),
    (r'\badalligari\b', 'adalligo'),
    (r'\badalligat\b', 'adalligo'),
    (r'\badalligata\b', 'adalligo'),
    (r'\badalligatae\b', 'adalligo'),
    (r'\badalligataeque\b', 'adalligo'),
    (r'\badalligatam\b', 'adalligo'),
    (r'\badalligatas\b', 'adalligo'),
    (r'\badalligati\b', 'adalligo'),
    (r'\badalligatique\b', 'adalligo'),
    (r'\badalligatis\b', 'adalligo'),
    (r'\badalligatisque\b', 'adalligo'),
    (r'\badalligato\b', 'adalligo'),
    (r'\badalligatos\b', 'adalligo'),
    (r'\badalligatum\b', 'adalligo'),
    (r'\badalligatumque\b', 'adalligo'),
    (r'\badalligatur\b', 'adalligo'),
    (r'\badalligatus\b', 'adalligo'),
    (r'\badalligatusque\b', 'adalligo'),
    (r'\badalligavere\b', 'adalligo'),
    (r'\badalligaverit\b', 'adalligo'),
    (r'\badalligavit\b', 'adalligo'),
    (r'\badalligent\b', 'adalligo'),
    (r'\badalligetur\b', 'adalligo'),
    (r'\badalligeturve\b', 'adalligo'),
    (r'\badama\b', 'adamo'),
    (r'\badamans\b', 'adamo'),
    (r'\badamant\b', 'adamo'),
    (r'\badamante\b', 'adamas'),
    (r'\badamante\b', 'adamo'),
    (r'\badamanteis\b', 'adamanteus'),
    (r'\badamantem\b', 'adamas'),
    (r'\badamantem\b', 'adamo'),
    (r'\badamanteo\b', 'adamanteus'),
    (r'\badamanti\b', 'adamas'),
    (r'\badamanti\b', 'adamo'),
    (r'\badamantide\b', 'adamantis'),
    (r'\badamantina\b', 'adamantinus'),
    (r'\badamantinae\b', 'adamantinus'),
    (r'\badamantinis\b', 'adamantinus'),
    (r'\badamantino\b', 'adamantinus'),
    (r'\badamantinos\b', 'adamantinus'),
    (r'\badamantis\b', 'adamantis'),
    (r'\badamantis\b', 'adamas'),
    (r'\badamantis\b', 'adamo'),
    (r'\badamaram\b', 'adamo'),
    (r'\badamarat\b', 'adamo'),
    (r'\badamare\b', 'adamo'),
    (r'\badamarent\b', 'adamo'),
    (r'\badamaret\b', 'adamo'),
    (r'\badamari\b', 'adamo'),
    (r'\badamaris\b', 'adamo'),
    (r'\badamarit\b', 'adamo'),
    (r'\badamas\b', 'adamas'),
    (r'\badamas\b', 'adamo'),
    (r'\badamasse\b', 'adamo'),
    (r'\badamassem\b', 'adamo'),
    (r'\badamassent\b', 'adamo'),
    (r'\badamasset\b', 'adamo'),
    (r'\badamasti\b', 'adamo'),
    (r'\badamastis\b', 'adamo'),
    (r'\badamat\b', 'adamo'),
    (r'\badamata\b', 'adamo'),
    (r'\badamatae\b', 'adamo'),
    (r'\badamatam\b', 'adamo'),
    (r'\badamati\b', 'adamo'),
    (r'\badamatisque\b', 'adamo'),
    (r'\badamato\b', 'adamo'),
    (r'\badamatum\b', 'adamo'),
    (r'\badamatur\b', 'adamo'),
    (r'\badamatura\b', 'adamo'),
    (r'\badamatus\b', 'adamo'),
    (r'\badamauerat\b', 'adamo'),
    (r'\badamauit\b', 'adamo'),
    (r'\badamaveram\b', 'adamo'),
    (r'\badamaveras\b', 'adamo'),
    (r'\badamaverint\b', 'adamo'),
    (r'\badamaveris\b', 'adamo'),
    (r'\badamaverit\b', 'adamo'),
    (r'\badamaverunt\b', 'adamo'),
    (r'\badamavi\b', 'adamo'),
    (r'\badamavisset\b', 'adamo'),
    (r'\badamavit\b', 'adamo'),
    (r'\badambulabam\b', 'adambulo'),
    (r'\badambulabat\b', 'adambulo'),
    (r'\badambulabo\b', 'adambulo'),
    (r'\badambulantem\b', 'adambulo'),
    (r'\badament\b', 'adamo'),
    (r'\badamet\b', 'adamo'),
    (r'\badametur\b', 'adamo'),
    (r'\badaperiam\b', 'adaperio'),
    (r'\badaperiat\b', 'adaperio'),
    (r'\badaperiens\b', 'adaperio'),
    (r'\badaperientibus\b', 'adaperio'),
    (r'\badaperire\b', 'adaperio'),
    (r'\badaperiret\b', 'adaperio'),
    (r'\badaperiunt\b', 'adaperio'),
    (r'\badaperiuntur\b', 'adaperio'),
    (r'\badaperta\b', 'adaperio'),
    (r'\badapertae\b', 'adaperio'),
    (r'\badapertaque\b', 'adaperio'),
    (r'\badapertas\b', 'adaperio'),
    (r'\badaperti\b', 'adaperio'),
    (r'\badapertile\b', 'adapertilis'),
    (r'\badapertione\b', 'adapertio'),
    (r'\badapertis\b', 'adaperio'),
    (r'\badaperto\b', 'adaperio'),
    (r'\badapertum\b', 'adaperio'),
    (r'\badapertus\b', 'adaperio'),
    (r'\badaperuere\b', 'adaperio'),
    (r'\badaperui\b', 'adaperio'),
    (r'\badaperuit\b', 'adaperio'),
    (r'\badaptarentur\b', 'adapto'),
    (r'\badaptatis\b', 'adapto'),
    (r'\badaptato\b', 'adapto'),
    (r'\badaquabantur\b', 'adaquo'),
    (r'\badaquare\b', 'adaquo'),
    (r'\badaquari\b', 'adaquo'),
    (r'\badaquato\b', 'adaquo'),
    (r'\badaquavit\b', 'adaquo'),
    (r'\badaquemus\b', 'adaquo'),
    (r'\badarca\b', 'adarca'),
    (r'\badarsa\b', 'adaresco'),
    (r'\badaruerit\b', 'adaresco'),
    (r'\badas\b', 'ador'),
    (r'\badaucta\b', 'adaugeo'),
    (r'\badaucta\b', 'adaucto'),
    (r'\badauctae\b', 'adaugeo'),
    (r'\badauctam\b', 'adaugeo'),
    (r'\badauctauit\b', 'adaucto'),
    (r'\badauctis\b', 'adaugeo'),
    (r'\badaucto\b', 'adaugeo'),
    (r'\badaucto\b', 'adaucto'),
    (r'\badauctu\b', 'adauctus2'),
    (r'\badauctu\b', 'adaugeo'),
    (r'\badauctum\b', 'adauctus2'),
    (r'\badauctum\b', 'adaugeo'),
    (r'\badaucturum\b', 'adaugeo'),
    (r'\badauctus\b', 'adauctus2'),
    (r'\badauctus\b', 'adaugeo'),
    (r'\badauge\b', 'adaugeo'),
    (r'\badaugeat\b', 'adaugeo'),
    (r'\badaugeatur\b', 'adaugeo'),
    (r'\badaugebitur\b', 'adaugeo'),
    (r'\badaugebo\b', 'adaugeo'),
    (r'\badaugenda\b', 'adaugeo'),
    (r'\badaugendae\b', 'adaugeo'),
    (r'\badaugendi\b', 'adaugeo'),
    (r'\badaugendum\b', 'adaugeo'),
    (r'\badaugent\b', 'adaugeo'),
    (r'\badaugere\b', 'adaugeo'),
    (r'\badaugeri\b', 'adaugeo'),
    (r'\badaugescit\b', 'adaugesco'),
    (r'\badauget\b', 'adaugeo'),
    (r'\badaugetur\b', 'adaugeo'),
    (r'\badauxit\b', 'adaugeo'),
    (r'\badbibe\b', 'adbibo'),
    (r'\badbibere\b', 'adbibo'),
    (r'\badbibero\b', 'adbibo'),
    (r'\badbibi\b', 'adbibo'),
    (r'\badbibit\b', 'adbibo'),
    (r'\badbites\b', 'adbito'),
    (r'\badbreviasti\b', 'ad-brevio'),
    (r'\badbreviata\b', 'ad-brevio'),
    (r'\badbreviatae\b', 'ad-brevio'),
    (r'\badbreviatus\b', 'ad-brevio'),
    (r'\badbreviavit\b', 'ad-brevio'),
    (r'\badcanto\b', 'accano'),
    (r'\badcantus\b', 'accano'),
    (r'\badcedam\b', 'ad-curro'),
    (r'\badcedat\b', 'ad-curro'),
    (r'\badcedebat\b', 'ad-curro'),
    (r'\badcedentem\b', 'ad-curro'),
    (r'\badcedere\b', 'ad-curro'),
    (r'\badcederent\b', 'ad-curro'),
    (r'\badcedit\b', 'ad-curro'),
    (r'\badcelera\b', 'ad-curro'),
    (r'\badcelerabo\b', 'ad-curro'),
    (r'\badcelerandam\b', 'ad-curro'),
    (r'\badcelerant\b', 'ad-curro'),
    (r'\badcelerantur\b', 'ad-curro'),
    (r'\badcelerare\b', 'ad-curro'),
    (r'\badceleraret\b', 'ad-curro'),
    (r'\badcelerari\b', 'ad-curro'),
    (r'\badcelerarunt\b', 'ad-curro'),
    (r'\badcelerasse\b', 'ad-curro'),
    (r'\badcelerasset\b', 'ad-curro'),
    (r'\badcelerat\b', 'ad-curro'),
    (r'\badcelerata\b', 'ad-curro'),
    (r'\badcelerate\b', 'ad-curro'),
    (r'\badcelerato\b', 'ad-curro'),
    (r'\badceleratos\b', 'ad-curro'),
    (r'\badceleratur\b', 'ad-curro'),
    (r'\badceleraturumque\b', 'ad-curro'),
    (r'\badceleraverat\b', 'ad-curro'),
    (r'\badceleravere\b', 'ad-curro'),
    (r'\badceleraverunt\b', 'ad-curro'),
    (r'\badceleravit\b', 'ad-curro'),
    (r'\badcelerent\b', 'ad-curro'),
    (r'\badcensa\b', 'ad-curro'),
    (r'\badcensae\b', 'ad-curro'),
    (r'\badcensi\b', 'ad-curro'),
    (r'\badcensum\b', 'ad-curro'),
    (r'\badcensus\b', 'ad-curro'),
    (r'\badcesserat\b', 'ad-curro'),
    (r'\badcessere\b', 'ad-curro'),
    (r'\badcessere\b', 'ad-curro'),
    (r'\badcesserint\b', 'ad-curro'),
    (r'\badcesserit\b', 'ad-curro'),
    (r'\badcessimus\b', 'ad-curro'),
    (r'\badcessissent\b', 'ad-curro'),
    (r'\badcessum\b', 'ad-curro'),
    (r'\badcessurum\b', 'ad-curro'),
    (r'\badcidat\b', 'ad-curro'),
    (r'\badcidentem\b', 'ad-curro'),
    (r'\badcidere\b', 'ad-curro'),
    (r'\badciderent\b', 'ad-curro'),
    (r'\badcideret\b', 'ad-curro'),
    (r'\badcidet\b', 'ad-curro'),
    (r'\badcidit\b', 'ad-curro'),
    (r'\badcingar\b', 'ad-curro'),
    (r'\badcipiunt\b', 'ad-curro'),
    (r'\badciti\b', 'ad-curro'),
    (r'\badcito\b', 'ad-curro'),
    (r'\badcito\b', 'ad-curro'),
    (r'\badcitum\b', 'ad-curro'),
    (r'\badclamabat\b', 'ad-curro'),
    (r'\badclamabit\b', 'ad-curro'),
    (r'\badclamant\b', 'ad-curro'),
    (r'\badclamante\b', 'ad-curro'),
    (r'\badclamantes\b', 'ad-curro'),
    (r'\badclamantibus\b', 'ad-curro'),
    (r'\badclamantium\b', 'ad-curro'),
    (r'\badclamare\b', 'ad-curro'),
    (r'\badclamarent\b', 'ad-curro'),
    (r'\badclamaret\b', 'ad-curro'),
    (r'\badclamari\b', 'ad-curro'),
    (r'\badclamata\b', 'ad-curro'),
    (r'\badclamate\b', 'ad-curro'),
    (r'\badclamatio\b', 'acclamatio'),
    (r'\badclamatione\b', 'acclamatio'),
    (r'\badclamationem\b', 'acclamatio'),
    (r'\badclamationemque\b', 'acclamatio'),
    (r'\badclamationes\b', 'acclamatio'),
    (r'\badclamationibus\b', 'acclamatio'),
    (r'\badclamationis\b', 'acclamatio'),
    (r'\badclamationum\b', 'acclamatio'),
    (r'\badclamatum\b', 'ad-curro'),
    (r'\badclamatumque\b', 'ad-curro'),
    (r'\badclamatur\b', 'ad-curro'),
    (r'\badclamauit\b', 'ad-curro'),
    (r'\badclamaverant\b', 'ad-curro'),
    (r'\badclamavere\b', 'ad-curro'),
    (r'\badclamavit\b', 'ad-curro'),
    (r'\badclament\b', 'ad-curro'),
    (r'\badclametis\b', 'ad-curro'),
    (r'\badcognoscant\b', 'ad-curro'),
    (r'\badcognoscere\b', 'ad-curro'),
    (r'\badcognoscit\b', 'ad-curro'),
    (r'\badcognoscitur\b', 'ad-curro'),
    (r'\badcognosco\b', 'ad-curro'),
    (r'\badcolas\b', 'accola'),
    (r'\badcolebant\b', 'ad-curro'),
    (r'\badcolit\b', 'ad-curro'),
    (r'\badcolitis\b', 'ad-curro'),
    (r'\badcommoda\b', 'accommodus'),
    (r'\badcommodabimus\b', 'ad-curro'),
    (r'\badcommodabitur\b', 'ad-curro'),
    (r'\badcommodabuntur\b', 'ad-curro'),
    (r'\badcommodanda\b', 'ad-curro'),
    (r'\badcommodandae\b', 'ad-curro'),
    (r'\badcommodandasque\b', 'ad-curro'),
    (r'\badcommodandum\b', 'ad-curro'),
    (r'\badcommodantes\b', 'ad-curro'),
    (r'\badcommodanti\b', 'ad-curro'),
    (r'\badcommodantur\b', 'ad-curro'),
    (r'\badcommodare\b', 'ad-curro'),
    (r'\badcommodarentur\b', 'ad-curro'),
    (r'\badcommodaret\b', 'ad-curro'),
    (r'\badcommodari\b', 'ad-curro'),
    (r'\badcommodasse\b', 'ad-curro'),
    (r'\badcommodassemus\b', 'ad-curro'),
    (r'\badcommodat\b', 'ad-curro'),
    (r'\badcommodata\b', 'ad-curro'),
    (r'\badcommodatae\b', 'ad-curro'),
    (r'\badcommodatam\b', 'ad-curro'),
    (r'\badcommodatas\b', 'ad-curro'),
    (r'\badcommodate\b', 'ad-curro'),
    (r'\badcommodati\b', 'ad-curro'),
    (r'\badcommodatior\b', 'ad-curro'),
    (r'\badcommodatiora\b', 'ad-curro'),
    (r'\badcommodatiores\b', 'ad-curro'),
    (r'\badcommodatis\b', 'ad-curro'),
    (r'\badcommodatissimae\b', 'ad-curro'),
    (r'\badcommodatissime\b', 'ad-curro'),
    (r'\badcommodatissimum\b', 'ad-curro'),
    (r'\badcommodato\b', 'ad-curro'),
    (r'\badcommodatos\b', 'ad-curro'),
    (r'\badcommodatum\b', 'ad-curro'),
    (r'\badcommodatumne\b', 'ad-curro'),
    (r'\badcommodatur\b', 'ad-curro'),
    (r'\badcommodatus\b', 'ad-curro'),
    (r'\badcommodaveris\b', 'ad-curro'),
    (r'\badcommodaverunt\b', 'ad-curro'),
    (r'\badcommodem\b', 'ad-curro'),
    (r'\badcommodentur\b', 'ad-curro'),
    (r'\badcommodes\b', 'ad-curro'),
    (r'\badcommodet\b', 'ad-curro'),
    (r'\badcommodiora\b', 'accommodus'),
    (r'\badcommodum\b', 'accommodus'),
    (r'\badcommodus\b', 'accommodus'),
    (r'\badcredat\b', 'ad-curro'),
    (r'\badcredens\b', 'ad-curro'),
    (r'\badcredere\b', 'ad-curro'),
    (r'\badcredidisse\b', 'ad-curro'),
    (r'\badcrescant\b', 'ad-curro'),
    (r'\badcrescat\b', 'ad-curro'),
    (r'\badcrescebat\b', 'ad-curro'),
    (r'\badcrescendi\b', 'ad-curro'),
    (r'\badcrescendo\b', 'ad-curro'),
    (r'\badcrescens\b', 'ad-curro'),
    (r'\badcrescent\b', 'ad-curro'),
    (r'\badcrescente\b', 'ad-curro'),
    (r'\badcrescentem\b', 'ad-curro'),
    (r'\badcrescentes\b', 'ad-curro'),
    (r'\badcrescentibus\b', 'ad-curro'),
    (r'\badcrescere\b', 'ad-curro'),
    (r'\badcresceret\b', 'ad-curro'),
    (r'\badcrescet\b', 'ad-curro'),
    (r'\badcrescit\b', 'ad-curro'),
    (r'\badcrescunt\b', 'ad-curro'),
    (r'\badcreuerint\b', 'ad-curro'),
    (r'\badcreuerit\b', 'ad-curro'),
    (r'\badcreuisse\b', 'ad-curro'),
    (r'\badcreuit\b', 'ad-curro'),
    (r'\badcreverat\b', 'ad-curro'),
    (r'\badcrevere\b', 'ad-curro'),
    (r'\badcreverit\b', 'ad-curro'),
    (r'\badcrevisse\b', 'ad-curro'),
    (r'\badcrevit\b', 'ad-curro'),
    (r'\badcrustante\b', 'ad-curro'),
    (r'\badcubantium\b', 'ad-curro'),
    (r'\badcubueram\b', 'ad-curro'),
    (r'\badcubuere\b', 'ad-curro'),
    (r'\badcubuerunt\b', 'ad-curro'),
    (r'\badcubuit\b', 'ad-curro'),
    (r'\badcucurrerant\b', 'ad-curro'),
    (r'\badcucurrerat\b', 'ad-curro'),
    (r'\badcucurri\b', 'ad-curro'),
    (r'\badcucurrisse\b', 'ad-curro'),
    (r'\badcucurrisset\b', 'ad-curro'),
    (r'\badcucurrit\b', 'ad-curro'),
    (r'\badcumulandis\b', 'ad-curro'),
    (r'\badcumulant\b', 'ad-curro'),
    (r'\badcumulare\b', 'ad-curro'),
    (r'\badcumulateque\b', 'accumulate'),
    (r'\badcumulatio\b', 'accumulatio'),
    (r'\badcumulatissume\b', 'ad-curro'),
    (r'\badcumulator\b', 'accumulator'),
    (r'\badcumuleturque\b', 'ad-curro'),
    (r'\badcura\b', 'ad-curro'),
    (r'\badcurandumst\b', 'ad-curro'),
    (r'\badcurandus\b', 'ad-curro'),
    (r'\badcurare\b', 'ad-curro'),
    (r'\badcurata\b', 'ad-curro'),
    (r'\badcurate\b', 'ad-curro'),
    (r'\badcuratius\b', 'ad-curro'),
    (r'\badcuratote\b', 'ad-curro'),
    (r'\badcuratus\b', 'ad-curro'),
    (r'\badcuro\b', 'ad-curro'),
    (r'\badcurrens\b', 'ad-curro'),
    (r'\badcurrentem\b', 'ad-curro'),
    (r'\badcurrentes\b', 'ad-curro'),
    (r'\badcurrentibus\b', 'ad-curro'),
    (r'\badcurrentium\b', 'ad-curro'),
    (r'\badcurrere\b', 'ad-curro'),
    (r'\badcurrerent\b', 'ad-curro'),
    (r'\badcurrerunt\b', 'ad-curro'),
    (r'\badcurret\b', 'ad-curro'),
    (r'\badcurrit\b', 'ad-curro'),
    (r'\badcurritur\b', 'ad-curro'),
    (r'\badcurrunt\b', 'ad-curro'),
    (r'\badcursu\b', 'accursus'),
    (r'\badcursum\b', 'accursus'),
    (r'\badcursus\b', 'accursus'),
    (r'\baddam\b', 'addo'),
    (r'\baddamus\b', 'addo'),
    (r'\baddant\b', 'addo'),
    (r'\baddantur\b', 'addo'),
    (r'\baddar\b', 'addo'),
    (r'\baddas\b', 'addo'),
    (r'\baddat\b', 'addo'),
    (r'\baddatur\b', 'addo'),
    (r'\baddaturque\b', 'addo'),
    (r'\badde\b', 'addo'),
    (r'\baddebant\b', 'addo'),
    (r'\baddebantur\b', 'addo'),
    (r'\baddebat\b', 'addo'),
    (r'\baddebatur\b', 'addo'),
    (r'\baddecet\b', 'addecet'),
    (r'\baddecimabit\b', 'addecimo'),
    (r'\baddemus\b', 'addo'),
    (r'\badden\b', 'addo'),
    (r'\baddenda\b', 'addo'),
    (r'\baddendam\b', 'addo'),
    (r'\baddendi\b', 'addo'),
    (r'\baddendis\b', 'addo'),
    (r'\baddendo\b', 'addo'),
    (r'\baddendos\b', 'addo'),
    (r'\baddendum\b', 'addo'),
    (r'\baddendumque\b', 'addo'),
    (r'\baddens\b', 'addo'),
    (r'\baddensari\b', 'addico'),
    (r'\baddensent\b', 'addenseo'),
    (r'\baddensent\b', 'addico'),
    (r'\baddent\b', 'addo'),
    (r'\baddente\b', 'addo'),
    (r'\baddentes\b', 'addo'),
    (r'\baddentia\b', 'addo'),
    (r'\baddentique\b', 'addo'),
    (r'\baddentium\b', 'addo'),
    (r'\baddentur\b', 'addo'),
    (r'\baddere\b', 'addo'),
    (r'\badderem\b', 'addo'),
    (r'\badderemus\b', 'addo'),
    (r'\badderent\b', 'addo'),
    (r'\badderentur\b', 'addo'),
    (r'\badderes\b', 'addo'),
    (r'\badderet\b', 'addo'),
    (r'\badderetis\b', 'addo'),
    (r'\badderetur\b', 'addo'),
    (r'\baddes\b', 'addo'),
    (r'\baddet\b', 'addo'),
    (r'\baddetis\b', 'addo'),
    (r'\baddetur\b', 'addo'),
    (r'\baddi\b', 'addo'),
    (r'\baddicam\b', 'addico'),
    (r'\baddicant\b', 'addico'),
    (r'\baddicantur\b', 'addico'),
    (r'\baddicar\b', 'addico'),
    (r'\baddicat\b', 'addico'),
    (r'\baddicatur\b', 'addico'),
    (r'\baddice\b', 'addico'),
    (r'\baddicebantur\b', 'addico'),
    (r'\baddicebas\b', 'addico'),
    (r'\baddicebat\b', 'addico'),
    (r'\baddicebatur\b', 'addico'),
    (r'\baddicenda\b', 'addico'),
    (r'\baddicendo\b', 'addico'),
    (r'\baddicente\b', 'addico'),
    (r'\baddicentibus\b', 'addico'),
    (r'\baddicentur\b', 'addico'),
    (r'\baddicere\b', 'addico'),
    (r'\baddicerent\b', 'addico'),
    (r'\baddicerentur\b', 'addico'),
    (r'\baddiceres\b', 'addico'),
    (r'\baddiceret\b', 'addico'),
    (r'\baddiceretur\b', 'addico'),
    (r'\baddices\b', 'addico'),
    (r'\baddicet\b', 'addico'),
    (r'\baddicetur\b', 'addico'),
    (r'\baddici\b', 'addico'),
    (r'\baddicimus\b', 'addico'),
    (r'\baddicique\b', 'addico'),
    (r'\baddicit\b', 'addico'),
    (r'\baddicito\b', 'addico'),
    (r'\baddicitur\b', 'addico'),
    (r'\baddico\b', 'addico'),
    (r'\baddicta\b', 'addico'),
    (r'\baddictae\b', 'addico'),
    (r'\baddictam\b', 'addico'),
    (r'\baddictas\b', 'addico'),
    (r'\baddicti\b', 'addictus'),
    (r'\baddicti\b', 'addico'),
    (r'\baddictio\b', 'addictio'),
    (r'\baddictione\b', 'addictio'),
    (r'\baddictionem\b', 'addictio'),
    (r'\baddictioni\b', 'addictio'),
    (r'\baddictis\b', 'addictus'),
    (r'\baddictis\b', 'addico'),
    (r'\baddicto\b', 'addictus'),
    (r'\baddicto\b', 'addico'),
    (r'\baddictorum\b', 'addictus'),
    (r'\baddictorum\b', 'addico'),
    (r'\baddictos\b', 'addictus'),
    (r'\baddictos\b', 'addico'),
    (r'\baddictosque\b', 'addictus'),
    (r'\baddictosque\b', 'addico'),
    (r'\baddictum\b', 'addictus'),
    (r'\baddictum\b', 'addico'),
    (r'\baddictumue\b', 'addictus'),
    (r'\baddictumue\b', 'addico'),
    (r'\baddictus\b', 'addictus'),
    (r'\baddictus\b', 'addico'),
    (r'\baddictusque\b', 'addictus'),
    (r'\baddictusque\b', 'addico'),
    (r'\baddictust\b', 'addictus'),
    (r'\baddictust\b', 'addico'),
    (r'\baddicunt\b', 'addico'),
    (r'\baddicuntur\b', 'addico'),
    (r'\baddiderant\b', 'addo'),
    (r'\baddiderantque\b', 'addo'),
    (r'\baddiderat\b', 'addo'),
    (r'\baddideratque\b', 'addo'),
    (r'\baddidere\b', 'addo'),
    (r'\baddiderim\b', 'addo'),
    (r'\baddiderimus\b', 'addo'),
    (r'\baddiderint\b', 'addo'),
    (r'\baddideris\b', 'addo'),
    (r'\baddiderit\b', 'addo'),
    (r'\baddidero\b', 'addo'),
    (r'\baddiderunt\b', 'addo'),
    (r'\baddideruntque\b', 'addo'),
    (r'\baddidi\b', 'addo'),
    (r'\baddidicerat\b', 'addisco'),
    (r'\baddidici\b', 'addisco'),
    (r'\baddidicisse\b', 'addisco'),
    (r'\baddidimus\b', 'addo'),
    (r'\baddidisse\b', 'addo'),
    (r'\baddidissemque\b', 'addo'),
    (r'\baddidissent\b', 'addo'),
    (r'\baddidisses\b', 'addo'),
    (r'\baddidisset\b', 'addo'),
    (r'\baddidisti\b', 'addo'),
    (r'\baddidistis\b', 'addo'),
    (r'\baddidit\b', 'addo'),
    (r'\baddiditque\b', 'addo'),
    (r'\baddimur\b', 'addo'),
    (r'\baddimus\b', 'addo'),
    (r'\baddin\b', 'addo'),
    (r'\baddique\b', 'addo'),
    (r'\baddis\b', 'addo'),
    (r'\baddiscat\b', 'addisco'),
    (r'\baddiscendo\b', 'addisco'),
    (r'\baddiscens\b', 'addisco'),
    (r'\baddiscentem\b', 'addisco'),
    (r'\baddiscere\b', 'addisco'),
    (r'\baddiscerem\b', 'addisco'),
    (r'\baddiscerent\b', 'addisco'),
    (r'\baddisceres\b', 'addisco'),
    (r'\baddisceret\b', 'addisco'),
    (r'\baddisces\b', 'addisco'),
    (r'\baddisci\b', 'addisco'),
    (r'\baddiscimus\b', 'addisco'),
    (r'\baddiscit\b', 'addisco'),
    (r'\baddiscite\b', 'addisco'),
    (r'\baddiscunt\b', 'addisco'),
    (r'\baddit\b', 'addo'),
    (r'\baddita\b', 'addo'),
    (r'\badditae\b', 'addo'),
    (r'\badditam\b', 'addo'),
    (r'\badditamenta\b', 'additamentum'),
    (r'\badditamenti\b', 'additamentum'),
    (r'\badditamento\b', 'additamentum'),
    (r'\badditamentum\b', 'additamentum'),
    (r'\badditaque\b', 'addo'),
    (r'\badditas\b', 'addo'),
    (r'\baddite\b', 'addo'),
    (r'\badditi\b', 'addo'),
    (r'\badditicium\b', 'additicius'),
    (r'\badditio\b', 'additio'),
    (r'\badditione\b', 'additio'),
    (r'\badditionem\b', 'additio'),
    (r'\badditis\b', 'addo'),
    (r'\badditisque\b', 'addo'),
    (r'\baddito\b', 'addo'),
    (r'\badditoque\b', 'addo'),
    (r'\badditos\b', 'addo'),
    (r'\badditque\b', 'addo'),
    (r'\badditum\b', 'addo'),
    (r'\badditumque\b', 'addo'),
    (r'\badditur\b', 'addo'),
    (r'\baddituros\b', 'addo'),
    (r'\badditurque\b', 'addo'),
    (r'\badditurum\b', 'addo'),
    (r'\badditurus\b', 'addo'),
    (r'\badditus\b', 'addo'),
    (r'\badditusque\b', 'addo'),
    (r'\badditust\b', 'addo'),
    (r'\baddixeram\b', 'addico'),
    (r'\baddixerant\b', 'addico'),
    (r'\baddixeras\b', 'addico'),
    (r'\baddixerat\b', 'addico'),
    (r'\baddixere\b', 'addico'),
    (r'\baddixerimus\b', 'addico'),
    (r'\baddixerint\b', 'addico'),
    (r'\baddixerit\b', 'addico'),
    (r'\baddixerunt\b', 'addico'),
    (r'\baddixi\b', 'addico'),
    (r'\baddiximus\b', 'addico'),
    (r'\baddixisse\b', 'addico'),
    (r'\baddixissent\b', 'addico'),
    (r'\baddixisses\b', 'addico'),
    (r'\baddixisset\b', 'addico'),
    (r'\baddixisti\b', 'addico'),
    (r'\baddixistis\b', 'addico'),
    (r'\baddixit\b', 'addico'),
    (r'\baddo\b', 'addo'),
    (r'\baddocet\b', 'addoceo'),
    (r'\baddon\b', 'addo'),
    (r'\baddone\b', 'addo'),
    (r'\baddormisceret\b', 'addormisco'),
    (r'\bAddua\b', 'Addua'),
    (r'\bAdduam\b', 'Addua'),
    (r'\baddubitare\b', 'addubito'),
    (r'\baddubitarem\b', 'addubito'),
    (r'\baddubitari\b', 'addubito'),
    (r'\baddubitas\b', 'addubito'),
    (r'\baddubitasse\b', 'addubito'),
    (r'\baddubitat\b', 'addubito'),
    (r'\baddubitata\b', 'addubito'),
    (r'\baddubitato\b', 'addubito'),
    (r'\baddubitatum\b', 'addubito'),
    (r'\baddubitauit\b', 'addubito'),
    (r'\baddubitavere\b', 'addubito'),
    (r'\baddubitavi\b', 'addubito'),
    (r'\baddubitem\b', 'addubito'),
    (r'\baddubitemus\b', 'addubito'),
    (r'\baddubites\b', 'addubito'),
    (r'\baddubitet\b', 'addubito'),
    (r'\baddubito\b', 'addubito'),
    (r'\badduc\b', 'adduco'),
    (r'\badducam\b', 'adduco'),
    (r'\badducamus\b', 'adduco'),
    (r'\badducant\b', 'adduco'),
    (r'\badducantur\b', 'adduco'),
    (r'\badducar\b', 'adduco'),
    (r'\badducas\b', 'adduco'),
    (r'\badducat\b', 'adduco'),
    (r'\badducatur\b', 'adduco'),
    (r'\badduce\b', 'adduco'),
    (r'\badducebam\b', 'adduco'),
    (r'\badducebant\b', 'adduco'),
    (r'\badducebantur\b', 'adduco'),
    (r'\badducebat\b', 'adduco'),
    (r'\badducebatur\b', 'adduco'),
    (r'\badducemus\b', 'adduco'),
    (r'\badducenda\b', 'adduco'),
    (r'\badducendae\b', 'adduco'),
    (r'\badducendam\b', 'adduco'),
    (r'\badducendas\b', 'adduco'),
    (r'\badducendi\b', 'adduco'),
    (r'\badducendum\b', 'adduco'),
    (r'\badducendus\b', 'adduco'),
    (r'\badducens\b', 'adduco'),
    (r'\badducent\b', 'adduco'),
    (r'\badducente\b', 'adduco'),
    (r'\badducentem\b', 'adduco'),
    (r'\badducentes\b', 'adduco'),
    (r'\badducentis\b', 'adduco'),
    (r'\badducentur\b', 'adduco'),
    (r'\badducere\b', 'adduco'),
    (r'\badducerem\b', 'adduco'),
    (r'\badducerent\b', 'adduco'),
    (r'\badducerentur\b', 'adduco'),
    (r'\badducerer\b', 'adduco'),
    (r'\badduceres\b', 'adduco'),
    (r'\badduceret\b', 'adduco'),
    (r'\badduceretur\b', 'adduco'),
    (r'\badduceris\b', 'adduco'),
    (r'\badduces\b', 'adduco'),
    (r'\badducet\b', 'adduco'),
    (r'\badducetis\b', 'adduco'),
    (r'\badducetque\b', 'adduco'),
    (r'\badducetur\b', 'adduco'),
    (r'\badduci\b', 'adduco'),
    (r'\badducier\b', 'adduco'),
    (r'\badducimur\b', 'adduco'),
    (r'\badducimus\b', 'adduco'),
    (r'\badducis\b', 'adduco'),
    (r'\badducit\b', 'adduco'),
    (r'\badducite\b', 'adduco'),
    (r'\badducito\b', 'adduco'),
    (r'\badducitque\b', 'adduco'),
    (r'\badducitur\b', 'adduco'),
    (r'\badduciue\b', 'adduco'),
    (r'\badduco\b', 'adduco'),
    (r'\badducor\b', 'adduco'),
    (r'\badducta\b', 'adduco'),
    (r'\badducta\b', 'adductor'),
    (r'\badductae\b', 'adduco'),
    (r'\badductam\b', 'adduco'),
    (r'\badductaque\b', 'adduco'),
    (r'\badductaque\b', 'adductor'),
    (r'\badductas\b', 'adduco'),
    (r'\badductas\b', 'adductor'),
    (r'\badducti\b', 'adduco'),
    (r'\badductior\b', 'adduco'),
    (r'\badductiore\b', 'adduco'),
    (r'\badductique\b', 'adduco'),
    (r'\badductis\b', 'adduco'),
    (r'\badductisque\b', 'adduco'),
    (r'\badductius\b', 'adduco'),
    (r'\badducto\b', 'adduco'),
    (r'\badducto\b', 'adductor'),
    (r'\badductoque\b', 'adduco'),
    (r'\badductoque\b', 'adductor'),
    (r'\badductos\b', 'adduco'),
    (r'\badductosque\b', 'adduco'),
    (r'\badductum\b', 'adduco'),
    (r'\badductumque\b', 'adduco'),
    (r'\badductura\b', 'adduco'),
    (r'\badducturam\b', 'adduco'),
    (r'\badducturum\b', 'adduco'),
    (r'\badducturus\b', 'adduco'),
    (r'\badductus\b', 'adduco'),
    (r'\badductust\b', 'adduco'),
    (r'\badducunt\b', 'adduco'),
    (r'\badducuntur\b', 'adduco'),
    (r'\badduint\b', 'addo'),
    (r'\badduit\b', 'addo'),
    (r'\baddunt\b', 'addo'),
    (r'\badduntque\b', 'addo'),
    (r'\badduntur\b', 'addo'),
    (r'\badduxeram\b', 'adduco'),
    (r'\badduxerant\b', 'adduco'),
    (r'\badduxerantque\b', 'adduco'),
    (r'\badduxerat\b', 'adduco'),
    (r'\badduxere\b', 'adduco'),
    (r'\badduxerim\b', 'adduco'),
    (r'\badduxeris\b', 'adduco'),
    (r'\badduxerit\b', 'adduco'),
    (r'\badduxeritis\b', 'adduco'),
    (r'\badduxero\b', 'adduco'),
    (r'\badduxerunt\b', 'adduco'),
    (r'\badduxeruntque\b', 'adduco'),
    (r'\badduxi\b', 'adduco'),
    (r'\badduximus\b', 'adduco'),
    (r'\badduxisse\b', 'adduco'),
    (r'\badduxissem\b', 'adduco'),
    (r'\badduxissent\b', 'adduco'),
    (r'\badduxisset\b', 'adduco'),
    (r'\badduxisti\b', 'adduco'),
    (r'\badduxistis\b', 'adduco'),
    (r'\badduxit\b', 'adduco'),
    (r'\badduxitque\b', 'adduco'),
    (r'\badeam\b', 'adeo1'),
    (r'\badeamus\b', 'adeo1'),
    (r'\badeant\b', 'adeo1'),
    (r'\badeantur\b', 'adeo1'),
    (r'\badeas\b', 'adeo1'),
    (r'\badeat\b', 'adeo1'),
    (r'\badeatis\b', 'adeo1'),
    (r'\badeatque\b', 'adeo1'),
    (r'\badeatur\b', 'adeo1'),
    (r'\badederat\b', 'ador'),
    (r'\badedere\b', 'adedo'),
    (r'\badedere\b', 'ador'),
    (r'\badederit\b', 'ador'),
    (r'\badederunt\b', 'ador'),
    (r'\badedit\b', 'ador'),
    (r'\badedit\b', 'adedo'),
    (r'\badeffecisse\b', 'ad-efficio'),
    (r'\badegeram\b', 'adigo'),
    (r'\badegerat\b', 'adigo'),
    (r'\badegere\b', 'adigo'),
    (r'\badegeris\b', 'adigo'),
    (r'\badegerit\b', 'adigo'),
    (r'\badegero\b', 'adigo'),
    (r'\badegerunt\b', 'adigo'),
    (r'\badegi\b', 'adigo'),
    (r'\badegissent\b', 'adigo'),
    (r'\badegisset\b', 'adigo'),
    (r'\badegisti\b', 'adigo'),
    (r'\badegit\b', 'adigo'),
    (r'\badelphides\b', 'adelphis'),
    (r'\badelphis\b', 'adelphis'),
    (r'\bAdelphis\b', 'ad-efficio'),
    (r'\bAdelphorum\b', 'ad-efficio'),
    (r'\bAdelphos\b', 'ad-efficio'),
    (r'\badem\b', 'ador'),
    (r'\bademerant\b', 'adimo'),
    (r'\bademerat\b', 'adimo'),
    (r'\bademere\b', 'adimo'),
    (r'\bademerint\b', 'adimo'),
    (r'\bademeris\b', 'adimo'),
    (r'\bademerit\b', 'adimo'),
    (r'\bademerunt\b', 'adimo'),
    (r'\bademi\b', 'adimo'),
    (r'\bademimus\b', 'adimo'),
    (r'\bademisse\b', 'adimo'),
    (r'\bademissent\b', 'adimo'),
    (r'\bademisses\b', 'adimo'),
    (r'\bademisset\b', 'adimo'),
    (r'\bademisti\b', 'adimo'),
    (r'\bademistis\b', 'adimo'),
    (r'\bademit\b', 'adimo'),
    (r'\badempsit\b', 'ademptio'),
    (r'\badempta\b', 'adimo'),
    (r'\bademptae\b', 'adimo'),
    (r'\bademptam\b', 'adimo'),
    (r'\bademptamque\b', 'adimo'),
    (r'\bademptaque\b', 'adimo'),
    (r'\bademptas\b', 'adimo'),
    (r'\badempte\b', 'adimo'),
    (r'\badempti\b', 'adimo'),
    (r'\bademptio\b', 'ademptio'),
    (r'\bademptione\b', 'ademptio'),
    (r'\bademptionem\b', 'ademptio'),
    (r'\bademptiones\b', 'ademptio'),
    (r'\bademptionis\b', 'ademptio'),
    (r'\bademptis\b', 'adimo'),
    (r'\badempto\b', 'adimo'),
    (r'\bademptum\b', 'adimo'),
    (r'\bademptumst\b', 'adimo'),
    (r'\badempturum\b', 'adimo'),
    (r'\badempturumque\b', 'adimo'),
    (r'\bademptus\b', 'adimo'),
    (r'\badeo\b', 'adeo2'),
    (r'\badeo\b', 'adeo1'),
    (r'\bAdeon\b', 'adeo2'),
    (r'\badeon\b', 'adeo2'),
    (r'\bAdeon\b', 'adeo1'),
    (r'\badeon\b', 'adeo1'),
    (r'\badeone\b', 'adeo2'),
    (r'\badeone\b', 'adeo1'),
    (r'\badeoque\b', 'adeo2'),
    (r'\badeoque\b', 'adeo1'),
    (r'\badeost\b', 'adeo2'),
    (r'\badeost\b', 'adeo1'),
    (r'\badeptione\b', 'adeptio'),
    (r'\badeptionem\b', 'adeptio'),
    (r'\badequitandi\b', 'adequito'),
    (r'\badequitando\b', 'adequito'),
    (r'\badequitans\b', 'adequito'),
    (r'\badequitant\b', 'adequito'),
    (r'\badequitantem\b', 'adequito'),
    (r'\badequitare\b', 'adequito'),
    (r'\badequitarent\b', 'adequito'),
    (r'\badequitassent\b', 'adequito'),
    (r'\badequitasset\b', 'adequito'),
    (r'\badequitat\b', 'adequito'),
    (r'\badequitauit\b', 'adequito'),
    (r'\badequitavit\b', 'adequito'),
    (r'\baderam\b', 'adsum'),
    (r'\baderamus\b', 'adsum'),
    (r'\baderant\b', 'adsum'),
    (r'\baderantque\b', 'adsum'),
    (r'\baderas\b', 'adsum'),
    (r'\baderat\b', 'adsum'),
    (r'\baderatque\b', 'adsum'),
    (r'\badere\b', 'adeo1'),
    (r'\badere\b', 'ador'),
    (r'\baderis\b', 'adsum'),
    (r'\baderis\b', 'ador'),
    (r'\baderisque\b', 'adsum'),
    (r'\baderisque\b', 'ador'),
    (r'\baderit\b', 'adsum'),
    (r'\baderitque\b', 'adsum'),
    (r'\badero\b', 'adsum'),
    (r'\baderrant\b', 'aderro'),
    (r'\baderrat\b', 'aderro'),
    (r'\baderunt\b', 'adsum'),
    (r'\baderunt\b', 'adeo1'),
    (r'\baderuntque\b', 'adsum'),
    (r'\baderuntque\b', 'adeo1'),
    (r'\bades\b', 'adsum'),
    (r'\bades\b', 'ador'),
    (r'\badesa\b', 'adedo'),
    (r'\badescandas\b', 'adesco'),
    (r'\badescantur\b', 'adesco'),
    (r'\badesi\b', 'adedo'),
    (r'\badesis\b', 'adedo'),
    (r'\badeso\b', 'adedo'),
    (r'\badesos\b', 'adedo'),
    (r'\badesse\b', 'adsum'),
    (r'\badessem\b', 'adsum'),
    (r'\badessemus\b', 'adsum'),
    (r'\badessent\b', 'adsum'),
    (r'\badesses\b', 'adsum'),
    (r'\badesset\b', 'adsum'),
    (r'\badessetis\b', 'adsum'),
    (r'\badest\b', 'adsum'),
    (r'\badeste\b', 'adsum'),
    (r'\badestis\b', 'adsum'),
    (r'\badestne\b', 'adsum'),
    (r'\badesto\b', 'adsum'),
    (r'\badesum\b', 'adedo'),
    (r'\badesurivit\b', 'adesurio'),
    (r'\badesus\b', 'adedo'),
    (r'\badeunda\b', 'adeo1'),
    (r'\badeundae\b', 'adeo1'),
    (r'\badeundam\b', 'adeo1'),
    (r'\badeunde\b', 'adeo1'),
    (r'\badeundi\b', 'adeo1'),
    (r'\badeundique\b', 'adeo1'),
    (r'\badeundis\b', 'adeo1'),
    (r'\badeundisque\b', 'adeo1'),
    (r'\badeundo\b', 'adeo1'),
    (r'\badeundorum\b', 'adeo1'),
    (r'\badeundos\b', 'adeo1'),
    (r'\badeundum\b', 'adeo1'),
    (r'\badeundumst\b', 'adeo1'),
    (r'\badeundus\b', 'adeo1'),
    (r'\badeunt\b', 'adeo1'),
    (r'\badeunte\b', 'adeo1'),
    (r'\badeuntem\b', 'adeo1'),
    (r'\badeuntes\b', 'adeo1'),
    (r'\badeunti\b', 'adeo1'),
    (r'\badeuntibus\b', 'adeo1'),
    (r'\badeuntis\b', 'adeo1'),
    (r'\badeuntium\b', 'adeo1'),
    (r'\badeunto\b', 'adeo1'),
    (r'\badeuntque\b', 'adeo1'),
    (r'\badeuntur\b', 'adeo1'),
    (r'\badfa\b', 'affor'),
    (r'\badfabar\b', 'affor'),
    (r'\badfabile\b', 'affabilis'),
    (r'\badfabili\b', 'affabilis'),
    (r'\badfabilis\b', 'affabilis'),
    (r'\badfabilissime\b', 'affabilis'),
    (r'\badfabilitasque\b', 'affabilitas'),
    (r'\badfabilitate\b', 'affabilitas'),
    (r'\badfabiliter\b', 'affabilis'),
    (r'\badfabiliter\b', 'adfixa'),
    (r'\badfamine\b', 'affamen'),
    (r'\badfamini\b', 'affamen'),
    (r'\badfamini\b', 'affor'),
    (r'\badfare\b', 'affor'),
    (r'\badfari\b', 'affor'),
    (r'\badfarier\b', 'affor'),
    (r'\badfaris\b', 'affor'),
    (r'\badfat\b', 'affor'),
    (r'\badfata\b', 'affor'),
    (r'\badfati\b', 'affor'),
    (r'\badfatibus\b', 'affatus2'),
    (r'\badfatim\b', 'affatim'),
    (r'\badfatis\b', 'affor'),
    (r'\badfatu\b', 'affatus2'),
    (r'\badfatu\b', 'affor'),
    (r'\badfatum\b', 'affatus2'),
    (r'\badfatum\b', 'affor'),
    (r'\badfatumque\b', 'affatus2'),
    (r'\badfatumque\b', 'affor'),
    (r'\badfatur\b', 'affor'),
    (r'\badfaturque\b', 'affor'),
    (r'\badfatus\b', 'affatus2'),
    (r'\badfatus\b', 'affor'),
    (r'\badfatusque\b', 'affatus2'),
    (r'\badfatusque\b', 'affor'),
    (r'\badfecerant\b', 'afficio'),
    (r'\badfecerat\b', 'afficio'),
    (r'\badfecere\b', 'afficio'),
    (r'\badfecerint\b', 'afficio'),
    (r'\badfeceris\b', 'afficio'),
    (r'\badfecerit\b', 'afficio'),
    (r'\badfecerunt\b', 'afficio'),
    (r'\badfeci\b', 'afficio'),
    (r'\badfecisse\b', 'afficio'),
    (r'\badfecissent\b', 'afficio'),
    (r'\badfecisset\b', 'afficio'),
    (r'\badfecisti\b', 'afficio'),
    (r'\badfecistis\b', 'afficio'),
    (r'\badfecit\b', 'afficio'),
    (r'\badfecta\b', 'afficio'),
    (r'\badfectae\b', 'afficio'),
    (r'\badfectam\b', 'afficio'),
    (r'\badfectaque\b', 'afficio'),
    (r'\badfectas\b', 'afficio'),
    (r'\badfectata\b', 'adfixa'),
    (r'\badfectatae\b', 'adfixa'),
    (r'\badfectatam\b', 'adfixa'),
    (r'\badfectate\b', 'adfixa'),
    (r'\badfectati\b', 'adfixa'),
    (r'\badfectatio\b', 'affectatio'),
    (r'\badfectatione\b', 'affectatio'),
    (r'\badfectationem\b', 'affectatio'),
    (r'\badfectationes\b', 'affectatio'),
    (r'\badfectationis\b', 'affectatio'),
    (r'\badfectato\b', 'adfixa'),
    (r'\badfectator\b', 'affectator'),
    (r'\badfectatorem\b', 'affectator'),
    (r'\badfectatores\b', 'affectator'),
    (r'\badfectatorque\b', 'affectator'),
    (r'\badfectatum\b', 'adfixa'),
    (r'\badfectatus\b', 'adfixa'),
    (r'\badfecte\b', 'affecte'),
    (r'\badfecte\b', 'afficio'),
    (r'\badfecti\b', 'afficio'),
    (r'\badfectibus\b', 'affectus2'),
    (r'\badfectio\b', 'affectio'),
    (r'\badfectione\b', 'affectio'),
    (r'\badfectionem\b', 'affectio'),
    (r'\badfectionemque\b', 'affectio'),
    (r'\badfectiones\b', 'affectio'),
    (r'\badfectioni\b', 'affectio'),
    (r'\badfectionibus\b', 'affectio'),
    (r'\badfectionis\b', 'affectio'),
    (r'\badfectionum\b', 'affectio'),
    (r'\badfectiose\b', 'affectiosus'),
    (r'\badfectis\b', 'afficio'),
    (r'\badfectisque\b', 'afficio'),
    (r'\badfectissimi\b', 'afficio'),
    (r'\badfectius\b', 'afficio'),
    (r'\badfecto\b', 'afficio'),
    (r'\badfectoque\b', 'afficio'),
    (r'\badfectos\b', 'afficio'),
    (r'\badfectu\b', 'affectus2'),
    (r'\badfectu\b', 'afficio'),
    (r'\badfectui\b', 'affectus2'),
    (r'\badfectum\b', 'affectus2'),
    (r'\badfectum\b', 'afficio'),
    (r'\badfecturi\b', 'afficio'),
    (r'\badfectus\b', 'affectus2'),
    (r'\badfectus\b', 'afficio'),
    (r'\badfectusque\b', 'affectus2'),
    (r'\badfectusque\b', 'afficio'),
    (r'\badfectuum\b', 'affectus2'),
    (r'\badfer\b', 'affero'),
    (r'\badfer\b', 'affor'),
    (r'\badferam\b', 'affero'),
    (r'\badferamus\b', 'affero'),
    (r'\badferant\b', 'affero'),
    (r'\badferantur\b', 'affero'),
    (r'\badferas\b', 'affero'),
    (r'\badferat\b', 'affero'),
    (r'\badferatis\b', 'affero'),
    (r'\badferatur\b', 'affero'),
    (r'\badferebam\b', 'affero'),
    (r'\badferebamus\b', 'affero'),
    (r'\badferebant\b', 'affero'),
    (r'\badferebantur\b', 'affero'),
    (r'\badferebas\b', 'affero'),
    (r'\badferebat\b', 'affero'),
    (r'\badferebatur\b', 'affero'),
    (r'\badferemus\b', 'affero'),
    (r'\badferen\b', 'affero'),
    (r'\badferen\b', 'affor'),
    (r'\badferenda\b', 'affero'),
    (r'\badferendae\b', 'affero'),
    (r'\badferendam\b', 'affero'),
    (r'\badferendo\b', 'affero'),
    (r'\badferendum\b', 'affero'),
    (r'\badferens\b', 'affero'),
    (r'\badferent\b', 'affero'),
    (r'\badferente\b', 'affero'),
    (r'\badferentem\b', 'affero'),
    (r'\badferentes\b', 'affero'),
    (r'\badferenti\b', 'affero'),
    (r'\badferentia\b', 'affero'),
    (r'\badferentibus\b', 'affero'),
    (r'\badferentis\b', 'affero'),
    (r'\badferentium\b', 'affero'),
    (r'\badferentur\b', 'affero'),
    (r'\badfereris\b', 'affero'),
    (r'\badferes\b', 'affero'),
    (r'\badferet\b', 'affero'),
    (r'\badferetur\b', 'affero'),
    (r'\badferimur\b', 'affero'),
    (r'\badferimus\b', 'affero'),
    (r'\badfero\b', 'affero'),
    (r'\badferque\b', 'affero'),
    (r'\badferque\b', 'affor'),
    (r'\badferre\b', 'affero'),
    (r'\badferrem\b', 'affero'),
    (r'\badferremus\b', 'affero'),
    (r'\badferrent\b', 'affero'),
    (r'\badferrentur\b', 'affero'),
    (r'\badferres\b', 'affero'),
    (r'\badferret\b', 'affero'),
    (r'\badferretur\b', 'affero'),
    (r'\badferri\b', 'affero'),
    (r'\badferrique\b', 'affero'),
    (r'\badfers\b', 'affero'),
    (r'\badfersne\b', 'affero'),
    (r'\badfert\b', 'affero'),
    (r'\badferte\b', 'affero'),
    (r'\badfertis\b', 'affero'),
    (r'\badferto\b', 'affero'),
    (r'\badfertque\b', 'affero'),
    (r'\badfertur\b', 'affero'),
    (r'\badferunt\b', 'affero'),
    (r'\badferuntur\b', 'affero'),
    (r'\badficere\b', 'afficio'),
    (r'\badficeremus\b', 'afficio'),
    (r'\badficerent\b', 'afficio'),
    (r'\badficerentur\b', 'afficio'),
    (r'\badficerer\b', 'afficio'),
    (r'\badficeret\b', 'afficio'),
    (r'\badficeretur\b', 'afficio'),
    (r'\badficeris\b', 'afficio'),
    (r'\badfici\b', 'afficio'),
    (r'\badficiam\b', 'afficio'),
    (r'\badficiamur\b', 'afficio'),
    (r'\badficiamurque\b', 'afficio'),
    (r'\badficiamus\b', 'afficio'),
    (r'\badficiant\b', 'afficio'),
    (r'\badficiantur\b', 'afficio'),
    (r'\badficiar\b', 'afficio'),
    (r'\badficias\b', 'afficio'),
    (r'\badficiat\b', 'afficio'),
    (r'\badficiatis\b', 'afficio'),
    (r'\badficiatur\b', 'afficio'),
    (r'\badficiebant\b', 'afficio'),
    (r'\badficiebantur\b', 'afficio'),
    (r'\badficiebar\b', 'afficio'),
    (r'\badficiebat\b', 'afficio'),
    (r'\badficiebatur\b', 'afficio'),
    (r'\badficiemini\b', 'afficio'),
    (r'\badficiendam\b', 'afficio'),
    (r'\badficiendi\b', 'afficio'),
    (r'\badficiendis\b', 'afficio'),
    (r'\badficiendo\b', 'afficio'),
    (r'\badficiendos\b', 'afficio'),
    (r'\badficiendum\b', 'afficio'),
    (r'\badficiendus\b', 'afficio'),
    (r'\badficient\b', 'afficio'),
    (r'\badficientes\b', 'afficio'),
    (r'\badficientium\b', 'afficio'),
    (r'\badficientur\b', 'afficio'),
    (r'\badficies\b', 'afficio'),
    (r'\badficiet\b', 'afficio'),
    (r'\badficietis\b', 'afficio'),
    (r'\badficietur\b', 'afficio'),
    (r'\badficimur\b', 'afficio'),
    (r'\badficio\b', 'afficio'),
    (r'\badficior\b', 'afficio'),
    (r'\badficique\b', 'afficio'),
    (r'\badficis\b', 'afficio'),
    (r'\badficit\b', 'afficio'),
    (r'\badficite\b', 'afficio'),
    (r'\badficitur\b', 'afficio'),
    (r'\badficiunt\b', 'afficio'),
    (r'\badficiuntur\b', 'afficio'),
    (r'\badficta\b', 'affictus'),
    (r'\badfictam\b', 'affictus'),
    (r'\badficticius\b', 'afficticius'),
    (r'\badficto\b', 'affictus'),
    (r'\badfictum\b', 'affictus'),
    (r'\badfigant\b', 'affigo'),
    (r'\badfigat\b', 'affigo'),
    (r'\badfigatur\b', 'affigo'),
    (r'\badfige\b', 'affigo'),
    (r'\badfigebantur\b', 'affigo'),
    (r'\badfigendus\b', 'affigo'),
    (r'\badfigens\b', 'affigo'),
    (r'\badfigent\b', 'affigo'),
    (r'\badfigentes\b', 'affigo'),
    (r'\badfigere\b', 'affigo'),
    (r'\badfigeretur\b', 'affigo'),
    (r'\badfiges\b', 'affigo'),
    (r'\badfiget\b', 'affigo'),
    (r'\badfigi\b', 'affigo'),
    (r'\badfigis\b', 'affigo'),
    (r'\badfigit\b', 'affigo'),
    (r'\badfigitur\b', 'affigo'),
    (r'\badfigunt\b', 'affigo'),
    (r'\badfiguntur\b', 'affigo'),
    (r'\badfine\b', 'affinis'),
    (r'\badfinem\b', 'affinis'),
    (r'\badfines\b', 'affinis'),
    (r'\badfinesque\b', 'affinis'),
    (r'\badfingant\b', 'affingo'),
    (r'\badfingas\b', 'affingo'),
    (r'\badfingat\b', 'affingo'),
    (r'\badfingebant\b', 'affingo'),
    (r'\badfingens\b', 'affingo'),
    (r'\badfingentium\b', 'affingo'),
    (r'\badfingere\b', 'affingo'),
    (r'\badfingeretur\b', 'affingo'),
    (r'\badfingimus\b', 'affingo'),
    (r'\badfingit\b', 'affingo'),
    (r'\badfingitur\b', 'affingo'),
    (r'\badfingo\b', 'affingo'),
    (r'\badfingunt\b', 'affingo'),
    (r'\badfinguntur\b', 'affingo'),
    (r'\badfini\b', 'affinis'),
    (r'\badfinia\b', 'affinis'),
    (r'\badfinibus\b', 'affinis'),
    (r'\badfinibusque\b', 'affinis'),
    (r'\badfinis\b', 'affinis'),
    (r'\badfinitas\b', 'affinitas'),
    (r'\badfinitas\b', 'affinis'),
    (r'\badfinitate\b', 'affinitas'),
    (r'\badfinitatem\b', 'affinitas'),
    (r'\badfinitates\b', 'affinitas'),
    (r'\badfinitatesque\b', 'affinitas'),
    (r'\badfinitateue\b', 'affinitas'),
    (r'\badfinitati\b', 'affinitas'),
    (r'\badfinitatibus\b', 'affinitas'),
    (r'\badfinitatis\b', 'affinitas'),
    (r'\badfinitatisue\b', 'affinitas'),
    (r'\badfinitatum\b', 'affinitas'),
    (r'\badfinium\b', 'affinis'),
    (r'\badfinxerit\b', 'affingo'),
    (r'\badfinxisset\b', 'affingo'),
    (r'\badfinxit\b', 'affingo'),
    (r'\badfirma\b', 'adfixa'),
    (r'\badfirmabant\b', 'adfixa'),
    (r'\badfirmabat\b', 'adfixa'),
    (r'\badfirmabatque\b', 'adfixa'),
    (r'\badfirmabatur\b', 'adfixa'),
    (r'\badfirmabimus\b', 'adfixa'),
    (r'\badfirmabo\b', 'adfixa'),
    (r'\badfirmabunt\b', 'adfixa'),
    (r'\badfirmamus\b', 'adfixa'),
    (r'\badfirmandi\b', 'adfixa'),
    (r'\badfirmando\b', 'adfixa'),
    (r'\badfirmans\b', 'adfixa'),
    (r'\badfirmant\b', 'adfixa'),
    (r'\badfirmante\b', 'adfixa'),
    (r'\badfirmantem\b', 'adfixa'),
    (r'\badfirmantes\b', 'adfixa'),
    (r'\badfirmanti\b', 'adfixa'),
    (r'\badfirmantibus\b', 'adfixa'),
    (r'\badfirmantibusque\b', 'adfixa'),
    (r'\badfirmantis\b', 'adfixa'),
    (r'\badfirmantur\b', 'adfixa'),
    (r'\badfirmare\b', 'adfixa'),
    (r'\badfirmarent\b', 'adfixa'),
    (r'\badfirmares\b', 'adfixa'),
    (r'\badfirmaret\b', 'adfixa'),
    (r'\badfirmari\b', 'adfixa'),
    (r'\badfirmarim\b', 'adfixa'),
    (r'\badfirmaris\b', 'adfixa'),
    (r'\badfirmas\b', 'adfixa'),
    (r'\badfirmasse\b', 'adfixa'),
    (r'\badfirmassent\b', 'adfixa'),
    (r'\badfirmasset\b', 'adfixa'),
    (r'\badfirmasti\b', 'adfixa'),
    (r'\badfirmat\b', 'adfixa'),
    (r'\badfirmata\b', 'adfixa'),
    (r'\badfirmatio\b', 'affirmatio'),
    (r'\badfirmatione\b', 'affirmatio'),
    (r'\badfirmationem\b', 'affirmatio'),
    (r'\badfirmationi\b', 'affirmatio'),
    (r'\badfirmationis\b', 'affirmatio'),
    (r'\badfirmatis\b', 'adfixa'),
    (r'\badfirmative\b', 'affirmativus'),
    (r'\badfirmativum\b', 'affirmativus'),
    (r'\badfirmator\b', 'affirmator'),
    (r'\badfirmatorum\b', 'affirmator'),
    (r'\badfirmatum\b', 'adfixa'),
    (r'\badfirmatur\b', 'adfixa'),
    (r'\badfirmauerat\b', 'adfixa'),
    (r'\badfirmauerim\b', 'adfixa'),
    (r'\badfirmauerint\b', 'adfixa'),
    (r'\badfirmauerit\b', 'adfixa'),
    (r'\badfirmauerunt\b', 'adfixa'),
    (r'\badfirmauit\b', 'adfixa'),
    (r'\badfirmaverat\b', 'adfixa'),
    (r'\badfirmavere\b', 'adfixa'),
    (r'\badfirmaverim\b', 'adfixa'),
    (r'\badfirmaverit\b', 'adfixa'),
    (r'\badfirmaverunt\b', 'adfixa'),
    (r'\badfirmavi\b', 'adfixa'),
    (r'\badfirmavimus\b', 'adfixa'),
    (r'\badfirmavit\b', 'adfixa'),
    (r'\badfirmem\b', 'adfixa'),
    (r'\badfirmemus\b', 'adfixa'),
    (r'\badfirment\b', 'adfixa'),
    (r'\badfirmentque\b', 'adfixa'),
    (r'\badfirmentur\b', 'adfixa'),
    (r'\badfirmes\b', 'adfixa'),
    (r'\badfirmet\b', 'adfixa'),
    (r'\badfirmetis\b', 'adfixa'),
    (r'\badfirmetur\b', 'adfixa'),
    (r'\badfirmo\b', 'adfixa'),
    (r'\badfixa\b', 'adfixa'),
    (r'\badfixa\b', 'affigo'),
    (r'\badfixae\b', 'affigo'),
    (r'\badfixaeque\b', 'affigo'),
    (r'\badfixam\b', 'affigo'),
    (r'\badfixaque\b', 'adfixa'),
    (r'\badfixaque\b', 'affigo'),
    (r'\badfixas\b', 'affigo'),
    (r'\badfixerant\b', 'affigo'),
    (r'\badfixerat\b', 'affigo'),
    (r'\badfixerit\b', 'affigo'),
    (r'\badfixerunt\b', 'affigo'),
    (r'\badfixi\b', 'affigo'),
    (r'\badfixique\b', 'affigo'),
    (r'\badfixis\b', 'adfixa'),
    (r'\badfixis\b', 'affigo'),
    (r'\badfixisse\b', 'affigo'),
    (r'\badfixit\b', 'affigo'),
    (r'\badfixo\b', 'affigo'),
    (r'\badfixos\b', 'affigo'),
    (r'\badfixum\b', 'adfixa'),
    (r'\badfixum\b', 'affigo'),
    (r'\badfixus\b', 'affigo'),
    (r'\badfixusque\b', 'affigo'),
    (r'\badflabat\b', 'afflo'),
    (r'\badflabitur\b', 'afflo'),
    (r'\badflans\b', 'afflo'),
    (r'\badflant\b', 'afflo'),
    (r'\badflante\b', 'afflo'),
    (r'\badflantur\b', 'afflo'),
    (r'\badflarant\b', 'afflo'),
    (r'\badflarat\b', 'afflo'),
    (r'\badflare\b', 'afflo'),
    (r'\badflarentur\b', 'afflo'),
    (r'\badflari\b', 'afflo'),
    (r'\badflasset\b', 'afflo'),
    (r'\badflat\b', 'afflo'),
    (r'\badflata\b', 'afflo'),
    (r'\badflataque\b', 'afflo'),
    (r'\badflate\b', 'afflo'),
    (r'\badflati\b', 'afflo'),
    (r'\badflatibus\b', 'afflatus2'),
    (r'\badflatique\b', 'afflo'),
    (r'\badflato\b', 'afflo'),
    (r'\badflatos\b', 'afflo'),
    (r'\badflatu\b', 'afflatus2'),
    (r'\badflatu\b', 'afflo'),
    (r'\badflatum\b', 'afflatus2'),
    (r'\badflatum\b', 'afflo'),
    (r'\badflatuque\b', 'afflatus2'),
    (r'\badflatuque\b', 'afflo'),
    (r'\badflatur\b', 'afflo'),
    (r'\badflatus\b', 'afflatus2'),
    (r'\badflatus\b', 'afflo'),
    (r'\badflatusque\b', 'afflatus2'),
    (r'\badflatusque\b', 'afflo'),
    (r'\badflauerat\b', 'afflo'),
    (r'\badflauerit\b', 'afflo'),
    (r'\badflauit\b', 'afflo'),
    (r'\badflaverat\b', 'afflo'),
    (r'\badflaverit\b', 'afflo'),
    (r'\badflavit\b', 'afflo'),
    (r'\badfleat\b', 'affleo'),
    (r'\badflectare\b', 'afflecto'),
    (r'\badflent\b', 'affleo'),
    (r'\badflent\b', 'afflo'),
    (r'\badflentur\b', 'affleo'),
    (r'\badflentur\b', 'afflo'),
    (r'\badflet\b', 'affleo'),
    (r'\badflet\b', 'afflo'),
    (r'\badflexa\b', 'afflecto'),
    (r'\badflexo\b', 'afflecto'),
    (r'\badflicta\b', 'affligo'),
    (r'\badflicta\b', 'afflicto'),
    (r'\badflictabant\b', 'afflicto'),
    (r'\badflictabat\b', 'afflicto'),
    (r'\badflictabatur\b', 'afflicto'),
    (r'\badflictae\b', 'affligo'),
    (r'\badflictaeque\b', 'affligo'),
    (r'\badflictam\b', 'affligo'),
    (r'\badflictando\b', 'afflicto'),
    (r'\badflictantur\b', 'afflicto'),
    (r'\badflictare\b', 'afflicto'),
    (r'\badflictarentur\b', 'afflicto'),
    (r'\badflictaret\b', 'afflicto'),
    (r'\badflictaretur\b', 'afflicto'),
    (r'\badflictari\b', 'afflicto'),
    (r'\badflictarum\b', 'affligo'),
    (r'\badflictas\b', 'affligo'),
    (r'\badflictas\b', 'afflicto'),
    (r'\badflictat\b', 'afflicto'),
    (r'\badflictata\b', 'afflicto'),
    (r'\badflictatio\b', 'afflictatio'),
    (r'\badflictationem\b', 'afflictatio'),
    (r'\badflictationis\b', 'afflictatio'),
    (r'\badflictatur\b', 'afflicto'),
    (r'\badflictatus\b', 'afflicto'),
    (r'\badflictaverat\b', 'afflicto'),
    (r'\badflictavisset\b', 'afflicto'),
    (r'\badflictem\b', 'afflicto'),
    (r'\badflictentur\b', 'afflicto'),
    (r'\badflictes\b', 'afflicto'),
    (r'\badflicti\b', 'affligo'),
    (r'\badflictio\b', 'afflictio'),
    (r'\badflictione\b', 'afflictio'),
    (r'\badflictionem\b', 'afflictio'),
    (r'\badflictionemque\b', 'afflictio'),
    (r'\badflictiones\b', 'afflictio'),
    (r'\badflictionibus\b', 'afflictio'),
    (r'\badflictionis\b', 'afflictio'),
    (r'\badflictiore\b', 'affligo'),
    (r'\badflictique\b', 'affligo'),
    (r'\badflictis\b', 'affligo'),
    (r'\badflictisque\b', 'affligo'),
    (r'\badflicto\b', 'affligo'),
    (r'\badflicto\b', 'afflicto'),
    (r'\badflictor\b', 'afflictor'),
    (r'\badflictor\b', 'afflicto'),
    (r'\badflictorem\b', 'afflictor'),
    (r'\badflictorum\b', 'afflictor'),
    (r'\badflictorum\b', 'affligo'),
    (r'\badflictos\b', 'affligo'),
    (r'\badflictosque\b', 'affligo'),
    (r'\badflictu\b', 'afflictus2'),
    (r'\badflictu\b', 'affligo'),
    (r'\badflictum\b', 'afflictus2'),
    (r'\badflictum\b', 'affligo'),
    (r'\badflictumque\b', 'afflictus2'),
    (r'\badflictumque\b', 'affligo'),
    (r'\badflicturus\b', 'affligo'),
    (r'\badflictus\b', 'afflictus2'),
    (r'\badflictus\b', 'affligo'),
    (r'\badflictusne\b', 'afflictus2'),
    (r'\badflictusne\b', 'affligo'),
    (r'\badflictusque\b', 'afflictus2'),
    (r'\badflictusque\b', 'affligo'),
    (r'\badfligam\b', 'affligo'),
    (r'\badfligant\b', 'affligo'),
    (r'\badfligantur\b', 'affligo'),
    (r'\badfligas\b', 'affligo'),
    (r'\badfligat\b', 'affligo'),
    (r'\badfligatur\b', 'affligo'),
    (r'\badflige\b', 'affligo'),
    (r'\badfligebant\b', 'affligo'),
    (r'\badfligebantur\b', 'affligo'),
    (r'\badfligebat\b', 'affligo'),
    (r'\badfligemus\b', 'affligo'),
    (r'\badfligendam\b', 'affligo'),
    (r'\badfligendo\b', 'affligo'),
    (r'\badfligendum\b', 'affligo'),
    (r'\badfligens\b', 'affligo'),
    (r'\badfligent\b', 'affligo'),
    (r'\badfligente\b', 'affligo'),
    (r'\badfligentem\b', 'affligo'),
    (r'\badfligentes\b', 'affligo'),
    (r'\badfligentibus\b', 'affligo'),
    (r'\badfligentur\b', 'affligo'),
    (r'\badfligere\b', 'affligo'),
    (r'\badfligerem\b', 'affligo'),
    (r'\badfligeremur\b', 'affligo'),
    (r'\badfligerent\b', 'affligo'),
    (r'\badfligerentur\b', 'affligo'),
    (r'\badfligeres\b', 'affligo'),
    (r'\badfligeret\b', 'affligo'),
    (r'\badfligeretur\b', 'affligo'),
    (r'\badfliges\b', 'affligo'),
    (r'\badfliget\b', 'affligo'),
    (r'\badfligetis\b', 'affligo'),
    (r'\badfligetisque\b', 'affligo'),
    (r'\badfligetur\b', 'affligo'),
    (r'\badfligi\b', 'affligo'),
    (r'\badfligit\b', 'affligo'),
    (r'\badfligitis\b', 'affligo'),
    (r'\badfligitur\b', 'affligo'),
    (r'\badfligunt\b', 'affligo'),
    (r'\badfliguntur\b', 'affligo'),
    (r'\badflixeram\b', 'affligo'),
    (r'\badflixeras\b', 'affligo'),
    (r'\badflixerat\b', 'affligo'),
    (r'\badflixere\b', 'affligo'),
    (r'\badflixerim\b', 'affligo'),
    (r'\badflixerintque\b', 'affligo'),
    (r'\badflixeris\b', 'affligo'),
    (r'\badflixerit\b', 'affligo'),
    (r'\badflixeritis\b', 'affligo'),
    (r'\badflixerunt\b', 'affligo'),
    (r'\badflixeruntque\b', 'affligo'),
    (r'\badflixi\b', 'affligo'),
    (r'\badflixisse\b', 'affligo'),
    (r'\badflixissent\b', 'affligo'),
    (r'\badflixisset\b', 'affligo'),
    (r'\badflixisti\b', 'affligo'),
    (r'\badflixistis\b', 'affligo'),
    (r'\badflixit\b', 'affligo'),
    (r'\badfluat\b', 'affluo'),
    (r'\badfluebant\b', 'affluo'),
    (r'\badfluebantque\b', 'affluo'),
    (r'\badfluebat\b', 'affluo'),
    (r'\badfluens\b', 'affluo'),
    (r'\badfluente\b', 'affluo'),
    (r'\badfluentem\b', 'affluo'),
    (r'\badfluentem\b', 'affluenter'),
    (r'\badfluentes\b', 'affluo'),
    (r'\badfluentes\b', 'affluenter'),
    (r'\badfluenti\b', 'affluo'),
    (r'\badfluentia\b', 'affluentia'),
    (r'\badfluentia\b', 'affluo'),
    (r'\badfluentiam\b', 'affluentia'),
    (r'\badfluentibus\b', 'affluo'),
    (r'\badfluentibusque\b', 'affluo'),
    (r'\badfluentis\b', 'affluo'),
    (r'\badfluentium\b', 'affluo'),
    (r'\badfluentius\b', 'affluo'),
    (r'\badfluere\b', 'affluo'),
    (r'\badfluerent\b', 'affluo'),
    (r'\badflueret\b', 'affluo'),
    (r'\badfluetque\b', 'affluo'),
    (r'\badfluit\b', 'affluo'),
    (r'\badfluunt\b', 'affluo'),
    (r'\badfluxere\b', 'affluo'),
    (r'\badfluxerit\b', 'affluo'),
    (r'\badfluxisse\b', 'affluo'),
    (r'\badfluxit\b', 'affluo'),
    (r'\badfodimus\b', 'affodio'),
    (r'\badfore\b', 'adsum'),
    (r'\badforet\b', 'adsum'),
    (r'\badformido\b', 'adfixa'),
    (r'\badfrangere\b', 'affrango'),
    (r'\badfrangunt\b', 'affrango'),
    (r'\badfremit\b', 'affremo'),
    (r'\badfriat\b', 'adfixa'),
    (r'\badfricans\b', 'affrico'),
    (r'\badfricant\b', 'affrico'),
    (r'\badfricetur\b', 'affrico'),
    (r'\badfricta\b', 'affrico'),
    (r'\badfrictu\b', 'affrictus'),
    (r'\badfrictu\b', 'affrico'),
    (r'\badfricuit\b', 'affrico'),
    (r'\badfudero\b', 'affundo'),
    (r'\badfuerant\b', 'adsum'),
    (r'\badfuerat\b', 'adsum'),
    (r'\badfuere\b', 'adsum'),
    (r'\badfuerim\b', 'adsum'),
    (r'\badfuerint\b', 'adsum'),
    (r'\badfueris\b', 'adsum'),
    (r'\badfuerit\b', 'adsum'),
    (r'\badfuero\b', 'adsum'),
    (r'\badfuerunt\b', 'adsum'),
    (r'\badfui\b', 'adsum'),
    (r'\badfuisse\b', 'adsum'),
    (r'\badfuissem\b', 'adsum'),
    (r'\badfuissemus\b', 'adsum'),
    (r'\badfuissent\b', 'adsum'),
    (r'\badfuisses\b', 'adsum'),
    (r'\badfuisset\b', 'adsum'),
    (r'\badfuisti\b', 'adsum'),
    (r'\badfuistis\b', 'adsum'),
    (r'\badfuit\b', 'adsum'),
    (r'\badfulserat\b', 'affulgeo'),
    (r'\badfulserit\b', 'affulgeo'),
    (r'\badfulsisse\b', 'affulgeo'),
    (r'\badfulsisset\b', 'affulgeo'),
    (r'\badfulsit\b', 'affulgeo'),
    (r'\badfundam\b', 'affundo'),
    (r'\badfundere\b', 'affundo'),
    (r'\badfunderent\b', 'affundo'),
    (r'\badfunderentur\b', 'affundo'),
    (r'\badfundi\b', 'affundo'),
    (r'\badfundit\b', 'affundo'),
    (r'\badfunditur\b', 'affundo'),
    (r'\badfundunt\b', 'affundo'),
    (r'\badfusa\b', 'affundo'),
    (r'\badfusae\b', 'affundo'),
    (r'\badfusaeque\b', 'affundo'),
    (r'\badfusaque\b', 'affundo'),
    (r'\badfusi\b', 'affundo'),
    (r'\badfusique\b', 'affundo'),
    (r'\badfusis\b', 'affundo'),
    (r'\badfuso\b', 'affundo'),
    (r'\badfusum\b', 'affundo'),
    (r'\badfusus\b', 'affundo'),
    (r'\badfutura\b', 'adsum'),
    (r'\badfuturam\b', 'adsum'),
    (r'\badfuturi\b', 'adsum'),
    (r'\badfuturos\b', 'adsum'),
    (r'\badfuturum\b', 'adsum'),
    (r'\badfuturus\b', 'adsum'),
    (r'\badgemit\b', 'ad-guberno'),
    (r'\badgerebant\b', 'ad-guberno'),
    (r'\badgerebantur\b', 'ad-guberno'),
    (r'\badgerenda\b', 'ad-guberno'),
    (r'\badgerendo\b', 'ad-guberno'),
    (r'\badgerentem\b', 'ad-guberno'),
    (r'\badgerere\b', 'ad-guberno'),
    (r'\badgereret\b', 'ad-guberno'),
    (r'\badgeri\b', 'ad-guberno'),
    (r'\badgeritis\b', 'ad-guberno'),
    (r'\badgerunda\b', 'ad-guberno'),
    (r'\badgerunt\b', 'ad-guberno'),
    (r'\badgeruntur\b', 'ad-guberno'),
    (r'\badgesserat\b', 'ad-guberno'),
    (r'\badgessisse\b', 'ad-guberno'),
    (r'\badgessit\b', 'ad-guberno'),
    (r'\badgesta\b', 'aggestus1'),
    (r'\badgestamque\b', 'ad-guberno'),
    (r'\badgestaque\b', 'aggestus1'),
    (r'\badgesto\b', 'aggestus1'),
    (r'\badgestu\b', 'aggestus1'),
    (r'\badgestus\b', 'aggestus1'),
    (r'\badglomerant\b', 'ad-guberno'),
    (r'\badglomerantur\b', 'ad-guberno'),
    (r'\badglomerare\b', 'ad-guberno'),
    (r'\badglomerat\b', 'ad-guberno'),
    (r'\badglutinabis\b', 'ad-guberno'),
    (r'\badglutinabo\b', 'ad-guberno'),
    (r'\badglutinanda\b', 'ad-guberno'),
    (r'\badglutinandam\b', 'ad-guberno'),
    (r'\badglutinando\b', 'ad-guberno'),
    (r'\badglutinandum\b', 'ad-guberno'),
    (r'\badglutinant\b', 'ad-guberno'),
    (r'\badglutinantur\b', 'ad-guberno'),
    (r'\badglutinare\b', 'ad-guberno'),
    (r'\badglutinata\b', 'ad-guberno'),
    (r'\badglutinati\b', 'ad-guberno'),
    (r'\badglutinatis\b', 'ad-guberno'),
    (r'\badglutinato\b', 'ad-guberno'),
    (r'\badglutinavi\b', 'ad-guberno'),
    (r'\badglutinet\b', 'ad-guberno'),
    (r'\badglutinetur\b', 'ad-guberno'),
    (r'\badgnatio\b', 'agnatio'),
    (r'\badgnatione\b', 'agnatio'),
    (r'\badgnationis\b', 'agnatio'),
    (r'\badgnoscam\b', 'agnosco'),
    (r'\badgnoscat\b', 'agnosco'),
    (r'\badgnoscatis\b', 'agnosco'),
    (r'\badgnoscendae\b', 'agnosco'),
    (r'\badgnoscendi\b', 'agnosco'),
    (r'\badgnoscendo\b', 'agnosco'),
    (r'\badgnoscendum\b', 'agnosco'),
    (r'\badgnoscendus\b', 'agnosco'),
    (r'\badgnoscens\b', 'agnosco'),
    (r'\badgnoscensque\b', 'agnosco'),
    (r'\badgnoscent\b', 'agnosco'),
    (r'\badgnoscente\b', 'agnosco'),
    (r'\badgnoscentem\b', 'agnosco'),
    (r'\badgnoscentes\b', 'agnosco'),
    (r'\badgnoscentibus\b', 'agnosco'),
    (r'\badgnoscentis\b', 'agnosco'),
    (r'\badgnoscere\b', 'agnosco'),
    (r'\badgnoscerem\b', 'agnosco'),
    (r'\badgnoscereque\b', 'agnosco'),
    (r'\badgnosceret\b', 'agnosco'),
    (r'\badgnosceretur\b', 'agnosco'),
    (r'\badgnosces\b', 'agnosco'),
    (r'\badgnoscet\b', 'agnosco'),
    (r'\badgnosci\b', 'agnosco'),
    (r'\badgnoscimus\b', 'agnosco'),
    (r'\badgnoscis\b', 'agnosco'),
    (r'\badgnoscit\b', 'agnosco'),
    (r'\badgnoscitisne\b', 'agnosco'),
    (r'\badgnoscito\b', 'agnosco'),
    (r'\badgnoscitque\b', 'agnosco'),
    (r'\badgnoscitur\b', 'agnosco'),
    (r'\badgnosco\b', 'agnosco'),
    (r'\badgnoscor\b', 'agnosco'),
    (r'\badgnoscunt\b', 'agnosco'),
    (r'\badgnoscuntur\b', 'agnosco'),
    (r'\badgnouerat\b', 'agnosco'),
    (r'\badgnouerint\b', 'agnosco'),
    (r'\badgnouerit\b', 'agnosco'),
    (r'\badgnouerunt\b', 'agnosco'),
    (r'\badgnouisse\b', 'agnosco'),
    (r'\badgnouisset\b', 'agnosco'),
    (r'\badgnouit\b', 'agnosco'),
    (r'\badgnovi\b', 'agnosco'),
    (r'\badgnovissent\b', 'agnosco'),
    (r'\badgnovit\b', 'agnosco'),
    (r'\badgnovitque\b', 'agnosco'),
    (r'\badgrauando\b', 'ad-guberno'),
    (r'\badgrauante\b', 'ad-guberno'),
    (r'\badgrauantibus\b', 'ad-guberno'),
    (r'\badgrauare\b', 'ad-guberno'),
    (r'\badgrauaret\b', 'ad-guberno'),
    (r'\badgrauari\b', 'ad-guberno'),
    (r'\badgrauata\b', 'ad-guberno'),
    (r'\badgrauatae\b', 'ad-guberno'),
    (r'\badgrauatur\b', 'ad-guberno'),
    (r'\badgrauescere\b', 'ad-guberno'),
    (r'\badgrauet\b', 'ad-guberno'),
    (r'\badgrauetur\b', 'ad-guberno'),
    (r'\badgrava\b', 'ad-guberno'),
    (r'\badgravans\b', 'ad-guberno'),
    (r'\badgravant\b', 'ad-guberno'),
    (r'\badgravante\b', 'ad-guberno'),
    (r'\badgravare\b', 'ad-guberno'),
    (r'\badgravaret\b', 'ad-guberno'),
    (r'\badgravaretur\b', 'ad-guberno'),
    (r'\badgravari\b', 'ad-guberno'),
    (r'\badgravasti\b', 'ad-guberno'),
    (r'\badgravat\b', 'ad-guberno'),
    (r'\badgravata\b', 'ad-guberno'),
    (r'\badgravatae\b', 'ad-guberno'),
    (r'\badgravati\b', 'ad-guberno'),
    (r'\badgravatum\b', 'ad-guberno'),
    (r'\badgravatura\b', 'ad-guberno'),
    (r'\badgravaturam\b', 'ad-guberno'),
    (r'\badgravaturque\b', 'ad-guberno'),
    (r'\badgravaverunt\b', 'ad-guberno'),
    (r'\badgravavit\b', 'ad-guberno'),
    (r'\badgravescat\b', 'ad-guberno'),
    (r'\badgravescens\b', 'ad-guberno'),
    (r'\badgravetur\b', 'ad-guberno'),
    (r'\badgravor\b', 'ad-guberno'),
    (r'\badgredere\b', 'aggredior'),
    (r'\badgrederentur\b', 'aggredior'),
    (r'\badgrederer\b', 'aggredior'),
    (r'\badgrederetur\b', 'aggredior'),
    (r'\badgrederisne\b', 'aggredior'),
    (r'\badgredi\b', 'aggredior'),
    (r'\badgrediamur\b', 'aggredior'),
    (r'\badgrediantur\b', 'aggredior'),
    (r'\badgrediar\b', 'aggredior'),
    (r'\badgrediare\b', 'aggredior'),
    (r'\badgrediaris\b', 'aggredior'),
    (r'\badgrediatur\b', 'aggredior'),
    (r'\badgrediemur\b', 'aggredior'),
    (r'\badgredienda\b', 'aggredior'),
    (r'\badgrediendaeque\b', 'aggredior'),
    (r'\badgrediendam\b', 'aggredior'),
    (r'\badgrediendi\b', 'aggredior'),
    (r'\badgrediendo\b', 'aggredior'),
    (r'\badgrediendum\b', 'aggredior'),
    (r'\badgrediendus\b', 'aggredior'),
    (r'\badgrediens\b', 'aggredior'),
    (r'\badgredienti\b', 'aggredior'),
    (r'\badgredientibus\b', 'aggredior'),
    (r'\badgredientur\b', 'aggredior'),
    (r'\badgredieris\b', 'aggredior'),
    (r'\badgredimini\b', 'aggredior'),
    (r'\badgredimur\b', 'aggredior'),
    (r'\badgredior\b', 'aggredior'),
    (r'\badgreditur\b', 'aggredior'),
    (r'\badgrediturque\b', 'aggredior'),
    (r'\badgrediundos\b', 'aggredior'),
    (r'\badgrediundust\b', 'aggredior'),
    (r'\badgrediuntur\b', 'aggredior'),
    (r'\badgregabantur\b', 'ad-guberno'),
    (r'\badgregabat\b', 'ad-guberno'),
    (r'\badgregabuntur\b', 'ad-guberno'),
    (r'\badgregandae\b', 'ad-guberno'),
    (r'\badgregant\b', 'ad-guberno'),
    (r'\badgregantibus\b', 'ad-guberno'),
    (r'\badgregantur\b', 'ad-guberno'),
    (r'\badgregarant\b', 'ad-guberno'),
    (r'\badgregare\b', 'ad-guberno'),
    (r'\badgregarentur\b', 'ad-guberno'),
    (r'\badgregares\b', 'ad-guberno'),
    (r'\badgregaret\b', 'ad-guberno'),
    (r'\badgregaretur\b', 'ad-guberno'),
    (r'\badgregari\b', 'ad-guberno'),
    (r'\badgregarit\b', 'ad-guberno'),
    (r'\badgregassem\b', 'ad-guberno'),
    (r'\badgregat\b', 'ad-guberno'),
    (r'\badgregati\b', 'ad-guberno'),
    (r'\badgregatis\b', 'ad-guberno'),
    (r'\badgregatum\b', 'ad-guberno'),
    (r'\badgregatur\b', 'ad-guberno'),
    (r'\badgregauerat\b', 'ad-guberno'),
    (r'\badgregaverat\b', 'ad-guberno'),
    (r'\badgregavere\b', 'ad-guberno'),
    (r'\badgregent\b', 'ad-guberno'),
    (r'\badgregetur\b', 'ad-guberno'),
    (r'\badgressa\b', 'aggredior'),
    (r'\badgressae\b', 'aggredior'),
    (r'\badgressam\b', 'aggredior'),
    (r'\badgressas\b', 'aggredior'),
    (r'\badgressi\b', 'aggredior'),
    (r'\badgressio\b', 'aggressio'),
    (r'\badgressionem\b', 'aggressio'),
    (r'\badgressionibus\b', 'aggressio'),
    (r'\badgressionum\b', 'aggressio'),
    (r'\badgressique\b', 'aggredior'),
    (r'\badgressis\b', 'aggredior'),
    (r'\badgressores\b', 'aggressor'),
    (r'\badgressoribusque\b', 'aggressor'),
    (r'\badgressos\b', 'aggredior'),
    (r'\badgressu\b', 'aggressus2'),
    (r'\badgressu\b', 'aggredior'),
    (r'\badgressum\b', 'aggressus2'),
    (r'\badgressum\b', 'aggredior'),
    (r'\badgressura\b', 'aggressura'),
    (r'\badgressura\b', 'aggredior'),
    (r'\badgressurae\b', 'aggressura'),
    (r'\badgressurae\b', 'aggredior'),
    (r'\badgressuram\b', 'aggressura'),
    (r'\badgressuram\b', 'aggredior'),
    (r'\badgressuras\b', 'aggressura'),
    (r'\badgressuras\b', 'aggredior'),
    (r'\badgressuri\b', 'aggredior'),
    (r'\badgressuris\b', 'aggressura'),
    (r'\badgressuris\b', 'aggredior'),
    (r'\badgressuros\b', 'aggredior'),
    (r'\badgressurum\b', 'aggredior'),
    (r'\badgressurus\b', 'aggredior'),
    (r'\badgressus\b', 'aggressus2'),
    (r'\badgressus\b', 'aggredior'),
    (r'\badgressust\b', 'aggressus2'),
    (r'\badgressust\b', 'aggredior'),
    (r'\badgubernans\b', 'ad-guberno'),
    (r'\badgubernante\b', 'ad-guberno'),
    (r'\badhaereant\b', 'adhaereo'),
    (r'\badhaereat\b', 'adhaereo'),
    (r'\badhaerebant\b', 'adhaereo'),
    (r'\badhaerebat\b', 'adhaereo'),
    (r'\badhaerebatis\b', 'adhaereo'),
    (r'\badhaerebunt\b', 'adhaereo'),
    (r'\badhaeremus\b', 'adhaereo'),
    (r'\badhaerendo\b', 'adhaereo'),
    (r'\badhaerens\b', 'adhaereo'),
    (r'\badhaerensque\b', 'adhaereo'),
    (r'\badhaerent\b', 'adhaereo'),
    (r'\badhaerente\b', 'adhaereo'),
    (r'\badhaerentem\b', 'adhaereo'),
    (r'\badhaerentes\b', 'adhaereo'),
    (r'\badhaerentia\b', 'adhaereo'),
    (r'\badhaerentibus\b', 'adhaereo'),
    (r'\badhaerentis\b', 'adhaereo'),
    (r'\badhaerentium\b', 'adhaereo'),
    (r'\badhaerere\b', 'adhaereo'),
    (r'\badhaererent\b', 'adhaereo'),
    (r'\badhaereret\b', 'adhaereo'),
    (r'\badhaeres\b', 'adhaereo'),
    (r'\badhaerescas\b', 'adhaeresco'),
    (r'\badhaerescat\b', 'adhaeresco'),
    (r'\badhaerescens\b', 'adhaeresco'),
    (r'\badhaerescente\b', 'adhaeresco'),
    (r'\badhaerescentes\b', 'adhaeresco'),
    (r'\badhaerescentia\b', 'adhaeresco'),
    (r'\badhaerescere\b', 'adhaeresco'),
    (r'\badhaerescerent\b', 'adhaeresco'),
    (r'\badhaeresceret\b', 'adhaeresco'),
    (r'\badhaerescet\b', 'adhaeresco'),
    (r'\badhaerescit\b', 'adhaeresco'),
    (r'\badhaerescunt\b', 'adhaeresco'),
    (r'\badhaeret\b', 'adhaereo'),
    (r'\badhaese\b', 'adhaese'),
    (r'\badhaese\b', 'adhaereo'),
    (r'\badhaeserant\b', 'adhaereo'),
    (r'\badhaesere\b', 'adhaereo'),
    (r'\badhaeserint\b', 'adhaereo'),
    (r'\badhaeserit\b', 'adhaereo'),
    (r'\badhaeserunt\b', 'adhaereo'),
    (r'\badhaesi\b', 'adhaereo'),
    (r'\badhaesiones\b', 'adhaesio'),
    (r'\badhaesionibus\b', 'adhaesio'),
    (r'\badhaesisse\b', 'adhaereo'),
    (r'\badhaesisset\b', 'adhaereo'),
    (r'\badhaesit\b', 'adhaereo'),
    (r'\badhaesu\b', 'adhaesus'),
    (r'\badhaesu\b', 'adhaereo'),
    (r'\badhaesum\b', 'adhaesus'),
    (r'\badhaesum\b', 'adhaereo'),
    (r'\badhaesuram\b', 'adhaereo'),
    (r'\badhalaverit\b', 'adhalo'),
    (r'\badhibe\b', 'adhibeo'),
    (r'\badhibeam\b', 'adhibeo'),
    (r'\badhibeamus\b', 'adhibeo'),
    (r'\badhibeant\b', 'adhibeo'),
    (r'\badhibeantur\b', 'adhibeo'),
    (r'\badhibeas\b', 'adhibeo'),
    (r'\badhibeat\b', 'adhibeo'),
    (r'\badhibeatis\b', 'adhibeo'),
    (r'\badhibeatur\b', 'adhibeo'),
    (r'\badhibeaturque\b', 'adhibeo'),
    (r'\badhibebamur\b', 'adhibeo'),
    (r'\badhibebant\b', 'adhibeo'),
    (r'\badhibebantur\b', 'adhibeo'),
    (r'\badhibebanturque\b', 'adhibeo'),
    (r'\badhibebat\b', 'adhibeo'),
    (r'\badhibebatur\b', 'adhibeo'),
    (r'\badhibebimus\b', 'adhibeo'),
    (r'\badhibebis\b', 'adhibeo'),
    (r'\badhibebit\b', 'adhibeo'),
    (r'\badhibebitis\b', 'adhibeo'),
    (r'\badhibebitur\b', 'adhibeo'),
    (r'\badhibebo\b', 'adhibeo'),
    (r'\badhibebuntur\b', 'adhibeo'),
    (r'\badhibemur\b', 'adhibeo'),
    (r'\badhibemus\b', 'adhibeo'),
    (r'\badhiben\b', 'adhibeo'),
    (r'\badhibenda\b', 'adhibeo'),
    (r'\badhibendae\b', 'adhibeo'),
    (r'\badhibendam\b', 'adhibeo'),
    (r'\badhibendaque\b', 'adhibeo'),
    (r'\badhibendas\b', 'adhibeo'),
    (r'\badhibendasque\b', 'adhibeo'),
    (r'\badhibendast\b', 'adhibeo'),
    (r'\badhibendi\b', 'adhibeo'),
    (r'\badhibendis\b', 'adhibeo'),
    (r'\badhibendo\b', 'adhibeo'),
    (r'\badhibendos\b', 'adhibeo'),
    (r'\badhibendum\b', 'adhibeo'),
    (r'\badhibendumne\b', 'adhibeo'),
    (r'\badhibendus\b', 'adhibeo'),
    (r'\badhibens\b', 'adhibeo'),
    (r'\badhibent\b', 'adhibeo'),
    (r'\badhibentem\b', 'adhibeo'),
    (r'\badhibentes\b', 'adhibeo'),
    (r'\badhibenti\b', 'adhibeo'),
    (r'\badhibentibus\b', 'adhibeo'),
    (r'\badhibentis\b', 'adhibeo'),
    (r'\badhibento\b', 'adhibeo'),
    (r'\badhibentur\b', 'adhibeo'),
    (r'\badhibeo\b', 'adhibeo'),
    (r'\badhibere\b', 'adhibeo'),
    (r'\badhiberemus\b', 'adhibeo'),
    (r'\badhiberent\b', 'adhibeo'),
    (r'\badhiberentur\b', 'adhibeo'),
    (r'\badhiberes\b', 'adhibeo'),
    (r'\badhiberet\b', 'adhibeo'),
    (r'\badhiberetis\b', 'adhibeo'),
    (r'\badhiberetur\b', 'adhibeo'),
    (r'\badhiberi\b', 'adhibeo'),
    (r'\badhibes\b', 'adhibeo'),
    (r'\badhibet\b', 'adhibeo'),
    (r'\badhibete\b', 'adhibeo'),
    (r'\badhibetis\b', 'adhibeo'),
    (r'\badhibeto\b', 'adhibeo'),
    (r'\badhibetur\b', 'adhibeo'),
    (r'\badhibeturque\b', 'adhibeo'),
    (r'\badhibita\b', 'adhibeo'),
    (r'\badhibitae\b', 'adhibeo'),
    (r'\badhibitam\b', 'adhibeo'),
    (r'\badhibitarum\b', 'adhibeo'),
    (r'\badhibiti\b', 'adhibeo'),
    (r'\badhibitione\b', 'adhibitio'),
    (r'\badhibitis\b', 'adhibeo'),
    (r'\badhibitisque\b', 'adhibeo'),
    (r'\badhibito\b', 'adhibeo'),
    (r'\badhibitoque\b', 'adhibeo'),
    (r'\badhibitos\b', 'adhibeo'),
    (r'\badhibitum\b', 'adhibeo'),
    (r'\badhibituram\b', 'adhibeo'),
    (r'\badhibituri\b', 'adhibeo'),
    (r'\badhibiturus\b', 'adhibeo'),
    (r'\badhibitus\b', 'adhibeo'),
    (r'\badhibuerat\b', 'adhibeo'),
    (r'\badhibuerim\b', 'adhibeo'),
    (r'\badhibuerint\b', 'adhibeo'),
    (r'\badhibueris\b', 'adhibeo'),
    (r'\badhibuerit\b', 'adhibeo'),
    (r'\badhibueritis\b', 'adhibeo'),
    (r'\badhibuero\b', 'adhibeo'),
    (r'\badhibuerunt\b', 'adhibeo'),
    (r'\badhibui\b', 'adhibeo'),
    (r'\badhibuimus\b', 'adhibeo'),
    (r'\badhibuisse\b', 'adhibeo'),
    (r'\badhibuissem\b', 'adhibeo'),
    (r'\badhibuissent\b', 'adhibeo'),
    (r'\badhibuisses\b', 'adhibeo'),
    (r'\badhibuisset\b', 'adhibeo'),
    (r'\badhibuissetque\b', 'adhibeo'),
    (r'\badhibuisti\b', 'adhibeo'),
    (r'\badhibuistis\b', 'adhibeo'),
    (r'\badhibuit\b', 'adhibeo'),
    (r'\badhibuitque\b', 'adhibeo'),
    (r'\badhinnire\b', 'adhinnio'),
    (r'\badhinnit\b', 'adhinnio'),
    (r'\badhinnivere\b', 'adhinnio'),
    (r'\badhinnivit\b', 'adhinnio'),
    (r'\badhorruit\b', 'adhorreo'),
    (r'\badhortabar\b', 'adhortor'),
    (r'\badhortabatur\b', 'adhortor'),
    (r'\badhortabimur\b', 'adhortor'),
    (r'\badhortabitur\b', 'adhortor'),
    (r'\badhortamina\b', 'adhortamen'),
    (r'\badhortamini\b', 'adhortamen'),
    (r'\badhortamini\b', 'adhortor'),
    (r'\badhortandas\b', 'adhortor'),
    (r'\badhortandi\b', 'adhortor'),
    (r'\badhortando\b', 'adhortor'),
    (r'\badhortandoque\b', 'adhortor'),
    (r'\badhortandorum\b', 'adhortor'),
    (r'\badhortandos\b', 'adhortor'),
    (r'\badhortandosque\b', 'adhortor'),
    (r'\badhortandus\b', 'adhortor'),
    (r'\badhortans\b', 'adhortor'),
    (r'\badhortante\b', 'adhortor'),
    (r'\badhortantem\b', 'adhortor'),
    (r'\badhortantes\b', 'adhortor'),
    (r'\badhortantesque\b', 'adhortor'),
    (r'\badhortanti\b', 'adhortor'),
    (r'\badhortantibus\b', 'adhortor'),
    (r'\badhortantis\b', 'adhortor'),
    (r'\badhortantium\b', 'adhortor'),
    (r'\badhortantur\b', 'adhortor'),
    (r'\badhortare\b', 'adhortor'),
    (r'\badhortarentur\b', 'adhortor'),
    (r'\badhortarer\b', 'adhortor'),
    (r'\badhortaretur\b', 'adhortor'),
    (r'\badhortari\b', 'adhortor'),
    (r'\badhortaris\b', 'adhortor'),
    (r'\badhortat\b', 'adhortor'),
    (r'\badhortata\b', 'adhortatus1'),
    (r'\badhortata\b', 'adhortor'),
    (r'\badhortatae\b', 'adhortatus1'),
    (r'\badhortatae\b', 'adhortor'),
    (r'\badhortatam\b', 'adhortatus1'),
    (r'\badhortatam\b', 'adhortor'),
    (r'\badhortati\b', 'adhortatus1'),
    (r'\badhortati\b', 'adhortor'),
    (r'\badhortatio\b', 'adhortatio'),
    (r'\badhortatione\b', 'adhortatio'),
    (r'\badhortationem\b', 'adhortatio'),
    (r'\badhortationes\b', 'adhortatio'),
    (r'\badhortationesque\b', 'adhortatio'),
    (r'\badhortationibus\b', 'adhortatio'),
    (r'\badhortationis\b', 'adhortatio'),
    (r'\badhortatique\b', 'adhortatus1'),
    (r'\badhortatique\b', 'adhortor'),
    (r'\badhortator\b', 'adhortator'),
    (r'\badhortatore\b', 'adhortator'),
    (r'\badhortatorque\b', 'adhortator'),
    (r'\badhortatu\b', 'adhortatus1'),
    (r'\badhortatu\b', 'adhortor'),
    (r'\badhortatum\b', 'adhortatus1'),
    (r'\badhortatum\b', 'adhortatus1'),
    (r'\badhortatum\b', 'adhortor'),
    (r'\badhortatur\b', 'adhortor'),
    (r'\badhortatus\b', 'adhortatus1'),
    (r'\badhortatus\b', 'adhortor'),
    (r'\badhortentur\b', 'adhortor'),
    (r'\badhorter\b', 'adhortor'),
    (r'\badhortere\b', 'adhortor'),
    (r'\badhorteris\b', 'adhortor'),
    (r'\badhortetur\b', 'adhortor'),
    (r'\badhortor\b', 'adhortor'),
    (r'\badhuc\b', 'adhuc'),
    (r'\badi\b', 'adeo1'),
    (r'\bAdiabene\b', 'adiantum'),
    (r'\bAdiabene\b', 'adiantum'),
    (r'\bAdiabenen\b', 'adiantum'),
    (r'\bAdiabeni\b', 'adiantum'),
    (r'\bAdiabeni\b', 'adiantum'),
    (r'\bAdiabenis\b', 'Adiabena'),
    (r'\bAdiabenis\b', 'adiantum'),
    (r'\bAdiabenis\b', 'adiantum'),
    (r'\bAdiabeno\b', 'adiantum'),
    (r'\bAdiabenorum\b', 'adiantum'),
    (r'\bAdiabenorum\b', 'adiantum'),
    (r'\bAdiabenos\b', 'adiantum'),
    (r'\bAdiabenosque\b', 'adiantum'),
    (r'\bAdiabenum\b', 'adiantum'),
    (r'\bAdiabenum\b', 'adiantum'),
    (r'\bAdiabenus\b', 'adiantum'),
    (r'\badiaceat\b', 'adjaceo'),
    (r'\badiacebant\b', 'adjaceo'),
    (r'\badiacebat\b', 'adjaceo'),
    (r'\badiacens\b', 'adjaceo'),
    (r'\badiacent\b', 'adjaceo'),
    (r'\badiacente\b', 'adjaceo'),
    (r'\badiacentem\b', 'adjaceo'),
    (r'\badiacentes\b', 'adjaceo'),
    (r'\badiacentia\b', 'adjacentia'),
    (r'\badiacentia\b', 'adjaceo'),
    (r'\badiacentibus\b', 'adjacentia'),
    (r'\badiacentibus\b', 'adjaceo'),
    (r'\badiacentis\b', 'adjaceo'),
    (r'\badiacentium\b', 'adjacentia'),
    (r'\badiacentium\b', 'adjaceo'),
    (r'\badiacere\b', 'adicio'),
    (r'\badiacerent\b', 'adicio'),
    (r'\badiacet\b', 'adjaceo'),
    (r'\badiacuit\b', 'adjaceo'),
    (r'\badiacuitque\b', 'adjaceo'),
    (r'\badianto\b', 'adiantum'),
    (r'\badiantum\b', 'adiantum'),
    (r'\badibam\b', 'adeo1'),
    (r'\badibant\b', 'adeo1'),
    (r'\badibat\b', 'adeo1'),
    (r'\badibatur\b', 'adeo1'),
    (r'\badibimus\b', 'adeo1'),
    (r'\badibis\b', 'adeo1'),
    (r'\badibit\b', 'adeo1'),
    (r'\badibitis\b', 'adeo1'),
    (r'\badibitur\b', 'adeo1'),
    (r'\badibo\b', 'adeo1'),
    (r'\badibon\b', 'adeo1'),
    (r'\badice\b', 'adicio'),
    (r'\badicere\b', 'adicio'),
    (r'\badicerem\b', 'adicio'),
    (r'\badicerent\b', 'adicio'),
    (r'\badicerentque\b', 'adicio'),
    (r'\badicerentur\b', 'adicio'),
    (r'\badiceres\b', 'adicio'),
    (r'\badiceret\b', 'adicio'),
    (r'\badiceretque\b', 'adicio'),
    (r'\badiceretur\b', 'adicio'),
    (r'\badices\b', 'adigo'),
    (r'\badices\b', 'adigo'),
    (r'\badici\b', 'adicio'),
    (r'\badiciam\b', 'adicio'),
    (r'\badiciamque\b', 'adicio'),
    (r'\badiciamus\b', 'adicio'),
    (r'\badiciant\b', 'adicio'),
    (r'\badiciantur\b', 'adicio'),
    (r'\badicias\b', 'adicio'),
    (r'\badiciat\b', 'adicio'),
    (r'\badiciatne\b', 'adicio'),
    (r'\badiciatur\b', 'adicio'),
    (r'\badiciebam\b', 'adicio'),
    (r'\badiciebamus\b', 'adicio'),
    (r'\badiciebant\b', 'adicio'),
    (r'\badiciebantur\b', 'adicio'),
    (r'\badiciebat\b', 'adicio'),
    (r'\badiciebatque\b', 'adicio'),
    (r'\badiciebatur\b', 'adicio'),
    (r'\badiciemus\b', 'adicio'),
    (r'\badicienda\b', 'adicio'),
    (r'\badiciendae\b', 'adicio'),
    (r'\badiciendam\b', 'adicio'),
    (r'\badiciendaque\b', 'adicio'),
    (r'\badiciendi\b', 'adicio'),
    (r'\badiciendo\b', 'adicio'),
    (r'\badiciendos\b', 'adicio'),
    (r'\badiciendum\b', 'adicio'),
    (r'\badiciendumque\b', 'adicio'),
    (r'\badiciendus\b', 'adicio'),
    (r'\badiciendusque\b', 'adicio'),
    (r'\badiciens\b', 'adicio'),
    (r'\badicient\b', 'adicio'),
    (r'\badiciente\b', 'adicio'),
    (r'\badicientem\b', 'adicio'),
    (r'\badicientes\b', 'adicio'),
    (r'\badicientesque\b', 'adicio'),
    (r'\badicientibus\b', 'adicio'),
    (r'\badicientur\b', 'adicio'),
    (r'\badicies\b', 'adicio'),
    (r'\badiciet\b', 'adicio'),
    (r'\badicietur\b', 'adicio'),
    (r'\badicimus\b', 'adicio'),
    (r'\badicio\b', 'adicio'),
    (r'\badicis\b', 'adicio'),
    (r'\badicit\b', 'adicio'),
    (r'\badicite\b', 'adicio'),
    (r'\badicitis\b', 'adicio'),
    (r'\badicito\b', 'adicio'),
    (r'\badicitque\b', 'adicio'),
    (r'\badicitur\b', 'adicio'),
    (r'\badiciturque\b', 'adicio'),
    (r'\badiciunt\b', 'adicio'),
    (r'\badiciuntque\b', 'adicio'),
    (r'\badiciuntur\b', 'adicio'),
    (r'\badiciunturque\b', 'adicio'),
    (r'\badieceramus\b', 'adicio'),
    (r'\badiecerant\b', 'adicio'),
    (r'\badieceras\b', 'adicio'),
    (r'\badiecerat\b', 'adicio'),
    (r'\badieceratque\b', 'adicio'),
    (r'\badiecere\b', 'adicio'),
    (r'\badiecerim\b', 'adicio'),
    (r'\badiecerint\b', 'adicio'),
    (r'\badieceris\b', 'adicio'),
    (r'\badiecerit\b', 'adicio'),
    (r'\badieceritis\b', 'adicio'),
    (r'\badiecero\b', 'adicio'),
    (r'\badiecerunt\b', 'adicio'),
    (r'\badieceruntque\b', 'adicio'),
    (r'\badieci\b', 'adicio'),
    (r'\badiecimus\b', 'adicio'),
    (r'\badiecisse\b', 'adicio'),
    (r'\badiecissem\b', 'adicio'),
    (r'\badiecissent\b', 'adicio'),
    (r'\badiecissentque\b', 'adicio'),
    (r'\badiecisses\b', 'adicio'),
    (r'\badiecisset\b', 'adicio'),
    (r'\badiecissetis\b', 'adicio'),
    (r'\badiecissetque\b', 'adicio'),
    (r'\badiecisti\b', 'adicio'),
    (r'\badiecit\b', 'adicio'),
    (r'\badiecitque\b', 'adicio'),
    (r'\badiecta\b', 'adicio'),
    (r'\badiectae\b', 'adicio'),
    (r'\badiectaeque\b', 'adicio'),
    (r'\badiectam\b', 'adicio'),
    (r'\badiectaque\b', 'adicio'),
    (r'\badiectas\b', 'adicio'),
    (r'\badiecti\b', 'adicio'),
    (r'\badiectio\b', 'adjectio'),
    (r'\badiectione\b', 'adjectio'),
    (r'\badiectionem\b', 'adjectio'),
    (r'\badiectiones\b', 'adjectio'),
    (r'\badiectionibus\b', 'adjectio'),
    (r'\badiectionis\b', 'adjectio'),
    (r'\badiectionum\b', 'adjectio'),
    (r'\badiectique\b', 'adicio'),
    (r'\badiectis\b', 'adicio'),
    (r'\badiectiva\b', 'adjectivus'),
    (r'\badiecto\b', 'adicio'),
    (r'\badiectoque\b', 'adicio'),
    (r'\badiectos\b', 'adicio'),
    (r'\badiectu\b', 'adjectus2'),
    (r'\badiectu\b', 'adicio'),
    (r'\badiectum\b', 'adjectus2'),
    (r'\badiectum\b', 'adicio'),
    (r'\badiectumque\b', 'adjectus2'),
    (r'\badiectumque\b', 'adicio'),
    (r'\badiectura\b', 'adicio'),
    (r'\badiecturam\b', 'adicio'),
    (r'\badiecturum\b', 'adicio'),
    (r'\badiecturus\b', 'adicio'),
    (r'\badiectus\b', 'adjectus2'),
    (r'\badiectus\b', 'adicio'),
    (r'\badierant\b', 'adeo1'),
    (r'\badierat\b', 'adeo1'),
    (r'\badiere\b', 'adeo1'),
    (r'\badierimus\b', 'adeo1'),
    (r'\badierint\b', 'adeo1'),
    (r'\badieris\b', 'adeo1'),
    (r'\badierit\b', 'adeo1'),
    (r'\badierunt\b', 'adeo1'),
    (r'\badieruntque\b', 'adeo1'),
    (r'\badigam\b', 'adigo'),
    (r'\badigat\b', 'adigo'),
    (r'\badigatur\b', 'adigo'),
    (r'\badigebant\b', 'adigo'),
    (r'\badigebantur\b', 'adigo'),
    (r'\badigebanturque\b', 'adigo'),
    (r'\badigebat\b', 'adigo'),
    (r'\badigebatur\b', 'adigo'),
    (r'\badigebaturque\b', 'adigo'),
    (r'\badigenda\b', 'adigo'),
    (r'\badigendo\b', 'adigo'),
    (r'\badigendum\b', 'adigo'),
    (r'\badigendus\b', 'adigo'),
    (r'\badigente\b', 'adigo'),
    (r'\badigere\b', 'adigo'),
    (r'\badigerent\b', 'adigo'),
    (r'\badigerentur\b', 'adigo'),
    (r'\badigeret\b', 'adigo'),
    (r'\badigeretur\b', 'adigo'),
    (r'\badiges\b', 'adigo'),
    (r'\badiget\b', 'adigo'),
    (r'\badigi\b', 'adigo'),
    (r'\badigis\b', 'adigo'),
    (r'\badigit\b', 'adigo'),
    (r'\badigito\b', 'adigo'),
    (r'\badigitque\b', 'adigo'),
    (r'\badigitur\b', 'adigo'),
    (r'\badigunt\b', 'adigo'),
    (r'\badiguntur\b', 'adigo'),
    (r'\badii\b', 'adeo1'),
    (r'\badiicere\b', 'adjicio'),
    (r'\badiicerent\b', 'adjicio'),
    (r'\badiiciens\b', 'adjicio'),
    (r'\badiimus\b', 'adeo1'),
    (r'\badiisse\b', 'adeo1'),
    (r'\badiisset\b', 'adeo1'),
    (r'\badiisti\b', 'adeo1'),
    (r'\badiit\b', 'adeo1'),
    (r'\badiitque\b', 'adeo1'),
    (r'\badimam\b', 'adimo'),
    (r'\badimant\b', 'adimo'),
    (r'\badimas\b', 'adimo'),
    (r'\badimat\b', 'adimo'),
    (r'\badimatur\b', 'adimo'),
    (r'\badimebant\b', 'adimo'),
    (r'\badimebat\b', 'adimo'),
    (r'\badimebatur\b', 'adimo'),
    (r'\badimemus\b', 'adimo'),
    (r'\badimenda\b', 'adimo'),
    (r'\badimendae\b', 'adimo'),
    (r'\badimendam\b', 'adimo'),
    (r'\badimendi\b', 'adimo'),
    (r'\badimendis\b', 'adimo'),
    (r'\badimendo\b', 'adimo'),
    (r'\badimendoque\b', 'adimo'),
    (r'\badimendum\b', 'adimo'),
    (r'\badimendus\b', 'adimo'),
    (r'\badiment\b', 'adimo'),
    (r'\badimente\b', 'adimo'),
    (r'\badimentes\b', 'adimo'),
    (r'\badimere\b', 'adimo'),
    (r'\badimerem\b', 'adimo'),
    (r'\badimerent\b', 'adimo'),
    (r'\badimerentur\b', 'adimo'),
    (r'\badimeret\b', 'adimo'),
    (r'\badimeretur\b', 'adimo'),
    (r'\badimet\b', 'adimo'),
    (r'\badimetur\b', 'adimo'),
    (r'\badimi\b', 'adimo'),
    (r'\badimimus\b', 'adimo'),
    (r'\badimique\b', 'adimo'),
    (r'\badimis\b', 'adimo'),
    (r'\badimisque\b', 'adimo'),
    (r'\badimit\b', 'adimo'),
    (r'\badimitis\b', 'adimo'),
    (r'\badimito\b', 'adimo'),
    (r'\badimitque\b', 'adimo'),
    (r'\badimitur\b', 'adimo'),
    (r'\badimo\b', 'adimo'),
    (r'\badimpleantur\b', 'adimpleo'),
    (r'\badimpleatur\b', 'adimpleo'),
    (r'\badimplebis\b', 'adimpleo'),
    (r'\badimplebit\b', 'adimpleo'),
    (r'\badimplebitis\b', 'adimpleo'),
    (r'\badimplebitur\b', 'adimpleo'),
    (r'\badimplenda\b', 'adimpleo'),
    (r'\badimpleo\b', 'adimpleo'),
    (r'\badimplere\b', 'adimpleo'),
    (r'\badimpleretur\b', 'adimpleo'),
    (r'\badimplesse\b', 'adimpleo'),
    (r'\badimplet\b', 'adimpleo'),
    (r'\badimpleta\b', 'adimpleo'),
    (r'\badimpletae\b', 'adimpleo'),
    (r'\badimpleti\b', 'adimpleo'),
    (r'\badimpletione\b', 'adimpletio'),
    (r'\badimpletum\b', 'adimpleo'),
    (r'\badimpletur\b', 'adimpleo'),
    (r'\badimpletus\b', 'adimpleo'),
    (r'\badimpleuerit\b', 'adimpleo'),
    (r'\badimplevit\b', 'adimpleo'),
    (r'\badimunt\b', 'adimo'),
    (r'\badimuntque\b', 'adimo'),
    (r'\badimuntur\b', 'adimo'),
    (r'\badimus\b', 'adeo1'),
    (r'\badin\b', 'adeo1'),
    (r'\badincrescant\b', 'adincresco'),
    (r'\badindito\b', 'adindo'),
    (r'\badinspectantium\b', 'ad-inspecto'),
    (r'\badinuentum\b', 'adinventum'),
    (r'\badinuentum\b', 'adinvenio'),
    (r'\badinvenire\b', 'adinvenio'),
    (r'\badinveniri\b', 'adinvenio'),
    (r'\badinvenit\b', 'adinvenio'),
    (r'\badinventio\b', 'adinventio'),
    (r'\badinventionem\b', 'adinventio'),
    (r'\badinventiones\b', 'adinventio'),
    (r'\badinventionibus\b', 'adinventio'),
    (r'\badinventionum\b', 'adinventio'),
    (r'\badipale\b', 'adipalis'),
    (r'\badipata\b', 'adipatus'),
    (r'\badipata\b', 'adipatum'),
    (r'\badipatam\b', 'adipatus'),
    (r'\badipsatheo\b', 'adipsatheon'),
    (r'\badipso\b', 'adipsos'),
    (r'\badipson\b', 'adipsos'),
    (r'\badipsos\b', 'adipsos'),
    (r'\badire\b', 'adeo1'),
    (r'\badirem\b', 'adeo1'),
    (r'\badiremus\b', 'adeo1'),
    (r'\badirent\b', 'adeo1'),
    (r'\badirentue\b', 'adeo1'),
    (r'\badirentur\b', 'adeo1'),
    (r'\badires\b', 'adeo1'),
    (r'\badiret\b', 'adeo1'),
    (r'\badiretis\b', 'adeo1'),
    (r'\badiretur\b', 'adeo1'),
    (r'\badiri\b', 'adeo1'),
    (r'\badirier\b', 'adeo1'),
    (r'\badis\b', 'adeo1'),
    (r'\badisse\b', 'adeo1'),
    (r'\badissem\b', 'adeo1'),
    (r'\badissemus\b', 'adeo1'),
    (r'\badissent\b', 'adeo1'),
    (r'\badisses\b', 'adeo1'),
    (r'\badisset\b', 'adeo1'),
    (r'\badisti\b', 'adeo1'),
    (r'\badistis\b', 'adeo1'),
    (r'\badit\b', 'adeo1'),
    (r'\badita\b', 'adeo1'),
    (r'\badita\b', 'adito'),
    (r'\baditae\b', 'adeo1'),
    (r'\baditam\b', 'adeo1'),
    (r'\baditamque\b', 'adeo1'),
    (r'\baditaque\b', 'adeo1'),
    (r'\baditaque\b', 'adito'),
    (r'\baditast\b', 'adeo1'),
    (r'\baditast\b', 'adito'),
    (r'\baditauere\b', 'adito'),
    (r'\badite\b', 'adeo1'),
    (r'\baditi\b', 'adeo1'),
    (r'\baditiales\b', 'aditialis'),
    (r'\baditiali\b', 'aditialis'),
    (r'\baditialibus\b', 'aditialis'),
    (r'\baditio\b', 'aditio'),
    (r'\baditione\b', 'aditio'),
    (r'\baditionem\b', 'aditio'),
    (r'\baditioni\b', 'aditio'),
    (r'\baditionis\b', 'aditio'),
    (r'\baditique\b', 'adeo1'),
    (r'\baditis\b', 'adeo1'),
    (r'\badito\b', 'adeo1'),
    (r'\badito\b', 'adito'),
    (r'\baditoque\b', 'adeo1'),
    (r'\baditoque\b', 'adito'),
    (r'\baditos\b', 'adeo1'),
    (r'\baditu\b', 'aditus2'),
    (r'\baditu\b', 'adeo1'),
    (r'\baditum\b', 'aditus2'),
    (r'\baditum\b', 'adeo1'),
    (r'\baditumque\b', 'aditus2'),
    (r'\baditumque\b', 'adeo1'),
    (r'\badituque\b', 'aditus2'),
    (r'\badituque\b', 'adeo1'),
    (r'\baditur\b', 'adeo1'),
    (r'\baditura\b', 'adeo1'),
    (r'\baditure\b', 'adeo1'),
    (r'\badituri\b', 'adeo1'),
    (r'\badituris\b', 'adeo1'),
    (r'\badituro\b', 'adeo1'),
    (r'\badituros\b', 'adeo1'),
    (r'\baditurum\b', 'adeo1'),
    (r'\baditurumque\b', 'adeo1'),
    (r'\baditurus\b', 'adeo1'),
    (r'\baditus\b', 'aditus2'),
    (r'\baditus\b', 'adeo1'),
    (r'\baditusque\b', 'aditus2'),
    (r'\baditusque\b', 'adeo1'),
    (r'\badiudicabit\b', 'adjudico'),
    (r'\badiudicabitur\b', 'adjudico'),
    (r'\badiudicando\b', 'adjudico'),
    (r'\badiudicandum\b', 'adjudico'),
    (r'\badiudicandus\b', 'adjudico'),
    (r'\badiudicare\b', 'adjudico'),
    (r'\badiudicaret\b', 'adjudico'),
    (r'\badiudicari\b', 'adjudico'),
    (r'\badiudicarier\b', 'adjudico'),
    (r'\badiudicarit\b', 'adjudico'),
    (r'\badiudicat\b', 'adjudico'),
    (r'\badiudicata\b', 'adjudico'),
    (r'\badiudicatae\b', 'adjudico'),
    (r'\badiudicatam\b', 'adjudico'),
    (r'\badiudicati\b', 'adjudico'),
    (r'\badiudicatio\b', 'adjudicatio'),
    (r'\badiudicatione\b', 'adjudicatio'),
    (r'\badiudicationem\b', 'adjudicatio'),
    (r'\badiudicationes\b', 'adjudicatio'),
    (r'\badiudicationibus\b', 'adjudicatio'),
    (r'\badiudicatis\b', 'adjudico'),
    (r'\badiudicato\b', 'adjudico'),
    (r'\badiudicatum\b', 'adjudico'),
    (r'\badiudicatur\b', 'adjudico'),
    (r'\badiudicaturos\b', 'adjudico'),
    (r'\badiudicaturus\b', 'adjudico'),
    (r'\badiudicatus\b', 'adjudico'),
    (r'\badiudicatusque\b', 'adjudico'),
    (r'\badiudicauerat\b', 'adjudico'),
    (r'\badiudicauerit\b', 'adjudico'),
    (r'\badiudicauit\b', 'adjudico'),
    (r'\badiudicaveritis\b', 'adjudico'),
    (r'\badiudicavit\b', 'adjudico'),
    (r'\badiudicet\b', 'adjudico'),
    (r'\badiudicetur\b', 'adjudico'),
    (r'\badiuerit\b', 'adeo1'),
    (r'\badiuero\b', 'adeo1'),
    (r'\badiugat\b', 'adjugo'),
    (r'\badiugatae\b', 'adjugo'),
    (r'\badiuit\b', 'adeo1'),
    (r'\badiumenta\b', 'adjumentum'),
    (r'\badiumenti\b', 'adjumentum'),
    (r'\badiumentique\b', 'adjumentum'),
    (r'\badiumentis\b', 'adjumentum'),
    (r'\badiumento\b', 'adjumentum'),
    (r'\badiumentum\b', 'adjumentum'),
    (r'\badiuncta\b', 'adjunctio'),
    (r'\badiuncta\b', 'adjungo'),
    (r'\badiunctae\b', 'adjungo'),
    (r'\badiunctam\b', 'adjungo'),
    (r'\badiunctaque\b', 'adjunctio'),
    (r'\badiunctaque\b', 'adjungo'),
    (r'\badiunctas\b', 'adjungo'),
    (r'\badiuncti\b', 'adjungo'),
    (r'\badiunctio\b', 'adjunctio'),
    (r'\badiunctione\b', 'adjunctio'),
    (r'\badiunctionem\b', 'adjunctio'),
    (r'\badiunctiora\b', 'adjungo'),
    (r'\badiunctis\b', 'adjunctio'),
    (r'\badiunctis\b', 'adjungo'),
    (r'\badiuncto\b', 'adjungo'),
    (r'\badiunctoque\b', 'adjungo'),
    (r'\badiunctor\b', 'adjunctor'),
    (r'\badiunctos\b', 'adjungo'),
    (r'\badiunctum\b', 'adjunctio'),
    (r'\badiunctum\b', 'adjungo'),
    (r'\badiuncturos\b', 'adjungo'),
    (r'\badiuncturum\b', 'adjungo'),
    (r'\badiuncturus\b', 'adjungo'),
    (r'\badiunctus\b', 'adjungo'),
    (r'\badiungam\b', 'adjungo'),
    (r'\badiungamus\b', 'adjungo'),
    (r'\badiungant\b', 'adjungo'),
    (r'\badiungas\b', 'adjungo'),
    (r'\badiungat\b', 'adjungo'),
    (r'\badiungatur\b', 'adjungo'),
    (r'\badiunge\b', 'adjungo'),
    (r'\badiungebant\b', 'adjungo'),
    (r'\badiungebat\b', 'adjungo'),
    (r'\badiungebatur\b', 'adjungo'),
    (r'\badiungemus\b', 'adjungo'),
    (r'\badiungenda\b', 'adjungo'),
    (r'\badiungendam\b', 'adjungo'),
    (r'\badiungendi\b', 'adjungo'),
    (r'\badiungendis\b', 'adjungo'),
    (r'\badiungendo\b', 'adjungo'),
    (r'\badiungendorum\b', 'adjungo'),
    (r'\badiungendos\b', 'adjungo'),
    (r'\badiungendum\b', 'adjungo'),
    (r'\badiungendus\b', 'adjungo'),
    (r'\badiungens\b', 'adjungo'),
    (r'\badiungentes\b', 'adjungo'),
    (r'\badiungenti\b', 'adjungo'),
    (r'\badiungentur\b', 'adjungo'),
    (r'\badiungere\b', 'adjungo'),
    (r'\badiungerem\b', 'adjungo'),
    (r'\badiungeremus\b', 'adjungo'),
    (r'\badiungerent\b', 'adjungo'),
    (r'\badiungerentur\b', 'adjungo'),
    (r'\badiungerer\b', 'adjungo'),
    (r'\badiungeret\b', 'adjungo'),
    (r'\badiungeretur\b', 'adjungo'),
    (r'\badiunges\b', 'adjungo'),
    (r'\badiunget\b', 'adjungo'),
    (r'\badiungetur\b', 'adjungo'),
    (r'\badiungi\b', 'adjungo'),
    (r'\badiungier\b', 'adjungo'),
    (r'\badiungimus\b', 'adjungo'),
    (r'\badiungis\b', 'adjungo'),
    (r'\badiungit\b', 'adjungo'),
    (r'\badiungite\b', 'adjungo'),
    (r'\badiungitis\b', 'adjungo'),
    (r'\badiungito\b', 'adjungo'),
    (r'\badiungitque\b', 'adjungo'),
    (r'\badiungitur\b', 'adjungo'),
    (r'\badiungo\b', 'adjungo'),
    (r'\badiungunt\b', 'adjungo'),
    (r'\badiunguntque\b', 'adjungo'),
    (r'\badiunguntur\b', 'adjungo'),
    (r'\badiunxeram\b', 'adjungo'),
    (r'\badiunxerant\b', 'adjungo'),
    (r'\badiunxerat\b', 'adjungo'),
    (r'\badiunxere\b', 'adjungo'),
    (r'\badiunxerimus\b', 'adjungo'),
    (r'\badiunxerint\b', 'adjungo'),
    (r'\badiunxeris\b', 'adjungo'),
    (r'\badiunxerit\b', 'adjungo'),
    (r'\badiunxero\b', 'adjungo'),
    (r'\badiunxerunt\b', 'adjungo'),
    (r'\badiunxi\b', 'adjungo'),
    (r'\badiunximus\b', 'adjungo'),
    (r'\badiunxisse\b', 'adjungo'),
    (r'\badiunxissent\b', 'adjungo'),
    (r'\badiunxisset\b', 'adjungo'),
    (r'\badiunxissetisque\b', 'adjungo'),
    (r'\badiunxisti\b', 'adjungo'),
    (r'\badiunxit\b', 'adjungo'),
    (r'\badiunxitque\b', 'adjungo'),
    (r'\badiurabat\b', 'adjuro1'),
    (r'\badiurabitque\b', 'adjuro1'),
    (r'\badiuramentum\b', 'adjuramentum'),
    (r'\badiurans\b', 'adjuro1'),
    (r'\badiurante\b', 'adjuro1'),
    (r'\badiurantem\b', 'adjuro1'),
    (r'\badiurantes\b', 'adjuro1'),
    (r'\badiurare\b', 'adjuro1'),
    (r'\badiurarent\b', 'adjuro1'),
    (r'\badiuraret\b', 'adjuro1'),
    (r'\badiurarit\b', 'adjuro1'),
    (r'\badiurasque\b', 'adjuro1'),
    (r'\badiurasset\b', 'adjuro1'),
    (r'\badiurasti\b', 'adjuro1'),
    (r'\badiurat\b', 'adjuro1'),
    (r'\badiuratione\b', 'adjuratio'),
    (r'\badiuratum\b', 'adjuro1'),
    (r'\badiuratur\b', 'adjuro1'),
    (r'\badiuratus\b', 'adjuro1'),
    (r'\badiurauit\b', 'adjuro1'),
    (r'\badiuraverat\b', 'adjuro1'),
    (r'\badiuraverit\b', 'adjuro1'),
    (r'\badiuravero\b', 'adjuro1'),
    (r'\badiuravi\b', 'adjuro1'),
    (r'\badiuravit\b', 'adjuro1'),
    (r'\badiurem\b', 'adjuro1'),
    (r'\badiures\b', 'adjuro1'),
    (r'\badiuret\b', 'adjuro1'),
    (r'\badiuro\b', 'adjuro1'),
    (r'\badiuta\b', 'adjuvo'),
    (r'\badiuta\b', 'adjuto'),
    (r'\badiutabant\b', 'adjuto'),
    (r'\badiutabilem\b', 'adjutabilis'),
    (r'\badiutabo\b', 'adjuto'),
    (r'\badiutae\b', 'adjuvo'),
    (r'\badiutam\b', 'adjuvo'),
    (r'\badiutamini\b', 'adjuto'),
    (r'\badiutamur\b', 'adjuto'),
    (r'\badiutans\b', 'adjuto'),
    (r'\badiutante\b', 'adjuto'),
    (r'\badiutare\b', 'adjuto'),
    (r'\badiutarent\b', 'adjuto'),
    (r'\badiutaret\b', 'adjuto'),
    (r'\badiutas\b', 'adjuvo'),
    (r'\badiutas\b', 'adjuto'),
    (r'\badiutasses\b', 'adjuto'),
    (r'\badiutat\b', 'adjuto'),
    (r'\badiutatur\b', 'adjuto'),
    (r'\badiutatus\b', 'adjuto'),
    (r'\badiutem\b', 'adjuto'),
    (r'\badiutemus\b', 'adjuto'),
    (r'\badiutetur\b', 'adjuto'),
    (r'\badiuti\b', 'adjuvo'),
    (r'\badiutis\b', 'adjuvo'),
    (r'\badiuto\b', 'adjuvo'),
    (r'\badiuto\b', 'adjuto'),
    (r'\badiutor\b', 'adjutor2'),
    (r'\badiutor\b', 'adjuto'),
    (r'\badiutore\b', 'adjutor2'),
    (r'\badiutorem\b', 'adjutor2'),
    (r'\badiutoremque\b', 'adjutor2'),
    (r'\badiutores\b', 'adjutor2'),
    (r'\badiutori\b', 'adjutor2'),
    (r'\badiutoria\b', 'adjutorium'),
    (r'\badiutoribus\b', 'adjutor2'),
    (r'\badiutoribusque\b', 'adjutor2'),
    (r'\badiutorii\b', 'adjutorium'),
    (r'\badiutoriis\b', 'adjutorium'),
    (r'\badiutorio\b', 'adjutorium'),
    (r'\badiutoris\b', 'adjutor2'),
    (r'\badiutorium\b', 'adjutorium'),
    (r'\badiutorque\b', 'adjutor2'),
    (r'\badiutorque\b', 'adjuto'),
    (r'\badiutorum\b', 'adjutor2'),
    (r'\badiutorum\b', 'adjuvo'),
    (r'\badiutos\b', 'adjuvo'),
    (r'\badiutrice\b', 'adjutrix'),
    (r'\badiutricem\b', 'adjutrix'),
    (r'\badiutrices\b', 'adjutrix'),
    (r'\badiutricis\b', 'adjutrix'),
    (r'\badiutrix\b', 'adjutrix'),
    (r'\badiutrixque\b', 'adjutrix'),
    (r'\badiutu\b', 'adjutus2'),
    (r'\badiutu\b', 'adjuvo'),
    (r'\badiutum\b', 'adjutus2'),
    (r'\badiutum\b', 'adjuvo'),
    (r'\badiutura\b', 'adjuvo'),
    (r'\badiuturam\b', 'adjuvo'),
    (r'\badiuturos\b', 'adjuvo'),
    (r'\badiuturum\b', 'adjuvo'),
    (r'\badiuturus\b', 'adjuvo'),
    (r'\badiutus\b', 'adjutus2'),
    (r'\badiutus\b', 'adjuvo'),
    (r'\badiutusque\b', 'adjutus2'),
    (r'\badiutusque\b', 'adjuvo'),
    (r'\badiuuabant\b', 'adjuvo'),
    (r'\badiuuabat\b', 'adjuvo'),
    (r'\badiuuabatur\b', 'adjuvo'),
    (r'\badiuuabit\b', 'adjuvo'),
    (r'\badiuuabitur\b', 'adjuvo'),
    (r'\badiuuabo\b', 'adjuvo'),
    (r'\badiuuabunt\b', 'adjuvo'),
    (r'\badiuuamur\b', 'adjuvo'),
    (r'\badiuuanda\b', 'adjuvo'),
    (r'\badiuuandae\b', 'adjuvo'),
    (r'\badiuuandam\b', 'adjuvo'),
    (r'\badiuuandi\b', 'adjuvo'),
    (r'\badiuuando\b', 'adjuvo'),
    (r'\badiuuandos\b', 'adjuvo'),
    (r'\badiuuandum\b', 'adjuvo'),
    (r'\badiuuandus\b', 'adjuvo'),
    (r'\badiuuant\b', 'adjuvo'),
    (r'\badiuuante\b', 'adjuvo'),
    (r'\badiuuantes\b', 'adjuvo'),
    (r'\badiuuantibus\b', 'adjuvo'),
    (r'\badiuuantium\b', 'adjuvo'),
    (r'\badiuuantur\b', 'adjuvo'),
    (r'\badiuuare\b', 'adjuvo'),
    (r'\badiuuarem\b', 'adjuvo'),
    (r'\badiuuarent\b', 'adjuvo'),
    (r'\badiuuarentur\b', 'adjuvo'),
    (r'\badiuuaret\b', 'adjuvo'),
    (r'\badiuuaretur\b', 'adjuvo'),
    (r'\badiuuari\b', 'adjuvo'),
    (r'\badiuuat\b', 'adjuvo'),
    (r'\badiuuate\b', 'adjuvo'),
    (r'\badiuuatque\b', 'adjuvo'),
    (r'\badiuuatur\b', 'adjuvo'),
    (r'\badiuuem\b', 'adjuvo'),
    (r'\badiuuemus\b', 'adjuvo'),
    (r'\badiuuen\b', 'adjuvo'),
    (r'\badiuuent\b', 'adjuvo'),
    (r'\badiuuerant\b', 'adjuvo'),
    (r'\badiuuerat\b', 'adjuvo'),
    (r'\badiuuere\b', 'adjuvo'),
    (r'\badiuuerimus\b', 'adjuvo'),
    (r'\badiuuerint\b', 'adjuvo'),
    (r'\badiuuerit\b', 'adjuvo'),
    (r'\badiuuerunt\b', 'adjuvo'),
    (r'\badiuues\b', 'adjuvo'),
    (r'\badiuuet\b', 'adjuvo'),
    (r'\badiuuetur\b', 'adjuvo'),
    (r'\badiuuisse\b', 'adjuvo'),
    (r'\badiuuissent\b', 'adjuvo'),
    (r'\badiuuisset\b', 'adjuvo'),
    (r'\badiuuit\b', 'adjuvo'),
    (r'\badiuuitque\b', 'adjuvo'),
    (r'\badiuva\b', 'adjuvo'),
    (r'\badiuvabant\b', 'adjuvo'),
    (r'\badiuvabat\b', 'adjuvo'),
    (r'\badiuvabatur\b', 'adjuvo'),
    (r'\badiuvabere\b', 'adjuvo'),
    (r'\badiuvabimus\b', 'adjuvo'),
    (r'\badiuvabis\b', 'adjuvo'),
    (r'\badiuvabit\b', 'adjuvo'),
    (r'\badiuvabitur\b', 'adjuvo'),
    (r'\badiuvabo\b', 'adjuvo'),
    (r'\badiuvabunt\b', 'adjuvo'),
    (r'\badiuvabuntur\b', 'adjuvo'),
    (r'\badiuvamur\b', 'adjuvo'),
    (r'\badiuvanda\b', 'adjuvo'),
    (r'\badiuvandae\b', 'adjuvo'),
    (r'\badiuvandam\b', 'adjuvo'),
    (r'\badiuvandas\b', 'adjuvo'),
    (r'\badiuvandi\b', 'adjuvo'),
    (r'\badiuvando\b', 'adjuvo'),
    (r'\badiuvandum\b', 'adjuvo'),
    (r'\badiuvandus\b', 'adjuvo'),
    (r'\badiuvandusque\b', 'adjuvo'),
    (r'\badiuvans\b', 'adjuvo'),
    (r'\badiuvant\b', 'adjuvo'),
    (r'\badiuvante\b', 'adjuvo'),
    (r'\badiuvantem\b', 'adjuvo'),
    (r'\badiuvantes\b', 'adjuvo'),
    (r'\badiuvantia\b', 'adjuvo'),
    (r'\badiuvantibus\b', 'adjuvo'),
    (r'\badiuvantur\b', 'adjuvo'),
    (r'\badiuvare\b', 'adjuvo'),
    (r'\badiuvarem\b', 'adjuvo'),
    (r'\badiuvaremini\b', 'adjuvo'),
    (r'\badiuvarent\b', 'adjuvo'),
    (r'\badiuvarentur\b', 'adjuvo'),
    (r'\badiuvarer\b', 'adjuvo'),
    (r'\badiuvares\b', 'adjuvo'),
    (r'\badiuvaret\b', 'adjuvo'),
    (r'\badiuvaretur\b', 'adjuvo'),
    (r'\badiuvari\b', 'adjuvo'),
    (r'\badiuvas\b', 'adjuvo'),
    (r'\badiuvat\b', 'adjuvo'),
    (r'\badiuvate\b', 'adjuvo'),
    (r'\badiuvato\b', 'adjuvo'),
    (r'\badiuvatur\b', 'adjuvo'),
    (r'\badiuvem\b', 'adjuvo'),
    (r'\badiuvemus\b', 'adjuvo'),
    (r'\badiuvent\b', 'adjuvo'),
    (r'\badiuventur\b', 'adjuvo'),
    (r'\badiuverant\b', 'adjuvo'),
    (r'\badiuverat\b', 'adjuvo'),
    (r'\badiuvere\b', 'adjuvo'),
    (r'\badiuverint\b', 'adjuvo'),
    (r'\badiuveris\b', 'adjuvo'),
    (r'\badiuverit\b', 'adjuvo'),
    (r'\badiuverunt\b', 'adjuvo'),
    (r'\badiuves\b', 'adjuvo'),
    (r'\badiuvet\b', 'adjuvo'),
    (r'\badiuvetis\b', 'adjuvo'),
    (r'\badiuvetur\b', 'adjuvo'),
    (r'\badiuvi\b', 'adjuvo'),
    (r'\badiuvimus\b', 'adjuvo'),
    (r'\badiuvissent\b', 'adjuvo'),
    (r'\badiuvisses\b', 'adjuvo'),
    (r'\badiuvisset\b', 'adjuvo'),
    (r'\badiuvisti\b', 'adjuvo'),
    (r'\badiuvit\b', 'adjuvo'),
    (r'\badiuvitque\b', 'adjuvo'),
    (r'\badiuvo\b', 'adjuvo'),
    (r'\badiuvor\b', 'adjuvo'),
    (r'\badlabente\b', 'allabor'),
    (r'\badlabere\b', 'allabor'),
    (r'\badlabi\b', 'allabor'),
    (r'\badlabimur\b', 'allabor'),
    (r'\badlabitur\b', 'allabor'),
    (r'\badlaborandum\b', 'admaturo'),
    (r'\badlabores\b', 'admaturo'),
    (r'\badlacrimans\b', 'admaturo'),
    (r'\badlapsa\b', 'allabor'),
    (r'\badlapsae\b', 'allabor'),
    (r'\badlapsam\b', 'allabor'),
    (r'\badlapsi\b', 'allabor'),
    (r'\badlapsum\b', 'allapsus2'),
    (r'\badlapsum\b', 'allabor'),
    (r'\badlapsus\b', 'allapsus2'),
    (r'\badlapsus\b', 'allabor'),
    (r'\badlata\b', 'affero'),
    (r'\badlatae\b', 'affero'),
    (r'\badlatam\b', 'affero'),
    (r'\badlataque\b', 'affero'),
    (r'\badlatarum\b', 'affero'),
    (r'\badlatas\b', 'affero'),
    (r'\badlati\b', 'affero'),
    (r'\badlatis\b', 'affero'),
    (r'\badlato\b', 'affero'),
    (r'\badlatos\b', 'affero'),
    (r'\badlatrandi\b', 'admaturo'),
    (r'\badlatrant\b', 'admaturo'),
    (r'\badlatrare\b', 'admaturo'),
    (r'\badlatrari\b', 'admaturo'),
    (r'\badlatras\b', 'admaturo'),
    (r'\badlatrat\b', 'admaturo'),
    (r'\badlatrauerat\b', 'admaturo'),
    (r'\badlatres\b', 'admaturo'),
    (r'\badlatum\b', 'affero'),
    (r'\badlatumque\b', 'affero'),
    (r'\badlatumst\b', 'affero'),
    (r'\badlatura\b', 'affero'),
    (r'\badlaturae\b', 'affero'),
    (r'\badlaturam\b', 'affero'),
    (r'\badlaturas\b', 'affero'),
    (r'\badlaturi\b', 'affero'),
    (r'\badlaturos\b', 'affero'),
    (r'\badlaturum\b', 'affero'),
    (r'\badlaturus\b', 'affero'),
    (r'\badlatus\b', 'affero'),
    (r'\badlatusque\b', 'affero'),
    (r'\badlaudabile\b', 'allaudabilis'),
    (r'\badlaudabilem\b', 'allaudabilis'),
    (r'\badlaudat\b', 'admaturo'),
    (r'\badlecta\b', 'allectus'),
    (r'\badlectam\b', 'allectus'),
    (r'\badlectant\b', 'admaturo'),
    (r'\badlectantia\b', 'admaturo'),
    (r'\badlectari\b', 'admaturo'),
    (r'\badlectat\b', 'admaturo'),
    (r'\badlectationi\b', 'allectatio'),
    (r'\badlecti\b', 'allectus'),
    (r'\badlectum\b', 'allectus'),
    (r'\badlecturum\b', 'admaturo'),
    (r'\badlectus\b', 'allectus'),
    (r'\badlega\b', 'admaturo'),
    (r'\badlegabat\b', 'admaturo'),
    (r'\badlegabimus\b', 'admaturo'),
    (r'\badleganda\b', 'admaturo'),
    (r'\badlegandum\b', 'admaturo'),
    (r'\badlegant\b', 'admaturo'),
    (r'\badlegant\b', 'admaturo'),
    (r'\badlegantes\b', 'admaturo'),
    (r'\badlegantibus\b', 'admaturo'),
    (r'\badlegantque\b', 'admaturo'),
    (r'\badlegantque\b', 'admaturo'),
    (r'\badlegare\b', 'admaturo'),
    (r'\badlegare\b', 'admaturo'),
    (r'\badlegarem\b', 'admaturo'),
    (r'\badlegarunt\b', 'admaturo'),
    (r'\badlegas\b', 'admaturo'),
    (r'\badlegas\b', 'admaturo'),
    (r'\badlegat\b', 'admaturo'),
    (r'\badlegat\b', 'admaturo'),
    (r'\badlegatione\b', 'allegatio'),
    (r'\badlegationes\b', 'allegatio'),
    (r'\badlegationibus\b', 'allegatio'),
    (r'\badlegato\b', 'admaturo'),
    (r'\badlegatos\b', 'allegatio'),
    (r'\badlegatu\b', 'allegatus'),
    (r'\badlegatum\b', 'allegatus'),
    (r'\badlegatum\b', 'allegatio'),
    (r'\badlegatur\b', 'admaturo'),
    (r'\badlegatur\b', 'admaturo'),
    (r'\badlegatus\b', 'allegatus'),
    (r'\badlegavero\b', 'admaturo'),
    (r'\badlegavit\b', 'admaturo'),
    (r'\badlegebantur\b', 'admaturo'),
    (r'\badlegem\b', 'admaturo'),
    (r'\badlegemus\b', 'admaturo'),
    (r'\badlegemus\b', 'admaturo'),
    (r'\badlegerentur\b', 'admaturo'),
    (r'\badlegeret\b', 'admaturo'),
    (r'\badleget\b', 'admaturo'),
    (r'\badleget\b', 'admaturo'),
    (r'\badlegi\b', 'admaturo'),
    (r'\badlegisse\b', 'admaturo'),
    (r'\badlegit\b', 'admaturo'),
    (r'\badlegitur\b', 'admaturo'),
    (r'\badleuamus\b', 'admaturo'),
    (r'\badleuanda\b', 'admaturo'),
    (r'\badleuandum\b', 'admaturo'),
    (r'\badleuandumque\b', 'admaturo'),
    (r'\badleuandus\b', 'admaturo'),
    (r'\badleuans\b', 'admaturo'),
    (r'\badleuant\b', 'admaturo'),
    (r'\badleuantem\b', 'admaturo'),
    (r'\badleuanti\b', 'admaturo'),
    (r'\badleuantur\b', 'admaturo'),
    (r'\badleuare\b', 'admaturo'),
    (r'\badleuarentur\b', 'admaturo'),
    (r'\badleuaretur\b', 'admaturo'),
    (r'\badleuari\b', 'admaturo'),
    (r'\badleuat\b', 'admaturo'),
    (r'\badleuata\b', 'admaturo'),
    (r'\badleuataque\b', 'admaturo'),
    (r'\badleuatas\b', 'admaturo'),
    (r'\badleuatio\b', 'allevatio'),
    (r'\badleuatis\b', 'admaturo'),
    (r'\badleuato\b', 'admaturo'),
    (r'\badleuatos\b', 'admaturo'),
    (r'\badleuatumque\b', 'admaturo'),
    (r'\badleuatur\b', 'admaturo'),
    (r'\badleuaturum\b', 'admaturo'),
    (r'\badleuauit\b', 'admaturo'),
    (r'\badleuentur\b', 'admaturo'),
    (r'\badleva\b', 'admaturo'),
    (r'\badlevabant\b', 'admaturo'),
    (r'\badlevabar\b', 'admaturo'),
    (r'\badlevabatque\b', 'admaturo'),
    (r'\badlevabatur\b', 'admaturo'),
    (r'\badlevabit\b', 'admaturo'),
    (r'\badlevabitis\b', 'admaturo'),
    (r'\badlevabitur\b', 'admaturo'),
    (r'\badlevamento\b', 'allevamentum'),
    (r'\badlevandis\b', 'admaturo'),
    (r'\badlevans\b', 'admaturo'),
    (r'\badlevant\b', 'admaturo'),
    (r'\badlevantem\b', 'admaturo'),
    (r'\badlevantur\b', 'admaturo'),
    (r'\badlevare\b', 'admaturo'),
    (r'\badlevarentur\b', 'admaturo'),
    (r'\badlevaret\b', 'admaturo'),
    (r'\badlevari\b', 'admaturo'),
    (r'\badlevasse\b', 'admaturo'),
    (r'\badlevassem\b', 'admaturo'),
    (r'\badlevassent\b', 'admaturo'),
    (r'\badlevasti\b', 'admaturo'),
    (r'\badlevat\b', 'admaturo'),
    (r'\badlevatae\b', 'admaturo'),
    (r'\badlevatas\b', 'admaturo'),
    (r'\badlevati\b', 'admaturo'),
    (r'\badlevationem\b', 'allevatio'),
    (r'\badlevatis\b', 'admaturo'),
    (r'\badlevato\b', 'admaturo'),
    (r'\badlevatumque\b', 'admaturo'),
    (r'\badlevatur\b', 'admaturo'),
    (r'\badlevatus\b', 'admaturo'),
    (r'\badlevavi\b', 'admaturo'),
    (r'\badlevavit\b', 'admaturo'),
    (r'\badlevent\b', 'admaturo'),
    (r'\badleventur\b', 'admaturo'),
    (r'\badleves\b', 'admaturo'),
    (r'\badlevet\b', 'admaturo'),
    (r'\badlevor\b', 'admaturo'),
    (r'\badlice\b', 'admaturo'),
    (r'\badlicere\b', 'admaturo'),
    (r'\badliceremus\b', 'admaturo'),
    (r'\badliceret\b', 'admaturo'),
    (r'\badlicuisse\b', 'admaturo'),
    (r'\badliga\b', 'admaturo'),
    (r'\badligabit\b', 'admaturo'),
    (r'\badligamus\b', 'admaturo'),
    (r'\badliganda\b', 'admaturo'),
    (r'\badligandae\b', 'admaturo'),
    (r'\badligando\b', 'admaturo'),
    (r'\badligans\b', 'admaturo'),
    (r'\badligantis\b', 'admaturo'),
    (r'\badligantur\b', 'admaturo'),
    (r'\badligare\b', 'admaturo'),
    (r'\badligarentur\b', 'admaturo'),
    (r'\badligaretur\b', 'admaturo'),
    (r'\badligari\b', 'admaturo'),
    (r'\badligaris\b', 'admaturo'),
    (r'\badligat\b', 'admaturo'),
    (r'\badligata\b', 'admaturo'),
    (r'\badligatae\b', 'admaturo'),
    (r'\badligatam\b', 'admaturo'),
    (r'\badligati\b', 'admaturo'),
    (r'\badligatio\b', 'alligatio'),
    (r'\badligatione\b', 'alligatio'),
    (r'\badligatis\b', 'admaturo'),
    (r'\badligato\b', 'admaturo'),
    (r'\badligator\b', 'alligator'),
    (r'\badligatos\b', 'admaturo'),
    (r'\badligatum\b', 'admaturo'),
    (r'\badligatumst\b', 'admaturo'),
    (r'\badligatur\b', 'admaturo'),
    (r'\badligatura\b', 'alligatura'),
    (r'\badligaturam\b', 'alligatura'),
    (r'\badligatus\b', 'admaturo'),
    (r'\badligauerint\b', 'admaturo'),
    (r'\badligaueris\b', 'admaturo'),
    (r'\badligauerit\b', 'admaturo'),
    (r'\badligauit\b', 'admaturo'),
    (r'\badligavit\b', 'admaturo'),
    (r'\badliger\b', 'admaturo'),
    (r'\badliget\b', 'admaturo'),
    (r'\badligetur\b', 'admaturo'),
    (r'\badligo\b', 'admaturo'),
    (r'\badlinet\b', 'admaturo'),
    (r'\badlisione\b', 'allisio'),
    (r'\badlocuti\b', 'alloquor'),
    (r'\badlocutio\b', 'allocutio'),
    (r'\badlocutione\b', 'allocutio'),
    (r'\badlocutionem\b', 'allocutio'),
    (r'\badlocutiones\b', 'allocutio'),
    (r'\badlocutionum\b', 'allocutio'),
    (r'\badlocutique\b', 'alloquor'),
    (r'\badlocutos\b', 'alloquor'),
    (r'\badlocutum\b', 'alloquor'),
    (r'\badlocuturae\b', 'alloquor'),
    (r'\badlocuturo\b', 'alloquor'),
    (r'\badlocutus\b', 'alloquor'),
    (r'\badlocutusque\b', 'alloquor'),
    (r'\badloquamur\b', 'alloquor'),
    (r'\badloquantur\b', 'alloquor'),
    (r'\badloquar\b', 'alloquor'),
    (r'\badloquatur\b', 'alloquor'),
    (r'\badloquebantur\b', 'alloquor'),
    (r'\badloquebatur\b', 'alloquor'),
    (r'\badloquemur\b', 'alloquor'),
    (r'\badloquenda\b', 'alloquor'),
    (r'\badloquendi\b', 'alloquor'),
    (r'\badloquendique\b', 'alloquor'),
    (r'\badloquendo\b', 'alloquor'),
    (r'\badloquendos\b', 'alloquor'),
    (r'\badloquendosque\b', 'alloquor'),
    (r'\badloquens\b', 'alloquor'),
    (r'\badloquente\b', 'alloquor'),
    (r'\badloquentem\b', 'alloquor'),
    (r'\badloquenti\b', 'alloquor'),
    (r'\badloquere\b', 'alloquor'),
    (r'\badloquerentur\b', 'alloquor'),
    (r'\badloquerer\b', 'alloquor'),
    (r'\badloqueretur\b', 'alloquor'),
    (r'\badloqueris\b', 'alloquor'),
    (r'\badloquetur\b', 'alloquor'),
    (r'\badloqui\b', 'alloquium'),
    (r'\badloqui\b', 'alloquor'),
    (r'\badloquia\b', 'alloquium'),
    (r'\badloquii\b', 'alloquium'),
    (r'\badloquiis\b', 'alloquium'),
    (r'\badloquimur\b', 'alloquor'),
    (r'\badloquio\b', 'alloquium'),
    (r'\badloquioque\b', 'alloquium'),
    (r'\badloquique\b', 'alloquium'),
    (r'\badloquique\b', 'alloquor'),
    (r'\badloquitur\b', 'alloquor'),
    (r'\badloquiturque\b', 'alloquor'),
    (r'\badloquium\b', 'alloquium'),
    (r'\badloquiumque\b', 'alloquium'),
    (r'\badloquor\b', 'alloquor'),
    (r'\badloquuntur\b', 'alloquor'),
    (r'\badluant\b', 'admaturo'),
    (r'\badluantur\b', 'admaturo'),
    (r'\badluat\b', 'admaturo'),
    (r'\badluatur\b', 'admaturo'),
    (r'\badlubentia\b', 'allubentia'),
    (r'\badlucere\b', 'admaturo'),
    (r'\badlucet\b', 'admaturo'),
    (r'\badluctantem\b', 'admaturo'),
    (r'\badluctari\b', 'admaturo'),
    (r'\badludens\b', 'admaturo'),
    (r'\badludentia\b', 'admaturo'),
    (r'\badludentibus\b', 'admaturo'),
    (r'\badludere\b', 'admaturo'),
    (r'\badludit\b', 'admaturo'),
    (r'\badludunt\b', 'admaturo'),
    (r'\badluebat\b', 'admaturo'),
    (r'\badluebatur\b', 'admaturo'),
    (r'\badluens\b', 'admaturo'),
    (r'\badluente\b', 'admaturo'),
    (r'\badluentibus\b', 'admaturo'),
    (r'\badluere\b', 'admaturo'),
    (r'\badluis\b', 'admaturo'),
    (r'\badluit\b', 'admaturo'),
    (r'\badluitur\b', 'admaturo'),
    (r'\badlusere\b', 'admaturo'),
    (r'\badlusit\b', 'admaturo'),
    (r'\badluuie\b', 'alluvies'),
    (r'\badluuie\b', 'alluvius'),
    (r'\badluuies\b', 'alluvies'),
    (r'\badluuionem\b', 'alluvio'),
    (r'\badluuionibus\b', 'alluvio'),
    (r'\badluuntur\b', 'admaturo'),
    (r'\badluvione\b', 'alluvio'),
    (r'\badluvionum\b', 'alluvio'),
    (r'\badluxerit\b', 'admaturo'),
    (r'\badluxerunt\b', 'admaturo'),
    (r'\badluxit\b', 'admaturo'),
    (r'\badmaturari\b', 'admaturo'),
    (r'\badmensa\b', 'admetior'),
    (r'\badmensum\b', 'admetior'),
    (r'\badmensus\b', 'admetior'),
    (r'\badmet\b', 'admeo'),
    (r'\bAdmete\b', 'ad-meto2'),
    (r'\badmete\b', 'ad-meto2'),
    (r'\bAdmeti\b', 'ad-meto2'),
    (r'\badmeti\b', 'admetior'),
    (r'\badmetiantur\b', 'admetior'),
    (r'\badmetiaris\b', 'admetior'),
    (r'\badmetiatur\b', 'admetior'),
    (r'\badmetiendi\b', 'admetior'),
    (r'\badmetietur\b', 'admetior'),
    (r'\badmetire\b', 'admetior'),
    (r'\badmetireris\b', 'admetior'),
    (r'\badmetiretur\b', 'admetior'),
    (r'\badmetiri\b', 'admetior'),
    (r'\badmetiris\b', 'admetior'),
    (r'\bAdmeto\b', 'ad-meto2'),
    (r'\badmeto\b', 'ad-meto2'),
    (r'\bAdmetum\b', 'ad-meto2'),
    (r'\bAdmetus\b', 'ad-meto2'),
    (r'\badmigrant\b', 'admigro'),
    (r'\badminicula\b', 'adminiculum'),
    (r'\badminicula\b', 'adminiculo'),
    (r'\badminiculandae\b', 'adminiculo'),
    (r'\badminiculandi\b', 'adminiculo'),
    (r'\badminiculando\b', 'adminiculo'),
    (r'\badminicularem\b', 'adminiculo'),
    (r'\badminiculari\b', 'adminiculo'),
    (r'\badminiculatae\b', 'adminiculo'),
    (r'\badminiculati\b', 'adminiculo'),
    (r'\badminiculatior\b', 'adminiculo'),
    (r'\badminiculato\b', 'adminiculo'),
    (r'\badminiculatore\b', 'adminiculator'),
    (r'\badminiculavi\b', 'adminiculo'),
    (r'\badminiculet\b', 'adminiculo'),
    (r'\badminiculi\b', 'adminiculum'),
    (r'\badminiculis\b', 'adminiculum'),
    (r'\badminiculo\b', 'adminiculum'),
    (r'\badminiculo\b', 'adminiculo'),
    (r'\badminiculorum\b', 'adminiculum'),
    (r'\badminiculum\b', 'adminiculum'),
    (r'\badminio\b', 'administer'),
    (r'\badminister\b', 'administer'),
    (r'\badministra\b', 'administra'),
    (r'\badministra\b', 'administro'),
    (r'\badministrabant\b', 'administro'),
    (r'\badministrabantur\b', 'administro'),
    (r'\badministrabat\b', 'administro'),
    (r'\badministrabatur\b', 'administro'),
    (r'\badministrabimus\b', 'administro'),
    (r'\badministrabit\b', 'administro'),
    (r'\badministrabitur\b', 'administro'),
    (r'\badministrabo\b', 'administro'),
    (r'\badministrabunt\b', 'administro'),
    (r'\badministrabuntur\b', 'administro'),
    (r'\badministrae\b', 'administra'),
    (r'\badministram\b', 'administra'),
    (r'\badministran\b', 'administra'),
    (r'\badministran\b', 'administro'),
    (r'\badministranda\b', 'administro'),
    (r'\badministrandae\b', 'administro'),
    (r'\badministrandam\b', 'administro'),
    (r'\badministrandarum\b', 'administro'),
    (r'\badministrandas\b', 'administro'),
    (r'\badministrandi\b', 'administro'),
    (r'\badministrandis\b', 'administro'),
    (r'\badministrandiue\b', 'administro'),
    (r'\badministrando\b', 'administro'),
    (r'\badministrandorum\b', 'administro'),
    (r'\badministrandum\b', 'administro'),
    (r'\badministrans\b', 'administro'),
    (r'\badministrant\b', 'administro'),
    (r'\badministrante\b', 'administro'),
    (r'\badministrantem\b', 'administro'),
    (r'\badministrantes\b', 'administro'),
    (r'\badministranti\b', 'administro'),
    (r'\badministrantibus\b', 'administro'),
    (r'\badministrantium\b', 'administro'),
    (r'\badministrantur\b', 'administro'),
    (r'\badministrare\b', 'administro'),
    (r'\badministrarem\b', 'administro'),
    (r'\badministrarent\b', 'administro'),
    (r'\badministrarentue\b', 'administro'),
    (r'\badministrarentur\b', 'administro'),
    (r'\badministrares\b', 'administro'),
    (r'\badministraret\b', 'administro'),
    (r'\badministraretur\b', 'administro'),
    (r'\badministrari\b', 'administro'),
    (r'\badministrarique\b', 'administro'),
    (r'\badministrarit\b', 'administro'),
    (r'\badministras\b', 'administra'),
    (r'\badministras\b', 'administro'),
    (r'\badministrasse\b', 'administro'),
    (r'\badministrassent\b', 'administro'),
    (r'\badministrasset\b', 'administro'),
    (r'\badministrasti\b', 'administro'),
    (r'\badministrastis\b', 'administro'),
    (r'\badministrat\b', 'administro'),
    (r'\badministrata\b', 'administro'),
    (r'\badministratae\b', 'administro'),
    (r'\badministratam\b', 'administro'),
    (r'\badministratas\b', 'administro'),
    (r'\badministrati\b', 'administro'),
    (r'\badministratio\b', 'administratio'),
    (r'\badministration\b', 'administratio'),
    (r'\badministratione\b', 'administratio'),
    (r'\badministrationem\b', 'administratio'),
    (r'\badministrationes\b', 'administratio'),
    (r'\badministrationesque\b', 'administratio'),
    (r'\badministrationi\b', 'administratio'),
    (r'\badministrationibus\b', 'administratio'),
    (r'\badministrationis\b', 'administratio'),
    (r'\badministrationum\b', 'administratio'),
    (r'\badministratis\b', 'administro'),
    (r'\badministratiua\b', 'administrativus'),
    (r'\badministrator\b', 'administrator'),
    (r'\badministratores\b', 'administrator'),
    (r'\badministratori\b', 'administrator'),
    (r'\badministratori\b', 'administratorius'),
    (r'\badministratorii\b', 'administratorius'),
    (r'\badministratorum\b', 'administrator'),
    (r'\badministratorum\b', 'administro'),
    (r'\badministratum\b', 'administro'),
    (r'\badministratur\b', 'administro'),
    (r'\badministraturos\b', 'administro'),
    (r'\badministraturum\b', 'administro'),
    (r'\badministraturus\b', 'administro'),
    (r'\badministratus\b', 'administro'),
    (r'\badministrauerant\b', 'administro'),
    (r'\badministrauerat\b', 'administro'),
    (r'\badministrauerim\b', 'administro'),
    (r'\badministrauerint\b', 'administro'),
    (r'\badministrauerit\b', 'administro'),
    (r'\badministrauerunt\b', 'administro'),
    (r'\badministraui\b', 'administro'),
    (r'\badministrauit\b', 'administro'),
    (r'\badministraverant\b', 'administro'),
    (r'\badministraverint\b', 'administro'),
    (r'\badministravisset\b', 'administro'),
    (r'\badministravit\b', 'administro'),
    (r'\badministrem\b', 'administro'),
    (r'\badministrent\b', 'administro'),
    (r'\badministrentur\b', 'administro'),
    (r'\badministres\b', 'administro'),
    (r'\badministret\b', 'administro'),
    (r'\badministretque\b', 'administro'),
    (r'\badministretur\b', 'administro'),
    (r'\badministri\b', 'administer'),
    (r'\badministris\b', 'administra'),
    (r'\badministris\b', 'administer'),
    (r'\badministrisque\b', 'administra'),
    (r'\badministrisque\b', 'administer'),
    (r'\badministro\b', 'administer'),
    (r'\badministro\b', 'administro'),
    (r'\badministros\b', 'administer'),
    (r'\badministrum\b', 'administer'),
    (r'\badmira\b', 'admiror'),
    (r'\badmirabantur\b', 'admiror'),
    (r'\badmirabar\b', 'admiror'),
    (r'\badmirabatur\b', 'admiror'),
    (r'\badmirabere\b', 'admiror'),
    (r'\badmiraberis\b', 'admiror'),
    (r'\badmirabile\b', 'admirabilis'),
    (r'\badmirabilem\b', 'admirabilis'),
    (r'\badmirabiles\b', 'admirabilis'),
    (r'\badmirabili\b', 'admirabilis'),
    (r'\badmirabilia\b', 'admirabilis'),
    (r'\badmirabilior\b', 'admirabilis'),
    (r'\badmirabiliora\b', 'admirabilis'),
    (r'\badmirabiliorem\b', 'admirabilis'),
    (r'\badmirabilique\b', 'admirabilis'),
    (r'\badmirabilis\b', 'admirabilis'),
    (r'\badmirabilitas\b', 'admirabilitas'),
    (r'\badmirabilitate\b', 'admirabilitas'),
    (r'\badmirabilitatem\b', 'admirabilitas'),
    (r'\badmirabiliter\b', 'admirabilis'),
    (r'\badmirabiliter\b', 'admirabiliter'),
    (r'\badmirabilium\b', 'admirabilis'),
    (r'\badmirabilius\b', 'admirabilis'),
    (r'\badmirabimur\b', 'admiror'),
    (r'\badmirabitur\b', 'admiror'),
    (r'\badmirabor\b', 'admiror'),
    (r'\badmirabuntur\b', 'admiror'),
    (r'\badmiramini\b', 'admiror'),
    (r'\badmiramur\b', 'admiror'),
    (r'\badmiranda\b', 'admiror'),
    (r'\badmiranda\b', 'admirandus'),
    (r'\badmirandae\b', 'admirandus'),
    (r'\badmirandae\b', 'admiror'),
    (r'\badmirandam\b', 'admirandus'),
    (r'\badmirandam\b', 'admiror'),
    (r'\badmirandamque\b', 'admirandus'),
    (r'\badmirandamque\b', 'admiror'),
    (r'\badmirandas\b', 'admirandus'),
    (r'\badmirandas\b', 'admiror'),
    (r'\badmirandi\b', 'admiror'),
    (r'\badmirandi\b', 'admirandus'),
    (r'\badmirandis\b', 'admiror'),
    (r'\badmirandis\b', 'admirandus'),
    (r'\badmirandisque\b', 'admiror'),
    (r'\badmirandisque\b', 'admirandus'),
    (r'\badmirando\b', 'admiror'),
    (r'\badmirando\b', 'admirandus'),
    (r'\badmirandos\b', 'admiror'),
    (r'\badmirandos\b', 'admirandus'),
    (r'\badmirandum\b', 'admiror'),
    (r'\badmirandum\b', 'admirandus'),
    (r'\badmirandus\b', 'admiror'),
    (r'\badmirandus\b', 'admirandus'),
    (r'\badmirans\b', 'admiror'),
    (r'\badmiransque\b', 'admiror'),
    (r'\badmirante\b', 'admiror'),
    (r'\badmirantem\b', 'admiror'),
    (r'\badmirantes\b', 'admiror'),
    (r'\badmiranti\b', 'admiror'),
    (r'\badmirantibus\b', 'admiror'),
    (r'\badmirantis\b', 'admiror'),
    (r'\badmirantium\b', 'admiror'),
    (r'\badmirantur\b', 'admiror'),
    (r'\badmirare\b', 'admiror'),
    (r'\badmirarentur\b', 'admiror'),
    (r'\badmirarer\b', 'admiror'),
    (r'\badmirarere\b', 'admiror'),
    (r'\badmirareris\b', 'admiror'),
    (r'\badmiraretur\b', 'admiror'),
    (r'\badmirari\b', 'admiror'),
    (r'\badmiraris\b', 'admiror'),
    (r'\badmirata\b', 'admiror'),
    (r'\badmiratae\b', 'admiror'),
    (r'\badmiratam\b', 'admiror'),
    (r'\badmirati\b', 'admiror'),
    (r'\badmiratio\b', 'admiratio'),
    (r'\badmiratione\b', 'admiratio'),
    (r'\badmirationem\b', 'admiratio'),
    (r'\badmirationemque\b', 'admiratio'),
    (r'\badmirationeque\b', 'admiratio'),
    (r'\badmirationes\b', 'admiratio'),
    (r'\badmirationi\b', 'admiratio'),
    (r'\badmirationibus\b', 'admiratio'),
    (r'\badmirationis\b', 'admiratio'),
    (r'\badmirationum\b', 'admiratio'),
    (r'\badmiratioque\b', 'admiratio'),
    (r'\badmirator\b', 'admirator'),
    (r'\badmiratorem\b', 'admirator'),
    (r'\badmiratores\b', 'admirator'),
    (r'\badmiratorque\b', 'admirator'),
    (r'\badmiratos\b', 'admiror'),
    (r'\badmiratu\b', 'admiror'),
    (r'\badmiratum\b', 'admiror'),
    (r'\badmiratur\b', 'admiror'),
    (r'\badmiraturque\b', 'admiror'),
    (r'\badmiraturum\b', 'admiror'),
    (r'\badmiratus\b', 'admiror'),
    (r'\badmiratusque\b', 'admiror'),
    (r'\badmiremini\b', 'admiror'),
    (r'\badmiremur\b', 'admiror'),
    (r'\badmirentur\b', 'admiror'),
    (r'\badmirer\b', 'admiror'),
    (r'\badmirere\b', 'admiror'),
    (r'\badmireris\b', 'admiror'),
    (r'\badmiretur\b', 'admiror'),
    (r'\badmiror\b', 'admiror'),
    (r'\badmisce\b', 'admisceo'),
    (r'\badmiscear\b', 'admisceo'),
    (r'\badmiscearis\b', 'admisceo'),
    (r'\badmisceas\b', 'admisceo'),
    (r'\badmisceat\b', 'admisceo'),
    (r'\badmisceatur\b', 'admisceo'),
    (r'\badmiscebis\b', 'admisceo'),
    (r'\badmiscebit\b', 'admisceo'),
    (r'\badmiscebitur\b', 'admisceo'),
    (r'\badmiscemus\b', 'admisceo'),
    (r'\badmiscenda\b', 'admisceo'),
    (r'\badmiscendo\b', 'admisceo'),
    (r'\badmiscendum\b', 'admisceo'),
    (r'\badmiscens\b', 'admisceo'),
    (r'\badmiscent\b', 'admisceo'),
    (r'\badmiscente\b', 'admisceo'),
    (r'\badmiscentem\b', 'admisceo'),
    (r'\badmiscentes\b', 'admisceo'),
    (r'\badmiscentque\b', 'admisceo'),
    (r'\badmiscentur\b', 'admisceo'),
    (r'\badmisceo\b', 'admisceo'),
    (r'\badmiscere\b', 'admisceo'),
    (r'\badmiscerentur\b', 'admisceo'),
    (r'\badmiscerenturne\b', 'admisceo'),
    (r'\badmisceri\b', 'admisceo'),
    (r'\badmisces\b', 'admisceo'),
    (r'\badmiscet\b', 'admisceo'),
    (r'\badmisceto\b', 'admisceo'),
    (r'\badmiscetque\b', 'admisceo'),
    (r'\badmiscetur\b', 'admisceo'),
    (r'\badmisceturque\b', 'admisceo'),
    (r'\badmiscuerat\b', 'admisceo'),
    (r'\badmiscuerint\b', 'admisceo'),
    (r'\badmiscuerit\b', 'admisceo'),
    (r'\badmiscuerunt\b', 'admisceo'),
    (r'\badmiscuisse\b', 'admisceo'),
    (r'\badmiscuit\b', 'admisceo'),
    (r'\badmiserant\b', 'admitto'),
    (r'\badmiserat\b', 'admitto'),
    (r'\badmisere\b', 'admitto'),
    (r'\badmiserim\b', 'admitto'),
    (r'\badmiserint\b', 'admitto'),
    (r'\badmiseris\b', 'admitto'),
    (r'\badmiserit\b', 'admitto'),
    (r'\badmisero\b', 'admitto'),
    (r'\badmiserunt\b', 'admitto'),
    (r'\badmiseruntque\b', 'admitto'),
    (r'\badmisi\b', 'admitto'),
    (r'\badmisimus\b', 'admitto'),
    (r'\badmisisse\b', 'admitto'),
    (r'\badmisissem\b', 'admitto'),
    (r'\badmisissent\b', 'admitto'),
    (r'\badmisisset\b', 'admitto'),
    (r'\badmisisti\b', 'admitto'),
    (r'\badmisistis\b', 'admitto'),
    (r'\badmisit\b', 'admitto'),
    (r'\badmisitque\b', 'admitto'),
    (r'\badmissa\b', 'admissum'),
    (r'\badmissa\b', 'admitto'),
    (r'\badmissae\b', 'admitto'),
    (r'\badmissaeque\b', 'admitto'),
    (r'\badmissam\b', 'admitto'),
    (r'\badmissarii\b', 'admissarius'),
    (r'\badmissariis\b', 'admissarius'),
    (r'\badmissario\b', 'admissarius'),
    (r'\badmissarios\b', 'admissarius'),
    (r'\badmissarium\b', 'admissarius'),
    (r'\badmissarius\b', 'admissarius'),
    (r'\badmissas\b', 'admitto'),
    (r'\badmisse\b', 'admissum'),
    (r'\badmisse\b', 'admitto'),
    (r'\badmissi\b', 'admissum'),
    (r'\badmissi\b', 'admitto'),
    (r'\badmissio\b', 'admissio'),
    (r'\badmissionalibus\b', 'admissionalis'),
    (r'\badmissione\b', 'admissio'),
    (r'\badmissiones\b', 'admissio'),
    (r'\badmissionis\b', 'admissio'),
    (r'\badmissionum\b', 'admissio'),
    (r'\badmissique\b', 'admissum'),
    (r'\badmissique\b', 'admitto'),
    (r'\badmissis\b', 'admissum'),
    (r'\badmissis\b', 'admitto'),
    (r'\badmissisque\b', 'admissum'),
    (r'\badmissisque\b', 'admitto'),
    (r'\badmisso\b', 'admissum'),
    (r'\badmisso\b', 'admitto'),
    (r'\badmissos\b', 'admitto'),
    (r'\badmissum\b', 'admissus2'),
    (r'\badmissum\b', 'admissum'),
    (r'\badmissum\b', 'admitto'),
    (r'\badmissumque\b', 'admissus2'),
    (r'\badmissumque\b', 'admissum'),
    (r'\badmissumque\b', 'admitto'),
    (r'\badmissura\b', 'admissura'),
    (r'\badmissura\b', 'admitto'),
    (r'\badmissurae\b', 'admissura'),
    (r'\badmissurae\b', 'admitto'),
    (r'\badmissuram\b', 'admissura'),
    (r'\badmissuram\b', 'admitto'),
    (r'\badmissuras\b', 'admissura'),
    (r'\badmissuras\b', 'admitto'),
    (r'\badmissuro\b', 'admitto'),
    (r'\badmissurum\b', 'admitto'),
    (r'\badmissurus\b', 'admitto'),
    (r'\badmissus\b', 'admissus2'),
    (r'\badmissus\b', 'admitto'),
    (r'\badmittam\b', 'admitto'),
    (r'\badmittamus\b', 'admitto'),
    (r'\badmittant\b', 'admitto'),
    (r'\badmittantque\b', 'admitto'),
    (r'\badmittantur\b', 'admitto'),
    (r'\badmittar\b', 'admitto'),
    (r'\badmittare\b', 'admitto'),
    (r'\badmittas\b', 'admitto'),
    (r'\badmittat\b', 'admitto'),
    (r'\badmittatur\b', 'admitto'),
    (r'\badmitte\b', 'admitto'),
    (r'\badmittebant\b', 'admitto'),
    (r'\badmittebantur\b', 'admitto'),
    (r'\badmittebat\b', 'admitto'),
    (r'\badmittebatur\b', 'admitto'),
    (r'\badmittemus\b', 'admitto'),
    (r'\badmittenda\b', 'admitto'),
    (r'\badmittendae\b', 'admitto'),
    (r'\badmittendam\b', 'admitto'),
    (r'\badmittendarum\b', 'admitto'),
    (r'\badmittendas\b', 'admitto'),
    (r'\badmittendi\b', 'admitto'),
    (r'\badmittendis\b', 'admitto'),
    (r'\badmittendisque\b', 'admitto'),
    (r'\badmittendiue\b', 'admitto'),
    (r'\badmittendo\b', 'admitto'),
    (r'\badmittendos\b', 'admitto'),
    (r'\badmittendum\b', 'admitto'),
    (r'\badmittendus\b', 'admitto'),
    (r'\badmittente\b', 'admitto'),
    (r'\badmittentes\b', 'admitto'),
    (r'\badmittentia\b', 'admitto'),
    (r'\badmittentibus\b', 'admitto'),
    (r'\badmittentis\b', 'admitto'),
    (r'\badmittentium\b', 'admitto'),
    (r'\badmittentur\b', 'admitto'),
    (r'\badmittere\b', 'admitto'),
    (r'\badmitterem\b', 'admitto'),
    (r'\badmitteremus\b', 'admitto'),
    (r'\badmitterent\b', 'admitto'),
    (r'\badmitterentur\b', 'admitto'),
    (r'\badmitterer\b', 'admitto'),
    (r'\badmitteres\b', 'admitto'),
    (r'\badmitteret\b', 'admitto'),
    (r'\badmitteretur\b', 'admitto'),
    (r'\badmitteris\b', 'admitto'),
    (r'\badmittes\b', 'admitto'),
    (r'\badmittet\b', 'admitto'),
    (r'\badmittetur\b', 'admitto'),
    (r'\badmitti\b', 'admitto'),
    (r'\badmittier\b', 'admitto'),
    (r'\badmittimur\b', 'admitto'),
    (r'\badmittimus\b', 'admitto'),
    (r'\badmittique\b', 'admitto'),
    (r'\badmittis\b', 'admitto'),
    (r'\badmittit\b', 'admitto'),
    (r'\badmittite\b', 'admitto'),
    (r'\badmittitis\b', 'admitto'),
    (r'\badmittito\b', 'admitto'),
    (r'\badmittitur\b', 'admitto'),
    (r'\badmitto\b', 'admitto'),
    (r'\badmittor\b', 'admitto'),
    (r'\badmittunt\b', 'admitto'),
    (r'\badmittuntur\b', 'admitto'),
    (r'\badmixta\b', 'admisceo'),
    (r'\badmixtae\b', 'admisceo'),
    (r'\badmixtam\b', 'admisceo'),
    (r'\badmixtaque\b', 'admisceo'),
    (r'\badmixtas\b', 'admisceo'),
    (r'\badmixtio\b', 'admistio'),
    (r'\badmixtione\b', 'admistio'),
    (r'\badmixtiones\b', 'admistio'),
    (r'\badmixtis\b', 'admisceo'),
    (r'\badmixto\b', 'admisceo'),
    (r'\badmixtoque\b', 'admisceo'),
    (r'\badmixtos\b', 'admisceo'),
    (r'\badmixtum\b', 'admixtus2'),
    (r'\badmixtum\b', 'admisceo'),
    (r'\badmixtumst\b', 'admixtus2'),
    (r'\badmixtumst\b', 'admisceo'),
    (r'\badmixtus\b', 'admixtus2'),
    (r'\badmixtus\b', 'admisceo'),
    (r'\badmo\b', 'admeo'),
    (r'\badmodum\b', 'admodum'),
    (r'\badmodumst\b', 'admodum'),
    (r'\badmoenire\b', 'admoenio'),
    (r'\badmoenivi\b', 'admoenio'),
    (r'\badmolirier\b', 'admolior'),
    (r'\badmolitur\b', 'admolior'),
    (r'\badmolituros\b', 'admolior'),
    (r'\badmolitus\b', 'admolior'),
    (r'\badmone\b', 'admoneo'),
    (r'\badmoneam\b', 'admoneo'),
    (r'\badmoneamur\b', 'admoneo'),
    (r'\badmoneamus\b', 'admoneo'),
    (r'\badmoneant\b', 'admoneo'),
    (r'\badmoneantque\b', 'admoneo'),
    (r'\badmoneantur\b', 'admoneo'),
    (r'\badmonear\b', 'admoneo'),
    (r'\badmoneare\b', 'admoneo'),
    (r'\badmonearis\b', 'admoneo'),
    (r'\badmoneas\b', 'admoneo'),
    (r'\badmoneat\b', 'admoneo'),
    (r'\badmoneatur\b', 'admoneo'),
    (r'\badmonebamur\b', 'admoneo'),
    (r'\badmonebant\b', 'admoneo'),
    (r'\badmonebantur\b', 'admoneo'),
    (r'\badmonebas\b', 'admoneo'),
    (r'\badmonebat\b', 'admoneo'),
    (r'\badmonebatque\b', 'admoneo'),
    (r'\badmonebatur\b', 'admoneo'),
    (r'\badmonebimus\b', 'admoneo'),
    (r'\badmonebis\b', 'admoneo'),
    (r'\badmonebit\b', 'admoneo'),
    (r'\badmonebitur\b', 'admoneo'),
    (r'\badmonebo\b', 'admoneo'),
    (r'\badmonebunt\b', 'admoneo'),
    (r'\badmonemur\b', 'admoneo'),
    (r'\badmonemus\b', 'admoneo'),
    (r'\badmonendi\b', 'admoneo'),
    (r'\badmonendo\b', 'admoneo'),
    (r'\badmonendoque\b', 'admoneo'),
    (r'\badmonendos\b', 'admoneo'),
    (r'\badmonendum\b', 'admoneo'),
    (r'\badmonendumque\b', 'admoneo'),
    (r'\badmonendus\b', 'admoneo'),
    (r'\badmonendusque\b', 'admoneo'),
    (r'\badmonens\b', 'admoneo'),
    (r'\badmonent\b', 'admoneo'),
    (r'\badmonente\b', 'admoneo'),
    (r'\badmonentem\b', 'admoneo'),
    (r'\badmonentemque\b', 'admoneo'),
    (r'\badmonentes\b', 'admoneo'),
    (r'\badmonentibus\b', 'admoneo'),
    (r'\badmonentis\b', 'admoneo'),
    (r'\badmonentur\b', 'admoneo'),
    (r'\badmoneo\b', 'admoneo'),
    (r'\badmoneor\b', 'admoneo'),
    (r'\badmonere\b', 'admoneo'),
    (r'\badmonerem\b', 'admoneo'),
    (r'\badmonerent\b', 'admoneo'),
    (r'\badmonerentque\b', 'admoneo'),
    (r'\badmonerentur\b', 'admoneo'),
    (r'\badmoneret\b', 'admoneo'),
    (r'\badmoneretis\b', 'admoneo'),
    (r'\badmoneretur\b', 'admoneo'),
    (r'\badmoneri\b', 'admoneo'),
    (r'\badmonerique\b', 'admoneo'),
    (r'\badmoneris\b', 'admoneo'),
    (r'\badmones\b', 'admoneo'),
    (r'\badmonet\b', 'admoneo'),
    (r'\badmonete\b', 'admoneo'),
    (r'\badmonetis\b', 'admoneo'),
    (r'\badmonetque\b', 'admoneo'),
    (r'\badmonetur\b', 'admoneo'),
    (r'\badmonita\b', 'admonitum'),
    (r'\badmonita\b', 'admoneo'),
    (r'\badmonita\b', 'admonitor'),
    (r'\badmonitae\b', 'admoneo'),
    (r'\badmonitaeque\b', 'admoneo'),
    (r'\badmoniti\b', 'admonitum'),
    (r'\badmoniti\b', 'admoneo'),
    (r'\badmonitio\b', 'admonitio'),
    (r'\badmonitione\b', 'admonitio'),
    (r'\badmonitionem\b', 'admonitio'),
    (r'\badmonitiones\b', 'admonitio'),
    (r'\badmonitioni\b', 'admonitio'),
    (r'\badmonitionibus\b', 'admonitio'),
    (r'\badmonitionis\b', 'admonitio'),
    (r'\badmonitionumque\b', 'admonitio'),
    (r'\badmonito\b', 'admonitum'),
    (r'\badmonito\b', 'admoneo'),
    (r'\badmonito\b', 'admonitor'),
    (r'\badmonitore\b', 'admonitor'),
    (r'\badmonitores\b', 'admonitor'),
    (r'\badmonitorque\b', 'admonitor'),
    (r'\badmonitos\b', 'admoneo'),
    (r'\badmonitosque\b', 'admoneo'),
    (r'\badmonitu\b', 'admonitus2'),
    (r'\badmonitu\b', 'admoneo'),
    (r'\badmonitum\b', 'admonitus2'),
    (r'\badmonitum\b', 'admonitum'),
    (r'\badmonitum\b', 'admoneo'),
    (r'\badmonitura\b', 'admoneo'),
    (r'\badmoniturum\b', 'admoneo'),
    (r'\badmonitus\b', 'admonitus2'),
    (r'\badmonitus\b', 'admoneo'),
    (r'\badmonitusque\b', 'admonitus2'),
    (r'\badmonitusque\b', 'admoneo'),
    (r'\badmonuere\b', 'admoneo'),
    (r'\badmonuerimus\b', 'admoneo'),
    (r'\badmonueris\b', 'admoneo'),
    (r'\badmonuerit\b', 'admoneo'),
    (r'\badmonuero\b', 'admoneo'),
    (r'\badmonuerunt\b', 'admoneo'),
    (r'\badmonui\b', 'admoneo'),
    (r'\badmonuimus\b', 'admoneo'),
    (r'\badmonuisse\b', 'admoneo'),
    (r'\badmonuisses\b', 'admoneo'),
    (r'\badmonuisset\b', 'admoneo'),
    (r'\badmonuisti\b', 'admoneo'),
    (r'\badmonuit\b', 'admoneo'),
    (r'\badmonuitque\b', 'admoneo'),
    (r'\badmordere\b', 'admordeo'),
    (r'\badmorsa\b', 'admordeo'),
    (r'\badmorsae\b', 'admordeo'),
    (r'\badmorsis\b', 'admordeo'),
    (r'\badmorso\b', 'admordeo'),
    (r'\badmorsu\b', 'admorsus2'),
    (r'\badmorsu\b', 'admordeo'),
    (r'\badmorunt\b', 'admoveo'),
    (r'\badmota\b', 'admoveo'),
    (r'\badmotae\b', 'admoveo'),
    (r'\badmotaeque\b', 'admoveo'),
    (r'\badmotam\b', 'admoveo'),
    (r'\badmotaque\b', 'admoveo'),
    (r'\badmotas\b', 'admoveo'),
    (r'\badmoti\b', 'admoveo'),
    (r'\badmotione\b', 'admotio'),
    (r'\badmotis\b', 'admoveo'),
    (r'\badmotisque\b', 'admoveo'),
    (r'\badmoto\b', 'admoveo'),
    (r'\badmotoque\b', 'admoveo'),
    (r'\badmotos\b', 'admoveo'),
    (r'\badmotum\b', 'admoveo'),
    (r'\badmotumque\b', 'admoveo'),
    (r'\badmoturi\b', 'admoveo'),
    (r'\badmoturos\b', 'admoveo'),
    (r'\badmoturus\b', 'admoveo'),
    (r'\badmotus\b', 'admoveo'),
    (r'\badmotusque\b', 'admoveo'),
    (r'\badmoue\b', 'admeo'),
    (r'\badmoueam\b', 'admoveo'),
    (r'\badmoueant\b', 'admoveo'),
    (r'\badmoueantur\b', 'admoveo'),
    (r'\badmoueas\b', 'admoveo'),
    (r'\badmoueat\b', 'admoveo'),
    (r'\badmoueatur\b', 'admoveo'),
    (r'\badmouebantur\b', 'admoveo'),
    (r'\badmouebat\b', 'admoveo'),
    (r'\badmouebatur\b', 'admoveo'),
    (r'\badmouebimus\b', 'admoveo'),
    (r'\badmouebo\b', 'admoveo'),
    (r'\badmouemus\b', 'admoveo'),
    (r'\badmouenda\b', 'admoveo'),
    (r'\badmouendae\b', 'admoveo'),
    (r'\badmouendi\b', 'admoveo'),
    (r'\badmouendo\b', 'admoveo'),
    (r'\badmouendum\b', 'admoveo'),
    (r'\badmouendumque\b', 'admoveo'),
    (r'\badmouendus\b', 'admoveo'),
    (r'\badmouens\b', 'admoveo'),
    (r'\badmouent\b', 'admoveo'),
    (r'\badmouentem\b', 'admoveo'),
    (r'\badmouentemque\b', 'admoveo'),
    (r'\badmouentes\b', 'admoveo'),
    (r'\badmouenti\b', 'admoveo'),
    (r'\badmouentibus\b', 'admoveo'),
    (r'\badmouentur\b', 'admoveo'),
    (r'\badmoueo\b', 'admoveo'),
    (r'\badmoueram\b', 'admoveo'),
    (r'\badmouerat\b', 'admoveo'),
    (r'\badmouere\b', 'admoveo'),
    (r'\badmouerent\b', 'admoveo'),
    (r'\badmouerentur\b', 'admoveo'),
    (r'\badmoueret\b', 'admoveo'),
    (r'\badmoueretur\b', 'admoveo'),
    (r'\badmoueri\b', 'admoveo'),
    (r'\badmouerim\b', 'admoveo'),
    (r'\badmouerint\b', 'admoveo'),
    (r'\badmouerique\b', 'admoveo'),
    (r'\badmoueris\b', 'admoveo'),
    (r'\badmouerit\b', 'admoveo'),
    (r'\badmouerunt\b', 'admoveo'),
    (r'\badmouet\b', 'admoveo'),
    (r'\badmoueto\b', 'admoveo'),
    (r'\badmouetur\b', 'admoveo'),
    (r'\badmoui\b', 'admoveo'),
    (r'\badmouimus\b', 'admoveo'),
    (r'\badmouisse\b', 'admoveo'),
    (r'\badmouissent\b', 'admoveo'),
    (r'\badmouisset\b', 'admoveo'),
    (r'\badmouit\b', 'admoveo'),
    (r'\badmouitque\b', 'admoveo'),
    (r'\badmove\b', 'admoveo'),
    (r'\badmoveam\b', 'admoveo'),
    (r'\badmoveamus\b', 'admoveo'),
    (r'\badmoveantur\b', 'admoveo'),
    (r'\badmoveas\b', 'admoveo'),
    (r'\badmoveat\b', 'admoveo'),
    (r'\badmoveatur\b', 'admoveo'),
    (r'\badmovebam\b', 'admoveo'),
    (r'\badmovebant\b', 'admoveo'),
    (r'\badmovebantur\b', 'admoveo'),
    (r'\badmovebat\b', 'admoveo'),
    (r'\badmovebatur\b', 'admoveo'),
    (r'\badmovebis\b', 'admoveo'),
    (r'\badmovebit\b', 'admoveo'),
    (r'\badmovebo\b', 'admoveo'),
    (r'\badmovemus\b', 'admoveo'),
    (r'\badmovenda\b', 'admoveo'),
    (r'\badmovendae\b', 'admoveo'),
    (r'\badmovendas\b', 'admoveo'),
    (r'\badmovendis\b', 'admoveo'),
    (r'\badmovendus\b', 'admoveo'),
    (r'\badmovens\b', 'admoveo'),
    (r'\badmovent\b', 'admoveo'),
    (r'\badmoventem\b', 'admoveo'),
    (r'\badmoventia\b', 'admoveo'),
    (r'\badmoventur\b', 'admoveo'),
    (r'\badmoveo\b', 'admoveo'),
    (r'\badmoverant\b', 'admoveo'),
    (r'\badmoverat\b', 'admoveo'),
    (r'\badmovere\b', 'admoveo'),
    (r'\badmoverent\b', 'admoveo'),
    (r'\badmoverentur\b', 'admoveo'),
    (r'\badmoveret\b', 'admoveo'),
    (r'\badmoveri\b', 'admoveo'),
    (r'\badmoveris\b', 'admoveo'),
    (r'\badmoverit\b', 'admoveo'),
    (r'\badmoves\b', 'admoveo'),
    (r'\badmovet\b', 'admoveo'),
    (r'\badmovete\b', 'admoveo'),
    (r'\badmoveto\b', 'admoveo'),
    (r'\badmovetque\b', 'admoveo'),
    (r'\badmovetur\b', 'admoveo'),
    (r'\badmovi\b', 'admoveo'),
    (r'\badmovique\b', 'admoveo'),
    (r'\badmovisse\b', 'admoveo'),
    (r'\badmovissent\b', 'admoveo'),
    (r'\badmovisses\b', 'admoveo'),
    (r'\badmovisset\b', 'admoveo'),
    (r'\badmovisti\b', 'admoveo'),
    (r'\badmovit\b', 'admoveo'),
    (r'\badmovitque\b', 'admoveo'),
    (r'\badmugit\b', 'admugio'),
    (r'\badmurmurante\b', 'admurmuro'),
    (r'\badmurmurati\b', 'admurmuro'),
    (r'\badmurmuratio\b', 'admurmuratio'),
    (r'\badmurmuratione\b', 'admurmuratio'),
    (r'\badmurmurationibus\b', 'admurmuratio'),
    (r'\badmurmuratum\b', 'admurmuro'),
    (r'\badmurmuraverint\b', 'admurmuro'),
    (r'\badmutilabit\b', 'admutilo'),
    (r'\badmutilavisti\b', 'admutilo'),
    (r'\badmutiletur\b', 'admutilo'),
    (r'\badn\b', 'ad'),
    (r'\badnabam\b', 'adnato'),
    (r'\badnabat\b', 'adnato'),
    (r'\badnabunt\b', 'adnato'),
    (r'\badnant\b', 'adnato'),
    (r'\badnantemque\b', 'adnato'),
    (r'\badnantes\b', 'adnato'),
    (r'\badnare\b', 'adnato'),
    (r'\badnarrant\b', 'adnascor'),
    (r'\badnasci\b', 'adnascor'),
    (r'\badnascuntur\b', 'adnascor'),
    (r'\badnata\b', 'adnato'),
    (r'\badnatabant\b', 'adnato'),
    (r'\badnatans\b', 'adnato'),
    (r'\badnatantes\b', 'adnato'),
    (r'\badnatantesque\b', 'adnato'),
    (r'\badnatare\b', 'adnato'),
    (r'\badnatarunt\b', 'adnato'),
    (r'\badnatat\b', 'adnato'),
    (r'\badnatavimus\b', 'adnato'),
    (r'\badnatavit\b', 'adnato'),
    (r'\badnatet\b', 'adnato'),
    (r'\badnauimus\b', 'adnato'),
    (r'\badnauisse\b', 'adnato'),
    (r'\badnauit\b', 'adnato'),
    (r'\badnavigantibus\b', 'adnavigo'),
    (r'\badnavigasset\b', 'adnavigo'),
    (r'\badnavigavimus\b', 'adnavigo'),
    (r'\badnavimus\b', 'adnato'),
    (r'\badne\b', 'anne'),
    (r'\badnectam\b', 'adnecto'),
    (r'\badnectantque\b', 'adnecto'),
    (r'\badnectantur\b', 'adnecto'),
    (r'\badnecte\b', 'adnecto'),
    (r'\badnectebat\b', 'adnecto'),
    (r'\badnectebatque\b', 'adnecto'),
    (r'\badnectebatur\b', 'adnecto'),
    (r'\badnectendo\b', 'adnecto'),
    (r'\badnectendum\b', 'adnecto'),
    (r'\badnectens\b', 'adnecto'),
    (r'\badnectentem\b', 'adnecto'),
    (r'\badnectere\b', 'adnecto'),
    (r'\badnectetur\b', 'adnecto'),
    (r'\badnecti\b', 'adnecto'),
    (r'\badnectit\b', 'adnecto'),
    (r'\badnectite\b', 'adnecto'),
    (r'\badnectitur\b', 'adnecto'),
    (r'\badnecto\b', 'adnecto'),
    (r'\badnector\b', 'adnecto'),
    (r'\badnectunt\b', 'adnecto'),
    (r'\badnegata\b', 'adnepos'),
    (r'\badnepos\b', 'adnepos'),
    (r'\badnepote\b', 'adnepos'),
    (r'\badnepotis\b', 'adnepos'),
    (r'\badnepte\b', 'adneptis'),
    (r'\badneptis\b', 'adneptis'),
    (r'\badnexa\b', 'adnecto'),
    (r'\badnexae\b', 'adnecto'),
    (r'\badnexam\b', 'adnecto'),
    (r'\badnexamque\b', 'adnecto'),
    (r'\badnexarum\b', 'adnecto'),
    (r'\badnexas\b', 'adnecto'),
    (r'\badnexi\b', 'adnecto'),
    (r'\badnexionem\b', 'annexio'),
    (r'\badnexis\b', 'adnecto'),
    (r'\badnexo\b', 'adnecto'),
    (r'\badnexos\b', 'adnecto'),
    (r'\badnexu\b', 'annexus2'),
    (r'\badnexu\b', 'adnecto'),
    (r'\badnexuerant\b', 'adnecto'),
    (r'\badnexuerat\b', 'adnecto'),
    (r'\badnexuit\b', 'adnecto'),
    (r'\badnexum\b', 'annexus2'),
    (r'\badnexum\b', 'adnecto'),
    (r'\badnexus\b', 'annexus2'),
    (r'\badnexus\b', 'adnecto'),
    (r'\badnisa\b', 'annitor'),
    (r'\badnisam\b', 'annitor'),
    (r'\badnisi\b', 'annitor'),
    (r'\badnisos\b', 'annitor'),
    (r'\badnisuros\b', 'annitor'),
    (r'\badnisurum\b', 'annitor'),
    (r'\badnisurumque\b', 'annitor'),
    (r'\badnisurus\b', 'annitor'),
    (r'\badnisus\b', 'annisus2'),
    (r'\badnisus\b', 'annitor'),
    (r'\badnitamur\b', 'annitor'),
    (r'\badnitantur\b', 'annitor'),
    (r'\badnitar\b', 'annitor'),
    (r'\badnitatur\b', 'annitor'),
    (r'\badnitebantur\b', 'adnitendus'),
    (r'\badnitebatur\b', 'adnitendus'),
    (r'\badnitenda\b', 'adnitendus'),
    (r'\badnitendum\b', 'adnitendus'),
    (r'\badnitente\b', 'adnitendus'),
    (r'\badnitentem\b', 'adnitendus'),
    (r'\badnitentibus\b', 'adnitendus'),
    (r'\badniterentur\b', 'adnitendus'),
    (r'\badniteretur\b', 'adnitendus'),
    (r'\badniti\b', 'annitor'),
    (r'\badnitier\b', 'annitor'),
    (r'\badnitimini\b', 'annitor'),
    (r'\badnititur\b', 'annitor'),
    (r'\badnitundum\b', 'annitor'),
    (r'\badnituntur\b', 'annitor'),
    (r'\badnixa\b', 'annitor'),
    (r'\badnixae\b', 'annitor'),
    (r'\badnixi\b', 'annitor'),
    (r'\badnixis\b', 'annitor'),
    (r'\badnixum\b', 'annitor'),
    (r'\badnixus\b', 'annitor'),
    (r'\badnodant\b', 'adnitendus'),
    (r'\badnodato\b', 'adnitendus'),
    (r'\badnodatur\b', 'adnitendus'),
    (r'\badnodatus\b', 'adnitendus'),
    (r'\badnomen\b', 'agnomen'),
    (r'\badnominatio\b', 'agnominatio'),
    (r'\badnominationem\b', 'agnominatio'),
    (r'\badnominationes\b', 'agnominatio'),
    (r'\badnominationibus\b', 'agnominatio'),
    (r'\badnoscant\b', 'agnosco'),
    (r'\badnosceret\b', 'agnosco'),
    (r'\badnoscitur\b', 'agnosco'),
    (r'\badnota\b', 'agnosco'),
    (r'\badnotabant\b', 'adobruo'),
    (r'\badnotabantur\b', 'adobruo'),
    (r'\badnotabat\b', 'adobruo'),
    (r'\badnotabatur\b', 'adobruo'),
    (r'\badnotabimus\b', 'adobruo'),
    (r'\badnotabo\b', 'adobruo'),
    (r'\badnotamentis\b', 'annotamentum'),
    (r'\badnotamus\b', 'adobruo'),
    (r'\badnotanda\b', 'adobruo'),
    (r'\badnotandae\b', 'adobruo'),
    (r'\badnotandaque\b', 'adobruo'),
    (r'\badnotandum\b', 'adobruo'),
    (r'\badnotant\b', 'adobruo'),
    (r'\badnotante\b', 'adobruo'),
    (r'\badnotantibus\b', 'adobruo'),
    (r'\badnotantur\b', 'adobruo'),
    (r'\badnotare\b', 'adobruo'),
    (r'\badnotaremus\b', 'adobruo'),
    (r'\badnotarent\b', 'adobruo'),
    (r'\badnotaret\b', 'adobruo'),
    (r'\badnotari\b', 'adobruo'),
    (r'\badnotasse\b', 'adobruo'),
    (r'\badnotasset\b', 'adobruo'),
    (r'\badnotat\b', 'adobruo'),
    (r'\badnotata\b', 'adobruo'),
    (r'\badnotati\b', 'adobruo'),
    (r'\badnotatio\b', 'annotatio'),
    (r'\badnotatione\b', 'annotatio'),
    (r'\badnotationem\b', 'annotatio'),
    (r'\badnotationi\b', 'annotatio'),
    (r'\badnotationibus\b', 'annotatio'),
    (r'\badnotatis\b', 'adobruo'),
    (r'\badnotatiunculis\b', 'annotatiuncula'),
    (r'\badnotatorque\b', 'annotator'),
    (r'\badnotatorum\b', 'annotator'),
    (r'\badnotatos\b', 'adobruo'),
    (r'\badnotatu\b', 'adobruo'),
    (r'\badnotatum\b', 'adobruo'),
    (r'\badnotatumque\b', 'adobruo'),
    (r'\badnotatur\b', 'adobruo'),
    (r'\badnotaturos\b', 'adobruo'),
    (r'\badnotatus\b', 'adobruo'),
    (r'\badnotatusque\b', 'adobruo'),
    (r'\badnotaueras\b', 'adobruo'),
    (r'\badnotauerint\b', 'adobruo'),
    (r'\badnotaueris\b', 'adobruo'),
    (r'\badnotauerit\b', 'adobruo'),
    (r'\badnotauerunt\b', 'adobruo'),
    (r'\badnotaui\b', 'adobruo'),
    (r'\badnotauimus\b', 'adobruo'),
    (r'\badnotauit\b', 'adobruo'),
    (r'\badnotavere\b', 'adobruo'),
    (r'\badnotaverim\b', 'adobruo'),
    (r'\badnotavit\b', 'adobruo'),
    (r'\badnotemus\b', 'adobruo'),
    (r'\badnotes\b', 'adobruo'),
    (r'\badnotet\b', 'adobruo'),
    (r'\badnotetur\b', 'adobruo'),
    (r'\badnuas\b', 'annuo'),
    (r'\badnuat\b', 'annuo'),
    (r'\badnuatque\b', 'annuo'),
    (r'\badnue\b', 'annuo'),
    (r'\badnuebat\b', 'annuo'),
    (r'\badnuendi\b', 'annuo'),
    (r'\badnuente\b', 'annuo'),
    (r'\badnuentes\b', 'annuo'),
    (r'\badnuentibus\b', 'annuo'),
    (r'\badnuentique\b', 'annuo'),
    (r'\badnueram\b', 'annuo'),
    (r'\badnuerant\b', 'annuo'),
    (r'\badnuerat\b', 'annuo'),
    (r'\badnuere\b', 'annuo'),
    (r'\badnueremque\b', 'annuo'),
    (r'\badnuerent\b', 'annuo'),
    (r'\badnueres\b', 'annuo'),
    (r'\badnueret\b', 'annuo'),
    (r'\badnuerimque\b', 'annuo'),
    (r'\badnuerint\b', 'annuo'),
    (r'\badnuerit\b', 'annuo'),
    (r'\badnuerunt\b', 'annuo'),
    (r'\badnuet\b', 'annuo'),
    (r'\badnuimus\b', 'annuo'),
    (r'\badnuimusque\b', 'annuo'),
    (r'\badnuis\b', 'annuo'),
    (r'\badnuisse\b', 'annuo'),
    (r'\badnuissent\b', 'annuo'),
    (r'\badnuisset\b', 'annuo'),
    (r'\badnuissetis\b', 'annuo'),
    (r'\badnuistin\b', 'annuo'),
    (r'\badnuit\b', 'annuo'),
    (r'\badnuite\b', 'annuo'),
    (r'\badnuitur\b', 'annuo'),
    (r'\badnumerabatur\b', 'adobruo'),
    (r'\badnumerabimus\b', 'adobruo'),
    (r'\badnumerabitur\b', 'adobruo'),
    (r'\badnumerabor\b', 'adobruo'),
    (r'\badnumeranda\b', 'adobruo'),
    (r'\badnumerandam\b', 'adobruo'),
    (r'\badnumerandi\b', 'adobruo'),
    (r'\badnumerandum\b', 'adobruo'),
    (r'\badnumerandus\b', 'adobruo'),
    (r'\badnumerant\b', 'adobruo'),
    (r'\badnumerante\b', 'adobruo'),
    (r'\badnumerantur\b', 'adobruo'),
    (r'\badnumerare\b', 'adobruo'),
    (r'\badnumerarer\b', 'adobruo'),
    (r'\badnumeraret\b', 'adobruo'),
    (r'\badnumeraretur\b', 'adobruo'),
    (r'\badnumerari\b', 'adobruo'),
    (r'\badnumeras\b', 'adobruo'),
    (r'\badnumerasse\b', 'adobruo'),
    (r'\badnumerasset\b', 'adobruo'),
    (r'\badnumerat\b', 'adobruo'),
    (r'\badnumerata\b', 'adobruo'),
    (r'\badnumerataque\b', 'adobruo'),
    (r'\badnumerataue\b', 'adobruo'),
    (r'\badnumerati\b', 'adobruo'),
    (r'\badnumeratis\b', 'adobruo'),
    (r'\badnumerato\b', 'adobruo'),
    (r'\badnumeratos\b', 'adobruo'),
    (r'\badnumeratum\b', 'adobruo'),
    (r'\badnumeratur\b', 'adobruo'),
    (r'\badnumeratus\b', 'adobruo'),
    (r'\badnumeraueris\b', 'adobruo'),
    (r'\badnumerauimus\b', 'adobruo'),
    (r'\badnumeravit\b', 'adobruo'),
    (r'\badnumerentur\b', 'adobruo'),
    (r'\badnumerer\b', 'adobruo'),
    (r'\badnumeres\b', 'adobruo'),
    (r'\badnumeretur\b', 'adobruo'),
    (r'\badnumero\b', 'adobruo'),
    (r'\badnumeror\b', 'adobruo'),
    (r'\badnuntia\b', 'adobruo'),
    (r'\badnuntiabam\b', 'adobruo'),
    (r'\badnuntiabat\b', 'adobruo'),
    (r'\badnuntiabimus\b', 'adobruo'),
    (r'\badnuntiabis\b', 'adobruo'),
    (r'\badnuntiabit\b', 'adobruo'),
    (r'\badnuntiabitur\b', 'adobruo'),
    (r'\badnuntiabo\b', 'adobruo'),
    (r'\badnuntiabunt\b', 'adobruo'),
    (r'\badnuntiabuntur\b', 'adobruo'),
    (r'\badnuntiamus\b', 'adobruo'),
    (r'\badnuntiandam\b', 'adobruo'),
    (r'\badnuntiandum\b', 'adobruo'),
    (r'\badnuntians\b', 'adobruo'),
    (r'\badnuntiant\b', 'adobruo'),
    (r'\badnuntiante\b', 'adobruo'),
    (r'\badnuntiantes\b', 'adobruo'),
    (r'\badnuntiantis\b', 'adobruo'),
    (r'\badnuntiare\b', 'adobruo'),
    (r'\badnuntiarem\b', 'adobruo'),
    (r'\badnuntiarent\b', 'adobruo'),
    (r'\badnuntiaret\b', 'adobruo'),
    (r'\badnuntiaretur\b', 'adobruo'),
    (r'\badnuntiari\b', 'adobruo'),
    (r'\badnuntias\b', 'adobruo'),
    (r'\badnuntiasset\b', 'adobruo'),
    (r'\badnuntiasti\b', 'adobruo'),
    (r'\badnuntiastis\b', 'adobruo'),
    (r'\badnuntiat\b', 'adobruo'),
    (r'\badnuntiata\b', 'adobruo'),
    (r'\badnuntiate\b', 'adobruo'),
    (r'\badnuntiatio\b', 'annuntiatio'),
    (r'\badnuntiationes\b', 'annuntiatio'),
    (r'\badnuntiatis\b', 'adobruo'),
    (r'\badnuntiator\b', 'annuntiator'),
    (r'\badnuntiatum\b', 'adobruo'),
    (r'\badnuntiatur\b', 'adobruo'),
    (r'\badnuntiaturus\b', 'adobruo'),
    (r'\badnuntiaverat\b', 'adobruo'),
    (r'\badnuntiavere\b', 'adobruo'),
    (r'\badnuntiaveris\b', 'adobruo'),
    (r'\badnuntiaverit\b', 'adobruo'),
    (r'\badnuntiavero\b', 'adobruo'),
    (r'\badnuntiaverunt\b', 'adobruo'),
    (r'\badnuntiaveruntque\b', 'adobruo'),
    (r'\badnuntiavi\b', 'adobruo'),
    (r'\badnuntiavit\b', 'adobruo'),
    (r'\badnuntiem\b', 'adobruo'),
    (r'\badnuntient\b', 'adobruo'),
    (r'\badnuntiet\b', 'adobruo'),
    (r'\badnuntietis\b', 'adobruo'),
    (r'\badnuntietur\b', 'adobruo'),
    (r'\badnuntii\b', 'annuntius'),
    (r'\badnuntio\b', 'annuntius'),
    (r'\badnuntium\b', 'annuntius'),
    (r'\badnuo\b', 'annuo'),
    (r'\badnuont\b', 'annuo'),
    (r'\badnutante\b', 'adobruo'),
    (r'\badnutat\b', 'adobruo'),
    (r'\badnutent\b', 'adobruo'),
    (r'\badnutriunt\b', 'adobruo'),
    (r'\badnuunt\b', 'annuo'),
    (r'\badnve\b', 'ad'),
    (r'\badnvis\b', 'ad'),
    (r'\badobruantur\b', 'adobruo'),
    (r'\badobruas\b', 'adobruo'),
    (r'\badobruentur\b', 'adobruo'),
    (r'\badobruere\b', 'adobruo'),
    (r'\badobrui\b', 'adobruo'),
    (r'\badobruito\b', 'adobruo'),
    (r'\badobruitur\b', 'adobruo'),
    (r'\badobruiturque\b', 'adobruo'),
    (r'\badobruunt\b', 'adobruo'),
    (r'\badobruuntur\b', 'adobruo'),
    (r'\badole\b', 'adoleo1'),
    (r'\badoleas\b', 'adoleo1'),
    (r'\badoleatur\b', 'adoleo1'),
    (r'\badolebant\b', 'adoleo1'),
    (r'\badolebat\b', 'adoleo1'),
    (r'\badolebatur\b', 'adoleo1'),
    (r'\badolebis\b', 'adoleo1'),
    (r'\badolebit\b', 'adoleo1'),
    (r'\badolebitis\b', 'adoleo1'),
    (r'\badolebitque\b', 'adoleo1'),
    (r'\badolebitur\b', 'adoleo1'),
    (r'\badolebunt\b', 'adoleo1'),
    (r'\badolebuntque\b', 'adoleo1'),
    (r'\badolemus\b', 'adoleo1'),
    (r'\badolenda\b', 'adoleo1'),
    (r'\badolendos\b', 'adoleo1'),
    (r'\badolendum\b', 'adoleo1'),
    (r'\badolens\b', 'adoleo1'),
    (r'\badolent\b', 'adoleo1'),
    (r'\badolentes\b', 'adoleo1'),
    (r'\badolentque\b', 'adoleo1'),
    (r'\badolentur\b', 'adoleo1'),
    (r'\badolere\b', 'adoleo1'),
    (r'\badolerent\b', 'adoleo1'),
    (r'\badoleret\b', 'adoleo1'),
    (r'\badolerique\b', 'adoleo1'),
    (r'\badolescant\b', 'adolesco'),
    (r'\badolescat\b', 'adolesco'),
    (r'\badolescebant\b', 'adolesco'),
    (r'\badolescebat\b', 'adolesco'),
    (r'\badolescendi\b', 'adolesco'),
    (r'\badolescens\b', 'adolesco'),
    (r'\badolescente\b', 'adolesco'),
    (r'\badolescentem\b', 'adolesco'),
    (r'\badolescentes\b', 'adolesco'),
    (r'\badolescenti\b', 'adolesco'),
    (r'\badolescentia\b', 'adulescentia'),
    (r'\badolescentia\b', 'adolesco'),
    (r'\badolescentiae\b', 'adulescentia'),
    (r'\badolescentiam\b', 'adulescentia'),
    (r'\badolescentibus\b', 'adolesco'),
    (r'\badolescentior\b', 'adolesco'),
    (r'\badolescentis\b', 'adolesco'),
    (r'\badolescentium\b', 'adolesco'),
    (r'\badolescentulas\b', 'adulescentula'),
    (r'\badolescentulo\b', 'adulescentulus'),
    (r'\badolescentulos\b', 'adulescentulus'),
    (r'\badolescentulus\b', 'adulescentulus'),
    (r'\badolescere\b', 'adolesco'),
    (r'\badolescerent\b', 'adolesco'),
    (r'\badolesceret\b', 'adolesco'),
    (r'\badolescet\b', 'adolesco'),
    (r'\badolescit\b', 'adolesco'),
    (r'\badolescitque\b', 'adolesco'),
    (r'\badolescunt\b', 'adolesco'),
    (r'\badolesse\b', 'adolesco'),
    (r'\badolet\b', 'adoleo1'),
    (r'\badoletur\b', 'adoleo1'),
    (r'\badoleuerat\b', 'adolesco'),
    (r'\badoleuerint\b', 'adolesco'),
    (r'\badoleuerit\b', 'adolesco'),
    (r'\badoleuerunt\b', 'adolesco'),
    (r'\badoleuisse\b', 'adolesco'),
    (r'\badoleuisset\b', 'adolesco'),
    (r'\badoleuit\b', 'adolesco'),
    (r'\badoleverat\b', 'adolesco'),
    (r'\badolevere\b', 'adolesco'),
    (r'\badoleverint\b', 'adolesco'),
    (r'\badoleveris\b', 'adolesco'),
    (r'\badoleverit\b', 'adolesco'),
    (r'\badoleverunt\b', 'adolesco'),
    (r'\badolevi\b', 'adolesco'),
    (r'\badolevisse\b', 'adolesco'),
    (r'\badolevissent\b', 'adolesco'),
    (r'\badolevisset\b', 'adolesco'),
    (r'\badolevit\b', 'adolesco'),
    (r'\badoluerunt\b', 'adoleo1'),
    (r'\badon\b', 'ador'),
    (r'\badone\b', 'ador'),
    (r'\badonem\b', 'adoperio'),
    (r'\bAdoneum\b', 'Adoneus1'),
    (r'\bAdoneum\b', 'Adoneus2'),
    (r'\bAdoneus\b', 'Adoneus1'),
    (r'\badoni\b', 'adonium'),
    (r'\bAdonia\b', 'Adonia'),
    (r'\badonia\b', 'adonium'),
    (r'\badonidem\b', 'adonium'),
    (r'\badonin\b', 'adonium'),
    (r'\badonio\b', 'adonium'),
    (r'\bAdonium\b', 'Adonia'),
    (r'\badonium\b', 'adonium'),
    (r'\badoperies\b', 'adoperio'),
    (r'\badoperiri\b', 'adoperio'),
    (r'\badoperito\b', 'adoperio'),
    (r'\badoperiunt\b', 'adoperio'),
    (r'\badoperta\b', 'adopertum'),
    (r'\badoperta\b', 'adoperio'),
    (r'\badopertam\b', 'adoperio'),
    (r'\badopertaque\b', 'adopertum'),
    (r'\badopertaque\b', 'adoperio'),
    (r'\badopertis\b', 'adopertum'),
    (r'\badopertis\b', 'adoperio'),
    (r'\badoperto\b', 'adopertum'),
    (r'\badoperto\b', 'adoperio'),
    (r'\badopertoque\b', 'adopertum'),
    (r'\badopertoque\b', 'adoperio'),
    (r'\badopertus\b', 'adoperio'),
    (r'\badoperuit\b', 'adoperio'),
    (r'\badopinamur\b', 'adopinor'),
    (r'\badopta\b', 'adopto'),
    (r'\badoptabant\b', 'adopto'),
    (r'\badoptabaris\b', 'adopto'),
    (r'\badoptabat\b', 'adopto'),
    (r'\badoptabatur\b', 'adopto'),
    (r'\badoptaberis\b', 'adopto'),
    (r'\badoptabimur\b', 'adopto'),
    (r'\badoptabit\b', 'adopto'),
    (r'\badoptabitur\b', 'adopto'),
    (r'\badoptamus\b', 'adopto'),
    (r'\badoptandi\b', 'adopto'),
    (r'\badoptando\b', 'adopto'),
    (r'\badoptandos\b', 'adopto'),
    (r'\badoptandum\b', 'adopto'),
    (r'\badoptandus\b', 'adopto'),
    (r'\badoptans\b', 'adopto'),
    (r'\badoptant\b', 'adopto'),
    (r'\badoptante\b', 'adopto'),
    (r'\badoptanti\b', 'adopto'),
    (r'\badoptantis\b', 'adopto'),
    (r'\badoptantur\b', 'adopto'),
    (r'\badoptarant\b', 'adopto'),
    (r'\badoptare\b', 'adopto'),
    (r'\badoptarem\b', 'adopto'),
    (r'\badoptarent\b', 'adopto'),
    (r'\badoptarer\b', 'adopto'),
    (r'\badoptarere\b', 'adopto'),
    (r'\badoptares\b', 'adopto'),
    (r'\badoptaret\b', 'adopto'),
    (r'\badoptaretur\b', 'adopto'),
    (r'\badoptari\b', 'adopto'),
    (r'\badoptarit\b', 'adopto'),
    (r'\badoptarunt\b', 'adopto'),
    (r'\badoptas\b', 'adopto'),
    (r'\badoptasse\b', 'adopto'),
    (r'\badoptassent\b', 'adopto'),
    (r'\badoptasses\b', 'adopto'),
    (r'\badoptasset\b', 'adopto'),
    (r'\badoptat\b', 'adopto'),
    (r'\badoptata\b', 'adopto'),
    (r'\badoptati\b', 'adopto'),
    (r'\badoptaticium\b', 'adoptaticius'),
    (r'\badoptaticius\b', 'adoptaticius'),
    (r'\badoptatio\b', 'adoptatio'),
    (r'\badoptatione\b', 'adoptatio'),
    (r'\badoptationem\b', 'adoptatio'),
    (r'\badoptationes\b', 'adoptatio'),
    (r'\badoptatis\b', 'adopto'),
    (r'\badoptato\b', 'adopto'),
    (r'\badoptator\b', 'adoptator'),
    (r'\badoptatori\b', 'adoptator'),
    (r'\badoptatum\b', 'adopto'),
    (r'\badoptatur\b', 'adopto'),
    (r'\badoptaturam\b', 'adopto'),
    (r'\badoptaturus\b', 'adopto'),
    (r'\badoptatus\b', 'adopto'),
    (r'\badoptatusque\b', 'adopto'),
    (r'\badoptauerat\b', 'adopto'),
    (r'\badoptauerimus\b', 'adopto'),
    (r'\badoptauerint\b', 'adopto'),
    (r'\badoptaueris\b', 'adopto'),
    (r'\badoptauerit\b', 'adopto'),
    (r'\badoptauero\b', 'adopto'),
    (r'\badoptaui\b', 'adopto'),
    (r'\badoptauit\b', 'adopto'),
    (r'\badoptaverant\b', 'adopto'),
    (r'\badoptaverat\b', 'adopto'),
    (r'\badoptaveris\b', 'adopto'),
    (r'\badoptavi\b', 'adopto'),
    (r'\badoptavit\b', 'adopto'),
    (r'\badoptem\b', 'adopto'),
    (r'\badoptentur\b', 'adopto'),
    (r'\badoptes\b', 'adopto'),
    (r'\badoptet\b', 'adopto'),
    (r'\badoptetur\b', 'adopto'),
    (r'\badoptio\b', 'adoptio'),
    (r'\badoption\b', 'adoptio'),
    (r'\badoptione\b', 'adoptio'),
    (r'\badoptionem\b', 'adoptio'),
    (r'\badoptiones\b', 'adoptio'),
    (r'\badoptionibus\b', 'adoptio'),
    (r'\badoptionis\b', 'adoptio'),
    (r'\badoptiua\b', 'adoptivus'),
    (r'\badoptiuae\b', 'adoptivus'),
    (r'\badoptiuam\b', 'adoptivus'),
    (r'\badoptiui\b', 'adoptivus'),
    (r'\badoptiuis\b', 'adoptivus'),
    (r'\badoptiuo\b', 'adoptivus'),
    (r'\badoptiuorum\b', 'adoptivus'),
    (r'\badoptiuos\b', 'adoptivus'),
    (r'\badoptiuum\b', 'adoptivus'),
    (r'\badoptiuus\b', 'adoptivus'),
    (r'\badoptiva\b', 'adoptivus'),
    (r'\badoptivas\b', 'adoptivus'),
    (r'\badoptivi\b', 'adoptivus'),
    (r'\badoptivis\b', 'adoptivus'),
    (r'\badoptivo\b', 'adoptivus'),
    (r'\badoptivos\b', 'adoptivus'),
    (r'\badoptivum\b', 'adoptivus'),
    (r'\badoptivus\b', 'adoptivus'),
    (r'\badopto\b', 'adopto'),
    (r'\badoptor\b', 'adopto'),
    (r'\bador\b', 'ador'),
    (r'\badora\b', 'adoro'),
    (r'\badorabant\b', 'adoro'),
    (r'\badorabat\b', 'adoro'),
    (r'\badorabile\b', 'adorabilis'),
    (r'\badorabimus\b', 'adoro'),
    (r'\badorabis\b', 'adoro'),
    (r'\badorabit\b', 'adoro'),
    (r'\badorabitis\b', 'adoro'),
    (r'\badorabo\b', 'adoro'),
    (r'\badorabunt\b', 'adoro'),
    (r'\badoramus\b', 'adoro'),
    (r'\badorandae\b', 'adoro'),
    (r'\badorandi\b', 'adoro'),
    (r'\badorando\b', 'adoro'),
    (r'\badorandum\b', 'adoro'),
    (r'\badorandus\b', 'adoro'),
    (r'\badorans\b', 'adoro'),
    (r'\badorant\b', 'adoro'),
    (r'\badorante\b', 'adoro'),
    (r'\badorantem\b', 'adoro'),
    (r'\badorantes\b', 'adoro'),
    (r'\badoranti\b', 'adoro'),
    (r'\badorantium\b', 'adoro'),
    (r'\badorare\b', 'adoro'),
    (r'\badorarem\b', 'adoro'),
    (r'\badorarent\b', 'adoro'),
    (r'\badoraret\b', 'adoro'),
    (r'\badoraretur\b', 'adoro'),
    (r'\badorari\b', 'adoro'),
    (r'\badorarint\b', 'adoro'),
    (r'\badorarunt\b', 'adoro'),
    (r'\badoras\b', 'adoro'),
    (r'\badorasse\b', 'adoro'),
    (r'\badorassent\b', 'adoro'),
    (r'\badorasset\b', 'adoro'),
    (r'\badorasti\b', 'adoro'),
    (r'\badorat\b', 'adoro'),
    (r'\badorata\b', 'adoro'),
    (r'\badoratam\b', 'adoro'),
    (r'\badoratas\b', 'adoro'),
    (r'\badorate\b', 'adoro'),
    (r'\badorati\b', 'adoro'),
    (r'\badoratione\b', 'adoratio'),
    (r'\badorationem\b', 'adoratio'),
    (r'\badorationibus\b', 'adoratio'),
    (r'\badoratis\b', 'adoro'),
    (r'\badorato\b', 'adoro'),
    (r'\badoratores\b', 'adorator'),
    (r'\badoratum\b', 'adoro'),
    (r'\badoraturus\b', 'adoro'),
    (r'\badoratus\b', 'adoro'),
    (r'\badoraueritis\b', 'adoro'),
    (r'\badoraui\b', 'adoro'),
    (r'\badorauit\b', 'adoro'),
    (r'\badorauitque\b', 'adoro'),
    (r'\badoraverimus\b', 'adoro'),
    (r'\badoraverint\b', 'adoro'),
    (r'\badoraveris\b', 'adoro'),
    (r'\badoraverit\b', 'adoro'),
    (r'\badoraveritis\b', 'adoro'),
    (r'\badoravero\b', 'adoro'),
    (r'\badoraverunt\b', 'adoro'),
    (r'\badoravi\b', 'adoro'),
    (r'\badoravisse\b', 'adoro'),
    (r'\badoravit\b', 'adoro'),
    (r'\badoravitque\b', 'adoro'),
    (r'\badordinabis\b', 'adordino'),
    (r'\badorea\b', 'adorea'),
    (r'\badorea\b', 'adoreus1'),
    (r'\badoreas\b', 'adorea'),
    (r'\badorei\b', 'adoreus1'),
    (r'\badorei\b', 'adoreus1'),
    (r'\badoreis\b', 'adorea'),
    (r'\badoreis\b', 'adoreus1'),
    (r'\badoreis\b', 'adoreus1'),
    (r'\badorem\b', 'adoro'),
    (r'\badoremus\b', 'adoro'),
    (r'\badorent\b', 'adoro'),
    (r'\badoreo\b', 'adoreus1'),
    (r'\bAdoreo\b', 'Adoreus2'),
    (r'\badoreo\b', 'adoreus1'),
    (r'\badores\b', 'adoro'),
    (r'\badoret\b', 'adoro'),
    (r'\badoretis\b', 'adoro'),
    (r'\badoretisque\b', 'adoro'),
    (r'\badoretur\b', 'adoro'),
    (r'\badoreum\b', 'adoreus1'),
    (r'\badoreum\b', 'adoreus1'),
    (r'\badori\b', 'adorio'),
    (r'\badoriam\b', 'adorio'),
    (r'\badoriamur\b', 'adorio'),
    (r'\badoriant\b', 'adorio'),
    (r'\badoriantur\b', 'adorio'),
    (r'\badoriar\b', 'adorio'),
    (r'\badoriare\b', 'adorio'),
    (r'\badoriatur\b', 'adorio'),
    (r'\badoriebantur\b', 'adorio'),
    (r'\badoriebatur\b', 'adorio'),
    (r'\badoriemur\b', 'adorio'),
    (r'\badoriendam\b', 'adorio'),
    (r'\badorirentur\b', 'adorio'),
    (r'\badoriretur\b', 'adorio'),
    (r'\badoriri\b', 'adorio'),
    (r'\badoris\b', 'adorio'),
    (r'\badoritur\b', 'adorio'),
    (r'\badoriundi\b', 'adorio'),
    (r'\badoriuntur\b', 'adorio'),
    (r'\badorna\b', 'adorno'),
    (r'\badornabant\b', 'adorno'),
    (r'\badornabat\b', 'adorno'),
    (r'\badornabis\b', 'adorno'),
    (r'\badornabit\b', 'adorno'),
    (r'\badornabo\b', 'adorno'),
    (r'\badornanda\b', 'adorno'),
    (r'\badornandum\b', 'adorno'),
    (r'\badornans\b', 'adorno'),
    (r'\badornant\b', 'adorno'),
    (r'\badornantes\b', 'adorno'),
    (r'\badornare\b', 'adorno'),
    (r'\badornarent\b', 'adorno'),
    (r'\badornares\b', 'adorno'),
    (r'\badornaret\b', 'adorno'),
    (r'\badornari\b', 'adorno'),
    (r'\badornas\b', 'adorno'),
    (r'\badornasse\b', 'adorno'),
    (r'\badornasset\b', 'adorno'),
    (r'\badornat\b', 'adorno'),
    (r'\badornata\b', 'adorno'),
    (r'\badornatae\b', 'adorno'),
    (r'\badornatam\b', 'adorno'),
    (r'\badornatas\b', 'adorno'),
    (r'\badornate\b', 'adornate'),
    (r'\badornate\b', 'adorno'),
    (r'\badornati\b', 'adorno'),
    (r'\badornatis\b', 'adorno'),
    (r'\badornatos\b', 'adorno'),
    (r'\badornatum\b', 'adorno'),
    (r'\badornatumque\b', 'adorno'),
    (r'\badornatur\b', 'adorno'),
    (r'\badornatus\b', 'adorno'),
    (r'\badornauerant\b', 'adorno'),
    (r'\badornaui\b', 'adorno'),
    (r'\badornauit\b', 'adorno'),
    (r'\badornauitque\b', 'adorno'),
    (r'\badornavi\b', 'adorno'),
    (r'\badornavit\b', 'adorno'),
    (r'\badornet\b', 'adorno'),
    (r'\badoro\b', 'adoro'),
    (r'\badorsi\b', 'adorea'),
    (r'\badorta\b', 'adorior'),
    (r'\badortae\b', 'adorior'),
    (r'\badortast\b', 'adorior'),
    (r'\badorti\b', 'adorior'),
    (r'\badortique\b', 'adorior'),
    (r'\badortis\b', 'adorior'),
    (r'\badortos\b', 'adorior'),
    (r'\badortum\b', 'adorior'),
    (r'\badortus\b', 'adorior'),
    (r'\badortusque\b', 'adorior'),
    (r'\badortust\b', 'adorior'),
    (r'\badparabantur\b', 'adquiesco'),
    (r'\badparando\b', 'adquiesco'),
    (r'\badparandum\b', 'adquiesco'),
    (r'\badparare\b', 'adquiesco'),
    (r'\badparares\b', 'adquiesco'),
    (r'\badparari\b', 'adquiesco'),
    (r'\badparat\b', 'adquiesco'),
    (r'\badparat\b', 'adquiesco'),
    (r'\badparata\b', 'adquiesco'),
    (r'\badparatis\b', 'adquiesco'),
    (r'\badparatis\b', 'adquiesco'),
    (r'\badparatius\b', 'adquiesco'),
    (r'\badparatu\b', 'apparatus2'),
    (r'\badparatum\b', 'apparatus2'),
    (r'\badparatur\b', 'adquiesco'),
    (r'\badparatus\b', 'apparatus2'),
    (r'\badpare\b', 'appareo'),
    (r'\badpareant\b', 'appareo'),
    (r'\badpareat\b', 'appareo'),
    (r'\badparebat\b', 'appareo'),
    (r'\badparebit\b', 'appareo'),
    (r'\badparent\b', 'appareo'),
    (r'\badparente\b', 'appareo'),
    (r'\badparentia\b', 'apparentia'),
    (r'\badparentia\b', 'appareo'),
    (r'\badparentur\b', 'appareo'),
    (r'\badparere\b', 'appareo'),
    (r'\badpareret\b', 'appareo'),
    (r'\badparet\b', 'appareo'),
    (r'\badparetque\b', 'appareo'),
    (r'\badparetur\b', 'appareo'),
    (r'\badparuerint\b', 'appareo'),
    (r'\badparuerit\b', 'appareo'),
    (r'\badparuisse\b', 'appareo'),
    (r'\badparuisset\b', 'appareo'),
    (r'\badparuisti\b', 'appareo'),
    (r'\badparuit\b', 'appareo'),
    (r'\badpella\b', 'appello1'),
    (r'\badpellabatur\b', 'appello1'),
    (r'\badpellabo\b', 'appello1'),
    (r'\badpellando\b', 'appello1'),
    (r'\badpellandorum\b', 'appello1'),
    (r'\badpellans\b', 'appello1'),
    (r'\badpellant\b', 'appello1'),
    (r'\badpellantibus\b', 'appello1'),
    (r'\badpellantur\b', 'appello1'),
    (r'\badpellare\b', 'appello1'),
    (r'\badpellarent\b', 'appello1'),
    (r'\badpellarentur\b', 'appello1'),
    (r'\badpellaret\b', 'appello1'),
    (r'\badpellaretur\b', 'appello1'),
    (r'\badpellari\b', 'appello1'),
    (r'\badpellas\b', 'appello1'),
    (r'\badpellasse\b', 'appello1'),
    (r'\badpellasset\b', 'appello1'),
    (r'\badpellat\b', 'appello1'),
    (r'\badpellata\b', 'appello1'),
    (r'\badpellati\b', 'appello1'),
    (r'\badpellatque\b', 'appello1'),
    (r'\badpellatum\b', 'appello1'),
    (r'\badpellatur\b', 'appello1'),
    (r'\badpellatus\b', 'appello1'),
    (r'\badpellavere\b', 'appello1'),
    (r'\badpellavimus\b', 'appello1'),
    (r'\badpellavit\b', 'appello1'),
    (r'\badpelle\b', 'adquiesco'),
    (r'\badpellebat\b', 'adquiesco'),
    (r'\badpellem\b', 'appello1'),
    (r'\badpellensque\b', 'adquiesco'),
    (r'\badpellent\b', 'appello1'),
    (r'\badpellentibus\b', 'adquiesco'),
    (r'\badpellere\b', 'appello1'),
    (r'\badpellerent\b', 'adquiesco'),
    (r'\badpelli\b', 'adquiesco'),
    (r'\badpellit\b', 'adquiesco'),
    (r'\badpellitque\b', 'adquiesco'),
    (r'\badpellitur\b', 'adquiesco'),
    (r'\badpello\b', 'appello1'),
    (r'\badpellunt\b', 'adquiesco'),
    (r'\badpelluntur\b', 'adquiesco'),
    (r'\badpendam\b', 'appendo'),
    (r'\badpendat\b', 'appendo'),
    (r'\badpendatis\b', 'appendo'),
    (r'\badpendatur\b', 'appendo'),
    (r'\badpende\b', 'appendo'),
    (r'\badpendeas\b', 'adquiesco'),
    (r'\badpendebat\b', 'appendo'),
    (r'\badpendebatur\b', 'appendo'),
    (r'\badpendens\b', 'appendo'),
    (r'\badpendentes\b', 'appendo'),
    (r'\badpendentia\b', 'appendo'),
    (r'\badpendere\b', 'appendo'),
    (r'\badpenderent\b', 'appendo'),
    (r'\badpenderentur\b', 'appendo'),
    (r'\badpenderes\b', 'appendo'),
    (r'\badpenderet\b', 'appendo'),
    (r'\badpenderis\b', 'appendo'),
    (r'\badpendes\b', 'appendo'),
    (r'\badpendetur\b', 'appendo'),
    (r'\badpendi\b', 'appendo'),
    (r'\badpendique\b', 'appendo'),
    (r'\badpendit\b', 'appendo'),
    (r'\badpendite\b', 'appendo'),
    (r'\badpenditis\b', 'appendo'),
    (r'\badpenditur\b', 'appendo'),
    (r'\badpensa\b', 'appendo'),
    (r'\badpensa\b', 'appensor'),
    (r'\badpensaue\b', 'appendo'),
    (r'\badpensaue\b', 'appensor'),
    (r'\badpenso\b', 'appendo'),
    (r'\badpenso\b', 'appensor'),
    (r'\badpensum\b', 'appendo'),
    (r'\badpensus\b', 'appendo'),
    (r'\badpetam\b', 'adquiesco'),
    (r'\badpetamus\b', 'adquiesco'),
    (r'\badpetant\b', 'adquiesco'),
    (r'\badpetantur\b', 'adquiesco'),
    (r'\badpetas\b', 'adquiesco'),
    (r'\badpetat\b', 'adquiesco'),
    (r'\badpetebam\b', 'adquiesco'),
    (r'\badpetebant\b', 'adquiesco'),
    (r'\badpetebat\b', 'adquiesco'),
    (r'\badpetebatur\b', 'adquiesco'),
    (r'\badpetenda\b', 'adquiesco'),
    (r'\badpetendam\b', 'adquiesco'),
    (r'\badpetendas\b', 'adquiesco'),
    (r'\badpetendi\b', 'adquiesco'),
    (r'\badpetendis\b', 'adquiesco'),
    (r'\badpetendo\b', 'adquiesco'),
    (r'\badpetendos\b', 'adquiesco'),
    (r'\badpetendum\b', 'adquiesco'),
    (r'\badpetendus\b', 'adquiesco'),
    (r'\badpetens\b', 'adquiesco'),
    (r'\badpetent\b', 'adquiesco'),
    (r'\badpetente\b', 'adquiesco'),
    (r'\badpetentem\b', 'adquiesco'),
    (r'\badpetenter\b', 'appetenter'),
    (r'\badpetentes\b', 'adquiesco'),
    (r'\badpetentia\b', 'appetentia'),
    (r'\badpetentiam\b', 'appetentia'),
    (r'\badpetentibus\b', 'adquiesco'),
    (r'\badpetentior\b', 'adquiesco'),
    (r'\badpetentis\b', 'adquiesco'),
    (r'\badpetentissimique\b', 'adquiesco'),
    (r'\badpetentissimum\b', 'adquiesco'),
    (r'\badpetentius\b', 'adquiesco'),
    (r'\badpetere\b', 'adquiesco'),
    (r'\badpeterent\b', 'adquiesco'),
    (r'\badpeteret\b', 'adquiesco'),
    (r'\badpeteretur\b', 'adquiesco'),
    (r'\badpetes\b', 'adquiesco'),
    (r'\badpetet\b', 'adquiesco'),
    (r'\badpeti\b', 'adquiesco'),
    (r'\badpetibiles\b', 'appetibilis'),
    (r'\badpetieris\b', 'adquiesco'),
    (r'\badpetierit\b', 'adquiesco'),
    (r'\badpetimus\b', 'adquiesco'),
    (r'\badpetis\b', 'adquiesco'),
    (r'\badpetisse\b', 'adquiesco'),
    (r'\badpetissent\b', 'adquiesco'),
    (r'\badpetisset\b', 'adquiesco'),
    (r'\badpetisti\b', 'adquiesco'),
    (r'\badpetistis\b', 'adquiesco'),
    (r'\badpetit\b', 'adquiesco'),
    (r'\badpetita\b', 'adquiesco'),
    (r'\badpetitae\b', 'adquiesco'),
    (r'\badpetitam\b', 'adquiesco'),
    (r'\badpetitaque\b', 'adquiesco'),
    (r'\badpetitarum\b', 'adquiesco'),
    (r'\badpetiti\b', 'adquiesco'),
    (r'\badpetitio\b', 'appetitio'),
    (r'\badpetitione\b', 'appetitio'),
    (r'\badpetitionem\b', 'appetitio'),
    (r'\badpetitiones\b', 'appetitio'),
    (r'\badpetitionesque\b', 'appetitio'),
    (r'\badpetitionis\b', 'appetitio'),
    (r'\badpetitionum\b', 'appetitio'),
    (r'\badpetitis\b', 'adquiesco'),
    (r'\badpetitor\b', 'appetitor'),
    (r'\badpetitu\b', 'appetitus2'),
    (r'\badpetitum\b', 'appetitus2'),
    (r'\badpetitumque\b', 'appetitus2'),
    (r'\badpetitur\b', 'adquiesco'),
    (r'\badpetiturum\b', 'adquiesco'),
    (r'\badpetitus\b', 'appetitus2'),
    (r'\badpetiui\b', 'adquiesco'),
    (r'\badpetiverunt\b', 'adquiesco'),
    (r'\badpetivi\b', 'adquiesco'),
    (r'\badpetivisse\b', 'adquiesco'),
    (r'\badpetivit\b', 'adquiesco'),
    (r'\badpeto\b', 'appeto2'),
    (r'\badpetunt\b', 'adquiesco'),
    (r'\badpetuntque\b', 'adquiesco'),
    (r'\badpetuntur\b', 'adquiesco'),
    (r'\badpingeres\b', 'adquiesco'),
    (r'\badpinges\b', 'adquiesco'),
    (r'\badpingit\b', 'adquiesco'),
    (r'\badplaudamus\b', 'applaudo'),
    (r'\badplaudebant\b', 'applaudo'),
    (r'\badplaudens\b', 'applaudo'),
    (r'\badplaudere\b', 'applaudo'),
    (r'\badplaudit\b', 'applaudo'),
    (r'\badplaudite\b', 'applaudo'),
    (r'\badplauditur\b', 'applaudo'),
    (r'\badplausae\b', 'applaudo'),
    (r'\badplauso\b', 'applaudo'),
    (r'\badplica\b', 'applex'),
    (r'\badplica\b', 'applico'),
    (r'\badplicabant\b', 'applico'),
    (r'\badplicabantur\b', 'applico'),
    (r'\badplicabas\b', 'applico'),
    (r'\badplicabat\b', 'applico'),
    (r'\badplicabimus\b', 'applico'),
    (r'\badplicabis\b', 'applico'),
    (r'\badplicabisque\b', 'applico'),
    (r'\badplicabit\b', 'applico'),
    (r'\badplicabitur\b', 'applico'),
    (r'\badplicabo\b', 'applico'),
    (r'\badplicabuntur\b', 'applico'),
    (r'\badplicamus\b', 'applico'),
    (r'\badplicanda\b', 'applico'),
    (r'\badplicandae\b', 'applico'),
    (r'\badplicandam\b', 'applico'),
    (r'\badplicando\b', 'applico'),
    (r'\badplicandum\b', 'applico'),
    (r'\badplicandus\b', 'applico'),
    (r'\badplicant\b', 'applico'),
    (r'\badplicante\b', 'applico'),
    (r'\badplicantes\b', 'applico'),
    (r'\badplicantur\b', 'applico'),
    (r'\badplicare\b', 'applico'),
    (r'\badplicaremus\b', 'applico'),
    (r'\badplicarent\b', 'applico'),
    (r'\badplicarentur\b', 'applico'),
    (r'\badplicaret\b', 'applico'),
    (r'\badplicari\b', 'applico'),
    (r'\badplicas\b', 'applico'),
    (r'\badplicat\b', 'applico'),
    (r'\badplicate\b', 'applico'),
    (r'\badplicatione\b', 'applicatio'),
    (r'\badplicatis\b', 'applico'),
    (r'\badplicatisque\b', 'applico'),
    (r'\badplicato\b', 'applico'),
    (r'\badplicatur\b', 'applico'),
    (r'\badplicemus\b', 'applico'),
    (r'\badplicent\b', 'applico'),
    (r'\badplicentur\b', 'applico'),
    (r'\badplices\b', 'applex'),
    (r'\badplices\b', 'applico'),
    (r'\badplicet\b', 'applico'),
    (r'\badplicetur\b', 'applico'),
    (r'\badplicita\b', 'applico'),
    (r'\badplicitae\b', 'applico'),
    (r'\badplicitiore\b', 'applico'),
    (r'\badplicito\b', 'applico'),
    (r'\badplicitosque\b', 'applico'),
    (r'\badplicitum\b', 'applico'),
    (r'\badplicitus\b', 'applico'),
    (r'\badplicor\b', 'applico'),
    (r'\badplicuerant\b', 'applico'),
    (r'\badplicuerat\b', 'applico'),
    (r'\badplicueris\b', 'applico'),
    (r'\badplicuerunt\b', 'applico'),
    (r'\badplicuimus\b', 'applico'),
    (r'\badplicuisse\b', 'applico'),
    (r'\badplicuisset\b', 'applico'),
    (r'\badplicuit\b', 'applico'),
    (r'\badplicuitque\b', 'applico'),
    (r'\badplorans\b', 'adquiesco'),
    (r'\badploraueris\b', 'adquiesco'),
    (r'\badplosum\b', 'applosus'),
    (r'\badplumbata\b', 'adquiesco'),
    (r'\badplumbato\b', 'adquiesco'),
    (r'\badplumbatum\b', 'adquiesco'),
    (r'\badponam\b', 'appono'),
    (r'\badponant\b', 'appono'),
    (r'\badponantur\b', 'appono'),
    (r'\badponas\b', 'appono'),
    (r'\badponat\b', 'appono'),
    (r'\badponatis\b', 'appono'),
    (r'\badponatur\b', 'appono'),
    (r'\badpone\b', 'appono'),
    (r'\badponebantur\b', 'appono'),
    (r'\badponebat\b', 'appono'),
    (r'\badponebatur\b', 'appono'),
    (r'\badponenda\b', 'appono'),
    (r'\badponent\b', 'appono'),
    (r'\badponentur\b', 'appono'),
    (r'\badponere\b', 'appono'),
    (r'\badponerent\b', 'appono'),
    (r'\badponerentur\b', 'appono'),
    (r'\badponeret\b', 'appono'),
    (r'\badpones\b', 'appono'),
    (r'\badponet\b', 'appono'),
    (r'\badponetur\b', 'appono'),
    (r'\badponi\b', 'appono'),
    (r'\badponis\b', 'appono'),
    (r'\badponit\b', 'appono'),
    (r'\badponite\b', 'appono'),
    (r'\badponitur\b', 'appono'),
    (r'\badponunt\b', 'appono'),
    (r'\badponuntur\b', 'appono'),
    (r'\badporrectumque\b', 'adquiesco'),
    (r'\badporta\b', 'apporto'),
    (r'\badportabat\b', 'apporto'),
    (r'\badportandus\b', 'apporto'),
    (r'\badportant\b', 'apporto'),
    (r'\badportantes\b', 'apporto'),
    (r'\badportanti\b', 'apporto'),
    (r'\badportantur\b', 'apporto'),
    (r'\badportare\b', 'apporto'),
    (r'\badportareque\b', 'apporto'),
    (r'\badportari\b', 'apporto'),
    (r'\badportas\b', 'apporto'),
    (r'\badportasse\b', 'apporto'),
    (r'\badportat\b', 'apporto'),
    (r'\badportata\b', 'apporto'),
    (r'\badportationibus\b', 'apportatio'),
    (r'\badportatis\b', 'apporto'),
    (r'\badportatum\b', 'apporto'),
    (r'\badportatur\b', 'apporto'),
    (r'\badportaui\b', 'apporto'),
    (r'\badportaverant\b', 'apporto'),
    (r'\badportaverint\b', 'apporto'),
    (r'\badportavi\b', 'apporto'),
    (r'\badportavisse\b', 'apporto'),
    (r'\badportavisti\b', 'apporto'),
    (r'\badportavit\b', 'apporto'),
    (r'\badportentur\b', 'apporto'),
    (r'\badportes\b', 'apporto'),
    (r'\badportet\b', 'apporto'),
    (r'\badporto\b', 'apporto'),
    (r'\badposcere\b', 'adquiesco'),
    (r'\badposcunt\b', 'adquiesco'),
    (r'\badposita\b', 'appono'),
    (r'\badpositae\b', 'appono'),
    (r'\badpositam\b', 'appono'),
    (r'\badpositaque\b', 'appono'),
    (r'\badpositas\b', 'appono'),
    (r'\badpositasque\b', 'appono'),
    (r'\badpositast\b', 'appono'),
    (r'\badposite\b', 'apposite'),
    (r'\badposite\b', 'appono'),
    (r'\badpositi\b', 'appono'),
    (r'\badpositio\b', 'appositio'),
    (r'\badpositione\b', 'appositio'),
    (r'\badpositiones\b', 'appositio'),
    (r'\badpositis\b', 'appono'),
    (r'\badpositissimae\b', 'appono'),
    (r'\badpositissimam\b', 'appono'),
    (r'\badposito\b', 'appono'),
    (r'\badpositos\b', 'appono'),
    (r'\badpositu\b', 'appositus2'),
    (r'\badpositu\b', 'appono'),
    (r'\badpositum\b', 'appositus2'),
    (r'\badpositum\b', 'appono'),
    (r'\badpositumque\b', 'appositus2'),
    (r'\badpositumque\b', 'appono'),
    (r'\badpositumst\b', 'appositus2'),
    (r'\badpositumst\b', 'appono'),
    (r'\badposituque\b', 'appositus2'),
    (r'\badposituque\b', 'appono'),
    (r'\badpositus\b', 'appositus2'),
    (r'\badpositus\b', 'appono'),
    (r'\badpositusque\b', 'appositus2'),
    (r'\badpositusque\b', 'appono'),
    (r'\badposueram\b', 'appono'),
    (r'\badposuerat\b', 'appono'),
    (r'\badposueris\b', 'appono'),
    (r'\badposuerit\b', 'appono'),
    (r'\badposuerunt\b', 'appono'),
    (r'\badposui\b', 'appono'),
    (r'\badposuimus\b', 'appono'),
    (r'\badposuisse\b', 'appono'),
    (r'\badposuisset\b', 'appono'),
    (r'\badposuit\b', 'appono'),
    (r'\badposuitque\b', 'appono'),
    (r'\badpotum\b', 'appotus'),
    (r'\badpotus\b', 'appotus'),
    (r'\badpraehendendum\b', 'adquiesco'),
    (r'\badpraehendit\b', 'adquiesco'),
    (r'\badprecabar\b', 'adquiesco'),
    (r'\badprecamur\b', 'adquiesco'),
    (r'\badprecantur\b', 'adquiesco'),
    (r'\badprecati\b', 'adquiesco'),
    (r'\badprecatur\b', 'adquiesco'),
    (r'\badprehendam\b', 'adquiesco'),
    (r'\badprehendant\b', 'adquiesco'),
    (r'\badprehendas\b', 'adquiesco'),
    (r'\badprehendat\b', 'adquiesco'),
    (r'\badprehendatur\b', 'adquiesco'),
    (r'\badprehende\b', 'adquiesco'),
    (r'\badprehendebam\b', 'adquiesco'),
    (r'\badprehendebant\b', 'adquiesco'),
    (r'\badprehendebat\b', 'adquiesco'),
    (r'\badprehendenda\b', 'adquiesco'),
    (r'\badprehendendae\b', 'adquiesco'),
    (r'\badprehendendi\b', 'adquiesco'),
    (r'\badprehendendo\b', 'adquiesco'),
    (r'\badprehendendum\b', 'adquiesco'),
    (r'\badprehendendus\b', 'adquiesco'),
    (r'\badprehendens\b', 'adquiesco'),
    (r'\badprehendensque\b', 'adquiesco'),
    (r'\badprehendent\b', 'adquiesco'),
    (r'\badprehendente\b', 'adquiesco'),
    (r'\badprehendentem\b', 'adquiesco'),
    (r'\badprehendentes\b', 'adquiesco'),
    (r'\badprehendentis\b', 'adquiesco'),
    (r'\badprehendentque\b', 'adquiesco'),
    (r'\badprehendentur\b', 'adquiesco'),
    (r'\badprehenderas\b', 'adquiesco'),
    (r'\badprehenderat\b', 'adquiesco'),
    (r'\badprehendere\b', 'adquiesco'),
    (r'\badprehenderent\b', 'adquiesco'),
    (r'\badprehenderet\b', 'adquiesco'),
    (r'\badprehenderint\b', 'adquiesco'),
    (r'\badprehenderis\b', 'adquiesco'),
    (r'\badprehenderit\b', 'adquiesco'),
    (r'\badprehendero\b', 'adquiesco'),
    (r'\badprehenderunt\b', 'adquiesco'),
    (r'\badprehendes\b', 'adquiesco'),
    (r'\badprehendet\b', 'adquiesco'),
    (r'\badprehendetur\b', 'adquiesco'),
    (r'\badprehendi\b', 'adquiesco'),
    (r'\badprehendimus\b', 'adquiesco'),
    (r'\badprehendisse\b', 'adquiesco'),
    (r'\badprehendissemus\b', 'adquiesco'),
    (r'\badprehendissent\b', 'adquiesco'),
    (r'\badprehendisset\b', 'adquiesco'),
    (r'\badprehendisti\b', 'adquiesco'),
    (r'\badprehendit\b', 'adquiesco'),
    (r'\badprehendite\b', 'adquiesco'),
    (r'\badprehenditque\b', 'adquiesco'),
    (r'\badprehenditur\b', 'adquiesco'),
    (r'\badprehendo\b', 'adquiesco'),
    (r'\badprehendunt\b', 'adquiesco'),
    (r'\badprehenduntur\b', 'adquiesco'),
    (r'\badprehensa\b', 'adquiesco'),
    (r'\badprehensa\b', 'adquiesco'),
    (r'\badprehensae\b', 'adquiesco'),
    (r'\badprehensam\b', 'adquiesco'),
    (r'\badprehensi\b', 'adquiesco'),
    (r'\badprehensis\b', 'adquiesco'),
    (r'\badprehenso\b', 'adquiesco'),
    (r'\badprehenso\b', 'adquiesco'),
    (r'\badprehensoque\b', 'adquiesco'),
    (r'\badprehensoque\b', 'adquiesco'),
    (r'\badprehensos\b', 'adquiesco'),
    (r'\badprehensosque\b', 'adquiesco'),
    (r'\badprehensum\b', 'adquiesco'),
    (r'\badprehensumque\b', 'adquiesco'),
    (r'\badprehensuris\b', 'adquiesco'),
    (r'\badprehensus\b', 'adquiesco'),
    (r'\badprehensusque\b', 'adquiesco'),
    (r'\badprendam\b', 'adquiesco'),
    (r'\badprendas\b', 'adquiesco'),
    (r'\badprendat\b', 'adquiesco'),
    (r'\badprendendo\b', 'adquiesco'),
    (r'\badprendendum\b', 'adquiesco'),
    (r'\badprendere\b', 'adquiesco'),
    (r'\badprendi\b', 'adquiesco'),
    (r'\badprenditis\b', 'adquiesco'),
    (r'\badprenduntur\b', 'adquiesco'),
    (r'\badprensa\b', 'adquiesco'),
    (r'\badprensat\b', 'adquiesco'),
    (r'\badprenso\b', 'adquiesco'),
    (r'\badpressit\b', 'adquiesco'),
    (r'\badpressum\b', 'adquiesco'),
    (r'\badpretiati\b', 'adquiesco'),
    (r'\badpretiatus\b', 'adquiesco'),
    (r'\badpretiaverunt\b', 'adquiesco'),
    (r'\badprime\b', 'apprimus'),
    (r'\badprime\b', 'apprime'),
    (r'\badprimeque\b', 'apprimus'),
    (r'\badprimeque\b', 'apprime'),
    (r'\badprimum\b', 'apprimus'),
    (r'\badprimus\b', 'apprimus'),
    (r'\badproba\b', 'approbus'),
    (r'\badprobabant\b', 'adquiesco'),
    (r'\badprobabas\b', 'adquiesco'),
    (r'\badprobabat\b', 'adquiesco'),
    (r'\badprobabis\b', 'adquiesco'),
    (r'\badprobabit\b', 'adquiesco'),
    (r'\badprobabitur\b', 'adquiesco'),
    (r'\badprobabo\b', 'adquiesco'),
    (r'\badprobanda\b', 'adquiesco'),
    (r'\badprobandae\b', 'adquiesco'),
    (r'\badprobandi\b', 'adquiesco'),
    (r'\badprobando\b', 'adquiesco'),
    (r'\badprobandum\b', 'adquiesco'),
    (r'\badprobandus\b', 'adquiesco'),
    (r'\badprobans\b', 'adquiesco'),
    (r'\badprobant\b', 'adquiesco'),
    (r'\badprobante\b', 'adquiesco'),
    (r'\badprobantem\b', 'adquiesco'),
    (r'\badprobantes\b', 'adquiesco'),
    (r'\badprobanti\b', 'adquiesco'),
    (r'\badprobantibus\b', 'adquiesco'),
    (r'\badprobantis\b', 'adquiesco'),
    (r'\badprobantium\b', 'adquiesco'),
    (r'\badprobantur\b', 'adquiesco'),
    (r'\badprobare\b', 'adquiesco'),
    (r'\badprobarem\b', 'adquiesco'),
    (r'\badprobarent\b', 'adquiesco'),
    (r'\badprobaret\b', 'adquiesco'),
    (r'\badprobaretur\b', 'adquiesco'),
    (r'\badprobari\b', 'adquiesco'),
    (r'\badprobarint\b', 'adquiesco'),
    (r'\badprobaris\b', 'adquiesco'),
    (r'\badprobarit\b', 'adquiesco'),
    (r'\badprobaritis\b', 'adquiesco'),
    (r'\badprobarunt\b', 'adquiesco'),
    (r'\badprobas\b', 'approbus'),
    (r'\badprobasse\b', 'adquiesco'),
    (r'\badprobassem\b', 'adquiesco'),
    (r'\badprobassent\b', 'adquiesco'),
    (r'\badprobasset\b', 'adquiesco'),
    (r'\badprobasti\b', 'adquiesco'),
    (r'\badprobat\b', 'adquiesco'),
    (r'\badprobata\b', 'adquiesco'),
    (r'\badprobatam\b', 'adquiesco'),
    (r'\badprobate\b', 'adquiesco'),
    (r'\badprobati\b', 'adquiesco'),
    (r'\badprobatio\b', 'approbatio'),
    (r'\badprobatione\b', 'approbatio'),
    (r'\badprobationem\b', 'approbatio'),
    (r'\badprobationes\b', 'approbatio'),
    (r'\badprobationis\b', 'approbatio'),
    (r'\badprobatis\b', 'adquiesco'),
    (r'\badprobato\b', 'adquiesco'),
    (r'\badprobatoque\b', 'adquiesco'),
    (r'\badprobatum\b', 'adquiesco'),
    (r'\badprobatur\b', 'adquiesco'),
    (r'\badprobaturi\b', 'adquiesco'),
    (r'\badprobaturus\b', 'adquiesco'),
    (r'\badprobatus\b', 'adquiesco'),
    (r'\badprobauerint\b', 'adquiesco'),
    (r'\badprobauerit\b', 'adquiesco'),
    (r'\badprobauistis\b', 'adquiesco'),
    (r'\badprobauit\b', 'adquiesco'),
    (r'\badprobaverant\b', 'adquiesco'),
    (r'\badprobaverat\b', 'adquiesco'),
    (r'\badprobavere\b', 'adquiesco'),
    (r'\badprobaverimus\b', 'adquiesco'),
    (r'\badprobaverit\b', 'adquiesco'),
    (r'\badprobaverunt\b', 'adquiesco'),
    (r'\badprobavi\b', 'adquiesco'),
    (r'\badprobavissent\b', 'adquiesco'),
    (r'\badprobavisset\b', 'adquiesco'),
    (r'\badprobavit\b', 'adquiesco'),
    (r'\badprobe\b', 'approbus'),
    (r'\badprobe\b', 'approbe'),
    (r'\badprobem\b', 'adquiesco'),
    (r'\badprobemus\b', 'adquiesco'),
    (r'\badprobent\b', 'adquiesco'),
    (r'\badprobes\b', 'adquiesco'),
    (r'\badprobet\b', 'adquiesco'),
    (r'\badprobetis\b', 'adquiesco'),
    (r'\badprobetur\b', 'adquiesco'),
    (r'\badprobo\b', 'approbus'),
    (r'\badprobus\b', 'approbus'),
    (r'\badpromissoremue\b', 'appromissor'),
    (r'\badpromissores\b', 'appromissor'),
    (r'\badpronat\b', 'adquiesco'),
    (r'\badpropera\b', 'appropero'),
    (r'\badproperabo\b', 'appropero'),
    (r'\badproperare\b', 'appropero'),
    (r'\badproperat\b', 'appropero'),
    (r'\badproperate\b', 'appropero'),
    (r'\badproperato\b', 'appropero'),
    (r'\badproperatum\b', 'appropero'),
    (r'\badproperavit\b', 'appropero'),
    (r'\badproperemus\b', 'appropero'),
    (r'\badproperet\b', 'appropero'),
    (r'\badpropero\b', 'appropero'),
    (r'\badpropians\b', 'adquiesco'),
    (r'\badpropiant\b', 'adquiesco'),
    (r'\badpropiante\b', 'adquiesco'),
    (r'\badpropiasset\b', 'adquiesco'),
    (r'\badpropiat\b', 'adquiesco'),
    (r'\badpropiate\b', 'adquiesco'),
    (r'\badpropiaverit\b', 'adquiesco'),
    (r'\badpropiaverunt\b', 'adquiesco'),
    (r'\badpropiavit\b', 'adquiesco'),
    (r'\badpropies\b', 'adquiesco'),
    (r'\badpropiet\b', 'adquiesco'),
    (r'\badpropinqua\b', 'appropinquo'),
    (r'\badpropinquabant\b', 'appropinquo'),
    (r'\badpropinquabat\b', 'appropinquo'),
    (r'\badpropinquabit\b', 'appropinquo'),
    (r'\badpropinquabunt\b', 'appropinquo'),
    (r'\badpropinquans\b', 'appropinquo'),
    (r'\badpropinquansque\b', 'appropinquo'),
    (r'\badpropinquant\b', 'appropinquo'),
    (r'\badpropinquante\b', 'appropinquo'),
    (r'\badpropinquantem\b', 'appropinquo'),
    (r'\badpropinquanteque\b', 'appropinquo'),
    (r'\badpropinquantes\b', 'appropinquo'),
    (r'\badpropinquanti\b', 'appropinquo'),
    (r'\badpropinquantibus\b', 'appropinquo'),
    (r'\badpropinquantis\b', 'appropinquo'),
    (r'\badpropinquantium\b', 'appropinquo'),
    (r'\badpropinquare\b', 'appropinquo'),
    (r'\badpropinquarent\b', 'appropinquo'),
    (r'\badpropinquaret\b', 'appropinquo'),
    (r'\badpropinquarunt\b', 'appropinquo'),
    (r'\badpropinquassent\b', 'appropinquo'),
    (r'\badpropinquasset\b', 'appropinquo'),
    (r'\badpropinquasti\b', 'appropinquo'),
    (r'\badpropinquat\b', 'appropinquo'),
    (r'\badpropinquatio\b', 'appropinquatio'),
    (r'\badpropinquatione\b', 'appropinquatio'),
    (r'\badpropinquatis\b', 'appropinquo'),
    (r'\badpropinquatum\b', 'appropinquo'),
    (r'\badpropinquaverant\b', 'appropinquo'),
    (r'\badpropinquavere\b', 'appropinquo'),
    (r'\badpropinquaverint\b', 'appropinquo'),
    (r'\badpropinquaverit\b', 'appropinquo'),
    (r'\badpropinquaverunt\b', 'appropinquo'),
    (r'\badpropinquavit\b', 'appropinquo'),
    (r'\badpropinquent\b', 'appropinquo'),
    (r'\badpropinques\b', 'appropinquo'),
    (r'\badpropinquet\b', 'appropinquo'),
    (r'\badpropinquetis\b', 'appropinquo'),
    (r'\badproximabunt\b', 'adquiesco'),
    (r'\badproximant\b', 'adquiesco'),
    (r'\badpugnare\b', 'adquiesco'),
    (r'\badpugnarent\b', 'adquiesco'),
    (r'\badpuleram\b', 'adquiesco'),
    (r'\badpulerant\b', 'adquiesco'),
    (r'\badpulerat\b', 'adquiesco'),
    (r'\badpulere\b', 'adquiesco'),
    (r'\badpulerit\b', 'adquiesco'),
    (r'\badpulissent\b', 'adquiesco'),
    (r'\badpulisset\b', 'adquiesco'),
    (r'\badpulisti\b', 'adquiesco'),
    (r'\badpulit\b', 'adquiesco'),
    (r'\badpulsa\b', 'adquiesco'),
    (r'\badpulsa\b', 'adquiesco'),
    (r'\badpulsae\b', 'adquiesco'),
    (r'\badpulsam\b', 'adquiesco'),
    (r'\badpulsaque\b', 'adquiesco'),
    (r'\badpulsaque\b', 'adquiesco'),
    (r'\badpulsas\b', 'adquiesco'),
    (r'\badpulsas\b', 'adquiesco'),
    (r'\badpulsi\b', 'adquiesco'),
    (r'\badpulsis\b', 'adquiesco'),
    (r'\badpulsisque\b', 'adquiesco'),
    (r'\badpulso\b', 'adquiesco'),
    (r'\badpulso\b', 'adquiesco'),
    (r'\badpulsos\b', 'adquiesco'),
    (r'\badpulsu\b', 'appulsus2'),
    (r'\badpulsui\b', 'appulsus2'),
    (r'\badpulsum\b', 'appulsus2'),
    (r'\badpulsus\b', 'appulsus2'),
    (r'\badpuncti\b', 'adquiesco'),
    (r'\badque\b', 'ad'),
    (r'\badqui\b', 'atqui'),
    (r'\badquierunt\b', 'adquiesco'),
    (r'\badquiescam\b', 'adquiesco'),
    (r'\badquiescamus\b', 'adquiesco'),
    (r'\badquiescant\b', 'adquiesco'),
    (r'\badquiescas\b', 'adquiesco'),
    (r'\badquiescat\b', 'adquiesco'),
    (r'\badquiesce\b', 'adquiesco'),
    (r'\badquiescebam\b', 'adquiesco'),
    (r'\badquiescebant\b', 'adquiesco'),
    (r'\badquiescebat\b', 'adquiesco'),
    (r'\badquiescendi\b', 'adquiesco'),
    (r'\badquiescens\b', 'adquiesco'),
    (r'\badquiescent\b', 'adquiesco'),
    (r'\badquiescentem\b', 'adquiesco'),
    (r'\badquiescentes\b', 'adquiesco'),
    (r'\badquiescentibus\b', 'adquiesco'),
    (r'\badquiescere\b', 'adquiesco'),
    (r'\badquiescerent\b', 'adquiesco'),
    (r'\badquiesceret\b', 'adquiesco'),
    (r'\badquiesces\b', 'adquiesco'),
    (r'\badquiescet\b', 'adquiesco'),
    (r'\badquiescimus\b', 'adquiesco'),
    (r'\badquiescis\b', 'adquiesco'),
    (r'\badquiescit\b', 'adquiesco'),
    (r'\badquiesco\b', 'adquiesco'),
    (r'\badquiescunt\b', 'adquiesco'),
    (r'\badquieturus\b', 'adquiesco'),
    (r'\badquieuerat\b', 'adquiesco'),
    (r'\badquieuerit\b', 'adquiesco'),
    (r'\badquieuerunt\b', 'adquiesco'),
    (r'\badquieui\b', 'adquiesco'),
    (r'\badquieuisset\b', 'adquiesco'),
    (r'\badquieuit\b', 'adquiesco'),
    (r'\badquieverint\b', 'adquiesco'),
    (r'\badquieverunt\b', 'adquiesco'),
    (r'\badquievi\b', 'adquiesco'),
    (r'\badquievisti\b', 'adquiesco'),
    (r'\badquievit\b', 'adquiesco'),
    (r'\badquievitque\b', 'adquiesco'),
    (r'\badquin\b', 'atqui'),
    (r'\badquiram\b', 'acquiro'),
    (r'\badquiramus\b', 'acquiro'),
    (r'\badquirant\b', 'acquiro'),
    (r'\badquirantur\b', 'acquiro'),
    (r'\badquiras\b', 'acquiro'),
    (r'\badquirat\b', 'acquiro'),
    (r'\badquiratis\b', 'acquiro'),
    (r'\badquiratur\b', 'acquiro'),
    (r'\badquire\b', 'acquiro'),
    (r'\badquirebat\b', 'acquiro'),
    (r'\badquirebatur\b', 'acquiro'),
    (r'\badquiremus\b', 'acquiro'),
    (r'\badquirenda\b', 'acquiro'),
    (r'\badquirendae\b', 'acquiro'),
    (r'\badquirendarum\b', 'acquiro'),
    (r'\badquirendi\b', 'acquiro'),
    (r'\badquirendis\b', 'acquiro'),
    (r'\badquirendo\b', 'acquiro'),
    (r'\badquirendum\b', 'acquiro'),
    (r'\badquirens\b', 'acquiro'),
    (r'\badquirent\b', 'acquiro'),
    (r'\badquirentem\b', 'acquiro'),
    (r'\badquirentur\b', 'acquiro'),
    (r'\badquirere\b', 'acquiro'),
    (r'\badquireremus\b', 'acquiro'),
    (r'\badquirerentur\b', 'acquiro'),
    (r'\badquireret\b', 'acquiro'),
    (r'\badquireretur\b', 'acquiro'),
    (r'\badquires\b', 'acquiro'),
    (r'\badquiret\b', 'acquiro'),
    (r'\badquiretur\b', 'acquiro'),
    (r'\badquiri\b', 'acquiro'),
    (r'\badquirim\b', 'adquiesco'),
    (r'\badquirimus\b', 'acquiro'),
    (r'\badquirique\b', 'acquiro'),
    (r'\badquiris\b', 'acquiro'),
    (r'\badquirit\b', 'acquiro'),
    (r'\badquirite\b', 'acquiro'),
    (r'\badquiritque\b', 'acquiro'),
    (r'\badquiritur\b', 'acquiro'),
    (r'\badquiro\b', 'acquiro'),
    (r'\badquirunt\b', 'acquiro'),
    (r'\badquiruntur\b', 'acquiro'),
    (r'\badquis\b', 'adquiesco'),
    (r'\badquisierant\b', 'acquiro'),
    (r'\badquisierat\b', 'acquiro'),
    (r'\badquisierim\b', 'acquiro'),
    (r'\badquisierimus\b', 'acquiro'),
    (r'\badquisierint\b', 'acquiro'),
    (r'\badquisieris\b', 'acquiro'),
    (r'\badquisierit\b', 'acquiro'),
    (r'\badquisiero\b', 'acquiro'),
    (r'\badquisierunt\b', 'acquiro'),
    (r'\badquisii\b', 'acquiro'),
    (r'\badquisiit\b', 'acquiro'),
    (r'\badquisisse\b', 'acquiro'),
    (r'\badquisissent\b', 'acquiro'),
    (r'\badquisisses\b', 'acquiro'),
    (r'\badquisisset\b', 'acquiro'),
    (r'\badquisisti\b', 'acquiro'),
    (r'\badquisita\b', 'acquiro'),
    (r'\badquisitae\b', 'acquiro'),
    (r'\badquisitam\b', 'acquiro'),
    (r'\badquisitas\b', 'acquiro'),
    (r'\badquisiti\b', 'acquiro'),
    (r'\badquisitis\b', 'acquiro'),
    (r'\badquisito\b', 'acquiro'),
    (r'\badquisitoque\b', 'acquiro'),
    (r'\badquisitum\b', 'acquiro'),
    (r'\badquisituri\b', 'acquiro'),
    (r'\badquisiturum\b', 'acquiro'),
    (r'\badquisiturus\b', 'acquiro'),
    (r'\badquisitus\b', 'acquiro'),
    (r'\badquisiui\b', 'acquiro'),
    (r'\badquisiuit\b', 'acquiro'),
    (r'\badquisiverat\b', 'acquiro'),
    (r'\badquisivi\b', 'acquiro'),
    (r'\badquisivit\b', 'acquiro'),
    (r'\badradas\b', 'adrado'),
    (r'\badrade\b', 'adrado'),
    (r'\badradenda\b', 'adrado'),
    (r'\badradi\b', 'adrado'),
    (r'\badradito\b', 'adrado'),
    (r'\badradunt\b', 'adrado'),
    (r'\bAdramytenus\b', 'Adramyttenus'),
    (r'\bAdramytii\b', 'Adramyttenus'),
    (r'\bAdramyttenus\b', 'Adramyttenus'),
    (r'\bAdranam\b', 'Adrana'),
    (r'\badraseris\b', 'adrado'),
    (r'\badrasi\b', 'adrado'),
    (r'\badraso\b', 'adrado'),
    (r'\badrasos\b', 'adrado'),
    (r'\bAdraste\b', 'Adrastus'),
    (r'\bAdrastea\b', 'ad-rapio'),
    (r'\bAdrastea\b', 'Adrasteus'),
    (r'\bAdrasteus\b', 'Adrasteus'),
    (r'\bAdrasti\b', 'Adrastus'),
    (r'\bAdrasti\b', 'Adrastus'),
    (r'\bAdrastiam\b', 'ad-rapio'),
    (r'\bAdrasto\b', 'Adrastus'),
    (r'\bAdrastos\b', 'Adrastus'),
    (r'\bAdrastum\b', 'Adrastus'),
    (r'\bAdrastus\b', 'Adrastus'),
    (r'\badrasum\b', 'adrado'),
    (r'\badrasus\b', 'adrado'),
    (r'\badrectae\b', 'ad-recingo'),
    (r'\badrectis\b', 'ad-recingo'),
    (r'\badrectisque\b', 'ad-recingo'),
    (r'\badrectos\b', 'ad-recingo'),
    (r'\badrectus\b', 'ad-recingo'),
    (r'\badremigantes\b', 'adremigo'),
    (r'\badremigantibus\b', 'adremigo'),
    (r'\badremigaverunt\b', 'adremigo'),
    (r'\badrepant\b', 'arrepo'),
    (r'\badrepe\b', 'arrepo'),
    (r'\badrepens\b', 'arrepo'),
    (r'\badrepentesque\b', 'arrepo'),
    (r'\badrepere\b', 'arrepo'),
    (r'\badrepit\b', 'arrepo'),
    (r'\badrepserat\b', 'arrepo'),
    (r'\badrepsisse\b', 'arrepo'),
    (r'\badrepsit\b', 'arrepo'),
    (r'\badrepta\b', 'arrepo'),
    (r'\badreptam\b', 'arrepo'),
    (r'\badrepti\b', 'arrepo'),
    (r'\badreptis\b', 'arrepo'),
    (r'\badrepto\b', 'arrepo'),
    (r'\badreptoque\b', 'arrepo'),
    (r'\badreptum\b', 'arrepo'),
    (r'\badreptumque\b', 'arrepo'),
    (r'\badreptus\b', 'arrepo'),
    (r'\badrepunt\b', 'arrepo'),
    (r'\badrestine\b', 'ad-repleo'),
    (r'\badrexerat\b', 'adremigo'),
    (r'\badrexit\b', 'adremigo'),
    (r'\bAdriacas\b', 'hadrobolon'),
    (r'\bAdriani\b', 'hadrobolon'),
    (r'\bAdriano\b', 'hadrobolon'),
    (r'\bAdrianus\b', 'hadrobolon'),
    (r'\badride\b', 'ad-rogo'),
    (r'\badridemus\b', 'ad-rogo'),
    (r'\badridendum\b', 'ad-rogo'),
    (r'\badridens\b', 'ad-rogo'),
    (r'\badrident\b', 'ad-rogo'),
    (r'\badridentia\b', 'ad-rogo'),
    (r'\badrideo\b', 'ad-rogo'),
    (r'\badridere\b', 'ad-rogo'),
    (r'\badrides\b', 'ad-rogo'),
    (r'\badridet\b', 'ad-rogo'),
    (r'\badrigere\b', 'adremigo'),
    (r'\badrigere\b', 'ad-rogo'),
    (r'\badripe\b', 'ad-rapio'),
    (r'\badripere\b', 'ad-rapio'),
    (r'\badriperet\b', 'ad-rapio'),
    (r'\badripi\b', 'ad-rapio'),
    (r'\badripiente\b', 'ad-rapio'),
    (r'\badripio\b', 'ad-rapio'),
    (r'\badripis\b', 'ad-rapio'),
    (r'\badripit\b', 'ad-rapio'),
    (r'\badripitur\b', 'ad-rapio'),
    (r'\badripiunt\b', 'ad-rapio'),
    (r'\badripui\b', 'ad-rapio'),
    (r'\badripuimus\b', 'ad-rapio'),
    (r'\badripuisse\b', 'ad-rapio'),
    (r'\badripuisset\b', 'ad-rapio'),
    (r'\badripuissetis\b', 'ad-rapio'),
    (r'\badripuisti\b', 'ad-rapio'),
    (r'\badripuit\b', 'ad-rapio'),
    (r'\badriserat\b', 'ad-rogo'),
    (r'\badriseris\b', 'ad-rogo'),
    (r'\badriserit\b', 'ad-rogo'),
    (r'\badriserunt\b', 'ad-rogo'),
    (r'\badrisi\b', 'ad-rogo'),
    (r'\badrisione\b', 'arrisio'),
    (r'\badrisisse\b', 'ad-rogo'),
    (r'\badrisissent\b', 'ad-rogo'),
    (r'\badrisisset\b', 'ad-rogo'),
    (r'\badrisissetque\b', 'ad-rogo'),
    (r'\badrisit\b', 'ad-rogo'),
    (r'\badrisor\b', 'arrisor'),
    (r'\badrodat\b', 'ad-rogo'),
    (r'\badrodatur\b', 'ad-rogo'),
    (r'\badrodens\b', 'ad-rogo'),
    (r'\badrodere\b', 'ad-rogo'),
    (r'\badroderet\b', 'ad-rogo'),
    (r'\badrodit\b', 'ad-rogo'),
    (r'\badroga\b', 'ad-rogo'),
    (r'\badrogabat\b', 'ad-rogo'),
    (r'\badrogabo\b', 'ad-rogo'),
    (r'\badrogandi\b', 'ad-rogo'),
    (r'\badrogandis\b', 'ad-rogo'),
    (r'\badrogando\b', 'ad-rogo'),
    (r'\badrogandum\b', 'ad-rogo'),
    (r'\badrogans\b', 'ad-rogo'),
    (r'\badrogant\b', 'ad-rogo'),
    (r'\badrogantem\b', 'ad-rogo'),
    (r'\badroganter\b', 'arroganter'),
    (r'\badrogantes\b', 'ad-rogo'),
    (r'\badroganti\b', 'ad-rogo'),
    (r'\badrogantia\b', 'arrogantia'),
    (r'\badrogantiae\b', 'arrogantia'),
    (r'\badrogantiam\b', 'arrogantia'),
    (r'\badrogantibus\b', 'ad-rogo'),
    (r'\badrogantiorem\b', 'ad-rogo'),
    (r'\badrogantioris\b', 'ad-rogo'),
    (r'\badrogantis\b', 'ad-rogo'),
    (r'\badrogantissime\b', 'ad-rogo'),
    (r'\badrogantissimo\b', 'ad-rogo'),
    (r'\badrogantium\b', 'ad-rogo'),
    (r'\badrogantius\b', 'ad-rogo'),
    (r'\badrogantur\b', 'ad-rogo'),
    (r'\badrogare\b', 'ad-rogo'),
    (r'\badrogarem\b', 'ad-rogo'),
    (r'\badrogaret\b', 'ad-rogo'),
    (r'\badrogaretur\b', 'ad-rogo'),
    (r'\badrogari\b', 'ad-rogo'),
    (r'\badrogaris\b', 'ad-rogo'),
    (r'\badrogas\b', 'ad-rogo'),
    (r'\badrogat\b', 'ad-rogo'),
    (r'\badrogati\b', 'ad-rogo'),
    (r'\badrogatio\b', 'arrogatio'),
    (r'\badrogatione\b', 'arrogatio'),
    (r'\badrogationem\b', 'arrogatio'),
    (r'\badrogationes\b', 'arrogatio'),
    (r'\badrogationibus\b', 'arrogatio'),
    (r'\badrogato\b', 'ad-rogo'),
    (r'\badrogator\b', 'arrogator'),
    (r'\badrogatore\b', 'arrogator'),
    (r'\badrogatorem\b', 'arrogator'),
    (r'\badrogatori\b', 'arrogator'),
    (r'\badrogatoris\b', 'arrogator'),
    (r'\badrogatum\b', 'ad-rogo'),
    (r'\badrogatur\b', 'ad-rogo'),
    (r'\badrogatus\b', 'ad-rogo'),
    (r'\badrogauerit\b', 'ad-rogo'),
    (r'\badrogauero\b', 'ad-rogo'),
    (r'\badrogauerunt\b', 'ad-rogo'),
    (r'\badrogaui\b', 'ad-rogo'),
    (r'\badrogauit\b', 'ad-rogo'),
    (r'\badrogaverunt\b', 'ad-rogo'),
    (r'\badrogavit\b', 'ad-rogo'),
    (r'\badrogent\b', 'ad-rogo'),
    (r'\badroges\b', 'ad-rogo'),
    (r'\badroget\b', 'ad-rogo'),
    (r'\badrogetur\b', 'ad-rogo'),
    (r'\badrogo\b', 'ad-rogo'),
    (r'\badrosa\b', 'ad-rogo'),
    (r'\badrosere\b', 'ad-rogo'),
    (r'\badroserunt\b', 'ad-rogo'),
    (r'\badrosis\b', 'ad-rogo'),
    (r'\badrosit\b', 'ad-rogo'),
    (r'\badroso\b', 'ad-rogo'),
    (r'\badrosor\b', 'arrosor'),
    (r'\badrosos\b', 'ad-rogo'),
    (r'\badrosum\b', 'ad-rogo'),
    (r'\badruenda\b', 'adruo'),
    (r'\badrui\b', 'adruo'),
    (r'\bAdrumetina\b', 'Hadrumetum'),
    (r'\bAdrumetinus\b', 'Hadrumetum'),
    (r'\bAdrumeto\b', 'Hadrumetum'),
    (r'\badruptis\b', 'adruo'),
    (r'\badrutum\b', 'adruo'),
    (r'\badruunt\b', 'adruo'),
    (r'\badscire\b', 'ad-scribo'),
    (r'\badsciri\b', 'ad-scribo'),
    (r'\badscirique\b', 'ad-scribo'),
    (r'\badsciscam\b', 'ad-scribo'),
    (r'\badsciscantque\b', 'ad-scribo'),
    (r'\badsciscat\b', 'ad-scribo'),
    (r'\badsciscatur\b', 'ad-scribo'),
    (r'\badsciscebantur\b', 'ad-scribo'),
    (r'\badsciscenda\b', 'ad-scribo'),
    (r'\badsciscendae\b', 'ad-scribo'),
    (r'\badsciscendas\b', 'ad-scribo'),
    (r'\badsciscendis\b', 'ad-scribo'),
    (r'\badsciscendo\b', 'ad-scribo'),
    (r'\badsciscere\b', 'ad-scribo'),
    (r'\badsciscerent\b', 'ad-scribo'),
    (r'\badscisceret\b', 'ad-scribo'),
    (r'\badscisceretur\b', 'ad-scribo'),
    (r'\badsciscet\b', 'ad-scribo'),
    (r'\badscisci\b', 'ad-scribo'),
    (r'\badsciscis\b', 'ad-scribo'),
    (r'\badsciscit\b', 'ad-scribo'),
    (r'\badsciscitur\b', 'ad-scribo'),
    (r'\badscisco\b', 'ad-scribo'),
    (r'\badsciscor\b', 'ad-scribo'),
    (r'\badsciscunt\b', 'ad-scribo'),
    (r'\badscisti\b', 'ad-scribo'),
    (r'\badscita\b', 'ad-scribo'),
    (r'\badscitae\b', 'ad-scribo'),
    (r'\badscitaque\b', 'ad-scribo'),
    (r'\badscitas\b', 'ad-scribo'),
    (r'\badscite\b', 'ad-scribo'),
    (r'\badsciti\b', 'ad-scribo'),
    (r'\badscitis\b', 'ad-scribo'),
    (r'\badscito\b', 'ad-scribo'),
    (r'\badscitos\b', 'ad-scribo'),
    (r'\badscitum\b', 'ascitus2'),
    (r'\badscitur\b', 'ad-scribo'),
    (r'\badscituram\b', 'ad-scribo'),
    (r'\badsciturus\b', 'ad-scribo'),
    (r'\badscitus\b', 'ascitus2'),
    (r'\badsciueris\b', 'ad-scribo'),
    (r'\badsciuerit\b', 'ad-scribo'),
    (r'\badsciuerunt\b', 'ad-scribo'),
    (r'\badsciuimus\b', 'ad-scribo'),
    (r'\badsciuit\b', 'ad-scribo'),
    (r'\badsciverant\b', 'ad-scribo'),
    (r'\badsciverat\b', 'ad-scribo'),
    (r'\badscivere\b', 'ad-scribo'),
    (r'\badsciverint\b', 'ad-scribo'),
    (r'\badsciverit\b', 'ad-scribo'),
    (r'\badscivero\b', 'ad-scribo'),
    (r'\badsciverunt\b', 'ad-scribo'),
    (r'\badscivimus\b', 'ad-scribo'),
    (r'\badscivisse\b', 'ad-scribo'),
    (r'\badscivissent\b', 'ad-scribo'),
    (r'\badscivisset\b', 'ad-scribo'),
    (r'\badscivit\b', 'ad-scribo'),
    (r'\badscribam\b', 'ad-scribo'),
    (r'\badscribant\b', 'ad-scribo'),
    (r'\badscribantur\b', 'ad-scribo'),
    (r'\badscribat\b', 'ad-scribo'),
    (r'\badscribatis\b', 'ad-scribo'),
    (r'\badscribatur\b', 'ad-scribo'),
    (r'\badscribe\b', 'ad-scribo'),
    (r'\badscribebatur\b', 'ad-scribo'),
    (r'\badscribemus\b', 'ad-scribo'),
    (r'\badscribenda\b', 'ad-scribo'),
    (r'\badscribendam\b', 'ad-scribo'),
    (r'\badscribendas\b', 'ad-scribo'),
    (r'\badscribendos\b', 'ad-scribo'),
    (r'\badscribendum\b', 'ad-scribo'),
    (r'\badscribere\b', 'ad-scribo'),
    (r'\badscriberem\b', 'ad-scribo'),
    (r'\badscriberemus\b', 'ad-scribo'),
    (r'\badscriberent\b', 'ad-scribo'),
    (r'\badscriberentur\b', 'ad-scribo'),
    (r'\badscriberer\b', 'ad-scribo'),
    (r'\badscriberes\b', 'ad-scribo'),
    (r'\badscriberet\b', 'ad-scribo'),
    (r'\badscriberetur\b', 'ad-scribo'),
    (r'\badscribi\b', 'ad-scribo'),
    (r'\badscribier\b', 'ad-scribo'),
    (r'\badscribimur\b', 'ad-scribo'),
    (r'\badscribimus\b', 'ad-scribo'),
    (r'\badscribis\b', 'ad-scribo'),
    (r'\badscribit\b', 'ad-scribo'),
    (r'\badscribito\b', 'ad-scribo'),
    (r'\badscribitur\b', 'ad-scribo'),
    (r'\badscribo\b', 'ad-scribo'),
    (r'\badscribunt\b', 'ad-scribo'),
    (r'\badscribuntur\b', 'ad-scribo'),
    (r'\badscripseram\b', 'ad-scribo'),
    (r'\badscripserant\b', 'ad-scribo'),
    (r'\badscripseras\b', 'ad-scribo'),
    (r'\badscripserat\b', 'ad-scribo'),
    (r'\badscripserim\b', 'ad-scribo'),
    (r'\badscripserint\b', 'ad-scribo'),
    (r'\badscripserit\b', 'ad-scribo'),
    (r'\badscripsero\b', 'ad-scribo'),
    (r'\badscripserunt\b', 'ad-scribo'),
    (r'\badscripsi\b', 'ad-scribo'),
    (r'\badscripsimus\b', 'ad-scribo'),
    (r'\badscripsisse\b', 'ad-scribo'),
    (r'\badscripsissent\b', 'ad-scribo'),
    (r'\badscripsisses\b', 'ad-scribo'),
    (r'\badscripsisset\b', 'ad-scribo'),
    (r'\badscripsit\b', 'ad-scribo'),
    (r'\badscripta\b', 'ad-scribo'),
    (r'\badscriptae\b', 'ad-scribo'),
    (r'\badscriptam\b', 'ad-scribo'),
    (r'\badscriptas\b', 'ad-scribo'),
    (r'\badscripti\b', 'ad-scribo'),
    (r'\badscripticios\b', 'ascripticius'),
    (r'\badscripticium\b', 'ascripticius'),
    (r'\badscriptio\b', 'ascriptio'),
    (r'\badscriptione\b', 'ascriptio'),
    (r'\badscriptis\b', 'ad-scribo'),
    (r'\badscriptivis\b', 'ascriptivus'),
    (r'\badscripto\b', 'ad-scribo'),
    (r'\badscriptos\b', 'ad-scribo'),
    (r'\badscriptum\b', 'ad-scribo'),
    (r'\badscriptumque\b', 'ad-scribo'),
    (r'\badscriptus\b', 'ad-scribo'),
    (r'\badsectabantur\b', 'assector'),
    (r'\badsectabar\b', 'assector'),
    (r'\badsectabatur\b', 'assector'),
    (r'\badsectando\b', 'assector'),
    (r'\badsectante\b', 'assector'),
    (r'\badsectarentur\b', 'assector'),
    (r'\badsectaretur\b', 'assector'),
    (r'\badsectari\b', 'assector'),
    (r'\badsectati\b', 'assector'),
    (r'\badsectatione\b', 'assectatio'),
    (r'\badsectationem\b', 'assectatio'),
    (r'\badsectationis\b', 'assectatio'),
    (r'\badsectator\b', 'assectator'),
    (r'\badsectatores\b', 'assectator'),
    (r'\badsectatoribus\b', 'assectator'),
    (r'\badsectatoribusque\b', 'assectator'),
    (r'\badsectatoris\b', 'assectator'),
    (r'\badsectatorque\b', 'assectator'),
    (r'\badsectatorum\b', 'assectator'),
    (r'\badsectatorum\b', 'assector'),
    (r'\badsectatur\b', 'assector'),
    (r'\badsectatus\b', 'assector'),
    (r'\badsectatusue\b', 'assector'),
    (r'\badsectentur\b', 'assector'),
    (r'\badsecuta\b', 'ad-sono'),
    (r'\badsecuti\b', 'ad-sono'),
    (r'\badsecutis\b', 'ad-sono'),
    (r'\badsecuto\b', 'ad-sono'),
    (r'\badsecutos\b', 'ad-sono'),
    (r'\badsecutum\b', 'ad-sono'),
    (r'\badsecuturi\b', 'ad-sono'),
    (r'\badsecuturos\b', 'ad-sono'),
    (r'\badsecuturum\b', 'ad-sono'),
    (r'\badsecuturus\b', 'ad-sono'),
    (r'\badsecutus\b', 'ad-sono'),
    (r'\badsederit\b', 'ad-sono'),
    (r'\badsedero\b', 'ad-sono'),
    (r'\badsedi\b', 'ad-sono'),
    (r'\badsedimus\b', 'ad-sono'),
    (r'\badsedisse\b', 'ad-sono'),
    (r'\badsedissemus\b', 'ad-sono'),
    (r'\badsedissent\b', 'ad-sono'),
    (r'\badsedisset\b', 'ad-sono'),
    (r'\badsedisti\b', 'ad-sono'),
    (r'\badsedistis\b', 'ad-sono'),
    (r'\badsedit\b', 'ad-sono'),
    (r'\badsensa\b', 'ad-sono'),
    (r'\badsensere\b', 'ad-sono'),
    (r'\badsenserim\b', 'ad-sono'),
    (r'\badsenserint\b', 'ad-sono'),
    (r'\badsenserunt\b', 'ad-sono'),
    (r'\badsensi\b', 'ad-sono'),
    (r'\badsensibus\b', 'assensus2'),
    (r'\badsensio\b', 'assensio'),
    (r'\badsensione\b', 'assensio'),
    (r'\badsensionem\b', 'assensio'),
    (r'\badsensionemque\b', 'assensio'),
    (r'\badsensiones\b', 'assensio'),
    (r'\badsensionesque\b', 'assensio'),
    (r'\badsensioni\b', 'assensio'),
    (r'\badsensionibus\b', 'assensio'),
    (r'\badsensionis\b', 'assensio'),
    (r'\badsensionum\b', 'assensio'),
    (r'\badsensit\b', 'ad-sono'),
    (r'\badsensorem\b', 'assensor'),
    (r'\badsensores\b', 'assensor'),
    (r'\badsensu\b', 'assensus2'),
    (r'\badsensum\b', 'assensus2'),
    (r'\badsensuque\b', 'assensus2'),
    (r'\badsensuri\b', 'ad-sono'),
    (r'\badsensurum\b', 'ad-sono'),
    (r'\badsensurus\b', 'ad-sono'),
    (r'\badsensus\b', 'assensus2'),
    (r'\badsensusque\b', 'assensus2'),
    (r'\badsentabatur\b', 'assentor'),
    (r'\badsentabor\b', 'assentor'),
    (r'\badsentandi\b', 'assentor'),
    (r'\badsentando\b', 'assentor'),
    (r'\badsentandumst\b', 'assentor'),
    (r'\badsentantem\b', 'assentor'),
    (r'\badsentantium\b', 'assentor'),
    (r'\badsentantur\b', 'assentor'),
    (r'\badsentare\b', 'assentor'),
    (r'\badsentari\b', 'assentor'),
    (r'\badsentaris\b', 'assentor'),
    (r'\badsentati\b', 'assentor'),
    (r'\badsentatio\b', 'assentatio'),
    (r'\badsentatione\b', 'assentatio'),
    (r'\badsentationem\b', 'assentatio'),
    (r'\badsentationes\b', 'assentatio'),
    (r'\badsentationibus\b', 'assentatio'),
    (r'\badsentationis\b', 'assentatio'),
    (r'\badsentationum\b', 'assentatio'),
    (r'\badsentatiuncula\b', 'assentatiuncula'),
    (r'\badsentatiunculas\b', 'assentatiuncula'),
    (r'\badsentator\b', 'assentator'),
    (r'\badsentatorem\b', 'assentator'),
    (r'\badsentatores\b', 'assentator'),
    (r'\badsentatoribus\b', 'assentator'),
    (r'\badsentatorie\b', 'assentatorie'),
    (r'\badsentatoris\b', 'assentator'),
    (r'\badsentatorum\b', 'assentator'),
    (r'\badsentatorum\b', 'assentor'),
    (r'\badsentatrix\b', 'assentatrix'),
    (r'\badsentatur\b', 'assentor'),
    (r'\badsentatus\b', 'assentor'),
    (r'\badsentetur\b', 'assentor'),
    (r'\badsentiamini\b', 'ad-sono'),
    (r'\badsentiamur\b', 'ad-sono'),
    (r'\badsentiant\b', 'ad-sono'),
    (r'\badsentiantur\b', 'ad-sono'),
    (r'\badsentiar\b', 'ad-sono'),
    (r'\badsentiare\b', 'ad-sono'),
    (r'\badsentiaris\b', 'ad-sono'),
    (r'\badsentiatur\b', 'ad-sono'),
    (r'\badsentiebantur\b', 'ad-sono'),
    (r'\badsentiebar\b', 'ad-sono'),
    (r'\badsentiebare\b', 'ad-sono'),
    (r'\badsentiebatur\b', 'ad-sono'),
    (r'\badsentiemur\b', 'ad-sono'),
    (r'\badsentiendi\b', 'ad-sono'),
    (r'\badsentiendo\b', 'ad-sono'),
    (r'\badsentiendum\b', 'ad-sono'),
    (r'\badsentiens\b', 'ad-sono'),
    (r'\badsentiente\b', 'ad-sono'),
    (r'\badsentientem\b', 'ad-sono'),
    (r'\badsentientes\b', 'ad-sono'),
    (r'\badsentienti\b', 'ad-sono'),
    (r'\badsentientibus\b', 'ad-sono'),
    (r'\badsentientis\b', 'ad-sono'),
    (r'\badsentientium\b', 'ad-sono'),
    (r'\badsentietur\b', 'ad-sono'),
    (r'\badsentimur\b', 'ad-sono'),
    (r'\badsentio\b', 'ad-sono'),
    (r'\badsentior\b', 'ad-sono'),
    (r'\badsentire\b', 'ad-sono'),
    (r'\badsentiremini\b', 'ad-sono'),
    (r'\badsentirentur\b', 'ad-sono'),
    (r'\badsentirer\b', 'ad-sono'),
    (r'\badsentiretur\b', 'ad-sono'),
    (r'\badsentiri\b', 'ad-sono'),
    (r'\badsentiris\b', 'ad-sono'),
    (r'\badsentitur\b', 'ad-sono'),
    (r'\badsentiuntur\b', 'ad-sono'),
    (r'\badsentor\b', 'assentor'),
    (r'\badsequamur\b', 'assequor'),
    (r'\badsequantur\b', 'assequor'),
    (r'\badsequar\b', 'assequor'),
    (r'\badsequare\b', 'assequor'),
    (r'\badsequatur\b', 'assequor'),
    (r'\badsequebamur\b', 'assequor'),
    (r'\badsequebantur\b', 'assequor'),
    (r'\badsequebar\b', 'assequor'),
    (r'\badsequebatur\b', 'assequor'),
    (r'\badsequemini\b', 'assequor'),
    (r'\badsequemur\b', 'assequor'),
    (r'\badsequendis\b', 'assequor'),
    (r'\badsequentem\b', 'assequor'),
    (r'\badsequentium\b', 'assequor'),
    (r'\badsequentur\b', 'assequor'),
    (r'\badsequere\b', 'assequor'),
    (r'\badsequeremur\b', 'assequor'),
    (r'\badsequerentur\b', 'assequor'),
    (r'\badsequerere\b', 'assequor'),
    (r'\badsequeretur\b', 'assequor'),
    (r'\badsequeris\b', 'assequor'),
    (r'\badsequetur\b', 'assequor'),
    (r'\badsequi\b', 'assequor'),
    (r'\badsequimur\b', 'assequor'),
    (r'\badsequitur\b', 'assequor'),
    (r'\badsequor\b', 'assequor'),
    (r'\badsequuntur\b', 'assequor'),
    (r'\badseram\b', 'assero1'),
    (r'\badserant\b', 'assero1'),
    (r'\badserantur\b', 'assero1'),
    (r'\badseras\b', 'assero1'),
    (r'\badserat\b', 'assero1'),
    (r'\badseratur\b', 'assero1'),
    (r'\badsere\b', 'assero1'),
    (r'\badserebant\b', 'assero1'),
    (r'\badserebat\b', 'assero1'),
    (r'\badserebatur\b', 'assero1'),
    (r'\badserenda\b', 'assero1'),
    (r'\badserendi\b', 'assero1'),
    (r'\badserendo\b', 'assero1'),
    (r'\badserendum\b', 'assero1'),
    (r'\badserens\b', 'assero1'),
    (r'\badserente\b', 'assero1'),
    (r'\badserentem\b', 'assero1'),
    (r'\badserentes\b', 'assero1'),
    (r'\badserentibus\b', 'assero1'),
    (r'\badserere\b', 'assero1'),
    (r'\badsereres\b', 'assero1'),
    (r'\badsereret\b', 'assero1'),
    (r'\badseres\b', 'assero1'),
    (r'\badseret\b', 'assero1'),
    (r'\badserimur\b', 'assero1'),
    (r'\badserimus\b', 'assero1'),
    (r'\badseris\b', 'assero1'),
    (r'\badserit\b', 'assero1'),
    (r'\badseritis\b', 'assero1'),
    (r'\badserito\b', 'assero1'),
    (r'\badseritur\b', 'assero1'),
    (r'\badsero\b', 'assero1'),
    (r'\badserta\b', 'assertum'),
    (r'\badserta\b', 'assero2'),
    (r'\badsertae\b', 'assero2'),
    (r'\badsertam\b', 'assero2'),
    (r'\badsertio\b', 'assertio'),
    (r'\badsertione\b', 'assertio'),
    (r'\badsertionem\b', 'assertio'),
    (r'\badsertionibus\b', 'assertio'),
    (r'\badsertique\b', 'assertum'),
    (r'\badsertique\b', 'assero2'),
    (r'\badserto\b', 'assertum'),
    (r'\badserto\b', 'assero2'),
    (r'\badsertor\b', 'assertor'),
    (r'\badsertorem\b', 'assertor'),
    (r'\badsertores\b', 'assertor'),
    (r'\badsertoresque\b', 'assertor'),
    (r'\badsertorque\b', 'assertor'),
    (r'\badseruabam\b', 'ad-sono'),
    (r'\badseruabant\b', 'ad-sono'),
    (r'\badseruabantur\b', 'ad-sono'),
    (r'\badseruandos\b', 'ad-sono'),
    (r'\badseruans\b', 'ad-sono'),
    (r'\badseruantur\b', 'ad-sono'),
    (r'\badseruare\b', 'ad-sono'),
    (r'\badseruarent\b', 'ad-sono'),
    (r'\badseruari\b', 'ad-sono'),
    (r'\badseruat\b', 'ad-sono'),
    (r'\badseruatis\b', 'ad-sono'),
    (r'\badseruato\b', 'ad-sono'),
    (r'\badseruatur\b', 'ad-sono'),
    (r'\badseruauit\b', 'ad-sono'),
    (r'\badseruem\b', 'ad-sono'),
    (r'\badserui\b', 'assero2'),
    (r'\badseruisse\b', 'assero2'),
    (r'\badseruit\b', 'assero2'),
    (r'\badserunt\b', 'assero1'),
    (r'\badseruntque\b', 'assero1'),
    (r'\badseruntur\b', 'assero1'),
    (r'\badserva\b', 'ad-sono'),
    (r'\badservabam\b', 'ad-sono'),
    (r'\badservabant\b', 'ad-sono'),
    (r'\badservabantur\b', 'ad-sono'),
    (r'\badservabimur\b', 'ad-sono'),
    (r'\badservabis\b', 'ad-sono'),
    (r'\badservabitur\b', 'ad-sono'),
    (r'\badservanda\b', 'ad-sono'),
    (r'\badservandis\b', 'ad-sono'),
    (r'\badservandos\b', 'ad-sono'),
    (r'\badservandum\b', 'ad-sono'),
    (r'\badservandus\b', 'ad-sono'),
    (r'\badservant\b', 'ad-sono'),
    (r'\badservantem\b', 'ad-sono'),
    (r'\badservantes\b', 'ad-sono'),
    (r'\badservantur\b', 'ad-sono'),
    (r'\badservare\b', 'ad-sono'),
    (r'\badservarem\b', 'ad-sono'),
    (r'\badservarentque\b', 'ad-sono'),
    (r'\badservaret\b', 'ad-sono'),
    (r'\badservaretur\b', 'ad-sono'),
    (r'\badservari\b', 'ad-sono'),
    (r'\badservasses\b', 'ad-sono'),
    (r'\badservat\b', 'ad-sono'),
    (r'\badservata\b', 'ad-sono'),
    (r'\badservatae\b', 'ad-sono'),
    (r'\badservatam\b', 'ad-sono'),
    (r'\badservate\b', 'ad-sono'),
    (r'\badservati\b', 'ad-sono'),
    (r'\badservatis\b', 'ad-sono'),
    (r'\badservato\b', 'ad-sono'),
    (r'\badservatoque\b', 'ad-sono'),
    (r'\badservatos\b', 'ad-sono'),
    (r'\badservatum\b', 'ad-sono'),
    (r'\badservatur\b', 'ad-sono'),
    (r'\badservatus\b', 'ad-sono'),
    (r'\badservavit\b', 'ad-sono'),
    (r'\badservent\b', 'ad-sono'),
    (r'\badserventur\b', 'ad-sono'),
    (r'\badservet\b', 'ad-sono'),
    (r'\badservetur\b', 'ad-sono'),
    (r'\badserviunt\b', 'ad-sono'),
    (r'\badservor\b', 'ad-sono'),
    (r'\badsessio\b', 'assessio'),
    (r'\badsessorem\b', 'assessor'),
    (r'\badsessori\b', 'assessor'),
    (r'\badsessori\b', 'assessorius'),
    (r'\badsessoribus\b', 'assessor'),
    (r'\badsessorio\b', 'assessorius'),
    (r'\badsessoriorum\b', 'assessorius'),
    (r'\badsessoris\b', 'assessor'),
    (r'\badsessorum\b', 'assessor'),
    (r'\badsessos\b', 'ad-sono'),
    (r'\badsessurae\b', 'assessura'),
    (r'\badsestricem\b', 'assestrix'),
    (r'\badseuera\b', 'assevero'),
    (r'\badseuerabat\b', 'assevero'),
    (r'\badseueramus\b', 'assero1'),
    (r'\badseueramus\b', 'assevero'),
    (r'\badseueranda\b', 'assevero'),
    (r'\badseuerans\b', 'assevero'),
    (r'\badseuerant\b', 'assero1'),
    (r'\badseuerant\b', 'assevero'),
    (r'\badseuerantem\b', 'assevero'),
    (r'\badseueranti\b', 'assevero'),
    (r'\badseuerantis\b', 'assevero'),
    (r'\badseuerantium\b', 'assevero'),
    (r'\badseuerare\b', 'assevero'),
    (r'\badseueraret\b', 'assevero'),
    (r'\badseuerat\b', 'assero1'),
    (r'\badseuerat\b', 'assevero'),
    (r'\badseuerate\b', 'assevero'),
    (r'\badseueratio\b', 'asseveratio'),
    (r'\badseueratione\b', 'asseveratio'),
    (r'\badseuerationem\b', 'asseveratio'),
    (r'\badseuerem\b', 'assevero'),
    (r'\badseuerent\b', 'assevero'),
    (r'\badseverabant\b', 'assevero'),
    (r'\badseverabat\b', 'assevero'),
    (r'\badseverabatque\b', 'assevero'),
    (r'\badseveramus\b', 'assero1'),
    (r'\badseveramus\b', 'assevero'),
    (r'\badseverans\b', 'assevero'),
    (r'\badseverant\b', 'assero1'),
    (r'\badseverant\b', 'assevero'),
    (r'\badseverante\b', 'assevero'),
    (r'\badseverantis\b', 'assevero'),
    (r'\badseverantium\b', 'assevero'),
    (r'\badseverantius\b', 'assevero'),
    (r'\badseverare\b', 'assevero'),
    (r'\badseverat\b', 'assero1'),
    (r'\badseverat\b', 'assevero'),
    (r'\badseveratio\b', 'asseveratio'),
    (r'\badseveratione\b', 'asseveratio'),
    (r'\badseveratur\b', 'assevero'),
    (r'\badseverent\b', 'assevero'),
    (r'\badseveret\b', 'assevero'),
    (r'\badsibilat\b', 'ad-sono'),
    (r'\badsicca\b', 'ad-sono'),
    (r'\badsiccanda\b', 'ad-sono'),
    (r'\badsiccandae\b', 'ad-sono'),
    (r'\badsiccant\b', 'ad-sono'),
    (r'\badsiccari\b', 'ad-sono'),
    (r'\badsiccata\b', 'ad-sono'),
    (r'\badsiccatam\b', 'ad-sono'),
    (r'\badsiccato\b', 'ad-sono'),
    (r'\badsiccatos\b', 'ad-sono'),
    (r'\badsiccentur\b', 'ad-sono'),
    (r'\badsiccescant\b', 'ad-sono'),
    (r'\badsiccetur\b', 'ad-sono'),
    (r'\badsidam\b', 'assideo'),
    (r'\badsidamus\b', 'assideo'),
    (r'\badsidant\b', 'assideo'),
    (r'\badsidat\b', 'assideo'),
    (r'\badside\b', 'assideo'),
    (r'\badsideamus\b', 'assideo'),
    (r'\badsideant\b', 'assideo'),
    (r'\badsideas\b', 'assideo'),
    (r'\badsideat\b', 'assideo'),
    (r'\badsidebant\b', 'assideo'),
    (r'\badsidebat\b', 'assideo'),
    (r'\badsidebit\b', 'assideo'),
    (r'\badsidebo\b', 'assideo'),
    (r'\badsidendo\b', 'assideo'),
    (r'\badsidens\b', 'assideo'),
    (r'\badsident\b', 'assideo'),
    (r'\badsidente\b', 'assideo'),
    (r'\badsidentem\b', 'assideo'),
    (r'\badsidentemque\b', 'assideo'),
    (r'\badsidentes\b', 'assideo'),
    (r'\badsidenti\b', 'assideo'),
    (r'\badsidentibus\b', 'assideo'),
    (r'\badsidentium\b', 'assideo'),
    (r'\badsideoque\b', 'assideo'),
    (r'\badsidere\b', 'assideo'),
    (r'\badsideres\b', 'assideo'),
    (r'\badsideret\b', 'assideo'),
    (r'\badsides\b', 'assideo'),
    (r'\badsidet\b', 'assideo'),
    (r'\badsidit\b', 'assideo'),
    (r'\badsidite\b', 'assideo'),
    (r'\badsido\b', 'assideo'),
    (r'\badsidua\b', 'assiduus2'),
    (r'\badsiduae\b', 'assiduus2'),
    (r'\badsiduam\b', 'assiduus2'),
    (r'\badsiduamque\b', 'assiduus2'),
    (r'\badsiduaque\b', 'assiduus2'),
    (r'\badsiduas\b', 'assiduus2'),
    (r'\badsidue\b', 'assiduus2'),
    (r'\badsidue\b', 'assiduus1'),
    (r'\badsidueque\b', 'assiduus2'),
    (r'\badsidueque\b', 'assiduus1'),
    (r'\badsidui\b', 'assiduus1'),
    (r'\badsidui\b', 'assiduus2'),
    (r'\badsiduiores\b', 'assiduus2'),
    (r'\badsiduis\b', 'assiduus1'),
    (r'\badsiduis\b', 'assiduus2'),
    (r'\badsiduisque\b', 'assiduus1'),
    (r'\badsiduisque\b', 'assiduus2'),
    (r'\badsiduissime\b', 'assiduus2'),
    (r'\badsiduitas\b', 'assiduitas'),
    (r'\badsiduitate\b', 'assiduitas'),
    (r'\badsiduitatem\b', 'assiduitas'),
    (r'\badsiduitatis\b', 'assiduitas'),
    (r'\badsidunt\b', 'assideo'),
    (r'\badsiduo\b', 'assiduo'),
    (r'\badsiduo\b', 'assiduus1'),
    (r'\badsiduo\b', 'assiduus2'),
    (r'\badsiduoque\b', 'assiduo'),
    (r'\badsiduoque\b', 'assiduus1'),
    (r'\badsiduoque\b', 'assiduus2'),
    (r'\badsiduos\b', 'assiduus1'),
    (r'\badsiduum\b', 'assiduus1'),
    (r'\badsiduum\b', 'assiduus2'),
    (r'\badsiduus\b', 'assiduus1'),
    (r'\badsiduusque\b', 'assiduus1'),
    (r'\badsient\b', 'adsum'),
    (r'\badsiet\b', 'adsum'),
    (r'\badsigna\b', 'ad-sono'),
    (r'\badsignabant\b', 'ad-sono'),
    (r'\badsignabantur\b', 'ad-sono'),
    (r'\badsignabat\b', 'ad-sono'),
    (r'\badsignabatur\b', 'ad-sono'),
    (r'\badsignabimus\b', 'ad-sono'),
    (r'\badsignabis\b', 'ad-sono'),
    (r'\badsignabit\b', 'ad-sono'),
    (r'\badsignabunt\b', 'ad-sono'),
    (r'\badsignabuntur\b', 'ad-sono'),
    (r'\badsignanda\b', 'ad-sono'),
    (r'\badsignandis\b', 'ad-sono'),
    (r'\badsignandisve\b', 'ad-sono'),
    (r'\badsignando\b', 'ad-sono'),
    (r'\badsignandum\b', 'ad-sono'),
    (r'\badsignans\b', 'ad-sono'),
    (r'\badsignant\b', 'ad-sono'),
    (r'\badsignante\b', 'ad-sono'),
    (r'\badsignantes\b', 'ad-sono'),
    (r'\badsignantur\b', 'ad-sono'),
    (r'\badsignare\b', 'ad-sono'),
    (r'\badsignarent\b', 'ad-sono'),
    (r'\badsignarentur\b', 'ad-sono'),
    (r'\badsignaret\b', 'ad-sono'),
    (r'\badsignaretur\b', 'ad-sono'),
    (r'\badsignari\b', 'ad-sono'),
    (r'\badsignarit\b', 'ad-sono'),
    (r'\badsignarunt\b', 'ad-sono'),
    (r'\badsignas\b', 'ad-sono'),
    (r'\badsignasse\b', 'ad-sono'),
    (r'\badsignassem\b', 'ad-sono'),
    (r'\badsignasset\b', 'ad-sono'),
    (r'\badsignasti\b', 'ad-sono'),
    (r'\badsignat\b', 'ad-sono'),
    (r'\badsignata\b', 'ad-sono'),
    (r'\badsignatae\b', 'ad-sono'),
    (r'\badsignatam\b', 'ad-sono'),
    (r'\badsignatas\b', 'ad-sono'),
    (r'\badsignati\b', 'ad-sono'),
    (r'\badsignatio\b', 'assignatio'),
    (r'\badsignatione\b', 'assignatio'),
    (r'\badsignationem\b', 'assignatio'),
    (r'\badsignationes\b', 'assignatio'),
    (r'\badsignationi\b', 'assignatio'),
    (r'\badsignationibus\b', 'assignatio'),
    (r'\badsignationis\b', 'assignatio'),
    (r'\badsignationum\b', 'assignatio'),
    (r'\badsignatis\b', 'ad-sono'),
    (r'\badsignato\b', 'ad-sono'),
    (r'\badsignatoris\b', 'assignator'),
    (r'\badsignatorum\b', 'assignator'),
    (r'\badsignatos\b', 'ad-sono'),
    (r'\badsignatum\b', 'ad-sono'),
    (r'\badsignatumque\b', 'ad-sono'),
    (r'\badsignatumue\b', 'ad-sono'),
    (r'\badsignatur\b', 'ad-sono'),
    (r'\badsignatura\b', 'ad-sono'),
    (r'\badsignaturi\b', 'ad-sono'),
    (r'\badsignaturos\b', 'ad-sono'),
    (r'\badsignaturque\b', 'ad-sono'),
    (r'\badsignaturum\b', 'ad-sono'),
    (r'\badsignaturus\b', 'ad-sono'),
    (r'\badsignatus\b', 'ad-sono'),
    (r'\badsignauerat\b', 'ad-sono'),
    (r'\badsignauerint\b', 'ad-sono'),
    (r'\badsignauerit\b', 'ad-sono'),
    (r'\badsignauerunt\b', 'ad-sono'),
    (r'\badsignauisset\b', 'ad-sono'),
    (r'\badsignauit\b', 'ad-sono'),
    (r'\badsignaverat\b', 'ad-sono'),
    (r'\badsignavere\b', 'ad-sono'),
    (r'\badsignaverim\b', 'ad-sono'),
    (r'\badsignaverit\b', 'ad-sono'),
    (r'\badsignavero\b', 'ad-sono'),
    (r'\badsignavit\b', 'ad-sono'),
    (r'\badsignem\b', 'ad-sono'),
    (r'\badsignemus\b', 'ad-sono'),
    (r'\badsignent\b', 'ad-sono'),
    (r'\badsignentur\b', 'ad-sono'),
    (r'\badsignes\b', 'ad-sono'),
    (r'\badsignet\b', 'ad-sono'),
    (r'\badsignetis\b', 'ad-sono'),
    (r'\badsignetur\b', 'ad-sono'),
    (r'\badsignificant\b', 'ad-sono'),
    (r'\badsignificantem\b', 'ad-sono'),
    (r'\badsignificare\b', 'ad-sono'),
    (r'\badsignificaret\b', 'ad-sono'),
    (r'\badsignificat\b', 'ad-sono'),
    (r'\badsigno\b', 'ad-sono'),
    (r'\badsignor\b', 'ad-sono'),
    (r'\badsiluere\b', 'ad-sono'),
    (r'\badsilui\b', 'ad-sono'),
    (r'\badsiluit\b', 'ad-sono'),
    (r'\badsim\b', 'adsum'),
    (r'\badsimiliter\b', 'assimiliter'),
    (r'\badsimula\b', 'ad-sono'),
    (r'\badsimulabat\b', 'ad-sono'),
    (r'\badsimulabatque\b', 'ad-sono'),
    (r'\badsimulabimus\b', 'ad-sono'),
    (r'\badsimulabit\b', 'ad-sono'),
    (r'\badsimulabitur\b', 'ad-sono'),
    (r'\badsimulabo\b', 'ad-sono'),
    (r'\badsimulamus\b', 'ad-sono'),
    (r'\badsimulandae\b', 'ad-sono'),
    (r'\badsimulans\b', 'ad-sono'),
    (r'\badsimulant\b', 'ad-sono'),
    (r'\badsimulantem\b', 'ad-sono'),
    (r'\badsimulanter\b', 'assimulanter'),
    (r'\badsimularam\b', 'ad-sono'),
    (r'\badsimulare\b', 'ad-sono'),
    (r'\badsimularet\b', 'ad-sono'),
    (r'\badsimularetur\b', 'ad-sono'),
    (r'\badsimularier\b', 'ad-sono'),
    (r'\badsimulas\b', 'ad-sono'),
    (r'\badsimulat\b', 'ad-sono'),
    (r'\badsimulata\b', 'ad-sono'),
    (r'\badsimulatae\b', 'ad-sono'),
    (r'\badsimulati\b', 'ad-sono'),
    (r'\badsimulatis\b', 'ad-sono'),
    (r'\badsimulato\b', 'ad-sono'),
    (r'\badsimulatos\b', 'ad-sono'),
    (r'\badsimulatote\b', 'ad-sono'),
    (r'\badsimulatum\b', 'ad-sono'),
    (r'\badsimulatur\b', 'ad-sono'),
    (r'\badsimulatus\b', 'ad-sono'),
    (r'\badsimulavere\b', 'ad-sono'),
    (r'\badsimulaverit\b', 'ad-sono'),
    (r'\badsimulavi\b', 'ad-sono'),
    (r'\badsimulavit\b', 'ad-sono'),
    (r'\badsimulem\b', 'ad-sono'),
    (r'\badsimulentur\b', 'ad-sono'),
    (r'\badsimules\b', 'ad-sono'),
    (r'\badsimulet\b', 'ad-sono'),
    (r'\badsimuletque\b', 'ad-sono'),
    (r'\badsimulo\b', 'ad-sono'),
    (r'\badsimus\b', 'adsum'),
    (r'\badsint\b', 'adsum'),
    (r'\badsintque\b', 'adsum'),
    (r'\badsis\b', 'adsum'),
    (r'\badsistam\b', 'assisto'),
    (r'\badsistant\b', 'assisto'),
    (r'\badsistas\b', 'assisto'),
    (r'\badsistat\b', 'assisto'),
    (r'\badsistatis\b', 'assisto'),
    (r'\badsiste\b', 'assisto'),
    (r'\badsistebam\b', 'assisto'),
    (r'\badsistebant\b', 'assisto'),
    (r'\badsistebat\b', 'assisto'),
    (r'\badsistendi\b', 'assisto'),
    (r'\badsistendique\b', 'assisto'),
    (r'\badsistendum\b', 'assisto'),
    (r'\badsistens\b', 'assisto'),
    (r'\badsistente\b', 'assisto'),
    (r'\badsistentem\b', 'assisto'),
    (r'\badsistentes\b', 'assisto'),
    (r'\badsistenti\b', 'assisto'),
    (r'\badsistentibus\b', 'assisto'),
    (r'\badsistentis\b', 'assisto'),
    (r'\badsistentium\b', 'assisto'),
    (r'\badsistere\b', 'assisto'),
    (r'\badsisterent\b', 'assisto'),
    (r'\badsisteret\b', 'assisto'),
    (r'\badsistet\b', 'assisto'),
    (r'\badsistis\b', 'assisto'),
    (r'\badsistit\b', 'assisto'),
    (r'\badsistite\b', 'assisto'),
    (r'\badsistitis\b', 'assisto'),
    (r'\badsistitque\b', 'assisto'),
    (r'\badsisto\b', 'assisto'),
    (r'\badsistunt\b', 'assisto'),
    (r'\badsit\b', 'adsum'),
    (r'\badsita\b', 'assitus1'),
    (r'\badsitis\b', 'assitus1'),
    (r'\badsitis\b', 'adsum'),
    (r'\badsitne\b', 'adsum'),
    (r'\badsocias\b', 'associus'),
    (r'\badsociat\b', 'ad-sono'),
    (r'\badsociati\b', 'ad-sono'),
    (r'\badsolati\b', 'ad-sono'),
    (r'\badsolent\b', 'assoleo'),
    (r'\badsoleret\b', 'assoleo'),
    (r'\badsolet\b', 'assoleo'),
    (r'\badsonarent\b', 'ad-sono'),
    (r'\badsonat\b', 'ad-sono'),
    (r'\badsonet\b', 'ad-sono'),
    (r'\badspargatur\b', 'ad-spuo'),
    (r'\badspargis\b', 'ad-spuo'),
    (r'\badsparsa\b', 'ad-spuo'),
    (r'\badspecta\b', 'ad-spuo'),
    (r'\badspecta\b', 'ad-spuo'),
    (r'\badspectas\b', 'ad-spuo'),
    (r'\badspectas\b', 'ad-spuo'),
    (r'\badspectu\b', 'aspectus2'),
    (r'\badspectum\b', 'aspectus2'),
    (r'\badspectus\b', 'aspectus2'),
    (r'\badspersu\b', 'aspersus2'),
    (r'\badspersum\b', 'aspersus2'),
    (r'\badspersus\b', 'aspersus2'),
    (r'\badspexere\b', 'ad-spuo'),
    (r'\badspexerint\b', 'ad-spuo'),
    (r'\badspexeris\b', 'ad-spuo'),
    (r'\badspexerit\b', 'ad-spuo'),
    (r'\badspexi\b', 'ad-spuo'),
    (r'\badspeximus\b', 'ad-spuo'),
    (r'\badspexisse\b', 'ad-spuo'),
    (r'\badspexisset\b', 'ad-spuo'),
    (r'\badspexisti\b', 'ad-spuo'),
    (r'\badspexit\b', 'ad-spuo'),
    (r'\badspice\b', 'ad-spuo'),
    (r'\badspicere\b', 'ad-spuo'),
    (r'\badspicere\b', 'ad-spuo'),
    (r'\badspicerem\b', 'ad-spuo'),
    (r'\badspicerent\b', 'ad-spuo'),
    (r'\badspiceres\b', 'ad-spuo'),
    (r'\badspiceret\b', 'ad-spuo'),
    (r'\badspici\b', 'ad-spuo'),
    (r'\badspiciam\b', 'ad-spuo'),
    (r'\badspiciamque\b', 'ad-spuo'),
    (r'\badspicias\b', 'ad-spuo'),
    (r'\badspiciat\b', 'ad-spuo'),
    (r'\badspicienda\b', 'ad-spuo'),
    (r'\badspiciendis\b', 'ad-spuo'),
    (r'\badspiciens\b', 'ad-spuo'),
    (r'\badspicies\b', 'ad-spuo'),
    (r'\badspicio\b', 'ad-spuo'),
    (r'\badspicis\b', 'ad-spuo'),
    (r'\badspicit\b', 'ad-spuo'),
    (r'\badspicite\b', 'ad-spuo'),
    (r'\badspiciunt\b', 'ad-spuo'),
    (r'\badspiciuntur\b', 'ad-spuo'),
    (r'\badspirabat\b', 'ad-spuo'),
    (r'\badspirabit\b', 'ad-spuo'),
    (r'\badspiramina\b', 'aspiramen'),
    (r'\badspirant\b', 'ad-spuo'),
    (r'\badspirante\b', 'ad-spuo'),
    (r'\badspirantes\b', 'ad-spuo'),
    (r'\badspiraque\b', 'ad-spuo'),
    (r'\badspirare\b', 'ad-spuo'),
    (r'\badspirarent\b', 'ad-spuo'),
    (r'\badspiras\b', 'ad-spuo'),
    (r'\badspirassent\b', 'ad-spuo'),
    (r'\badspirasset\b', 'ad-spuo'),
    (r'\badspirat\b', 'ad-spuo'),
    (r'\badspirate\b', 'ad-spuo'),
    (r'\badspiratio\b', 'aspiratio'),
    (r'\badspiratione\b', 'aspiratio'),
    (r'\badspirationem\b', 'aspiratio'),
    (r'\badspirationis\b', 'aspiratio'),
    (r'\badspirauerit\b', 'ad-spuo'),
    (r'\badspirauit\b', 'ad-spuo'),
    (r'\badspiravit\b', 'ad-spuo'),
    (r'\badspirent\b', 'ad-spuo'),
    (r'\badspires\b', 'ad-spuo'),
    (r'\badspiret\b', 'ad-spuo'),
    (r'\badspui\b', 'ad-spuo'),
    (r'\badsta\b', 'asto'),
    (r'\badstabam\b', 'asto'),
    (r'\badstabant\b', 'asto'),
    (r'\badstabat\b', 'asto'),
    (r'\badstabit\b', 'asto'),
    (r'\badstabo\b', 'asto'),
    (r'\badstamus\b', 'asto'),
    (r'\badstans\b', 'asto'),
    (r'\badstant\b', 'asto'),
    (r'\badstante\b', 'asto'),
    (r'\badstantem\b', 'asto'),
    (r'\badstantes\b', 'asto'),
    (r'\badstanti\b', 'asto'),
    (r'\badstantibus\b', 'asto'),
    (r'\badstantium\b', 'asto'),
    (r'\badstare\b', 'asto'),
    (r'\badstaret\b', 'asto'),
    (r'\badstas\b', 'asto'),
    (r'\badstat\b', 'asto'),
    (r'\badstem\b', 'asto'),
    (r'\badsternunturque\b', 'adstipulo'),
    (r'\badstes\b', 'asto'),
    (r'\badstetit\b', 'asto'),
    (r'\badstipulando\b', 'adstipulo'),
    (r'\badstipularetur\b', 'adstipulo'),
    (r'\badstipulari\b', 'adstipulo'),
    (r'\badstipularique\b', 'adstipulo'),
    (r'\badstipulatio\b', 'astipulatio'),
    (r'\badstipulatione\b', 'astipulatio'),
    (r'\badstipulator\b', 'astipulator'),
    (r'\badstipulatore\b', 'astipulator'),
    (r'\badstipulatorem\b', 'astipulator'),
    (r'\badstipulatoris\b', 'astipulator'),
    (r'\badstipulatu\b', 'astipulatus'),
    (r'\badstipulatu\b', 'adstipulo'),
    (r'\badstipulatur\b', 'adstipulo'),
    (r'\badstipulatus\b', 'astipulatus'),
    (r'\badstipulatus\b', 'adstipulo'),
    (r'\badstiterant\b', 'assisto'),
    (r'\badstiterat\b', 'assisto'),
    (r'\badstitere\b', 'assisto'),
    (r'\badstiteris\b', 'assisto'),
    (r'\badstiterit\b', 'assisto'),
    (r'\badstiterunt\b', 'assisto'),
    (r'\badstiti\b', 'assisto'),
    (r'\badstiti\b', 'asto'),
    (r'\badstitisse\b', 'assisto'),
    (r'\badstitissem\b', 'assisto'),
    (r'\badstitisset\b', 'assisto'),
    (r'\badstitit\b', 'assisto'),
    (r'\badstititque\b', 'assisto'),
    (r'\badstituemus\b', 'adstipulo'),
    (r'\badstituerat\b', 'adstipulo'),
    (r'\badstituor\b', 'adstipulo'),
    (r'\badstiturum\b', 'asto'),
    (r'\badsto\b', 'asto'),
    (r'\badstrata\b', 'adstipulo'),
    (r'\badstrepebant\b', 'astrepo'),
    (r'\badstrepebat\b', 'astrepo'),
    (r'\badstrepere\b', 'astrepo'),
    (r'\badstreperent\b', 'astrepo'),
    (r'\badstrepunt\b', 'astrepo'),
    (r'\badstricta\b', 'adstipulo'),
    (r'\badstrictae\b', 'adstipulo'),
    (r'\badstrictam\b', 'adstipulo'),
    (r'\badstrictas\b', 'adstipulo'),
    (r'\badstricti\b', 'adstipulo'),
    (r'\badstrictione\b', 'astrictio'),
    (r'\badstrictior\b', 'adstipulo'),
    (r'\badstrictis\b', 'adstipulo'),
    (r'\badstrictius\b', 'adstipulo'),
    (r'\badstrictiusque\b', 'adstipulo'),
    (r'\badstricto\b', 'adstipulo'),
    (r'\badstrictoriam\b', 'astrictorius'),
    (r'\badstrictos\b', 'adstipulo'),
    (r'\badstrictosque\b', 'adstipulo'),
    (r'\badstrictum\b', 'adstipulo'),
    (r'\badstrictumque\b', 'adstipulo'),
    (r'\badstrictus\b', 'adstipulo'),
    (r'\badstringam\b', 'adstipulo'),
    (r'\badstringant\b', 'adstipulo'),
    (r'\badstringantur\b', 'adstipulo'),
    (r'\badstringas\b', 'adstipulo'),
    (r'\badstringat\b', 'adstipulo'),
    (r'\badstringatur\b', 'adstipulo'),
    (r'\badstringe\b', 'adstipulo'),
    (r'\badstringebant\b', 'adstipulo'),
    (r'\badstringebat\b', 'adstipulo'),
    (r'\badstringenda\b', 'adstipulo'),
    (r'\badstringendae\b', 'adstipulo'),
    (r'\badstringendi\b', 'adstipulo'),
    (r'\badstringendisque\b', 'adstipulo'),
    (r'\badstringendo\b', 'adstipulo'),
    (r'\badstringendum\b', 'adstipulo'),
    (r'\badstringens\b', 'adstipulo'),
    (r'\badstringente\b', 'adstipulo'),
    (r'\badstringentibus\b', 'adstipulo'),
    (r'\badstringere\b', 'adstipulo'),
    (r'\badstringerent\b', 'adstipulo'),
    (r'\badstringerentur\b', 'adstipulo'),
    (r'\badstringerer\b', 'adstipulo'),
    (r'\badstringeret\b', 'adstipulo'),
    (r'\badstringes\b', 'adstipulo'),
    (r'\badstringet\b', 'adstipulo'),
    (r'\badstringetur\b', 'adstipulo'),
    (r'\badstringi\b', 'adstipulo'),
    (r'\badstringis\b', 'adstipulo'),
    (r'\badstringit\b', 'adstipulo'),
    (r'\badstringite\b', 'adstipulo'),
    (r'\badstringito\b', 'adstipulo'),
    (r'\badstringitque\b', 'adstipulo'),
    (r'\badstringitur\b', 'adstipulo'),
    (r'\badstringo\b', 'adstipulo'),
    (r'\badstringor\b', 'adstipulo'),
    (r'\badstringunt\b', 'adstipulo'),
    (r'\badstringuntur\b', 'adstipulo'),
    (r'\badstrinxerat\b', 'adstipulo'),
    (r'\badstrinxere\b', 'adstipulo'),
    (r'\badstrinxerint\b', 'adstipulo'),
    (r'\badstrinxeris\b', 'adstipulo'),
    (r'\badstrinxerit\b', 'adstipulo'),
    (r'\badstrinxero\b', 'adstipulo'),
    (r'\badstrinxerunt\b', 'adstipulo'),
    (r'\badstrinxi\b', 'adstipulo'),
    (r'\badstrinxissent\b', 'adstipulo'),
    (r'\badstrinxit\b', 'adstipulo'),
    (r'\badstruas\b', 'astruo'),
    (r'\badstruat\b', 'astruo'),
    (r'\badstruatur\b', 'astruo'),
    (r'\badstructis\b', 'adstipulo'),
    (r'\badstrue\b', 'astruo'),
    (r'\badstruendi\b', 'astruo'),
    (r'\badstruentur\b', 'astruo'),
    (r'\badstruere\b', 'astruo'),
    (r'\badstruerent\b', 'astruo'),
    (r'\badstrui\b', 'astruo'),
    (r'\badstruis\b', 'astruo'),
    (r'\badstruit\b', 'astruo'),
    (r'\badstruitur\b', 'astruo'),
    (r'\badstruxerat\b', 'astruo'),
    (r'\badstruxeris\b', 'astruo'),
    (r'\badstruxerunt\b', 'astruo'),
    (r'\badstruximus\b', 'astruo'),
    (r'\badstruxit\b', 'astruo'),
    (r'\badstupes\b', 'astupeo'),
    (r'\badstupet\b', 'astupeo'),
    (r'\badsuctis\b', 'adsum'),
    (r'\badsuefacere\b', 'assuefacio'),
    (r'\badsuefaceret\b', 'assuefacio'),
    (r'\badsuefaciant\b', 'assuefacio'),
    (r'\badsuefaciebant\b', 'assuefacio'),
    (r'\badsuefaciens\b', 'assuefacio'),
    (r'\badsuefacite\b', 'assuefacio'),
    (r'\badsuefaciunt\b', 'assuefacio'),
    (r'\badsuefeceram\b', 'assuefacio'),
    (r'\badsuefecerat\b', 'assuefacio'),
    (r'\badsuefecerunt\b', 'assuefacio'),
    (r'\badsuefecit\b', 'assuefacio'),
    (r'\badsuenda\b', 'adsum'),
    (r'\badsueram\b', 'ad-suspiro'),
    (r'\badsuerant\b', 'ad-suspiro'),
    (r'\badsueras\b', 'ad-suspiro'),
    (r'\badsuerat\b', 'ad-suspiro'),
    (r'\badsuerint\b', 'ad-suspiro'),
    (r'\badsuerit\b', 'ad-suspiro'),
    (r'\badsuerunt\b', 'ad-suspiro'),
    (r'\badsuescam\b', 'assuesco'),
    (r'\badsuescamus\b', 'assuesco'),
    (r'\badsuescant\b', 'assuesco'),
    (r'\badsuescas\b', 'assuesco'),
    (r'\badsuescat\b', 'assuesco'),
    (r'\badsuesce\b', 'assuesco'),
    (r'\badsuescebat\b', 'assuesco'),
    (r'\badsuescendo\b', 'assuesco'),
    (r'\badsuescendum\b', 'assuesco'),
    (r'\badsuescent\b', 'assuesco'),
    (r'\badsuescere\b', 'assuesco'),
    (r'\badsuescerent\b', 'assuesco'),
    (r'\badsuesceres\b', 'assuesco'),
    (r'\badsuesceret\b', 'assuesco'),
    (r'\badsuesces\b', 'assuesco'),
    (r'\badsuescis\b', 'assuesco'),
    (r'\badsuescit\b', 'assuesco'),
    (r'\badsuescite\b', 'assuesco'),
    (r'\badsuescitis\b', 'assuesco'),
    (r'\badsuescitque\b', 'assuesco'),
    (r'\badsuescitur\b', 'assuesco'),
    (r'\badsuescunt\b', 'assuesco'),
    (r'\badsueta\b', 'assuesco'),
    (r'\badsuetae\b', 'assuesco'),
    (r'\badsuetam\b', 'assuesco'),
    (r'\badsuetamque\b', 'assuesco'),
    (r'\badsuetaque\b', 'assuesco'),
    (r'\badsuetas\b', 'assuesco'),
    (r'\badsuetasque\b', 'assuesco'),
    (r'\badsueti\b', 'assuesco'),
    (r'\badsuetior\b', 'assuesco'),
    (r'\badsuetis\b', 'assuesco'),
    (r'\badsueto\b', 'assuesco'),
    (r'\badsuetoque\b', 'assuesco'),
    (r'\badsuetorum\b', 'assuesco'),
    (r'\badsuetos\b', 'assuesco'),
    (r'\badsuetudine\b', 'assuetudo'),
    (r'\badsuetudo\b', 'assuetudo'),
    (r'\badsuetum\b', 'assuesco'),
    (r'\badsuetumque\b', 'assuesco'),
    (r'\badsuetus\b', 'assuesco'),
    (r'\badsueuerant\b', 'assuesco'),
    (r'\badsueuerat\b', 'assuesco'),
    (r'\badsueuere\b', 'assuesco'),
    (r'\badsueuerint\b', 'assuesco'),
    (r'\badsueuerit\b', 'assuesco'),
    (r'\badsueui\b', 'assuesco'),
    (r'\badsueuimus\b', 'assuesco'),
    (r'\badsueuit\b', 'assuesco'),
    (r'\badsueveram\b', 'assuesco'),
    (r'\badsueverant\b', 'assuesco'),
    (r'\badsueverat\b', 'assuesco'),
    (r'\badsuevere\b', 'assuesco'),
    (r'\badsueveris\b', 'assuesco'),
    (r'\badsueverunt\b', 'assuesco'),
    (r'\badsuevi\b', 'assuesco'),
    (r'\badsuevimus\b', 'assuesco'),
    (r'\badsuevisse\b', 'assuesco'),
    (r'\badsuevissent\b', 'assuesco'),
    (r'\badsuevit\b', 'assuesco'),
    (r'\badsuit\b', 'ad-suspiro'),
    (r'\badsuitur\b', 'ad-suspiro'),
    (r'\badsultibus\b', 'assultus'),
    (r'\badsultim\b', 'assultim'),
    (r'\badsum\b', 'adsum'),
    (r'\badsumam\b', 'ad-suspiro'),
    (r'\badsumamus\b', 'ad-suspiro'),
    (r'\badsumant\b', 'ad-suspiro'),
    (r'\badsumantur\b', 'ad-suspiro'),
    (r'\badsumas\b', 'ad-suspiro'),
    (r'\badsumat\b', 'ad-suspiro'),
    (r'\badsumatque\b', 'ad-suspiro'),
    (r'\badsumatur\b', 'ad-suspiro'),
    (r'\badsume\b', 'ad-suspiro'),
    (r'\badsumebatur\b', 'ad-suspiro'),
    (r'\badsumemus\b', 'ad-suspiro'),
    (r'\badsumenda\b', 'ad-suspiro'),
    (r'\badsumendae\b', 'ad-suspiro'),
    (r'\badsumendas\b', 'ad-suspiro'),
    (r'\badsumendi\b', 'ad-suspiro'),
    (r'\badsumendis\b', 'ad-suspiro'),
    (r'\badsumendo\b', 'ad-suspiro'),
    (r'\badsumendum\b', 'ad-suspiro'),
    (r'\badsumendus\b', 'ad-suspiro'),
    (r'\badsumens\b', 'ad-suspiro'),
    (r'\badsumensque\b', 'ad-suspiro'),
    (r'\badsument\b', 'ad-suspiro'),
    (r'\badsumentes\b', 'ad-suspiro'),
    (r'\badsumentesque\b', 'ad-suspiro'),
    (r'\badsumentum\b', 'assumentum'),
    (r'\badsumere\b', 'ad-suspiro'),
    (r'\badsumerem\b', 'ad-suspiro'),
    (r'\badsumerent\b', 'ad-suspiro'),
    (r'\badsumerentur\b', 'ad-suspiro'),
    (r'\badsumeret\b', 'ad-suspiro'),
    (r'\badsumeretur\b', 'ad-suspiro'),
    (r'\badsumes\b', 'ad-suspiro'),
    (r'\badsumet\b', 'ad-suspiro'),
    (r'\badsumetque\b', 'ad-suspiro'),
    (r'\badsumetur\b', 'ad-suspiro'),
    (r'\badsumi\b', 'ad-suspiro'),
    (r'\badsumimus\b', 'ad-suspiro'),
    (r'\badsumis\b', 'ad-suspiro'),
    (r'\badsumit\b', 'ad-suspiro'),
    (r'\badsumite\b', 'ad-suspiro'),
    (r'\badsumitis\b', 'ad-suspiro'),
    (r'\badsumitur\b', 'ad-suspiro'),
    (r'\badsumiturque\b', 'ad-suspiro'),
    (r'\badsumo\b', 'ad-suspiro'),
    (r'\badsumpserat\b', 'ad-suspiro'),
    (r'\badsumpserim\b', 'ad-suspiro'),
    (r'\badsumpserimus\b', 'ad-suspiro'),
    (r'\badsumpserint\b', 'ad-suspiro'),
    (r'\badsumpserit\b', 'ad-suspiro'),
    (r'\badsumpserunt\b', 'ad-suspiro'),
    (r'\badsumpsi\b', 'ad-suspiro'),
    (r'\badsumpsimus\b', 'ad-suspiro'),
    (r'\badsumpsisse\b', 'ad-suspiro'),
    (r'\badsumpsissem\b', 'ad-suspiro'),
    (r'\badsumpsissent\b', 'ad-suspiro'),
    (r'\badsumpsisset\b', 'ad-suspiro'),
    (r'\badsumpsisti\b', 'ad-suspiro'),
    (r'\badsumpsistis\b', 'ad-suspiro'),
    (r'\badsumpsit\b', 'ad-suspiro'),
    (r'\badsumpsitque\b', 'ad-suspiro'),
    (r'\badsumpta\b', 'ad-suspiro'),
    (r'\badsumptae\b', 'ad-suspiro'),
    (r'\badsumptaque\b', 'ad-suspiro'),
    (r'\badsumptas\b', 'ad-suspiro'),
    (r'\badsumpti\b', 'ad-suspiro'),
    (r'\badsumptio\b', 'assumptio'),
    (r'\badsumptione\b', 'assumptio'),
    (r'\badsumptionem\b', 'assumptio'),
    (r'\badsumptiones\b', 'assumptio'),
    (r'\badsumptionis\b', 'assumptio'),
    (r'\badsumptis\b', 'ad-suspiro'),
    (r'\badsumptisque\b', 'ad-suspiro'),
    (r'\badsumptiua\b', 'assumptivus'),
    (r'\badsumptiva\b', 'assumptivus'),
    (r'\badsumptivae\b', 'assumptivus'),
    (r'\badsumptivam\b', 'assumptivus'),
    (r'\badsumpto\b', 'ad-suspiro'),
    (r'\badsumptoque\b', 'ad-suspiro'),
    (r'\badsumptos\b', 'ad-suspiro'),
    (r'\badsumptum\b', 'ad-suspiro'),
    (r'\badsumptumque\b', 'ad-suspiro'),
    (r'\badsumpturus\b', 'ad-suspiro'),
    (r'\badsumptus\b', 'ad-suspiro'),
    (r'\badsumunt\b', 'ad-suspiro'),
    (r'\badsumuntur\b', 'ad-suspiro'),
    (r'\badsumus\b', 'adsum'),
    (r'\badsunt\b', 'adsum'),
    (r'\badsurgam\b', 'assurgo'),
    (r'\badsurgat\b', 'assurgo'),
    (r'\badsurgendi\b', 'assurgo'),
    (r'\badsurgendo\b', 'assurgo'),
    (r'\badsurgens\b', 'assurgo'),
    (r'\badsurgentem\b', 'assurgo'),
    (r'\badsurgentes\b', 'assurgo'),
    (r'\badsurgenti\b', 'assurgo'),
    (r'\badsurgentibus\b', 'assurgo'),
    (r'\badsurgentis\b', 'assurgo'),
    (r'\badsurgentiumque\b', 'assurgo'),
    (r'\badsurgere\b', 'assurgo'),
    (r'\badsurgerent\b', 'assurgo'),
    (r'\badsurgeret\b', 'assurgo'),
    (r'\badsurgi\b', 'assurgo'),
    (r'\badsurgis\b', 'assurgo'),
    (r'\badsurgit\b', 'assurgo'),
    (r'\badsurgite\b', 'assurgo'),
    (r'\badsurgo\b', 'assurgo'),
    (r'\badsurgunt\b', 'assurgo'),
    (r'\badsurrectum\b', 'assurgo'),
    (r'\badsurrexerat\b', 'assurgo'),
    (r'\badsurrexerit\b', 'assurgo'),
    (r'\badsurrexerunt\b', 'assurgo'),
    (r'\badsurrexisse\b', 'assurgo'),
    (r'\badsurrexit\b', 'assurgo'),
    (r'\badsuspirans\b', 'ad-suspiro'),
    (r'\badsuta\b', 'ad-suspiro'),
    (r'\badsuunt\b', 'ad-suspiro'),
    (r'\badtactu\b', 'ad-tumulo'),
    (r'\badtemperat\b', 'ad-tumulo'),
    (r'\badtemperate\b', 'ad-tumulo'),
    (r'\badtemptanda\b', 'attento'),
    (r'\badtemptantem\b', 'attento'),
    (r'\badtemptare\b', 'attento'),
    (r'\badtemptari\b', 'attento'),
    (r'\badtemptas\b', 'attento'),
    (r'\badtemptat\b', 'attento'),
    (r'\badtemptata\b', 'ad-tumulo'),
    (r'\badtemptatae\b', 'ad-tumulo'),
    (r'\badtemptatam\b', 'ad-tumulo'),
    (r'\badtemptatur\b', 'attento'),
    (r'\badtemptauit\b', 'ad-tumulo'),
    (r'\badtemptetur\b', 'attento'),
    (r'\badtendam\b', 'ad-tumulo'),
    (r'\badtendamus\b', 'ad-tumulo'),
    (r'\badtendant\b', 'ad-tumulo'),
    (r'\badtendas\b', 'ad-tumulo'),
    (r'\badtendat\b', 'ad-tumulo'),
    (r'\badtendatis\b', 'ad-tumulo'),
    (r'\badtendatur\b', 'ad-tumulo'),
    (r'\badtende\b', 'ad-tumulo'),
    (r'\badtendebant\b', 'ad-tumulo'),
    (r'\badtendebat\b', 'ad-tumulo'),
    (r'\badtendemus\b', 'ad-tumulo'),
    (r'\badtendendum\b', 'ad-tumulo'),
    (r'\badtendens\b', 'ad-tumulo'),
    (r'\badtendentem\b', 'ad-tumulo'),
    (r'\badtendentes\b', 'ad-tumulo'),
    (r'\badtendenti\b', 'ad-tumulo'),
    (r'\badtendentibus\b', 'ad-tumulo'),
    (r'\badtendere\b', 'ad-tumulo'),
    (r'\badtenderemus\b', 'ad-tumulo'),
    (r'\badtenderent\b', 'ad-tumulo'),
    (r'\badtenderis\b', 'ad-tumulo'),
    (r'\badtendet\b', 'ad-tumulo'),
    (r'\badtendi\b', 'ad-tumulo'),
    (r'\badtendimus\b', 'ad-tumulo'),
    (r'\badtendis\b', 'ad-tumulo'),
    (r'\badtendit\b', 'ad-tumulo'),
    (r'\badtendite\b', 'ad-tumulo'),
    (r'\badtenta\b', 'ad-tumulo'),
    (r'\badtenta\b', 'ad-tumulo'),
    (r'\badtente\b', 'ad-tumulo'),
    (r'\badtenti\b', 'ad-tumulo'),
    (r'\badtentior\b', 'ad-tumulo'),
    (r'\badtentiore\b', 'ad-tumulo'),
    (r'\badtentiores\b', 'ad-tumulo'),
    (r'\badtentioribus\b', 'ad-tumulo'),
    (r'\badtentissima\b', 'ad-tumulo'),
    (r'\badtentissimo\b', 'ad-tumulo'),
    (r'\badtentius\b', 'ad-tumulo'),
    (r'\badtento\b', 'ad-tumulo'),
    (r'\badtento\b', 'ad-tumulo'),
    (r'\badtentos\b', 'ad-tumulo'),
    (r'\badtentum\b', 'ad-tumulo'),
    (r'\badtentus\b', 'ad-tumulo'),
    (r'\badtenuabit\b', 'ad-tumulo'),
    (r'\badtenuabitur\b', 'ad-tumulo'),
    (r'\badtenuabo\b', 'ad-tumulo'),
    (r'\badtenuabuntur\b', 'ad-tumulo'),
    (r'\badtenuanda\b', 'ad-tumulo'),
    (r'\badtenuandae\b', 'ad-tumulo'),
    (r'\badtenuari\b', 'ad-tumulo'),
    (r'\badtenuaris\b', 'ad-tumulo'),
    (r'\badtenuasti\b', 'ad-tumulo'),
    (r'\badtenuat\b', 'ad-tumulo'),
    (r'\badtenuata\b', 'ad-tumulo'),
    (r'\badtenuati\b', 'ad-tumulo'),
    (r'\badtenuatione\b', 'attenuatio'),
    (r'\badtenuato\b', 'ad-tumulo'),
    (r'\badtenuatum\b', 'ad-tumulo'),
    (r'\badtenuatur\b', 'ad-tumulo'),
    (r'\badtenuatus\b', 'ad-tumulo'),
    (r'\badtenuentur\b', 'ad-tumulo'),
    (r'\badtenuetur\b', 'ad-tumulo'),
    (r'\badterant\b', 'ad-tumulo'),
    (r'\badterantur\b', 'ad-tumulo'),
    (r'\badteratur\b', 'ad-tumulo'),
    (r'\badterendo\b', 'ad-tumulo'),
    (r'\badterent\b', 'ad-tumulo'),
    (r'\badterentur\b', 'ad-tumulo'),
    (r'\badterere\b', 'ad-tumulo'),
    (r'\badtererent\b', 'ad-tumulo'),
    (r'\badtereret\b', 'ad-tumulo'),
    (r'\badteretur\b', 'ad-tumulo'),
    (r'\badteri\b', 'ad-tumulo'),
    (r'\badterit\b', 'ad-tumulo'),
    (r'\badteritis\b', 'ad-tumulo'),
    (r'\badterunt\b', 'ad-tumulo'),
    (r'\badteruntur\b', 'ad-tumulo'),
    (r'\badtestabatur\b', 'ad-tumulo'),
    (r'\badtestari\b', 'ad-tumulo'),
    (r'\badtestatast\b', 'ad-tumulo'),
    (r'\badtestatus\b', 'ad-tumulo'),
    (r'\badtineas\b', 'ad-tumulo'),
    (r'\badtineat\b', 'ad-tumulo'),
    (r'\badtinebat\b', 'ad-tumulo'),
    (r'\badtinent\b', 'ad-tumulo'),
    (r'\badtinent\b', 'ad-tumulo'),
    (r'\badtinentes\b', 'ad-tumulo'),
    (r'\badtinentur\b', 'ad-tumulo'),
    (r'\badtinentur\b', 'ad-tumulo'),
    (r'\badtinere\b', 'ad-tumulo'),
    (r'\badtinere\b', 'ad-tumulo'),
    (r'\badtinerent\b', 'ad-tumulo'),
    (r'\badtineret\b', 'ad-tumulo'),
    (r'\badtines\b', 'ad-tumulo'),
    (r'\badtines\b', 'ad-tumulo'),
    (r'\badtinet\b', 'ad-tumulo'),
    (r'\badtinet\b', 'ad-tumulo'),
    (r'\badtingam\b', 'ad-tumulo'),
    (r'\badtingant\b', 'ad-tumulo'),
    (r'\badtingantur\b', 'ad-tumulo'),
    (r'\badtingas\b', 'ad-tumulo'),
    (r'\badtingat\b', 'ad-tumulo'),
    (r'\badtingebat\b', 'ad-tumulo'),
    (r'\badtingendae\b', 'ad-tumulo'),
    (r'\badtingendus\b', 'ad-tumulo'),
    (r'\badtingens\b', 'ad-tumulo'),
    (r'\badtingente\b', 'ad-tumulo'),
    (r'\badtingentium\b', 'ad-tumulo'),
    (r'\badtingere\b', 'ad-tumulo'),
    (r'\badtingerent\b', 'ad-tumulo'),
    (r'\badtingi\b', 'ad-tumulo'),
    (r'\badtingimus\b', 'ad-tumulo'),
    (r'\badtingit\b', 'ad-tumulo'),
    (r'\badtingunt\b', 'ad-tumulo'),
    (r'\badtinuerit\b', 'ad-tumulo'),
    (r'\badtinuisse\b', 'ad-tumulo'),
    (r'\badtinuit\b', 'ad-tumulo'),
    (r'\badtollant\b', 'ad-tumulo'),
    (r'\badtollat\b', 'ad-tumulo'),
    (r'\badtollendo\b', 'ad-tumulo'),
    (r'\badtollendum\b', 'ad-tumulo'),
    (r'\badtollendus\b', 'ad-tumulo'),
    (r'\badtollens\b', 'ad-tumulo'),
    (r'\badtollente\b', 'ad-tumulo'),
    (r'\badtollentem\b', 'ad-tumulo'),
    (r'\badtollentes\b', 'ad-tumulo'),
    (r'\badtollentia\b', 'ad-tumulo'),
    (r'\badtollere\b', 'ad-tumulo'),
    (r'\badtolleret\b', 'ad-tumulo'),
    (r'\badtollet\b', 'ad-tumulo'),
    (r'\badtolli\b', 'ad-tumulo'),
    (r'\badtollimur\b', 'ad-tumulo'),
    (r'\badtollit\b', 'ad-tumulo'),
    (r'\badtollite\b', 'ad-tumulo'),
    (r'\badtollitque\b', 'ad-tumulo'),
    (r'\badtollitur\b', 'ad-tumulo'),
    (r'\badtollunt\b', 'ad-tumulo'),
    (r'\badtondebitis\b', 'ad-tumulo'),
    (r'\badtondent\b', 'ad-tumulo'),
    (r'\badtondentur\b', 'ad-tumulo'),
    (r'\badtondere\b', 'ad-tumulo'),
    (r'\badtonita\b', 'ad-tumulo'),
    (r'\badtonitas\b', 'ad-tumulo'),
    (r'\badtoniti\b', 'ad-tumulo'),
    (r'\badtonitique\b', 'ad-tumulo'),
    (r'\badtonitis\b', 'ad-tumulo'),
    (r'\badtonitos\b', 'ad-tumulo'),
    (r'\badtonitum\b', 'ad-tumulo'),
    (r'\badtonitus\b', 'ad-tumulo'),
    (r'\badtonsi\b', 'ad-tumulo'),
    (r'\badtonsum\b', 'ad-tumulo'),
    (r'\badtonsurum\b', 'ad-tumulo'),
    (r'\badtracta\b', 'ad-tumulo'),
    (r'\badtracta\b', 'ad-tumulo'),
    (r'\badtractatum\b', 'ad-tumulo'),
    (r'\badtractaverit\b', 'ad-tumulo'),
    (r'\badtractent\b', 'ad-tumulo'),
    (r'\badtracti\b', 'ad-tumulo'),
    (r'\badtractiorem\b', 'ad-tumulo'),
    (r'\badtractis\b', 'ad-tumulo'),
    (r'\badtracto\b', 'ad-tumulo'),
    (r'\badtracto\b', 'ad-tumulo'),
    (r'\badtractum\b', 'ad-tumulo'),
    (r'\badtractus\b', 'ad-tumulo'),
    (r'\badtrahas\b', 'ad-tumulo'),
    (r'\badtrahat\b', 'ad-tumulo'),
    (r'\badtrahatur\b', 'ad-tumulo'),
    (r'\badtrahaturque\b', 'ad-tumulo'),
    (r'\badtrahe\b', 'ad-tumulo'),
    (r'\badtrahenda\b', 'ad-tumulo'),
    (r'\badtrahendo\b', 'ad-tumulo'),
    (r'\badtrahendum\b', 'ad-tumulo'),
    (r'\badtrahendus\b', 'ad-tumulo'),
    (r'\badtrahens\b', 'ad-tumulo'),
    (r'\badtrahentem\b', 'ad-tumulo'),
    (r'\badtrahere\b', 'ad-tumulo'),
    (r'\badtraherent\b', 'ad-tumulo'),
    (r'\badtraheret\b', 'ad-tumulo'),
    (r'\badtrahes\b', 'ad-tumulo'),
    (r'\badtrahetur\b', 'ad-tumulo'),
    (r'\badtrahi\b', 'ad-tumulo'),
    (r'\badtrahit\b', 'ad-tumulo'),
    (r'\badtrahitur\b', 'ad-tumulo'),
    (r'\badtrahunt\b', 'ad-tumulo'),
    (r'\badtrahuntur\b', 'ad-tumulo'),
    (r'\badtraxerant\b', 'ad-tumulo'),
    (r'\badtraxere\b', 'ad-tumulo'),
    (r'\badtraxerit\b', 'ad-tumulo'),
    (r'\badtraxerunt\b', 'ad-tumulo'),
    (r'\badtraxi\b', 'ad-tumulo'),
    (r'\badtraxit\b', 'ad-tumulo'),
    (r'\badtrectatione\b', 'attrectatio'),
    (r'\badtribuamus\b', 'ad-tumulo'),
    (r'\badtribuant\b', 'ad-tumulo'),
    (r'\badtribuantur\b', 'ad-tumulo'),
    (r'\badtribuas\b', 'ad-tumulo'),
    (r'\badtribuat\b', 'ad-tumulo'),
    (r'\badtribuatur\b', 'ad-tumulo'),
    (r'\badtribuemus\b', 'ad-tumulo'),
    (r'\badtribuendum\b', 'ad-tumulo'),
    (r'\badtribuendus\b', 'ad-tumulo'),
    (r'\badtribuens\b', 'ad-tumulo'),
    (r'\badtribuentur\b', 'ad-tumulo'),
    (r'\badtribuerant\b', 'ad-tumulo'),
    (r'\badtribuerat\b', 'ad-tumulo'),
    (r'\badtribuere\b', 'ad-tumulo'),
    (r'\badtribuerent\b', 'ad-tumulo'),
    (r'\badtribuerentur\b', 'ad-tumulo'),
    (r'\badtribueretur\b', 'ad-tumulo'),
    (r'\badtribuerit\b', 'ad-tumulo'),
    (r'\badtribuerunt\b', 'ad-tumulo'),
    (r'\badtribuetur\b', 'ad-tumulo'),
    (r'\badtribui\b', 'ad-tumulo'),
    (r'\badtribuimusque\b', 'ad-tumulo'),
    (r'\badtribuit\b', 'ad-tumulo'),
    (r'\badtribuite\b', 'ad-tumulo'),
    (r'\badtribuitur\b', 'ad-tumulo'),
    (r'\badtributa\b', 'ad-tumulo'),
    (r'\badtributae\b', 'ad-tumulo'),
    (r'\badtributam\b', 'ad-tumulo'),
    (r'\badtributas\b', 'ad-tumulo'),
    (r'\badtributi\b', 'ad-tumulo'),
    (r'\badtributio\b', 'attributio'),
    (r'\badtributionibus\b', 'attributio'),
    (r'\badtributis\b', 'ad-tumulo'),
    (r'\badtributos\b', 'ad-tumulo'),
    (r'\badtributum\b', 'ad-tumulo'),
    (r'\badtributus\b', 'ad-tumulo'),
    (r'\badtribuunt\b', 'ad-tumulo'),
    (r'\badtribuuntur\b', 'ad-tumulo'),
    (r'\badtrita\b', 'ad-tumulo'),
    (r'\badtritae\b', 'ad-tumulo'),
    (r'\badtritam\b', 'ad-tumulo'),
    (r'\badtritas\b', 'ad-tumulo'),
    (r'\badtriti\b', 'ad-tumulo'),
    (r'\badtritis\b', 'ad-tumulo'),
    (r'\badtritisque\b', 'ad-tumulo'),
    (r'\badtritos\b', 'ad-tumulo'),
    (r'\badtritu\b', 'ad-tumulo'),
    (r'\badtritum\b', 'ad-tumulo'),
    (r'\badtritumue\b', 'ad-tumulo'),
    (r'\badtritus\b', 'ad-tumulo'),
    (r'\badtriuerant\b', 'ad-tumulo'),
    (r'\badtriuit\b', 'ad-tumulo'),
    (r'\badtriverant\b', 'ad-tumulo'),
    (r'\badtriverat\b', 'ad-tumulo'),
    (r'\badtrivimus\b', 'ad-tumulo'),
    (r'\badtrivisti\b', 'ad-tumulo'),
    (r'\badtrivit\b', 'ad-tumulo'),
    (r'\badtuendam\b', 'ad-tumulo'),
    (r'\badtuleram\b', 'affero'),
    (r'\badtulerant\b', 'affero'),
    (r'\badtulerat\b', 'affero'),
    (r'\badtuleratque\b', 'affero'),
    (r'\badtulere\b', 'affero'),
    (r'\badtulerimus\b', 'affero'),
    (r'\badtuleris\b', 'affero'),
    (r'\badtulerit\b', 'affero'),
    (r'\badtuleritis\b', 'affero'),
    (r'\badtulerunt\b', 'affero'),
    (r'\badtuleruntque\b', 'affero'),
    (r'\badtuli\b', 'affero'),
    (r'\badtulimus\b', 'affero'),
    (r'\badtulisse\b', 'affero'),
    (r'\badtulissent\b', 'affero'),
    (r'\badtulisset\b', 'affero'),
    (r'\badtulisti\b', 'affero'),
    (r'\badtulit\b', 'affero'),
    (r'\badtumulantium\b', 'ad-tumulo'),
    (r'\badtumulata\b', 'ad-tumulo'),
    (r'\baduecta\b', 'adveho'),
    (r'\baduecta\b', 'advecto'),
    (r'\baduectae\b', 'adveho'),
    (r'\baduectam\b', 'adveho'),
    (r'\baduectas\b', 'adveho'),
    (r'\baduectas\b', 'advecto'),
    (r'\baduecti\b', 'adveho'),
    (r'\baduectis\b', 'adveho'),
    (r'\baduecto\b', 'adveho'),
    (r'\baduecto\b', 'advecto'),
    (r'\baduectos\b', 'adveho'),
    (r'\baduectosque\b', 'adveho'),
    (r'\baduectum\b', 'advectus2'),
    (r'\baduectum\b', 'adveho'),
    (r'\baduectumque\b', 'advectus2'),
    (r'\baduectumque\b', 'adveho'),
    (r'\baduectus\b', 'advectus2'),
    (r'\baduectus\b', 'adveho'),
    (r'\baduehat\b', 'adveho'),
    (r'\baduehatur\b', 'adveho'),
    (r'\baduehe\b', 'adveho'),
    (r'\baduehebant\b', 'adveho'),
    (r'\baduehebatur\b', 'adveho'),
    (r'\baduehendas\b', 'adveho'),
    (r'\baduehendorum\b', 'adveho'),
    (r'\baduehendum\b', 'adveho'),
    (r'\baduehentium\b', 'adveho'),
    (r'\baduehere\b', 'adveho'),
    (r'\badueherentur\b', 'adveho'),
    (r'\badueheretur\b', 'adveho'),
    (r'\baduehi\b', 'adveho'),
    (r'\baduehimus\b', 'adveho'),
    (r'\baduehis\b', 'adveho'),
    (r'\baduehit\b', 'adveho'),
    (r'\baduehitur\b', 'adveho'),
    (r'\baduehuntur\b', 'adveho'),
    (r'\baduelat\b', 'advelo'),
    (r'\baduena\b', 'advena'),
    (r'\baduenae\b', 'advena'),
    (r'\baduenam\b', 'advena'),
    (r'\baduenarum\b', 'advena'),
    (r'\baduenas\b', 'advena'),
    (r'\baduenerant\b', 'advenio'),
    (r'\baduenerat\b', 'advenio'),
    (r'\badueneratus\b', 'adveneror'),
    (r'\baduenere\b', 'advenio'),
    (r'\badueneris\b', 'advenio'),
    (r'\baduenerit\b', 'advenio'),
    (r'\baduenerunt\b', 'advenio'),
    (r'\badueni\b', 'advenio'),
    (r'\baduenias\b', 'advenio'),
    (r'\badueniat\b', 'advenio'),
    (r'\badueniens\b', 'advenio'),
    (r'\badueniente\b', 'advenio'),
    (r'\baduenientem\b', 'advenio'),
    (r'\baduenientes\b', 'advenio'),
    (r'\baduenienti\b', 'advenio'),
    (r'\baduenientiam\b', 'advenientia'),
    (r'\baduenientibus\b', 'advenio'),
    (r'\baduenientis\b', 'advenio'),
    (r'\baduenientium\b', 'advenio'),
    (r'\badueniet\b', 'advenio'),
    (r'\baduenio\b', 'advenio'),
    (r'\baduenire\b', 'advenio'),
    (r'\badueniret\b', 'advenio'),
    (r'\baduenis\b', 'advena'),
    (r'\baduenis\b', 'advenio'),
    (r'\baduenisse\b', 'advenio'),
    (r'\baduenissent\b', 'advenio'),
    (r'\baduenisset\b', 'advenio'),
    (r'\baduenisti\b', 'advenio'),
    (r'\baduenit\b', 'advenio'),
    (r'\badueniunt\b', 'advenio'),
    (r'\baduentabant\b', 'advento'),
    (r'\baduentabat\b', 'advento'),
    (r'\baduentamus\b', 'advento'),
    (r'\baduentant\b', 'advento'),
    (r'\baduentante\b', 'advento'),
    (r'\baduentantem\b', 'advento'),
    (r'\baduentanti\b', 'advento'),
    (r'\baduentantibus\b', 'advento'),
    (r'\baduentantis\b', 'advento'),
    (r'\baduentare\b', 'advento'),
    (r'\baduentaremus\b', 'advento'),
    (r'\baduentarent\b', 'advento'),
    (r'\baduentaret\b', 'advento'),
    (r'\baduentat\b', 'advento'),
    (r'\baduenticia\b', 'adventicius'),
    (r'\baduenticiam\b', 'adventicius'),
    (r'\baduenticii\b', 'adventicius'),
    (r'\baduenticiis\b', 'adventicius'),
    (r'\baduenticio\b', 'adventicius'),
    (r'\baduenticium\b', 'adventicius'),
    (r'\baduentores\b', 'adventor'),
    (r'\baduentorum\b', 'adventor'),
    (r'\baduentorum\b', 'advenio'),
    (r'\baduentu\b', 'adventus'),
    (r'\baduentu\b', 'advenio'),
    (r'\baduentum\b', 'adventus'),
    (r'\baduentum\b', 'advenio'),
    (r'\baduentumque\b', 'adventus'),
    (r'\baduentumque\b', 'advenio'),
    (r'\baduentuque\b', 'adventus'),
    (r'\baduentuque\b', 'advenio'),
    (r'\baduentura\b', 'advenio'),
    (r'\baduenturae\b', 'advenio'),
    (r'\baduentus\b', 'adventus'),
    (r'\baduentus\b', 'advenio'),
    (r'\baduentusque\b', 'adventus'),
    (r'\baduentusque\b', 'advenio'),
    (r'\baduerberat\b', 'adverbero'),
    (r'\baduerbia\b', 'adverbium'),
    (r'\baduerbialiter\b', 'adverbialis'),
    (r'\baduerbialiter\b', 'adverbialiter'),
    (r'\baduerbii\b', 'adverbium'),
    (r'\baduerbiis\b', 'adverbium'),
    (r'\baduerbio\b', 'adverbium'),
    (r'\baduerbiorum\b', 'adverbium'),
    (r'\baduerbium\b', 'adverbium'),
    (r'\baduerrere\b', 'adverro'),
    (r'\baduersa\b', 'adversaria'),
    (r'\baduersa\b', 'adversus'),
    (r'\baduersa\b', 'adverro'),
    (r'\baduersa\b', 'adverso'),
    (r'\baduersabantur\b', 'adverso'),
    (r'\baduersabatur\b', 'adverso'),
    (r'\baduersae\b', 'adversaria'),
    (r'\baduersae\b', 'adverro'),
    (r'\baduersaeque\b', 'adversaria'),
    (r'\baduersaeque\b', 'adverro'),
    (r'\baduersam\b', 'adversaria'),
    (r'\baduersam\b', 'adverro'),
    (r'\baduersamque\b', 'adversaria'),
    (r'\baduersamque\b', 'adverro'),
    (r'\baduersando\b', 'adverso'),
    (r'\baduersandum\b', 'adverso'),
    (r'\baduersante\b', 'adverso'),
    (r'\baduersantia\b', 'adverso'),
    (r'\baduersantibus\b', 'adverso'),
    (r'\baduersantis\b', 'adverso'),
    (r'\baduersantium\b', 'adverso'),
    (r'\baduersantiumque\b', 'adverso'),
    (r'\baduersantur\b', 'adverso'),
    (r'\baduersaque\b', 'adversaria'),
    (r'\baduersaque\b', 'adversus'),
    (r'\baduersaque\b', 'adverro'),
    (r'\baduersaque\b', 'adverso'),
    (r'\baduersare\b', 'adverso'),
    (r'\baduersarentur\b', 'adverso'),
    (r'\baduersarer\b', 'adverso'),
    (r'\baduersaretur\b', 'adverso'),
    (r'\baduersari\b', 'adversarius'),
    (r'\baduersari\b', 'adverso'),
    (r'\baduersaria\b', 'adversarius'),
    (r'\baduersaria\b', 'adversaria'),
    (r'\baduersariae\b', 'adversarius'),
    (r'\baduersarias\b', 'adversarius'),
    (r'\baduersarii\b', 'adversarius'),
    (r'\baduersariis\b', 'adversarius'),
    (r'\baduersariis\b', 'adversaria'),
    (r'\baduersariisque\b', 'adversarius'),
    (r'\baduersariisque\b', 'adversaria'),
    (r'\baduersario\b', 'adversarius'),
    (r'\baduersariorum\b', 'adversarius'),
    (r'\baduersariorum\b', 'adversaria'),
    (r'\baduersariorumque\b', 'adversarius'),
    (r'\baduersariorumque\b', 'adversaria'),
    (r'\baduersarios\b', 'adversarius'),
    (r'\baduersariosque\b', 'adversarius'),
    (r'\baduersaris\b', 'adverso'),
    (r'\baduersarium\b', 'adversarius'),
    (r'\baduersarium\b', 'adversaria'),
    (r'\baduersarius\b', 'adversarius'),
    (r'\baduersarum\b', 'adversaria'),
    (r'\baduersarum\b', 'adverro'),
    (r'\baduersas\b', 'adversaria'),
    (r'\baduersas\b', 'adverro'),
    (r'\baduersas\b', 'adverso'),
    (r'\baduersasque\b', 'adversaria'),
    (r'\baduersasque\b', 'adverro'),
    (r'\baduersasque\b', 'adverso'),
    (r'\baduersata\b', 'adverso'),
    (r'\baduersati\b', 'adverso'),
    (r'\baduersatorem\b', 'adversator'),
    (r'\baduersatos\b', 'adverso'),
    (r'\baduersatur\b', 'adverso'),
    (r'\baduersatus\b', 'adverso'),
    (r'\baduerse\b', 'adverse'),
    (r'\baduerse\b', 'adversus'),
    (r'\baduerse\b', 'adversus'),
    (r'\baduerse\b', 'adverro'),
    (r'\baduersentur\b', 'adverso'),
    (r'\baduersere\b', 'adverso'),
    (r'\baduersetur\b', 'adverso'),
    (r'\baduersi\b', 'adversus'),
    (r'\baduersi\b', 'adversus'),
    (r'\baduersi\b', 'adverro'),
    (r'\baduersique\b', 'adversus'),
    (r'\baduersique\b', 'adversus'),
    (r'\baduersique\b', 'adverro'),
    (r'\baduersis\b', 'adversaria'),
    (r'\baduersis\b', 'adversus'),
    (r'\baduersis\b', 'adversus'),
    (r'\baduersis\b', 'adverro'),
    (r'\baduersisque\b', 'adversaria'),
    (r'\baduersisque\b', 'adversus'),
    (r'\baduersisque\b', 'adversus'),
    (r'\baduersisque\b', 'adverro'),
    (r'\baduersissimas\b', 'adverro'),
    (r'\baduersissimis\b', 'adverro'),
    (r'\baduerso\b', 'adversus'),
    (r'\baduerso\b', 'adversus'),
    (r'\baduerso\b', 'adverro'),
    (r'\baduerso\b', 'adverso'),
    (r'\baduersoque\b', 'adversus'),
    (r'\baduersoque\b', 'adversus'),
    (r'\baduersoque\b', 'adverro'),
    (r'\baduersoque\b', 'adverso'),
    (r'\baduersorum\b', 'adversus'),
    (r'\baduersorum\b', 'adversus'),
    (r'\baduersorum\b', 'adverro'),
    (r'\baduersorumque\b', 'adversus'),
    (r'\baduersorumque\b', 'adversus'),
    (r'\baduersorumque\b', 'adverro'),
    (r'\baduersos\b', 'adversus'),
    (r'\baduersos\b', 'adverro'),
    (r'\baduersosque\b', 'adversus'),
    (r'\baduersosque\b', 'adverro'),
    (r'\baduersu\b', 'adverro'),
    (r'\baduersum\b', 'adversus'),
    (r'\baduersum\b', 'adversus'),
    (r'\baduersum\b', 'adversus'),
    (r'\baduersum\b', 'adverro'),
    (r'\baduersumque\b', 'adversus'),
    (r'\baduersumque\b', 'adversus'),
    (r'\baduersumque\b', 'adversus'),
    (r'\baduersumque\b', 'adverro'),
    (r'\baduersus\b', 'adversus2'),
    (r'\baduersus\b', 'adversus'),
    (r'\baduersus\b', 'adverro'),
    (r'\baduersusque\b', 'adversus2'),
    (r'\baduersusque\b', 'adversus'),
    (r'\baduersusque\b', 'adverro'),
    (r'\baduertam\b', 'adverto'),
    (r'\baduertant\b', 'adverto'),
    (r'\baduertantur\b', 'adverto'),
    (r'\baduertas\b', 'adverto'),
    (r'\baduertat\b', 'adverto'),
    (r'\baduerte\b', 'adverto'),
    (r'\baduertens\b', 'adverto'),
    (r'\baduertentes\b', 'adverto'),
    (r'\baduertere\b', 'adverto'),
    (r'\baduerterent\b', 'adverto'),
    (r'\baduerteret\b', 'adverto'),
    (r'\baduerterimus\b', 'adverto'),
    (r'\baduerterit\b', 'adverto'),
    (r'\baduerterunt\b', 'adverto'),
    (r'\baduertimus\b', 'adverto'),
    (r'\baduertisset\b', 'adverto'),
    (r'\baduertisti\b', 'adverto'),
    (r'\baduertit\b', 'adverto'),
    (r'\baduertite\b', 'adverto'),
    (r'\baduertitis\b', 'adverto'),
    (r'\baduertito\b', 'adverto'),
    (r'\baduerto\b', 'adverto'),
    (r'\baduertunt\b', 'adverto'),
    (r'\baduertuntur\b', 'adverto'),
    (r'\baduexerant\b', 'adveho'),
    (r'\baduexerat\b', 'adveho'),
    (r'\baduexere\b', 'adveho'),
    (r'\baduexeris\b', 'adveho'),
    (r'\baduexerunt\b', 'adveho'),
    (r'\baduexi\b', 'adveho'),
    (r'\badueximus\b', 'adveho'),
    (r'\baduexisse\b', 'adveho'),
    (r'\baduexisset\b', 'adveho'),
    (r'\baduexistis\b', 'adveho'),
    (r'\baduexit\b', 'adveho'),
    (r'\baduigilantia\b', 'advigilo'),
    (r'\baduigiletur\b', 'advigilo'),
    (r'\baduiuere\b', 'advivo'),
    (r'\baduiuet\b', 'advivo'),
    (r'\baduixerit\b', 'advivo'),
    (r'\badulamur\b', 'adulo'),
    (r'\badulandi\b', 'adulo'),
    (r'\badulando\b', 'adulo'),
    (r'\badulandus\b', 'adulo'),
    (r'\badulans\b', 'adulo'),
    (r'\badulant\b', 'adulo'),
    (r'\badulantem\b', 'adulo'),
    (r'\badulantes\b', 'adulo'),
    (r'\badulanti\b', 'adulo'),
    (r'\badulantia\b', 'adulo'),
    (r'\badulantibus\b', 'adulo'),
    (r'\badulantis\b', 'adulo'),
    (r'\badulantisque\b', 'adulo'),
    (r'\badulantium\b', 'adulo'),
    (r'\badulantiumque\b', 'adulo'),
    (r'\badulantur\b', 'adulo'),
    (r'\badulare\b', 'adulo'),
    (r'\badulari\b', 'adulo'),
    (r'\badularis\b', 'adulo'),
    (r'\badulat\b', 'adulo'),
    (r'\badulata\b', 'adulo'),
    (r'\badulatio\b', 'adulatio'),
    (r'\badulatione\b', 'adulatio'),
    (r'\badulationem\b', 'adulatio'),
    (r'\badulationes\b', 'adulatio'),
    (r'\badulationesque\b', 'adulatio'),
    (r'\badulationi\b', 'adulatio'),
    (r'\badulationibus\b', 'adulatio'),
    (r'\badulationis\b', 'adulatio'),
    (r'\badulationum\b', 'adulatio'),
    (r'\badulatique\b', 'adulo'),
    (r'\badulato\b', 'adulo'),
    (r'\badulator\b', 'adulator'),
    (r'\badulatores\b', 'adulator'),
    (r'\badulatoribus\b', 'adulator'),
    (r'\badulatorie\b', 'adulatorius'),
    (r'\badulatorii\b', 'adulatorius'),
    (r'\badulatoris\b', 'adulator'),
    (r'\badulatorium\b', 'adulatorius'),
    (r'\badulatorum\b', 'adulator'),
    (r'\badulatorum\b', 'adulo'),
    (r'\badulatos\b', 'adulo'),
    (r'\badulatrices\b', 'adulatrix'),
    (r'\badulatum\b', 'adulo'),
    (r'\badulatur\b', 'adulo'),
    (r'\badulatus\b', 'adulo'),
    (r'\badulentur\b', 'adulo'),
    (r'\badulescens\b', 'adulescens'),
    (r'\badulescente\b', 'adulescens'),
    (r'\badulescentem\b', 'adulescens'),
    (r'\badulescentes\b', 'adulescens'),
    (r'\badulescenti\b', 'adulescens'),
    (r'\badulescentia\b', 'adulescentia'),
    (r'\badulescentiae\b', 'adulescentia'),
    (r'\badulescentiaeque\b', 'adulescentia'),
    (r'\badulescentiam\b', 'adulescentia'),
    (r'\badulescentiamque\b', 'adulescentia'),
    (r'\badulescentiaris\b', 'adulescentior'),
    (r'\badulescentibus\b', 'adulescens'),
    (r'\badulescentior\b', 'adulescentior'),
    (r'\badulescentis\b', 'adulescens'),
    (r'\badulescentium\b', 'adulescens'),
    (r'\badulescentiumst\b', 'adulescens'),
    (r'\badulescentula\b', 'adulescentula'),
    (r'\badulescentulae\b', 'adulescentula'),
    (r'\badulescentulam\b', 'adulescentula'),
    (r'\badulescentularum\b', 'adulescentula'),
    (r'\badulescentulas\b', 'adulescentula'),
    (r'\badulescentuli\b', 'adulescentulus'),
    (r'\badulescentulis\b', 'adulescentula'),
    (r'\badulescentulis\b', 'adulescentulus'),
    (r'\badulescentulist\b', 'adulescentula'),
    (r'\badulescentulist\b', 'adulescentulus'),
    (r'\badulescentulo\b', 'adulescentulus'),
    (r'\badulescentulorum\b', 'adulescentulus'),
    (r'\badulescentulos\b', 'adulescentulus'),
    (r'\badulescentulum\b', 'adulescentulus'),
    (r'\badulescentulus\b', 'adulescentulus'),
    (r'\badulescentulusque\b', 'adulescentulus'),
    (r'\badulescentulust\b', 'adulescentulus'),
    (r'\badulescentum\b', 'adulescens'),
    (r'\badulescenturire\b', 'adulescenturio'),
    (r'\badulo\b', 'adulo'),
    (r'\badulor\b', 'adulo'),
    (r'\badulta\b', 'adoleo1'),
    (r'\badultae\b', 'adoleo1'),
    (r'\badultam\b', 'adoleo1'),
    (r'\badultamque\b', 'adoleo1'),
    (r'\badultaque\b', 'adoleo1'),
    (r'\badultarum\b', 'adoleo1'),
    (r'\badultas\b', 'adoleo1'),
    (r'\badulter\b', 'adulter1'),
    (r'\badultera\b', 'adulteratio'),
    (r'\badultera\b', 'adultero'),
    (r'\badulterabat\b', 'adultero'),
    (r'\badulterabis\b', 'adultero'),
    (r'\badulterae\b', 'adulteratio'),
    (r'\badulteram\b', 'adulteratio'),
    (r'\badulterandi\b', 'adultero'),
    (r'\badulterandis\b', 'adultero'),
    (r'\badulterandum\b', 'adultero'),
    (r'\badulterans\b', 'adultero'),
    (r'\badulterant\b', 'adultero'),
    (r'\badulterantes\b', 'adultero'),
    (r'\badulterantque\b', 'adultero'),
    (r'\badulterantur\b', 'adultero'),
    (r'\badulterare\b', 'adultero'),
    (r'\badulterarere\b', 'adultero'),
    (r'\badulterares\b', 'adultero'),
    (r'\badulteraret\b', 'adultero'),
    (r'\badulteraretur\b', 'adultero'),
    (r'\badulterari\b', 'adultero'),
    (r'\badulterarint\b', 'adultero'),
    (r'\badulterarum\b', 'adulteratio'),
    (r'\badulteras\b', 'adulteratio'),
    (r'\badulteras\b', 'adultero'),
    (r'\badulterat\b', 'adultero'),
    (r'\badulterata\b', 'adultero'),
    (r'\badulteratam\b', 'adultero'),
    (r'\badulterati\b', 'adultero'),
    (r'\badulteratione\b', 'adulteratio'),
    (r'\badulterationes\b', 'adulteratio'),
    (r'\badulterato\b', 'adultero'),
    (r'\badulteratores\b', 'adulterator'),
    (r'\badulteratque\b', 'adultero'),
    (r'\badulteratu\b', 'adultero'),
    (r'\badulteratum\b', 'adultero'),
    (r'\badulteratur\b', 'adultero'),
    (r'\badulteravere\b', 'adultero'),
    (r'\badulteraverint\b', 'adultero'),
    (r'\badulteravit\b', 'adultero'),
    (r'\badulterentur\b', 'adultero'),
    (r'\badulteres\b', 'adultero'),
    (r'\badulteretur\b', 'adultero'),
    (r'\badulteri\b', 'adulter1'),
    (r'\badulteri\b', 'adulterium'),
    (r'\badulteria\b', 'adulterium'),
    (r'\badulterii\b', 'adulterium'),
    (r'\badulteriis\b', 'adulterium'),
    (r'\badulteriisque\b', 'adulterium'),
    (r'\badulterina\b', 'adulterinus'),
    (r'\badulterinae\b', 'adulterinus'),
    (r'\badulterinam\b', 'adulterinus'),
    (r'\badulterinas\b', 'adulterinus'),
    (r'\badulterini\b', 'adulterinus'),
    (r'\badulterinis\b', 'adulterinus'),
    (r'\badulterino\b', 'adulterinus'),
    (r'\badulterinos\b', 'adulterinus'),
    (r'\badulterinum\b', 'adulterinus'),
    (r'\badulterinus\b', 'adulterinus'),
    (r'\badulterio\b', 'adulterium'),
    (r'\badulteriorum\b', 'adulterium'),
    (r'\badulteris\b', 'adulteratio'),
    (r'\badulteris\b', 'adulter1'),
    (r'\badulteritatem\b', 'adulteritas'),
    (r'\badulterium\b', 'adulterium'),
    (r'\badulteriumue\b', 'adulterium'),
    (r'\badultero\b', 'adulter1'),
    (r'\badultero\b', 'adultero'),
    (r'\badulterorum\b', 'adulter1'),
    (r'\badulteros\b', 'adulter1'),
    (r'\badulterosque\b', 'adulter1'),
    (r'\badulterum\b', 'adulter1'),
    (r'\badulterumque\b', 'adulter1'),
    (r'\badulti\b', 'adoleo1'),
    (r'\badultioresque\b', 'adoleo1'),
    (r'\badultis\b', 'adoleo1'),
    (r'\badulto\b', 'adoleo1'),
    (r'\badultorum\b', 'adoleo1'),
    (r'\badultos\b', 'adoleo1'),
    (r'\badultum\b', 'adoleo1'),
    (r'\badultumque\b', 'adoleo1'),
    (r'\badultus\b', 'adoleo1'),
    (r'\badumbrabat\b', 'adumbro'),
    (r'\badumbrabimus\b', 'adumbro'),
    (r'\badumbrantur\b', 'adumbro'),
    (r'\badumbrare\b', 'adumbro'),
    (r'\badumbrari\b', 'adumbro'),
    (r'\badumbras\b', 'adumbro'),
    (r'\badumbrat\b', 'adumbro'),
    (r'\badumbrata\b', 'adumbro'),
    (r'\badumbratam\b', 'adumbro'),
    (r'\badumbratas\b', 'adumbro'),
    (r'\badumbrati\b', 'adumbro'),
    (r'\badumbratim\b', 'adumbratim'),
    (r'\badumbratio\b', 'adumbratio'),
    (r'\badumbratis\b', 'adumbro'),
    (r'\badumbratorum\b', 'adumbro'),
    (r'\badumbratos\b', 'adumbro'),
    (r'\badumbratum\b', 'adumbro'),
    (r'\badumbratus\b', 'adumbro'),
    (r'\badumbrauit\b', 'adumbro'),
    (r'\badumbretur\b', 'adumbro'),
    (r'\badunabo\b', 'aduno'),
    (r'\badunari\b', 'aduno'),
    (r'\badunata\b', 'aduno'),
    (r'\badunati\b', 'aduno'),
    (r'\badunatos\b', 'aduno'),
    (r'\badunatum\b', 'aduno'),
    (r'\badunavit\b', 'aduno'),
    (r'\badunca\b', 'aduncus'),
    (r'\baduncae\b', 'aduncus'),
    (r'\baduncam\b', 'aduncus'),
    (r'\baduncas\b', 'aduncus'),
    (r'\badunci\b', 'aduncus'),
    (r'\baduncis\b', 'aduncus'),
    (r'\baduncitas\b', 'aduncitas'),
    (r'\baduncitate\b', 'aduncitas'),
    (r'\badunco\b', 'aduncus'),
    (r'\baduncos\b', 'aduncus'),
    (r'\baduncum\b', 'aduncus'),
    (r'\baduncus\b', 'aduncus'),
    (r'\badundantes\b', 'aduno'),
    (r'\badundat\b', 'aduno'),
    (r'\baduoca\b', 'advoco'),
    (r'\baduocabatis\b', 'advoco'),
    (r'\baduocabimus\b', 'advoco'),
    (r'\baduocabit\b', 'advoco'),
    (r'\baduocabo\b', 'advoco'),
    (r'\baduocamur\b', 'advoco'),
    (r'\baduocanda\b', 'advoco'),
    (r'\baduocandi\b', 'advoco'),
    (r'\baduocandum\b', 'advoco'),
    (r'\baduocandus\b', 'advoco'),
    (r'\baduocant\b', 'advoco'),
    (r'\baduocantes\b', 'advoco'),
    (r'\baduocantium\b', 'advoco'),
    (r'\baduocantur\b', 'advoco'),
    (r'\baduocare\b', 'advoco'),
    (r'\baduocaret\b', 'advoco'),
    (r'\baduocaretur\b', 'advoco'),
    (r'\baduocari\b', 'advoco'),
    (r'\baduocarim\b', 'advoco'),
    (r'\baduocaris\b', 'advoco'),
    (r'\baduocas\b', 'advoco'),
    (r'\baduocasse\b', 'advoco'),
    (r'\baduocat\b', 'advoco'),
    (r'\baduocata\b', 'advoco'),
    (r'\baduocatam\b', 'advoco'),
    (r'\baduocataque\b', 'advoco'),
    (r'\baduocati\b', 'advocatus'),
    (r'\baduocati\b', 'advoco'),
    (r'\baduocatio\b', 'advocatio'),
    (r'\baduocatione\b', 'advocatio'),
    (r'\baduocationem\b', 'advocatio'),
    (r'\baduocationes\b', 'advocatio'),
    (r'\baduocationi\b', 'advocatio'),
    (r'\baduocationibus\b', 'advocatio'),
    (r'\baduocationis\b', 'advocatio'),
    (r'\baduocationum\b', 'advocatio'),
    (r'\baduocatis\b', 'advocatus'),
    (r'\baduocatis\b', 'advoco'),
    (r'\baduocatisque\b', 'advocatus'),
    (r'\baduocatisque\b', 'advoco'),
    (r'\baduocato\b', 'advoco'),
    (r'\baduocato\b', 'advocatus'),
    (r'\baduocatoque\b', 'advoco'),
    (r'\baduocatoque\b', 'advocatus'),
    (r'\baduocatorum\b', 'advocator'),
    (r'\baduocatorum\b', 'advoco'),
    (r'\baduocatos\b', 'advocatus'),
    (r'\baduocatos\b', 'advoco'),
    (r'\baduocatum\b', 'advocatus'),
    (r'\baduocatum\b', 'advoco'),
    (r'\baduocatumque\b', 'advocatus'),
    (r'\baduocatumque\b', 'advoco'),
    (r'\baduocatur\b', 'advoco'),
    (r'\baduocatus\b', 'advocatus'),
    (r'\baduocatus\b', 'advoco'),
    (r'\baduocauerit\b', 'advoco'),
    (r'\baduocauerunt\b', 'advoco'),
    (r'\baduocaui\b', 'advoco'),
    (r'\baduocauisse\b', 'advoco'),
    (r'\baduocauit\b', 'advoco'),
    (r'\baduocemus\b', 'advoco'),
    (r'\baduocent\b', 'advoco'),
    (r'\baduocet\b', 'advoco'),
    (r'\baduola\b', 'advolo'),
    (r'\baduolant\b', 'advolo'),
    (r'\baduolantibus\b', 'advolo'),
    (r'\baduolasse\b', 'advolo'),
    (r'\baduolassent\b', 'advolo'),
    (r'\baduolat\b', 'advolo'),
    (r'\baduolauerunt\b', 'advolo'),
    (r'\baduolaui\b', 'advolo'),
    (r'\baduolauit\b', 'advolo'),
    (r'\baduolent\b', 'advolo'),
    (r'\baduolet\b', 'advolo'),
    (r'\baduoluens\b', 'advolvo'),
    (r'\baduoluensque\b', 'advolvo'),
    (r'\baduoluere\b', 'advolvo'),
    (r'\baduoluitur\b', 'advolvo'),
    (r'\baduoluor\b', 'advolvo'),
    (r'\baduoluta\b', 'advolvo'),
    (r'\baduoluta\b', 'advolvo'),
    (r'\baduolutum\b', 'advolvo'),
    (r'\baduolutumque\b', 'advolvo'),
    (r'\baduolutus\b', 'advolvo'),
    (r'\baduolutusque\b', 'advolvo'),
    (r'\baduoluunt\b', 'advolvo'),
    (r'\baduorsae\b', 'adverto'),
    (r'\baduorsam\b', 'adverto'),
    (r'\baduorsari\b', 'adverso'),
    (r'\baduorsi\b', 'adverto'),
    (r'\baduorso\b', 'adverto'),
    (r'\baduorso\b', 'adverso'),
    (r'\baduorsos\b', 'adverto'),
    (r'\baduorsum\b', 'adverto'),
    (r'\baduorsus\b', 'adversus2'),
    (r'\baduorte\b', 'adverto'),
    (r'\baduortere\b', 'adverto'),
    (r'\baduortito\b', 'adverto'),
    (r'\baduotus\b', 'ad-voveo'),
    (r'\baduram\b', 'aduro'),
    (r'\badurant\b', 'aduro'),
    (r'\badurantur\b', 'aduro'),
    (r'\baduras\b', 'aduro'),
    (r'\badurat\b', 'aduro'),
    (r'\baduratur\b', 'aduro'),
    (r'\badurebant\b', 'aduro'),
    (r'\badurebat\b', 'aduro'),
    (r'\badurenda\b', 'aduro'),
    (r'\badurendae\b', 'aduro'),
    (r'\badurendi\b', 'aduro'),
    (r'\badurendo\b', 'aduro'),
    (r'\badurendum\b', 'aduro'),
    (r'\badurendus\b', 'aduro'),
    (r'\badurens\b', 'aduro'),
    (r'\badurente\b', 'aduro'),
    (r'\badurentes\b', 'aduro'),
    (r'\badurentia\b', 'aduro'),
    (r'\badurentibus\b', 'aduro'),
    (r'\badurentur\b', 'aduro'),
    (r'\badurere\b', 'aduro'),
    (r'\badurerent\b', 'aduro'),
    (r'\baduretur\b', 'aduro'),
    (r'\badurgens\b', 'adurgeo'),
    (r'\baduri\b', 'aduro'),
    (r'\badurimur\b', 'aduro'),
    (r'\badurimus\b', 'aduro'),
    (r'\badurique\b', 'aduro'),
    (r'\baduris\b', 'aduro'),
    (r'\badurit\b', 'aduro'),
    (r'\baduritur\b', 'aduro'),
    (r'\badurunt\b', 'aduro'),
    (r'\baduruntur\b', 'aduro'),
    (r'\badusserint\b', 'aduro'),
    (r'\badusseris\b', 'aduro'),
    (r'\badusserit\b', 'aduro'),
    (r'\badusserunt\b', 'aduro'),
    (r'\badussisse\b', 'aduro'),
    (r'\badussisset\b', 'aduro'),
    (r'\badussit\b', 'aduro'),
    (r'\badusta\b', 'adustio'),
    (r'\badusta\b', 'aduro'),
    (r'\badustae\b', 'aduro'),
    (r'\badustam\b', 'aduro'),
    (r'\badustas\b', 'aduro'),
    (r'\badusti\b', 'aduro'),
    (r'\badustio\b', 'adustio'),
    (r'\badustione\b', 'adustio'),
    (r'\badustionem\b', 'adustio'),
    (r'\badustiones\b', 'adustio'),
    (r'\badustionesque\b', 'adustio'),
    (r'\badustioris\b', 'aduro'),
    (r'\badustis\b', 'adustio'),
    (r'\badustis\b', 'aduro'),
    (r'\badustisque\b', 'adustio'),
    (r'\badustisque\b', 'aduro'),
    (r'\badusto\b', 'aduro'),
    (r'\badustorum\b', 'adustio'),
    (r'\badustorum\b', 'aduro'),
    (r'\badustum\b', 'adustio'),
    (r'\badustum\b', 'aduro'),
    (r'\badustumst\b', 'adustio'),
    (r'\badustumst\b', 'aduro'),
    (r'\badustus\b', 'aduro'),
    (r'\badve\b', 'ad'),
    (r'\badvecta\b', 'adveho'),
    (r'\badvecta\b', 'advecto'),
    (r'\badvectae\b', 'adveho'),
    (r'\badvectam\b', 'adveho'),
    (r'\badvectaret\b', 'advecto'),
    (r'\badvectarum\b', 'adveho'),
    (r'\badvectas\b', 'adveho'),
    (r'\badvectas\b', 'advecto'),
    (r'\badvectast\b', 'adveho'),
    (r'\badvectast\b', 'advecto'),
    (r'\badvectet\b', 'advecto'),
    (r'\badvecti\b', 'adveho'),
    (r'\badvecticio\b', 'advecticius'),
    (r'\badvectionis\b', 'advectio'),
    (r'\badvectis\b', 'adveho'),
    (r'\badvectisque\b', 'adveho'),
    (r'\badvecto\b', 'adveho'),
    (r'\badvecto\b', 'advecto'),
    (r'\badvectorum\b', 'advector'),
    (r'\badvectorum\b', 'adveho'),
    (r'\badvectos\b', 'adveho'),
    (r'\badvectu\b', 'advectus2'),
    (r'\badvectu\b', 'adveho'),
    (r'\badvectum\b', 'advectus2'),
    (r'\badvectum\b', 'adveho'),
    (r'\badvectus\b', 'advectus2'),
    (r'\badvectus\b', 'adveho'),
    (r'\badvehar\b', 'adveho'),
    (r'\badvehatur\b', 'adveho'),
    (r'\badvehebantur\b', 'adveho'),
    (r'\badvehebatur\b', 'adveho'),
    (r'\badvehendas\b', 'adveho'),
    (r'\badvehere\b', 'adveho'),
    (r'\badveherent\b', 'adveho'),
    (r'\badveheret\b', 'adveho'),
    (r'\badveheretur\b', 'adveho'),
    (r'\badvehi\b', 'adveho'),
    (r'\badvehimur\b', 'adveho'),
    (r'\badvehit\b', 'adveho'),
    (r'\badvehitur\b', 'adveho'),
    (r'\badvehiturque\b', 'adveho'),
    (r'\badvehor\b', 'adveho'),
    (r'\badvehunt\b', 'adveho'),
    (r'\badvehuntur\b', 'adveho'),
    (r'\badvelans\b', 'advelo'),
    (r'\badven\b', 'ad'),
    (r'\badvena\b', 'advena'),
    (r'\badvenae\b', 'advena'),
    (r'\badvenam\b', 'advena'),
    (r'\badvenarum\b', 'advena'),
    (r'\badvenas\b', 'advena'),
    (r'\badvenasque\b', 'advena'),
    (r'\badveneram\b', 'advenio'),
    (r'\badvenerant\b', 'advenio'),
    (r'\badvenerat\b', 'advenio'),
    (r'\badvenere\b', 'advenio'),
    (r'\badvenerim\b', 'advenio'),
    (r'\badvenerint\b', 'advenio'),
    (r'\badveneris\b', 'advenio'),
    (r'\badvenerit\b', 'advenio'),
    (r'\badvenero\b', 'advenio'),
    (r'\badveneror\b', 'adveneror'),
    (r'\badvenerunt\b', 'advenio'),
    (r'\badveneruntque\b', 'advenio'),
    (r'\badveni\b', 'advenio'),
    (r'\badveniam\b', 'advenio'),
    (r'\badveniant\b', 'advenio'),
    (r'\badvenias\b', 'advenio'),
    (r'\badveniat\b', 'advenio'),
    (r'\badveniebant\b', 'advenio'),
    (r'\badvenien\b', 'advenio'),
    (r'\badveniens\b', 'advenio'),
    (r'\badveniensque\b', 'advenio'),
    (r'\badvenient\b', 'advenio'),
    (r'\badveniente\b', 'advenio'),
    (r'\badvenientem\b', 'advenio'),
    (r'\badvenientes\b', 'advenio'),
    (r'\badvenienti\b', 'advenio'),
    (r'\badvenientibus\b', 'advenio'),
    (r'\badvenientique\b', 'advenio'),
    (r'\badvenientis\b', 'advenio'),
    (r'\badvenientium\b', 'advenio'),
    (r'\badvenies\b', 'advenio'),
    (r'\badveniet\b', 'advenio'),
    (r'\badvenimus\b', 'advenio'),
    (r'\badvenio\b', 'advenio'),
    (r'\badvenire\b', 'advenio'),
    (r'\badveniret\b', 'advenio'),
    (r'\badvenis\b', 'advena'),
    (r'\badvenis\b', 'advenio'),
    (r'\badvenisse\b', 'advenio'),
    (r'\badvenissem\b', 'advenio'),
    (r'\badvenissemus\b', 'advenio'),
    (r'\badvenissent\b', 'advenio'),
    (r'\badvenisset\b', 'advenio'),
    (r'\badvenisti\b', 'advenio'),
    (r'\badvenistis\b', 'advenio'),
    (r'\badvenit\b', 'advenio'),
    (r'\badvenitis\b', 'advenio'),
    (r'\badveniunt\b', 'advenio'),
    (r'\badventa\b', 'advenio'),
    (r'\badventa\b', 'advento'),
    (r'\badventabam\b', 'advento'),
    (r'\badventabant\b', 'advento'),
    (r'\badventabat\b', 'advento'),
    (r'\badventante\b', 'advento'),
    (r'\badventantem\b', 'advento'),
    (r'\badventantes\b', 'advento'),
    (r'\badventanti\b', 'advento'),
    (r'\badventantibus\b', 'advento'),
    (r'\badventantis\b', 'advento'),
    (r'\badventantium\b', 'advento'),
    (r'\badventare\b', 'advento'),
    (r'\badventarent\b', 'advento'),
    (r'\badventaret\b', 'advento'),
    (r'\badventarit\b', 'advento'),
    (r'\badventat\b', 'advento'),
    (r'\badventate\b', 'advento'),
    (r'\badventet\b', 'advento'),
    (r'\badventi\b', 'advenio'),
    (r'\badventibus\b', 'adventus'),
    (r'\badventicia\b', 'adventicius'),
    (r'\badventiciae\b', 'adventicius'),
    (r'\badventiciam\b', 'adventicius'),
    (r'\badventiciis\b', 'adventicius'),
    (r'\badventicio\b', 'adventicius'),
    (r'\badventicium\b', 'adventicius'),
    (r'\badventicius\b', 'adventicius'),
    (r'\badvento\b', 'advenio'),
    (r'\badvento\b', 'advento'),
    (r'\badventor\b', 'adventor'),
    (r'\badventor\b', 'advento'),
    (r'\badventorem\b', 'adventor'),
    (r'\badventores\b', 'adventor'),
    (r'\badventoria\b', 'adventoria'),
    (r'\badventoria\b', 'adventorius'),
    (r'\badventoribus\b', 'adventor'),
    (r'\badventu\b', 'adventus'),
    (r'\badventu\b', 'advenio'),
    (r'\badventui\b', 'adventus'),
    (r'\badventum\b', 'adventus'),
    (r'\badventum\b', 'advenio'),
    (r'\badventumque\b', 'adventus'),
    (r'\badventumque\b', 'advenio'),
    (r'\badventuque\b', 'adventus'),
    (r'\badventuque\b', 'advenio'),
    (r'\badventuram\b', 'advenio'),
    (r'\badventurum\b', 'advenio'),
    (r'\badventus\b', 'adventus'),
    (r'\badventus\b', 'advenio'),
    (r'\badventusque\b', 'adventus'),
    (r'\badventusque\b', 'advenio'),
    (r'\badverbia\b', 'adverbium'),
    (r'\badverbialiter\b', 'adverbialis'),
    (r'\badverbialiter\b', 'adverbialiter'),
    (r'\badverbii\b', 'adverbium'),
    (r'\badverbiis\b', 'adverbium'),
    (r'\badverbio\b', 'adverbium'),
    (r'\badverbiorum\b', 'adverbium'),
    (r'\badverbium\b', 'adverbium'),
    (r'\badversa\b', 'adversaria'),
    (r'\badversa\b', 'adversus'),
    (r'\badversa\b', 'adverro'),
    (r'\badversa\b', 'adverso'),
    (r'\badversabantur\b', 'adverso'),
    (r'\badversabatur\b', 'adverso'),
    (r'\badversabimur\b', 'adverso'),
    (r'\badversabor\b', 'adverso'),
    (r'\badversabuntur\b', 'adverso'),
    (r'\badversae\b', 'adversaria'),
    (r'\badversae\b', 'adverro'),
    (r'\badversaeque\b', 'adversaria'),
    (r'\badversaeque\b', 'adverro'),
    (r'\badversam\b', 'adversaria'),
    (r'\badversam\b', 'adverro'),
    (r'\badversamque\b', 'adversaria'),
    (r'\badversamque\b', 'adverro'),
    (r'\badversamur\b', 'adverso'),
    (r'\badversamve\b', 'adversaria'),
    (r'\badversamve\b', 'adverro'),
    (r'\badversando\b', 'adverso'),
    (r'\badversante\b', 'adverso'),
    (r'\badversantem\b', 'adverso'),
    (r'\badversantes\b', 'adverso'),
    (r'\badversantia\b', 'adverso'),
    (r'\badversantibus\b', 'adverso'),
    (r'\badversantis\b', 'adverso'),
    (r'\badversantur\b', 'adverso'),
    (r'\badversaque\b', 'adversaria'),
    (r'\badversaque\b', 'adversus'),
    (r'\badversaque\b', 'adverro'),
    (r'\badversaque\b', 'adverso'),
    (r'\badversarentur\b', 'adverso'),
    (r'\badversarer\b', 'adverso'),
    (r'\badversaretur\b', 'adverso'),
    (r'\badversari\b', 'adversarius'),
    (r'\badversari\b', 'adverso'),
    (r'\badversaria\b', 'adversarius'),
    (r'\badversaria\b', 'adversaria'),
    (r'\badversariae\b', 'adversarius'),
    (r'\badversariam\b', 'adversarius'),
    (r'\badversarii\b', 'adversarius'),
    (r'\badversariis\b', 'adversarius'),
    (r'\badversariis\b', 'adversaria'),
    (r'\badversariisque\b', 'adversarius'),
    (r'\badversariisque\b', 'adversaria'),
    (r'\badversario\b', 'adversarius'),
    (r'\badversariorum\b', 'adversarius'),
    (r'\badversariorum\b', 'adversaria'),
    (r'\badversariorumque\b', 'adversarius'),
    (r'\badversariorumque\b', 'adversaria'),
    (r'\badversarios\b', 'adversarius'),
    (r'\badversariosque\b', 'adversarius'),
    (r'\badversaris\b', 'adverso'),
    (r'\badversarium\b', 'adversarius'),
    (r'\badversarium\b', 'adversaria'),
    (r'\badversariumne\b', 'adversarius'),
    (r'\badversariumne\b', 'adversaria'),
    (r'\badversarius\b', 'adversarius'),
    (r'\badversarum\b', 'adversaria'),
    (r'\badversarum\b', 'adverro'),
    (r'\badversarumque\b', 'adversaria'),
    (r'\badversarumque\b', 'adverro'),
    (r'\badversas\b', 'adversaria'),
    (r'\badversas\b', 'adverro'),
    (r'\badversas\b', 'adverso'),
    (r'\badversasque\b', 'adversaria'),
    (r'\badversasque\b', 'adverro'),
    (r'\badversasque\b', 'adverso'),
    (r'\badversata\b', 'adverso'),
    (r'\badversatae\b', 'adverso'),
    (r'\badversatam\b', 'adverso'),
    (r'\badversatrix\b', 'adversatrix'),
    (r'\badversatum\b', 'adverso'),
    (r'\badversatur\b', 'adverso'),
    (r'\badversatus\b', 'adverso'),
    (r'\badversatust\b', 'adverso'),
    (r'\badversavi\b', 'adverso'),
    (r'\badversentur\b', 'adverso'),
    (r'\badversere\b', 'adverso'),
    (r'\badverseris\b', 'adverso'),
    (r'\badversetur\b', 'adverso'),
    (r'\badversi\b', 'adversus'),
    (r'\badversi\b', 'adversus'),
    (r'\badversi\b', 'adverro'),
    (r'\badversis\b', 'adversaria'),
    (r'\badversis\b', 'adversus'),
    (r'\badversis\b', 'adversus'),
    (r'\badversis\b', 'adverro'),
    (r'\badversisque\b', 'adversaria'),
    (r'\badversisque\b', 'adversus'),
    (r'\badversisque\b', 'adversus'),
    (r'\badversisque\b', 'adverro'),
    (r'\badversissima\b', 'adverro'),
    (r'\badversissimam\b', 'adverro'),
    (r'\badversissimi\b', 'adverro'),
    (r'\badversitatem\b', 'adversitas'),
    (r'\badversius\b', 'adverro'),
    (r'\badverso\b', 'adversus'),
    (r'\badverso\b', 'adversus'),
    (r'\badverso\b', 'adverro'),
    (r'\badverso\b', 'adverso'),
    (r'\badversor\b', 'adverso'),
    (r'\badversorum\b', 'adversus'),
    (r'\badversorum\b', 'adversus'),
    (r'\badversorum\b', 'adverro'),
    (r'\badversos\b', 'adversus'),
    (r'\badversos\b', 'adverro'),
    (r'\badversosque\b', 'adversus'),
    (r'\badversosque\b', 'adverro'),
    (r'\badversum\b', 'adversus'),
    (r'\badversum\b', 'adversus'),
    (r'\badversum\b', 'adversus'),
    (r'\badversum\b', 'adverro'),
    (r'\badversus\b', 'adversus2'),
    (r'\badversus\b', 'adversus'),
    (r'\badversus\b', 'adverro'),
    (r'\badversusque\b', 'adversus2'),
    (r'\badversusque\b', 'adversus'),
    (r'\badversusque\b', 'adverro'),
    (r'\badvertam\b', 'adverto'),
    (r'\badvertantur\b', 'adverto'),
    (r'\badvertas\b', 'adverto'),
    (r'\badvertatis\b', 'adverto'),
    (r'\badvertatur\b', 'adverto'),
    (r'\badverte\b', 'adverto'),
    (r'\badvertebant\b', 'adverto'),
    (r'\badvertebat\b', 'adverto'),
    (r'\badvertebatis\b', 'adverto'),
    (r'\badvertebatur\b', 'adverto'),
    (r'\badvertemus\b', 'adverto'),
    (r'\badvertenda\b', 'adverto'),
    (r'\badvertendum\b', 'adverto'),
    (r'\badvertens\b', 'adverto'),
    (r'\badverteram\b', 'adverto'),
    (r'\badverteramus\b', 'adverto'),
    (r'\badverterat\b', 'adverto'),
    (r'\badvertere\b', 'adverto'),
    (r'\badverterent\b', 'adverto'),
    (r'\badverteret\b', 'adverto'),
    (r'\badverteretur\b', 'adverto'),
    (r'\badverterimus\b', 'adverto'),
    (r'\badverteris\b', 'adverto'),
    (r'\badverterit\b', 'adverto'),
    (r'\badverterunt\b', 'adverto'),
    (r'\badverti\b', 'adverto'),
    (r'\badvertimus\b', 'adverto'),
    (r'\badvertisse\b', 'adverto'),
    (r'\badvertissent\b', 'adverto'),
    (r'\badvertisset\b', 'adverto'),
    (r'\badvertit\b', 'adverto'),
    (r'\badvertite\b', 'adverto'),
    (r'\badvertitis\b', 'adverto'),
    (r'\badvertitque\b', 'adverto'),
    (r'\badvertitur\b', 'adverto'),
    (r'\badverto\b', 'adverto'),
    (r'\badvertunt\b', 'adverto'),
    (r'\badvexerant\b', 'adveho'),
    (r'\badvexerat\b', 'adveho'),
    (r'\badvexerit\b', 'adveho'),
    (r'\badvexi\b', 'adveho'),
    (r'\badvexisse\b', 'adveho'),
    (r'\badvexissent\b', 'adveho'),
    (r'\badvexisset\b', 'adveho'),
    (r'\badvexit\b', 'adveho'),
    (r'\badvigila\b', 'advigilo'),
    (r'\badvigilamus\b', 'advigilo'),
    (r'\badvigilare\b', 'advigilo'),
    (r'\badvigilaveris\b', 'advigilo'),
    (r'\badviverent\b', 'advivo'),
    (r'\badviveret\b', 'advivo'),
    (r'\badvixerit\b', 'advivo'),
    (r'\badvoca\b', 'advoco'),
    (r'\badvocabant\b', 'advoco'),
    (r'\badvocabat\b', 'advoco'),
    (r'\badvocabit\b', 'advoco'),
    (r'\badvocabo\b', 'advoco'),
    (r'\badvocamus\b', 'advoco'),
    (r'\badvocandam\b', 'advoco'),
    (r'\badvocandi\b', 'advoco'),
    (r'\badvocans\b', 'advoco'),
    (r'\badvocant\b', 'advoco'),
    (r'\badvocantem\b', 'advoco'),
    (r'\badvocantur\b', 'advoco'),
    (r'\badvocare\b', 'advoco'),
    (r'\badvocarent\b', 'advoco'),
    (r'\badvocares\b', 'advoco'),
    (r'\badvocaret\b', 'advoco'),
    (r'\badvocari\b', 'advoco'),
    (r'\badvocas\b', 'advoco'),
    (r'\badvocasse\b', 'advoco'),
    (r'\badvocassent\b', 'advoco'),
    (r'\badvocasti\b', 'advoco'),
    (r'\badvocat\b', 'advoco'),
    (r'\badvocata\b', 'advoco'),
    (r'\badvocatam\b', 'advoco'),
    (r'\badvocati\b', 'advocatus'),
    (r'\badvocati\b', 'advoco'),
    (r'\badvocatio\b', 'advocatio'),
    (r'\badvocatione\b', 'advocatio'),
    (r'\badvocationem\b', 'advocatio'),
    (r'\badvocationemque\b', 'advocatio'),
    (r'\badvocationes\b', 'advocatio'),
    (r'\badvocationi\b', 'advocatio'),
    (r'\badvocationibus\b', 'advocatio'),
    (r'\badvocationis\b', 'advocatio'),
    (r'\badvocationum\b', 'advocatio'),
    (r'\badvocatique\b', 'advocatus'),
    (r'\badvocatique\b', 'advoco'),
    (r'\badvocatis\b', 'advocatus'),
    (r'\badvocatis\b', 'advoco'),
    (r'\badvocatisque\b', 'advocatus'),
    (r'\badvocatisque\b', 'advoco'),
    (r'\badvocato\b', 'advoco'),
    (r'\badvocato\b', 'advocatus'),
    (r'\badvocatorum\b', 'advocator'),
    (r'\badvocatorum\b', 'advoco'),
    (r'\badvocatos\b', 'advocatus'),
    (r'\badvocatos\b', 'advoco'),
    (r'\badvocatu\b', 'advoco'),
    (r'\badvocatum\b', 'advocatus'),
    (r'\badvocatum\b', 'advoco'),
    (r'\badvocatur\b', 'advoco'),
    (r'\badvocaturus\b', 'advoco'),
    (r'\badvocatus\b', 'advocatus'),
    (r'\badvocatus\b', 'advoco'),
    (r'\badvocaveram\b', 'advoco'),
    (r'\badvocaverat\b', 'advoco'),
    (r'\badvocavere\b', 'advoco'),
    (r'\badvocaverit\b', 'advoco'),
    (r'\badvocavi\b', 'advoco'),
    (r'\badvocavisti\b', 'advoco'),
    (r'\badvocavit\b', 'advoco'),
    (r'\badvocemus\b', 'advoco'),
    (r'\badvoceris\b', 'advoco'),
    (r'\badvoces\b', 'advoco'),
    (r'\badvocet\b', 'advoco'),
    (r'\badvocetur\b', 'advoco'),
    (r'\badvoco\b', 'advoco'),
    (r'\badvocor\b', 'advoco'),
    (r'\badvola\b', 'advolo'),
    (r'\badvolabat\b', 'advolo'),
    (r'\badvolabis\b', 'advolo'),
    (r'\badvolabit\b', 'advolo'),
    (r'\badvolans\b', 'advolo'),
    (r'\badvolant\b', 'advolo'),
    (r'\badvolantem\b', 'advolo'),
    (r'\badvolarat\b', 'advolo'),
    (r'\badvolare\b', 'advolo'),
    (r'\badvolarent\b', 'advolo'),
    (r'\badvolaret\b', 'advolo'),
    (r'\badvolaris\b', 'advolo'),
    (r'\badvolas\b', 'advolo'),
    (r'\badvolasse\b', 'advolo'),
    (r'\badvolassent\b', 'advolo'),
    (r'\badvolasti\b', 'advolo'),
    (r'\badvolat\b', 'advolo'),
    (r'\badvolatu\b', 'advolatus'),
    (r'\badvolatu\b', 'advolo'),
    (r'\badvolaturam\b', 'advolo'),
    (r'\badvolaturas\b', 'advolo'),
    (r'\badvolaturus\b', 'advolo'),
    (r'\badvolaverint\b', 'advolo'),
    (r'\badvolaverunt\b', 'advolo'),
    (r'\badvolavisse\b', 'advolo'),
    (r'\badvolavit\b', 'advolo'),
    (r'\badvolem\b', 'advolo'),
    (r'\badvoles\b', 'advolo'),
    (r'\badvolet\b', 'advolo'),
    (r'\badvolitans\b', 'advolo'),
    (r'\badvolone\b', 'advolo'),
    (r'\badvoluta\b', 'advolvo'),
    (r'\badvoluta\b', 'advolvo'),
    (r'\badvoluti\b', 'advolvo'),
    (r'\badvolutum\b', 'advolvo'),
    (r'\badvolutus\b', 'advolvo'),
    (r'\badvolvebantur\b', 'advolvo'),
    (r'\badvolveretur\b', 'advolvo'),
    (r'\badvolveris\b', 'advolvo'),
    (r'\badvolvi\b', 'advolvo'),
    (r'\badvolvimur\b', 'advolvo'),
    (r'\badvolvit\b', 'advolvo'),
    (r'\badvolvitur\b', 'advolvo'),
    (r'\badvolvuntur\b', 'advolvo'),
    (r'\badvorsa\b', 'adverto'),
    (r'\badvorsa\b', 'adverso'),
    (r'\badvorsabar\b', 'adverso'),
    (r'\badvorsabor\b', 'adverso'),
    (r'\badvorsae\b', 'adverto'),
    (r'\badvorsam\b', 'adverto'),
    (r'\badvorsaretur\b', 'adverso'),
    (r'\badvorsari\b', 'adverso'),
    (r'\badvorsarier\b', 'adverso'),
    (r'\badvorsarum\b', 'adverto'),
    (r'\badvorsas\b', 'adverto'),
    (r'\badvorsas\b', 'adverso'),
    (r'\badvorsatrix\b', 'adversatrix'),
    (r'\badvorsatur\b', 'adverso'),
    (r'\badvorser\b', 'adverso'),
    (r'\badvorsi\b', 'adverto'),
    (r'\badvorsis\b', 'adverto'),
    (r'\badvorsitores\b', 'adversitor'),
    (r'\badvorso\b', 'adverto'),
    (r'\badvorso\b', 'adverso'),
    (r'\badvorsor\b', 'adverso'),
    (r'\badvorsos\b', 'adverto'),
    (r'\badvorsu\b', 'adverto'),
    (r'\badvorsum\b', 'adverto'),
    (r'\badvorsumne\b', 'adverto'),
    (r'\badvorsuros\b', 'adverto'),
    (r'\badvorsus\b', 'adversus2'),
    (r'\badvortam\b', 'adverto'),
    (r'\badvortas\b', 'adverto'),
    (r'\badvorte\b', 'adverto'),
    (r'\badvortenda\b', 'adverto'),
    (r'\badvortendum\b', 'adverto'),
    (r'\badvorteram\b', 'adverto'),
    (r'\badvorterat\b', 'adverto'),
    (r'\badvortere\b', 'adverto'),
    (r'\badvorterim\b', 'adverto'),
    (r'\badvortes\b', 'adverto'),
    (r'\badvortetis\b', 'adverto'),
    (r'\badvorti\b', 'adverto'),
    (r'\badvortis\b', 'adverto'),
    (r'\badvortit\b', 'adverto'),
    (r'\badvortite\b', 'adverto'),
    (r'\badvortitis\b', 'adverto'),
    (r'\badvortito\b', 'adverto'),
    (r'\badvorto\b', 'adverto'),
    (r'\badvortunt\b', 'adverto'),
    (r'\badyta\b', 'adytum'),
    (r'\badyti\b', 'adytum'),
    (r'\badytis\b', 'adytum'),
    (r'\badytisque\b', 'adytum'),
    (r'\badyto\b', 'adytum'),
    (r'\badytum\b', 'adytum'),
    (r'\badzelabor\b', 'adzelor'),
    (r'\bAea\b', 'Aea'),
    (r'\bAeace\b', 'Aeacus'),
    (r'\bAeaci\b', 'Aeacus'),
    (r'\bAeaci\b', 'Aeacius'),
    (r'\bAeacida\b', 'Aeacides'),
    (r'\bAeacidae\b', 'Aeacides'),
    (r'\bAeacidarum\b', 'Aeacides'),
    (r'\bAeacidas\b', 'Aeacides'),
    (r'\bAeacide\b', 'Aeacides'),
    (r'\bAeacideia\b', 'Aeacideius'),
    (r'\bAeaciden\b', 'Aeacides'),
    (r'\bAeacides\b', 'Aeacides'),
    (r'\bAeacidinis\b', 'Aeacidinus'),
    (r'\bAeacidis\b', 'Aeacides'),
    (r'\bAeacii\b', 'Aeacius'),
    (r'\bAeacius\b', 'Aeacius'),
    (r'\bAeaco\b', 'Aeacus'),
    (r'\bAeacon\b', 'Aeacus'),
    (r'\bAeacum\b', 'Aeacus'),
    (r'\bAeacus\b', 'Aeacus'),
    (r'\bAeaea\b', 'Aeaea'),
    (r'\bAeaea\b', 'Aeaeus'),
    (r'\bAeaeae\b', 'Aeaea'),
    (r'\bAeaeaeque\b', 'Aeaea'),
    (r'\bAeaeam\b', 'Aeaea'),
    (r'\bAeaeaque\b', 'Aeaea'),
    (r'\bAeaeaque\b', 'Aeaeus'),
    (r'\bAeaee\b', 'Aeaeus'),
    (r'\bAeaei\b', 'Aeaeus'),
    (r'\bAeaeis\b', 'Aeaea'),
    (r'\bAeaeis\b', 'Aeaeus'),
    (r'\bAeaeo\b', 'Aeaeus'),
    (r'\bAeaeos\b', 'Aeaeus'),
    (r'\bAeaeum\b', 'Aeaeus'),
    (r'\bAeaeus\b', 'Aeaeus'),
    (r'\bAean\b', 'Aea'),
    (r'\bAean\b', 'Aeas'),
    (r'\baean\b', 'a-eo1'),
    (r'\bAeantem\b', 'Aeas'),
    (r'\bAeanti\b', 'Aeas'),
    (r'\bAeas\b', 'Aea'),
    (r'\bAeas\b', 'Aeas'),
    (r'\baeas\b', 'a-eo1'),
    (r'\bAebura\b', 'Aebura'),
    (r'\bAeburam\b', 'Aebura'),
    (r'\bAebuti\b', 'Aebutius'),
    (r'\bAebutia\b', 'Aebutius'),
    (r'\bAebutiae\b', 'Aebutius'),
    (r'\bAebutiam\b', 'Aebutius'),
    (r'\bAebutii\b', 'Aebutius'),
    (r'\bAebutio\b', 'Aebutius'),
    (r'\bAebutium\b', 'Aebutius'),
    (r'\bAebutius\b', 'Aebutius'),
    (r'\bAecae\b', 'Aecae'),
    (r'\baecae\b', 'aequus'),
    (r'\baeci\b', 'aequus'),
    (r'\baeco\b', 'aequus'),
    (r'\baecorum\b', 'aequus'),
    (r'\bAeculani\b', 'Aeculanum'),
    (r'\bAeculani\b', 'Aeculanum'),
    (r'\bAeculanum\b', 'Aeculanum'),
    (r'\bAeculanum\b', 'Aeculanum'),
    (r'\baecum\b', 'aequus'),
    (r'\baecumst\b', 'aequus'),
    (r'\baecus\b', 'aequus'),
    (r'\baedatur\b', 'aedes'),
    (r'\baede\b', 'aedes'),
    (r'\baedem\b', 'aedes'),
    (r'\baedemque\b', 'aedes'),
    (r'\baedes\b', 'aedes'),
    (r'\baedesque\b', 'aedes'),
    (r'\baedi\b', 'aedes'),
    (r'\baedibus\b', 'aedes'),
    (r'\baedibusque\b', 'aedes'),
    (r'\baedibust\b', 'aedes'),
    (r'\baedicas\b', 'aedicula'),
    (r'\baedicula\b', 'aedicula'),
    (r'\baediculae\b', 'aedicula'),
    (r'\baediculam\b', 'aedicula'),
    (r'\baedicularum\b', 'aedicula'),
    (r'\baediculas\b', 'aedicula'),
    (r'\baediculis\b', 'aedicula'),
    (r'\baedifica\b', 'aedifico'),
    (r'\baedificabant\b', 'aedifico'),
    (r'\baedificabat\b', 'aedifico'),
    (r'\baedificabatur\b', 'aedifico'),
    (r'\baedificaberis\b', 'aedifico'),
    (r'\baedificabimini\b', 'aedifico'),
    (r'\baedificabimus\b', 'aedifico'),
    (r'\baedificabis\b', 'aedifico'),
    (r'\baedificabit\b', 'aedifico'),
    (r'\baedificabitis\b', 'aedifico'),
    (r'\baedificabitur\b', 'aedifico'),
    (r'\baedificabo\b', 'aedifico'),
    (r'\baedificabunt\b', 'aedifico'),
    (r'\baedificabuntur\b', 'aedifico'),
    (r'\baedificamus\b', 'aedifico'),
    (r'\baedificanda\b', 'aedifico'),
    (r'\baedificandae\b', 'aedifico'),
    (r'\baedificandam\b', 'aedifico'),
    (r'\baedificandamque\b', 'aedifico'),
    (r'\baedificandas\b', 'aedifico'),
    (r'\baedificandi\b', 'aedifico'),
    (r'\baedificandis\b', 'aedifico'),
    (r'\baedificando\b', 'aedifico'),
    (r'\baedificandum\b', 'aedifico'),
    (r'\baedificans\b', 'aedifico'),
    (r'\baedificant\b', 'aedifico'),
    (r'\baedificante\b', 'aedifico'),
    (r'\baedificantem\b', 'aedifico'),
    (r'\baedificantes\b', 'aedifico'),
    (r'\baedificanti\b', 'aedifico'),
    (r'\baedificantibus\b', 'aedifico'),
    (r'\baedificantis\b', 'aedifico'),
    (r'\baedificantium\b', 'aedifico'),
    (r'\baedificantur\b', 'aedifico'),
    (r'\baedificarat\b', 'aedifico'),
    (r'\baedificare\b', 'aedifico'),
    (r'\baedificarem\b', 'aedifico'),
    (r'\baedificaremus\b', 'aedifico'),
    (r'\baedificarent\b', 'aedifico'),
    (r'\baedificares\b', 'aedifico'),
    (r'\baedificaret\b', 'aedifico'),
    (r'\baedificaretis\b', 'aedifico'),
    (r'\baedificaretur\b', 'aedifico'),
    (r'\baedificari\b', 'aedifico'),
    (r'\baedificarim\b', 'aedifico'),
    (r'\baedificarintne\b', 'aedifico'),
    (r'\baedificaris\b', 'aedifico'),
    (r'\baedificarit\b', 'aedifico'),
    (r'\baedificarunt\b', 'aedifico'),
    (r'\baedificas\b', 'aedifico'),
    (r'\baedificasse\b', 'aedifico'),
    (r'\baedificassem\b', 'aedifico'),
    (r'\baedificassemus\b', 'aedifico'),
    (r'\baedificasset\b', 'aedifico'),
    (r'\baedificasti\b', 'aedifico'),
    (r'\baedificastis\b', 'aedifico'),
    (r'\baedificat\b', 'aedifico'),
    (r'\baedificata\b', 'aedifico'),
    (r'\baedificatae\b', 'aedifico'),
    (r'\baedificatam\b', 'aedifico'),
    (r'\baedificatas\b', 'aedifico'),
    (r'\baedificate\b', 'aedifico'),
    (r'\baedificati\b', 'aedifico'),
    (r'\baedificatio\b', 'aedificatio'),
    (r'\baedificatione\b', 'aedificatio'),
    (r'\baedificationem\b', 'aedificatio'),
    (r'\baedificationemque\b', 'aedificatio'),
    (r'\baedificationes\b', 'aedificatio'),
    (r'\baedificationi\b', 'aedificatio'),
    (r'\baedificationibus\b', 'aedificatio'),
    (r'\baedificationis\b', 'aedificatio'),
    (r'\baedificationum\b', 'aedificatio'),
    (r'\baedificatis\b', 'aedifico'),
    (r'\baedificatiuncula\b', 'aedificatiuncula'),
    (r'\baedificato\b', 'aedifico'),
    (r'\baedificator\b', 'aedificator'),
    (r'\baedificatore\b', 'aedificator'),
    (r'\baedificatoremque\b', 'aedificator'),
    (r'\baedificatores\b', 'aedificator'),
    (r'\baedificatori\b', 'aedificator'),
    (r'\baedificatori\b', 'aedificatorius'),
    (r'\baedificatoribus\b', 'aedificator'),
    (r'\baedificatoris\b', 'aedificator'),
    (r'\baedificatum\b', 'aedifico'),
    (r'\baedificatur\b', 'aedifico'),
    (r'\baedificaturum\b', 'aedifico'),
    (r'\baedificaturus\b', 'aedifico'),
    (r'\baedificatus\b', 'aedifico'),
    (r'\baedificaueras\b', 'aedifico'),
    (r'\baedificauerat\b', 'aedifico'),
    (r'\baedificauerim\b', 'aedifico'),
    (r'\baedificauerint\b', 'aedifico'),
    (r'\baedificaueris\b', 'aedifico'),
    (r'\baedificauerit\b', 'aedifico'),
    (r'\baedificauero\b', 'aedifico'),
    (r'\baedificaui\b', 'aedifico'),
    (r'\baedificauit\b', 'aedifico'),
    (r'\baedificauitque\b', 'aedifico'),
    (r'\baedificaverat\b', 'aedifico'),
    (r'\baedificavere\b', 'aedifico'),
    (r'\baedificaverint\b', 'aedifico'),
    (r'\baedificaveris\b', 'aedifico'),
    (r'\baedificaverit\b', 'aedifico'),
    (r'\baedificaveritis\b', 'aedifico'),
    (r'\baedificaverunt\b', 'aedifico'),
    (r'\baedificaveruntque\b', 'aedifico'),
    (r'\baedificavi\b', 'aedifico'),
    (r'\baedificavimus\b', 'aedifico'),
    (r'\baedificavisse\b', 'aedifico'),
    (r'\baedificavit\b', 'aedifico'),
    (r'\baedificavitque\b', 'aedifico'),
    (r'\baedificem\b', 'aedifico'),
    (r'\baedificemus\b', 'aedifico'),
    (r'\baedificent\b', 'aedifico'),
    (r'\baedificentur\b', 'aedifico'),
    (r'\baedifices\b', 'aedifico'),
    (r'\baedificet\b', 'aedifico'),
    (r'\baedificetis\b', 'aedifico'),
    (r'\baedificetur\b', 'aedifico'),
    (r'\baedificia\b', 'aedificium'),
    (r'\baedificiaque\b', 'aedificium'),
    (r'\baedificii\b', 'aedificium'),
    (r'\baedificiis\b', 'aedificium'),
    (r'\baedificiisque\b', 'aedificium'),
    (r'\baedificiisve\b', 'aedificium'),
    (r'\baedificio\b', 'aedificium'),
    (r'\baedificiorum\b', 'aedificium'),
    (r'\baedificiorumque\b', 'aedificium'),
    (r'\baedificioue\b', 'aedificium'),
    (r'\baedificium\b', 'aedificium'),
    (r'\baedificiumue\b', 'aedificium'),
    (r'\baedifico\b', 'aedifico'),
    (r'\baedile\b', 'aedilis'),
    (r'\baedilem\b', 'aedilis'),
    (r'\baedilemque\b', 'aedilis'),
    (r'\baediles\b', 'aedilis'),
    (r'\baedilesque\b', 'aedilis'),
    (r'\baedili\b', 'aedilis'),
    (r'\baedilibus\b', 'aedilis'),
    (r'\baedilicii\b', 'aedilicius'),
    (r'\baediliciis\b', 'aedilicius'),
    (r'\baedilicio\b', 'aedilicius'),
    (r'\baedilicios\b', 'aedilicius'),
    (r'\baedilicium\b', 'aedilicius'),
    (r'\baedilicius\b', 'aedilicius'),
    (r'\baedilis\b', 'aedilis'),
    (r'\baedilitas\b', 'aedilitas'),
    (r'\baedilitate\b', 'aedilitas'),
    (r'\baedilitatem\b', 'aedilitas'),
    (r'\baedilitates\b', 'aedilitas'),
    (r'\baedilitati\b', 'aedilitas'),
    (r'\baedilitatibus\b', 'aedilitas'),
    (r'\baedilitatis\b', 'aedilitas'),
    (r'\baedilitatum\b', 'aedilitas'),
    (r'\baedilium\b', 'aedilis'),
    (r'\baedis\b', 'aedes'),
    (r'\baedisque\b', 'aedes'),
    (r'\baeditimo\b', 'aeditimus'),
    (r'\baeditimus\b', 'aeditimus'),
    (r'\baeditu\b', 'aedes'),
    (r'\baedituentes\b', 'aedituens'),
    (r'\baeditui\b', 'aedituus'),
    (r'\baedituis\b', 'aeditua'),
    (r'\baedituis\b', 'aedituus'),
    (r'\baeditumor\b', 'aedituus'),
    (r'\baedituo\b', 'aedituus'),
    (r'\baedituorum\b', 'aedituus'),
    (r'\baedituos\b', 'aedituus'),
    (r'\baedituum\b', 'aedituus'),
    (r'\baedituus\b', 'aedituus'),
    (r'\baedon\b', 'aedon'),
    (r'\baedone\b', 'aedon'),
    (r'\baedonia\b', 'aedonius'),
    (r'\bAedui\b', 'Aedui'),
    (r'\bAeduis\b', 'Aedui'),
    (r'\bAeduisque\b', 'Aedui'),
    (r'\bAeduorum\b', 'Aedui'),
    (r'\bAeduos\b', 'Aedui'),
    (r'\bAeeta\b', 'Aeetes'),
    (r'\bAeetae\b', 'Aeetes'),
    (r'\bAeetam\b', 'Aeetes'),
    (r'\bAeetas\b', 'Aeetes'),
    (r'\bAeeten\b', 'Aeetes'),
    (r'\bAeetes\b', 'Aeetes'),
    (r'\bAeetia\b', 'Aegae'),
    (r'\bAeetias\b', 'Aegae'),
    (r'\bAeetine\b', 'Aegae'),
    (r'\bAeetis\b', 'Aeetes'),
    (r'\bAeetius\b', 'Aegae'),
    (r'\bAegae\b', 'Aegae'),
    (r'\bAegaea\b', 'Aegaeus'),
    (r'\bAegaeae\b', 'Aegaeus'),
    (r'\bAegaeaque\b', 'Aegaeus'),
    (r'\bAegaeas\b', 'Aegaeus'),
    (r'\bAegaei\b', 'Aegaeus'),
    (r'\bAegaeis\b', 'Aegaeus'),
    (r'\bAegaeo\b', 'Aegaeus'),
    (r'\bAegaeon\b', 'Aegaeus'),
    (r'\bAegaeos\b', 'Aegaeus'),
    (r'\bAegaeum\b', 'Aegaeus'),
    (r'\bAegaeumque\b', 'Aegaeus'),
    (r'\bAegaeus\b', 'Aegaeus'),
    (r'\bAegas\b', 'Aegae'),
    (r'\bAegates\b', 'Aegates'),
    (r'\baege\b', 'aeger'),
    (r'\bAegea\b', 'a-egero'),
    (r'\bAegea\b', 'Aegeus2'),
    (r'\bAegeas\b', 'Aegeus2'),
    (r'\baegeas\b', 'aeger'),
    (r'\bAegei\b', 'a-egero'),
    (r'\bAegei\b', 'Aegeus2'),
    (r'\bAegeo\b', 'a-egero'),
    (r'\bAegeo\b', 'Aegeus2'),
    (r'\baegeo\b', 'aeger'),
    (r'\bAegeos\b', 'a-egero'),
    (r'\baeger\b', 'aeger'),
    (r'\baegerque\b', 'aeger'),
    (r'\baegerrima\b', 'aeger'),
    (r'\baegerrimam\b', 'aeger'),
    (r'\baegerrime\b', 'aeger'),
    (r'\baegerrimusque\b', 'aeger'),
    (r'\baegesta\b', 'a-egero'),
    (r'\bAegeu\b', 'a-egero'),
    (r'\bAegeum\b', 'a-egero'),
    (r'\bAegeum\b', 'Aegeus2'),
    (r'\bAegeus\b', 'a-egero'),
    (r'\bAegi\b', 'Aegle'),
    (r'\bAegi\b', 'Aegium'),
    (r'\baegi\b', 'a-aro'),
    (r'\bAegia\b', 'Aegle'),
    (r'\bAegia\b', 'Aegium'),
    (r'\bAegiale\b', 'Aegiale'),
    (r'\bAegialeo\b', 'Aegialeus'),
    (r'\bAegialeon\b', 'Aegialeus'),
    (r'\bAegialeus\b', 'Aegialeus'),
    (r'\bAegidae\b', 'Aegides'),
    (r'\bAegidas\b', 'Aegides'),
    (r'\baegide\b', 'aegis'),
    (r'\bAegide\b', 'Aegides'),
    (r'\baegiden\b', 'aegis'),
    (r'\bAegiden\b', 'Aegides'),
    (r'\baegides\b', 'aegis'),
    (r'\bAegides\b', 'Aegides'),
    (r'\baegidis\b', 'aegis'),
    (r'\bAegiensibus\b', 'Aegienses'),
    (r'\bAegiensis\b', 'Aegienses'),
    (r'\bAegiensium\b', 'Aegienses'),
    (r'\bAegii\b', 'Aegle'),
    (r'\bAegii\b', 'Aegium'),
    (r'\bAegiis\b', 'Aegle'),
    (r'\bAegiis\b', 'Aegium'),
    (r'\baegilopa\b', 'aegilopa'),
    (r'\baegilopas\b', 'aegilopa'),
    (r'\baegilopia\b', 'aegilopium'),
    (r'\baegilopiis\b', 'aegilopium'),
    (r'\baegilopis\b', 'aegilopa'),
    (r'\bAegimuro\b', 'Aegimurus'),
    (r'\bAegimurum\b', 'Aegimurus'),
    (r'\bAegina\b', 'Aegina'),
    (r'\bAeginae\b', 'Aegina'),
    (r'\bAeginaeque\b', 'Aegina'),
    (r'\bAeginam\b', 'Aegina'),
    (r'\bAeginan\b', 'Aegina'),
    (r'\bAeginensium\b', 'Aeginiensis'),
    (r'\bAeginetae\b', 'Aeginiensis'),
    (r'\bAeginetica\b', 'Aeginiensis'),
    (r'\bAeginetici\b', 'Aeginiensis'),
    (r'\bAeginetico\b', 'Aeginiensis'),
    (r'\bAegineticum\b', 'Aeginiensis'),
    (r'\bAeginetis\b', 'Aeginiensis'),
    (r'\bAeginiensibus\b', 'Aeginiensis'),
    (r'\bAeginiensium\b', 'Aeginiensis'),
    (r'\bAeginium\b', 'Aeginium'),
    (r'\bAegio\b', 'Aegle'),
    (r'\bAegio\b', 'Aegium'),
    (r'\bAegion\b', 'Aegle'),
    (r'\bAegion\b', 'Aegium'),
    (r'\bAegira\b', 'Aegira'),
    (r'\baegis\b', 'aegis'),
    (r'\baegisono\b', 'aegisonus'),
    (r'\bAegisthe\b', 'Aegisthus'),
    (r'\bAegisthi\b', 'Aegisthus'),
    (r'\bAegistho\b', 'Aegisthus'),
    (r'\bAegisthum\b', 'Aegisthus'),
    (r'\bAegisthumque\b', 'Aegisthus'),
    (r'\bAegisthus\b', 'Aegisthus'),
    (r'\baegithum\b', 'aegithus'),
    (r'\baegithus\b', 'aegithus'),
    (r'\bAegium\b', 'Aegle'),
    (r'\bAegium\b', 'Aegium'),
    (r'\bAegle\b', 'Aegle'),
    (r'\bAeglen\b', 'Aegle'),
    (r'\baegoceri\b', 'aegoceros'),
    (r'\baegocero\b', 'aegoceros'),
    (r'\baegoceron\b', 'aegoceros'),
    (r'\baegoceros\b', 'aegoceros'),
    (r'\baegocerotis\b', 'aegoceros'),
    (r'\baegolethron\b', 'aegolethron'),
    (r'\bAegon\b', 'Aegon'),
    (r'\bAegonis\b', 'Aegon'),
    (r'\baegophthalmos\b', 'aegophthalmos'),
    (r'\baegra\b', 'aeger'),
    (r'\baegrae\b', 'aeger'),
    (r'\baegram\b', 'aeger'),
    (r'\baegramque\b', 'aeger'),
    (r'\baegraque\b', 'aeger'),
    (r'\baegrarum\b', 'aeger'),
    (r'\baegras\b', 'aeger'),
    (r'\baegrast\b', 'aeger'),
    (r'\baegre\b', 'aeger'),
    (r'\baegre\b', 'aegreo'),
    (r'\baegreque\b', 'aeger'),
    (r'\baegreque\b', 'aegreo'),
    (r'\baegrescente\b', 'aegresco'),
    (r'\baegrescere\b', 'aegresco'),
    (r'\baegresceret\b', 'aegresco'),
    (r'\baegrescimus\b', 'aegresco'),
    (r'\baegrescit\b', 'aegresco'),
    (r'\baegrescitque\b', 'aegresco'),
    (r'\baegrescunt\b', 'aegresco'),
    (r'\baegrest\b', 'aeger'),
    (r'\baegrest\b', 'aegreo'),
    (r'\baegret\b', 'aegreo'),
    (r'\baegri\b', 'aeger'),
    (r'\baegrimonia\b', 'aegrimonia'),
    (r'\baegrimoniae\b', 'aegrimonia'),
    (r'\baegrine\b', 'aeger'),
    (r'\baegrique\b', 'aeger'),
    (r'\baegris\b', 'aeger'),
    (r'\baegrisque\b', 'aeger'),
    (r'\bAegritomari\b', 'aegritudo'),
    (r'\baegritudine\b', 'aegritudo'),
    (r'\baegritudinem\b', 'aegritudo'),
    (r'\baegritudinemque\b', 'aegritudo'),
    (r'\baegritudinemve\b', 'aegritudo'),
    (r'\baegritudines\b', 'aegritudo'),
    (r'\baegritudinesque\b', 'aegritudo'),
    (r'\baegritudini\b', 'aegritudo'),
    (r'\baegritudinis\b', 'aegritudo'),
    (r'\baegritudinum\b', 'aegritudo'),
    (r'\baegritudinumst\b', 'aegritudo'),
    (r'\baegritudo\b', 'aegritudo'),
    (r'\baegrius\b', 'aeger'),
    (r'\baegriusque\b', 'aeger'),
    (r'\baegro\b', 'aeger'),
    (r'\baegroque\b', 'aeger'),
    (r'\baegror\b', 'aegror'),
    (r'\baegrorum\b', 'aeger'),
    (r'\baegros\b', 'aeger'),
    (r'\baegrota\b', 'aegrotus'),
    (r'\baegrota\b', 'aegroto'),
    (r'\baegrotabat\b', 'aegroto'),
    (r'\baegrotabis\b', 'aegroto'),
    (r'\baegrotae\b', 'aegrotus'),
    (r'\baegrotam\b', 'aegrotus'),
    (r'\baegrotamus\b', 'aegroto'),
    (r'\baegrotando\b', 'aegroto'),
    (r'\baegrotandum\b', 'aegroto'),
    (r'\baegrotans\b', 'aegroto'),
    (r'\baegrotant\b', 'aegroto'),
    (r'\baegrotante\b', 'aegroto'),
    (r'\baegrotantem\b', 'aegroto'),
    (r'\baegrotantes\b', 'aegroto'),
    (r'\baegrotanti\b', 'aegroto'),
    (r'\baegrotantibus\b', 'aegroto'),
    (r'\baegrotantis\b', 'aegroto'),
    (r'\baegrotantium\b', 'aegroto'),
    (r'\baegrotare\b', 'aegroto'),
    (r'\baegrotaret\b', 'aegroto'),
    (r'\baegrotas\b', 'aegrotus'),
    (r'\baegrotas\b', 'aegroto'),
    (r'\baegrotasse\b', 'aegroto'),
    (r'\baegrotasset\b', 'aegroto'),
    (r'\baegrotasti\b', 'aegroto'),
    (r'\baegrotat\b', 'aegroto'),
    (r'\baegrotatio\b', 'aegrotatio'),
    (r'\baegrotatione\b', 'aegrotatio'),
    (r'\baegrotationem\b', 'aegrotatio'),
    (r'\baegrotationes\b', 'aegrotatio'),
    (r'\baegrotationesque\b', 'aegrotatio'),
    (r'\baegrotationi\b', 'aegrotatio'),
    (r'\baegrotationibusque\b', 'aegrotatio'),
    (r'\baegrotationis\b', 'aegrotatio'),
    (r'\baegrotationum\b', 'aegrotatio'),
    (r'\baegrotaverit\b', 'aegroto'),
    (r'\baegrotavi\b', 'aegroto'),
    (r'\baegrotavit\b', 'aegroto'),
    (r'\baegrotent\b', 'aegroto'),
    (r'\baegrotes\b', 'aegroto'),
    (r'\baegrotet\b', 'aegroto'),
    (r'\baegroti\b', 'aegrotus'),
    (r'\baegrotis\b', 'aegrotus'),
    (r'\baegroto\b', 'aegrotus'),
    (r'\baegroto\b', 'aegroto'),
    (r'\baegrotos\b', 'aegrotus'),
    (r'\baegrotum\b', 'aegrotus'),
    (r'\baegrotus\b', 'aegrotus'),
    (r'\baegrum\b', 'aeger'),
    (r'\baegrumque\b', 'aeger'),
    (r'\baegrumue\b', 'aeger'),
    (r'\bAegypta\b', 'Aegyptiacus'),
    (r'\bAegyptam\b', 'Aegyptiacus'),
    (r'\bAegypte\b', 'Aegyptus1'),
    (r'\bAegypte\b', 'Aegyptus2'),
    (r'\bAegypti\b', 'Aegyptus1'),
    (r'\bAegypti\b', 'Aegyptus2'),
    (r'\bAegypti\b', 'Aegyptius'),
    (r'\bAegyptia\b', 'Aegyptius'),
    (r'\bAegyptiacae\b', 'Aegyptiacus'),
    (r'\bAegyptiaci\b', 'Aegyptiacus'),
    (r'\bAegyptiacis\b', 'Aegyptiacus'),
    (r'\bAegyptiacorum\b', 'Aegyptiacus'),
    (r'\bAegyptiacos\b', 'Aegyptiacus'),
    (r'\bAegyptiacus\b', 'Aegyptiacus'),
    (r'\bAegyptiae\b', 'Aegyptius'),
    (r'\bAegyptiam\b', 'Aegyptius'),
    (r'\bAegyptias\b', 'Aegyptius'),
    (r'\bAegyptii\b', 'Aegyptius'),
    (r'\bAegyptiis\b', 'Aegyptius'),
    (r'\bAegyptiisque\b', 'Aegyptius'),
    (r'\baegyptilla\b', 'aegyptilla'),
    (r'\baegyptillam\b', 'aegyptilla'),
    (r'\bAegyptio\b', 'Aegyptius'),
    (r'\bAegyptiorum\b', 'Aegyptius'),
    (r'\bAegyptiorumque\b', 'Aegyptius'),
    (r'\bAegyptios\b', 'Aegyptius'),
    (r'\bAegyptiosque\b', 'Aegyptius'),
    (r'\bAegyptique\b', 'Aegyptus1'),
    (r'\bAegyptique\b', 'Aegyptus2'),
    (r'\bAegyptique\b', 'Aegyptius'),
    (r'\bAegyptium\b', 'Aegyptius'),
    (r'\bAegyptius\b', 'Aegyptius'),
    (r'\bAegypto\b', 'Aegyptus1'),
    (r'\bAegypto\b', 'Aegyptus2'),
    (r'\bAegypton\b', 'Aegyptus1'),
    (r'\bAegypton\b', 'Aegyptus2'),
    (r'\bAegyptoque\b', 'Aegyptus1'),
    (r'\bAegyptoque\b', 'Aegyptus2'),
    (r'\bAegyptos\b', 'Aegyptus1'),
    (r'\bAegyptos\b', 'Aegyptus2'),
    (r'\bAegyptum\b', 'Aegyptus1'),
    (r'\bAegyptum\b', 'Aegyptus2'),
    (r'\bAegyptumque\b', 'Aegyptus1'),
    (r'\bAegyptumque\b', 'Aegyptus2'),
    (r'\bAegyptus\b', 'Aegyptus1'),
    (r'\bAegyptus\b', 'Aegyptus2'),
    (r'\bAeli\b', 'Aelius'),
    (r'\bAelia\b', 'Aelianus'),
    (r'\bAeliae\b', 'Aelianus'),
    (r'\bAeliam\b', 'Aelianus'),
    (r'\bAeliana\b', 'Aelianus'),
    (r'\bAelianas\b', 'Aelianus'),
    (r'\bAeliani\b', 'Aelianus'),
    (r'\bAeliano\b', 'Aelianus'),
    (r'\bAelianum\b', 'Aelianus'),
    (r'\bAelianus\b', 'Aelianus'),
    (r'\bAelias\b', 'Aelianus'),
    (r'\bAelii\b', 'Aelius'),
    (r'\bAeliis\b', 'Aelianus'),
    (r'\bAeliis\b', 'Aelius'),
    (r'\baelinon\b', 'aelinos'),
    (r'\bAelio\b', 'Aelius'),
    (r'\bAeliorum\b', 'Aelius'),
    (r'\bAelium\b', 'Aelius'),
    (r'\bAelius\b', 'Aelius'),
    (r'\bAello\b', 'Aello'),
    (r'\baeluro\b', 'aelurus'),
    (r'\baelurorum\b', 'aelurus'),
    (r'\baeluros\b', 'aelurus'),
    (r'\bAemili\b', 'Aemilius'),
    (r'\bAemilia\b', 'Aemilius'),
    (r'\bAemiliae\b', 'Aemilius'),
    (r'\bAemiliaeque\b', 'Aemilius'),
    (r'\bAemiliam\b', 'Aemilius'),
    (r'\bAemiliana\b', 'Aemilianus'),
    (r'\bAemiliane\b', 'Aemilianus'),
    (r'\bAemiliani\b', 'Aemilianus'),
    (r'\bAemilianis\b', 'Aemilianus'),
    (r'\bAemiliano\b', 'Aemilianus'),
    (r'\bAemilianos\b', 'Aemilianus'),
    (r'\bAemilianum\b', 'Aemilianus'),
    (r'\bAemilianus\b', 'Aemilianus'),
    (r'\bAemilii\b', 'Aemilius'),
    (r'\bAemiliis\b', 'Aemilius'),
    (r'\bAemilio\b', 'Aemilius'),
    (r'\bAemilioque\b', 'Aemilius'),
    (r'\bAemiliorum\b', 'Aemilius'),
    (r'\bAemilios\b', 'Aemilius'),
    (r'\bAemilium\b', 'Aemilius'),
    (r'\bAemilius\b', 'Aemilius'),
    (r'\baemin\b', 'a-emo'),
    (r'\baemula\b', 'aemulus'),
    (r'\baemula\b', 'aemulo'),
    (r'\baemulabantur\b', 'aemulo'),
    (r'\baemulabatur\b', 'aemulo'),
    (r'\baemulabitur\b', 'aemulo'),
    (r'\baemulae\b', 'aemulus'),
    (r'\baemulam\b', 'aemulus'),
    (r'\baemulamini\b', 'aemulo'),
    (r'\baemulamur\b', 'aemulo'),
    (r'\baemulandas\b', 'aemulo'),
    (r'\baemulandi\b', 'aemulo'),
    (r'\baemulando\b', 'aemulo'),
    (r'\baemulandos\b', 'aemulo'),
    (r'\baemulandum\b', 'aemulo'),
    (r'\baemulante\b', 'aemulo'),
    (r'\baemulantes\b', 'aemulo'),
    (r'\baemulantis\b', 'aemulo'),
    (r'\baemulantium\b', 'aemulo'),
    (r'\baemulantur\b', 'aemulo'),
    (r'\baemulaque\b', 'aemulus'),
    (r'\baemulaque\b', 'aemulo'),
    (r'\baemulare\b', 'aemulo'),
    (r'\baemularentur\b', 'aemulo'),
    (r'\baemularer\b', 'aemulo'),
    (r'\baemularetur\b', 'aemulo'),
    (r'\baemulari\b', 'aemulo'),
    (r'\baemularique\b', 'aemulo'),
    (r'\baemularis\b', 'aemulo'),
    (r'\baemulas\b', 'aemulus'),
    (r'\baemulas\b', 'aemulo'),
    (r'\baemulata\b', 'aemulo'),
    (r'\baemulataque\b', 'aemulo'),
    (r'\baemulati\b', 'aemulo'),
    (r'\baemulatio\b', 'aemulatio'),
    (r'\baemulatione\b', 'aemulatio'),
    (r'\baemulationem\b', 'aemulatio'),
    (r'\baemulationes\b', 'aemulatio'),
    (r'\baemulationi\b', 'aemulatio'),
    (r'\baemulationis\b', 'aemulatio'),
    (r'\baemulationisque\b', 'aemulatio'),
    (r'\baemulationum\b', 'aemulatio'),
    (r'\baemulator\b', 'aemulator'),
    (r'\baemulatorem\b', 'aemulator'),
    (r'\baemulatores\b', 'aemulator'),
    (r'\baemulatori\b', 'aemulator'),
    (r'\baemulatorque\b', 'aemulator'),
    (r'\baemulatur\b', 'aemulo'),
    (r'\baemulaturque\b', 'aemulo'),
    (r'\baemulatus\b', 'aemulatus'),
    (r'\baemulatus\b', 'aemulo'),
    (r'\baemulaueris\b', 'aemulo'),
    (r'\baemulemini\b', 'aemulo'),
    (r'\baemulemur\b', 'aemulo'),
    (r'\baemulentur\b', 'aemulo'),
    (r'\baemuleris\b', 'aemulo'),
    (r'\baemuletur\b', 'aemulo'),
    (r'\baemuli\b', 'aemulus'),
    (r'\baemulis\b', 'aemulus'),
    (r'\baemulo\b', 'aemulus'),
    (r'\baemulo\b', 'aemulo'),
    (r'\baemulor\b', 'aemulo'),
    (r'\baemulorum\b', 'aemulus'),
    (r'\baemulos\b', 'aemulus'),
    (r'\baemulum\b', 'aemulus'),
    (r'\baemulumque\b', 'aemulus'),
    (r'\baemulus\b', 'aemulus'),
    (r'\bAen\b', 'a-eo1'),
    (r'\baen\b', 'aedon'),
    (r'\baena\b', 'aenus3'),
    (r'\baenae\b', 'aenus3'),
    (r'\baenare\b', 'a-eno'),
    (r'\bAenaria\b', 'Aenaria'),
    (r'\bAenariam\b', 'Aenaria'),
    (r'\baenatorum\b', 'a-eno'),
    (r'\bAenea\b', 'Aenea2'),
    (r'\bAenea\b', 'Aeneas'),
    (r'\baenea\b', 'aeneus'),
    (r'\bAeneadae\b', 'Aeneades'),
    (r'\bAeneadas\b', 'Aeneades'),
    (r'\bAeneadasque\b', 'Aeneades'),
    (r'\bAeneade\b', 'Aeneades'),
    (r'\bAeneaden\b', 'Aeneades'),
    (r'\bAeneades\b', 'Aeneades'),
    (r'\bAeneadis\b', 'Aeneades'),
    (r'\bAeneae\b', 'Aenea2'),
    (r'\baeneae\b', 'aeneus'),
    (r'\bAeneae\b', 'Aeneas'),
    (r'\bAeneaeque\b', 'Aenea2'),
    (r'\baeneaeque\b', 'aeneus'),
    (r'\bAeneaeque\b', 'Aeneas'),
    (r'\bAeneam\b', 'Aenea2'),
    (r'\baeneam\b', 'aeneus'),
    (r'\bAeneam\b', 'Aeneas'),
    (r'\baenean\b', 'aeneus'),
    (r'\bAenean\b', 'Aeneas'),
    (r'\baeneaque\b', 'aeneus'),
    (r'\bAeneas\b', 'Aenea2'),
    (r'\baeneas\b', 'aeneus'),
    (r'\bAeneas\b', 'Aeneas'),
    (r'\baeneasque\b', 'aeneus'),
    (r'\baeneatores\b', 'aeneator'),
    (r'\baeneatoribus\b', 'aeneator'),
    (r'\baenei\b', 'aeneus'),
    (r'\bAeneia\b', 'Aeneius'),
    (r'\bAeneiaque\b', 'Aeneius'),
    (r'\bAeneide\b', 'Aeneis'),
    (r'\bAeneidem\b', 'Aeneis'),
    (r'\baeneidem\b', 'aeneus'),
    (r'\bAeneidis\b', 'Aeneis'),
    (r'\bAeneis\b', 'Aenea2'),
    (r'\bAeneis\b', 'Aeneis'),
    (r'\bAeneis\b', 'Aeneas'),
    (r'\baeneis\b', 'aeneus'),
    (r'\baeneisque\b', 'aeneus'),
    (r'\baeneo\b', 'aeneus'),
    (r'\baeneolo\b', 'aeneolus'),
    (r'\baeneolosque\b', 'aeneolus'),
    (r'\baeneorum\b', 'aeneus'),
    (r'\baeneos\b', 'aeneus'),
    (r'\bAenesi\b', 'Aenesi'),
    (r'\baeneum\b', 'aeneus'),
    (r'\baeneumque\b', 'aeneus'),
    (r'\baeneus\b', 'aeneus'),
    (r'\bAeni\b', 'Aenus1'),
    (r'\bAeni\b', 'Aenus2'),
    (r'\baeni\b', 'aenus3'),
    (r'\bAeniam\b', 'Aenea2'),
    (r'\bAenianes\b', 'Aenianes'),
    (r'\bAenianum\b', 'Aenianes'),
    (r'\bAenidae\b', 'Aenides'),
    (r'\bAenide\b', 'Aenides'),
    (r'\baenigma\b', 'aenigma'),
    (r'\baenigmata\b', 'aenigma'),
    (r'\baenigmate\b', 'aenigma'),
    (r'\baenigmatis\b', 'aenigma'),
    (r'\baeniorum\b', 'aenus3'),
    (r'\bAeniorum\b', 'Aenii'),
    (r'\bAenios\b', 'Aenii'),
    (r'\baenis\b', 'aenus3'),
    (r'\bAeno\b', 'Aenus1'),
    (r'\bAeno\b', 'Aenus2'),
    (r'\baeno\b', 'aenus3'),
    (r'\bAenobarbum\b', 'a-eno'),
    (r'\bAenon\b', 'Aenus1'),
    (r'\bAenon\b', 'Aenus2'),
    (r'\baenon\b', 'aenus3'),
    (r'\bAenos\b', 'Aenus1'),
    (r'\bAenos\b', 'Aenus2'),
    (r'\baenos\b', 'aenus3'),
    (r'\baens\b', 'a-sum1'),
    (r'\baenulum\b', 'aenulum'),
    (r'\bAenum\b', 'Aenus1'),
    (r'\bAenum\b', 'Aenus2'),
    (r'\baenum\b', 'aenus3'),
    (r'\baenumque\b', 'aenus3'),
    (r'\bAenus\b', 'Aenus1'),
    (r'\bAenus\b', 'Aenus2'),
    (r'\baenus\b', 'aenus3'),
    (r'\baeo\b', 'a-eo1'),
    (r'\bAeole\b', 'Aeolus'),
    (r'\bAeoli\b', 'Aeolus'),
    (r'\bAeoli\b', 'Aeolius'),
    (r'\bAeolia\b', 'Aeolia'),
    (r'\bAeolia\b', 'Aeolius'),
    (r'\bAeoliae\b', 'Aeolia'),
    (r'\bAeoliam\b', 'Aeolia'),
    (r'\bAeoliamque\b', 'Aeolia'),
    (r'\bAeolias\b', 'Aeolia'),
    (r'\bAeolica\b', 'Aeolicus'),
    (r'\bAeolicae\b', 'Aeolicus'),
    (r'\bAeolicam\b', 'Aeolicus'),
    (r'\bAeolicarum\b', 'Aeolicus'),
    (r'\bAeolici\b', 'Aeolicus'),
    (r'\bAeolicum\b', 'Aeolicus'),
    (r'\bAeolicus\b', 'Aeolicus'),
    (r'\bAeolida\b', 'Aeolides'),
    (r'\bAeolidae\b', 'Aeolides'),
    (r'\bAeolide\b', 'Aeolis1'),
    (r'\bAeolide\b', 'Aeolides'),
    (r'\bAeolidem\b', 'Aeolis1'),
    (r'\bAeoliden\b', 'Aeolides'),
    (r'\bAeolides\b', 'Aeolis1'),
    (r'\bAeolides\b', 'Aeolides'),
    (r'\bAeolidis\b', 'Aeolis1'),
    (r'\bAeolidis\b', 'Aeolides'),
    (r'\bAeolii\b', 'Aeolii'),
    (r'\bAeolii\b', 'Aeolius'),
    (r'\bAeoliique\b', 'Aeolii'),
    (r'\bAeoliique\b', 'Aeolius'),
    (r'\bAeoliis\b', 'Aeolia'),
    (r'\bAeoliis\b', 'Aeolii'),
    (r'\bAeoliis\b', 'Aeolius'),
    (r'\bAeolio\b', 'Aeolius'),
    (r'\bAeolion\b', 'Aeolii'),
    (r'\bAeolion\b', 'Aeolius'),
    (r'\bAeolios\b', 'Aeolii'),
    (r'\bAeolis\b', 'Aeolis1'),
    (r'\bAeolis\b', 'Aeolus'),
    (r'\bAeolium\b', 'Aeolii'),
    (r'\bAeolium\b', 'Aeolius'),
    (r'\bAeolius\b', 'Aeolius'),
    (r'\bAeolo\b', 'Aeolus'),
    (r'\bAeolon\b', 'Aeolus'),
    (r'\bAeolorum\b', 'Aeolus'),
    (r'\bAeolum\b', 'Aeolus'),
    (r'\bAeolum\b', 'a-eo1'),
    (r'\bAeolus\b', 'Aeolus'),
    (r'\baeones\b', 'aeon'),
    (r'\baequa\b', 'aequus'),
    (r'\baequa\b', 'aequus'),
    (r'\baequa\b', 'aequo'),
    (r'\baequabant\b', 'aequo'),
    (r'\baequabantur\b', 'aequo'),
    (r'\baequabat\b', 'aequo'),
    (r'\baequabatur\b', 'aequo'),
    (r'\baequabile\b', 'aequabilis'),
    (r'\baequabilem\b', 'aequabilis'),
    (r'\baequabiles\b', 'aequabilis'),
    (r'\baequabilesque\b', 'aequabilis'),
    (r'\baequabili\b', 'aequabilis'),
    (r'\baequabilior\b', 'aequabilis'),
    (r'\baequabilis\b', 'aequabilis'),
    (r'\baequabilitas\b', 'aequabilitas'),
    (r'\baequabilitate\b', 'aequabilitas'),
    (r'\baequabilitatem\b', 'aequabilitas'),
    (r'\baequabilitatis\b', 'aequabilitas'),
    (r'\baequabiliter\b', 'aequabilis'),
    (r'\baequabiliter\b', 'aequabiliter'),
    (r'\baequabilius\b', 'aequabilis'),
    (r'\baequabis\b', 'aequo'),
    (r'\baequabit\b', 'aequo'),
    (r'\baequabitis\b', 'aequo'),
    (r'\baequabitque\b', 'aequo'),
    (r'\baequabitur\b', 'aequo'),
    (r'\baequabo\b', 'aequo'),
    (r'\baequabunt\b', 'aequo'),
    (r'\baequae\b', 'aequus'),
    (r'\baequaeua\b', 'aequaevus'),
    (r'\baequaeuam\b', 'aequaevus'),
    (r'\baequaeue\b', 'aequaevus'),
    (r'\baequaeue\b', 'aequus'),
    (r'\baequaeui\b', 'aequaevus'),
    (r'\baequaeuo\b', 'aequaevus'),
    (r'\baequaeuum\b', 'aequaevus'),
    (r'\baequaeuumque\b', 'aequaevus'),
    (r'\baequaeuus\b', 'aequaevus'),
    (r'\baequaeva\b', 'aequaevus'),
    (r'\baequaevamque\b', 'aequaevus'),
    (r'\baequaevo\b', 'aequaevus'),
    (r'\baequaevum\b', 'aequaevus'),
    (r'\baequale\b', 'aequalis'),
    (r'\baequalem\b', 'aequalis'),
    (r'\baequales\b', 'aequalis'),
    (r'\baequalesque\b', 'aequalis'),
    (r'\baequalest\b', 'aequalis'),
    (r'\baequali\b', 'aequalis'),
    (r'\baequalia\b', 'aequalis'),
    (r'\baequalibus\b', 'aequalis'),
    (r'\baequalibusque\b', 'aequalis'),
    (r'\baequalior\b', 'aequalis'),
    (r'\baequaliorque\b', 'aequalis'),
    (r'\baequalique\b', 'aequalis'),
    (r'\baequalis\b', 'aequalis'),
    (r'\baequalisque\b', 'aequalis'),
    (r'\baequalitas\b', 'aequalitas'),
    (r'\baequalitate\b', 'aequalitas'),
    (r'\baequalitatem\b', 'aequalitas'),
    (r'\baequalitatemque\b', 'aequalitas'),
    (r'\baequalitatibus\b', 'aequalitas'),
    (r'\baequalitatis\b', 'aequalitas'),
    (r'\baequaliter\b', 'aequalis'),
    (r'\baequaliter\b', 'aequaliter'),
    (r'\baequaliterque\b', 'aequalis'),
    (r'\baequaliterque\b', 'aequaliter'),
    (r'\baequalium\b', 'aequalis'),
    (r'\baequalius\b', 'aequalis'),
    (r'\baequam\b', 'aequus'),
    (r'\baequamen\b', 'aequamen'),
    (r'\baequamque\b', 'aequus'),
    (r'\baequamur\b', 'aequo'),
    (r'\bAequana\b', 'Aequana'),
    (r'\baequanda\b', 'aequo'),
    (r'\baequandae\b', 'aequo'),
    (r'\baequandam\b', 'aequo'),
    (r'\baequandaque\b', 'aequo'),
    (r'\baequandarum\b', 'aequo'),
    (r'\baequandas\b', 'aequo'),
    (r'\baequandi\b', 'aequo'),
    (r'\baequando\b', 'aequo'),
    (r'\baequandum\b', 'aequo'),
    (r'\baequandus\b', 'aequo'),
    (r'\baequane\b', 'aequus'),
    (r'\baequane\b', 'aequus'),
    (r'\baequane\b', 'aequo'),
    (r'\baequanimitas\b', 'aequanimitas'),
    (r'\baequanimitate\b', 'aequanimitas'),
    (r'\baequanimitatem\b', 'aequanimitas'),
    (r'\baequanimitatis\b', 'aequanimitas'),
    (r'\baequanimiter\b', 'aequanimiter'),
    (r'\baequant\b', 'aequo'),
    (r'\baequante\b', 'aequo'),
    (r'\baequantem\b', 'aequo'),
    (r'\baequantes\b', 'aequo'),
    (r'\baequantia\b', 'aequo'),
    (r'\baequantibus\b', 'aequo'),
    (r'\baequantis\b', 'aequo'),
    (r'\baequantiumque\b', 'aequo'),
    (r'\baequantur\b', 'aequo'),
    (r'\bAequanum\b', 'Aequana'),
    (r'\baequaque\b', 'aequus'),
    (r'\baequaque\b', 'aequus'),
    (r'\baequaque\b', 'aequo'),
    (r'\baequarat\b', 'aequo'),
    (r'\baequare\b', 'aequo'),
    (r'\baequarent\b', 'aequo'),
    (r'\baequarentur\b', 'aequo'),
    (r'\baequares\b', 'aequo'),
    (r'\baequaret\b', 'aequo'),
    (r'\baequaretque\b', 'aequo'),
    (r'\baequaretur\b', 'aequo'),
    (r'\baequari\b', 'aequo'),
    (r'\baequarint\b', 'aequo'),
    (r'\baequarit\b', 'aequo'),
    (r'\baequarum\b', 'aequus'),
    (r'\baequarunt\b', 'aequo'),
    (r'\baequas\b', 'aequus'),
    (r'\baequas\b', 'aequo'),
    (r'\baequasse\b', 'aequo'),
    (r'\baequassem\b', 'aequo'),
    (r'\baequassent\b', 'aequo'),
    (r'\baequasset\b', 'aequo'),
    (r'\baequasti\b', 'aequo'),
    (r'\baequat\b', 'aequo'),
    (r'\baequata\b', 'aequo'),
    (r'\baequatae\b', 'aequo'),
    (r'\baequatam\b', 'aequo'),
    (r'\baequataque\b', 'aequo'),
    (r'\baequatas\b', 'aequo'),
    (r'\baequate\b', 'aequo'),
    (r'\baequati\b', 'aequo'),
    (r'\baequatio\b', 'aequatio'),
    (r'\baequationem\b', 'aequatio'),
    (r'\baequatique\b', 'aequo'),
    (r'\baequatis\b', 'aequo'),
    (r'\baequatisque\b', 'aequo'),
    (r'\baequato\b', 'aequo'),
    (r'\baequatoque\b', 'aequo'),
    (r'\baequatos\b', 'aequo'),
    (r'\baequatque\b', 'aequo'),
    (r'\baequatum\b', 'aequo'),
    (r'\baequatumque\b', 'aequo'),
    (r'\baequatur\b', 'aequo'),
    (r'\baequatura\b', 'aequo'),
    (r'\baequaturi\b', 'aequo'),
    (r'\baequaturum\b', 'aequo'),
    (r'\baequaturusque\b', 'aequo'),
    (r'\baequatus\b', 'aequo'),
    (r'\baequauerant\b', 'aequo'),
    (r'\baequauerat\b', 'aequo'),
    (r'\baequauerint\b', 'aequo'),
    (r'\baequaueris\b', 'aequo'),
    (r'\baequauerit\b', 'aequo'),
    (r'\baequaueritis\b', 'aequo'),
    (r'\baequauerunt\b', 'aequo'),
    (r'\baequaui\b', 'aequo'),
    (r'\baequauisse\b', 'aequo'),
    (r'\baequauit\b', 'aequo'),
    (r'\baequaverat\b', 'aequo'),
    (r'\baequavere\b', 'aequo'),
    (r'\baequaverint\b', 'aequo'),
    (r'\baequaverit\b', 'aequo'),
    (r'\baequavimus\b', 'aequo'),
    (r'\baequavit\b', 'aequo'),
    (r'\baeque\b', 'aequus'),
    (r'\baeque\b', 'aeque'),
    (r'\baeque\b', 'aequus'),
    (r'\baequem\b', 'aequo'),
    (r'\baequemus\b', 'aequo'),
    (r'\baequent\b', 'aequo'),
    (r'\baequentur\b', 'aequo'),
    (r'\baequeque\b', 'aequus'),
    (r'\baequeque\b', 'aeque'),
    (r'\baequeque\b', 'aequus'),
    (r'\baequest\b', 'aequus'),
    (r'\baequest\b', 'aeque'),
    (r'\baequest\b', 'aequus'),
    (r'\baequet\b', 'aequo'),
    (r'\baequetur\b', 'aequo'),
    (r'\bAequi\b', 'Aequi'),
    (r'\baequi\b', 'aequus'),
    (r'\baequi\b', 'aequus'),
    (r'\bAequicula\b', 'Aequicus'),
    (r'\bAequiculam\b', 'Aequicus'),
    (r'\bAequiculis\b', 'Aequicus'),
    (r'\bAequiculos\b', 'Aequicus'),
    (r'\bAequiculus\b', 'Aequicus'),
    (r'\bAequicum\b', 'Aequicus'),
    (r'\baequicumque\b', 'aequus'),
    (r'\bAequicumque\b', 'Aequicus'),
    (r'\baequicumque\b', 'aequus'),
    (r'\baequidianis\b', 'aequidianus'),
    (r'\baequilatatio\b', 'aequilatatio'),
    (r'\baequilibres\b', 'aequilibris'),
    (r'\baequilibrio\b', 'aequilibrium'),
    (r'\baequilibritatem\b', 'aequilibritas'),
    (r'\baequilibrium\b', 'aequilibris'),
    (r'\baequilibrium\b', 'aequilibrium'),
    (r'\bAequimaelio\b', 'Aequimaelium'),
    (r'\bAequimaelium\b', 'Aequimaelium'),
    (r'\bAequimelium\b', 'Aequimaelium'),
    (r'\bAequine\b', 'Aequi'),
    (r'\baequine\b', 'aequus'),
    (r'\baequine\b', 'aequus'),
    (r'\baequinoctia\b', 'aequinoctium'),
    (r'\baequinoctialem\b', 'aequinoctialis'),
    (r'\baequinoctiales\b', 'aequinoctialis'),
    (r'\baequinoctiali\b', 'aequinoctialis'),
    (r'\baequinoctialibus\b', 'aequinoctialis'),
    (r'\baequinoctialis\b', 'aequinoctialis'),
    (r'\baequinoctialium\b', 'aequinoctialis'),
    (r'\baequinoctii\b', 'aequinoctium'),
    (r'\baequinoctiis\b', 'aequinoctium'),
    (r'\baequinoctio\b', 'aequinoctium'),
    (r'\baequinoctium\b', 'aequinoctium'),
    (r'\baequior\b', 'aequus'),
    (r'\baequiora\b', 'aequus'),
    (r'\baequiore\b', 'aequus'),
    (r'\baequiorem\b', 'aequus'),
    (r'\baequiores\b', 'aequus'),
    (r'\baequiori\b', 'aequus'),
    (r'\baequioribus\b', 'aequus'),
    (r'\baequiorisque\b', 'aequus'),
    (r'\baequiparabile\b', 'aequiparabilis'),
    (r'\baequiparatur\b', 'aequiparo'),
    (r'\baequipedum\b', 'aequipedus'),
    (r'\baequiperabiles\b', 'aequiparabilis'),
    (r'\baequiperabilia\b', 'aequiparabilis'),
    (r'\baequiperatio\b', 'aequiparatio'),
    (r'\baequiperatione\b', 'aequiparatio'),
    (r'\baequipondii\b', 'aequipondium'),
    (r'\baequipondium\b', 'aequipondium'),
    (r'\bAequique\b', 'Aequi'),
    (r'\baequique\b', 'aequus'),
    (r'\baequique\b', 'aequus'),
    (r'\baequis\b', 'aequus'),
    (r'\bAequis\b', 'Aequi'),
    (r'\baequis\b', 'aequus'),
    (r'\baequisque\b', 'aequus'),
    (r'\bAequisque\b', 'Aequi'),
    (r'\baequisque\b', 'aequus'),
    (r'\baequissima\b', 'aequus'),
    (r'\baequissimam\b', 'aequus'),
    (r'\baequissimas\b', 'aequus'),
    (r'\baequissime\b', 'aequus'),
    (r'\baequissimis\b', 'aequus'),
    (r'\baequissimo\b', 'aequus'),
    (r'\baequissimos\b', 'aequus'),
    (r'\baequissimum\b', 'aequus'),
    (r'\baequissimumst\b', 'aequus'),
    (r'\baequissimumve\b', 'aequus'),
    (r'\baequissimus\b', 'aequus'),
    (r'\baequissumi\b', 'aequus'),
    (r'\baequissumum\b', 'aequus'),
    (r'\baequitas\b', 'aequitas'),
    (r'\baequitat\b', 'aequitas'),
    (r'\baequitate\b', 'aequitas'),
    (r'\baequitatem\b', 'aequitas'),
    (r'\baequitatemque\b', 'aequitas'),
    (r'\baequitates\b', 'aequitas'),
    (r'\baequitati\b', 'aequitas'),
    (r'\baequitatibus\b', 'aequitas'),
    (r'\baequitatis\b', 'aequitas'),
    (r'\baequitatisque\b', 'aequitas'),
    (r'\baequiter\b', 'aequiter'),
    (r'\baequiter\b', 'aequitas'),
    (r'\baequitum\b', 'a-equio'),
    (r'\baequius\b', 'aequus'),
    (r'\baequiusne\b', 'aequus'),
    (r'\baequiust\b', 'aequus'),
    (r'\baequo\b', 'aequus'),
    (r'\baequo\b', 'aequus'),
    (r'\baequo\b', 'aequo'),
    (r'\baequom\b', 'aequus'),
    (r'\baequom\b', 'aequus'),
    (r'\baequomque\b', 'aequus'),
    (r'\baequomque\b', 'aequus'),
    (r'\baequomst\b', 'aequus'),
    (r'\baequomst\b', 'aequus'),
    (r'\baequone\b', 'aequus'),
    (r'\baequone\b', 'aequus'),
    (r'\baequone\b', 'aequo'),
    (r'\baequoque\b', 'aequus'),
    (r'\baequoque\b', 'aequus'),
    (r'\baequoque\b', 'aequo'),
    (r'\baequor\b', 'aequor'),
    (r'\baequor\b', 'aequo'),
    (r'\baequora\b', 'aequor'),
    (r'\baequoraque\b', 'aequor'),
    (r'\baequore\b', 'aequor'),
    (r'\baequorea\b', 'aequoreus'),
    (r'\baequoreae\b', 'aequoreus'),
    (r'\baequoreaeque\b', 'aequoreus'),
    (r'\baequoream\b', 'aequoreus'),
    (r'\baequoreas\b', 'aequoreus'),
    (r'\baequoreasque\b', 'aequoreus'),
    (r'\baequorei\b', 'aequoreus'),
    (r'\baequoreis\b', 'aequoreus'),
    (r'\baequoreo\b', 'aequoreus'),
    (r'\baequoreos\b', 'aequoreus'),
    (r'\baequoreosque\b', 'aequoreus'),
    (r'\baequoreum\b', 'aequoreus'),
    (r'\baequoreus\b', 'aequoreus'),
    (r'\baequoreusque\b', 'aequoreus'),
    (r'\baequori\b', 'aequor'),
    (r'\baequoribus\b', 'aequor'),
    (r'\baequoribusque\b', 'aequor'),
    (r'\baequoris\b', 'aequor'),
    (r'\baequorque\b', 'aequor'),
    (r'\baequorque\b', 'aequo'),
    (r'\bAequorum\b', 'Aequi'),
    (r'\baequorum\b', 'aequus'),
    (r'\baequorum\b', 'aequor'),
    (r'\bAequorumque\b', 'Aequi'),
    (r'\baequorumque\b', 'aequus'),
    (r'\baequorumque\b', 'aequor'),
    (r'\bAequos\b', 'Aequi'),
    (r'\baequos\b', 'aequus'),
    (r'\bAequosque\b', 'Aequi'),
    (r'\baequosque\b', 'aequus'),
    (r'\bAequum\b', 'Aequi'),
    (r'\baequum\b', 'aequus'),
    (r'\baequum\b', 'aequus'),
    (r'\bAequumne\b', 'Aequi'),
    (r'\baequumne\b', 'aequus'),
    (r'\baequumne\b', 'aequus'),
    (r'\baequumque\b', 'aequus'),
    (r'\baequumque\b', 'aequus'),
    (r'\baequumst\b', 'aequus'),
    (r'\baequumst\b', 'aequus'),
    (r'\baequus\b', 'aequus'),
    (r'\baequusque\b', 'aequus'),
    (r'\baequusue\b', 'aequus'),
    (r'\baer\b', 'aer'),
    (r'\baera\b', 'aera'),
    (r'\baerae\b', 'aera'),
    (r'\baeram\b', 'aera'),
    (r'\baeramenta\b', 'aeramentum'),
    (r'\baeramentis\b', 'aeramentum'),
    (r'\baeramento\b', 'aeramentum'),
    (r'\baeramentorum\b', 'aeramentum'),
    (r'\baeramentum\b', 'aeramentum'),
    (r'\baerane\b', 'aera'),
    (r'\baeraque\b', 'aera'),
    (r'\baerari\b', 'aerarius'),
    (r'\baeraria\b', 'aeraria'),
    (r'\baeraria\b', 'aerarius'),
    (r'\baerariae\b', 'aeraria'),
    (r'\baerariam\b', 'aeraria'),
    (r'\baerarias\b', 'aeraria'),
    (r'\baerarii\b', 'aerarius'),
    (r'\baerarii\b', 'aerarius'),
    (r'\baerariis\b', 'aeraria'),
    (r'\baerariis\b', 'aerarius'),
    (r'\baerariis\b', 'aerarius'),
    (r'\baerario\b', 'aerarius'),
    (r'\baerario\b', 'aerarius'),
    (r'\baerariorum\b', 'aerarius'),
    (r'\baerariorum\b', 'aerarius'),
    (r'\baerarios\b', 'aerarius'),
    (r'\baerarium\b', 'aerarius'),
    (r'\baerarium\b', 'aerarius'),
    (r'\baerariumque\b', 'aerarius'),
    (r'\baerariumque\b', 'aerarius'),
    (r'\baerarius\b', 'aerarius'),
    (r'\baerata\b', 'aeratus'),
    (r'\baeratae\b', 'aeratus'),
    (r'\baerataeque\b', 'aeratus'),
    (r'\baeratam\b', 'aeratus'),
    (r'\baeratas\b', 'aeratus'),
    (r'\baeratasque\b', 'aeratus'),
    (r'\baerati\b', 'aeratus'),
    (r'\baeratis\b', 'aeratus'),
    (r'\baerato\b', 'aeratus'),
    (r'\baeratos\b', 'aeratus'),
    (r'\baeratus\b', 'aeratus'),
    (r'\baere\b', 'aer'),
    (r'\baerea\b', 'aereus1'),
    (r'\baerea\b', 'aereus1'),
    (r'\baereae\b', 'aereus1'),
    (r'\baeream\b', 'aereus1'),
    (r'\baereaque\b', 'aereus1'),
    (r'\baereaque\b', 'aereus1'),
    (r'\baerearumque\b', 'aereus1'),
    (r'\baereas\b', 'aereus1'),
    (r'\baerei\b', 'aereus1'),
    (r'\baerei\b', 'aereus1'),
    (r'\baereis\b', 'aereus1'),
    (r'\baereis\b', 'aereus1'),
    (r'\baereis\b', 'aereus1'),
    (r'\baerem\b', 'aer'),
    (r'\baereo\b', 'aereus1'),
    (r'\baereo\b', 'aereus1'),
    (r'\baereos\b', 'aereus1'),
    (r'\baereque\b', 'aer'),
    (r'\baereum\b', 'aereus1'),
    (r'\baereum\b', 'aereus1'),
    (r'\baereum\b', 'aereus1'),
    (r'\baereus\b', 'aereus1'),
    (r'\baeri\b', 'aer'),
    (r'\baeri\b', 'aerius'),
    (r'\baeria\b', 'aerius'),
    (r'\baeriae\b', 'aerius'),
    (r'\baeriaeque\b', 'aerius'),
    (r'\baeriam\b', 'aerius'),
    (r'\baeriamque\b', 'aerius'),
    (r'\baerias\b', 'aerius'),
    (r'\baeriasque\b', 'aerius'),
    (r'\baeribus\b', 'aer'),
    (r'\baeriferae\b', 'aerifer'),
    (r'\baerifice\b', 'aerifice'),
    (r'\baerii\b', 'aerius'),
    (r'\baeriis\b', 'aerius'),
    (r'\baerina\b', 'aerinus'),
    (r'\baerinis\b', 'aerinus'),
    (r'\baerio\b', 'aerius'),
    (r'\baerion\b', 'aerius'),
    (r'\baerios\b', 'aerius'),
    (r'\baeripedem\b', 'aeripes'),
    (r'\baerique\b', 'aer'),
    (r'\baerique\b', 'aerius'),
    (r'\baeris\b', 'aera'),
    (r'\baeris\b', 'aer'),
    (r'\baerisona\b', 'aerisonus'),
    (r'\baerisoni\b', 'aerisonus'),
    (r'\baerisonis\b', 'aerisonus'),
    (r'\baerisono\b', 'aerisonus'),
    (r'\baerisonum\b', 'aerisonus'),
    (r'\baerisque\b', 'aera'),
    (r'\baerisque\b', 'aer'),
    (r'\baerisue\b', 'aera'),
    (r'\baerisue\b', 'aer'),
    (r'\baerium\b', 'aerius'),
    (r'\baerius\b', 'aerius'),
    (r'\baeronibus\b', 'aero2'),
    (r'\bAeropa\b', 'Aeropa'),
    (r'\baerosa\b', 'aerosus'),
    (r'\baeroso\b', 'aerosus'),
    (r'\baerosum\b', 'aerosus'),
    (r'\baeruca\b', 'aeruca'),
    (r'\baerucam\b', 'aeruca'),
    (r'\baerugine\b', 'aerugo'),
    (r'\baeruginem\b', 'aerugo'),
    (r'\baerugineque\b', 'aerugo'),
    (r'\baerugini\b', 'aerugo'),
    (r'\baeruginis\b', 'aerugo'),
    (r'\baeruginosam\b', 'aeruginosus'),
    (r'\baeruginosis\b', 'aeruginosus'),
    (r'\baerugo\b', 'aerugo'),
    (r'\baerum\b', 'aer'),
    (r'\baerumna\b', 'aerumna'),
    (r'\baerumnabile\b', 'aerumnabilis'),
    (r'\baerumnabili\b', 'aerumnabilis'),
    (r'\baerumnabilis\b', 'aerumnabilis'),
    (r'\baerumnae\b', 'aerumna'),
    (r'\baerumnam\b', 'aerumna'),
    (r'\baerumnarum\b', 'aerumna'),
    (r'\baerumnas\b', 'aerumna'),
    (r'\baerumnis\b', 'aerumna'),
    (r'\baerumnosam\b', 'aerumnosus'),
    (r'\baerumnosas\b', 'aerumnosus'),
    (r'\baerumnosi\b', 'aerumnosus'),
    (r'\baerumnosior\b', 'aerumnosus'),
    (r'\baerumnosique\b', 'aerumnosus'),
    (r'\baerumnosis\b', 'aerumnosus'),
    (r'\baerumnosissimae\b', 'aerumnosus'),
    (r'\baerumnosissimam\b', 'aerumnosus'),
    (r'\baerumnosissimo\b', 'aerumnosus'),
    (r'\baerumnosissimum\b', 'aerumnosus'),
    (r'\baerumnosius\b', 'aerumnosus'),
    (r'\baerumnoso\b', 'aerumnosus'),
    (r'\baerumnosos\b', 'aerumnosus'),
    (r'\baerumnosum\b', 'aerumnosus'),
    (r'\baerumnosus\b', 'aerumnosus'),
    (r'\baerumnulas\b', 'aerumnula'),
    (r'\baeruscanti\b', 'aerusco'),
    (r'\baeruscatores\b', 'aeruscator'),
    (r'\bAes\b', 'a-eo1'),
    (r'\baes\b', 'aedon'),
    (r'\bAesacon\b', 'Aesacus'),
    (r'\bAesacos\b', 'Aesacus'),
    (r'\bAesacus\b', 'Aesacus'),
    (r'\baesalon\b', 'aesalon'),
    (r'\bAesarei\b', 'Aeschines'),
    (r'\bAesaris\b', 'Aesar'),
    (r'\bAeschine\b', 'Aeschines'),
    (r'\bAeschinem\b', 'Aeschines'),
    (r'\bAeschinen\b', 'Aeschines'),
    (r'\bAeschines\b', 'Aeschines'),
    (r'\bAeschini\b', 'Aeschines'),
    (r'\bAeschinis\b', 'Aeschines'),
    (r'\bAeschinum\b', 'Aeschines'),
    (r'\bAeschrio\b', 'Aeschrio'),
    (r'\bAeschrion\b', 'Aeschrio'),
    (r'\bAeschrione\b', 'Aeschrio'),
    (r'\bAeschrionem\b', 'Aeschrio'),
    (r'\bAeschrioni\b', 'Aeschrio'),
    (r'\bAeschrionis\b', 'Aeschrio'),
    (r'\bAeschyle\b', 'Aeschylus'),
    (r'\bAeschyli\b', 'Aeschylus'),
    (r'\bAeschylo\b', 'Aeschylus'),
    (r'\bAeschylos\b', 'Aeschylus'),
    (r'\bAeschylum\b', 'Aeschylus'),
    (r'\bAeschylus\b', 'Aeschylus'),
    (r'\baeschynomene\b', 'aeschynomene'),
    (r'\baeschynomenen\b', 'aeschynomene'),
    (r'\bAesculapi\b', 'Aesculapius'),
    (r'\bAesculapii\b', 'Aesculapius'),
    (r'\bAesculapii\b', 'Aesculapium'),
    (r'\bAesculapio\b', 'Aesculapius'),
    (r'\bAesculapio\b', 'Aesculapium'),
    (r'\bAesculapiorum\b', 'Aesculapius'),
    (r'\bAesculapiorum\b', 'Aesculapium'),
    (r'\bAesculapium\b', 'Aesculapius'),
    (r'\bAesculapium\b', 'Aesculapium'),
    (r'\bAesculapius\b', 'Aesculapius'),
    (r'\baesculea\b', 'aesculeus'),
    (r'\baesculeae\b', 'aesculeus'),
    (r'\bAesculeta\b', 'aesculetum'),
    (r'\baesculeta\b', 'aesculetum'),
    (r'\baesculetis\b', 'aesculetum'),
    (r'\baesculeto\b', 'aesculetum'),
    (r'\baesculi\b', 'aesculus'),
    (r'\baesculini\b', 'aesculinus'),
    (r'\baesculis\b', 'aesculus'),
    (r'\baesculo\b', 'aesculus'),
    (r'\baesculos\b', 'aesculus'),
    (r'\baesculum\b', 'aesculus'),
    (r'\baesculus\b', 'aesculus'),
    (r'\bAesernia\b', 'Aesernia'),
    (r'\bAeserniae\b', 'Aesernia'),
    (r'\bAeserniam\b', 'Aesernia'),
    (r'\bAesernina\b', 'Aesis1'),
    (r'\bAesernini\b', 'Aesis1'),
    (r'\bAesernini\b', 'Aesis1'),
    (r'\bAesernino\b', 'Aesis1'),
    (r'\bAeserninos\b', 'Aesis1'),
    (r'\bAeserninum\b', 'Aesis1'),
    (r'\bAeserninum\b', 'Aesis1'),
    (r'\bAeserninus\b', 'Aesis1'),
    (r'\bAesim\b', 'Aesis2'),
    (r'\bAesim\b', 'Aesis1'),
    (r'\bAesinates\b', 'Aesis1'),
    (r'\bAesis\b', 'Aesis2'),
    (r'\bAesis\b', 'Aesis1'),
    (r'\baesis\b', 'aedon'),
    (r'\baesius\b', 'aedon'),
    (r'\bAesolani\b', 'Aeson'),
    (r'\bAeson\b', 'Aeson'),
    (r'\baeson\b', 'aedon'),
    (r'\bAesone\b', 'Aeson'),
    (r'\baesone\b', 'aedon'),
    (r'\bAesonia\b', 'Aesonius'),
    (r'\bAesoniae\b', 'Aesonius'),
    (r'\bAesoniamque\b', 'Aesonius'),
    (r'\bAesonias\b', 'Aesonius'),
    (r'\bAesonidae\b', 'Aesonius'),
    (r'\bAesonide\b', 'Aesonius'),
    (r'\bAesoniden\b', 'Aesonius'),
    (r'\bAesonides\b', 'Aesonius'),
    (r'\bAesonii\b', 'Aesonius'),
    (r'\bAesonio\b', 'Aesonius'),
    (r'\bAesonios\b', 'Aesonius'),
    (r'\bAesonis\b', 'Aeson'),
    (r'\bAesonium\b', 'Aesonius'),
    (r'\bAesonius\b', 'Aesonius'),
    (r'\bAesope\b', 'Aesopus'),
    (r'\bAesopi\b', 'Aesopus'),
    (r'\bAesopi\b', 'Aesopius'),
    (r'\bAesopia\b', 'Aesopius'),
    (r'\bAesopias\b', 'Aesopius'),
    (r'\bAesopo\b', 'Aesopus'),
    (r'\bAesopum\b', 'Aesopus'),
    (r'\bAesopus\b', 'Aesopus'),
    (r'\baesoque\b', 'aedon'),
    (r'\baest\b', 'aedon'),
    (r'\baestas\b', 'aestas'),
    (r'\baestasque\b', 'aestas'),
    (r'\baestate\b', 'aestas'),
    (r'\baestatem\b', 'aestas'),
    (r'\baestatemque\b', 'aestas'),
    (r'\baestates\b', 'aestas'),
    (r'\baestatesque\b', 'aestas'),
    (r'\baestati\b', 'aestas'),
    (r'\baestatibus\b', 'aestas'),
    (r'\baestatis\b', 'aestas'),
    (r'\baestatisque\b', 'aestas'),
    (r'\baestatium\b', 'aestas'),
    (r'\baestatum\b', 'aestas'),
    (r'\baestibus\b', 'aestus'),
    (r'\baestima\b', 'aestimo'),
    (r'\baestimabam\b', 'aestimo'),
    (r'\baestimabamus\b', 'aestimo'),
    (r'\baestimabant\b', 'aestimo'),
    (r'\baestimabantur\b', 'aestimo'),
    (r'\baestimabat\b', 'aestimo'),
    (r'\baestimabatur\b', 'aestimo'),
    (r'\baestimabile\b', 'aestimabilis'),
    (r'\baestimabiles\b', 'aestimabilis'),
    (r'\baestimabilia\b', 'aestimabilis'),
    (r'\baestimabimus\b', 'aestimo'),
    (r'\baestimabis\b', 'aestimo'),
    (r'\baestimabit\b', 'aestimo'),
    (r'\baestimabitis\b', 'aestimo'),
    (r'\baestimabitur\b', 'aestimo'),
    (r'\baestimabo\b', 'aestimo'),
    (r'\baestimabunt\b', 'aestimo'),
    (r'\baestimabuntur\b', 'aestimo'),
    (r'\baestimamus\b', 'aestimo'),
    (r'\baestimanda\b', 'aestimo'),
    (r'\baestimandae\b', 'aestimo'),
    (r'\baestimandam\b', 'aestimo'),
    (r'\baestimandaque\b', 'aestimo'),
    (r'\baestimandas\b', 'aestimo'),
    (r'\baestimandast\b', 'aestimo'),
    (r'\baestimandi\b', 'aestimo'),
    (r'\baestimandis\b', 'aestimo'),
    (r'\baestimando\b', 'aestimo'),
    (r'\baestimandoque\b', 'aestimo'),
    (r'\baestimandosque\b', 'aestimo'),
    (r'\baestimandum\b', 'aestimo'),
    (r'\baestimandus\b', 'aestimo'),
    (r'\baestimans\b', 'aestimo'),
    (r'\baestimant\b', 'aestimo'),
    (r'\baestimantem\b', 'aestimo'),
    (r'\baestimantes\b', 'aestimo'),
    (r'\baestimanti\b', 'aestimo'),
    (r'\baestimantibus\b', 'aestimo'),
    (r'\baestimantis\b', 'aestimo'),
    (r'\baestimantium\b', 'aestimo'),
    (r'\baestimantur\b', 'aestimo'),
    (r'\baestimaram\b', 'aestimo'),
    (r'\baestimarant\b', 'aestimo'),
    (r'\baestimare\b', 'aestimo'),
    (r'\baestimarem\b', 'aestimo'),
    (r'\baestimarent\b', 'aestimo'),
    (r'\baestimarentur\b', 'aestimo'),
    (r'\baestimares\b', 'aestimo'),
    (r'\baestimaret\b', 'aestimo'),
    (r'\baestimaretis\b', 'aestimo'),
    (r'\baestimaretur\b', 'aestimo'),
    (r'\baestimari\b', 'aestimo'),
    (r'\baestimarique\b', 'aestimo'),
    (r'\baestimarit\b', 'aestimo'),
    (r'\baestimarunt\b', 'aestimo'),
    (r'\baestimas\b', 'aestimo'),
    (r'\baestimasse\b', 'aestimo'),
    (r'\baestimassem\b', 'aestimo'),
    (r'\baestimasset\b', 'aestimo'),
    (r'\baestimasti\b', 'aestimo'),
    (r'\baestimat\b', 'aestimo'),
    (r'\baestimata\b', 'aestimo'),
    (r'\baestimatae\b', 'aestimo'),
    (r'\baestimatam\b', 'aestimo'),
    (r'\baestimatarum\b', 'aestimo'),
    (r'\baestimatas\b', 'aestimo'),
    (r'\baestimate\b', 'aestimo'),
    (r'\baestimati\b', 'aestimo'),
    (r'\baestimatio\b', 'aestimatio'),
    (r'\baestimatione\b', 'aestimatio'),
    (r'\baestimationem\b', 'aestimatio'),
    (r'\baestimationemque\b', 'aestimatio'),
    (r'\baestimationes\b', 'aestimatio'),
    (r'\baestimationi\b', 'aestimatio'),
    (r'\baestimationibus\b', 'aestimatio'),
    (r'\baestimationis\b', 'aestimatio'),
    (r'\baestimationisve\b', 'aestimatio'),
    (r'\baestimatique\b', 'aestimo'),
    (r'\baestimatis\b', 'aestimo'),
    (r'\baestimato\b', 'aestimo'),
    (r'\baestimatoque\b', 'aestimo'),
    (r'\baestimator\b', 'aestimator'),
    (r'\baestimatore\b', 'aestimator'),
    (r'\baestimatorem\b', 'aestimator'),
    (r'\baestimatores\b', 'aestimator'),
    (r'\baestimatoria\b', 'aestimatorius'),
    (r'\baestimatoria\b', 'aestimatorius'),
    (r'\baestimatoriam\b', 'aestimatorius'),
    (r'\baestimatoribus\b', 'aestimator'),
    (r'\baestimatorio\b', 'aestimatorius'),
    (r'\baestimatos\b', 'aestimo'),
    (r'\baestimatu\b', 'aestimatus'),
    (r'\baestimatu\b', 'aestimo'),
    (r'\baestimatum\b', 'aestimatus'),
    (r'\baestimatum\b', 'aestimo'),
    (r'\baestimatumque\b', 'aestimatus'),
    (r'\baestimatumque\b', 'aestimo'),
    (r'\baestimatur\b', 'aestimo'),
    (r'\baestimaturi\b', 'aestimo'),
    (r'\baestimaturo\b', 'aestimo'),
    (r'\baestimaturos\b', 'aestimo'),
    (r'\baestimaturum\b', 'aestimo'),
    (r'\baestimaturus\b', 'aestimo'),
    (r'\baestimatus\b', 'aestimatus'),
    (r'\baestimatus\b', 'aestimo'),
    (r'\baestimauerimus\b', 'aestimo'),
    (r'\baestimauerint\b', 'aestimo'),
    (r'\baestimaueris\b', 'aestimo'),
    (r'\baestimauerit\b', 'aestimo'),
    (r'\baestimauit\b', 'aestimo'),
    (r'\baestimaverit\b', 'aestimo'),
    (r'\baestimaverunt\b', 'aestimo'),
    (r'\baestimavi\b', 'aestimo'),
    (r'\baestimavimus\b', 'aestimo'),
    (r'\baestimavisset\b', 'aestimo'),
    (r'\baestimavit\b', 'aestimo'),
    (r'\baestimem\b', 'aestimo'),
    (r'\baestimemus\b', 'aestimo'),
    (r'\baestiment\b', 'aestimo'),
    (r'\baestimentur\b', 'aestimo'),
    (r'\baestimes\b', 'aestimo'),
    (r'\baestimet\b', 'aestimo'),
    (r'\baestimetis\b', 'aestimo'),
    (r'\baestimetur\b', 'aestimo'),
    (r'\baestimio\b', 'aestimium'),
    (r'\baestimo\b', 'aestimo'),
    (r'\bAestiorum\b', 'Aestii'),
    (r'\baestiua\b', 'aestivus'),
    (r'\baestiua\b', 'aestiva'),
    (r'\baestiua\b', 'aestivo'),
    (r'\baestiuae\b', 'aestivus'),
    (r'\baestiualia\b', 'aestivalis'),
    (r'\baestiualium\b', 'aestivalis'),
    (r'\baestiuam\b', 'aestivus'),
    (r'\baestiuare\b', 'aestivo'),
    (r'\baestiuarum\b', 'aestivus'),
    (r'\baestiuas\b', 'aestivus'),
    (r'\baestiuas\b', 'aestivo'),
    (r'\baestiui\b', 'aestivus'),
    (r'\baestiuis\b', 'aestivus'),
    (r'\baestiuis\b', 'aestiva'),
    (r'\baestiuisque\b', 'aestivus'),
    (r'\baestiuisque\b', 'aestiva'),
    (r'\baestiuo\b', 'aestivus'),
    (r'\baestiuo\b', 'aestivo'),
    (r'\baestiuom\b', 'aestivus'),
    (r'\baestiuorum\b', 'aestivus'),
    (r'\baestiuorum\b', 'aestiva'),
    (r'\baestiuos\b', 'aestivus'),
    (r'\baestiuosque\b', 'aestivus'),
    (r'\baestiuum\b', 'aestivus'),
    (r'\baestiuum\b', 'aestiva'),
    (r'\baestiuumque\b', 'aestivus'),
    (r'\baestiuumque\b', 'aestiva'),
    (r'\baestiuus\b', 'aestivus'),
    (r'\baestiva\b', 'aestivus'),
    (r'\baestiva\b', 'aestiva'),
    (r'\baestiva\b', 'aestivo'),
    (r'\baestivabant\b', 'aestivo'),
    (r'\baestivae\b', 'aestivus'),
    (r'\baestivam\b', 'aestivus'),
    (r'\baestivant\b', 'aestivo'),
    (r'\baestivas\b', 'aestivus'),
    (r'\baestivas\b', 'aestivo'),
    (r'\baestivasque\b', 'aestivus'),
    (r'\baestivasque\b', 'aestivo'),
    (r'\baestivat\b', 'aestivo'),
    (r'\baestivatum\b', 'aestivo'),
    (r'\baestive\b', 'aestivus'),
    (r'\baestivi\b', 'aestivus'),
    (r'\baestivis\b', 'aestivus'),
    (r'\baestivis\b', 'aestiva'),
    (r'\baestivisque\b', 'aestivus'),
    (r'\baestivisque\b', 'aestiva'),
    (r'\baestivo\b', 'aestivus'),
    (r'\baestivo\b', 'aestivo'),
    (r'\baestivorum\b', 'aestivus'),
    (r'\baestivorum\b', 'aestiva'),
    (r'\baestivos\b', 'aestivus'),
    (r'\baestivosque\b', 'aestivus'),
    (r'\baestivum\b', 'aestivus'),
    (r'\baestivum\b', 'aestiva'),
    (r'\baestivus\b', 'aestivus'),
    (r'\baestu\b', 'aestus'),
    (r'\baestua\b', 'aestuo'),
    (r'\baestuabat\b', 'aestuo'),
    (r'\baestuabatque\b', 'aestuo'),
    (r'\baestuabimus\b', 'aestuo'),
    (r'\baestuabit\b', 'aestuo'),
    (r'\baestuabo\b', 'aestuo'),
    (r'\baestuamus\b', 'aestuo'),
    (r'\baestuandi\b', 'aestuo'),
    (r'\baestuando\b', 'aestuo'),
    (r'\baestuandove\b', 'aestuo'),
    (r'\baestuandum\b', 'aestuo'),
    (r'\baestuans\b', 'aestuo'),
    (r'\baestuant\b', 'aestuo'),
    (r'\baestuante\b', 'aestuo'),
    (r'\baestuantem\b', 'aestuo'),
    (r'\baestuantes\b', 'aestuo'),
    (r'\baestuanti\b', 'aestuo'),
    (r'\baestuantia\b', 'aestuo'),
    (r'\baestuantibus\b', 'aestuo'),
    (r'\baestuantis\b', 'aestuo'),
    (r'\baestuantium\b', 'aestuo'),
    (r'\baestuare\b', 'aestuo'),
    (r'\baestuaret\b', 'aestuo'),
    (r'\baestuaria\b', 'aestuarium'),
    (r'\baestuariis\b', 'aestuarium'),
    (r'\baestuariisque\b', 'aestuarium'),
    (r'\baestuario\b', 'aestuarium'),
    (r'\baestuarium\b', 'aestuarium'),
    (r'\baestuat\b', 'aestuo'),
    (r'\baestuatio\b', 'aestuatio'),
    (r'\baestuatus\b', 'aestuo'),
    (r'\baestuauerint\b', 'aestuo'),
    (r'\baestuaverunt\b', 'aestuo'),
    (r'\baestuavi\b', 'aestuo'),
    (r'\baestuavit\b', 'aestuo'),
    (r'\baestuem\b', 'aestuo'),
    (r'\baestuent\b', 'aestuo'),
    (r'\baestues\b', 'aestuo'),
    (r'\baestuet\b', 'aestuo'),
    (r'\baestuetis\b', 'aestuo'),
    (r'\baestui\b', 'aestus'),
    (r'\baestum\b', 'aestus'),
    (r'\baestumandae\b', 'aestimo'),
    (r'\baestumandis\b', 'aestimo'),
    (r'\baestumandum\b', 'aestimo'),
    (r'\baestumant\b', 'aestimo'),
    (r'\baestumantur\b', 'aestimo'),
    (r'\baestumare\b', 'aestimo'),
    (r'\baestumarem\b', 'aestimo'),
    (r'\baestumat\b', 'aestimo'),
    (r'\baestumatis\b', 'aestimo'),
    (r'\baestumatum\b', 'aestimo'),
    (r'\baestumavere\b', 'aestimo'),
    (r'\baestumaverit\b', 'aestimo'),
    (r'\baestumavi\b', 'aestimo'),
    (r'\baestumet\b', 'aestimo'),
    (r'\baestumetur\b', 'aestimo'),
    (r'\baestumo\b', 'aestimo'),
    (r'\baestumque\b', 'aestus'),
    (r'\baestuo\b', 'aestuo'),
    (r'\baestuosa\b', 'aestuosus'),
    (r'\baestuosae\b', 'aestuosus'),
    (r'\baestuosam\b', 'aestuosus'),
    (r'\baestuosas\b', 'aestuosus'),
    (r'\baestuosi\b', 'aestuosus'),
    (r'\baestuosis\b', 'aestuosus'),
    (r'\baestuosissimis\b', 'aestuosus'),
    (r'\baestuosissimum\b', 'aestuosus'),
    (r'\baestuosius\b', 'aestuosus'),
    (r'\baestuoso\b', 'aestuosus'),
    (r'\baestuosos\b', 'aestuosus'),
    (r'\baestuosum\b', 'aestuosus'),
    (r'\baestuosus\b', 'aestuosus'),
    (r'\baestuque\b', 'aestus'),
    (r'\baestus\b', 'aestus'),
    (r'\baestusque\b', 'aestus'),
    (r'\baestusve\b', 'aestus'),
    (r'\baestuum\b', 'aestus'),
    (r'\baesum\b', 'aedon'),
    (r'\baesumque\b', 'aedon'),
    (r'\baeta\b', 'a-fello'),
    (r'\baetas\b', 'aetas'),
    (r'\baetasque\b', 'aetas'),
    (r'\baetate\b', 'aetas'),
    (r'\baetatem\b', 'aetas'),
    (r'\baetatemque\b', 'aetas'),
    (r'\baetates\b', 'aetas'),
    (r'\baetatesque\b', 'aetas'),
    (r'\baetati\b', 'aetas'),
    (r'\baetatibus\b', 'aetas'),
    (r'\baetatibusque\b', 'aetas'),
    (r'\baetatique\b', 'aetas'),
    (r'\baetatis\b', 'aetas'),
    (r'\baetatisque\b', 'aetas'),
    (r'\baetatisue\b', 'aetas'),
    (r'\baetatium\b', 'aetas'),
    (r'\baetatula\b', 'aetatula'),
    (r'\baetatulae\b', 'aetatula'),
    (r'\baetatulam\b', 'aetatula'),
    (r'\baetatulast\b', 'aetatula'),
    (r'\baetatulis\b', 'aetatula'),
    (r'\baetatum\b', 'aetas'),
    (r'\baetatumque\b', 'aetas'),
    (r'\baeterna\b', 'aeternus'),
    (r'\baeterna\b', 'aeterno2'),
    (r'\baeternae\b', 'aeternus'),
    (r'\baeternaeque\b', 'aeternus'),
    (r'\baeternales\b', 'aeternalis'),
    (r'\baeternam\b', 'aeternus'),
    (r'\baeternamque\b', 'aeternus'),
    (r'\baeternaque\b', 'aeternus'),
    (r'\baeternaque\b', 'aeterno2'),
    (r'\baeternare\b', 'aeterno2'),
    (r'\baeternarum\b', 'aeternus'),
    (r'\baeternas\b', 'aeternus'),
    (r'\baeternas\b', 'aeterno2'),
    (r'\baeterne\b', 'aeternus'),
    (r'\baeternet\b', 'aeterno2'),
    (r'\baeterni\b', 'aeternus'),
    (r'\baeternior\b', 'aeternus'),
    (r'\baeternique\b', 'aeternus'),
    (r'\baeternis\b', 'aeternus'),
    (r'\baeternisque\b', 'aeternus'),
    (r'\baeternitas\b', 'aeternitas'),
    (r'\baeternitate\b', 'aeternitas'),
    (r'\baeternitatem\b', 'aeternitas'),
    (r'\baeternitatemque\b', 'aeternitas'),
    (r'\baeternitates\b', 'aeternitas'),
    (r'\baeternitati\b', 'aeternitas'),
    (r'\baeternitatique\b', 'aeternitas'),
    (r'\baeternitatis\b', 'aeternitas'),
    (r'\baeternitatisque\b', 'aeternitas'),
    (r'\baeterno\b', 'aeternus'),
    (r'\baeterno\b', 'aeterno2'),
    (r'\baeternoque\b', 'aeternus'),
    (r'\baeternoque\b', 'aeterno2'),
    (r'\baeternorum\b', 'aeternus'),
    (r'\baeternos\b', 'aeternus'),
    (r'\baeternum\b', 'aeternus'),
    (r'\baeternumque\b', 'aeternus'),
    (r'\baeternus\b', 'aeternus'),
    (r'\baeternusque\b', 'aeternus'),
    (r'\baethalis\b', 'aethalus'),
    (r'\baethalon\b', 'aethalus'),
    (r'\baether\b', 'aether'),
    (r'\baethera\b', 'aether'),
    (r'\baetheraque\b', 'aether'),
    (r'\baethere\b', 'aether'),
    (r'\baetherem\b', 'aether'),
    (r'\baetheri\b', 'aether'),
    (r'\baetheri\b', 'aetherius'),
    (r'\baetheria\b', 'aetherius'),
    (r'\baetheriae\b', 'aetherius'),
    (r'\baetheriam\b', 'aetherius'),
    (r'\baetheriamque\b', 'aetherius'),
    (r'\baetheriarum\b', 'aetherius'),
    (r'\baetherias\b', 'aetherius'),
    (r'\baetheriasque\b', 'aetherius'),
    (r'\baetherie\b', 'aetherius'),
    (r'\baetherii\b', 'aetherius'),
    (r'\baetheriis\b', 'aetherius'),
    (r'\baetherio\b', 'aetherius'),
    (r'\baetherioque\b', 'aetherius'),
    (r'\baetherios\b', 'aetherius'),
    (r'\baetheriosque\b', 'aetherius'),
    (r'\baetheris\b', 'aether'),
    (r'\baetherium\b', 'aetherius'),
    (r'\baetherius\b', 'aetherius'),
    (r'\baetheriusque\b', 'aetherius'),
    (r'\baetheros\b', 'aether'),
    (r'\baetherque\b', 'aether'),
    (r'\bAethiope\b', 'Aethiops'),
    (r'\bAethiope\b', 'Aethiopus'),
    (r'\bAethiopem\b', 'Aethiops'),
    (r'\bAethiopes\b', 'Aethiops'),
    (r'\bAethiopesque\b', 'Aethiops'),
    (r'\bAethiopi\b', 'Aethiops'),
    (r'\bAethiopi\b', 'Aethiopus'),
    (r'\bAethiopia\b', 'Aethiopia'),
    (r'\bAethiopiae\b', 'Aethiopia'),
    (r'\bAethiopiaeque\b', 'Aethiopia'),
    (r'\bAethiopiam\b', 'Aethiopia'),
    (r'\bAethiopias\b', 'Aethiopia'),
    (r'\bAethiopiast\b', 'Aethiopia'),
    (r'\bAethiopibus\b', 'Aethiops'),
    (r'\bAethiopica\b', 'aethiopis'),
    (r'\bAethiopicae\b', 'aethiopis'),
    (r'\bAethiopicam\b', 'aethiopis'),
    (r'\bAethiopici\b', 'aethiopis'),
    (r'\bAethiopicis\b', 'aethiopis'),
    (r'\bAethiopico\b', 'aethiopis'),
    (r'\bAethiopicos\b', 'aethiopis'),
    (r'\bAethiopicum\b', 'aethiopis'),
    (r'\baethiopide\b', 'aethiopis'),
    (r'\baethiopidem\b', 'aethiopis'),
    (r'\bAethiopidem\b', 'Aethiops'),
    (r'\bAethiopidem\b', 'Aethiopus'),
    (r'\baethiopis\b', 'aethiopis'),
    (r'\bAethiopis\b', 'Aethiopus'),
    (r'\bAethiopis\b', 'Aethiops'),
    (r'\bAethiops\b', 'Aethiops'),
    (r'\bAethiopum\b', 'Aethiopus'),
    (r'\bAethiopumque\b', 'Aethiopus'),
    (r'\bAethiopus\b', 'Aethiopus'),
    (r'\bAethon\b', 'Aethon'),
    (r'\baethra\b', 'aethra1'),
    (r'\bAethra\b', 'Aethra2'),
    (r'\baethrae\b', 'aethra1'),
    (r'\bAethrae\b', 'Aethra2'),
    (r'\baethram\b', 'aethra1'),
    (r'\bAethram\b', 'Aethra2'),
    (r'\baethramque\b', 'aethra1'),
    (r'\bAethramque\b', 'Aethra2'),
    (r'\bAetidemi\b', 'aetiologia'),
    (r'\baetiologia\b', 'aetiologia'),
    (r'\baetiologiae\b', 'aetiologia'),
    (r'\baetiologian\b', 'aetiologia'),
    (r'\baetiologias\b', 'aetiologia'),
    (r'\baetiten\b', 'aetites'),
    (r'\bAetna\b', 'Aetna'),
    (r'\bAetnae\b', 'Aetna'),
    (r'\bAetnaea\b', 'Aetnaeus'),
    (r'\bAetnaeae\b', 'Aetnaeus'),
    (r'\bAetnaeaque\b', 'Aetnaeus'),
    (r'\bAetnaeas\b', 'Aetnaeus'),
    (r'\bAetnaei\b', 'Aetnaeus'),
    (r'\bAetnaei\b', 'Aetnaeus'),
    (r'\bAetnaeis\b', 'Aetnaeus'),
    (r'\bAetnaeis\b', 'Aetnaeus'),
    (r'\bAetnaeo\b', 'Aetnaeus'),
    (r'\bAetnaeorum\b', 'Aetnaeus'),
    (r'\bAetnaeorum\b', 'Aetnaeus'),
    (r'\bAetnaeos\b', 'Aetnaeus'),
    (r'\bAetnaeum\b', 'Aetnaeus'),
    (r'\bAetnaeum\b', 'Aetnaeus'),
    (r'\bAetnaeus\b', 'Aetnaeus'),
    (r'\bAetnaeusque\b', 'Aetnaeus'),
    (r'\bAetnam\b', 'Aetna'),
    (r'\bAetnamque\b', 'Aetna'),
    (r'\bAetnamue\b', 'Aetna'),
    (r'\bAetne\b', 'Aetnensis'),
    (r'\bAetnen\b', 'Aetnensis'),
    (r'\bAetnensem\b', 'Aetnensis'),
    (r'\bAetnenses\b', 'Aetnensis'),
    (r'\bAetnenses\b', 'Aetnensis'),
    (r'\bAetnensi\b', 'Aetnensis'),
    (r'\bAetnensibus\b', 'Aetnensis'),
    (r'\bAetnensibus\b', 'Aetnensis'),
    (r'\bAetnensis\b', 'Aetnensis'),
    (r'\bAetnensis\b', 'Aetnensis'),
    (r'\bAetnensium\b', 'Aetnensis'),
    (r'\bAetnensium\b', 'Aetnensis'),
    (r'\baeto\b', 'a-fello'),
    (r'\bAetola\b', 'aevitas'),
    (r'\bAetolae\b', 'aevitas'),
    (r'\bAetolaque\b', 'aevitas'),
    (r'\bAetoli\b', 'Aetolia'),
    (r'\bAetoli\b', 'aevitas'),
    (r'\bAetoli\b', 'aevitas'),
    (r'\bAetolia\b', 'Aetolia'),
    (r'\bAetolia\b', 'aevitas'),
    (r'\bAetoliae\b', 'Aetolia'),
    (r'\bAetoliam\b', 'Aetolia'),
    (r'\bAetoliaque\b', 'Aetolia'),
    (r'\bAetoliaque\b', 'aevitas'),
    (r'\bAetolica\b', 'aevitas'),
    (r'\bAetolici\b', 'aevitas'),
    (r'\bAetolicis\b', 'aevitas'),
    (r'\bAetolico\b', 'aevitas'),
    (r'\bAetolicum\b', 'aevitas'),
    (r'\bAetolide\b', 'aevitas'),
    (r'\bAetolique\b', 'Aetolia'),
    (r'\bAetolique\b', 'aevitas'),
    (r'\bAetolique\b', 'aevitas'),
    (r'\bAetolis\b', 'aevitas'),
    (r'\bAetolis\b', 'Aetolia'),
    (r'\bAetolis\b', 'aevitas'),
    (r'\bAetolisque\b', 'aevitas'),
    (r'\bAetolisque\b', 'Aetolia'),
    (r'\bAetolisque\b', 'aevitas'),
    (r'\bAetolius\b', 'aevitas'),
    (r'\bAetolius\b', 'aevitas'),
    (r'\bAetolo\b', 'aevitas'),
    (r'\bAetolorum\b', 'Aetolia'),
    (r'\bAetolorum\b', 'aevitas'),
    (r'\bAetolorumque\b', 'Aetolia'),
    (r'\bAetolorumque\b', 'aevitas'),
    (r'\bAetolos\b', 'Aetolia'),
    (r'\bAetolosque\b', 'Aetolia'),
    (r'\bAetolum\b', 'Aetolia'),
    (r'\bAetolum\b', 'aevitas'),
    (r'\bAetolumque\b', 'Aetolia'),
    (r'\bAetolumque\b', 'aevitas'),
    (r'\bAetolumue\b', 'Aetolia'),
    (r'\bAetolumue\b', 'aevitas'),
    (r'\bAetolus\b', 'aevitas'),
    (r'\bAetolusque\b', 'aevitas'),
    (r'\baeui\b', 'aevum'),
    (r'\baeuis\b', 'aevum'),
    (r'\baeuitasue\b', 'aevitas'),
    (r'\baeuitatem\b', 'aevitas'),
    (r'\baeuitates\b', 'aevitas'),
    (r'\baeuo\b', 'aevum'),
    (r'\baeuola\b', 'aevum'),
    (r'\baeuom\b', 'aevum'),
    (r'\baeuoque\b', 'aevum'),
    (r'\baeuum\b', 'aevum'),
    (r'\baeuumque\b', 'aevum'),
    (r'\baeva\b', 'aevum'),
    (r'\baevi\b', 'aevum'),
    (r'\baevique\b', 'aevum'),
    (r'\baevis\b', 'aevum'),
    (r'\baevitatis\b', 'aevitas'),
    (r'\baevo\b', 'aevum'),
    (r'\baevom\b', 'aevum'),
    (r'\baevoque\b', 'aevum'),
    (r'\baevum\b', 'aevum'),
    (r'\baevumque\b', 'aevum'),
    (r'\bafanon\b', 'a-fello'),
    (r'\bafella\b', 'a-fello'),
    (r'\bafer\b', 'a-fero'),
    (r'\bafer\b', 'a-for'),
    (r'\baffabilem\b', 'affabilis'),
    (r'\baffabilior\b', 'affabilis'),
    (r'\baffabilis\b', 'affabilis'),
    (r'\baffabilitate\b', 'affabilitas'),
    (r'\baffari\b', 'affor'),
    (r'\baffata\b', 'affor'),
    (r'\baffatibus\b', 'affatus2'),
    (r'\baffatim\b', 'affatim'),
    (r'\baffatu\b', 'affatus2'),
    (r'\baffatu\b', 'affor'),
    (r'\baffatur\b', 'affor'),
    (r'\baffatus\b', 'affatus2'),
    (r'\baffatus\b', 'affor'),
    (r'\baffecerat\b', 'afficio'),
    (r'\baffecerit\b', 'afficio'),
    (r'\baffecerunt\b', 'afficio'),
    (r'\baffecisset\b', 'afficio'),
    (r'\baffecit\b', 'afficio'),
    (r'\baffecta\b', 'afficio'),
    (r'\baffecta\b', 'affecto'),
    (r'\baffectabant\b', 'affecto'),
    (r'\baffectabat\b', 'affecto'),
    (r'\baffectabunt\b', 'affecto'),
    (r'\baffectae\b', 'afficio'),
    (r'\baffectam\b', 'afficio'),
    (r'\baffectamus\b', 'affecto'),
    (r'\baffectanda\b', 'affecto'),
    (r'\baffectans\b', 'affecto'),
    (r'\baffectant\b', 'affecto'),
    (r'\baffectantes\b', 'affecto'),
    (r'\baffectantibus\b', 'affecto'),
    (r'\baffectare\b', 'affecto'),
    (r'\baffectas\b', 'afficio'),
    (r'\baffectas\b', 'affecto'),
    (r'\baffectasse\b', 'affecto'),
    (r'\baffectat\b', 'affecto'),
    (r'\baffectata\b', 'affecto'),
    (r'\baffectatae\b', 'affecto'),
    (r'\baffectate\b', 'affecto'),
    (r'\baffectati\b', 'affecto'),
    (r'\baffectatorem\b', 'affectator'),
    (r'\baffectauerit\b', 'affecto'),
    (r'\baffectauit\b', 'affecto'),
    (r'\baffectaverunt\b', 'affecto'),
    (r'\baffectavit\b', 'affecto'),
    (r'\baffectent\b', 'affecto'),
    (r'\baffecti\b', 'afficio'),
    (r'\baffectibus\b', 'affectus2'),
    (r'\baffectio\b', 'affectio'),
    (r'\baffectione\b', 'affectio'),
    (r'\baffectionem\b', 'affectio'),
    (r'\baffectionemque\b', 'affectio'),
    (r'\baffectiones\b', 'affectio'),
    (r'\baffectionesque\b', 'affectio'),
    (r'\baffectioni\b', 'affectio'),
    (r'\baffectionibus\b', 'affectio'),
    (r'\baffectionis\b', 'affectio'),
    (r'\baffectiose\b', 'affectiosus'),
    (r'\baffectis\b', 'afficio'),
    (r'\baffectos\b', 'afficio'),
    (r'\baffectu\b', 'affectus2'),
    (r'\baffectu\b', 'afficio'),
    (r'\baffectui\b', 'affectus2'),
    (r'\baffectum\b', 'affectus2'),
    (r'\baffectum\b', 'afficio'),
    (r'\baffectuque\b', 'affectus2'),
    (r'\baffectuque\b', 'afficio'),
    (r'\baffectus\b', 'affectus2'),
    (r'\baffectus\b', 'afficio'),
    (r'\baffectusque\b', 'affectus2'),
    (r'\baffectusque\b', 'afficio'),
    (r'\baffectuue\b', 'affectus2'),
    (r'\baffectuue\b', 'afficio'),
    (r'\baffer\b', 'affero'),
    (r'\baffer\b', 'affor'),
    (r'\bafferam\b', 'affero'),
    (r'\bafferamus\b', 'affero'),
    (r'\bafferant\b', 'affero'),
    (r'\bafferantur\b', 'affero'),
    (r'\bafferas\b', 'affero'),
    (r'\bafferat\b', 'affero'),
    (r'\bafferatque\b', 'affero'),
    (r'\bafferatur\b', 'affero'),
    (r'\bafferebantur\b', 'affero'),
    (r'\bafferebat\b', 'affero'),
    (r'\bafferemus\b', 'affero'),
    (r'\bafferendas\b', 'affero'),
    (r'\bafferendum\b', 'affero'),
    (r'\bafferens\b', 'affero'),
    (r'\bafferent\b', 'affero'),
    (r'\bafferentur\b', 'affero'),
    (r'\bafferes\b', 'affero'),
    (r'\bafferet\b', 'affero'),
    (r'\bafferetur\b', 'affero'),
    (r'\baffero\b', 'affero'),
    (r'\bafferre\b', 'affero'),
    (r'\bafferrent\b', 'affero'),
    (r'\bafferret\b', 'affero'),
    (r'\bafferri\b', 'affero'),
    (r'\baffers\b', 'affero'),
    (r'\baffert\b', 'affero'),
    (r'\baffertur\b', 'affero'),
    (r'\bafferunt\b', 'affero'),
    (r'\bafferuntur\b', 'affero'),
    (r'\baffice\b', 'afficio'),
    (r'\bafficere\b', 'afficio'),
    (r'\bafficerent\b', 'afficio'),
    (r'\bafficerentur\b', 'afficio'),
    (r'\bafficeret\b', 'afficio'),
    (r'\bafficeretur\b', 'afficio'),
    (r'\baffici\b', 'afficio'),
    (r'\bafficiam\b', 'afficio'),
    (r'\bafficiantur\b', 'afficio'),
    (r'\bafficiare\b', 'afficio'),
    (r'\bafficiatur\b', 'afficio'),
    (r'\bafficiebat\b', 'afficio'),
    (r'\bafficiemus\b', 'afficio'),
    (r'\bafficiendum\b', 'afficio'),
    (r'\bafficiens\b', 'afficio'),
    (r'\bafficientur\b', 'afficio'),
    (r'\bafficiet\b', 'afficio'),
    (r'\bafficietur\b', 'afficio'),
    (r'\bafficio\b', 'afficio'),
    (r'\bafficit\b', 'afficio'),
    (r'\bafficitur\b', 'afficio'),
    (r'\bafficiunt\b', 'afficio'),
    (r'\bafficiuntur\b', 'afficio'),
    (r'\bafficta\b', 'affictus'),
    (r'\bafficta\b', 'affingo'),
    (r'\baffigamus\b', 'affigo'),
    (r'\baffigatis\b', 'affigo'),
    (r'\baffigebatur\b', 'affigo'),
    (r'\baffigere\b', 'affigo'),
    (r'\baffigeret\b', 'affigo'),
    (r'\baffigi\b', 'affigo'),
    (r'\baffigique\b', 'affigo'),
    (r'\baffigitur\b', 'affigo'),
    (r'\baffinem\b', 'affinis'),
    (r'\baffines\b', 'affinis'),
    (r'\baffingit\b', 'affingo'),
    (r'\baffini\b', 'affinis'),
    (r'\baffinibus\b', 'affinis'),
    (r'\baffinis\b', 'affinis'),
    (r'\baffinitate\b', 'affinitas'),
    (r'\baffinitatem\b', 'affinitas'),
    (r'\baffinitates\b', 'affinitas'),
    (r'\baffinitatibus\b', 'affinitas'),
    (r'\baffinitatibusque\b', 'affinitas'),
    (r'\baffinitatis\b', 'affinitas'),
    (r'\baffirma\b', 'affirmo'),
    (r'\baffirmabat\b', 'affirmo'),
    (r'\baffirmabatque\b', 'affirmo'),
    (r'\baffirmabit\b', 'affirmo'),
    (r'\baffirmabo\b', 'affirmo'),
    (r'\baffirmamus\b', 'affirmo'),
    (r'\baffirmans\b', 'affirmo'),
    (r'\baffirmant\b', 'affirmo'),
    (r'\baffirmantem\b', 'affirmo'),
    (r'\baffirmantes\b', 'affirmo'),
    (r'\baffirmantibus\b', 'affirmo'),
    (r'\baffirmare\b', 'affirmo'),
    (r'\baffirmarent\b', 'affirmo'),
    (r'\baffirmaret\b', 'affirmo'),
    (r'\baffirmasse\b', 'affirmo'),
    (r'\baffirmasset\b', 'affirmo'),
    (r'\baffirmat\b', 'affirmo'),
    (r'\baffirmate\b', 'affirmatio'),
    (r'\baffirmate\b', 'affirmo'),
    (r'\baffirmatio\b', 'affirmatio'),
    (r'\baffirmatione\b', 'affirmatio'),
    (r'\baffirmationi\b', 'affirmatio'),
    (r'\baffirmatis\b', 'affirmo'),
    (r'\baffirmatissime\b', 'affirmo'),
    (r'\baffirmatum\b', 'affirmo'),
    (r'\baffirmatur\b', 'affirmo'),
    (r'\baffirmauero\b', 'affirmo'),
    (r'\baffirmauerunt\b', 'affirmo'),
    (r'\baffirmauisse\b', 'affirmo'),
    (r'\baffirmauit\b', 'affirmo'),
    (r'\baffirmauitque\b', 'affirmo'),
    (r'\baffirmavi\b', 'affirmo'),
    (r'\baffirmavit\b', 'affirmo'),
    (r'\baffirmemus\b', 'affirmo'),
    (r'\baffirment\b', 'affirmo'),
    (r'\baffirmes\b', 'affirmo'),
    (r'\baffirmet\b', 'affirmo'),
    (r'\baffirmetur\b', 'affirmo'),
    (r'\baffirmo\b', 'affirmo'),
    (r'\baffixa\b', 'affigo'),
    (r'\baffixis\b', 'affigo'),
    (r'\baffixit\b', 'affigo'),
    (r'\baffixo\b', 'affigo'),
    (r'\baffixus\b', 'affigo'),
    (r'\bafflabat\b', 'afflo'),
    (r'\bafflabunt\b', 'afflo'),
    (r'\bafflare\b', 'afflo'),
    (r'\bafflaretur\b', 'afflo'),
    (r'\bafflari\b', 'afflo'),
    (r'\bafflat\b', 'afflo'),
    (r'\bafflata\b', 'afflo'),
    (r'\bafflati\b', 'afflo'),
    (r'\bafflatibus\b', 'afflatus2'),
    (r'\bafflatu\b', 'afflatus2'),
    (r'\bafflatu\b', 'afflo'),
    (r'\bafflatum\b', 'afflatus2'),
    (r'\bafflatum\b', 'afflo'),
    (r'\bafflatus\b', 'afflatus2'),
    (r'\bafflatus\b', 'afflo'),
    (r'\bafflatuue\b', 'afflatus2'),
    (r'\bafflatuue\b', 'afflo'),
    (r'\bafflauerit\b', 'afflo'),
    (r'\bafflauit\b', 'afflo'),
    (r'\bafflaverit\b', 'afflo'),
    (r'\bafflavit\b', 'afflo'),
    (r'\bafflicta\b', 'affligo'),
    (r'\bafflicta\b', 'afflicto'),
    (r'\bafflictae\b', 'affligo'),
    (r'\bafflictam\b', 'affligo'),
    (r'\bafflictantem\b', 'afflicto'),
    (r'\bafflictarum\b', 'affligo'),
    (r'\bafflictas\b', 'affligo'),
    (r'\bafflictas\b', 'afflicto'),
    (r'\bafflictat\b', 'afflicto'),
    (r'\bafflicti\b', 'affligo'),
    (r'\bafflictis\b', 'affligo'),
    (r'\bafflicto\b', 'affligo'),
    (r'\bafflicto\b', 'afflicto'),
    (r'\bafflictos\b', 'affligo'),
    (r'\bafflictum\b', 'afflictus2'),
    (r'\bafflictum\b', 'affligo'),
    (r'\baffligar\b', 'affligo'),
    (r'\baffligat\b', 'affligo'),
    (r'\baffligebat\b', 'affligo'),
    (r'\baffligere\b', 'affligo'),
    (r'\baffligerentur\b', 'affligo'),
    (r'\baffligi\b', 'affligo'),
    (r'\baffligier\b', 'affligo'),
    (r'\baffligimur\b', 'affligo'),
    (r'\baffligit\b', 'affligo'),
    (r'\baffligitur\b', 'affligo'),
    (r'\baffliguntur\b', 'affligo'),
    (r'\bafflixit\b', 'affligo'),
    (r'\baffluam\b', 'affluo'),
    (r'\baffluant\b', 'affluo'),
    (r'\baffluat\b', 'affluo'),
    (r'\baffluatis\b', 'affluo'),
    (r'\baffluen\b', 'affluo'),
    (r'\baffluens\b', 'affluo'),
    (r'\baffluent\b', 'affluo'),
    (r'\baffluente\b', 'affluo'),
    (r'\baffluentem\b', 'affluo'),
    (r'\baffluentem\b', 'affluenter'),
    (r'\baffluenter\b', 'affluenter'),
    (r'\baffluentes\b', 'affluo'),
    (r'\baffluentes\b', 'affluenter'),
    (r'\baffluenti\b', 'affluo'),
    (r'\baffluentia\b', 'affluentia'),
    (r'\baffluentia\b', 'affluo'),
    (r'\baffluentiam\b', 'affluentia'),
    (r'\baffluentibus\b', 'affluo'),
    (r'\baffluentior\b', 'affluo'),
    (r'\baffluentiores\b', 'affluo'),
    (r'\baffluentis\b', 'affluo'),
    (r'\baffluentius\b', 'affluo'),
    (r'\baffluere\b', 'affluo'),
    (r'\bafflueret\b', 'affluo'),
    (r'\bafflues\b', 'affluo'),
    (r'\baffluet\b', 'affluo'),
    (r'\baffluit\b', 'affluo'),
    (r'\baffluxerit\b', 'affluo'),
    (r'\baffore\b', 'adsum'),
    (r'\bafforet\b', 'adsum'),
    (r'\baffricabit\b', 'affrico'),
    (r'\baffricantis\b', 'affrico'),
    (r'\baffrictu\b', 'affrictus'),
    (r'\baffrictu\b', 'affrico'),
    (r'\baffueram\b', 'adsum'),
    (r'\baffuerit\b', 'adsum'),
    (r'\baffuerunt\b', 'adsum'),
    (r'\baffui\b', 'adsum'),
    (r'\baffuisset\b', 'adsum'),
    (r'\baffuit\b', 'adsum'),
    (r'\baffulserat\b', 'affulgeo'),
    (r'\baffulsisse\b', 'affulgeo'),
    (r'\baffulsit\b', 'affulgeo'),
    (r'\baffunde\b', 'affundo'),
    (r'\baffundit\b', 'affundo'),
    (r'\baffunditur\b', 'affundo'),
    (r'\baffusa\b', 'affundo'),
    (r'\baffusum\b', 'affundo'),
    (r'\baffusus\b', 'affundo'),
    (r'\baffuturos\b', 'adsum'),
    (r'\baffuturum\b', 'adsum'),
    (r'\bafinio\b', 'a-for'),
    (r'\bafluam\b', 'a-for'),
    (r'\bafluant\b', 'a-for'),
    (r'\bafluat\b', 'a-for'),
    (r'\bafluens\b', 'a-for'),
    (r'\bafluentem\b', 'a-for'),
    (r'\bafluentem\b', 'a-for'),
    (r'\bafluenti\b', 'a-for'),
    (r'\bafluentia\b', 'a-for'),
    (r'\bafluere\b', 'a-for'),
    (r'\bafluit\b', 'a-for'),
    (r'\bafluunt\b', 'a-for'),
    (r'\bafore\b', 'a-sum1'),
    (r'\bAfrani\b', 'Afranius'),
    (r'\bAfrania\b', 'Afranius'),
    (r'\bAfraniae\b', 'Afranius'),
    (r'\bAfraniana\b', 'Afranius'),
    (r'\bAfraniani\b', 'Afranius'),
    (r'\bAfraniani\b', 'Afranius'),
    (r'\bAfranianis\b', 'Afranius'),
    (r'\bAfranianis\b', 'Afranius'),
    (r'\bAfranianos\b', 'Afranius'),
    (r'\bAfranianus\b', 'Afranius'),
    (r'\bAfranii\b', 'Afranius'),
    (r'\bAfranio\b', 'Afranius'),
    (r'\bAfranium\b', 'Afranius'),
    (r'\bAfraniumque\b', 'Afranius'),
    (r'\bAfranius\b', 'Afranius'),
    (r'\bAfraniusque\b', 'Afranius'),
    (r'\bAfrica\b', 'Africa'),
    (r'\bAfrica\b', 'a-frico'),
    (r'\bafrica\b', 'a-frico'),
    (r'\bAfricae\b', 'Africa'),
    (r'\bAfricam\b', 'Africa'),
    (r'\bAfricamque\b', 'Africa'),
    (r'\bAfricana\b', 'a-frico'),
    (r'\bAfricanae\b', 'a-frico'),
    (r'\bAfricanae\b', 'a-frico'),
    (r'\bAfricanam\b', 'a-frico'),
    (r'\bAfricanarum\b', 'a-frico'),
    (r'\bAfricanas\b', 'a-frico'),
    (r'\bAfricane\b', 'a-frico'),
    (r'\bafricane\b', 'a-frico'),
    (r'\bAfricani\b', 'a-frico'),
    (r'\bAfricanis\b', 'a-frico'),
    (r'\bAfricanis\b', 'a-frico'),
    (r'\bAfricano\b', 'a-frico'),
    (r'\bAfricanorum\b', 'a-frico'),
    (r'\bAfricanos\b', 'a-frico'),
    (r'\bAfricanum\b', 'a-frico'),
    (r'\bAfricanumve\b', 'a-frico'),
    (r'\bAfricanus\b', 'a-frico'),
    (r'\bAfrici\b', 'a-frico'),
    (r'\bAfricique\b', 'a-frico'),
    (r'\bAfricis\b', 'Africa'),
    (r'\bAfricis\b', 'a-frico'),
    (r'\bAfrico\b', 'a-frico'),
    (r'\bafrico\b', 'a-frico'),
    (r'\bAfricoque\b', 'a-frico'),
    (r'\bafricoque\b', 'a-frico'),
    (r'\bAfricum\b', 'a-frico'),
    (r'\bAfricus\b', 'a-frico'),
    (r'\bafueram\b', 'a-sum1'),
    (r'\bafuerant\b', 'a-sum1'),
    (r'\bafuerat\b', 'a-sum1'),
    (r'\bafuere\b', 'a-sum1'),
    (r'\bafuerim\b', 'a-sum1'),
    (r'\bafuerint\b', 'a-sum1'),
    (r'\bafueris\b', 'a-sum1'),
    (r'\bafuerit\b', 'a-sum1'),
    (r'\bafuerunt\b', 'a-sum1'),
    (r'\bafui\b', 'a-sum1'),
    (r'\bafuisse\b', 'a-sum1'),
    (r'\bafuissem\b', 'a-sum1'),
    (r'\bafuissent\b', 'a-sum1'),
    (r'\bafuisses\b', 'a-sum1'),
    (r'\bafuisset\b', 'a-sum1'),
    (r'\bafuisti\b', 'a-sum1'),
    (r'\bafuit\b', 'a-sum1'),
    (r'\bafutura\b', 'a-sum1'),
    (r'\bafuturam\b', 'a-sum1'),
    (r'\bafuturo\b', 'a-sum1'),
    (r'\bafuturosque\b', 'a-sum1'),
    (r'\bafuturum\b', 'a-sum1'),
    (r'\bafuturumque\b', 'a-sum1'),
    (r'\bafuturus\b', 'a-sum1'),
    (r'\bagam\b', 'ago'),
    (r'\bAgamede\b', 'Agamedes'),
    (r'\bAgamedes\b', 'Agamedes'),
    (r'\bAgamemno\b', 'Agamemnon'),
    (r'\bAgamemnon\b', 'Agamemnon'),
    (r'\bAgamemnone\b', 'Agamemnon'),
    (r'\bAgamemnonem\b', 'Agamemnon'),
    (r'\bAgamemnoni\b', 'Agamemnon'),
    (r'\bAgamemnoni\b', 'agamus'),
    (r'\bAgamemnoniae\b', 'agamus'),
    (r'\bAgamemnoniaeque\b', 'agamus'),
    (r'\bAgamemnoniam\b', 'agamus'),
    (r'\bAgamemnonias\b', 'agamus'),
    (r'\bAgamemnoniasque\b', 'agamus'),
    (r'\bAgamemnonidae\b', 'agamus'),
    (r'\bAgamemnonides\b', 'agamus'),
    (r'\bAgamemnoniis\b', 'agamus'),
    (r'\bAgamemnonio\b', 'agamus'),
    (r'\bAgamemnonios\b', 'agamus'),
    (r'\bAgamemnonis\b', 'Agamemnon'),
    (r'\bAgamemnonius\b', 'agamus'),
    (r'\bagamque\b', 'ago'),
    (r'\bagamus\b', 'agamus'),
    (r'\bagamus\b', 'ago'),
    (r'\bagan\b', 'ago'),
    (r'\bAganippe\b', 'Aganippe'),
    (r'\bAganippen\b', 'Aganippe'),
    (r'\bAganippes\b', 'Aganippe'),
    (r'\bagant\b', 'ago'),
    (r'\bagantur\b', 'ago'),
    (r'\bagar\b', 'ago'),
    (r'\bagarici\b', 'agaricum'),
    (r'\bagarico\b', 'agaricum'),
    (r'\bagaricum\b', 'agaricum'),
    (r'\bagaris\b', 'ago'),
    (r'\bagas\b', 'ago'),
    (r'\bagaso\b', 'agaso'),
    (r'\bagasone\b', 'agaso'),
    (r'\bagasonem\b', 'agaso'),
    (r'\bagasones\b', 'agaso'),
    (r'\bagasoni\b', 'agaso'),
    (r'\bagasonibus\b', 'agaso'),
    (r'\bagasonibusque\b', 'agaso'),
    (r'\bagasque\b', 'ago'),
    (r'\bagat\b', 'ago'),
    (r'\bAgathine\b', 'Agathocles'),
    (r'\bAgathini\b', 'Agathocles'),
    (r'\bAgathino\b', 'Agathocles'),
    (r'\bAgathinum\b', 'Agathocles'),
    (r'\bAgathinus\b', 'Agathocles'),
    (r'\bAgathocle\b', 'Agathocles'),
    (r'\bAgathocleae\b', 'Agathocleus'),
    (r'\bAgathocleis\b', 'Agathocleus'),
    (r'\bAgathoclem\b', 'Agathocles'),
    (r'\bAgathocles\b', 'Agathocles'),
    (r'\bAgathocli\b', 'Agathocles'),
    (r'\bAgathoclis\b', 'Agathocles'),
    (r'\bAgathyrna\b', 'Agathyrna'),
    (r'\bAgathyrnam\b', 'Agathyrna'),
    (r'\bAgathyrsi\b', 'Agathyrsi'),
    (r'\bagatis\b', 'ago'),
    (r'\bagatne\b', 'ago'),
    (r'\bagatque\b', 'ago'),
    (r'\bagatur\b', 'ago'),
    (r'\bAgaue\b', 'Agave'),
    (r'\bAgauen\b', 'Agave'),
    (r'\bAgaues\b', 'Agave'),
    (r'\bAgave\b', 'Agave'),
    (r'\bAgaves\b', 'Agave'),
    (r'\bage\b', 'ago'),
    (r'\bagea\b', 'agea'),
    (r'\bagebam\b', 'ago'),
    (r'\bagebamus\b', 'ago'),
    (r'\bagebant\b', 'ago'),
    (r'\bagebantque\b', 'ago'),
    (r'\bagebantur\b', 'ago'),
    (r'\bagebar\b', 'ago'),
    (r'\bagebas\b', 'ago'),
    (r'\bagebat\b', 'ago'),
    (r'\bagebatis\b', 'ago'),
    (r'\bagebatque\b', 'ago'),
    (r'\bagebatur\b', 'ago'),
    (r'\bagedum\b', 'agedum'),
    (r'\bAgelastum\b', 'agedum'),
    (r'\bagelle\b', 'agellus'),
    (r'\bagelli\b', 'agellus'),
    (r'\bagellis\b', 'agellus'),
    (r'\bagellist\b', 'agellus'),
    (r'\bagello\b', 'agellus'),
    (r'\bagellorum\b', 'agellus'),
    (r'\bagellos\b', 'agellus'),
    (r'\bagellulum\b', 'agellulus'),
    (r'\bagellum\b', 'agellus'),
    (r'\bagellus\b', 'agellus'),
    (r'\bagema\b', 'agema'),
    (r'\bagemus\b', 'ago'),
    (r'\bagemusque\b', 'ago'),
    (r'\bagen\b', 'ago'),
    (r'\bagenda\b', 'ago'),
    (r'\bagendae\b', 'ago'),
    (r'\bagendam\b', 'ago'),
    (r'\bagendaque\b', 'ago'),
    (r'\bagendarum\b', 'ago'),
    (r'\bagendas\b', 'ago'),
    (r'\bagendi\b', 'ago'),
    (r'\bagendique\b', 'ago'),
    (r'\bagendis\b', 'ago'),
    (r'\bagendo\b', 'ago'),
    (r'\bagendoque\b', 'ago'),
    (r'\bagendorum\b', 'ago'),
    (r'\bagendos\b', 'ago'),
    (r'\bagendum\b', 'ago'),
    (r'\bagendumst\b', 'ago'),
    (r'\bagendus\b', 'ago'),
    (r'\bagendusque\b', 'ago'),
    (r'\bAgenor\b', 'Agenor'),
    (r'\bAgenore\b', 'Agenor'),
    (r'\bAgenoreae\b', 'Agenorides'),
    (r'\bAgenoream\b', 'Agenorides'),
    (r'\bAgenoreas\b', 'Agenorides'),
    (r'\bAgenorei\b', 'Agenorides'),
    (r'\bAgenoreis\b', 'Agenorides'),
    (r'\bAgenorem\b', 'Agenor'),
    (r'\bAgenoreo\b', 'Agenorides'),
    (r'\bAgenoreos\b', 'Agenorides'),
    (r'\bAgenoreum\b', 'Agenorides'),
    (r'\bAgenoreus\b', 'Agenorides'),
    (r'\bAgenoridae\b', 'Agenorides'),
    (r'\bAgenoridas\b', 'Agenorides'),
    (r'\bAgenoride\b', 'Agenorides'),
    (r'\bAgenorides\b', 'Agenorides'),
    (r'\bAgenoridis\b', 'Agenorides'),
    (r'\bAgenoris\b', 'Agenor'),
    (r'\bagens\b', 'ago'),
    (r'\bagent\b', 'ago'),
    (r'\bagente\b', 'ago'),
    (r'\bagentem\b', 'ago'),
    (r'\bagentes\b', 'ago'),
    (r'\bagentesque\b', 'ago'),
    (r'\bagenti\b', 'ago'),
    (r'\bagentia\b', 'ago'),
    (r'\bagentibus\b', 'ago'),
    (r'\bagentis\b', 'ago'),
    (r'\bagentium\b', 'ago'),
    (r'\bagentur\b', 'ago'),
    (r'\bager\b', 'ager'),
    (r'\bageraton\b', 'ageraton'),
    (r'\bagere\b', 'ago'),
    (r'\bagerem\b', 'ago'),
    (r'\bageremus\b', 'ago'),
    (r'\bagerent\b', 'ago'),
    (r'\bagerentque\b', 'ago'),
    (r'\bagerentur\b', 'ago'),
    (r'\bagerenturque\b', 'ago'),
    (r'\bagerere\b', 'ago'),
    (r'\bageres\b', 'ago'),
    (r'\bagerest\b', 'ago'),
    (r'\bageret\b', 'ago'),
    (r'\bageretis\b', 'ago'),
    (r'\bageretque\b', 'ago'),
    (r'\bageretur\b', 'ago'),
    (r'\bagereturque\b', 'ago'),
    (r'\bageris\b', 'ago'),
    (r'\bagerque\b', 'ager'),
    (r'\bages\b', 'ago'),
    (r'\bAgesilae\b', 'Agesilaus'),
    (r'\bAgesilai\b', 'Agesilaus'),
    (r'\bAgesilao\b', 'Agesilaus'),
    (r'\bAgesilaos\b', 'Agesilaus'),
    (r'\bAgesilaum\b', 'Agesilaus'),
    (r'\bAgesilaumque\b', 'Agesilaus'),
    (r'\bAgesilaus\b', 'Agesilaus'),
    (r'\bagestes\b', 'a-gesto'),
    (r'\baget\b', 'ago'),
    (r'\bagetis\b', 'ago'),
    (r'\bagetur\b', 'ago'),
    (r'\baggemit\b', 'aggemo'),
    (r'\bagger\b', 'agger'),
    (r'\baggerabant\b', 'aggero1'),
    (r'\baggerabatur\b', 'aggero1'),
    (r'\baggeranda\b', 'aggero1'),
    (r'\baggerantur\b', 'aggero1'),
    (r'\baggerantur\b', 'aggero2'),
    (r'\baggerare\b', 'aggero1'),
    (r'\baggerare\b', 'aggero2'),
    (r'\baggerari\b', 'aggero1'),
    (r'\baggeras\b', 'aggero1'),
    (r'\baggeras\b', 'aggero2'),
    (r'\baggerat\b', 'aggero1'),
    (r'\baggerat\b', 'aggero2'),
    (r'\baggerata\b', 'aggero1'),
    (r'\baggeratae\b', 'aggero1'),
    (r'\baggerati\b', 'aggero1'),
    (r'\baggeratim\b', 'aggeratim'),
    (r'\baggerationem\b', 'aggeratio'),
    (r'\baggeratis\b', 'aggero1'),
    (r'\baggeratis\b', 'aggero2'),
    (r'\baggerato\b', 'aggero1'),
    (r'\baggeratus\b', 'aggero1'),
    (r'\baggere\b', 'agger'),
    (r'\baggere\b', 'aggero2'),
    (r'\baggerebant\b', 'aggero2'),
    (r'\baggerebatur\b', 'aggero2'),
    (r'\baggerem\b', 'agger'),
    (r'\baggerem\b', 'aggero1'),
    (r'\baggeremque\b', 'agger'),
    (r'\baggeremque\b', 'aggero1'),
    (r'\baggerens\b', 'aggero2'),
    (r'\baggerentem\b', 'aggero2'),
    (r'\baggerere\b', 'aggero2'),
    (r'\baggerere\b', 'aggero1'),
    (r'\baggeres\b', 'aggero2'),
    (r'\baggeres\b', 'agger'),
    (r'\baggeres\b', 'aggero1'),
    (r'\baggeret\b', 'aggero2'),
    (r'\baggeret\b', 'aggero1'),
    (r'\baggeretur\b', 'aggero2'),
    (r'\baggeretur\b', 'aggero1'),
    (r'\baggeri\b', 'agger'),
    (r'\baggeri\b', 'aggero2'),
    (r'\baggeribus\b', 'agger'),
    (r'\baggeribusque\b', 'agger'),
    (r'\baggerimus\b', 'aggero2'),
    (r'\baggerique\b', 'agger'),
    (r'\baggerique\b', 'aggero2'),
    (r'\baggeris\b', 'agger'),
    (r'\baggeris\b', 'aggero2'),
    (r'\baggerisque\b', 'agger'),
    (r'\baggerisque\b', 'aggero2'),
    (r'\baggeritur\b', 'aggero2'),
    (r'\baggerum\b', 'agger'),
    (r'\baggerunda\b', 'aggero2'),
    (r'\baggerundaque\b', 'aggero2'),
    (r'\baggerunt\b', 'aggero2'),
    (r'\baggessere\b', 'aggero2'),
    (r'\baggessi\b', 'aggero2'),
    (r'\baggesta\b', 'aggestus1'),
    (r'\baggesta\b', 'aggero2'),
    (r'\baggestis\b', 'aggestus2'),
    (r'\baggestis\b', 'aggestus1'),
    (r'\baggestis\b', 'aggero2'),
    (r'\baggestos\b', 'aggestus2'),
    (r'\baggestos\b', 'aggero2'),
    (r'\baggestu\b', 'aggestus1'),
    (r'\baggestu\b', 'aggero2'),
    (r'\baggestum\b', 'aggestus1'),
    (r'\baggestum\b', 'aggestus2'),
    (r'\baggestum\b', 'aggestus1'),
    (r'\baggestum\b', 'aggero2'),
    (r'\bagglutinant\b', 'agglutino'),
    (r'\baggrauas\b', 'aggravo'),
    (r'\baggrauet\b', 'aggravo'),
    (r'\baggravant\b', 'aggravo'),
    (r'\baggredere\b', 'aggredio'),
    (r'\baggrederentur\b', 'aggredio'),
    (r'\baggrederetur\b', 'aggredio'),
    (r'\baggrederis\b', 'aggredio'),
    (r'\baggredi\b', 'aggredio'),
    (r'\baggrediar\b', 'aggredio'),
    (r'\baggredienda\b', 'aggredio'),
    (r'\baggrediendi\b', 'aggredio'),
    (r'\baggredienti\b', 'aggredio'),
    (r'\baggredietur\b', 'aggredio'),
    (r'\baggredimur\b', 'aggredio'),
    (r'\baggredior\b', 'aggredio'),
    (r'\baggreditur\b', 'aggredio'),
    (r'\baggrediuntur\b', 'aggredio'),
    (r'\baggressa\b', 'aggredior'),
    (r'\baggressam\b', 'aggredior'),
    (r'\baggressi\b', 'aggredior'),
    (r'\baggressione\b', 'aggressio'),
    (r'\baggressum\b', 'aggressus2'),
    (r'\baggressum\b', 'aggredior'),
    (r'\baggressuri\b', 'aggredior'),
    (r'\baggressuros\b', 'aggredior'),
    (r'\baggressurus\b', 'aggredior'),
    (r'\baggressus\b', 'aggressus2'),
    (r'\baggressus\b', 'aggredior'),
    (r'\bagi\b', 'ago'),
    (r'\bagier\b', 'ago'),
    (r'\bagile\b', 'agilis'),
    (r'\bagilem\b', 'agilis'),
    (r'\bagilemque\b', 'agilis'),
    (r'\bagiles\b', 'agilis'),
    (r'\bagili\b', 'agilis'),
    (r'\bagilia\b', 'agilis'),
    (r'\bagilibus\b', 'agilis'),
    (r'\bagilior\b', 'agilis'),
    (r'\bagiliore\b', 'agilis'),
    (r'\bagiliores\b', 'agilis'),
    (r'\bagilioribus\b', 'agilis'),
    (r'\bagiliorque\b', 'agilis'),
    (r'\bagilique\b', 'agilis'),
    (r'\bagilis\b', 'agilis'),
    (r'\bagilisque\b', 'agilis'),
    (r'\bagilissimus\b', 'agilis'),
    (r'\bagilitas\b', 'agilitas'),
    (r'\bagilitate\b', 'agilitas'),
    (r'\bagilitatem\b', 'agilitas'),
    (r'\bagilitatis\b', 'agilitas'),
    (r'\bagiliter\b', 'agilis'),
    (r'\bagiliter\b', 'agiliter'),
    (r'\bagilius\b', 'agilis'),
    (r'\bagimur\b', 'ago'),
    (r'\bagimus\b', 'ago'),
    (r'\bAgin\b', 'Agis'),
    (r'\bagin\b', 'ago'),
    (r'\bagina\b', 'agina'),
    (r'\baginam\b', 'agina'),
    (r'\bagipes\b', 'agipes'),
    (r'\bagique\b', 'ago'),
    (r'\bAgis\b', 'Agis'),
    (r'\bagis\b', 'ago'),
    (r'\bagisque\b', 'ago'),
    (r'\bagist\b', 'ago'),
    (r'\bagit\b', 'ago'),
    (r'\bagita\b', 'agito'),
    (r'\bagitabam\b', 'agito'),
    (r'\bagitabamus\b', 'agito'),
    (r'\bagitabant\b', 'agito'),
    (r'\bagitabantque\b', 'agito'),
    (r'\bagitabantur\b', 'agito'),
    (r'\bagitabanturque\b', 'agito'),
    (r'\bagitabas\b', 'agito'),
    (r'\bagitabat\b', 'agito'),
    (r'\bagitabatur\b', 'agito'),
    (r'\bagitabere\b', 'agito'),
    (r'\bagitaberis\b', 'agito'),
    (r'\bagitabilis\b', 'agitabilis'),
    (r'\bagitabis\b', 'agito'),
    (r'\bagitabit\b', 'agito'),
    (r'\bagitabitur\b', 'agito'),
    (r'\bagitabo\b', 'agito'),
    (r'\bagitabunt\b', 'agito'),
    (r'\bagitamus\b', 'agito'),
    (r'\bagitanda\b', 'agito'),
    (r'\bagitandi\b', 'agito'),
    (r'\bagitandis\b', 'agito'),
    (r'\bagitando\b', 'agito'),
    (r'\bagitandoque\b', 'agito'),
    (r'\bagitandum\b', 'agito'),
    (r'\bagitandumst\b', 'agito'),
    (r'\bagitandus\b', 'agito'),
    (r'\bagitans\b', 'agito'),
    (r'\bagitant\b', 'agito'),
    (r'\bagitante\b', 'agito'),
    (r'\bagitantem\b', 'agito'),
    (r'\bagitantes\b', 'agito'),
    (r'\bagitanti\b', 'agito'),
    (r'\bagitantia\b', 'agito'),
    (r'\bagitantibus\b', 'agito'),
    (r'\bagitantis\b', 'agito'),
    (r'\bagitantium\b', 'agito'),
    (r'\bagitantque\b', 'agito'),
    (r'\bagitantur\b', 'agito'),
    (r'\bagitaram\b', 'agito'),
    (r'\bagitare\b', 'agito'),
    (r'\bagitarem\b', 'agito'),
    (r'\bagitarent\b', 'agito'),
    (r'\bagitarentur\b', 'agito'),
    (r'\bagitares\b', 'agito'),
    (r'\bagitaret\b', 'agito'),
    (r'\bagitaretur\b', 'agito'),
    (r'\bagitari\b', 'agito'),
    (r'\bagitarique\b', 'agito'),
    (r'\bagitaris\b', 'agito'),
    (r'\bagitarit\b', 'agito'),
    (r'\bagitas\b', 'agito'),
    (r'\bagitasse\b', 'agito'),
    (r'\bagitassem\b', 'agito'),
    (r'\bagitassent\b', 'agito'),
    (r'\bagitasses\b', 'agito'),
    (r'\bagitasset\b', 'agito'),
    (r'\bagitasti\b', 'agito'),
    (r'\bagitat\b', 'agito'),
    (r'\bagitata\b', 'agito'),
    (r'\bagitatae\b', 'agito'),
    (r'\bagitataeque\b', 'agito'),
    (r'\bagitatam\b', 'agito'),
    (r'\bagitataque\b', 'agito'),
    (r'\bagitate\b', 'agito'),
    (r'\bagitati\b', 'agito'),
    (r'\bagitatio\b', 'agitatio'),
    (r'\bagitatione\b', 'agitatio'),
    (r'\bagitationem\b', 'agitatio'),
    (r'\bagitationes\b', 'agitatio'),
    (r'\bagitationi\b', 'agitatio'),
    (r'\bagitationibus\b', 'agitatio'),
    (r'\bagitationis\b', 'agitatio'),
    (r'\bagitatioque\b', 'agitatio'),
    (r'\bagitatior\b', 'agito'),
    (r'\bagitatiora\b', 'agito'),
    (r'\bagitatiorem\b', 'agito'),
    (r'\bagitatis\b', 'agito'),
    (r'\bagitato\b', 'agito'),
    (r'\bagitatoque\b', 'agito'),
    (r'\bagitator\b', 'agitator'),
    (r'\bagitatore\b', 'agitator'),
    (r'\bagitatorem\b', 'agitator'),
    (r'\bagitatores\b', 'agitator'),
    (r'\bagitatori\b', 'agitator'),
    (r'\bagitatorum\b', 'agitator'),
    (r'\bagitatorum\b', 'agito'),
    (r'\bagitatos\b', 'agito'),
    (r'\bagitatque\b', 'agito'),
    (r'\bagitatricem\b', 'agitatrix'),
    (r'\bagitatu\b', 'agitatus'),
    (r'\bagitatu\b', 'agito'),
    (r'\bagitatum\b', 'agitatus'),
    (r'\bagitatum\b', 'agito'),
    (r'\bagitatumque\b', 'agitatus'),
    (r'\bagitatumque\b', 'agito'),
    (r'\bagitatur\b', 'agito'),
    (r'\bagitaturus\b', 'agito'),
    (r'\bagitatus\b', 'agitatus'),
    (r'\bagitatus\b', 'agito'),
    (r'\bagitatusque\b', 'agitatus'),
    (r'\bagitatusque\b', 'agito'),
    (r'\bagitauerant\b', 'agito'),
    (r'\bagitauerat\b', 'agito'),
    (r'\bagitauere\b', 'agito'),
    (r'\bagitauerit\b', 'agito'),
    (r'\bagitauerunt\b', 'agito'),
    (r'\bagitaui\b', 'agito'),
    (r'\bagitauimus\b', 'agito'),
    (r'\bagitauit\b', 'agito'),
    (r'\bagitaverant\b', 'agito'),
    (r'\bagitaverat\b', 'agito'),
    (r'\bagitavere\b', 'agito'),
    (r'\bagitaverint\b', 'agito'),
    (r'\bagitaverit\b', 'agito'),
    (r'\bagitavi\b', 'agito'),
    (r'\bagitavimus\b', 'agito'),
    (r'\bagitavisse\b', 'agito'),
    (r'\bagitavit\b', 'agito'),
    (r'\bagite\b', 'ago'),
    (r'\bagitem\b', 'agito'),
    (r'\bagitemus\b', 'agito'),
    (r'\bagitent\b', 'agito'),
    (r'\bagitentque\b', 'agito'),
    (r'\bagitentur\b', 'agito'),
    (r'\bagites\b', 'agito'),
    (r'\bagitet\b', 'agito'),
    (r'\bagitetur\b', 'agito'),
    (r'\bagiteturque\b', 'agito'),
    (r'\bagitis\b', 'ago'),
    (r'\bagito\b', 'ago'),
    (r'\bagito\b', 'agito'),
    (r'\bagitor\b', 'agito'),
    (r'\bagitque\b', 'ago'),
    (r'\bagitur\b', 'ago'),
    (r'\bagiturque\b', 'ago'),
    (r'\bAglaophon\b', 'Aglaophon'),
    (r'\baglaophotide\b', 'aglaophotis'),
    (r'\bAglauro\b', 'Aglauros'),
    (r'\bAglauros\b', 'Aglauros'),
    (r'\bagmen\b', 'agmen'),
    (r'\bagmenque\b', 'agmen'),
    (r'\bagmina\b', 'agmen'),
    (r'\bagminales\b', 'agminalis'),
    (r'\bagminaque\b', 'agmen'),
    (r'\bagminatim\b', 'agminatim'),
    (r'\bagmine\b', 'agmen'),
    (r'\bagmini\b', 'agmen'),
    (r'\bagminibus\b', 'agmen'),
    (r'\bagminis\b', 'agmen'),
    (r'\bagminum\b', 'agmen'),
    (r'\bagminumque\b', 'agmen'),
    (r'\bagna\b', 'agna1'),
    (r'\bagnae\b', 'agna1'),
    (r'\bAgnalia\b', 'Agnalia'),
    (r'\bagnam\b', 'agna1'),
    (r'\bagnamve\b', 'agna1'),
    (r'\bagnaque\b', 'agna1'),
    (r'\bagnas\b', 'agna1'),
    (r'\bagnascendo\b', 'agnascor'),
    (r'\bagnascentibus\b', 'agnascor'),
    (r'\bagnascitur\b', 'agnascor'),
    (r'\bagnata\b', 'agnascor'),
    (r'\bagnatae\b', 'agnascor'),
    (r'\bagnati\b', 'agnascor'),
    (r'\bagnatio\b', 'agnatio'),
    (r'\bagnatione\b', 'agnatio'),
    (r'\bagnationem\b', 'agnatio'),
    (r'\bagnationes\b', 'agnatio'),
    (r'\bagnationibus\b', 'agnatio'),
    (r'\bagnationis\b', 'agnatio'),
    (r'\bagnationum\b', 'agnatio'),
    (r'\bagnatis\b', 'agnascor'),
    (r'\bagnato\b', 'agnascor'),
    (r'\bagnatorum\b', 'agnascor'),
    (r'\bagnatos\b', 'agnascor'),
    (r'\bagnatosque\b', 'agnascor'),
    (r'\bagnatum\b', 'agnascor'),
    (r'\bagnatus\b', 'agnascor'),
    (r'\bagnellum\b', 'agnellus'),
    (r'\bagnellus\b', 'agnellus'),
    (r'\bagni\b', 'agnos'),
    (r'\bagni\b', 'agnus'),
    (r'\bagnina\b', 'agninus'),
    (r'\bagnina\b', 'agninus'),
    (r'\bagninae\b', 'agninus'),
    (r'\bagninam\b', 'agninus'),
    (r'\bagninas\b', 'agninus'),
    (r'\bagninis\b', 'agninus'),
    (r'\bagninis\b', 'agninus'),
    (r'\bagnino\b', 'agninus'),
    (r'\bagninorum\b', 'agninus'),
    (r'\bagninove\b', 'agninus'),
    (r'\bagninum\b', 'agninus'),
    (r'\bagninus\b', 'agninus'),
    (r'\bagnique\b', 'agnos'),
    (r'\bagnique\b', 'agnus'),
    (r'\bagnis\b', 'agna1'),
    (r'\bagnis\b', 'agnus'),
    (r'\bagnitio\b', 'agnitio'),
    (r'\bagnitione\b', 'agnitio'),
    (r'\bagnitionem\b', 'agnitio'),
    (r'\bagnitioni\b', 'agnitio'),
    (r'\bagnitionis\b', 'agnitio'),
    (r'\bagnitor\b', 'agnitor'),
    (r'\bagnitore\b', 'agnitor'),
    (r'\bagno\b', 'agnos'),
    (r'\bagno\b', 'agnus'),
    (r'\bagnomen\b', 'agnomen'),
    (r'\bagnomina\b', 'agnomen'),
    (r'\bagnominibus\b', 'agnomen'),
    (r'\bagnominumque\b', 'agnomen'),
    (r'\bagnon\b', 'agnos'),
    (r'\bagnon\b', 'agnus'),
    (r'\bagnone\b', 'agnos'),
    (r'\bagnone\b', 'agnus'),
    (r'\bagnorum\b', 'agnos'),
    (r'\bagnorum\b', 'agnus'),
    (r'\bagnos\b', 'agnos'),
    (r'\bagnos\b', 'agnus'),
    (r'\bagnoscam\b', 'agnosco'),
    (r'\bagnoscamus\b', 'agnosco'),
    (r'\bagnoscant\b', 'agnosco'),
    (r'\bagnoscantur\b', 'agnosco'),
    (r'\bagnoscar\b', 'agnosco'),
    (r'\bagnoscas\b', 'agnosco'),
    (r'\bagnoscat\b', 'agnosco'),
    (r'\bagnoscatis\b', 'agnosco'),
    (r'\bagnoscatur\b', 'agnosco'),
    (r'\bagnosce\b', 'agnosco'),
    (r'\bagnoscebam\b', 'agnosco'),
    (r'\bagnoscebamus\b', 'agnosco'),
    (r'\bagnoscebant\b', 'agnosco'),
    (r'\bagnoscebas\b', 'agnosco'),
    (r'\bagnoscebat\b', 'agnosco'),
    (r'\bagnoscebatur\b', 'agnosco'),
    (r'\bagnoscenda\b', 'agnosco'),
    (r'\bagnoscendae\b', 'agnosco'),
    (r'\bagnoscende\b', 'agnosco'),
    (r'\bagnoscendi\b', 'agnosco'),
    (r'\bagnoscendis\b', 'agnosco'),
    (r'\bagnoscendo\b', 'agnosco'),
    (r'\bagnoscendum\b', 'agnosco'),
    (r'\bagnoscendus\b', 'agnosco'),
    (r'\bagnoscens\b', 'agnosco'),
    (r'\bagnoscensque\b', 'agnosco'),
    (r'\bagnoscent\b', 'agnosco'),
    (r'\bagnoscente\b', 'agnosco'),
    (r'\bagnoscentem\b', 'agnosco'),
    (r'\bagnoscentes\b', 'agnosco'),
    (r'\bagnoscentibus\b', 'agnosco'),
    (r'\bagnoscentis\b', 'agnosco'),
    (r'\bagnoscere\b', 'agnosco'),
    (r'\bagnoscerem\b', 'agnosco'),
    (r'\bagnoscerent\b', 'agnosco'),
    (r'\bagnoscerentur\b', 'agnosco'),
    (r'\bagnosceres\b', 'agnosco'),
    (r'\bagnosceret\b', 'agnosco'),
    (r'\bagnosceretur\b', 'agnosco'),
    (r'\bagnosceris\b', 'agnosco'),
    (r'\bagnosces\b', 'agnosco'),
    (r'\bagnoscet\b', 'agnosco'),
    (r'\bagnoscetur\b', 'agnosco'),
    (r'\bagnosci\b', 'agnosco'),
    (r'\bagnoscimus\b', 'agnosco'),
    (r'\bagnoscis\b', 'agnosco'),
    (r'\bagnoscisne\b', 'agnosco'),
    (r'\bagnoscit\b', 'agnosco'),
    (r'\bagnoscite\b', 'agnosco'),
    (r'\bagnoscitis\b', 'agnosco'),
    (r'\bagnoscitque\b', 'agnosco'),
    (r'\bagnoscitur\b', 'agnosco'),
    (r'\bagnosco\b', 'agnosco'),
    (r'\bagnoscoque\b', 'agnosco'),
    (r'\bagnoscunt\b', 'agnosco'),
    (r'\bagnoscuntur\b', 'agnosco'),
    (r'\bagnota\b', 'anquina'),
    (r'\bagnoturum\b', 'anquina'),
    (r'\bagnotus\b', 'anquina'),
    (r'\bagnouerat\b', 'anquina'),
    (r'\bagnouere\b', 'anquina'),
    (r'\bagnouerint\b', 'anquina'),
    (r'\bagnouerit\b', 'anquina'),
    (r'\bagnouerunt\b', 'anquina'),
    (r'\bagnoui\b', 'anquina'),
    (r'\bagnouimus\b', 'anquina'),
    (r'\bagnouisse\b', 'anquina'),
    (r'\bagnouissem\b', 'anquina'),
    (r'\bagnouit\b', 'anquina'),
    (r'\bagnouitque\b', 'anquina'),
    (r'\bagnoverat\b', 'anquina'),
    (r'\bagnovere\b', 'anquina'),
    (r'\bagnoverim\b', 'anquina'),
    (r'\bagnoverimus\b', 'anquina'),
    (r'\bagnoverint\b', 'anquina'),
    (r'\bagnoverit\b', 'anquina'),
    (r'\bagnoverunt\b', 'anquina'),
    (r'\bagnovi\b', 'anquina'),
    (r'\bagnovimus\b', 'anquina'),
    (r'\bagnovique\b', 'anquina'),
    (r'\bagnovisse\b', 'anquina'),
    (r'\bagnovissent\b', 'anquina'),
    (r'\bagnovisset\b', 'anquina'),
    (r'\bagnovisti\b', 'anquina'),
    (r'\bagnovit\b', 'anquina'),
    (r'\bagnovitque\b', 'anquina'),
    (r'\bagnum\b', 'agnos'),
    (r'\bagnum\b', 'agnus'),
    (r'\bagnus\b', 'agnus'),
    (r'\bagnusue\b', 'agnus'),
    (r'\bago\b', 'ago'),
    (r'\bagogas\b', 'agogae'),
    (r'\bagon\b', 'agon'),
    (r'\bAgonalem\b', 'Agonalis'),
    (r'\bAgonales\b', 'Agonalis'),
    (r'\bAgonali\b', 'Agonalis'),
    (r'\bAgonalia\b', 'Agnalia'),
    (r'\bagone\b', 'agon'),
    (r'\bagonem\b', 'agon'),
    (r'\bAgonensium\b', 'Agonensis'),
    (r'\bagones\b', 'agon'),
    (r'\bagoni\b', 'agon'),
    (r'\bagoni\b', 'agonium'),
    (r'\bagonia\b', 'agonia'),
    (r'\bagonia\b', 'agonium'),
    (r'\bagonibus\b', 'agon'),
    (r'\bAgonidem\b', 'Agonis'),
    (r'\bagonidem\b', 'agon'),
    (r'\bagonidem\b', 'agonium'),
    (r'\bAgonidis\b', 'Agonis'),
    (r'\bAgonis\b', 'Agonis'),
    (r'\bagonis\b', 'agon'),
    (r'\bagonotheta\b', 'agonotheta'),
    (r'\bagonothetas\b', 'agonotheta'),
    (r'\bagonum\b', 'agon'),
    (r'\bagor\b', 'ago'),
    (r'\bagoranomum\b', 'agoranomus'),
    (r'\bagoranomus\b', 'agoranomus'),
    (r'\bAgraganti\b', 'Agragas'),
    (r'\bAgragantinas\b', 'a-gradior'),
    (r'\bAgragantinis\b', 'a-gradior'),
    (r'\bAgragantino\b', 'a-gradior'),
    (r'\bAgragantum\b', 'Agragas'),
    (r'\bAgragas\b', 'Agragas'),
    (r'\bagrari\b', 'agrarius'),
    (r'\bagraria\b', 'agrarius'),
    (r'\bagrariae\b', 'agrarius'),
    (r'\bagrariam\b', 'agrarius'),
    (r'\bagrarias\b', 'agrarius'),
    (r'\bagrarii\b', 'agrarius'),
    (r'\bagrarii\b', 'agrarius'),
    (r'\bagrariis\b', 'agrarius'),
    (r'\bagrariis\b', 'agrarius'),
    (r'\bagrariorum\b', 'agrarius'),
    (r'\bagrariorum\b', 'agrarius'),
    (r'\bagrarios\b', 'agrarius'),
    (r'\bagrarium\b', 'agrarius'),
    (r'\bagrarium\b', 'agrarius'),
    (r'\bagre\b', 'ager'),
    (r'\bagressa\b', 'a-gradior'),
    (r'\bagressi\b', 'a-gradior'),
    (r'\bagrest\b', 'ager'),
    (r'\bagreste\b', 'agrestis'),
    (r'\bagrestem\b', 'agrestis'),
    (r'\bagrestemque\b', 'agrestis'),
    (r'\bagrestes\b', 'agrestis'),
    (r'\bagrestesque\b', 'agrestis'),
    (r'\bagresti\b', 'agrestis'),
    (r'\bagrestia\b', 'agrestis'),
    (r'\bagrestibus\b', 'agrestis'),
    (r'\bagrestibusque\b', 'agrestis'),
    (r'\bagrestior\b', 'agrestis'),
    (r'\bagrestioribus\b', 'agrestis'),
    (r'\bagrestique\b', 'agrestis'),
    (r'\bagrestis\b', 'agrestis'),
    (r'\bagrestisque\b', 'agrestis'),
    (r'\bagrestium\b', 'agrestis'),
    (r'\bagrestiumque\b', 'agrestis'),
    (r'\bagrestius\b', 'agrestis'),
    (r'\bagri\b', 'ager'),
    (r'\bAgri\b', 'Agrius2'),
    (r'\bagri\b', 'agrius1'),
    (r'\bagria\b', 'agrius1'),
    (r'\bagrian\b', 'agrius1'),
    (r'\bAgrianes\b', 'agricola1'),
    (r'\bAgrianum\b', 'agricola1'),
    (r'\bagrias\b', 'agrius1'),
    (r'\bagricola\b', 'agricola1'),
    (r'\bAgricola\b', 'Agricola2'),
    (r'\bagricolae\b', 'agricola1'),
    (r'\bAgricolae\b', 'Agricola2'),
    (r'\bagricolaeque\b', 'agricola1'),
    (r'\bAgricolaeque\b', 'Agricola2'),
    (r'\bagricolam\b', 'agricola1'),
    (r'\bAgricolam\b', 'Agricola2'),
    (r'\bagricolarum\b', 'agricola1'),
    (r'\bagricolas\b', 'agricola1'),
    (r'\bAgricolas\b', 'Agricola2'),
    (r'\bagricolatio\b', 'agricolatio'),
    (r'\bagricolatione\b', 'agricolatio'),
    (r'\bagricolationem\b', 'agricolatio'),
    (r'\bagricolationi\b', 'agricolatio'),
    (r'\bagricolationis\b', 'agricolatio'),
    (r'\bagricolis\b', 'agricola1'),
    (r'\bagricolisve\b', 'agricola1'),
    (r'\bagricultores\b', 'agricultor'),
    (r'\bagricultoribus\b', 'agricultor'),
    (r'\bagricultura\b', 'agricultura'),
    (r'\bagriculturae\b', 'agricultura'),
    (r'\bagriculturam\b', 'agricultura'),
    (r'\bAgrigenti\b', 'Agrigentum'),
    (r'\bAgrigentini\b', 'Agrigentum'),
    (r'\bAgrigentini\b', 'Agrigentum'),
    (r'\bAgrigentinis\b', 'Agrigentum'),
    (r'\bAgrigentinis\b', 'Agrigentum'),
    (r'\bAgrigentino\b', 'Agrigentum'),
    (r'\bAgrigentinorum\b', 'Agrigentum'),
    (r'\bAgrigentinorum\b', 'Agrigentum'),
    (r'\bAgrigentinos\b', 'Agrigentum'),
    (r'\bAgrigentinum\b', 'Agrigentum'),
    (r'\bAgrigentinum\b', 'Agrigentum'),
    (r'\bAgrigentinus\b', 'Agrigentum'),
    (r'\bAgrigento\b', 'Agrigentum'),
    (r'\bAgrigentum\b', 'Agrigentum'),
    (r'\bAgrii\b', 'Agrius2'),
    (r'\bagrii\b', 'agrius1'),
    (r'\bagrimensori\b', 'agrimensor'),
    (r'\bAgrion\b', 'Agrius2'),
    (r'\bagrion\b', 'agrius1'),
    (r'\bagrios\b', 'agrius1'),
    (r'\bAgrios\b', 'Agrius2'),
    (r'\bagripeta\b', 'agripeta'),
    (r'\bagripetas\b', 'agripeta'),
    (r'\bAgrippa\b', 'Agrippa'),
    (r'\bAgrippae\b', 'Agrippa'),
    (r'\bAgrippam\b', 'Agrippa'),
    (r'\bAgrippas\b', 'Agrippa'),
    (r'\bAgrippina\b', 'Agrippina'),
    (r'\bAgrippinae\b', 'Agrippina'),
    (r'\bAgrippinaeque\b', 'Agrippina'),
    (r'\bAgrippinam\b', 'Agrippina'),
    (r'\bAgrippinas\b', 'Agrippina'),
    (r'\bagrique\b', 'ager'),
    (r'\bagrique\b', 'agrius1'),
    (r'\bagris\b', 'ager'),
    (r'\bagrisque\b', 'ager'),
    (r'\bagrisue\b', 'ager'),
    (r'\bagriue\b', 'ager'),
    (r'\bagriue\b', 'agrius1'),
    (r'\bAgrium\b', 'Agrius2'),
    (r'\bagrium\b', 'agrius1'),
    (r'\bagrius\b', 'agrius1'),
    (r'\bAgrius\b', 'Agrius2'),
    (r'\bagro\b', 'ager'),
    (r'\bagrone\b', 'ager'),
    (r'\bagroque\b', 'ager'),
    (r'\bagrorum\b', 'ager'),
    (r'\bagrorumque\b', 'ager'),
    (r'\bagros\b', 'ager'),
    (r'\bagrosque\b', 'ager'),
    (r'\bagrosus\b', 'agrosus'),
    (r'\bagroue\b', 'ager'),
    (r'\bagrum\b', 'ager'),
    (r'\bagrumque\b', 'ager'),
    (r'\bagunda\b', 'ago'),
    (r'\bagundae\b', 'ago'),
    (r'\bagundam\b', 'ago'),
    (r'\bagundarum\b', 'ago'),
    (r'\bagundi\b', 'ago'),
    (r'\bagundis\b', 'ago'),
    (r'\bagundo\b', 'ago'),
    (r'\bagundum\b', 'ago'),
    (r'\bagunt\b', 'ago'),
    (r'\bagunto\b', 'ago'),
    (r'\baguntque\b', 'ago'),
    (r'\baguntur\b', 'ago'),
    (r'\bAgusium\b', 'Agusius'),
    (r'\bAgusius\b', 'Agusius'),
    (r'\bAgylla\b', 'Agylla'),
    (r'\bAgyllam\b', 'Agylla'),
    (r'\bAgyri\b', 'Agyrium'),
    (r'\bAgyrinense\b', 'Agyrium'),
    (r'\bAgyrinenses\b', 'Agyrium'),
    (r'\bAgyrinensi\b', 'Agyrium'),
    (r'\bAgyrinensibus\b', 'Agyrium'),
    (r'\bAgyrinensis\b', 'Agyrium'),
    (r'\bAgyrinensium\b', 'Agyrium'),
    (r'\bAgyrio\b', 'Agyrium'),
    (r'\bAgyrium\b', 'Agyrium'),
    (r'\bah\b', 'ah'),
    (r'\baha\b', 'aha'),
    (r'\bAhala\b', 'Ahala'),
    (r'\bahala\b', 'a-halo'),
    (r'\bAhalae\b', 'Ahala'),
    (r'\bAhalam\b', 'Ahala'),
    (r'\bAhalas\b', 'Ahala'),
    (r'\bahalas\b', 'a-halo'),
    (r'\bAharnam\b', 'a-halo'),
    (r'\bahena\b', 'aenus3'),
    (r'\bahenae\b', 'aenus3'),
    (r'\bahenea\b', 'aeneus'),
    (r'\baheneam\b', 'aeneus'),
    (r'\baheneas\b', 'aeneus'),
    (r'\bahenei\b', 'aeneus'),
    (r'\baheneo\b', 'aeneus'),
    (r'\baheneos\b', 'aeneus'),
    (r'\baheneum\b', 'aeneus'),
    (r'\baheni\b', 'aenus3'),
    (r'\bahenis\b', 'aenus3'),
    (r'\baheno\b', 'aenus3'),
    (r'\bAhenobarbi\b', 'ai'),
    (r'\bAhenobarbo\b', 'ai'),
    (r'\bAhenobarbum\b', 'ai'),
    (r'\bAhenobarbus\b', 'ai'),
    (r'\bahenos\b', 'aenus3'),
    (r'\bahenum\b', 'aenus3'),
    (r'\bahia\b', 'ai'),
    (r'\bahias\b', 'ai'),
    (r'\bahio\b', 'ai'),
    (r'\bahion\b', 'ai'),
    (r'\bai\b', 'ai'),
    (r'\bAiace\b', 'a-jacio'),
    (r'\baiace\b', 'a-jacio'),
    (r'\bAiacem\b', 'a-jacio'),
    (r'\bAiacen\b', 'a-jacio'),
    (r'\baiacen\b', 'a-jacio'),
    (r'\bAiaces\b', 'a-jacio'),
    (r'\baiaces\b', 'a-jacio'),
    (r'\bAiacesque\b', 'a-jacio'),
    (r'\baiacesque\b', 'a-jacio'),
    (r'\bAiaci\b', 'a-jacio'),
    (r'\baiaci\b', 'a-jacio'),
    (r'\bAiacis\b', 'a-jacio'),
    (r'\baiacis\b', 'a-jacio'),
    (r'\bAiacisque\b', 'a-jacio'),
    (r'\baiacisque\b', 'a-jacio'),
    (r'\baiant\b', 'aio'),
    (r'\baias\b', 'aio'),
    (r'\baiat\b', 'aio'),
    (r'\bAiax\b', 'a-jacio'),
    (r'\bAiaxque\b', 'a-jacio'),
    (r'\baibant\b', 'aio'),
    (r'\baibas\b', 'aio'),
    (r'\baibat\b', 'aio'),
    (r'\baiebam\b', 'aio'),
    (r'\baiebamus\b', 'aio'),
    (r'\baiebant\b', 'aio'),
    (r'\baiebas\b', 'aio'),
    (r'\baiebat\b', 'aio'),
    (r'\baiebatis\b', 'aio'),
    (r'\baiens\b', 'a-eo1'),
    (r'\baii\b', 'a-eo1'),
    (r'\bain\b', 'ai'),
    (r'\bAin\b', 'aio'),
    (r'\bain\b', 'aio'),
    (r'\baio\b', 'aio'),
    (r'\bais\b', 'aio'),
    (r'\baisne\b', 'aio'),
    (r'\bait\b', 'aio'),
    (r'\baitque\b', 'aio'),
    (r'\baiunt\b', 'aio'),
    (r'\baiuntque\b', 'aio'),
    (r'\baizoi\b', 'aizoon'),
    (r'\baizoo\b', 'aizoon'),
    (r'\baizoum\b', 'aizoon'),
    (r'\bala\b', 'ala'),
    (r'\bala\b', 'alum'),
    (r'\bAlabanda\b', 'Alabanda'),
    (r'\balabanda\b', 'alacer'),
    (r'\bAlabandensem\b', 'Alabandicus'),
    (r'\bAlabandenses\b', 'Alabandicus'),
    (r'\bAlabandensi\b', 'Alabandicus'),
    (r'\bAlabandensibus\b', 'Alabandicus'),
    (r'\bAlabandensis\b', 'Alabandicus'),
    (r'\bAlabandensisque\b', 'Alabandicus'),
    (r'\bAlabandica\b', 'Alabandicus'),
    (r'\bAlabandico\b', 'Alabandicus'),
    (r'\bAlabandicos\b', 'Alabandicus'),
    (r'\bAlabandicus\b', 'Alabandicus'),
    (r'\bAlabandis\b', 'Alabanda'),
    (r'\balabandis\b', 'alacer'),
    (r'\balabandum\b', 'alacer'),
    (r'\bAlabandum\b', 'Alabanda'),
    (r'\balabandus\b', 'alacer'),
    (r'\balabaster\b', 'alabaster'),
    (r'\balabastra\b', 'alabastrites'),
    (r'\balabastris\b', 'alabaster'),
    (r'\balabastris\b', 'alabastrites'),
    (r'\balabastritae\b', 'alabastrites'),
    (r'\balabastrite\b', 'alabastrites'),
    (r'\balabastriten\b', 'alabastrites'),
    (r'\balabastritis\b', 'alabastrites'),
    (r'\balabastro\b', 'alabaster'),
    (r'\balabastron\b', 'alabaster'),
    (r'\balabastrorum\b', 'alabaster'),
    (r'\balabastrorum\b', 'alabastrites'),
    (r'\balabastros\b', 'alabaster'),
    (r'\balabastrum\b', 'alabaster'),
    (r'\balabastrum\b', 'alabastrites'),
    (r'\balabetae\b', 'alabeta'),
    (r'\bAlabi\b', 'Alabis'),
    (r'\balabi\b', 'alacer'),
    (r'\bAlabim\b', 'Alabis'),
    (r'\bAlabimque\b', 'Alabis'),
    (r'\balacer\b', 'alacer'),
    (r'\balacre\b', 'alacer'),
    (r'\balacrem\b', 'alacer'),
    (r'\balacres\b', 'alacer'),
    (r'\balacresque\b', 'alacer'),
    (r'\balacri\b', 'alacer'),
    (r'\balacria\b', 'alacer'),
    (r'\balacribus\b', 'alacer'),
    (r'\balacrior\b', 'alacer'),
    (r'\balacriora\b', 'alacer'),
    (r'\balacriorem\b', 'alacer'),
    (r'\balacriores\b', 'alacer'),
    (r'\balacris\b', 'alacer'),
    (r'\balacritas\b', 'alacritas'),
    (r'\balacritasque\b', 'alacritas'),
    (r'\balacritate\b', 'alacritas'),
    (r'\balacritatem\b', 'alacritas'),
    (r'\balacritatemque\b', 'alacritas'),
    (r'\balacritatibus\b', 'alacritas'),
    (r'\balacritatis\b', 'alacritas'),
    (r'\balacriter\b', 'alacriter'),
    (r'\balae\b', 'ala'),
    (r'\balaeque\b', 'ala'),
    (r'\balaeue\b', 'ala'),
    (r'\balam\b', 'ala'),
    (r'\balam\b', 'alo'),
    (r'\bAlamanni\b', 'Alemon'),
    (r'\bAlamannia\b', 'Alemon'),
    (r'\bAlamannici\b', 'Alemon'),
    (r'\bAlamannorum\b', 'Alemon'),
    (r'\bAlamannos\b', 'Alemon'),
    (r'\bAlanam\b', 'Alanus'),
    (r'\bAlani\b', 'Alanus'),
    (r'\bAlani\b', 'Alanus'),
    (r'\bAlanis\b', 'Alanus'),
    (r'\bAlanis\b', 'Alanus'),
    (r'\bAlanos\b', 'Alanus'),
    (r'\balant\b', 'alo'),
    (r'\balantque\b', 'alo'),
    (r'\balantur\b', 'alo'),
    (r'\bAlanus\b', 'Alanus'),
    (r'\balapae\b', 'alapa'),
    (r'\balapam\b', 'alapa'),
    (r'\balapas\b', 'alapa'),
    (r'\balapis\b', 'alapa'),
    (r'\balapis\b', 'alapus'),
    (r'\balar\b', 'alo'),
    (r'\balari\b', 'alarius'),
    (r'\balariae\b', 'alarius'),
    (r'\balariarum\b', 'alarius'),
    (r'\balarias\b', 'alarius'),
    (r'\balarii\b', 'alarius'),
    (r'\balariis\b', 'alarius'),
    (r'\balario\b', 'alarius'),
    (r'\balarios\b', 'alarius'),
    (r'\balaris\b', 'alo'),
    (r'\balarium\b', 'alarius'),
    (r'\balarius\b', 'alarius'),
    (r'\balarque\b', 'alo'),
    (r'\balarum\b', 'ala'),
    (r'\balarumque\b', 'ala'),
    (r'\balas\b', 'ala'),
    (r'\balas\b', 'alo'),
    (r'\balasque\b', 'ala'),
    (r'\balasque\b', 'alo'),
    (r'\balat\b', 'alo'),
    (r'\balata\b', 'alatus'),
    (r'\balaternus\b', 'alaternus'),
    (r'\balatis\b', 'alatus'),
    (r'\balatis\b', 'alo'),
    (r'\balatne\b', 'alo'),
    (r'\balato\b', 'alatus'),
    (r'\balatorum\b', 'alatus'),
    (r'\balatos\b', 'alatus'),
    (r'\balatque\b', 'alo'),
    (r'\balatur\b', 'alo'),
    (r'\balatus\b', 'alatus'),
    (r'\balauda\b', 'alauda'),
    (r'\balaudae\b', 'alauda'),
    (r'\balaudarum\b', 'alauda'),
    (r'\balaudas\b', 'alauda'),
    (r'\balazon\b', 'alazon1'),
    (r'\balba\b', 'alba1'),
    (r'\bAlba\b', 'Alba2'),
    (r'\bAlba\b', 'Alba2'),
    (r'\balba\b', 'album'),
    (r'\balbae\b', 'alba1'),
    (r'\bAlbae\b', 'Alba2'),
    (r'\bAlbae\b', 'Alba2'),
    (r'\balbai\b', 'alba1'),
    (r'\bAlbai\b', 'Alba2'),
    (r'\bAlbai\b', 'Alba2'),
    (r'\balbam\b', 'alba1'),
    (r'\bAlbam\b', 'Alba2'),
    (r'\bAlbam\b', 'Alba2'),
    (r'\balbamentis\b', 'albamentum'),
    (r'\balbamentum\b', 'albamentum'),
    (r'\balbamque\b', 'alba1'),
    (r'\bAlbamque\b', 'Alba2'),
    (r'\bAlbamque\b', 'Alba2'),
    (r'\bAlbana\b', 'Albana'),
    (r'\bAlbana\b', 'Albanus'),
    (r'\bAlbanae\b', 'Albana'),
    (r'\bAlbanam\b', 'Albana'),
    (r'\bAlbanaque\b', 'Albana'),
    (r'\bAlbanaque\b', 'Albanus'),
    (r'\bAlbanarum\b', 'Albana'),
    (r'\bAlbanas\b', 'Albana'),
    (r'\bAlbanasque\b', 'Albana'),
    (r'\bAlbane\b', 'Albanus'),
    (r'\balbane\b', 'alba1'),
    (r'\balbane\b', 'album'),
    (r'\bAlbani\b', 'Albania'),
    (r'\bAlbani\b', 'Albanus'),
    (r'\bAlbania\b', 'Albania'),
    (r'\bAlbaniae\b', 'Albania'),
    (r'\bAlbaniam\b', 'Albania'),
    (r'\bAlbanique\b', 'Albania'),
    (r'\bAlbanique\b', 'Albanus'),
    (r'\bAlbanis\b', 'Albana'),
    (r'\bAlbanis\b', 'Albania'),
    (r'\bAlbanis\b', 'Albanus'),
    (r'\bAlbaniue\b', 'Albania'),
    (r'\bAlbaniue\b', 'Albanus'),
    (r'\bAlbanius\b', 'Albanus'),
    (r'\bAlbano\b', 'Albanus'),
    (r'\bAlbanoque\b', 'Albanus'),
    (r'\bAlbanorum\b', 'Albania'),
    (r'\bAlbanorum\b', 'Albanus'),
    (r'\bAlbanos\b', 'Albania'),
    (r'\bAlbanosque\b', 'Albania'),
    (r'\bAlbanove\b', 'Albanus'),
    (r'\bAlbanum\b', 'Albania'),
    (r'\bAlbanum\b', 'Albanus'),
    (r'\bAlbanus\b', 'Albanus'),
    (r'\balbaque\b', 'alba1'),
    (r'\bAlbaque\b', 'Alba2'),
    (r'\bAlbaque\b', 'Alba2'),
    (r'\balbaque\b', 'album'),
    (r'\balbaria\b', 'albarius'),
    (r'\balbaria\b', 'albaris'),
    (r'\balbariis\b', 'albarius'),
    (r'\balbario\b', 'albarius'),
    (r'\balbarum\b', 'alba1'),
    (r'\balbas\b', 'alba1'),
    (r'\balbata\b', 'albatus'),
    (r'\balbati\b', 'albatus'),
    (r'\balbato\b', 'albatus'),
    (r'\balbatos\b', 'albatus'),
    (r'\balbatus\b', 'albatus'),
    (r'\balbaue\b', 'alba1'),
    (r'\balbaue\b', 'album'),
    (r'\balbave\b', 'alba1'),
    (r'\bAlbave\b', 'Alba2'),
    (r'\bAlbave\b', 'Alba2'),
    (r'\balbave\b', 'album'),
    (r'\balbe\b', 'albus'),
    (r'\bAlbe\b', 'Albis'),
    (r'\balbe\b', 'album'),
    (r'\balbe\b', 'albeo'),
    (r'\balbens\b', 'albeo'),
    (r'\balbent\b', 'albeo'),
    (r'\balbente\b', 'albeo'),
    (r'\balbentes\b', 'albeo'),
    (r'\balbentesque\b', 'albeo'),
    (r'\balbentesve\b', 'albeo'),
    (r'\balbenti\b', 'albeo'),
    (r'\balbentia\b', 'albeo'),
    (r'\balbentibus\b', 'albeo'),
    (r'\balbentique\b', 'albeo'),
    (r'\balbentis\b', 'albeo'),
    (r'\balbeo\b', 'albeo'),
    (r'\balbes\b', 'albeo'),
    (r'\balbescant\b', 'albesco'),
    (r'\balbescat\b', 'albesco'),
    (r'\balbescens\b', 'albesco'),
    (r'\balbescente\b', 'albesco'),
    (r'\balbescentes\b', 'albesco'),
    (r'\balbescentibus\b', 'albesco'),
    (r'\balbescentium\b', 'albesco'),
    (r'\balbescere\b', 'albesco'),
    (r'\balbescit\b', 'albesco'),
    (r'\balbescunt\b', 'albesco'),
    (r'\balbesia\b', 'albesia'),
    (r'\balbesium\b', 'albesia'),
    (r'\balbet\b', 'albeo'),
    (r'\bAlbi\b', 'Albis'),
    (r'\balbi\b', 'albus'),
    (r'\bAlbi\b', 'Albius'),
    (r'\balbi\b', 'album'),
    (r'\bAlbiana\b', 'Albianus'),
    (r'\bAlbiano\b', 'Albianus'),
    (r'\bAlbianum\b', 'Albianus'),
    (r'\balbicans\b', 'albico'),
    (r'\balbicant\b', 'albico'),
    (r'\balbicante\b', 'albico'),
    (r'\balbicantes\b', 'albico'),
    (r'\balbicantibus\b', 'albico'),
    (r'\balbicantis\b', 'albico'),
    (r'\balbicare\b', 'albico'),
    (r'\balbicascit\b', 'albicasco'),
    (r'\balbicat\b', 'albico'),
    (r'\balbicatur\b', 'albico'),
    (r'\balbiceram\b', 'albico'),
    (r'\balbicerata\b', 'albiceris'),
    (r'\balbicerem\b', 'albiceris'),
    (r'\balbicet\b', 'albico'),
    (r'\balbida\b', 'albidus'),
    (r'\balbidas\b', 'albidus'),
    (r'\balbidior\b', 'albidus'),
    (r'\balbidissimumque\b', 'albidus'),
    (r'\balbidius\b', 'albidus'),
    (r'\balbidum\b', 'albidus'),
    (r'\balbidus\b', 'albidus'),
    (r'\bAlbim\b', 'Albis'),
    (r'\bAlbimque\b', 'Albis'),
    (r'\balbin\b', 'alba1'),
    (r'\bAlbin\b', 'Alba2'),
    (r'\bAlbin\b', 'Alba2'),
    (r'\balbin\b', 'albus'),
    (r'\bAlbin\b', 'Albis'),
    (r'\bAlbin\b', 'Albius'),
    (r'\balbin\b', 'album'),
    (r'\balbine\b', 'albinus1'),
    (r'\bAlbine\b', 'Albinus2'),
    (r'\bAlbini\b', 'Albinus2'),
    (r'\balbini\b', 'albinus1'),
    (r'\bAlbini\b', 'Albinius'),
    (r'\bAlbinianam\b', 'Albinius'),
    (r'\bAlbiniani\b', 'Albinius'),
    (r'\bAlbiniani\b', 'Albinius'),
    (r'\bAlbinium\b', 'Albinius'),
    (r'\bAlbinius\b', 'Albinius'),
    (r'\balbino\b', 'albinus1'),
    (r'\bAlbino\b', 'Albinus2'),
    (r'\balbinorum\b', 'albinus1'),
    (r'\bAlbinorum\b', 'Albinus2'),
    (r'\bAlbinouane\b', 'Albinovanus'),
    (r'\bAlbinouanum\b', 'Albinovanus'),
    (r'\bAlbinovano\b', 'Albinovanus'),
    (r'\bAlbinovanum\b', 'Albinovanus'),
    (r'\bAlbinovanus\b', 'Albinovanus'),
    (r'\balbinum\b', 'albinus1'),
    (r'\bAlbinum\b', 'Albinus2'),
    (r'\balbinus\b', 'albinus1'),
    (r'\bAlbinus\b', 'Albinus2'),
    (r'\bAlbio\b', 'Albius'),
    (r'\bAlbion\b', 'Albion1'),
    (r'\bAlbion\b', 'Albion2'),
    (r'\bAlbiones\b', 'Albion1'),
    (r'\bAlbiones\b', 'Albion2'),
    (r'\balbique\b', 'albus'),
    (r'\balbique\b', 'album'),
    (r'\balbis\b', 'alba1'),
    (r'\bAlbis\b', 'Alba2'),
    (r'\bAlbis\b', 'Alba2'),
    (r'\balbis\b', 'albus'),
    (r'\bAlbis\b', 'Albis'),
    (r'\balbis\b', 'album'),
    (r'\balbissumum\b', 'albus'),
    (r'\balbitudinem\b', 'albitudo'),
    (r'\bAlbium\b', 'Albius'),
    (r'\bAlbium\b', 'Albis'),
    (r'\balbius\b', 'albus'),
    (r'\bAlbius\b', 'Albius'),
    (r'\balbo\b', 'albus'),
    (r'\balbo\b', 'album'),
    (r'\balbogilvum\b', 'albogilvus'),
    (r'\balbogilvus\b', 'albogilvus'),
    (r'\balboque\b', 'albus'),
    (r'\balboque\b', 'album'),
    (r'\balbore\b', 'albor'),
    (r'\balborem\b', 'albor'),
    (r'\balborum\b', 'albor'),
    (r'\balborum\b', 'album'),
    (r'\balbos\b', 'albus'),
    (r'\balbuci\b', 'albucus'),
    (r'\bAlbuci\b', 'albucus'),
    (r'\bAlbucii\b', 'albucus'),
    (r'\bAlbucio\b', 'albucus'),
    (r'\bAlbucium\b', 'albucus'),
    (r'\bAlbucius\b', 'albucus'),
    (r'\balbuco\b', 'albucus'),
    (r'\balbucum\b', 'albucus'),
    (r'\balbuelis\b', 'albuelis'),
    (r'\balbugine\b', 'albugo'),
    (r'\balbuginem\b', 'albugo'),
    (r'\balbugines\b', 'albugo'),
    (r'\balbugo\b', 'albugo'),
    (r'\bAlbula\b', 'Albula'),
    (r'\balbula\b', 'albulus'),
    (r'\bAlbulae\b', 'Albula'),
    (r'\balbulae\b', 'albulus'),
    (r'\bAlbulam\b', 'Albula'),
    (r'\balbulam\b', 'albulus'),
    (r'\bAlbularum\b', 'Albula'),
    (r'\balbularum\b', 'albulus'),
    (r'\bAlbulas\b', 'Albula'),
    (r'\balbulas\b', 'albulus'),
    (r'\balbulis\b', 'albulus'),
    (r'\bAlbulisque\b', 'Albula'),
    (r'\balbulisque\b', 'albulus'),
    (r'\balbulus\b', 'albulus'),
    (r'\balbum\b', 'albus'),
    (r'\balbum\b', 'album'),
    (r'\balbumine\b', 'albumen'),
    (r'\balbumque\b', 'albus'),
    (r'\balbumque\b', 'album'),
    (r'\bAlbunea\b', 'Albunea'),
    (r'\bAlbuneae\b', 'Albunea'),
    (r'\bAlbuneam\b', 'Albunea'),
    (r'\balburnum\b', 'alburnus1'),
    (r'\bAlburnum\b', 'Alburnus2'),
    (r'\balburnum\b', 'alburnum'),
    (r'\balburnumque\b', 'alburnus1'),
    (r'\bAlburnumque\b', 'Alburnus2'),
    (r'\balburnumque\b', 'alburnum'),
    (r'\balburnus\b', 'alburnus1'),
    (r'\bAlburnus\b', 'Alburnus2'),
    (r'\balbus\b', 'albus'),
    (r'\balbusque\b', 'albus'),
    (r'\bAlcae\b', 'Alce'),
    (r'\bAlcaee\b', 'Alcaeus'),
    (r'\bAlcaei\b', 'Alcaeus'),
    (r'\bAlcaeo\b', 'Alcaeus'),
    (r'\bAlcaeum\b', 'Alcaeus'),
    (r'\bAlcaeus\b', 'Alcaeus'),
    (r'\bAlcamenen\b', 'Alcamenes'),
    (r'\bAlcamenes\b', 'Alcamenes'),
    (r'\bAlcameni\b', 'Alcamenes'),
    (r'\bAlcamenis\b', 'Alcamenes'),
    (r'\bAlcas\b', 'Alce'),
    (r'\bAlcathoen\b', 'Alcathoe'),
    (r'\bAlcathoi\b', 'Alcathous'),
    (r'\bAlcathoum\b', 'Alcathous'),
    (r'\bAlcathous\b', 'Alcathous'),
    (r'\balce\b', 'alces'),
    (r'\bAlce\b', 'Alce'),
    (r'\bAlce\b', 'Alcis2'),
    (r'\balcea\b', 'alcea'),
    (r'\balcedo\b', 'alcedo'),
    (r'\balcedonia\b', 'alcedonia'),
    (r'\balcen\b', 'alces'),
    (r'\bAlcen\b', 'Alce'),
    (r'\balces\b', 'alces'),
    (r'\bAlces\b', 'Alce'),
    (r'\bAlces\b', 'Alcis2'),
    (r'\bAlcesti\b', 'Alcestis'),
    (r'\bAlcestin\b', 'Alcestis'),
    (r'\bAlcestin\b', 'Alcestis'),
    (r'\bAlcestis\b', 'Alcestis'),
    (r'\bAlcestis\b', 'Alcestis'),
    (r'\balci\b', 'alces'),
    (r'\bAlci\b', 'Alcis2'),
    (r'\bAlcibiade\b', 'Alcibiades'),
    (r'\bAlcibiadem\b', 'Alcibiades'),
    (r'\bAlcibiaden\b', 'Alcibiades'),
    (r'\bAlcibiades\b', 'Alcibiades'),
    (r'\bAlcibiadi\b', 'Alcibiades'),
    (r'\bAlcibiadis\b', 'Alcibiades'),
    (r'\bAlcidae\b', 'Alcides'),
    (r'\bAlcide\b', 'Alcis1'),
    (r'\bAlcide\b', 'Alcides'),
    (r'\bAlciden\b', 'Alcides'),
    (r'\bAlcides\b', 'Alcis1'),
    (r'\bAlcides\b', 'Alcides'),
    (r'\bAlcimachus\b', 'Alcimachus'),
    (r'\bAlcimede\b', 'Alcimede'),
    (r'\bAlcimeden\b', 'Alcimede'),
    (r'\bAlcimedes\b', 'Alcimede'),
    (r'\bAlcimedis\b', 'Alcimede'),
    (r'\bAlcimedon\b', 'Alcimedon'),
    (r'\bAlcimedontis\b', 'Alcimedon'),
    (r'\bAlcinoi\b', 'Alcinous'),
    (r'\bAlcinoique\b', 'Alcinous'),
    (r'\bAlcinoo\b', 'Alcinous'),
    (r'\bAlcinoum\b', 'Alcinous'),
    (r'\bAlcinous\b', 'Alcinous'),
    (r'\bAlcis\b', 'Alce'),
    (r'\balcis\b', 'alces'),
    (r'\bAlcis\b', 'Alcis1'),
    (r'\bAlcis\b', 'Alcis2'),
    (r'\bAlcisthenen\b', 'Alcisthene'),
    (r'\bAlcithoe\b', 'Alcithoe'),
    (r'\bAlcithoen\b', 'Alcithoe'),
    (r'\bAlcmaeo\b', 'Alcmaeus'),
    (r'\bAlcmaeon\b', 'Alcmaeus'),
    (r'\bAlcmaeoni\b', 'Alcmaeus'),
    (r'\bAlcmaeoniae\b', 'Alcmaeus'),
    (r'\bAlcmena\b', 'Alcmena'),
    (r'\bAlcmenae\b', 'Alcmena'),
    (r'\bAlcmenam\b', 'Alcmena'),
    (r'\bAlcmene\b', 'Alcmene'),
    (r'\bAlcmenen\b', 'Alcmene'),
    (r'\bAlcmenes\b', 'Alcmene'),
    (r'\bAlcumena\b', 'Alcmena'),
    (r'\bAlcumenae\b', 'Alcmena'),
    (r'\bAlcumenam\b', 'Alcmena'),
    (r'\bAlcumenas\b', 'Alcmena'),
    (r'\bAlcyonae\b', 'Alcyone'),
    (r'\bAlcyonas\b', 'Alcyone'),
    (r'\bAlcyone\b', 'Alcyone'),
    (r'\balcyonea\b', 'alcyoneus'),
    (r'\balcyonea\b', 'alcyoneus'),
    (r'\balcyonei\b', 'alcyoneus'),
    (r'\balcyonei\b', 'alcyoneus'),
    (r'\bAlcyonen\b', 'Alcyone'),
    (r'\balcyoneo\b', 'alcyoneus'),
    (r'\balcyoneo\b', 'alcyoneus'),
    (r'\bAlcyoneque\b', 'Alcyone'),
    (r'\bAlcyones\b', 'Alcyone'),
    (r'\balcyoneum\b', 'alcyoneus'),
    (r'\balcyoneum\b', 'alcyoneus'),
    (r'\balcyoneus\b', 'alcyoneus'),
    (r'\bAlcyonis\b', 'Alcyone'),
    (r'\bale\b', 'aluta'),
    (r'\bale\b', 'alum'),
    (r'\bale\b', 'alo'),
    (r'\balea\b', 'alea'),
    (r'\bAlea\b', 'Aleus2'),
    (r'\baleae\b', 'alea'),
    (r'\bAleae\b', 'Aleus2'),
    (r'\baleam\b', 'alea'),
    (r'\baleaque\b', 'alea'),
    (r'\bAleaque\b', 'Aleus2'),
    (r'\baleariae\b', 'alearius'),
    (r'\baleator\b', 'aleator'),
    (r'\baleatorem\b', 'aleator'),
    (r'\baleatores\b', 'aleator'),
    (r'\baleatoria\b', 'aleatorius'),
    (r'\baleatoria\b', 'aleatorius'),
    (r'\baleatoribus\b', 'aleator'),
    (r'\baleatorio\b', 'aleatorius'),
    (r'\baleatorio\b', 'aleatorius'),
    (r'\baleatoris\b', 'aleator'),
    (r'\baleatorum\b', 'aleator'),
    (r'\balebam\b', 'alo'),
    (r'\balebant\b', 'alo'),
    (r'\balebantur\b', 'alo'),
    (r'\balebat\b', 'alo'),
    (r'\balebatur\b', 'alo'),
    (r'\balebribus\b', 'alebria'),
    (r'\bAlecto\b', 'a-lecto'),
    (r'\balecto\b', 'a-lego2'),
    (r'\balecto\b', 'a-lecto'),
    (r'\balectoriae\b', 'alectorius'),
    (r'\balectorias\b', 'alectorius'),
    (r'\bAledio\b', 'a-lego2'),
    (r'\bAledium\b', 'a-lego2'),
    (r'\bAledius\b', 'a-lego2'),
    (r'\bAlei\b', 'Aleus2'),
    (r'\bAlei\b', 'a-lego2'),
    (r'\baleis\b', 'alea'),
    (r'\bAleis\b', 'Aleus2'),
    (r'\bAlemanni\b', 'Alemon'),
    (r'\bAlemanni\b', 'Alemanni'),
    (r'\bAlemone\b', 'Alemon'),
    (r'\bAlemoniden\b', 'Alemonides'),
    (r'\bAlemonides\b', 'Alemonides'),
    (r'\balemus\b', 'alo'),
    (r'\balenda\b', 'alo'),
    (r'\balendam\b', 'alo'),
    (r'\balendamque\b', 'alo'),
    (r'\balendarum\b', 'alo'),
    (r'\balendi\b', 'alo'),
    (r'\balendis\b', 'alo'),
    (r'\balendisque\b', 'alo'),
    (r'\balendo\b', 'alo'),
    (r'\balendoque\b', 'alo'),
    (r'\balendorum\b', 'alo'),
    (r'\balendos\b', 'alo'),
    (r'\balendosque\b', 'alo'),
    (r'\balendum\b', 'alo'),
    (r'\balendumque\b', 'alo'),
    (r'\balendus\b', 'alo'),
    (r'\balens\b', 'alo'),
    (r'\balente\b', 'alo'),
    (r'\balentem\b', 'alo'),
    (r'\balentes\b', 'alo'),
    (r'\balenti\b', 'alo'),
    (r'\balentibus\b', 'alo'),
    (r'\balentium\b', 'alo'),
    (r'\balentur\b', 'alo'),
    (r'\baleo\b', 'aleo'),
    (r'\bAleo\b', 'Aleus2'),
    (r'\bAleon\b', 'Aleus2'),
    (r'\baleon\b', 'aleo'),
    (r'\baleones\b', 'aleo'),
    (r'\bAleos\b', 'Aleus2'),
    (r'\balere\b', 'alo'),
    (r'\balerent\b', 'alo'),
    (r'\balerentur\b', 'alo'),
    (r'\balerere\b', 'alo'),
    (r'\baleres\b', 'alo'),
    (r'\baleret\b', 'alo'),
    (r'\baleretur\b', 'alo'),
    (r'\bAleria\b', 'Aleria'),
    (r'\bAleriae\b', 'Aleria'),
    (r'\bAleriam\b', 'Aleria'),
    (r'\baleris\b', 'alo'),
    (r'\bales\b', 'alo'),
    (r'\balescendi\b', 'alesco'),
    (r'\balescendo\b', 'alesco'),
    (r'\balescere\b', 'alesco'),
    (r'\balescit\b', 'alesco'),
    (r'\balescunt\b', 'alesco'),
    (r'\bAlesia\b', 'Alesia'),
    (r'\bAlesiae\b', 'Alesia'),
    (r'\bAlesiam\b', 'Alesia'),
    (r'\balesque\b', 'alo'),
    (r'\balet\b', 'alo'),
    (r'\baleten\b', 'a-leto'),
    (r'\baletes\b', 'a-leto'),
    (r'\bAletini\b', 'Aletinus'),
    (r'\bAletrinatem\b', 'a-leto'),
    (r'\bAletrinates\b', 'a-leto'),
    (r'\bAletrinati\b', 'a-leto'),
    (r'\bAletrinatibus\b', 'a-leto'),
    (r'\bAletrinatis\b', 'a-leto'),
    (r'\baletur\b', 'alo'),
    (r'\bAleuae\b', 'Aleuas'),
    (r'\bAleuas\b', 'Aleuas'),
    (r'\baleuas\b', 'a-levo1'),
    (r'\bAleum\b', 'Aleus2'),
    (r'\bAlexa\b', 'Alexamenus'),
    (r'\bAlexae\b', 'Alexamenus'),
    (r'\bAlexam\b', 'Alexamenus'),
    (r'\bAlexameno\b', 'Alexamenus'),
    (r'\bAlexamenum\b', 'Alexamenus'),
    (r'\bAlexamenus\b', 'Alexamenus'),
    (r'\bAlexan\b', 'Alexamenus'),
    (r'\bAlexander\b', 'Alexander'),
    (r'\bAlexandrea\b', 'Alexandrea'),
    (r'\bAlexandreae\b', 'Alexandrea'),
    (r'\bAlexandream\b', 'Alexandrea'),
    (r'\bAlexandri\b', 'Alexander'),
    (r'\bAlexandria\b', 'Alexandrea'),
    (r'\bAlexandriae\b', 'Alexandrea'),
    (r'\bAlexandriaeque\b', 'Alexandrea'),
    (r'\bAlexandriam\b', 'Alexandrea'),
    (r'\bAlexandrina\b', 'alexipharmacon'),
    (r'\bAlexandrinae\b', 'alexipharmacon'),
    (r'\bAlexandrinam\b', 'alexipharmacon'),
    (r'\bAlexandrinarum\b', 'alexipharmacon'),
    (r'\bAlexandrinas\b', 'alexipharmacon'),
    (r'\bAlexandrini\b', 'alexipharmacon'),
    (r'\bAlexandrini\b', 'alexipharmacon'),
    (r'\bAlexandrinis\b', 'alexipharmacon'),
    (r'\bAlexandrinis\b', 'alexipharmacon'),
    (r'\bAlexandrino\b', 'alexipharmacon'),
    (r'\bAlexandrinoque\b', 'alexipharmacon'),
    (r'\bAlexandrinorum\b', 'alexipharmacon'),
    (r'\bAlexandrinorum\b', 'alexipharmacon'),
    (r'\bAlexandrinos\b', 'alexipharmacon'),
    (r'\bAlexandrinum\b', 'alexipharmacon'),
    (r'\bAlexandrinum\b', 'alexipharmacon'),
    (r'\bAlexandrinus\b', 'alexipharmacon'),
    (r'\bAlexandro\b', 'Alexander'),
    (r'\bAlexandrum\b', 'Alexander'),
    (r'\bAlexandrumque\b', 'Alexander'),
    (r'\bAlexide\b', 'alga'),
    (r'\bAlexidis\b', 'alga'),
    (r'\bAlexin\b', 'Alexamenus'),
    (r'\bAlexin\b', 'alga'),
    (r'\bAlexio\b', 'alexipharmacon'),
    (r'\bAlexione\b', 'alexipharmacon'),
    (r'\bAlexionis\b', 'alexipharmacon'),
    (r'\balexipharmacon\b', 'alexipharmacon'),
    (r'\bAlexis\b', 'Alexamenus'),
    (r'\bAlexis\b', 'alga'),
    (r'\bAlfene\b', 'alga'),
    (r'\bAlfeni\b', 'alga'),
    (r'\bAlfeno\b', 'alga'),
    (r'\bAlfenum\b', 'alga'),
    (r'\bAlfenus\b', 'alga'),
    (r'\bAlfi\b', 'alga'),
    (r'\bAlfii\b', 'alga'),
    (r'\bAlfio\b', 'alga'),
    (r'\bAlfium\b', 'alga'),
    (r'\bAlfius\b', 'alga'),
    (r'\balga\b', 'alga'),
    (r'\balgae\b', 'alga'),
    (r'\balgam\b', 'alga'),
    (r'\balgas\b', 'alga'),
    (r'\balgense\b', 'algensis'),
    (r'\bAlgida\b', 'Algidus'),
    (r'\bAlgida\b', 'Algidum'),
    (r'\balgida\b', 'algidus1'),
    (r'\balgidam\b', 'algidus1'),
    (r'\bAlgidense\b', 'Algidensis'),
    (r'\bAlgido\b', 'Algidus'),
    (r'\balgido\b', 'algidus1'),
    (r'\bAlgido\b', 'Algidum'),
    (r'\balgidosve\b', 'algidus1'),
    (r'\bAlgidosve\b', 'Algidus'),
    (r'\bAlgidum\b', 'Algidus'),
    (r'\balgidum\b', 'algidus1'),
    (r'\bAlgidum\b', 'Algidum'),
    (r'\bAlgidumque\b', 'Algidus'),
    (r'\balgidumque\b', 'algidus1'),
    (r'\bAlgidumque\b', 'Algidum'),
    (r'\balgidus\b', 'algidus1'),
    (r'\bAlgidus\b', 'Algidus'),
    (r'\balgificus\b', 'algificus'),
    (r'\balgis\b', 'alga'),
    (r'\balgor\b', 'algor'),
    (r'\balgore\b', 'algor'),
    (r'\balgorem\b', 'algor'),
    (r'\balgores\b', 'algor'),
    (r'\balgoresque\b', 'algor'),
    (r'\balgoribus\b', 'algor'),
    (r'\balgoris\b', 'algor'),
    (r'\balgosis\b', 'algosus'),
    (r'\balgosum\b', 'algosus'),
    (r'\balgu\b', 'algus'),
    (r'\balgum\b', 'algus'),
    (r'\balguque\b', 'algus'),
    (r'\bali\b', 'aluta'),
    (r'\bAli\b', 'Alius1'),
    (r'\bali\b', 'alum'),
    (r'\bali\b', 'alo'),
    (r'\balia\b', 'alius2'),
    (r'\balia\b', 'alia'),
    (r'\bAlia\b', 'Alius1'),
    (r'\balia\b', 'alias'),
    (r'\baliae\b', 'alius2'),
    (r'\bAliae\b', 'Alius1'),
    (r'\baliaeque\b', 'alius2'),
    (r'\bAliaeque\b', 'Alius1'),
    (r'\baliaest\b', 'alius2'),
    (r'\baliaeue\b', 'alius2'),
    (r'\baliaeve\b', 'alius2'),
    (r'\bAliam\b', 'Alius1'),
    (r'\baliam\b', 'alius2'),
    (r'\baliamne\b', 'alius2'),
    (r'\bAliamque\b', 'Alius1'),
    (r'\baliamque\b', 'alius2'),
    (r'\baliamue\b', 'alius2'),
    (r'\baliamve\b', 'alius2'),
    (r'\balian\b', 'alius2'),
    (r'\bAlian\b', 'Alius1'),
    (r'\balian\b', 'alia'),
    (r'\balian\b', 'alias'),
    (r'\baliaque\b', 'alius2'),
    (r'\baliaque\b', 'alia'),
    (r'\baliaque\b', 'alias'),
    (r'\bAliarum\b', 'Alius1'),
    (r'\baliarum\b', 'alius2'),
    (r'\baliarumque\b', 'alius2'),
    (r'\baliarumue\b', 'alius2'),
    (r'\bAlias\b', 'Alius1'),
    (r'\balias\b', 'alius2'),
    (r'\balias\b', 'alias'),
    (r'\baliasque\b', 'alius2'),
    (r'\baliasque\b', 'alias'),
    (r'\baliast\b', 'alius2'),
    (r'\baliast\b', 'alia'),
    (r'\baliast\b', 'alias'),
    (r'\baliato\b', 'alias'),
    (r'\baliaue\b', 'alius2'),
    (r'\baliaue\b', 'alia'),
    (r'\baliaue\b', 'alias'),
    (r'\baliave\b', 'alius2'),
    (r'\baliave\b', 'alia'),
    (r'\baliave\b', 'alias'),
    (r'\balibi\b', 'alibi'),
    (r'\balibile\b', 'alibilis'),
    (r'\balibiles\b', 'alibilis'),
    (r'\balibiliores\b', 'alibilis'),
    (r'\balica\b', 'alica'),
    (r'\balicae\b', 'alica'),
    (r'\balicaeve\b', 'alica'),
    (r'\balicam\b', 'alica'),
    (r'\balicarias\b', 'alicaria'),
    (r'\balicubi\b', 'alicubi'),
    (r'\balicui\b', 'aliqui'),
    (r'\balicuius\b', 'aliqui'),
    (r'\balicula\b', 'alicula'),
    (r'\baliculae\b', 'alicula'),
    (r'\baliculam\b', 'alicula'),
    (r'\balicunde\b', 'alicunde'),
    (r'\bAlide\b', 'Alis2'),
    (r'\bAlidem\b', 'Alis2'),
    (r'\balidem\b', 'aluta'),
    (r'\balidem\b', 'alum'),
    (r'\balidem\b', 'alo'),
    (r'\bAlidensem\b', 'Alidensis'),
    (r'\bAlidensia\b', 'Alidensis'),
    (r'\balie\b', 'allium'),
    (r'\balien\b', 'allium'),
    (r'\balien\b', 'alias'),
    (r'\baliena\b', 'alienus'),
    (r'\baliena\b', 'alienus'),
    (r'\baliena\b', 'alieno'),
    (r'\balienabat\b', 'alieno'),
    (r'\balienabis\b', 'alieno'),
    (r'\balienae\b', 'alienus'),
    (r'\balienaeque\b', 'alienus'),
    (r'\balienam\b', 'alienus'),
    (r'\balienamque\b', 'alienus'),
    (r'\balienamue\b', 'alienus'),
    (r'\balienanda\b', 'alieno'),
    (r'\balienandae\b', 'alieno'),
    (r'\balienandarum\b', 'alieno'),
    (r'\balienandas\b', 'alieno'),
    (r'\balienandi\b', 'alieno'),
    (r'\balienandis\b', 'alieno'),
    (r'\balienando\b', 'alieno'),
    (r'\balienandos\b', 'alieno'),
    (r'\balienandum\b', 'alieno'),
    (r'\balienans\b', 'alieno'),
    (r'\balienant\b', 'alieno'),
    (r'\balienantur\b', 'alieno'),
    (r'\balienaque\b', 'alienus'),
    (r'\balienaque\b', 'alienus'),
    (r'\balienaque\b', 'alieno'),
    (r'\balienarat\b', 'alieno'),
    (r'\balienare\b', 'alieno'),
    (r'\balienarem\b', 'alieno'),
    (r'\balienarent\b', 'alieno'),
    (r'\balienarentur\b', 'alieno'),
    (r'\balienaret\b', 'alieno'),
    (r'\balienaretur\b', 'alieno'),
    (r'\balienareue\b', 'alieno'),
    (r'\balienari\b', 'alieno'),
    (r'\balienarum\b', 'alienus'),
    (r'\balienarumque\b', 'alienus'),
    (r'\balienarunt\b', 'alieno'),
    (r'\balienas\b', 'alienus'),
    (r'\balienas\b', 'alieno'),
    (r'\balienasque\b', 'alienus'),
    (r'\balienasque\b', 'alieno'),
    (r'\balienasse\b', 'alieno'),
    (r'\balienassent\b', 'alieno'),
    (r'\balienasset\b', 'alieno'),
    (r'\balienat\b', 'alieno'),
    (r'\balienata\b', 'alieno'),
    (r'\balienatae\b', 'alieno'),
    (r'\balienatam\b', 'alieno'),
    (r'\balienatas\b', 'alieno'),
    (r'\balienati\b', 'alieno'),
    (r'\balienatio\b', 'alienatio'),
    (r'\balienatione\b', 'alienatio'),
    (r'\balienationem\b', 'alienatio'),
    (r'\balienationes\b', 'alienatio'),
    (r'\balienationi\b', 'alienatio'),
    (r'\balienationibus\b', 'alienatio'),
    (r'\balienationis\b', 'alienatio'),
    (r'\balienatique\b', 'alieno'),
    (r'\balienatis\b', 'alieno'),
    (r'\balienato\b', 'alieno'),
    (r'\balienatos\b', 'alieno'),
    (r'\balienatum\b', 'alieno'),
    (r'\balienatur\b', 'alieno'),
    (r'\balienaturum\b', 'alieno'),
    (r'\balienatus\b', 'alieno'),
    (r'\balienatusque\b', 'alieno'),
    (r'\balienatust\b', 'alieno'),
    (r'\balienatusue\b', 'alieno'),
    (r'\balienaue\b', 'alienus'),
    (r'\balienaue\b', 'alienus'),
    (r'\balienaue\b', 'alieno'),
    (r'\balienauerint\b', 'alieno'),
    (r'\balienaueris\b', 'alieno'),
    (r'\balienauerit\b', 'alieno'),
    (r'\balienauero\b', 'alieno'),
    (r'\balienauerunt\b', 'alieno'),
    (r'\balienaui\b', 'alieno'),
    (r'\balienauit\b', 'alieno'),
    (r'\balienavit\b', 'alieno'),
    (r'\balienent\b', 'alieno'),
    (r'\balienentur\b', 'alieno'),
    (r'\balienes\b', 'alieno'),
    (r'\balienet\b', 'alieno'),
    (r'\balienetur\b', 'alieno'),
    (r'\balieni\b', 'alienus'),
    (r'\balieni\b', 'alienus'),
    (r'\balienigena\b', 'alienigena'),
    (r'\balienigena\b', 'alienigenus'),
    (r'\balienigenae\b', 'alienigenus'),
    (r'\balienigenae\b', 'alienigena'),
    (r'\balienigenam\b', 'alienigenus'),
    (r'\balienigenam\b', 'alienigena'),
    (r'\balienigenarum\b', 'alienigenus'),
    (r'\balienigenarum\b', 'alienigena'),
    (r'\balienigenas\b', 'alienigenus'),
    (r'\balienigenas\b', 'alienigena'),
    (r'\balienigeni\b', 'alienigenus'),
    (r'\balienigenis\b', 'alienigena'),
    (r'\balienigenis\b', 'alienigenus'),
    (r'\balienigenisque\b', 'alienigena'),
    (r'\balienigenisque\b', 'alienigenus'),
    (r'\balieniloquium\b', 'alieniloquium'),
    (r'\balienior\b', 'alienus'),
    (r'\balieniora\b', 'alienus'),
    (r'\balieniore\b', 'alienus'),
    (r'\balieniorem\b', 'alienus'),
    (r'\balieniores\b', 'alienus'),
    (r'\balienioribus\b', 'alienus'),
    (r'\balienique\b', 'alienus'),
    (r'\balienique\b', 'alienus'),
    (r'\balienis\b', 'alienus'),
    (r'\balienis\b', 'alienus'),
    (r'\balienisque\b', 'alienus'),
    (r'\balienisque\b', 'alienus'),
    (r'\balienissima\b', 'alienus'),
    (r'\balienissimae\b', 'alienus'),
    (r'\balienissimam\b', 'alienus'),
    (r'\balienissimas\b', 'alienus'),
    (r'\balienissimi\b', 'alienus'),
    (r'\balienissimis\b', 'alienus'),
    (r'\balienissimo\b', 'alienus'),
    (r'\balienissimorum\b', 'alienus'),
    (r'\balienissimos\b', 'alienus'),
    (r'\balienissimum\b', 'alienus'),
    (r'\balienissimumque\b', 'alienus'),
    (r'\balienissimus\b', 'alienus'),
    (r'\balieniue\b', 'alienus'),
    (r'\balieniue\b', 'alienus'),
    (r'\balienius\b', 'alienus'),
    (r'\balieno\b', 'alienus'),
    (r'\balieno\b', 'alienus'),
    (r'\balieno\b', 'alieno'),
    (r'\balienon\b', 'alienus'),
    (r'\balienon\b', 'alienus'),
    (r'\balienon\b', 'alieno'),
    (r'\balienoque\b', 'alienus'),
    (r'\balienoque\b', 'alienus'),
    (r'\balienoque\b', 'alieno'),
    (r'\balienorum\b', 'alienus'),
    (r'\balienorum\b', 'alienus'),
    (r'\balienos\b', 'alienus'),
    (r'\balienosque\b', 'alienus'),
    (r'\balienoue\b', 'alienus'),
    (r'\balienoue\b', 'alienus'),
    (r'\balienoue\b', 'alieno'),
    (r'\balienum\b', 'alienus'),
    (r'\balienum\b', 'alienus'),
    (r'\balienumque\b', 'alienus'),
    (r'\balienumque\b', 'alienus'),
    (r'\balienun\b', 'alienus'),
    (r'\balienus\b', 'alienus'),
    (r'\balienusque\b', 'alienus'),
    (r'\baliger\b', 'aliger'),
    (r'\baligeris\b', 'aliger'),
    (r'\baligerisque\b', 'aliger'),
    (r'\bAlii\b', 'Alii'),
    (r'\balii\b', 'alius2'),
    (r'\balii\b', 'allium'),
    (r'\bAlii\b', 'Alius1'),
    (r'\baliique\b', 'alius2'),
    (r'\baliique\b', 'allium'),
    (r'\baliis\b', 'alius2'),
    (r'\bAliis\b', 'Alii'),
    (r'\bAliis\b', 'Alius1'),
    (r'\baliis\b', 'allium'),
    (r'\baliisne\b', 'alius2'),
    (r'\bAliisne\b', 'Alii'),
    (r'\bAliisne\b', 'Alius1'),
    (r'\baliisne\b', 'allium'),
    (r'\baliisque\b', 'alius2'),
    (r'\baliisque\b', 'allium'),
    (r'\baliisue\b', 'alius2'),
    (r'\baliisue\b', 'allium'),
    (r'\baliisve\b', 'alius2'),
    (r'\baliisve\b', 'allium'),
    (r'\baliiue\b', 'alius2'),
    (r'\baliiue\b', 'allium'),
    (r'\balimenta\b', 'alimentum'),
    (r'\balimentaque\b', 'alimentum'),
    (r'\balimentaria\b', 'alimentarius'),
    (r'\balimentariam\b', 'alimentarius'),
    (r'\balimentarias\b', 'alimentarius'),
    (r'\balimentarii\b', 'alimentarius'),
    (r'\balimentariorum\b', 'alimentarius'),
    (r'\balimentarius\b', 'alimentarius'),
    (r'\balimenti\b', 'alimentum'),
    (r'\balimentique\b', 'alimentum'),
    (r'\balimentis\b', 'alimentum'),
    (r'\balimentisque\b', 'alimentum'),
    (r'\balimento\b', 'alimentum'),
    (r'\balimentorum\b', 'alimentum'),
    (r'\balimentorumque\b', 'alimentum'),
    (r'\balimentum\b', 'alimentum'),
    (r'\balimon\b', 'a-limo2'),
    (r'\balimonia\b', 'alimonia'),
    (r'\balimonia\b', 'alimonium'),
    (r'\balimoniae\b', 'alimonia'),
    (r'\balimoniam\b', 'alimonia'),
    (r'\balimoniarum\b', 'alimonia'),
    (r'\balimonias\b', 'alimonia'),
    (r'\balimoniis\b', 'alimonia'),
    (r'\balimoniis\b', 'alimonium'),
    (r'\balimonio\b', 'alimonium'),
    (r'\balimonium\b', 'alimonium'),
    (r'\balimur\b', 'alo'),
    (r'\balimurque\b', 'alo'),
    (r'\balimus\b', 'alo'),
    (r'\balio\b', 'alio'),
    (r'\balio\b', 'alius2'),
    (r'\bAlio\b', 'Alius1'),
    (r'\balio\b', 'allium'),
    (r'\balio\b', 'alias'),
    (r'\balione\b', 'alio'),
    (r'\balione\b', 'alius2'),
    (r'\balione\b', 'allium'),
    (r'\balione\b', 'alias'),
    (r'\balioque\b', 'alio'),
    (r'\balioque\b', 'alius2'),
    (r'\balioque\b', 'allium'),
    (r'\balioque\b', 'alias'),
    (r'\balioqui\b', 'alioqui'),
    (r'\balioquin\b', 'alioqui'),
    (r'\baliorsum\b', 'aliorsum'),
    (r'\bAliorum\b', 'Alii'),
    (r'\baliorum\b', 'alius2'),
    (r'\bAliorum\b', 'Alius1'),
    (r'\baliorum\b', 'allium'),
    (r'\baliorumque\b', 'alius2'),
    (r'\baliorumque\b', 'allium'),
    (r'\baliorumue\b', 'alius2'),
    (r'\baliorumue\b', 'allium'),
    (r'\baliorumve\b', 'alius2'),
    (r'\baliorumve\b', 'allium'),
    (r'\bAlios\b', 'Alii'),
    (r'\balios\b', 'alius2'),
    (r'\baliosque\b', 'alius2'),
    (r'\baliost\b', 'alio'),
    (r'\bAliost\b', 'Alii'),
    (r'\baliost\b', 'alius2'),
    (r'\bAliost\b', 'Alius1'),
    (r'\baliost\b', 'allium'),
    (r'\baliost\b', 'alias'),
    (r'\baliosve\b', 'alius2'),
    (r'\balioue\b', 'alio'),
    (r'\balioue\b', 'alius2'),
    (r'\balioue\b', 'allium'),
    (r'\balioue\b', 'alias'),
    (r'\baliove\b', 'alio'),
    (r'\baliove\b', 'alius2'),
    (r'\baliove\b', 'allium'),
    (r'\baliove\b', 'alias'),
    (r'\bAliphera\b', 'Aliphera'),
    (r'\bAlipheram\b', 'Aliphera'),
    (r'\bAlipheran\b', 'Aliphera'),
    (r'\balipilum\b', 'alipilus'),
    (r'\balipta\b', 'aliptes'),
    (r'\baliptae\b', 'aliptes'),
    (r'\baliptes\b', 'aliptes'),
    (r'\baliqua\b', 'aliqui'),
    (r'\baliqua\b', 'aliqua'),
    (r'\baliquae\b', 'aliqui'),
    (r'\baliqualibet\b', 'aliqui'),
    (r'\baliqualibet\b', 'aliqua'),
    (r'\baliquam\b', 'aliqui'),
    (r'\baliquamdiu\b', 'aliquamdiu'),
    (r'\baliquan\b', 'aliqui'),
    (r'\baliquan\b', 'aliqua'),
    (r'\baliquande\b', 'aliqua'),
    (r'\baliquando\b', 'aliqua'),
    (r'\baliquandoque\b', 'aliqua'),
    (r'\baliquandost\b', 'aliqua'),
    (r'\baliquane\b', 'aliqui'),
    (r'\baliquane\b', 'aliqua'),
    (r'\baliquant\b', 'aliqua'),
    (r'\baliquanta\b', 'aliquantus'),
    (r'\baliquantae\b', 'aliquantus'),
    (r'\baliquantam\b', 'aliquantus'),
    (r'\baliquantas\b', 'aliquantus'),
    (r'\baliquanti\b', 'aliquantus'),
    (r'\baliquanti\b', 'aliqua'),
    (r'\baliquantillum\b', 'aliquantillum'),
    (r'\baliquantis\b', 'aliquantus'),
    (r'\baliquantis\b', 'aliqua'),
    (r'\baliquanto\b', 'aliqua'),
    (r'\baliquanto\b', 'aliquanto'),
    (r'\baliquanto\b', 'aliquantus'),
    (r'\baliquantoque\b', 'aliqua'),
    (r'\baliquantoque\b', 'aliquanto'),
    (r'\baliquantoque\b', 'aliquantus'),
    (r'\baliquantos\b', 'aliquantus'),
    (r'\baliquantulo\b', 'aliquantulo'),
    (r'\baliquantulo\b', 'aliquantulus'),
    (r'\baliquantulos\b', 'aliquantulus'),
    (r'\baliquantulum\b', 'aliquantulus'),
    (r'\baliquantum\b', 'aliquantus'),
    (r'\baliquantum\b', 'aliquantus'),
    (r'\baliquantus\b', 'aliquantus'),
    (r'\baliquarum\b', 'aliqui'),
    (r'\baliquas\b', 'aliqui'),
    (r'\baliquas\b', 'aliqua'),
    (r'\baliquast\b', 'aliqui'),
    (r'\baliquast\b', 'aliqua'),
    (r'\baliquatenus\b', 'aliquatenus'),
    (r'\baliquaue\b', 'aliqui'),
    (r'\baliquaue\b', 'aliqua'),
    (r'\balique\b', 'aliqui'),
    (r'\baliquem\b', 'aliqui'),
    (r'\baliquem\b', 'aliqua'),
    (r'\baliquemque\b', 'aliqui'),
    (r'\baliquemque\b', 'aliqua'),
    (r'\baliqui\b', 'aliqui'),
    (r'\baliquibus\b', 'aliqui'),
    (r'\baliquid\b', 'aliquis'),
    (r'\baliquidque\b', 'aliquis'),
    (r'\baliquidue\b', 'aliquis'),
    (r'\baliquis\b', 'aliqui'),
    (r'\baliquis\b', 'aliquis'),
    (r'\baliquisne\b', 'aliqui'),
    (r'\baliquisne\b', 'aliquis'),
    (r'\baliquisque\b', 'aliqui'),
    (r'\baliquisque\b', 'aliquis'),
    (r'\baliquit\b', 'aliqui'),
    (r'\baliquo\b', 'aliquo'),
    (r'\baliquo\b', 'aliquis'),
    (r'\baliquo\b', 'aliqua'),
    (r'\baliquod\b', 'aliqui'),
    (r'\baliquodue\b', 'aliqui'),
    (r'\baliquorum\b', 'aliqui'),
    (r'\baliquos\b', 'aliqui'),
    (r'\baliquot\b', 'aliquot'),
    (r'\baliquotfariam\b', 'aliquotfariam'),
    (r'\baliquotiens\b', 'aliquoties'),
    (r'\baliquoties\b', 'aliquoties'),
    (r'\baliquotque\b', 'aliquot'),
    (r'\baliquovorsum\b', 'aliquovorsum'),
    (r'\balis\b', 'ala'),
    (r'\bAlis\b', 'Alis2'),
    (r'\balis\b', 'alum'),
    (r'\balis\b', 'alo'),
    (r'\bAlisone\b', 'Aliso'),
    (r'\bAlisonem\b', 'Aliso'),
    (r'\balisque\b', 'ala'),
    (r'\balisque\b', 'alum'),
    (r'\balisque\b', 'alo'),
    (r'\balit\b', 'alo'),
    (r'\balita\b', 'alo'),
    (r'\balita\b', 'aliter'),
    (r'\balitae\b', 'alo'),
    (r'\balitam\b', 'alo'),
    (r'\balite\b', 'alo'),
    (r'\balitem\b', 'aliter'),
    (r'\baliter\b', 'aliter'),
    (r'\baliterque\b', 'aliter'),
    (r'\baliterue\b', 'aliter'),
    (r'\baliterve\b', 'aliter'),
    (r'\balites\b', 'aliter'),
    (r'\baliti\b', 'alo'),
    (r'\balitis\b', 'alo'),
    (r'\balito\b', 'alo'),
    (r'\balito\b', 'aliter'),
    (r'\balitque\b', 'alo'),
    (r'\balitum\b', 'alo'),
    (r'\balitur\b', 'alo'),
    (r'\balituram\b', 'alitura'),
    (r'\balituram\b', 'alo'),
    (r'\baliturque\b', 'alo'),
    (r'\balitus\b', 'alo'),
    (r'\baliubi\b', 'aliubi'),
    (r'\baliud\b', 'alius2'),
    (r'\baliudque\b', 'alius2'),
    (r'\baliudue\b', 'alius2'),
    (r'\baliudve\b', 'alius2'),
    (r'\balium\b', 'alius2'),
    (r'\bAlium\b', 'Alii'),
    (r'\bAlium\b', 'Alius1'),
    (r'\balium\b', 'allium'),
    (r'\baliumque\b', 'alius2'),
    (r'\baliumque\b', 'allium'),
    (r'\baliumue\b', 'alius2'),
    (r'\baliumue\b', 'allium'),
    (r'\baliumve\b', 'alius2'),
    (r'\baliumve\b', 'allium'),
    (r'\baliunde\b', 'aliunde'),
    (r'\baliundest\b', 'aliunde'),
    (r'\bAlius\b', 'Alius1'),
    (r'\balius\b', 'alius2'),
    (r'\bAliusne\b', 'Alius1'),
    (r'\baliusne\b', 'alius2'),
    (r'\baliusque\b', 'alius2'),
    (r'\baliusue\b', 'alius2'),
    (r'\baliusve\b', 'alius2'),
    (r'\ballaberetur\b', 'allabor'),
    (r'\ballapsam\b', 'allabor'),
    (r'\ballata\b', 'affero'),
    (r'\ballatae\b', 'affero'),
    (r'\ballatam\b', 'affero'),
    (r'\ballatas\b', 'affero'),
    (r'\ballatast\b', 'affero'),
    (r'\ballati\b', 'affero'),
    (r'\ballatique\b', 'affero'),
    (r'\ballatis\b', 'affero'),
    (r'\ballato\b', 'affero'),
    (r'\ballatum\b', 'affero'),
    (r'\ballatura\b', 'affero'),
    (r'\ballaturam\b', 'affero'),
    (r'\ballaturi\b', 'affero'),
    (r'\ballaturos\b', 'affero'),
    (r'\ballaturum\b', 'affero'),
    (r'\ballaturus\b', 'affero'),
    (r'\ballatus\b', 'affero'),
    (r'\ballatust\b', 'affero'),
    (r'\ballectabat\b', 'allecto'),
    (r'\ballecti\b', 'allectus'),
    (r'\ballecti\b', 'allicio'),
    (r'\ballectione\b', 'allectio'),
    (r'\ballectionibus\b', 'allectio'),
    (r'\ballectis\b', 'allectus'),
    (r'\ballectis\b', 'allicio'),
    (r'\ballecto\b', 'allectus'),
    (r'\ballecto\b', 'allicio'),
    (r'\ballecto\b', 'allecto'),
    (r'\ballectum\b', 'allectus'),
    (r'\ballectum\b', 'allicio'),
    (r'\ballectus\b', 'allectus'),
    (r'\ballectus\b', 'allicio'),
    (r'\ballegabat\b', 'allego1'),
    (r'\ballegabo\b', 'allego1'),
    (r'\ballegamus\b', 'allego1'),
    (r'\ballegandam\b', 'allego1'),
    (r'\ballegando\b', 'allego1'),
    (r'\ballegans\b', 'allego1'),
    (r'\ballegantes\b', 'allego1'),
    (r'\ballegantur\b', 'allego1'),
    (r'\ballegare\b', 'allego1'),
    (r'\ballegarentur\b', 'allego1'),
    (r'\ballegaret\b', 'allego1'),
    (r'\ballegaretur\b', 'allego1'),
    (r'\ballegari\b', 'allego1'),
    (r'\ballegasset\b', 'allego1'),
    (r'\ballegasti\b', 'allego1'),
    (r'\ballegastis\b', 'allego1'),
    (r'\ballegat\b', 'allego1'),
    (r'\ballegata\b', 'allego1'),
    (r'\ballegatae\b', 'allego1'),
    (r'\ballegatio\b', 'allegatio'),
    (r'\ballegatione\b', 'allegatio'),
    (r'\ballegationem\b', 'allegatio'),
    (r'\ballegationibus\b', 'allegatio'),
    (r'\ballegatis\b', 'allegatio'),
    (r'\ballegatis\b', 'allego1'),
    (r'\ballegato\b', 'allego1'),
    (r'\ballegaturi\b', 'allego1'),
    (r'\ballegauit\b', 'allego1'),
    (r'\ballegavissem\b', 'allego1'),
    (r'\ballegavit\b', 'allego1'),
    (r'\ballegemus\b', 'allego1'),
    (r'\ballegendis\b', 'admaturo'),
    (r'\ballegent\b', 'allego1'),
    (r'\ballegentur\b', 'allego1'),
    (r'\balleget\b', 'allego1'),
    (r'\ballegetur\b', 'allego1'),
    (r'\ballegi\b', 'admaturo'),
    (r'\ballegit\b', 'admaturo'),
    (r'\ballego\b', 'allego1'),
    (r'\ballegoria\b', 'allegoria'),
    (r'\ballegoriae\b', 'allegoria'),
    (r'\ballegoriam\b', 'allegoria'),
    (r'\ballegorian\b', 'allegoria'),
    (r'\ballegorice\b', 'allegoricus'),
    (r'\ballegoricos\b', 'allegoricus'),
    (r'\balleua\b', 'allevo1'),
    (r'\balleuare\b', 'allevo1'),
    (r'\balleuatur\b', 'allevo1'),
    (r'\balleuauit\b', 'allevo1'),
    (r'\ballevans\b', 'allevo1'),
    (r'\ballevat\b', 'allevo1'),
    (r'\ballevatio\b', 'allevatio'),
    (r'\ballevatis\b', 'allevo1'),
    (r'\ballevetis\b', 'allevo1'),
    (r'\ballex\b', 'allex1'),
    (r'\balli\b', 'allus'),
    (r'\bAllia\b', 'Allia'),
    (r'\ballia\b', 'allium'),
    (r'\bAlliam\b', 'Allia'),
    (r'\bAlliaque\b', 'Allia'),
    (r'\balliaque\b', 'allium'),
    (r'\ballicere\b', 'allicio'),
    (r'\ballicerentur\b', 'allicio'),
    (r'\balliceret\b', 'allicio'),
    (r'\ballici\b', 'allex1'),
    (r'\ballici\b', 'allicio'),
    (r'\balliciam\b', 'allicio'),
    (r'\balliciant\b', 'allicio'),
    (r'\balliciat\b', 'allicio'),
    (r'\balliciendi\b', 'allicio'),
    (r'\balliciendo\b', 'allicio'),
    (r'\balliciendus\b', 'allicio'),
    (r'\ballicientem\b', 'allicio'),
    (r'\ballicientur\b', 'allicio'),
    (r'\ballicit\b', 'allicio'),
    (r'\ballicuit\b', 'admaturo'),
    (r'\ballidit\b', 'allido'),
    (r'\balliduntur\b', 'allido'),
    (r'\bAllieno\b', 'Allifae'),
    (r'\bAlliensem\b', 'Alliensis'),
    (r'\bAlliensi\b', 'Alliensis'),
    (r'\bAlliensique\b', 'Alliensis'),
    (r'\bAlliensis\b', 'Alliensis'),
    (r'\bAllienum\b', 'Allifae'),
    (r'\bAllienus\b', 'Allifae'),
    (r'\bAllifae\b', 'Allifae'),
    (r'\bAllifani\b', 'Allifanus'),
    (r'\bAllifani\b', 'Allifanus'),
    (r'\bAllifanis\b', 'Allifanus'),
    (r'\bAllifanis\b', 'Allifanus'),
    (r'\bAllifanis\b', 'Allifanus'),
    (r'\bAllifano\b', 'Allifanus'),
    (r'\bAllifanum\b', 'Allifanus'),
    (r'\bAllifanum\b', 'Allifanus'),
    (r'\bAllifanum\b', 'Allifanus'),
    (r'\bAllifanumque\b', 'Allifanus'),
    (r'\bAllifanumque\b', 'Allifanus'),
    (r'\bAllifanumque\b', 'Allifanus'),
    (r'\bAllifanus\b', 'Allifanus'),
    (r'\bAllifas\b', 'Allifae'),
    (r'\balliga\b', 'alligo'),
    (r'\balligabantur\b', 'alligo'),
    (r'\balligabis\b', 'alligo'),
    (r'\balligabit\b', 'alligo'),
    (r'\balligabitur\b', 'alligo'),
    (r'\balligabo\b', 'alligo'),
    (r'\balligabor\b', 'alligo'),
    (r'\balligabunt\b', 'alligo'),
    (r'\balliganda\b', 'alligo'),
    (r'\balligandi\b', 'alligo'),
    (r'\balligando\b', 'alligo'),
    (r'\balligandos\b', 'alligo'),
    (r'\balligandosque\b', 'alligo'),
    (r'\balligandum\b', 'alligo'),
    (r'\balligans\b', 'alligo'),
    (r'\balligant\b', 'alligo'),
    (r'\balligantes\b', 'alligo'),
    (r'\balligantur\b', 'alligo'),
    (r'\balliganturque\b', 'alligo'),
    (r'\balligare\b', 'alligo'),
    (r'\balligarent\b', 'alligo'),
    (r'\balligaret\b', 'alligo'),
    (r'\balligaretur\b', 'alligo'),
    (r'\balligari\b', 'alligo'),
    (r'\balligarique\b', 'alligo'),
    (r'\balligas\b', 'alligo'),
    (r'\balligassem\b', 'alligo'),
    (r'\balligasses\b', 'alligo'),
    (r'\balligasset\b', 'alligo'),
    (r'\balligassetque\b', 'alligo'),
    (r'\balligasti\b', 'alligo'),
    (r'\balligastis\b', 'alligo'),
    (r'\balligat\b', 'alligo'),
    (r'\balligata\b', 'alligo'),
    (r'\balligatae\b', 'alligo'),
    (r'\balligatam\b', 'alligo'),
    (r'\balligatas\b', 'alligo'),
    (r'\balligate\b', 'alligo'),
    (r'\balligati\b', 'alligo'),
    (r'\balligationibus\b', 'alligatio'),
    (r'\balligatique\b', 'alligo'),
    (r'\balligatis\b', 'alligo'),
    (r'\balligato\b', 'alligo'),
    (r'\balligatoque\b', 'alligo'),
    (r'\balligatore\b', 'alligator'),
    (r'\balligatoris\b', 'alligator'),
    (r'\balligatos\b', 'alligo'),
    (r'\balligatum\b', 'alligo'),
    (r'\balligatur\b', 'alligo'),
    (r'\balligatura\b', 'alligatura'),
    (r'\balligatura\b', 'alligo'),
    (r'\balligaturis\b', 'alligatura'),
    (r'\balligaturis\b', 'alligo'),
    (r'\balligaturus\b', 'alligo'),
    (r'\balligatus\b', 'alligo'),
    (r'\balligatusque\b', 'alligo'),
    (r'\balligauerat\b', 'alligo'),
    (r'\balligaueris\b', 'alligo'),
    (r'\balligauerit\b', 'alligo'),
    (r'\balligauerunt\b', 'alligo'),
    (r'\balligauit\b', 'alligo'),
    (r'\balligaverat\b', 'alligo'),
    (r'\balligaverit\b', 'alligo'),
    (r'\balligaveritis\b', 'alligo'),
    (r'\balligaverunt\b', 'alligo'),
    (r'\balligavi\b', 'alligo'),
    (r'\balligavit\b', 'alligo'),
    (r'\balligem\b', 'alligo'),
    (r'\balligent\b', 'alligo'),
    (r'\balligentur\b', 'alligo'),
    (r'\balligere\b', 'alligo'),
    (r'\balliges\b', 'alligo'),
    (r'\balliget\b', 'alligo'),
    (r'\balligetur\b', 'alligo'),
    (r'\balligo\b', 'alligo'),
    (r'\balligor\b', 'alligo'),
    (r'\ballinit\b', 'allino'),
    (r'\ballis\b', 'allus'),
    (r'\ballium\b', 'allium'),
    (r'\ballo\b', 'allus'),
    (r'\bAllobroges\b', 'Allobrogicus'),
    (r'\bAllobrogibus\b', 'Allobrogicus'),
    (r'\bAllobrogibusque\b', 'Allobrogicus'),
    (r'\bAllobrogica\b', 'Allobrogicus'),
    (r'\bAllobrogicae\b', 'Allobrogicus'),
    (r'\bAllobrogicaque\b', 'Allobrogicus'),
    (r'\bAllobrogici\b', 'Allobrogicus'),
    (r'\bAllobrogicis\b', 'Allobrogicus'),
    (r'\bAllobrogico\b', 'Allobrogicus'),
    (r'\bAllobrogicum\b', 'Allobrogicus'),
    (r'\bAllobrogicus\b', 'Allobrogicus'),
    (r'\bAllobrogum\b', 'Allobrogicus'),
    (r'\ballocuta\b', 'alloquor'),
    (r'\ballocutio\b', 'allocutio'),
    (r'\ballocutione\b', 'allocutio'),
    (r'\ballocutiones\b', 'allocutio'),
    (r'\ballocutionis\b', 'allocutio'),
    (r'\ballocutus\b', 'alloquor'),
    (r'\ballon\b', 'allus'),
    (r'\balloquar\b', 'alloquor'),
    (r'\balloquebatur\b', 'alloquor'),
    (r'\balloquendi\b', 'alloquor'),
    (r'\balloquerer\b', 'alloquor'),
    (r'\balloqueris\b', 'alloquor'),
    (r'\balloqui\b', 'alloquium'),
    (r'\balloqui\b', 'alloquor'),
    (r'\balloquiis\b', 'alloquium'),
    (r'\balloquio\b', 'alloquium'),
    (r'\balloquioque\b', 'alloquium'),
    (r'\balloquitur\b', 'alloquor'),
    (r'\balloquor\b', 'alloquor'),
    (r'\ballucens\b', 'alluceo'),
    (r'\balludebant\b', 'alludo'),
    (r'\balludis\b', 'alludo'),
    (r'\balludit\b', 'alludo'),
    (r'\balluendo\b', 'alluo'),
    (r'\balluens\b', 'alluo'),
    (r'\ballueret\b', 'alluo'),
    (r'\balluit\b', 'alluo'),
    (r'\balluitur\b', 'alluo'),
    (r'\ballus\b', 'allus'),
    (r'\balluserit\b', 'alludo'),
    (r'\ballusit\b', 'alludo'),
    (r'\balluuie\b', 'alluvies'),
    (r'\balluuie\b', 'alluvius'),
    (r'\balluuio\b', 'alluvio'),
    (r'\balluuio\b', 'alluvius'),
    (r'\balluuion\b', 'alluvio'),
    (r'\balluuion\b', 'alluvius'),
    (r'\balluuione\b', 'alluvio'),
    (r'\balluuione\b', 'alluvius'),
    (r'\balluuionem\b', 'alluvio'),
    (r'\balluuionis\b', 'alluvio'),
    (r'\balluvie\b', 'alluvies'),
    (r'\balluvie\b', 'alluvius'),
    (r'\balma\b', 'almus'),
    (r'\balmae\b', 'almus'),
    (r'\balmam\b', 'almus'),
    (r'\balmaque\b', 'almus'),
    (r'\balme\b', 'almus'),
    (r'\balmi\b', 'almus'),
    (r'\balmis\b', 'almus'),
    (r'\bAlmo\b', 'Almo'),
    (r'\balmo\b', 'almus'),
    (r'\balmon\b', 'almus'),
    (r'\bAlmon\b', 'Almo'),
    (r'\bAlmone\b', 'Almo'),
    (r'\balmone\b', 'almus'),
    (r'\bAlmonem\b', 'Almo'),
    (r'\bAlmonis\b', 'Almo'),
    (r'\balmum\b', 'almus'),
    (r'\balmus\b', 'almus'),
    (r'\balneas\b', 'alneus'),
    (r'\balneis\b', 'alneus'),
    (r'\balni\b', 'alnus'),
    (r'\balnis\b', 'alnus'),
    (r'\balno\b', 'alnus'),
    (r'\balnos\b', 'alnus'),
    (r'\balnum\b', 'alnus'),
    (r'\balnus\b', 'alnus'),
    (r'\balo\b', 'aluta'),
    (r'\balo\b', 'alum'),
    (r'\balo\b', 'alo'),
    (r'\baloe\b', 'aloe'),
    (r'\baloen\b', 'aloe'),
    (r'\baloes\b', 'aloe'),
    (r'\balogas\b', 'alogus'),
    (r'\balogias\b', 'alogia'),
    (r'\balogum\b', 'alogus'),
    (r'\bAloidae\b', 'Aloidae'),
    (r'\bAloidas\b', 'Aloidae'),
    (r'\bAlope\b', 'Alope'),
    (r'\balopecia\b', 'alopecia'),
    (r'\balopeciarum\b', 'alopecia'),
    (r'\balopecias\b', 'alopecia'),
    (r'\balopeciasque\b', 'alopecia'),
    (r'\balopeciis\b', 'alopecia'),
    (r'\balopeciisque\b', 'alopecia'),
    (r'\balopecis\b', 'alopecis'),
    (r'\balopecuros\b', 'alopecuros'),
    (r'\bAlopes\b', 'Alope'),
    (r'\bAlpe\b', 'Alpis'),
    (r'\bAlpem\b', 'Alpis'),
    (r'\bAlpemque\b', 'Alpis'),
    (r'\bAlpes\b', 'Alpis'),
    (r'\bAlpesne\b', 'Alpis'),
    (r'\bAlpesque\b', 'Alpis'),
    (r'\balpha\b', 'alpha'),
    (r'\bAlphea\b', 'Alpheus'),
    (r'\bAlpheae\b', 'Alpheus'),
    (r'\bAlphee\b', 'Alpheus'),
    (r'\bAlphei\b', 'Alpheus'),
    (r'\bAlpheias\b', 'Alpheias'),
    (r'\bAlpheo\b', 'Alpheus'),
    (r'\bAlpheon\b', 'Alpheus'),
    (r'\bAlpheos\b', 'Alpheus'),
    (r'\bAlpheosque\b', 'Alpheus'),
    (r'\bAlphesiboea\b', 'Alphesiboea'),
    (r'\bAlphesiboeae\b', 'Alphesiboea'),
    (r'\bAlpheum\b', 'Alpheus'),
    (r'\bAlpheumque\b', 'Alpheus'),
    (r'\bAlpheus\b', 'Alpheus'),
    (r'\balpho\b', 'alphus'),
    (r'\balphos\b', 'alphus'),
    (r'\bAlpibus\b', 'Alpis'),
    (r'\bAlpibusque\b', 'Alpis'),
    (r'\bAlpicos\b', 'Alpicus'),
    (r'\bAlpina\b', 'Alpinus'),
    (r'\bAlpinae\b', 'Alpinus'),
    (r'\bAlpinam\b', 'Alpinus'),
    (r'\bAlpinaque\b', 'Alpinus'),
    (r'\bAlpinarum\b', 'Alpinus'),
    (r'\bAlpinas\b', 'Alpinus'),
    (r'\bAlpini\b', 'Alpinus'),
    (r'\bAlpinis\b', 'Alpinus'),
    (r'\bAlpinius\b', 'Alpinus'),
    (r'\bAlpino\b', 'Alpinus'),
    (r'\bAlpinorum\b', 'Alpinus'),
    (r'\bAlpinos\b', 'Alpinus'),
    (r'\bAlpinosque\b', 'Alpinus'),
    (r'\bAlpinum\b', 'Alpinus'),
    (r'\bAlpinus\b', 'Alpinus'),
    (r'\bAlpis\b', 'Alpis'),
    (r'\bAlpisque\b', 'Alpis'),
    (r'\bAlpium\b', 'Alpis'),
    (r'\bAlpiumque\b', 'Alpis'),
    (r'\balsia\b', 'alsius1'),
    (r'\bAlsiense\b', 'Alsiensis'),
    (r'\bAlsiensem\b', 'Alsiensis'),
    (r'\bAlsienses\b', 'Alsiensis'),
    (r'\bAlsiensi\b', 'Alsiensis'),
    (r'\bAlsiensis\b', 'Alsiensis'),
    (r'\balsine\b', 'alsine'),
    (r'\bAlsine\b', 'Alsius2'),
    (r'\balsiosa\b', 'alsiosus'),
    (r'\balsiosis\b', 'alsiosus'),
    (r'\balsiosisque\b', 'alsiosus'),
    (r'\balsiosum\b', 'alsiosus'),
    (r'\balsium\b', 'alsius1'),
    (r'\bAlsium\b', 'Alsius2'),
    (r'\balsius\b', 'alsius1'),
    (r'\balta\b', 'altus1'),
    (r'\balta\b', 'altum'),
    (r'\balta\b', 'alo'),
    (r'\balta\b', 'alto'),
    (r'\baltae\b', 'altus1'),
    (r'\baltae\b', 'alo'),
    (r'\baltaeque\b', 'altus1'),
    (r'\baltaeque\b', 'alo'),
    (r'\baltam\b', 'altus1'),
    (r'\baltam\b', 'alo'),
    (r'\baltamque\b', 'altus1'),
    (r'\baltamque\b', 'alo'),
    (r'\baltani\b', 'altanus'),
    (r'\baltanos\b', 'altanus'),
    (r'\baltanus\b', 'altanus'),
    (r'\baltaque\b', 'altus1'),
    (r'\baltaque\b', 'altum'),
    (r'\baltaque\b', 'alo'),
    (r'\baltaque\b', 'alto'),
    (r'\baltare\b', 'altar'),
    (r'\baltare\b', 'altare'),
    (r'\baltare\b', 'alto'),
    (r'\baltari\b', 'altare'),
    (r'\baltari\b', 'altar'),
    (r'\baltari\b', 'altarium'),
    (r'\baltari\b', 'alto'),
    (r'\baltaria\b', 'altare'),
    (r'\baltaribus\b', 'altar'),
    (r'\baltarii\b', 'altarium'),
    (r'\baltario\b', 'altarium'),
    (r'\baltaris\b', 'altar'),
    (r'\baltaris\b', 'alto'),
    (r'\baltarium\b', 'altare'),
    (r'\baltarium\b', 'altarium'),
    (r'\baltarum\b', 'altus1'),
    (r'\baltarum\b', 'altar'),
    (r'\baltarum\b', 'alo'),
    (r'\baltas\b', 'altus1'),
    (r'\baltas\b', 'alo'),
    (r'\baltas\b', 'alto'),
    (r'\baltasque\b', 'altus1'),
    (r'\baltasque\b', 'alo'),
    (r'\baltasque\b', 'alto'),
    (r'\balte\b', 'altus1'),
    (r'\balte\b', 'altum'),
    (r'\balte\b', 'alo'),
    (r'\baltene\b', 'altus1'),
    (r'\baltene\b', 'altum'),
    (r'\baltene\b', 'alo'),
    (r'\balteque\b', 'altus1'),
    (r'\balteque\b', 'altum'),
    (r'\balteque\b', 'alo'),
    (r'\balter\b', 'alter'),
    (r'\balter\b', 'alto'),
    (r'\baltera\b', 'alter'),
    (r'\balterae\b', 'alter'),
    (r'\balteram\b', 'alter'),
    (r'\balteramque\b', 'alter'),
    (r'\balteramue\b', 'alter'),
    (r'\balteraque\b', 'alter'),
    (r'\balterarum\b', 'alter'),
    (r'\balteras\b', 'alter'),
    (r'\balteras\b', 'alteras'),
    (r'\balterast\b', 'alter'),
    (r'\balterave\b', 'alter'),
    (r'\baltercabantur\b', 'alterco'),
    (r'\baltercamur\b', 'alterco'),
    (r'\baltercandi\b', 'alterco'),
    (r'\baltercando\b', 'alterco'),
    (r'\baltercandoque\b', 'alterco'),
    (r'\baltercandum\b', 'alterco'),
    (r'\baltercant\b', 'alterco'),
    (r'\baltercante\b', 'alterco'),
    (r'\baltercantem\b', 'alterco'),
    (r'\baltercantes\b', 'alterco'),
    (r'\baltercantibus\b', 'alterco'),
    (r'\baltercare\b', 'alterco'),
    (r'\baltercaretur\b', 'alterco'),
    (r'\baltercari\b', 'alterco'),
    (r'\baltercas\b', 'alterco'),
    (r'\baltercasti\b', 'alterco'),
    (r'\baltercat\b', 'alterco'),
    (r'\baltercati\b', 'alterco'),
    (r'\baltercatio\b', 'altercatio'),
    (r'\baltercatione\b', 'altercatio'),
    (r'\baltercationem\b', 'altercatio'),
    (r'\baltercationes\b', 'altercatio'),
    (r'\baltercationesque\b', 'altercatio'),
    (r'\baltercationibus\b', 'altercatio'),
    (r'\baltercationis\b', 'altercatio'),
    (r'\baltercator\b', 'altercator'),
    (r'\baltercatoribus\b', 'altercator'),
    (r'\baltercatus\b', 'alterco'),
    (r'\balterceris\b', 'alterco'),
    (r'\balterci\b', 'alterculum'),
    (r'\baltercum\b', 'alterculum'),
    (r'\balteri\b', 'alter'),
    (r'\balteris\b', 'alter'),
    (r'\balteris\b', 'alto'),
    (r'\balterius\b', 'alter'),
    (r'\balteriusque\b', 'alter'),
    (r'\balteriusue\b', 'alter'),
    (r'\balterive\b', 'alter'),
    (r'\balterna\b', 'alternus'),
    (r'\balterna\b', 'alterno'),
    (r'\balternae\b', 'alternus'),
    (r'\balternaeque\b', 'alternus'),
    (r'\balternam\b', 'alternus'),
    (r'\balternanda\b', 'alterno'),
    (r'\balternans\b', 'alterno'),
    (r'\balternant\b', 'alterno'),
    (r'\balternante\b', 'alterno'),
    (r'\balternantes\b', 'alterno'),
    (r'\balternanti\b', 'alterno'),
    (r'\balternaque\b', 'alternus'),
    (r'\balternaque\b', 'alterno'),
    (r'\balternare\b', 'alterno'),
    (r'\balternari\b', 'alterno'),
    (r'\balternas\b', 'alternus'),
    (r'\balternas\b', 'alterno'),
    (r'\balternasque\b', 'alternus'),
    (r'\balternasque\b', 'alterno'),
    (r'\balternasse\b', 'alterno'),
    (r'\balternat\b', 'alterno'),
    (r'\balternata\b', 'alterno'),
    (r'\balternatae\b', 'alterno'),
    (r'\balternatim\b', 'alternatim'),
    (r'\balternatio\b', 'alternatio'),
    (r'\balternatione\b', 'alternatio'),
    (r'\balternationi\b', 'alternatio'),
    (r'\balternationibus\b', 'alternatio'),
    (r'\balternatis\b', 'alterno'),
    (r'\balternatos\b', 'alterno'),
    (r'\balternatque\b', 'alterno'),
    (r'\balternemus\b', 'alterno'),
    (r'\balternet\b', 'alterno'),
    (r'\balterni\b', 'alternus'),
    (r'\balternique\b', 'alternus'),
    (r'\balternis\b', 'alternus'),
    (r'\balternisque\b', 'alternus'),
    (r'\balterno\b', 'alternus'),
    (r'\balterno\b', 'alterno'),
    (r'\balternoque\b', 'alternus'),
    (r'\balternoque\b', 'alterno'),
    (r'\balternorum\b', 'alternus'),
    (r'\balternos\b', 'alternus'),
    (r'\balternosque\b', 'alternus'),
    (r'\balternum\b', 'alternus'),
    (r'\balternumque\b', 'alternus'),
    (r'\balternus\b', 'alternus'),
    (r'\balternusque\b', 'alternus'),
    (r'\baltero\b', 'alter'),
    (r'\balteroque\b', 'alter'),
    (r'\balterorum\b', 'alter'),
    (r'\balteros\b', 'alter'),
    (r'\balteroue\b', 'alter'),
    (r'\balterove\b', 'alter'),
    (r'\balterque\b', 'alter'),
    (r'\balterque\b', 'alto'),
    (r'\balterue\b', 'alter'),
    (r'\balterue\b', 'alto'),
    (r'\balterum\b', 'alter'),
    (r'\balterumque\b', 'alter'),
    (r'\balterumue\b', 'alter'),
    (r'\balterumve\b', 'alter'),
    (r'\balteruter\b', 'alteruter'),
    (r'\balterutra\b', 'alteruter'),
    (r'\balterutrae\b', 'alteruter'),
    (r'\balterutram\b', 'alteruter'),
    (r'\balterutraque\b', 'alteruter'),
    (r'\balterutras\b', 'alteruter'),
    (r'\balterutri\b', 'alteruter'),
    (r'\balterutris\b', 'alteruter'),
    (r'\balterutrius\b', 'alteruter'),
    (r'\balterutro\b', 'alteruter'),
    (r'\balterutrum\b', 'alteruter'),
    (r'\balterve\b', 'alter'),
    (r'\balterve\b', 'alto'),
    (r'\balthaea\b', 'althaea1'),
    (r'\bAlthaea\b', 'Althaea2'),
    (r'\balthaeae\b', 'althaea1'),
    (r'\bAlthaeae\b', 'Althaea2'),
    (r'\balthaeam\b', 'althaea1'),
    (r'\bAlthaeam\b', 'Althaea2'),
    (r'\balti\b', 'altus1'),
    (r'\balti\b', 'altum'),
    (r'\balti\b', 'alo'),
    (r'\balticinctis\b', 'alticinctus'),
    (r'\baltilaneam\b', 'altilaneus'),
    (r'\baltile\b', 'altilis'),
    (r'\baltiles\b', 'altilis'),
    (r'\baltili\b', 'altilis'),
    (r'\baltilia\b', 'altilis'),
    (r'\baltilibus\b', 'altilis'),
    (r'\baltiliorem\b', 'altilis'),
    (r'\baltilis\b', 'altilis'),
    (r'\baltilium\b', 'altilis'),
    (r'\bAltinae\b', 'altipendulus'),
    (r'\bAltinates\b', 'Altinum'),
    (r'\bAltinatesque\b', 'Altinum'),
    (r'\bAltinatium\b', 'Altinum'),
    (r'\bAltini\b', 'altipendulus'),
    (r'\bAltini\b', 'Altinum'),
    (r'\bAltinius\b', 'altipendulus'),
    (r'\bAltino\b', 'altipendulus'),
    (r'\bAltino\b', 'Altinum'),
    (r'\bAltinum\b', 'altipendulus'),
    (r'\bAltinum\b', 'Altinum'),
    (r'\bAltinumque\b', 'altipendulus'),
    (r'\bAltinumque\b', 'Altinum'),
    (r'\baltior\b', 'alo'),
    (r'\baltiora\b', 'alo'),
    (r'\baltiore\b', 'alo'),
    (r'\baltiorem\b', 'alo'),
    (r'\baltioremque\b', 'alo'),
    (r'\baltiores\b', 'alo'),
    (r'\baltioresque\b', 'alo'),
    (r'\baltioribus\b', 'alo'),
    (r'\baltioris\b', 'alo'),
    (r'\baltiorque\b', 'alo'),
    (r'\baltiorum\b', 'alo'),
    (r'\baltipendulos\b', 'altipendulus'),
    (r'\baltique\b', 'altus1'),
    (r'\baltique\b', 'altum'),
    (r'\baltique\b', 'alo'),
    (r'\baltis\b', 'altus1'),
    (r'\baltis\b', 'altum'),
    (r'\baltis\b', 'alo'),
    (r'\baltisona\b', 'altisonus'),
    (r'\baltisoni\b', 'altisonus'),
    (r'\baltisono\b', 'altisonus'),
    (r'\baltisonum\b', 'altisonus'),
    (r'\baltisonus\b', 'altisonus'),
    (r'\baltisque\b', 'altus1'),
    (r'\baltisque\b', 'altum'),
    (r'\baltisque\b', 'alo'),
    (r'\baltissima\b', 'alo'),
    (r'\baltissimae\b', 'alo'),
    (r'\baltissimam\b', 'alo'),
    (r'\baltissimaque\b', 'alo'),
    (r'\baltissimas\b', 'alo'),
    (r'\baltissime\b', 'alo'),
    (r'\baltissimeque\b', 'alo'),
    (r'\baltissimi\b', 'alo'),
    (r'\baltissimis\b', 'alo'),
    (r'\baltissimisque\b', 'alo'),
    (r'\baltissimo\b', 'alo'),
    (r'\baltissimorum\b', 'alo'),
    (r'\baltissimos\b', 'alo'),
    (r'\baltissimum\b', 'alo'),
    (r'\baltissimus\b', 'alo'),
    (r'\baltitonae\b', 'altitonus'),
    (r'\baltitudine\b', 'altitudo'),
    (r'\baltitudinem\b', 'altitudo'),
    (r'\baltitudinemque\b', 'altitudo'),
    (r'\baltitudines\b', 'altitudo'),
    (r'\baltitudinesque\b', 'altitudo'),
    (r'\baltitudini\b', 'altitudo'),
    (r'\baltitudinibus\b', 'altitudo'),
    (r'\baltitudinis\b', 'altitudo'),
    (r'\baltitudinum\b', 'altitudo'),
    (r'\baltitudo\b', 'altitudo'),
    (r'\baltius\b', 'alo'),
    (r'\baltiuscule\b', 'altiusculus'),
    (r'\baltiusculis\b', 'altiusculus'),
    (r'\baltiusque\b', 'alo'),
    (r'\baltivolae\b', 'altivolus'),
    (r'\balto\b', 'altus1'),
    (r'\balto\b', 'altum'),
    (r'\balto\b', 'alo'),
    (r'\balto\b', 'alto'),
    (r'\baltoque\b', 'altus1'),
    (r'\baltoque\b', 'altum'),
    (r'\baltoque\b', 'alo'),
    (r'\baltoque\b', 'alto'),
    (r'\baltor\b', 'altor'),
    (r'\baltor\b', 'alto'),
    (r'\baltore\b', 'altor'),
    (r'\baltorem\b', 'altor'),
    (r'\baltores\b', 'altor'),
    (r'\baltoris\b', 'altor'),
    (r'\baltorum\b', 'altor'),
    (r'\baltorum\b', 'altum'),
    (r'\baltorum\b', 'alo'),
    (r'\baltos\b', 'altus1'),
    (r'\baltos\b', 'alo'),
    (r'\baltosque\b', 'altus1'),
    (r'\baltosque\b', 'alo'),
    (r'\baltrice\b', 'altrix'),
    (r'\baltricem\b', 'altrix'),
    (r'\baltricemque\b', 'altrix'),
    (r'\baltrices\b', 'altrix'),
    (r'\baltrici\b', 'altrix'),
    (r'\baltricis\b', 'altrix'),
    (r'\baltricum\b', 'altrix'),
    (r'\baltrinsecus\b', 'altrinsecus'),
    (r'\baltrinsecust\b', 'altrinsecus'),
    (r'\baltrix\b', 'altrix'),
    (r'\baltrixque\b', 'altrix'),
    (r'\baltrovorsum\b', 'altrovorsum'),
    (r'\baltu\b', 'altus2'),
    (r'\baltu\b', 'alo'),
    (r'\baltum\b', 'altus1'),
    (r'\baltum\b', 'altum'),
    (r'\baltum\b', 'alo'),
    (r'\baltumque\b', 'altus1'),
    (r'\baltumque\b', 'altum'),
    (r'\baltumque\b', 'alo'),
    (r'\baltumue\b', 'altus1'),
    (r'\baltumue\b', 'altum'),
    (r'\baltumue\b', 'alo'),
    (r'\baltus\b', 'altus2'),
    (r'\baltus\b', 'altus1'),
    (r'\baltus\b', 'alo'),
    (r'\baltusque\b', 'altus2'),
    (r'\baltusque\b', 'altus1'),
    (r'\baltusque\b', 'alo'),
    (r'\baluare\b', 'aluta'),
    (r'\baluas\b', 'aluta'),
    (r'\balucinanti\b', 'alucinor'),
    (r'\balucinantibus\b', 'alucinor'),
    (r'\balucinantis\b', 'alucinor'),
    (r'\balucinari\b', 'alucinor'),
    (r'\balucitae\b', 'alucita'),
    (r'\balue\b', 'alvus'),
    (r'\baluearibus\b', 'alvearium'),
    (r'\balueatos\b', 'alveatus'),
    (r'\baluei\b', 'alveus'),
    (r'\balueis\b', 'alveus'),
    (r'\balueo\b', 'alveus'),
    (r'\balueolis\b', 'alveolus'),
    (r'\balueolo\b', 'alveolus'),
    (r'\balueolos\b', 'alveolus'),
    (r'\balueolum\b', 'alveolus'),
    (r'\balueolumque\b', 'alveolus'),
    (r'\balueoque\b', 'alveus'),
    (r'\balueorum\b', 'alveus'),
    (r'\balueos\b', 'alveus'),
    (r'\balueosque\b', 'alveus'),
    (r'\baluerat\b', 'alo'),
    (r'\baluere\b', 'alo'),
    (r'\baluerim\b', 'alo'),
    (r'\baluerint\b', 'alo'),
    (r'\balueris\b', 'alo'),
    (r'\baluerit\b', 'alo'),
    (r'\balueritis\b', 'alo'),
    (r'\baluero\b', 'alo'),
    (r'\baluerunt\b', 'alo'),
    (r'\balueruntque\b', 'alo'),
    (r'\balueum\b', 'alveus'),
    (r'\balueus\b', 'alveus'),
    (r'\balui\b', 'alvus'),
    (r'\balui\b', 'alo'),
    (r'\baluimus\b', 'alo'),
    (r'\baluique\b', 'alvus'),
    (r'\baluique\b', 'alo'),
    (r'\baluis\b', 'alvus'),
    (r'\baluisse\b', 'alo'),
    (r'\baluissem\b', 'alo'),
    (r'\baluissent\b', 'alo'),
    (r'\baluisses\b', 'alo'),
    (r'\baluisset\b', 'alo'),
    (r'\baluistis\b', 'alo'),
    (r'\baluit\b', 'alo'),
    (r'\baluitque\b', 'alo'),
    (r'\balum\b', 'aluta'),
    (r'\balum\b', 'alum'),
    (r'\balumen\b', 'alumen'),
    (r'\baluminata\b', 'aluminatus'),
    (r'\balumine\b', 'alumen'),
    (r'\balumini\b', 'alumen'),
    (r'\baluminis\b', 'alumen'),
    (r'\baluminosa\b', 'aluminosus'),
    (r'\baluminosas\b', 'aluminosus'),
    (r'\baluminosi\b', 'aluminosus'),
    (r'\baluminosum\b', 'aluminosus'),
    (r'\balumna\b', 'alumna'),
    (r'\balumna\b', 'alumnus'),
    (r'\balumna\b', 'alumno'),
    (r'\balumnae\b', 'alumna'),
    (r'\balumnam\b', 'alumna'),
    (r'\balumnandam\b', 'alumno'),
    (r'\balumnarum\b', 'alumna'),
    (r'\balumnas\b', 'alumna'),
    (r'\balumnas\b', 'alumno'),
    (r'\balumnati\b', 'alumno'),
    (r'\balumnatos\b', 'alumno'),
    (r'\balumnatus\b', 'alumno'),
    (r'\balumne\b', 'alumnus'),
    (r'\balumni\b', 'alumnus'),
    (r'\balumnis\b', 'alumna'),
    (r'\balumnis\b', 'alumnus'),
    (r'\balumno\b', 'alumnus'),
    (r'\balumno\b', 'alumno'),
    (r'\balumnos\b', 'alumnus'),
    (r'\balumnum\b', 'alumnus'),
    (r'\balumnus\b', 'alumnus'),
    (r'\balunt\b', 'alo'),
    (r'\baluntque\b', 'alo'),
    (r'\baluntur\b', 'alo'),
    (r'\balunturque\b', 'alo'),
    (r'\baluntve\b', 'alo'),
    (r'\baluo\b', 'alvus'),
    (r'\baluom\b', 'alvus'),
    (r'\baluorum\b', 'alvus'),
    (r'\baluos\b', 'alvus'),
    (r'\baluosque\b', 'alvus'),
    (r'\balus\b', 'aluta'),
    (r'\baluta\b', 'aluta'),
    (r'\balutae\b', 'aluta'),
    (r'\balutaeque\b', 'aluta'),
    (r'\balutam\b', 'aluta'),
    (r'\baluum\b', 'alvus'),
    (r'\baluus\b', 'alvus'),
    (r'\balvearia\b', 'alvearium'),
    (r'\balvearibus\b', 'alvearium'),
    (r'\balveariis\b', 'alvearium'),
    (r'\balveariorum\b', 'alvearium'),
    (r'\balvearium\b', 'alvearium'),
    (r'\balvearium\b', 'alvearium'),
    (r'\balvei\b', 'alveus'),
    (r'\balveis\b', 'alveus'),
    (r'\balveo\b', 'alveus'),
    (r'\balveolatum\b', 'alveolatus'),
    (r'\balveolo\b', 'alveolus'),
    (r'\balveolorum\b', 'alveolus'),
    (r'\balveolum\b', 'alveolus'),
    (r'\balveos\b', 'alveus'),
    (r'\balveum\b', 'alveus'),
    (r'\balveus\b', 'alveus'),
    (r'\balveusne\b', 'alveus'),
    (r'\balvi\b', 'alvus'),
    (r'\balvique\b', 'alvus'),
    (r'\balvis\b', 'alvus'),
    (r'\balvo\b', 'alvus'),
    (r'\balvom\b', 'alvus'),
    (r'\balvoque\b', 'alvus'),
    (r'\balvorum\b', 'alvus'),
    (r'\balvos\b', 'alvus'),
    (r'\balvosque\b', 'alvus'),
    (r'\balvum\b', 'alvus'),
    (r'\balvumque\b', 'alvus'),
    (r'\balvus\b', 'alvus'),
    (r'\balypon\b', 'alypon'),
    (r'\balysso\b', 'alysson'),
    (r'\bAlyzia\b', 'Alyzia'),
    (r'\bAlyziam\b', 'Alyzia'),
    (r'\bama\b', 'amo'),
    (r'\bamabam\b', 'amo'),
    (r'\bamabamus\b', 'amo'),
    (r'\bamabant\b', 'amo'),
    (r'\bamabantur\b', 'amo'),
    (r'\bamabar\b', 'amo'),
    (r'\bamabas\b', 'amo'),
    (r'\bamabat\b', 'amo'),
    (r'\bamabatur\b', 'amo'),
    (r'\bamabaturque\b', 'amo'),
    (r'\bamabile\b', 'amabilis'),
    (r'\bamabilem\b', 'amabilis'),
    (r'\bamabiles\b', 'amabilis'),
    (r'\bamabili\b', 'amabilis'),
    (r'\bamabilia\b', 'amabilis'),
    (r'\bamabilior\b', 'amabilis'),
    (r'\bamabiliora\b', 'amabilis'),
    (r'\bamabilis\b', 'amabilis'),
    (r'\bamabilissimum\b', 'amabilis'),
    (r'\bamabilissimus\b', 'amabilis'),
    (r'\bamabilitas\b', 'amabilitas'),
    (r'\bamabilitati\b', 'amabilitas'),
    (r'\bamabiliter\b', 'amabilis'),
    (r'\bamabiliter\b', 'amabiliter'),
    (r'\bamabilius\b', 'amabilis'),
    (r'\bamabimus\b', 'amo'),
    (r'\bamabis\b', 'amo'),
    (r'\bamabit\b', 'amo'),
    (r'\bamabitur\b', 'amo'),
    (r'\bamabo\b', 'amo'),
    (r'\bamabor\b', 'amo'),
    (r'\bamabunt\b', 'amo'),
    (r'\bAmafinii\b', 'Amalthea'),
    (r'\bAmafinium\b', 'Amalthea'),
    (r'\bAmafinius\b', 'Amalthea'),
    (r'\bAmalthea\b', 'Amalthea'),
    (r'\bAmalthea\b', 'amandatio'),
    (r'\bAmaltheae\b', 'Amalthea'),
    (r'\bAmaltheam\b', 'Amalthea'),
    (r'\bAmaltheo\b', 'amandatio'),
    (r'\bamamur\b', 'amo'),
    (r'\bamamus\b', 'amo'),
    (r'\baman\b', 'amo'),
    (r'\bamana\b', 'a-mano'),
    (r'\bamanda\b', 'amo'),
    (r'\bamanda\b', 'amando'),
    (r'\bamandam\b', 'amo'),
    (r'\bamandandi\b', 'amando'),
    (r'\bamandandus\b', 'amando'),
    (r'\bamandarat\b', 'amando'),
    (r'\bamandare\b', 'amando'),
    (r'\bamandas\b', 'amo'),
    (r'\bamandas\b', 'amando'),
    (r'\bamandasque\b', 'amo'),
    (r'\bamandasque\b', 'amando'),
    (r'\bamandat\b', 'amando'),
    (r'\bamandati\b', 'amando'),
    (r'\bamandatio\b', 'amandatio'),
    (r'\bamandato\b', 'amando'),
    (r'\bamandatur\b', 'amando'),
    (r'\bamandatus\b', 'amando'),
    (r'\bamandavit\b', 'amando'),
    (r'\bamandi\b', 'amo'),
    (r'\bamandique\b', 'amo'),
    (r'\bamando\b', 'amo'),
    (r'\bamando\b', 'amando'),
    (r'\bamandone\b', 'amo'),
    (r'\bamandone\b', 'amando'),
    (r'\bamandos\b', 'amo'),
    (r'\bamandum\b', 'amo'),
    (r'\bamandus\b', 'amo'),
    (r'\bAmani\b', 'Amanus'),
    (r'\bamanicas\b', 'a-manico'),
    (r'\bAmaniensis\b', 'a-manico'),
    (r'\bAmano\b', 'Amanus'),
    (r'\bamano\b', 'a-mano'),
    (r'\bamans\b', 'amo'),
    (r'\bamansque\b', 'amo'),
    (r'\bamant\b', 'amo'),
    (r'\bamante\b', 'amo'),
    (r'\bamantem\b', 'amo'),
    (r'\bamanter\b', 'amanter'),
    (r'\bAmantes\b', 'Amantia'),
    (r'\bamantes\b', 'amo'),
    (r'\bamanti\b', 'amo'),
    (r'\bAmantia\b', 'Amantia'),
    (r'\bamantia\b', 'amo'),
    (r'\bAmantiam\b', 'Amantia'),
    (r'\bamantibus\b', 'amo'),
    (r'\bAmantini\b', 'amanuensis'),
    (r'\bAmantinorum\b', 'amanuensis'),
    (r'\bamantior\b', 'amo'),
    (r'\bamantiore\b', 'amo'),
    (r'\bamantiorem\b', 'amo'),
    (r'\bamantis\b', 'amo'),
    (r'\bamantissima\b', 'amo'),
    (r'\bamantissimam\b', 'amo'),
    (r'\bamantissimas\b', 'amo'),
    (r'\bamantissime\b', 'amo'),
    (r'\bamantissimi\b', 'amo'),
    (r'\bamantissimis\b', 'amo'),
    (r'\bamantissimisque\b', 'amo'),
    (r'\bamantissimo\b', 'amo'),
    (r'\bamantissimorum\b', 'amo'),
    (r'\bamantissimos\b', 'amo'),
    (r'\bamantissimum\b', 'amo'),
    (r'\bamantissimumque\b', 'amo'),
    (r'\bamantissimus\b', 'amo'),
    (r'\bamantist\b', 'amo'),
    (r'\bamantium\b', 'amo'),
    (r'\bamantius\b', 'amo'),
    (r'\bamanto\b', 'amo'),
    (r'\bamantque\b', 'amo'),
    (r'\bamantur\b', 'amo'),
    (r'\bamanuensibus\b', 'amanuensis'),
    (r'\bAmanum\b', 'Amanus'),
    (r'\bAmanus\b', 'Amanus'),
    (r'\bamara\b', 'amarus'),
    (r'\bamaraci\b', 'amaracus'),
    (r'\bamaraci\b', 'amaracus'),
    (r'\bamaracina\b', 'amaracinus'),
    (r'\bamaracina\b', 'amaracinus'),
    (r'\bamaracini\b', 'amaracinus'),
    (r'\bamaracini\b', 'amaracinus'),
    (r'\bamaracino\b', 'amaracinus'),
    (r'\bamaracino\b', 'amaracinus'),
    (r'\bamaracinum\b', 'amaracinus'),
    (r'\bamaracinum\b', 'amaracinus'),
    (r'\bamaraco\b', 'amaracus'),
    (r'\bamaraco\b', 'amaracus'),
    (r'\bamaracum\b', 'amaracus'),
    (r'\bamaracum\b', 'amaracus'),
    (r'\bamaracus\b', 'amaracus'),
    (r'\bamarae\b', 'amarus'),
    (r'\bamaraeque\b', 'amarus'),
    (r'\bamaram\b', 'amarus'),
    (r'\bamaram\b', 'amo'),
    (r'\bamaran\b', 'amarus'),
    (r'\bamaran\b', 'amo'),
    (r'\bamarante\b', 'amarantus'),
    (r'\bamaranti\b', 'amarantus'),
    (r'\bamarantis\b', 'amarantus'),
    (r'\bamaranto\b', 'amarantus'),
    (r'\bamarantus\b', 'amarantus'),
    (r'\bamaraque\b', 'amarus'),
    (r'\bamararum\b', 'amarus'),
    (r'\bamaras\b', 'amarus'),
    (r'\bamaras\b', 'amo'),
    (r'\bamarat\b', 'amo'),
    (r'\bamare\b', 'amarus'),
    (r'\bamare\b', 'amo'),
    (r'\bamarem\b', 'amo'),
    (r'\bamaremus\b', 'amo'),
    (r'\bamarent\b', 'amo'),
    (r'\bamarentur\b', 'amo'),
    (r'\bamarer\b', 'amo'),
    (r'\bamares\b', 'amo'),
    (r'\bamarest\b', 'amarus'),
    (r'\bamarest\b', 'amo'),
    (r'\bamaret\b', 'amo'),
    (r'\bamaretur\b', 'amo'),
    (r'\bamari\b', 'amarus'),
    (r'\bamari\b', 'amo'),
    (r'\bamaricare\b', 'amarico'),
    (r'\bamaricatus\b', 'amarico'),
    (r'\bamariceris\b', 'amarico'),
    (r'\bamarior\b', 'amarus'),
    (r'\bamariore\b', 'amarus'),
    (r'\bamariorem\b', 'amarus'),
    (r'\bamariores\b', 'amarus'),
    (r'\bamarioribus\b', 'amarus'),
    (r'\bamarioris\b', 'amarus'),
    (r'\bamariorque\b', 'amarus'),
    (r'\bamarique\b', 'amarus'),
    (r'\bamarique\b', 'amo'),
    (r'\bamaris\b', 'amarus'),
    (r'\bamaris\b', 'amo'),
    (r'\bamarissima\b', 'amarus'),
    (r'\bamarissimae\b', 'amarus'),
    (r'\bamarissimam\b', 'amarus'),
    (r'\bamarissimas\b', 'amarus'),
    (r'\bamarissime\b', 'amarus'),
    (r'\bamarissimi\b', 'amarus'),
    (r'\bamarissimis\b', 'amarus'),
    (r'\bamarissimo\b', 'amarus'),
    (r'\bamarissimorum\b', 'amarus'),
    (r'\bamarissimos\b', 'amarus'),
    (r'\bamarissimum\b', 'amarus'),
    (r'\bamarit\b', 'amo'),
    (r'\bamaritate\b', 'amaritas'),
    (r'\bamaritate\b', 'amariter'),
    (r'\bamaritiem\b', 'amarities'),
    (r'\bamaritudine\b', 'amaritudo'),
    (r'\bamaritudinem\b', 'amaritudo'),
    (r'\bamaritudines\b', 'amaritudo'),
    (r'\bamaritudini\b', 'amaritudo'),
    (r'\bamaritudinibus\b', 'amaritudo'),
    (r'\bamaritudinis\b', 'amaritudo'),
    (r'\bamaritudinum\b', 'amaritudo'),
    (r'\bamaritudo\b', 'amaritudo'),
    (r'\bamarius\b', 'amarus'),
    (r'\bamariusque\b', 'amarus'),
    (r'\bamaro\b', 'amarus'),
    (r'\bamaror\b', 'amaror'),
    (r'\bamaros\b', 'amarus'),
    (r'\bamarulentus\b', 'amarulentus'),
    (r'\bamarum\b', 'amarus'),
    (r'\bamarumque\b', 'amarus'),
    (r'\bamarumst\b', 'amarus'),
    (r'\bamarunt\b', 'amo'),
    (r'\bamarus\b', 'amarus'),
    (r'\bAmarynthidis\b', 'Amarynthis'),
    (r'\bamas\b', 'amo'),
    (r'\bamasco\b', 'amasco'),
    (r'\bAmase\b', 'Amasis'),
    (r'\bAmasene\b', 'Amasenus'),
    (r'\bAmasenus\b', 'Amasenus'),
    (r'\bAmasi\b', 'Amasis'),
    (r'\bamasi\b', 'amasius'),
    (r'\bAmasia\b', 'Amasia'),
    (r'\bAmasiae\b', 'Amasia'),
    (r'\bAmasiam\b', 'Amasia'),
    (r'\bAmasias\b', 'Amasia'),
    (r'\bAmasim\b', 'Amasis'),
    (r'\bAmasin\b', 'Amasis'),
    (r'\bamasin\b', 'amasius'),
    (r'\bamasio\b', 'amasius'),
    (r'\bamasio\b', 'amasio'),
    (r'\bamasios\b', 'amasius'),
    (r'\bAmasis\b', 'Amasis'),
    (r'\bamasium\b', 'amasius'),
    (r'\bamasque\b', 'amo'),
    (r'\bamasse\b', 'amo'),
    (r'\bamasset\b', 'amo'),
    (r'\bamasso\b', 'a-masso1'),
    (r'\bamasti\b', 'amo'),
    (r'\bamastis\b', 'amo'),
    (r'\bAmastri\b', 'a-masso1'),
    (r'\bAmastriacis\b', 'a-masso1'),
    (r'\bAmastrianorum\b', 'a-masso1'),
    (r'\bAmastrin\b', 'a-masso1'),
    (r'\bAmastris\b', 'a-masso1'),
    (r'\bamat\b', 'amo'),
    (r'\bAmata\b', 'Amata'),
    (r'\bamata\b', 'amo'),
    (r'\bAmatae\b', 'Amata'),
    (r'\bamatae\b', 'amo'),
    (r'\bAmatam\b', 'Amata'),
    (r'\bamatam\b', 'amo'),
    (r'\bamatas\b', 'amo'),
    (r'\bamate\b', 'amo'),
    (r'\bamati\b', 'amo'),
    (r'\bamatio\b', 'amatio'),
    (r'\bamationibus\b', 'amatio'),
    (r'\bamatiost\b', 'amatio'),
    (r'\bamatis\b', 'amo'),
    (r'\bamatne\b', 'amo'),
    (r'\bamato\b', 'amo'),
    (r'\bamator\b', 'amator'),
    (r'\bamatorculos\b', 'amatorculus'),
    (r'\bamatore\b', 'amator'),
    (r'\bamatorem\b', 'amator'),
    (r'\bamatores\b', 'amator'),
    (r'\bamatori\b', 'amator'),
    (r'\bamatori\b', 'amatorius'),
    (r'\bamatoria\b', 'amatorius'),
    (r'\bamatoria\b', 'amatorius'),
    (r'\bamatoriae\b', 'amatorius'),
    (r'\bamatoriam\b', 'amatorius'),
    (r'\bamatorias\b', 'amatorius'),
    (r'\bamatoribus\b', 'amator'),
    (r'\bamatorie\b', 'amatorius'),
    (r'\bamatorie\b', 'amatorius'),
    (r'\bamatoriis\b', 'amatorius'),
    (r'\bamatoriis\b', 'amatorius'),
    (r'\bamatorio\b', 'amatorius'),
    (r'\bamatorio\b', 'amatorius'),
    (r'\bamatorios\b', 'amatorius'),
    (r'\bamatoris\b', 'amator'),
    (r'\bamatorium\b', 'amatorius'),
    (r'\bamatorium\b', 'amatorius'),
    (r'\bamatorque\b', 'amator'),
    (r'\bamatorum\b', 'amator'),
    (r'\bamatorum\b', 'amo'),
    (r'\bamatos\b', 'amo'),
    (r'\bamatque\b', 'amo'),
    (r'\bamatrice\b', 'amatrix'),
    (r'\bamatricem\b', 'amatrix'),
    (r'\bamatrices\b', 'amatrix'),
    (r'\bamatrici\b', 'amatrix'),
    (r'\bamatricis\b', 'amatrix'),
    (r'\bamatrix\b', 'amatrix'),
    (r'\bamatu\b', 'amo'),
    (r'\bamatum\b', 'amo'),
    (r'\bamatumque\b', 'amo'),
    (r'\bamatur\b', 'amo'),
    (r'\bamatura\b', 'amo'),
    (r'\bamaturae\b', 'amo'),
    (r'\bamaturo\b', 'amo'),
    (r'\bamaturum\b', 'amo'),
    (r'\bamaturus\b', 'amo'),
    (r'\bamatus\b', 'amo'),
    (r'\bamatusque\b', 'amo'),
    (r'\bamauerat\b', 'amo'),
    (r'\bamauerim\b', 'amo'),
    (r'\bamauerit\b', 'amo'),
    (r'\bamauerunt\b', 'amo'),
    (r'\bamaui\b', 'amo'),
    (r'\bamauimus\b', 'amo'),
    (r'\bamauit\b', 'amo'),
    (r'\bamaveras\b', 'amo'),
    (r'\bamaverat\b', 'amo'),
    (r'\bamaverim\b', 'amo'),
    (r'\bamaverint\b', 'amo'),
    (r'\bamaveris\b', 'amo'),
    (r'\bamaverit\b', 'amo'),
    (r'\bamaverunt\b', 'amo'),
    (r'\bamavi\b', 'amo'),
    (r'\bamavimus\b', 'amo'),
    (r'\bamavit\b', 'amo'),
    (r'\bamavitque\b', 'amo'),
    (r'\bAmazon\b', 'Amazon'),
    (r'\bAmazone\b', 'Amazon'),
    (r'\bAmazonem\b', 'Amazon'),
    (r'\bAmazones\b', 'Amazon'),
    (r'\bAmazoni\b', 'Amazon'),
    (r'\bAmazoni\b', 'Amazonius'),
    (r'\bAmazonia\b', 'Amazonius'),
    (r'\bAmazoniaeue\b', 'Amazonius'),
    (r'\bAmazoniam\b', 'Amazonius'),
    (r'\bAmazonibus\b', 'Amazon'),
    (r'\bAmazonicae\b', 'Amazonius'),
    (r'\bAmazonici\b', 'Amazonius'),
    (r'\bAmazonicis\b', 'Amazonius'),
    (r'\bAmazonico\b', 'Amazonius'),
    (r'\bAmazonicus\b', 'Amazonius'),
    (r'\bAmazonide\b', 'Amazonius'),
    (r'\bAmazonidum\b', 'Amazonius'),
    (r'\bAmazoniis\b', 'Amazonius'),
    (r'\bAmazonio\b', 'Amazonius'),
    (r'\bAmazonis\b', 'Amazon'),
    (r'\bAmazonis\b', 'Amazonius'),
    (r'\bAmazonium\b', 'Amazonius'),
    (r'\bAmazonius\b', 'Amazonius'),
    (r'\bAmazonum\b', 'Amazon'),
    (r'\bambactos\b', 'ambactus'),
    (r'\bambactos\b', 'ambago'),
    (r'\bambactus\b', 'ambactus'),
    (r'\bambactus\b', 'ambago'),
    (r'\bambae\b', 'ambo'),
    (r'\bambaeque\b', 'ambo'),
    (r'\bambage\b', 'ambages'),
    (r'\bambage\b', 'ambago'),
    (r'\bambages\b', 'ambages'),
    (r'\bambages\b', 'ambago'),
    (r'\bambagesque\b', 'ambages'),
    (r'\bambagesque\b', 'ambago'),
    (r'\bambagibus\b', 'ambages'),
    (r'\bambagine\b', 'ambago'),
    (r'\bambagiosa\b', 'ambagiosus'),
    (r'\bambagum\b', 'ambages'),
    (r'\bambarum\b', 'ambo'),
    (r'\bambarumque\b', 'ambo'),
    (r'\bambarvale\b', 'ambarvalis'),
    (r'\bambas\b', 'ambo'),
    (r'\bambecisu\b', 'ambecisus'),
    (r'\bambederat\b', 'ambedo'),
    (r'\bambederit\b', 'ambedo'),
    (r'\bambedisse\b', 'ambedo'),
    (r'\bambedit\b', 'ambedo'),
    (r'\bambesa\b', 'ambedo'),
    (r'\bambesas\b', 'ambedo'),
    (r'\bambestrices\b', 'ambestrix'),
    (r'\bambi\b', 'ambestrix'),
    (r'\bambibat\b', 'ambestrix'),
    (r'\bambibatur\b', 'ambestrix'),
    (r'\bambibunt\b', 'ambestrix'),
    (r'\bambiendi\b', 'ambestrix'),
    (r'\bambiendo\b', 'ambestrix'),
    (r'\bambiendum\b', 'ambestrix'),
    (r'\bambiens\b', 'ambestrix'),
    (r'\bambierantque\b', 'ambestrix'),
    (r'\bambierat\b', 'ambestrix'),
    (r'\bambieratque\b', 'ambestrix'),
    (r'\bambierit\b', 'ambestrix'),
    (r'\bambifariam\b', 'ambifarius'),
    (r'\bambifariam\b', 'ambifariam'),
    (r'\bambigam\b', 'ambiga'),
    (r'\bambigam\b', 'ambago'),
    (r'\bambigant\b', 'ambago'),
    (r'\bambigat\b', 'ambago'),
    (r'\bambigatur\b', 'ambago'),
    (r'\bambigebant\b', 'ambago'),
    (r'\bambigebatur\b', 'ambago'),
    (r'\bambigendi\b', 'ambago'),
    (r'\bambigendo\b', 'ambago'),
    (r'\bambigendum\b', 'ambago'),
    (r'\bambigent\b', 'ambago'),
    (r'\bambigente\b', 'ambago'),
    (r'\bambigentes\b', 'ambago'),
    (r'\bambigenti\b', 'ambago'),
    (r'\bambigentis\b', 'ambago'),
    (r'\bambigere\b', 'ambago'),
    (r'\bambigerentur\b', 'ambago'),
    (r'\bambigeres\b', 'ambago'),
    (r'\bambigeret\b', 'ambago'),
    (r'\bambigeretur\b', 'ambago'),
    (r'\bambiget\b', 'ambago'),
    (r'\bambigetur\b', 'ambago'),
    (r'\bambigi\b', 'ambago'),
    (r'\bambigis\b', 'ambiga'),
    (r'\bambigis\b', 'ambago'),
    (r'\bambigit\b', 'ambago'),
    (r'\bambigitur\b', 'ambago'),
    (r'\bambigo\b', 'ambago'),
    (r'\bambigua\b', 'ambiguus'),
    (r'\bambigua\b', 'ambiguus'),
    (r'\bambiguae\b', 'ambiguus'),
    (r'\bambiguaeque\b', 'ambiguus'),
    (r'\bambiguam\b', 'ambiguus'),
    (r'\bambiguarum\b', 'ambiguus'),
    (r'\bambiguarumque\b', 'ambiguus'),
    (r'\bambiguas\b', 'ambiguus'),
    (r'\bambigue\b', 'ambiguus'),
    (r'\bambigue\b', 'ambiguus'),
    (r'\bambigui\b', 'ambiguus'),
    (r'\bambigui\b', 'ambiguus'),
    (r'\bambiguis\b', 'ambiguus'),
    (r'\bambiguis\b', 'ambiguus'),
    (r'\bambiguisque\b', 'ambiguus'),
    (r'\bambiguisque\b', 'ambiguus'),
    (r'\bambiguitas\b', 'ambiguitas'),
    (r'\bambiguitate\b', 'ambiguitas'),
    (r'\bambiguitatem\b', 'ambiguitas'),
    (r'\bambiguitates\b', 'ambiguitas'),
    (r'\bambiguitatibus\b', 'ambiguitas'),
    (r'\bambiguitatis\b', 'ambiguitas'),
    (r'\bambigunt\b', 'ambago'),
    (r'\bambiguntur\b', 'ambago'),
    (r'\bambiguo\b', 'ambiguus'),
    (r'\bambiguo\b', 'ambiguus'),
    (r'\bambiguom\b', 'ambiguus'),
    (r'\bambiguom\b', 'ambiguus'),
    (r'\bambiguoque\b', 'ambiguus'),
    (r'\bambiguoque\b', 'ambiguus'),
    (r'\bambiguorum\b', 'ambiguus'),
    (r'\bambiguorum\b', 'ambiguus'),
    (r'\bambiguos\b', 'ambiguus'),
    (r'\bambiguum\b', 'ambiguus'),
    (r'\bambiguum\b', 'ambiguus'),
    (r'\bambiguumque\b', 'ambiguus'),
    (r'\bambiguumque\b', 'ambiguus'),
    (r'\bambiguus\b', 'ambiguus'),
    (r'\bambiit\b', 'ambestrix'),
    (r'\bambire\b', 'ambestrix'),
    (r'\bambirent\b', 'ambestrix'),
    (r'\bambirentque\b', 'ambestrix'),
    (r'\bambirentur\b', 'ambestrix'),
    (r'\bambires\b', 'ambestrix'),
    (r'\bambiret\b', 'ambestrix'),
    (r'\bambiretur\b', 'ambestrix'),
    (r'\bambiri\b', 'ambestrix'),
    (r'\bambis\b', 'ambestrix'),
    (r'\bambisque\b', 'ambestrix'),
    (r'\bambisse\b', 'ambestrix'),
    (r'\bambissent\b', 'ambestrix'),
    (r'\bambisset\b', 'ambestrix'),
    (r'\bambissetque\b', 'ambestrix'),
    (r'\bambit\b', 'ambestrix'),
    (r'\bambitae\b', 'ambestrix'),
    (r'\bambite\b', 'ambestrix'),
    (r'\bambiti\b', 'ambestrix'),
    (r'\bambitio\b', 'ambitio'),
    (r'\bambitione\b', 'ambitio'),
    (r'\bambitionem\b', 'ambitio'),
    (r'\bambitiones\b', 'ambitio'),
    (r'\bambitioni\b', 'ambitio'),
    (r'\bambitionibus\b', 'ambitio'),
    (r'\bambitionis\b', 'ambitio'),
    (r'\bambitionum\b', 'ambitio'),
    (r'\bambitiosa\b', 'ambitiosus'),
    (r'\bambitiosae\b', 'ambitiosus'),
    (r'\bambitiosam\b', 'ambitiosus'),
    (r'\bambitiosas\b', 'ambitiosus'),
    (r'\bambitiose\b', 'ambitiosus'),
    (r'\bambitiosi\b', 'ambitiosus'),
    (r'\bambitiosior\b', 'ambitiosus'),
    (r'\bambitiosique\b', 'ambitiosus'),
    (r'\bambitiosis\b', 'ambitiosus'),
    (r'\bambitiosissime\b', 'ambitiosus'),
    (r'\bambitiosissimum\b', 'ambitiosus'),
    (r'\bambitiosius\b', 'ambitiosus'),
    (r'\bambitioso\b', 'ambitiosus'),
    (r'\bambitiosos\b', 'ambitiosus'),
    (r'\bambitiosum\b', 'ambitiosus'),
    (r'\bambitiosumque\b', 'ambitiosus'),
    (r'\bambitiosus\b', 'ambitiosus'),
    (r'\bambitor\b', 'ambitor'),
    (r'\bambitores\b', 'ambitor'),
    (r'\bambitque\b', 'ambestrix'),
    (r'\bambitu\b', 'ambitus2'),
    (r'\bambitum\b', 'ambitus2'),
    (r'\bambitumque\b', 'ambitus2'),
    (r'\bambituque\b', 'ambitus2'),
    (r'\bambitur\b', 'ambestrix'),
    (r'\bambitus\b', 'ambitus2'),
    (r'\bambiuit\b', 'ambestrix'),
    (r'\bAmbiuius\b', 'Ambivius'),
    (r'\bAmbivaretis\b', 'Ambivareti'),
    (r'\bAmbivaretos\b', 'Ambivareti'),
    (r'\bAmbivaritos\b', 'Ambivariti'),
    (r'\bambiverit\b', 'ambestrix'),
    (r'\bAmbivii\b', 'Ambivius'),
    (r'\bambivii\b', 'ambivium'),
    (r'\bAmbivio\b', 'Ambivius'),
    (r'\bambivio\b', 'ambivium'),
    (r'\bambo\b', 'ambo'),
    (r'\bambon\b', 'ambo'),
    (r'\bamboque\b', 'ambo'),
    (r'\bamborum\b', 'ambo'),
    (r'\bambos\b', 'ambo'),
    (r'\bamboue\b', 'ambo'),
    (r'\bambove\b', 'ambo'),
    (r'\bAmbracia\b', 'Ambracia'),
    (r'\bAmbracia\b', 'Ambracius'),
    (r'\bAmbraciae\b', 'Ambracia'),
    (r'\bAmbraciam\b', 'Ambracia'),
    (r'\bAmbraciamque\b', 'Ambracia'),
    (r'\bAmbracias\b', 'Ambracia'),
    (r'\bAmbracienses\b', 'Ambracius'),
    (r'\bAmbraciensibus\b', 'Ambracius'),
    (r'\bAmbraciensis\b', 'Ambracius'),
    (r'\bAmbraciensium\b', 'Ambracius'),
    (r'\bAmbracii\b', 'Ambracius'),
    (r'\bAmbracio\b', 'Ambracius'),
    (r'\bAmbraciosque\b', 'Ambracius'),
    (r'\bAmbraciotam\b', 'Ambracius'),
    (r'\bAmbracioten\b', 'Ambracius'),
    (r'\bAmbracium\b', 'Ambracius'),
    (r'\bAmbracius\b', 'Ambracius'),
    (r'\bambrosia\b', 'ambrosia1'),
    (r'\bAmbrosia\b', 'Ambrosie'),
    (r'\bambrosia\b', 'ambrosius1'),
    (r'\bambrosiae\b', 'ambrosia1'),
    (r'\bambrosiaeque\b', 'ambrosia1'),
    (r'\bambrosiam\b', 'ambrosia1'),
    (r'\bAmbrosiam\b', 'Ambrosie'),
    (r'\bambrosian\b', 'ambrosia1'),
    (r'\bambrosian\b', 'ambrosius1'),
    (r'\bambrosias\b', 'ambrosia1'),
    (r'\bAmbrosias\b', 'Ambrosie'),
    (r'\bambrosiasque\b', 'ambrosia1'),
    (r'\bAmbrosiasque\b', 'Ambrosie'),
    (r'\bAmbrosie\b', 'Ambrosie'),
    (r'\bAmbrosie\b', 'Ambrosius2'),
    (r'\bambrosie\b', 'ambrosius1'),
    (r'\bambrosiis\b', 'ambrosia1'),
    (r'\bambrosiis\b', 'ambrosius1'),
    (r'\bambrosio\b', 'ambrosius1'),
    (r'\bambrosion\b', 'ambrosius1'),
    (r'\bambrosios\b', 'ambrosius1'),
    (r'\bAmbrosios\b', 'Ambrosius2'),
    (r'\bAmbrosium\b', 'Ambrosius2'),
    (r'\bambrosium\b', 'ambrosius1'),
    (r'\bambrosius\b', 'ambrosius1'),
    (r'\bAmbrosius\b', 'Ambrosius2'),
    (r'\bambrosiusque\b', 'ambrosius1'),
    (r'\bAmbrosiusque\b', 'Ambrosius2'),
    (r'\bAmbrysus\b', 'Ambrysus'),
    (r'\bambubaia\b', 'ambubaia'),
    (r'\bambubaiae\b', 'ambubaia'),
    (r'\bambubaiarum\b', 'ambubaia'),
    (r'\bambubaias\b', 'ambubaia'),
    (r'\bambubeia\b', 'ambubeia'),
    (r'\bambula\b', 'ambulo'),
    (r'\bambulabam\b', 'ambulo'),
    (r'\bambulabamus\b', 'ambulo'),
    (r'\bambulabant\b', 'ambulo'),
    (r'\bambulabas\b', 'ambulo'),
    (r'\bambulabat\b', 'ambulo'),
    (r'\bambulabimus\b', 'ambulo'),
    (r'\bambulabis\b', 'ambulo'),
    (r'\bambulabit\b', 'ambulo'),
    (r'\bambulabitis\b', 'ambulo'),
    (r'\bambulabo\b', 'ambulo'),
    (r'\bambulabunt\b', 'ambulo'),
    (r'\bambulacris\b', 'ambulacrum'),
    (r'\bambulacro\b', 'ambulacrum'),
    (r'\bambulacrum\b', 'ambulacrum'),
    (r'\bambulamus\b', 'ambulo'),
    (r'\bambulandi\b', 'ambulo'),
    (r'\bambulando\b', 'ambulo'),
    (r'\bambulandum\b', 'ambulo'),
    (r'\bambulans\b', 'ambulo'),
    (r'\bambulant\b', 'ambulo'),
    (r'\bambulante\b', 'ambulo'),
    (r'\bambulantem\b', 'ambulo'),
    (r'\bambulantes\b', 'ambulo'),
    (r'\bambulanti\b', 'ambulo'),
    (r'\bambulantibus\b', 'ambulo'),
    (r'\bambulantis\b', 'ambulo'),
    (r'\bambulantisque\b', 'ambulo'),
    (r'\bambulare\b', 'ambulo'),
    (r'\bambularem\b', 'ambulo'),
    (r'\bambularemus\b', 'ambulo'),
    (r'\bambularent\b', 'ambulo'),
    (r'\bambulares\b', 'ambulo'),
    (r'\bambularet\b', 'ambulo'),
    (r'\bambularetis\b', 'ambulo'),
    (r'\bambulari\b', 'ambulo'),
    (r'\bambulas\b', 'ambulo'),
    (r'\bambulasse\b', 'ambulo'),
    (r'\bambulassem\b', 'ambulo'),
    (r'\bambulasses\b', 'ambulo'),
    (r'\bambulasset\b', 'ambulo'),
    (r'\bambulasti\b', 'ambulo'),
    (r'\bambulastis\b', 'ambulo'),
    (r'\bambulat\b', 'ambulo'),
    (r'\bambulate\b', 'ambulo'),
    (r'\bambulatilibus\b', 'ambulatilis'),
    (r'\bambulatio\b', 'ambulatio'),
    (r'\bambulatione\b', 'ambulatio'),
    (r'\bambulationem\b', 'ambulatio'),
    (r'\bambulationes\b', 'ambulatio'),
    (r'\bambulationesque\b', 'ambulatio'),
    (r'\bambulationi\b', 'ambulatio'),
    (r'\bambulationibus\b', 'ambulatio'),
    (r'\bambulationis\b', 'ambulatio'),
    (r'\bambulationum\b', 'ambulatio'),
    (r'\bambulatis\b', 'ambulo'),
    (r'\bambulatiuncula\b', 'ambulatiuncula'),
    (r'\bambulato\b', 'ambulo'),
    (r'\bambulator\b', 'ambulator'),
    (r'\bambulatori\b', 'ambulator'),
    (r'\bambulatori\b', 'ambulatorius'),
    (r'\bambulatoria\b', 'ambulatorius'),
    (r'\bambulatoriae\b', 'ambulatorius'),
    (r'\bambulatoriam\b', 'ambulatorius'),
    (r'\bambulatorias\b', 'ambulatorius'),
    (r'\bambulatorium\b', 'ambulatorius'),
    (r'\bambulatrix\b', 'ambulatrix'),
    (r'\bambulatum\b', 'ambulatus'),
    (r'\bambulatum\b', 'ambulo'),
    (r'\bambulatumst\b', 'ambulatus'),
    (r'\bambulatumst\b', 'ambulo'),
    (r'\bambulatur\b', 'ambulo'),
    (r'\bambulaturi\b', 'ambulo'),
    (r'\bambulaturus\b', 'ambulo'),
    (r'\bambulatus\b', 'ambulatus'),
    (r'\bambulatus\b', 'ambulo'),
    (r'\bambulatve\b', 'ambulo'),
    (r'\bambulauerit\b', 'ambulo'),
    (r'\bambulauerunt\b', 'ambulo'),
    (r'\bambulaui\b', 'ambulo'),
    (r'\bambulauit\b', 'ambulo'),
    (r'\bambulaverat\b', 'ambulo'),
    (r'\bambulaverim\b', 'ambulo'),
    (r'\bambulaverint\b', 'ambulo'),
    (r'\bambulaveris\b', 'ambulo'),
    (r'\bambulaverit\b', 'ambulo'),
    (r'\bambulaveritis\b', 'ambulo'),
    (r'\bambulavero\b', 'ambulo'),
    (r'\bambulaverunt\b', 'ambulo'),
    (r'\bambulaveruntque\b', 'ambulo'),
    (r'\bambulavi\b', 'ambulo'),
    (r'\bambulavimus\b', 'ambulo'),
    (r'\bambulavisset\b', 'ambulo'),
    (r'\bambulavit\b', 'ambulo'),
    (r'\bambulavitque\b', 'ambulo'),
    (r'\bambulem\b', 'ambulo'),
    (r'\bambulemus\b', 'ambulo'),
    (r'\bambulent\b', 'ambulo'),
    (r'\bambulentur\b', 'ambulo'),
    (r'\bambules\b', 'ambulo'),
    (r'\bambulet\b', 'ambulo'),
    (r'\bambuletis\b', 'ambulo'),
    (r'\bambuletur\b', 'ambulo'),
    (r'\bambulo\b', 'ambulo'),
    (r'\bamburat\b', 'amburo'),
    (r'\bamburbale\b', 'amburbale'),
    (r'\bamburbium\b', 'amburbium'),
    (r'\bamburebat\b', 'amburo'),
    (r'\bamburens\b', 'amburo'),
    (r'\bamburenti\b', 'amburo'),
    (r'\bamburerentur\b', 'amburo'),
    (r'\bambureret\b', 'amburo'),
    (r'\bambureretur\b', 'amburo'),
    (r'\bambures\b', 'amburo'),
    (r'\bamburet\b', 'amburo'),
    (r'\bamburi\b', 'amburo'),
    (r'\bamburit\b', 'amburo'),
    (r'\bamburitur\b', 'amburo'),
    (r'\bambusta\b', 'ambustum'),
    (r'\bambusta\b', 'amburo'),
    (r'\bambustae\b', 'amburo'),
    (r'\bambustaeue\b', 'amburo'),
    (r'\bambustam\b', 'amburo'),
    (r'\bambustaque\b', 'ambustum'),
    (r'\bambustaque\b', 'amburo'),
    (r'\bambustas\b', 'amburo'),
    (r'\bambustasque\b', 'amburo'),
    (r'\bambusti\b', 'ambustum'),
    (r'\bambusti\b', 'amburo'),
    (r'\bambustique\b', 'ambustum'),
    (r'\bambustique\b', 'amburo'),
    (r'\bambustis\b', 'ambustum'),
    (r'\bambustis\b', 'amburo'),
    (r'\bambustisve\b', 'ambustum'),
    (r'\bambustisve\b', 'amburo'),
    (r'\bambusto\b', 'ambustum'),
    (r'\bambusto\b', 'amburo'),
    (r'\bambustoque\b', 'ambustum'),
    (r'\bambustoque\b', 'amburo'),
    (r'\bambustulatum\b', 'ambustulatus'),
    (r'\bambustum\b', 'ambustum'),
    (r'\bambustum\b', 'amburo'),
    (r'\bambustumque\b', 'ambustum'),
    (r'\bambustumque\b', 'amburo'),
    (r'\bambustus\b', 'amburo'),
    (r'\bamella\b', 'amellus'),
    (r'\bamelli\b', 'amellus'),
    (r'\bamello\b', 'amellus'),
    (r'\bamem\b', 'amo'),
    (r'\bamemur\b', 'amo'),
    (r'\bamemus\b', 'amo'),
    (r'\bamen\b', 'amen'),
    (r'\bAmenanaque\b', 'Amenanus'),
    (r'\bAmenanus\b', 'Amenanus'),
    (r'\bamens\b', 'amens'),
    (r'\bamensque\b', 'amens'),
    (r'\bament\b', 'amo'),
    (r'\bamenta\b', 'amentum'),
    (r'\bamenta\b', 'amento'),
    (r'\bamentaque\b', 'amentum'),
    (r'\bamentaque\b', 'amento'),
    (r'\bamentatae\b', 'amento'),
    (r'\bamentatas\b', 'amento'),
    (r'\bamentem\b', 'amens'),
    (r'\bamentem\b', 'amento'),
    (r'\bamentes\b', 'amens'),
    (r'\bamentes\b', 'amento'),
    (r'\bamenti\b', 'amens'),
    (r'\bamenti\b', 'amentum'),
    (r'\bamentia\b', 'amentia'),
    (r'\bamentia\b', 'amens'),
    (r'\bamentiae\b', 'amentia'),
    (r'\bamentiam\b', 'amentia'),
    (r'\bamentiamque\b', 'amentia'),
    (r'\bamentiaque\b', 'amentia'),
    (r'\bamentiaque\b', 'amens'),
    (r'\bamentiast\b', 'amentia'),
    (r'\bamentiast\b', 'amens'),
    (r'\bamentibus\b', 'amens'),
    (r'\bamentiorem\b', 'amens'),
    (r'\bamentiores\b', 'amens'),
    (r'\bamentique\b', 'amens'),
    (r'\bamentique\b', 'amentum'),
    (r'\bamentis\b', 'amens'),
    (r'\bamentis\b', 'amentum'),
    (r'\bamentissime\b', 'amens'),
    (r'\bamentissimi\b', 'amens'),
    (r'\bamentissimo\b', 'amens'),
    (r'\bamentissimum\b', 'amens'),
    (r'\bamentissimus\b', 'amens'),
    (r'\bamentium\b', 'amens'),
    (r'\bamentius\b', 'amens'),
    (r'\bamento\b', 'amentum'),
    (r'\bamento\b', 'amento'),
    (r'\bamentque\b', 'amo'),
    (r'\bamentum\b', 'amentum'),
    (r'\bamentur\b', 'amo'),
    (r'\bamenturve\b', 'amo'),
    (r'\bamere\b', 'amo'),
    (r'\bAmeria\b', 'Ameria'),
    (r'\bAmeriae\b', 'Ameria'),
    (r'\bAmeriam\b', 'Ameria'),
    (r'\bamerimnon\b', 'amerimnon'),
    (r'\bAmerina\b', 'ames'),
    (r'\bAmerina\b', 'ames'),
    (r'\bAmerinae\b', 'ames'),
    (r'\bAmerinam\b', 'ames'),
    (r'\bAmerini\b', 'ames'),
    (r'\bAmerini\b', 'ames'),
    (r'\bAmerinis\b', 'ames'),
    (r'\bAmerinis\b', 'ames'),
    (r'\bAmerinis\b', 'ames'),
    (r'\bAmerino\b', 'ames'),
    (r'\bAmerinorum\b', 'ames'),
    (r'\bAmerinorum\b', 'ames'),
    (r'\bAmerinum\b', 'ames'),
    (r'\bAmerinum\b', 'ames'),
    (r'\bAmerinum\b', 'ames'),
    (r'\bAmerinus\b', 'ames'),
    (r'\bameris\b', 'amo'),
    (r'\bames\b', 'ames'),
    (r'\bames\b', 'amo'),
    (r'\bamessai\b', 'ametor'),
    (r'\bAmestrati\b', 'Amestratus'),
    (r'\bAmestratini\b', 'Amestratus'),
    (r'\bAmestratini\b', 'Amestratus'),
    (r'\bAmestratinos\b', 'Amestratus'),
    (r'\bAmestratinum\b', 'Amestratus'),
    (r'\bAmestratinum\b', 'Amestratus'),
    (r'\bamet\b', 'amo'),
    (r'\bamethysti\b', 'amethystus'),
    (r'\bamethystina\b', 'amethystinus'),
    (r'\bamethystinae\b', 'amethystinus'),
    (r'\bamethystinasque\b', 'amethystinus'),
    (r'\bamethystini\b', 'amethystinus'),
    (r'\bamethystinos\b', 'amethystinus'),
    (r'\bamethystis\b', 'amethystus'),
    (r'\bamethysto\b', 'amethystus'),
    (r'\bamethystos\b', 'amethystus'),
    (r'\bamethystum\b', 'amethystus'),
    (r'\bametis\b', 'ametor'),
    (r'\bametis\b', 'amo'),
    (r'\bametque\b', 'amo'),
    (r'\bametur\b', 'amo'),
    (r'\bamfractibus\b', 'anfractus2'),
    (r'\bamfractus\b', 'anfractus2'),
    (r'\bamiae\b', 'amia'),
    (r'\bamiae\b', 'amica'),
    (r'\bamiam\b', 'amia'),
    (r'\bamiam\b', 'amica'),
    (r'\bamian\b', 'amica'),
    (r'\bAmiano\b', 'amica'),
    (r'\bamiantus\b', 'amiantus'),
    (r'\bamica\b', 'amica'),
    (r'\bamica\b', 'amicus1'),
    (r'\bamica\b', 'amico'),
    (r'\bamicae\b', 'amica'),
    (r'\bamicalem\b', 'amicalis'),
    (r'\bamicalibus\b', 'amicalis'),
    (r'\bamicalis\b', 'amicalis'),
    (r'\bamicam\b', 'amica'),
    (r'\bamicamque\b', 'amica'),
    (r'\bamicamue\b', 'amica'),
    (r'\bamicaque\b', 'amica'),
    (r'\bamicaque\b', 'amicus1'),
    (r'\bamicaque\b', 'amico'),
    (r'\bamicarum\b', 'amica'),
    (r'\bamicas\b', 'amica'),
    (r'\bamicas\b', 'amico'),
    (r'\bamicast\b', 'amica'),
    (r'\bamicast\b', 'amicus1'),
    (r'\bamicast\b', 'amico'),
    (r'\bamicat\b', 'amico'),
    (r'\bamice\b', 'amicus1'),
    (r'\bamice\b', 'amicus1'),
    (r'\bamice\b', 'amice'),
    (r'\bamici\b', 'amicus1'),
    (r'\bamici\b', 'amicus1'),
    (r'\bamicimine\b', 'amicimen'),
    (r'\bamicior\b', 'amicus1'),
    (r'\bamiciora\b', 'amicus1'),
    (r'\bamiciorem\b', 'amicus1'),
    (r'\bamiciores\b', 'amicus1'),
    (r'\bamicioresque\b', 'amicus1'),
    (r'\bamiciori\b', 'amicus1'),
    (r'\bamicioribus\b', 'amicus1'),
    (r'\bamiciorum\b', 'amicus1'),
    (r'\bamicique\b', 'amicus1'),
    (r'\bamicique\b', 'amicus1'),
    (r'\bamicis\b', 'amica'),
    (r'\bamicis\b', 'amicus1'),
    (r'\bamicis\b', 'amicus1'),
    (r'\bamicisque\b', 'amica'),
    (r'\bamicisque\b', 'amicus1'),
    (r'\bamicisque\b', 'amicus1'),
    (r'\bamicissima\b', 'amicus1'),
    (r'\bamicissimam\b', 'amicus1'),
    (r'\bamicissimas\b', 'amicus1'),
    (r'\bamicissime\b', 'amicus1'),
    (r'\bamicissimeque\b', 'amicus1'),
    (r'\bamicissimi\b', 'amicus1'),
    (r'\bamicissimis\b', 'amicus1'),
    (r'\bamicissimo\b', 'amicus1'),
    (r'\bamicissimoque\b', 'amicus1'),
    (r'\bamicissimorum\b', 'amicus1'),
    (r'\bamicissimorumque\b', 'amicus1'),
    (r'\bamicissimos\b', 'amicus1'),
    (r'\bamicissimum\b', 'amicus1'),
    (r'\bamicissimumque\b', 'amicus1'),
    (r'\bamicissimus\b', 'amicus1'),
    (r'\bamicissimusque\b', 'amicus1'),
    (r'\bamicissume\b', 'amicus1'),
    (r'\bamicissumi\b', 'amicus1'),
    (r'\bamicissumos\b', 'amicus1'),
    (r'\bamicitia\b', 'amicitia'),
    (r'\bamicitiae\b', 'amicitia'),
    (r'\bamicitiaeque\b', 'amicitia'),
    (r'\bamicitiaeue\b', 'amicitia'),
    (r'\bamicitiai\b', 'amicitia'),
    (r'\bamicitiam\b', 'amicitia'),
    (r'\bamicitiamque\b', 'amicitia'),
    (r'\bamicitiaque\b', 'amicitia'),
    (r'\bamicitiarum\b', 'amicitia'),
    (r'\bamicitias\b', 'amicitia'),
    (r'\bamicitiasque\b', 'amicitia'),
    (r'\bamicitiast\b', 'amicitia'),
    (r'\bamicitiis\b', 'amicitia'),
    (r'\bamicius\b', 'amicus1'),
    (r'\bamico\b', 'amicus1'),
    (r'\bamico\b', 'amicus1'),
    (r'\bamico\b', 'amico'),
    (r'\bamicoque\b', 'amicus1'),
    (r'\bamicoque\b', 'amicus1'),
    (r'\bamicoque\b', 'amico'),
    (r'\bamicorum\b', 'amicus1'),
    (r'\bamicorum\b', 'amicus1'),
    (r'\bamicorumque\b', 'amicus1'),
    (r'\bamicorumque\b', 'amicus1'),
    (r'\bamicorumve\b', 'amicus1'),
    (r'\bamicorumve\b', 'amicus1'),
    (r'\bamicos\b', 'amicus1'),
    (r'\bamicosne\b', 'amicus1'),
    (r'\bamicosque\b', 'amicus1'),
    (r'\bamicost\b', 'amicus1'),
    (r'\bamicost\b', 'amicus1'),
    (r'\bamicost\b', 'amico'),
    (r'\bamicta\b', 'a-mino'),
    (r'\bamictae\b', 'a-mino'),
    (r'\bamictam\b', 'a-mino'),
    (r'\bamicti\b', 'a-mino'),
    (r'\bamictibus\b', 'amictus2'),
    (r'\bamictorium\b', 'amictorius'),
    (r'\bamictorium\b', 'amictorius'),
    (r'\bamictos\b', 'a-mino'),
    (r'\bamictu\b', 'amictus2'),
    (r'\bamictui\b', 'amictus2'),
    (r'\bamictum\b', 'amictus2'),
    (r'\bamictuque\b', 'amictus2'),
    (r'\bamictus\b', 'amictus2'),
    (r'\bamictusque\b', 'amictus2'),
    (r'\bamicuit\b', 'amico'),
    (r'\bamicula\b', 'amicula'),
    (r'\bamicula\b', 'amiculum'),
    (r'\bamiculae\b', 'amicula'),
    (r'\bamiculam\b', 'amicula'),
    (r'\bamiculi\b', 'amiculus'),
    (r'\bamiculi\b', 'amiculum'),
    (r'\bamiculis\b', 'amicula'),
    (r'\bamiculis\b', 'amiculus'),
    (r'\bamiculis\b', 'amiculum'),
    (r'\bamiculo\b', 'amiculus'),
    (r'\bamiculo\b', 'amiculum'),
    (r'\bamiculum\b', 'amiculus'),
    (r'\bamiculum\b', 'amiculum'),
    (r'\bamiculus\b', 'amiculus'),
    (r'\bamicum\b', 'amicus1'),
    (r'\bamicum\b', 'amicus1'),
    (r'\bamicumque\b', 'amicus1'),
    (r'\bamicumque\b', 'amicus1'),
    (r'\bamicus\b', 'amicus1'),
    (r'\bamicusque\b', 'amicus1'),
    (r'\bamicust\b', 'amicus1'),
    (r'\bamigrant\b', 'a-migro'),
    (r'\bamina\b', 'a-mino'),
    (r'\bAminaei\b', 'Aminaeus'),
    (r'\bAminaeo\b', 'Aminaeus'),
    (r'\bAminaeum\b', 'Aminaeus'),
    (r'\baminio\b', 'a-mino'),
    (r'\bAmisenorum\b', 'a-mino'),
    (r'\bAmisenos\b', 'a-mino'),
    (r'\bamiseram\b', 'amitto'),
    (r'\bamiserant\b', 'amitto'),
    (r'\bamiseras\b', 'amitto'),
    (r'\bamiserat\b', 'amitto'),
    (r'\bamisere\b', 'amitto'),
    (r'\bamiserim\b', 'amitto'),
    (r'\bamiserimus\b', 'amitto'),
    (r'\bamiserint\b', 'amitto'),
    (r'\bamiseris\b', 'amitto'),
    (r'\bamiserit\b', 'amitto'),
    (r'\bamisero\b', 'amitto'),
    (r'\bamiserunt\b', 'amitto'),
    (r'\bAmisi\b', 'Amisus'),
    (r'\bAmisi\b', 'Amisus'),
    (r'\bamisi\b', 'amitto'),
    (r'\bamisimus\b', 'amitto'),
    (r'\bAmisis\b', 'Amisus'),
    (r'\bAmisis\b', 'Amisus'),
    (r'\bamisisse\b', 'amitto'),
    (r'\bamisissem\b', 'amitto'),
    (r'\bamisissemus\b', 'amitto'),
    (r'\bamisissent\b', 'amitto'),
    (r'\bamisisses\b', 'amitto'),
    (r'\bamisisset\b', 'amitto'),
    (r'\bamisissetis\b', 'amitto'),
    (r'\bamisisti\b', 'amitto'),
    (r'\bamisistis\b', 'amitto'),
    (r'\bamisit\b', 'amitto'),
    (r'\bamisitque\b', 'amitto'),
    (r'\bAmiso\b', 'Amisus'),
    (r'\bAmiso\b', 'Amisus'),
    (r'\bAmison\b', 'Amisus'),
    (r'\bAmison\b', 'Amisus'),
    (r'\bAmisos\b', 'Amisus'),
    (r'\bamissa\b', 'amitto'),
    (r'\bamissae\b', 'amitto'),
    (r'\bamissaeque\b', 'amitto'),
    (r'\bamissam\b', 'amitto'),
    (r'\bamissamque\b', 'amitto'),
    (r'\bamissaque\b', 'amitto'),
    (r'\bamissarum\b', 'amitto'),
    (r'\bamissas\b', 'amitto'),
    (r'\bamissasque\b', 'amitto'),
    (r'\bamissi\b', 'amitto'),
    (r'\bamissio\b', 'amissio'),
    (r'\bamissione\b', 'amissio'),
    (r'\bamissionem\b', 'amissio'),
    (r'\bamissiones\b', 'amissio'),
    (r'\bamissionis\b', 'amissio'),
    (r'\bamissis\b', 'amitto'),
    (r'\bamissisque\b', 'amitto'),
    (r'\bamisso\b', 'amitto'),
    (r'\bamissoque\b', 'amitto'),
    (r'\bamissorum\b', 'amitto'),
    (r'\bamissos\b', 'amitto'),
    (r'\bamissum\b', 'amissus2'),
    (r'\bamissum\b', 'amitto'),
    (r'\bamissumque\b', 'amissus2'),
    (r'\bamissumque\b', 'amitto'),
    (r'\bamissumve\b', 'amissus2'),
    (r'\bamissumve\b', 'amitto'),
    (r'\bamissuram\b', 'amitto'),
    (r'\bamissuri\b', 'amitto'),
    (r'\bamissuros\b', 'amitto'),
    (r'\bamissurum\b', 'amitto'),
    (r'\bamissurus\b', 'amitto'),
    (r'\bamissus\b', 'amissus2'),
    (r'\bamissus\b', 'amitto'),
    (r'\bAmisum\b', 'Amisus'),
    (r'\bAmisum\b', 'Amisus'),
    (r'\bAmisumque\b', 'Amisus'),
    (r'\bAmisumque\b', 'Amisus'),
    (r'\bamita\b', 'amita'),
    (r'\bamitae\b', 'amita'),
    (r'\bamitam\b', 'amita'),
    (r'\bamitas\b', 'amita'),
    (r'\bamitasque\b', 'amita'),
    (r'\bamite\b', 'ames'),
    (r'\bAmiterna\b', 'Amiternum'),
    (r'\bAmiterni\b', 'Amiternum'),
    (r'\bAmiternina\b', 'Amiternum'),
    (r'\bAmiterninae\b', 'Amiternum'),
    (r'\bAmiternini\b', 'Amiternum'),
    (r'\bAmiternini\b', 'Amiternum'),
    (r'\bAmiterninis\b', 'Amiternum'),
    (r'\bAmiterninis\b', 'Amiternum'),
    (r'\bAmiternino\b', 'Amiternum'),
    (r'\bAmiterninus\b', 'Amiternum'),
    (r'\bAmiterno\b', 'Amiternum'),
    (r'\bAmiternum\b', 'Amiternum'),
    (r'\bamites\b', 'ames'),
    (r'\bamitinae\b', 'amitinus'),
    (r'\bamitinae\b', 'amitini'),
    (r'\bamitinas\b', 'amitini'),
    (r'\bamitini\b', 'amitini'),
    (r'\bamitini\b', 'amitinus'),
    (r'\bamitinis\b', 'amitini'),
    (r'\bamitinis\b', 'amitini'),
    (r'\bamitinis\b', 'amitinus'),
    (r'\bamitino\b', 'amitinus'),
    (r'\bamitinos\b', 'amitini'),
    (r'\bamitinum\b', 'amitini'),
    (r'\bamitinum\b', 'amitinus'),
    (r'\bAmitinum\b', 'amitini'),
    (r'\bamitis\b', 'amita'),
    (r'\bamitis\b', 'ames'),
    (r'\bamittam\b', 'amitto'),
    (r'\bamittamus\b', 'amitto'),
    (r'\bamittant\b', 'amitto'),
    (r'\bamittantur\b', 'amitto'),
    (r'\bamittas\b', 'amitto'),
    (r'\bamittat\b', 'amitto'),
    (r'\bamittatis\b', 'amitto'),
    (r'\bamittatur\b', 'amitto'),
    (r'\bamittaturve\b', 'amitto'),
    (r'\bamitte\b', 'amitto'),
    (r'\bamittebant\b', 'amitto'),
    (r'\bamittebat\b', 'amitto'),
    (r'\bamittemus\b', 'amitto'),
    (r'\bamittenda\b', 'amitto'),
    (r'\bamittendae\b', 'amitto'),
    (r'\bamittendam\b', 'amitto'),
    (r'\bamittendi\b', 'amitto'),
    (r'\bamittendo\b', 'amitto'),
    (r'\bamittendorum\b', 'amitto'),
    (r'\bamittendum\b', 'amitto'),
    (r'\bamittens\b', 'amitto'),
    (r'\bamittente\b', 'amitto'),
    (r'\bamittentes\b', 'amitto'),
    (r'\bamittenti\b', 'amitto'),
    (r'\bamittere\b', 'amitto'),
    (r'\bamitterem\b', 'amitto'),
    (r'\bamitteremus\b', 'amitto'),
    (r'\bamitterent\b', 'amitto'),
    (r'\bamitteres\b', 'amitto'),
    (r'\bamitteret\b', 'amitto'),
    (r'\bamitteretis\b', 'amitto'),
    (r'\bamitteretur\b', 'amitto'),
    (r'\bamittes\b', 'amitto'),
    (r'\bamittet\b', 'amitto'),
    (r'\bamittetis\b', 'amitto'),
    (r'\bamittetur\b', 'amitto'),
    (r'\bamitti\b', 'amitto'),
    (r'\bamittimus\b', 'amitto'),
    (r'\bamittis\b', 'amitto'),
    (r'\bamittit\b', 'amitto'),
    (r'\bamittitque\b', 'amitto'),
    (r'\bamittitur\b', 'amitto'),
    (r'\bamitto\b', 'amitto'),
    (r'\bamittunt\b', 'amitto'),
    (r'\bamittunto\b', 'amitto'),
    (r'\bamittuntur\b', 'amitto'),
    (r'\bammochryso\b', 'ammochrysus'),
    (r'\bammochrysos\b', 'ammochrysus'),
    (r'\bAmmon\b', 'Ammon'),
    (r'\bAmmone\b', 'Ammon'),
    (r'\bAmmonem\b', 'Ammon'),
    (r'\bAmmoni\b', 'Ammon'),
    (r'\bAmmoni\b', 'Ammonius'),
    (r'\bAmmoniaci\b', 'Ammoniacus'),
    (r'\bAmmoniaci\b', 'Ammoniacus'),
    (r'\bAmmoniaco\b', 'Ammoniacus'),
    (r'\bAmmoniaco\b', 'Ammoniacus'),
    (r'\bAmmoniacus\b', 'Ammoniacus'),
    (r'\bAmmonis\b', 'Ammon'),
    (r'\bAmmonius\b', 'Ammonius'),
    (r'\bamne\b', 'amnis'),
    (r'\bamnem\b', 'amnis'),
    (r'\bamnemque\b', 'amnis'),
    (r'\bamnes\b', 'amnis'),
    (r'\bamnesque\b', 'amnis'),
    (r'\bamnestia\b', 'amnestia'),
    (r'\bamnestian\b', 'amnestia'),
    (r'\bamni\b', 'amnis'),
    (r'\bamnibus\b', 'amnis'),
    (r'\bamnibusque\b', 'amnis'),
    (r'\bamnica\b', 'amnicus'),
    (r'\bamnicarum\b', 'amnicus'),
    (r'\bamnicis\b', 'amnicus'),
    (r'\bamnicolaeque\b', 'amnicola'),
    (r'\bamnicos\b', 'amnicus'),
    (r'\bamniculo\b', 'amniculus'),
    (r'\bamnigenam\b', 'amnigena'),
    (r'\bamnis\b', 'amnis'),
    (r'\bamnisque\b', 'amnis'),
    (r'\bamnium\b', 'amnis'),
    (r'\bamniumque\b', 'amnis'),
    (r'\bamo\b', 'amo'),
    (r'\bamodo\b', 'amodo'),
    (r'\bamoebaei\b', 'amoebaeus'),
    (r'\bamoebaeo\b', 'amoebaeus'),
    (r'\bamoebaeum\b', 'amoebaeus'),
    (r'\bAmoebea\b', 'Amoebeus'),
    (r'\bamoena\b', 'amoenus'),
    (r'\bamoena\b', 'amoena'),
    (r'\bamoena\b', 'amoeno'),
    (r'\bamoenae\b', 'amoenus'),
    (r'\bamoenam\b', 'amoenus'),
    (r'\bamoenas\b', 'amoenus'),
    (r'\bamoenas\b', 'amoeno'),
    (r'\bamoene\b', 'amoenus'),
    (r'\bamoeni\b', 'amoenus'),
    (r'\bamoenior\b', 'amoenus'),
    (r'\bamoeniore\b', 'amoenus'),
    (r'\bamoeniorem\b', 'amoenus'),
    (r'\bamoeniores\b', 'amoenus'),
    (r'\bamoenioribus\b', 'amoenus'),
    (r'\bamoenique\b', 'amoenus'),
    (r'\bamoenis\b', 'amoenus'),
    (r'\bamoenis\b', 'amoena'),
    (r'\bamoenissima\b', 'amoenus'),
    (r'\bamoenissimam\b', 'amoenus'),
    (r'\bamoenissimas\b', 'amoenus'),
    (r'\bamoenissime\b', 'amoenus'),
    (r'\bamoenissimis\b', 'amoenus'),
    (r'\bamoenissimos\b', 'amoenus'),
    (r'\bamoenissimum\b', 'amoenus'),
    (r'\bamoenissimus\b', 'amoenus'),
    (r'\bamoenissumi\b', 'amoenus'),
    (r'\bamoenitas\b', 'amoenitas'),
    (r'\bamoenitate\b', 'amoenitas'),
    (r'\bamoenitatem\b', 'amoenitas'),
    (r'\bamoenitatemque\b', 'amoenitas'),
    (r'\bamoenitates\b', 'amoenitas'),
    (r'\bamoenitati\b', 'amoenitas'),
    (r'\bamoenitatibus\b', 'amoenitas'),
    (r'\bamoenitatis\b', 'amoenitas'),
    (r'\bamoenitatum\b', 'amoenitas'),
    (r'\bamoeniue\b', 'amoenus'),
    (r'\bamoenius\b', 'amoenus'),
    (r'\bamoeniusque\b', 'amoenus'),
    (r'\bamoeno\b', 'amoenus'),
    (r'\bamoeno\b', 'amoeno'),
    (r'\bamoenoque\b', 'amoenus'),
    (r'\bamoenoque\b', 'amoeno'),
    (r'\bamoenos\b', 'amoenus'),
    (r'\bamoenosque\b', 'amoenus'),
    (r'\bamoenum\b', 'amoenus'),
    (r'\bamoenum\b', 'amoena'),
    (r'\bamoenus\b', 'amoenus'),
    (r'\bamoliamur\b', 'amolior'),
    (r'\bamoliantur\b', 'amolior'),
    (r'\bamoliebar\b', 'amolior'),
    (r'\bamolienda\b', 'amolior'),
    (r'\bamoliendis\b', 'amolior'),
    (r'\bamoliendo\b', 'amolior'),
    (r'\bamoliendum\b', 'amolior'),
    (r'\bamolientis\b', 'amolior'),
    (r'\bamolimini\b', 'amolior'),
    (r'\bamolior\b', 'amolior'),
    (r'\bamolire\b', 'amolior'),
    (r'\bamolirentur\b', 'amolior'),
    (r'\bamoliretur\b', 'amolior'),
    (r'\bamoliri\b', 'amolior'),
    (r'\bamolirier\b', 'amolior'),
    (r'\bamolita\b', 'amolior'),
    (r'\bamoliti\b', 'amolior'),
    (r'\bamolitiost\b', 'amolitio'),
    (r'\bamolitis\b', 'amolior'),
    (r'\bamolitur\b', 'amolior'),
    (r'\bamolitus\b', 'amolior'),
    (r'\bamoliuntur\b', 'amolior'),
    (r'\bamoma\b', 'amomum'),
    (r'\bamomi\b', 'amomum'),
    (r'\bamomis\b', 'amomis'),
    (r'\bamomis\b', 'amomum'),
    (r'\bamomo\b', 'amomum'),
    (r'\bamomon\b', 'amomum'),
    (r'\bamomum\b', 'amomum'),
    (r'\bamon\b', 'amo'),
    (r'\bamoque\b', 'amo'),
    (r'\bamor\b', 'amor'),
    (r'\bamor\b', 'amo'),
    (r'\bamorabunda\b', 'amorabundus'),
    (r'\bamorabundam\b', 'amorabundus'),
    (r'\bamore\b', 'amor'),
    (r'\bamorem\b', 'amor'),
    (r'\bamoremne\b', 'amor'),
    (r'\bamoremque\b', 'amor'),
    (r'\bamores\b', 'amor'),
    (r'\bamoresque\b', 'amor'),
    (r'\bamorest\b', 'amor'),
    (r'\bAmorgi\b', 'Amorgus'),
    (r'\bAmorgos\b', 'Amorgus'),
    (r'\bAmorgum\b', 'Amorgus'),
    (r'\bamori\b', 'amor'),
    (r'\bamoribus\b', 'amor'),
    (r'\bamoribusque\b', 'amor'),
    (r'\bamorin\b', 'amor'),
    (r'\bamorique\b', 'amor'),
    (r'\bamoris\b', 'amor'),
    (r'\bamorisque\b', 'amor'),
    (r'\bamorne\b', 'amor'),
    (r'\bamorne\b', 'amo'),
    (r'\bamorque\b', 'amor'),
    (r'\bamorque\b', 'amo'),
    (r'\bamorum\b', 'amor'),
    (r'\bamota\b', 'amoveo'),
    (r'\bamotae\b', 'amoveo'),
    (r'\bamotam\b', 'amoveo'),
    (r'\bamotarum\b', 'amoveo'),
    (r'\bamotas\b', 'amoveo'),
    (r'\bamoti\b', 'amoveo'),
    (r'\bamotio\b', 'amotio'),
    (r'\bamotionem\b', 'amotio'),
    (r'\bamotis\b', 'amoveo'),
    (r'\bamoto\b', 'amoveo'),
    (r'\bamotoque\b', 'amoveo'),
    (r'\bamotos\b', 'amoveo'),
    (r'\bamotum\b', 'amoveo'),
    (r'\bamotumque\b', 'amoveo'),
    (r'\bamotus\b', 'amoveo'),
    (r'\bamotusque\b', 'amoveo'),
    (r'\bamoue\b', 'amo'),
    (r'\bamoueantur\b', 'amoveo'),
    (r'\bamoueas\b', 'amoveo'),
    (r'\bamoueat\b', 'amoveo'),
    (r'\bamouenda\b', 'amoveo'),
    (r'\bamouendae\b', 'amoveo'),
    (r'\bamouendi\b', 'amoveo'),
    (r'\bamouendo\b', 'amoveo'),
    (r'\bamouendum\b', 'amoveo'),
    (r'\bamouendus\b', 'amoveo'),
    (r'\bamouens\b', 'amoveo'),
    (r'\bamouentem\b', 'amoveo'),
    (r'\bamouentis\b', 'amoveo'),
    (r'\bamouento\b', 'amoveo'),
    (r'\bamouentur\b', 'amoveo'),
    (r'\bamoueo\b', 'amoveo'),
    (r'\bamouerat\b', 'amoveo'),
    (r'\bamouere\b', 'amoveo'),
    (r'\bamoueret\b', 'amoveo'),
    (r'\bamoueretur\b', 'amoveo'),
    (r'\bamoueri\b', 'amoveo'),
    (r'\bamouerint\b', 'amoveo'),
    (r'\bamouerique\b', 'amoveo'),
    (r'\bamouerit\b', 'amoveo'),
    (r'\bamouerunt\b', 'amoveo'),
    (r'\bamoues\b', 'amoveo'),
    (r'\bamouet\b', 'amoveo'),
    (r'\bamoui\b', 'amoveo'),
    (r'\bamouimus\b', 'amoveo'),
    (r'\bamouisse\b', 'amoveo'),
    (r'\bamouissent\b', 'amoveo'),
    (r'\bamouisset\b', 'amoveo'),
    (r'\bamouit\b', 'amoveo'),
    (r'\bamouitque\b', 'amoveo'),
    (r'\bamove\b', 'amoveo'),
    (r'\bamoveamus\b', 'amoveo'),
    (r'\bamoveas\b', 'amoveo'),
    (r'\bamoveatur\b', 'amoveo'),
    (r'\bamovebis\b', 'amoveo'),
    (r'\bamovebo\b', 'amoveo'),
    (r'\bamovemus\b', 'amoveo'),
    (r'\bamovendi\b', 'amoveo'),
    (r'\bamovendo\b', 'amoveo'),
    (r'\bamovendum\b', 'amoveo'),
    (r'\bamoverant\b', 'amoveo'),
    (r'\bamoverat\b', 'amoveo'),
    (r'\bamovere\b', 'amoveo'),
    (r'\bamoverem\b', 'amoveo'),
    (r'\bamoverent\b', 'amoveo'),
    (r'\bamoveret\b', 'amoveo'),
    (r'\bamoveretur\b', 'amoveo'),
    (r'\bamoveri\b', 'amoveo'),
    (r'\bamoverim\b', 'amoveo'),
    (r'\bamoverique\b', 'amoveo'),
    (r'\bamoveris\b', 'amoveo'),
    (r'\bamoverunt\b', 'amoveo'),
    (r'\bamoves\b', 'amoveo'),
    (r'\bamovet\b', 'amoveo'),
    (r'\bamovete\b', 'amoveo'),
    (r'\bamovi\b', 'amoveo'),
    (r'\bamovimus\b', 'amoveo'),
    (r'\bamovisse\b', 'amoveo'),
    (r'\bamovisti\b', 'amoveo'),
    (r'\bamovit\b', 'amoveo'),
    (r'\bampelina\b', 'ampelinus'),
    (r'\bampelitide\b', 'ampelitis'),
    (r'\bampelo\b', 'ampelos1'),
    (r'\bampelodesmon\b', 'ampelodesmos'),
    (r'\bampelon\b', 'ampelos1'),
    (r'\bAmpelon\b', 'Ampelos2'),
    (r'\bAmpelon\b', 'Ampelos3'),
    (r'\bampelopraso\b', 'ampeloprason'),
    (r'\bampeloprason\b', 'ampeloprason'),
    (r'\bampelos\b', 'ampelos1'),
    (r'\bAmpelos\b', 'Ampelos2'),
    (r'\bAmpelos\b', 'Ampelos3'),
    (r'\bAmphiarae\b', 'Amphiaraus'),
    (r'\bAmphiarai\b', 'Amphiaraus'),
    (r'\bAmphiarao\b', 'Amphiaraus'),
    (r'\bAmphiaraum\b', 'Amphiaraus'),
    (r'\bAmphiaraus\b', 'Amphiaraus'),
    (r'\bamphibolia\b', 'amphibolia'),
    (r'\bamphiboliae\b', 'amphibolia'),
    (r'\bamphiboliam\b', 'amphibolia'),
    (r'\bamphiboliarum\b', 'amphibolia'),
    (r'\bamphibolias\b', 'amphibolia'),
    (r'\bamphibolon\b', 'amphibolus'),
    (r'\bamphibrachy\b', 'amphibrachys'),
    (r'\bamphibrachyn\b', 'amphibrachys'),
    (r'\bamphibrachys\b', 'amphibrachys'),
    (r'\bAmphictyones\b', 'Amphictyones'),
    (r'\bAmphictyonum\b', 'Amphictyones'),
    (r'\bAmphidamantis\b', 'Amphidamas'),
    (r'\bAmphidamas\b', 'Amphidamas'),
    (r'\bAmphilochi\b', 'Amphilochus'),
    (r'\bAmphilochi\b', 'Amphilochia'),
    (r'\bAmphilochi\b', 'Amphilochus'),
    (r'\bAmphilochia\b', 'Amphilochia'),
    (r'\bAmphilochia\b', 'Amphilochus'),
    (r'\bAmphilochii\b', 'Amphilochus'),
    (r'\bAmphilochis\b', 'Amphilochia'),
    (r'\bAmphilochium\b', 'Amphilochus'),
    (r'\bAmphilocho\b', 'Amphilochus'),
    (r'\bAmphilochos\b', 'Amphilochia'),
    (r'\bAmphilochosque\b', 'Amphilochia'),
    (r'\bAmphilochus\b', 'Amphilochus'),
    (r'\bamphimacro\b', 'amphimacrus'),
    (r'\bamphimacron\b', 'amphimacrus'),
    (r'\bamphimacros\b', 'amphimacrus'),
    (r'\bamphimacrum\b', 'amphimacrus'),
    (r'\bamphimallum\b', 'amphimallum'),
    (r'\bAmphimedon\b', 'Amphimedon'),
    (r'\bAmphinome\b', 'Amphinomus'),
    (r'\bAmphinomus\b', 'Amphinomus'),
    (r'\bAmphion\b', 'Amphion'),
    (r'\bAmphione\b', 'Amphion'),
    (r'\bAmphionem\b', 'Amphion'),
    (r'\bAmphioni\b', 'Amphion'),
    (r'\bAmphioni\b', 'Amphipolis'),
    (r'\bAmphioniae\b', 'Amphipolis'),
    (r'\bAmphionias\b', 'Amphipolis'),
    (r'\bAmphioniis\b', 'Amphipolis'),
    (r'\bAmphionio\b', 'Amphipolis'),
    (r'\bAmphionios\b', 'Amphipolis'),
    (r'\bAmphionis\b', 'Amphion'),
    (r'\bAmphipoli\b', 'Amphipolis'),
    (r'\bAmphipolim\b', 'Amphipolis'),
    (r'\bAmphipolin\b', 'Amphipolis'),
    (r'\bAmphipolis\b', 'Amphipolis'),
    (r'\bAmphipolitanos\b', 'amphiprostylos'),
    (r'\bAmphipolites\b', 'amphiprostylos'),
    (r'\bamphiprostylos\b', 'amphiprostylos'),
    (r'\bamphisbaena\b', 'amphisbaena'),
    (r'\bamphisbaenae\b', 'amphisbaena'),
    (r'\bamphisbaenam\b', 'amphisbaena'),
    (r'\bAmphissa\b', 'Amphissa'),
    (r'\bAmphissae\b', 'Amphissa'),
    (r'\bAmphissam\b', 'Amphissa'),
    (r'\bAmphissos\b', 'Amphissus'),
    (r'\bamphithalamos\b', 'amphithalamos'),
    (r'\bamphitheatra\b', 'amphitheatrum'),
    (r'\bamphitheatrales\b', 'amphitheatralis'),
    (r'\bamphitheatrali\b', 'amphitheatralis'),
    (r'\bamphitheatri\b', 'amphitheatrum'),
    (r'\bamphitheatris\b', 'amphitheatrum'),
    (r'\bamphitheatro\b', 'amphitheatrum'),
    (r'\bamphitheatrum\b', 'amphitheatrum'),
    (r'\bAmphitrite\b', 'Amphitrite'),
    (r'\bAmphitriten\b', 'Amphitrite'),
    (r'\bAmphitrites\b', 'Amphitrite'),
    (r'\bAmphitruo\b', 'Amphitryo'),
    (r'\bAmphitruone\b', 'Amphitryo'),
    (r'\bAmphitruonem\b', 'Amphitryo'),
    (r'\bAmphitruoni\b', 'Amphitryo'),
    (r'\bAmphitruonis\b', 'Amphitryo'),
    (r'\bAmphitryo\b', 'Amphitryo'),
    (r'\bAmphitryon\b', 'Amphitryo'),
    (r'\bAmphitryone\b', 'Amphitryo'),
    (r'\bAmphitryoniadae\b', 'amphora'),
    (r'\bAmphitryoniaden\b', 'amphora'),
    (r'\bAmphitryoniades\b', 'amphora'),
    (r'\bAmphitryonis\b', 'Amphitryo'),
    (r'\bamphora\b', 'amphora'),
    (r'\bamphorae\b', 'amphora'),
    (r'\bamphorale\b', 'amphoralis'),
    (r'\bamphoram\b', 'amphora'),
    (r'\bamphoramque\b', 'amphora'),
    (r'\bamphorarii\b', 'amphorarius'),
    (r'\bamphorarium\b', 'amphorarius'),
    (r'\bamphorarum\b', 'amphora'),
    (r'\bamphoras\b', 'amphora'),
    (r'\bamphoris\b', 'amphora'),
    (r'\bamphorisve\b', 'amphora'),
    (r'\bAmphrisia\b', 'Amphrisius'),
    (r'\bAmphrysi\b', 'Amphrysus'),
    (r'\bAmphrysi\b', 'Amphrysus'),
    (r'\bAmphrysia\b', 'Amphrysus'),
    (r'\bAmphrysiaco\b', 'Amphrysus'),
    (r'\bAmphryso\b', 'Amphrysus'),
    (r'\bAmphrysos\b', 'Amphrysus'),
    (r'\bAmphrysum\b', 'Amphrysus'),
    (r'\bAmphrysus\b', 'Amphrysus'),
    (r'\bAmpi\b', 'Ampius'),
    (r'\bAmpiae\b', 'Ampius'),
    (r'\bAmpio\b', 'Ampius'),
    (r'\bAmpium\b', 'Ampius'),
    (r'\bAmpius\b', 'Ampius'),
    (r'\bampla\b', 'amplus'),
    (r'\bampla\b', 'amplo'),
    (r'\bamplae\b', 'amplus'),
    (r'\bamplam\b', 'amplus'),
    (r'\bamplarum\b', 'amplus'),
    (r'\bamplas\b', 'amplus'),
    (r'\bamplas\b', 'amplo'),
    (r'\bamplasque\b', 'amplus'),
    (r'\bamplasque\b', 'amplo'),
    (r'\bample\b', 'amplus'),
    (r'\bamplectamini\b', 'amplector'),
    (r'\bamplectamur\b', 'amplector'),
    (r'\bamplectantur\b', 'amplector'),
    (r'\bamplectar\b', 'amplector'),
    (r'\bamplectare\b', 'amplector'),
    (r'\bamplectaris\b', 'amplector'),
    (r'\bamplectatur\b', 'amplector'),
    (r'\bamplectebantur\b', 'amplector'),
    (r'\bamplectebatur\b', 'amplector'),
    (r'\bamplectenda\b', 'amplector'),
    (r'\bamplectendae\b', 'amplector'),
    (r'\bamplectendam\b', 'amplector'),
    (r'\bamplectendi\b', 'amplector'),
    (r'\bamplectendo\b', 'amplector'),
    (r'\bamplectens\b', 'amplector'),
    (r'\bamplectensque\b', 'amplector'),
    (r'\bamplectente\b', 'amplector'),
    (r'\bamplectentem\b', 'amplector'),
    (r'\bamplectentibus\b', 'amplector'),
    (r'\bamplectentur\b', 'amplector'),
    (r'\bamplectere\b', 'amplector'),
    (r'\bamplecterer\b', 'amplector'),
    (r'\bamplecteretur\b', 'amplector'),
    (r'\bamplecteris\b', 'amplector'),
    (r'\bamplectetur\b', 'amplector'),
    (r'\bamplecti\b', 'amplector'),
    (r'\bamplectier\b', 'amplector'),
    (r'\bamplectimur\b', 'amplector'),
    (r'\bamplectique\b', 'amplector'),
    (r'\bamplectitote\b', 'amplector'),
    (r'\bamplectitur\b', 'amplector'),
    (r'\bamplector\b', 'amplector'),
    (r'\bamplectuntur\b', 'amplector'),
    (r'\bamplent\b', 'amplo'),
    (r'\bampleque\b', 'amplus'),
    (r'\bamplexa\b', 'amplector'),
    (r'\bamplexabantur\b', 'amplexor'),
    (r'\bamplexabere\b', 'amplexor'),
    (r'\bamplexabitur\b', 'amplexor'),
    (r'\bamplexabor\b', 'amplexor'),
    (r'\bamplexae\b', 'amplector'),
    (r'\bamplexaeque\b', 'amplector'),
    (r'\bamplexam\b', 'amplector'),
    (r'\bamplexamini\b', 'amplexor'),
    (r'\bamplexanda\b', 'amplexor'),
    (r'\bamplexandi\b', 'amplexor'),
    (r'\bamplexando\b', 'amplexor'),
    (r'\bamplexandum\b', 'amplexor'),
    (r'\bamplexans\b', 'amplexor'),
    (r'\bamplexantem\b', 'amplexor'),
    (r'\bamplexantes\b', 'amplexor'),
    (r'\bamplexantur\b', 'amplexor'),
    (r'\bamplexaque\b', 'amplector'),
    (r'\bamplexare\b', 'amplexor'),
    (r'\bamplexarentur\b', 'amplexor'),
    (r'\bamplexaretur\b', 'amplexor'),
    (r'\bamplexari\b', 'amplexor'),
    (r'\bamplexarier\b', 'amplexor'),
    (r'\bamplexaris\b', 'amplexor'),
    (r'\bamplexas\b', 'amplector'),
    (r'\bamplexati\b', 'amplexor'),
    (r'\bamplexato\b', 'amplexor'),
    (r'\bamplexatur\b', 'amplexor'),
    (r'\bamplexatus\b', 'amplexor'),
    (r'\bamplexeris\b', 'amplexor'),
    (r'\bamplexetur\b', 'amplexor'),
    (r'\bamplexi\b', 'amplector'),
    (r'\bamplexibus\b', 'amplexus2'),
    (r'\bamplexibusque\b', 'amplexus2'),
    (r'\bamplexis\b', 'amplector'),
    (r'\bamplexo\b', 'amplector'),
    (r'\bamplexor\b', 'amplexor'),
    (r'\bamplexos\b', 'amplector'),
    (r'\bamplexu\b', 'amplexus2'),
    (r'\bamplexu\b', 'amplector'),
    (r'\bamplexum\b', 'amplexus2'),
    (r'\bamplexum\b', 'amplector'),
    (r'\bamplexumque\b', 'amplexus2'),
    (r'\bamplexumque\b', 'amplector'),
    (r'\bamplexuque\b', 'amplexus2'),
    (r'\bamplexuque\b', 'amplector'),
    (r'\bamplexus\b', 'amplexus2'),
    (r'\bamplexus\b', 'amplector'),
    (r'\bamplexusque\b', 'amplexus2'),
    (r'\bamplexusque\b', 'amplector'),
    (r'\bamplexuum\b', 'amplexus2'),
    (r'\bampli\b', 'amplus'),
    (r'\bamplia\b', 'amplio'),
    (r'\bamplianda\b', 'amplio'),
    (r'\bampliandi\b', 'amplio'),
    (r'\bampliando\b', 'amplio'),
    (r'\bampliandoque\b', 'amplio'),
    (r'\bampliantur\b', 'amplio'),
    (r'\bampliare\b', 'amplio'),
    (r'\bampliarentur\b', 'amplio'),
    (r'\bampliaretur\b', 'amplio'),
    (r'\bampliari\b', 'amplio'),
    (r'\bampliasse\b', 'amplio'),
    (r'\bampliassent\b', 'amplio'),
    (r'\bampliat\b', 'amplio'),
    (r'\bampliata\b', 'amplio'),
    (r'\bampliatae\b', 'amplio'),
    (r'\bampliatam\b', 'amplio'),
    (r'\bampliatio\b', 'ampliatio'),
    (r'\bampliationem\b', 'ampliatio'),
    (r'\bampliatique\b', 'amplio'),
    (r'\bampliato\b', 'amplio'),
    (r'\bampliatum\b', 'amplio'),
    (r'\bampliatur\b', 'amplio'),
    (r'\bampliatus\b', 'amplio'),
    (r'\bampliauerat\b', 'amplio'),
    (r'\bampliauerit\b', 'amplio'),
    (r'\bampliauit\b', 'amplio'),
    (r'\bampliaveritis\b', 'amplio'),
    (r'\bampliaverunt\b', 'amplio'),
    (r'\bampliavimus\b', 'amplio'),
    (r'\bampliavit\b', 'amplio'),
    (r'\bampliemus\b', 'amplio'),
    (r'\bampliet\b', 'amplio'),
    (r'\bamplietur\b', 'amplio'),
    (r'\bamplificabatur\b', 'amplifico'),
    (r'\bamplificanda\b', 'amplifico'),
    (r'\bamplificandae\b', 'amplifico'),
    (r'\bamplificandam\b', 'amplifico'),
    (r'\bamplificandas\b', 'amplifico'),
    (r'\bamplificandi\b', 'amplifico'),
    (r'\bamplificandisque\b', 'amplifico'),
    (r'\bamplificando\b', 'amplifico'),
    (r'\bamplificandum\b', 'amplifico'),
    (r'\bamplificans\b', 'amplifico'),
    (r'\bamplificantis\b', 'amplifico'),
    (r'\bamplificantur\b', 'amplifico'),
    (r'\bamplificare\b', 'amplifico'),
    (r'\bamplificarent\b', 'amplifico'),
    (r'\bamplificaret\b', 'amplifico'),
    (r'\bamplificari\b', 'amplifico'),
    (r'\bamplificarique\b', 'amplifico'),
    (r'\bamplificat\b', 'amplifico'),
    (r'\bamplificata\b', 'amplifico'),
    (r'\bamplificatae\b', 'amplifico'),
    (r'\bamplificatam\b', 'amplifico'),
    (r'\bamplificatamque\b', 'amplifico'),
    (r'\bamplificataque\b', 'amplifico'),
    (r'\bamplificati\b', 'amplifico'),
    (r'\bamplificatio\b', 'amplificatio'),
    (r'\bamplificatione\b', 'amplificatio'),
    (r'\bamplificationem\b', 'amplificatio'),
    (r'\bamplificationes\b', 'amplificatio'),
    (r'\bamplificationi\b', 'amplificatio'),
    (r'\bamplificationibus\b', 'amplificatio'),
    (r'\bamplificationis\b', 'amplificatio'),
    (r'\bamplificatis\b', 'amplifico'),
    (r'\bamplificato\b', 'amplifico'),
    (r'\bamplificator\b', 'amplificator'),
    (r'\bamplificatorem\b', 'amplificator'),
    (r'\bamplificatum\b', 'amplifico'),
    (r'\bamplificatur\b', 'amplifico'),
    (r'\bamplificaturum\b', 'amplifico'),
    (r'\bamplificatus\b', 'amplifico'),
    (r'\bamplificauit\b', 'amplifico'),
    (r'\bamplificaverunt\b', 'amplifico'),
    (r'\bamplificavit\b', 'amplifico'),
    (r'\bamplifice\b', 'amplificus'),
    (r'\bamplificemus\b', 'amplifico'),
    (r'\bamplifices\b', 'amplifico'),
    (r'\bamplificet\b', 'amplifico'),
    (r'\bamplificum\b', 'amplificus'),
    (r'\bamplior\b', 'amplus'),
    (r'\bamplior\b', 'amplio'),
    (r'\bampliora\b', 'amplus'),
    (r'\bampliore\b', 'amplus'),
    (r'\bampliorem\b', 'amplus'),
    (r'\bamplioremque\b', 'amplus'),
    (r'\bampliores\b', 'amplus'),
    (r'\bamplioresque\b', 'amplus'),
    (r'\bampliori\b', 'amplus'),
    (r'\bamplioribus\b', 'amplus'),
    (r'\bamplioribusne\b', 'amplus'),
    (r'\bamplioris\b', 'amplus'),
    (r'\bampliorque\b', 'amplus'),
    (r'\bampliorque\b', 'amplio'),
    (r'\bampliorum\b', 'amplus'),
    (r'\bamplis\b', 'amplus'),
    (r'\bamplissima\b', 'amplus'),
    (r'\bamplissimae\b', 'amplus'),
    (r'\bamplissimam\b', 'amplus'),
    (r'\bamplissimarum\b', 'amplus'),
    (r'\bamplissimas\b', 'amplus'),
    (r'\bamplissimasque\b', 'amplus'),
    (r'\bamplissime\b', 'amplus'),
    (r'\bamplissimi\b', 'amplus'),
    (r'\bamplissimique\b', 'amplus'),
    (r'\bamplissimis\b', 'amplus'),
    (r'\bamplissimisque\b', 'amplus'),
    (r'\bamplissimo\b', 'amplus'),
    (r'\bamplissimorum\b', 'amplus'),
    (r'\bamplissimos\b', 'amplus'),
    (r'\bamplissimum\b', 'amplus'),
    (r'\bamplissimumque\b', 'amplus'),
    (r'\bamplissimus\b', 'amplus'),
    (r'\bamplissumis\b', 'amplus'),
    (r'\bamplissumorum\b', 'amplus'),
    (r'\bamplissumos\b', 'amplus'),
    (r'\bampliter\b', 'ampliter'),
    (r'\bamplitudine\b', 'amplitudo'),
    (r'\bamplitudinem\b', 'amplitudo'),
    (r'\bamplitudinemque\b', 'amplitudo'),
    (r'\bamplitudineque\b', 'amplitudo'),
    (r'\bamplitudines\b', 'amplitudo'),
    (r'\bamplitudini\b', 'amplitudo'),
    (r'\bamplitudinibus\b', 'amplitudo'),
    (r'\bamplitudinis\b', 'amplitudo'),
    (r'\bamplitudinisque\b', 'amplitudo'),
    (r'\bamplitudo\b', 'amplitudo'),
    (r'\bamplitudoque\b', 'amplitudo'),
    (r'\bamplius\b', 'amplus'),
    (r'\bampliuscula\b', 'ampliusculus'),
    (r'\bampliuscule\b', 'ampliusculus'),
    (r'\bampliusque\b', 'amplus'),
    (r'\bampliusue\b', 'amplus'),
    (r'\bamplo\b', 'amplus'),
    (r'\bamplo\b', 'amplo'),
    (r'\bamplos\b', 'amplus'),
    (r'\bamplum\b', 'amplus'),
    (r'\bamplus\b', 'amplus'),
    (r'\bAmpsancti\b', 'Ampsanctus'),
    (r'\bampulla\b', 'ampulla'),
    (r'\bampullacea\b', 'ampullaceus'),
    (r'\bampullae\b', 'ampulla'),
    (r'\bampullam\b', 'ampulla'),
    (r'\bampullarius\b', 'ampullarius'),
    (r'\bampullas\b', 'ampulla'),
    (r'\bampullatur\b', 'ampullor'),
    (r'\bampullis\b', 'ampulla'),
    (r'\bamputa\b', 'amputo'),
    (r'\bamputabant\b', 'amputo'),
    (r'\bamputabat\b', 'amputo'),
    (r'\bamputabis\b', 'amputo'),
    (r'\bamputabit\b', 'amputo'),
    (r'\bamputabitur\b', 'amputo'),
    (r'\bamputabo\b', 'amputo'),
    (r'\bamputabuntur\b', 'amputo'),
    (r'\bamputanda\b', 'amputo'),
    (r'\bamputandae\b', 'amputo'),
    (r'\bamputandam\b', 'amputo'),
    (r'\bamputandi\b', 'amputo'),
    (r'\bamputandos\b', 'amputo'),
    (r'\bamputandus\b', 'amputo'),
    (r'\bamputans\b', 'amputo'),
    (r'\bamputant\b', 'amputo'),
    (r'\bamputantem\b', 'amputo'),
    (r'\bamputantibus\b', 'amputo'),
    (r'\bamputantur\b', 'amputo'),
    (r'\bamputare\b', 'amputo'),
    (r'\bamputarent\b', 'amputo'),
    (r'\bamputaretur\b', 'amputo'),
    (r'\bamputari\b', 'amputo'),
    (r'\bamputasse\b', 'amputo'),
    (r'\bamputassent\b', 'amputo'),
    (r'\bamputasset\b', 'amputo'),
    (r'\bamputat\b', 'amputo'),
    (r'\bamputata\b', 'amputo'),
    (r'\bamputatae\b', 'amputo'),
    (r'\bamputatio\b', 'amputatio'),
    (r'\bamputatione\b', 'amputatio'),
    (r'\bamputationem\b', 'amputatio'),
    (r'\bamputationemque\b', 'amputatio'),
    (r'\bamputatis\b', 'amputo'),
    (r'\bamputatisque\b', 'amputo'),
    (r'\bamputato\b', 'amputo'),
    (r'\bamputatoque\b', 'amputo'),
    (r'\bamputatum\b', 'amputo'),
    (r'\bamputatumque\b', 'amputo'),
    (r'\bamputatur\b', 'amputo'),
    (r'\bamputaturae\b', 'amputo'),
    (r'\bamputaturum\b', 'amputo'),
    (r'\bamputauit\b', 'amputo'),
    (r'\bamputaverat\b', 'amputo'),
    (r'\bamputaveris\b', 'amputo'),
    (r'\bamputaverunt\b', 'amputo'),
    (r'\bamputavi\b', 'amputo'),
    (r'\bamputavisset\b', 'amputo'),
    (r'\bamputavit\b', 'amputo'),
    (r'\bamputem\b', 'amputo'),
    (r'\bamputemus\b', 'amputo'),
    (r'\bamputentur\b', 'amputo'),
    (r'\bamputes\b', 'amputo'),
    (r'\bamputet\b', 'amputo'),
    (r'\bamputetur\b', 'amputo'),
    (r'\bAmpyci\b', 'Ampycus'),
    (r'\bAmpyciden\b', 'Ampycides'),
    (r'\bAmpycides\b', 'Ampycides'),
    (r'\bAmpycidesque\b', 'Ampycides'),
    (r'\bAmpycus\b', 'Ampycus'),
    (r'\bamuleta\b', 'amuletum'),
    (r'\bamuleti\b', 'amuletum'),
    (r'\bamuleto\b', 'amuletum'),
    (r'\bamuletum\b', 'amuletum'),
    (r'\bAmuli\b', 'Amulius'),
    (r'\bamuli\b', 'amylum'),
    (r'\bAmulii\b', 'Amulius'),
    (r'\bAmulio\b', 'Amulius'),
    (r'\bAmulium\b', 'Amulius'),
    (r'\bAmuliumque\b', 'Amulius'),
    (r'\bAmulius\b', 'Amulius'),
    (r'\bamulo\b', 'amylum'),
    (r'\bamulum\b', 'amylum'),
    (r'\bamurca\b', 'amurca'),
    (r'\bamurcae\b', 'amurca'),
    (r'\bamurcam\b', 'amurca'),
    (r'\bamurcamque\b', 'amurca'),
    (r'\bamurcaria\b', 'amurcarius'),
    (r'\bamurga\b', 'amurca'),
    (r'\bamurgae\b', 'amurca'),
    (r'\bamurgam\b', 'amurca'),
    (r'\bamurgaque\b', 'amurca'),
    (r'\bamusiam\b', 'amusia'),
    (r'\bamusos\b', 'amusos'),
    (r'\bamussim\b', 'amussis'),
    (r'\bamussis\b', 'amussis'),
    (r'\bAmyci\b', 'Amycus'),
    (r'\bAmyclae\b', 'Amyclae'),
    (r'\bAmyclaea\b', 'Amyclides'),
    (r'\bAmyclaeas\b', 'Amyclides'),
    (r'\bAmyclaei\b', 'Amyclides'),
    (r'\bAmyclaeis\b', 'Amyclides'),
    (r'\bAmyclaeo\b', 'Amyclides'),
    (r'\bAmyclaeos\b', 'Amyclides'),
    (r'\bAmyclaeum\b', 'Amyclides'),
    (r'\bAmyclaeumque\b', 'Amyclides'),
    (r'\bAmyclanus\b', 'Amyclides'),
    (r'\bAmyclas\b', 'Amyclae'),
    (r'\bAmyclide\b', 'Amyclides'),
    (r'\bAmyclis\b', 'Amyclae'),
    (r'\bAmyco\b', 'Amycus'),
    (r'\bAmycum\b', 'Amycus'),
    (r'\bAmycus\b', 'Amycus'),
    (r'\bamygdala\b', 'amygdala'),
    (r'\bamygdala\b', 'amygdalum'),
    (r'\bamygdalae\b', 'amygdala'),
    (r'\bamygdalam\b', 'amygdala'),
    (r'\bamygdalarum\b', 'amygdala'),
    (r'\bamygdalas\b', 'amygdala'),
    (r'\bamygdale\b', 'amygdalus'),
    (r'\bamygdale\b', 'amygdalum'),
    (r'\bamygdalina\b', 'amygdalinus'),
    (r'\bamygdalinae\b', 'amygdalinus'),
    (r'\bamygdalino\b', 'amygdalinus'),
    (r'\bamygdalinum\b', 'amygdalinus'),
    (r'\bamygdalis\b', 'amygdala'),
    (r'\bamygdalis\b', 'amygdalum'),
    (r'\bamygdaliten\b', 'amygdalites'),
    (r'\bamygdalites\b', 'amygdalites'),
    (r'\bamygdalorum\b', 'amygdalus'),
    (r'\bamygdalorum\b', 'amygdalum'),
    (r'\bamygdalum\b', 'amygdalus'),
    (r'\bamygdalum\b', 'amygdalum'),
    (r'\bamygdalumve\b', 'amygdalus'),
    (r'\bamygdalumve\b', 'amygdalum'),
    (r'\bamyli\b', 'amylum'),
    (r'\bamylique\b', 'amylum'),
    (r'\bamylo\b', 'amylum'),
    (r'\bamylo\b', 'amylo'),
    (r'\bamylum\b', 'amylum'),
    (r'\bAmymone\b', 'Amymone'),
    (r'\bAmymonen\b', 'Amymone'),
    (r'\bAmymones\b', 'Amymone'),
    (r'\bAmymoniorum\b', 'Amyntas'),
    (r'\bAmynta\b', 'Amyntas'),
    (r'\bAmyntae\b', 'Amyntas'),
    (r'\bAmyntam\b', 'Amyntas'),
    (r'\bAmyntan\b', 'Amyntas'),
    (r'\bAmyntaque\b', 'Amyntas'),
    (r'\bAmyntas\b', 'Amyntas'),
    (r'\bAmyntiaden\b', 'Amyntor'),
    (r'\bAmyntor\b', 'Amyntor'),
    (r'\bAmyntore\b', 'Amyntor'),
    (r'\bAmyntorem\b', 'Amyntor'),
    (r'\bAmyntorides\b', 'amystis'),
    (r'\bAmyntoris\b', 'Amyntor'),
    (r'\bamystide\b', 'amystis'),
    (r'\bamystis\b', 'amystis'),
    (r'\bAmythaone\b', 'Amythaon'),
    (r'\bAmythaonia\b', 'an'),
    (r'\bAmythaonis\b', 'Amythaon'),
    (r'\bAmythaonius\b', 'an'),
    (r'\bAmythaoniusque\b', 'an'),
    (r'\ban\b', 'an'),
    (r'\bAna\b', 'Anas3'),
    (r'\bana\b', 'anodynon'),
    (r'\banabasim\b', 'anabasis'),
    (r'\banabasis\b', 'anabasis'),
    (r'\banabathra\b', 'anabathrum'),
    (r'\banacampserote\b', 'anacampseros'),
    (r'\banacampseroten\b', 'anacampseros'),
    (r'\bAnacharsim\b', 'Anacharsis'),
    (r'\bAnacharsis\b', 'Anacharsis'),
    (r'\bAnacreon\b', 'Anacreon'),
    (r'\bAnacreonte\b', 'Anacreon'),
    (r'\bAnacreonteum\b', 'anactorium'),
    (r'\bAnacreonti\b', 'Anacreon'),
    (r'\bAnacreonti\b', 'anactorium'),
    (r'\bAnacreontis\b', 'Anacreon'),
    (r'\banactoria\b', 'anactorium'),
    (r'\banactorie\b', 'anactorium'),
    (r'\banactorio\b', 'anactorium'),
    (r'\banactorium\b', 'anactorium'),
    (r'\banademata\b', 'anadema'),
    (r'\bAnadyomenen\b', 'Anadyomene'),
    (r'\bAnae\b', 'Anas3'),
    (r'\banagallides\b', 'anagallis'),
    (r'\banagallidi\b', 'anagallis'),
    (r'\banagallidis\b', 'anagallis'),
    (r'\banagallidum\b', 'anagallis'),
    (r'\banagallis\b', 'anagallis'),
    (r'\banaglypta\b', 'anaglyptus'),
    (r'\banaglypta\b', 'anaglypta'),
    (r'\bAnagnia\b', 'Anagnia'),
    (r'\bAnagniae\b', 'Anagnia'),
    (r'\bAnagniam\b', 'Anagnia'),
    (r'\bAnagnini\b', 'anagnostes'),
    (r'\bAnagnini\b', 'anagnostes'),
    (r'\bAnagnini\b', 'anagnostes'),
    (r'\bAnagninis\b', 'anagnostes'),
    (r'\bAnagninis\b', 'anagnostes'),
    (r'\bAnagninis\b', 'anagnostes'),
    (r'\bAnagnino\b', 'anagnostes'),
    (r'\bAnagnino\b', 'anagnostes'),
    (r'\bAnagninos\b', 'anagnostes'),
    (r'\bAnagninum\b', 'anagnostes'),
    (r'\bAnagninum\b', 'anagnostes'),
    (r'\bAnagninum\b', 'anagnostes'),
    (r'\banagnosta\b', 'anagnostes'),
    (r'\banagnostae\b', 'anagnostes'),
    (r'\banagnosten\b', 'anagnostes'),
    (r'\banagnostes\b', 'anagnostes'),
    (r'\banagyros\b', 'anagyros'),
    (r'\banalecta\b', 'analecta'),
    (r'\banalectas\b', 'analecta'),
    (r'\banalogi\b', 'analogus'),
    (r'\banalogia\b', 'analogia'),
    (r'\banalogiae\b', 'analogia'),
    (r'\banalogiam\b', 'analogia'),
    (r'\banalogian\b', 'analogia'),
    (r'\banalogiarum\b', 'analogia'),
    (r'\banalogias\b', 'analogia'),
    (r'\banalogicis\b', 'analogicus'),
    (r'\banalogiis\b', 'analogia'),
    (r'\banalogo\b', 'analogus'),
    (r'\bAnam\b', 'Anas3'),
    (r'\bAnan\b', 'Anas3'),
    (r'\banan\b', 'anodynon'),
    (r'\banancaea\b', 'anancaeum'),
    (r'\banancaeo\b', 'anancaeum'),
    (r'\bananciten\b', 'anancites'),
    (r'\banancitide\b', 'anancitis'),
    (r'\banancitis\b', 'anancitis'),
    (r'\banancitis\b', 'anancites'),
    (r'\banapaesta\b', 'anapaestus'),
    (r'\banapaesta\b', 'anapaestus'),
    (r'\banapaesti\b', 'anapaestus'),
    (r'\banapaesti\b', 'anapaestus'),
    (r'\banapaestica\b', 'anapaesticus'),
    (r'\banapaesticis\b', 'anapaesticus'),
    (r'\banapaestico\b', 'anapaesticus'),
    (r'\banapaesticon\b', 'anapaesticus'),
    (r'\banapaesticum\b', 'anapaesticus'),
    (r'\banapaesticus\b', 'anapaesticus'),
    (r'\banapaestis\b', 'anapaestus'),
    (r'\banapaestis\b', 'anapaestus'),
    (r'\banapaesto\b', 'anapaestus'),
    (r'\banapaesto\b', 'anapaestus'),
    (r'\banapaeston\b', 'anapaestus'),
    (r'\banapaeston\b', 'anapaestus'),
    (r'\banapaestos\b', 'anapaestus'),
    (r'\banapaestum\b', 'anapaestus'),
    (r'\banapaestum\b', 'anapaestus'),
    (r'\banapaestus\b', 'anapaestus'),
    (r'\bAnaphe\b', 'Anaphe'),
    (r'\bAnaphen\b', 'Anaphe'),
    (r'\banaphoras\b', 'anaphora'),
    (r'\banaphorica\b', 'anaphoricus'),
    (r'\bAnapi\b', 'Anapis'),
    (r'\bAnapis\b', 'Anapis'),
    (r'\bAnapum\b', 'Anapis'),
    (r'\bAnapus\b', 'Anapis'),
    (r'\bAnas\b', 'Anas3'),
    (r'\banas\b', 'anodynon'),
    (r'\banatariam\b', 'anatarius'),
    (r'\banate\b', 'anodynon'),
    (r'\banatem\b', 'anatocismus'),
    (r'\banatemque\b', 'anatocismus'),
    (r'\banates\b', 'anatocismus'),
    (r'\banatesque\b', 'anatocismus'),
    (r'\banathema\b', 'anathema1'),
    (r'\banathemata\b', 'anathema1'),
    (r'\banathemate\b', 'anathema1'),
    (r'\banathematis\b', 'anathema1'),
    (r'\banathematizare\b', 'anathematizo'),
    (r'\banathematizavit\b', 'anathematizo'),
    (r'\banathymiasis\b', 'anathymiasis'),
    (r'\banaticulas\b', 'anaticula'),
    (r'\banatinam\b', 'anatina'),
    (r'\banatis\b', 'anodynon'),
    (r'\banatocismo\b', 'anatocismus'),
    (r'\banatona\b', 'anatonus'),
    (r'\bAnauros\b', 'Anaurus'),
    (r'\bAnaxagora\b', 'Anaxagoras'),
    (r'\bAnaxagorae\b', 'Anaxagoras'),
    (r'\bAnaxagoram\b', 'Anaxagoras'),
    (r'\bAnaxagoran\b', 'Anaxagoras'),
    (r'\bAnaxagoras\b', 'Anaxagoras'),
    (r'\bAnaxarchi\b', 'Anaxarchus'),
    (r'\bAnaxarchique\b', 'Anaxarchus'),
    (r'\bAnaxarcho\b', 'Anaxarchus'),
    (r'\bAnaxarchum\b', 'Anaxarchus'),
    (r'\bAnaxarchus\b', 'Anaxarchus'),
    (r'\bAnaxarete\b', 'Anaxarete'),
    (r'\bAnaxareten\b', 'Anaxarete'),
    (r'\bAnaxaretes\b', 'Anaxarete'),
    (r'\bAnaximander\b', 'Anaximander'),
    (r'\bAnaximandri\b', 'Anaximander'),
    (r'\bAnaximandro\b', 'Anaximander'),
    (r'\bAnaximandrum\b', 'Anaximander'),
    (r'\bAncaei\b', 'Ancaeus'),
    (r'\bAncaeo\b', 'Ancaeus'),
    (r'\bAncaeum\b', 'Ancaeus'),
    (r'\bAncaeus\b', 'Ancaeus'),
    (r'\bAncalites\b', 'Ancalites'),
    (r'\banceps\b', 'anceps'),
    (r'\bancepsque\b', 'anceps'),
    (r'\bAnchari\b', 'Ancharius'),
    (r'\bAnchariana\b', 'Ancharius'),
    (r'\bAncharianam\b', 'Ancharius'),
    (r'\bAnchario\b', 'Ancharius'),
    (r'\bAncharium\b', 'Ancharius'),
    (r'\bAncharius\b', 'Ancharius'),
    (r'\bAnchiale\b', 'Anchises'),
    (r'\bAnchiali\b', 'Anchises'),
    (r'\bAnchialos\b', 'Anchises'),
    (r'\bAnchialum\b', 'Anchises'),
    (r'\bAnchialus\b', 'Anchises'),
    (r'\bAnchisa\b', 'Anchises'),
    (r'\bAnchisae\b', 'Anchises'),
    (r'\bAnchisam\b', 'Anchises'),
    (r'\bAnchise\b', 'Anchises'),
    (r'\bAnchisen\b', 'Anchises'),
    (r'\bAnchisenque\b', 'Anchises'),
    (r'\bAnchiseo\b', 'anchora'),
    (r'\bAnchises\b', 'Anchises'),
    (r'\bAnchisesque\b', 'Anchises'),
    (r'\bAnchisiade\b', 'anchora'),
    (r'\bAnchisiaden\b', 'anchora'),
    (r'\bAnchisiades\b', 'anchora'),
    (r'\banchora\b', 'anchora'),
    (r'\banchorae\b', 'anchora'),
    (r'\banchoram\b', 'anchora'),
    (r'\banchorarum\b', 'anchora'),
    (r'\banchoras\b', 'anchora'),
    (r'\banchoris\b', 'anchora'),
    (r'\banchusa\b', 'anchusa'),
    (r'\banchusae\b', 'anchusa'),
    (r'\banchusam\b', 'anchusa'),
    (r'\bAnci\b', 'Ancus2'),
    (r'\bancile\b', 'ancile'),
    (r'\bancilia\b', 'ancile'),
    (r'\bancilibus\b', 'ancile'),
    (r'\bancilium\b', 'ancile'),
    (r'\bancilla\b', 'ancilla'),
    (r'\bancillae\b', 'ancilla'),
    (r'\bancillaeque\b', 'ancilla'),
    (r'\bancillaeue\b', 'ancilla'),
    (r'\bancillam\b', 'ancilla'),
    (r'\bancillamque\b', 'ancilla'),
    (r'\bancillans\b', 'ancillor'),
    (r'\bancillantur\b', 'ancillor'),
    (r'\bancillari\b', 'ancillaris'),
    (r'\bancillari\b', 'ancillor'),
    (r'\bancillariolum\b', 'ancillariolus'),
    (r'\bancillarique\b', 'ancillaris'),
    (r'\bancillarique\b', 'ancillor'),
    (r'\bancillaris\b', 'ancillaris'),
    (r'\bancillaris\b', 'ancillor'),
    (r'\bancillarum\b', 'ancilla'),
    (r'\bancillarumque\b', 'ancilla'),
    (r'\bancillas\b', 'ancilla'),
    (r'\bancillasque\b', 'ancilla'),
    (r'\bancillast\b', 'ancilla'),
    (r'\bancillatus\b', 'ancillatus'),
    (r'\bancillatus\b', 'ancillor'),
    (r'\bancillis\b', 'ancilla'),
    (r'\bancillisue\b', 'ancilla'),
    (r'\bancillula\b', 'ancillula'),
    (r'\bancillulae\b', 'ancillula'),
    (r'\bancillulam\b', 'ancillula'),
    (r'\bancillulas\b', 'ancillula'),
    (r'\bancillulast\b', 'ancillula'),
    (r'\bancillulis\b', 'ancillula'),
    (r'\bancipitem\b', 'anceps'),
    (r'\bancipitemque\b', 'anceps'),
    (r'\bancipites\b', 'anceps'),
    (r'\bancipitesque\b', 'anceps'),
    (r'\bancipiti\b', 'anceps'),
    (r'\bancipitibus\b', 'anceps'),
    (r'\bancipitique\b', 'anceps'),
    (r'\bancipitis\b', 'anceps'),
    (r'\bancipitisque\b', 'anceps'),
    (r'\banclabatur\b', 'anclo'),
    (r'\bAnco\b', 'Ancus2'),
    (r'\bAncon\b', 'Ancon2'),
    (r'\bancon\b', 'ancon1'),
    (r'\bAncona\b', 'ancora'),
    (r'\bAnconae\b', 'ancora'),
    (r'\bAnconam\b', 'ancora'),
    (r'\bAncone\b', 'Ancon2'),
    (r'\bancone\b', 'ancon1'),
    (r'\bAnconem\b', 'Ancon2'),
    (r'\banconem\b', 'ancon1'),
    (r'\bancones\b', 'ancon1'),
    (r'\banconibus\b', 'ancon1'),
    (r'\bAnconitanum\b', 'ancora'),
    (r'\bancora\b', 'ancora'),
    (r'\bancorae\b', 'ancora'),
    (r'\bancorale\b', 'ancoralis'),
    (r'\bancoralia\b', 'ancoralis'),
    (r'\bancoralibus\b', 'ancoralis'),
    (r'\bancoralibus\b', 'ancoralis'),
    (r'\bancoram\b', 'ancora'),
    (r'\bancorariis\b', 'ancorarius'),
    (r'\bancorarius\b', 'ancorarius'),
    (r'\bancorarum\b', 'ancora'),
    (r'\bancoras\b', 'ancora'),
    (r'\bancoris\b', 'ancora'),
    (r'\bAncos\b', 'Ancus2'),
    (r'\banctus\b', 'ango'),
    (r'\bAncum\b', 'Ancus2'),
    (r'\bAncus\b', 'Ancus2'),
    (r'\bAncyra\b', 'Ancyra'),
    (r'\bAncyram\b', 'Ancyra'),
    (r'\bandabata\b', 'andabata'),
    (r'\bandabatae\b', 'andabata'),
    (r'\bAndaniam\b', 'Andania'),
    (r'\bAndecavi\b', 'Andecavi'),
    (r'\bAndecavos\b', 'Andecavi'),
    (r'\bandem\b', 'an'),
    (r'\bAndes\b', 'Andes2'),
    (r'\bAndibus\b', 'Andes2'),
    (r'\bandrachne\b', 'andrachne'),
    (r'\bAndraemon\b', 'Andraemon'),
    (r'\bAndraemone\b', 'Andraemon'),
    (r'\bAndremonis\b', 'Andraemon'),
    (r'\bAndri\b', 'Andros'),
    (r'\bAndri\b', 'Andrius'),
    (r'\bAndria\b', 'Andricus'),
    (r'\bAndria\b', 'Andrius'),
    (r'\bAndriae\b', 'Andricus'),
    (r'\bAndriam\b', 'Andricus'),
    (r'\bAndrias\b', 'Andricus'),
    (r'\bAndriast\b', 'Andricus'),
    (r'\bAndriast\b', 'Andrius'),
    (r'\bAndricus\b', 'Andricus'),
    (r'\bAndriorum\b', 'Andrius'),
    (r'\bAndrisco\b', 'Andriscus'),
    (r'\bAndriscum\b', 'Andriscus'),
    (r'\bAndriscus\b', 'Andriscus'),
    (r'\bAndrium\b', 'Andrius'),
    (r'\bAndrius\b', 'Andrius'),
    (r'\bAndro\b', 'Andros'),
    (r'\bAndroclen\b', 'Androcles'),
    (r'\bAndrocles\b', 'Androcles'),
    (r'\bAndroclum\b', 'Androcles'),
    (r'\bAndroclus\b', 'Androcles'),
    (r'\bandrodamas\b', 'androdamas'),
    (r'\bAndrogei\b', 'Androgeos'),
    (r'\bAndrogeique\b', 'Androgeos'),
    (r'\bAndrogeo\b', 'Androgeos'),
    (r'\bAndrogeoneae\b', 'Androgeos'),
    (r'\bAndrogeos\b', 'Androgeos'),
    (r'\bAndrogeum\b', 'Androgeos'),
    (r'\bAndrogeus\b', 'Androgeos'),
    (r'\bandrogynen\b', 'androgyne'),
    (r'\bandrogyni\b', 'androgynus'),
    (r'\bandrogyno\b', 'androgynus'),
    (r'\bandrogynos\b', 'androgynus'),
    (r'\bAndrom\b', 'Andros'),
    (r'\bAndromacha\b', 'Andromache'),
    (r'\bAndromachae\b', 'Andromache'),
    (r'\bAndromacham\b', 'Andromache'),
    (r'\bAndromache\b', 'Andromache'),
    (r'\bAndromachen\b', 'Andromache'),
    (r'\bAndromacheque\b', 'Andromache'),
    (r'\bAndromaches\b', 'Andromache'),
    (r'\bAndromeda\b', 'Andromeda'),
    (r'\bAndromedae\b', 'Andromeda'),
    (r'\bAndromedaeque\b', 'Andromeda'),
    (r'\bAndromedam\b', 'Andromeda'),
    (r'\bAndromedan\b', 'Andromeda'),
    (r'\bAndromedanque\b', 'Andromeda'),
    (r'\bAndromede\b', 'Andromeda'),
    (r'\bAndromedeque\b', 'Andromeda'),
    (r'\bAndromene\b', 'andron'),
    (r'\bAndromeni\b', 'andron'),
    (r'\bAndron\b', 'Andros'),
    (r'\bandron\b', 'andron'),
    (r'\bAndrone\b', 'Andros'),
    (r'\bandrone\b', 'andron'),
    (r'\bandronem\b', 'andron'),
    (r'\bandroni\b', 'andron'),
    (r'\bAndronici\b', 'Andronicus'),
    (r'\bAndronico\b', 'Andronicus'),
    (r'\bAndronicum\b', 'Andronicus'),
    (r'\bAndronicus\b', 'Andronicus'),
    (r'\bandronis\b', 'andron'),
    (r'\bandronitides\b', 'andronitis'),
    (r'\bandronitin\b', 'andronitis'),
    (r'\bAndros\b', 'Andros'),
    (r'\bandrosaces\b', 'androsaces'),
    (r'\bandrosaemon\b', 'androsaemon'),
    (r'\bAndrum\b', 'Andros'),
    (r'\bane\b', 'anus1'),
    (r'\baneclogisti\b', 'aneclogistus'),
    (r'\baneclogistos\b', 'aneclogistus'),
    (r'\banelli\b', 'anellus'),
    (r'\banellis\b', 'anellus'),
    (r'\banellos\b', 'anellus'),
    (r'\banellum\b', 'anellus'),
    (r'\banem\b', 'anodynon'),
    (r'\banemonae\b', 'anemone'),
    (r'\banemonas\b', 'anemone'),
    (r'\banemone\b', 'anemone'),
    (r'\banemonen\b', 'anemone'),
    (r'\banemones\b', 'anemone'),
    (r'\bAnemuriensis\b', 'Anemurium'),
    (r'\bAnemurio\b', 'Anemurium'),
    (r'\bAnemurium\b', 'Anemurium'),
    (r'\baner\b', 'anodynon'),
    (r'\banes\b', 'anethum'),
    (r'\banes\b', 'anodynon'),
    (r'\banescit\b', 'anethum'),
    (r'\banet\b', 'anethum'),
    (r'\banet\b', 'anodynon'),
    (r'\banethi\b', 'anethum'),
    (r'\banetho\b', 'anethum'),
    (r'\banethum\b', 'anethum'),
    (r'\baneti\b', 'anethum'),
    (r'\banetis\b', 'anethum'),
    (r'\banetis\b', 'anodynon'),
    (r'\baneto\b', 'anethum'),
    (r'\banetum\b', 'anethum'),
    (r'\banfracta\b', 'anfractum'),
    (r'\banfractibus\b', 'anfractus2'),
    (r'\banfracto\b', 'anfractum'),
    (r'\banfractu\b', 'anfractus2'),
    (r'\banfractum\b', 'anfractus2'),
    (r'\banfractum\b', 'anfractum'),
    (r'\banfractus\b', 'anfractus2'),
    (r'\bangam\b', 'ango'),
    (r'\bangant\b', 'ango'),
    (r'\bangantur\b', 'ango'),
    (r'\bangar\b', 'ango'),
    (r'\bangari\b', 'angarius'),
    (r'\bangariae\b', 'angaria'),
    (r'\bangariari\b', 'angario'),
    (r'\bangariarum\b', 'angaria'),
    (r'\bangariaverit\b', 'angario'),
    (r'\bangariaverunt\b', 'angario'),
    (r'\bangariis\b', 'angaria'),
    (r'\bangariis\b', 'angarius'),
    (r'\bangariorum\b', 'angarius'),
    (r'\bangariorumue\b', 'angarius'),
    (r'\bangaris\b', 'ango'),
    (r'\bangas\b', 'ango'),
    (r'\bangat\b', 'ango'),
    (r'\bangatur\b', 'ango'),
    (r'\bangebant\b', 'ango'),
    (r'\bangebantur\b', 'ango'),
    (r'\bangebar\b', 'ango'),
    (r'\bangebat\b', 'ango'),
    (r'\bangebatur\b', 'ango'),
    (r'\bangeli\b', 'angelus'),
    (r'\bangelicum\b', 'angelicus'),
    (r'\bangelicus\b', 'angelicus'),
    (r'\bangelis\b', 'angelus'),
    (r'\bangellis\b', 'angellus'),
    (r'\bangelo\b', 'angelus'),
    (r'\bangelorum\b', 'angelus'),
    (r'\bangelorumque\b', 'angelus'),
    (r'\bangelos\b', 'angelus'),
    (r'\bangelum\b', 'angelus'),
    (r'\bangelus\b', 'angelus'),
    (r'\bangens\b', 'ango'),
    (r'\bangentem\b', 'ango'),
    (r'\bangere\b', 'ango'),
    (r'\bangerent\b', 'ango'),
    (r'\bangerentur\b', 'ango'),
    (r'\bangerer\b', 'ango'),
    (r'\bangeret\b', 'ango'),
    (r'\bangeretur\b', 'ango'),
    (r'\bAngerona\b', 'Angerona'),
    (r'\bAngeronalia\b', 'angina'),
    (r'\bangetur\b', 'ango'),
    (r'\bangi\b', 'ango'),
    (r'\bangimur\b', 'ango'),
    (r'\bangina\b', 'angina'),
    (r'\banginae\b', 'angina'),
    (r'\banginam\b', 'angina'),
    (r'\banginas\b', 'angina'),
    (r'\banginis\b', 'angina'),
    (r'\bangiporta\b', 'angiportus'),
    (r'\bangiporti\b', 'angiportus'),
    (r'\bangiportis\b', 'angiportus'),
    (r'\bangiporto\b', 'angiportus'),
    (r'\bangiportorum\b', 'angiportus'),
    (r'\bangiportu\b', 'angiportus'),
    (r'\bangiportum\b', 'angiportus'),
    (r'\bangiportum\b', 'angiportus'),
    (r'\bangiportus\b', 'angiportus'),
    (r'\bangiportusque\b', 'angiportus'),
    (r'\bangit\b', 'ango'),
    (r'\bAngitiae\b', 'Angitia'),
    (r'\bAngitiam\b', 'Angitia'),
    (r'\bangitque\b', 'ango'),
    (r'\bangitur\b', 'ango'),
    (r'\bangor\b', 'angor'),
    (r'\bangor\b', 'ango'),
    (r'\bangore\b', 'angor'),
    (r'\bangorem\b', 'angor'),
    (r'\bangores\b', 'angor'),
    (r'\bangori\b', 'angor'),
    (r'\bangoribus\b', 'angor'),
    (r'\bangoris\b', 'angor'),
    (r'\bAngrivarii\b', 'Angrivarii'),
    (r'\bAngrivariis\b', 'Angrivarii'),
    (r'\bAngrivariorum\b', 'Angrivarii'),
    (r'\bAngrivarios\b', 'Angrivarii'),
    (r'\bangue\b', 'anguis'),
    (r'\banguem\b', 'anguis'),
    (r'\banguemque\b', 'anguis'),
    (r'\bangues\b', 'anguis'),
    (r'\banguesque\b', 'anguis'),
    (r'\bangui\b', 'anguis'),
    (r'\banguibus\b', 'anguis'),
    (r'\banguibusque\b', 'anguis'),
    (r'\banguicomae\b', 'anguicomus'),
    (r'\banguicomam\b', 'anguicomus'),
    (r'\banguiculos\b', 'anguiculus'),
    (r'\banguifer\b', 'anguifer'),
    (r'\banguifera\b', 'anguifer'),
    (r'\banguiferae\b', 'anguifer'),
    (r'\banguiferamque\b', 'anguifer'),
    (r'\banguiferumque\b', 'anguifer'),
    (r'\banguigenae\b', 'anguigena'),
    (r'\banguilla\b', 'anguilla'),
    (r'\banguillae\b', 'anguilla'),
    (r'\banguillam\b', 'anguilla'),
    (r'\banguillarum\b', 'anguilla'),
    (r'\banguillas\b', 'anguilla'),
    (r'\banguillast\b', 'anguilla'),
    (r'\banguillis\b', 'anguilla'),
    (r'\banguimanus\b', 'anguimanus'),
    (r'\banguina\b', 'anguinus'),
    (r'\banguina\b', 'anguinus'),
    (r'\banguinae\b', 'anguinus'),
    (r'\banguinam\b', 'anguinus'),
    (r'\banguinea\b', 'anguineus'),
    (r'\banguinei\b', 'anguineus'),
    (r'\banguineis\b', 'anguineus'),
    (r'\banguinis\b', 'anguinus'),
    (r'\banguinis\b', 'anguinus'),
    (r'\banguino\b', 'anguinus'),
    (r'\banguino\b', 'anguinus'),
    (r'\banguinum\b', 'anguinus'),
    (r'\banguinum\b', 'anguinus'),
    (r'\banguinus\b', 'anguinus'),
    (r'\banguis\b', 'anguis'),
    (r'\banguisque\b', 'anguis'),
    (r'\banguitenens\b', 'anguitenens'),
    (r'\banguitenentis\b', 'anguitenens'),
    (r'\banguium\b', 'anguis'),
    (r'\bangularem\b', 'angulo'),
    (r'\bangularem\b', 'angularis'),
    (r'\bangulares\b', 'angulo'),
    (r'\bangulares\b', 'angularis'),
    (r'\bangulari\b', 'angularis'),
    (r'\bangulari\b', 'angulo'),
    (r'\bangularia\b', 'angularis'),
    (r'\bangularibus\b', 'angularis'),
    (r'\bangularis\b', 'angularis'),
    (r'\bangularis\b', 'angulo'),
    (r'\bangularium\b', 'angularis'),
    (r'\bangulata\b', 'angulo'),
    (r'\bangulatam\b', 'angulo'),
    (r'\bangulatim\b', 'angulatim'),
    (r'\bangulavit\b', 'angulo'),
    (r'\banguli\b', 'angulus'),
    (r'\bangulis\b', 'angulus'),
    (r'\bangulisque\b', 'angulus'),
    (r'\bangulo\b', 'angulus'),
    (r'\bangulo\b', 'angulo'),
    (r'\bangulorum\b', 'angulus'),
    (r'\bangulorumque\b', 'angulus'),
    (r'\bangulos\b', 'angulus'),
    (r'\bangulosa\b', 'angulosus'),
    (r'\bangulosi\b', 'angulosus'),
    (r'\bangulosis\b', 'angulosus'),
    (r'\banguloso\b', 'angulosus'),
    (r'\bangulosos\b', 'angulosus'),
    (r'\bangulosque\b', 'angulus'),
    (r'\bangulosus\b', 'angulosus'),
    (r'\bangulum\b', 'angulus'),
    (r'\bangulus\b', 'angulus'),
    (r'\bangunt\b', 'ango'),
    (r'\banguntque\b', 'ango'),
    (r'\banguntur\b', 'ango'),
    (r'\bangusta\b', 'angustus'),
    (r'\bangusta\b', 'angustus'),
    (r'\bangusta\b', 'angusto'),
    (r'\bangustabatur\b', 'angusto'),
    (r'\bangustabitur\b', 'angusto'),
    (r'\bangustae\b', 'angustus'),
    (r'\bangustaeque\b', 'angustus'),
    (r'\bangustam\b', 'angustus'),
    (r'\bangustanda\b', 'angusto'),
    (r'\bangustans\b', 'angusto'),
    (r'\bangustant\b', 'angusto'),
    (r'\bangustantibus\b', 'angusto'),
    (r'\bangustaque\b', 'angustus'),
    (r'\bangustaque\b', 'angustus'),
    (r'\bangustaque\b', 'angusto'),
    (r'\bangustare\b', 'angusto'),
    (r'\bangustaret\b', 'angusto'),
    (r'\bangustas\b', 'angustus'),
    (r'\bangustas\b', 'angusto'),
    (r'\bangustasque\b', 'angustus'),
    (r'\bangustasque\b', 'angusto'),
    (r'\bangustast\b', 'angustus'),
    (r'\bangustast\b', 'angustus'),
    (r'\bangustast\b', 'angusto'),
    (r'\bangustat\b', 'angusto'),
    (r'\bangustata\b', 'angusto'),
    (r'\bangustate\b', 'angusto'),
    (r'\bangustatus\b', 'angusto'),
    (r'\bangustaverunt\b', 'angusto'),
    (r'\banguste\b', 'angustus'),
    (r'\banguste\b', 'angustus'),
    (r'\bangusteque\b', 'angustus'),
    (r'\bangusteque\b', 'angustus'),
    (r'\bangustet\b', 'angusto'),
    (r'\bangusti\b', 'angustus'),
    (r'\bangusti\b', 'angustus'),
    (r'\bangustia\b', 'angustia'),
    (r'\bangustia\b', 'angustio'),
    (r'\bangustiae\b', 'angustia'),
    (r'\bangustiam\b', 'angustia'),
    (r'\bangustiamini\b', 'angustio'),
    (r'\bangustiamur\b', 'angustio'),
    (r'\bangustianti\b', 'angustio'),
    (r'\bangustiaretur\b', 'angustio'),
    (r'\bangustiarum\b', 'angustia'),
    (r'\bangustias\b', 'angustia'),
    (r'\bangustias\b', 'angustio'),
    (r'\bangustiasque\b', 'angustia'),
    (r'\bangustiasque\b', 'angustio'),
    (r'\bangustiati\b', 'angustio'),
    (r'\bangustiatus\b', 'angustio'),
    (r'\bangustiavit\b', 'angustio'),
    (r'\bangusticlauius\b', 'angusticlavius'),
    (r'\bangustiis\b', 'angustia'),
    (r'\bangustior\b', 'angustus'),
    (r'\bangustior\b', 'angustio'),
    (r'\bangustiora\b', 'angustus'),
    (r'\bangustioraque\b', 'angustus'),
    (r'\bangustiore\b', 'angustus'),
    (r'\bangustiorem\b', 'angustus'),
    (r'\bangustiores\b', 'angustus'),
    (r'\bangustioribus\b', 'angustus'),
    (r'\bangustioris\b', 'angustus'),
    (r'\bangustique\b', 'angustus'),
    (r'\bangustique\b', 'angustus'),
    (r'\bangustis\b', 'angustus'),
    (r'\bangustis\b', 'angustus'),
    (r'\bangustisque\b', 'angustus'),
    (r'\bangustisque\b', 'angustus'),
    (r'\bangustissima\b', 'angustus'),
    (r'\bangustissimae\b', 'angustus'),
    (r'\bangustissimam\b', 'angustus'),
    (r'\bangustissimas\b', 'angustus'),
    (r'\bangustissime\b', 'angustus'),
    (r'\bangustissimis\b', 'angustus'),
    (r'\bangustissimo\b', 'angustus'),
    (r'\bangustissimos\b', 'angustus'),
    (r'\bangustissimum\b', 'angustus'),
    (r'\bangustissimus\b', 'angustus'),
    (r'\bangustitatem\b', 'angustitas'),
    (r'\bangustius\b', 'angustus'),
    (r'\bangustiusque\b', 'angustus'),
    (r'\bangusto\b', 'angustus'),
    (r'\bangusto\b', 'angustus'),
    (r'\bangusto\b', 'angusto'),
    (r'\bangustoque\b', 'angustus'),
    (r'\bangustoque\b', 'angustus'),
    (r'\bangustoque\b', 'angusto'),
    (r'\bangustos\b', 'angustus'),
    (r'\bangustosque\b', 'angustus'),
    (r'\bangustum\b', 'angustus'),
    (r'\bangustum\b', 'angustus'),
    (r'\bangustumque\b', 'angustus'),
    (r'\bangustumque\b', 'angustus'),
    (r'\bangustus\b', 'angustus'),
    (r'\banhela\b', 'anhelus'),
    (r'\banhela\b', 'anhelo'),
    (r'\banhelabant\b', 'anhelo'),
    (r'\banhelabat\b', 'anhelo'),
    (r'\banhelae\b', 'anhelus'),
    (r'\banhelam\b', 'anhelus'),
    (r'\banhelamus\b', 'anhelo'),
    (r'\banhelandi\b', 'anhelo'),
    (r'\banhelans\b', 'anhelo'),
    (r'\banhelant\b', 'anhelo'),
    (r'\banhelante\b', 'anhelo'),
    (r'\banhelantem\b', 'anhelo'),
    (r'\banhelantemque\b', 'anhelo'),
    (r'\banhelantes\b', 'anhelo'),
    (r'\banhelantesque\b', 'anhelo'),
    (r'\banhelanti\b', 'anhelo'),
    (r'\banhelantibus\b', 'anhelo'),
    (r'\banhelantis\b', 'anhelo'),
    (r'\banhelare\b', 'anhelo'),
    (r'\banhelarent\b', 'anhelo'),
    (r'\banhelas\b', 'anhelus'),
    (r'\banhelas\b', 'anhelo'),
    (r'\banhelat\b', 'anhelo'),
    (r'\banhelata\b', 'anhelo'),
    (r'\banhelatio\b', 'anhelatio'),
    (r'\banhelatione\b', 'anhelatio'),
    (r'\banhelationibus\b', 'anhelatio'),
    (r'\banhelatis\b', 'anhelo'),
    (r'\banhelatori\b', 'anhelator'),
    (r'\banhelatoribus\b', 'anhelator'),
    (r'\banhelatos\b', 'anhelo'),
    (r'\banhelatum\b', 'anhelo'),
    (r'\banhelent\b', 'anhelo'),
    (r'\banheles\b', 'anhelo'),
    (r'\banhelet\b', 'anhelo'),
    (r'\banheli\b', 'anhelus'),
    (r'\banhelis\b', 'anhelus'),
    (r'\banhelitu\b', 'anhelitus'),
    (r'\banhelitum\b', 'anhelitus'),
    (r'\banhelitune\b', 'anhelitus'),
    (r'\banhelitus\b', 'anhelitus'),
    (r'\banhelo\b', 'anhelus'),
    (r'\banhelo\b', 'anhelo'),
    (r'\banhelos\b', 'anhelus'),
    (r'\banhelum\b', 'anhelus'),
    (r'\banhelus\b', 'anhelus'),
    (r'\banhydros\b', 'anhydros1'),
    (r'\bAnhydros\b', 'Anhydros2'),
    (r'\bani\b', 'anus1'),
    (r'\bAni\b', 'a-nitor1'),
    (r'\baniatrologetus\b', 'aniatrologetus'),
    (r'\banibus\b', 'anus3'),
    (r'\bAnicato\b', 'Anicianus'),
    (r'\bAnici\b', 'anicula'),
    (r'\banici\b', 'anicula'),
    (r'\bAnicia\b', 'Anicianus'),
    (r'\bAniciana\b', 'Anicianus'),
    (r'\bAnicianae\b', 'Anicianus'),
    (r'\bAnicianam\b', 'Anicianus'),
    (r'\bAnicianis\b', 'Anicianus'),
    (r'\bAnicianum\b', 'Anicianus'),
    (r'\bAnicii\b', 'anicula'),
    (r'\banicilla\b', 'anicilla'),
    (r'\bAnicio\b', 'anicula'),
    (r'\bAnicium\b', 'anicula'),
    (r'\bAnicius\b', 'anicula'),
    (r'\banicula\b', 'anicula'),
    (r'\baniculae\b', 'anicula'),
    (r'\baniculam\b', 'anicula'),
    (r'\banicularum\b', 'anicula'),
    (r'\baniculis\b', 'anicula'),
    (r'\bAnien\b', 'a-nitor1'),
    (r'\bAniena\b', 'Anienus2'),
    (r'\bAnienaque\b', 'Anienus2'),
    (r'\bAniene\b', 'Anienus2'),
    (r'\bAnieni\b', 'Anienus2'),
    (r'\bAnienicolae\b', 'Anienicola'),
    (r'\bAnienicolis\b', 'Anienicola'),
    (r'\bAnienis\b', 'Anienus2'),
    (r'\bAniensem\b', 'Aniensis'),
    (r'\bAniensi\b', 'Aniensis'),
    (r'\bAniensis\b', 'Aniensis'),
    (r'\bAnigrum\b', 'Anigros'),
    (r'\bAnii\b', 'a-nitor1'),
    (r'\banile\b', 'anilis'),
    (r'\banilem\b', 'anilis'),
    (r'\baniles\b', 'anilis'),
    (r'\banili\b', 'anilis'),
    (r'\banilia\b', 'anilis'),
    (r'\banilibus\b', 'anilis'),
    (r'\banilibusque\b', 'anilis'),
    (r'\banilis\b', 'anilis'),
    (r'\banilitari\b', 'anilitor'),
    (r'\banilitas\b', 'anilitas'),
    (r'\baniliter\b', 'anilis'),
    (r'\baniliter\b', 'aniliter'),
    (r'\baniliter\b', 'anilitor'),
    (r'\banima\b', 'anima'),
    (r'\banima\b', 'animo'),
    (r'\banimadversa\b', 'animadverto'),
    (r'\banimadversae\b', 'animadverto'),
    (r'\banimadversi\b', 'animadverto'),
    (r'\banimadversio\b', 'animadversio'),
    (r'\banimadversione\b', 'animadversio'),
    (r'\banimadversionem\b', 'animadversio'),
    (r'\banimadversiones\b', 'animadversio'),
    (r'\banimadversionesque\b', 'animadversio'),
    (r'\banimadversioni\b', 'animadversio'),
    (r'\banimadversionibus\b', 'animadversio'),
    (r'\banimadversionis\b', 'animadversio'),
    (r'\banimadversionum\b', 'animadversio'),
    (r'\banimadversis\b', 'animadverto'),
    (r'\banimadverso\b', 'animadverto'),
    (r'\banimadversoresque\b', 'animadversor'),
    (r'\banimadversum\b', 'animadverto'),
    (r'\banimadversumque\b', 'animadverto'),
    (r'\banimadversurus\b', 'animadverto'),
    (r'\banimadvertam\b', 'animadverto'),
    (r'\banimadvertamus\b', 'animadverto'),
    (r'\banimadvertant\b', 'animadverto'),
    (r'\banimadvertas\b', 'animadverto'),
    (r'\banimadvertat\b', 'animadverto'),
    (r'\banimadvertatur\b', 'animadverto'),
    (r'\banimadverte\b', 'animadverto'),
    (r'\banimadvertebam\b', 'animadverto'),
    (r'\banimadvertebant\b', 'animadverto'),
    (r'\banimadvertebantur\b', 'animadverto'),
    (r'\banimadvertebas\b', 'animadverto'),
    (r'\banimadvertebat\b', 'animadverto'),
    (r'\banimadvertemus\b', 'animadverto'),
    (r'\banimadvertenda\b', 'animadverto'),
    (r'\banimadvertendae\b', 'animadverto'),
    (r'\banimadvertendam\b', 'animadverto'),
    (r'\banimadvertendas\b', 'animadverto'),
    (r'\banimadvertendi\b', 'animadverto'),
    (r'\banimadvertendis\b', 'animadverto'),
    (r'\banimadvertendisque\b', 'animadverto'),
    (r'\banimadvertendo\b', 'animadverto'),
    (r'\banimadvertendum\b', 'animadverto'),
    (r'\banimadvertendus\b', 'animadverto'),
    (r'\banimadvertens\b', 'animadverto'),
    (r'\banimadvertensque\b', 'animadverto'),
    (r'\banimadvertentem\b', 'animadverto'),
    (r'\banimadverteram\b', 'animadverto'),
    (r'\banimadverterant\b', 'animadverto'),
    (r'\banimadverterat\b', 'animadverto'),
    (r'\banimadvertere\b', 'animadverto'),
    (r'\banimadverterem\b', 'animadverto'),
    (r'\banimadverterent\b', 'animadverto'),
    (r'\banimadverterentque\b', 'animadverto'),
    (r'\banimadverterentur\b', 'animadverto'),
    (r'\banimadverteres\b', 'animadverto'),
    (r'\banimadverterest\b', 'animadverto'),
    (r'\banimadverteret\b', 'animadverto'),
    (r'\banimadverteretque\b', 'animadverto'),
    (r'\banimadverteretur\b', 'animadverto'),
    (r'\banimadverterim\b', 'animadverto'),
    (r'\banimadverterimus\b', 'animadverto'),
    (r'\banimadverterint\b', 'animadverto'),
    (r'\banimadverteris\b', 'animadverto'),
    (r'\banimadverterit\b', 'animadverto'),
    (r'\banimadverterunt\b', 'animadverto'),
    (r'\banimadvertes\b', 'animadverto'),
    (r'\banimadvertet\b', 'animadverto'),
    (r'\banimadvertetur\b', 'animadverto'),
    (r'\banimadverti\b', 'animadverto'),
    (r'\banimadvertimus\b', 'animadverto'),
    (r'\banimadvertique\b', 'animadverto'),
    (r'\banimadvertis\b', 'animadverto'),
    (r'\banimadvertisse\b', 'animadverto'),
    (r'\banimadvertissem\b', 'animadverto'),
    (r'\banimadvertissent\b', 'animadverto'),
    (r'\banimadvertisset\b', 'animadverto'),
    (r'\banimadvertissetque\b', 'animadverto'),
    (r'\banimadvertisti\b', 'animadverto'),
    (r'\banimadvertistis\b', 'animadverto'),
    (r'\banimadvertit\b', 'animadverto'),
    (r'\banimadvertite\b', 'animadverto'),
    (r'\banimadvertitis\b', 'animadverto'),
    (r'\banimadvertito\b', 'animadverto'),
    (r'\banimadvertitur\b', 'animadverto'),
    (r'\banimadverto\b', 'animadverto'),
    (r'\banimadvertunt\b', 'animadverto'),
    (r'\banimadvertuntque\b', 'animadverto'),
    (r'\banimadvertuntur\b', 'animadverto'),
    (r'\banimae\b', 'anima'),
    (r'\banimaeque\b', 'animaequus'),
    (r'\banimaequior\b', 'animaequus'),
    (r'\banimaequiores\b', 'animaequus'),
    (r'\banimai\b', 'anima'),
    (r'\banimaist\b', 'anima'),
    (r'\banimal\b', 'animal'),
    (r'\banimale\b', 'animal'),
    (r'\banimale\b', 'animalis'),
    (r'\banimalem\b', 'animalis'),
    (r'\banimales\b', 'animalis'),
    (r'\banimali\b', 'animalis'),
    (r'\banimali\b', 'animal'),
    (r'\banimalia\b', 'animalis'),
    (r'\banimalibus\b', 'animalis'),
    (r'\banimalibus\b', 'animal'),
    (r'\banimalibusque\b', 'animalis'),
    (r'\banimalibusque\b', 'animal'),
    (r'\banimalique\b', 'animalis'),
    (r'\banimalique\b', 'animal'),
    (r'\banimalis\b', 'animalis'),
    (r'\banimalis\b', 'animal'),
    (r'\banimalium\b', 'animalis'),
    (r'\banimaliumque\b', 'animalis'),
    (r'\banimam\b', 'anima'),
    (r'\banimamque\b', 'anima'),
    (r'\banimamus\b', 'animo'),
    (r'\banimans\b', 'animo'),
    (r'\banimante\b', 'animo'),
    (r'\banimantem\b', 'animo'),
    (r'\banimantes\b', 'animo'),
    (r'\banimantesque\b', 'animo'),
    (r'\banimanti\b', 'animo'),
    (r'\banimantia\b', 'animo'),
    (r'\banimantibus\b', 'animo'),
    (r'\banimantis\b', 'animo'),
    (r'\banimantium\b', 'animo'),
    (r'\banimantur\b', 'animo'),
    (r'\banimaque\b', 'anima'),
    (r'\banimaque\b', 'animo'),
    (r'\banimare\b', 'animo'),
    (r'\banimarent\b', 'animo'),
    (r'\banimarentur\b', 'animo'),
    (r'\banimaretur\b', 'animo'),
    (r'\banimari\b', 'animo'),
    (r'\banimarum\b', 'anima'),
    (r'\banimarumque\b', 'anima'),
    (r'\banimas\b', 'anima'),
    (r'\banimas\b', 'animo'),
    (r'\banimasque\b', 'anima'),
    (r'\banimasque\b', 'animo'),
    (r'\banimasse\b', 'animo'),
    (r'\banimast\b', 'anima'),
    (r'\banimast\b', 'animo'),
    (r'\banimat\b', 'animo'),
    (r'\banimata\b', 'animo'),
    (r'\banimatae\b', 'animo'),
    (r'\banimatam\b', 'animo'),
    (r'\banimatas\b', 'animo'),
    (r'\banimati\b', 'animo'),
    (r'\banimationis\b', 'animatio'),
    (r'\banimatis\b', 'animo'),
    (r'\banimato\b', 'animo'),
    (r'\banimatos\b', 'animo'),
    (r'\banimatu\b', 'animatus2'),
    (r'\banimatu\b', 'animo'),
    (r'\banimatum\b', 'animatus2'),
    (r'\banimatum\b', 'animo'),
    (r'\banimatur\b', 'animo'),
    (r'\banimatus\b', 'animatus2'),
    (r'\banimatus\b', 'animo'),
    (r'\banimatust\b', 'animatus2'),
    (r'\banimatust\b', 'animo'),
    (r'\banimauit\b', 'animo'),
    (r'\banimavit\b', 'animo'),
    (r'\banime\b', 'animus'),
    (r'\banimentur\b', 'animo'),
    (r'\banimi\b', 'animus'),
    (r'\banimine\b', 'animus'),
    (r'\banimique\b', 'animus'),
    (r'\banimis\b', 'anima'),
    (r'\banimis\b', 'animus'),
    (r'\banimisque\b', 'anima'),
    (r'\banimisque\b', 'animus'),
    (r'\banimist\b', 'anima'),
    (r'\banimist\b', 'animus'),
    (r'\banimive\b', 'animus'),
    (r'\banimo\b', 'animus'),
    (r'\banimo\b', 'animo'),
    (r'\banimone\b', 'animus'),
    (r'\banimone\b', 'animo'),
    (r'\banimoque\b', 'animus'),
    (r'\banimoque\b', 'animo'),
    (r'\banimorum\b', 'animus'),
    (r'\banimorumque\b', 'animus'),
    (r'\banimos\b', 'animus'),
    (r'\banimosa\b', 'animosus1'),
    (r'\banimosae\b', 'animosus1'),
    (r'\banimosam\b', 'animosus1'),
    (r'\banimosaque\b', 'animosus1'),
    (r'\banimosas\b', 'animosus1'),
    (r'\banimose\b', 'animosus1'),
    (r'\banimoseque\b', 'animosus1'),
    (r'\banimosi\b', 'animosus1'),
    (r'\banimosior\b', 'animosus1'),
    (r'\banimosiorem\b', 'animosus1'),
    (r'\banimosique\b', 'animosus1'),
    (r'\banimosissime\b', 'animosus1'),
    (r'\banimositas\b', 'animositas'),
    (r'\banimositatem\b', 'animositas'),
    (r'\banimositates\b', 'animositas'),
    (r'\banimositatis\b', 'animositas'),
    (r'\banimosius\b', 'animosus1'),
    (r'\banimosne\b', 'animus'),
    (r'\banimoso\b', 'animosus1'),
    (r'\banimosos\b', 'animosus1'),
    (r'\banimosque\b', 'animus'),
    (r'\banimost\b', 'animus'),
    (r'\banimost\b', 'animo'),
    (r'\banimosum\b', 'animosus1'),
    (r'\banimosus\b', 'animosus1'),
    (r'\banimove\b', 'animus'),
    (r'\banimove\b', 'animo'),
    (r'\banimula\b', 'animula1'),
    (r'\banimulae\b', 'animula1'),
    (r'\banimulas\b', 'animula1'),
    (r'\banimule\b', 'animulus'),
    (r'\banimum\b', 'animus'),
    (r'\banimumque\b', 'animus'),
    (r'\banimumue\b', 'animus'),
    (r'\banimus\b', 'animus'),
    (r'\banimusne\b', 'animus'),
    (r'\banimusque\b', 'animus'),
    (r'\banimusquest\b', 'animus'),
    (r'\banimust\b', 'animus'),
    (r'\bAnio\b', 'a-nitor1'),
    (r'\bAnione\b', 'a-nitor1'),
    (r'\banis\b', 'anus1'),
    (r'\baniso\b', 'anisum'),
    (r'\banisocyclorum\b', 'anisocycla'),
    (r'\banisus\b', 'a-nitor1'),
    (r'\banites\b', 'a-nitor1'),
    (r'\bAnium\b', 'a-nitor1'),
    (r'\bAnius\b', 'a-nitor1'),
    (r'\bann\b', 'an'),
    (r'\bAnna\b', 'Anna1'),
    (r'\banna\b', 'adnato'),
    (r'\bAnnae\b', 'Anna1'),
    (r'\bAnnaea\b', 'annalia'),
    (r'\bAnnaee\b', 'annalia'),
    (r'\bAnnaei\b', 'annalia'),
    (r'\bAnnaeo\b', 'annalia'),
    (r'\bAnnaeoque\b', 'annalia'),
    (r'\bAnnaeum\b', 'annalia'),
    (r'\bAnnaeus\b', 'annalia'),
    (r'\bannale\b', 'annalis'),
    (r'\bannalem\b', 'annalis'),
    (r'\bannales\b', 'annalis'),
    (r'\bannali\b', 'annalis'),
    (r'\bannalia\b', 'annalia'),
    (r'\bannalibus\b', 'annalis'),
    (r'\bannalibus\b', 'annalia'),
    (r'\bannalis\b', 'annalis'),
    (r'\bannalium\b', 'annalis'),
    (r'\bannalium\b', 'annalia'),
    (r'\bAnnam\b', 'Anna1'),
    (r'\bannariae\b', 'annarius'),
    (r'\bAnnas\b', 'Anna1'),
    (r'\bannas\b', 'adnato'),
    (r'\bannatant\b', 'adnato'),
    (r'\banne\b', 'anne'),
    (r'\banne\b', 'annus'),
    (r'\bannectat\b', 'adnecto'),
    (r'\bannecteretque\b', 'adnecto'),
    (r'\bAnnei\b', 'annexio'),
    (r'\bAnnei\b', 'Anneius'),
    (r'\bAnneio\b', 'Anneius'),
    (r'\bAnneium\b', 'Anneius'),
    (r'\bAnneius\b', 'Anneius'),
    (r'\bannes\b', 'anne'),
    (r'\bannes\b', 'adnato'),
    (r'\bAnneum\b', 'annexio'),
    (r'\bannexum\b', 'annexus2'),
    (r'\bannexum\b', 'adnecto'),
    (r'\banni\b', 'annus'),
    (r'\bAnni\b', 'Annius'),
    (r'\bAnnia\b', 'Annianus'),
    (r'\bAnniae\b', 'Annianus'),
    (r'\bAnniam\b', 'Annianus'),
    (r'\bAnniana\b', 'Annianus'),
    (r'\bAnniane\b', 'Annianus'),
    (r'\bAnniano\b', 'Annianus'),
    (r'\bAnnianus\b', 'Annianus'),
    (r'\bAnnicerii\b', 'Annicerii'),
    (r'\bannicula\b', 'anniculus'),
    (r'\banniculae\b', 'anniculus'),
    (r'\banniculam\b', 'anniculus'),
    (r'\banniculasque\b', 'anniculus'),
    (r'\banniculi\b', 'anniculus'),
    (r'\banniculis\b', 'anniculus'),
    (r'\banniculo\b', 'anniculus'),
    (r'\banniculos\b', 'anniculus'),
    (r'\banniculum\b', 'anniculus'),
    (r'\banniculus\b', 'anniculus'),
    (r'\bAnnii\b', 'Annius'),
    (r'\bAnnio\b', 'Annius'),
    (r'\bAnnios\b', 'Annius'),
    (r'\bannique\b', 'annus'),
    (r'\bAnnis\b', 'Anna1'),
    (r'\bannis\b', 'annus'),
    (r'\bannisque\b', 'annus'),
    (r'\banniti\b', 'annitor'),
    (r'\banniuersaria\b', 'anniversarius'),
    (r'\banniuersarias\b', 'anniversarius'),
    (r'\banniuersarii\b', 'anniversarius'),
    (r'\banniuersariis\b', 'anniversarius'),
    (r'\banniuersario\b', 'anniversarius'),
    (r'\banniuersarios\b', 'anniversarius'),
    (r'\banniuersarium\b', 'anniversarius'),
    (r'\bAnnium\b', 'Annius'),
    (r'\bAnnius\b', 'Annius'),
    (r'\banniversaria\b', 'anniversarius'),
    (r'\banniversariam\b', 'anniversarius'),
    (r'\banniversarias\b', 'anniversarius'),
    (r'\banniversarii\b', 'anniversarius'),
    (r'\banniversariis\b', 'anniversarius'),
    (r'\banniversario\b', 'anniversarius'),
    (r'\banniversarios\b', 'anniversarius'),
    (r'\banniversariosque\b', 'anniversarius'),
    (r'\banniversarium\b', 'anniversarius'),
    (r'\banno\b', 'annus'),
    (r'\banno\b', 'adnato'),
    (r'\bannodes\b', 'annodo'),
    (r'\bannon\b', 'annus'),
    (r'\bannon\b', 'adnato'),
    (r'\bannona\b', 'annona'),
    (r'\bannonae\b', 'annona'),
    (r'\bannonaeque\b', 'annona'),
    (r'\bannonam\b', 'annona'),
    (r'\bannonamque\b', 'annona'),
    (r'\bannonaque\b', 'annona'),
    (r'\bannonari\b', 'annonarius'),
    (r'\bannonari\b', 'annonor'),
    (r'\bannonaria\b', 'annonarius'),
    (r'\bannonariam\b', 'annonarius'),
    (r'\bannonarum\b', 'annona'),
    (r'\bannonas\b', 'annona'),
    (r'\bannonast\b', 'annona'),
    (r'\bannonis\b', 'annona'),
    (r'\bannoque\b', 'annus'),
    (r'\bannoque\b', 'adnato'),
    (r'\bannorum\b', 'annus'),
    (r'\bannorumque\b', 'annus'),
    (r'\bannorumve\b', 'annus'),
    (r'\bannos\b', 'annus'),
    (r'\bannosa\b', 'annosus'),
    (r'\bannosae\b', 'annosus'),
    (r'\bannosam\b', 'annosus'),
    (r'\bannosaque\b', 'annosus'),
    (r'\bannosas\b', 'annosus'),
    (r'\bannosasque\b', 'annosus'),
    (r'\bannosi\b', 'annosus'),
    (r'\bannosis\b', 'annosus'),
    (r'\bannoso\b', 'annosus'),
    (r'\bannosque\b', 'annus'),
    (r'\bannosue\b', 'annus'),
    (r'\bannosum\b', 'annosus'),
    (r'\bannosus\b', 'annosus'),
    (r'\bannotabam\b', 'annoto'),
    (r'\bannotabis\b', 'annoto'),
    (r'\bannotandum\b', 'annoto'),
    (r'\bannotare\b', 'annoto'),
    (r'\bannotationibus\b', 'annotatio'),
    (r'\bannotauit\b', 'annoto'),
    (r'\bannotinas\b', 'annotinus'),
    (r'\bannotinis\b', 'annotinus'),
    (r'\bannotino\b', 'annotinus'),
    (r'\bannotinos\b', 'annotinus'),
    (r'\bannua\b', 'annuus'),
    (r'\bannua\b', 'annualis'),
    (r'\bannuae\b', 'annuus'),
    (r'\bannuali\b', 'annualis'),
    (r'\bannuam\b', 'annuus'),
    (r'\bannuam\b', 'annuo'),
    (r'\bannuaque\b', 'annuus'),
    (r'\bannuaque\b', 'annualis'),
    (r'\bannuas\b', 'annuus'),
    (r'\bannuas\b', 'annuo'),
    (r'\bannuat\b', 'annuo'),
    (r'\bannue\b', 'annuus'),
    (r'\bannue\b', 'annuus'),
    (r'\bannue\b', 'annuo'),
    (r'\bannuendo\b', 'annuo'),
    (r'\bannuens\b', 'annuo'),
    (r'\bannuente\b', 'annuo'),
    (r'\bannuere\b', 'annuo'),
    (r'\bannuerint\b', 'annuo'),
    (r'\bannueritque\b', 'annuo'),
    (r'\bannuerunt\b', 'annuo'),
    (r'\bannui\b', 'annuus'),
    (r'\bannui\b', 'annuus'),
    (r'\bannui\b', 'annuo'),
    (r'\bannuimus\b', 'annuo'),
    (r'\bannuis\b', 'annuus'),
    (r'\bannuis\b', 'annualis'),
    (r'\bannuis\b', 'annuo'),
    (r'\bannuisset\b', 'annuo'),
    (r'\bannuit\b', 'annuo'),
    (r'\bannulum\b', 'anulus1'),
    (r'\bannum\b', 'annus'),
    (r'\bannumque\b', 'annus'),
    (r'\bannun\b', 'annus'),
    (r'\bannuntiabant\b', 'annuntio'),
    (r'\bannuntiabat\b', 'annuntio'),
    (r'\bannuntiari\b', 'annuntio'),
    (r'\bannuntiasse\b', 'annuntio'),
    (r'\bannuntiat\b', 'annuntio'),
    (r'\bannuntiatis\b', 'annuntio'),
    (r'\bannuntiauerat\b', 'annuntio'),
    (r'\bannuntio\b', 'annuntius'),
    (r'\bannuntio\b', 'annuntio'),
    (r'\bannuo\b', 'annuus'),
    (r'\bannuo\b', 'annuus'),
    (r'\bannuo\b', 'annuo'),
    (r'\bannuos\b', 'annuus'),
    (r'\bannuosque\b', 'annuus'),
    (r'\bannus\b', 'annus'),
    (r'\bannuum\b', 'annuus'),
    (r'\bannuum\b', 'annualis'),
    (r'\bannuum\b', 'annuus'),
    (r'\bannuumque\b', 'annuus'),
    (r'\bannuumque\b', 'annualis'),
    (r'\bannuumque\b', 'annuus'),
    (r'\bannuunt\b', 'annuo'),
    (r'\bannuus\b', 'annuus'),
    (r'\bannvis\b', 'an'),
    (r'\bano\b', 'anus1'),
    (r'\banodyna\b', 'anodynon'),
    (r'\banomalia\b', 'anomalia'),
    (r'\banomaliam\b', 'anomalia'),
    (r'\banon\b', 'anus1'),
    (r'\banone\b', 'anus1'),
    (r'\banonymos\b', 'anonymos'),
    (r'\banorum\b', 'anus1'),
    (r'\banos\b', 'anus1'),
    (r'\banque\b', 'an'),
    (r'\banquina\b', 'anquina'),
    (r'\banquirat\b', 'anquiro'),
    (r'\banquirebant\b', 'anquiro'),
    (r'\banquirebantur\b', 'anquiro'),
    (r'\banquirendi\b', 'anquiro'),
    (r'\banquirendum\b', 'anquiro'),
    (r'\banquirens\b', 'anquiro'),
    (r'\banquirente\b', 'anquiro'),
    (r'\banquirentibus\b', 'anquiro'),
    (r'\banquirere\b', 'anquiro'),
    (r'\banquirerent\b', 'anquiro'),
    (r'\banquireret\b', 'anquiro'),
    (r'\banquiri\b', 'anquiro'),
    (r'\banquirit\b', 'anquiro'),
    (r'\banquiritur\b', 'anquiro'),
    (r'\banquirunt\b', 'anquiro'),
    (r'\banquisissent\b', 'anquiro'),
    (r'\banquisisset\b', 'anquiro'),
    (r'\banquisitionis\b', 'anquisitio'),
    (r'\bansa\b', 'ansa'),
    (r'\bansae\b', 'ansa'),
    (r'\bansam\b', 'ansa'),
    (r'\bansaque\b', 'ansa'),
    (r'\bansarum\b', 'ansa'),
    (r'\bansas\b', 'ansa'),
    (r'\bansatae\b', 'ansatus'),
    (r'\bansatas\b', 'ansatus'),
    (r'\bansati\b', 'ansatus'),
    (r'\bansatis\b', 'ansatus'),
    (r'\bansatum\b', 'ansatus'),
    (r'\bansatus\b', 'ansatus'),
    (r'\bAnser\b', 'Anser2'),
    (r'\banser\b', 'anser1'),
    (r'\banserculis\b', 'anserculus'),
    (r'\bAnsere\b', 'Anser2'),
    (r'\bansere\b', 'anser1'),
    (r'\bAnserem\b', 'Anser2'),
    (r'\banserem\b', 'anser1'),
    (r'\bAnseres\b', 'Anser2'),
    (r'\banseres\b', 'anser1'),
    (r'\bAnseri\b', 'Anser2'),
    (r'\banseri\b', 'anser1'),
    (r'\bAnseribus\b', 'Anser2'),
    (r'\banseribus\b', 'anser1'),
    (r'\banserina\b', 'anserinus'),
    (r'\banserinae\b', 'anserinus'),
    (r'\banserinam\b', 'anserinus'),
    (r'\banserini\b', 'anserinus'),
    (r'\banserinis\b', 'anserinus'),
    (r'\banserino\b', 'anserinus'),
    (r'\banserinos\b', 'anserinus'),
    (r'\banserinum\b', 'anserinus'),
    (r'\banserinus\b', 'anserinus'),
    (r'\banseris\b', 'anser1'),
    (r'\banserisque\b', 'anser1'),
    (r'\banserum\b', 'anser1'),
    (r'\bansis\b', 'ansa'),
    (r'\bansulae\b', 'ansula'),
    (r'\bansulam\b', 'ansula'),
    (r'\bansulas\b', 'ansula'),
    (r'\bansulis\b', 'ansula'),
    (r'\bantachates\b', 'antachates'),
    (r'\bantae\b', 'antae'),
    (r'\bAntaee\b', 'Antaeus'),
    (r'\bAntaei\b', 'Antaeus'),
    (r'\bAntaeique\b', 'Antaeus'),
    (r'\bAntaeo\b', 'Antaeus'),
    (r'\bAntaeopoliten\b', 'Antaeopolites'),
    (r'\bAntaeum\b', 'Antaeus'),
    (r'\bAntaeus\b', 'Antaeus'),
    (r'\bAntandri\b', 'Antandros'),
    (r'\bAntandri\b', 'Antandros'),
    (r'\bAntandrium\b', 'Antandros'),
    (r'\bAntandro\b', 'Antandros'),
    (r'\bAntandron\b', 'Antandros'),
    (r'\bAntandros\b', 'Antandros'),
    (r'\bAntandrum\b', 'Antandros'),
    (r'\bantapodosi\b', 'antapodosis'),
    (r'\bantapodosis\b', 'antapodosis'),
    (r'\bantarctico\b', 'antarcticus'),
    (r'\bantarcticum\b', 'antarcticus'),
    (r'\bantarcticus\b', 'antarcticus'),
    (r'\bantarii\b', 'antarius'),
    (r'\bantarium\b', 'antarius'),
    (r'\bantas\b', 'antae'),
    (r'\bante\b', 'ante'),
    (r'\bantea\b', 'antea'),
    (r'\banteacta\b', 'anteactus'),
    (r'\banteacta\b', 'anteambulo'),
    (r'\banteactae\b', 'anteactus'),
    (r'\banteactae\b', 'anteambulo'),
    (r'\banteambulo\b', 'anteambulo'),
    (r'\banteambulonem\b', 'anteambulo'),
    (r'\banteambulones\b', 'anteambulo'),
    (r'\banteambulonis\b', 'anteambulo'),
    (r'\bantecantamenta\b', 'antecantamentum'),
    (r'\bantecapere\b', 'antecapio'),
    (r'\bantecaperet\b', 'antecapio'),
    (r'\bantecapto\b', 'antecapio'),
    (r'\bantecapto\b', 'antecedo'),
    (r'\bantecedant\b', 'antecedo'),
    (r'\bantecedas\b', 'antecedo'),
    (r'\bantecedat\b', 'antecedo'),
    (r'\bantecedatis\b', 'antecedo'),
    (r'\bantecede\b', 'antecedo'),
    (r'\bantecedebant\b', 'antecedo'),
    (r'\bantecedebat\b', 'antecedo'),
    (r'\bantecedendo\b', 'antecedo'),
    (r'\bantecedens\b', 'antecedo'),
    (r'\bantecedent\b', 'antecedo'),
    (r'\bantecedente\b', 'antecedo'),
    (r'\bantecedentem\b', 'antecedo'),
    (r'\bantecedentes\b', 'antecedo'),
    (r'\bantecedenti\b', 'antecedo'),
    (r'\bantecedentia\b', 'antecedo'),
    (r'\bantecedentia\b', 'antecedo'),
    (r'\bantecedentibus\b', 'antecedo'),
    (r'\bantecedentis\b', 'antecedo'),
    (r'\bantecedentium\b', 'antecedo'),
    (r'\bantecedentium\b', 'antecedo'),
    (r'\bantecedere\b', 'antecedo'),
    (r'\bantecederent\b', 'antecedo'),
    (r'\bantecederet\b', 'antecedo'),
    (r'\bantecedes\b', 'antecedo'),
    (r'\bantecedet\b', 'antecedo'),
    (r'\bantecedimus\b', 'antecedo'),
    (r'\bantecedis\b', 'antecedo'),
    (r'\bantecedit\b', 'antecedo'),
    (r'\bantecedite\b', 'antecedo'),
    (r'\bantecedo\b', 'antecedo'),
    (r'\bantecedunt\b', 'antecedo'),
    (r'\bantecellant\b', 'antecello'),
    (r'\bantecellat\b', 'antecello'),
    (r'\bantecellebat\b', 'antecello'),
    (r'\bantecellens\b', 'antecello'),
    (r'\bantecellentem\b', 'antecello'),
    (r'\bantecellere\b', 'antecello'),
    (r'\bantecellerent\b', 'antecello'),
    (r'\bantecelleret\b', 'antecello'),
    (r'\bantecellet\b', 'antecello'),
    (r'\bantecellimus\b', 'antecello'),
    (r'\bantecellis\b', 'antecello'),
    (r'\bantecellit\b', 'antecello'),
    (r'\bantecellunt\b', 'antecello'),
    (r'\bantecelluntur\b', 'antecello'),
    (r'\bantecenia\b', 'antecenium'),
    (r'\banteceperat\b', 'antecapio'),
    (r'\banteceptam\b', 'antecapio'),
    (r'\bantecesserant\b', 'antecedo'),
    (r'\bantecesserat\b', 'antecedo'),
    (r'\bantecesserint\b', 'antecedo'),
    (r'\bantecesseris\b', 'antecedo'),
    (r'\bantecesseris\b', 'antecessor'),
    (r'\bantecesserit\b', 'antecedo'),
    (r'\bantecesserunt\b', 'antecedo'),
    (r'\bantecessimus\b', 'antecedo'),
    (r'\bantecessionem\b', 'antecessio'),
    (r'\bantecessiones\b', 'antecessio'),
    (r'\bantecessisse\b', 'antecedo'),
    (r'\bantecessissent\b', 'antecedo'),
    (r'\bantecessisset\b', 'antecedo'),
    (r'\bantecessisti\b', 'antecedo'),
    (r'\bantecessit\b', 'antecedo'),
    (r'\bantecessor\b', 'antecessor'),
    (r'\bantecessore\b', 'antecessor'),
    (r'\bantecessores\b', 'antecessor'),
    (r'\bantecessoribus\b', 'antecessor'),
    (r'\bantecessum\b', 'antecedo'),
    (r'\bantecessura\b', 'antecedo'),
    (r'\bantecessurae\b', 'antecedo'),
    (r'\bantecessus\b', 'antecedo'),
    (r'\bantecrescunt\b', 'antecurro'),
    (r'\bantecurrens\b', 'antecurro'),
    (r'\bantecursores\b', 'antecursor'),
    (r'\bantecursoribus\b', 'antecursor'),
    (r'\bantedictorum\b', 'antedico'),
    (r'\banteeunt\b', 'anteeo'),
    (r'\banteferam\b', 'antefero'),
    (r'\banteferat\b', 'antefero'),
    (r'\banteferatur\b', 'antefero'),
    (r'\banteferebat\b', 'antefero'),
    (r'\banteferendo\b', 'antefero'),
    (r'\banteferendus\b', 'antefero'),
    (r'\banteferre\b', 'antefero'),
    (r'\banteferrem\b', 'antefero'),
    (r'\banteferrent\b', 'antefero'),
    (r'\banteferrentur\b', 'antefero'),
    (r'\banteferres\b', 'antefero'),
    (r'\banteferret\b', 'antefero'),
    (r'\banteferretur\b', 'antefero'),
    (r'\banteferri\b', 'antefero'),
    (r'\bantefert\b', 'antefero'),
    (r'\bantefertur\b', 'antefero'),
    (r'\bantefixa\b', 'antefixus'),
    (r'\bantefixa\b', 'antefixus'),
    (r'\bantefixi\b', 'antefixus'),
    (r'\bantefixis\b', 'antefixus'),
    (r'\bantefixis\b', 'antefixus'),
    (r'\bantegenitali\b', 'antegenitalis'),
    (r'\bantegreditur\b', 'antegredior'),
    (r'\bantegressa\b', 'antegredior'),
    (r'\bantegressae\b', 'antegredior'),
    (r'\bantegressas\b', 'antegredior'),
    (r'\bantegressis\b', 'antegredior'),
    (r'\bantehabeant\b', 'antehabeo'),
    (r'\bantehabeo\b', 'antehabeo'),
    (r'\bantehabuerunt\b', 'antehabeo'),
    (r'\bantehac\b', 'antehac'),
    (r'\bantei\b', 'anteeo'),
    (r'\banteiam\b', 'anteeo'),
    (r'\banteibant\b', 'anteeo'),
    (r'\banteibat\b', 'anteeo'),
    (r'\banteibit\b', 'anteeo'),
    (r'\banteibo\b', 'anteeo'),
    (r'\banteibunt\b', 'anteeo'),
    (r'\banteiit\b', 'anteeo'),
    (r'\banteio\b', 'anteeo'),
    (r'\banteire\b', 'anteeo'),
    (r'\banteirent\b', 'anteeo'),
    (r'\banteirentur\b', 'anteeo'),
    (r'\banteires\b', 'anteeo'),
    (r'\banteiret\b', 'anteeo'),
    (r'\banteiretis\b', 'anteeo'),
    (r'\banteiri\b', 'anteeo'),
    (r'\banteis\b', 'anteeo'),
    (r'\banteisset\b', 'anteeo'),
    (r'\banteistis\b', 'anteeo'),
    (r'\banteit\b', 'anteeo'),
    (r'\bantelata\b', 'antefero'),
    (r'\bantelatae\b', 'antefero'),
    (r'\bantelati\b', 'antefero'),
    (r'\bantelatum\b', 'antefero'),
    (r'\bantelaturum\b', 'antefero'),
    (r'\bantelaturus\b', 'antefero'),
    (r'\bantelatus\b', 'antefero'),
    (r'\bantelogium\b', 'antelogium'),
    (r'\bantelucana\b', 'antelucanus'),
    (r'\bantelucana\b', 'antelucanus'),
    (r'\bantelucanas\b', 'antelucanus'),
    (r'\bantelucani\b', 'antelucanus'),
    (r'\bantelucani\b', 'antelucanus'),
    (r'\bantelucanis\b', 'antelucanus'),
    (r'\bantelucanis\b', 'antelucanus'),
    (r'\bantelucano\b', 'antelucanus'),
    (r'\bantelucano\b', 'antelucanus'),
    (r'\bantelucanos\b', 'antelucanus'),
    (r'\bantelucanum\b', 'antelucanus'),
    (r'\bantelucanum\b', 'antelucanus'),
    (r'\bantelucio\b', 'antelucio'),
    (r'\banteluculo\b', 'anteluculo'),
    (r'\banteludia\b', 'anteludium'),
    (r'\bantemeridiana\b', 'antemeridianus'),
    (r'\bantemeridianae\b', 'antemeridianus'),
    (r'\bantemeridianis\b', 'antemeridianus'),
    (r'\bantemeridiano\b', 'antemeridianus'),
    (r'\bantemeridianum\b', 'antemeridianus'),
    (r'\bantemisit\b', 'ante-mitto'),
    (r'\bantemna\b', 'antenna'),
    (r'\bAntemnae\b', 'Antemnae'),
    (r'\bantemnae\b', 'antenna'),
    (r'\bantemnaeque\b', 'antenna'),
    (r'\bantemnam\b', 'antenna'),
    (r'\bantemnaque\b', 'antenna'),
    (r'\bantemnarum\b', 'antenna'),
    (r'\bantemnas\b', 'antenna'),
    (r'\bAntemnates\b', 'Antemnates'),
    (r'\bAntemnatium\b', 'Antemnates'),
    (r'\bantemnis\b', 'antenna'),
    (r'\bantemnisque\b', 'antenna'),
    (r'\bantemurale\b', 'antemurale'),
    (r'\bantennae\b', 'antenna'),
    (r'\bantennam\b', 'antenna'),
    (r'\bantennas\b', 'antenna'),
    (r'\bantennisque\b', 'antenna'),
    (r'\banteno\b', 'ante-no1'),
    (r'\bAntenor\b', 'ante-no1'),
    (r'\bantenor\b', 'ante-no1'),
    (r'\bAntenore\b', 'ante-no1'),
    (r'\bAntenorea\b', 'ante-nosco'),
    (r'\bAntenorei\b', 'ante-nosco'),
    (r'\bAntenorem\b', 'ante-no1'),
    (r'\bAntenoreo\b', 'ante-nosco'),
    (r'\bAntenori\b', 'ante-no1'),
    (r'\bAntenoridae\b', 'ante-nosco'),
    (r'\bAntenoridas\b', 'ante-nosco'),
    (r'\bAntenoride\b', 'ante-nosco'),
    (r'\bAntenoriden\b', 'ante-nosco'),
    (r'\bAntenorique\b', 'ante-no1'),
    (r'\bantenoris\b', 'ante-nosco'),
    (r'\bAntenoris\b', 'ante-no1'),
    (r'\bantepaenultima\b', 'antepaenultimus'),
    (r'\bantepaenultimum\b', 'antepaenultimus'),
    (r'\bantepaenultimus\b', 'antepaenultimus'),
    (r'\bantepagmenta\b', 'antepagmentum'),
    (r'\bantepagmenti\b', 'antepagmentum'),
    (r'\bantepagmentis\b', 'antepagmentum'),
    (r'\bantepagmentorum\b', 'antepagmentum'),
    (r'\bantepagmentum\b', 'antepagmentum'),
    (r'\banteparta\b', 'ante-pario2'),
    (r'\bantepartum\b', 'ante-pario2'),
    (r'\bantependulis\b', 'antependulus'),
    (r'\bantependulos\b', 'antependulus'),
    (r'\bantepilanis\b', 'antepilanus'),
    (r'\bantepilanos\b', 'antepilanus'),
    (r'\bantepollebat\b', 'antepolleo'),
    (r'\bantepollet\b', 'antepolleo'),
    (r'\banteponam\b', 'antepono'),
    (r'\banteponamus\b', 'antepono'),
    (r'\banteponant\b', 'antepono'),
    (r'\banteponantur\b', 'antepono'),
    (r'\banteponare\b', 'antepono'),
    (r'\banteponas\b', 'antepono'),
    (r'\banteponat\b', 'antepono'),
    (r'\banteponatis\b', 'antepono'),
    (r'\banteponatur\b', 'antepono'),
    (r'\banteponebant\b', 'antepono'),
    (r'\banteponebantur\b', 'antepono'),
    (r'\banteponebas\b', 'antepono'),
    (r'\banteponebat\b', 'antepono'),
    (r'\banteponebatur\b', 'antepono'),
    (r'\banteponenda\b', 'antepono'),
    (r'\banteponendam\b', 'antepono'),
    (r'\banteponendas\b', 'antepono'),
    (r'\banteponendi\b', 'antepono'),
    (r'\banteponendo\b', 'antepono'),
    (r'\banteponendos\b', 'antepono'),
    (r'\banteponendum\b', 'antepono'),
    (r'\banteponendus\b', 'antepono'),
    (r'\banteponent\b', 'antepono'),
    (r'\banteponentem\b', 'antepono'),
    (r'\banteponentes\b', 'antepono'),
    (r'\banteponere\b', 'antepono'),
    (r'\banteponeremus\b', 'antepono'),
    (r'\banteponerent\b', 'antepono'),
    (r'\banteponerentur\b', 'antepono'),
    (r'\banteponeres\b', 'antepono'),
    (r'\banteponeret\b', 'antepono'),
    (r'\banteponeretur\b', 'antepono'),
    (r'\bantepones\b', 'antepono'),
    (r'\banteponet\b', 'antepono'),
    (r'\banteponi\b', 'antepono'),
    (r'\banteponis\b', 'antepono'),
    (r'\banteponit\b', 'antepono'),
    (r'\banteponitur\b', 'antepono'),
    (r'\bantepono\b', 'antepono'),
    (r'\banteponoque\b', 'antepono'),
    (r'\banteponunt\b', 'antepono'),
    (r'\banteponuntur\b', 'antepono'),
    (r'\banteposita\b', 'antepono'),
    (r'\bantepositam\b', 'antepono'),
    (r'\bantepositis\b', 'antepono'),
    (r'\banteposito\b', 'antepono'),
    (r'\bantepositum\b', 'antepono'),
    (r'\bantepositus\b', 'antepono'),
    (r'\banteposuerat\b', 'antepono'),
    (r'\banteposuere\b', 'antepono'),
    (r'\banteposuerit\b', 'antepono'),
    (r'\banteposueritis\b', 'antepono'),
    (r'\banteposuerunt\b', 'antepono'),
    (r'\banteposui\b', 'antepono'),
    (r'\banteposuissem\b', 'antepono'),
    (r'\banteposuisti\b', 'antepono'),
    (r'\banteposuistis\b', 'antepono'),
    (r'\banteposuit\b', 'antepono'),
    (r'\bantepotens\b', 'antepotens'),
    (r'\bantequam\b', 'antequam'),
    (r'\banteque\b', 'ante'),
    (r'\banterides\b', 'anterides'),
    (r'\bAnteros\b', 'antes'),
    (r'\bAnteros\b', 'Anteros'),
    (r'\banterotas\b', 'antes'),
    (r'\bAnterum\b', 'antes'),
    (r'\bantes\b', 'antes'),
    (r'\bantescholanus\b', 'antescholanus'),
    (r'\bantesignani\b', 'antesignanus'),
    (r'\bantesignanique\b', 'antesignanus'),
    (r'\bantesignanis\b', 'antesignanus'),
    (r'\bantesignanorum\b', 'antesignanus'),
    (r'\bantesignanos\b', 'antesignanus'),
    (r'\bantesignanus\b', 'antesignanus'),
    (r'\bantestabatur\b', 'antesto'),
    (r'\bantestabor\b', 'antesto'),
    (r'\bantestare\b', 'antesto'),
    (r'\bantestaret\b', 'antesto'),
    (r'\bantestari\b', 'antesto'),
    (r'\bantestaris\b', 'antestor'),
    (r'\bantestaris\b', 'antesto'),
    (r'\bantestat\b', 'antesto'),
    (r'\bantestatus\b', 'antesto'),
    (r'\bantestatus\b', 'antestor'),
    (r'\bantetuleram\b', 'antefero'),
    (r'\bantetulerim\b', 'antefero'),
    (r'\bantetulerit\b', 'antefero'),
    (r'\bantetuleritis\b', 'antefero'),
    (r'\bantetulerunt\b', 'antefero'),
    (r'\bantetuli\b', 'antefero'),
    (r'\bantetulit\b', 'antefero'),
    (r'\banteueniens\b', 'antevenio'),
    (r'\banteuentulae\b', 'anteventulus'),
    (r'\banteuentuli\b', 'anteventulus'),
    (r'\banteuertit\b', 'anteverto'),
    (r'\banteuolans\b', 'antevolo'),
    (r'\banteuolat\b', 'antevolo'),
    (r'\banteuortit\b', 'anteverto'),
    (r'\banteuortunt\b', 'anteverto'),
    (r'\bantevenere\b', 'antevenio'),
    (r'\banteveni\b', 'antevenio'),
    (r'\banteveniam\b', 'antevenio'),
    (r'\banteveniat\b', 'antevenio'),
    (r'\bantevenire\b', 'antevenio'),
    (r'\bantevenisse\b', 'antevenio'),
    (r'\bantevenisset\b', 'antevenio'),
    (r'\bantevenit\b', 'antevenio'),
    (r'\banteventum\b', 'antevenio'),
    (r'\bantevertendum\b', 'anteverto'),
    (r'\bantevertens\b', 'anteverto'),
    (r'\bantevertit\b', 'anteverto'),
    (r'\bantevortar\b', 'anteverto'),
    (r'\bantevorterim\b', 'anteverto'),
    (r'\bantevortit\b', 'anteverto'),
    (r'\bantevortunt\b', 'anteverto'),
    (r'\banthalii\b', 'anthalium'),
    (r'\banthalium\b', 'anthalium'),
    (r'\banthedon\b', 'anthedon1'),
    (r'\bAnthedon\b', 'Anthedon2'),
    (r'\banthedone\b', 'anthedon1'),
    (r'\bAnthedone\b', 'Anthedon2'),
    (r'\banthedonem\b', 'anthedon1'),
    (r'\bAnthedonem\b', 'Anthedon2'),
    (r'\banthedoni\b', 'anthedon1'),
    (r'\bAnthedonii\b', 'anthemis'),
    (r'\bAnthedoniumque\b', 'anthemis'),
    (r'\bAnthedonius\b', 'anthemis'),
    (r'\banthemide\b', 'anthemis'),
    (r'\banthemidis\b', 'anthemis'),
    (r'\banthemis\b', 'anthemis'),
    (r'\banthemis\b', 'anthemum'),
    (r'\bAnthemusam\b', 'Anthemusa'),
    (r'\bAnthemusia\b', 'Anthemusia'),
    (r'\bAnthemusia\b', 'anthera'),
    (r'\banthera\b', 'anthera'),
    (r'\bantherae\b', 'anthera'),
    (r'\bantheras\b', 'anthera'),
    (r'\bantherici\b', 'anthericos'),
    (r'\banthericum\b', 'anthericos'),
    (r'\banthi\b', 'anthus'),
    (r'\banthia\b', 'anthias'),
    (r'\banthiae\b', 'anthias'),
    (r'\banthias\b', 'anthias'),
    (r'\banthinae\b', 'anthinus'),
    (r'\banthinum\b', 'anthinus'),
    (r'\banthracinis\b', 'anthracinus'),
    (r'\banthraciten\b', 'anthracites'),
    (r'\banthracites\b', 'anthracites'),
    (r'\banthracitide\b', 'anthracitis'),
    (r'\banthracitis\b', 'anthracitis'),
    (r'\banthracitis\b', 'anthracites'),
    (r'\banthrax\b', 'anthrax1'),
    (r'\bAnthrax\b', 'Anthrax2'),
    (r'\bAnthropinus\b', 'anthropographos'),
    (r'\banthropographos\b', 'anthropographos'),
    (r'\banthropophagi\b', 'anthropophagus'),
    (r'\banthropophagos\b', 'anthropophagus'),
    (r'\banthus\b', 'anthus'),
    (r'\banthyllion\b', 'anthyllion'),
    (r'\banthyllis\b', 'anthyllis'),
    (r'\banthyllium\b', 'anthyllis'),
    (r'\banthyllium\b', 'anthyllion'),
    (r'\banthypophoran\b', 'anthypophora'),
    (r'\bAnti\b', 'Antius'),
    (r'\bAnti\b', 'Antium'),
    (r'\bAntia\b', 'Antius'),
    (r'\bAntia\b', 'Antium'),
    (r'\bantiae\b', 'antiae'),
    (r'\bAntiae\b', 'Antius'),
    (r'\bAntiam\b', 'Antius'),
    (r'\bantian\b', 'antiae'),
    (r'\bAntian\b', 'Antius'),
    (r'\bAntian\b', 'Antiatinus'),
    (r'\bAntian\b', 'Antium'),
    (r'\bAntiano\b', 'Antianus'),
    (r'\bAntianus\b', 'Antianus'),
    (r'\bantias\b', 'antiae'),
    (r'\bAntias\b', 'Antius'),
    (r'\bAntias\b', 'Antiatinus'),
    (r'\bAntiate\b', 'Antiatinus'),
    (r'\bAntiatem\b', 'Antiatinus'),
    (r'\bAntiates\b', 'Antiatinus'),
    (r'\bAntiates\b', 'Antiatinus'),
    (r'\bAntiati\b', 'Antiatinus'),
    (r'\bAntiatibus\b', 'Antiatinus'),
    (r'\bAntiatibus\b', 'Antiatinus'),
    (r'\bAntiatinae\b', 'Antiatinus'),
    (r'\bAntiatis\b', 'Antiatinus'),
    (r'\bAntiatium\b', 'Antiatinus'),
    (r'\bantibasis\b', 'antibasis'),
    (r'\bantiboreum\b', 'antiboreus'),
    (r'\bantibus\b', 'antes'),
    (r'\bantica\b', 'anticus'),
    (r'\banticam\b', 'anticus'),
    (r'\banticategoriae\b', 'anticategoria'),
    (r'\bAnticato\b', 'Anticato'),
    (r'\bAnticatone\b', 'Anticato'),
    (r'\bAnticatones\b', 'Anticato'),
    (r'\bAntichristus\b', 'Antichristus'),
    (r'\bantichthones\b', 'antichthones'),
    (r'\bantichthonum\b', 'antichthones'),
    (r'\banticipantibus\b', 'anticipo'),
    (r'\banticipare\b', 'anticipo'),
    (r'\banticipasse\b', 'anticipo'),
    (r'\banticipat\b', 'anticipo'),
    (r'\banticipata\b', 'anticipo'),
    (r'\banticipate\b', 'anticipo'),
    (r'\banticipatio\b', 'anticipatio'),
    (r'\banticipationem\b', 'anticipatio'),
    (r'\banticipatos\b', 'anticipo'),
    (r'\banticipatumque\b', 'anticipo'),
    (r'\banticipaverunt\b', 'anticipo'),
    (r'\banticipemus\b', 'anticipo'),
    (r'\banticipent\b', 'anticipo'),
    (r'\banticipes\b', 'anticipo'),
    (r'\banticipet\b', 'anticipo'),
    (r'\bAnticlea\b', 'Anticlea'),
    (r'\bantico\b', 'anticus'),
    (r'\banticorum\b', 'anticus'),
    (r'\banticos\b', 'anticus'),
    (r'\banticum\b', 'anticus'),
    (r'\banticus\b', 'anticus'),
    (r'\bAnticyra\b', 'Anticyra'),
    (r'\bAnticyrae\b', 'Anticyra'),
    (r'\bAnticyram\b', 'Anticyra'),
    (r'\bAnticyras\b', 'Anticyra'),
    (r'\bAnticyris\b', 'Anticyra'),
    (r'\bantidhac\b', 'antehac'),
    (r'\bantidota\b', 'antidotum'),
    (r'\bantidoti\b', 'antidotum'),
    (r'\bantidotis\b', 'antidotum'),
    (r'\bantidoto\b', 'antidotum'),
    (r'\bantidotos\b', 'antidotum'),
    (r'\bantidotum\b', 'antidotum'),
    (r'\bantidotus\b', 'antidotum'),
    (r'\bAntiensis\b', 'Antiensis'),
    (r'\bAntignotus\b', 'Antignotus'),
    (r'\bAntigona\b', 'Antigona'),
    (r'\bAntigonae\b', 'Antigona'),
    (r'\bAntigonam\b', 'Antigona'),
    (r'\bAntigone\b', 'Antigonus'),
    (r'\bAntigonea\b', 'Antigonea'),
    (r'\bAntigoneam\b', 'Antigonea'),
    (r'\bAntigonen\b', 'Antigonus'),
    (r'\bAntigoni\b', 'Antigonus'),
    (r'\bAntigono\b', 'Antigonus'),
    (r'\bAntigonum\b', 'Antigonus'),
    (r'\bAntigonus\b', 'Antigonus'),
    (r'\bAntii\b', 'Antius'),
    (r'\bAntii\b', 'Antium'),
    (r'\bantiis\b', 'antiae'),
    (r'\bAntilibano\b', 'Antilibanus'),
    (r'\bAntilibanum\b', 'Antilibanus'),
    (r'\bAntilibanus\b', 'Antilibanus'),
    (r'\bAntiloche\b', 'Antilochus'),
    (r'\bAntilochi\b', 'Antilochus'),
    (r'\bAntilochique\b', 'Antilochus'),
    (r'\bAntilochum\b', 'Antilochus'),
    (r'\bAntilochus\b', 'Antilochus'),
    (r'\bAntimacho\b', 'Antimachus'),
    (r'\bAntimachum\b', 'Antimachus'),
    (r'\bAntimachumque\b', 'Antimachus'),
    (r'\bAntimachus\b', 'Antimachus'),
    (r'\bantinomia\b', 'antinomia'),
    (r'\bAntio\b', 'Antius'),
    (r'\bAntio\b', 'Antium'),
    (r'\bAntioche\b', 'Antiochus'),
    (r'\bAntiochea\b', 'Antiochea'),
    (r'\bAntiochea\b', 'Antiocheus'),
    (r'\bAntiocheae\b', 'Antiochea'),
    (r'\bAntiocheam\b', 'Antiochea'),
    (r'\bAntiocheno\b', 'Antiochenus1'),
    (r'\bAntiochenos\b', 'Antiochenus1'),
    (r'\bAntiochense\b', 'Antiochensis1'),
    (r'\bAntiochenses\b', 'Antiochensis1'),
    (r'\bAntiochenses\b', 'Antiochensis1'),
    (r'\bAntiochensi\b', 'Antiochensis1'),
    (r'\bAntiochensibus\b', 'Antiochensis1'),
    (r'\bAntiochensibus\b', 'Antiochensis1'),
    (r'\bAntiochensis\b', 'Antiochensis1'),
    (r'\bAntiochensis\b', 'Antiochensis1'),
    (r'\bAntiochensium\b', 'Antiochensis1'),
    (r'\bAntiochensium\b', 'Antiochensis1'),
    (r'\bAntiochenum\b', 'Antiochenus1'),
    (r'\bAntiochi\b', 'Antiochus'),
    (r'\bAntiochi\b', 'Antiochius'),
    (r'\bAntiochia\b', 'Antiochea'),
    (r'\bAntiochiae\b', 'Antiochea'),
    (r'\bAntiochiam\b', 'Antiochea'),
    (r'\bAntiochii\b', 'Antiochius'),
    (r'\bAntiochinae\b', 'Antiochinus'),
    (r'\bAntiochinam\b', 'Antiochinus'),
    (r'\bAntiochinas\b', 'Antiochinus'),
    (r'\bAntiochino\b', 'Antiochinus'),
    (r'\bAntiochinum\b', 'Antiochinus'),
    (r'\bAntiochique\b', 'Antiochus'),
    (r'\bAntiochique\b', 'Antiochius'),
    (r'\bAntiochius\b', 'Antiochius'),
    (r'\bAntiocho\b', 'Antiochus'),
    (r'\bAntiochorum\b', 'Antiochus'),
    (r'\bAntiochum\b', 'Antiochus'),
    (r'\bAntiochumque\b', 'Antiochus'),
    (r'\bAntiochus\b', 'Antiochus'),
    (r'\bAntiopa\b', 'Antiopa'),
    (r'\bAntiopae\b', 'Antiopa'),
    (r'\bAntiopam\b', 'Antiopa'),
    (r'\bAntioque\b', 'Antius'),
    (r'\bAntioque\b', 'Antium'),
    (r'\bAntipater\b', 'Antipater'),
    (r'\bantipathes\b', 'antipathes1'),
    (r'\bantipathes\b', 'antipathes2'),
    (r'\bantipathia\b', 'antipathia'),
    (r'\bantipathiam\b', 'antipathia'),
    (r'\bantipathian\b', 'antipathia'),
    (r'\bAntipatri\b', 'Antipater'),
    (r'\bAntipatridem\b', 'Antipater'),
    (r'\bAntipatro\b', 'Antipater'),
    (r'\bAntipatrum\b', 'Antipater'),
    (r'\bAntipatrumque\b', 'Antipater'),
    (r'\bAntiphatae\b', 'Antiphates'),
    (r'\bAntiphataeque\b', 'Antiphates'),
    (r'\bAntiphaten\b', 'Antiphates'),
    (r'\bAntiphatenque\b', 'Antiphates'),
    (r'\bAntiphates\b', 'Antiphates'),
    (r'\bAntiphatesue\b', 'Antiphates'),
    (r'\bAntiphon\b', 'Antiphon'),
    (r'\bAntiphontem\b', 'Antiphon'),
    (r'\bAntiphonti\b', 'Antiphon'),
    (r'\bAntiphontis\b', 'Antiphon'),
    (r'\bantiphrasin\b', 'antiphrasis'),
    (r'\bantipodes\b', 'antipodes'),
    (r'\bantipodibus\b', 'antipodes'),
    (r'\bantipodum\b', 'antipodes'),
    (r'\bAntipolim\b', 'Antipolis'),
    (r'\bAntipolis\b', 'Antipolis'),
    (r'\bAntipolitani\b', 'antiptosis'),
    (r'\bantiptosin\b', 'antiptosis'),
    (r'\bantiptosis\b', 'antiptosis'),
    (r'\bantiqua\b', 'antiquus'),
    (r'\bantiqua\b', 'antiquus'),
    (r'\bantiqua\b', 'antiquo'),
    (r'\bantiquabant\b', 'antiquo'),
    (r'\bantiquae\b', 'antiquus'),
    (r'\bantiquam\b', 'antiquus'),
    (r'\bantiquamque\b', 'antiquus'),
    (r'\bantiquandam\b', 'antiquo'),
    (r'\bantiquandas\b', 'antiquo'),
    (r'\bantiquando\b', 'antiquo'),
    (r'\bantiquaque\b', 'antiquus'),
    (r'\bantiquaque\b', 'antiquus'),
    (r'\bantiquaque\b', 'antiquo'),
    (r'\bantiquare\b', 'antiquo'),
    (r'\bantiquarent\b', 'antiquo'),
    (r'\bantiquaret\b', 'antiquo'),
    (r'\bantiquaretur\b', 'antiquo'),
    (r'\bantiquari\b', 'antiquarius'),
    (r'\bantiquari\b', 'antiquo'),
    (r'\bantiquaria\b', 'antiquarius'),
    (r'\bantiquaria\b', 'antiquarius'),
    (r'\bantiquariis\b', 'antiquarius'),
    (r'\bantiquariis\b', 'antiquarius'),
    (r'\bantiquariorum\b', 'antiquarius'),
    (r'\bantiquarios\b', 'antiquarius'),
    (r'\bantiquarium\b', 'antiquarius'),
    (r'\bantiquarum\b', 'antiquus'),
    (r'\bantiquarunt\b', 'antiquo'),
    (r'\bantiquas\b', 'antiquus'),
    (r'\bantiquas\b', 'antiquo'),
    (r'\bantiquasque\b', 'antiquus'),
    (r'\bantiquasque\b', 'antiquo'),
    (r'\bantiquastis\b', 'antiquo'),
    (r'\bantiquata\b', 'antiquo'),
    (r'\bantiquatam\b', 'antiquo'),
    (r'\bantiquatis\b', 'antiquo'),
    (r'\bantiquatum\b', 'antiquo'),
    (r'\bantiquatur\b', 'antiquo'),
    (r'\bantique\b', 'antiquus'),
    (r'\bantique\b', 'antique'),
    (r'\bantique\b', 'antiquus'),
    (r'\bantiquetur\b', 'antiquo'),
    (r'\bantiqui\b', 'antiquus'),
    (r'\bantiqui\b', 'antiquitas'),
    (r'\bantiqui\b', 'antiquus'),
    (r'\bantiquior\b', 'antiquus'),
    (r'\bantiquiora\b', 'antiquus'),
    (r'\bantiquiore\b', 'antiquus'),
    (r'\bantiquiorem\b', 'antiquus'),
    (r'\bantiquiores\b', 'antiquus'),
    (r'\bantiquioribus\b', 'antiquus'),
    (r'\bantiquioris\b', 'antiquus'),
    (r'\bantiquiorque\b', 'antiquus'),
    (r'\bantiquiorum\b', 'antiquus'),
    (r'\bantiquique\b', 'antiquus'),
    (r'\bantiquique\b', 'antiquitas'),
    (r'\bantiquique\b', 'antiquus'),
    (r'\bantiquis\b', 'antiquus'),
    (r'\bantiquis\b', 'antiquitas'),
    (r'\bantiquis\b', 'antiquus'),
    (r'\bantiquissima\b', 'antiquus'),
    (r'\bantiquissimae\b', 'antiquus'),
    (r'\bantiquissimam\b', 'antiquus'),
    (r'\bantiquissimamque\b', 'antiquus'),
    (r'\bantiquissimarum\b', 'antiquus'),
    (r'\bantiquissimas\b', 'antiquus'),
    (r'\bantiquissime\b', 'antiquus'),
    (r'\bantiquissimi\b', 'antiquus'),
    (r'\bantiquissimis\b', 'antiquus'),
    (r'\bantiquissimisque\b', 'antiquus'),
    (r'\bantiquissimo\b', 'antiquus'),
    (r'\bantiquissimorum\b', 'antiquus'),
    (r'\bantiquissimorumque\b', 'antiquus'),
    (r'\bantiquissimos\b', 'antiquus'),
    (r'\bantiquissimum\b', 'antiquus'),
    (r'\bantiquissimus\b', 'antiquus'),
    (r'\bantiquissumis\b', 'antiquus'),
    (r'\bantiquissumos\b', 'antiquus'),
    (r'\bantiquitas\b', 'antiquitas'),
    (r'\bantiquitasque\b', 'antiquitas'),
    (r'\bantiquitate\b', 'antiquitas'),
    (r'\bantiquitatem\b', 'antiquitas'),
    (r'\bantiquitates\b', 'antiquitas'),
    (r'\bantiquitati\b', 'antiquitas'),
    (r'\bantiquitatibus\b', 'antiquitas'),
    (r'\bantiquitatis\b', 'antiquitas'),
    (r'\bantiquitatisque\b', 'antiquitas'),
    (r'\bantiquitatium\b', 'antiquitas'),
    (r'\bantiquitatum\b', 'antiquitas'),
    (r'\bantiquitus\b', 'antique'),
    (r'\bantiquius\b', 'antiquus'),
    (r'\bantiquo\b', 'antiquus'),
    (r'\bantiquo\b', 'antiquus'),
    (r'\bantiquo\b', 'antiquo'),
    (r'\bantiquom\b', 'antiquus'),
    (r'\bantiquom\b', 'antiquus'),
    (r'\bantiquorum\b', 'antiquitas'),
    (r'\bantiquorum\b', 'antiquus'),
    (r'\bantiquorumque\b', 'antiquitas'),
    (r'\bantiquorumque\b', 'antiquus'),
    (r'\bantiquos\b', 'antiquitas'),
    (r'\bantiquosque\b', 'antiquitas'),
    (r'\bantiquum\b', 'antiquus'),
    (r'\bantiquum\b', 'antiquitas'),
    (r'\bantiquum\b', 'antiquus'),
    (r'\bantiquumque\b', 'antiquus'),
    (r'\bantiquumque\b', 'antiquitas'),
    (r'\bantiquumque\b', 'antiquus'),
    (r'\bantiquus\b', 'antiquus'),
    (r'\bantirrhinon\b', 'antirrhinon'),
    (r'\bantis\b', 'antae'),
    (r'\bantis\b', 'antes'),
    (r'\bantisophistas\b', 'antisophista'),
    (r'\bantispasto\b', 'antispastus'),
    (r'\bantispastum\b', 'antispastus'),
    (r'\bantispastus\b', 'antispastus'),
    (r'\bantispodi\b', 'antispodos'),
    (r'\bantispodon\b', 'antispodos'),
    (r'\bantisque\b', 'antae'),
    (r'\bantisque\b', 'antes'),
    (r'\bAntissa\b', 'Antissa'),
    (r'\bAntissaeos\b', 'Antissaei'),
    (r'\bAntissam\b', 'Antissa'),
    (r'\bantist\b', 'antae'),
    (r'\bantist\b', 'antes'),
    (r'\bAntist\b', 'Antius'),
    (r'\bAntist\b', 'Antium'),
    (r'\bantistes\b', 'antistes'),
    (r'\bAntisthene\b', 'Antisthenis'),
    (r'\bAntisthenes\b', 'Antisthenis'),
    (r'\bAntistheni\b', 'Antisthenis'),
    (r'\bAntisthenis\b', 'Antisthenis'),
    (r'\bAntisti\b', 'Antistius'),
    (r'\bAntistii\b', 'Antistius'),
    (r'\bAntistio\b', 'Antistius'),
    (r'\bantistite\b', 'antistes'),
    (r'\bantistitem\b', 'antistes'),
    (r'\bantistites\b', 'antistes'),
    (r'\bantistiti\b', 'antistes'),
    (r'\bantistiti\b', 'antistitium'),
    (r'\bantistitibus\b', 'antistes'),
    (r'\bantistitis\b', 'antistes'),
    (r'\bAntistium\b', 'Antistius'),
    (r'\bAntistius\b', 'Antistius'),
    (r'\bAntistiusque\b', 'Antistius'),
    (r'\bantithesin\b', 'antithesis'),
    (r'\bantithesis\b', 'antithesis'),
    (r'\bantithetis\b', 'antitheton'),
    (r'\bantitheton\b', 'antitheton'),
    (r'\bantium\b', 'antes'),
    (r'\bAntium\b', 'Antius'),
    (r'\bAntium\b', 'Antium'),
    (r'\bantiumque\b', 'antes'),
    (r'\bAntiumque\b', 'Antius'),
    (r'\bAntiumque\b', 'Antium'),
    (r'\bAntius\b', 'Antius'),
    (r'\bantlia\b', 'antlia'),
    (r'\bantliam\b', 'antlia'),
    (r'\bAntoni\b', 'Antonius'),
    (r'\bAntonia\b', 'Antonia'),
    (r'\bAntonia\b', 'Antonius'),
    (r'\bAntoniae\b', 'Antonia'),
    (r'\bAntoniam\b', 'Antonia'),
    (r'\bAntoniana\b', 'Antonianus'),
    (r'\bAntonianae\b', 'Antonianus'),
    (r'\bAntonianae\b', 'Antonianus'),
    (r'\bAntonianarum\b', 'Antonianus'),
    (r'\bAntonianas\b', 'Antonianus'),
    (r'\bAntoniani\b', 'Antonianus'),
    (r'\bAntoniano\b', 'Antonianus'),
    (r'\bAntonianos\b', 'Antonianus'),
    (r'\bAntonianum\b', 'Antonianus'),
    (r'\bAntonias\b', 'Antonia'),
    (r'\bAntoniaster\b', 'Antoniaster'),
    (r'\bAntonii\b', 'Antonius'),
    (r'\bAntoniis\b', 'Antonia'),
    (r'\bAntoniis\b', 'Antonius'),
    (r'\bAntonin\b', 'Antonius'),
    (r'\bAntonine\b', 'Antoninus'),
    (r'\bAntonini\b', 'Antoninus'),
    (r'\bAntoniniana\b', 'Antoninus'),
    (r'\bAntoninianae\b', 'Antoninus'),
    (r'\bAntoninianas\b', 'Antoninus'),
    (r'\bAntoniniani\b', 'Antoninus'),
    (r'\bAntoninianis\b', 'Antoninus'),
    (r'\bAntoninianos\b', 'Antoninus'),
    (r'\bAntoninianum\b', 'Antoninus'),
    (r'\bAntoninis\b', 'Antoninus'),
    (r'\bAntonino\b', 'Antoninus'),
    (r'\bAntoninorum\b', 'Antoninus'),
    (r'\bAntoninos\b', 'Antoninus'),
    (r'\bAntoninum\b', 'Antoninus'),
    (r'\bAntoninus\b', 'Antoninus'),
    (r'\bAntonio\b', 'Antonius'),
    (r'\bAntonione\b', 'Antonius'),
    (r'\bAntoniopolitae\b', 'Antoniopolitae'),
    (r'\bAntoniorum\b', 'Antonius'),
    (r'\bAntonios\b', 'Antonius'),
    (r'\bAntoniosque\b', 'Antonius'),
    (r'\bAntonique\b', 'Antonius'),
    (r'\bAntonium\b', 'Antonius'),
    (r'\bAntoniumque\b', 'Antonius'),
    (r'\bAntonius\b', 'Antonius'),
    (r'\bAntoniusne\b', 'Antonius'),
    (r'\bAntoniusque\b', 'Antonius'),
    (r'\bantonomasia\b', 'antonomasia'),
    (r'\bantonomasiae\b', 'antonomasia'),
    (r'\bantonomasian\b', 'antonomasia'),
    (r'\bantonomasiva\b', 'antonomasivus'),
    (r'\bantonomasivum\b', 'antonomasivus'),
    (r'\bantra\b', 'antrum'),
    (r'\bantraque\b', 'antrum'),
    (r'\bantri\b', 'antrum'),
    (r'\bantris\b', 'antrum'),
    (r'\bantro\b', 'antrum'),
    (r'\bAntroni\b', 'Antron'),
    (r'\bantroque\b', 'antrum'),
    (r'\bantrorumque\b', 'antrum'),
    (r'\bantrum\b', 'antrum'),
    (r'\bantrumque\b', 'antrum'),
    (r'\banu\b', 'anus3'),
    (r'\banubin\b', 'anularis'),
    (r'\banubis\b', 'anularis'),
    (r'\banubus\b', 'anus3'),
    (r'\banui\b', 'anus3'),
    (r'\banuis\b', 'an'),
    (r'\banulare\b', 'anularis'),
    (r'\banulariam\b', 'anularius'),
    (r'\banularias\b', 'anularius'),
    (r'\banularius\b', 'anularis'),
    (r'\banularius\b', 'anularius'),
    (r'\banule\b', 'anulus1'),
    (r'\banuli\b', 'anulus1'),
    (r'\banulis\b', 'anulus1'),
    (r'\banulisque\b', 'anulus1'),
    (r'\banulo\b', 'anulus1'),
    (r'\banulorum\b', 'anulus1'),
    (r'\banulorumque\b', 'anulus1'),
    (r'\banulos\b', 'anulus1'),
    (r'\banulosque\b', 'anulus1'),
    (r'\banulum\b', 'anulus1'),
    (r'\banulumque\b', 'anulus1'),
    (r'\banulus\b', 'anulus1'),
    (r'\banum\b', 'anus3'),
    (r'\banum\b', 'anus1'),
    (r'\banumque\b', 'anus3'),
    (r'\banumque\b', 'anus1'),
    (r'\banun\b', 'anus3'),
    (r'\banun\b', 'anus1'),
    (r'\banus\b', 'anus3'),
    (r'\banus\b', 'anus1'),
    (r'\banusque\b', 'anus3'),
    (r'\banusque\b', 'anus1'),
    (r'\banusve\b', 'anus3'),
    (r'\banusve\b', 'anus1'),
    (r'\banxa\b', 'ango'),
    (r'\banxia\b', 'anxius'),
    (r'\banxia\b', 'anxio'),
    (r'\banxiabatur\b', 'anxio'),
    (r'\banxiae\b', 'anxius'),
    (r'\banxiam\b', 'anxius'),
    (r'\banxiaretur\b', 'anxio'),
    (r'\banxias\b', 'anxius'),
    (r'\banxias\b', 'anxio'),
    (r'\banxiatus\b', 'anxio'),
    (r'\banxie\b', 'anxius'),
    (r'\banxieque\b', 'anxius'),
    (r'\banxietas\b', 'anxietas'),
    (r'\banxietate\b', 'anxietas'),
    (r'\banxietatem\b', 'anxietas'),
    (r'\banxiferas\b', 'anxifer'),
    (r'\banxiferi\b', 'anxifer'),
    (r'\banxii\b', 'anxius'),
    (r'\banxiis\b', 'anxius'),
    (r'\banxio\b', 'anxius'),
    (r'\banxio\b', 'anxio'),
    (r'\banxios\b', 'anxius'),
    (r'\banxit\b', 'ango'),
    (r'\banxitudine\b', 'anxitudo'),
    (r'\banxitudo\b', 'anxitudo'),
    (r'\banxium\b', 'anxius'),
    (r'\banxiumque\b', 'anxius'),
    (r'\banxius\b', 'ango'),
    (r'\banxius\b', 'anxius'),
    (r'\bAnxur\b', 'Anxur'),
    (r'\banxure\b', 'ango'),
    (r'\bAnxure\b', 'Anxur'),
    (r'\banxuri\b', 'ango'),
    (r'\bAnxuri\b', 'Anxur'),
    (r'\banxuris\b', 'ango'),
    (r'\bAnxuris\b', 'Anxur'),
    (r'\banxurus\b', 'ango'),
    (r'\bAnxyr\b', 'Anxur'),
    (r'\bAnxyris\b', 'Anxur'),
    (r'\bAnyti\b', 'Anytus'),
    (r'\bAnytique\b', 'Anytus'),
    (r'\bAnytus\b', 'Anytus'),
    (r'\bAoede\b', 'Aoede'),
    (r'\bAones\b', 'Aones'),
    (r'\bAoni\b', 'a-orno'),
    (r'\bAonia\b', 'Aonia'),
    (r'\bAonia\b', 'a-orno'),
    (r'\bAoniae\b', 'Aonia'),
    (r'\bAoniam\b', 'Aonia'),
    (r'\bAoniamque\b', 'Aonia'),
    (r'\bAonias\b', 'Aonia'),
    (r'\bAoniasque\b', 'Aonia'),
    (r'\bAonidas\b', 'a-orno'),
    (r'\bAonides\b', 'a-orno'),
    (r'\bAonides\b', 'a-orno'),
    (r'\bAonidum\b', 'a-orno'),
    (r'\bAonie\b', 'a-orno'),
    (r'\bAonii\b', 'a-orno'),
    (r'\bAoniis\b', 'Aonia'),
    (r'\bAoniis\b', 'a-orno'),
    (r'\bAonio\b', 'a-orno'),
    (r'\bAonios\b', 'a-orno'),
    (r'\bAonis\b', 'a-orno'),
    (r'\bAonium\b', 'a-orno'),
    (r'\bAonius\b', 'a-orno'),
    (r'\bAoo\b', 'Aous'),
    (r'\baorno\b', 'a-orno'),
    (r'\baorsi\b', 'a-orno'),
    (r'\baorsorum\b', 'a-orno'),
    (r'\bAoum\b', 'Aous'),
    (r'\bAoumque\b', 'Aous'),
    (r'\bAous\b', 'Aous'),
    (r'\bapage\b', 'apage'),
    (r'\bapala\b', 'apala'),
    (r'\bApamea\b', 'Apamea'),
    (r'\bApamea\b', 'aparctias'),
    (r'\bApameae\b', 'Apamea'),
    (r'\bApameam\b', 'Apamea'),
    (r'\bApamena\b', 'aparctias'),
    (r'\bApamenam\b', 'aparctias'),
    (r'\bApamenas\b', 'aparctias'),
    (r'\bApamenorum\b', 'aparctias'),
    (r'\bApamense\b', 'aparctias'),
    (r'\bApamensem\b', 'aparctias'),
    (r'\bApamensibus\b', 'aparctias'),
    (r'\bApamenum\b', 'aparctias'),
    (r'\bapar\b', 'apo'),
    (r'\baparctias\b', 'aparctias'),
    (r'\baparine\b', 'aparine'),
    (r'\baparinen\b', 'aparine'),
    (r'\bapaten\b', 'apathia'),
    (r'\bapathiae\b', 'apathia'),
    (r'\bApaturii\b', 'Apaturius'),
    (r'\bApaturius\b', 'Apaturius'),
    (r'\bape\b', 'apis1'),
    (r'\bape\b', 'apo'),
    (r'\bapelioten\b', 'apeliotes'),
    (r'\bapeliotes\b', 'apeliotes'),
    (r'\bApella\b', 'Apella'),
    (r'\bApellae\b', 'Apella'),
    (r'\bapellam\b', 'a-pello'),
    (r'\bApellam\b', 'Apella'),
    (r'\bApellan\b', 'Apella'),
    (r'\bapellan\b', 'a-pello'),
    (r'\bApellas\b', 'Apella'),
    (r'\bapellas\b', 'a-pello'),
    (r'\bApelle\b', 'Apelles'),
    (r'\bapelle\b', 'a-pello'),
    (r'\bApellea\b', 'a-pello'),
    (r'\bApelleae\b', 'a-pello'),
    (r'\bApellei\b', 'a-pello'),
    (r'\bApelleis\b', 'a-pello'),
    (r'\bApellem\b', 'Apelles'),
    (r'\bapellen\b', 'a-pello'),
    (r'\bApellen\b', 'Apelles'),
    (r'\bapellenque\b', 'a-pello'),
    (r'\bApellenque\b', 'Apelles'),
    (r'\bApelleo\b', 'a-pello'),
    (r'\bapelles\b', 'a-pello'),
    (r'\bApelles\b', 'Apelles'),
    (r'\bApelleum\b', 'a-pello'),
    (r'\bApelli\b', 'Apelles'),
    (r'\bapelli\b', 'a-pello'),
    (r'\bApellis\b', 'Apella'),
    (r'\bApellis\b', 'Apelles'),
    (r'\bapellis\b', 'a-pello'),
    (r'\bapem\b', 'apis1'),
    (r'\bapene\b', 'apis1'),
    (r'\bapene\b', 'apo'),
    (r'\bApennini\b', 'Apenninus'),
    (r'\bApenninicola\b', 'Apenninicola'),
    (r'\bApenninicolae\b', 'Apenninicola'),
    (r'\bApennino\b', 'Apenninus'),
    (r'\bApenninum\b', 'Apenninus'),
    (r'\bApenninumque\b', 'Apenninus'),
    (r'\bApenninus\b', 'Apenninus'),
    (r'\baper\b', 'aper1'),
    (r'\bAper\b', 'Aper2'),
    (r'\bAperantiam\b', 'Aperantia'),
    (r'\bapere\b', 'apo'),
    (r'\bAperensem\b', 'Aperensis'),
    (r'\baperi\b', 'aperio'),
    (r'\baperiam\b', 'aperio'),
    (r'\baperiamus\b', 'aperio'),
    (r'\baperiant\b', 'aperio'),
    (r'\baperiantur\b', 'aperio'),
    (r'\baperias\b', 'aperio'),
    (r'\baperiat\b', 'aperio'),
    (r'\baperiatque\b', 'aperio'),
    (r'\baperiatur\b', 'aperio'),
    (r'\baperiebam\b', 'aperio'),
    (r'\baperiebant\b', 'aperio'),
    (r'\baperiebantur\b', 'aperio'),
    (r'\baperiebat\b', 'aperio'),
    (r'\baperiebatur\b', 'aperio'),
    (r'\baperiemus\b', 'aperio'),
    (r'\baperienda\b', 'aperio'),
    (r'\baperiendae\b', 'aperio'),
    (r'\baperiendaeque\b', 'aperio'),
    (r'\baperiendam\b', 'aperio'),
    (r'\baperiendarum\b', 'aperio'),
    (r'\baperiendas\b', 'aperio'),
    (r'\baperiendi\b', 'aperio'),
    (r'\baperiendis\b', 'aperio'),
    (r'\baperiendo\b', 'aperio'),
    (r'\baperiendorum\b', 'aperio'),
    (r'\baperiendum\b', 'aperio'),
    (r'\baperiendus\b', 'aperio'),
    (r'\baperiens\b', 'aperio'),
    (r'\baperiensque\b', 'aperio'),
    (r'\baperient\b', 'aperio'),
    (r'\baperiente\b', 'aperio'),
    (r'\baperientem\b', 'aperio'),
    (r'\baperientes\b', 'aperio'),
    (r'\baperienti\b', 'aperio'),
    (r'\baperientibus\b', 'aperio'),
    (r'\baperientur\b', 'aperio'),
    (r'\baperies\b', 'aperio'),
    (r'\baperiesque\b', 'aperio'),
    (r'\baperiet\b', 'aperio'),
    (r'\baperietis\b', 'aperio'),
    (r'\baperietur\b', 'aperio'),
    (r'\baperimur\b', 'aperio'),
    (r'\baperimus\b', 'aperio'),
    (r'\baperio\b', 'aperio'),
    (r'\baperire\b', 'aperio'),
    (r'\baperirem\b', 'aperio'),
    (r'\baperirent\b', 'aperio'),
    (r'\baperirentur\b', 'aperio'),
    (r'\baperires\b', 'aperio'),
    (r'\baperiret\b', 'aperio'),
    (r'\baperiretur\b', 'aperio'),
    (r'\baperiri\b', 'aperio'),
    (r'\baperirique\b', 'aperio'),
    (r'\baperis\b', 'apo'),
    (r'\baperis\b', 'aperio'),
    (r'\baperit\b', 'aperio'),
    (r'\baperite\b', 'aperio'),
    (r'\baperitin\b', 'aperio'),
    (r'\baperitis\b', 'aperio'),
    (r'\baperito\b', 'aperio'),
    (r'\baperitque\b', 'aperio'),
    (r'\baperitur\b', 'aperio'),
    (r'\baperiunda\b', 'aperio'),
    (r'\baperiundas\b', 'aperio'),
    (r'\baperiundis\b', 'aperio'),
    (r'\baperiundo\b', 'aperio'),
    (r'\baperiundum\b', 'aperio'),
    (r'\baperiunt\b', 'aperio'),
    (r'\baperiuntur\b', 'aperio'),
    (r'\baperta\b', 'apertus'),
    (r'\baperta\b', 'aperio'),
    (r'\baperta\b', 'aperto'),
    (r'\bapertae\b', 'apertus'),
    (r'\bapertae\b', 'aperio'),
    (r'\bapertam\b', 'apertus'),
    (r'\bapertam\b', 'aperio'),
    (r'\bapertamque\b', 'apertus'),
    (r'\bapertamque\b', 'aperio'),
    (r'\bapertaque\b', 'apertus'),
    (r'\bapertaque\b', 'aperio'),
    (r'\bapertaque\b', 'aperto'),
    (r'\bapertarum\b', 'apertus'),
    (r'\bapertarum\b', 'aperio'),
    (r'\bapertas\b', 'apertus'),
    (r'\bapertas\b', 'aperio'),
    (r'\bapertas\b', 'aperto'),
    (r'\bapertasque\b', 'apertus'),
    (r'\bapertasque\b', 'aperio'),
    (r'\bapertasque\b', 'aperto'),
    (r'\bapertast\b', 'apertus'),
    (r'\bapertast\b', 'aperio'),
    (r'\bapertast\b', 'aperto'),
    (r'\baperte\b', 'apertus'),
    (r'\baperte\b', 'aperio'),
    (r'\baperteque\b', 'apertus'),
    (r'\baperteque\b', 'aperio'),
    (r'\baperti\b', 'apertus'),
    (r'\baperti\b', 'aperio'),
    (r'\bapertio\b', 'apertio'),
    (r'\bapertione\b', 'apertio'),
    (r'\bapertionem\b', 'apertio'),
    (r'\bapertiones\b', 'apertio'),
    (r'\bapertionis\b', 'apertio'),
    (r'\bapertior\b', 'aperio'),
    (r'\bapertiora\b', 'aperio'),
    (r'\bapertiore\b', 'aperio'),
    (r'\bapertiorem\b', 'aperio'),
    (r'\bapertiores\b', 'aperio'),
    (r'\bapertioribus\b', 'aperio'),
    (r'\bapertis\b', 'apertus'),
    (r'\bapertis\b', 'aperio'),
    (r'\bapertisque\b', 'apertus'),
    (r'\bapertisque\b', 'aperio'),
    (r'\bapertissima\b', 'aperio'),
    (r'\bapertissimae\b', 'aperio'),
    (r'\bapertissimas\b', 'aperio'),
    (r'\bapertissime\b', 'aperio'),
    (r'\bapertissimis\b', 'aperio'),
    (r'\bapertissimo\b', 'aperio'),
    (r'\bapertissimum\b', 'aperio'),
    (r'\bapertissimus\b', 'aperio'),
    (r'\bapertissuma\b', 'aperio'),
    (r'\bapertius\b', 'aperio'),
    (r'\bapertiusque\b', 'aperio'),
    (r'\baperto\b', 'apertus'),
    (r'\baperto\b', 'aperio'),
    (r'\baperto\b', 'aperto'),
    (r'\bapertoque\b', 'apertus'),
    (r'\bapertoque\b', 'aperio'),
    (r'\bapertoque\b', 'aperto'),
    (r'\bapertos\b', 'apertus'),
    (r'\bapertos\b', 'aperio'),
    (r'\bapertosque\b', 'apertus'),
    (r'\bapertosque\b', 'aperio'),
    (r'\bapertum\b', 'apertum'),
    (r'\bapertum\b', 'apertus'),
    (r'\bapertum\b', 'aperio'),
    (r'\bapertumque\b', 'apertum'),
    (r'\bapertumque\b', 'apertus'),
    (r'\bapertumque\b', 'aperio'),
    (r'\bapertura\b', 'apertura'),
    (r'\bapertura\b', 'aperio'),
    (r'\baperturae\b', 'apertura'),
    (r'\baperturae\b', 'aperio'),
    (r'\baperturam\b', 'apertura'),
    (r'\baperturam\b', 'aperio'),
    (r'\baperturas\b', 'apertura'),
    (r'\baperturas\b', 'aperio'),
    (r'\baperturi\b', 'aperio'),
    (r'\baperturis\b', 'apertura'),
    (r'\baperturis\b', 'aperio'),
    (r'\baperturos\b', 'aperio'),
    (r'\baperturum\b', 'aperio'),
    (r'\bapertus\b', 'apertus'),
    (r'\bapertus\b', 'aperio'),
    (r'\baperuerant\b', 'aperio'),
    (r'\baperuerat\b', 'aperio'),
    (r'\baperuere\b', 'aperio'),
    (r'\baperuerimus\b', 'aperio'),
    (r'\baperuerint\b', 'aperio'),
    (r'\baperueris\b', 'aperio'),
    (r'\baperuerit\b', 'aperio'),
    (r'\baperueritis\b', 'aperio'),
    (r'\baperuero\b', 'aperio'),
    (r'\baperuerunt\b', 'aperio'),
    (r'\baperui\b', 'aperio'),
    (r'\baperuimus\b', 'aperio'),
    (r'\baperuisse\b', 'aperio'),
    (r'\baperuissem\b', 'aperio'),
    (r'\baperuissemus\b', 'aperio'),
    (r'\baperuissent\b', 'aperio'),
    (r'\baperuisset\b', 'aperio'),
    (r'\baperuisti\b', 'aperio'),
    (r'\baperuistis\b', 'aperio'),
    (r'\baperuit\b', 'aperio'),
    (r'\baperuitque\b', 'aperio'),
    (r'\bapes\b', 'apis1'),
    (r'\bapes\b', 'apo'),
    (r'\bApes\b', 'Apis2'),
    (r'\bapesque\b', 'apis1'),
    (r'\bapesque\b', 'apo'),
    (r'\bapex\b', 'apex'),
    (r'\bapexabo\b', 'apexabo'),
    (r'\baphaca\b', 'aphaca'),
    (r'\baphacae\b', 'aphaca'),
    (r'\bAphaeae\b', 'Aphaea'),
    (r'\baphaerema\b', 'aphaerema'),
    (r'\baphaeresin\b', 'aphaeresis'),
    (r'\baphaeresis\b', 'aphaeresis'),
    (r'\bApharei\b', 'Aphareus'),
    (r'\bAphareus\b', 'Aphareus'),
    (r'\bAphidnas\b', 'Aphidnae'),
    (r'\baphracta\b', 'aphractus'),
    (r'\baphractis\b', 'aphractus'),
    (r'\baphractis\b', 'aphractus'),
    (r'\baphractorum\b', 'aphractus'),
    (r'\baphractorum\b', 'aphractus'),
    (r'\baphractus\b', 'aphractus'),
    (r'\bAphrodisia\b', 'Aphrodisia'),
    (r'\baphrodisiaca\b', 'aphrodisiace'),
    (r'\bAphrodisiade\b', 'Aphrodisias1'),
    (r'\bAphrodisias\b', 'Aphrodisias1'),
    (r'\bAphrodisiis\b', 'Aphrodisia'),
    (r'\bAphrodisium\b', 'Aphrodisia'),
    (r'\bAphrodisium\b', 'Aphrodisium'),
    (r'\baphronitri\b', 'aphronitrum'),
    (r'\baphronitro\b', 'aphronitrum'),
    (r'\baphronitrum\b', 'aphronitrum'),
    (r'\baphye\b', 'aphya'),
    (r'\baphyen\b', 'aphya'),
    (r'\bapi\b', 'apis1'),
    (r'\bapi\b', 'apium'),
    (r'\bapi\b', 'apo'),
    (r'\bApia\b', 'Apia'),
    (r'\bapia\b', 'apium'),
    (r'\bapia\b', 'apio'),
    (r'\bapiacam\b', 'apiacus'),
    (r'\bapiacon\b', 'apiacus'),
    (r'\bapianam\b', 'apianus'),
    (r'\bapianis\b', 'apianus'),
    (r'\bapianis\b', 'apianus'),
    (r'\bapiaria\b', 'apiarius'),
    (r'\bapiaria\b', 'apiarius'),
    (r'\bapiarii\b', 'apiarius'),
    (r'\bapiarii\b', 'apiarius'),
    (r'\bapiariis\b', 'apiarius'),
    (r'\bapiariis\b', 'apiarius'),
    (r'\bapiario\b', 'apiarius'),
    (r'\bapiario\b', 'apiarius'),
    (r'\bapiarium\b', 'apiarius'),
    (r'\bapiarium\b', 'apiarius'),
    (r'\bapiastrae\b', 'apiastra'),
    (r'\bapiastri\b', 'apiastrum'),
    (r'\bapiastro\b', 'apiastrum'),
    (r'\bapiastrum\b', 'apiastrum'),
    (r'\bapiatas\b', 'apiatus'),
    (r'\bapiatas\b', 'apio'),
    (r'\bapibus\b', 'apis1'),
    (r'\bapibusque\b', 'apis1'),
    (r'\bapibusve\b', 'apis1'),
    (r'\bapicas\b', 'apica'),
    (r'\bapicatam\b', 'apicatus'),
    (r'\bapicatam\b', 'apica'),
    (r'\bapicati\b', 'apicatus'),
    (r'\bapicati\b', 'apica'),
    (r'\bapice\b', 'apex'),
    (r'\bapicem\b', 'apex'),
    (r'\bapicem\b', 'apica'),
    (r'\bapicemque\b', 'apex'),
    (r'\bapicemque\b', 'apica'),
    (r'\bapices\b', 'apex'),
    (r'\bapices\b', 'apica'),
    (r'\bapici\b', 'apex'),
    (r'\bApici\b', 'Apicius2'),
    (r'\bapici\b', 'apicius1'),
    (r'\bapiciam\b', 'apicius1'),
    (r'\bApiciana\b', 'apicius1'),
    (r'\bApicianam\b', 'apicius1'),
    (r'\bApicianas\b', 'apicius1'),
    (r'\bApiciano\b', 'apicius1'),
    (r'\bApicianum\b', 'apicius1'),
    (r'\bapicias\b', 'apicius1'),
    (r'\bapicibus\b', 'apex'),
    (r'\bapicii\b', 'apicius1'),
    (r'\bApicii\b', 'Apicius2'),
    (r'\bapicii\b', 'apicius1'),
    (r'\bapicio\b', 'apicius1'),
    (r'\bApicio\b', 'Apicius2'),
    (r'\bapicio\b', 'apicius1'),
    (r'\bapicis\b', 'apica'),
    (r'\bapicis\b', 'apex'),
    (r'\bApicium\b', 'Apicius2'),
    (r'\bapicium\b', 'apicius1'),
    (r'\bapicium\b', 'apicius1'),
    (r'\bapicius\b', 'apicius1'),
    (r'\bApicius\b', 'Apicius2'),
    (r'\bapicula\b', 'apicula'),
    (r'\bapicularum\b', 'apicula'),
    (r'\bApidani\b', 'Apidanus'),
    (r'\bApidano\b', 'Apidanus'),
    (r'\bApidanos\b', 'Apidanus'),
    (r'\bApidanosque\b', 'Apidanus'),
    (r'\bApidanus\b', 'Apidanus'),
    (r'\bapidem\b', 'apis1'),
    (r'\bApidem\b', 'Apis2'),
    (r'\bapidem\b', 'apium'),
    (r'\bapidem\b', 'apo'),
    (r'\bapii\b', 'apium'),
    (r'\bapilas\b', 'a-pilo1'),
    (r'\bapim\b', 'apis1'),
    (r'\bApim\b', 'Apis2'),
    (r'\bapin\b', 'apis1'),
    (r'\bApin\b', 'Apis2'),
    (r'\bapin\b', 'apium'),
    (r'\bapin\b', 'apo'),
    (r'\bApinam\b', 'a-pilo1'),
    (r'\bApinasque\b', 'a-pilo1'),
    (r'\bApio\b', 'apio'),
    (r'\bapio\b', 'apium'),
    (r'\bapio\b', 'apio'),
    (r'\bApion\b', 'apio'),
    (r'\bapion\b', 'apium'),
    (r'\bapion\b', 'apio'),
    (r'\bApione\b', 'apio'),
    (r'\bapione\b', 'apium'),
    (r'\bapione\b', 'apio'),
    (r'\bApionis\b', 'apio'),
    (r'\bapioque\b', 'apium'),
    (r'\bapioque\b', 'apio'),
    (r'\bapiorum\b', 'apium'),
    (r'\bapis\b', 'apis1'),
    (r'\bApis\b', 'Apis2'),
    (r'\bapis\b', 'apo'),
    (r'\bapiscatur\b', 'apiscor'),
    (r'\bapitis\b', 'apo'),
    (r'\bapium\b', 'apis1'),
    (r'\bApium\b', 'Apis2'),
    (r'\bapium\b', 'apium'),
    (r'\baple\b', 'apluda'),
    (r'\bapluda\b', 'apluda'),
    (r'\bapludam\b', 'apluda'),
    (r'\baplustre\b', 'aplustre'),
    (r'\baplustria\b', 'aplustre'),
    (r'\baplustribus\b', 'aplustre'),
    (r'\baplustris\b', 'aplustre'),
    (r'\bapo\b', 'apo'),
    (r'\bapocalypsi\b', 'apocalypsis'),
    (r'\bapocalypsin\b', 'apocalypsis'),
    (r'\bapocalypsis\b', 'apocalypsis'),
    (r'\bapocarteresin\b', 'apocarteresis'),
    (r'\bapocatastasin\b', 'apocatastasis'),
    (r'\bapocha\b', 'apocha'),
    (r'\bapochae\b', 'apocha'),
    (r'\bapocham\b', 'apocha'),
    (r'\bapocope\b', 'apocope'),
    (r'\bapocopen\b', 'apocope'),
    (r'\bapocyni\b', 'apocynon'),
    (r'\bapocyno\b', 'apocynon'),
    (r'\bapocynon\b', 'apocynon'),
    (r'\bapodictico\b', 'apodicticus'),
    (r'\bapodixin\b', 'apodixis'),
    (r'\bapodixis\b', 'apodixis'),
    (r'\bApodotosque\b', 'Apodoti'),
    (r'\bapodyteri\b', 'apodyterium'),
    (r'\bapodyterio\b', 'apodyterium'),
    (r'\bapodyterium\b', 'apodyterium'),
    (r'\bapogei\b', 'apogeus'),
    (r'\bapographon\b', 'apographon'),
    (r'\bapolactizo\b', 'apolactizo'),
    (r'\bapolecti\b', 'apolectus'),
    (r'\bapolectos\b', 'apolectus'),
    (r'\bapolectum\b', 'apolectus'),
    (r'\bapoli\b', 'a-polio1'),
    (r'\bapollinare\b', 'apollinaris'),
    (r'\bApollinare\b', 'a-polio1'),
    (r'\bApollinare\b', 'apollinaris'),
    (r'\bapollinarem\b', 'apollinaris'),
    (r'\bApollinarem\b', 'apollinaris'),
    (r'\bapollinares\b', 'apollinaris'),
    (r'\bApollinares\b', 'apollinaris'),
    (r'\bapollinari\b', 'apollinaris'),
    (r'\bApollinari\b', 'apollinaris'),
    (r'\bApollinari\b', 'a-polio1'),
    (r'\bapollinaribus\b', 'apollinaris'),
    (r'\bApollinaribus\b', 'apollinaris'),
    (r'\bApollinaribus\b', 'a-polio1'),
    (r'\bapollinaris\b', 'apollinaris'),
    (r'\bApollinaris\b', 'apollinaris'),
    (r'\bApollinaris\b', 'a-polio1'),
    (r'\bapollinarium\b', 'apollinaris'),
    (r'\bApollinarium\b', 'apollinaris'),
    (r'\bApolline\b', 'Apollo'),
    (r'\bApollinea\b', 'Apollineus'),
    (r'\bApollineae\b', 'Apollineus'),
    (r'\bApollineam\b', 'Apollineus'),
    (r'\bApollineas\b', 'Apollineus'),
    (r'\bApollineasque\b', 'Apollineus'),
    (r'\bApollinei\b', 'Apollineus'),
    (r'\bApollineis\b', 'Apollineus'),
    (r'\bApollinem\b', 'Apollo'),
    (r'\bApollinemne\b', 'Apollo'),
    (r'\bApollinemque\b', 'Apollo'),
    (r'\bApollineo\b', 'Apollineus'),
    (r'\bApollineos\b', 'Apollineus'),
    (r'\bApollines\b', 'Apollo'),
    (r'\bApollineus\b', 'Apollineus'),
    (r'\bApollini\b', 'Apollo'),
    (r'\bApollinique\b', 'Apollo'),
    (r'\bApollinis\b', 'Apollo'),
    (r'\bApollinum\b', 'Apollo'),
    (r'\bApollo\b', 'Apollo'),
    (r'\bApollodori\b', 'Apollodorus'),
    (r'\bApollodoro\b', 'Apollodorus'),
    (r'\bApollodorum\b', 'Apollodorus'),
    (r'\bApollodorus\b', 'Apollodorus'),
    (r'\bApollon\b', 'Apollo'),
    (r'\bApolloni\b', 'Apollonius'),
    (r'\bApollonia\b', 'Apollonia'),
    (r'\bApolloniae\b', 'Apollonia'),
    (r'\bApolloniam\b', 'Apollonia'),
    (r'\bApolloniatae\b', 'Apollonidenses'),
    (r'\bApolloniatae\b', 'Apollonidenses'),
    (r'\bApolloniatarum\b', 'Apollonidenses'),
    (r'\bApolloniatas\b', 'Apollonidenses'),
    (r'\bApolloniates\b', 'Apollonidenses'),
    (r'\bApolloniati\b', 'Apollonidenses'),
    (r'\bApolloniaticum\b', 'Apollonidenses'),
    (r'\bApolloniatis\b', 'Apollonidenses'),
    (r'\bApollonide\b', 'Apollonides'),
    (r'\bApollonide\b', 'Apollonius'),
    (r'\bApollonidem\b', 'Apollonius'),
    (r'\bApolloniden\b', 'Apollonides'),
    (r'\bApollonidenses\b', 'Apollonidenses'),
    (r'\bApollonidensibus\b', 'Apollonidenses'),
    (r'\bApollonidensis\b', 'Apollonidenses'),
    (r'\bApollonides\b', 'Apollonides'),
    (r'\bApollonides\b', 'Apollonius'),
    (r'\bApollonidi\b', 'Apollonides'),
    (r'\bApollonidi\b', 'Apollonius'),
    (r'\bApolloniensem\b', 'Apollonius'),
    (r'\bApolloniensi\b', 'Apollonius'),
    (r'\bApolloniensis\b', 'Apollonius'),
    (r'\bApolloniensis\b', 'Apollonius'),
    (r'\bApollonii\b', 'Apollonius'),
    (r'\bApollonio\b', 'Apollonius'),
    (r'\bApollonios\b', 'Apollonius'),
    (r'\bApollonis\b', 'Apollonius'),
    (r'\bApollonium\b', 'Apollonius'),
    (r'\bApollonius\b', 'Apollonius'),
    (r'\bapologationem\b', 'apologatio'),
    (r'\bapologavit\b', 'apologo'),
    (r'\bapologia\b', 'apologia'),
    (r'\bapologis\b', 'apologus'),
    (r'\bapologo\b', 'apologus'),
    (r'\bapologo\b', 'apologo'),
    (r'\bapologorum\b', 'apologus'),
    (r'\bapologos\b', 'apologus'),
    (r'\bapologum\b', 'apologus'),
    (r'\bapologus\b', 'apologus'),
    (r'\bAponi\b', 'a-pono'),
    (r'\bAponi\b', 'a-pono'),
    (r'\baponi\b', 'a-pono'),
    (r'\bAponio\b', 'a-pono'),
    (r'\bAponium\b', 'a-pono'),
    (r'\bAponius\b', 'a-pono'),
    (r'\bAponius\b', 'a-pono'),
    (r'\bApono\b', 'a-pono'),
    (r'\bapono\b', 'a-pono'),
    (r'\bAponus\b', 'a-pono'),
    (r'\bapophoreta\b', 'apophoreta'),
    (r'\bapophoretis\b', 'apophoreta'),
    (r'\bapoplexi\b', 'apoplexia'),
    (r'\bapoplexin\b', 'apoplexia'),
    (r'\bapopsi\b', 'apopsis'),
    (r'\baporia\b', 'aporia'),
    (r'\baporiamur\b', 'aporior'),
    (r'\baporiatus\b', 'aporior'),
    (r'\baposiopesin\b', 'aposiopesis'),
    (r'\baposiopesis\b', 'aposiopesis'),
    (r'\baposphragisma\b', 'aposphragisma'),
    (r'\bapostata\b', 'apostata'),
    (r'\bapostata\b', 'apostato'),
    (r'\bapostatae\b', 'apostata'),
    (r'\bapostatare\b', 'apostato'),
    (r'\bapostatrices\b', 'apostatrix'),
    (r'\bapostemata\b', 'apostema'),
    (r'\bapostolatum\b', 'apostolatus'),
    (r'\bapostolatus\b', 'apostolatus'),
    (r'\bapostoli\b', 'apostolus'),
    (r'\bapostolica\b', 'apostolicus'),
    (r'\bapostolicum\b', 'apostolicus'),
    (r'\bapostolis\b', 'apostolus'),
    (r'\bapostolo\b', 'apostolus'),
    (r'\bapostolorum\b', 'apostolus'),
    (r'\bapostolos\b', 'apostolus'),
    (r'\bapostolum\b', 'apostolus'),
    (r'\bapostolus\b', 'apostolus'),
    (r'\bapostropha\b', 'apostrophe'),
    (r'\bapostropham\b', 'apostrophe'),
    (r'\bapostrophe\b', 'apostrophe'),
    (r'\bapostrophe\b', 'apostrophos'),
    (r'\bapostrophum\b', 'apostrophos'),
    (r'\bapotheca\b', 'apotheca'),
    (r'\bapotheca\b', 'apotheco'),
    (r'\bapothecae\b', 'apotheca'),
    (r'\bapothecam\b', 'apotheca'),
    (r'\bapothecas\b', 'apotheca'),
    (r'\bapothecas\b', 'apotheco'),
    (r'\bapothecis\b', 'apotheca'),
    (r'\bapotheosin\b', 'apotheosis'),
    (r'\bappara\b', 'appario'),
    (r'\bapparabant\b', 'appario'),
    (r'\bapparabantur\b', 'appario'),
    (r'\bapparabas\b', 'appario'),
    (r'\bapparabat\b', 'appario'),
    (r'\bapparabatur\b', 'appario'),
    (r'\bapparabitis\b', 'appario'),
    (r'\bapparanda\b', 'appario'),
    (r'\bapparandae\b', 'appario'),
    (r'\bapparandi\b', 'appario'),
    (r'\bapparandis\b', 'appario'),
    (r'\bapparando\b', 'appario'),
    (r'\bapparantem\b', 'appario'),
    (r'\bapparantur\b', 'appario'),
    (r'\bapparanturque\b', 'appario'),
    (r'\bapparare\b', 'appario'),
    (r'\bappararent\b', 'appario'),
    (r'\bappararentur\b', 'appario'),
    (r'\bappararet\b', 'appario'),
    (r'\bappararetur\b', 'appario'),
    (r'\bapparari\b', 'appario'),
    (r'\bappararier\b', 'appario'),
    (r'\bappararit\b', 'appario'),
    (r'\bapparas\b', 'appario'),
    (r'\bapparasset\b', 'appario'),
    (r'\bapparat\b', 'appario'),
    (r'\bapparata\b', 'appario'),
    (r'\bapparatas\b', 'appario'),
    (r'\bapparate\b', 'apparate'),
    (r'\bapparate\b', 'appario'),
    (r'\bapparateque\b', 'apparate'),
    (r'\bapparateque\b', 'appario'),
    (r'\bapparati\b', 'appario'),
    (r'\bapparatibus\b', 'apparatus2'),
    (r'\bapparatior\b', 'appario'),
    (r'\bapparatiores\b', 'appario'),
    (r'\bapparatioribus\b', 'appario'),
    (r'\bapparatis\b', 'appario'),
    (r'\bapparatisque\b', 'appario'),
    (r'\bapparatissimas\b', 'appario'),
    (r'\bapparatissimi\b', 'appario'),
    (r'\bapparatissimo\b', 'appario'),
    (r'\bapparatissimos\b', 'appario'),
    (r'\bapparatissimosque\b', 'appario'),
    (r'\bapparatissimum\b', 'appario'),
    (r'\bapparator\b', 'apparator'),
    (r'\bapparatos\b', 'appario'),
    (r'\bapparatu\b', 'apparatus2'),
    (r'\bapparatu\b', 'appario'),
    (r'\bapparatum\b', 'apparatus2'),
    (r'\bapparatum\b', 'appario'),
    (r'\bapparatumque\b', 'apparatus2'),
    (r'\bapparatumque\b', 'appario'),
    (r'\bapparatuque\b', 'apparatus2'),
    (r'\bapparatuque\b', 'appario'),
    (r'\bapparatur\b', 'appario'),
    (r'\bapparatus\b', 'apparatus2'),
    (r'\bapparatus\b', 'appario'),
    (r'\bapparatusque\b', 'apparatus2'),
    (r'\bapparatusque\b', 'appario'),
    (r'\bapparauit\b', 'appario'),
    (r'\bapparavit\b', 'appario'),
    (r'\bappare\b', 'appareo'),
    (r'\bappareant\b', 'appareo'),
    (r'\bappareantque\b', 'appareo'),
    (r'\bappareas\b', 'appareo'),
    (r'\bappareat\b', 'appareo'),
    (r'\bappareatque\b', 'appareo'),
    (r'\bapparebant\b', 'appareo'),
    (r'\bapparebat\b', 'appareo'),
    (r'\bapparebatque\b', 'appareo'),
    (r'\bapparebis\b', 'appareo'),
    (r'\bapparebit\b', 'appareo'),
    (r'\bapparebitis\b', 'appareo'),
    (r'\bapparebo\b', 'appareo'),
    (r'\bapparebunt\b', 'appareo'),
    (r'\bapparem\b', 'appario'),
    (r'\bapparens\b', 'appareo'),
    (r'\bapparent\b', 'appareo'),
    (r'\bapparent\b', 'appario'),
    (r'\bapparente\b', 'appareo'),
    (r'\bapparentem\b', 'appareo'),
    (r'\bapparentes\b', 'appareo'),
    (r'\bapparentia\b', 'apparentia'),
    (r'\bapparentia\b', 'appareo'),
    (r'\bapparentibus\b', 'appareo'),
    (r'\bapparentis\b', 'appareo'),
    (r'\bapparento\b', 'appareo'),
    (r'\bapparentur\b', 'appareo'),
    (r'\bapparentur\b', 'appario'),
    (r'\bappareo\b', 'appareo'),
    (r'\bapparere\b', 'appareo'),
    (r'\bapparere\b', 'appario'),
    (r'\bapparerent\b', 'appareo'),
    (r'\bappareret\b', 'appareo'),
    (r'\bappareretque\b', 'appareo'),
    (r'\bappares\b', 'appareo'),
    (r'\bappares\b', 'appario'),
    (r'\bapparescebant\b', 'apparesco'),
    (r'\bapparescens\b', 'apparesco'),
    (r'\bapparescentem\b', 'apparesco'),
    (r'\bapparet\b', 'appareo'),
    (r'\bapparet\b', 'appario'),
    (r'\bapparetque\b', 'appareo'),
    (r'\bapparetque\b', 'appario'),
    (r'\bapparetur\b', 'appareo'),
    (r'\bapparetur\b', 'appario'),
    (r'\bapparitione\b', 'apparitio'),
    (r'\bapparitionibus\b', 'apparitio'),
    (r'\bapparitor\b', 'apparitor'),
    (r'\bapparitore\b', 'apparitor'),
    (r'\bapparitorem\b', 'apparitor'),
    (r'\bapparitores\b', 'apparitor'),
    (r'\bapparitoresque\b', 'apparitor'),
    (r'\bapparitori\b', 'apparitor'),
    (r'\bapparitoribus\b', 'apparitor'),
    (r'\bapparitorum\b', 'apparitor'),
    (r'\bapparitorum\b', 'appareo'),
    (r'\bapparituram\b', 'apparitura'),
    (r'\bapparituram\b', 'appareo'),
    (r'\bappariturum\b', 'appareo'),
    (r'\bapparo\b', 'appario'),
    (r'\bapparuerant\b', 'appareo'),
    (r'\bapparuerat\b', 'appareo'),
    (r'\bapparuere\b', 'appareo'),
    (r'\bapparuerimus\b', 'appareo'),
    (r'\bapparuerint\b', 'appareo'),
    (r'\bapparueris\b', 'appareo'),
    (r'\bapparuerit\b', 'appareo'),
    (r'\bapparuerunt\b', 'appareo'),
    (r'\bapparui\b', 'appareo'),
    (r'\bapparuisse\b', 'appareo'),
    (r'\bapparuissent\b', 'appareo'),
    (r'\bapparuisses\b', 'appareo'),
    (r'\bapparuisset\b', 'appareo'),
    (r'\bapparuistis\b', 'appareo'),
    (r'\bapparuit\b', 'appareo'),
    (r'\bapparuitque\b', 'appareo'),
    (r'\bappella\b', 'appello1'),
    (r'\bappellabam\b', 'appello1'),
    (r'\bappellabant\b', 'appello1'),
    (r'\bappellabantur\b', 'appello1'),
    (r'\bappellabaris\b', 'appello1'),
    (r'\bappellabas\b', 'appello1'),
    (r'\bappellabat\b', 'appello1'),
    (r'\bappellabatque\b', 'appello1'),
    (r'\bappellabatur\b', 'appello1'),
    (r'\bappellaberis\b', 'appello1'),
    (r'\bappellabimus\b', 'appello1'),
    (r'\bappellabis\b', 'appello1'),
    (r'\bappellabit\b', 'appello1'),
    (r'\bappellabitis\b', 'appello1'),
    (r'\bappellabitur\b', 'appello1'),
    (r'\bappellabo\b', 'appello1'),
    (r'\bappellabunt\b', 'appello1'),
    (r'\bappellabuntur\b', 'appello1'),
    (r'\bappellamur\b', 'appello1'),
    (r'\bappellamur\b', 'appello1'),
    (r'\bappellamus\b', 'appello1'),
    (r'\bappellamus\b', 'appello1'),
    (r'\bappellanda\b', 'appello1'),
    (r'\bappellandae\b', 'appello1'),
    (r'\bappellandam\b', 'appello1'),
    (r'\bappellandarum\b', 'appello1'),
    (r'\bappellandas\b', 'appello1'),
    (r'\bappellandi\b', 'appello1'),
    (r'\bappellandis\b', 'appello1'),
    (r'\bappellando\b', 'appello1'),
    (r'\bappellandorum\b', 'appello1'),
    (r'\bappellandos\b', 'appello1'),
    (r'\bappellandum\b', 'appello1'),
    (r'\bappellandus\b', 'appello1'),
    (r'\bappellans\b', 'appello1'),
    (r'\bappellansque\b', 'appello1'),
    (r'\bappellant\b', 'appello1'),
    (r'\bappellant\b', 'appello1'),
    (r'\bappellante\b', 'appello1'),
    (r'\bappellantem\b', 'appello1'),
    (r'\bappellantes\b', 'appello1'),
    (r'\bappellanti\b', 'appello1'),
    (r'\bappellantibus\b', 'appello1'),
    (r'\bappellantibusque\b', 'appello1'),
    (r'\bappellantis\b', 'appello1'),
    (r'\bappellantium\b', 'appello1'),
    (r'\bappellantque\b', 'appello1'),
    (r'\bappellantque\b', 'appello1'),
    (r'\bappellantur\b', 'appello1'),
    (r'\bappellantur\b', 'appello1'),
    (r'\bappellanturque\b', 'appello1'),
    (r'\bappellanturque\b', 'appello1'),
    (r'\bappellar\b', 'appello1'),
    (r'\bappellaras\b', 'appello1'),
    (r'\bappellarat\b', 'appello1'),
    (r'\bappellare\b', 'appello1'),
    (r'\bappellare\b', 'appello1'),
    (r'\bappellarem\b', 'appello1'),
    (r'\bappellaremur\b', 'appello1'),
    (r'\bappellaremus\b', 'appello1'),
    (r'\bappellarent\b', 'appello1'),
    (r'\bappellarentur\b', 'appello1'),
    (r'\bappellareque\b', 'appello1'),
    (r'\bappellareque\b', 'appello1'),
    (r'\bappellares\b', 'appello1'),
    (r'\bappellaret\b', 'appello1'),
    (r'\bappellaretur\b', 'appello1'),
    (r'\bappellari\b', 'appello1'),
    (r'\bappellarint\b', 'appello1'),
    (r'\bappellarique\b', 'appello1'),
    (r'\bappellaris\b', 'appello1'),
    (r'\bappellaris\b', 'appello1'),
    (r'\bappellarisne\b', 'appello1'),
    (r'\bappellarisne\b', 'appello1'),
    (r'\bappellarit\b', 'appello1'),
    (r'\bappellarunt\b', 'appello1'),
    (r'\bappellas\b', 'appello1'),
    (r'\bappellas\b', 'appello1'),
    (r'\bappellasse\b', 'appello1'),
    (r'\bappellassem\b', 'appello1'),
    (r'\bappellassent\b', 'appello1'),
    (r'\bappellasses\b', 'appello1'),
    (r'\bappellasset\b', 'appello1'),
    (r'\bappellassetis\b', 'appello1'),
    (r'\bappellassetque\b', 'appello1'),
    (r'\bappellasti\b', 'appello1'),
    (r'\bappellat\b', 'appello1'),
    (r'\bappellat\b', 'appello1'),
    (r'\bappellata\b', 'appello1'),
    (r'\bappellatae\b', 'appello1'),
    (r'\bappellatam\b', 'appello1'),
    (r'\bappellatamque\b', 'appello1'),
    (r'\bappellataque\b', 'appello1'),
    (r'\bappellatarum\b', 'appello1'),
    (r'\bappellatas\b', 'appello1'),
    (r'\bappellatasque\b', 'appello1'),
    (r'\bappellate\b', 'appello1'),
    (r'\bappellati\b', 'appello1'),
    (r'\bappellatio\b', 'appellatio'),
    (r'\bappellatione\b', 'appellatio'),
    (r'\bappellationem\b', 'appellatio'),
    (r'\bappellationes\b', 'appellatio'),
    (r'\bappellationi\b', 'appellatio'),
    (r'\bappellationibus\b', 'appellatio'),
    (r'\bappellationis\b', 'appellatio'),
    (r'\bappellationum\b', 'appellatio'),
    (r'\bappellatique\b', 'appello1'),
    (r'\bappellatis\b', 'appello1'),
    (r'\bappellatis\b', 'appello1'),
    (r'\bappellatisque\b', 'appello1'),
    (r'\bappellatisque\b', 'appello1'),
    (r'\bappellativa\b', 'appellativus'),
    (r'\bappellativis\b', 'appellativus'),
    (r'\bappellativo\b', 'appellativus'),
    (r'\bappellativorum\b', 'appellativus'),
    (r'\bappellativum\b', 'appellativus'),
    (r'\bappellato\b', 'appello1'),
    (r'\bappellatore\b', 'appellator'),
    (r'\bappellatori\b', 'appellator'),
    (r'\bappellatori\b', 'appellatorius'),
    (r'\bappellatoria\b', 'appellatorius'),
    (r'\bappellatoribus\b', 'appellator'),
    (r'\bappellatorii\b', 'appellatorius'),
    (r'\bappellatorios\b', 'appellatorius'),
    (r'\bappellatos\b', 'appello1'),
    (r'\bappellatosque\b', 'appello1'),
    (r'\bappellatu\b', 'appello1'),
    (r'\bappellatum\b', 'appello1'),
    (r'\bappellatumque\b', 'appello1'),
    (r'\bappellatur\b', 'appello1'),
    (r'\bappellatur\b', 'appello1'),
    (r'\bappellaturi\b', 'appello1'),
    (r'\bappellaturum\b', 'appello1'),
    (r'\bappellaturus\b', 'appello1'),
    (r'\bappellatus\b', 'appello1'),
    (r'\bappellatusque\b', 'appello1'),
    (r'\bappellauerant\b', 'appello1'),
    (r'\bappellauerat\b', 'appello1'),
    (r'\bappellauere\b', 'appello1'),
    (r'\bappellauerim\b', 'appello1'),
    (r'\bappellauerint\b', 'appello1'),
    (r'\bappellaueris\b', 'appello1'),
    (r'\bappellauerit\b', 'appello1'),
    (r'\bappellauero\b', 'appello1'),
    (r'\bappellauerunt\b', 'appello1'),
    (r'\bappellaui\b', 'appello1'),
    (r'\bappellauisset\b', 'appello1'),
    (r'\bappellauit\b', 'appello1'),
    (r'\bappellauitque\b', 'appello1'),
    (r'\bappellaverant\b', 'appello1'),
    (r'\bappellaveras\b', 'appello1'),
    (r'\bappellaverat\b', 'appello1'),
    (r'\bappellavere\b', 'appello1'),
    (r'\bappellaverim\b', 'appello1'),
    (r'\bappellaverint\b', 'appello1'),
    (r'\bappellaverit\b', 'appello1'),
    (r'\bappellaverunt\b', 'appello1'),
    (r'\bappellavi\b', 'appello1'),
    (r'\bappellavimus\b', 'appello1'),
    (r'\bappellavisse\b', 'appello1'),
    (r'\bappellavisset\b', 'appello1'),
    (r'\bappellavistis\b', 'appello1'),
    (r'\bappellavit\b', 'appello1'),
    (r'\bappellavitque\b', 'appello1'),
    (r'\bappelle\b', 'appello1'),
    (r'\bappellebat\b', 'appello1'),
    (r'\bappellem\b', 'appello1'),
    (r'\bappellemus\b', 'appello1'),
    (r'\bappellemus\b', 'appello1'),
    (r'\bappellendi\b', 'appello1'),
    (r'\bappellendum\b', 'appello1'),
    (r'\bappellent\b', 'appello1'),
    (r'\bappellent\b', 'appello1'),
    (r'\bappellentis\b', 'appello1'),
    (r'\bappellentur\b', 'appello1'),
    (r'\bappellentur\b', 'appello1'),
    (r'\bappeller\b', 'appello1'),
    (r'\bappellere\b', 'appello1'),
    (r'\bappellere\b', 'appello1'),
    (r'\bappelleret\b', 'appello1'),
    (r'\bappelleretur\b', 'appello1'),
    (r'\bappelleris\b', 'appello1'),
    (r'\bappelleris\b', 'appello1'),
    (r'\bappelles\b', 'appello1'),
    (r'\bappelles\b', 'appello1'),
    (r'\bappellesque\b', 'appello1'),
    (r'\bappellesque\b', 'appello1'),
    (r'\bappellet\b', 'appello1'),
    (r'\bappellet\b', 'appello1'),
    (r'\bappelletis\b', 'appello1'),
    (r'\bappelletis\b', 'appello1'),
    (r'\bappelletur\b', 'appello1'),
    (r'\bappelletur\b', 'appello1'),
    (r'\bappelli\b', 'appello1'),
    (r'\bappellis\b', 'appello1'),
    (r'\bappellitabat\b', 'appellito'),
    (r'\bappellitabatis\b', 'appellito'),
    (r'\bappellitantur\b', 'appellito'),
    (r'\bappellitarim\b', 'appellito'),
    (r'\bappellitatum\b', 'appellito'),
    (r'\bappellitauerunt\b', 'appellito'),
    (r'\bappellite\b', 'appello1'),
    (r'\bappellitur\b', 'appello1'),
    (r'\bappello\b', 'appello1'),
    (r'\bappellor\b', 'appello1'),
    (r'\bappellunt\b', 'appello1'),
    (r'\bappelluntque\b', 'appello1'),
    (r'\bappendantur\b', 'appendo'),
    (r'\bappende\b', 'appendo'),
    (r'\bappendebat\b', 'appendo'),
    (r'\bappendere\b', 'appendo'),
    (r'\bappendi\b', 'appendo'),
    (r'\bappendicula\b', 'appendicula'),
    (r'\bappendit\b', 'appendo'),
    (r'\bappenduntur\b', 'appendo'),
    (r'\bAppennini\b', 'Apenninus'),
    (r'\bAppenninis\b', 'Apenninus'),
    (r'\bAppennino\b', 'Apenninus'),
    (r'\bAppenninoque\b', 'Apenninus'),
    (r'\bAppenninos\b', 'Apenninus'),
    (r'\bAppenninum\b', 'Apenninus'),
    (r'\bAppenninumque\b', 'Apenninus'),
    (r'\bAppenninus\b', 'Apenninus'),
    (r'\bappensa\b', 'appendo'),
    (r'\bappensa\b', 'appensor'),
    (r'\bappensae\b', 'appendo'),
    (r'\bappensum\b', 'appendo'),
    (r'\bappetam\b', 'appeto1'),
    (r'\bappetant\b', 'appeto1'),
    (r'\bappetantur\b', 'appeto1'),
    (r'\bappetas\b', 'appeto1'),
    (r'\bappetat\b', 'appeto1'),
    (r'\bappetatur\b', 'appeto1'),
    (r'\bappetebam\b', 'appeto1'),
    (r'\bappetebant\b', 'appeto1'),
    (r'\bappetebat\b', 'appeto1'),
    (r'\bappetenda\b', 'appeto1'),
    (r'\bappetendam\b', 'appeto1'),
    (r'\bappetendarum\b', 'appeto1'),
    (r'\bappetendi\b', 'appeto1'),
    (r'\bappetendis\b', 'appeto1'),
    (r'\bappetendo\b', 'appeto1'),
    (r'\bappetendorum\b', 'appeto1'),
    (r'\bappetendum\b', 'appeto1'),
    (r'\bappetens\b', 'appeto1'),
    (r'\bappetensque\b', 'appeto1'),
    (r'\bappetentem\b', 'appeto1'),
    (r'\bappetentes\b', 'appeto1'),
    (r'\bappetenti\b', 'appeto1'),
    (r'\bappetentis\b', 'appeto1'),
    (r'\bappetentissimus\b', 'appeto1'),
    (r'\bappetentius\b', 'appeto1'),
    (r'\bappetere\b', 'appeto1'),
    (r'\bappeterem\b', 'appeto1'),
    (r'\bappeterent\b', 'appeto1'),
    (r'\bappeteres\b', 'appeto1'),
    (r'\bappeteret\b', 'appeto1'),
    (r'\bappetes\b', 'appeto1'),
    (r'\bappetet\b', 'appeto1'),
    (r'\bappeti\b', 'appeto1'),
    (r'\bappetibiles\b', 'appetibilis'),
    (r'\bappetierint\b', 'adquiesco'),
    (r'\bappetieris\b', 'adquiesco'),
    (r'\bappetierit\b', 'adquiesco'),
    (r'\bappetii\b', 'adquiesco'),
    (r'\bappetiit\b', 'adquiesco'),
    (r'\bappetimus\b', 'appeto1'),
    (r'\bappetis\b', 'appeto1'),
    (r'\bappetisse\b', 'appeto1'),
    (r'\bappetisse\b', 'appetisso'),
    (r'\bappetissem\b', 'appeto1'),
    (r'\bappetisset\b', 'appetisso'),
    (r'\bappetisset\b', 'appeto1'),
    (r'\bappetisti\b', 'appeto1'),
    (r'\bappetit\b', 'appeto1'),
    (r'\bappetita\b', 'appeto1'),
    (r'\bappetitam\b', 'appeto1'),
    (r'\bappetitas\b', 'appeto1'),
    (r'\bappetiti\b', 'appeto1'),
    (r'\bappetitio\b', 'appetitio'),
    (r'\bappetitione\b', 'appetitio'),
    (r'\bappetitionem\b', 'appetitio'),
    (r'\bappetitionesque\b', 'appetitio'),
    (r'\bappetitionis\b', 'appetitio'),
    (r'\bappetitis\b', 'appeto1'),
    (r'\bappetito\b', 'appeto1'),
    (r'\bappetitor\b', 'appetitor'),
    (r'\bappetitu\b', 'appetitus2'),
    (r'\bappetitu\b', 'appeto1'),
    (r'\bappetitum\b', 'appetitus2'),
    (r'\bappetitum\b', 'appeto1'),
    (r'\bappetitur\b', 'appeto1'),
    (r'\bappetituros\b', 'appeto1'),
    (r'\bappetiturus\b', 'appeto1'),
    (r'\bappetitus\b', 'appetitus2'),
    (r'\bappetitus\b', 'appeto1'),
    (r'\bappetitusque\b', 'appetitus2'),
    (r'\bappetitusque\b', 'appeto1'),
    (r'\bappetiuere\b', 'appeto1'),
    (r'\bappetiuimus\b', 'appeto1'),
    (r'\bappetiuit\b', 'appeto1'),
    (r'\bappetiverunt\b', 'appeto1'),
    (r'\bappetivi\b', 'appeto1'),
    (r'\bappetivit\b', 'appeto1'),
    (r'\bappeto\b', 'appeto2'),
    (r'\bappeto\b', 'appeto1'),
    (r'\bappetonibus\b', 'appeto2'),
    (r'\bappetunt\b', 'appeto1'),
    (r'\bappetuntur\b', 'appeto1'),
    (r'\bAppi\b', 'Appius'),
    (r'\bAppia\b', 'Appia'),
    (r'\bAppia\b', 'Appius'),
    (r'\bappia\b', 'adquiesco'),
    (r'\bAppiades\b', 'Appias'),
    (r'\bAppiadesque\b', 'Appias'),
    (r'\bAppiae\b', 'Appia'),
    (r'\bappiae\b', 'adquiesco'),
    (r'\bAppiam\b', 'Appia'),
    (r'\bAppiana\b', 'Appianus1'),
    (r'\bAppianae\b', 'Appianus1'),
    (r'\bAppianarum\b', 'Appianus1'),
    (r'\bAppianas\b', 'Appianus1'),
    (r'\bAppiani\b', 'Appianus1'),
    (r'\bAppiani\b', 'Appianus1'),
    (r'\bAppianis\b', 'Appianus1'),
    (r'\bAppianis\b', 'Appianus1'),
    (r'\bAppiano\b', 'Appianus1'),
    (r'\bAppianum\b', 'Appianus1'),
    (r'\bAppianum\b', 'Appianus1'),
    (r'\bAppias\b', 'Appia'),
    (r'\bAppias\b', 'Appias'),
    (r'\bappias\b', 'adquiesco'),
    (r'\bAppietatem\b', 'Appietas'),
    (r'\bAppii\b', 'Appius'),
    (r'\bAppiis\b', 'Appia'),
    (r'\bAppiis\b', 'Appius'),
    (r'\bappinge\b', 'appingo1'),
    (r'\bappingere\b', 'appingo1'),
    (r'\bAppio\b', 'Appius'),
    (r'\bappio\b', 'adquiesco'),
    (r'\bAppios\b', 'Appius'),
    (r'\bAppium\b', 'Appius'),
    (r'\bAppius\b', 'Appius'),
    (r'\bAppiusque\b', 'Appius'),
    (r'\bapplausu\b', 'applaudo'),
    (r'\bapplica\b', 'applex'),
    (r'\bapplica\b', 'applico'),
    (r'\bapplicabat\b', 'applico'),
    (r'\bapplicamus\b', 'applico'),
    (r'\bapplicandum\b', 'applico'),
    (r'\bapplicans\b', 'applico'),
    (r'\bapplicansque\b', 'applico'),
    (r'\bapplicant\b', 'applico'),
    (r'\bapplicantes\b', 'applico'),
    (r'\bapplicantque\b', 'applico'),
    (r'\bapplicantur\b', 'applico'),
    (r'\bapplicare\b', 'applico'),
    (r'\bapplicarent\b', 'applico'),
    (r'\bapplicarentur\b', 'applico'),
    (r'\bapplicaret\b', 'applico'),
    (r'\bapplicaretur\b', 'applico'),
    (r'\bapplicari\b', 'applico'),
    (r'\bapplicat\b', 'applico'),
    (r'\bapplicationis\b', 'applicatio'),
    (r'\bapplicato\b', 'applico'),
    (r'\bapplicatur\b', 'applico'),
    (r'\bapplicem\b', 'applex'),
    (r'\bapplicem\b', 'applico'),
    (r'\bapplicemus\b', 'applico'),
    (r'\bapplicent\b', 'applico'),
    (r'\bapplicentur\b', 'applico'),
    (r'\bapplices\b', 'applex'),
    (r'\bapplices\b', 'applico'),
    (r'\bapplicet\b', 'applico'),
    (r'\bapplicetur\b', 'applico'),
    (r'\bapplicita\b', 'applico'),
    (r'\bapplicitas\b', 'applico'),
    (r'\bappliciti\b', 'applico'),
    (r'\bapplicito\b', 'applico'),
    (r'\bapplicitum\b', 'applico'),
    (r'\bapplicitus\b', 'applico'),
    (r'\bapplicor\b', 'applico'),
    (r'\bapplicuerant\b', 'applico'),
    (r'\bapplicuerat\b', 'applico'),
    (r'\bapplicueris\b', 'applico'),
    (r'\bapplicuerit\b', 'applico'),
    (r'\bapplicuerunt\b', 'applico'),
    (r'\bapplicui\b', 'applico'),
    (r'\bapplicuisse\b', 'applico'),
    (r'\bapplicuissent\b', 'applico'),
    (r'\bapplicuit\b', 'applico'),
    (r'\bapponam\b', 'appono'),
    (r'\bapponas\b', 'appono'),
    (r'\bapponat\b', 'appono'),
    (r'\bapponatur\b', 'appono'),
    (r'\bappone\b', 'appono'),
    (r'\bapponebant\b', 'appono'),
    (r'\bapponebat\b', 'appono'),
    (r'\bapponebatur\b', 'appono'),
    (r'\bapponendo\b', 'appono'),
    (r'\bapponendum\b', 'appono'),
    (r'\bapponens\b', 'appono'),
    (r'\bapponere\b', 'appono'),
    (r'\bapponerentur\b', 'appono'),
    (r'\bapponeret\b', 'appono'),
    (r'\bappones\b', 'appono'),
    (r'\bapponesque\b', 'appono'),
    (r'\bapponet\b', 'appono'),
    (r'\bapponi\b', 'appono'),
    (r'\bapponit\b', 'appono'),
    (r'\bapponite\b', 'appono'),
    (r'\bapponito\b', 'appono'),
    (r'\bapponitur\b', 'appono'),
    (r'\bappono\b', 'appono'),
    (r'\bapponunt\b', 'appono'),
    (r'\bapportabunt\b', 'apporto'),
    (r'\bapportanda\b', 'apporto'),
    (r'\bapportans\b', 'apporto'),
    (r'\bapportarat\b', 'apporto'),
    (r'\bapportarentur\b', 'apporto'),
    (r'\bapportari\b', 'apporto'),
    (r'\bapportat\b', 'apporto'),
    (r'\bapportata\b', 'apporto'),
    (r'\bapportaturos\b', 'apporto'),
    (r'\bapportes\b', 'apporto'),
    (r'\bapportet\b', 'apporto'),
    (r'\bapporto\b', 'apporto'),
    (r'\bapposita\b', 'appositum'),
    (r'\bapposita\b', 'applumbo'),
    (r'\bappositam\b', 'applumbo'),
    (r'\bapposite\b', 'apposite'),
    (r'\bapposite\b', 'appositum'),
    (r'\bapposite\b', 'applumbo'),
    (r'\bappositi\b', 'appositum'),
    (r'\bappositi\b', 'applumbo'),
    (r'\bappositionem\b', 'appositio'),
    (r'\bappositior\b', 'applumbo'),
    (r'\bappositique\b', 'appositum'),
    (r'\bappositique\b', 'applumbo'),
    (r'\bappositis\b', 'appositum'),
    (r'\bappositis\b', 'applumbo'),
    (r'\bappositissima\b', 'applumbo'),
    (r'\bappositissimae\b', 'applumbo'),
    (r'\bapposito\b', 'appositum'),
    (r'\bapposito\b', 'applumbo'),
    (r'\bappositos\b', 'applumbo'),
    (r'\bappositu\b', 'appositus2'),
    (r'\bappositu\b', 'applumbo'),
    (r'\bappositum\b', 'appositus2'),
    (r'\bappositum\b', 'appositum'),
    (r'\bappositum\b', 'applumbo'),
    (r'\bappositumque\b', 'appositus2'),
    (r'\bappositumque\b', 'appositum'),
    (r'\bappositumque\b', 'applumbo'),
    (r'\bapposituque\b', 'appositus2'),
    (r'\bapposituque\b', 'applumbo'),
    (r'\bappositurum\b', 'applumbo'),
    (r'\bappositus\b', 'appositus2'),
    (r'\bappositus\b', 'applumbo'),
    (r'\bappostae\b', 'appono'),
    (r'\bapposuerimus\b', 'applumbo'),
    (r'\bapposueris\b', 'applumbo'),
    (r'\bapposuerunt\b', 'applumbo'),
    (r'\bapposui\b', 'applumbo'),
    (r'\bapposuisse\b', 'applumbo'),
    (r'\bapposuisset\b', 'applumbo'),
    (r'\bapposuisti\b', 'applumbo'),
    (r'\bapposuit\b', 'applumbo'),
    (r'\bappoti\b', 'appotus'),
    (r'\bapprehendas\b', 'apprehendo'),
    (r'\bapprehendens\b', 'apprehendo'),
    (r'\bapprehendentes\b', 'apprehendo'),
    (r'\bapprehenderam\b', 'apprehendo'),
    (r'\bapprehenderat\b', 'apprehendo'),
    (r'\bapprehendere\b', 'apprehendo'),
    (r'\bapprehendet\b', 'apprehendo'),
    (r'\bapprehendisset\b', 'apprehendo'),
    (r'\bapprehendit\b', 'apprehendo'),
    (r'\bapprehensa\b', 'apprehendo'),
    (r'\bapprehenso\b', 'apprehendo'),
    (r'\bapprehensum\b', 'apprehendo'),
    (r'\bapprenso\b', 'apprenso'),
    (r'\bapprime\b', 'apprimus'),
    (r'\bapprime\b', 'apprime'),
    (r'\bapprime\b', 'apprimo'),
    (r'\bapprimetve\b', 'apprimo'),
    (r'\bapproba\b', 'approbus'),
    (r'\bapproba\b', 'approbo'),
    (r'\bapprobabo\b', 'approbo'),
    (r'\bapprobabunt\b', 'approbo'),
    (r'\bapprobando\b', 'approbo'),
    (r'\bapprobant\b', 'approbo'),
    (r'\bapprobante\b', 'approbo'),
    (r'\bapprobantes\b', 'approbo'),
    (r'\bapprobantibus\b', 'approbo'),
    (r'\bapprobantium\b', 'approbo'),
    (r'\bapprobare\b', 'approbo'),
    (r'\bapprobarent\b', 'approbo'),
    (r'\bapprobaret\b', 'approbo'),
    (r'\bapprobaretur\b', 'approbo'),
    (r'\bapprobari\b', 'approbo'),
    (r'\bapprobaris\b', 'approbo'),
    (r'\bapprobasse\b', 'approbo'),
    (r'\bapprobasses\b', 'approbo'),
    (r'\bapprobat\b', 'approbo'),
    (r'\bapprobata\b', 'approbo'),
    (r'\bapprobatio\b', 'approbatio'),
    (r'\bapprobatione\b', 'approbatio'),
    (r'\bapprobationem\b', 'approbatio'),
    (r'\bapprobationemque\b', 'approbatio'),
    (r'\bapprobationes\b', 'approbatio'),
    (r'\bapprobationis\b', 'approbatio'),
    (r'\bapprobato\b', 'approbo'),
    (r'\bapprobatoresque\b', 'approbator'),
    (r'\bapprobatum\b', 'approbo'),
    (r'\bapprobatur\b', 'approbo'),
    (r'\bapprobaturum\b', 'approbo'),
    (r'\bapprobauere\b', 'approbo'),
    (r'\bapprobauit\b', 'approbo'),
    (r'\bapprobaverunt\b', 'approbo'),
    (r'\bapprobavi\b', 'approbo'),
    (r'\bapprobavisset\b', 'approbo'),
    (r'\bapprobavistis\b', 'approbo'),
    (r'\bapprobavit\b', 'approbo'),
    (r'\bapprobe\b', 'approbus'),
    (r'\bapprobe\b', 'approbe'),
    (r'\bapprobent\b', 'approbo'),
    (r'\bapprobet\b', 'approbo'),
    (r'\bapprobetur\b', 'approbo'),
    (r'\bapprobo\b', 'approbus'),
    (r'\bapprobo\b', 'approbo'),
    (r'\bappromitteret\b', 'appromitto'),
    (r'\bapproperant\b', 'appropero'),
    (r'\bapproperaret\b', 'appropero'),
    (r'\bapproperata\b', 'appropero'),
    (r'\bapproperate\b', 'appropero'),
    (r'\bapproperemus\b', 'appropero'),
    (r'\bappropiat\b', 'adquiesco'),
    (r'\bappropinquabant\b', 'appropinquo'),
    (r'\bappropinquabat\b', 'appropinquo'),
    (r'\bappropinquans\b', 'appropinquo'),
    (r'\bappropinquante\b', 'appropinquo'),
    (r'\bappropinquantem\b', 'appropinquo'),
    (r'\bappropinquantes\b', 'appropinquo'),
    (r'\bappropinquanti\b', 'appropinquo'),
    (r'\bappropinquantibus\b', 'appropinquo'),
    (r'\bappropinquantis\b', 'appropinquo'),
    (r'\bappropinquare\b', 'appropinquo'),
    (r'\bappropinquarent\b', 'appropinquo'),
    (r'\bappropinquaret\b', 'appropinquo'),
    (r'\bappropinquarunt\b', 'appropinquo'),
    (r'\bappropinquasset\b', 'appropinquo'),
    (r'\bappropinquat\b', 'appropinquo'),
    (r'\bappropinquauit\b', 'appropinquo'),
    (r'\bappropinquavit\b', 'appropinquo'),
    (r'\bappropinquet\b', 'appropinquo'),
    (r'\bAppuleia\b', 'Appuleius'),
    (r'\bAppuleiae\b', 'Appuleius'),
    (r'\bAppuleiam\b', 'Appuleius'),
    (r'\bAppuleio\b', 'Appuleius'),
    (r'\bAppuleium\b', 'Appuleius'),
    (r'\bAppuleius\b', 'Appuleius'),
    (r'\bappulerant\b', 'appello1'),
    (r'\bappulerat\b', 'appello1'),
    (r'\bappulerunt\b', 'appello1'),
    (r'\bappuli\b', 'appello1'),
    (r'\bappulisse\b', 'appello1'),
    (r'\bappulissent\b', 'appello1'),
    (r'\bappulisses\b', 'appello1'),
    (r'\bappulisset\b', 'appello1'),
    (r'\bappulisti\b', 'appello1'),
    (r'\bappulit\b', 'appello1'),
    (r'\bappulsa\b', 'appello1'),
    (r'\bappulsam\b', 'appello1'),
    (r'\bappulsi\b', 'appello1'),
    (r'\bappulsis\b', 'appello1'),
    (r'\bappulsum\b', 'appulsus2'),
    (r'\bappulsum\b', 'appello1'),
    (r'\bappulsus\b', 'appulsus2'),
    (r'\bappulsus\b', 'appello1'),
    (r'\bAppulus\b', 'apra'),
    (r'\bappungit\b', 'adquiesco'),
    (r'\bapra\b', 'apra'),
    (r'\bapraria\b', 'aprarius'),
    (r'\bapri\b', 'aper1'),
    (r'\bApri\b', 'Aper2'),
    (r'\baprica\b', 'apricus'),
    (r'\baprica\b', 'apricus'),
    (r'\baprica\b', 'aprico'),
    (r'\bapricae\b', 'apricus'),
    (r'\bapricanti\b', 'aprico'),
    (r'\bapricantur\b', 'aprico'),
    (r'\bapricari\b', 'aprico'),
    (r'\bapricas\b', 'apricus'),
    (r'\bapricas\b', 'aprico'),
    (r'\bapricatione\b', 'apricatio'),
    (r'\bapricationem\b', 'apricatio'),
    (r'\bapricetur\b', 'aprico'),
    (r'\baprici\b', 'apricus'),
    (r'\baprici\b', 'apricus'),
    (r'\bapricioribus\b', 'apricus'),
    (r'\bapricis\b', 'apricus'),
    (r'\bapricis\b', 'apricus'),
    (r'\bapricissimo\b', 'apricus'),
    (r'\bapricitas\b', 'apricitas'),
    (r'\bapricitate\b', 'apricitas'),
    (r'\bapricitatis\b', 'apricitas'),
    (r'\baprico\b', 'apricus'),
    (r'\baprico\b', 'apricus'),
    (r'\baprico\b', 'aprico'),
    (r'\bapricoque\b', 'apricus'),
    (r'\bapricoque\b', 'apricus'),
    (r'\bapricoque\b', 'aprico'),
    (r'\bapricos\b', 'apricus'),
    (r'\bapriculum\b', 'apriculus'),
    (r'\bapricum\b', 'apricus'),
    (r'\bapricum\b', 'apricus'),
    (r'\bapricus\b', 'apricus'),
    (r'\bAprile\b', 'Aprilis'),
    (r'\bAprilem\b', 'Aprilis'),
    (r'\bApriles\b', 'Aprilis'),
    (r'\bAprili\b', 'Aprilis'),
    (r'\bAprilibus\b', 'Aprilis'),
    (r'\bAprilis\b', 'Aprilis'),
    (r'\baprine\b', 'aprinus'),
    (r'\baprinea\b', 'aprineus'),
    (r'\baprinum\b', 'aprinus'),
    (r'\baprique\b', 'aper1'),
    (r'\bapris\b', 'apra'),
    (r'\bapris\b', 'aper1'),
    (r'\bApris\b', 'Aper2'),
    (r'\bapro\b', 'aper1'),
    (r'\bApro\b', 'Aper2'),
    (r'\bAproni\b', 'Apronius'),
    (r'\bapronia\b', 'apronia'),
    (r'\baproniam\b', 'apronia'),
    (r'\bAproniana\b', 'Apronius'),
    (r'\bAproniani\b', 'Apronius'),
    (r'\bApronianis\b', 'Apronius'),
    (r'\bAproniano\b', 'Apronius'),
    (r'\bApronianum\b', 'Apronius'),
    (r'\bApronianus\b', 'Apronius'),
    (r'\bApronii\b', 'Apronius'),
    (r'\bApronio\b', 'Apronius'),
    (r'\bApronium\b', 'Apronius'),
    (r'\bApronius\b', 'Apronius'),
    (r'\baprorum\b', 'aper1'),
    (r'\bapros\b', 'aper1'),
    (r'\bApros\b', 'Aper2'),
    (r'\baprosque\b', 'aper1'),
    (r'\baproxi\b', 'aproxis'),
    (r'\baproxis\b', 'aproxis'),
    (r'\baprugnum\b', 'aprugnus'),
    (r'\baprum\b', 'aper1'),
    (r'\bAprum\b', 'Aper2'),
    (r'\bapruna\b', 'aprugnus'),
    (r'\baprunam\b', 'aprugnus'),
    (r'\bapruni\b', 'aprugnus'),
    (r'\bapruno\b', 'aprugnus'),
    (r'\baprunos\b', 'aprugnus'),
    (r'\baprunum\b', 'aprugnus'),
    (r'\baprunus\b', 'aprugnus'),
    (r'\bAprusa\b', 'Aprusa'),
    (r'\baps\b', 'ab'),
    (r'\bApso\b', 'Apsus'),
    (r'\bApsoros\b', 'Apsoros'),
    (r'\bapsque\b', 'ab'),
    (r'\bApsum\b', 'Apsus'),
    (r'\bApsus\b', 'Apsus'),
    (r'\bapsyctos\b', 'apsyctos'),
    (r'\bapta\b', 'aptus'),
    (r'\bapta\b', 'apto'),
    (r'\baptabant\b', 'apto'),
    (r'\baptabar\b', 'apto'),
    (r'\baptabat\b', 'apto'),
    (r'\baptabatque\b', 'apto'),
    (r'\baptabimus\b', 'apto'),
    (r'\baptabis\b', 'apto'),
    (r'\baptabit\b', 'apto'),
    (r'\baptae\b', 'aptus'),
    (r'\baptam\b', 'aptus'),
    (r'\baptamque\b', 'aptus'),
    (r'\baptamur\b', 'apto'),
    (r'\baptanda\b', 'apto'),
    (r'\baptandaque\b', 'apto'),
    (r'\baptandi\b', 'apto'),
    (r'\baptandis\b', 'apto'),
    (r'\baptando\b', 'apto'),
    (r'\baptandum\b', 'apto'),
    (r'\baptandus\b', 'apto'),
    (r'\baptans\b', 'apto'),
    (r'\baptant\b', 'apto'),
    (r'\baptante\b', 'apto'),
    (r'\baptantem\b', 'apto'),
    (r'\baptantes\b', 'apto'),
    (r'\baptantque\b', 'apto'),
    (r'\baptantur\b', 'apto'),
    (r'\baptaque\b', 'aptus'),
    (r'\baptaque\b', 'apto'),
    (r'\baptarat\b', 'apto'),
    (r'\baptare\b', 'apto'),
    (r'\baptaret\b', 'apto'),
    (r'\baptari\b', 'apto'),
    (r'\baptarique\b', 'apto'),
    (r'\baptarit\b', 'apto'),
    (r'\baptarunt\b', 'apto'),
    (r'\baptas\b', 'aptus'),
    (r'\baptas\b', 'apto'),
    (r'\baptasse\b', 'apto'),
    (r'\baptasset\b', 'apto'),
    (r'\baptasti\b', 'apto'),
    (r'\baptat\b', 'apto'),
    (r'\baptata\b', 'apto'),
    (r'\baptatae\b', 'apto'),
    (r'\baptatam\b', 'apto'),
    (r'\baptatamque\b', 'apto'),
    (r'\baptatasque\b', 'apto'),
    (r'\baptate\b', 'apto'),
    (r'\baptati\b', 'apto'),
    (r'\baptatis\b', 'apto'),
    (r'\baptato\b', 'apto'),
    (r'\baptatos\b', 'apto'),
    (r'\baptatque\b', 'apto'),
    (r'\baptatum\b', 'apto'),
    (r'\baptatur\b', 'apto'),
    (r'\baptatus\b', 'apto'),
    (r'\baptaueratque\b', 'apto'),
    (r'\baptaueris\b', 'apto'),
    (r'\baptauerunt\b', 'apto'),
    (r'\baptauimus\b', 'apto'),
    (r'\baptauit\b', 'apto'),
    (r'\baptaverant\b', 'apto'),
    (r'\baptaverat\b', 'apto'),
    (r'\baptavere\b', 'apto'),
    (r'\baptaverunt\b', 'apto'),
    (r'\baptavi\b', 'apto'),
    (r'\baptavit\b', 'apto'),
    (r'\bapte\b', 'aptus'),
    (r'\bapte\b', 'apte'),
    (r'\baptemur\b', 'apto'),
    (r'\baptemus\b', 'apto'),
    (r'\baptent\b', 'apto'),
    (r'\baptentur\b', 'apto'),
    (r'\bapteque\b', 'aptus'),
    (r'\bapteque\b', 'apte'),
    (r'\baptes\b', 'apto'),
    (r'\baptet\b', 'apto'),
    (r'\baptetur\b', 'apto'),
    (r'\bapti\b', 'aptus'),
    (r'\baptior\b', 'aptus'),
    (r'\baptiora\b', 'aptus'),
    (r'\baptiore\b', 'aptus'),
    (r'\baptiorem\b', 'aptus'),
    (r'\baptioremque\b', 'aptus'),
    (r'\baptiores\b', 'aptus'),
    (r'\baptioribus\b', 'aptus'),
    (r'\baptiorque\b', 'aptus'),
    (r'\baptis\b', 'aptus'),
    (r'\baptisque\b', 'aptus'),
    (r'\baptissima\b', 'aptus'),
    (r'\baptissimae\b', 'aptus'),
    (r'\baptissimam\b', 'aptus'),
    (r'\baptissime\b', 'aptus'),
    (r'\baptissimeque\b', 'aptus'),
    (r'\baptissimi\b', 'aptus'),
    (r'\baptissimo\b', 'aptus'),
    (r'\baptissimos\b', 'aptus'),
    (r'\baptissimum\b', 'aptus'),
    (r'\baptissimumque\b', 'aptus'),
    (r'\baptissimus\b', 'aptus'),
    (r'\baptissumum\b', 'aptus'),
    (r'\baptius\b', 'aptus'),
    (r'\baptiusque\b', 'aptus'),
    (r'\bapto\b', 'aptus'),
    (r'\bapto\b', 'apto'),
    (r'\baptoque\b', 'aptus'),
    (r'\baptoque\b', 'apto'),
    (r'\baptos\b', 'aptus'),
    (r'\baptota\b', 'aptota'),
    (r'\baptotis\b', 'aptota'),
    (r'\baptum\b', 'aptus'),
    (r'\baptumne\b', 'aptus'),
    (r'\baptumque\b', 'aptus'),
    (r'\baptus\b', 'aptus'),
    (r'\baptusque\b', 'aptus'),
    (r'\baptust\b', 'aptus'),
    (r'\bapud\b', 'apud'),
    (r'\bApula\b', 'apra'),
    (r'\bApulae\b', 'apra'),
    (r'\bApulam\b', 'apra'),
    (r'\bApulasque\b', 'apra'),
    (r'\bApule\b', 'apra'),
    (r'\bApulei\b', 'Appuleius'),
    (r'\bApuleia\b', 'Apuleianus'),
    (r'\bApuleiae\b', 'Apuleianus'),
    (r'\bApuleiana\b', 'Apuleianus'),
    (r'\bApuleias\b', 'Apuleianus'),
    (r'\bApuleio\b', 'Appuleius'),
    (r'\bApuleioque\b', 'Appuleius'),
    (r'\bApuleios\b', 'Appuleius'),
    (r'\bApuleium\b', 'Appuleius'),
    (r'\bApuleius\b', 'Appuleius'),
    (r'\bApuli\b', 'apra'),
    (r'\bapuli\b', 'a-pello'),
    (r'\bApulia\b', 'Appulia'),
    (r'\bApuliae\b', 'Appulia'),
    (r'\bApuliam\b', 'Appulia'),
    (r'\bApuliamque\b', 'Appulia'),
    (r'\bApuliaque\b', 'Appulia'),
    (r'\bApulique\b', 'apra'),
    (r'\bapulique\b', 'a-pello'),
    (r'\bApulis\b', 'apra'),
    (r'\bApulo\b', 'apra'),
    (r'\bApuloque\b', 'apra'),
    (r'\bApulorum\b', 'apra'),
    (r'\bApulos\b', 'apra'),
    (r'\bApulosque\b', 'apra'),
    (r'\bapulsos\b', 'a-pello'),
    (r'\bApulum\b', 'apra'),
    (r'\bApulus\b', 'apra'),
    (r'\bapyrenum\b', 'apyrinus'),
    (r'\bapyrenum\b', 'apyrenum'),
    (r'\bapyrina\b', 'apyrinus'),
    (r'\bapyrinum\b', 'apyrinus'),
    (r'\baqua\b', 'aqua'),
    (r'\baquabantur\b', 'aquor'),
    (r'\baquae\b', 'aqua'),
    (r'\baquaeductu\b', 'aquaeductus'),
    (r'\baquaeductum\b', 'aquaeductus'),
    (r'\baquaeductus\b', 'aquaeductus'),
    (r'\baquaeue\b', 'aqua'),
    (r'\baquagi\b', 'aquagium'),
    (r'\baquagium\b', 'aquagium'),
    (r'\baquai\b', 'aqua'),
    (r'\baquaist\b', 'aqua'),
    (r'\baquale\b', 'aqualis'),
    (r'\baqualem\b', 'aqualis'),
    (r'\baquales\b', 'aqualis'),
    (r'\baquali\b', 'aqualis'),
    (r'\baqualiculum\b', 'aqualiculus'),
    (r'\baqualiculus\b', 'aqualiculus'),
    (r'\baqualis\b', 'aqualis'),
    (r'\baqualium\b', 'aqualis'),
    (r'\baquam\b', 'aqua'),
    (r'\baquamque\b', 'aqua'),
    (r'\baquamue\b', 'aqua'),
    (r'\baquamve\b', 'aqua'),
    (r'\baquandi\b', 'aquor'),
    (r'\baquandique\b', 'aquor'),
    (r'\baquantibus\b', 'aquor'),
    (r'\baquantium\b', 'aquor'),
    (r'\baquantur\b', 'aquor'),
    (r'\baquaque\b', 'aqua'),
    (r'\baquarentur\b', 'aquor'),
    (r'\baquari\b', 'aquarius'),
    (r'\baquari\b', 'aquarius'),
    (r'\baquari\b', 'aquor'),
    (r'\baquaria\b', 'aquarius'),
    (r'\baquaria\b', 'aquarius'),
    (r'\baquariaeque\b', 'aquarius'),
    (r'\baquariam\b', 'aquarius'),
    (r'\baquarias\b', 'aquarius'),
    (r'\baquarii\b', 'aquarius'),
    (r'\baquarii\b', 'aquarius'),
    (r'\baquariis\b', 'aquarius'),
    (r'\baquariis\b', 'aquarius'),
    (r'\baquario\b', 'aquarius'),
    (r'\baquario\b', 'aquarius'),
    (r'\baquariolus\b', 'aquariolus'),
    (r'\baquariorum\b', 'aquarius'),
    (r'\baquariorum\b', 'aquarius'),
    (r'\baquarios\b', 'aquarius'),
    (r'\baquarium\b', 'aquarius'),
    (r'\baquarium\b', 'aquarius'),
    (r'\baquarius\b', 'aquarius'),
    (r'\baquarum\b', 'aqua'),
    (r'\baquarumque\b', 'aqua'),
    (r'\baquas\b', 'aqua'),
    (r'\baquasque\b', 'aqua'),
    (r'\baquast\b', 'aqua'),
    (r'\baquati\b', 'aquor'),
    (r'\baquati\b', 'aquatio'),
    (r'\baquatica\b', 'aquaticus'),
    (r'\baquaticae\b', 'aquaticus'),
    (r'\baquaticarum\b', 'aquaticus'),
    (r'\baquaticas\b', 'aquaticus'),
    (r'\baquatici\b', 'aquaticus'),
    (r'\baquaticis\b', 'aquaticus'),
    (r'\baquaticos\b', 'aquaticus'),
    (r'\baquaticum\b', 'aquaticus'),
    (r'\baquaticus\b', 'aquaticus'),
    (r'\baquatile\b', 'aquatilis'),
    (r'\baquatiles\b', 'aquatilis'),
    (r'\baquatilia\b', 'aquatilis'),
    (r'\baquatilibus\b', 'aquatilis'),
    (r'\baquatilibus\b', 'aquatilis'),
    (r'\baquatilis\b', 'aquatilis'),
    (r'\baquatilium\b', 'aquatilis'),
    (r'\baquatilium\b', 'aquatilis'),
    (r'\baquatio\b', 'aquatio'),
    (r'\baquatione\b', 'aquatio'),
    (r'\baquationem\b', 'aquatio'),
    (r'\baquationes\b', 'aquatio'),
    (r'\baquationis\b', 'aquatio'),
    (r'\baquationum\b', 'aquatio'),
    (r'\baquatioribus\b', 'aquor'),
    (r'\baquatis\b', 'aquor'),
    (r'\baquatis\b', 'aquatio'),
    (r'\baquatissimo\b', 'aquor'),
    (r'\baquatius\b', 'aquor'),
    (r'\baquato\b', 'aquor'),
    (r'\baquatorem\b', 'aquator'),
    (r'\baquatores\b', 'aquator'),
    (r'\baquatoribus\b', 'aquator'),
    (r'\baquatum\b', 'aquor'),
    (r'\baque\b', 'a'),
    (r'\baque\b', 'ab'),
    (r'\bAquenses\b', 'Aquensis'),
    (r'\bAquicaldenses\b', 'Aquicaldenses'),
    (r'\baquifolia\b', 'aquifolius'),
    (r'\baquifolia\b', 'aquifolius'),
    (r'\baquifoliae\b', 'aquifolius'),
    (r'\baquifoliis\b', 'aquifolius'),
    (r'\baquifoliis\b', 'aquifolius'),
    (r'\baquifoliis\b', 'aquifolius'),
    (r'\baquifolio\b', 'aquifolius'),
    (r'\baquifolio\b', 'aquifolius'),
    (r'\baquifolios\b', 'aquifolius'),
    (r'\baquifolium\b', 'aquifolius'),
    (r'\baquifolium\b', 'aquifolius'),
    (r'\baquila\b', 'aquila1'),
    (r'\bAquila\b', 'Aquila2'),
    (r'\baquila\b', 'aquilus'),
    (r'\baquilae\b', 'aquila1'),
    (r'\bAquilae\b', 'Aquila2'),
    (r'\baquilaeque\b', 'aquila1'),
    (r'\bAquilaeque\b', 'Aquila2'),
    (r'\baquilai\b', 'aquila1'),
    (r'\bAquilai\b', 'Aquila2'),
    (r'\baquilam\b', 'aquila1'),
    (r'\bAquilam\b', 'Aquila2'),
    (r'\baquilamque\b', 'aquila1'),
    (r'\bAquilamque\b', 'Aquila2'),
    (r'\baquilaque\b', 'aquila1'),
    (r'\baquilaque\b', 'aquilus'),
    (r'\baquilarum\b', 'aquila1'),
    (r'\baquilas\b', 'aquila1'),
    (r'\baquilasque\b', 'aquila1'),
    (r'\bAquileia\b', 'Aquileia'),
    (r'\bAquileiae\b', 'Aquileia'),
    (r'\bAquileiam\b', 'Aquileia'),
    (r'\bAquileiense\b', 'aquilentus'),
    (r'\bAquileienses\b', 'aquilentus'),
    (r'\bAquileienses\b', 'aquilentus'),
    (r'\bAquileiensi\b', 'aquilentus'),
    (r'\bAquileiensibus\b', 'aquilentus'),
    (r'\bAquileiensibus\b', 'aquilentus'),
    (r'\bAquileiensis\b', 'aquilentus'),
    (r'\bAquileiensis\b', 'aquilentus'),
    (r'\bAquileiensium\b', 'aquilentus'),
    (r'\bAquileiensium\b', 'aquilentus'),
    (r'\baquilenta\b', 'aquilentus'),
    (r'\baquili\b', 'aquilus'),
    (r'\bAquili\b', 'Aquilius'),
    (r'\bAquilia\b', 'Aquilianus'),
    (r'\bAquilia\b', 'Aquilius'),
    (r'\bAquiliae\b', 'Aquilianus'),
    (r'\bAquiliam\b', 'Aquilianus'),
    (r'\bAquiliana\b', 'Aquilianus'),
    (r'\bAquilianam\b', 'Aquilianus'),
    (r'\bAquiliani\b', 'Aquilianus'),
    (r'\bAquilii\b', 'Aquilius'),
    (r'\bAquiliisque\b', 'Aquilianus'),
    (r'\bAquiliisque\b', 'Aquilius'),
    (r'\baquilini\b', 'aquilinus'),
    (r'\baquilinis\b', 'aquilinus'),
    (r'\baquilino\b', 'aquilinus'),
    (r'\baquilinum\b', 'aquilinus'),
    (r'\baquilinus\b', 'aquilinus'),
    (r'\bAquilio\b', 'Aquilius'),
    (r'\bAquilios\b', 'Aquilius'),
    (r'\baquilis\b', 'aquila1'),
    (r'\baquilis\b', 'aquilus'),
    (r'\baquilisque\b', 'aquila1'),
    (r'\bAquilisque\b', 'Aquila2'),
    (r'\baquilisque\b', 'aquilus'),
    (r'\bAquilium\b', 'Aquilius'),
    (r'\baquilius\b', 'aquilus'),
    (r'\bAquilius\b', 'Aquilius'),
    (r'\bAquilo\b', 'aquilo'),
    (r'\baquilo\b', 'aquilo'),
    (r'\baquilo\b', 'aquilus'),
    (r'\bAquilone\b', 'aquilo'),
    (r'\baquilone\b', 'aquilo'),
    (r'\bAquilonem\b', 'aquilo'),
    (r'\baquilonem\b', 'aquilo'),
    (r'\baquilones\b', 'aquilo'),
    (r'\bAquiloni\b', 'aquilo'),
    (r'\baquiloni\b', 'aquilo'),
    (r'\bAquiloni\b', 'Aquilonia'),
    (r'\baquiloni\b', 'aquilonius'),
    (r'\bAquilonia\b', 'Aquilonia'),
    (r'\baquilonia\b', 'aquilonius'),
    (r'\bAquiloniae\b', 'Aquilonia'),
    (r'\baquiloniae\b', 'aquilonius'),
    (r'\bAquiloniam\b', 'Aquilonia'),
    (r'\baquiloniam\b', 'aquilonius'),
    (r'\bAquilonibus\b', 'aquilo'),
    (r'\baquilonibus\b', 'aquilo'),
    (r'\baquilonibusque\b', 'aquilo'),
    (r'\baquilonii\b', 'aquilonius'),
    (r'\baquiloniis\b', 'aquilonius'),
    (r'\baquilonio\b', 'aquilonius'),
    (r'\bAquilonis\b', 'Aquilonia'),
    (r'\bAquilonis\b', 'aquilo'),
    (r'\baquilonis\b', 'aquilo'),
    (r'\baquilonius\b', 'aquilonius'),
    (r'\baquilonum\b', 'aquilo'),
    (r'\bAquiloque\b', 'aquilo'),
    (r'\baquiloque\b', 'aquilo'),
    (r'\baquiloque\b', 'aquilus'),
    (r'\baquilost\b', 'aquilus'),
    (r'\baquilost\b', 'aquilo'),
    (r'\baquilum\b', 'aquilus'),
    (r'\baquilus\b', 'aquilus'),
    (r'\baquiminalia\b', 'aquiminale'),
    (r'\baquiminario\b', 'aquiminarium'),
    (r'\bAquinas\b', 'Aquinius'),
    (r'\bAquinate\b', 'Aquinius'),
    (r'\bAquinatem\b', 'Aquinius'),
    (r'\bAquinates\b', 'Aquinius'),
    (r'\bAquinates\b', 'Aquinius'),
    (r'\bAquinatium\b', 'Aquinius'),
    (r'\bAquinatium\b', 'Aquinius'),
    (r'\bAquini\b', 'Aquinius'),
    (r'\bAquini\b', 'Aquinum'),
    (r'\bAquinio\b', 'Aquinius'),
    (r'\bAquinium\b', 'Aquinius'),
    (r'\bAquino\b', 'Aquinum'),
    (r'\bAquinum\b', 'Aquinum'),
    (r'\bAquinumque\b', 'Aquinum'),
    (r'\baquis\b', 'aqua'),
    (r'\baquisque\b', 'aqua'),
    (r'\baquisue\b', 'aqua'),
    (r'\baquisve\b', 'aqua'),
    (r'\bAquitanae\b', 'Aquitanus'),
    (r'\bAquitanas\b', 'Aquitanus'),
    (r'\bAquitani\b', 'Aquitania'),
    (r'\bAquitani\b', 'Aquitanus'),
    (r'\bAquitania\b', 'Aquitania'),
    (r'\bAquitaniae\b', 'Aquitania'),
    (r'\bAquitaniam\b', 'Aquitania'),
    (r'\bAquitanica\b', 'Aquitanus'),
    (r'\bAquitanicae\b', 'Aquitanus'),
    (r'\bAquitanicam\b', 'Aquitanus'),
    (r'\bAquitanico\b', 'Aquitanus'),
    (r'\bAquitanis\b', 'Aquitania'),
    (r'\bAquitanis\b', 'Aquitanus'),
    (r'\bAquitanorum\b', 'Aquitania'),
    (r'\bAquitanorum\b', 'Aquitanus'),
    (r'\bAquitanus\b', 'Aquitanus'),
    (r'\baquosa\b', 'aquosus'),
    (r'\baquosae\b', 'aquosus'),
    (r'\baquosam\b', 'aquosus'),
    (r'\baquosas\b', 'aquosus'),
    (r'\baquosi\b', 'aquosus'),
    (r'\baquosiore\b', 'aquosus'),
    (r'\baquosis\b', 'aquosus'),
    (r'\baquosisque\b', 'aquosus'),
    (r'\baquosissima\b', 'aquosus'),
    (r'\baquosissimis\b', 'aquosus'),
    (r'\baquosissimusque\b', 'aquosus'),
    (r'\baquoso\b', 'aquosus'),
    (r'\baquosos\b', 'aquosus'),
    (r'\baquosum\b', 'aquosus'),
    (r'\baquosus\b', 'aquosus'),
    (r'\baquosusque\b', 'aquosus'),
    (r'\bara\b', 'ara'),
    (r'\bara\b', 'aron'),
    (r'\bara\b', 'aro'),
    (r'\bArabae\b', 'Arabus1'),
    (r'\bArabam\b', 'Arabus1'),
    (r'\barabam\b', 'aro'),
    (r'\barabant\b', 'aro'),
    (r'\barabarches\b', 'arabarches'),
    (r'\bArabas\b', 'Arabus1'),
    (r'\barabas\b', 'aro'),
    (r'\bArabasque\b', 'Arabus1'),
    (r'\barabasque\b', 'aro'),
    (r'\bArabasve\b', 'Arabus1'),
    (r'\barabasve\b', 'aro'),
    (r'\barabat\b', 'aro'),
    (r'\bArabe\b', 'Arabus1'),
    (r'\bArabe\b', 'a-rabo1'),
    (r'\barabe\b', 'a-rabio'),
    (r'\barabes\b', 'a-rabo1'),
    (r'\bArabes\b', 'a-rabo1'),
    (r'\barabesque\b', 'a-rabo1'),
    (r'\bArabesque\b', 'a-rabo1'),
    (r'\bArabi\b', 'Arabia'),
    (r'\bArabi\b', 'a-rabo1'),
    (r'\bArabi\b', 'a-rabio'),
    (r'\bArabi\b', 'Arabus1'),
    (r'\barabi\b', 'a-rabio'),
    (r'\bArabia\b', 'Arabia'),
    (r'\bArabia\b', 'a-rabio'),
    (r'\bArabiae\b', 'Arabia'),
    (r'\bArabiam\b', 'Arabia'),
    (r'\barabiam\b', 'a-rabio'),
    (r'\bArabiane\b', 'Arabia'),
    (r'\bArabiane\b', 'a-rabio'),
    (r'\bArabiaque\b', 'Arabia'),
    (r'\bArabiaque\b', 'a-rabio'),
    (r'\bArabiast\b', 'Arabia'),
    (r'\bArabiast\b', 'a-rabio'),
    (r'\bArabibus\b', 'a-rabo1'),
    (r'\bArabica\b', 'arabilis'),
    (r'\bArabica\b', 'arabilis'),
    (r'\bArabicae\b', 'arabilis'),
    (r'\bArabicam\b', 'arabilis'),
    (r'\bArabicarum\b', 'arabilis'),
    (r'\bArabicarumque\b', 'arabilis'),
    (r'\bArabicas\b', 'arabilis'),
    (r'\bArabicasque\b', 'arabilis'),
    (r'\bArabici\b', 'arabilis'),
    (r'\bArabicis\b', 'arabilis'),
    (r'\bArabicis\b', 'arabilis'),
    (r'\bArabicisque\b', 'arabilis'),
    (r'\bArabicisque\b', 'arabilis'),
    (r'\bArabico\b', 'arabilis'),
    (r'\bArabicorum\b', 'arabilis'),
    (r'\bArabicum\b', 'arabilis'),
    (r'\bArabicus\b', 'arabilis'),
    (r'\barabilem\b', 'arabilis'),
    (r'\barabimini\b', 'aro'),
    (r'\barabimus\b', 'aro'),
    (r'\bArabioni\b', 'a-rabio'),
    (r'\barabis\b', 'aro'),
    (r'\bArabis\b', 'Arabia'),
    (r'\bArabis\b', 'a-rabo1'),
    (r'\bArabis\b', 'Arabus1'),
    (r'\barabisue\b', 'aro'),
    (r'\bArabisue\b', 'Arabia'),
    (r'\bArabisue\b', 'a-rabo1'),
    (r'\bArabisue\b', 'Arabus1'),
    (r'\barabisve\b', 'aro'),
    (r'\barabit\b', 'aro'),
    (r'\barabiton\b', 'a-rabio'),
    (r'\barabitur\b', 'aro'),
    (r'\bArabium\b', 'a-rabo1'),
    (r'\bArabium\b', 'a-rabio'),
    (r'\bArabius\b', 'Arabus1'),
    (r'\bArabius\b', 'a-rabio'),
    (r'\barabo\b', 'aro'),
    (r'\bArabo\b', 'Arabus1'),
    (r'\bArabos\b', 'Arabia'),
    (r'\bArabs\b', 'a-rabo1'),
    (r'\bArabum\b', 'Arabia'),
    (r'\bArabum\b', 'Arabus1'),
    (r'\bArabumque\b', 'Arabia'),
    (r'\bArabumque\b', 'Arabus1'),
    (r'\barabunt\b', 'aro'),
    (r'\bArabus\b', 'Arabus1'),
    (r'\bArachnae\b', 'Arachne'),
    (r'\bArachne\b', 'Arachne'),
    (r'\bArachnes\b', 'Arachne'),
    (r'\bArachosia\b', 'Arachosia'),
    (r'\bArachosii\b', 'Arachotae'),
    (r'\bArachosiis\b', 'Arachosia'),
    (r'\bArachosiis\b', 'Arachotae'),
    (r'\bArachosiorum\b', 'Arachotae'),
    (r'\bArachosios\b', 'Arachotae'),
    (r'\bArachotarum\b', 'Arachotae'),
    (r'\bArachotas\b', 'Arachotae'),
    (r'\bAracynthe\b', 'Aracynthus'),
    (r'\bAracyntho\b', 'Aracynthus'),
    (r'\bAracynthus\b', 'Aracynthus'),
    (r'\bAradi\b', 'Aradius'),
    (r'\baradi\b', 'a-rado'),
    (r'\bAradii\b', 'Aradius'),
    (r'\bAradii\b', 'Aradius'),
    (r'\bAradios\b', 'Aradius'),
    (r'\bAradium\b', 'Aradius'),
    (r'\bAradium\b', 'Aradius'),
    (r'\barado\b', 'a-rado'),
    (r'\barae\b', 'ara'),
    (r'\bArae\b', 'Arausio'),
    (r'\baraeque\b', 'ara'),
    (r'\baraeve\b', 'ara'),
    (r'\baram\b', 'ara'),
    (r'\baramque\b', 'ara'),
    (r'\baramue\b', 'ara'),
    (r'\baramus\b', 'aro'),
    (r'\baran\b', 'ara'),
    (r'\baran\b', 'aron'),
    (r'\baran\b', 'aro'),
    (r'\baranda\b', 'aro'),
    (r'\barandae\b', 'aro'),
    (r'\barande\b', 'aro'),
    (r'\barandi\b', 'aro'),
    (r'\barandique\b', 'aro'),
    (r'\barandis\b', 'aro'),
    (r'\barando\b', 'aro'),
    (r'\barandum\b', 'aro'),
    (r'\barandus\b', 'aro'),
    (r'\barane\b', 'ara'),
    (r'\barane\b', 'aron'),
    (r'\barane\b', 'aro'),
    (r'\baranea\b', 'aranea'),
    (r'\baranea\b', 'araneum'),
    (r'\baraneae\b', 'aranea'),
    (r'\baraneam\b', 'aranea'),
    (r'\baranearum\b', 'aranea'),
    (r'\baraneas\b', 'aranea'),
    (r'\baranei\b', 'araneus1'),
    (r'\baranei\b', 'araneum'),
    (r'\baraneis\b', 'aranea'),
    (r'\baraneis\b', 'araneus1'),
    (r'\baraneis\b', 'araneum'),
    (r'\baraneo\b', 'araneus1'),
    (r'\baraneo\b', 'araneum'),
    (r'\baraneoli\b', 'araneolus'),
    (r'\baraneolis\b', 'araneola'),
    (r'\baraneolis\b', 'araneolus'),
    (r'\baraneorum\b', 'araneus1'),
    (r'\baraneorum\b', 'araneum'),
    (r'\baraneos\b', 'araneus1'),
    (r'\baraneosa\b', 'araneosus'),
    (r'\baraneosae\b', 'araneosus'),
    (r'\baraneoso\b', 'araneosus'),
    (r'\baraneosos\b', 'araneosus'),
    (r'\baraneosus\b', 'araneosus'),
    (r'\baraneum\b', 'araneus1'),
    (r'\baraneum\b', 'araneum'),
    (r'\baraneum\b', 'araneus2'),
    (r'\baraneus\b', 'araneus1'),
    (r'\barans\b', 'aro'),
    (r'\barant\b', 'aro'),
    (r'\barantem\b', 'aro'),
    (r'\barantes\b', 'aro'),
    (r'\baranti\b', 'aro'),
    (r'\barantibus\b', 'aro'),
    (r'\barantis\b', 'aro'),
    (r'\barantium\b', 'aro'),
    (r'\barantur\b', 'aro'),
    (r'\baraque\b', 'ara'),
    (r'\baraque\b', 'aron'),
    (r'\baraque\b', 'aro'),
    (r'\bararat\b', 'aro'),
    (r'\barare\b', 'aro'),
    (r'\bararent\b', 'aro'),
    (r'\bararet\b', 'aro'),
    (r'\bararetur\b', 'aro'),
    (r'\barari\b', 'aro'),
    (r'\bararim\b', 'aro'),
    (r'\bararis\b', 'aro'),
    (r'\bararit\b', 'aro'),
    (r'\bararum\b', 'ara'),
    (r'\baras\b', 'ara'),
    (r'\baras\b', 'aro'),
    (r'\barasque\b', 'ara'),
    (r'\barasque\b', 'aro'),
    (r'\barasse\b', 'aro'),
    (r'\barasset\b', 'aro'),
    (r'\barassetis\b', 'aro'),
    (r'\barastis\b', 'aro'),
    (r'\barat\b', 'aro'),
    (r'\barata\b', 'aro'),
    (r'\baratas\b', 'aro'),
    (r'\bAratea\b', 'Arateus'),
    (r'\bArateis\b', 'Arateus'),
    (r'\barater\b', 'arater'),
    (r'\bArati\b', 'Aratus2'),
    (r'\barati\b', 'aro'),
    (r'\baratio\b', 'aratio'),
    (r'\baratione\b', 'aratio'),
    (r'\barationem\b', 'aratio'),
    (r'\barationes\b', 'aratio'),
    (r'\barationesque\b', 'aratio'),
    (r'\barationi\b', 'aratio'),
    (r'\barationibus\b', 'aratio'),
    (r'\barationis\b', 'aratio'),
    (r'\barationum\b', 'aratio'),
    (r'\barationumque\b', 'aratio'),
    (r'\baratis\b', 'aro'),
    (r'\baratiunculam\b', 'aratiuncula'),
    (r'\baratiunculas\b', 'aratiuncula'),
    (r'\barato\b', 'aro'),
    (r'\bArato\b', 'Aratus2'),
    (r'\baratoque\b', 'aro'),
    (r'\barator\b', 'arator'),
    (r'\baratore\b', 'arator'),
    (r'\baratorem\b', 'arator'),
    (r'\baratores\b', 'arator'),
    (r'\baratori\b', 'arator'),
    (r'\baratoribus\b', 'arator'),
    (r'\baratoribusque\b', 'arator'),
    (r'\baratoris\b', 'arator'),
    (r'\baratorque\b', 'arator'),
    (r'\baratorum\b', 'arator'),
    (r'\bAratorum\b', 'Aratus2'),
    (r'\baratorum\b', 'aro'),
    (r'\baratorumne\b', 'arator'),
    (r'\baratorumne\b', 'aro'),
    (r'\baratorumque\b', 'arator'),
    (r'\baratorumque\b', 'aro'),
    (r'\baratos\b', 'aro'),
    (r'\baratra\b', 'aratrum'),
    (r'\baratra\b', 'aratro'),
    (r'\baratrare\b', 'aratro'),
    (r'\baratri\b', 'arater'),
    (r'\baratri\b', 'aratrum'),
    (r'\baratris\b', 'arater'),
    (r'\baratris\b', 'aratrum'),
    (r'\baratro\b', 'arater'),
    (r'\baratro\b', 'aratrum'),
    (r'\baratro\b', 'aratro'),
    (r'\baratroque\b', 'arater'),
    (r'\baratroque\b', 'aratrum'),
    (r'\baratroque\b', 'aratro'),
    (r'\baratrost\b', 'arater'),
    (r'\baratrost\b', 'aratrum'),
    (r'\baratrost\b', 'aratro'),
    (r'\baratrum\b', 'arater'),
    (r'\baratrum\b', 'aratrum'),
    (r'\bAratum\b', 'Aratus2'),
    (r'\baratum\b', 'aro'),
    (r'\bAratumque\b', 'Aratus2'),
    (r'\baratumque\b', 'aro'),
    (r'\baratur\b', 'aro'),
    (r'\baraturae\b', 'aro'),
    (r'\baraturis\b', 'aro'),
    (r'\baraturos\b', 'aro'),
    (r'\bAratus\b', 'Aratus2'),
    (r'\baratus\b', 'aro'),
    (r'\barauerat\b', 'aro'),
    (r'\barauerit\b', 'aro'),
    (r'\barauit\b', 'aro'),
    (r'\bArauris\b', 'Arauris'),
    (r'\bAraus\b', 'Arausio'),
    (r'\bArausio\b', 'Arausio'),
    (r'\bArausionem\b', 'Arausio'),
    (r'\baraveris\b', 'aro'),
    (r'\baraverit\b', 'aro'),
    (r'\baravit\b', 'aro'),
    (r'\bAraxe\b', 'Araxes'),
    (r'\bAraxen\b', 'Araxes'),
    (r'\bAraxes\b', 'Araxes'),
    (r'\bAraxi\b', 'Araxes'),
    (r'\bAraxis\b', 'Araxes'),
    (r'\bAraxum\b', 'Araxes'),
    (r'\bArbace\b', 'Arbaces'),
    (r'\bArbacem\b', 'Arbaces'),
    (r'\bArbaces\b', 'Arbaces'),
    (r'\bArbela\b', 'Arbela'),
    (r'\bArbelis\b', 'Arbela'),
    (r'\bArbi\b', 'Arbis1'),
    (r'\bArbi\b', 'Arbis2'),
    (r'\barbita\b', 'arbutum'),
    (r'\barbiter\b', 'arbiter'),
    (r'\barbiterium\b', 'arbitrium'),
    (r'\barbiterque\b', 'arbiter'),
    (r'\barbitra\b', 'arbitra'),
    (r'\barbitrabamur\b', 'arbitror'),
    (r'\barbitrabantur\b', 'arbitror'),
    (r'\barbitrabar\b', 'arbitror'),
    (r'\barbitrabare\b', 'arbitror'),
    (r'\barbitrabaris\b', 'arbitror'),
    (r'\barbitrabatur\b', 'arbitror'),
    (r'\barbitrabere\b', 'arbitror'),
    (r'\barbitrabimur\b', 'arbitror'),
    (r'\barbitrabitur\b', 'arbitror'),
    (r'\barbitrabor\b', 'arbitror'),
    (r'\barbitrabuntur\b', 'arbitror'),
    (r'\barbitrae\b', 'arbitra'),
    (r'\barbitram\b', 'arbitra'),
    (r'\barbitramini\b', 'arbitror'),
    (r'\barbitramur\b', 'arbitror'),
    (r'\barbitrandum\b', 'arbitror'),
    (r'\barbitrandus\b', 'arbitror'),
    (r'\barbitrans\b', 'arbitror'),
    (r'\barbitrantes\b', 'arbitror'),
    (r'\barbitranti\b', 'arbitror'),
    (r'\barbitrantium\b', 'arbitror'),
    (r'\barbitrantur\b', 'arbitror'),
    (r'\barbitrare\b', 'arbitror'),
    (r'\barbitraremur\b', 'arbitror'),
    (r'\barbitrarentur\b', 'arbitror'),
    (r'\barbitrarer\b', 'arbitror'),
    (r'\barbitrarere\b', 'arbitror'),
    (r'\barbitraretur\b', 'arbitror'),
    (r'\barbitrari\b', 'arbitrarius'),
    (r'\barbitrari\b', 'arbitror'),
    (r'\barbitraria\b', 'arbitrarius'),
    (r'\barbitrariae\b', 'arbitrarius'),
    (r'\barbitrariam\b', 'arbitrarius'),
    (r'\barbitrarier\b', 'arbitror'),
    (r'\barbitrario\b', 'arbitrario'),
    (r'\barbitrario\b', 'arbitrarius'),
    (r'\barbitraris\b', 'arbitror'),
    (r'\barbitrarium\b', 'arbitrarius'),
    (r'\barbitrata\b', 'arbitror'),
    (r'\barbitratae\b', 'arbitror'),
    (r'\barbitrati\b', 'arbitror'),
    (r'\barbitratione\b', 'arbitratio'),
    (r'\barbitratis\b', 'arbitror'),
    (r'\barbitrato\b', 'arbitror'),
    (r'\barbitratu\b', 'arbitratus2'),
    (r'\barbitratu\b', 'arbitror'),
    (r'\barbitratum\b', 'arbitratus2'),
    (r'\barbitratum\b', 'arbitror'),
    (r'\barbitratur\b', 'arbitror'),
    (r'\barbitraturum\b', 'arbitror'),
    (r'\barbitraturus\b', 'arbitror'),
    (r'\barbitratus\b', 'arbitratus2'),
    (r'\barbitratus\b', 'arbitror'),
    (r'\barbitratust\b', 'arbitratus2'),
    (r'\barbitratust\b', 'arbitror'),
    (r'\barbitremini\b', 'arbitror'),
    (r'\barbitremur\b', 'arbitror'),
    (r'\barbitrentur\b', 'arbitror'),
    (r'\barbitrer\b', 'arbitror'),
    (r'\barbitrere\b', 'arbitror'),
    (r'\barbitreris\b', 'arbitror'),
    (r'\barbitrerisne\b', 'arbitror'),
    (r'\barbitretur\b', 'arbitror'),
    (r'\barbitri\b', 'arbiter'),
    (r'\barbitri\b', 'arbitrium'),
    (r'\barbitria\b', 'arbitrium'),
    (r'\barbitriaque\b', 'arbitrium'),
    (r'\barbitrii\b', 'arbitrium'),
    (r'\barbitriis\b', 'arbitrium'),
    (r'\barbitrio\b', 'arbitrium'),
    (r'\barbitrioque\b', 'arbitrium'),
    (r'\barbitris\b', 'arbitra'),
    (r'\barbitris\b', 'arbiter'),
    (r'\barbitrium\b', 'arbitrium'),
    (r'\barbitriumque\b', 'arbitrium'),
    (r'\barbitro\b', 'arbiter'),
    (r'\barbitroque\b', 'arbiter'),
    (r'\barbitror\b', 'arbitror'),
    (r'\barbitrorum\b', 'arbiter'),
    (r'\barbitros\b', 'arbiter'),
    (r'\barbitrove\b', 'arbiter'),
    (r'\barbitrum\b', 'arbiter'),
    (r'\barbitrumue\b', 'arbiter'),
    (r'\bArbium\b', 'Arbis1'),
    (r'\bArbium\b', 'Arbis2'),
    (r'\bArbocala\b', 'Arbocala'),
    (r'\barbor\b', 'arbor1'),
    (r'\barborariae\b', 'arborarius'),
    (r'\barborarias\b', 'arborarius'),
    (r'\barborarii\b', 'arborarius'),
    (r'\barborator\b', 'arborator'),
    (r'\barbore\b', 'arbor1'),
    (r'\barborea\b', 'arboreus'),
    (r'\barboreae\b', 'arboreus'),
    (r'\barboream\b', 'arboreus'),
    (r'\barboreas\b', 'arboreus'),
    (r'\barboreasque\b', 'arboreus'),
    (r'\barborei\b', 'arboreus'),
    (r'\barboreis\b', 'arboreus'),
    (r'\barborem\b', 'arbor1'),
    (r'\barboremque\b', 'arbor1'),
    (r'\barboreo\b', 'arboreus'),
    (r'\barboreorum\b', 'arboreus'),
    (r'\barboreos\b', 'arboreus'),
    (r'\barbores\b', 'arbor1'),
    (r'\barborescere\b', 'arboresco'),
    (r'\barboresque\b', 'arbor1'),
    (r'\barboresue\b', 'arbor1'),
    (r'\barboresve\b', 'arbor1'),
    (r'\barboreta\b', 'arboretum'),
    (r'\barboreum\b', 'arboreus'),
    (r'\barbori\b', 'arbor1'),
    (r'\barboriae\b', 'arboreus'),
    (r'\barboribus\b', 'arbor1'),
    (r'\barboribusque\b', 'arbor1'),
    (r'\barborique\b', 'arbor1'),
    (r'\barboris\b', 'arbor1'),
    (r'\barborisque\b', 'arbor1'),
    (r'\barborque\b', 'arbor1'),
    (r'\barborum\b', 'arbor1'),
    (r'\barborumne\b', 'arbor1'),
    (r'\barborumque\b', 'arbor1'),
    (r'\barbuscula\b', 'arbuscula1'),
    (r'\bArbuscula\b', 'Arbuscula2'),
    (r'\barbusculae\b', 'arbuscula1'),
    (r'\barbusculaeque\b', 'arbuscula1'),
    (r'\barbusculam\b', 'arbuscula1'),
    (r'\barbuscularum\b', 'arbuscula1'),
    (r'\barbusculas\b', 'arbuscula1'),
    (r'\barbusculis\b', 'arbuscula1'),
    (r'\barbusta\b', 'arbustus'),
    (r'\barbusta\b', 'arbustum'),
    (r'\barbusta\b', 'arbusto'),
    (r'\barbustaque\b', 'arbustus'),
    (r'\barbustaque\b', 'arbustum'),
    (r'\barbustaque\b', 'arbusto'),
    (r'\barbustat\b', 'arbusto'),
    (r'\barbusti\b', 'arbustus'),
    (r'\barbusti\b', 'arbustum'),
    (r'\barbustis\b', 'arbustus'),
    (r'\barbustis\b', 'arbustum'),
    (r'\barbustisque\b', 'arbustus'),
    (r'\barbustisque\b', 'arbustum'),
    (r'\barbustiuae\b', 'arbustivus'),
    (r'\barbustiuam\b', 'arbustivus'),
    (r'\barbustiui\b', 'arbustivus'),
    (r'\barbustiuo\b', 'arbustivus'),
    (r'\barbustiuum\b', 'arbustivus'),
    (r'\barbustivo\b', 'arbustivus'),
    (r'\barbusto\b', 'arbustus'),
    (r'\barbusto\b', 'arbustum'),
    (r'\barbusto\b', 'arbusto'),
    (r'\barbustorum\b', 'arbustus'),
    (r'\barbustorum\b', 'arbustum'),
    (r'\barbustorumque\b', 'arbustus'),
    (r'\barbustorumque\b', 'arbustum'),
    (r'\barbustos\b', 'arbustus'),
    (r'\barbustum\b', 'arbustus'),
    (r'\barbustum\b', 'arbustum'),
    (r'\barbustumque\b', 'arbustus'),
    (r'\barbustumque\b', 'arbustum'),
    (r'\barbuta\b', 'arbutum'),
    (r'\barbutea\b', 'arbuteus'),
    (r'\barbuteae\b', 'arbuteus'),
    (r'\barbutei\b', 'arbuteus'),
    (r'\barbuteis\b', 'arbuteus'),
    (r'\barbuteos\b', 'arbuteus'),
    (r'\barbuti\b', 'arbutus'),
    (r'\barbuti\b', 'arbutum'),
    (r'\barbuto\b', 'arbutus'),
    (r'\barbuto\b', 'arbutum'),
    (r'\barbutos\b', 'arbutus'),
    (r'\barbutum\b', 'arbutus'),
    (r'\barbutum\b', 'arbutum'),
    (r'\barbutus\b', 'arbutus'),
    (r'\barca\b', 'arca'),
    (r'\bArcade\b', 'Arcas'),
    (r'\barcadem\b', 'arca'),
    (r'\bArcadem\b', 'Arcas'),
    (r'\bArcades\b', 'Arcades'),
    (r'\bArcadi\b', 'Arcas'),
    (r'\bArcadi\b', 'Arcae'),
    (r'\bArcadia\b', 'Arcadia1'),
    (r'\bArcadia\b', 'Arcae'),
    (r'\bArcadiae\b', 'Arcadia1'),
    (r'\bArcadiam\b', 'Arcadia1'),
    (r'\bArcadias\b', 'Arcadia1'),
    (r'\bArcadibus\b', 'Arcades'),
    (r'\bArcadica\b', 'Arcae'),
    (r'\bArcadici\b', 'Arcae'),
    (r'\bArcadicis\b', 'Arcae'),
    (r'\bArcadico\b', 'Arcae'),
    (r'\bArcadicos\b', 'Arcae'),
    (r'\bArcadicum\b', 'Arcae'),
    (r'\bArcadii\b', 'Arcae'),
    (r'\bArcadiis\b', 'Arcadia1'),
    (r'\bArcadiis\b', 'Arcae'),
    (r'\bArcadio\b', 'Arcae'),
    (r'\bArcadios\b', 'Arcae'),
    (r'\bArcadis\b', 'Arcas'),
    (r'\bArcadium\b', 'Arcae'),
    (r'\bArcadius\b', 'Arcae'),
    (r'\bArcadum\b', 'Arcades'),
    (r'\bArcadumque\b', 'Arcades'),
    (r'\barcae\b', 'arca'),
    (r'\barcam\b', 'arca'),
    (r'\barcamque\b', 'arca'),
    (r'\barcana\b', 'arcanus1'),
    (r'\bArcana\b', 'Arcanus2'),
    (r'\bArcana\b', 'arcanum'),
    (r'\barcana\b', 'arcanum'),
    (r'\barcanae\b', 'arcanus1'),
    (r'\barcanam\b', 'arcanus1'),
    (r'\barcanaque\b', 'arcanus1'),
    (r'\barcanaque\b', 'arcanum'),
    (r'\barcanarum\b', 'arcanus1'),
    (r'\barcanas\b', 'arcanus1'),
    (r'\barcane\b', 'arcanus1'),
    (r'\barcane\b', 'arcanum'),
    (r'\bArcani\b', 'Arcanus2'),
    (r'\bArcani\b', 'Arcani'),
    (r'\barcani\b', 'arcanus1'),
    (r'\bArcani\b', 'arcanum'),
    (r'\barcani\b', 'arcanum'),
    (r'\barcanique\b', 'arcanus1'),
    (r'\barcanique\b', 'arcanum'),
    (r'\barcanis\b', 'arcanus1'),
    (r'\barcanis\b', 'arcanum'),
    (r'\barcanius\b', 'arcanus1'),
    (r'\barcano\b', 'arcanus1'),
    (r'\bArcano\b', 'Arcanus2'),
    (r'\bArcano\b', 'arcanum'),
    (r'\barcano\b', 'arcanum'),
    (r'\barcanorum\b', 'arcanus1'),
    (r'\barcanorum\b', 'arcanum'),
    (r'\barcanorumque\b', 'arcanus1'),
    (r'\barcanorumque\b', 'arcanum'),
    (r'\barcanos\b', 'arcanus1'),
    (r'\bArcanum\b', 'Arcanus2'),
    (r'\bArcanum\b', 'Arcani'),
    (r'\barcanum\b', 'arcanus1'),
    (r'\bArcanum\b', 'arcanum'),
    (r'\barcanum\b', 'arcanum'),
    (r'\barcanumque\b', 'arcanus1'),
    (r'\barcanumque\b', 'arcanum'),
    (r'\barcanun\b', 'arcanus1'),
    (r'\barcanus\b', 'arcanus1'),
    (r'\barcaque\b', 'arca'),
    (r'\barcaria\b', 'arcarius'),
    (r'\barcariis\b', 'arcarius'),
    (r'\barcarios\b', 'arcarius'),
    (r'\barcarius\b', 'arcarius'),
    (r'\barcas\b', 'arca'),
    (r'\bArcas\b', 'Arcae'),
    (r'\bArcas\b', 'Arcas'),
    (r'\barce\b', 'arx'),
    (r'\barce\b', 'arceo'),
    (r'\barceam\b', 'arceo'),
    (r'\barceamus\b', 'arceo'),
    (r'\barceant\b', 'arceo'),
    (r'\barceantur\b', 'arceo'),
    (r'\barcear\b', 'arceo'),
    (r'\barceas\b', 'arceo'),
    (r'\barceat\b', 'arceo'),
    (r'\barceatur\b', 'arceo'),
    (r'\barcebant\b', 'arceo'),
    (r'\barcebantur\b', 'arceo'),
    (r'\barcebat\b', 'arceo'),
    (r'\barcebatque\b', 'arceo'),
    (r'\barcebatur\b', 'arceo'),
    (r'\barcebis\b', 'arceo'),
    (r'\barcebit\b', 'arceo'),
    (r'\barcebitur\b', 'arceo'),
    (r'\barcebo\b', 'arceo'),
    (r'\barcebunt\b', 'arceo'),
    (r'\barcem\b', 'arx'),
    (r'\barcemque\b', 'arx'),
    (r'\barcemue\b', 'arx'),
    (r'\barcemur\b', 'arceo'),
    (r'\barcemus\b', 'arceo'),
    (r'\barcenda\b', 'arceo'),
    (r'\barcendae\b', 'arceo'),
    (r'\barcendam\b', 'arceo'),
    (r'\barcendas\b', 'arceo'),
    (r'\barcende\b', 'arceo'),
    (r'\barcendi\b', 'arceo'),
    (r'\barcendis\b', 'arceo'),
    (r'\barcendo\b', 'arceo'),
    (r'\barcendos\b', 'arceo'),
    (r'\barcendum\b', 'arceo'),
    (r'\barcendus\b', 'arceo'),
    (r'\barcens\b', 'arceo'),
    (r'\barcent\b', 'arceo'),
    (r'\barcente\b', 'arceo'),
    (r'\barcentem\b', 'arceo'),
    (r'\barcentemque\b', 'arceo'),
    (r'\barcentes\b', 'arceo'),
    (r'\barcentibus\b', 'arceo'),
    (r'\barcentis\b', 'arceo'),
    (r'\barcentium\b', 'arceo'),
    (r'\barcentque\b', 'arceo'),
    (r'\barcentur\b', 'arceo'),
    (r'\barceo\b', 'arceo'),
    (r'\barceor\b', 'arceo'),
    (r'\barcera\b', 'arcera'),
    (r'\barceram\b', 'arcera'),
    (r'\barcere\b', 'arceo'),
    (r'\barcerem\b', 'arceo'),
    (r'\barceremur\b', 'arceo'),
    (r'\barcerent\b', 'arceo'),
    (r'\barcerentur\b', 'arceo'),
    (r'\barceres\b', 'arceo'),
    (r'\barceret\b', 'arceo'),
    (r'\barceretur\b', 'arceo'),
    (r'\barceri\b', 'arceo'),
    (r'\barcerique\b', 'arceo'),
    (r'\barces\b', 'arx'),
    (r'\barces\b', 'arceo'),
    (r'\bArcesilae\b', 'Arcesius'),
    (r'\bArcesilai\b', 'Arcesius'),
    (r'\bArcesilaum\b', 'Arcesius'),
    (r'\bArcesilaus\b', 'Arcesius'),
    (r'\bArcesius\b', 'Arcesius'),
    (r'\barcesque\b', 'arx'),
    (r'\barcesque\b', 'arceo'),
    (r'\barcessam\b', 'arcesso'),
    (r'\barcessamur\b', 'arcesso'),
    (r'\barcessant\b', 'arcesso'),
    (r'\barcessantur\b', 'arcesso'),
    (r'\barcessas\b', 'arcesso'),
    (r'\barcessat\b', 'arcesso'),
    (r'\barcessatur\b', 'arcesso'),
    (r'\barcesse\b', 'arcesso'),
    (r'\barcessebamus\b', 'arcesso'),
    (r'\barcessebant\b', 'arcesso'),
    (r'\barcessebantur\b', 'arcesso'),
    (r'\barcessebat\b', 'arcesso'),
    (r'\barcessebatur\b', 'arcesso'),
    (r'\barcessemus\b', 'arcesso'),
    (r'\barcessenda\b', 'arcesso'),
    (r'\barcessendam\b', 'arcesso'),
    (r'\barcessendas\b', 'arcesso'),
    (r'\barcessendi\b', 'arcesso'),
    (r'\barcessendis\b', 'arcesso'),
    (r'\barcessendo\b', 'arcesso'),
    (r'\barcessendos\b', 'arcesso'),
    (r'\barcessendum\b', 'arcesso'),
    (r'\barcessendus\b', 'arcesso'),
    (r'\barcessentes\b', 'arcesso'),
    (r'\barcessentibus\b', 'arcesso'),
    (r'\barcessentur\b', 'arcesso'),
    (r'\barcessere\b', 'arcesso'),
    (r'\barcesserem\b', 'arcesso'),
    (r'\barcesseremus\b', 'arcesso'),
    (r'\barcesserent\b', 'arcesso'),
    (r'\barcesserentur\b', 'arcesso'),
    (r'\barcesseres\b', 'arcesso'),
    (r'\barcesseret\b', 'arcesso'),
    (r'\barcesseretur\b', 'arcesso'),
    (r'\barcesses\b', 'arcesso'),
    (r'\barcesset\b', 'arcesso'),
    (r'\barcessi\b', 'arcesso'),
    (r'\barcessiebantur\b', 'arcesso'),
    (r'\barcessier\b', 'arcesso'),
    (r'\barcessieris\b', 'arcesso'),
    (r'\barcessimus\b', 'arcesso'),
    (r'\barcessiri\b', 'arcesso'),
    (r'\barcessis\b', 'arcesso'),
    (r'\barcessisse\b', 'arcesso'),
    (r'\barcessisset\b', 'arcesso'),
    (r'\barcessistis\b', 'arcesso'),
    (r'\barcessit\b', 'arcesso'),
    (r'\barcessita\b', 'arcesso'),
    (r'\barcessitae\b', 'arcesso'),
    (r'\barcessitam\b', 'arcesso'),
    (r'\barcessite\b', 'arcesso'),
    (r'\barcessiti\b', 'arcesso'),
    (r'\barcessitique\b', 'arcesso'),
    (r'\barcessitis\b', 'arcesso'),
    (r'\barcessito\b', 'arcesso'),
    (r'\barcessitorem\b', 'arcessitor'),
    (r'\barcessitosque\b', 'arcesso'),
    (r'\barcessitu\b', 'arcessitus2'),
    (r'\barcessitu\b', 'arcesso'),
    (r'\barcessitum\b', 'arcessitus2'),
    (r'\barcessitum\b', 'arcesso'),
    (r'\barcessituque\b', 'arcessitus2'),
    (r'\barcessituque\b', 'arcesso'),
    (r'\barcessitur\b', 'arcesso'),
    (r'\barcessituram\b', 'arcesso'),
    (r'\barcessitus\b', 'arcessitus2'),
    (r'\barcessitus\b', 'arcesso'),
    (r'\barcessiuit\b', 'arcesso'),
    (r'\barcessivi\b', 'arcesso'),
    (r'\barcessivisse\b', 'arcesso'),
    (r'\barcessivisti\b', 'arcesso'),
    (r'\barcessivit\b', 'arcesso'),
    (r'\barcesso\b', 'arcesso'),
    (r'\barcessor\b', 'arcesso'),
    (r'\barcessunt\b', 'arcesso'),
    (r'\barcessuntur\b', 'arcesso'),
    (r'\barcet\b', 'arceo'),
    (r'\barcete\b', 'arceo'),
    (r'\barcetque\b', 'arceo'),
    (r'\barcetur\b', 'arceo'),
    (r'\barceuthina\b', 'arceuthinus'),
    (r'\bArchaeopolis\b', 'Archaeopolis'),
    (r'\bArchagathi\b', 'archangelus'),
    (r'\bArchagatho\b', 'archangelus'),
    (r'\bArchagathum\b', 'archangelus'),
    (r'\bArchagathus\b', 'archangelus'),
    (r'\barchangeli\b', 'archangelus'),
    (r'\barchangelus\b', 'archangelus'),
    (r'\barche\b', 'arche'),
    (r'\bArchelai\b', 'Archelaus'),
    (r'\bArchelaidem\b', 'Archelaus'),
    (r'\bArchelao\b', 'Archelaus'),
    (r'\bArchelaum\b', 'Archelaus'),
    (r'\bArchelaus\b', 'Archelaus'),
    (r'\barcheotae\b', 'archeota'),
    (r'\barchetypa\b', 'archetypus'),
    (r'\barchetypa\b', 'archetypus'),
    (r'\barchetypas\b', 'archetypus'),
    (r'\barchetypis\b', 'archetypus'),
    (r'\barchetypis\b', 'archetypus'),
    (r'\barchetypo\b', 'archetypus'),
    (r'\barchetypo\b', 'archetypus'),
    (r'\barchetypon\b', 'archetypus'),
    (r'\barchetypon\b', 'archetypus'),
    (r'\barchetypos\b', 'archetypus'),
    (r'\barchetypum\b', 'archetypus'),
    (r'\barchetypum\b', 'archetypus'),
    (r'\barchezosti\b', 'archezostis'),
    (r'\barchezostim\b', 'archezostis'),
    (r'\barchezostis\b', 'archezostis'),
    (r'\bArchia\b', 'Archias'),
    (r'\barchia\b', 'archium'),
    (r'\bArchiaci\b', 'Archias'),
    (r'\bArchiacis\b', 'Archias'),
    (r'\bArchiae\b', 'Archias'),
    (r'\bArchiam\b', 'Archias'),
    (r'\bArchias\b', 'Archias'),
    (r'\bArchidemidem\b', 'Archidemus'),
    (r'\bArchidemum\b', 'Archidemus'),
    (r'\bArchidemus\b', 'Archidemus'),
    (r'\barchiereum\b', 'archiereus'),
    (r'\barchigalli\b', 'archigallus'),
    (r'\barchigallum\b', 'archigallus'),
    (r'\barchigubernus\b', 'archigubernus'),
    (r'\bArchilochi\b', 'Archilochus'),
    (r'\bArchilochi\b', 'Archilochus'),
    (r'\bArchilochia\b', 'Archilochus'),
    (r'\bArchilochio\b', 'Archilochus'),
    (r'\bArchilochium\b', 'Archilochus'),
    (r'\bArchilocho\b', 'Archilochus'),
    (r'\bArchilochon\b', 'Archilochus'),
    (r'\bArchilochum\b', 'Archilochus'),
    (r'\bArchilochus\b', 'Archilochus'),
    (r'\barchimagiri\b', 'archimagirus'),
    (r'\bArchimede\b', 'Archimedes'),
    (r'\bArchimedem\b', 'Archimedes'),
    (r'\bArchimeden\b', 'Archimedes'),
    (r'\bArchimedes\b', 'Archimedes'),
    (r'\bArchimedi\b', 'Archimedes'),
    (r'\bArchimedis\b', 'Archimedes'),
    (r'\barchimimi\b', 'archimimus'),
    (r'\barchimimum\b', 'archimimus'),
    (r'\barchimimus\b', 'archimimus'),
    (r'\barchio\b', 'archium'),
    (r'\barchipirata\b', 'archipirata'),
    (r'\barchipiratae\b', 'archipirata'),
    (r'\barchipiratam\b', 'archipirata'),
    (r'\barchipiratas\b', 'archipirata'),
    (r'\barchisynagogi\b', 'archisynagogus'),
    (r'\barchisynagogis\b', 'archisynagogus'),
    (r'\barchisynagogo\b', 'archisynagogus'),
    (r'\barchisynagogum\b', 'archisynagogus'),
    (r'\barchisynagogus\b', 'archisynagogus'),
    (r'\barchitecte\b', 'architectus'),
    (r'\barchitecti\b', 'architectus'),
    (r'\barchitectis\b', 'architecta'),
    (r'\barchitectis\b', 'architectus'),
    (r'\barchitecto\b', 'architectus'),
    (r'\barchitectonica\b', 'architectonice'),
    (r'\barchitectonica\b', 'architectonicus'),
    (r'\barchitectonicas\b', 'architectonice'),
    (r'\barchitectonice\b', 'architectonicus'),
    (r'\barchitectonice\b', 'architectonice'),
    (r'\barchitectorum\b', 'architectus'),
    (r'\barchitectos\b', 'architectus'),
    (r'\barchitectum\b', 'architectus'),
    (r'\barchitectura\b', 'architectura'),
    (r'\barchitecturae\b', 'architectura'),
    (r'\barchitecturam\b', 'architectura'),
    (r'\barchitectus\b', 'architectus'),
    (r'\barchitectust\b', 'architectus'),
    (r'\barchitriclino\b', 'architriclinus'),
    (r'\barchitriclinus\b', 'architriclinus'),
    (r'\bArchonidas\b', 'Archytas'),
    (r'\bArchyta\b', 'Archytas'),
    (r'\bArchytae\b', 'Archytas'),
    (r'\bArchytam\b', 'Archytas'),
    (r'\bArchytas\b', 'Archytas'),
    (r'\barci\b', 'arx'),
    (r'\barcibus\b', 'arx'),
    (r'\barcibus\b', 'arcus'),
    (r'\barcifinale\b', 'arcifinalis'),
    (r'\barcifinales\b', 'arcifinalis'),
    (r'\barcion\b', 'arcion'),
    (r'\barcis\b', 'arca'),
    (r'\barcis\b', 'arx'),
    (r'\barcisque\b', 'arca'),
    (r'\barcisque\b', 'arx'),
    (r'\bArcitenens\b', 'Arcitenens'),
    (r'\bArcitenensque\b', 'Arcitenens'),
    (r'\barcium\b', 'arcion'),
    (r'\barcti\b', 'arctos'),
    (r'\barcti\b', 'artus1'),
    (r'\barcti\b', 'arceo'),
    (r'\barctici\b', 'arcticus'),
    (r'\barctico\b', 'arcticus'),
    (r'\barcticon\b', 'arcticus'),
    (r'\barcticos\b', 'arcticus'),
    (r'\barcticum\b', 'arcticus'),
    (r'\barcticus\b', 'arcticus'),
    (r'\barctio\b', 'arction'),
    (r'\barction\b', 'arction'),
    (r'\barcto\b', 'arctos'),
    (r'\barcto\b', 'artus1'),
    (r'\barcto\b', 'arceo'),
    (r'\barctoa\b', 'arctous'),
    (r'\barctoae\b', 'arctous'),
    (r'\barctoam\b', 'arctous'),
    (r'\barctoas\b', 'arctous'),
    (r'\barctoe\b', 'arctous'),
    (r'\barctoi\b', 'arctous'),
    (r'\barctois\b', 'arctous'),
    (r'\barcton\b', 'arctos'),
    (r'\barcton\b', 'artus1'),
    (r'\barcton\b', 'arceo'),
    (r'\barctonque\b', 'arctos'),
    (r'\barctonque\b', 'artus1'),
    (r'\barctonque\b', 'arceo'),
    (r'\barctoo\b', 'arctous'),
    (r'\barctoos\b', 'arctous'),
    (r'\barctoosne\b', 'arctous'),
    (r'\bArctophylax\b', 'Arctophylax'),
    (r'\barctoque\b', 'arctos'),
    (r'\barctoque\b', 'artus1'),
    (r'\barctoque\b', 'arceo'),
    (r'\barctorum\b', 'arctos'),
    (r'\barctorum\b', 'artus1'),
    (r'\barctorum\b', 'arceo'),
    (r'\barctos\b', 'arctos'),
    (r'\barctos\b', 'artus1'),
    (r'\barctos\b', 'arceo'),
    (r'\barctosque\b', 'arctos'),
    (r'\barctosque\b', 'artus1'),
    (r'\barctosque\b', 'arceo'),
    (r'\barctoum\b', 'arctous'),
    (r'\barctous\b', 'arctous'),
    (r'\barctum\b', 'arctos'),
    (r'\barctum\b', 'artus1'),
    (r'\barctum\b', 'arceo'),
    (r'\barcturi\b', 'arceo'),
    (r'\barcturi\b', 'arcturus'),
    (r'\barcturique\b', 'arceo'),
    (r'\barcturique\b', 'arcturus'),
    (r'\barcturo\b', 'arceo'),
    (r'\barcturo\b', 'arcturus'),
    (r'\barcturon\b', 'arceo'),
    (r'\barcturon\b', 'arcturus'),
    (r'\barcturum\b', 'arceo'),
    (r'\barcturum\b', 'arcturus'),
    (r'\barcturumque\b', 'arceo'),
    (r'\barcturumque\b', 'arcturus'),
    (r'\barcturus\b', 'arceo'),
    (r'\barcturus\b', 'arcturus'),
    (r'\barctus\b', 'artus1'),
    (r'\barctus\b', 'arceo'),
    (r'\barcu\b', 'arcus'),
    (r'\barcuarii\b', 'arcuarius'),
    (r'\barcuatim\b', 'arcuatim'),
    (r'\barcuationibus\b', 'arcuatio'),
    (r'\barcuationibusque\b', 'arcuatio'),
    (r'\barcuationibusve\b', 'arcuatio'),
    (r'\barcuato\b', 'arcuo'),
    (r'\barcuato\b', 'arcuatus'),
    (r'\barcuatoque\b', 'arcuo'),
    (r'\barcuatoque\b', 'arcuatus'),
    (r'\barcuatum\b', 'arcuatus'),
    (r'\barcuatum\b', 'arcuo'),
    (r'\barcuatur\b', 'arcuo'),
    (r'\barcuatura\b', 'arcuo'),
    (r'\barcubus\b', 'arcus'),
    (r'\barcuerant\b', 'arceo'),
    (r'\barcuerat\b', 'arceo'),
    (r'\barcuere\b', 'arceo'),
    (r'\barcuere\b', 'arcuo'),
    (r'\barcuerim\b', 'arceo'),
    (r'\barcuerint\b', 'arceo'),
    (r'\barcuerit\b', 'arceo'),
    (r'\barcuerunt\b', 'arceo'),
    (r'\barcui\b', 'arcus'),
    (r'\barcui\b', 'arceo'),
    (r'\barcuisse\b', 'arceo'),
    (r'\barcuissem\b', 'arceo'),
    (r'\barcuissent\b', 'arceo'),
    (r'\barcuisset\b', 'arceo'),
    (r'\barcuit\b', 'arceo'),
    (r'\barcula\b', 'arcula'),
    (r'\barcula\b', 'arculum'),
    (r'\barculae\b', 'arcula'),
    (r'\barculam\b', 'arcula'),
    (r'\barcularii\b', 'arcularius'),
    (r'\barcularum\b', 'arcula'),
    (r'\barculas\b', 'arcula'),
    (r'\barculis\b', 'arcula'),
    (r'\barculis\b', 'arculum'),
    (r'\barculum\b', 'arculum'),
    (r'\barcum\b', 'arx'),
    (r'\barcum\b', 'arcus'),
    (r'\barcumque\b', 'arx'),
    (r'\barcumque\b', 'arcus'),
    (r'\barcuque\b', 'arcus'),
    (r'\barcus\b', 'arcus'),
    (r'\barcusque\b', 'arcus'),
    (r'\barcuum\b', 'arcus'),
    (r'\barda\b', 'ardus'),
    (r'\bardae\b', 'ardus'),
    (r'\barde\b', 'ardus'),
    (r'\barde\b', 'ardeo'),
    (r'\bardea\b', 'ardea1'),
    (r'\bArdea\b', 'Ardea2'),
    (r'\bardeae\b', 'ardea1'),
    (r'\bArdeae\b', 'Ardea2'),
    (r'\bardeam\b', 'ardea1'),
    (r'\bArdeam\b', 'Ardea2'),
    (r'\bardeam\b', 'ardeo'),
    (r'\bardeamque\b', 'ardea1'),
    (r'\bArdeamque\b', 'Ardea2'),
    (r'\bardeamque\b', 'ardeo'),
    (r'\bardeant\b', 'ardeo'),
    (r'\bardeat\b', 'ardeo'),
    (r'\bArdeates\b', 'Ardeatinus'),
    (r'\bArdeatibus\b', 'Ardeatinus'),
    (r'\bArdeatibusque\b', 'Ardeatinus'),
    (r'\bArdeatinam\b', 'Ardeatinus'),
    (r'\bArdeatino\b', 'Ardeatinus'),
    (r'\bArdeatis\b', 'Ardeatinus'),
    (r'\bardeatis\b', 'ardeo'),
    (r'\bArdeatium\b', 'Ardeatinus'),
    (r'\bardebam\b', 'ardeo'),
    (r'\bardebant\b', 'ardeo'),
    (r'\bardebat\b', 'ardeo'),
    (r'\bardebimus\b', 'ardeo'),
    (r'\bardebis\b', 'ardeo'),
    (r'\bardebit\b', 'ardeo'),
    (r'\bardebunt\b', 'ardeo'),
    (r'\bardemus\b', 'ardeo'),
    (r'\bardendi\b', 'ardeo'),
    (r'\bardendo\b', 'ardeo'),
    (r'\bardens\b', 'ardeo'),
    (r'\bardensque\b', 'ardeo'),
    (r'\bardent\b', 'ardeo'),
    (r'\bardente\b', 'ardeo'),
    (r'\bardentem\b', 'ardeo'),
    (r'\bardentemque\b', 'ardeo'),
    (r'\bardenter\b', 'ardenter'),
    (r'\bardentes\b', 'ardeo'),
    (r'\bardentesque\b', 'ardeo'),
    (r'\bardenti\b', 'ardeo'),
    (r'\bardentia\b', 'ardeo'),
    (r'\bardentiaque\b', 'ardeo'),
    (r'\bardentibus\b', 'ardeo'),
    (r'\bardentior\b', 'ardeo'),
    (r'\bardentiore\b', 'ardeo'),
    (r'\bardentiorem\b', 'ardeo'),
    (r'\bardentioris\b', 'ardeo'),
    (r'\bardentiorque\b', 'ardeo'),
    (r'\bardentique\b', 'ardeo'),
    (r'\bardentis\b', 'ardeo'),
    (r'\bardentisque\b', 'ardeo'),
    (r'\bardentissima\b', 'ardeo'),
    (r'\bardentissimae\b', 'ardeo'),
    (r'\bardentissime\b', 'ardeo'),
    (r'\bardentissimi\b', 'ardeo'),
    (r'\bardentissimis\b', 'ardeo'),
    (r'\bardentissimo\b', 'ardeo'),
    (r'\bardentissimum\b', 'ardeo'),
    (r'\bardentissimus\b', 'ardeo'),
    (r'\bardentium\b', 'ardeo'),
    (r'\bardentius\b', 'ardeo'),
    (r'\bardentiusque\b', 'ardeo'),
    (r'\bardeo\b', 'ardeo'),
    (r'\bardere\b', 'ardeo'),
    (r'\barderem\b', 'ardeo'),
    (r'\barderent\b', 'ardeo'),
    (r'\barderet\b', 'ardeo'),
    (r'\bardes\b', 'ardeo'),
    (r'\bardet\b', 'ardeo'),
    (r'\bardetis\b', 'ardeo'),
    (r'\bardetque\b', 'ardeo'),
    (r'\bardifeta\b', 'ardifetus'),
    (r'\bardon\b', 'ardus'),
    (r'\bardor\b', 'ardor'),
    (r'\bardore\b', 'ardor'),
    (r'\bardorem\b', 'ardor'),
    (r'\bardoremque\b', 'ardor'),
    (r'\bardoreque\b', 'ardor'),
    (r'\bardores\b', 'ardor'),
    (r'\bardori\b', 'ardor'),
    (r'\bardoribus\b', 'ardor'),
    (r'\bardoris\b', 'ardor'),
    (r'\bardorque\b', 'ardor'),
    (r'\bardorue\b', 'ardor'),
    (r'\bardorum\b', 'ardor'),
    (r'\bardorum\b', 'ardus'),
    (r'\bardua\b', 'arduus'),
    (r'\bardua\b', 'arduus'),
    (r'\barduae\b', 'arduus'),
    (r'\barduam\b', 'arduus'),
    (r'\barduaque\b', 'arduus'),
    (r'\barduaque\b', 'arduus'),
    (r'\barduarum\b', 'arduus'),
    (r'\barduas\b', 'arduus'),
    (r'\bArduenna\b', 'Arduenna'),
    (r'\bArduennae\b', 'Arduenna'),
    (r'\bArduennam\b', 'Arduenna'),
    (r'\bardui\b', 'arduus'),
    (r'\bardui\b', 'arduus'),
    (r'\barduis\b', 'arduus'),
    (r'\barduis\b', 'arduus'),
    (r'\barduisque\b', 'arduus'),
    (r'\barduisque\b', 'arduus'),
    (r'\barduissimo\b', 'arduus'),
    (r'\barduitatem\b', 'arduitas'),
    (r'\barduiusque\b', 'arduus'),
    (r'\bardum\b', 'ardus'),
    (r'\barduo\b', 'arduus'),
    (r'\barduo\b', 'arduus'),
    (r'\barduom\b', 'arduus'),
    (r'\barduom\b', 'arduus'),
    (r'\barduorum\b', 'arduus'),
    (r'\barduorum\b', 'arduus'),
    (r'\barduos\b', 'arduus'),
    (r'\barduum\b', 'arduus'),
    (r'\barduum\b', 'arduus'),
    (r'\barduus\b', 'arduus'),
    (r'\bare\b', 'aros'),
    (r'\bare\b', 'aron'),
    (r'\bare\b', 'areo'),
    (r'\bArea\b', 'Areus'),
    (r'\bareale\b', 'arealis'),
    (r'\barealem\b', 'arealis'),
    (r'\bAream\b', 'Areus'),
    (r'\baream\b', 'areo'),
    (r'\bareamque\b', 'areo'),
    (r'\bArearum\b', 'Areus'),
    (r'\bareas\b', 'areo'),
    (r'\bAreatas\b', 'Areatae'),
    (r'\barebant\b', 'areo'),
    (r'\barebat\b', 'areo'),
    (r'\barebit\b', 'areo'),
    (r'\barebunt\b', 'areo'),
    (r'\bAree\b', 'Areus'),
    (r'\barefacere\b', 'arefacio'),
    (r'\barefaciam\b', 'arefacio'),
    (r'\barefaciens\b', 'arefacio'),
    (r'\barefacientes\b', 'arefacio'),
    (r'\barefaciet\b', 'arefacio'),
    (r'\barefacit\b', 'arefacio'),
    (r'\barefacito\b', 'arefacio'),
    (r'\barefaciunt\b', 'arefacio'),
    (r'\barefacta\b', 'arefacio'),
    (r'\barefactae\b', 'arefacio'),
    (r'\barefactam\b', 'arefacio'),
    (r'\barefactaque\b', 'arefacio'),
    (r'\barefacti\b', 'arefacio'),
    (r'\barefactis\b', 'arefacio'),
    (r'\barefacto\b', 'arefacio'),
    (r'\barefactorum\b', 'arefacio'),
    (r'\barefactum\b', 'arefacio'),
    (r'\barefactumque\b', 'arefacio'),
    (r'\barefactus\b', 'arefacio'),
    (r'\barefecit\b', 'arefacio'),
    (r'\bArei\b', 'Areus'),
    (r'\bArelate\b', 'Arelatensis'),
    (r'\barelate\b', 'a-refero'),
    (r'\bArelatensi\b', 'Arelatensis'),
    (r'\bArelatensis\b', 'Arelatensis'),
    (r'\bArelatensis\b', 'Arelatensis'),
    (r'\bArelatensium\b', 'Arelatensis'),
    (r'\bArelatensium\b', 'Arelatensis'),
    (r'\bArem\b', 'a-repleo'),
    (r'\barem\b', 'aro'),
    (r'\bAremoricae\b', 'Armoricae'),
    (r'\baremus\b', 'areo'),
    (r'\baremus\b', 'aro'),
    (r'\baren\b', 'aros'),
    (r'\bAren\b', 'a-repleo'),
    (r'\baren\b', 'aron'),
    (r'\baren\b', 'areo'),
    (r'\baren\b', 'aro'),
    (r'\barena\b', 'harena'),
    (r'\barena\b', 'arena'),
    (r'\bArenaci\b', 'Arenacum'),
    (r'\barenae\b', 'harena'),
    (r'\barenam\b', 'harena'),
    (r'\barenarius\b', 'arenarius'),
    (r'\barenarum\b', 'harena'),
    (r'\barenas\b', 'harena'),
    (r'\barenas\b', 'arena'),
    (r'\bArene\b', 'a-repleo'),
    (r'\barene\b', 'a-reneo'),
    (r'\bArenenque\b', 'a-repleo'),
    (r'\barenenque\b', 'arena'),
    (r'\barenis\b', 'harena'),
    (r'\barenosa\b', 'arenosus'),
    (r'\barenosum\b', 'arenosus'),
    (r'\barenosus\b', 'arenosus'),
    (r'\barens\b', 'areo'),
    (r'\barent\b', 'areo'),
    (r'\barent\b', 'aro'),
    (r'\barente\b', 'areo'),
    (r'\barentem\b', 'areo'),
    (r'\barentemque\b', 'areo'),
    (r'\barentes\b', 'areo'),
    (r'\barentesque\b', 'areo'),
    (r'\barenti\b', 'areo'),
    (r'\barentia\b', 'areo'),
    (r'\barentibus\b', 'areo'),
    (r'\barentique\b', 'areo'),
    (r'\barentis\b', 'areo'),
    (r'\barentisque\b', 'areo'),
    (r'\barentium\b', 'areo'),
    (r'\barentur\b', 'areo'),
    (r'\barentur\b', 'aro'),
    (r'\bAreo\b', 'Areus'),
    (r'\bareo\b', 'areo'),
    (r'\bareola\b', 'areola'),
    (r'\bareolae\b', 'areola'),
    (r'\bareolam\b', 'areola'),
    (r'\bareolas\b', 'areola'),
    (r'\bareolis\b', 'areola'),
    (r'\bAreon\b', 'Areus'),
    (r'\bareon\b', 'areo'),
    (r'\bAreopagi\b', 'Areopagus'),
    (r'\bAreopagitae\b', 'Areopagites'),
    (r'\bAreopagitarum\b', 'Areopagites'),
    (r'\bAreopagitas\b', 'Areopagites'),
    (r'\bAreopagites\b', 'Areopagites'),
    (r'\bAreopago\b', 'Areopagus'),
    (r'\bAreopagum\b', 'Areopagus'),
    (r'\bAreos\b', 'Areus'),
    (r'\barepennem\b', 'arepennis'),
    (r'\barer\b', 'aro'),
    (r'\barere\b', 'areo'),
    (r'\barere\b', 'aro'),
    (r'\barerem\b', 'areo'),
    (r'\bAres\b', 'a-repleo'),
    (r'\bares\b', 'areo'),
    (r'\bares\b', 'aro'),
    (r'\barescant\b', 'aresco'),
    (r'\barescat\b', 'aresco'),
    (r'\barescens\b', 'aresco'),
    (r'\barescent\b', 'aresco'),
    (r'\barescente\b', 'aresco'),
    (r'\barescentem\b', 'aresco'),
    (r'\barescentes\b', 'aresco'),
    (r'\barescentibus\b', 'aresco'),
    (r'\barescentique\b', 'aresco'),
    (r'\barescentis\b', 'aresco'),
    (r'\barescentium\b', 'aresco'),
    (r'\barescere\b', 'aresco'),
    (r'\barescet\b', 'aresco'),
    (r'\baresci\b', 'aresco'),
    (r'\barescit\b', 'aresco'),
    (r'\barescitve\b', 'aresco'),
    (r'\barescunt\b', 'aresco'),
    (r'\bArestoridae\b', 'Arestorides'),
    (r'\baret\b', 'areo'),
    (r'\baret\b', 'aro'),
    (r'\bAreta\b', 'Arete'),
    (r'\bareta\b', 'a-repleo'),
    (r'\bAretae\b', 'Arete'),
    (r'\baretae\b', 'a-repleo'),
    (r'\baretalogos\b', 'aretalogus'),
    (r'\baretalogus\b', 'aretalogus'),
    (r'\bArete\b', 'Arete'),
    (r'\barete\b', 'areo'),
    (r'\bAreten\b', 'Arete'),
    (r'\bareten\b', 'areo'),
    (r'\bAretes\b', 'Arete'),
    (r'\bAretho\b', 'Aretho'),
    (r'\bArethonis\b', 'Aretho'),
    (r'\bArethusa\b', 'Arethusa'),
    (r'\bArethusae\b', 'Arethusa'),
    (r'\bArethusam\b', 'Arethusa'),
    (r'\bArethusia\b', 'Aretinus'),
    (r'\bArethusii\b', 'Aretinus'),
    (r'\bArethusii\b', 'Aretinus'),
    (r'\bArethusios\b', 'Aretinus'),
    (r'\baretque\b', 'areo'),
    (r'\baretque\b', 'aro'),
    (r'\baretur\b', 'areo'),
    (r'\baretur\b', 'aro'),
    (r'\bAreum\b', 'Areus'),
    (r'\bAreus\b', 'Areus'),
    (r'\bArga\b', 'Argus'),
    (r'\bArganthi\b', 'Arganthus'),
    (r'\bArganthoniacos\b', 'Arganthonius'),
    (r'\bArganthonio\b', 'Arganthonius'),
    (r'\bArganthonium\b', 'Arganthonius'),
    (r'\bArganthonius\b', 'Arganthonius'),
    (r'\bArge\b', 'Argus'),
    (r'\bArgea\b', 'Argeus'),
    (r'\bArgeas\b', 'Argeus'),
    (r'\bArgei\b', 'Argei'),
    (r'\bArgei\b', 'Argeus'),
    (r'\bargema\b', 'argema'),
    (r'\bargema\b', 'argemon'),
    (r'\bargemo\b', 'argemon'),
    (r'\bargemon\b', 'argemon'),
    (r'\bargemonen\b', 'argemone'),
    (r'\bargemonia\b', 'argemonia'),
    (r'\bargemoniae\b', 'argemonia'),
    (r'\bargennon\b', 'argennon'),
    (r'\bargenta\b', 'argentum'),
    (r'\bArgentanum\b', 'Argentanum'),
    (r'\bargentari\b', 'argentarius1'),
    (r'\bargentari\b', 'argentarius1'),
    (r'\bargentari\b', 'argentarium'),
    (r'\bargentaria\b', 'argentaria'),
    (r'\bargentaria\b', 'argentarium'),
    (r'\bargentariae\b', 'argentaria'),
    (r'\bargentariam\b', 'argentaria'),
    (r'\bargentariarum\b', 'argentaria'),
    (r'\bargentarias\b', 'argentaria'),
    (r'\bargentarii\b', 'argentarius1'),
    (r'\bargentarii\b', 'argentarium'),
    (r'\bargentariis\b', 'argentaria'),
    (r'\bargentariis\b', 'argentarius1'),
    (r'\bargentariis\b', 'argentarium'),
    (r'\bargentariisque\b', 'argentaria'),
    (r'\bargentariisque\b', 'argentarius1'),
    (r'\bargentariisque\b', 'argentarium'),
    (r'\bargentario\b', 'argentarius1'),
    (r'\bargentario\b', 'argentarium'),
    (r'\bargentariorum\b', 'argentarius1'),
    (r'\bargentariorum\b', 'argentarium'),
    (r'\bargentariorumque\b', 'argentarius1'),
    (r'\bargentariorumque\b', 'argentarium'),
    (r'\bargentarios\b', 'argentarius1'),
    (r'\bargentarium\b', 'argentarius1'),
    (r'\bargentarium\b', 'argentarium'),
    (r'\bargentarium\b', 'argentarius1'),
    (r'\bargentarius\b', 'argentarius1'),
    (r'\bargentata\b', 'argentatus'),
    (r'\bargentatas\b', 'argentatus'),
    (r'\bargentati\b', 'argentatus'),
    (r'\bargentatis\b', 'argentatus'),
    (r'\bargente\b', 'argentum'),
    (r'\bargentea\b', 'argenteus1'),
    (r'\bargenteae\b', 'argenteus1'),
    (r'\bargenteam\b', 'argenteus1'),
    (r'\bArgenteam\b', 'Argenteus2'),
    (r'\bargenteamque\b', 'argenteus1'),
    (r'\bargenteaque\b', 'argenteus1'),
    (r'\bargenteas\b', 'argenteus1'),
    (r'\bargentei\b', 'argenteus1'),
    (r'\bargenteis\b', 'argenteus1'),
    (r'\bargenteisque\b', 'argenteus1'),
    (r'\bargenteo\b', 'argenteus1'),
    (r'\bArgenteo\b', 'Argenteus2'),
    (r'\bargenteoque\b', 'argenteus1'),
    (r'\bargenteorum\b', 'argenteus1'),
    (r'\bargenteos\b', 'argenteus1'),
    (r'\bargenteosque\b', 'argenteus1'),
    (r'\bargenteum\b', 'argenteus1'),
    (r'\bArgenteum\b', 'Argenteus2'),
    (r'\bargenteumque\b', 'argenteus1'),
    (r'\bargenteus\b', 'argenteus1'),
    (r'\bArgenteus\b', 'Argenteus2'),
    (r'\bargenti\b', 'argentum'),
    (r'\bargentifodinae\b', 'argentifodina'),
    (r'\bargentifodinarum\b', 'argentifodina'),
    (r'\bargentifodinas\b', 'argentifodina'),
    (r'\bargentique\b', 'argentum'),
    (r'\bargentiue\b', 'argentum'),
    (r'\bargentive\b', 'argentum'),
    (r'\bargento\b', 'argentum'),
    (r'\bargentoque\b', 'argentum'),
    (r'\bargentost\b', 'argentum'),
    (r'\bargentosum\b', 'argentosus'),
    (r'\bargentoue\b', 'argentum'),
    (r'\bargentove\b', 'argentum'),
    (r'\bargentum\b', 'argentum'),
    (r'\bargentumque\b', 'argentum'),
    (r'\bargentumst\b', 'argentum'),
    (r'\bargentumue\b', 'argentum'),
    (r'\bArgeo\b', 'Argeus'),
    (r'\bArgeorum\b', 'Argei'),
    (r'\bArgeorum\b', 'Argeus'),
    (r'\bArgeos\b', 'Argei'),
    (r'\bargeste\b', 'argestes1'),
    (r'\bargesten\b', 'argestes1'),
    (r'\bargestes\b', 'argestes1'),
    (r'\bArgestes\b', 'Argestes2'),
    (r'\bArgeum\b', 'Argei'),
    (r'\bArgeum\b', 'Argeus'),
    (r'\bArgi\b', 'Argi'),
    (r'\bArgi\b', 'Argus'),
    (r'\bArgia\b', 'Argia'),
    (r'\bArgiae\b', 'Argia'),
    (r'\bArgiam\b', 'Argia'),
    (r'\bArgian\b', 'Argia'),
    (r'\bArgiletanam\b', 'Argiletum'),
    (r'\bArgiletanas\b', 'Argiletum'),
    (r'\bArgiletani\b', 'Argiletum'),
    (r'\bArgileti\b', 'Argiletum'),
    (r'\bArgiletum\b', 'Argiletum'),
    (r'\bargilla\b', 'argilla'),
    (r'\bargillacea\b', 'argillaceus'),
    (r'\bargillae\b', 'argilla'),
    (r'\bargillam\b', 'argilla'),
    (r'\bargillamque\b', 'argilla'),
    (r'\bargillis\b', 'argilla'),
    (r'\bargillosa\b', 'argillosus'),
    (r'\bargillosam\b', 'argillosus'),
    (r'\bargillosis\b', 'argillosus'),
    (r'\bargilloso\b', 'argillosus'),
    (r'\bArginusis\b', 'Arginusae'),
    (r'\bArginussas\b', 'Arginusae'),
    (r'\bArgique\b', 'Argi'),
    (r'\bArgique\b', 'Argus'),
    (r'\bArgis\b', 'Argi'),
    (r'\bArgis\b', 'Argus'),
    (r'\bArgisque\b', 'Argi'),
    (r'\bArgisque\b', 'Argus'),
    (r'\bArgisue\b', 'Argi'),
    (r'\bArgisue\b', 'Argus'),
    (r'\bArgitheae\b', 'Argithea'),
    (r'\bArgitheam\b', 'Argithea'),
    (r'\bargitis\b', 'argitis'),
    (r'\bargitisque\b', 'argitis'),
    (r'\bArgiua\b', 'Argivus'),
    (r'\bArgiuae\b', 'Argivus'),
    (r'\bArgiuam\b', 'Argivus'),
    (r'\bArgiuaque\b', 'Argivus'),
    (r'\bArgiue\b', 'Argivus'),
    (r'\bArgiue\b', 'Argi'),
    (r'\bArgiue\b', 'Argus'),
    (r'\bArgiui\b', 'Argivus'),
    (r'\bArgiuis\b', 'Argivus'),
    (r'\bArgiuo\b', 'Argivus'),
    (r'\bArgiuom\b', 'Argivus'),
    (r'\bArgiuorum\b', 'Argivus'),
    (r'\bArgiuos\b', 'Argivus'),
    (r'\bArgius\b', 'Argus'),
    (r'\bArgiuum\b', 'Argivus'),
    (r'\bArgiuus\b', 'Argivus'),
    (r'\bArgiva\b', 'Argivus'),
    (r'\bArgivae\b', 'Argivus'),
    (r'\bArgivam\b', 'Argivus'),
    (r'\bArgivaque\b', 'Argivus'),
    (r'\bArgivas\b', 'Argivus'),
    (r'\bArgive\b', 'Argivus'),
    (r'\bArgivi\b', 'Argivus'),
    (r'\bArgivis\b', 'Argivus'),
    (r'\bArgivisque\b', 'Argivus'),
    (r'\bArgivo\b', 'Argivus'),
    (r'\bArgivorum\b', 'Argivus'),
    (r'\bArgivos\b', 'Argivus'),
    (r'\bArgivum\b', 'Argivus'),
    (r'\bArgivumque\b', 'Argivus'),
    (r'\bArgivus\b', 'Argivus'),
    (r'\bArgo\b', 'Argo'),
    (r'\bArgo\b', 'Argus'),
    (r'\bArgoa\b', 'Argous'),
    (r'\bArgoae\b', 'Argous'),
    (r'\bArgoaeque\b', 'Argous'),
    (r'\bArgoaque\b', 'Argous'),
    (r'\bArgoi\b', 'Argo'),
    (r'\bArgoi\b', 'Argous'),
    (r'\bArgolica\b', 'Argolicus'),
    (r'\bArgolicae\b', 'Argolicus'),
    (r'\bArgolicaeque\b', 'Argolicus'),
    (r'\bArgolicam\b', 'Argolicus'),
    (r'\bArgolicamque\b', 'Argolicus'),
    (r'\bArgolicas\b', 'Argolicus'),
    (r'\bArgolicasque\b', 'Argolicus'),
    (r'\bArgolici\b', 'Argolicus'),
    (r'\bArgolicique\b', 'Argolicus'),
    (r'\bArgolicis\b', 'Argolicus'),
    (r'\bArgolicisque\b', 'Argolicus'),
    (r'\bArgolico\b', 'Argolicus'),
    (r'\bArgolicos\b', 'Argolicus'),
    (r'\bArgolicosque\b', 'Argolicus'),
    (r'\bArgolicoue\b', 'Argolicus'),
    (r'\bArgolicove\b', 'Argolicus'),
    (r'\bArgolicum\b', 'Argolicus'),
    (r'\bArgolicumque\b', 'Argolicus'),
    (r'\bArgolicus\b', 'Argolicus'),
    (r'\bArgolicusque\b', 'Argolicus'),
    (r'\bArgolide\b', 'Argolis'),
    (r'\bArgolides\b', 'Argolis'),
    (r'\bArgolidum\b', 'Argolis'),
    (r'\bArgolis\b', 'Argolis'),
    (r'\bArgon\b', 'Argo'),
    (r'\bArgon\b', 'Argi'),
    (r'\bArgon\b', 'Argus'),
    (r'\bArgonautae\b', 'Argonautae'),
    (r'\bArgonautarum\b', 'Argonautae'),
    (r'\bArgonautas\b', 'Argonautae'),
    (r'\bArgonautica\b', 'Argonauticus'),
    (r'\bArgonautica\b', 'Argonauticus'),
    (r'\bArgonautis\b', 'Argonautae'),
    (r'\bArgoo\b', 'Argous'),
    (r'\bArgoos\b', 'Argous'),
    (r'\bArgos\b', 'Argi'),
    (r'\bArgosque\b', 'Argi'),
    (r'\barguam\b', 'arguo'),
    (r'\barguamus\b', 'arguo'),
    (r'\barguant\b', 'arguo'),
    (r'\barguantur\b', 'arguo'),
    (r'\barguar\b', 'arguo'),
    (r'\barguare\b', 'arguo'),
    (r'\barguaris\b', 'arguo'),
    (r'\barguas\b', 'arguo'),
    (r'\barguat\b', 'arguo'),
    (r'\barguatis\b', 'arguo'),
    (r'\barguatur\b', 'arguo'),
    (r'\bargue\b', 'arguo'),
    (r'\barguebam\b', 'arguo'),
    (r'\barguebant\b', 'arguo'),
    (r'\barguebantur\b', 'arguo'),
    (r'\barguebas\b', 'arguo'),
    (r'\barguebat\b', 'arguo'),
    (r'\barguebatur\b', 'arguo'),
    (r'\barguebaturve\b', 'arguo'),
    (r'\barguemur\b', 'arguo'),
    (r'\barguenda\b', 'arguo'),
    (r'\barguendae\b', 'arguo'),
    (r'\barguendi\b', 'arguo'),
    (r'\barguendique\b', 'arguo'),
    (r'\barguendo\b', 'arguo'),
    (r'\barguendum\b', 'arguo'),
    (r'\barguens\b', 'arguo'),
    (r'\barguent\b', 'arguo'),
    (r'\barguente\b', 'arguo'),
    (r'\barguentem\b', 'arguo'),
    (r'\barguentes\b', 'arguo'),
    (r'\barguenti\b', 'arguo'),
    (r'\barguentibus\b', 'arguo'),
    (r'\barguentibusque\b', 'arguo'),
    (r'\barguentis\b', 'arguo'),
    (r'\barguentium\b', 'arguo'),
    (r'\barguentur\b', 'arguo'),
    (r'\barguerat\b', 'arguo'),
    (r'\barguere\b', 'arguo'),
    (r'\barguerem\b', 'arguo'),
    (r'\barguerent\b', 'arguo'),
    (r'\barguerentur\b', 'arguo'),
    (r'\barguerer\b', 'arguo'),
    (r'\bargueres\b', 'arguo'),
    (r'\bargueret\b', 'arguo'),
    (r'\bargueretur\b', 'arguo'),
    (r'\barguerim\b', 'arguo'),
    (r'\barguerint\b', 'arguo'),
    (r'\bargueris\b', 'arguo'),
    (r'\barguerit\b', 'arguo'),
    (r'\barguero\b', 'arguo'),
    (r'\barguet\b', 'arguo'),
    (r'\barguetur\b', 'arguo'),
    (r'\bargui\b', 'arguo'),
    (r'\barguimur\b', 'arguo'),
    (r'\barguimus\b', 'arguo'),
    (r'\barguis\b', 'arguo'),
    (r'\barguisse\b', 'arguo'),
    (r'\barguit\b', 'arguo'),
    (r'\barguite\b', 'arguo'),
    (r'\barguitis\b', 'arguo'),
    (r'\barguito\b', 'arguo'),
    (r'\barguitur\b', 'arguo'),
    (r'\barguiturque\b', 'arguo'),
    (r'\bArgum\b', 'Argi'),
    (r'\bArgum\b', 'Argus'),
    (r'\bargumenta\b', 'argumentum'),
    (r'\bargumentabatur\b', 'argumentor'),
    (r'\bargumentaberis\b', 'argumentor'),
    (r'\bargumentabimur\b', 'argumentor'),
    (r'\bargumentabitur\b', 'argumentor'),
    (r'\bargumentabor\b', 'argumentor'),
    (r'\bargumentamur\b', 'argumentor'),
    (r'\bargumentandi\b', 'argumentor'),
    (r'\bargumentando\b', 'argumentor'),
    (r'\bargumentandum\b', 'argumentor'),
    (r'\bargumentante\b', 'argumentor'),
    (r'\bargumentantes\b', 'argumentor'),
    (r'\bargumentantibus\b', 'argumentor'),
    (r'\bargumentantur\b', 'argumentor'),
    (r'\bargumentaque\b', 'argumentum'),
    (r'\bargumentare\b', 'argumentor'),
    (r'\bargumentarer\b', 'argumentor'),
    (r'\bargumentarere\b', 'argumentor'),
    (r'\bargumentari\b', 'argumentor'),
    (r'\bargumentaris\b', 'argumentor'),
    (r'\bargumentata\b', 'argumentor'),
    (r'\bargumentati\b', 'argumentor'),
    (r'\bargumentatio\b', 'argumentatio'),
    (r'\bargumentatione\b', 'argumentatio'),
    (r'\bargumentationem\b', 'argumentatio'),
    (r'\bargumentationes\b', 'argumentatio'),
    (r'\bargumentationibus\b', 'argumentatio'),
    (r'\bargumentationis\b', 'argumentatio'),
    (r'\bargumentationum\b', 'argumentatio'),
    (r'\bargumentatis\b', 'argumentor'),
    (r'\bargumentatur\b', 'argumentor'),
    (r'\bargumentatus\b', 'argumentor'),
    (r'\bargumentemur\b', 'argumentor'),
    (r'\bargumenter\b', 'argumentor'),
    (r'\bargumenti\b', 'argumentum'),
    (r'\bargumentique\b', 'argumentum'),
    (r'\bargumentis\b', 'argumentum'),
    (r'\bargumentisque\b', 'argumentum'),
    (r'\bargumento\b', 'argumentum'),
    (r'\bargumentoque\b', 'argumentum'),
    (r'\bargumentor\b', 'argumentor'),
    (r'\bargumentorum\b', 'argumentum'),
    (r'\bargumentorumque\b', 'argumentum'),
    (r'\bargumentost\b', 'argumentum'),
    (r'\bargumentosum\b', 'argumentosus'),
    (r'\bargumentum\b', 'argumentum'),
    (r'\bargumentumque\b', 'argumentum'),
    (r'\barguo\b', 'arguo'),
    (r'\barguont\b', 'arguo'),
    (r'\barguor\b', 'arguo'),
    (r'\bArgus\b', 'Argo'),
    (r'\bArgus\b', 'Argus'),
    (r'\bArgusque\b', 'Argo'),
    (r'\bArgusque\b', 'Argus'),
    (r'\barguta\b', 'arguo'),
    (r'\bargutae\b', 'arguo'),
    (r'\bargutam\b', 'arguo'),
    (r'\bargutamini\b', 'argutor'),
    (r'\bargutando\b', 'argutor'),
    (r'\bargutarier\b', 'argutor'),
    (r'\bargutas\b', 'arguo'),
    (r'\bargutatio\b', 'argutatio'),
    (r'\bargutatori\b', 'argutator'),
    (r'\bargutatur\b', 'argutor'),
    (r'\bargute\b', 'arguo'),
    (r'\barguteque\b', 'arguo'),
    (r'\barguti\b', 'arguo'),
    (r'\bargutiae\b', 'argutiae'),
    (r'\bargutiarum\b', 'argutiae'),
    (r'\bargutias\b', 'argutiae'),
    (r'\bargutiis\b', 'argutiae'),
    (r'\bargutiola\b', 'argutiola'),
    (r'\bargutiolam\b', 'argutiola'),
    (r'\bargutior\b', 'arguo'),
    (r'\bargutiores\b', 'arguo'),
    (r'\bargutis\b', 'arguo'),
    (r'\bargutissima\b', 'arguo'),
    (r'\bargutissimam\b', 'arguo'),
    (r'\bargutissimas\b', 'arguo'),
    (r'\bargutissime\b', 'arguo'),
    (r'\bargutissimeque\b', 'arguo'),
    (r'\bargutius\b', 'arguo'),
    (r'\bargutiusque\b', 'arguo'),
    (r'\barguto\b', 'arguo'),
    (r'\bargutos\b', 'arguo'),
    (r'\bargutula\b', 'argutulus'),
    (r'\bargutulos\b', 'argutulus'),
    (r'\bargutum\b', 'arguo'),
    (r'\bargutumque\b', 'arguo'),
    (r'\bargutus\b', 'arguo'),
    (r'\bargutust\b', 'arguo'),
    (r'\barguunt\b', 'arguo'),
    (r'\barguuntur\b', 'arguo'),
    (r'\bArgynne\b', 'Argynnus'),
    (r'\bArgynni\b', 'Argynnus'),
    (r'\bargyranchen\b', 'argyranche'),
    (r'\bargyraspides\b', 'argyraspis'),
    (r'\bargyre\b', 'argyros'),
    (r'\bArgyripa\b', 'Argyrippa'),
    (r'\bArgyripae\b', 'Argyrippa'),
    (r'\bArgyripam\b', 'Argyrippa'),
    (r'\bArgyrippa\b', 'Argyrippa'),
    (r'\bArgyrippe\b', 'Argyrippus'),
    (r'\bArgyrippo\b', 'Argyrippus'),
    (r'\bArgyrippum\b', 'Argyrippus'),
    (r'\bArgyrippus\b', 'Argyrippus'),
    (r'\bargyritis\b', 'argyritis'),
    (r'\bargyrodamanti\b', 'argyrodamas'),
    (r'\bargyrodamas\b', 'argyrodamas'),
    (r'\bari\b', 'aros'),
    (r'\bAri\b', 'Aris2'),
    (r'\bAri\b', 'a-repleo'),
    (r'\bAri\b', 'Arius1'),
    (r'\bari\b', 'aron'),
    (r'\bAria\b', 'Aria1'),
    (r'\bAriadna\b', 'Ariadna'),
    (r'\bAriadnae\b', 'Ariadna'),
    (r'\bAriadnaeae\b', 'Ariana'),
    (r'\bAriadnaeis\b', 'Ariana'),
    (r'\bAriadnaeo\b', 'Ariana'),
    (r'\bAriam\b', 'Aria1'),
    (r'\bAriana\b', 'Ariana'),
    (r'\bAriana\b', 'Arianus'),
    (r'\bArianae\b', 'Ariana'),
    (r'\bAriane\b', 'Arianus'),
    (r'\bAriani\b', 'arianis'),
    (r'\bAriani\b', 'Arianus'),
    (r'\barianide\b', 'arianis'),
    (r'\bArianis\b', 'Ariana'),
    (r'\barianis\b', 'arianis'),
    (r'\bArianis\b', 'arianis'),
    (r'\bArianis\b', 'Arianus'),
    (r'\bArianos\b', 'arianis'),
    (r'\bAriarathe\b', 'Aricia'),
    (r'\bAriarathen\b', 'Aricia'),
    (r'\bAriarathes\b', 'Aricia'),
    (r'\bAriarathi\b', 'Aricia'),
    (r'\bAriarathis\b', 'Aricia'),
    (r'\bAricia\b', 'Aricia'),
    (r'\bAriciae\b', 'Aricia'),
    (r'\bAriciam\b', 'Aricia'),
    (r'\bAricina\b', 'Aricinus'),
    (r'\bAricinae\b', 'Aricinus'),
    (r'\bAricinam\b', 'Aricinus'),
    (r'\bAricini\b', 'Aricinus'),
    (r'\bAricini\b', 'Aricinus'),
    (r'\bAricinique\b', 'Aricinus'),
    (r'\bAricinique\b', 'Aricinus'),
    (r'\bAricinis\b', 'Aricinus'),
    (r'\bAricinis\b', 'Aricinus'),
    (r'\bAricino\b', 'Aricinus'),
    (r'\bAricinorum\b', 'Aricinus'),
    (r'\bAricinorum\b', 'Aricinus'),
    (r'\bAricinos\b', 'Aricinus'),
    (r'\bAricinum\b', 'Aricinus'),
    (r'\bAricinum\b', 'Aricinus'),
    (r'\bAricinus\b', 'Aricinus'),
    (r'\barida\b', 'aridus'),
    (r'\barida\b', 'aridus'),
    (r'\baridae\b', 'aridus'),
    (r'\baridai\b', 'aridus'),
    (r'\baridam\b', 'aridus'),
    (r'\baridaque\b', 'aridus'),
    (r'\baridaque\b', 'aridus'),
    (r'\baridas\b', 'aridus'),
    (r'\baridasque\b', 'aridus'),
    (r'\baride\b', 'aridus'),
    (r'\baride\b', 'aris1'),
    (r'\baride\b', 'aridus'),
    (r'\baridi\b', 'aris1'),
    (r'\baridi\b', 'aridus'),
    (r'\baridi\b', 'aridus'),
    (r'\baridior\b', 'aridus'),
    (r'\baridiora\b', 'aridus'),
    (r'\baridiore\b', 'aridus'),
    (r'\baridiores\b', 'aridus'),
    (r'\baridique\b', 'aris1'),
    (r'\baridique\b', 'aridus'),
    (r'\baridique\b', 'aridus'),
    (r'\baridis\b', 'aridus'),
    (r'\baridis\b', 'aris1'),
    (r'\baridis\b', 'aridus'),
    (r'\baridisque\b', 'aridus'),
    (r'\baridisque\b', 'aris1'),
    (r'\baridisque\b', 'aridus'),
    (r'\baridissimis\b', 'aridus'),
    (r'\baridissimum\b', 'aridus'),
    (r'\bariditate\b', 'ariditas'),
    (r'\bariditatem\b', 'ariditas'),
    (r'\barido\b', 'aridus'),
    (r'\barido\b', 'aridus'),
    (r'\baridorum\b', 'aridus'),
    (r'\baridorum\b', 'aridus'),
    (r'\baridos\b', 'aridus'),
    (r'\baridulis\b', 'aridulus'),
    (r'\baridulo\b', 'aridulus'),
    (r'\baridum\b', 'aris1'),
    (r'\baridum\b', 'aridus'),
    (r'\baridum\b', 'aridus'),
    (r'\baridumque\b', 'aris1'),
    (r'\baridumque\b', 'aridus'),
    (r'\baridumque\b', 'aridus'),
    (r'\baridumst\b', 'aris1'),
    (r'\baridumst\b', 'aridus'),
    (r'\baridumst\b', 'aridus'),
    (r'\baridumue\b', 'aris1'),
    (r'\baridumue\b', 'aridus'),
    (r'\baridumue\b', 'aridus'),
    (r'\baridumve\b', 'aris1'),
    (r'\baridumve\b', 'aridus'),
    (r'\baridumve\b', 'aridus'),
    (r'\baridus\b', 'aridus'),
    (r'\barien\b', 'aries'),
    (r'\baries\b', 'aries'),
    (r'\bariesque\b', 'aries'),
    (r'\bariesve\b', 'aries'),
    (r'\barietant\b', 'arieto'),
    (r'\barietare\b', 'arieto'),
    (r'\barietarent\b', 'arieto'),
    (r'\barietari\b', 'arietarius'),
    (r'\barietari\b', 'arieto'),
    (r'\barietaria\b', 'arietarius'),
    (r'\barietariae\b', 'arietarius'),
    (r'\barietariam\b', 'arietarius'),
    (r'\barietat\b', 'arieto'),
    (r'\barietata\b', 'arieto'),
    (r'\barietatio\b', 'arietatio'),
    (r'\barietatorum\b', 'arieto'),
    (r'\barietaueris\b', 'arieto'),
    (r'\barietavit\b', 'arieto'),
    (r'\bariete\b', 'aries'),
    (r'\barietem\b', 'aries'),
    (r'\barietem\b', 'arieto'),
    (r'\barietemque\b', 'aries'),
    (r'\barietemque\b', 'arieto'),
    (r'\barietes\b', 'aries'),
    (r'\barietes\b', 'arieto'),
    (r'\barietesque\b', 'aries'),
    (r'\barietesque\b', 'arieto'),
    (r'\barietet\b', 'arieto'),
    (r'\barieti\b', 'aries'),
    (r'\barietibus\b', 'aries'),
    (r'\barietina\b', 'arietinus'),
    (r'\barietinae\b', 'arietinus'),
    (r'\barietini\b', 'arietinus'),
    (r'\barietinis\b', 'arietinus'),
    (r'\barietino\b', 'arietinus'),
    (r'\barietinorum\b', 'arietinus'),
    (r'\barietinos\b', 'arietinus'),
    (r'\barietinum\b', 'arietinus'),
    (r'\barietis\b', 'aries'),
    (r'\barietum\b', 'aries'),
    (r'\bariga\b', 'a-rigo'),
    (r'\bArii\b', 'Arius1'),
    (r'\bArii\b', 'a-rigo'),
    (r'\barillatorem\b', 'arilator'),
    (r'\bArim\b', 'Aris2'),
    (r'\bArimaspi\b', 'Arimaspi'),
    (r'\bArimaspis\b', 'Arimaspi'),
    (r'\bArimaspos\b', 'Arimaspi'),
    (r'\bAriminensem\b', 'Ariminum'),
    (r'\bAriminenses\b', 'Ariminum'),
    (r'\bAriminenses\b', 'Ariminum'),
    (r'\bAriminensi\b', 'Ariminum'),
    (r'\bAriminensium\b', 'Ariminum'),
    (r'\bAriminensium\b', 'Ariminum'),
    (r'\bArimini\b', 'Ariminum'),
    (r'\bArimino\b', 'Ariminum'),
    (r'\bAriminum\b', 'Ariminum'),
    (r'\barinca\b', 'arinca'),
    (r'\barincam\b', 'arinca'),
    (r'\barine\b', 'aros'),
    (r'\barine\b', 'aron'),
    (r'\bArine\b', 'Ariobarzanes'),
    (r'\bArinem\b', 'Ariobarzanes'),
    (r'\barinen\b', 'aros'),
    (r'\bArinen\b', 'Ariobarzanes'),
    (r'\barinen\b', 'aron'),
    (r'\bArinis\b', 'Ariobarzanes'),
    (r'\bArio\b', 'Arius1'),
    (r'\bAriobarzane\b', 'Ariobarzanes'),
    (r'\bAriobarzanem\b', 'Ariobarzanes'),
    (r'\bAriobarzanen\b', 'Ariobarzanes'),
    (r'\bAriobarzanes\b', 'Ariobarzanes'),
    (r'\bAriobarzani\b', 'Ariobarzanes'),
    (r'\bAriobarzanis\b', 'Ariobarzanes'),
    (r'\bariolabar\b', 'hariolor'),
    (r'\bariolandi\b', 'hariolor'),
    (r'\bariolari\b', 'hariolor'),
    (r'\bariolatus\b', 'hariolor'),
    (r'\barioli\b', 'hariolus'),
    (r'\bariolis\b', 'hariola'),
    (r'\bariolis\b', 'hariolus'),
    (r'\bariolo\b', 'hariolus'),
    (r'\bariolorum\b', 'hariolus'),
    (r'\bariolos\b', 'hariolus'),
    (r'\bariolum\b', 'hariolus'),
    (r'\bArion\b', 'Arion'),
    (r'\bArione\b', 'Arion'),
    (r'\bArionem\b', 'Arion'),
    (r'\bArioniae\b', 'Ariovistus'),
    (r'\bArioniam\b', 'Ariovistus'),
    (r'\bArionis\b', 'Arion'),
    (r'\bArionium\b', 'Ariovistus'),
    (r'\bAriopagi\b', 'Ariovistus'),
    (r'\bAriopagita\b', 'Ariovistus'),
    (r'\bAriopagitae\b', 'Ariovistus'),
    (r'\bAriopagitas\b', 'Ariovistus'),
    (r'\bAriopagitis\b', 'Ariovistus'),
    (r'\bAriopagitis\b', 'Ariovistus'),
    (r'\bAriopago\b', 'Ariovistus'),
    (r'\bAriopagum\b', 'Ariovistus'),
    (r'\bAriorum\b', 'a-rigo'),
    (r'\bArios\b', 'a-rigo'),
    (r'\bAriosque\b', 'a-rigo'),
    (r'\bAriovisti\b', 'Ariovistus'),
    (r'\bAriovisto\b', 'Ariovistus'),
    (r'\bAriovistum\b', 'Ariovistus'),
    (r'\bAriovistus\b', 'Ariovistus'),
    (r'\barique\b', 'aros'),
    (r'\barique\b', 'aron'),
    (r'\baris\b', 'ara'),
    (r'\baris\b', 'aris1'),
    (r'\bAris\b', 'Aris2'),
    (r'\bAris\b', 'a-repleo'),
    (r'\baris\b', 'aron'),
    (r'\barisae\b', 'ariditas'),
    (r'\barisai\b', 'ariditas'),
    (r'\bArisba\b', 'Arisba'),
    (r'\bArisbam\b', 'Arisba'),
    (r'\bArisbas\b', 'Arisba'),
    (r'\bArisbe\b', 'Arisba'),
    (r'\barisque\b', 'ara'),
    (r'\barisque\b', 'aris1'),
    (r'\barisque\b', 'aron'),
    (r'\barist\b', 'ara'),
    (r'\barist\b', 'aris1'),
    (r'\barist\b', 'aros'),
    (r'\bArist\b', 'Aris2'),
    (r'\bArist\b', 'a-repleo'),
    (r'\bArist\b', 'Arius1'),
    (r'\barist\b', 'aron'),
    (r'\barista\b', 'arista'),
    (r'\baristae\b', 'arista'),
    (r'\bAristaee\b', 'Aristaeus'),
    (r'\bAristaei\b', 'Aristaeus'),
    (r'\bAristaeo\b', 'Aristaeus'),
    (r'\bAristaeum\b', 'Aristaeus'),
    (r'\bAristaeus\b', 'Aristaeus'),
    (r'\baristam\b', 'arista'),
    (r'\bAristarchei\b', 'Aristarchus'),
    (r'\bAristarchi\b', 'Aristarchus'),
    (r'\bAristarcho\b', 'Aristarchus'),
    (r'\bAristarchum\b', 'Aristarchus'),
    (r'\bAristarchus\b', 'Aristarchus'),
    (r'\baristarum\b', 'arista'),
    (r'\baristas\b', 'arista'),
    (r'\bAristeus\b', 'Aristides'),
    (r'\bAristi\b', 'Aristius'),
    (r'\bAristide\b', 'Aristides'),
    (r'\bAristidem\b', 'Aristides'),
    (r'\bAristiden\b', 'Aristides'),
    (r'\bAristides\b', 'Aristides'),
    (r'\bAristidi\b', 'Aristides'),
    (r'\bAristidis\b', 'Aristides'),
    (r'\bAristippeo\b', 'Aristippus'),
    (r'\bAristippeum\b', 'Aristippus'),
    (r'\bAristippi\b', 'Aristippus'),
    (r'\bAristippo\b', 'Aristippus'),
    (r'\bAristippum\b', 'Aristippus'),
    (r'\bAristippus\b', 'Aristippus'),
    (r'\baristis\b', 'arista'),
    (r'\bAristium\b', 'Aristius'),
    (r'\bAristius\b', 'Aristius'),
    (r'\bAristo\b', 'Aristo'),
    (r'\bAristocrito\b', 'aristolochia'),
    (r'\bAristocritum\b', 'aristolochia'),
    (r'\bAristocritus\b', 'aristolochia'),
    (r'\bAristodamo\b', 'aristolochia'),
    (r'\bAristodemi\b', 'aristolochia'),
    (r'\bAristodemo\b', 'aristolochia'),
    (r'\bAristodemum\b', 'aristolochia'),
    (r'\bAristodemus\b', 'aristolochia'),
    (r'\baristolochia\b', 'aristolochia'),
    (r'\baristolochiae\b', 'aristolochia'),
    (r'\baristolochiam\b', 'aristolochia'),
    (r'\baristolochiamque\b', 'aristolochia'),
    (r'\bAriston\b', 'Aristo'),
    (r'\bAristone\b', 'Aristo'),
    (r'\bAristonea\b', 'Aristoneus'),
    (r'\bAristonem\b', 'Aristo'),
    (r'\bAristoni\b', 'Aristo'),
    (r'\bAristonici\b', 'Aristonicus'),
    (r'\bAristonico\b', 'Aristonicus'),
    (r'\bAristonicum\b', 'Aristonicus'),
    (r'\bAristonicus\b', 'Aristonicus'),
    (r'\bAristonis\b', 'Aristo'),
    (r'\bAristophane\b', 'Aristophanes'),
    (r'\bAristophanem\b', 'Aristophanes'),
    (r'\bAristophanen\b', 'Aristophanes'),
    (r'\bAristophaneo\b', 'Aristophaneus'),
    (r'\bAristophaneque\b', 'Aristophanes'),
    (r'\bAristophanes\b', 'Aristophanes'),
    (r'\bAristophanesque\b', 'Aristophanes'),
    (r'\bAristophaneus\b', 'Aristophaneus'),
    (r'\bAristophani\b', 'Aristophanes'),
    (r'\bAristophanis\b', 'Aristophanes'),
    (r'\bAristotele\b', 'Aristoteles'),
    (r'\bAristotelea\b', 'Aristoxenus'),
    (r'\bAristotelem\b', 'Aristoteles'),
    (r'\bAristotelen\b', 'Aristoteles'),
    (r'\bAristoteleque\b', 'Aristoteles'),
    (r'\bAristoteles\b', 'Aristoteles'),
    (r'\bAristotelesque\b', 'Aristoteles'),
    (r'\bAristoteli\b', 'Aristoteles'),
    (r'\bAristoteli\b', 'Aristoxenus'),
    (r'\bAristotelia\b', 'Aristoxenus'),
    (r'\bAristoteliam\b', 'Aristoxenus'),
    (r'\bAristotelio\b', 'Aristoxenus'),
    (r'\bAristotelios\b', 'Aristoxenus'),
    (r'\bAristotelis\b', 'Aristoteles'),
    (r'\bAristotelisque\b', 'Aristoteles'),
    (r'\bAristoxeni\b', 'Aristoxenus'),
    (r'\bAristoxeno\b', 'Aristoxenus'),
    (r'\bAristoxenum\b', 'Aristoxenus'),
    (r'\bAristoxenus\b', 'Aristoxenus'),
    (r'\barithmetica\b', 'arithmetica'),
    (r'\barithmeticae\b', 'arithmetica'),
    (r'\barithmeticen\b', 'arithmetica'),
    (r'\barithmeticis\b', 'arithmetica'),
    (r'\barithmeticis\b', 'arithmeticus'),
    (r'\baritudine\b', 'aritudo'),
    (r'\baritudinem\b', 'aritudo'),
    (r'\baritudinis\b', 'aritudo'),
    (r'\bArium\b', 'Arius1'),
    (r'\bArium\b', 'a-rigo'),
    (r'\bArius\b', 'Arius1'),
    (r'\bAriusia\b', 'Ariusius'),
    (r'\bAriusio\b', 'Ariusius'),
    (r'\bAriusium\b', 'Ariusius'),
    (r'\barma\b', 'arma'),
    (r'\barma\b', 'armo'),
    (r'\barmabantur\b', 'armo'),
    (r'\barmabat\b', 'armo'),
    (r'\barmabimus\b', 'armo'),
    (r'\barmabis\b', 'armo'),
    (r'\barmabit\b', 'armo'),
    (r'\barmabitis\b', 'armo'),
    (r'\barmabitur\b', 'armo'),
    (r'\barmabuntur\b', 'armo'),
    (r'\barmamaxas\b', 'armamaxa'),
    (r'\barmamenta\b', 'armamenta'),
    (r'\barmamentaque\b', 'armamenta'),
    (r'\barmamentaria\b', 'armamentarium'),
    (r'\barmamentariisque\b', 'armamentarium'),
    (r'\barmamentario\b', 'armamentarium'),
    (r'\barmamentarium\b', 'armamentarium'),
    (r'\barmamentis\b', 'armamenta'),
    (r'\barmamentisque\b', 'armamenta'),
    (r'\barmamentisue\b', 'armamenta'),
    (r'\barmamentorum\b', 'armamenta'),
    (r'\barmamentum\b', 'armamenta'),
    (r'\barmamini\b', 'armo'),
    (r'\barmanda\b', 'armo'),
    (r'\barmandae\b', 'armo'),
    (r'\barmandam\b', 'armo'),
    (r'\barmandas\b', 'armo'),
    (r'\barmandi\b', 'armo'),
    (r'\barmandique\b', 'armo'),
    (r'\barmandis\b', 'armo'),
    (r'\barmando\b', 'armo'),
    (r'\barmandos\b', 'armo'),
    (r'\barmandosque\b', 'armo'),
    (r'\barmane\b', 'arma'),
    (r'\barmane\b', 'armo'),
    (r'\barmant\b', 'armo'),
    (r'\barmante\b', 'armo'),
    (r'\barmantem\b', 'armo'),
    (r'\barmantibus\b', 'armo'),
    (r'\barmantque\b', 'armo'),
    (r'\barmantur\b', 'armo'),
    (r'\barmaque\b', 'arma'),
    (r'\barmaque\b', 'armo'),
    (r'\barmarant\b', 'armo'),
    (r'\barmarat\b', 'armo'),
    (r'\barmare\b', 'armo'),
    (r'\barmaremus\b', 'armo'),
    (r'\barmarent\b', 'armo'),
    (r'\barmarentque\b', 'armo'),
    (r'\barmarentur\b', 'armo'),
    (r'\barmaret\b', 'armo'),
    (r'\barmaretque\b', 'armo'),
    (r'\barmari\b', 'armarium'),
    (r'\barmari\b', 'armo'),
    (r'\barmaria\b', 'armarium'),
    (r'\barmariis\b', 'armarium'),
    (r'\barmariisque\b', 'armarium'),
    (r'\barmario\b', 'armarium'),
    (r'\barmariola\b', 'armariolum'),
    (r'\barmarique\b', 'armarium'),
    (r'\barmarique\b', 'armo'),
    (r'\barmarit\b', 'armo'),
    (r'\barmarium\b', 'armarium'),
    (r'\barmariumue\b', 'armarium'),
    (r'\barmarunt\b', 'armo'),
    (r'\barmasse\b', 'armo'),
    (r'\barmasset\b', 'armo'),
    (r'\barmastis\b', 'armo'),
    (r'\barmat\b', 'armo'),
    (r'\barmata\b', 'armo'),
    (r'\barmatae\b', 'armo'),
    (r'\barmataeque\b', 'armo'),
    (r'\barmatam\b', 'armo'),
    (r'\barmatamque\b', 'armo'),
    (r'\barmataque\b', 'armo'),
    (r'\barmatas\b', 'armo'),
    (r'\barmatasque\b', 'armo'),
    (r'\barmate\b', 'armatus'),
    (r'\barmate\b', 'armo'),
    (r'\barmati\b', 'armatus'),
    (r'\barmati\b', 'armo'),
    (r'\barmatique\b', 'armatus'),
    (r'\barmatique\b', 'armo'),
    (r'\barmatis\b', 'armatus'),
    (r'\barmatis\b', 'armo'),
    (r'\barmatisque\b', 'armatus'),
    (r'\barmatisque\b', 'armo'),
    (r'\barmatissimi\b', 'armo'),
    (r'\barmatissimis\b', 'armo'),
    (r'\barmatisve\b', 'armatus'),
    (r'\barmatisve\b', 'armo'),
    (r'\barmato\b', 'armo'),
    (r'\barmato\b', 'armatus'),
    (r'\barmatoque\b', 'armo'),
    (r'\barmatoque\b', 'armatus'),
    (r'\barmatorum\b', 'armatus'),
    (r'\barmatorum\b', 'armo'),
    (r'\barmatos\b', 'armatus'),
    (r'\barmatos\b', 'armo'),
    (r'\barmatosque\b', 'armatus'),
    (r'\barmatosque\b', 'armo'),
    (r'\barmatu\b', 'armatus2'),
    (r'\barmatu\b', 'armo'),
    (r'\barmatum\b', 'armatus'),
    (r'\barmatum\b', 'armo'),
    (r'\barmatumque\b', 'armatus'),
    (r'\barmatumque\b', 'armo'),
    (r'\barmatur\b', 'armo'),
    (r'\barmatura\b', 'armatura'),
    (r'\barmatura\b', 'armo'),
    (r'\barmaturae\b', 'armatura'),
    (r'\barmaturae\b', 'armo'),
    (r'\barmaturam\b', 'armatura'),
    (r'\barmaturam\b', 'armo'),
    (r'\barmaturas\b', 'armatura'),
    (r'\barmaturas\b', 'armo'),
    (r'\barmatus\b', 'armatus2'),
    (r'\barmatus\b', 'armatus'),
    (r'\barmatus\b', 'armo'),
    (r'\barmatusque\b', 'armatus2'),
    (r'\barmatusque\b', 'armatus'),
    (r'\barmatusque\b', 'armo'),
    (r'\barmauerant\b', 'armo'),
    (r'\barmauerat\b', 'armo'),
    (r'\barmaueratque\b', 'armo'),
    (r'\barmauere\b', 'armo'),
    (r'\barmauerit\b', 'armo'),
    (r'\barmauerunt\b', 'armo'),
    (r'\barmaui\b', 'armo'),
    (r'\barmauit\b', 'armo'),
    (r'\barmauitque\b', 'armo'),
    (r'\barmaverant\b', 'armo'),
    (r'\barmaverat\b', 'armo'),
    (r'\barmaverit\b', 'armo'),
    (r'\barmaverunt\b', 'armo'),
    (r'\barmavi\b', 'armo'),
    (r'\barmavimus\b', 'armo'),
    (r'\barmavisset\b', 'armo'),
    (r'\barmavit\b', 'armo'),
    (r'\barmemus\b', 'armo'),
    (r'\barmene\b', 'armus'),
    (r'\bArmeni\b', 'armenta'),
    (r'\bArmeni\b', 'armenta'),
    (r'\bArmenia\b', 'Armenia'),
    (r'\bArmenia\b', 'armenta'),
    (r'\bArmeniaca\b', 'armenta'),
    (r'\bArmeniacae\b', 'armenta'),
    (r'\bArmeniaci\b', 'armenta'),
    (r'\bArmeniacum\b', 'armenta'),
    (r'\bArmeniae\b', 'Armenia'),
    (r'\bArmeniaeque\b', 'Armenia'),
    (r'\bArmeniam\b', 'Armenia'),
    (r'\bArmeniaque\b', 'Armenia'),
    (r'\bArmeniaque\b', 'armenta'),
    (r'\bArmenias\b', 'Armenia'),
    (r'\bArmeniasque\b', 'Armenia'),
    (r'\bArmenii\b', 'armenta'),
    (r'\bArmenii\b', 'armenta'),
    (r'\bArmeniique\b', 'armenta'),
    (r'\bArmeniique\b', 'armenta'),
    (r'\bArmeniis\b', 'Armenia'),
    (r'\bArmeniis\b', 'armenta'),
    (r'\bArmeniis\b', 'armenta'),
    (r'\bArmeniisque\b', 'Armenia'),
    (r'\bArmeniisque\b', 'armenta'),
    (r'\bArmeniisque\b', 'armenta'),
    (r'\bArmenio\b', 'armenta'),
    (r'\bArmenio\b', 'armenta'),
    (r'\bArmeniorum\b', 'armenta'),
    (r'\bArmeniorum\b', 'armenta'),
    (r'\bArmenios\b', 'armenta'),
    (r'\bArmeniosne\b', 'armenta'),
    (r'\bArmeniosque\b', 'armenta'),
    (r'\bArmenium\b', 'armenta'),
    (r'\bArmenium\b', 'armenta'),
    (r'\bArmeniumque\b', 'armenta'),
    (r'\bArmeniumque\b', 'armenta'),
    (r'\bArmenius\b', 'armenta'),
    (r'\bArmeniusque\b', 'armenta'),
    (r'\barment\b', 'armo'),
    (r'\barmenta\b', 'armenta'),
    (r'\barmenta\b', 'armentum'),
    (r'\barmentale\b', 'armentalis'),
    (r'\barmentalia\b', 'armentalis'),
    (r'\barmentalis\b', 'armentalis'),
    (r'\barmentaque\b', 'armenta'),
    (r'\barmentaque\b', 'armentum'),
    (r'\barmentari\b', 'armentarius'),
    (r'\barmentarii\b', 'armentarius'),
    (r'\barmentariis\b', 'armentarius'),
    (r'\barmentario\b', 'armentarius'),
    (r'\barmentarium\b', 'armentarius'),
    (r'\barmentarius\b', 'armentarius'),
    (r'\barmentas\b', 'armenta'),
    (r'\barmenti\b', 'armentum'),
    (r'\barmenticios\b', 'armenticius'),
    (r'\barmenticium\b', 'armenticius'),
    (r'\barmentique\b', 'armentum'),
    (r'\barmentis\b', 'armenta'),
    (r'\barmentis\b', 'armentum'),
    (r'\barmentiue\b', 'armentivus'),
    (r'\barmentiue\b', 'armentum'),
    (r'\barmentivis\b', 'armentivus'),
    (r'\barmento\b', 'armentum'),
    (r'\barmentoque\b', 'armentum'),
    (r'\barmentorum\b', 'armentum'),
    (r'\barmentorumque\b', 'armentum'),
    (r'\barmentosissima\b', 'armentosus'),
    (r'\barmentum\b', 'armentum'),
    (r'\barmentumve\b', 'armentum'),
    (r'\barmentur\b', 'armo'),
    (r'\barmes\b', 'armo'),
    (r'\barmet\b', 'armo'),
    (r'\barmetis\b', 'armo'),
    (r'\barmetque\b', 'armo'),
    (r'\barmetur\b', 'armo'),
    (r'\barmi\b', 'armus'),
    (r'\barmifer\b', 'armifer'),
    (r'\barmiferae\b', 'armifer'),
    (r'\barmiferam\b', 'armifer'),
    (r'\barmiferas\b', 'armifer'),
    (r'\barmiferi\b', 'armifer'),
    (r'\barmiferis\b', 'armifer'),
    (r'\barmifero\b', 'armifer'),
    (r'\barmiferos\b', 'armifer'),
    (r'\barmiferum\b', 'armifer'),
    (r'\barmiger\b', 'armiger'),
    (r'\barmigera\b', 'armiger'),
    (r'\barmigerae\b', 'armiger'),
    (r'\barmigeram\b', 'armiger'),
    (r'\barmigeras\b', 'armiger'),
    (r'\barmigeri\b', 'armiger'),
    (r'\barmigeris\b', 'armiger'),
    (r'\barmigero\b', 'armiger'),
    (r'\barmigerorumque\b', 'armiger'),
    (r'\barmigeros\b', 'armiger'),
    (r'\barmigerum\b', 'armiger'),
    (r'\barmigerumque\b', 'armiger'),
    (r'\barmilla\b', 'armilla'),
    (r'\barmilla\b', 'armillum'),
    (r'\barmillae\b', 'armilla'),
    (r'\barmillaeque\b', 'armilla'),
    (r'\barmillam\b', 'armilla'),
    (r'\barmillas\b', 'armilla'),
    (r'\barmillata\b', 'armillatus'),
    (r'\barmillato\b', 'armillatus'),
    (r'\barmillatos\b', 'armillatus'),
    (r'\barmillatus\b', 'armillatus'),
    (r'\barmillis\b', 'armilla'),
    (r'\barmillis\b', 'armillum'),
    (r'\barmillisque\b', 'armilla'),
    (r'\barmillisque\b', 'armillum'),
    (r'\barmillum\b', 'armillum'),
    (r'\bArmilustrium\b', 'Armilustrium'),
    (r'\bArmilustro\b', 'Armilustrum'),
    (r'\barmine\b', 'armus'),
    (r'\bArmini\b', 'Arminius'),
    (r'\bArminii\b', 'Arminius'),
    (r'\bArminio\b', 'Arminius'),
    (r'\bArminium\b', 'Arminius'),
    (r'\bArminius\b', 'Arminius'),
    (r'\barmis\b', 'armus'),
    (r'\barmis\b', 'arma'),
    (r'\barmisona\b', 'armisonus'),
    (r'\barmisonae\b', 'armisonus'),
    (r'\barmisque\b', 'armus'),
    (r'\barmisque\b', 'arma'),
    (r'\barmo\b', 'armus'),
    (r'\barmo\b', 'armo'),
    (r'\barmon\b', 'armus'),
    (r'\barmon\b', 'armo'),
    (r'\barmoracia\b', 'armoracia'),
    (r'\barmoraciam\b', 'armoracia'),
    (r'\barmorum\b', 'armus'),
    (r'\barmorum\b', 'arma'),
    (r'\barmorumque\b', 'armus'),
    (r'\barmorumque\b', 'arma'),
    (r'\barmorumue\b', 'armus'),
    (r'\barmorumue\b', 'arma'),
    (r'\barmorumve\b', 'armus'),
    (r'\barmorumve\b', 'arma'),
    (r'\barmos\b', 'armus'),
    (r'\barmosque\b', 'armus'),
    (r'\barmum\b', 'armus'),
    (r'\barmum\b', 'arma'),
    (r'\barmumque\b', 'armus'),
    (r'\barmumque\b', 'arma'),
    (r'\barmus\b', 'armus'),
    (r'\barn\b', 'ars'),
    (r'\bArna\b', 'Arna1'),
    (r'\bArnam\b', 'Arna1'),
    (r'\bArnas\b', 'Arna1'),
    (r'\bArnates\b', 'Arnates'),
    (r'\bArne\b', 'Arne1'),
    (r'\bArne\b', 'Arnus'),
    (r'\bArni\b', 'Arnus'),
    (r'\bArniensem\b', 'Arniensis'),
    (r'\bArniensis\b', 'Arniensis'),
    (r'\bArno\b', 'Arnus'),
    (r'\bArnon\b', 'Arnus'),
    (r'\bArnum\b', 'Arnus'),
    (r'\bArnus\b', 'Arnus'),
    (r'\baro\b', 'aros'),
    (r'\baro\b', 'aron'),
    (r'\baro\b', 'aro'),
    (r'\barodi\b', 'aroma'),
    (r'\barogas\b', 'aroma'),
    (r'\baroma\b', 'aroma'),
    (r'\baromata\b', 'aroma'),
    (r'\baromataque\b', 'aroma'),
    (r'\baromatibus\b', 'aroma'),
    (r'\baromatica\b', 'aromaticus'),
    (r'\baromatis\b', 'aroma'),
    (r'\baromatite\b', 'aromatites'),
    (r'\baromatiten\b', 'aromatites'),
    (r'\baromatitis\b', 'aromatites'),
    (r'\baromatizans\b', 'aromatizo'),
    (r'\baromatum\b', 'aroma'),
    (r'\baron\b', 'aros'),
    (r'\baron\b', 'aron'),
    (r'\baron\b', 'aro'),
    (r'\baros\b', 'aros'),
    (r'\bArpani\b', 'Arpi'),
    (r'\bArpani\b', 'Arpi'),
    (r'\bArpano\b', 'Arpi'),
    (r'\bArpi\b', 'Arpi'),
    (r'\bArpinas\b', 'Arpinus'),
    (r'\bArpinas\b', 'Arpinum'),
    (r'\bArpinate\b', 'Arpinum'),
    (r'\bArpinatem\b', 'Arpinum'),
    (r'\bArpinates\b', 'Arpinum'),
    (r'\bArpinates\b', 'Arpinum'),
    (r'\bArpinati\b', 'Arpinum'),
    (r'\bArpinatibus\b', 'Arpinum'),
    (r'\bArpinatibus\b', 'Arpinum'),
    (r'\bArpinatis\b', 'Arpinum'),
    (r'\bArpinatis\b', 'Arpinum'),
    (r'\bArpinatium\b', 'Arpinum'),
    (r'\bArpinatium\b', 'Arpinum'),
    (r'\bArpini\b', 'Arpinus'),
    (r'\bArpini\b', 'Arpinum'),
    (r'\bArpini\b', 'Arpinum'),
    (r'\bArpinique\b', 'Arpinus'),
    (r'\bArpinique\b', 'Arpinum'),
    (r'\bArpinique\b', 'Arpinum'),
    (r'\bArpinis\b', 'Arpinus'),
    (r'\bArpinis\b', 'Arpinum'),
    (r'\bArpinis\b', 'Arpinum'),
    (r'\bArpinius\b', 'Arpinus'),
    (r'\bArpinorum\b', 'Arpinum'),
    (r'\bArpinorum\b', 'Arpinum'),
    (r'\bArpinum\b', 'Arpinus'),
    (r'\bArpinum\b', 'Arpinum'),
    (r'\bArpinum\b', 'Arpinum'),
    (r'\bArpinumne\b', 'Arpinus'),
    (r'\bArpinumne\b', 'Arpinum'),
    (r'\bArpinumne\b', 'Arpinum'),
    (r'\bArpinus\b', 'Arpinus'),
    (r'\bArpis\b', 'Arpi'),
    (r'\bArpos\b', 'Arpi'),
    (r'\barquati\b', 'arquatus'),
    (r'\barquatis\b', 'arquatus'),
    (r'\barquato\b', 'arquatus'),
    (r'\barquatorum\b', 'arquatus'),
    (r'\barquatos\b', 'arquatus'),
    (r'\barquatum\b', 'arquatus'),
    (r'\barquitenens\b', 'Arcitenens'),
    (r'\bArquitenens\b', 'Arquitenens'),
    (r'\barquitenentem\b', 'Arcitenens'),
    (r'\barquitenentis\b', 'Arcitenens'),
    (r'\bArquitenentis\b', 'Arquitenens'),
    (r'\barrabo\b', 'arrhabo'),
    (r'\barrabone\b', 'arrhabo'),
    (r'\barrabonem\b', 'arrhabo'),
    (r'\barraboni\b', 'arrhabo'),
    (r'\barrecta\b', 'arrideo'),
    (r'\barrectae\b', 'arrideo'),
    (r'\barrectaeque\b', 'arrideo'),
    (r'\barrectaria\b', 'arrectarius'),
    (r'\barrectariis\b', 'arrectarius'),
    (r'\barrectariorum\b', 'arrectarius'),
    (r'\barrectas\b', 'arrideo'),
    (r'\barrectasque\b', 'arrideo'),
    (r'\barrecti\b', 'arrideo'),
    (r'\barrectiora\b', 'arrideo'),
    (r'\barrectis\b', 'arrideo'),
    (r'\barrectisque\b', 'arrideo'),
    (r'\barrecto\b', 'arrideo'),
    (r'\barrectos\b', 'arrideo'),
    (r'\barrectum\b', 'arrideo'),
    (r'\barrectus\b', 'arrideo'),
    (r'\barrenici\b', 'arrenicum'),
    (r'\barrepta\b', 'arrepo'),
    (r'\barreptam\b', 'arrepo'),
    (r'\barreptamque\b', 'arrepo'),
    (r'\barreptaque\b', 'arrepo'),
    (r'\barreptas\b', 'arrepo'),
    (r'\barrepticium\b', 'arrepticius'),
    (r'\barreptis\b', 'arrepo'),
    (r'\barreptisque\b', 'arrepo'),
    (r'\barrepto\b', 'arrepo'),
    (r'\barreptoque\b', 'arrepo'),
    (r'\barreptos\b', 'arrepo'),
    (r'\barreptum\b', 'arrepo'),
    (r'\barrepturos\b', 'arrepo'),
    (r'\barrepturum\b', 'arrepo'),
    (r'\barreptus\b', 'arrepo'),
    (r'\bArreti\b', 'Arretium'),
    (r'\bArretii\b', 'Arretium'),
    (r'\bArretina\b', 'Aretinus'),
    (r'\bArretinae\b', 'Aretinus'),
    (r'\bArretinaque\b', 'Aretinus'),
    (r'\bArretini\b', 'Aretinus'),
    (r'\bArretinis\b', 'Aretinus'),
    (r'\bArretino\b', 'Aretinus'),
    (r'\bArretinorum\b', 'Aretinus'),
    (r'\bArretinos\b', 'Aretinus'),
    (r'\bArretinum\b', 'Aretinus'),
    (r'\bArretio\b', 'Arretium'),
    (r'\bArretium\b', 'Arretium'),
    (r'\bArretiumque\b', 'Arretium'),
    (r'\barrexere\b', 'arrideo'),
    (r'\barrexit\b', 'arrideo'),
    (r'\bArri\b', 'Arius2'),
    (r'\bArria\b', 'Arria'),
    (r'\bArriae\b', 'Arria'),
    (r'\bArriam\b', 'Arria'),
    (r'\bArriamque\b', 'Arria'),
    (r'\barrideant\b', 'arrideo'),
    (r'\barrideat\b', 'arrideo'),
    (r'\barridebant\b', 'arrideo'),
    (r'\barridens\b', 'arrideo'),
    (r'\barridere\b', 'arrideo'),
    (r'\barriderent\b', 'arrideo'),
    (r'\barridet\b', 'arrideo'),
    (r'\bArrii\b', 'Arius2'),
    (r'\bArrio\b', 'Arius2'),
    (r'\barripe\b', 'arripio'),
    (r'\barripere\b', 'arripio'),
    (r'\barriperem\b', 'arripio'),
    (r'\barriperent\b', 'arripio'),
    (r'\barriperet\b', 'arripio'),
    (r'\barripi\b', 'arripio'),
    (r'\barripiam\b', 'arripio'),
    (r'\barripiamus\b', 'arripio'),
    (r'\barripiant\b', 'arripio'),
    (r'\barripias\b', 'arripio'),
    (r'\barripiat\b', 'arripio'),
    (r'\barripiebat\b', 'arripio'),
    (r'\barripiendi\b', 'arripio'),
    (r'\barripiens\b', 'arripio'),
    (r'\barripiensque\b', 'arripio'),
    (r'\barripient\b', 'arripio'),
    (r'\barripiente\b', 'arripio'),
    (r'\barripientes\b', 'arripio'),
    (r'\barripientium\b', 'arripio'),
    (r'\barripiet\b', 'arripio'),
    (r'\barripimus\b', 'arripio'),
    (r'\barripio\b', 'arripio'),
    (r'\barripit\b', 'arripio'),
    (r'\barripite\b', 'arripio'),
    (r'\barripitur\b', 'arripio'),
    (r'\barripiunt\b', 'arripio'),
    (r'\barripuerant\b', 'arripio'),
    (r'\barripuerat\b', 'arripio'),
    (r'\barripuerimus\b', 'arripio'),
    (r'\barripuerit\b', 'arripio'),
    (r'\barripuerunt\b', 'arripio'),
    (r'\barripui\b', 'arripio'),
    (r'\barripuimus\b', 'arripio'),
    (r'\barripuisse\b', 'arripio'),
    (r'\barripuissent\b', 'arripio'),
    (r'\barripuisset\b', 'arripio'),
    (r'\barripuit\b', 'arripio'),
    (r'\barripuitque\b', 'arripio'),
    (r'\barrisere\b', 'arrideo'),
    (r'\barriserit\b', 'arrideo'),
    (r'\barrisisset\b', 'arrideo'),
    (r'\barrisit\b', 'arrideo'),
    (r'\barrisum\b', 'arrideo'),
    (r'\bArrium\b', 'Arius2'),
    (r'\bArrius\b', 'Arius2'),
    (r'\barrodet\b', 'arrodo'),
    (r'\barrogans\b', 'arrogo'),
    (r'\barrogante\b', 'arrogo'),
    (r'\barrogantem\b', 'arrogo'),
    (r'\barroganter\b', 'arroganter'),
    (r'\barrogantes\b', 'arrogo'),
    (r'\barrogantia\b', 'arrogantia'),
    (r'\barrogantia\b', 'arrogo'),
    (r'\barrogantiae\b', 'arrogantia'),
    (r'\barrogantiam\b', 'arrogantia'),
    (r'\barrogantiamque\b', 'arrogantia'),
    (r'\barrogantis\b', 'arrogo'),
    (r'\barrogantissimae\b', 'arrogo'),
    (r'\barrogantius\b', 'arrogo'),
    (r'\barrogare\b', 'arrogo'),
    (r'\barrogat\b', 'arrogo'),
    (r'\barrogatio\b', 'arrogatio'),
    (r'\barroget\b', 'arrogo'),
    (r'\barrogo\b', 'arrogo'),
    (r'\barrosit\b', 'arrodo'),
    (r'\bArrotrebae\b', 'Arrotrebae'),
    (r'\bArrotrebarum\b', 'Arrotrebae'),
    (r'\bArrotrebas\b', 'Arrotrebae'),
    (r'\barrugia\b', 'arrugia'),
    (r'\barrugias\b', 'arrugia'),
    (r'\bArrunti\b', 'Arruntius'),
    (r'\bArruntii\b', 'Arruntius'),
    (r'\bArruntio\b', 'Arruntius'),
    (r'\bArruntios\b', 'Arruntius'),
    (r'\bArruntium\b', 'Arruntius'),
    (r'\bArruntius\b', 'Arruntius'),
    (r'\bars\b', 'ars'),
    (r'\barsa\b', 'arsus'),
    (r'\barsa\b', 'ardeo'),
    (r'\bArsace\b', 'Arsaces'),
    (r'\bArsacen\b', 'Arsaces'),
    (r'\bArsaces\b', 'Arsaces'),
    (r'\bArsaci\b', 'Arsaces'),
    (r'\bArsaci\b', 'Arsacius'),
    (r'\bArsacia\b', 'Arsacius'),
    (r'\bArsacidae\b', 'Arsacius'),
    (r'\bArsacidarum\b', 'Arsacius'),
    (r'\bArsacidas\b', 'Arsacius'),
    (r'\bArsacidis\b', 'Arsacius'),
    (r'\bArsacis\b', 'Arsaces'),
    (r'\barsam\b', 'arsus'),
    (r'\barsam\b', 'ardeo'),
    (r'\bArsamosata\b', 'Armosata'),
    (r'\barse\b', 'arsus'),
    (r'\barse\b', 'arsis'),
    (r'\barse\b', 'ardeo'),
    (r'\barsen\b', 'arsus'),
    (r'\barsen\b', 'arsis'),
    (r'\barsen\b', 'ardeo'),
    (r'\barserant\b', 'ardeo'),
    (r'\barserat\b', 'ardeo'),
    (r'\barsere\b', 'ardeo'),
    (r'\barserit\b', 'ardeo'),
    (r'\barserunt\b', 'ardeo'),
    (r'\barses\b', 'arsis'),
    (r'\barsi\b', 'arsis'),
    (r'\barsi\b', 'arsus'),
    (r'\barsi\b', 'ardeo'),
    (r'\bArsia\b', 'Arsia'),
    (r'\bArsiae\b', 'Arsia'),
    (r'\bArsiam\b', 'Arsia'),
    (r'\barsin\b', 'arsis'),
    (r'\barsin\b', 'arsus'),
    (r'\barsin\b', 'ardeo'),
    (r'\barsinea\b', 'arsineum'),
    (r'\bArsinoae\b', 'Arsinoa'),
    (r'\bArsinoeo\b', 'arsis'),
    (r'\barsis\b', 'arsis'),
    (r'\barsis\b', 'arsus'),
    (r'\barsis\b', 'ardeo'),
    (r'\barsisse\b', 'ardeo'),
    (r'\barsissent\b', 'ardeo'),
    (r'\barsisses\b', 'ardeo'),
    (r'\barsisset\b', 'ardeo'),
    (r'\barsissetque\b', 'ardeo'),
    (r'\barsisti\b', 'ardeo'),
    (r'\barsit\b', 'ardeo'),
    (r'\barsque\b', 'ars'),
    (r'\barsura\b', 'ardeo'),
    (r'\barsuram\b', 'ardeo'),
    (r'\barsuraque\b', 'ardeo'),
    (r'\barsuras\b', 'ardeo'),
    (r'\barsurasque\b', 'ardeo'),
    (r'\barsuris\b', 'ardeo'),
    (r'\barsuro\b', 'ardeo'),
    (r'\barsuros\b', 'ardeo'),
    (r'\barsurosque\b', 'ardeo'),
    (r'\barsurum\b', 'ardeo'),
    (r'\barsurus\b', 'ardeo'),
    (r'\barsurusque\b', 'ardeo'),
    (r'\barta\b', 'artus1'),
    (r'\barta\b', 'artus1'),
    (r'\barta\b', 'arto'),
    (r'\bartaba\b', 'artaba'),
    (r'\bartabae\b', 'artaba'),
    (r'\bartabane\b', 'artaba'),
    (r'\bArtabane\b', 'Artabanus'),
    (r'\bArtabani\b', 'Artabanus'),
    (r'\bArtabano\b', 'Artabanus'),
    (r'\bArtabanum\b', 'Artabanus'),
    (r'\bArtabanus\b', 'Artabanus'),
    (r'\bartabat\b', 'arto'),
    (r'\bartabitur\b', 'arto'),
    (r'\bartabuntur\b', 'arto'),
    (r'\bArtacie\b', 'Artacie'),
    (r'\bArtaciis\b', 'Artacie'),
    (r'\bartae\b', 'artus1'),
    (r'\bartaeque\b', 'artus1'),
    (r'\bartam\b', 'artus1'),
    (r'\bartandam\b', 'arto'),
    (r'\bartandi\b', 'arto'),
    (r'\bartandus\b', 'arto'),
    (r'\bartantibus\b', 'arto'),
    (r'\bartantur\b', 'arto'),
    (r'\bartaque\b', 'artus1'),
    (r'\bartaque\b', 'artus1'),
    (r'\bartaque\b', 'arto'),
    (r'\bartare\b', 'arto'),
    (r'\bartaret\b', 'arto'),
    (r'\bartari\b', 'arto'),
    (r'\bartas\b', 'artus1'),
    (r'\bartas\b', 'arto'),
    (r'\bartasse\b', 'arto'),
    (r'\bartat\b', 'arto'),
    (r'\bartata\b', 'arto'),
    (r'\bartatae\b', 'arto'),
    (r'\bartatas\b', 'arto'),
    (r'\bartati\b', 'arto'),
    (r'\bartatis\b', 'arto'),
    (r'\bartato\b', 'arto'),
    (r'\bartatque\b', 'arto'),
    (r'\bartatum\b', 'arto'),
    (r'\bartatur\b', 'arto'),
    (r'\bartatus\b', 'arto'),
    (r'\bArtauasden\b', 'Artaxata'),
    (r'\bArtauasdi\b', 'Artaxata'),
    (r'\bartauerit\b', 'arto'),
    (r'\bartauit\b', 'arto'),
    (r'\bArtavasden\b', 'Artaxata'),
    (r'\bArtavasdes\b', 'Artaxata'),
    (r'\bArtavasdi\b', 'Artaxata'),
    (r'\bArtavasdis\b', 'Artaxata'),
    (r'\bArtavasdis\b', 'Artaxata'),
    (r'\bartaverat\b', 'arto'),
    (r'\bartavique\b', 'arto'),
    (r'\bartavit\b', 'arto'),
    (r'\bartavitque\b', 'arto'),
    (r'\bArtaxata\b', 'Artaxata'),
    (r'\bArtaxatis\b', 'Artaxata'),
    (r'\bArtaxerxe\b', 'Artaxerxes'),
    (r'\bArtaxerxem\b', 'Artaxerxes'),
    (r'\bArtaxerxen\b', 'Artaxerxes'),
    (r'\bArtaxerxes\b', 'Artaxerxes'),
    (r'\bArtaxerxi\b', 'Artaxerxes'),
    (r'\bArtaxerxis\b', 'Artaxerxes'),
    (r'\barte\b', 'artus1'),
    (r'\barte\b', 'ars'),
    (r'\barte\b', 'artus1'),
    (r'\bartem\b', 'ars'),
    (r'\bartem\b', 'arto'),
    (r'\bArtemidore\b', 'Artemidorus'),
    (r'\bArtemidori\b', 'Artemidorus'),
    (r'\bArtemidoro\b', 'Artemidorus'),
    (r'\bArtemidorum\b', 'Artemidorus'),
    (r'\bArtemidorus\b', 'Artemidorus'),
    (r'\bArtemisia\b', 'artemisia'),
    (r'\bartemisia\b', 'artemisia'),
    (r'\bArtemisia\b', 'Artemisium'),
    (r'\bArtemisiae\b', 'artemisia'),
    (r'\bartemisiae\b', 'artemisia'),
    (r'\bArtemisiam\b', 'artemisia'),
    (r'\bartemisiam\b', 'artemisia'),
    (r'\bArtemisio\b', 'Artemisium'),
    (r'\bArtemisium\b', 'Artemisium'),
    (r'\bArtemitam\b', 'Artemita'),
    (r'\bArtemiten\b', 'artemon'),
    (r'\bArtemo\b', 'artemon'),
    (r'\bartemon\b', 'artemon'),
    (r'\bArtemon\b', 'artemon'),
    (r'\bArtemone\b', 'artemon'),
    (r'\bartemone\b', 'artemon'),
    (r'\bArtemonem\b', 'artemon'),
    (r'\bartemonem\b', 'artemon'),
    (r'\bArtemoni\b', 'artemon'),
    (r'\bartemoni\b', 'artemon'),
    (r'\bArtemonis\b', 'artemon'),
    (r'\bartemonis\b', 'artemon'),
    (r'\bartemque\b', 'ars'),
    (r'\bartemque\b', 'arto'),
    (r'\bartentur\b', 'arto'),
    (r'\barteque\b', 'artus1'),
    (r'\barteque\b', 'ars'),
    (r'\barteque\b', 'artus1'),
    (r'\barteria\b', 'arteria'),
    (r'\barteriace\b', 'arteriacus'),
    (r'\barteriace\b', 'arteriace'),
    (r'\barteriae\b', 'arteria'),
    (r'\barteriaeque\b', 'arteria'),
    (r'\barteriam\b', 'arteria'),
    (r'\barteriarum\b', 'arteria'),
    (r'\barterias\b', 'arteria'),
    (r'\barteriasue\b', 'arteria'),
    (r'\barteriis\b', 'arteria'),
    (r'\bartes\b', 'ars'),
    (r'\bartes\b', 'arto'),
    (r'\bartesque\b', 'ars'),
    (r'\bartesque\b', 'arto'),
    (r'\bartet\b', 'arto'),
    (r'\bartetur\b', 'arto'),
    (r'\barthriticum\b', 'arthriticus'),
    (r'\barthriticus\b', 'arthriticus'),
    (r'\barti\b', 'ars'),
    (r'\barti\b', 'artus1'),
    (r'\barti\b', 'artius'),
    (r'\barti\b', 'artus1'),
    (r'\barti\b', 'artio1'),
    (r'\bartibus\b', 'ars'),
    (r'\bartibus\b', 'artus2'),
    (r'\bartibusque\b', 'ars'),
    (r'\bartibusque\b', 'artus2'),
    (r'\barticulamenta\b', 'articulamentum'),
    (r'\barticulamentorum\b', 'articulamentum'),
    (r'\barticulamentum\b', 'articulamentum'),
    (r'\barticulant\b', 'articulo'),
    (r'\barticularem\b', 'articulo'),
    (r'\barticularem\b', 'articularis'),
    (r'\barticulari\b', 'articularis'),
    (r'\barticulari\b', 'articularius'),
    (r'\barticulari\b', 'articulo'),
    (r'\barticularia\b', 'articularius'),
    (r'\barticularia\b', 'articularis'),
    (r'\barticulariis\b', 'articularius'),
    (r'\barticulariisque\b', 'articularius'),
    (r'\barticulario\b', 'articularius'),
    (r'\barticularios\b', 'articularius'),
    (r'\barticularium\b', 'articularis'),
    (r'\barticularium\b', 'articularius'),
    (r'\barticulat\b', 'articulo'),
    (r'\barticulata\b', 'articulatus'),
    (r'\barticulata\b', 'articulo'),
    (r'\barticulatae\b', 'articulatus'),
    (r'\barticulatae\b', 'articulo'),
    (r'\barticulate\b', 'articulatus'),
    (r'\barticulate\b', 'articulo'),
    (r'\barticulatim\b', 'articulatim'),
    (r'\barticulatio\b', 'articulatio'),
    (r'\barticuli\b', 'articulus'),
    (r'\barticulique\b', 'articulus'),
    (r'\barticulis\b', 'articulus'),
    (r'\barticulisque\b', 'articulus'),
    (r'\barticulo\b', 'articulus'),
    (r'\barticulo\b', 'articulo'),
    (r'\barticulorum\b', 'articulus'),
    (r'\barticulorumque\b', 'articulus'),
    (r'\barticulos\b', 'articulus'),
    (r'\barticulosa\b', 'articulosus'),
    (r'\barticulosaque\b', 'articulosus'),
    (r'\barticulosque\b', 'articulus'),
    (r'\barticulum\b', 'articulus'),
    (r'\barticulus\b', 'articulus'),
    (r'\bartifex\b', 'artifex'),
    (r'\bartifice\b', 'artifex'),
    (r'\bartificem\b', 'artifex'),
    (r'\bartificemque\b', 'artifex'),
    (r'\bartifices\b', 'artifex'),
    (r'\bartificesque\b', 'artifex'),
    (r'\bartifici\b', 'artifex'),
    (r'\bartifici\b', 'artificium'),
    (r'\bartificia\b', 'artificium'),
    (r'\bartificiale\b', 'artificialis'),
    (r'\bartificiales\b', 'artificialis'),
    (r'\bartificiali\b', 'artificialis'),
    (r'\bartificialis\b', 'artificialis'),
    (r'\bartificialiter\b', 'artificialis'),
    (r'\bartificialiter\b', 'artificialiter'),
    (r'\bartificialium\b', 'artificialis'),
    (r'\bartificialium\b', 'artificialis'),
    (r'\bartificibus\b', 'artifex'),
    (r'\bartificii\b', 'artificium'),
    (r'\bartificiis\b', 'artificium'),
    (r'\bartificio\b', 'artificium'),
    (r'\bartificioque\b', 'artificium'),
    (r'\bartificiorum\b', 'artificium'),
    (r'\bartificiosa\b', 'artificiosus'),
    (r'\bartificiosae\b', 'artificiosus'),
    (r'\bartificiosam\b', 'artificiosus'),
    (r'\bartificiose\b', 'artificiosus'),
    (r'\bartificiosi\b', 'artificiosus'),
    (r'\bartificiosis\b', 'artificiosus'),
    (r'\bartificiosissime\b', 'artificiosus'),
    (r'\bartificiosissimi\b', 'artificiosus'),
    (r'\bartificiosius\b', 'artificiosus'),
    (r'\bartificioso\b', 'artificiosus'),
    (r'\bartificiosum\b', 'artificiosus'),
    (r'\bartificiosumque\b', 'artificiosus'),
    (r'\bartificiosus\b', 'artificiosus'),
    (r'\bartificique\b', 'artifex'),
    (r'\bartificique\b', 'artificium'),
    (r'\bartificis\b', 'artifex'),
    (r'\bartificium\b', 'artificium'),
    (r'\bartificum\b', 'artifex'),
    (r'\bartificumque\b', 'artifex'),
    (r'\bartior\b', 'artus1'),
    (r'\bartior\b', 'artio1'),
    (r'\bartiora\b', 'artus1'),
    (r'\bartiore\b', 'artus1'),
    (r'\bartiorem\b', 'artus1'),
    (r'\bartioremque\b', 'artus1'),
    (r'\bartiores\b', 'artus1'),
    (r'\bartioribus\b', 'artus1'),
    (r'\bartioris\b', 'artus1'),
    (r'\bartiorque\b', 'artus1'),
    (r'\bartiorque\b', 'artio1'),
    (r'\bartis\b', 'artus1'),
    (r'\bartis\b', 'ars'),
    (r'\bartis\b', 'artus1'),
    (r'\bartis\b', 'artio1'),
    (r'\bartisque\b', 'artus1'),
    (r'\bartisque\b', 'ars'),
    (r'\bartisque\b', 'artus1'),
    (r'\bartisque\b', 'artio1'),
    (r'\bartissima\b', 'artus1'),
    (r'\bartissimam\b', 'artus1'),
    (r'\bartissimas\b', 'artus1'),
    (r'\bartissime\b', 'artus1'),
    (r'\bartissimi\b', 'artus1'),
    (r'\bartissimis\b', 'artus1'),
    (r'\bartissimo\b', 'artus1'),
    (r'\bartissimos\b', 'artus1'),
    (r'\bartissimum\b', 'artus1'),
    (r'\bartissume\b', 'artus1'),
    (r'\bartito\b', 'artio1'),
    (r'\bartitoque\b', 'artio1'),
    (r'\bartiueris\b', 'artio1'),
    (r'\bartiuit\b', 'artio1'),
    (r'\bartium\b', 'ars'),
    (r'\bartium\b', 'artius'),
    (r'\bartiumque\b', 'ars'),
    (r'\bartiumque\b', 'artius'),
    (r'\bartius\b', 'artus1'),
    (r'\bartius\b', 'artius'),
    (r'\barto\b', 'artus1'),
    (r'\barto\b', 'artus1'),
    (r'\barto\b', 'arto'),
    (r'\bartolagani\b', 'artolaganus'),
    (r'\bartoptae\b', 'artopta'),
    (r'\bartoptam\b', 'artopta'),
    (r'\bartoptas\b', 'artopta'),
    (r'\bartopticii\b', 'artopticius'),
    (r'\bartopticio\b', 'artopticius'),
    (r'\bartor\b', 'arto'),
    (r'\bartos\b', 'artus1'),
    (r'\bartosque\b', 'artus1'),
    (r'\bArtotrogus\b', 'Artotrogus'),
    (r'\bartu\b', 'artus2'),
    (r'\bartubus\b', 'artus2'),
    (r'\bartum\b', 'ars'),
    (r'\bartum\b', 'artus1'),
    (r'\bartum\b', 'artus1'),
    (r'\bartus\b', 'artus2'),
    (r'\bartus\b', 'artus1'),
    (r'\bartusque\b', 'artus2'),
    (r'\bartusque\b', 'artus1'),
    (r'\bartuum\b', 'artus2'),
    (r'\barua\b', 'arvalis'),
    (r'\barua\b', 'arvum'),
    (r'\baruaque\b', 'arvalis'),
    (r'\baruaque\b', 'arvum'),
    (r'\baruas\b', 'arvalis'),
    (r'\barue\b', 'arvus'),
    (r'\barue\b', 'arvum'),
    (r'\baruerat\b', 'a-ruo'),
    (r'\baruerint\b', 'a-ruo'),
    (r'\baruerit\b', 'a-ruo'),
    (r'\baruerunt\b', 'a-ruo'),
    (r'\barui\b', 'arvus'),
    (r'\barui\b', 'arvum'),
    (r'\baruina\b', 'arvina'),
    (r'\baruis\b', 'arvalis'),
    (r'\baruis\b', 'arvus'),
    (r'\baruis\b', 'arvum'),
    (r'\baruisque\b', 'arvalis'),
    (r'\baruisque\b', 'arvus'),
    (r'\baruisque\b', 'arvum'),
    (r'\baruit\b', 'a-ruo'),
    (r'\barula\b', 'arula'),
    (r'\barulae\b', 'arula'),
    (r'\barulaeque\b', 'arula'),
    (r'\barulam\b', 'arula'),
    (r'\barulas\b', 'arula'),
    (r'\barum\b', 'aros'),
    (r'\bArum\b', 'a-repleo'),
    (r'\barum\b', 'aron'),
    (r'\barunci\b', 'aruncus'),
    (r'\baruncum\b', 'aruncus'),
    (r'\barundine\b', 'harundo'),
    (r'\barundinea\b', 'harundineus'),
    (r'\barundinem\b', 'harundo'),
    (r'\barundines\b', 'harundo'),
    (r'\barundineto\b', 'harundinetum'),
    (r'\barundinis\b', 'harundo'),
    (r'\barundinum\b', 'harundo'),
    (r'\baruo\b', 'arvus'),
    (r'\baruo\b', 'arvum'),
    (r'\baruorum\b', 'arvus'),
    (r'\baruorum\b', 'arvum'),
    (r'\bArupinis\b', 'a-ruo'),
    (r'\baruspex\b', 'haruspex'),
    (r'\baruspice\b', 'haruspex'),
    (r'\baruspicem\b', 'haruspex'),
    (r'\baruspices\b', 'haruspex'),
    (r'\baruspicesque\b', 'haruspex'),
    (r'\baruspicibus\b', 'haruspex'),
    (r'\baruspicinae\b', 'haruspicinus'),
    (r'\baruspicinam\b', 'haruspicinus'),
    (r'\baruspicis\b', 'haruspica'),
    (r'\baruspicis\b', 'haruspex'),
    (r'\baruspicum\b', 'haruspex'),
    (r'\baruum\b', 'arvus'),
    (r'\baruum\b', 'arvum'),
    (r'\barva\b', 'arvalis'),
    (r'\barva\b', 'arvum'),
    (r'\barvale\b', 'arvalis'),
    (r'\barvales\b', 'arvalis'),
    (r'\barvalis\b', 'arvalis'),
    (r'\barvaque\b', 'arvalis'),
    (r'\barvaque\b', 'arvum'),
    (r'\barvas\b', 'arvalis'),
    (r'\bArverni\b', 'Arverni'),
    (r'\bArverni\b', 'Arvernus'),
    (r'\bArvernis\b', 'Arverni'),
    (r'\bArvernis\b', 'Arvernus'),
    (r'\bArvernisque\b', 'Arverni'),
    (r'\bArvernisque\b', 'Arvernus'),
    (r'\bArverno\b', 'Arvernus'),
    (r'\bArvernorum\b', 'Arverni'),
    (r'\bArvernorum\b', 'Arvernus'),
    (r'\bArvernorumque\b', 'Arverni'),
    (r'\bArvernorumque\b', 'Arvernus'),
    (r'\bArvernos\b', 'Arverni'),
    (r'\bArvernosque\b', 'Arverni'),
    (r'\bArvernum\b', 'Arverni'),
    (r'\bArvernum\b', 'Arvernus'),
    (r'\bArvernus\b', 'Arvernus'),
    (r'\barvi\b', 'arvus'),
    (r'\barvi\b', 'arvum'),
    (r'\barvina\b', 'arvina'),
    (r'\barvinam\b', 'arvina'),
    (r'\barvis\b', 'arvalis'),
    (r'\barvis\b', 'arvus'),
    (r'\barvis\b', 'arvum'),
    (r'\barvisque\b', 'arvalis'),
    (r'\barvisque\b', 'arvus'),
    (r'\barvisque\b', 'arvum'),
    (r'\barvo\b', 'arvus'),
    (r'\barvo\b', 'arvum'),
    (r'\barvom\b', 'arvus'),
    (r'\barvom\b', 'arvum'),
    (r'\barvorum\b', 'arvus'),
    (r'\barvorum\b', 'arvum'),
    (r'\barvos\b', 'arvus'),
    (r'\barvum\b', 'arvus'),
    (r'\barvum\b', 'arvum'),
    (r'\barvus\b', 'arvus'),
    (r'\barx\b', 'arx'),
    (r'\bAsa\b', 'a-sum1'),
    (r'\basamian\b', 'asarotum'),
    (r'\bAsan\b', 'a-sum1'),
    (r'\basana\b', 'asarotum'),
    (r'\basara\b', 'asarum'),
    (r'\basari\b', 'asarum'),
    (r'\basaro\b', 'asarum'),
    (r'\basaron\b', 'asarum'),
    (r'\basarota\b', 'asarotum'),
    (r'\basaroton\b', 'asarotum'),
    (r'\basarum\b', 'asarum'),
    (r'\basatorum\b', 'asia'),
    (r'\basbesto\b', 'asbestos'),
    (r'\basbestos\b', 'asbestos'),
    (r'\basbestum\b', 'asbestos'),
    (r'\bAsbolos\b', 'Asbolus'),
    (r'\bAsbolus\b', 'Asbolus'),
    (r'\bascalaboten\b', 'ascalabotes'),
    (r'\bAscalapho\b', 'Ascalaphus'),
    (r'\bAscalaphum\b', 'Ascalaphus'),
    (r'\bAscalaphus\b', 'Ascalaphus'),
    (r'\bAscalaphusque\b', 'Ascalaphus'),
    (r'\bascalia\b', 'ascalia'),
    (r'\bAscalo\b', 'Ascalo'),
    (r'\bAscalon\b', 'Ascalo'),
    (r'\bAscalone\b', 'Ascalo'),
    (r'\bAscalonem\b', 'Ascalo'),
    (r'\bAscaloni\b', 'Ascalo'),
    (r'\bAscaloni\b', 'ascalpo'),
    (r'\bAscalonia\b', 'ascalpo'),
    (r'\bAscaloniae\b', 'ascalpo'),
    (r'\bAscaloniam\b', 'ascalpo'),
    (r'\bAscaloniarum\b', 'ascalpo'),
    (r'\bAscalonii\b', 'ascalpo'),
    (r'\bAscalonis\b', 'Ascalo'),
    (r'\bascalpens\b', 'ascalpo'),
    (r'\bAscani\b', 'Ascanius2'),
    (r'\bAscani\b', 'Ascanius1'),
    (r'\bAscania\b', 'Ascania'),
    (r'\bAscania\b', 'Ascanius1'),
    (r'\bAscaniae\b', 'Ascania'),
    (r'\bAscanii\b', 'Ascanius1'),
    (r'\bAscanio\b', 'Ascanius1'),
    (r'\bAscanione\b', 'Ascanius1'),
    (r'\bAscanium\b', 'Ascanius1'),
    (r'\bAscaniumque\b', 'Ascanius1'),
    (r'\bAscanius\b', 'Ascanius1'),
    (r'\bAscaniusque\b', 'Ascanius1'),
    (r'\bascaules\b', 'ascaules'),
    (r'\bascendam\b', 'ascendo'),
    (r'\bascendamus\b', 'ascendo'),
    (r'\bascendant\b', 'ascendo'),
    (r'\bascendas\b', 'ascendo'),
    (r'\bascendat\b', 'ascendo'),
    (r'\bascendatis\b', 'ascendo'),
    (r'\bascendatur\b', 'ascendo'),
    (r'\bascende\b', 'ascendo'),
    (r'\bascendebamus\b', 'ascendo'),
    (r'\bascendebant\b', 'ascendo'),
    (r'\bascendebantque\b', 'ascendo'),
    (r'\bascendebantur\b', 'ascendo'),
    (r'\bascendebat\b', 'ascendo'),
    (r'\bascendebatur\b', 'ascendo'),
    (r'\bascendemus\b', 'ascendo'),
    (r'\bascendendi\b', 'ascendo'),
    (r'\bascendendo\b', 'ascendo'),
    (r'\bascendendum\b', 'ascendo'),
    (r'\bascendendus\b', 'ascendo'),
    (r'\bascendens\b', 'ascendo'),
    (r'\bascendensque\b', 'ascendo'),
    (r'\bascendent\b', 'ascendo'),
    (r'\bascendente\b', 'ascendo'),
    (r'\bascendentem\b', 'ascendo'),
    (r'\bascendentes\b', 'ascendo'),
    (r'\bascendentesque\b', 'ascendo'),
    (r'\bascendenti\b', 'ascendo'),
    (r'\bascendentibus\b', 'ascendo'),
    (r'\bascendentis\b', 'ascendo'),
    (r'\bascendentium\b', 'ascendo'),
    (r'\bascendere\b', 'ascendo'),
    (r'\bascenderem\b', 'ascendo'),
    (r'\bascenderent\b', 'ascendo'),
    (r'\bascenderes\b', 'ascendo'),
    (r'\bascenderet\b', 'ascendo'),
    (r'\bascenderetur\b', 'ascendo'),
    (r'\bascenderis\b', 'ascendo'),
    (r'\bascendes\b', 'ascendo'),
    (r'\bascendesque\b', 'ascendo'),
    (r'\bascendet\b', 'ascendo'),
    (r'\bascendetis\b', 'ascendo'),
    (r'\bascendi\b', 'ascendo'),
    (r'\bascendibilem\b', 'ascendibilis'),
    (r'\bascendimus\b', 'ascendo'),
    (r'\bascendit\b', 'ascendo'),
    (r'\bascendite\b', 'ascendo'),
    (r'\bascenditis\b', 'ascendo'),
    (r'\bascenditque\b', 'ascendo'),
    (r'\bascenditur\b', 'ascendo'),
    (r'\bascendo\b', 'ascendo'),
    (r'\bascendunt\b', 'ascendo'),
    (r'\bascenduntque\b', 'ascendo'),
    (r'\bascensio\b', 'ascensio'),
    (r'\bascensione\b', 'ascensio'),
    (r'\bascensionem\b', 'ascensio'),
    (r'\bascensiones\b', 'ascensio'),
    (r'\bascensionis\b', 'ascensio'),
    (r'\bascensor\b', 'ascensor'),
    (r'\bascensorem\b', 'ascensor'),
    (r'\bascensores\b', 'ascensor'),
    (r'\bascensu\b', 'ascensus2'),
    (r'\bascensum\b', 'ascensus2'),
    (r'\bascensus\b', 'ascensus2'),
    (r'\bascensusque\b', 'ascensus2'),
    (r'\bascia\b', 'ascia'),
    (r'\bascia\b', 'ascius'),
    (r'\bascia\b', 'ascio1'),
    (r'\basciam\b', 'ascia'),
    (r'\basciam\b', 'ascio2'),
    (r'\bascias\b', 'ascia'),
    (r'\bascias\b', 'ascio1'),
    (r'\bascias\b', 'ascio2'),
    (r'\bAsciburgii\b', 'Asciburgium'),
    (r'\bAsciburgiumque\b', 'Asciburgium'),
    (r'\bascietur\b', 'ascio2'),
    (r'\bascietur\b', 'ascio1'),
    (r'\bascire\b', 'ascio2'),
    (r'\basciscendum\b', 'ascisco'),
    (r'\basciscere\b', 'ascisco'),
    (r'\basciscerent\b', 'ascisco'),
    (r'\bascita\b', 'ascites'),
    (r'\bascita\b', 'ascio2'),
    (r'\bascitae\b', 'ascites'),
    (r'\bascitae\b', 'ascio2'),
    (r'\bascitam\b', 'ascites'),
    (r'\bascitam\b', 'ascio2'),
    (r'\bascitis\b', 'ascites'),
    (r'\bascitis\b', 'ascio2'),
    (r'\bascito\b', 'ascio2'),
    (r'\bascitos\b', 'ascio2'),
    (r'\bascitum\b', 'ascitus2'),
    (r'\bascitum\b', 'ascio2'),
    (r'\bascitus\b', 'ascitus2'),
    (r'\bascitus\b', 'ascio2'),
    (r'\basciuerant\b', 'ascio2'),
    (r'\basciuerit\b', 'ascio2'),
    (r'\basciuit\b', 'ascio2'),
    (r'\basciverant\b', 'ascio2'),
    (r'\basciveris\b', 'ascio2'),
    (r'\basciverit\b', 'ascio2'),
    (r'\bascivit\b', 'ascio2'),
    (r'\bAscla\b', 'Asculum'),
    (r'\bAsclapo\b', 'Asclepiades'),
    (r'\bAsclapone\b', 'Asclepiades'),
    (r'\basclepiade\b', 'asclepias'),
    (r'\bAsclepiade\b', 'Asclepiades'),
    (r'\basclepiadem\b', 'asclepias'),
    (r'\basclepiaden\b', 'asclepias'),
    (r'\bAsclepiaden\b', 'Asclepiades'),
    (r'\bAsclepiadeon\b', 'Asclepiadeus'),
    (r'\basclepiades\b', 'asclepias'),
    (r'\bAsclepiades\b', 'Asclepiades'),
    (r'\basclepiadi\b', 'asclepias'),
    (r'\bAsclepiadi\b', 'Asclepiades'),
    (r'\basclepiadis\b', 'asclepias'),
    (r'\bAsclepiadis\b', 'Asclepiades'),
    (r'\basclepias\b', 'asclepias'),
    (r'\basclepii\b', 'asclepion'),
    (r'\basclepio\b', 'asclepion'),
    (r'\bAsclepiodoti\b', 'Asclepiodotus'),
    (r'\bAsclepiodoto\b', 'Asclepiodotus'),
    (r'\bAsclepiodotum\b', 'Asclepiodotus'),
    (r'\bAsclepiodotus\b', 'Asclepiodotus'),
    (r'\basclepion\b', 'asclepion'),
    (r'\basclepium\b', 'asclepion'),
    (r'\bAscletarionis\b', 'Ascletario'),
    (r'\bAscli\b', 'Asculum'),
    (r'\bAsconio\b', 'Asconius'),
    (r'\bAsconius\b', 'Asconius'),
    (r'\bascopa\b', 'a-scopo2'),
    (r'\bascopam\b', 'a-scopo2'),
    (r'\bAscra\b', 'a-scopo2'),
    (r'\bascra\b', 'ascribo'),
    (r'\bAscraeas\b', 'ascribo'),
    (r'\bAscraei\b', 'ascribo'),
    (r'\bAscraeo\b', 'ascribo'),
    (r'\bAscraeos\b', 'ascribo'),
    (r'\bAscraeum\b', 'ascribo'),
    (r'\bAscraeumque\b', 'ascribo'),
    (r'\bAscraeus\b', 'ascribo'),
    (r'\bascribamus\b', 'ascribo'),
    (r'\bascribat\b', 'ascribo'),
    (r'\bascribatque\b', 'ascribo'),
    (r'\bascribe\b', 'ascribo'),
    (r'\bascribebantur\b', 'ascribo'),
    (r'\bascribemus\b', 'ascribo'),
    (r'\bascribendus\b', 'ascribo'),
    (r'\bascribere\b', 'ascribo'),
    (r'\bascriberet\b', 'ascribo'),
    (r'\bascriberetis\b', 'ascribo'),
    (r'\bascriberetur\b', 'ascribo'),
    (r'\bascribi\b', 'ascribo'),
    (r'\bascribit\b', 'ascribo'),
    (r'\bascribitur\b', 'ascribo'),
    (r'\bascribo\b', 'ascribo'),
    (r'\bascribunt\b', 'ascribo'),
    (r'\bascripserant\b', 'ascribo'),
    (r'\bascripseras\b', 'ascribo'),
    (r'\bascripserit\b', 'ascribo'),
    (r'\bascripserunt\b', 'ascribo'),
    (r'\bascripsi\b', 'ascribo'),
    (r'\bascripsimus\b', 'ascribo'),
    (r'\bascripsisse\b', 'ascribo'),
    (r'\bascripsisset\b', 'ascribo'),
    (r'\bascripsisti\b', 'ascribo'),
    (r'\bascripsit\b', 'ascribo'),
    (r'\bascripti\b', 'ascribo'),
    (r'\bascriptio\b', 'ascriptio'),
    (r'\bascriptis\b', 'ascribo'),
    (r'\bascriptiuis\b', 'ascriptivus'),
    (r'\bascriptivi\b', 'ascriptivus'),
    (r'\bascriptivis\b', 'ascriptivus'),
    (r'\bascriptores\b', 'ascriptor'),
    (r'\bascriptos\b', 'ascribo'),
    (r'\bascriptum\b', 'ascribo'),
    (r'\bascripturum\b', 'ascribo'),
    (r'\bascriptus\b', 'ascribo'),
    (r'\bAsculani\b', 'Asculum'),
    (r'\bAsculani\b', 'Asculum'),
    (r'\bAsculanis\b', 'Asculum'),
    (r'\bAsculanis\b', 'Asculum'),
    (r'\bAsculano\b', 'Asculum'),
    (r'\bAsculanorum\b', 'Asculum'),
    (r'\bAsculanorum\b', 'Asculum'),
    (r'\bAsculanos\b', 'Asculum'),
    (r'\bAsculanus\b', 'Asculum'),
    (r'\bAsculi\b', 'Asculum'),
    (r'\bAsculo\b', 'Asculum'),
    (r'\bAsculum\b', 'Asculum'),
    (r'\bascyroides\b', 'ascyroides'),
    (r'\bascyron\b', 'ascyron'),
    (r'\basella\b', 'asella'),
    (r'\basellae\b', 'asella'),
    (r'\basellas\b', 'asella'),
    (r'\baselle\b', 'asellus'),
    (r'\baselli\b', 'asellus'),
    (r'\bAsellio\b', 'Asellius'),
    (r'\bAsellio\b', 'Asellio'),
    (r'\bAsellione\b', 'Asellio'),
    (r'\bAsellionem\b', 'Asellio'),
    (r'\bAsellionis\b', 'Asellio'),
    (r'\basellis\b', 'asella'),
    (r'\basellis\b', 'asellus'),
    (r'\bAsellium\b', 'Asellius'),
    (r'\bAsellius\b', 'Asellius'),
    (r'\basello\b', 'asellus'),
    (r'\basellorum\b', 'asellus'),
    (r'\basellos\b', 'asellus'),
    (r'\basellum\b', 'asellus'),
    (r'\basellus\b', 'asellus'),
    (r'\basemas\b', 'asemus'),
    (r'\basemon\b', 'asemus'),
    (r'\baserim\b', 'asia'),
    (r'\bAsi\b', 'Asius'),
    (r'\bAsi\b', 'a-sum1'),
    (r'\bAsia\b', 'asia'),
    (r'\basia\b', 'asia'),
    (r'\bAsia\b', 'Asius'),
    (r'\bAsiae\b', 'asia'),
    (r'\basiae\b', 'asia'),
    (r'\bAsiaene\b', 'asia'),
    (r'\basiaene\b', 'asia'),
    (r'\bAsiaeque\b', 'asia'),
    (r'\basiaeque\b', 'asia'),
    (r'\bAsiai\b', 'asia'),
    (r'\basiai\b', 'asia'),
    (r'\bAsiam\b', 'asia'),
    (r'\basiam\b', 'asia'),
    (r'\bAsiamque\b', 'asia'),
    (r'\basiamque\b', 'asia'),
    (r'\bAsiana\b', 'Asianus'),
    (r'\bAsiane\b', 'Asianus'),
    (r'\basiane\b', 'asia'),
    (r'\bAsiani\b', 'Asianus'),
    (r'\bAsiani\b', 'Asianus'),
    (r'\bAsianis\b', 'Asianus'),
    (r'\bAsianis\b', 'Asianus'),
    (r'\bAsianorum\b', 'Asianus'),
    (r'\bAsianorum\b', 'Asianus'),
    (r'\bAsianos\b', 'Asianus'),
    (r'\bAsianum\b', 'Asianus'),
    (r'\bAsianum\b', 'Asianus'),
    (r'\bAsianus\b', 'Asianus'),
    (r'\bAsiaque\b', 'asia'),
    (r'\basiaque\b', 'asia'),
    (r'\bAsiaque\b', 'Asius'),
    (r'\bAsiatica\b', 'Asiaticus'),
    (r'\bAsiaticae\b', 'Asiaticus'),
    (r'\bAsiaticam\b', 'Asiaticus'),
    (r'\bAsiaticas\b', 'Asiaticus'),
    (r'\bAsiatici\b', 'Asiaticus'),
    (r'\bAsiaticis\b', 'Asiaticus'),
    (r'\bAsiatico\b', 'Asiaticus'),
    (r'\bAsiaticorum\b', 'Asiaticus'),
    (r'\bAsiaticos\b', 'Asiaticus'),
    (r'\bAsiaticum\b', 'Asiaticus'),
    (r'\bAsiaticus\b', 'Asiaticus'),
    (r'\bAsici\b', 'asilus'),
    (r'\bAsicianam\b', 'asilus'),
    (r'\bAsiciano\b', 'asilus'),
    (r'\bAsicio\b', 'asilus'),
    (r'\bAsicius\b', 'asilus'),
    (r'\baside\b', 'asilus'),
    (r'\basido\b', 'asilus'),
    (r'\bAsii\b', 'Asius'),
    (r'\basilo\b', 'asilus'),
    (r'\basilos\b', 'asilus'),
    (r'\basilum\b', 'asilus'),
    (r'\basilus\b', 'asilus'),
    (r'\basim\b', 'a-sum1'),
    (r'\basima\b', 'asina'),
    (r'\bAsin\b', 'Asius'),
    (r'\bAsin\b', 'a-sum1'),
    (r'\basin\b', 'a-sum1'),
    (r'\basina\b', 'asina'),
    (r'\bAsina\b', 'Asine'),
    (r'\basinae\b', 'asina'),
    (r'\bAsinae\b', 'Asine'),
    (r'\bAsinaeo\b', 'Asinaeus'),
    (r'\basinaeque\b', 'asina'),
    (r'\bAsinaeque\b', 'Asine'),
    (r'\bAsinaeus\b', 'Asinaeus'),
    (r'\basinaeve\b', 'asina'),
    (r'\basinali\b', 'asinalis'),
    (r'\basinam\b', 'asina'),
    (r'\bAsinam\b', 'Asine'),
    (r'\bAsinaria\b', 'asinarius'),
    (r'\basinaria\b', 'asinarius'),
    (r'\basinariae\b', 'asinarius'),
    (r'\bAsinariam\b', 'asinarius'),
    (r'\basinariam\b', 'asinarius'),
    (r'\basinarias\b', 'asinarius'),
    (r'\basinario\b', 'asinarius'),
    (r'\basinarium\b', 'asinarius'),
    (r'\basinarius\b', 'asinarius'),
    (r'\basinarum\b', 'asina'),
    (r'\basinarumve\b', 'asina'),
    (r'\basinas\b', 'asina'),
    (r'\bAsine\b', 'Asine'),
    (r'\basine\b', 'asinus'),
    (r'\bAsines\b', 'Asine'),
    (r'\basines\b', 'asinus'),
    (r'\basini\b', 'asinus'),
    (r'\bAsini\b', 'Asinius'),
    (r'\bAsinianos\b', 'Asinianus'),
    (r'\bAsinianum\b', 'Asinianus'),
    (r'\bAsinii\b', 'Asinius'),
    (r'\basinina\b', 'asininus'),
    (r'\basininae\b', 'asininus'),
    (r'\basininas\b', 'asininus'),
    (r'\basinini\b', 'asininus'),
    (r'\basininis\b', 'asininus'),
    (r'\basinino\b', 'asininus'),
    (r'\basininum\b', 'asininus'),
    (r'\bAsinio\b', 'Asinius'),
    (r'\bAsinios\b', 'Asinius'),
    (r'\basinis\b', 'asina'),
    (r'\basinis\b', 'asinus'),
    (r'\basinisque\b', 'asina'),
    (r'\basinisque\b', 'asinus'),
    (r'\bAsinium\b', 'Asinius'),
    (r'\bAsinius\b', 'Asinius'),
    (r'\basino\b', 'asinus'),
    (r'\basinorum\b', 'asinus'),
    (r'\basinos\b', 'asinus'),
    (r'\basinum\b', 'asinus'),
    (r'\basinumque\b', 'asinus'),
    (r'\basinus\b', 'asinus'),
    (r'\basinusca\b', 'asinusca'),
    (r'\bAsis\b', 'a-sum1'),
    (r'\basis\b', 'a-sum1'),
    (r'\bAsium\b', 'Asius'),
    (r'\bAsius\b', 'Asius'),
    (r'\bAsnaum\b', 'Asnaus'),
    (r'\bAsom\b', 'a-sum1'),
    (r'\bAsope\b', 'Asopus'),
    (r'\bAsopi\b', 'Asopus'),
    (r'\basopi\b', 'a-sopio'),
    (r'\bAsopiades\b', 'Asopiades'),
    (r'\bAsopide\b', 'a-sopio'),
    (r'\bAsopis\b', 'a-sopio'),
    (r'\bAsopis\b', 'Asopus'),
    (r'\basopis\b', 'a-sopio'),
    (r'\bAsopo\b', 'Asopus'),
    (r'\bAsopon\b', 'Asopus'),
    (r'\bAsopos\b', 'Asopus'),
    (r'\bAsopum\b', 'Asopus'),
    (r'\basoti\b', 'asotus'),
    (r'\basotia\b', 'asotia'),
    (r'\basotiamque\b', 'asotia'),
    (r'\basotorum\b', 'asotus'),
    (r'\basotos\b', 'asotus'),
    (r'\basotum\b', 'asotus'),
    (r'\baspalatho\b', 'aspalathus'),
    (r'\baspalathos\b', 'aspalathus'),
    (r'\baspalathum\b', 'aspalathus'),
    (r'\bAspar\b', 'Aspar'),
    (r'\basparagi\b', 'asparagus'),
    (r'\bAsparagi\b', 'Asparagium'),
    (r'\basparagis\b', 'asparagus'),
    (r'\bAsparagium\b', 'Asparagium'),
    (r'\basparago\b', 'asparagus'),
    (r'\basparagorum\b', 'asparagus'),
    (r'\basparagos\b', 'asparagus'),
    (r'\basparagum\b', 'asparagus'),
    (r'\basparagus\b', 'asparagus'),
    (r'\bAspare\b', 'Aspar'),
    (r'\bAsparem\b', 'Aspar'),
    (r'\baspargenda\b', 'a-spargo1'),
    (r'\baspargere\b', 'a-spargo1'),
    (r'\basparges\b', 'a-spargo1'),
    (r'\baspargi\b', 'a-spargo1'),
    (r'\baspargine\b', 'aspergo2'),
    (r'\baspargis\b', 'a-spargo1'),
    (r'\baspargit\b', 'a-spargo1'),
    (r'\baspargitur\b', 'a-spargo1'),
    (r'\baspargo\b', 'aspergo2'),
    (r'\baspargunt\b', 'a-spargo1'),
    (r'\basparguntur\b', 'a-spargo1'),
    (r'\basparsae\b', 'a-spargo1'),
    (r'\basparso\b', 'a-spargo1'),
    (r'\bAspasia\b', 'Aspasia'),
    (r'\bAspasiae\b', 'Aspasia'),
    (r'\bAspasiam\b', 'Aspasia'),
    (r'\baspecta\b', 'aspicio'),
    (r'\baspecta\b', 'aspecto'),
    (r'\baspectabant\b', 'aspecto'),
    (r'\baspectabat\b', 'aspecto'),
    (r'\baspectabile\b', 'aspectabilis'),
    (r'\baspectabilius\b', 'aspectabilis'),
    (r'\baspectae\b', 'aspicio'),
    (r'\baspectans\b', 'aspecto'),
    (r'\baspectant\b', 'aspecto'),
    (r'\baspectare\b', 'aspecto'),
    (r'\baspectari\b', 'aspecto'),
    (r'\baspectas\b', 'aspicio'),
    (r'\baspectas\b', 'aspecto'),
    (r'\baspectat\b', 'aspecto'),
    (r'\baspecti\b', 'aspicio'),
    (r'\baspectibus\b', 'aspectus2'),
    (r'\baspectione\b', 'aspectio'),
    (r'\baspectis\b', 'aspicio'),
    (r'\baspecto\b', 'aspicio'),
    (r'\baspecto\b', 'aspecto'),
    (r'\baspectoque\b', 'aspicio'),
    (r'\baspectoque\b', 'aspecto'),
    (r'\baspectu\b', 'aspectus2'),
    (r'\baspectu\b', 'aspicio'),
    (r'\baspectui\b', 'aspectus2'),
    (r'\baspectum\b', 'aspectus2'),
    (r'\baspectum\b', 'aspicio'),
    (r'\baspectumque\b', 'aspectus2'),
    (r'\baspectumque\b', 'aspicio'),
    (r'\baspectuque\b', 'aspectus2'),
    (r'\baspectuque\b', 'aspicio'),
    (r'\baspectus\b', 'aspectus2'),
    (r'\baspectus\b', 'aspicio'),
    (r'\baspellam\b', 'aspello'),
    (r'\baspellat\b', 'aspello'),
    (r'\baspellis\b', 'aspello'),
    (r'\baspellit\b', 'aspello'),
    (r'\baspellito\b', 'aspello'),
    (r'\baspellor\b', 'aspello'),
    (r'\bAspendi\b', 'Aspendos'),
    (r'\bAspendi\b', 'Aspendos'),
    (r'\bAspendi\b', 'asper1'),
    (r'\bAspendiis\b', 'Aspendos'),
    (r'\bAspendiorum\b', 'Aspendos'),
    (r'\bAspendium\b', 'Aspendos'),
    (r'\bAspendos\b', 'Aspendos'),
    (r'\bAspendum\b', 'Aspendos'),
    (r'\bAspendum\b', 'asper1'),
    (r'\basper\b', 'asper1'),
    (r'\baspera\b', 'asper1'),
    (r'\baspera\b', 'aspero'),
    (r'\basperae\b', 'asper1'),
    (r'\basperam\b', 'asper1'),
    (r'\basperandae\b', 'aspero'),
    (r'\basperandos\b', 'aspero'),
    (r'\basperant\b', 'aspero'),
    (r'\basperantur\b', 'aspero'),
    (r'\basperaque\b', 'asper1'),
    (r'\basperaque\b', 'aspero'),
    (r'\basperare\b', 'aspero'),
    (r'\basperarent\b', 'aspero'),
    (r'\basperari\b', 'aspero'),
    (r'\basperarum\b', 'asper1'),
    (r'\basperas\b', 'asper1'),
    (r'\basperas\b', 'aspero'),
    (r'\basperasset\b', 'aspero'),
    (r'\basperat\b', 'aspero'),
    (r'\basperata\b', 'asperatus'),
    (r'\basperata\b', 'aspero'),
    (r'\basperatam\b', 'asperatus'),
    (r'\basperatam\b', 'aspero'),
    (r'\basperatas\b', 'asperatus'),
    (r'\basperatas\b', 'aspero'),
    (r'\basperato\b', 'aspero'),
    (r'\basperato\b', 'asperatus'),
    (r'\basperatum\b', 'asperatus'),
    (r'\basperatum\b', 'aspero'),
    (r'\basperatur\b', 'aspero'),
    (r'\basperatus\b', 'asperatus'),
    (r'\basperatus\b', 'aspero'),
    (r'\basperavere\b', 'aspero'),
    (r'\baspere\b', 'asper1'),
    (r'\basperet\b', 'aspero'),
    (r'\baspergine\b', 'aspergo2'),
    (r'\basperginem\b', 'aspergo2'),
    (r'\baspergines\b', 'aspergo2'),
    (r'\baspergo\b', 'aspergo2'),
    (r'\basperi\b', 'asper1'),
    (r'\basperior\b', 'asper1'),
    (r'\basperiora\b', 'asper1'),
    (r'\basperiore\b', 'asper1'),
    (r'\basperiorem\b', 'asper1'),
    (r'\basperiores\b', 'asper1'),
    (r'\basperioribus\b', 'asper1'),
    (r'\basperioris\b', 'asper1'),
    (r'\basperiorum\b', 'asper1'),
    (r'\basperis\b', 'asper1'),
    (r'\basperisque\b', 'asper1'),
    (r'\basperitas\b', 'asperitas'),
    (r'\basperitasque\b', 'asperitas'),
    (r'\basperitate\b', 'asperitas'),
    (r'\basperitatem\b', 'asperitas'),
    (r'\basperitatemque\b', 'asperitas'),
    (r'\basperitateque\b', 'asperitas'),
    (r'\basperitates\b', 'asperitas'),
    (r'\basperitati\b', 'asperitas'),
    (r'\basperitatibus\b', 'asperitas'),
    (r'\basperitatis\b', 'asperitas'),
    (r'\basperius\b', 'asper1'),
    (r'\baspern\b', 'asper1'),
    (r'\baspernabantur\b', 'aspernor'),
    (r'\baspernabatur\b', 'aspernor'),
    (r'\baspernabere\b', 'aspernor'),
    (r'\baspernabilem\b', 'aspernabilis'),
    (r'\baspernabiles\b', 'aspernabilis'),
    (r'\baspernabilis\b', 'aspernabilis'),
    (r'\baspernabitur\b', 'aspernor'),
    (r'\baspernamini\b', 'aspernor'),
    (r'\baspernanda\b', 'aspernor'),
    (r'\baspernandam\b', 'aspernor'),
    (r'\baspernandis\b', 'aspernor'),
    (r'\baspernandos\b', 'aspernor'),
    (r'\baspernandum\b', 'aspernor'),
    (r'\baspernandus\b', 'aspernor'),
    (r'\baspernans\b', 'aspernor'),
    (r'\baspernante\b', 'aspernor'),
    (r'\baspernantem\b', 'aspernor'),
    (r'\baspernantes\b', 'aspernor'),
    (r'\baspernantibus\b', 'aspernor'),
    (r'\baspernantibusque\b', 'aspernor'),
    (r'\baspernantis\b', 'aspernor'),
    (r'\baspernantium\b', 'aspernor'),
    (r'\baspernantur\b', 'aspernor'),
    (r'\baspernanturque\b', 'aspernor'),
    (r'\baspernarentur\b', 'aspernor'),
    (r'\baspernarer\b', 'aspernor'),
    (r'\baspernaretur\b', 'aspernor'),
    (r'\baspernari\b', 'aspernor'),
    (r'\baspernarique\b', 'aspernor'),
    (r'\baspernaris\b', 'aspernor'),
    (r'\baspernata\b', 'aspernor'),
    (r'\baspernatae\b', 'aspernor'),
    (r'\baspernatam\b', 'aspernor'),
    (r'\baspernatast\b', 'aspernor'),
    (r'\baspernati\b', 'aspernor'),
    (r'\baspernatio\b', 'aspernatio'),
    (r'\baspernatione\b', 'aspernatio'),
    (r'\baspernationem\b', 'aspernatio'),
    (r'\baspernationes\b', 'aspernatio'),
    (r'\baspernator\b', 'aspernator'),
    (r'\baspernatos\b', 'aspernor'),
    (r'\baspernatum\b', 'aspernor'),
    (r'\baspernatur\b', 'aspernor'),
    (r'\baspernaturque\b', 'aspernor'),
    (r'\baspernatus\b', 'aspernor'),
    (r'\baspernatusque\b', 'aspernor'),
    (r'\baspernemur\b', 'aspernor'),
    (r'\baspernentur\b', 'aspernor'),
    (r'\baspernenturque\b', 'aspernor'),
    (r'\basperner\b', 'aspernor'),
    (r'\baspernere\b', 'aspernor'),
    (r'\basperneris\b', 'aspernor'),
    (r'\baspernetur\b', 'aspernor'),
    (r'\basperneturque\b', 'aspernor'),
    (r'\baspernor\b', 'aspernor'),
    (r'\baspero\b', 'asper1'),
    (r'\baspero\b', 'aspero'),
    (r'\basperoque\b', 'asper1'),
    (r'\basperoque\b', 'aspero'),
    (r'\basperorum\b', 'asper1'),
    (r'\basperos\b', 'asper1'),
    (r'\basperque\b', 'asper1'),
    (r'\basperrima\b', 'asper1'),
    (r'\basperrimae\b', 'asper1'),
    (r'\basperrimam\b', 'asper1'),
    (r'\basperrimamque\b', 'asper1'),
    (r'\basperrimaque\b', 'asper1'),
    (r'\basperrimas\b', 'asper1'),
    (r'\basperrime\b', 'asper1'),
    (r'\basperrimi\b', 'asper1'),
    (r'\basperrimis\b', 'asper1'),
    (r'\basperrimo\b', 'asper1'),
    (r'\basperrimoque\b', 'asper1'),
    (r'\basperrimorum\b', 'asper1'),
    (r'\basperrimos\b', 'asper1'),
    (r'\basperrimum\b', 'asper1'),
    (r'\basperrimus\b', 'asper1'),
    (r'\baspersione\b', 'aspersio'),
    (r'\baspersionem\b', 'aspersio'),
    (r'\baspersionis\b', 'aspersio'),
    (r'\baspersu\b', 'aspersus2'),
    (r'\baspersum\b', 'aspersus2'),
    (r'\baspersus\b', 'aspersus2'),
    (r'\baspersusque\b', 'aspersus2'),
    (r'\basperugo\b', 'asperugo'),
    (r'\basperum\b', 'asper1'),
    (r'\basperumque\b', 'asper1'),
    (r'\baspexeram\b', 'aspicio'),
    (r'\baspexerant\b', 'aspicio'),
    (r'\baspexeras\b', 'aspicio'),
    (r'\baspexerat\b', 'aspicio'),
    (r'\baspexere\b', 'aspicio'),
    (r'\baspexerim\b', 'aspicio'),
    (r'\baspexerint\b', 'aspicio'),
    (r'\baspexeris\b', 'aspicio'),
    (r'\baspexerit\b', 'aspicio'),
    (r'\baspexeritne\b', 'aspicio'),
    (r'\baspexero\b', 'aspicio'),
    (r'\baspexerunt\b', 'aspicio'),
    (r'\baspexi\b', 'aspicio'),
    (r'\baspeximus\b', 'aspicio'),
    (r'\baspexisse\b', 'aspicio'),
    (r'\baspexissent\b', 'aspicio'),
    (r'\baspexissentque\b', 'aspicio'),
    (r'\baspexisset\b', 'aspicio'),
    (r'\baspexisti\b', 'aspicio'),
    (r'\baspexistis\b', 'aspicio'),
    (r'\baspexit\b', 'aspicio'),
    (r'\bAsphaltite\b', 'Asphaltites'),
    (r'\bAsphaltiten\b', 'Asphaltites'),
    (r'\bAsphaltites\b', 'Asphaltites'),
    (r'\basphodeli\b', 'asphodelus'),
    (r'\basphodelo\b', 'asphodelus'),
    (r'\basphodelon\b', 'asphodelus'),
    (r'\basphodelum\b', 'asphodelus'),
    (r'\basphodelus\b', 'asphodelus'),
    (r'\baspice\b', 'aspicio'),
    (r'\baspicere\b', 'aspicio'),
    (r'\baspicerem\b', 'aspicio'),
    (r'\baspiceremus\b', 'aspicio'),
    (r'\baspicerent\b', 'aspicio'),
    (r'\baspicerentur\b', 'aspicio'),
    (r'\baspiceres\b', 'aspicio'),
    (r'\baspiceret\b', 'aspicio'),
    (r'\baspiceretur\b', 'aspicio'),
    (r'\baspiceris\b', 'aspicio'),
    (r'\baspici\b', 'aspicio'),
    (r'\baspiciam\b', 'aspicio'),
    (r'\baspiciamne\b', 'aspicio'),
    (r'\baspiciamque\b', 'aspicio'),
    (r'\baspiciamus\b', 'aspicio'),
    (r'\baspiciant\b', 'aspicio'),
    (r'\baspiciantur\b', 'aspicio'),
    (r'\baspiciar\b', 'aspicio'),
    (r'\baspiciare\b', 'aspicio'),
    (r'\baspicias\b', 'aspicio'),
    (r'\baspiciat\b', 'aspicio'),
    (r'\baspiciatur\b', 'aspicio'),
    (r'\baspiciebam\b', 'aspicio'),
    (r'\baspiciebant\b', 'aspicio'),
    (r'\baspiciebantque\b', 'aspicio'),
    (r'\baspiciebantur\b', 'aspicio'),
    (r'\baspiciebat\b', 'aspicio'),
    (r'\baspiciebatur\b', 'aspicio'),
    (r'\baspiciemus\b', 'aspicio'),
    (r'\baspicienda\b', 'aspicio'),
    (r'\baspiciendae\b', 'aspicio'),
    (r'\baspiciendam\b', 'aspicio'),
    (r'\baspiciendas\b', 'aspicio'),
    (r'\baspiciendi\b', 'aspicio'),
    (r'\baspiciendum\b', 'aspicio'),
    (r'\baspiciendus\b', 'aspicio'),
    (r'\baspiciens\b', 'aspicio'),
    (r'\baspicient\b', 'aspicio'),
    (r'\baspicientes\b', 'aspicio'),
    (r'\baspicienti\b', 'aspicio'),
    (r'\baspicientibus\b', 'aspicio'),
    (r'\baspicies\b', 'aspicio'),
    (r'\baspiciet\b', 'aspicio'),
    (r'\baspicietis\b', 'aspicio'),
    (r'\baspicietur\b', 'aspicio'),
    (r'\baspicimur\b', 'aspicio'),
    (r'\baspicimus\b', 'aspicio'),
    (r'\baspicio\b', 'aspicio'),
    (r'\baspicique\b', 'aspicio'),
    (r'\baspicis\b', 'aspicio'),
    (r'\baspicit\b', 'aspicio'),
    (r'\baspicite\b', 'aspicio'),
    (r'\baspicitis\b', 'aspicio'),
    (r'\baspicito\b', 'aspicio'),
    (r'\baspicitur\b', 'aspicio'),
    (r'\baspiciturque\b', 'aspicio'),
    (r'\baspiciunt\b', 'aspicio'),
    (r'\baspiciuntur\b', 'aspicio'),
    (r'\baspide\b', 'aspis'),
    (r'\baspidem\b', 'aspis'),
    (r'\baspides\b', 'aspis'),
    (r'\baspidi\b', 'aspis'),
    (r'\baspidis\b', 'aspis'),
    (r'\baspidum\b', 'aspis'),
    (r'\baspirabat\b', 'aspiro'),
    (r'\baspirabit\b', 'aspiro'),
    (r'\baspirandum\b', 'aspiro'),
    (r'\baspirans\b', 'aspiro'),
    (r'\baspirant\b', 'aspiro'),
    (r'\baspirantibus\b', 'aspiro'),
    (r'\baspirare\b', 'aspiro'),
    (r'\baspirarit\b', 'aspiro'),
    (r'\baspirasse\b', 'aspiro'),
    (r'\baspirasset\b', 'aspiro'),
    (r'\baspirasti\b', 'aspiro'),
    (r'\baspirat\b', 'aspiro'),
    (r'\baspirate\b', 'aspiro'),
    (r'\baspiratio\b', 'aspiratio'),
    (r'\baspiratione\b', 'aspiratio'),
    (r'\baspirationem\b', 'aspiratio'),
    (r'\baspirationibus\b', 'aspiratio'),
    (r'\baspirationis\b', 'aspiratio'),
    (r'\baspiratur\b', 'aspiro'),
    (r'\baspirauerint\b', 'aspiro'),
    (r'\baspirauit\b', 'aspiro'),
    (r'\baspiravit\b', 'aspiro'),
    (r'\baspiret\b', 'aspiro'),
    (r'\baspiretque\b', 'aspiro'),
    (r'\baspiretur\b', 'aspiro'),
    (r'\baspis\b', 'aspis'),
    (r'\basplenon\b', 'asplenum'),
    (r'\basporta\b', 'asporto'),
    (r'\basportabant\b', 'asporto'),
    (r'\basportabat\b', 'asporto'),
    (r'\basportabit\b', 'asporto'),
    (r'\basportabitur\b', 'asporto'),
    (r'\basportabunt\b', 'asporto'),
    (r'\basportanda\b', 'asporto'),
    (r'\basportandi\b', 'asporto'),
    (r'\basportandum\b', 'asporto'),
    (r'\basportandumque\b', 'asporto'),
    (r'\basportans\b', 'asporto'),
    (r'\basportantur\b', 'asporto'),
    (r'\basportare\b', 'asporto'),
    (r'\basportarent\b', 'asporto'),
    (r'\basportaret\b', 'asporto'),
    (r'\basportari\b', 'asporto'),
    (r'\basportarier\b', 'asporto'),
    (r'\basportasse\b', 'asporto'),
    (r'\basportassent\b', 'asporto'),
    (r'\basportata\b', 'asporto'),
    (r'\basportatam\b', 'asporto'),
    (r'\basportate\b', 'asporto'),
    (r'\basportatio\b', 'asportatio'),
    (r'\basportatis\b', 'asporto'),
    (r'\basportatum\b', 'asporto'),
    (r'\basportatur\b', 'asporto'),
    (r'\basportauitque\b', 'asporto'),
    (r'\basportaverat\b', 'asporto'),
    (r'\basportaverunt\b', 'asporto'),
    (r'\basportavit\b', 'asporto'),
    (r'\basportet\b', 'asporto'),
    (r'\baspreta\b', 'aspretum'),
    (r'\baspretis\b', 'aspretum'),
    (r'\baspritudine\b', 'aspritudo'),
    (r'\baspritudinem\b', 'aspritudo'),
    (r'\baspritudines\b', 'aspritudo'),
    (r'\baspritudo\b', 'aspritudo'),
    (r'\bass\b', 'assa'),
    (r'\bassa\b', 'assus'),
    (r'\bassa\b', 'assa'),
    (r'\bassa\b', 'asso'),
    (r'\bAssabinum\b', 'Assabinus'),
    (r'\bassabis\b', 'asso'),
    (r'\bassae\b', 'assus'),
    (r'\bassam\b', 'assus'),
    (r'\bassanda\b', 'asso'),
    (r'\bassandi\b', 'asso'),
    (r'\bassantur\b', 'asso'),
    (r'\bAssaraci\b', 'Assaracus'),
    (r'\bAssaracique\b', 'Assaracus'),
    (r'\bAssaraco\b', 'Assaracus'),
    (r'\bAssaracon\b', 'Assaracus'),
    (r'\bAssaracum\b', 'Assaracus'),
    (r'\bAssaracus\b', 'Assaracus'),
    (r'\bAssaracusque\b', 'Assaracus'),
    (r'\bassari\b', 'assarius1'),
    (r'\bassari\b', 'assarius1'),
    (r'\bassari\b', 'asso'),
    (r'\bassaria\b', 'assarius1'),
    (r'\bassarii\b', 'assarius1'),
    (r'\bassarii\b', 'assarius1'),
    (r'\bassario\b', 'assarius1'),
    (r'\bassario\b', 'assarius1'),
    (r'\bassariorum\b', 'assarius1'),
    (r'\bassariorum\b', 'assarius1'),
    (r'\bassarium\b', 'assarius1'),
    (r'\bassarium\b', 'assarius1'),
    (r'\bassarum\b', 'assus'),
    (r'\bassas\b', 'assus'),
    (r'\bassas\b', 'asso'),
    (r'\bassasque\b', 'assus'),
    (r'\bassasque\b', 'asso'),
    (r'\bassat\b', 'asso'),
    (r'\bassata\b', 'asso'),
    (r'\bassatae\b', 'asso'),
    (r'\bassatum\b', 'asso'),
    (r'\bassatur\b', 'asso'),
    (r'\bassaturae\b', 'assatura'),
    (r'\bassaturae\b', 'asso'),
    (r'\bassaturam\b', 'assatura'),
    (r'\bassaturam\b', 'asso'),
    (r'\bassaturas\b', 'assatura'),
    (r'\bassaturas\b', 'asso'),
    (r'\bassaturis\b', 'assatura'),
    (r'\bassaturis\b', 'asso'),
    (r'\bassaverunt\b', 'asso'),
    (r'\bassavit\b', 'asso'),
    (r'\basscit\b', 'ad-scribo'),
    (r'\basse\b', 'assus'),
    (r'\basse\b', 'assis1'),
    (r'\basse\b', 'assis2'),
    (r'\basse\b', 'assum'),
    (r'\basseclam\b', 'assecla'),
    (r'\bassecuta\b', 'ad-sono'),
    (r'\bassecuti\b', 'ad-sono'),
    (r'\bassecutique\b', 'ad-sono'),
    (r'\bassecutis\b', 'ad-sono'),
    (r'\bassecuto\b', 'ad-sono'),
    (r'\bassecutus\b', 'ad-sono'),
    (r'\bassecutusque\b', 'ad-sono'),
    (r'\bassedi\b', 'ad-sono'),
    (r'\bassedimus\b', 'ad-sono'),
    (r'\bassedisset\b', 'ad-sono'),
    (r'\bassedit\b', 'ad-sono'),
    (r'\bassellandi\b', 'assellor'),
    (r'\bassem\b', 'assis1'),
    (r'\bassem\b', 'assis2'),
    (r'\bassem\b', 'asso'),
    (r'\bassemque\b', 'assis1'),
    (r'\bassemque\b', 'assis2'),
    (r'\bassemque\b', 'asso'),
    (r'\bassensere\b', 'ad-sono'),
    (r'\bassenserimus\b', 'ad-sono'),
    (r'\bassenserit\b', 'ad-sono'),
    (r'\bassensi\b', 'assentior'),
    (r'\bassensio\b', 'assensio'),
    (r'\bassensione\b', 'assensio'),
    (r'\bassensionem\b', 'assensio'),
    (r'\bassensionibus\b', 'assensio'),
    (r'\bassensionis\b', 'assensio'),
    (r'\bassensisse\b', 'ad-sono'),
    (r'\bassensit\b', 'ad-sono'),
    (r'\bassensor\b', 'assensor'),
    (r'\bassensu\b', 'assensus2'),
    (r'\bassensu\b', 'assentior'),
    (r'\bassensum\b', 'assensus2'),
    (r'\bassensum\b', 'assentior'),
    (r'\bassensus\b', 'assensus2'),
    (r'\bassensus\b', 'assentior'),
    (r'\bassent\b', 'asso'),
    (r'\bassentante\b', 'assentor'),
    (r'\bassentatio\b', 'assentatio'),
    (r'\bassentationem\b', 'assentatio'),
    (r'\bassentator\b', 'assentator'),
    (r'\bassentatorem\b', 'assentator'),
    (r'\bassentatores\b', 'assentator'),
    (r'\bassentatoribus\b', 'assentator'),
    (r'\bassentatorum\b', 'assentator'),
    (r'\bassentatorum\b', 'assentor'),
    (r'\bassentatur\b', 'assentor'),
    (r'\bassentemur\b', 'assentor'),
    (r'\bassentiamur\b', 'assentior'),
    (r'\bassentiar\b', 'assentior'),
    (r'\bassentiebatur\b', 'assentior'),
    (r'\bassentiendum\b', 'assentior'),
    (r'\bassentientem\b', 'assentior'),
    (r'\bassentimus\b', 'assentior'),
    (r'\bassentio\b', 'assentior'),
    (r'\bassentior\b', 'assentior'),
    (r'\bassentire\b', 'assentior'),
    (r'\bassentiri\b', 'assentior'),
    (r'\bassentiuntur\b', 'assentior'),
    (r'\bassentur\b', 'asso'),
    (r'\bassequamur\b', 'assequor'),
    (r'\bassequar\b', 'assequor'),
    (r'\bassequatur\b', 'assequor'),
    (r'\bassequebantur\b', 'assequor'),
    (r'\bassequebar\b', 'assequor'),
    (r'\bassequebatur\b', 'assequor'),
    (r'\bassequemur\b', 'assequor'),
    (r'\bassequetur\b', 'assequor'),
    (r'\bassequi\b', 'assequor'),
    (r'\bassequimur\b', 'assequor'),
    (r'\bassequuntur\b', 'assequor'),
    (r'\basserat\b', 'assero1'),
    (r'\bassercula\b', 'asserculus'),
    (r'\basserculis\b', 'asserculus'),
    (r'\basserculis\b', 'asserculus'),
    (r'\basserculo\b', 'asserculus'),
    (r'\basserculo\b', 'asserculus'),
    (r'\basserculos\b', 'asserculus'),
    (r'\bassere\b', 'asser'),
    (r'\bassere\b', 'assero1'),
    (r'\bassere\b', 'asso'),
    (r'\basserebam\b', 'assero1'),
    (r'\basserebant\b', 'assero1'),
    (r'\basserem\b', 'asser'),
    (r'\basserenda\b', 'assero1'),
    (r'\basserendo\b', 'assero1'),
    (r'\basserente\b', 'assero1'),
    (r'\basserentes\b', 'assero1'),
    (r'\basserere\b', 'assero1'),
    (r'\bassererent\b', 'assero1'),
    (r'\bassereret\b', 'assero1'),
    (r'\basseres\b', 'assero1'),
    (r'\basseres\b', 'asser'),
    (r'\basseresve\b', 'assero1'),
    (r'\basseresve\b', 'asser'),
    (r'\basseri\b', 'asser'),
    (r'\basseri\b', 'assero1'),
    (r'\basseribus\b', 'asser'),
    (r'\basseribusque\b', 'asser'),
    (r'\basserit\b', 'assero1'),
    (r'\basseritur\b', 'assero1'),
    (r'\bassertio\b', 'assertio'),
    (r'\bassertionibus\b', 'assertio'),
    (r'\basserto\b', 'assertum'),
    (r'\basserto\b', 'assero2'),
    (r'\bassertor\b', 'assertor'),
    (r'\bassertorem\b', 'assertor'),
    (r'\bassertores\b', 'assertor'),
    (r'\bassertorum\b', 'assertor'),
    (r'\bassertorum\b', 'assertum'),
    (r'\bassertorum\b', 'assero2'),
    (r'\basserturi\b', 'assero2'),
    (r'\basseruere\b', 'assero2'),
    (r'\basseruere\b', 'asservo'),
    (r'\basseruisset\b', 'assero2'),
    (r'\basseruit\b', 'assero2'),
    (r'\basseruit\b', 'asservio'),
    (r'\basserum\b', 'asser'),
    (r'\basserunt\b', 'assero1'),
    (r'\basserva\b', 'asservo'),
    (r'\basservabat\b', 'asservo'),
    (r'\basservabo\b', 'asservo'),
    (r'\basservanda\b', 'asservo'),
    (r'\basservatote\b', 'asservo'),
    (r'\basses\b', 'assis1'),
    (r'\basses\b', 'assis2'),
    (r'\basses\b', 'asso'),
    (r'\bassessore\b', 'assessor'),
    (r'\bassessores\b', 'assessor'),
    (r'\bassessu\b', 'assessus2'),
    (r'\basset\b', 'asso'),
    (r'\basseuerabat\b', 'assevero'),
    (r'\basseuerante\b', 'assevero'),
    (r'\basseuerat\b', 'assero1'),
    (r'\basseuerat\b', 'assevero'),
    (r'\basseuerate\b', 'assevero'),
    (r'\basseverabat\b', 'assevero'),
    (r'\basseveratione\b', 'asseveratio'),
    (r'\bassi\b', 'assis1'),
    (r'\bassi\b', 'assus'),
    (r'\bassi\b', 'assis2'),
    (r'\bAssi\b', 'Assius'),
    (r'\bassi\b', 'assum'),
    (r'\bAssias\b', 'Assius'),
    (r'\bassibus\b', 'assis1'),
    (r'\bassibus\b', 'assis2'),
    (r'\bassidat\b', 'assideo'),
    (r'\basside\b', 'assideo'),
    (r'\bassideant\b', 'assideo'),
    (r'\bassidebam\b', 'assideo'),
    (r'\bassidebat\b', 'assideo'),
    (r'\bassidebatque\b', 'assideo'),
    (r'\bassidendo\b', 'assideo'),
    (r'\bassidens\b', 'assideo'),
    (r'\bassident\b', 'assideo'),
    (r'\bassidente\b', 'assideo'),
    (r'\bassidentem\b', 'assideo'),
    (r'\bassidenti\b', 'assideo'),
    (r'\bassidentium\b', 'assideo'),
    (r'\bassideo\b', 'assideo'),
    (r'\bassidere\b', 'assideo'),
    (r'\bassiderent\b', 'assideo'),
    (r'\bassideri\b', 'assideo'),
    (r'\bassides\b', 'assideo'),
    (r'\bassidet\b', 'assideo'),
    (r'\bassidite\b', 'assideo'),
    (r'\bassidua\b', 'assiduus2'),
    (r'\bassidua\b', 'assiduo2'),
    (r'\bassiduae\b', 'assiduus2'),
    (r'\bassiduam\b', 'assiduus2'),
    (r'\bassiduas\b', 'assiduus2'),
    (r'\bassiduas\b', 'assiduo2'),
    (r'\bassidue\b', 'assiduus2'),
    (r'\bassidue\b', 'assiduus1'),
    (r'\bassidueque\b', 'assiduus2'),
    (r'\bassidueque\b', 'assiduus1'),
    (r'\bassidui\b', 'assiduus1'),
    (r'\bassidui\b', 'assiduus2'),
    (r'\bassiduique\b', 'assiduus1'),
    (r'\bassiduique\b', 'assiduus2'),
    (r'\bassiduis\b', 'assiduus1'),
    (r'\bassiduis\b', 'assiduus2'),
    (r'\bassiduissimi\b', 'assiduus2'),
    (r'\bassiduitas\b', 'assiduitas'),
    (r'\bassiduitate\b', 'assiduitas'),
    (r'\bassiduitatem\b', 'assiduitas'),
    (r'\bassiduitatemque\b', 'assiduitas'),
    (r'\bassiduitatis\b', 'assiduitas'),
    (r'\bassiduo\b', 'assiduo'),
    (r'\bassiduo\b', 'assiduus1'),
    (r'\bassiduo\b', 'assiduus2'),
    (r'\bassiduo\b', 'assiduo2'),
    (r'\bassiduoque\b', 'assiduo'),
    (r'\bassiduoque\b', 'assiduus1'),
    (r'\bassiduoque\b', 'assiduus2'),
    (r'\bassiduoque\b', 'assiduo2'),
    (r'\bassiduos\b', 'assiduus1'),
    (r'\bassiduum\b', 'assiduus1'),
    (r'\bassiduum\b', 'assiduus2'),
    (r'\bassiduumque\b', 'assiduus1'),
    (r'\bassiduumque\b', 'assiduus2'),
    (r'\bassiduus\b', 'assiduus1'),
    (r'\bassiduusque\b', 'assiduus1'),
    (r'\bassignabatur\b', 'assigno'),
    (r'\bassignabimus\b', 'assigno'),
    (r'\bassignandus\b', 'assigno'),
    (r'\bassignant\b', 'assigno'),
    (r'\bassignantur\b', 'assigno'),
    (r'\bassignarant\b', 'assigno'),
    (r'\bassignare\b', 'assigno'),
    (r'\bassignarentur\b', 'assigno'),
    (r'\bassignari\b', 'assigno'),
    (r'\bassignasse\b', 'assigno'),
    (r'\bassignasti\b', 'assigno'),
    (r'\bassignat\b', 'assigno'),
    (r'\bassignata\b', 'assigno'),
    (r'\bassignatas\b', 'assigno'),
    (r'\bassignate\b', 'assigno'),
    (r'\bassignati\b', 'assigno'),
    (r'\bassignatione\b', 'assignatio'),
    (r'\bassignationem\b', 'assignatio'),
    (r'\bassignationes\b', 'assignatio'),
    (r'\bassignationi\b', 'assignatio'),
    (r'\bassignationis\b', 'assignatio'),
    (r'\bassignationisque\b', 'assignatio'),
    (r'\bassignationum\b', 'assignatio'),
    (r'\bassignatis\b', 'assigno'),
    (r'\bassignato\b', 'assigno'),
    (r'\bassignatorum\b', 'assignator'),
    (r'\bassignatorum\b', 'assigno'),
    (r'\bassignatum\b', 'assigno'),
    (r'\bassignatur\b', 'assigno'),
    (r'\bassignatus\b', 'assigno'),
    (r'\bassignauerunt\b', 'assigno'),
    (r'\bassignauit\b', 'assigno'),
    (r'\bassignet\b', 'assigno'),
    (r'\bassignificant\b', 'assignifico'),
    (r'\bassigno\b', 'assigno'),
    (r'\bassilire\b', 'assilio'),
    (r'\bassilit\b', 'assilio'),
    (r'\bassiluit\b', 'ad-sono'),
    (r'\bassim\b', 'assis1'),
    (r'\bassim\b', 'assis2'),
    (r'\bassim\b', 'adsum'),
    (r'\bassimulabam\b', 'assimulo'),
    (r'\bassimulabat\b', 'assimulo'),
    (r'\bassimulanda\b', 'assimulo'),
    (r'\bassimulant\b', 'assimulo'),
    (r'\bassimularet\b', 'assimulo'),
    (r'\bassimulata\b', 'assimulo'),
    (r'\bassimulatione\b', 'assimulatio'),
    (r'\bassimulo\b', 'assimulo'),
    (r'\bassint\b', 'adsum'),
    (r'\bAssio\b', 'Assius'),
    (r'\bassipondium\b', 'assipondium'),
    (r'\bassis\b', 'assus'),
    (r'\bassis\b', 'assis1'),
    (r'\bassis\b', 'assis2'),
    (r'\bassis\b', 'assa'),
    (r'\bassis\b', 'adsum'),
    (r'\bassiste\b', 'assisto'),
    (r'\bassistebant\b', 'assisto'),
    (r'\bassistebat\b', 'assisto'),
    (r'\bassistendi\b', 'assisto'),
    (r'\bassistens\b', 'assisto'),
    (r'\bassistentibus\b', 'assisto'),
    (r'\bassistere\b', 'assisto'),
    (r'\bassistit\b', 'assisto'),
    (r'\bassit\b', 'adsum'),
    (r'\bassitas\b', 'assitus1'),
    (r'\bassitas\b', 'assero1'),
    (r'\bassium\b', 'assis1'),
    (r'\bassium\b', 'assis2'),
    (r'\bassius\b', 'assus'),
    (r'\bAssius\b', 'Assius'),
    (r'\basso\b', 'assus'),
    (r'\basso\b', 'assum'),
    (r'\basso\b', 'asso'),
    (r'\bassolent\b', 'assoleo'),
    (r'\bassolent\b', 'assolo'),
    (r'\bassolet\b', 'assoleo'),
    (r'\bassolet\b', 'assolo'),
    (r'\basson\b', 'assus'),
    (r'\basson\b', 'assum'),
    (r'\basson\b', 'asso'),
    (r'\bassoque\b', 'assus'),
    (r'\bassoque\b', 'assum'),
    (r'\bassoque\b', 'asso'),
    (r'\bAssorini\b', 'Assoro'),
    (r'\bAssorinis\b', 'Assoro'),
    (r'\bAssorinorum\b', 'Assoro'),
    (r'\bAssorinos\b', 'Assoro'),
    (r'\bAssorinus\b', 'Assoro'),
    (r'\bAssoro\b', 'Assoro'),
    (r'\bassorum\b', 'assus'),
    (r'\bassorum\b', 'assa'),
    (r'\bassos\b', 'assus'),
    (r'\bassudescit\b', 'assudesco'),
    (r'\bassuefaceret\b', 'assuefacio'),
    (r'\bassuefactis\b', 'assuefacio'),
    (r'\bassueram\b', 'ad-suspiro'),
    (r'\bassuerant\b', 'ad-suspiro'),
    (r'\bassuerat\b', 'ad-suspiro'),
    (r'\bassuesce\b', 'assuesco'),
    (r'\bassuescent\b', 'assuesco'),
    (r'\bassuescerent\b', 'assuesco'),
    (r'\bassuesceret\b', 'assuesco'),
    (r'\bassueta\b', 'assuesco'),
    (r'\bassuetae\b', 'assuesco'),
    (r'\bassuetam\b', 'assuesco'),
    (r'\bassuetas\b', 'assuesco'),
    (r'\bassuetasque\b', 'assuesco'),
    (r'\bassueti\b', 'assuesco'),
    (r'\bassuetis\b', 'assuo'),
    (r'\bassuetis\b', 'assuesco'),
    (r'\bassueto\b', 'assuesco'),
    (r'\bassuetos\b', 'assuesco'),
    (r'\bassuetudine\b', 'assuetudo'),
    (r'\bassuetudinis\b', 'assuetudo'),
    (r'\bassuetum\b', 'assuesco'),
    (r'\bassuetus\b', 'assuesco'),
    (r'\bassueui\b', 'assuesco'),
    (r'\bassueverant\b', 'assuesco'),
    (r'\bassueverit\b', 'assuesco'),
    (r'\bassuevi\b', 'assuesco'),
    (r'\bassuevit\b', 'assuesco'),
    (r'\bassulae\b', 'assula'),
    (r'\bassulas\b', 'assula'),
    (r'\bassulatim\b', 'assulatim'),
    (r'\bassulis\b', 'assula'),
    (r'\bassulose\b', 'assulose'),
    (r'\bassum\b', 'assus'),
    (r'\bassum\b', 'assa'),
    (r'\bassum\b', 'assum'),
    (r'\bassum\b', 'adsum'),
    (r'\bassumant\b', 'assumo'),
    (r'\bassumantur\b', 'assumo'),
    (r'\bassumebat\b', 'assumo'),
    (r'\bassumenda\b', 'assumo'),
    (r'\bassumendus\b', 'assumo'),
    (r'\bassumere\b', 'assumo'),
    (r'\bassumes\b', 'assumo'),
    (r'\bassumet\b', 'assumo'),
    (r'\bassumi\b', 'assumo'),
    (r'\bassumimus\b', 'assumo'),
    (r'\bassumis\b', 'assumo'),
    (r'\bassumit\b', 'assumo'),
    (r'\bassumitur\b', 'assumo'),
    (r'\bassumo\b', 'assumo'),
    (r'\bassumpserat\b', 'assumo'),
    (r'\bassumpsere\b', 'assumo'),
    (r'\bassumpseris\b', 'assumo'),
    (r'\bassumpsit\b', 'assumo'),
    (r'\bassumpta\b', 'assumo'),
    (r'\bassumptae\b', 'assumo'),
    (r'\bassumptas\b', 'assumo'),
    (r'\bassumptio\b', 'assumptio'),
    (r'\bassumptione\b', 'assumptio'),
    (r'\bassumptionem\b', 'assumptio'),
    (r'\bassumptioni\b', 'assumptio'),
    (r'\bassumptionis\b', 'assumptio'),
    (r'\bassumptis\b', 'assumo'),
    (r'\bassumptiva\b', 'assumptivus'),
    (r'\bassumptivae\b', 'assumptivus'),
    (r'\bassumptivis\b', 'assumptivus'),
    (r'\bassumpto\b', 'assumo'),
    (r'\bassumptum\b', 'assumo'),
    (r'\bassumunt\b', 'assumo'),
    (r'\bassumuntur\b', 'assumo'),
    (r'\bassumus\b', 'adsum'),
    (r'\bassurgatur\b', 'assurgo'),
    (r'\bassurge\b', 'assurgo'),
    (r'\bassurgens\b', 'assurgo'),
    (r'\bassurgentem\b', 'assurgo'),
    (r'\bassurgere\b', 'assurgo'),
    (r'\bassurgeret\b', 'assurgo'),
    (r'\bassurgit\b', 'assurgo'),
    (r'\bassurrectum\b', 'assurgo'),
    (r'\bassurrexisse\b', 'assurgo'),
    (r'\bassurrexit\b', 'assurgo'),
    (r'\bassus\b', 'assus'),
    (r'\bAssyria\b', 'Assyria'),
    (r'\bAssyria\b', 'Assyrius'),
    (r'\bAssyriae\b', 'Assyria'),
    (r'\bAssyriaeque\b', 'Assyria'),
    (r'\bAssyriam\b', 'Assyria'),
    (r'\bAssyriaque\b', 'Assyria'),
    (r'\bAssyriaque\b', 'Assyrius'),
    (r'\bAssyrias\b', 'Assyria'),
    (r'\bAssyrii\b', 'Assyrius'),
    (r'\bAssyrii\b', 'Assyrius'),
    (r'\bAssyriis\b', 'Assyria'),
    (r'\bAssyriis\b', 'Assyrius'),
    (r'\bAssyriis\b', 'Assyrius'),
    (r'\bAssyrio\b', 'Assyrius'),
    (r'\bAssyrioque\b', 'Assyrius'),
    (r'\bAssyriorum\b', 'Assyrius'),
    (r'\bAssyriorum\b', 'Assyrius'),
    (r'\bAssyrios\b', 'Assyrius'),
    (r'\bAssyrium\b', 'Assyrius'),
    (r'\bAssyrium\b', 'Assyrius'),
    (r'\bAssyrius\b', 'Assyrius'),
    (r'\bast\b', 'at'),
    (r'\bAsta\b', 'Asta'),
    (r'\basta\b', 'astus'),
    (r'\basta\b', 'asto'),
    (r'\bastabant\b', 'asto'),
    (r'\bastabat\b', 'asto'),
    (r'\bastabo\b', 'asto'),
    (r'\bAstabores\b', 'Astabores'),
    (r'\bastacis\b', 'astacus1'),
    (r'\bAstacon\b', 'Astacus3'),
    (r'\bastacon\b', 'astacus1'),
    (r'\bAstacon\b', 'Astacus2'),
    (r'\bAstacum\b', 'Astacus3'),
    (r'\bastacum\b', 'astacus1'),
    (r'\bAstacum\b', 'Astacus2'),
    (r'\bAstacus\b', 'Astacus3'),
    (r'\bastacus\b', 'astacus1'),
    (r'\bAstacus\b', 'Astacus2'),
    (r'\bastamus\b', 'asto'),
    (r'\bastans\b', 'asto'),
    (r'\bastant\b', 'asto'),
    (r'\bastante\b', 'asto'),
    (r'\bastantem\b', 'asto'),
    (r'\bastantibus\b', 'asto'),
    (r'\bastantis\b', 'asto'),
    (r'\bAstapa\b', 'Astapa'),
    (r'\bAstape\b', 'Astapus'),
    (r'\bastaphide\b', 'astaphis'),
    (r'\bastaphis\b', 'astaphis'),
    (r'\bAstapus\b', 'Astapus'),
    (r'\bastare\b', 'asto'),
    (r'\bAstarte\b', 'Astarte'),
    (r'\bastas\b', 'astus'),
    (r'\bastas\b', 'asto'),
    (r'\bastat\b', 'asto'),
    (r'\bastate\b', 'asto'),
    (r'\bastatis\b', 'asto'),
    (r'\bastato\b', 'asto'),
    (r'\bastent\b', 'asto'),
    (r'\baster\b', 'aster'),
    (r'\baster\b', 'asto'),
    (r'\basteria\b', 'asteria1'),
    (r'\bAsteria\b', 'Asteria2'),
    (r'\basteria\b', 'asterias'),
    (r'\basteria\b', 'asterion1'),
    (r'\basteriae\b', 'asteria1'),
    (r'\bAsteriae\b', 'Asteria2'),
    (r'\basteriae\b', 'asterias'),
    (r'\basteriam\b', 'asteria1'),
    (r'\bAsteriam\b', 'Asteria2'),
    (r'\basteriam\b', 'asterias'),
    (r'\bAsterie\b', 'Asteria2'),
    (r'\basterie\b', 'asterion1'),
    (r'\bAsterien\b', 'Asteria2'),
    (r'\basterien\b', 'asterion1'),
    (r'\bAsteries\b', 'Asteria2'),
    (r'\bAsterion\b', 'Asterion2'),
    (r'\basterion\b', 'asterion1'),
    (r'\basteris\b', 'aster'),
    (r'\basteris\b', 'asto'),
    (r'\basterium\b', 'asterion1'),
    (r'\bastes\b', 'asto'),
    (r'\bastet\b', 'asto'),
    (r'\basthmaticis\b', 'asthmaticus'),
    (r'\basti\b', 'astus'),
    (r'\basticam\b', 'asticus'),
    (r'\bastice\b', 'asticus'),
    (r'\bastici\b', 'asticus'),
    (r'\basticis\b', 'asticus'),
    (r'\basticos\b', 'asticus'),
    (r'\bastile\b', 'hastile'),
    (r'\bastipulatore\b', 'astipulator'),
    (r'\bAstis\b', 'Asta'),
    (r'\bastis\b', 'astus'),
    (r'\bastiterint\b', 'asto'),
    (r'\bastiterit\b', 'asto'),
    (r'\bastiterunt\b', 'asto'),
    (r'\bastiti\b', 'asto'),
    (r'\bastitisset\b', 'asto'),
    (r'\bastitisti\b', 'asto'),
    (r'\bastitit\b', 'asto'),
    (r'\bastitui\b', 'astituo'),
    (r'\basto\b', 'astus'),
    (r'\basto\b', 'asto'),
    (r'\bAstomorum\b', 'Astomi'),
    (r'\baston\b', 'astus'),
    (r'\baston\b', 'asto'),
    (r'\bastra\b', 'astrum'),
    (r'\bAstraba\b', 'Astraba'),
    (r'\bAstraea\b', 'Astraea'),
    (r'\bAstraeae\b', 'Astraea'),
    (r'\bAstraeaque\b', 'Astraea'),
    (r'\bAstraei\b', 'Astraeus'),
    (r'\bAstraeo\b', 'Astraeus'),
    (r'\bAstraeum\b', 'Astraeus'),
    (r'\bAstraeus\b', 'Astraeus'),
    (r'\bastragali\b', 'astragalus'),
    (r'\bastragalis\b', 'astragalus'),
    (r'\bastragalo\b', 'astragalus'),
    (r'\bastragalum\b', 'astragalus'),
    (r'\bastragalus\b', 'astragalus'),
    (r'\bAstrapen\b', 'Astrape'),
    (r'\bastraque\b', 'astrum'),
    (r'\bastrepit\b', 'astrepo'),
    (r'\bastri\b', 'astrion'),
    (r'\bastricam\b', 'astricus'),
    (r'\bastricen\b', 'astricus'),
    (r'\bastricta\b', 'astringo'),
    (r'\bastrictae\b', 'astringo'),
    (r'\bastrictam\b', 'astringo'),
    (r'\bastrictas\b', 'astringo'),
    (r'\bastricte\b', 'astricte'),
    (r'\bastricte\b', 'astringo'),
    (r'\bastricti\b', 'astringo'),
    (r'\bastrictior\b', 'astringo'),
    (r'\bastrictioris\b', 'astringo'),
    (r'\bastrictis\b', 'astringo'),
    (r'\bastricto\b', 'astringo'),
    (r'\bastrictos\b', 'astringo'),
    (r'\bastrictum\b', 'astringo'),
    (r'\bastrictumque\b', 'astringo'),
    (r'\bastrictus\b', 'astringo'),
    (r'\bastridentibus\b', 'astrido'),
    (r'\bastriferas\b', 'astrifer'),
    (r'\bastriferi\b', 'astrifer'),
    (r'\bastriferis\b', 'astrifer'),
    (r'\bastrifero\b', 'astrifer'),
    (r'\bastriferos\b', 'astrifer'),
    (r'\bastriferum\b', 'astrifer'),
    (r'\bastriferumque\b', 'astrifer'),
    (r'\bastringant\b', 'astringo'),
    (r'\bastringat\b', 'astringo'),
    (r'\bastringatur\b', 'astringo'),
    (r'\bastringe\b', 'astringo'),
    (r'\bastringebam\b', 'astringo'),
    (r'\bastringendam\b', 'astringo'),
    (r'\bastringens\b', 'astringo'),
    (r'\bastringentibus\b', 'astringo'),
    (r'\bastringentis\b', 'astringo'),
    (r'\bastringere\b', 'astringo'),
    (r'\bastringerentur\b', 'astringo'),
    (r'\bastringeret\b', 'astringo'),
    (r'\bastringi\b', 'astringo'),
    (r'\bastringit\b', 'astringo'),
    (r'\bastringor\b', 'astringo'),
    (r'\bastringunt\b', 'astringo'),
    (r'\bastrinxerant\b', 'astringo'),
    (r'\bastrinxere\b', 'astringo'),
    (r'\bastrinxit\b', 'astringo'),
    (r'\bastrion\b', 'astrion'),
    (r'\bastris\b', 'astrum'),
    (r'\bastrisque\b', 'astrum'),
    (r'\bastro\b', 'astrum'),
    (r'\bastrologi\b', 'astrologus'),
    (r'\bastrologia\b', 'astrologia'),
    (r'\bastrologiae\b', 'astrologia'),
    (r'\bastrologiam\b', 'astrologia'),
    (r'\bastrologis\b', 'astrologus'),
    (r'\bastrologo\b', 'astrologus'),
    (r'\bastrologorum\b', 'astrologus'),
    (r'\bastrologos\b', 'astrologus'),
    (r'\bastrologus\b', 'astrologus'),
    (r'\bastron\b', 'astrum'),
    (r'\bastronomicon\b', 'astronomicus'),
    (r'\bastroque\b', 'astrum'),
    (r'\bastrorum\b', 'astrum'),
    (r'\bastrorumque\b', 'astrum'),
    (r'\bastruent\b', 'astruo'),
    (r'\bastruere\b', 'astruo'),
    (r'\bastrueret\b', 'astruo'),
    (r'\bastruit\b', 'astruo'),
    (r'\bastrum\b', 'astrum'),
    (r'\bastrumque\b', 'astrum'),
    (r'\bastu\b', 'astus2'),
    (r'\bastula\b', 'assula'),
    (r'\bastulae\b', 'assula'),
    (r'\bastulas\b', 'assula'),
    (r'\bastulis\b', 'assula'),
    (r'\bastumque\b', 'astus'),
    (r'\bastupet\b', 'astupeo'),
    (r'\bastuque\b', 'astus2'),
    (r'\bastur\b', 'astur1'),
    (r'\bAstur\b', 'Astur2'),
    (r'\bAstura\b', 'Astura'),
    (r'\bAsturae\b', 'Astura'),
    (r'\bAsturam\b', 'Astura'),
    (r'\bAsturamque\b', 'Astura'),
    (r'\bAsturco\b', 'Asturco'),
    (r'\bAsturcone\b', 'Asturco'),
    (r'\bastures\b', 'astur1'),
    (r'\bAstures\b', 'Astur2'),
    (r'\bAsturia\b', 'Asturia'),
    (r'\bAsturiam\b', 'Asturia'),
    (r'\bAsturica\b', 'astus'),
    (r'\bAsturica\b', 'astus'),
    (r'\bAsturici\b', 'astus'),
    (r'\bAsturicum\b', 'astus'),
    (r'\basturum\b', 'astur1'),
    (r'\bAsturum\b', 'Astur2'),
    (r'\bastus\b', 'astus2'),
    (r'\bastus\b', 'astus'),
    (r'\bastusque\b', 'astus2'),
    (r'\bastusque\b', 'astus'),
    (r'\bastuta\b', 'astutus'),
    (r'\bastutae\b', 'astutus'),
    (r'\bastutam\b', 'astutus'),
    (r'\bastute\b', 'astutus'),
    (r'\bastuti\b', 'astutus'),
    (r'\bastutia\b', 'astutia'),
    (r'\bastutiae\b', 'astutia'),
    (r'\bastutiam\b', 'astutia'),
    (r'\bastutiaque\b', 'astutia'),
    (r'\bastutiarum\b', 'astutia'),
    (r'\bastutias\b', 'astutia'),
    (r'\bastutiisque\b', 'astutia'),
    (r'\bastutior\b', 'astutus'),
    (r'\bastutiore\b', 'astutus'),
    (r'\bastutiorem\b', 'astutus'),
    (r'\bastutissime\b', 'astutus'),
    (r'\bastutius\b', 'astutus'),
    (r'\bastuto\b', 'astutus'),
    (r'\bastutos\b', 'astutus'),
    (r'\bastutulae\b', 'astutulus'),
    (r'\bastutule\b', 'astutulus'),
    (r'\bastutulo\b', 'astutulus'),
    (r'\bastutum\b', 'astutus'),
    (r'\bastutumque\b', 'astutus'),
    (r'\bastutus\b', 'astutus'),
    (r'\bAstyage\b', 'Astyages'),
    (r'\bAstyagem\b', 'Astyages'),
    (r'\bAstyagen\b', 'Astyages'),
    (r'\bAstyages\b', 'Astyages'),
    (r'\bAstyanacte\b', 'Astyanax'),
    (r'\bAstyanacti\b', 'Astyanax'),
    (r'\bAstyanactis\b', 'Astyanax'),
    (r'\bAstyanax\b', 'Astyanax'),
    (r'\bAstyanaxque\b', 'Astyanax'),
    (r'\bAstyle\b', 'Astylos'),
    (r'\bAstylon\b', 'Astylos'),
    (r'\bAstypalaea\b', 'Astypalaea'),
    (r'\bAstypalaeam\b', 'Astypalaea'),
    (r'\bAstypalaeicae\b', 'Astypaleius'),
    (r'\bAstypalaeicas\b', 'Astypaleius'),
    (r'\bAstypaleia\b', 'Astypaleius'),
    (r'\bAstyre\b', 'Astyre'),
    (r'\bAstyres\b', 'Astyre'),
    (r'\basueri\b', 'a-sum1'),
    (r'\basuero\b', 'asyla'),
    (r'\bAsum\b', 'a-sum1'),
    (r'\basum\b', 'a-sum1'),
    (r'\bAsuvi\b', 'asyla'),
    (r'\bAsuvianum\b', 'asyla'),
    (r'\bAsuvium\b', 'asyla'),
    (r'\bAsuviumque\b', 'asyla'),
    (r'\bAsuvius\b', 'asyla'),
    (r'\basyla\b', 'asyla'),
    (r'\basyla\b', 'asylum'),
    (r'\basyli\b', 'asylum'),
    (r'\basylo\b', 'asylum'),
    (r'\basylorum\b', 'asylum'),
    (r'\basylum\b', 'asylum'),
    (r'\basymboli\b', 'asymbolus'),
    (r'\basymbolum\b', 'asymbolus'),
    (r'\basyndeton\b', 'asyndeton'),
    (r'\bat\b', 'at'),
    (r'\bAtabuli\b', 'Atabulus'),
    (r'\bAtabulus\b', 'Atabulus'),
    (r'\bAtace\b', 'Atax'),
    (r'\batace\b', 'a-taceo'),
    (r'\bAtacino\b', 'a-taceo'),
    (r'\bAtacinorum\b', 'a-taceo'),
    (r'\bAtacinorum\b', 'a-taceo'),
    (r'\bAtacinus\b', 'a-taceo'),
    (r'\bAtalanta\b', 'Atalanta'),
    (r'\bAtalantae\b', 'Atalanta'),
    (r'\bAtalantaeamque\b', 'Atalantiades'),
    (r'\bAtalantaeas\b', 'Atalantiades'),
    (r'\bAtalantaeos\b', 'Atalantiades'),
    (r'\bAtalantam\b', 'Atalanta'),
    (r'\bAtalante\b', 'Atalanta'),
    (r'\bAtalanten\b', 'Atalanta'),
    (r'\bAtalantes\b', 'Atalanta'),
    (r'\bAtalantiades\b', 'Atalantiades'),
    (r'\bAtarnea\b', 'Atarnea'),
    (r'\bAtarnea\b', 'Atarneus'),
    (r'\bAtarneo\b', 'Atarneus'),
    (r'\bataui\b', 'atavus'),
    (r'\batauia\b', 'atavia'),
    (r'\batauiae\b', 'atavia'),
    (r'\batauiam\b', 'atavia'),
    (r'\batauique\b', 'atavus'),
    (r'\batauis\b', 'atavus'),
    (r'\batauisque\b', 'atavus'),
    (r'\batauo\b', 'atavus'),
    (r'\batauos\b', 'atavus'),
    (r'\batauus\b', 'atavus'),
    (r'\batavi\b', 'atavus'),
    (r'\bataviae\b', 'atavia'),
    (r'\batavique\b', 'atavus'),
    (r'\batavis\b', 'atavus'),
    (r'\batavo\b', 'atavus'),
    (r'\batavos\b', 'atavus'),
    (r'\batavosque\b', 'atavus'),
    (r'\batavum\b', 'atavus'),
    (r'\batavus\b', 'atavus'),
    (r'\bAtax\b', 'Atax'),
    (r'\bAtei\b', 'Atteius'),
    (r'\bAteii\b', 'Atteius'),
    (r'\bAteio\b', 'Atteius'),
    (r'\bAteium\b', 'Atteius'),
    (r'\bAteius\b', 'Atteius'),
    (r'\bAtella\b', 'Atella'),
    (r'\bAtellae\b', 'Atella'),
    (r'\bAtellam\b', 'Atella'),
    (r'\bAtellan\b', 'Atella'),
    (r'\bAtellana\b', 'ater1'),
    (r'\bAtellana\b', 'ater1'),
    (r'\bAtellanae\b', 'ater1'),
    (r'\bAtellanam\b', 'ater1'),
    (r'\bAtellanarum\b', 'ater1'),
    (r'\bAtellanas\b', 'ater1'),
    (r'\bAtellani\b', 'ater1'),
    (r'\bAtellani\b', 'ater1'),
    (r'\bAtellani\b', 'ater1'),
    (r'\bAtellanico\b', 'ater1'),
    (r'\bAtellanicos\b', 'ater1'),
    (r'\bAtellanio\b', 'ater1'),
    (r'\bAtellaniolae\b', 'ater1'),
    (r'\bAtellanis\b', 'ater1'),
    (r'\bAtellanis\b', 'ater1'),
    (r'\bAtellanis\b', 'ater1'),
    (r'\bAtellano\b', 'ater1'),
    (r'\bAtellanos\b', 'ater1'),
    (r'\bAtellaque\b', 'Atella'),
    (r'\bater\b', 'ater1'),
    (r'\batere\b', 'a-tero'),
    (r'\baterne\b', 'ater1'),
    (r'\bAterni\b', 'Aternus'),
    (r'\bAterni\b', 'Aternius'),
    (r'\bAterni\b', 'Aternus'),
    (r'\bAternio\b', 'Aternius'),
    (r'\bAternium\b', 'Aternius'),
    (r'\bAternius\b', 'Aternius'),
    (r'\bAterno\b', 'Aternus'),
    (r'\bAterno\b', 'Aternus'),
    (r'\bAternus\b', 'Aternus'),
    (r'\baterque\b', 'ater1'),
    (r'\bAtesi\b', 'Athesis'),
    (r'\bAteste\b', 'a-tero'),
    (r'\bAtestinae\b', 'Atestinus'),
    (r'\bAtestinus\b', 'Atestinus'),
    (r'\bAthaman\b', 'Athamas'),
    (r'\bAthamana\b', 'Athamas'),
    (r'\bAthamanas\b', 'Athamas'),
    (r'\bAthamanes\b', 'Athamania'),
    (r'\bAthamanesque\b', 'Athamania'),
    (r'\bAthamania\b', 'Athamania'),
    (r'\bAthamaniae\b', 'Athamania'),
    (r'\bAthamaniam\b', 'Athamania'),
    (r'\bAthamanibus\b', 'Athamania'),
    (r'\bAthamante\b', 'Athamas'),
    (r'\bAthamantea\b', 'Athamas'),
    (r'\bAthamantem\b', 'Athamas'),
    (r'\bAthamanteo\b', 'Athamas'),
    (r'\bAthamanteosque\b', 'Athamas'),
    (r'\bAthamanti\b', 'Athamas'),
    (r'\bAthamantiadae\b', 'Athamas'),
    (r'\bAthamantiadesque\b', 'Athamas'),
    (r'\bAthamantico\b', 'Athamas'),
    (r'\bAthamantis\b', 'Athamas'),
    (r'\bAthamantis\b', 'Athamas'),
    (r'\bAthamanum\b', 'Athamania'),
    (r'\bAthamanum\b', 'Athamas'),
    (r'\bAthamanumque\b', 'Athamania'),
    (r'\bAthamanumque\b', 'Athamas'),
    (r'\bAthamas\b', 'Athamas'),
    (r'\bAthanatum\b', 'Athanatus'),
    (r'\bAthen\b', 'Athos'),
    (r'\bAthenae\b', 'Athenae'),
    (r'\bAthenaeis\b', 'Athenaeus1'),
    (r'\bAthenaeis\b', 'Athenaeum'),
    (r'\bAthenaeo\b', 'Athenaeus1'),
    (r'\bAthenaeo\b', 'Athenaeum'),
    (r'\bAthenaeum\b', 'Athenaeus1'),
    (r'\bAthenaeum\b', 'Athenaeum'),
    (r'\bAthenaeus\b', 'Athenaeus1'),
    (r'\bAthenagora\b', 'Atheniensis'),
    (r'\bAthenagorae\b', 'Atheniensis'),
    (r'\bAthenagoram\b', 'Atheniensis'),
    (r'\bAthenagoran\b', 'Atheniensis'),
    (r'\bAthenagoras\b', 'Atheniensis'),
    (r'\bAthenaidis\b', 'Atheniensis'),
    (r'\bAthenarum\b', 'Athenae'),
    (r'\bAthenas\b', 'Athenae'),
    (r'\bAthenasque\b', 'Athenae'),
    (r'\bAtheniense\b', 'Atheniensis'),
    (r'\bAtheniensem\b', 'Atheniensis'),
    (r'\bAthenienses\b', 'Atheniensis'),
    (r'\bAthenienses\b', 'Atheniensis'),
    (r'\bAtheniensesque\b', 'Atheniensis'),
    (r'\bAtheniensesque\b', 'Atheniensis'),
    (r'\bAtheniensi\b', 'Atheniensis'),
    (r'\bAtheniensibus\b', 'Atheniensis'),
    (r'\bAtheniensibus\b', 'Atheniensis'),
    (r'\bAtheniensibusque\b', 'Atheniensis'),
    (r'\bAtheniensibusque\b', 'Atheniensis'),
    (r'\bAtheniensis\b', 'Atheniensis'),
    (r'\bAtheniensis\b', 'Atheniensis'),
    (r'\bAtheniensium\b', 'Atheniensis'),
    (r'\bAtheniensium\b', 'Atheniensis'),
    (r'\bAtheniensiumque\b', 'Atheniensis'),
    (r'\bAtheniensiumque\b', 'Atheniensis'),
    (r'\bAthenin\b', 'Athenae'),
    (r'\bAthenio\b', 'Athenio'),
    (r'\bAthenion\b', 'Athenio'),
    (r'\bAthenione\b', 'Athenio'),
    (r'\bAthenionem\b', 'Athenio'),
    (r'\bAthenionis\b', 'Athenio'),
    (r'\bAthenis\b', 'Athenae'),
    (r'\bAthenisque\b', 'Athenae'),
    (r'\bAthenodoro\b', 'atheos'),
    (r'\bAthenodorum\b', 'atheos'),
    (r'\bAthenodorus\b', 'atheos'),
    (r'\batheos\b', 'atheos'),
    (r'\bathera\b', 'athera'),
    (r'\batheram\b', 'athera'),
    (r'\bAtheriani\b', 'Atherianus'),
    (r'\batheromata\b', 'atheroma'),
    (r'\batheromati\b', 'atheroma'),
    (r'\bAthesi\b', 'Athesis'),
    (r'\bAthesim\b', 'Athesis'),
    (r'\bAthesin\b', 'Athesis'),
    (r'\bAthesis\b', 'Athesis'),
    (r'\bAthin\b', 'Athos'),
    (r'\bAthin\b', 'Athis'),
    (r'\bAthis\b', 'Athos'),
    (r'\bAthis\b', 'Athis'),
    (r'\bathla\b', 'athla'),
    (r'\bathla\b', 'athlon'),
    (r'\bathleta\b', 'athleta'),
    (r'\bathletae\b', 'athleta'),
    (r'\bathletam\b', 'athleta'),
    (r'\bathletarum\b', 'athleta'),
    (r'\bathletas\b', 'athleta'),
    (r'\bathletasque\b', 'athleta'),
    (r'\bathleticae\b', 'athletica'),
    (r'\bathleticam\b', 'athletica'),
    (r'\bathletice\b', 'athleticus'),
    (r'\bathletici\b', 'athleticus'),
    (r'\bathletico\b', 'athleticus'),
    (r'\bathletis\b', 'athleta'),
    (r'\bathletisque\b', 'athleta'),
    (r'\bathlis\b', 'athla'),
    (r'\bathlis\b', 'athlon'),
    (r'\bathlo\b', 'athlon'),
    (r'\bAtho\b', 'Athos'),
    (r'\bAthon\b', 'Athos'),
    (r'\bAthone\b', 'Athos'),
    (r'\bAthos\b', 'Athos'),
    (r'\bAti\b', 'Atius'),
    (r'\bAtia\b', 'Atilianus'),
    (r'\bAtia\b', 'Atius'),
    (r'\bAtiae\b', 'Atilianus'),
    (r'\bAtiam\b', 'Atilianus'),
    (r'\bAtidio\b', 'Atilianus'),
    (r'\bAtidium\b', 'Atilianus'),
    (r'\bAtidius\b', 'Atilianus'),
    (r'\bAtii\b', 'Atius'),
    (r'\bAtili\b', 'Atilius'),
    (r'\bAtilia\b', 'Atilius'),
    (r'\bAtilianae\b', 'Atilianus'),
    (r'\bAtiliano\b', 'Atilianus'),
    (r'\bAtilianorum\b', 'Atilianus'),
    (r'\bAtilianos\b', 'Atilianus'),
    (r'\bAtilianus\b', 'Atilianus'),
    (r'\bAtilii\b', 'Atilius'),
    (r'\bAtilio\b', 'Atilius'),
    (r'\bAtilioque\b', 'Atilius'),
    (r'\bAtilios\b', 'Atilius'),
    (r'\bAtilium\b', 'Atilius'),
    (r'\bAtilius\b', 'Atilius'),
    (r'\batimeto\b', 'a-timeo'),
    (r'\bAtin\b', 'Atius'),
    (r'\bAtina\b', 'a-timeo'),
    (r'\batina\b', 'a-tineo'),
    (r'\bAtinae\b', 'a-timeo'),
    (r'\bAtinam\b', 'a-timeo'),
    (r'\bAtinas\b', 'a-timeo'),
    (r'\bAtinas\b', 'a-tineo'),
    (r'\batinas\b', 'a-tineo'),
    (r'\bAtinate\b', 'a-tineo'),
    (r'\batinate\b', 'a-tineo'),
    (r'\bAtinatem\b', 'a-tineo'),
    (r'\bAtinates\b', 'a-tineo'),
    (r'\bAtinates\b', 'a-tineo'),
    (r'\bAtinati\b', 'a-tineo'),
    (r'\batinati\b', 'a-tineo'),
    (r'\bAtinatibus\b', 'a-tineo'),
    (r'\bAtinatibus\b', 'a-tineo'),
    (r'\bAtinatis\b', 'a-tineo'),
    (r'\bAtinatis\b', 'a-tineo'),
    (r'\batinatis\b', 'a-tineo'),
    (r'\bAtini\b', 'Atinius'),
    (r'\batini\b', 'ater1'),
    (r'\bAtinia\b', 'Atinius'),
    (r'\bAtiniae\b', 'Atinius'),
    (r'\bAtiniam\b', 'Atinius'),
    (r'\bAtiniarum\b', 'Atinius'),
    (r'\bAtinias\b', 'Atinius'),
    (r'\bAtinii\b', 'Atinius'),
    (r'\bAtinio\b', 'Atinius'),
    (r'\bAtinios\b', 'Atinius'),
    (r'\bAtinium\b', 'Atinius'),
    (r'\bAtinius\b', 'Atinius'),
    (r'\bAtintania\b', 'Atintania'),
    (r'\bAtio\b', 'Atius'),
    (r'\bAtium\b', 'Atius'),
    (r'\bAtius\b', 'Atius'),
    (r'\batizoe\b', 'atizoe'),
    (r'\batizoen\b', 'atizoe'),
    (r'\bAtlante\b', 'Atlas'),
    (r'\bAtlanteas\b', 'Atlanticus'),
    (r'\bAtlantem\b', 'Atlas'),
    (r'\bAtlanteo\b', 'Atlanticus'),
    (r'\bAtlantes\b', 'Atlanticus'),
    (r'\bAtlanteum\b', 'Atlanticus'),
    (r'\bAtlanteusque\b', 'Atlanticus'),
    (r'\bAtlanti\b', 'Atlas'),
    (r'\bAtlanti\b', 'Atlas'),
    (r'\batlanti\b', 'atlantion'),
    (r'\batlantia\b', 'atlantion'),
    (r'\bAtlantiaci\b', 'Atlanticus'),
    (r'\bAtlantiaco\b', 'Atlanticus'),
    (r'\bAtlantiademque\b', 'Atlanticus'),
    (r'\batlantiademque\b', 'atlantion'),
    (r'\bAtlantiades\b', 'Atlanticus'),
    (r'\bAtlantiades\b', 'Atlanticus'),
    (r'\bAtlantiadum\b', 'Atlanticus'),
    (r'\bAtlantica\b', 'Atlanticus'),
    (r'\bAtlantici\b', 'Atlanticus'),
    (r'\bAtlantico\b', 'Atlanticus'),
    (r'\bAtlanticum\b', 'Atlanticus'),
    (r'\bAtlanticus\b', 'Atlanticus'),
    (r'\bAtlantide\b', 'Atlas'),
    (r'\bAtlantidem\b', 'Atlas'),
    (r'\batlantidem\b', 'atlantion'),
    (r'\bAtlantides\b', 'Atlas'),
    (r'\bAtlantidibus\b', 'Atlas'),
    (r'\bAtlantidis\b', 'Atlas'),
    (r'\bAtlantidum\b', 'Atlas'),
    (r'\bAtlantion\b', 'Atlas'),
    (r'\batlantion\b', 'atlantion'),
    (r'\bAtlantis\b', 'Atlas'),
    (r'\bAtlantis\b', 'Atlas'),
    (r'\bAtlantius\b', 'Atlas'),
    (r'\bAtlas\b', 'Atlas'),
    (r'\batnepos\b', 'adnepos'),
    (r'\batneptis\b', 'adneptis'),
    (r'\batocio\b', 'atocium'),
    (r'\batomi\b', 'atomus'),
    (r'\batomis\b', 'atomus'),
    (r'\batomo\b', 'atomus'),
    (r'\batomorum\b', 'atomus'),
    (r'\batomos\b', 'atomus'),
    (r'\batomum\b', 'atomus'),
    (r'\batomus\b', 'atomus'),
    (r'\batque\b', 'atque'),
    (r'\batqui\b', 'atqui'),
    (r'\batquin\b', 'atqui'),
    (r'\batra\b', 'ater1'),
    (r'\bAtracia\b', 'atractylis'),
    (r'\bAtracides\b', 'atractylis'),
    (r'\bAtracides\b', 'Atracides'),
    (r'\bAtracio\b', 'atractylis'),
    (r'\bAtracis\b', 'atractylis'),
    (r'\batractylide\b', 'atractylis'),
    (r'\batractylis\b', 'atractylis'),
    (r'\batrae\b', 'ater1'),
    (r'\batraeque\b', 'ater1'),
    (r'\batram\b', 'ater1'),
    (r'\batramenta\b', 'atramentum'),
    (r'\batramentarium\b', 'atramentarium'),
    (r'\batramenti\b', 'atramentum'),
    (r'\batramento\b', 'atramentum'),
    (r'\batramentum\b', 'atramentum'),
    (r'\bAtramitae\b', 'Atramitae'),
    (r'\bAtramitica\b', 'Atratinus'),
    (r'\bAtramitis\b', 'Atramitae'),
    (r'\batramque\b', 'ater1'),
    (r'\batraque\b', 'ater1'),
    (r'\batras\b', 'ater1'),
    (r'\bAtratine\b', 'Atratinus'),
    (r'\bAtratini\b', 'Atratinus'),
    (r'\bAtratino\b', 'Atratinus'),
    (r'\bAtratinum\b', 'Atratinus'),
    (r'\bAtratinus\b', 'Atratinus'),
    (r'\bAtratum\b', 'Atratus2'),
    (r'\bAtratus\b', 'Atratus2'),
    (r'\batre\b', 'ater1'),
    (r'\bAtrea\b', 'Atreus'),
    (r'\bAtrebates\b', 'Atrebates'),
    (r'\bAtrebatibus\b', 'Atrebates'),
    (r'\bAtrei\b', 'Atreus'),
    (r'\bAtrei\b', 'Atreus'),
    (r'\bAtreias\b', 'Atreus'),
    (r'\bAtreis\b', 'Atreus'),
    (r'\bAtreius\b', 'Atreus'),
    (r'\bAtreo\b', 'Atreus'),
    (r'\bAtreu\b', 'Atreus'),
    (r'\bAtreum\b', 'Atreus'),
    (r'\bAtreus\b', 'Atreus'),
    (r'\batri\b', 'ater1'),
    (r'\batria\b', 'atrium'),
    (r'\batriaque\b', 'atrium'),
    (r'\batriarii\b', 'atriarius'),
    (r'\bAtrida\b', 'Atrides'),
    (r'\bAtridae\b', 'Atrides'),
    (r'\bAtridam\b', 'Atrides'),
    (r'\bAtridarum\b', 'Atrides'),
    (r'\bAtridas\b', 'Atrides'),
    (r'\bAtride\b', 'Atrides'),
    (r'\bAtriden\b', 'Atrides'),
    (r'\bAtrides\b', 'Atrides'),
    (r'\bAtridis\b', 'Atrides'),
    (r'\batriense\b', 'atriensis'),
    (r'\batriensem\b', 'atriensis'),
    (r'\batrienses\b', 'atriensis'),
    (r'\batriensi\b', 'atriensis'),
    (r'\batriensibus\b', 'atriensis'),
    (r'\batriensis\b', 'atriensis'),
    (r'\batriensium\b', 'atriensis'),
    (r'\batrii\b', 'atrium'),
    (r'\bAtriis\b', 'Atrius'),
    (r'\batriis\b', 'atrium'),
    (r'\batrine\b', 'ater1'),
    (r'\bAtrine\b', 'Atrius'),
    (r'\bAtrio\b', 'Atrius'),
    (r'\batrio\b', 'atrium'),
    (r'\batriola\b', 'atriolum'),
    (r'\batrioli\b', 'atriolum'),
    (r'\batriolo\b', 'atriolum'),
    (r'\batriolum\b', 'atriolum'),
    (r'\bAtrion\b', 'Atrius'),
    (r'\batrion\b', 'atrium'),
    (r'\batrior\b', 'ater1'),
    (r'\batriorum\b', 'ater1'),
    (r'\bAtriorum\b', 'Atrius'),
    (r'\batriorum\b', 'atrium'),
    (r'\batris\b', 'ater1'),
    (r'\batrisque\b', 'ater1'),
    (r'\batritate\b', 'atritas'),
    (r'\batriue\b', 'ater1'),
    (r'\bAtrium\b', 'Atrius'),
    (r'\batrium\b', 'atrium'),
    (r'\batrius\b', 'ater1'),
    (r'\bAtrius\b', 'Atrius'),
    (r'\batriusque\b', 'ater1'),
    (r'\batro\b', 'ater1'),
    (r'\batrocem\b', 'atrox'),
    (r'\batrocemque\b', 'atrox'),
    (r'\batroces\b', 'atrox'),
    (r'\batroci\b', 'atrox'),
    (r'\batrocibus\b', 'atrox'),
    (r'\batrocior\b', 'atrox'),
    (r'\batrociora\b', 'atrox'),
    (r'\batrociore\b', 'atrox'),
    (r'\batrociorem\b', 'atrox'),
    (r'\batrocioremque\b', 'atrox'),
    (r'\batrociores\b', 'atrox'),
    (r'\batrocioribus\b', 'atrox'),
    (r'\batrocioribusque\b', 'atrox'),
    (r'\batrocique\b', 'atrox'),
    (r'\batrocis\b', 'atrox'),
    (r'\batrocissima\b', 'atrox'),
    (r'\batrocissimae\b', 'atrox'),
    (r'\batrocissimam\b', 'atrox'),
    (r'\batrocissimas\b', 'atrox'),
    (r'\batrocissime\b', 'atrox'),
    (r'\batrocissimi\b', 'atrox'),
    (r'\batrocissimis\b', 'atrox'),
    (r'\batrocissimo\b', 'atrox'),
    (r'\batrocissimos\b', 'atrox'),
    (r'\batrocissimum\b', 'atrox'),
    (r'\batrocissimus\b', 'atrox'),
    (r'\batrocitas\b', 'atrocitas'),
    (r'\batrocitate\b', 'atrocitas'),
    (r'\batrocitatem\b', 'atrocitas'),
    (r'\batrocitatemque\b', 'atrocitas'),
    (r'\batrocitati\b', 'atrocitas'),
    (r'\batrocitatibus\b', 'atrocitas'),
    (r'\batrocitatis\b', 'atrocitas'),
    (r'\batrociter\b', 'atrociter'),
    (r'\batrocius\b', 'atrox'),
    (r'\batropha\b', 'atrophus'),
    (r'\batrophis\b', 'atrophus'),
    (r'\batrophos\b', 'atrophus'),
    (r'\bAtropos\b', 'Atropos'),
    (r'\batroque\b', 'ater1'),
    (r'\batrorum\b', 'ater1'),
    (r'\batros\b', 'ater1'),
    (r'\batrox\b', 'atrox'),
    (r'\batroxque\b', 'atrox'),
    (r'\batrum\b', 'ater1'),
    (r'\batrumque\b', 'ater1'),
    (r'\batrumst\b', 'ater1'),
    (r'\bAtta\b', 'Atta2'),
    (r'\battacorum\b', 'attacus'),
    (r'\battactam\b', 'attingo'),
    (r'\battacti\b', 'attingo'),
    (r'\battactu\b', 'attactus2'),
    (r'\battactu\b', 'attingo'),
    (r'\battactum\b', 'attactus2'),
    (r'\battactum\b', 'attingo'),
    (r'\battactumque\b', 'attactus2'),
    (r'\battactumque\b', 'attingo'),
    (r'\battactus\b', 'attactus2'),
    (r'\battactus\b', 'attingo'),
    (r'\battacus\b', 'attacus'),
    (r'\bAttae\b', 'Atta2'),
    (r'\battagen\b', 'attagus'),
    (r'\battagena\b', 'attagus'),
    (r'\battagenae\b', 'attagus'),
    (r'\battagenam\b', 'attagus'),
    (r'\battagenarum\b', 'attagus'),
    (r'\battagenas\b', 'attagus'),
    (r'\bAttale\b', 'Attalus'),
    (r'\bAttalenses\b', 'Attalenses'),
    (r'\bAttalensium\b', 'Attalenses'),
    (r'\bAttali\b', 'Attalus'),
    (r'\bAttaliam\b', 'Attalea'),
    (r'\bAttalica\b', 'Attalis'),
    (r'\bAttalica\b', 'Attalis'),
    (r'\bAttalicas\b', 'Attalis'),
    (r'\bAttalici\b', 'Attalis'),
    (r'\bAttalicis\b', 'Attalis'),
    (r'\bAttalicis\b', 'Attalis'),
    (r'\bAttalico\b', 'Attalis'),
    (r'\bAttalicos\b', 'Attalis'),
    (r'\bAttalique\b', 'Attalus'),
    (r'\bAttalis\b', 'Attalis'),
    (r'\bAttalis\b', 'Attalus'),
    (r'\bAttalo\b', 'Attalus'),
    (r'\bAttalum\b', 'Attalus'),
    (r'\bAttalumque\b', 'Attalus'),
    (r'\bAttalus\b', 'Attalus'),
    (r'\bAttalusque\b', 'Attalus'),
    (r'\bAttalusue\b', 'Attalus'),
    (r'\bAttam\b', 'Atta2'),
    (r'\battaminare\b', 'attamino'),
    (r'\battaminatus\b', 'attamino'),
    (r'\battaminent\b', 'attamino'),
    (r'\battat\b', 'attat'),
    (r'\battegias\b', 'attegia'),
    (r'\battemperata\b', 'attempero'),
    (r'\battemptantem\b', 'attento'),
    (r'\battemptare\b', 'attento'),
    (r'\battemptas\b', 'attento'),
    (r'\battemptasse\b', 'ad-tumulo'),
    (r'\battemptat\b', 'attento'),
    (r'\battemptata\b', 'ad-tumulo'),
    (r'\battemptaverit\b', 'ad-tumulo'),
    (r'\battemptentur\b', 'attento'),
    (r'\battendam\b', 'attendo'),
    (r'\battendamus\b', 'attendo'),
    (r'\battendant\b', 'attendo'),
    (r'\battendas\b', 'attendo'),
    (r'\battendatis\b', 'attendo'),
    (r'\battendatque\b', 'attendo'),
    (r'\battende\b', 'attendo'),
    (r'\battendebat\b', 'attendo'),
    (r'\battendemus\b', 'attendo'),
    (r'\battendenda\b', 'attendo'),
    (r'\battendendum\b', 'attendo'),
    (r'\battendendus\b', 'attendo'),
    (r'\battendens\b', 'attendo'),
    (r'\battendente\b', 'attendo'),
    (r'\battendentem\b', 'attendo'),
    (r'\battendentibus\b', 'attendo'),
    (r'\battendentium\b', 'attendo'),
    (r'\battendere\b', 'attendo'),
    (r'\battenderem\b', 'attendo'),
    (r'\battenderes\b', 'attendo'),
    (r'\battenderet\b', 'attendo'),
    (r'\battenderim\b', 'attendo'),
    (r'\battenderis\b', 'attendo'),
    (r'\battenderit\b', 'attendo'),
    (r'\battenderunt\b', 'attendo'),
    (r'\battendes\b', 'attendo'),
    (r'\battendetis\b', 'attendo'),
    (r'\battendi\b', 'attendo'),
    (r'\battendimus\b', 'attendo'),
    (r'\battendis\b', 'attendo'),
    (r'\battendisset\b', 'attendo'),
    (r'\battendisti\b', 'attendo'),
    (r'\battendistis\b', 'attendo'),
    (r'\battendit\b', 'attendo'),
    (r'\battendite\b', 'attendo'),
    (r'\battenditis\b', 'attendo'),
    (r'\battenditur\b', 'attendo'),
    (r'\battendo\b', 'attendo'),
    (r'\battendoque\b', 'attendo'),
    (r'\battendunt\b', 'attendo'),
    (r'\battenduntur\b', 'attendo'),
    (r'\battene\b', 'ad-tumulo'),
    (r'\battentae\b', 'attendo'),
    (r'\battentam\b', 'attendo'),
    (r'\battentarit\b', 'ad-tumulo'),
    (r'\battentas\b', 'attendo'),
    (r'\battentas\b', 'attento'),
    (r'\battentavit\b', 'ad-tumulo'),
    (r'\battente\b', 'attendo'),
    (r'\battenteque\b', 'attendo'),
    (r'\battenti\b', 'attendo'),
    (r'\battentio\b', 'attentio'),
    (r'\battentione\b', 'attentio'),
    (r'\battentionem\b', 'attentio'),
    (r'\battentionis\b', 'attentio'),
    (r'\battentior\b', 'attendo'),
    (r'\battentiore\b', 'attendo'),
    (r'\battentiorem\b', 'attendo'),
    (r'\battentis\b', 'attendo'),
    (r'\battentissima\b', 'attendo'),
    (r'\battentissime\b', 'attendo'),
    (r'\battentissimis\b', 'attendo'),
    (r'\battentius\b', 'attendo'),
    (r'\battento\b', 'attendo'),
    (r'\battento\b', 'attento'),
    (r'\battentos\b', 'attendo'),
    (r'\battentum\b', 'attendo'),
    (r'\battentus\b', 'attendo'),
    (r'\battentusque\b', 'attendo'),
    (r'\battenuansque\b', 'attenuo'),
    (r'\battenuant\b', 'attenuo'),
    (r'\battenuantur\b', 'attenuo'),
    (r'\battenuarat\b', 'ad-tumulo'),
    (r'\battenuare\b', 'attenuo'),
    (r'\battenuaret\b', 'attenuo'),
    (r'\battenuari\b', 'attenuo'),
    (r'\battenuasse\b', 'ad-tumulo'),
    (r'\battenuat\b', 'attenuo'),
    (r'\battenuata\b', 'ad-tumulo'),
    (r'\battenuatae\b', 'ad-tumulo'),
    (r'\battenuatas\b', 'ad-tumulo'),
    (r'\battenuate\b', 'attenuate'),
    (r'\battenuate\b', 'attenuo'),
    (r'\battenuati\b', 'ad-tumulo'),
    (r'\battenuatio\b', 'attenuatio'),
    (r'\battenuatione\b', 'attenuatio'),
    (r'\battenuatis\b', 'attenuo'),
    (r'\battenuatissima\b', 'ad-tumulo'),
    (r'\battenuatissimae\b', 'ad-tumulo'),
    (r'\battenuatum\b', 'ad-tumulo'),
    (r'\battenuatus\b', 'ad-tumulo'),
    (r'\battenuet\b', 'attenuo'),
    (r'\batteram\b', 'attero'),
    (r'\batterantur\b', 'attero'),
    (r'\batterat\b', 'attero'),
    (r'\batteratur\b', 'attero'),
    (r'\batterebantur\b', 'attero'),
    (r'\batterebatur\b', 'attero'),
    (r'\batterendi\b', 'attero'),
    (r'\batterens\b', 'attero'),
    (r'\batterente\b', 'attero'),
    (r'\batterere\b', 'attero'),
    (r'\batteret\b', 'attero'),
    (r'\batteri\b', 'attero'),
    (r'\batterit\b', 'attero'),
    (r'\batteritur\b', 'attero'),
    (r'\batterranea\b', 'atterraneus'),
    (r'\batterunt\b', 'attero'),
    (r'\batteruntur\b', 'attero'),
    (r'\battestata\b', 'attestor'),
    (r'\battestatur\b', 'attestor'),
    (r'\battexitote\b', 'attexo'),
    (r'\battexuntur\b', 'attexo'),
    (r'\bAtthide\b', 'Atthis'),
    (r'\bAtthidem\b', 'Atthis'),
    (r'\bAtthides\b', 'Atthis'),
    (r'\bAtthidum\b', 'Atthis'),
    (r'\bAtthis\b', 'Atthis'),
    (r'\bAtti\b', 'Attius'),
    (r'\bAttianae\b', 'Attianus'),
    (r'\bAttiani\b', 'Attianus'),
    (r'\bAttiano\b', 'Attianus'),
    (r'\bAttianorum\b', 'Attianus'),
