#!/usr/bin/env python
# -*- coding: iso-8859-1 -*-

'''Extension for Python-Markdown implementing advanced punctuation'''

import markdown

class PunctuationPattern(markdown.inlinepatterns.Pattern):
    def __init__(self, pattern, entity, markdown_instance=None):
        '''Initializes the Pattern object for replacing punctuation'''
        markdown.inlinepatterns.Pattern.__init__(self, pattern, markdown_instance)
        self.entity = entity

    def handleMatch(self, m):
        '''Handles a match for the LaTeX pattern found by Markdown's processor.

        @param m the regular expression match for the line on which the pattern was
        found. m contains one capturing group before the part that matched this
        pattern and one after.'''
        return self.markdown.htmlStash.store(self.entity)

class PunctuationExtension(markdown.Extension):
    '''The actual extension class.'''
    def extendMarkdown(self, md, md_globals):
        md.inlinePatterns['mdash'] = PunctuationPattern(r'---', '&mdash;', md)
        md.inlinePatterns['ndash'] = PunctuationPattern(r'--', '&ndash;', md)

def makeExtension(config):
    '''Returns an instance of the extension.'''
    return PunctuationExtension(config)
