#!/usr/bin/env python3

# This is the code example used in the tutorial. It shows how to define and
# manipulate polyhedra.

import code


class InteractiveConsole(code.InteractiveConsole):
    def push(self, line=''):
        if line:
            print('>>>', line)
            return super().push(line)
        else:
            print()


if __name__ == '__main__':

    shell = InteractiveConsole()

    shell.push('from linpy import *')
    shell.push("x, y = symbols('x y')")
    shell.push()

    shell.push('square1 = Le(0, x, 2) & Le(0, y, 2)')
    shell.push('square1')
    shell.push()

    shell.push("square2 = Polyhedron('1 <= x <= 3, 1 <= y <= 3')")
    shell.push('square2')
    shell.push()

    shell.push('inter = square1.intersection(square2) # or square1 & square2')
    shell.push('inter')
    shell.push()

    shell.push('hull = square1.convex_union(square2)')
    shell.push('hull')
    shell.push()

    shell.push('proj = square1.project([y])')
    shell.push('proj')
    shell.push()

    shell.push('inter <= square1')
    shell.push('inter == Empty')
    shell.push()

    shell.push('union = square1.union(square2) # or square1 | square2')
    shell.push('union')
    shell.push('union <= hull')
    shell.push()

    shell.push('diff = square1.difference(square2) # or square1 - square2')
    shell.push('diff')
    shell.push('~square1')
