#!/usr/bin/env python3

# In geometry, the tesseract is the four-dimensional analog of the cube; the
# tesseract is to the cube as the cube is to the square. Just as the surface of
# the cube consists of 6 square faces, the hypersurface of the tesseract
# consists of 8 cubical cells.

from linpy import *


x, y, z, t = symbols('x y z t')

tesseract = Le(0, x, 1) & Le(0, y, 1) & Le(0, z, 1) & Le(0, t, 1)

def faces(polyhedron):
    for points in polyhedron.faces():
        face = points[0].aspolyhedron()
        face = face.convex_union(*[point.aspolyhedron() for point in points[1:]])
        yield face

if __name__ == '__main__':
    print('Faces of tesseract\n\n  {}\n\nare:\n'.format(tesseract))
    for face in faces(tesseract):
        assert(len(face.vertices()) == 8)
        print('  {}'.format(face))
