import time
import logging


__LOGGER__ = logging.getLogger(__name__)


class Timer(object):
    def __init__(self, verbose=False):
        self.verbose = verbose

    def __enter__(self):
        self.start = time.time()
        return self

    def __exit__(self, *args):
        self.end = time.time()
        self.secs = self.end - self.start
        self.msecs = self.secs * 1000  # millisecs
        if self.verbose:
            __LOGGER__.debug('elapsed time: %f ms' % self.msecs)
