"""
This module defines the CustomQueryPredictiveObject class that allows wrapping of
one or many GraphLab data structures and additional functionality within a
predictive object, which can be deployed into a Predicitve Service.
"""

import types as _types
from _predictive_object import PredictiveObject as _PredictiveObject

class CustomQueryPredictiveObject(_PredictiveObject):
    '''
    CustomQueryPredictiveObjects are intended to facilitate deployment of 
    GraphLab data structures with additional custom query logic.

    Using a CustomQueryPredictiveObject you can include multiple GraphLab
    objects and embed more complex logic on top of those objects. Use the
    set_query method to bind a custom query function to a
    CustomQueryPredictiveObject instance. Use the dependencies attribute to
    include multiple GraphLab data structures.
    '''
    def __init__(self, description =  None):
        super(CustomQueryPredictiveObject, self).__init__(description)

    def query(self, input):
        '''Query the model according to input

        Query the model according to the method and query data specified in the
        input. You must set the query function using the `set_query` method
        before calling this. If query has not been set, this call will result in
        a no-op.

        Parameters
        ----------
        input : dict
            a dictionary that needs to have the following two keys:
                'method' : can be either 'predict' or 'recommend'
                'data' : the actual data that is used to query the model. In the
                 form of dictionary, which matches the actual method signature

        Returns
        -------
        out: object.
            Typically, the results will be a list or dict, but the result could
            be any type, depending on the implementation of the query method. If
            the method returns SFrame, out should be converted to a dict, and if
            model method returns SArray, out should be converted to a list.

        See Also
        --------
        PredictiveObject, ModelPredictiveObject
        '''
        pass

    def set_query(self, function):
        '''Set the query method for the predictive object.

        Parameters
        ----------
        function : a function
            function is expected to take two parameters, the first which will be
            bound to the instance (self), and the second should be a dictionary.
            How you process the input is up to you.
        '''
        assert(isinstance(function, _types.FunctionType))
        self.query = _types.MethodType(function, self)
