from graphlab.canvas.views.bivariate import BivariateView as _bivariate

class BarGraphView(_bivariate):

    def __init__(self, obj, params):
        super(BarGraphView, self).__init__(obj, params)
        self.col1 = self.get_column('x')
        self.col2 = self.get_numeric_column('y', self.col1)

    def __get_values(self):
        if self.col1 is None or \
           self.col2 is None:
            return []
        categoricalList = list(self.obj[self.col1])
        numericalList = list(self.obj[self.col2])
        barData = []
        for i in range(0, len(categoricalList)):
            barData.append({'name': str(categoricalList[i]), 'value':numericalList[i]})
        return barData

    def _get_values(self, url, handler):
        handler.write({"data": self.__get_values()})

    def __get_extrema(self):
        if self.col1 is None or \
           self.col2 is None:
            return {}
        maximum = self.obj[self.col2].max()
        minimum = self.obj[self.col2].min()
        return {'max': maximum, 'min': minimum}

    def _get_extrema(self, url, handler):
        handler.write(self.__get_extrema())

    def get_staticdata(self):
        if len(self.obj) > 100:
            return {}
        return {
            'barData': self.__get_values(),
            'extrema': self.__get_extrema()
        }
