"use strict";define("task",["react","d3","dagre","common_util","taskqueue","common_controls","logging"],function(React,d3,_dagre,Util,TaskQueue,Controls,Logging){var vertexWidth=60;var vertexHeight=15;var vertexStageHeight=10;var polygonSide=6;var StageCodeView=React.createClass({displayName:"StageCodeView",componentDidMount:function(){var node=this.getDOMNode()},shouldComponentUpdate:function(){return false},render:function(){var code=this.props.code;return React.DOM.pre(null,React.DOM.code(null,code))}});function constructTaskJSON(inputs,params,outputs){var graphJSON={};var nodesJSON=[];var linksJSON=[];var stageNode={};stageNode["name"]="Stage";stageNode["color"]="#b0007f";stageNode["node"]="none";nodesJSON.push(stageNode);var preNode={};preNode["name"]="preStage";preNode["node"]="none";nodesJSON.push(preNode);var preLink={};preLink["source"]="preStage";preLink["target"]="Stage";linksJSON.push(preLink);var postNode={};postNode["name"]="postStage";postNode["node"]="none";nodesJSON.push(postNode);var postLink={};postLink["source"]="Stage";postLink["target"]="postStage";linksJSON.push(postLink);for(var key in inputs){var inputsNode={};inputsNode["name"]=key;inputsNode["color"]="#0a8cc4";inputsNode["node"]="input";nodesJSON.push(inputsNode);var linkNode={};linkNode["source"]=key;linkNode["target"]="preStage";linksJSON.push(linkNode)}for(var key in params){var paramNode={};paramNode["name"]=key;paramNode["color"]="#85bd00";paramNode["node"]="param";nodesJSON.push(paramNode);var linkNode={};linkNode["source"]=key;linkNode["target"]="preStage";linksJSON.push(linkNode)}for(var key in outputs){var outputNode={};outputNode["name"]=key;outputNode["color"]="#0a8cc4";outputNode["node"]="output";nodesJSON.push(outputNode);var linkNode={};linkNode["source"]="postStage";linkNode["target"]=key;linksJSON.push(linkNode)}graphJSON["nodes"]=nodesJSON;graphJSON["links"]=linksJSON;return graphJSON}var GraphLayout=React.createClass({displayName:"GraphLayout",layout:function(){var layoutFn=Util.dagreLayout;return layoutFn(this.props.vertices,this.props.edges,vertexWidth,vertexHeight,20,-1,"LR")},getMax:function(vertices){var max_ip=0;var max_o=0;for(var i=0;i<vertices.length;i++){if(vertices[i].node=="input"||vertices[i].node=="param"){max_ip=max_ip+1}else if(vertices[i].node=="output"){max_o=max_o+1}}return Math.max(max_ip,max_o)},getBreaks:function(max_height){if(max_height<100){return React.DOM.div(null,React.DOM.br(null),React.DOM.br(null),React.DOM.br(null))}else{return React.DOM.div(null)}},render:function(){var graph=this.layout();var max_y=this.getMax(this.props.vertices);var max_height=-90+max_y*165;var scaleToAxis=function(axis){var vertexSize=axis=="x"?vertexWidth:vertexHeight;var idx=axis=="x"?0:1;var scaleMax=axis=="x"?500:max_height;var valuesMin=graph.edges.map(function(e){return d3.min(e.points.map(function(p){return p[idx]}))-vertexSize});var valuesMax=graph.edges.map(function(e){return d3.max(e.points.map(function(p){return p[idx]}))+vertexSize});return d3.scale.linear().domain([d3.min(valuesMin),d3.max(valuesMax)]).range([0,scaleMax])};var scaleX=scaleToAxis("x");var scaleY=scaleToAxis("y");return React.DOM.div(null,this.getBreaks(max_height),React.DOM.svg({width:500,height:max_height},graph.edges.map(function(e,idx){var ret=[];var p1=[];var p2=[];for(var i=0;i<e.points.length-1;i++){p1=e.points[i];p2=e.points[i+1];var color="#000";if(e.source=="postStage"||e.target=="preStage"){color="#0a8cc4"}ret.push(React.DOM.line({x1:scaleX(p1[0]),y1:scaleY(p1[1]),x2:scaleX(p2[0]),y2:scaleY(p2[1]),stroke:color,strokeWidth:1,key:e.source+"__"+e.target+i+"_"+idx}))}if(e.target=="Stage"||e.source=="postStage"){var slope=0;var b=0;var points="";if(p2[0]!=p1[0]){slope=(p2[1]-p1[1])/(p2[0]-p1[0]);b=p2[1]-p2[0]*slope}if(slope==0){p2[0]=p2[0]-vertexWidth/2;var points=scaleX(p2[0])+","+scaleY(p2[1])+" "+scaleX(p2[0]-polygonSide)+","+scaleY(p2[1]+polygonSide/8)+" "+scaleX(p2[0]-polygonSide)+","+scaleY(p2[1]-polygonSide/8)}ret.push(React.DOM.polygon({points:points,stroke:"#000",strokeWidth:1,key:e.target+"_"+e.source+"_ar_"+idx}))}return ret}.bind(this)),graph.vertices.map(function(n,idx){var ret=[];var x1=scaleX(n.x-vertexWidth/2);var y1=scaleY(n.y-vertexHeight/2);var x2=scaleX(n.x+vertexWidth/2);var y2=scaleY(n.y+vertexHeight/2);var style={"font-size":"12","font-weight":"400"};var name=n.name;if(name=="preStage"||name=="postStage"){return ret}Util.assert(x1>=0);Util.assert(y1>=0);Util.assert(x2<=500);ret.push(React.DOM.rect({width:x2-x1,height:y2-y1,x:x1,y:y1,stroke:"#000",strokeWidth:0,fill:n.color,key:n.name+"_"+idx}));var end_x2=x2-.25;var points=end_x2+","+y1+" "+end_x2+","+y2+" "+(end_x2+15)+","+scaleY(n.y);ret.push(React.DOM.polygon({points:points,fill:n.color,stroke:n.color,key:n.name+"_p_"+idx}));if(name=="Stage"){name="Code";style={fill:"#fff","font-size":"16"};y2=y1+vertexStageHeight;x1=x1+9}ret.push(React.DOM.text({x:x1+3,y:y2+vertexHeight,style:style,key:n.name+"_name_"+idx},name));return ret}.bind(this))))}});var InputsTable=React.createClass({displayName:"InputsTable",render:function(){var inputs=this.props.inputs;var params=this.props.params;var input_list=Object.keys(inputs);var params_list=Object.keys(params);if(input_list.length==0){input_list=[" "]}if(params_list.length==0){params_list=[" "]}return React.DOM.div(null,React.DOM.div({className:"canvas-task-info-header"},"INPUTS"),React.DOM.div({className:"canvas-task-info-type",style:{color:"#0a8cc4"}},"GraphLab Objects"),input_list.map(function(n,idx){return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-input"},n)}.bind(this)),React.DOM.div({className:"canvas-task-info-type",style:{color:"#85bd00"}},"Params"),params_list.map(function(n,idx){return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-param"},n)}.bind(this)))}});var OutputsTable=React.createClass({displayName:"OutputsTable",render:function(){var outputs=this.props.outputs;var list=Object.keys(outputs);if(list.length==0){list=[" "]}return React.DOM.div(null,React.DOM.div({className:"canvas-task-info-header"},"OUTPUTS"),React.DOM.div({className:"canvas-task-info-type",style:{color:"#0a8cc4"}},"GraphLab Objects"),list.map(function(n,idx){return React.DOM.div({key:n+"_"+idx,className:"canvas-task-info-val-output"},n)}.bind(this)))}});return{View:React.createClass({displayName:"View",mixins:[Controls.AsyncState,Controls.SizeToWindow],getInitialState:function(){return{task_task:""}},componentDidMount:function(){var block=this.getDOMNode()},shouldComponentUpdate:function(){return false},render:function(){var name=Util.tryGetProperty(this.props.selected_variable,"taskname");var description=Util.tryGetProperty(this.props.selected_variable,"description");var inputs=Util.tryGetProperty(this.props.selected_variable,"inputs");var outputs=Util.tryGetProperty(this.props.selected_variable,"outputs");var params=Util.tryGetProperty(this.props.selected_variable,"params");var code=Util.tryGetProperty(this.props.selected_variable,"code");var packages=Util.tryGetProperty(this.props.selected_variable,"required_pkg");var graphJSON=constructTaskJSON(inputs,params,outputs);return React.DOM.div({className:"tab-content",style:{"max-width":this.state.windowWidth-(190+50),"max-height":this.state.windowHeight-(74+50),overflow:"auto"}},React.DOM.div({className:"canvas-stage-table"},React.DOM.div({className:"canvas-stage-title"},"Task: ",name),React.DOM.div({className:"canvas-task-graph"},GraphLayout({vertices:graphJSON.nodes,edges:graphJSON.links})),React.DOM.div({className:"canvas-task-graph"},React.DOM.div({className:"canvas-task-info-table"},InputsTable({inputs:inputs,params:params}),React.DOM.br(null),OutputsTable({outputs:outputs}))),React.DOM.br({style:{clear:"both"}}),React.DOM.br(null),React.DOM.div({className:"canvas-stage-title"},"Code :"),React.DOM.div({className:"canvas-stage-code"},StageCodeView({code:code}))))}})}});