"use strict";define("common_util",["d3","dagre","react"],function(d3,_dagre,React){var pollIntervalThresholds=[[Math.pow(2,20),1e3],[Math.pow(2,27),5e3]];var pollIntervalScale=d3.scale.linear().domain(pollIntervalThresholds.map(function(a){return a[0]})).range(pollIntervalThresholds.map(function(a){return a[1]}));function assert(x){if("assert"in console){console.assert(x)}else if(!x){var msg="assertion failed";if("error"in console){console.error(msg)}else if("log"in console){console.log(msg)}if("trace"in console){console.trace()}}}function formatNumber(n){if(n===null){return NaN}if(n<.001&&n>0||n>-.001&&n<0){return n.toFixed(4)}if(n>Math.pow(2,40)||n<-Math.pow(2,40)){return n.toPrecision(4)}return n.toLocaleString()}function merge(x1,x2,recursive){var ret={};for(var attr in x1){ret[attr]=x1[attr]}for(var attr in x2){if(recursive&&attr in ret){ret[attr]=merge(ret[attr],x2[attr])}else{ret[attr]=x2[attr]}}return ret}var CanvasImage=React.createClass({displayName:"CanvasImage",draw:function(ctx){var data=this.props.data;var id=ctx.createImageData(this.props.width,this.props.height);var pixels=data.length/this.props.channels;for(var i=0;i<pixels*4;i+=4){var idx=i/4*this.props.channels;id.data[i]=data[idx];if(this.props.channels===1){id.data[i+1]=data[idx];id.data[i+2]=data[idx];id.data[i+3]=255}else{id.data[i+1]=data[idx+1];id.data[i+2]=data[idx+2];if(this.props.channels===3){id.data[i+3]=255}else{assert(this.props.channels===4);id.data[i+3]=data[idx+3]}}}ctx.putImageData(id,0,0)},componentDidMount:function(){var ctx=this.getDOMNode().getContext("2d");this.draw(ctx)},componentDidUpdate:function(){var ctx=this.getDOMNode().getContext("2d");ctx.clearRect(0,0,this.props.width,this.props.height);this.draw(ctx)},shouldComponentUpdate:function(nextProps,nextState){return nextProps.id!==this.props.id},render:function(){return React.DOM.canvas({style:this.props.style,width:this.props.width,height:this.props.height})}});return{assert:assert,merge:merge,partial:function(obj,keys,exclude){var ret={};if(exclude){Object.keys(obj).forEach(function(key){if(keys.indexOf(key)===-1){ret[key]=obj[key]}})}else{keys.forEach(function(key){ret[key]=obj[key]})}return ret},objectMap:function(obj,callback){var ret={};for(var key in obj){ret=merge(ret,callback(key,obj[key]))}return ret},tryGetProperty:function _tryGetProperty(obj,propName,defaultValue){if(typeof defaultValue==="undefined")defaultValue=null;if(propName==null)return defaultValue;if(obj==null)return defaultValue;if(typeof propName==="string"||typeof propName==="number"){if(!(propName in obj))return defaultValue;return obj[propName]}else{assert(Array.isArray(propName));var currentPropName=propName.shift();if(propName.length===0){return _tryGetProperty(obj,currentPropName,defaultValue)}else{return _tryGetProperty(_tryGetProperty(obj,currentPropName),propName,defaultValue)}}},deepCopy:function(o){return JSON.parse(JSON.stringify(o))},deepEquals:function _deepEquals(a,b,depth){if(typeof depth==="undefined"){depth=0}if(depth>500){assert(false);return false}if(typeof a==="function"&&typeof b==="function"){return true}if(typeof a!==typeof b)return false;if(Array.isArray(a)!==Array.isArray(b))return false;if(Array.isArray(a)){if(a.length!==b.length)return false;var ret=true;for(var i=0;i<a.length;i++){ret=ret&&_deepEquals(a[i],b[i],depth+1);if(!ret)return ret}return ret}if(typeof a==="object"){var keys={};for(var key in a){keys[key]=1}for(var key in b){if(!(key in keys))return false;keys[key]++}var ret=true;for(var key in keys){if(keys[key]!==2)return false;ret=ret&&_deepEquals(a[key],b[key],depth+1);if(!ret)return ret}return ret}return a===b},sortFrequentItems:function(frequent_items,count){var values=[];for(var key in frequent_items){values.push({key:key,value:frequent_items[key]})}values.sort(function(a,b){return b.value.frequency-a.value.frequency});return values.slice(0,count)},formatElapsed:function(ms){var d=new Date(ms);var pieces={hours:d.getUTCHours(),minutes:d.getUTCMinutes(),seconds:d.getUTCSeconds()};for(var key in pieces){var s=String(pieces[key]);if(s.length<2){s="0"+s}pieces[key]=s}return pieces.hours+":"+pieces.minutes+":"+pieces.seconds},numberWithSuffix:function(i){if(i>100){return String(i)}var j=i%10;if(j===1&&i!==11){return i+"st"}if(j===2&&i!==12){return i+"nd"}if(j===3&&i!==13){return i+"rd"}return i+"th"},formatNumber:formatNumber,formatSArrayValue:function(value,rowHeight){if(value===""){value="''"}else if(typeof value==="number"){value=formatNumber(value)}else if(typeof value==="object"&&value.type==="image"){var style={};if(rowHeight){style["maxHeight"]=rowHeight}var data=value.value;if(value.format==="raw"){value=CanvasImage({alt:"Image Content",width:value.width,height:value.height,data:value.value,channels:value.channels,style:style,id:value.id})}else{value=React.DOM.img({alt:"Image Content",src:"data:"+value.value,style:style})}}return value},siPrefixToShortScale:function(prefix){var map={Y:"septillion",Z:"sextillion",E:"quintillion",P:"quadrillion",T:"trillion",G:"billion",M:"million",k:"thousand",h:"hundred",da:"ten","":null,d:"tenth",c:"hundredth",m:"thousandth",µ:"millionth",n:"billionth",p:"trillionth",f:"quadrillionth",a:"quintillionth",z:"sextillionth",y:"septillionth"};if(prefix in map){return map[prefix]}Util.assert(false);return null},getCookie:function(name){var r=document.cookie.match("\\b"+name+"=([^;]*)\\b");return r?r[1]:undefined},getSketchPollInterval:function(rowCount){if(rowCount<pollIntervalThresholds[0][0]){return pollIntervalThresholds[0][1]}if(rowCount>pollIntervalThresholds[1][0]){return pollIntervalThresholds[1][1]}return pollIntervalScale(rowCount)},getColorFromNodeType:function(type){var color="";if(type=="Task"){color="#b0007f"}else if(type=="input"||type=="output"){color="#0a8cc4"}else if(type=="param"){color="#85bd00"}return color},getColorFromStatus:function(task_status,selected){var color="";if(selected){return"#ff5500"}if(task_status=="Completed"){color="#0a8cc4"}else if(task_status=="Running"){color="#85bd00"}else if(task_status=="Failed"){color="#B80000"}else{color="#B2B2B2"}return color},getColorFromStatusHighlight:function(task_status){var color="";if(task_status=="Completed"){color="#0a6ca4"}else if(task_status=="Running"){color="#659d00"}else if(task_status=="Failed"){color="#A80000"}else{color="#A2A2A2"}return color},getEdgeStrokeColor:function(selectedOrHover,selected){if(!selectedOrHover){return"#B2B2B2"}if(selected){return"#727272"}else{return"#E2E2E2"}},getDepGraphSelectedStrokeColor:function(){return"#5e5555"},dagreLayout:function(vertices,edges,vertexWidth,vertexHeight,edgesep,ranksep,dir){var g=new dagre.Digraph;for(var i=0;i<vertices.length;i++){g.addNode(vertices[i].name,{label:String(vertices[i].name),width:vertexWidth,height:vertexHeight})}for(var i=0;i<edges.length;i++){g.addEdge(null,edges[i].source,edges[i].target)}var layout;if(edgesep<0&&ranksep<0){layout=dagre.layout().rankDir(dir).run(g)}else if(edgesep>=0&&ranksep<0){layout=dagre.layout().rankDir(dir).edgeSep(edgesep).run(g)}else if(edgesep<0&&ranksep>=0){layout=dagre.layout().rankDir(dir).rankSep(ranksep).run(g)}else{layout=dagre.layout().rankDir(dir).edgeSep(edgesep).rankSep(ranksep).run(g)}var nodeElements=[],edgeElements=[];layout.eachNode(function(u,value){for(var i=0;i<vertices.length;i++){if(vertices[i].name==u){vertices[i]["x"]=value.x;vertices[i]["y"]=value.y}}});var edgeIdx=0;layout.eachEdge(function(e,u,v,value){var points=[[layout.node(u).x,layout.node(u).y]];for(var i=0;i<value.points.length;i++){points.push([value.points[i].x,value.points[i].y])}points.push([layout.node(v).x,layout.node(v).y]);edges[edgeIdx++]["points"]=points});return{vertices:vertices,edges:edges}}}});