"use strict";"use strict";define("canvas",["react","bowser","common_util","common_controls","taskqueue","state","logging"],function(React,Bowser,Util,Controls,TaskQueue,State,Logging){var Descriptives=React.createClass({displayName:"Descriptives",handleClick:function(name){var selected=this.props.selected_variable.concat([name]);selectVariable(selected)},render:function(){if(this.props.selected_variable.length===0){return React.DOM.div(null)}var type=this.props.type;return React.DOM.div({className:"canvas-descriptives"},React.DOM.span(null,React.DOM.span({className:"label"},"Type:")," ",type),$.map(this.props.descriptives,function(value,name){var formatValue=typeof value==="number"?Util.formatNumber(value):value;return React.DOM.span({key:name},React.DOM.span({className:"label"},$.isEmptyObject(this.props.links)||!(name in this.props.links)?" "+name+":":React.DOM.a({href:"javascript:",onClick:this.handleClick.bind(this,this.props.links[name]),style:{color:"#84c5e1",fontWeight:300,textDecoration:"underline"}},name+":"))," ",String(formatValue))}.bind(this)))}});var PythonVariable=React.createClass({displayName:"PythonVariable",getInitialState:function(){return{hover:false}},handleClick:function(evt){selectVariable(this.props.variable.name)},onMouseOver:function(evt){this.setState({hover:true})},onMouseOut:function(evt){this.setState({hover:false})},render:function(){var variableType=this.props.variable.type.toLowerCase();var icons={dataobjects:"data",predictiveservices:"predserv",jobs:"jobs"};if(variableType in icons){var icon=icons[variableType];var state=this.props.selected?"sel":this.state.hover?"hvr":"nml";return React.DOM.a({href:"javascript:",onClick:this.handleClick,onMouseOver:this.onMouseOver,onMouseOut:this.onMouseOut},React.DOM.img({src:"/images/lnav_"+icon+"_"+state+".png",alt:this.props.variable.name}))}Util.assert(false);return React.DOM.span(null)}});var PythonVariables=React.createClass({displayName:"PythonVariables",isSelectedVariable:function(variable){var selected=Util.tryGetProperty(this.props.selected_variable,"name",[]);if(variable.length>selected.length){return false}return Util.deepEquals(selected.slice(0,variable.length),variable)},render:function(){var name=Util.tryGetProperty(this.props.selected_variable,"name",[]);var selectedType=Util.tryGetProperty(this.props.selected_variable,"type");var dataObjSelected=["SArray","SFrame","SGraph"].indexOf(selectedType)!==-1&&(name.length>0&&name[0]!="Jobs")||Util.deepEquals(Util.tryGetProperty(this.props.selected_variable,"name"),["Data"]);return React.DOM.div(null,React.DOM.h3({className:"canvas-title"},"GraphLab ",React.DOM.span({className:"canvas-brand"},"Canvas")),PythonVariable({variable:{name:["Data"],type:"DataObjects"},selected:dataObjSelected}),this.props.variables.map(function(variable,idx){if(variable.type==="SFrame"||variable.type==="SArray"||variable.type==="SGraph"||Util.deepEquals(variable.name,["Data"])){return null}var selected=this.isSelectedVariable(variable.name);return PythonVariable({variable:variable,selected:selected,key:idx})},this))}});var ProgressBar=React.createClass({displayName:"ProgressBar",render:function(){var task=this.props.task;var progress=Math.round(Util.tryGetProperty(task,"progress",0)*100);var finished=Util.tryGetProperty(task,"finished");var transition=["width",progress===0?"0s":"0.6s","ease,","opacity",finished?"2s":"0s","ease"].join(" ");var style={width:progress+"%",opacity:finished?0:.5,transition:transition,"-webkit-transition":transition};var className="canvas-progressbar progress progress-striped active";return React.DOM.div({className:className},React.DOM.div({className:"progress-bar",role:"progressbar","aria-valuenow":progress,"aria-valuemin":"0","aria-valuemax":"100",style:style}),React.DOM.div({className:"canvas-progressbar-contents"},this.props.children))}});var BreadcrumbTitle=React.createClass({displayName:"BreadcrumbTitle",getBreadcrumbPiece:function(name,idx,showSep){var piece=name[idx];var sep=showSep?React.DOM.polygon({points:"0,0 10,11, 0,22",fill:"#495163"}):React.DOM.g(null,React.DOM.rect({x:0,y:0,width:11,height:22,fill:"#495163"}),React.DOM.line({x1:0,y1:-2,x2:10,y2:11,strokeWidth:3,stroke:"#5a6378",strokeLinecap:"square"}),React.DOM.line({x1:10,y1:11,x2:0,y2:24,strokeWidth:3,stroke:"#5a6378",strokeLinecap:"square"}));return React.DOM.span(null,React.DOM.a({href:"javascript:",onClick:selectVariable.bind(this,name.slice(0,idx+1)),style:{height:22,lineHeight:1,fontSize:14,backgroundColor:"#495163",display:"inline-block",verticalAlign:"middle",color:"white",padding:"4px 4px 4px 10px"}},piece),React.DOM.svg({style:{width:11,height:22,verticalAlign:"middle"}},sep))},getTitle:function(name,idx,length){var piece=name[idx];return React.DOM.span({className:"active",style:{marginLeft:length>1?10:0}},piece)},render:function(){var name=Util.tryGetProperty(this.props.selected_variable,"name",[]);var type=Util.tryGetProperty(this.props.selected_variable,"type","");var dataObjSelected=["SFrame","SArray","SGraph"].indexOf(type)!==-1&&(name.length>0&&name[0]!="Jobs");return React.DOM.div({className:"canvas-breadcrumb"},dataObjSelected?this.getBreadcrumbPiece(["Data"],0,name.length===1):null,name.map(function(piece,idx){return React.DOM.span({key:idx},idx===name.length-1?this.getTitle(name,idx,name.length+(dataObjSelected?1:0)):this.getBreadcrumbPiece(name,idx,idx==name.length-2))}.bind(this)))}});var FeedbackButton=React.createClass({displayName:"FeedbackButton",mixins:[Controls.Modal],getInitialState:function(){return{includeLog:true}},setEmail:function(evt){this.props.setEmail(evt.target.value)},submit:function(){var feedback=$(".canvas-feedback-textarea").val();var log;if(this.state.includeLog){log=Logging.get()}reportFeedback(feedback,log);this.modalClose()},getRadioButton:function(value){var props={type:"radio",name:"canvas-feedback-log",value:value?"true":"false",onClick:this.setState.bind(null,{includeLog:value})};if(this.state.includeLog===value){props["checked"]=true}var input=React.DOM.input(props);return React.DOM.span(null,value?"Yes":"No",input)},render:function(){var emailProps={type:"email",name:"canvas-feedback-email",className:"canvas-feedback-email",placeholder:"E-mail (optional)",onChange:this.setEmail};var emailField=React.DOM.input(emailProps);var form=React.DOM.div({className:"canvas-feedback-form"},React.DOM.div({className:"canvas-feedback-log-area"},React.DOM.label({htmlFor:"canvas-feedback-log"},"Include log file with feedback?"),React.DOM.span({className:"canvas-feedback-log-radios"},this.getRadioButton(true),this.getRadioButton(false))),React.DOM.div(null,React.DOM.textarea({name:"canvas-feedback-text",className:"canvas-feedback-textarea",placeholder:"Enter your feedback..."})),React.DOM.div(null,"If you would like a reply via e-mail, enter your address.",emailField),React.DOM.div({className:"canvas-form-buttons"},React.DOM.a({className:"canvas-form-submit",href:"javascript:",onClick:this.submit},"Submit"),React.DOM.a({className:"canvas-form-cancel",href:"javascript:",onClick:this.modalClose},"Cancel")));var modalOpen=this.modalOpen.bind(null,"Send Feedback",form);var button=React.DOM.a({className:"canvas-feedback-button",href:"javascript:",onClick:modalOpen},"Send us",React.DOM.br(null),"Feedback");return React.DOM.div({className:"canvas-feedback"},React.DOM.img({src:"/images/gl_logo.png",style:{width:60,height:39}}),button,this.getModal())}});var Header=React.createClass({displayName:"Header",render:function(){return React.DOM.div({className:"canvas-header-container"},React.DOM.div({className:"canvas-header-colorbar"},["#b0007f","#0a8cc4","#85bd00","#ff5500","#5e5555"].map(function(color,idx){var style={backgroundColor:color,left:String(idx*20)+"%"};return React.DOM.div({key:color,style:style})})))}});var DataStructureView=React.createClass({displayName:"DataStructureView",requestFile:function(props){var view_file=this.getViewFile(props);if(view_file!==null){require([view_file],function(ViewFile){this.setState({loaded:true})}.bind(this))}},getInitialState:function(){return{loaded:false}},getViewFile:function(props){return Util.tryGetProperty(props.selected_variable,"view_file")},componentDidMount:function(){this.requestFile(this.props)},componentWillReceiveProps:function(nextProps){if(this.getViewFile(this.props)!==this.getViewFile(nextProps)){this.setState({loaded:false});this.requestFile(nextProps)}},render:function(){var view_file=this.getViewFile(this.props);if(!this.state.loaded||view_file===null){return React.DOM.div(null)}else{var ViewFile=require(view_file);var viewComponent=ViewFile["View"];return React.DOM.div({style:{marginLeft:20,marginRight:20}},viewComponent({selectVariable:selectVariable,selected_variable:this.props.selected_variable,variables:this.props.variables}))}}});var StatusItem=React.createClass({displayName:"StatusItem",mixins:[Controls.Modal],getInitialState:function(){return{showReportBug:true}},reportBug:function(){reportFeedback("unexpected_exception: "+JSON.stringify(this.props.message),JSON.stringify(Logging.get()));this.setState({showReportBug:false})},render:function(){var stack_trace=null;if("stack_trace"in this.props.message){var modalOpen=this.modalOpen.bind(undefined,"Stack Trace",React.DOM.pre(null,React.DOM.code(null,this.props.message.stack_trace)));var bugReportLink=this.state.showReportBug?React.DOM.a({href:"javascript:",onClick:this.reportBug},"Report Bug to GraphLab"):"Bug reported.";stack_trace=React.DOM.div({className:"canvas-statusbar-stack-trace-link"}," | ",React.DOM.a({href:"javascript:",onClick:modalOpen},"View Stack Trace")," | ",bugReportLink,this.getModal())}return React.DOM.div({className:"alert alert-danger alert-dismissable"},React.DOM.button({type:"button",className:"close","aria-hidden":"true",onClick:this.props.dismiss},"×"),this.props.message.text,stack_trace)}});var StatusBar=React.createClass({displayName:"StatusBar",render:function(){return React.DOM.div({className:"canvas-statusbar"},this.props.messages.map(function(m,idx){return StatusItem({key:idx,message:m,dismiss:this.props.dismiss.bind(undefined,idx)})}.bind(this)))}});var LeftBar=React.createClass({displayName:"LeftBar",render:function(){return React.DOM.div({className:"canvas-leftnav"},this.props.children)}});var Page=React.createClass({displayName:"Page",getInitialState:function(){return{selected_variable:null,variables:[],task:{},messages:[],gl_version:"unknown",gl_product_key:"unknown",user_email:null}},shouldComponentUpdate:function(nextProps,nextState){return!Util.deepEquals(this.state,nextState)},setEmail:function(str){this.setState({user_email:str})},dismissStatus:function(idx){this.setState({messages:this.state.messages.slice(0,idx).concat(this.state.messages.slice(idx+1))})},render:function(){var _this=this;var selected_variable=this.state.selected_variable;return React.DOM.div({id:"canvas-page"},React.DOM.div({className:"canvas-body-container"},LeftBar(null,PythonVariables({variables:this.state.variables,selected_variable:selected_variable}),FeedbackButton({setEmail:this.setEmail,user_email:this.state.user_email})),React.DOM.div({className:"canvas-main"},Header(null),StatusBar({messages:this.state.messages,dismiss:this.dismissStatus}),ProgressBar({task:this.state.task,selected_variable:selected_variable},BreadcrumbTitle({selected_variable:selected_variable}),Descriptives({selected_variable:Util.tryGetProperty(selected_variable,"name",[]),descriptives:Util.tryGetProperty(selected_variable,"descriptives",{}),links:Util.tryGetProperty(selected_variable,"descriptives_links",{}),type:Util.tryGetProperty(selected_variable,"type")})),DataStructureView({selected_variable:selected_variable,variables:this.state.variables}))))}});function setGlobalState(data){if("selected_variable"in data&&!Util.deepEquals(g_page.state.selected_variable,data.selected_variable)){TaskQueue.cancelAll();data.messages=[]}State.set(data)}var g_focused=true;function getVars(){if(g_focused){$.get("/vars").done(function(data,textStatus,jqXHR){data["messages"]=g_page.state.messages.concat(data.exceptions.map(function(e){Logging.log("encountered an exception");Logging.log(e);return{text:"An error occurred of type "+e.type+": "+e.message,stack_trace:e.stack_trace}}));delete data.exceptions;setGlobalState(data);setTimeout(getVars,2e3)}).fail(function(){setGlobalState({messages:g_page.state.messages.concat([{text:"Lost connection to GraphLab Create Python session. Call .show() again from Python to re-invoke Canvas."}])})})}else{setTimeout(getVars,1e3)}}function pingServer(){$.get("/ping",function(data,textStatus,jqXHR){setTimeout(pingServer,1e3)})}function selectVariable(v){var currentVariable=Util.tryGetProperty(g_page.state.selected_variable,"name");if(Util.deepEquals(currentVariable,v)){return}TaskQueue.cancelAll();$.post("/vars",{selected:JSON.stringify(v),_xsrf:Util.getCookie("_xsrf")},function(data,textStatus,jqXHR){setGlobalState(data)})}function reportFeedback(feedback,log){var data={feedback:"\n\n"+feedback+"\n",log:JSON.stringify(log),language:navigator.language,recipient:"product-feedback@graphlab.com",subject:g_page.state.gl_product_key,version:g_page.state.gl_version,email:g_page.state.user_email,env_report:"REMOTE_ADDR,HTTP_USER_AGENT",print_config:"subject",sort:"order:version,email,feedback,log,language"};$.post("http://formmail.dreamhost.com/cgi-bin/formmail.cgi",data)}var g_page;function runCanvas(){Logging.reportMetric("script_load.duration.ms",Date.now()-g_scriptLoadStart);window.onerror=function(errorMsg,url,line){Logging.reportMetric("unhandled_exception",null,{error:errorMsg.substring(0,100),url:url.substring(0,100),line:line})};window.onfocus=function(){g_focused=true};window.onblur=function(){g_focused=false};Logging.reportMetric("browser",null,{name:Bowser.name,version:Bowser.version});g_page=React.renderComponent(Page(null),document.body);State.addListener(g_page);getVars();pingServer();TaskQueue.start()}return{runCanvas:runCanvas}});