/*
 * Decompiled with CFR 0.152.
 */
package org.graphlab.hadoop.yarn.applications;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.io.DataOutputBuffer;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationConstants;
import org.apache.hadoop.yarn.api.protocolrecords.GetNewApplicationResponse;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.api.records.ContainerLaunchContext;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.client.api.YarnClientApplication;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.hadoop.yarn.util.Records;
import org.graphlab.hadoop.yarn.applications.Log4jPropertyHelper;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public class Client {
    public static final transient int[] __cobertura_counters;
    private static final Log LOG;
    private Configuration conf;
    private YarnClient yarnClient;
    private String appName;
    private int amPriority;
    private String amQueue;
    private int amMemory;
    private int amVCores;
    private String appMasterJar;
    private final String appMasterMainClass;
    private String[] pythonArgs;
    private int pythonScriptPriority;
    private int containerMemory;
    private int containerVirtualCores;
    private int numContainers;
    private String log4jPropFile;
    private final long clientStartTime;
    private long clientTimeout;
    boolean debugFlag;
    private String resource_dir;
    private String python_dependencies_file;
    private Options opts;
    private static final String pythonArgsPath = "pythonArgs";
    private static final String appMasterJarPath = "AppMaster.jar";
    private static final String log4jPath = "log4j.properties";
    private static final String dependencyScriptPath = "ExecGetPythonDependencyFiles.sh";
    private static final String userPythonDepPath = "UserPythonDep";
    private static final String userResourceScriptPath = "ExecGetUserResc.sh";
    private static final String userResourcePath = "UserResources";
    private static final String glScriptPath = "ExecGetGLPkg.sh";
    private static final String glReqPath = "gl_reqs";
    private static final String glCertPath = "gl_cert";
    private static final String jsonTag = "$$JSONTAG##";
    private String checkAppId;
    private Long applicationTimeStamp;
    private int applicationId;
    private boolean monitor;
    private boolean is_JSON;
    private boolean use_cache;
    private String cache_directory;
    private MonitorTypes monitorType;
    private String gl_source;
    private boolean gl_art;
    private String task_zip;
    private String pythonScriptPath;
    private String userCertPath;

    public static void main(String[] stringArray) {
        Client.__cobertura_init();
        int n = 0;
        __cobertura_counters[29] = __cobertura_counters[29] + 1;
        ExitStatus result = ExitStatus.RUNNING;
        try {
            int n2;
            __cobertura_counters[30] = __cobertura_counters[30] + 1;
            Client client = new Client();
            __cobertura_counters[31] = __cobertura_counters[31] + 1;
            LOG.info((Object)"Initializing Client");
            try {
                String[] args;
                __cobertura_counters[32] = __cobertura_counters[32] + 1;
                boolean doRun = client.init(args);
                __cobertura_counters[33] = __cobertura_counters[33] + 1;
                n = 35;
                if (!doRun) {
                    __cobertura_counters[34] = __cobertura_counters[34] + 1;
                    n = 0;
                    __cobertura_counters[36] = __cobertura_counters[36] + 1;
                    System.exit(0);
                }
                n2 = n;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                __cobertura_counters[37] = __cobertura_counters[37] + 1;
                IllegalArgumentException e = illegalArgumentException;
                __cobertura_counters[38] = __cobertura_counters[38] + 1;
                System.err.println(e.getLocalizedMessage());
                __cobertura_counters[39] = __cobertura_counters[39] + 1;
                client.printUsage();
                __cobertura_counters[40] = __cobertura_counters[40] + 1;
                System.exit(-1);
            }
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[41] = __cobertura_counters[41] + 1;
            __cobertura_counters[42] = __cobertura_counters[42] + 1;
            result = client.run();
        }
        catch (Throwable throwable) {
            __cobertura_counters[43] = __cobertura_counters[43] + 1;
            Throwable t = throwable;
            __cobertura_counters[44] = __cobertura_counters[44] + 1;
            LOG.fatal((Object)"Error running CLient", t);
            __cobertura_counters[45] = __cobertura_counters[45] + 1;
            System.exit(1);
        }
        __cobertura_counters[46] = __cobertura_counters[46] + 1;
        __cobertura_counters[47] = __cobertura_counters[47] + 1;
        n = 49;
        if (result == ExitStatus.FINISH_SUCCESS) {
            __cobertura_counters[48] = __cobertura_counters[48] + 1;
            n = 0;
            __cobertura_counters[50] = __cobertura_counters[50] + 1;
            LOG.info((Object)"Application completed successfully");
            __cobertura_counters[51] = __cobertura_counters[51] + 1;
            System.exit(0);
        } else {
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[52] = __cobertura_counters[52] + 1;
            n = 54;
            if (result == ExitStatus.RUNNING) {
                __cobertura_counters[53] = __cobertura_counters[53] + 1;
                n = 0;
                __cobertura_counters[55] = __cobertura_counters[55] + 1;
                LOG.info((Object)"Application is/are still running.");
                __cobertura_counters[56] = __cobertura_counters[56] + 1;
                System.exit(0);
            } else {
                int n4 = n;
                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                n = 0;
                __cobertura_counters[57] = __cobertura_counters[57] + 1;
                n = 59;
                if (result == ExitStatus.MONITOR) {
                    __cobertura_counters[58] = __cobertura_counters[58] + 1;
                    n = 0;
                    __cobertura_counters[60] = __cobertura_counters[60] + 1;
                    System.exit(0);
                }
            }
        }
        int n5 = n;
        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
        n = 0;
        __cobertura_counters[61] = __cobertura_counters[61] + 1;
        LOG.error((Object)"Application failed to complete successfully");
        __cobertura_counters[62] = __cobertura_counters[62] + 1;
        System.exit(2);
        __cobertura_counters[63] = __cobertura_counters[63] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public Client(Configuration configuration) throws Exception {
        void conf;
        int n = 0;
        __cobertura_counters[64] = __cobertura_counters[64] + 1;
        this("org.graphlab.hadoop.yarn.applications.ApplicationMaster", (Configuration)conf);
        __cobertura_counters[65] = __cobertura_counters[65] + 1;
    }

    /*
     * WARNING - void declaration
     */
    Client(String string, Configuration configuration) {
        void appMasterMainClass;
        void conf;
        int n = 0;
        __cobertura_counters[66] = __cobertura_counters[66] + 1;
        __cobertura_counters[2] = __cobertura_counters[2] + 1;
        this.appName = "";
        __cobertura_counters[3] = __cobertura_counters[3] + 1;
        this.amPriority = 0;
        __cobertura_counters[4] = __cobertura_counters[4] + 1;
        this.amQueue = "";
        __cobertura_counters[5] = __cobertura_counters[5] + 1;
        this.amMemory = 10;
        __cobertura_counters[6] = __cobertura_counters[6] + 1;
        this.amVCores = 1;
        __cobertura_counters[7] = __cobertura_counters[7] + 1;
        this.appMasterJar = "";
        __cobertura_counters[8] = __cobertura_counters[8] + 1;
        this.pythonArgs = new String[0];
        __cobertura_counters[9] = __cobertura_counters[9] + 1;
        this.pythonScriptPriority = 0;
        __cobertura_counters[10] = __cobertura_counters[10] + 1;
        this.containerMemory = 10;
        __cobertura_counters[11] = __cobertura_counters[11] + 1;
        this.containerVirtualCores = 1;
        __cobertura_counters[12] = __cobertura_counters[12] + 1;
        this.numContainers = 1;
        __cobertura_counters[13] = __cobertura_counters[13] + 1;
        this.log4jPropFile = "";
        __cobertura_counters[14] = __cobertura_counters[14] + 1;
        this.clientStartTime = System.currentTimeMillis();
        __cobertura_counters[15] = __cobertura_counters[15] + 1;
        this.clientTimeout = 600000L;
        __cobertura_counters[16] = __cobertura_counters[16] + 1;
        this.debugFlag = false;
        __cobertura_counters[17] = __cobertura_counters[17] + 1;
        this.resource_dir = "";
        __cobertura_counters[18] = __cobertura_counters[18] + 1;
        this.python_dependencies_file = "";
        __cobertura_counters[19] = __cobertura_counters[19] + 1;
        this.checkAppId = "";
        __cobertura_counters[20] = __cobertura_counters[20] + 1;
        this.monitor = false;
        __cobertura_counters[21] = __cobertura_counters[21] + 1;
        this.is_JSON = false;
        __cobertura_counters[22] = __cobertura_counters[22] + 1;
        this.use_cache = false;
        __cobertura_counters[23] = __cobertura_counters[23] + 1;
        this.cache_directory = "";
        __cobertura_counters[24] = __cobertura_counters[24] + 1;
        this.gl_source = "";
        __cobertura_counters[25] = __cobertura_counters[25] + 1;
        this.gl_art = false;
        __cobertura_counters[26] = __cobertura_counters[26] + 1;
        this.task_zip = null;
        __cobertura_counters[27] = __cobertura_counters[27] + 1;
        this.pythonScriptPath = "";
        __cobertura_counters[28] = __cobertura_counters[28] + 1;
        this.userCertPath = "";
        __cobertura_counters[67] = __cobertura_counters[67] + 1;
        this.conf = conf;
        __cobertura_counters[68] = __cobertura_counters[68] + 1;
        this.appMasterMainClass = appMasterMainClass;
        __cobertura_counters[69] = __cobertura_counters[69] + 1;
        this.yarnClient = YarnClient.createYarnClient();
        __cobertura_counters[70] = __cobertura_counters[70] + 1;
        this.yarnClient.init((Configuration)conf);
        __cobertura_counters[71] = __cobertura_counters[71] + 1;
        this.opts = new Options();
        __cobertura_counters[72] = __cobertura_counters[72] + 1;
        this.opts.addOption("appname", true, "Application Name. Default value - GraphLab");
        __cobertura_counters[73] = __cobertura_counters[73] + 1;
        this.opts.addOption("priority", true, "Application Priority. Default 0");
        __cobertura_counters[74] = __cobertura_counters[74] + 1;
        this.opts.addOption("timeout", true, "Application timeout in milliseconds");
        __cobertura_counters[75] = __cobertura_counters[75] + 1;
        this.opts.addOption("master_memory", true, "Amount of memory in MB to be requested to run the application master");
        __cobertura_counters[76] = __cobertura_counters[76] + 1;
        this.opts.addOption("master_vcores", true, "Amount of virtual cores to be requested to run the application master");
        __cobertura_counters[77] = __cobertura_counters[77] + 1;
        this.opts.addOption("jar", true, "Jar file containing the application master");
        __cobertura_counters[78] = __cobertura_counters[78] + 1;
        this.opts.addOption("python_args", true, "Command line args for the python script.Multiple args can be separated by empty space.");
        __cobertura_counters[79] = __cobertura_counters[79] + 1;
        this.opts.getOption("python_args").setArgs(-2);
        __cobertura_counters[80] = __cobertura_counters[80] + 1;
        this.opts.addOption("python_script_priority", true, "Priority for the python command containers");
        __cobertura_counters[81] = __cobertura_counters[81] + 1;
        this.opts.addOption("container_memory", true, "Amount of memory in MB to be requested to run the GraphLab job");
        __cobertura_counters[82] = __cobertura_counters[82] + 1;
        this.opts.addOption("container_vcores", true, "Amount of virtual cores to be requested to run the GraphLab job");
        __cobertura_counters[83] = __cobertura_counters[83] + 1;
        this.opts.addOption("num_containers", true, "No. of containers on which the GraphLab job needs to be executed");
        __cobertura_counters[84] = __cobertura_counters[84] + 1;
        this.opts.addOption("log_properties", true, "log4j.properties file");
        __cobertura_counters[85] = __cobertura_counters[85] + 1;
        this.opts.addOption("debug", false, "Dump out debug information");
        __cobertura_counters[86] = __cobertura_counters[86] + 1;
        this.opts.addOption("help", false, "Print usage");
        __cobertura_counters[87] = __cobertura_counters[87] + 1;
        this.opts.addOption("resource_dir", true, "Directory of user resources being used to run on hadoop");
        __cobertura_counters[88] = __cobertura_counters[88] + 1;
        this.opts.addOption("dependencies", true, "File that contains all the python dependency packages for user in requirements.pip format");
        __cobertura_counters[89] = __cobertura_counters[89] + 1;
        this.opts.addOption("python_script", true, "The path to the entry point python script that the user will run on hadoop.  This should be located inside the resource directory, resource_dir");
        __cobertura_counters[90] = __cobertura_counters[90] + 1;
        this.opts.addOption("product_key", true, "The product key location of the client that is required to run GraphLab");
        __cobertura_counters[91] = __cobertura_counters[91] + 1;
        this.opts.addOption("checkAppId", true, "The applicationId that the client needs to check");
        __cobertura_counters[92] = __cobertura_counters[92] + 1;
        this.opts.addOption("monitor", true, "Monitors the application status for all GraphLab applications. \n-monitor all : to monitor all applications\n-monitor running : only monitor running applications\n-monitor finished : only monitor finished applications");
        __cobertura_counters[93] = __cobertura_counters[93] + 1;
        this.opts.addOption("gl_source", true, "location of the graphlab source code\n-gl_source native : GraphLab is already installed natively on hadoop clusters\n-gl_source none : no source is provided, client would download and containers would install GraphLab\n-gl_source (HDFS path) : the HDFS path to the GraphLab tar ball provided by the user ");
        __cobertura_counters[94] = __cobertura_counters[94] + 1;
        this.opts.addOption("json", false, "Outputs the application status in json");
        __cobertura_counters[95] = __cobertura_counters[95] + 1;
        this.opts.addOption("gl_artifact", false, " graphlab internal: running gl_artifacts");
        __cobertura_counters[96] = __cobertura_counters[96] + 1;
        this.opts.addOption("task_zip", true, "graphlab internal: the tar.gz of the task");
        __cobertura_counters[97] = __cobertura_counters[97] + 1;
        this.opts.addOption("cache_virtualenv", false, "graphlab internal: Look for a cached GraphLab virtual environment on the node OS at this directory.  If not found, create one and leave it there for future runs");
        __cobertura_counters[98] = __cobertura_counters[98] + 1;
    }

    public Client() throws Exception {
        int n = 0;
        __cobertura_counters[99] = __cobertura_counters[99] + 1;
        this((Configuration)new YarnConfiguration());
        __cobertura_counters[100] = __cobertura_counters[100] + 1;
    }

    private void printUsage() {
        int n = 0;
        __cobertura_counters[101] = __cobertura_counters[101] + 1;
        new HelpFormatter().printHelp(85, "Client", "", this.opts, "");
        __cobertura_counters[102] = __cobertura_counters[102] + 1;
    }

    /*
     * Unable to fully structure code
     */
    public boolean init(String[] var1_1) throws ParseException {
        block46: {
            block45: {
                block44: {
                    block41: {
                        block43: {
                            block42: {
                                var2_2 = 0;
                                Client.__cobertura_counters[103] = Client.__cobertura_counters[103] + 1;
                                cliParser = new GnuParser().parse(this.opts, (String[])args);
                                Client.__cobertura_counters[104] = Client.__cobertura_counters[104] + 1;
                                var2_2 = 106;
                                if (((void)args).length == 0) {
                                    Client.__cobertura_counters[105] = Client.__cobertura_counters[105] + 1;
                                    var2_2 = 0;
                                    Client.__cobertura_counters[107] = Client.__cobertura_counters[107] + 1;
                                    throw new IllegalArgumentException("No args specified for client to initialize");
                                }
                                v0 = var2_2;
                                Client.__cobertura_counters[v0] = Client.__cobertura_counters[v0] + 1;
                                var2_2 = 0;
                                Client.__cobertura_counters[108] = Client.__cobertura_counters[108] + 1;
                                var2_2 = 110;
                                if (cliParser.hasOption("log_properties")) {
                                    Client.__cobertura_counters[109] = Client.__cobertura_counters[109] + 1;
                                    var2_2 = 0;
                                    Client.__cobertura_counters[111] = Client.__cobertura_counters[111] + 1;
                                    log4jPath = cliParser.getOptionValue("log_properties");
                                    try {
                                        Client.__cobertura_counters[112] = Client.__cobertura_counters[112] + 1;
                                        Log4jPropertyHelper.updateLog4jConfiguration(Client.class, log4jPath);
                                    }
                                    catch (Exception v1) {
                                        Client.__cobertura_counters[113] = Client.__cobertura_counters[113] + 1;
                                        e = v1;
                                        Client.__cobertura_counters[114] = Client.__cobertura_counters[114] + 1;
                                        Client.LOG.warn((Object)("Can not set up custom log4j properties. " + e));
                                    }
                                    Client.__cobertura_counters[115] = Client.__cobertura_counters[115] + 1;
                                }
                                v2 = var2_2;
                                Client.__cobertura_counters[v2] = Client.__cobertura_counters[v2] + 1;
                                var2_2 = 0;
                                Client.__cobertura_counters[116] = Client.__cobertura_counters[116] + 1;
                                var2_2 = 118;
                                if (cliParser.hasOption("help")) {
                                    Client.__cobertura_counters[117] = Client.__cobertura_counters[117] + 1;
                                    var2_2 = 0;
                                    Client.__cobertura_counters[119] = Client.__cobertura_counters[119] + 1;
                                    this.printUsage();
                                    Client.__cobertura_counters[120] = Client.__cobertura_counters[120] + 1;
                                    return false;
                                }
                                v3 = var2_2;
                                Client.__cobertura_counters[v3] = Client.__cobertura_counters[v3] + 1;
                                var2_2 = 0;
                                Client.__cobertura_counters[121] = Client.__cobertura_counters[121] + 1;
                                var2_2 = 123;
                                if (cliParser.hasOption("debug")) {
                                    Client.__cobertura_counters[122] = Client.__cobertura_counters[122] + 1;
                                    var2_2 = 0;
                                    Client.__cobertura_counters[124] = Client.__cobertura_counters[124] + 1;
                                    this.debugFlag = true;
                                    Client.__cobertura_counters[125] = Client.__cobertura_counters[125] + 1;
                                    this.use_cache = true;
                                }
                                v4 = var2_2;
                                Client.__cobertura_counters[v4] = Client.__cobertura_counters[v4] + 1;
                                var2_2 = 0;
                                Client.__cobertura_counters[126] = Client.__cobertura_counters[126] + 1;
                                var2_2 = 128;
                                if (!cliParser.hasOption("gl_artifact")) break block41;
                                Client.__cobertura_counters[127] = Client.__cobertura_counters[127] + 1;
                                var2_2 = 0;
                                Client.__cobertura_counters[129] = Client.__cobertura_counters[129] + 1;
                                this.gl_art = true;
                                Client.__cobertura_counters[130] = Client.__cobertura_counters[130] + 1;
                                var2_2 = 132;
                                if (!cliParser.hasOption("task_zip")) break block42;
                                Client.__cobertura_counters[131] = Client.__cobertura_counters[131] + 1;
                                var2_2 = 0;
                                var2_2 = 134;
                                if (cliParser.getOptionValue("task_zip") != null) break block43;
                                Client.__cobertura_counters[133] = Client.__cobertura_counters[133] + 1;
                                var2_2 = 0;
                            }
                            v5 = var2_2;
                            Client.__cobertura_counters[v5] = Client.__cobertura_counters[v5] + 1;
                            var2_2 = 0;
                            Client.__cobertura_counters[135] = Client.__cobertura_counters[135] + 1;
                            throw new IllegalArgumentException(" if gl_artifact selected, specify a task_zip");
                        }
                        v6 = var2_2;
                        Client.__cobertura_counters[v6] = Client.__cobertura_counters[v6] + 1;
                        var2_2 = 0;
                        Client.__cobertura_counters[136] = Client.__cobertura_counters[136] + 1;
                        this.task_zip = cliParser.getOptionValue("task_zip");
                    }
                    v7 = var2_2;
                    Client.__cobertura_counters[v7] = Client.__cobertura_counters[v7] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[137] = Client.__cobertura_counters[137] + 1;
                    this.appName = cliParser.getOptionValue("appname", "GraphLab");
                    Client.__cobertura_counters[138] = Client.__cobertura_counters[138] + 1;
                    this.amPriority = Integer.parseInt(cliParser.getOptionValue("priority", "0"));
                    Client.__cobertura_counters[139] = Client.__cobertura_counters[139] + 1;
                    this.amQueue = cliParser.getOptionValue("queue", "default");
                    Client.__cobertura_counters[140] = Client.__cobertura_counters[140] + 1;
                    this.amMemory = Integer.parseInt(cliParser.getOptionValue("master_memory", "10"));
                    Client.__cobertura_counters[141] = Client.__cobertura_counters[141] + 1;
                    this.amVCores = Integer.parseInt(cliParser.getOptionValue("master_vcores", "1"));
                    Client.__cobertura_counters[142] = Client.__cobertura_counters[142] + 1;
                    var2_2 = 144;
                    if (this.amMemory < 0) {
                        Client.__cobertura_counters[143] = Client.__cobertura_counters[143] + 1;
                        var2_2 = 0;
                        Client.__cobertura_counters[145] = Client.__cobertura_counters[145] + 1;
                        throw new IllegalArgumentException("Invalid memory specified for application master, exiting. Specified memory=" + this.amMemory);
                    }
                    v8 = var2_2;
                    Client.__cobertura_counters[v8] = Client.__cobertura_counters[v8] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[146] = Client.__cobertura_counters[146] + 1;
                    var2_2 = 148;
                    if (this.amVCores < 0) {
                        Client.__cobertura_counters[147] = Client.__cobertura_counters[147] + 1;
                        var2_2 = 0;
                        Client.__cobertura_counters[149] = Client.__cobertura_counters[149] + 1;
                        throw new IllegalArgumentException("Invalid virtual cores specified for application master, exiting. Specified virtual cores=" + this.amVCores);
                    }
                    v9 = var2_2;
                    Client.__cobertura_counters[v9] = Client.__cobertura_counters[v9] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[150] = Client.__cobertura_counters[150] + 1;
                    var2_2 = 152;
                    if (!cliParser.hasOption("jar")) {
                        Client.__cobertura_counters[151] = Client.__cobertura_counters[151] + 1;
                        var2_2 = 0;
                        var2_2 = 154;
                        if (!cliParser.hasOption("monitor")) {
                            Client.__cobertura_counters[153] = Client.__cobertura_counters[153] + 1;
                            var2_2 = 0;
                            var2_2 = 156;
                            if (!cliParser.hasOption("checkAppId")) {
                                Client.__cobertura_counters[155] = Client.__cobertura_counters[155] + 1;
                                var2_2 = 0;
                                Client.__cobertura_counters[157] = Client.__cobertura_counters[157] + 1;
                                throw new IllegalArgumentException("No jar file specified for application master");
                            }
                        }
                    }
                    v10 = var2_2;
                    Client.__cobertura_counters[v10] = Client.__cobertura_counters[v10] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[158] = Client.__cobertura_counters[158] + 1;
                    this.appMasterJar = cliParser.getOptionValue("jar");
                    Client.__cobertura_counters[159] = Client.__cobertura_counters[159] + 1;
                    var2_2 = 161;
                    if (cliParser.hasOption("python_args")) {
                        Client.__cobertura_counters[160] = Client.__cobertura_counters[160] + 1;
                        var2_2 = 0;
                        Client.__cobertura_counters[162] = Client.__cobertura_counters[162] + 1;
                        this.pythonArgs = cliParser.getOptionValues("python_args");
                    }
                    v11 = var2_2;
                    Client.__cobertura_counters[v11] = Client.__cobertura_counters[v11] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[163] = Client.__cobertura_counters[163] + 1;
                    this.pythonScriptPriority = Integer.parseInt(cliParser.getOptionValue("python_script_priority", "0"));
                    Client.__cobertura_counters[164] = Client.__cobertura_counters[164] + 1;
                    this.containerMemory = Integer.parseInt(cliParser.getOptionValue("container_memory", "10"));
                    Client.__cobertura_counters[165] = Client.__cobertura_counters[165] + 1;
                    this.containerVirtualCores = Integer.parseInt(cliParser.getOptionValue("container_vcores", "1"));
                    Client.__cobertura_counters[166] = Client.__cobertura_counters[166] + 1;
                    this.numContainers = Integer.parseInt(cliParser.getOptionValue("num_containers", "1"));
                    Client.__cobertura_counters[167] = Client.__cobertura_counters[167] + 1;
                    var2_2 = 169;
                    if (this.containerMemory < 0) break block44;
                    Client.__cobertura_counters[168] = Client.__cobertura_counters[168] + 1;
                    var2_2 = 0;
                    var2_2 = 171;
                    if (this.containerVirtualCores < 0) break block44;
                    Client.__cobertura_counters[170] = Client.__cobertura_counters[170] + 1;
                    var2_2 = 0;
                    var2_2 = 173;
                    if (this.numContainers >= 1) break block45;
                    Client.__cobertura_counters[172] = Client.__cobertura_counters[172] + 1;
                    var2_2 = 0;
                }
                v12 = var2_2;
                Client.__cobertura_counters[v12] = Client.__cobertura_counters[v12] + 1;
                var2_2 = 0;
                Client.__cobertura_counters[174] = Client.__cobertura_counters[174] + 1;
                throw new IllegalArgumentException("Invalid no. of containers or container memory/vcores specified, exiting. Specified containerMemory=" + this.containerMemory + ", containerVirtualCores=" + this.containerVirtualCores + ", numContainer=" + this.numContainers);
            }
            v13 = var2_2;
            Client.__cobertura_counters[v13] = Client.__cobertura_counters[v13] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[175] = Client.__cobertura_counters[175] + 1;
            this.clientTimeout = Integer.parseInt(cliParser.getOptionValue("timeout", "800000"));
            Client.__cobertura_counters[176] = Client.__cobertura_counters[176] + 1;
            this.log4jPropFile = cliParser.getOptionValue("log_properties", "");
            Client.__cobertura_counters[177] = Client.__cobertura_counters[177] + 1;
            var2_2 = 179;
            if (cliParser.hasOption("cache_virtualenv")) {
                Client.__cobertura_counters[178] = Client.__cobertura_counters[178] + 1;
                var2_2 = 0;
                Client.__cobertura_counters[180] = Client.__cobertura_counters[180] + 1;
                this.use_cache = true;
            }
            v14 = var2_2;
            Client.__cobertura_counters[v14] = Client.__cobertura_counters[v14] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[181] = Client.__cobertura_counters[181] + 1;
            var2_2 = 183;
            if (!cliParser.hasOption("monitor")) break block46;
            Client.__cobertura_counters[182] = Client.__cobertura_counters[182] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[184] = Client.__cobertura_counters[184] + 1;
            this.monitor = true;
            Client.__cobertura_counters[185] = Client.__cobertura_counters[185] + 1;
            monitorInput = cliParser.getOptionValue("monitor");
            Client.__cobertura_counters[186] = Client.__cobertura_counters[186] + 1;
            var2_2 = 188;
            if (monitorInput == null) ** GOTO lbl214
            Client.__cobertura_counters[187] = Client.__cobertura_counters[187] + 1;
            var2_2 = 0;
            var2_2 = 190;
            if (monitorInput.equals("all")) {
                Client.__cobertura_counters[189] = Client.__cobertura_counters[189] + 1;
                var2_2 = 0;
lbl214:
                // 2 sources

                v15 = var2_2;
                Client.__cobertura_counters[v15] = Client.__cobertura_counters[v15] + 1;
                var2_2 = 0;
                Client.__cobertura_counters[191] = Client.__cobertura_counters[191] + 1;
                this.monitorType = MonitorTypes.ALL;
            } else {
                v16 = var2_2;
                Client.__cobertura_counters[v16] = Client.__cobertura_counters[v16] + 1;
                var2_2 = 0;
                Client.__cobertura_counters[192] = Client.__cobertura_counters[192] + 1;
                var2_2 = 194;
                if ("running".equals(monitorInput.toLowerCase())) {
                    Client.__cobertura_counters[193] = Client.__cobertura_counters[193] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[195] = Client.__cobertura_counters[195] + 1;
                    this.monitorType = MonitorTypes.RUNNING;
                } else {
                    v17 = var2_2;
                    Client.__cobertura_counters[v17] = Client.__cobertura_counters[v17] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[196] = Client.__cobertura_counters[196] + 1;
                    var2_2 = 198;
                    if ("finished".equals(monitorInput.toLowerCase())) {
                        Client.__cobertura_counters[197] = Client.__cobertura_counters[197] + 1;
                        var2_2 = 0;
                        Client.__cobertura_counters[199] = Client.__cobertura_counters[199] + 1;
                        this.monitorType = MonitorTypes.FINISHED;
                    }
                }
            }
        }
        v18 = var2_2;
        Client.__cobertura_counters[v18] = Client.__cobertura_counters[v18] + 1;
        var2_2 = 0;
        Client.__cobertura_counters[200] = Client.__cobertura_counters[200] + 1;
        var2_2 = 202;
        if (cliParser.hasOption("json")) {
            Client.__cobertura_counters[201] = Client.__cobertura_counters[201] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[203] = Client.__cobertura_counters[203] + 1;
            this.is_JSON = true;
        }
        v19 = var2_2;
        Client.__cobertura_counters[v19] = Client.__cobertura_counters[v19] + 1;
        var2_2 = 0;
        Client.__cobertura_counters[204] = Client.__cobertura_counters[204] + 1;
        var2_2 = 206;
        if (cliParser.hasOption("checkAppId")) {
            Client.__cobertura_counters[205] = Client.__cobertura_counters[205] + 1;
            var2_2 = 0;
            var2_2 = 208;
            if (!this.monitor) {
                Client.__cobertura_counters[207] = Client.__cobertura_counters[207] + 1;
                var2_2 = 0;
                Client.__cobertura_counters[209] = Client.__cobertura_counters[209] + 1;
                this.checkAppId = cliParser.getOptionValue("checkAppId");
                Client.__cobertura_counters[210] = Client.__cobertura_counters[210] + 1;
                split_id = this.checkAppId.split("_");
                Client.__cobertura_counters[211] = Client.__cobertura_counters[211] + 1;
                var2_2 = 213;
                if (split_id.length != 3) {
                    Client.__cobertura_counters[212] = Client.__cobertura_counters[212] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[214] = Client.__cobertura_counters[214] + 1;
                    throw new IllegalArgumentException("Invalid ApplicationId specified: " + this.checkAppId);
                }
                v20 = var2_2;
                Client.__cobertura_counters[v20] = Client.__cobertura_counters[v20] + 1;
                var2_2 = 0;
                Client.__cobertura_counters[215] = Client.__cobertura_counters[215] + 1;
                this.applicationTimeStamp = Long.valueOf(split_id[1]);
                Client.__cobertura_counters[216] = Client.__cobertura_counters[216] + 1;
                this.applicationId = Integer.valueOf(split_id[2]);
            }
        }
        v21 = var2_2;
        Client.__cobertura_counters[v21] = Client.__cobertura_counters[v21] + 1;
        var2_2 = 0;
        Client.__cobertura_counters[217] = Client.__cobertura_counters[217] + 1;
        var2_2 = 219;
        if (!cliParser.hasOption("resource_dir")) ** GOTO lbl-1000
        Client.__cobertura_counters[218] = Client.__cobertura_counters[218] + 1;
        var2_2 = 0;
        var2_2 = 221;
        if (cliParser.hasOption("python_script")) {
            Client.__cobertura_counters[220] = Client.__cobertura_counters[220] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[222] = Client.__cobertura_counters[222] + 1;
            this.resource_dir = cliParser.getOptionValue("resource_dir");
            Client.__cobertura_counters[223] = Client.__cobertura_counters[223] + 1;
            this.pythonScriptPath = cliParser.getOptionValue("python_script");
        } else lbl-1000:
        // 2 sources

        {
            v22 = var2_2;
            Client.__cobertura_counters[v22] = Client.__cobertura_counters[v22] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[224] = Client.__cobertura_counters[224] + 1;
            var2_2 = 226;
            if (this.checkAppId.isEmpty()) {
                Client.__cobertura_counters[225] = Client.__cobertura_counters[225] + 1;
                var2_2 = 0;
                var2_2 = 228;
                if (!this.monitor) {
                    Client.__cobertura_counters[227] = Client.__cobertura_counters[227] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[229] = Client.__cobertura_counters[229] + 1;
                    throw new IllegalArgumentException("Resource directory and top level python script name are both needed to run graphlab on hadoop");
                }
            }
        }
        v23 = var2_2;
        Client.__cobertura_counters[v23] = Client.__cobertura_counters[v23] + 1;
        var2_2 = 0;
        Client.__cobertura_counters[230] = Client.__cobertura_counters[230] + 1;
        var2_2 = 232;
        if (cliParser.hasOption("dependencies")) {
            Client.__cobertura_counters[231] = Client.__cobertura_counters[231] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[233] = Client.__cobertura_counters[233] + 1;
            this.python_dependencies_file = cliParser.getOptionValue("dependencies");
        }
        v24 = var2_2;
        Client.__cobertura_counters[v24] = Client.__cobertura_counters[v24] + 1;
        var2_2 = 0;
        Client.__cobertura_counters[234] = Client.__cobertura_counters[234] + 1;
        var2_2 = 236;
        if (cliParser.hasOption("product_key")) {
            Client.__cobertura_counters[235] = Client.__cobertura_counters[235] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[237] = Client.__cobertura_counters[237] + 1;
            this.userCertPath = cliParser.getOptionValue("product_key");
        }
        v25 = var2_2;
        Client.__cobertura_counters[v25] = Client.__cobertura_counters[v25] + 1;
        var2_2 = 0;
        Client.__cobertura_counters[238] = Client.__cobertura_counters[238] + 1;
        var2_2 = 240;
        if (cliParser.hasOption("gl_source")) {
            Client.__cobertura_counters[239] = Client.__cobertura_counters[239] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[241] = Client.__cobertura_counters[241] + 1;
            this.gl_source = cliParser.getOptionValue("gl_source").toLowerCase();
            Client.__cobertura_counters[242] = Client.__cobertura_counters[242] + 1;
            var2_2 = 244;
            if (!this.gl_source.equals("native")) {
                Client.__cobertura_counters[243] = Client.__cobertura_counters[243] + 1;
                var2_2 = 0;
                var2_2 = 246;
                if (!this.gl_source.equals("none")) {
                    Client.__cobertura_counters[245] = Client.__cobertura_counters[245] + 1;
                    var2_2 = 0;
                    Client.__cobertura_counters[247] = Client.__cobertura_counters[247] + 1;
                    this.gl_source = cliParser.getOptionValue("gl_source");
                }
            }
        } else {
            v26 = var2_2;
            Client.__cobertura_counters[v26] = Client.__cobertura_counters[v26] + 1;
            var2_2 = 0;
            Client.__cobertura_counters[248] = Client.__cobertura_counters[248] + 1;
            this.gl_source = "none";
        }
        v27 = var2_2;
        Client.__cobertura_counters[v27] = Client.__cobertura_counters[v27] + 1;
        var2_2 = 0;
        Client.__cobertura_counters[249] = Client.__cobertura_counters[249] + 1;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void obtainUserResources(FileSystem fileSystem, ApplicationId applicationId, Map<String, LocalResource> map, Map<String, String> map2) throws IOException {
        void env;
        long userResourceTimestamp;
        long userResourceLen;
        String userPythonName;
        String userResourceLocation;
        int n;
        block17: {
            block16: {
                n = 0;
                __cobertura_counters[250] = __cobertura_counters[250] + 1;
                userResourceLocation = "";
                __cobertura_counters[251] = __cobertura_counters[251] + 1;
                userPythonName = "";
                __cobertura_counters[252] = __cobertura_counters[252] + 1;
                userResourceLen = 0L;
                __cobertura_counters[253] = __cobertura_counters[253] + 1;
                userResourceTimestamp = 0L;
                __cobertura_counters[254] = __cobertura_counters[254] + 1;
                String shellPathSuffix = this.appName + "/" + userResourcePath;
                __cobertura_counters[255] = __cobertura_counters[255] + 1;
                File dir = new File(this.resource_dir);
                __cobertura_counters[256] = __cobertura_counters[256] + 1;
                n = 258;
                if (dir.listFiles() == null) {
                    __cobertura_counters[257] = __cobertura_counters[257] + 1;
                    n = 0;
                    __cobertura_counters[259] = __cobertura_counters[259] + 1;
                    throw new IllegalArgumentException("-resource_dir " + this.resource_dir + " not found");
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[260] = __cobertura_counters[260] + 1;
                n = 262;
                if (this.writeDependencyScript(userResourceScriptPath, this.resource_dir, null) == 0) {
                    __cobertura_counters[261] = __cobertura_counters[261] + 1;
                    n = 0;
                    __cobertura_counters[263] = __cobertura_counters[263] + 1;
                    LOG.info((Object)"User Resource directory script wrote successfully");
                    __cobertura_counters[264] = __cobertura_counters[264] + 1;
                    this.runDependencyScript(userResourceScriptPath, this.resource_dir);
                    __cobertura_counters[265] = __cobertura_counters[265] + 1;
                    LOG.info((Object)"User Resource directory script ran successfully");
                    __cobertura_counters[266] = __cobertura_counters[266] + 1;
                    String folderName = "";
                    __cobertura_counters[267] = __cobertura_counters[267] + 1;
                    n = 269;
                    if (this.resource_dir.charAt(this.resource_dir.length() - 1) == '/') {
                        __cobertura_counters[268] = __cobertura_counters[268] + 1;
                        n = 0;
                        __cobertura_counters[270] = __cobertura_counters[270] + 1;
                        folderName = this.resource_dir.substring(0, this.resource_dir.lastIndexOf("/"));
                    } else {
                        int n3 = n;
                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                        n = 0;
                        __cobertura_counters[271] = __cobertura_counters[271] + 1;
                        folderName = this.resource_dir;
                    }
                    __cobertura_counters[272] = __cobertura_counters[272] + 1;
                    folderName = folderName.substring(folderName.lastIndexOf("/") + 1, folderName.length());
                    __cobertura_counters[273] = __cobertura_counters[273] + 1;
                    File[] arr$ = dir.listFiles();
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        n = 275;
                        if (i$ >= len$) break;
                        __cobertura_counters[274] = __cobertura_counters[274] + 1;
                        n = 0;
                        File f = arr$[i$];
                        __cobertura_counters[277] = __cobertura_counters[277] + 1;
                        n = 279;
                        if (f.getName().equals(folderName + ".tar.gz")) {
                            void localResources;
                            void appId;
                            void fs;
                            __cobertura_counters[278] = __cobertura_counters[278] + 1;
                            n = 0;
                            __cobertura_counters[280] = __cobertura_counters[280] + 1;
                            this.addToLocalSharedResources((FileSystem)fs, f.getPath(), userResourcePath, folderName + ".tar.gz", appId.getId(), (Map<String, LocalResource>)localResources, null);
                            __cobertura_counters[281] = __cobertura_counters[281] + 1;
                            Path filePath = new Path(fs.getHomeDirectory(), shellPathSuffix + "/" + f.getName());
                            __cobertura_counters[282] = __cobertura_counters[282] + 1;
                            userResourceLocation = filePath.toUri().toString();
                            __cobertura_counters[283] = __cobertura_counters[283] + 1;
                            FileStatus fStat = fs.getFileStatus(filePath);
                            __cobertura_counters[284] = __cobertura_counters[284] + 1;
                            userResourceLen = fStat.getLen();
                            __cobertura_counters[285] = __cobertura_counters[285] + 1;
                            userResourceTimestamp = fStat.getModificationTime();
                            __cobertura_counters[286] = __cobertura_counters[286] + 1;
                            LOG.info((Object)"User Resource directory tar file uploaded to hdfs successfully");
                            __cobertura_counters[287] = __cobertura_counters[287] + 1;
                            String pyPath = "";
                            __cobertura_counters[288] = __cobertura_counters[288] + 1;
                            n = 290;
                            if (this.pythonScriptPath.lastIndexOf(folderName) > -1) {
                                __cobertura_counters[289] = __cobertura_counters[289] + 1;
                                n = 0;
                                __cobertura_counters[291] = __cobertura_counters[291] + 1;
                                pyPath = this.pythonScriptPath.substring(this.pythonScriptPath.lastIndexOf(folderName), this.pythonScriptPath.length());
                            } else {
                                int n4 = n;
                                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                                n = 0;
                                __cobertura_counters[292] = __cobertura_counters[292] + 1;
                                String scriptName = this.pythonScriptPath.substring(this.pythonScriptPath.lastIndexOf("/") + 1, this.pythonScriptPath.length());
                                __cobertura_counters[293] = __cobertura_counters[293] + 1;
                                n = 295;
                                if (folderName.lastIndexOf("/") > 0) {
                                    __cobertura_counters[294] = __cobertura_counters[294] + 1;
                                    n = 0;
                                    __cobertura_counters[296] = __cobertura_counters[296] + 1;
                                    pyPath = folderName + scriptName;
                                } else {
                                    int n5 = n;
                                    __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                                    n = 0;
                                    __cobertura_counters[297] = __cobertura_counters[297] + 1;
                                    pyPath = folderName + "/" + scriptName;
                                }
                            }
                            __cobertura_counters[298] = __cobertura_counters[298] + 1;
                            userPythonName = pyPath;
                            __cobertura_counters[299] = __cobertura_counters[299] + 1;
                            n = 301;
                            if (!this.debugFlag) {
                                __cobertura_counters[300] = __cobertura_counters[300] + 1;
                                n = 0;
                                __cobertura_counters[302] = __cobertura_counters[302] + 1;
                                f.delete();
                            }
                        }
                        int n6 = n;
                        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                        n = 0;
                        __cobertura_counters[276] = __cobertura_counters[276] + 1;
                        ++i$;
                    }
                    int n7 = n;
                    __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                    n = 0;
                    __cobertura_counters[303] = __cobertura_counters[303] + 1;
                    File scriptFile = new File(userResourceScriptPath);
                    __cobertura_counters[304] = __cobertura_counters[304] + 1;
                    n = 306;
                    if (!this.debugFlag) {
                        __cobertura_counters[305] = __cobertura_counters[305] + 1;
                        n = 0;
                        __cobertura_counters[307] = __cobertura_counters[307] + 1;
                        scriptFile.delete();
                    } else {
                        int n8 = n;
                        __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                        n = 0;
                        __cobertura_counters[308] = __cobertura_counters[308] + 1;
                        LOG.info((Object)("userResourceLocation: " + userResourceLocation));
                        __cobertura_counters[309] = __cobertura_counters[309] + 1;
                        LOG.info((Object)("userResourceLen: " + userResourceLen));
                        __cobertura_counters[310] = __cobertura_counters[310] + 1;
                        LOG.info((Object)("userResourceTimestamp: " + userResourceTimestamp));
                        __cobertura_counters[311] = __cobertura_counters[311] + 1;
                        LOG.info((Object)("userPythonName: " + userPythonName));
                    }
                }
                int n9 = n;
                __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                n = 0;
                __cobertura_counters[312] = __cobertura_counters[312] + 1;
                n = 314;
                if (userResourceLocation.isEmpty()) break block16;
                __cobertura_counters[313] = __cobertura_counters[313] + 1;
                n = 0;
                n = 316;
                if (userResourceLen == 0L) break block16;
                __cobertura_counters[315] = __cobertura_counters[315] + 1;
                n = 0;
                n = 318;
                if (userResourceTimestamp == 0L) break block16;
                __cobertura_counters[317] = __cobertura_counters[317] + 1;
                n = 0;
                n = 320;
                if (!userPythonName.isEmpty()) break block17;
                __cobertura_counters[319] = __cobertura_counters[319] + 1;
                n = 0;
            }
            int n10 = n;
            __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
            n = 0;
            __cobertura_counters[321] = __cobertura_counters[321] + 1;
            throw new IllegalArgumentException("Error while processing user resource directory and python script. Please check the input for resource_dir and python_script");
        }
        int n11 = n;
        __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
        n = 0;
        __cobertura_counters[322] = __cobertura_counters[322] + 1;
        env.put("GL_USER_RESOURCE_TAR", userResourceLocation);
        __cobertura_counters[323] = __cobertura_counters[323] + 1;
        env.put("GL_USER_RESOURCE_LENGTH", Long.toString(userResourceLen));
        __cobertura_counters[324] = __cobertura_counters[324] + 1;
        env.put("GL_USER_RESOURCE_TIMESTAMP", Long.toString(userResourceTimestamp));
        __cobertura_counters[325] = __cobertura_counters[325] + 1;
        env.put("GL_USER_PYTHON_NAME", userPythonName);
        __cobertura_counters[326] = __cobertura_counters[326] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public void obtainPythonDependencies(FileSystem fileSystem, ApplicationId applicationId, Map<String, LocalResource> map, Map<String, String> map2) throws IOException {
        void env;
        long pythonReqFileTimestamp;
        long pythonReqFileLen;
        long pythonResourceTimestamp;
        long pythonResourceLen;
        String pythonReqFileLocation;
        String pythonResourceLocation;
        int n;
        block16: {
            block15: {
                block12: {
                    n = 0;
                    __cobertura_counters[327] = __cobertura_counters[327] + 1;
                    pythonResourceLocation = "";
                    __cobertura_counters[328] = __cobertura_counters[328] + 1;
                    pythonReqFileLocation = "";
                    __cobertura_counters[329] = __cobertura_counters[329] + 1;
                    pythonResourceLen = 0L;
                    __cobertura_counters[330] = __cobertura_counters[330] + 1;
                    pythonResourceTimestamp = 0L;
                    __cobertura_counters[331] = __cobertura_counters[331] + 1;
                    pythonReqFileLen = 0L;
                    __cobertura_counters[332] = __cobertura_counters[332] + 1;
                    pythonReqFileTimestamp = 0L;
                    __cobertura_counters[333] = __cobertura_counters[333] + 1;
                    n = 335;
                    if (this.writeDependencyScript(dependencyScriptPath, userPythonDepPath, this.python_dependencies_file) != 0) break block12;
                    __cobertura_counters[334] = __cobertura_counters[334] + 1;
                    n = 0;
                    __cobertura_counters[336] = __cobertura_counters[336] + 1;
                    LOG.info((Object)"User python dep script wrote successfully");
                    __cobertura_counters[337] = __cobertura_counters[337] + 1;
                    this.runDependencyScript(dependencyScriptPath, userPythonDepPath);
                    __cobertura_counters[338] = __cobertura_counters[338] + 1;
                    LOG.info((Object)"User python dep script ran successfully");
                    __cobertura_counters[339] = __cobertura_counters[339] + 1;
                    String shellPathSuffix = this.appName + "/" + userPythonDepPath;
                    __cobertura_counters[340] = __cobertura_counters[340] + 1;
                    File dir = new File(userPythonDepPath);
                    __cobertura_counters[341] = __cobertura_counters[341] + 1;
                    File[] arr$ = dir.listFiles();
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        File f;
                        block14: {
                            void localResources;
                            void appId;
                            void fs;
                            String reqFileName;
                            String tarName;
                            block13: {
                                n = 343;
                                if (i$ >= len$) break;
                                __cobertura_counters[342] = __cobertura_counters[342] + 1;
                                n = 0;
                                f = arr$[i$];
                                __cobertura_counters[345] = __cobertura_counters[345] + 1;
                                tarName = "UserPythonDep.tar.gz";
                                __cobertura_counters[346] = __cobertura_counters[346] + 1;
                                reqFileName = "requirements.txt";
                                __cobertura_counters[347] = __cobertura_counters[347] + 1;
                                n = 349;
                                if (f.getName().equals(tarName)) break block13;
                                __cobertura_counters[348] = __cobertura_counters[348] + 1;
                                n = 0;
                                n = 351;
                                if (!f.getName().equals(reqFileName)) break block14;
                                __cobertura_counters[350] = __cobertura_counters[350] + 1;
                                n = 0;
                            }
                            int n2 = n;
                            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                            n = 0;
                            __cobertura_counters[352] = __cobertura_counters[352] + 1;
                            this.addToLocalSharedResources((FileSystem)fs, f.getPath(), userPythonDepPath, f.getName(), appId.getId(), (Map<String, LocalResource>)localResources, null);
                            __cobertura_counters[353] = __cobertura_counters[353] + 1;
                            Path filePath = new Path(fs.getHomeDirectory(), shellPathSuffix + "/" + f.getName());
                            __cobertura_counters[354] = __cobertura_counters[354] + 1;
                            FileStatus fStat = fs.getFileStatus(filePath);
                            __cobertura_counters[355] = __cobertura_counters[355] + 1;
                            n = 357;
                            if (f.getName().equals(tarName)) {
                                __cobertura_counters[356] = __cobertura_counters[356] + 1;
                                n = 0;
                                __cobertura_counters[358] = __cobertura_counters[358] + 1;
                                LOG.info((Object)"User python dep tar file uploaded to hdfs successfully");
                                __cobertura_counters[359] = __cobertura_counters[359] + 1;
                                pythonResourceLocation = filePath.toUri().toString();
                                __cobertura_counters[360] = __cobertura_counters[360] + 1;
                                pythonResourceLen = fStat.getLen();
                                __cobertura_counters[361] = __cobertura_counters[361] + 1;
                                pythonResourceTimestamp = fStat.getModificationTime();
                            }
                            int n3 = n;
                            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                            n = 0;
                            __cobertura_counters[362] = __cobertura_counters[362] + 1;
                            n = 364;
                            if (f.getName().equals(reqFileName)) {
                                __cobertura_counters[363] = __cobertura_counters[363] + 1;
                                n = 0;
                                __cobertura_counters[365] = __cobertura_counters[365] + 1;
                                LOG.info((Object)"User python dep requirement file uploaded to hdfs successfully");
                                __cobertura_counters[366] = __cobertura_counters[366] + 1;
                                pythonReqFileLocation = filePath.toUri().toString();
                                __cobertura_counters[367] = __cobertura_counters[367] + 1;
                                pythonReqFileLen = fStat.getLen();
                                __cobertura_counters[368] = __cobertura_counters[368] + 1;
                                pythonReqFileTimestamp = fStat.getModificationTime();
                            }
                        }
                        int n4 = n;
                        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                        n = 0;
                        __cobertura_counters[369] = __cobertura_counters[369] + 1;
                        n = 371;
                        if (!this.debugFlag) {
                            __cobertura_counters[370] = __cobertura_counters[370] + 1;
                            n = 0;
                            __cobertura_counters[372] = __cobertura_counters[372] + 1;
                            f.delete();
                        }
                        int n5 = n;
                        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                        n = 0;
                        __cobertura_counters[344] = __cobertura_counters[344] + 1;
                        ++i$;
                    }
                    int n6 = n;
                    __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                    n = 0;
                    __cobertura_counters[373] = __cobertura_counters[373] + 1;
                    n = 375;
                    if (!this.debugFlag) {
                        __cobertura_counters[374] = __cobertura_counters[374] + 1;
                        n = 0;
                        __cobertura_counters[376] = __cobertura_counters[376] + 1;
                        dir.delete();
                        __cobertura_counters[377] = __cobertura_counters[377] + 1;
                        File scriptFile = new File(dependencyScriptPath);
                        __cobertura_counters[378] = __cobertura_counters[378] + 1;
                        scriptFile.delete();
                        __cobertura_counters[379] = __cobertura_counters[379] + 1;
                    } else {
                        int n7 = n;
                        __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                        n = 0;
                        __cobertura_counters[380] = __cobertura_counters[380] + 1;
                        LOG.info((Object)("pythonResourceLocation: " + pythonResourceLocation));
                        __cobertura_counters[381] = __cobertura_counters[381] + 1;
                        LOG.info((Object)("pythonResourceLen: " + pythonResourceLen));
                        __cobertura_counters[382] = __cobertura_counters[382] + 1;
                        LOG.info((Object)("pythonResourceTimestamp: " + pythonResourceTimestamp));
                        __cobertura_counters[383] = __cobertura_counters[383] + 1;
                        LOG.info((Object)("pythonReqFileLocation: " + pythonReqFileLocation));
                        __cobertura_counters[384] = __cobertura_counters[384] + 1;
                        LOG.info((Object)("pythonReqFileLen: " + pythonReqFileLen));
                        __cobertura_counters[385] = __cobertura_counters[385] + 1;
                        LOG.info((Object)("pythonReqFileTimestamp: " + pythonReqFileTimestamp));
                    }
                }
                int n8 = n;
                __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                n = 0;
                __cobertura_counters[386] = __cobertura_counters[386] + 1;
                n = 388;
                if (pythonResourceLocation.isEmpty()) break block15;
                __cobertura_counters[387] = __cobertura_counters[387] + 1;
                n = 0;
                n = 390;
                if (pythonResourceLen == 0L) break block15;
                __cobertura_counters[389] = __cobertura_counters[389] + 1;
                n = 0;
                n = 392;
                if (pythonReqFileLen == 0L) break block15;
                __cobertura_counters[391] = __cobertura_counters[391] + 1;
                n = 0;
                n = 394;
                if (pythonResourceTimestamp == 0L) break block15;
                __cobertura_counters[393] = __cobertura_counters[393] + 1;
                n = 0;
                n = 396;
                if (pythonReqFileLocation.isEmpty()) break block15;
                __cobertura_counters[395] = __cobertura_counters[395] + 1;
                n = 0;
                n = 398;
                if (pythonReqFileTimestamp != 0L) break block16;
                __cobertura_counters[397] = __cobertura_counters[397] + 1;
                n = 0;
            }
            int n9 = n;
            __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
            n = 0;
            __cobertura_counters[399] = __cobertura_counters[399] + 1;
            throw new IllegalArgumentException("Error while processing user python dependency files and requirement file. Please check the input for dependencies");
        }
        int n10 = n;
        __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
        n = 0;
        __cobertura_counters[400] = __cobertura_counters[400] + 1;
        env.put("GL_USER_REQS_TAR", pythonResourceLocation);
        __cobertura_counters[401] = __cobertura_counters[401] + 1;
        env.put("GL_USER_REQS_LENGTH", Long.toString(pythonResourceLen));
        __cobertura_counters[402] = __cobertura_counters[402] + 1;
        env.put("GL_USER_REQS_TIMESTAMP", Long.toString(pythonResourceTimestamp));
        __cobertura_counters[403] = __cobertura_counters[403] + 1;
        env.put("GL_USER_REQS_PIP_FILE", pythonReqFileLocation);
        __cobertura_counters[404] = __cobertura_counters[404] + 1;
        env.put("GL_USER_REQS_PIP_FILE_LENGTH", Long.toString(pythonReqFileLen));
        __cobertura_counters[405] = __cobertura_counters[405] + 1;
        env.put("GL_USER_REQS_PIP_FILE_TIMESTAMP", Long.toString(pythonReqFileTimestamp));
        __cobertura_counters[406] = __cobertura_counters[406] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public void obtainGraphlabProductKey(FileSystem fileSystem, ApplicationId applicationId, Map<String, LocalResource> map, Map<String, String> map2) throws IOException {
        void env;
        long glUserCertTimestamp;
        long glUserCertLen;
        String glUserCertPath;
        int n;
        block9: {
            block8: {
                Path dstCert;
                void fs;
                block5: {
                    File certFile;
                    block7: {
                        block6: {
                            block4: {
                                n = 0;
                                __cobertura_counters[407] = __cobertura_counters[407] + 1;
                                glUserCertPath = "";
                                __cobertura_counters[408] = __cobertura_counters[408] + 1;
                                glUserCertLen = 0L;
                                __cobertura_counters[409] = __cobertura_counters[409] + 1;
                                glUserCertTimestamp = 0L;
                                __cobertura_counters[410] = __cobertura_counters[410] + 1;
                                String cert_dst = this.appName + "/" + glCertPath + "/gl_user_cert_config";
                                __cobertura_counters[411] = __cobertura_counters[411] + 1;
                                dstCert = new Path(fs.getHomeDirectory(), cert_dst);
                                __cobertura_counters[412] = __cobertura_counters[412] + 1;
                                n = 414;
                                if (this.userCertPath.isEmpty()) break block4;
                                __cobertura_counters[413] = __cobertura_counters[413] + 1;
                                n = 0;
                                __cobertura_counters[415] = __cobertura_counters[415] + 1;
                                Path srcCert = new Path(this.userCertPath);
                                __cobertura_counters[416] = __cobertura_counters[416] + 1;
                                LOG.info((Object)"Found input user product key, copying...");
                                __cobertura_counters[417] = __cobertura_counters[417] + 1;
                                fs.copyFromLocalFile(srcCert, dstCert);
                                __cobertura_counters[418] = __cobertura_counters[418] + 1;
                                break block5;
                            }
                            int n2 = n;
                            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                            n = 0;
                            __cobertura_counters[419] = __cobertura_counters[419] + 1;
                            certFile = new File(System.getProperty("user.home"), ".graphlab/config");
                            __cobertura_counters[420] = __cobertura_counters[420] + 1;
                            n = 422;
                            if (certFile == null) break block6;
                            __cobertura_counters[421] = __cobertura_counters[421] + 1;
                            n = 0;
                            n = 424;
                            if (!certFile.exists()) break block6;
                            __cobertura_counters[423] = __cobertura_counters[423] + 1;
                            n = 0;
                            n = 426;
                            if (certFile.isFile()) break block7;
                            __cobertura_counters[425] = __cobertura_counters[425] + 1;
                            n = 0;
                        }
                        int n3 = n;
                        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                        n = 0;
                        __cobertura_counters[427] = __cobertura_counters[427] + 1;
                        LOG.info((Object)"Invalid graphlab certificate. Please specify your graphlab certificate with -product_key option or specify your certificate in /home/.graphlab/config");
                        __cobertura_counters[428] = __cobertura_counters[428] + 1;
                        throw new IllegalArgumentException("Invalid graphlab certificate. Please specify your graphlab certificate with -product_key option or specify your certificate in /home/.graphlab/config");
                    }
                    int n4 = n;
                    __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                    n = 0;
                    __cobertura_counters[429] = __cobertura_counters[429] + 1;
                    LOG.info((Object)"Found user product key from config, copying...");
                    __cobertura_counters[430] = __cobertura_counters[430] + 1;
                    fs.copyFromLocalFile(new Path(certFile.getPath()), dstCert);
                }
                __cobertura_counters[431] = __cobertura_counters[431] + 1;
                FileStatus fsStatus = fs.getFileStatus(dstCert);
                __cobertura_counters[432] = __cobertura_counters[432] + 1;
                glUserCertPath = fsStatus.getPath().toUri().toString();
                __cobertura_counters[433] = __cobertura_counters[433] + 1;
                glUserCertLen = fsStatus.getLen();
                __cobertura_counters[434] = __cobertura_counters[434] + 1;
                glUserCertTimestamp = fsStatus.getModificationTime();
                __cobertura_counters[435] = __cobertura_counters[435] + 1;
                n = 437;
                if (glUserCertPath.isEmpty()) break block8;
                __cobertura_counters[436] = __cobertura_counters[436] + 1;
                n = 0;
                n = 439;
                if (glUserCertLen == 0L) break block8;
                __cobertura_counters[438] = __cobertura_counters[438] + 1;
                n = 0;
                n = 441;
                if (glUserCertTimestamp != 0L) break block9;
                __cobertura_counters[440] = __cobertura_counters[440] + 1;
                n = 0;
            }
            int n5 = n;
            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
            n = 0;
            __cobertura_counters[442] = __cobertura_counters[442] + 1;
            throw new IllegalArgumentException("Error while processing user certificate file. Please check the input for certificate file");
        }
        int n6 = n;
        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
        n = 0;
        __cobertura_counters[443] = __cobertura_counters[443] + 1;
        env.put("GL_USER_CERT_PATH", glUserCertPath);
        __cobertura_counters[444] = __cobertura_counters[444] + 1;
        env.put("GL_USER_CERT_LENGTH", Long.toString(glUserCertLen));
        __cobertura_counters[445] = __cobertura_counters[445] + 1;
        env.put("GL_USER_CERT_TIMESTAMP", Long.toString(glUserCertTimestamp));
        __cobertura_counters[446] = __cobertura_counters[446] + 1;
    }

    /*
     * WARNING - void declaration
     */
    public void obtainGraphlabReqs(FileSystem fileSystem, ApplicationId applicationId, Map<String, LocalResource> map, Map<String, String> map2) throws IOException {
        void env;
        long glResourceTimestamp;
        long glResourceLen;
        String glResourceNative;
        String glResourceLocation;
        int n;
        block37: {
            block36: {
                block27: {
                    void localResources;
                    void appId;
                    void fs;
                    block31: {
                        FileStatus glFile;
                        block34: {
                            block33: {
                                block26: {
                                    n = 0;
                                    __cobertura_counters[447] = __cobertura_counters[447] + 1;
                                    glResourceLocation = "";
                                    __cobertura_counters[448] = __cobertura_counters[448] + 1;
                                    glResourceNative = "";
                                    __cobertura_counters[449] = __cobertura_counters[449] + 1;
                                    glResourceLen = 0L;
                                    __cobertura_counters[450] = __cobertura_counters[450] + 1;
                                    glResourceTimestamp = 0L;
                                    __cobertura_counters[451] = __cobertura_counters[451] + 1;
                                    n = 453;
                                    if (!this.gl_source.equals("none")) break block26;
                                    __cobertura_counters[452] = __cobertura_counters[452] + 1;
                                    n = 0;
                                    n = 455;
                                    if (this.checkRequirementFiles((FileSystem)fs, glReqPath)) break block26;
                                    __cobertura_counters[454] = __cobertura_counters[454] + 1;
                                    n = 0;
                                    __cobertura_counters[456] = __cobertura_counters[456] + 1;
                                    n = 458;
                                    if (this.writeDependencyScript(glScriptPath, glReqPath, glReqPath) != 0) break block27;
                                    __cobertura_counters[457] = __cobertura_counters[457] + 1;
                                    n = 0;
                                    __cobertura_counters[459] = __cobertura_counters[459] + 1;
                                    LOG.info((Object)"Graphlab dep script wrote successfully");
                                    __cobertura_counters[460] = __cobertura_counters[460] + 1;
                                    String shellPathSuffix = this.appName + "/" + glReqPath;
                                    __cobertura_counters[461] = __cobertura_counters[461] + 1;
                                    File dir = new File(glReqPath);
                                    __cobertura_counters[462] = __cobertura_counters[462] + 1;
                                    n = 464;
                                    if (!dir.exists()) {
                                        __cobertura_counters[463] = __cobertura_counters[463] + 1;
                                        n = 0;
                                        __cobertura_counters[465] = __cobertura_counters[465] + 1;
                                        dir.mkdir();
                                    }
                                    int n2 = n;
                                    __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                                    n = 0;
                                    __cobertura_counters[466] = __cobertura_counters[466] + 1;
                                    java.net.URL is = this.getClass().getResource("/virtenv_utils/gl_create_base_virtenv.sh");
                                    try {
                                        __cobertura_counters[467] = __cobertura_counters[467] + 1;
                                        this.addToLocalSharedResources((FileSystem)fs, is.toURI().toString(), glReqPath, "gl_create_base_virtenv.sh", appId.getId(), (Map<String, LocalResource>)localResources, null);
                                    }
                                    catch (URISyntaxException uRISyntaxException) {
                                        __cobertura_counters[468] = __cobertura_counters[468] + 1;
                                        URISyntaxException ex = uRISyntaxException;
                                        __cobertura_counters[469] = __cobertura_counters[469] + 1;
                                        ex.printStackTrace();
                                        __cobertura_counters[470] = __cobertura_counters[470] + 1;
                                        LOG.info((Object)"Error when getting virtenv_utils/gl_create_base_virtenv.sh URI");
                                    }
                                    __cobertura_counters[471] = __cobertura_counters[471] + 1;
                                    __cobertura_counters[472] = __cobertura_counters[472] + 1;
                                    this.runDependencyScript(glScriptPath, glReqPath);
                                    __cobertura_counters[473] = __cobertura_counters[473] + 1;
                                    LOG.info((Object)"Graphlab dep script ran successfully");
                                    __cobertura_counters[474] = __cobertura_counters[474] + 1;
                                    dir = new File(glReqPath);
                                    __cobertura_counters[475] = __cobertura_counters[475] + 1;
                                    File[] arr$ = dir.listFiles();
                                    int len$ = arr$.length;
                                    int i$ = 0;
                                    while (true) {
                                        File f;
                                        block30: {
                                            String tarName;
                                            block29: {
                                                n = 477;
                                                if (i$ >= len$) break;
                                                __cobertura_counters[476] = __cobertura_counters[476] + 1;
                                                n = 0;
                                                f = arr$[i$];
                                                __cobertura_counters[479] = __cobertura_counters[479] + 1;
                                                tarName = "gl_reqs.tar.gz";
                                                __cobertura_counters[480] = __cobertura_counters[480] + 1;
                                                String reqFileName = "output_gl_reqs.txt";
                                                __cobertura_counters[481] = __cobertura_counters[481] + 1;
                                                n = 483;
                                                if (f.getName().equals(tarName)) break block29;
                                                __cobertura_counters[482] = __cobertura_counters[482] + 1;
                                                n = 0;
                                                n = 485;
                                                if (!f.getName().equals(reqFileName)) break block30;
                                                __cobertura_counters[484] = __cobertura_counters[484] + 1;
                                                n = 0;
                                            }
                                            int n3 = n;
                                            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                                            n = 0;
                                            __cobertura_counters[486] = __cobertura_counters[486] + 1;
                                            LOG.info((Object)"Graphlab dep locations updating");
                                            __cobertura_counters[487] = __cobertura_counters[487] + 1;
                                            this.addToLocalSharedResources((FileSystem)fs, f.getPath(), glReqPath, f.getName(), appId.getId(), (Map<String, LocalResource>)localResources, null);
                                            __cobertura_counters[488] = __cobertura_counters[488] + 1;
                                            Path filePath = new Path(fs.getHomeDirectory(), shellPathSuffix + "/" + f.getName());
                                            __cobertura_counters[489] = __cobertura_counters[489] + 1;
                                            FileStatus fStat = fs.getFileStatus(filePath);
                                            __cobertura_counters[490] = __cobertura_counters[490] + 1;
                                            n = 492;
                                            if (f.getName().equals(tarName)) {
                                                __cobertura_counters[491] = __cobertura_counters[491] + 1;
                                                n = 0;
                                                __cobertura_counters[493] = __cobertura_counters[493] + 1;
                                                glResourceLocation = filePath.toUri().toString();
                                                __cobertura_counters[494] = __cobertura_counters[494] + 1;
                                                glResourceLen = fStat.getLen();
                                                __cobertura_counters[495] = __cobertura_counters[495] + 1;
                                                glResourceTimestamp = fStat.getModificationTime();
                                                __cobertura_counters[496] = __cobertura_counters[496] + 1;
                                                glResourceNative = "hdfs";
                                                __cobertura_counters[497] = __cobertura_counters[497] + 1;
                                                LOG.info((Object)"Graphlab dep locations updated successfully");
                                            }
                                        }
                                        int n4 = n;
                                        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                                        n = 0;
                                        __cobertura_counters[498] = __cobertura_counters[498] + 1;
                                        n = 500;
                                        if (!this.debugFlag) {
                                            __cobertura_counters[499] = __cobertura_counters[499] + 1;
                                            n = 0;
                                            __cobertura_counters[501] = __cobertura_counters[501] + 1;
                                            f.delete();
                                        }
                                        int n5 = n;
                                        __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                                        n = 0;
                                        __cobertura_counters[478] = __cobertura_counters[478] + 1;
                                        ++i$;
                                    }
                                    int n6 = n;
                                    __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                                    n = 0;
                                    __cobertura_counters[502] = __cobertura_counters[502] + 1;
                                    File scriptFile = new File(glScriptPath);
                                    __cobertura_counters[503] = __cobertura_counters[503] + 1;
                                    n = 505;
                                    if (!this.debugFlag) {
                                        __cobertura_counters[504] = __cobertura_counters[504] + 1;
                                        n = 0;
                                        __cobertura_counters[506] = __cobertura_counters[506] + 1;
                                        dir.delete();
                                        __cobertura_counters[507] = __cobertura_counters[507] + 1;
                                        scriptFile.delete();
                                    } else {
                                        int n7 = n;
                                        __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                                        n = 0;
                                        __cobertura_counters[508] = __cobertura_counters[508] + 1;
                                        LOG.info((Object)("glResourceLocation: " + glResourceLocation));
                                        __cobertura_counters[509] = __cobertura_counters[509] + 1;
                                        LOG.info((Object)("glResourceLen: " + glResourceLen));
                                        __cobertura_counters[510] = __cobertura_counters[510] + 1;
                                        LOG.info((Object)("glResourceTimestamp: " + glResourceTimestamp));
                                    }
                                    __cobertura_counters[511] = __cobertura_counters[511] + 1;
                                    break block27;
                                }
                                int n8 = n;
                                __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                                n = 0;
                                __cobertura_counters[512] = __cobertura_counters[512] + 1;
                                n = 514;
                                if (this.gl_source.equals("native")) break block31;
                                __cobertura_counters[513] = __cobertura_counters[513] + 1;
                                n = 0;
                                n = 516;
                                if (this.gl_source.equals("none")) break block31;
                                __cobertura_counters[515] = __cobertura_counters[515] + 1;
                                n = 0;
                                __cobertura_counters[517] = __cobertura_counters[517] + 1;
                                java.net.URL is = this.getClass().getResource("/virtenv_utils/gl_create_base_virtenv.sh");
                                try {
                                    __cobertura_counters[518] = __cobertura_counters[518] + 1;
                                    this.addToLocalSharedResources((FileSystem)fs, is.toURI().toString(), glReqPath, "gl_create_base_virtenv.sh", appId.getId(), (Map<String, LocalResource>)localResources, null);
                                }
                                catch (URISyntaxException uRISyntaxException) {
                                    __cobertura_counters[519] = __cobertura_counters[519] + 1;
                                    URISyntaxException ex = uRISyntaxException;
                                    __cobertura_counters[520] = __cobertura_counters[520] + 1;
                                    ex.printStackTrace();
                                    __cobertura_counters[521] = __cobertura_counters[521] + 1;
                                    LOG.info((Object)"Error when getting virtenv_utils/gl_create_base_virtenv.sh URI");
                                }
                                __cobertura_counters[522] = __cobertura_counters[522] + 1;
                                __cobertura_counters[523] = __cobertura_counters[523] + 1;
                                Path glHDFSpath = new Path(this.gl_source);
                                __cobertura_counters[524] = __cobertura_counters[524] + 1;
                                glFile = fs.getFileStatus(glHDFSpath);
                                __cobertura_counters[525] = __cobertura_counters[525] + 1;
                                n = 527;
                                if (glFile == null) break block33;
                                __cobertura_counters[526] = __cobertura_counters[526] + 1;
                                n = 0;
                                n = 529;
                                if (glFile.isFile()) break block34;
                                __cobertura_counters[528] = __cobertura_counters[528] + 1;
                                n = 0;
                            }
                            int n9 = n;
                            __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                            n = 0;
                            __cobertura_counters[530] = __cobertura_counters[530] + 1;
                            throw new IllegalArgumentException("Error while processing gl_source file location specified on HDFS");
                        }
                        int n10 = n;
                        __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                        n = 0;
                        __cobertura_counters[531] = __cobertura_counters[531] + 1;
                        glResourceLocation = glFile.getPath().toUri().toString();
                        __cobertura_counters[532] = __cobertura_counters[532] + 1;
                        glResourceLen = glFile.getLen();
                        __cobertura_counters[533] = __cobertura_counters[533] + 1;
                        glResourceTimestamp = glFile.getModificationTime();
                        __cobertura_counters[534] = __cobertura_counters[534] + 1;
                        glResourceNative = "hdfs";
                        __cobertura_counters[535] = __cobertura_counters[535] + 1;
                        LOG.info((Object)"Graphlab dep locations updated successfully");
                        __cobertura_counters[536] = __cobertura_counters[536] + 1;
                        break block27;
                    }
                    int n11 = n;
                    __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
                    n = 0;
                    __cobertura_counters[537] = __cobertura_counters[537] + 1;
                    java.net.URL is = this.getClass().getResource("/virtenv_utils/gl_create_base_virtenv.sh");
                    try {
                        __cobertura_counters[538] = __cobertura_counters[538] + 1;
                        this.addToLocalSharedResources((FileSystem)fs, is.toURI().toString(), glReqPath, "gl_create_base_virtenv.sh", appId.getId(), (Map<String, LocalResource>)localResources, null);
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        __cobertura_counters[539] = __cobertura_counters[539] + 1;
                        URISyntaxException ex = uRISyntaxException;
                        __cobertura_counters[540] = __cobertura_counters[540] + 1;
                        ex.printStackTrace();
                        __cobertura_counters[541] = __cobertura_counters[541] + 1;
                        LOG.info((Object)"Error when getting virtenv_utils/gl_create_base_virtenv.sh URI");
                    }
                    __cobertura_counters[542] = __cobertura_counters[542] + 1;
                    __cobertura_counters[543] = __cobertura_counters[543] + 1;
                    n = 545;
                    if (this.gl_source.equals("native")) {
                        __cobertura_counters[544] = __cobertura_counters[544] + 1;
                        n = 0;
                        __cobertura_counters[546] = __cobertura_counters[546] + 1;
                        glResourceNative = "native";
                        __cobertura_counters[547] = __cobertura_counters[547] + 1;
                        glResourceLocation = "native";
                        __cobertura_counters[548] = __cobertura_counters[548] + 1;
                        glResourceLen = 1L;
                        __cobertura_counters[549] = __cobertura_counters[549] + 1;
                        glResourceTimestamp = 1L;
                    } else {
                        int n12 = n;
                        __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
                        n = 0;
                        __cobertura_counters[550] = __cobertura_counters[550] + 1;
                        glResourceNative = "hdfs";
                        __cobertura_counters[551] = __cobertura_counters[551] + 1;
                        String tarPath = this.appName + "/" + glReqPath + "/" + glReqPath + ".tar.gz";
                        __cobertura_counters[552] = __cobertura_counters[552] + 1;
                        FileStatus glFile = fs.getFileStatus(new Path(fs.getHomeDirectory(), tarPath));
                        __cobertura_counters[553] = __cobertura_counters[553] + 1;
                        glResourceLocation = glFile.getPath().toUri().toString();
                        __cobertura_counters[554] = __cobertura_counters[554] + 1;
                        glResourceLen = glFile.getLen();
                        __cobertura_counters[555] = __cobertura_counters[555] + 1;
                        glResourceTimestamp = glFile.getModificationTime();
                    }
                    __cobertura_counters[556] = __cobertura_counters[556] + 1;
                    LOG.info((Object)"Graphlab dep locations updated successfully");
                }
                int n13 = n;
                __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
                n = 0;
                __cobertura_counters[557] = __cobertura_counters[557] + 1;
                n = 559;
                if (glResourceLocation.isEmpty()) break block36;
                __cobertura_counters[558] = __cobertura_counters[558] + 1;
                n = 0;
                n = 561;
                if (glResourceLen == 0L) break block36;
                __cobertura_counters[560] = __cobertura_counters[560] + 1;
                n = 0;
                n = 563;
                if (glResourceTimestamp == 0L) break block36;
                __cobertura_counters[562] = __cobertura_counters[562] + 1;
                n = 0;
                n = 565;
                if (!glResourceNative.isEmpty()) break block37;
                __cobertura_counters[564] = __cobertura_counters[564] + 1;
                n = 0;
            }
            int n14 = n;
            __cobertura_counters[n14] = __cobertura_counters[n14] + 1;
            n = 0;
            __cobertura_counters[566] = __cobertura_counters[566] + 1;
            throw new IllegalArgumentException("Error while processing gl requirement files. Please run this job again");
        }
        int n15 = n;
        __cobertura_counters[n15] = __cobertura_counters[n15] + 1;
        n = 0;
        __cobertura_counters[567] = __cobertura_counters[567] + 1;
        env.put("GL_SOURCE_TAR", glResourceLocation);
        __cobertura_counters[568] = __cobertura_counters[568] + 1;
        env.put("GL_SOURCE_LEN", Long.toString(glResourceLen));
        __cobertura_counters[569] = __cobertura_counters[569] + 1;
        env.put("GL_SOURCE_TIMESTAMP", Long.toString(glResourceTimestamp));
        __cobertura_counters[570] = __cobertura_counters[570] + 1;
        env.put("GL_SOURCE_NATIVE", glResourceNative);
        __cobertura_counters[571] = __cobertura_counters[571] + 1;
    }

    public ExitStatus run() throws IOException, YarnException {
        ContainerLaunchContext amContainer;
        ApplicationId appId;
        ApplicationSubmissionContext appContext;
        int n;
        block21: {
            String tokenRenewer;
            Credentials credentials;
            FileSystem fs;
            block23: {
                block22: {
                    n = 0;
                    __cobertura_counters[572] = __cobertura_counters[572] + 1;
                    LOG.info((Object)"Running Client");
                    __cobertura_counters[573] = __cobertura_counters[573] + 1;
                    this.yarnClient.start();
                    __cobertura_counters[574] = __cobertura_counters[574] + 1;
                    n = 576;
                    if (this.monitor) {
                        __cobertura_counters[575] = __cobertura_counters[575] + 1;
                        n = 0;
                        __cobertura_counters[577] = __cobertura_counters[577] + 1;
                        return this.monitorGraphlabApplications();
                    }
                    int n2 = n;
                    __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                    n = 0;
                    __cobertura_counters[578] = __cobertura_counters[578] + 1;
                    n = 580;
                    if (!this.checkAppId.isEmpty()) {
                        __cobertura_counters[579] = __cobertura_counters[579] + 1;
                        n = 0;
                        __cobertura_counters[581] = __cobertura_counters[581] + 1;
                        ApplicationId checkId = ApplicationId.newInstance((long)this.applicationTimeStamp, (int)this.applicationId);
                        __cobertura_counters[582] = __cobertura_counters[582] + 1;
                        return this.monitorApplication(checkId);
                    }
                    int n3 = n;
                    __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                    n = 0;
                    __cobertura_counters[583] = __cobertura_counters[583] + 1;
                    YarnClientApplication app = this.yarnClient.createApplication();
                    __cobertura_counters[584] = __cobertura_counters[584] + 1;
                    GetNewApplicationResponse appResponse = app.getNewApplicationResponse();
                    __cobertura_counters[585] = __cobertura_counters[585] + 1;
                    int maxMem = appResponse.getMaximumResourceCapability().getMemory();
                    __cobertura_counters[586] = __cobertura_counters[586] + 1;
                    LOG.info((Object)("Max mem capabililty of resources in this cluster " + maxMem));
                    __cobertura_counters[587] = __cobertura_counters[587] + 1;
                    n = 589;
                    if (this.amMemory > maxMem) {
                        __cobertura_counters[588] = __cobertura_counters[588] + 1;
                        n = 0;
                        __cobertura_counters[590] = __cobertura_counters[590] + 1;
                        LOG.info((Object)("AM memory specified above max threshold of cluster. Using max value., specified=" + this.amMemory + ", max=" + maxMem));
                        __cobertura_counters[591] = __cobertura_counters[591] + 1;
                        this.amMemory = maxMem;
                    }
                    int n4 = n;
                    __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                    n = 0;
                    __cobertura_counters[592] = __cobertura_counters[592] + 1;
                    int maxVCores = appResponse.getMaximumResourceCapability().getVirtualCores();
                    __cobertura_counters[593] = __cobertura_counters[593] + 1;
                    LOG.info((Object)("Max virtual cores capabililty of resources in this cluster " + maxVCores));
                    __cobertura_counters[594] = __cobertura_counters[594] + 1;
                    n = 596;
                    if (this.amVCores > maxVCores) {
                        __cobertura_counters[595] = __cobertura_counters[595] + 1;
                        n = 0;
                        __cobertura_counters[597] = __cobertura_counters[597] + 1;
                        LOG.info((Object)("AM virtual cores specified above max threshold of cluster. Using max value., specified=" + this.amVCores + ", max=" + maxVCores));
                        __cobertura_counters[598] = __cobertura_counters[598] + 1;
                        this.amVCores = maxVCores;
                    }
                    int n5 = n;
                    __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                    n = 0;
                    __cobertura_counters[599] = __cobertura_counters[599] + 1;
                    appContext = app.getApplicationSubmissionContext();
                    __cobertura_counters[600] = __cobertura_counters[600] + 1;
                    appContext.setApplicationName(this.appName);
                    __cobertura_counters[601] = __cobertura_counters[601] + 1;
                    appContext.setApplicationType("Graphlab");
                    __cobertura_counters[602] = __cobertura_counters[602] + 1;
                    appId = appContext.getApplicationId();
                    __cobertura_counters[603] = __cobertura_counters[603] + 1;
                    amContainer = (ContainerLaunchContext)Records.newRecord(ContainerLaunchContext.class);
                    __cobertura_counters[604] = __cobertura_counters[604] + 1;
                    HashMap<String, LocalResource> localResources = new HashMap<String, LocalResource>();
                    __cobertura_counters[605] = __cobertura_counters[605] + 1;
                    LOG.info((Object)"Copy App Master jar from local filesystem and add to local environment");
                    __cobertura_counters[606] = __cobertura_counters[606] + 1;
                    fs = FileSystem.get((Configuration)this.conf);
                    __cobertura_counters[607] = __cobertura_counters[607] + 1;
                    this.addToLocalResources(fs, this.appMasterJar, appMasterJarPath, appId.getId(), localResources, null, null);
                    __cobertura_counters[608] = __cobertura_counters[608] + 1;
                    n = 610;
                    if (!this.log4jPropFile.isEmpty()) {
                        __cobertura_counters[609] = __cobertura_counters[609] + 1;
                        n = 0;
                        __cobertura_counters[611] = __cobertura_counters[611] + 1;
                        this.addToLocalResources(fs, this.log4jPropFile, log4jPath, appId.getId(), localResources, null, null);
                    }
                    int n6 = n;
                    __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                    n = 0;
                    __cobertura_counters[612] = __cobertura_counters[612] + 1;
                    LOG.info((Object)"Set the environment for the application master");
                    __cobertura_counters[613] = __cobertura_counters[613] + 1;
                    HashMap<String, String> env = new HashMap<String, String>();
                    __cobertura_counters[614] = __cobertura_counters[614] + 1;
                    n = 616;
                    if (this.gl_art) {
                        __cobertura_counters[615] = __cobertura_counters[615] + 1;
                        n = 0;
                        __cobertura_counters[617] = __cobertura_counters[617] + 1;
                        this.uploadTaskArchive(fs, appId, localResources, env);
                    }
                    int n7 = n;
                    __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                    n = 0;
                    __cobertura_counters[618] = __cobertura_counters[618] + 1;
                    n = 620;
                    if (!this.resource_dir.isEmpty()) {
                        __cobertura_counters[619] = __cobertura_counters[619] + 1;
                        n = 0;
                        __cobertura_counters[621] = __cobertura_counters[621] + 1;
                        this.obtainUserResources(fs, appId, localResources, env);
                    }
                    int n8 = n;
                    __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                    n = 0;
                    __cobertura_counters[622] = __cobertura_counters[622] + 1;
                    n = 624;
                    if (this.pythonArgs.length > 0) {
                        __cobertura_counters[623] = __cobertura_counters[623] + 1;
                        n = 0;
                        __cobertura_counters[625] = __cobertura_counters[625] + 1;
                        env.put("GL_USER_PYTHON_ARGS", StringUtils.join((Object[])this.pythonArgs, (String)" "));
                    }
                    int n9 = n;
                    __cobertura_counters[n9] = __cobertura_counters[n9] + 1;
                    n = 0;
                    __cobertura_counters[626] = __cobertura_counters[626] + 1;
                    n = 628;
                    if (!this.python_dependencies_file.isEmpty()) {
                        __cobertura_counters[627] = __cobertura_counters[627] + 1;
                        n = 0;
                        __cobertura_counters[629] = __cobertura_counters[629] + 1;
                        this.obtainPythonDependencies(fs, appId, localResources, env);
                    }
                    int n10 = n;
                    __cobertura_counters[n10] = __cobertura_counters[n10] + 1;
                    n = 0;
                    __cobertura_counters[630] = __cobertura_counters[630] + 1;
                    n = 632;
                    if (this.use_cache) {
                        __cobertura_counters[631] = __cobertura_counters[631] + 1;
                        n = 0;
                        __cobertura_counters[633] = __cobertura_counters[633] + 1;
                        env.put("USE_CACHE", "/tmp/GRAPHLAB_CACHE_VIRTENV");
                    }
                    int n11 = n;
                    __cobertura_counters[n11] = __cobertura_counters[n11] + 1;
                    n = 0;
                    __cobertura_counters[634] = __cobertura_counters[634] + 1;
                    this.obtainGraphlabProductKey(fs, appId, localResources, env);
                    __cobertura_counters[635] = __cobertura_counters[635] + 1;
                    this.obtainGraphlabReqs(fs, appId, localResources, env);
                    __cobertura_counters[636] = __cobertura_counters[636] + 1;
                    amContainer.setLocalResources(localResources);
                    __cobertura_counters[637] = __cobertura_counters[637] + 1;
                    StringBuilder classPathEnv = new StringBuilder(ApplicationConstants.Environment.CLASSPATH.$()).append(File.pathSeparatorChar).append("./*");
                    __cobertura_counters[638] = __cobertura_counters[638] + 1;
                    String[] arr$ = this.conf.getStrings("yarn.application.classpath", YarnConfiguration.DEFAULT_YARN_APPLICATION_CLASSPATH);
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        n = 640;
                        if (i$ >= len$) break;
                        __cobertura_counters[639] = __cobertura_counters[639] + 1;
                        n = 0;
                        String c = arr$[i$];
                        __cobertura_counters[642] = __cobertura_counters[642] + 1;
                        classPathEnv.append(File.pathSeparatorChar);
                        __cobertura_counters[643] = __cobertura_counters[643] + 1;
                        classPathEnv.append(c.trim());
                        __cobertura_counters[641] = __cobertura_counters[641] + 1;
                        ++i$;
                    }
                    int n12 = n;
                    __cobertura_counters[n12] = __cobertura_counters[n12] + 1;
                    n = 0;
                    __cobertura_counters[644] = __cobertura_counters[644] + 1;
                    classPathEnv.append(File.pathSeparatorChar).append("./log4j.properties");
                    __cobertura_counters[645] = __cobertura_counters[645] + 1;
                    n = 647;
                    if (this.conf.getBoolean("yarn.is.minicluster", false)) {
                        __cobertura_counters[646] = __cobertura_counters[646] + 1;
                        n = 0;
                        __cobertura_counters[648] = __cobertura_counters[648] + 1;
                        classPathEnv.append(':');
                        __cobertura_counters[649] = __cobertura_counters[649] + 1;
                        classPathEnv.append(System.getProperty("java.class.path"));
                    }
                    int n13 = n;
                    __cobertura_counters[n13] = __cobertura_counters[n13] + 1;
                    n = 0;
                    __cobertura_counters[650] = __cobertura_counters[650] + 1;
                    n = 652;
                    if (this.debugFlag) {
                        __cobertura_counters[651] = __cobertura_counters[651] + 1;
                        n = 0;
                        __cobertura_counters[653] = __cobertura_counters[653] + 1;
                        Iterator i$2 = env.keySet().iterator();
                        while (true) {
                            n = 655;
                            if (!i$2.hasNext()) break;
                            __cobertura_counters[654] = __cobertura_counters[654] + 1;
                            n = 0;
                            String key = (String)i$2.next();
                            __cobertura_counters[656] = __cobertura_counters[656] + 1;
                            LOG.info((Object)("client env key=" + key + " value=" + (String)env.get(key)));
                            __cobertura_counters[657] = __cobertura_counters[657] + 1;
                        }
                    }
                    int n14 = n;
                    __cobertura_counters[n14] = __cobertura_counters[n14] + 1;
                    n = 0;
                    __cobertura_counters[658] = __cobertura_counters[658] + 1;
                    env.put("CLASSPATH", classPathEnv.toString());
                    __cobertura_counters[659] = __cobertura_counters[659] + 1;
                    amContainer.setEnvironment(env);
                    __cobertura_counters[660] = __cobertura_counters[660] + 1;
                    Vector<String> vargs = new Vector<String>(30);
                    __cobertura_counters[661] = __cobertura_counters[661] + 1;
                    LOG.info((Object)"Setting up app master command");
                    __cobertura_counters[662] = __cobertura_counters[662] + 1;
                    vargs.add(ApplicationConstants.Environment.JAVA_HOME.$() + "/bin/java");
                    __cobertura_counters[663] = __cobertura_counters[663] + 1;
                    vargs.add("-Xmx" + this.amMemory + "m");
                    __cobertura_counters[664] = __cobertura_counters[664] + 1;
                    vargs.add(this.appMasterMainClass);
                    __cobertura_counters[665] = __cobertura_counters[665] + 1;
                    vargs.add("--container_memory " + String.valueOf(this.containerMemory));
                    __cobertura_counters[666] = __cobertura_counters[666] + 1;
                    vargs.add("--container_vcores " + String.valueOf(this.containerVirtualCores));
                    __cobertura_counters[667] = __cobertura_counters[667] + 1;
                    vargs.add("--num_containers " + String.valueOf(this.numContainers));
                    __cobertura_counters[668] = __cobertura_counters[668] + 1;
                    vargs.add("--priority " + String.valueOf(this.pythonScriptPriority));
                    __cobertura_counters[669] = __cobertura_counters[669] + 1;
                    n = 671;
                    if (this.debugFlag) {
                        __cobertura_counters[670] = __cobertura_counters[670] + 1;
                        n = 0;
                        __cobertura_counters[672] = __cobertura_counters[672] + 1;
                        vargs.add("--debug");
                    }
                    int n15 = n;
                    __cobertura_counters[n15] = __cobertura_counters[n15] + 1;
                    n = 0;
                    __cobertura_counters[673] = __cobertura_counters[673] + 1;
                    vargs.add("1><LOG_DIR>/gl_AppMaster.stdout");
                    __cobertura_counters[674] = __cobertura_counters[674] + 1;
                    vargs.add("2><LOG_DIR>/gl_AppMaster.stderr");
                    __cobertura_counters[675] = __cobertura_counters[675] + 1;
                    StringBuilder command = new StringBuilder();
                    __cobertura_counters[676] = __cobertura_counters[676] + 1;
                    Iterator i$2 = vargs.iterator();
                    while (true) {
                        n = 678;
                        if (!i$2.hasNext()) break;
                        __cobertura_counters[677] = __cobertura_counters[677] + 1;
                        n = 0;
                        CharSequence str = (CharSequence)i$2.next();
                        __cobertura_counters[679] = __cobertura_counters[679] + 1;
                        command.append(str).append(" ");
                        __cobertura_counters[680] = __cobertura_counters[680] + 1;
                    }
                    int n16 = n;
                    __cobertura_counters[n16] = __cobertura_counters[n16] + 1;
                    n = 0;
                    __cobertura_counters[681] = __cobertura_counters[681] + 1;
                    LOG.info((Object)("Completed setting up app master command " + command.toString()));
                    __cobertura_counters[682] = __cobertura_counters[682] + 1;
                    ArrayList<String> commands = new ArrayList<String>();
                    __cobertura_counters[683] = __cobertura_counters[683] + 1;
                    commands.add(command.toString());
                    __cobertura_counters[684] = __cobertura_counters[684] + 1;
                    amContainer.setCommands(commands);
                    __cobertura_counters[685] = __cobertura_counters[685] + 1;
                    Resource capability = (Resource)Records.newRecord(Resource.class);
                    __cobertura_counters[686] = __cobertura_counters[686] + 1;
                    capability.setMemory(this.amMemory);
                    __cobertura_counters[687] = __cobertura_counters[687] + 1;
                    capability.setVirtualCores(this.amVCores);
                    __cobertura_counters[688] = __cobertura_counters[688] + 1;
                    appContext.setResource(capability);
                    __cobertura_counters[689] = __cobertura_counters[689] + 1;
                    n = 691;
                    if (!UserGroupInformation.isSecurityEnabled()) break block21;
                    __cobertura_counters[690] = __cobertura_counters[690] + 1;
                    n = 0;
                    __cobertura_counters[692] = __cobertura_counters[692] + 1;
                    credentials = new Credentials();
                    __cobertura_counters[693] = __cobertura_counters[693] + 1;
                    tokenRenewer = this.conf.get("yarn.resourcemanager.principal");
                    __cobertura_counters[694] = __cobertura_counters[694] + 1;
                    n = 696;
                    if (tokenRenewer == null) break block22;
                    __cobertura_counters[695] = __cobertura_counters[695] + 1;
                    n = 0;
                    n = 698;
                    if (tokenRenewer.length() != 0) break block23;
                    __cobertura_counters[697] = __cobertura_counters[697] + 1;
                    n = 0;
                }
                int n17 = n;
                __cobertura_counters[n17] = __cobertura_counters[n17] + 1;
                n = 0;
                __cobertura_counters[699] = __cobertura_counters[699] + 1;
                throw new IOException("Can't get Master Kerberos principal for the RM to use as renewer");
            }
            int n18 = n;
            __cobertura_counters[n18] = __cobertura_counters[n18] + 1;
            n = 0;
            __cobertura_counters[700] = __cobertura_counters[700] + 1;
            Token[] tokens = fs.addDelegationTokens(tokenRenewer, credentials);
            __cobertura_counters[701] = __cobertura_counters[701] + 1;
            n = 703;
            if (tokens != null) {
                __cobertura_counters[702] = __cobertura_counters[702] + 1;
                n = 0;
                __cobertura_counters[704] = __cobertura_counters[704] + 1;
                Token[] arr$ = tokens;
                int len$ = arr$.length;
                int i$ = 0;
                while (true) {
                    n = 706;
                    if (i$ >= len$) break;
                    __cobertura_counters[705] = __cobertura_counters[705] + 1;
                    n = 0;
                    Token token = arr$[i$];
                    __cobertura_counters[708] = __cobertura_counters[708] + 1;
                    LOG.info((Object)("Got dt for " + fs.getUri() + "; " + token));
                    __cobertura_counters[707] = __cobertura_counters[707] + 1;
                    ++i$;
                }
            }
            int n19 = n;
            __cobertura_counters[n19] = __cobertura_counters[n19] + 1;
            n = 0;
            __cobertura_counters[709] = __cobertura_counters[709] + 1;
            DataOutputBuffer dob = new DataOutputBuffer();
            __cobertura_counters[710] = __cobertura_counters[710] + 1;
            credentials.writeTokenStorageToStream((DataOutputStream)dob);
            __cobertura_counters[711] = __cobertura_counters[711] + 1;
            ByteBuffer fsTokens = ByteBuffer.wrap(dob.getData(), 0, dob.getLength());
            __cobertura_counters[712] = __cobertura_counters[712] + 1;
            amContainer.setTokens(fsTokens);
        }
        int n20 = n;
        __cobertura_counters[n20] = __cobertura_counters[n20] + 1;
        n = 0;
        __cobertura_counters[713] = __cobertura_counters[713] + 1;
        appContext.setAMContainerSpec(amContainer);
        __cobertura_counters[714] = __cobertura_counters[714] + 1;
        Priority pri = (Priority)Records.newRecord(Priority.class);
        __cobertura_counters[715] = __cobertura_counters[715] + 1;
        pri.setPriority(this.amPriority);
        __cobertura_counters[716] = __cobertura_counters[716] + 1;
        appContext.setPriority(pri);
        __cobertura_counters[717] = __cobertura_counters[717] + 1;
        appContext.setQueue(this.amQueue);
        __cobertura_counters[718] = __cobertura_counters[718] + 1;
        LOG.info((Object)"Submitting application to ASM");
        __cobertura_counters[719] = __cobertura_counters[719] + 1;
        this.yarnClient.submitApplication(appContext);
        __cobertura_counters[720] = __cobertura_counters[720] + 1;
        return this.monitorApplication(appId);
    }

    /*
     * WARNING - void declaration
     */
    private void uploadTaskArchive(FileSystem fileSystem, ApplicationId applicationId, Map<String, LocalResource> map, Map<String, String> map2) throws IOException {
        void env;
        long taskTimestamp;
        long taskLen;
        String taskHDFSPath;
        int n;
        block3: {
            block2: {
                void localResources;
                void appId;
                void fs;
                n = 0;
                __cobertura_counters[721] = __cobertura_counters[721] + 1;
                taskHDFSPath = "";
                __cobertura_counters[722] = __cobertura_counters[722] + 1;
                taskLen = 0L;
                __cobertura_counters[723] = __cobertura_counters[723] + 1;
                taskTimestamp = 0L;
                __cobertura_counters[724] = __cobertura_counters[724] + 1;
                this.addToLocalResources((FileSystem)fs, this.task_zip, "top_async.zip", appId.getId(), (Map<String, LocalResource>)localResources, null, LocalResourceType.ARCHIVE);
                __cobertura_counters[725] = __cobertura_counters[725] + 1;
                String taskDst = this.appName + "/" + appId + "_" + "top_async.zip";
                __cobertura_counters[726] = __cobertura_counters[726] + 1;
                Path taskHDFSDest = new Path(fs.getHomeDirectory(), taskDst);
                __cobertura_counters[727] = __cobertura_counters[727] + 1;
                Path taskLocalPath = new Path(this.task_zip);
                __cobertura_counters[728] = __cobertura_counters[728] + 1;
                LOG.info((Object)"found task archive to upload");
                __cobertura_counters[729] = __cobertura_counters[729] + 1;
                fs.copyFromLocalFile(taskLocalPath, taskHDFSDest);
                __cobertura_counters[730] = __cobertura_counters[730] + 1;
                FileStatus fsStatus = fs.getFileStatus(taskHDFSDest);
                __cobertura_counters[731] = __cobertura_counters[731] + 1;
                taskHDFSPath = fsStatus.getPath().toUri().toString();
                __cobertura_counters[732] = __cobertura_counters[732] + 1;
                taskLen = fsStatus.getLen();
                __cobertura_counters[733] = __cobertura_counters[733] + 1;
                taskTimestamp = fsStatus.getModificationTime();
                __cobertura_counters[734] = __cobertura_counters[734] + 1;
                n = 736;
                if (taskHDFSPath.isEmpty()) break block2;
                __cobertura_counters[735] = __cobertura_counters[735] + 1;
                n = 0;
                n = 738;
                if (taskLen == 0L) break block2;
                __cobertura_counters[737] = __cobertura_counters[737] + 1;
                n = 0;
                n = 740;
                if (taskTimestamp != 0L) break block3;
                __cobertura_counters[739] = __cobertura_counters[739] + 1;
                n = 0;
            }
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[741] = __cobertura_counters[741] + 1;
            throw new IllegalArgumentException("Error while processing task file");
        }
        int n3 = n;
        __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
        n = 0;
        __cobertura_counters[742] = __cobertura_counters[742] + 1;
        env.put("TASK_ZIP_PATH", taskHDFSPath);
        __cobertura_counters[743] = __cobertura_counters[743] + 1;
        env.put("TASK_ZIP_LEN", Long.toString(taskLen));
        __cobertura_counters[744] = __cobertura_counters[744] + 1;
        env.put("TASK_ZIP_TIMESTAMP", Long.toString(taskTimestamp));
        __cobertura_counters[745] = __cobertura_counters[745] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private String convertLongToTime(long l) {
        void time;
        int n = 0;
        __cobertura_counters[746] = __cobertura_counters[746] + 1;
        n = 748;
        if (Long.valueOf(0L).equals((long)time)) {
            __cobertura_counters[747] = __cobertura_counters[747] + 1;
            n = 0;
            __cobertura_counters[749] = __cobertura_counters[749] + 1;
            return "--------";
        }
        int n2 = n;
        __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
        n = 0;
        __cobertura_counters[750] = __cobertura_counters[750] + 1;
        Date date = new Date((long)time);
        __cobertura_counters[751] = __cobertura_counters[751] + 1;
        SimpleDateFormat format = new SimpleDateFormat("HH:mm:ss MM/dd");
        __cobertura_counters[752] = __cobertura_counters[752] + 1;
        return format.format((Object)date).toString();
    }

    /*
     * Unable to fully structure code
     */
    private ExitStatus monitorGraphlabApplications() throws YarnException, IOException {
        var1_1 = 0;
        Client.__cobertura_counters[753] = Client.__cobertura_counters[753] + 1;
        applicationTypes = new HashSet<String>();
        Client.__cobertura_counters[754] = Client.__cobertura_counters[754] + 1;
        applicationTypes.add("Graphlab");
        Client.__cobertura_counters[755] = Client.__cobertura_counters[755] + 1;
        reports = this.yarnClient.getApplications(applicationTypes);
        Client.__cobertura_counters[756] = Client.__cobertura_counters[756] + 1;
        filteredReports = new ArrayList<ApplicationReport>();
        Client.__cobertura_counters[757] = Client.__cobertura_counters[757] + 1;
        i$ = reports.iterator();
        while (true) {
            block9: {
                block8: {
                    var1_1 = 759;
                    if (!i$.hasNext()) break;
                    Client.__cobertura_counters[758] = Client.__cobertura_counters[758] + 1;
                    var1_1 = 0;
                    report = (ApplicationReport)i$.next();
                    Client.__cobertura_counters[760] = Client.__cobertura_counters[760] + 1;
                    var1_1 = 762;
                    if (this.monitorType != MonitorTypes.RUNNING) break block8;
                    Client.__cobertura_counters[761] = Client.__cobertura_counters[761] + 1;
                    var1_1 = 0;
                    var1_1 = 764;
                    if (report.getYarnApplicationState().equals((Object)YarnApplicationState.FINISHED)) break block8;
                    Client.__cobertura_counters[763] = Client.__cobertura_counters[763] + 1;
                    var1_1 = 0;
                    Client.__cobertura_counters[765] = Client.__cobertura_counters[765] + 1;
                    filteredReports.add(report);
                    break block9;
                }
                v0 = var1_1;
                Client.__cobertura_counters[v0] = Client.__cobertura_counters[v0] + 1;
                var1_1 = 0;
                Client.__cobertura_counters[766] = Client.__cobertura_counters[766] + 1;
                var1_1 = 768;
                if (this.monitorType != MonitorTypes.FINISHED) ** GOTO lbl-1000
                Client.__cobertura_counters[767] = Client.__cobertura_counters[767] + 1;
                var1_1 = 0;
                var1_1 = 770;
                if (report.getYarnApplicationState().equals((Object)YarnApplicationState.FINISHED)) {
                    Client.__cobertura_counters[769] = Client.__cobertura_counters[769] + 1;
                    var1_1 = 0;
                    Client.__cobertura_counters[771] = Client.__cobertura_counters[771] + 1;
                    filteredReports.add(report);
                } else lbl-1000:
                // 2 sources

                {
                    v1 = var1_1;
                    Client.__cobertura_counters[v1] = Client.__cobertura_counters[v1] + 1;
                    var1_1 = 0;
                    Client.__cobertura_counters[772] = Client.__cobertura_counters[772] + 1;
                    var1_1 = 774;
                    if (this.monitorType == MonitorTypes.ALL) {
                        Client.__cobertura_counters[773] = Client.__cobertura_counters[773] + 1;
                        var1_1 = 0;
                        Client.__cobertura_counters[775] = Client.__cobertura_counters[775] + 1;
                        filteredReports.add(report);
                    }
                }
            }
            v2 = var1_1;
            Client.__cobertura_counters[v2] = Client.__cobertura_counters[v2] + 1;
            var1_1 = 0;
            Client.__cobertura_counters[776] = Client.__cobertura_counters[776] + 1;
        }
        v3 = var1_1;
        Client.__cobertura_counters[v3] = Client.__cobertura_counters[v3] + 1;
        var1_1 = 0;
        Client.__cobertura_counters[777] = Client.__cobertura_counters[777] + 1;
        Collections.sort(filteredReports, new Comparator<ApplicationReport>(this){
            public static final transient int[] __cobertura_counters;
            final /* synthetic */ Client this$0;
            {
                int n = 0;
                __cobertura_counters[1] = __cobertura_counters[1] + 1;
                this.this$0 = client;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int compare(ApplicationReport applicationReport, ApplicationReport applicationReport2) {
                void a;
                void b;
                int n = 0;
                __cobertura_counters[3] = __cobertura_counters[3] + 1;
                return Long.valueOf(b.getStartTime()).compareTo(a.getStartTime());
            }

            static {
                1.__cobertura_init();
            }

            public static void __cobertura_init() {
                if (__cobertura_counters == null) {
                    __cobertura_counters = new int[4];
                    TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/Client$1");
                }
            }

            public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
                LightClassmapListener lightClassmapListener2 = lightClassmapListener;
                lightClassmapListener2.putLineTouchPoint(1278, 1, "<init>", "(Lorg/graphlab/hadoop/yarn/applications/Client;)V");
                lightClassmapListener2.putLineTouchPoint(1278, 2, "compare", "(Ljava/lang/Object;Ljava/lang/Object;)I");
                lightClassmapListener2.putLineTouchPoint(1280, 3, "compare", "(Lorg/apache/hadoop/yarn/api/records/ApplicationReport;Lorg/apache/hadoop/yarn/api/records/ApplicationReport;)I");
            }

            public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
                LightClassmapListener lightClassmapListener2 = lightClassmapListener;
                lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/Client$1");
                lightClassmapListener2.setSource("Client.java");
                1.__cobertura_classmap_0(lightClassmapListener2);
            }

            public static int[] __cobertura_get_and_reset_counters() {
                int[] nArray = __cobertura_counters;
                __cobertura_counters = new int[__cobertura_counters.length];
                return nArray;
            }
        });
        Client.__cobertura_counters[778] = Client.__cobertura_counters[778] + 1;
        appStatus_list = new JSONArray();
        Client.__cobertura_counters[779] = Client.__cobertura_counters[779] + 1;
        System.out.println("List of Graphlab Applications: ");
        Client.__cobertura_counters[780] = Client.__cobertura_counters[780] + 1;
        var1_1 = 782;
        if (!this.is_JSON) {
            Client.__cobertura_counters[781] = Client.__cobertura_counters[781] + 1;
            var1_1 = 0;
            Client.__cobertura_counters[783] = Client.__cobertura_counters[783] + 1;
            System.out.printf("%-35s %-20s %-20s %-15s %-25s %-25s %-25s %-20s\n", new Object[]{"AppId", "AppUser", "StartTime", "AppState", "DistributedFinalState", "numReservedContainers", "numUsedContainers", "FinishTime"});
        }
        v4 = var1_1;
        Client.__cobertura_counters[v4] = Client.__cobertura_counters[v4] + 1;
        var1_1 = 0;
        Client.__cobertura_counters[784] = Client.__cobertura_counters[784] + 1;
        i$ = filteredReports.iterator();
        while (true) {
            var1_1 = 786;
            if (!i$.hasNext()) break;
            Client.__cobertura_counters[785] = Client.__cobertura_counters[785] + 1;
            var1_1 = 0;
            report = (ApplicationReport)i$.next();
            Client.__cobertura_counters[787] = Client.__cobertura_counters[787] + 1;
            appStatus = new JSONObject();
            Client.__cobertura_counters[788] = Client.__cobertura_counters[788] + 1;
            appStatus.put("AppId", report.getApplicationId().toString());
            Client.__cobertura_counters[789] = Client.__cobertura_counters[789] + 1;
            appStatus.put("AppUser", report.getUser());
            Client.__cobertura_counters[790] = Client.__cobertura_counters[790] + 1;
            appStatus.put("StartTime", this.convertLongToTime(report.getStartTime()));
            Client.__cobertura_counters[791] = Client.__cobertura_counters[791] + 1;
            appStatus.put("AppState", report.getYarnApplicationState().toString());
            Client.__cobertura_counters[792] = Client.__cobertura_counters[792] + 1;
            appStatus.put("DistributedFinalState", report.getFinalApplicationStatus().toString());
            Client.__cobertura_counters[793] = Client.__cobertura_counters[793] + 1;
            appStatus.put("numReservedContainers", report.getApplicationResourceUsageReport().getNumReservedContainers());
            Client.__cobertura_counters[794] = Client.__cobertura_counters[794] + 1;
            appStatus.put("numUsedContainers", report.getApplicationResourceUsageReport().getNumUsedContainers());
            Client.__cobertura_counters[795] = Client.__cobertura_counters[795] + 1;
            appStatus.put("FinishTime", this.convertLongToTime(report.getFinishTime()));
            Client.__cobertura_counters[796] = Client.__cobertura_counters[796] + 1;
            appStatus_list.add(appStatus);
            Client.__cobertura_counters[797] = Client.__cobertura_counters[797] + 1;
            var1_1 = 799;
            if (!this.is_JSON) {
                Client.__cobertura_counters[798] = Client.__cobertura_counters[798] + 1;
                var1_1 = 0;
                Client.__cobertura_counters[800] = Client.__cobertura_counters[800] + 1;
                System.out.printf("%-35s %-20s %-20s %-15s %-25s %-25s %-25s %-20s\n", new Object[]{report.getApplicationId().toString(), report.getUser(), this.convertLongToTime(report.getStartTime()), report.getYarnApplicationState().toString(), report.getFinalApplicationStatus().toString(), report.getApplicationResourceUsageReport().getNumReservedContainers(), report.getApplicationResourceUsageReport().getNumUsedContainers(), this.convertLongToTime(report.getFinishTime())});
            }
            v5 = var1_1;
            Client.__cobertura_counters[v5] = Client.__cobertura_counters[v5] + 1;
            var1_1 = 0;
            Client.__cobertura_counters[801] = Client.__cobertura_counters[801] + 1;
        }
        v6 = var1_1;
        Client.__cobertura_counters[v6] = Client.__cobertura_counters[v6] + 1;
        var1_1 = 0;
        Client.__cobertura_counters[802] = Client.__cobertura_counters[802] + 1;
        var1_1 = 804;
        if (this.is_JSON) {
            Client.__cobertura_counters[803] = Client.__cobertura_counters[803] + 1;
            var1_1 = 0;
            Client.__cobertura_counters[805] = Client.__cobertura_counters[805] + 1;
            System.out.println("$$JSONTAG##" + appStatus_list.toString() + "$$JSONTAG##");
        }
        v7 = var1_1;
        Client.__cobertura_counters[v7] = Client.__cobertura_counters[v7] + 1;
        var1_1 = 0;
        Client.__cobertura_counters[806] = Client.__cobertura_counters[806] + 1;
        return ExitStatus.MONITOR;
    }

    /*
     * WARNING - void declaration
     */
    private ExitStatus monitorApplication(ApplicationId applicationId) throws YarnException, IOException {
        void appId;
        int n;
        block11: {
            FinalApplicationStatus dsStatus;
            YarnApplicationState state;
            block10: {
                n = 0;
                try {
                    __cobertura_counters[807] = __cobertura_counters[807] + 1;
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    __cobertura_counters[808] = __cobertura_counters[808] + 1;
                    InterruptedException e = interruptedException;
                    __cobertura_counters[809] = __cobertura_counters[809] + 1;
                    LOG.debug((Object)"Thread sleep in monitoring loop interrupted");
                }
                __cobertura_counters[810] = __cobertura_counters[810] + 1;
                __cobertura_counters[811] = __cobertura_counters[811] + 1;
                ApplicationReport report = this.yarnClient.getApplicationReport((ApplicationId)appId);
                __cobertura_counters[812] = __cobertura_counters[812] + 1;
                LOG.info((Object)("Got application report from ASM for,\n\t appId=" + appId.getId() + ",\n\t appUser=" + report.getUser() + ",\n\t appMasterHost=" + report.getHost() + ",\n\t appStartTime=" + this.convertLongToTime(report.getStartTime()) + ",\n\t yarnAppState=" + report.getYarnApplicationState().toString() + ",\n\t distributedFinalState=" + report.getFinalApplicationStatus().toString() + ",\n\t numReservedContainers=" + report.getApplicationResourceUsageReport().getNumReservedContainers() + ",\n\t numUsedContainers=" + report.getApplicationResourceUsageReport().getNumUsedContainers()));
                __cobertura_counters[813] = __cobertura_counters[813] + 1;
                n = 815;
                if (this.is_JSON) {
                    __cobertura_counters[814] = __cobertura_counters[814] + 1;
                    n = 0;
                    __cobertura_counters[816] = __cobertura_counters[816] + 1;
                    System.out.println("Graphlab Application Status for Application ID " + appId.toString());
                    __cobertura_counters[817] = __cobertura_counters[817] + 1;
                    JSONObject appStatus = new JSONObject();
                    __cobertura_counters[818] = __cobertura_counters[818] + 1;
                    appStatus.put("AppId", report.getApplicationId().toString());
                    __cobertura_counters[819] = __cobertura_counters[819] + 1;
                    appStatus.put("AppUser", report.getUser());
                    __cobertura_counters[820] = __cobertura_counters[820] + 1;
                    appStatus.put("StartTime", this.convertLongToTime(report.getStartTime()));
                    __cobertura_counters[821] = __cobertura_counters[821] + 1;
                    appStatus.put("AppState", report.getYarnApplicationState().toString());
                    __cobertura_counters[822] = __cobertura_counters[822] + 1;
                    appStatus.put("DistributedFinalState", report.getFinalApplicationStatus().toString());
                    __cobertura_counters[823] = __cobertura_counters[823] + 1;
                    appStatus.put("numReservedContainers", report.getApplicationResourceUsageReport().getNumReservedContainers());
                    __cobertura_counters[824] = __cobertura_counters[824] + 1;
                    appStatus.put("numUsedContainers", report.getApplicationResourceUsageReport().getNumUsedContainers());
                    __cobertura_counters[825] = __cobertura_counters[825] + 1;
                    appStatus.put("FinishTime", this.convertLongToTime(report.getFinishTime()));
                    __cobertura_counters[826] = __cobertura_counters[826] + 1;
                    System.out.println(jsonTag + appStatus.toString() + jsonTag);
                }
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                __cobertura_counters[827] = __cobertura_counters[827] + 1;
                state = report.getYarnApplicationState();
                __cobertura_counters[828] = __cobertura_counters[828] + 1;
                dsStatus = report.getFinalApplicationStatus();
                __cobertura_counters[829] = __cobertura_counters[829] + 1;
                n = 831;
                if (YarnApplicationState.FINISHED == state) {
                    __cobertura_counters[830] = __cobertura_counters[830] + 1;
                    n = 0;
                    __cobertura_counters[832] = __cobertura_counters[832] + 1;
                    n = 834;
                    if (FinalApplicationStatus.SUCCEEDED == dsStatus) {
                        __cobertura_counters[833] = __cobertura_counters[833] + 1;
                        n = 0;
                        __cobertura_counters[835] = __cobertura_counters[835] + 1;
                        LOG.info((Object)"Application has completed successfully. Breaking monitoring loop");
                        __cobertura_counters[836] = __cobertura_counters[836] + 1;
                        return ExitStatus.FINISH_SUCCESS;
                    }
                    int n3 = n;
                    __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
                    n = 0;
                    __cobertura_counters[837] = __cobertura_counters[837] + 1;
                    LOG.info((Object)("Application did finished unsuccessfully. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
                    __cobertura_counters[838] = __cobertura_counters[838] + 1;
                    return ExitStatus.FINISH_FAIL;
                }
                int n4 = n;
                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                n = 0;
                __cobertura_counters[839] = __cobertura_counters[839] + 1;
                n = 841;
                if (YarnApplicationState.KILLED == state) break block10;
                __cobertura_counters[840] = __cobertura_counters[840] + 1;
                n = 0;
                n = 843;
                if (YarnApplicationState.FAILED != state) break block11;
                __cobertura_counters[842] = __cobertura_counters[842] + 1;
                n = 0;
            }
            int n5 = n;
            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
            n = 0;
            __cobertura_counters[844] = __cobertura_counters[844] + 1;
            LOG.info((Object)("Application did not finish. YarnState=" + state.toString() + ", DSFinalStatus=" + dsStatus.toString() + ". Breaking monitoring loop"));
            __cobertura_counters[845] = __cobertura_counters[845] + 1;
            return ExitStatus.KILLED;
        }
        int n6 = n;
        __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
        n = 0;
        __cobertura_counters[846] = __cobertura_counters[846] + 1;
        n = 848;
        if (System.currentTimeMillis() > this.clientStartTime + this.clientTimeout) {
            __cobertura_counters[847] = __cobertura_counters[847] + 1;
            n = 0;
            __cobertura_counters[849] = __cobertura_counters[849] + 1;
            LOG.info((Object)"Reached client specified timeout for application. Killing application");
            __cobertura_counters[850] = __cobertura_counters[850] + 1;
            this.forceKillApplication((ApplicationId)appId);
            __cobertura_counters[851] = __cobertura_counters[851] + 1;
            return ExitStatus.TIMEDOUT;
        }
        int n7 = n;
        __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
        n = 0;
        __cobertura_counters[852] = __cobertura_counters[852] + 1;
        LOG.info((Object)"Application is still running...");
        __cobertura_counters[853] = __cobertura_counters[853] + 1;
        return ExitStatus.RUNNING;
    }

    /*
     * WARNING - void declaration
     */
    private void forceKillApplication(ApplicationId applicationId) throws YarnException, IOException {
        void appId;
        int n = 0;
        __cobertura_counters[854] = __cobertura_counters[854] + 1;
        this.yarnClient.killApplication((ApplicationId)appId);
        __cobertura_counters[855] = __cobertura_counters[855] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addToLocalResources(FileSystem fileSystem, String string, String string2, int n, Map<String, LocalResource> map, String string3, LocalResourceType localResourceType) throws IOException {
        void localResources;
        LocalResourceType type;
        Path dst;
        void fs;
        void fileDstPath;
        int n2;
        block4: {
            void fileSrcPath;
            block3: {
                void appId;
                n2 = 0;
                __cobertura_counters[856] = __cobertura_counters[856] + 1;
                String suffix = this.appName + "/" + (int)appId + "/" + (String)fileDstPath;
                __cobertura_counters[857] = __cobertura_counters[857] + 1;
                dst = new Path(fs.getHomeDirectory(), suffix);
                __cobertura_counters[858] = __cobertura_counters[858] + 1;
                n2 = 860;
                if (fileSrcPath != null) break block3;
                __cobertura_counters[859] = __cobertura_counters[859] + 1;
                n2 = 0;
                __cobertura_counters[861] = __cobertura_counters[861] + 1;
                FSDataOutputStream ostream = null;
                try {
                    void resources;
                    __cobertura_counters[862] = __cobertura_counters[862] + 1;
                    ostream = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    __cobertura_counters[863] = __cobertura_counters[863] + 1;
                    ostream.writeUTF((String)resources);
                }
                catch (Throwable throwable) {
                    __cobertura_counters[864] = __cobertura_counters[864] + 1;
                    Throwable throwable2 = throwable;
                    IOUtils.closeQuietly(ostream);
                    throw throwable2;
                }
                __cobertura_counters[864] = __cobertura_counters[864] + 1;
                IOUtils.closeQuietly((OutputStream)ostream);
                __cobertura_counters[865] = __cobertura_counters[865] + 1;
                __cobertura_counters[866] = __cobertura_counters[866] + 1;
                break block4;
            }
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            __cobertura_counters[867] = __cobertura_counters[867] + 1;
            fs.copyFromLocalFile(new Path((String)fileSrcPath), dst);
        }
        __cobertura_counters[868] = __cobertura_counters[868] + 1;
        FileStatus scFileStatus = fs.getFileStatus(dst);
        __cobertura_counters[869] = __cobertura_counters[869] + 1;
        n2 = 871;
        if (type == null) {
            __cobertura_counters[870] = __cobertura_counters[870] + 1;
            n2 = 0;
            __cobertura_counters[872] = __cobertura_counters[872] + 1;
            type = LocalResourceType.FILE;
        }
        int n4 = n2;
        __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
        n2 = 0;
        __cobertura_counters[873] = __cobertura_counters[873] + 1;
        LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)type, (LocalResourceVisibility)LocalResourceVisibility.APPLICATION, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        __cobertura_counters[874] = __cobertura_counters[874] + 1;
        localResources.put(fileDstPath, scRsrc);
        __cobertura_counters[875] = __cobertura_counters[875] + 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void addToLocalSharedResources(FileSystem fileSystem, String string, String string2, String string3, int n, Map<String, LocalResource> map, String string4) throws IOException {
        void localResources;
        Path dst;
        void fs;
        void fileDstPath;
        block3: {
            void fileSrcPath;
            int n2;
            block2: {
                void sharePath;
                n2 = 0;
                __cobertura_counters[876] = __cobertura_counters[876] + 1;
                String suffix = this.appName + "/" + (String)sharePath + "/" + (String)fileDstPath;
                __cobertura_counters[877] = __cobertura_counters[877] + 1;
                dst = new Path(fs.getHomeDirectory(), suffix);
                __cobertura_counters[878] = __cobertura_counters[878] + 1;
                n2 = 880;
                if (fileSrcPath != null) break block2;
                __cobertura_counters[879] = __cobertura_counters[879] + 1;
                n2 = 0;
                __cobertura_counters[881] = __cobertura_counters[881] + 1;
                FSDataOutputStream ostream = null;
                try {
                    void resources;
                    __cobertura_counters[882] = __cobertura_counters[882] + 1;
                    ostream = FileSystem.create((FileSystem)fs, (Path)dst, (FsPermission)new FsPermission(456));
                    __cobertura_counters[883] = __cobertura_counters[883] + 1;
                    ostream.writeUTF((String)resources);
                }
                catch (Throwable throwable) {
                    __cobertura_counters[884] = __cobertura_counters[884] + 1;
                    Throwable throwable2 = throwable;
                    IOUtils.closeQuietly(ostream);
                    throw throwable2;
                }
                __cobertura_counters[884] = __cobertura_counters[884] + 1;
                IOUtils.closeQuietly((OutputStream)ostream);
                __cobertura_counters[885] = __cobertura_counters[885] + 1;
                __cobertura_counters[886] = __cobertura_counters[886] + 1;
                break block3;
            }
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            __cobertura_counters[887] = __cobertura_counters[887] + 1;
            fs.copyFromLocalFile(new Path((String)fileSrcPath), dst);
        }
        __cobertura_counters[888] = __cobertura_counters[888] + 1;
        FileStatus scFileStatus = fs.getFileStatus(dst);
        __cobertura_counters[889] = __cobertura_counters[889] + 1;
        LocalResource scRsrc = LocalResource.newInstance((URL)ConverterUtils.getYarnUrlFromURI((URI)dst.toUri()), (LocalResourceType)LocalResourceType.FILE, (LocalResourceVisibility)LocalResourceVisibility.PUBLIC, (long)scFileStatus.getLen(), (long)scFileStatus.getModificationTime());
        __cobertura_counters[890] = __cobertura_counters[890] + 1;
        localResources.put(fileDstPath, scRsrc);
        __cobertura_counters[891] = __cobertura_counters[891] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private int writeDependencyScript(String string, String string2, String string3) {
        int n = 0;
        try {
            String line;
            void requirementFile;
            void downloadFolder;
            void dependencyScriptPath;
            __cobertura_counters[892] = __cobertura_counters[892] + 1;
            LOG.info((Object)("writing dependency script \ndependencyScriptPath=" + (String)dependencyScriptPath + " \ndownloadFolder=" + (String)downloadFolder + "\nrequirementFile=" + (String)requirementFile));
            __cobertura_counters[893] = __cobertura_counters[893] + 1;
            FileWriter out = new FileWriter((String)dependencyScriptPath);
            __cobertura_counters[894] = __cobertura_counters[894] + 1;
            out.write("#!/bin/bash\n");
            __cobertura_counters[895] = __cobertura_counters[895] + 1;
            String virtualEnv = "GLVIRTUALENV_" + (int)(Math.random() * 100.0);
            __cobertura_counters[896] = __cobertura_counters[896] + 1;
            out.write("virtualenv-2.7 " + virtualEnv + "\n");
            __cobertura_counters[897] = __cobertura_counters[897] + 1;
            out.write("source " + virtualEnv + "/bin/activate\n");
            __cobertura_counters[898] = __cobertura_counters[898] + 1;
            n = 900;
            if (this.python_dependencies_file.equals(requirementFile)) {
                __cobertura_counters[899] = __cobertura_counters[899] + 1;
                n = 0;
                __cobertura_counters[901] = __cobertura_counters[901] + 1;
                line = virtualEnv + "/bin/pip install --download=\"" + (String)downloadFolder + "\" -r " + (String)requirementFile + "\n";
                __cobertura_counters[902] = __cobertura_counters[902] + 1;
                out.write(line);
                __cobertura_counters[903] = __cobertura_counters[903] + 1;
                line = "cp " + (String)requirementFile + " " + (String)downloadFolder + "/requirements.txt\n";
                __cobertura_counters[904] = __cobertura_counters[904] + 1;
                out.write(line);
                __cobertura_counters[905] = __cobertura_counters[905] + 1;
            } else {
                int n2 = n;
                __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
                n = 0;
                n = 907;
                if (glReqPath.equals(requirementFile)) {
                    __cobertura_counters[906] = __cobertura_counters[906] + 1;
                    n = 0;
                    __cobertura_counters[908] = __cobertura_counters[908] + 1;
                    line = virtualEnv + "/bin/pip install --download=\"" + (String)downloadFolder + "\" graphlab-create\n";
                    __cobertura_counters[909] = __cobertura_counters[909] + 1;
                    out.write(line);
                }
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[910] = __cobertura_counters[910] + 1;
            String newPath = "";
            __cobertura_counters[911] = __cobertura_counters[911] + 1;
            n = 913;
            if (downloadFolder.endsWith("/")) {
                __cobertura_counters[912] = __cobertura_counters[912] + 1;
                n = 0;
                __cobertura_counters[914] = __cobertura_counters[914] + 1;
                newPath = downloadFolder.substring(0, downloadFolder.length() - 1);
            } else {
                int n4 = n;
                __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                n = 0;
                __cobertura_counters[915] = __cobertura_counters[915] + 1;
                newPath = downloadFolder;
            }
            __cobertura_counters[916] = __cobertura_counters[916] + 1;
            String folderName = newPath.substring(newPath.lastIndexOf("/") + 1, newPath.length());
            __cobertura_counters[917] = __cobertura_counters[917] + 1;
            String folderPath = newPath.substring(0, newPath.lastIndexOf(folderName));
            __cobertura_counters[918] = __cobertura_counters[918] + 1;
            n = 920;
            if (folderPath.isEmpty()) {
                __cobertura_counters[919] = __cobertura_counters[919] + 1;
                n = 0;
                __cobertura_counters[921] = __cobertura_counters[921] + 1;
                folderPath = ".";
            }
            int n5 = n;
            __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
            n = 0;
            __cobertura_counters[922] = __cobertura_counters[922] + 1;
            out.write("tar -zcvf " + folderName + ".tar.gz -C " + folderPath + " ./" + folderName + "\n");
            __cobertura_counters[923] = __cobertura_counters[923] + 1;
            out.write("mv " + folderName + ".tar.gz " + (String)downloadFolder + "\n");
            __cobertura_counters[924] = __cobertura_counters[924] + 1;
            out.write("ls " + (String)downloadFolder + " > " + newPath + "/output_" + folderName + ".txt\n");
            __cobertura_counters[925] = __cobertura_counters[925] + 1;
            out.write("deactivate\n");
            __cobertura_counters[926] = __cobertura_counters[926] + 1;
            out.write("rm -rf " + virtualEnv + "/\n");
            __cobertura_counters[927] = __cobertura_counters[927] + 1;
            out.close();
        }
        catch (IOException iOException) {
            __cobertura_counters[928] = __cobertura_counters[928] + 1;
            IOException e = iOException;
            __cobertura_counters[929] = __cobertura_counters[929] + 1;
            LOG.info((Object)"Error while writing script to get python packages");
            __cobertura_counters[930] = __cobertura_counters[930] + 1;
            return -1;
        }
        __cobertura_counters[931] = __cobertura_counters[931] + 1;
        __cobertura_counters[932] = __cobertura_counters[932] + 1;
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    private void runDependencyScript(String string, String string2) {
        void downloadFolder;
        void dependencyScriptPath;
        int n = 0;
        __cobertura_counters[933] = __cobertura_counters[933] + 1;
        String cmd = "bash " + (String)dependencyScriptPath;
        __cobertura_counters[934] = __cobertura_counters[934] + 1;
        File dir = new File((String)downloadFolder);
        __cobertura_counters[935] = __cobertura_counters[935] + 1;
        n = 937;
        if (!dir.exists()) {
            __cobertura_counters[936] = __cobertura_counters[936] + 1;
            n = 0;
            __cobertura_counters[938] = __cobertura_counters[938] + 1;
            dir.mkdir();
        }
        try {
            int n2 = n;
            __cobertura_counters[n2] = __cobertura_counters[n2] + 1;
            n = 0;
            __cobertura_counters[939] = __cobertura_counters[939] + 1;
            Process p = Runtime.getRuntime().exec(cmd);
            __cobertura_counters[940] = __cobertura_counters[940] + 1;
            BufferedReader in = new BufferedReader(new InputStreamReader(p.getInputStream()));
            __cobertura_counters[941] = __cobertura_counters[941] + 1;
            String line = "";
            while (true) {
                __cobertura_counters[942] = __cobertura_counters[942] + 1;
                line = in.readLine();
                n = 944;
                if (line == null) break;
                __cobertura_counters[943] = __cobertura_counters[943] + 1;
                n = 0;
                __cobertura_counters[945] = __cobertura_counters[945] + 1;
                LOG.debug((Object)("script-out: " + line));
            }
            int n3 = n;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n = 0;
            __cobertura_counters[946] = __cobertura_counters[946] + 1;
            in.close();
            __cobertura_counters[947] = __cobertura_counters[947] + 1;
            int out = p.waitFor();
            __cobertura_counters[948] = __cobertura_counters[948] + 1;
            LOG.info((Object)("Successfully downloaded all user dependent python packages " + out));
        }
        catch (IOException iOException) {
            __cobertura_counters[949] = __cobertura_counters[949] + 1;
            IOException e = iOException;
            __cobertura_counters[950] = __cobertura_counters[950] + 1;
            LOG.error((Object)"Error when running script to get python dependency packages");
            __cobertura_counters[951] = __cobertura_counters[951] + 1;
            e.printStackTrace();
            __cobertura_counters[952] = __cobertura_counters[952] + 1;
            return;
        }
        catch (InterruptedException interruptedException) {
            __cobertura_counters[953] = __cobertura_counters[953] + 1;
            InterruptedException e = interruptedException;
            __cobertura_counters[954] = __cobertura_counters[954] + 1;
            LOG.error((Object)"Error when running script to get python dependency packages");
            __cobertura_counters[955] = __cobertura_counters[955] + 1;
            e.printStackTrace();
            __cobertura_counters[956] = __cobertura_counters[956] + 1;
            return;
        }
        __cobertura_counters[957] = __cobertura_counters[957] + 1;
        __cobertura_counters[958] = __cobertura_counters[958] + 1;
    }

    /*
     * WARNING - void declaration
     */
    private boolean checkRequirementFiles(FileSystem fileSystem, String string) {
        int n;
        void requirementFolder;
        int n2 = 0;
        __cobertura_counters[959] = __cobertura_counters[959] + 1;
        LOG.info((Object)("requirementFolder=" + (String)requirementFolder));
        try {
            void fs;
            __cobertura_counters[960] = __cobertura_counters[960] + 1;
            Path req_path = new Path(fs.getHomeDirectory(), this.appName + "/" + (String)requirementFolder);
            __cobertura_counters[961] = __cobertura_counters[961] + 1;
            LOG.info((Object)("req_path=" + req_path.toString()));
            __cobertura_counters[962] = __cobertura_counters[962] + 1;
            n2 = 964;
            if (!fs.exists(req_path)) {
                __cobertura_counters[963] = __cobertura_counters[963] + 1;
                n2 = 0;
                __cobertura_counters[965] = __cobertura_counters[965] + 1;
                LOG.info((Object)"req_path does not exist");
                __cobertura_counters[966] = __cobertura_counters[966] + 1;
                return false;
            }
            int n3 = n2;
            __cobertura_counters[n3] = __cobertura_counters[n3] + 1;
            n2 = 0;
            __cobertura_counters[967] = __cobertura_counters[967] + 1;
            FileStatus dir = fs.getFileStatus(req_path);
            __cobertura_counters[968] = __cobertura_counters[968] + 1;
            n2 = 970;
            if (dir != null) {
                __cobertura_counters[969] = __cobertura_counters[969] + 1;
                n2 = 0;
                n2 = 972;
                if (dir.isDirectory()) {
                    __cobertura_counters[971] = __cobertura_counters[971] + 1;
                    n2 = 0;
                    __cobertura_counters[973] = __cobertura_counters[973] + 1;
                    String reqFileName = "output_" + (String)requirementFolder + ".txt";
                    __cobertura_counters[974] = __cobertura_counters[974] + 1;
                    String reqFilePath = this.appName + "/" + (String)requirementFolder + "/" + reqFileName;
                    __cobertura_counters[975] = __cobertura_counters[975] + 1;
                    Path req_file_path = new Path(fs.getHomeDirectory(), reqFilePath);
                    __cobertura_counters[976] = __cobertura_counters[976] + 1;
                    n2 = 978;
                    if (!fs.exists(req_file_path)) {
                        __cobertura_counters[977] = __cobertura_counters[977] + 1;
                        n2 = 0;
                        __cobertura_counters[979] = __cobertura_counters[979] + 1;
                        return false;
                    }
                    int n4 = n2;
                    __cobertura_counters[n4] = __cobertura_counters[n4] + 1;
                    n2 = 0;
                    __cobertura_counters[980] = __cobertura_counters[980] + 1;
                    FileStatus reqFileStatus = fs.getFileStatus(req_file_path);
                    __cobertura_counters[981] = __cobertura_counters[981] + 1;
                    n2 = 983;
                    if (!reqFileStatus.isFile()) {
                        __cobertura_counters[982] = __cobertura_counters[982] + 1;
                        n2 = 0;
                        __cobertura_counters[984] = __cobertura_counters[984] + 1;
                        return false;
                    }
                    int n5 = n2;
                    __cobertura_counters[n5] = __cobertura_counters[n5] + 1;
                    n2 = 0;
                    __cobertura_counters[985] = __cobertura_counters[985] + 1;
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)fs.open(req_file_path)));
                    __cobertura_counters[986] = __cobertura_counters[986] + 1;
                    StringBuilder fileString = new StringBuilder();
                    __cobertura_counters[987] = __cobertura_counters[987] + 1;
                    String line = "";
                    while (true) {
                        __cobertura_counters[988] = __cobertura_counters[988] + 1;
                        line = br.readLine();
                        n2 = 990;
                        if (line == null) break;
                        __cobertura_counters[989] = __cobertura_counters[989] + 1;
                        n2 = 0;
                        __cobertura_counters[991] = __cobertura_counters[991] + 1;
                        fileString.append(line + "\n");
                    }
                    int n6 = n2;
                    __cobertura_counters[n6] = __cobertura_counters[n6] + 1;
                    n2 = 0;
                    __cobertura_counters[992] = __cobertura_counters[992] + 1;
                    line = fileString.toString();
                    __cobertura_counters[993] = __cobertura_counters[993] + 1;
                    FileStatus[] dirList = fs.listStatus(req_path);
                    __cobertura_counters[994] = __cobertura_counters[994] + 1;
                    FileStatus[] arr$ = dirList;
                    int len$ = arr$.length;
                    int i$ = 0;
                    while (true) {
                        n2 = 996;
                        if (i$ >= len$) break;
                        __cobertura_counters[995] = __cobertura_counters[995] + 1;
                        n2 = 0;
                        FileStatus fsStatus = arr$[i$];
                        __cobertura_counters[998] = __cobertura_counters[998] + 1;
                        n2 = 1000;
                        if (fsStatus.getPath().getName().equals("gl_create_base_virtenv.sh")) {
                            __cobertura_counters[999] = __cobertura_counters[999] + 1;
                            n2 = 0;
                            __cobertura_counters[1001] = __cobertura_counters[1001] + 1;
                        } else {
                            int n7 = n2;
                            __cobertura_counters[n7] = __cobertura_counters[n7] + 1;
                            n2 = 0;
                            __cobertura_counters[1002] = __cobertura_counters[1002] + 1;
                            n2 = 1004;
                            if (!line.contains(fsStatus.getPath().getName())) {
                                __cobertura_counters[1003] = __cobertura_counters[1003] + 1;
                                n2 = 0;
                                __cobertura_counters[1005] = __cobertura_counters[1005] + 1;
                                return false;
                            }
                        }
                        int n8 = n2;
                        __cobertura_counters[n8] = __cobertura_counters[n8] + 1;
                        n2 = 0;
                        __cobertura_counters[997] = __cobertura_counters[997] + 1;
                        ++i$;
                    }
                }
            }
            n = n2;
        }
        catch (IOException iOException) {
            __cobertura_counters[1006] = __cobertura_counters[1006] + 1;
            IOException e = iOException;
            __cobertura_counters[1007] = __cobertura_counters[1007] + 1;
            LOG.info((Object)"Error when checking requirements directory on HDFS");
            __cobertura_counters[1008] = __cobertura_counters[1008] + 1;
            e.printStackTrace();
            __cobertura_counters[1009] = __cobertura_counters[1009] + 1;
            return false;
        }
        __cobertura_counters[n] = __cobertura_counters[n] + 1;
        n2 = 0;
        __cobertura_counters[1010] = __cobertura_counters[1010] + 1;
        __cobertura_counters[1011] = __cobertura_counters[1011] + 1;
        LOG.info((Object)"Graphlab requirements met!");
        __cobertura_counters[1012] = __cobertura_counters[1012] + 1;
        return true;
    }

    static {
        Client.__cobertura_init();
        int n = 0;
        __cobertura_counters[1] = __cobertura_counters[1] + 1;
        LOG = LogFactory.getLog(Client.class);
    }

    public static void __cobertura_init() {
        if (__cobertura_counters == null) {
            __cobertura_counters = new int[1013];
            TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/Client");
        }
    }

    public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.putLineTouchPoint(141, 1, "<clinit>", "()V");
        lightClassmapListener2.putLineTouchPoint(148, 2, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(150, 3, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(152, 4, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(154, 5, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(156, 6, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(159, 7, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(164, 8, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(166, 9, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(170, 10, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(173, 11, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(175, 12, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(179, 13, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(182, 14, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(184, 15, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(187, 16, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(190, 17, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(193, 18, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(211, 19, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(214, 20, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(215, 21, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(216, 22, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(217, 23, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(219, 24, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(222, 25, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(223, 26, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(226, 27, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(229, 28, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(246, 29, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(248, 30, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(249, 31, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(251, 32, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(252, 33, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(252, 35, 34);
        lightClassmapListener2.putLineTouchPoint(253, 36, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(255, 37, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(256, 38, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(257, 39, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(258, 40, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(259, 41, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(260, 42, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(261, 43, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(262, 44, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(263, 45, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(264, 46, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(265, 47, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(265, 49, 48);
        lightClassmapListener2.putLineTouchPoint(266, 50, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(267, 51, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(268, 52, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(268, 54, 53);
        lightClassmapListener2.putLineTouchPoint(269, 55, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(270, 56, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(271, 57, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(271, 59, 58);
        lightClassmapListener2.putLineTouchPoint(272, 60, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(274, 61, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(275, 62, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(276, 63, "main", "([Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(281, 64, "<init>", "(Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(284, 65, "<init>", "(Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(286, 66, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(287, 67, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(288, 68, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(289, 69, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(290, 70, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(291, 71, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(292, 72, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(294, 73, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(297, 74, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(298, 75, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(300, 76, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(302, 77, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(304, 78, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(307, 79, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(308, 80, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(310, 81, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(312, 82, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(314, 83, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(316, 84, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(317, 85, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(318, 86, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(319, 87, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(321, 88, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(323, 89, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(326, 90, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(328, 91, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(331, 92, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(338, 93, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(345, 94, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(346, 95, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(348, 96, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(350, 97, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(355, 98, "<init>", "(Ljava/lang/String;Lorg/apache/hadoop/conf/Configuration;)V");
        lightClassmapListener2.putLineTouchPoint(360, 99, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(361, 100, "<init>", "()V");
        lightClassmapListener2.putLineTouchPoint(367, 101, "printUsage", "()V");
        lightClassmapListener2.putLineTouchPoint(368, 102, "printUsage", "()V");
        lightClassmapListener2.putLineTouchPoint(380, 103, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(382, 104, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(382, 106, 105);
        lightClassmapListener2.putLineTouchPoint(383, 107, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(387, 108, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(387, 110, 109);
        lightClassmapListener2.putLineTouchPoint(388, 111, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(390, 112, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(392, 113, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(393, 114, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(394, 115, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(397, 116, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(397, 118, 117);
        lightClassmapListener2.putLineTouchPoint(398, 119, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(399, 120, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(402, 121, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(402, 123, 122);
        lightClassmapListener2.putLineTouchPoint(403, 124, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(404, 125, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(408, 126, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(408, 128, 127);
        lightClassmapListener2.putLineTouchPoint(409, 129, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(410, 130, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(410, 132, 131);
        lightClassmapListener2.putJumpTouchPoint(410, 134, 133);
        lightClassmapListener2.putLineTouchPoint(412, 135, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(415, 136, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(418, 137, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(419, 138, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(421, 139, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(422, 140, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(424, 141, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(427, 142, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(427, 144, 143);
        lightClassmapListener2.putLineTouchPoint(428, 145, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(432, 146, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(432, 148, 147);
        lightClassmapListener2.putLineTouchPoint(433, 149, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(438, 150, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(438, 152, 151);
        lightClassmapListener2.putJumpTouchPoint(438, 154, 153);
        lightClassmapListener2.putJumpTouchPoint(438, 156, 155);
        lightClassmapListener2.putLineTouchPoint(440, 157, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(444, 158, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(446, 159, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(446, 161, 160);
        lightClassmapListener2.putLineTouchPoint(447, 162, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(450, 163, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(453, 164, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(455, 165, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(457, 166, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(460, 167, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(460, 169, 168);
        lightClassmapListener2.putJumpTouchPoint(460, 171, 170);
        lightClassmapListener2.putJumpTouchPoint(460, 173, 172);
        lightClassmapListener2.putLineTouchPoint(462, 174, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(470, 175, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(473, 176, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(475, 177, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(475, 179, 178);
        lightClassmapListener2.putLineTouchPoint(476, 180, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(481, 181, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(481, 183, 182);
        lightClassmapListener2.putLineTouchPoint(482, 184, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(483, 185, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(484, 186, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(484, 188, 187);
        lightClassmapListener2.putJumpTouchPoint(484, 190, 189);
        lightClassmapListener2.putLineTouchPoint(485, 191, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(486, 192, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(486, 194, 193);
        lightClassmapListener2.putLineTouchPoint(487, 195, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(488, 196, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(488, 198, 197);
        lightClassmapListener2.putLineTouchPoint(489, 199, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(495, 200, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(495, 202, 201);
        lightClassmapListener2.putLineTouchPoint(496, 203, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(500, 204, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(500, 206, 205);
        lightClassmapListener2.putJumpTouchPoint(500, 208, 207);
        lightClassmapListener2.putLineTouchPoint(501, 209, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(502, 210, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(503, 211, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(503, 213, 212);
        lightClassmapListener2.putLineTouchPoint(504, 214, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(507, 215, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(508, 216, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(513, 217, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(513, 219, 218);
        lightClassmapListener2.putJumpTouchPoint(513, 221, 220);
        lightClassmapListener2.putLineTouchPoint(515, 222, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(516, 223, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(517, 224, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(517, 226, 225);
        lightClassmapListener2.putJumpTouchPoint(517, 228, 227);
        lightClassmapListener2.putLineTouchPoint(518, 229, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(524, 230, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(524, 232, 231);
        lightClassmapListener2.putLineTouchPoint(525, 233, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(529, 234, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(529, 236, 235);
        lightClassmapListener2.putLineTouchPoint(530, 237, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(533, 238, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(533, 240, 239);
        lightClassmapListener2.putLineTouchPoint(534, 241, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(535, 242, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(535, 244, 243);
        lightClassmapListener2.putJumpTouchPoint(535, 246, 245);
        lightClassmapListener2.putLineTouchPoint(536, 247, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(539, 248, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(541, 249, "init", "([Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(547, 250, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(548, 251, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(549, 252, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(550, 253, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(552, 254, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(554, 255, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(555, 256, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(555, 258, 257);
        lightClassmapListener2.putLineTouchPoint(556, 259, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(559, 260, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(559, 262, 261);
        lightClassmapListener2.putLineTouchPoint(560, 263, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(563, 264, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(564, 265, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(567, 266, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(568, 267, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(568, 269, 268);
        lightClassmapListener2.putLineTouchPoint(569, 270, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(572, 271, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(574, 272, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(578, 273, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(578, 275, 274);
        lightClassmapListener2.putLineTouchPoint(578, 276, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(579, 277, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(579, 279, 278);
        lightClassmapListener2.putLineTouchPoint(581, 280, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(584, 281, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(586, 282, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(587, 283, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(588, 284, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(589, 285, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(590, 286, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(593, 287, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(594, 288, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(594, 290, 289);
        lightClassmapListener2.putLineTouchPoint(595, 291, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(599, 292, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(602, 293, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(602, 295, 294);
        lightClassmapListener2.putLineTouchPoint(603, 296, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(605, 297, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(608, 298, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(609, 299, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(609, 301, 300);
        lightClassmapListener2.putLineTouchPoint(610, 302, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(616, 303, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(617, 304, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(617, 306, 305);
        lightClassmapListener2.putLineTouchPoint(618, 307, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(620, 308, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(621, 309, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(622, 310, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(623, 311, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(628, 312, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(628, 314, 313);
        lightClassmapListener2.putJumpTouchPoint(628, 316, 315);
        lightClassmapListener2.putJumpTouchPoint(628, 318, 317);
        lightClassmapListener2.putJumpTouchPoint(628, 320, 319);
        lightClassmapListener2.putLineTouchPoint(630, 321, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(636, 322, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(637, 323, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(639, 324, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(641, 325, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(643, 326, "obtainUserResources", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(648, 327, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(649, 328, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(650, 329, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(651, 330, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(652, 331, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(653, 332, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(656, 333, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(656, 335, 334);
        lightClassmapListener2.putLineTouchPoint(658, 336, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(661, 337, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(662, 338, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(664, 339, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(666, 340, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(667, 341, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(667, 343, 342);
        lightClassmapListener2.putLineTouchPoint(667, 344, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(669, 345, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(670, 346, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(671, 347, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(671, 349, 348);
        lightClassmapListener2.putJumpTouchPoint(671, 351, 350);
        lightClassmapListener2.putLineTouchPoint(673, 352, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(676, 353, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(678, 354, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(679, 355, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(679, 357, 356);
        lightClassmapListener2.putLineTouchPoint(680, 358, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(681, 359, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(682, 360, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(683, 361, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(685, 362, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(685, 364, 363);
        lightClassmapListener2.putLineTouchPoint(686, 365, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(687, 366, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(688, 367, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(689, 368, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(693, 369, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(693, 371, 370);
        lightClassmapListener2.putLineTouchPoint(695, 372, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(699, 373, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(699, 375, 374);
        lightClassmapListener2.putLineTouchPoint(701, 376, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(702, 377, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(703, 378, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(704, 379, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(705, 380, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(706, 381, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(707, 382, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(708, 383, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(709, 384, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(710, 385, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(715, 386, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(715, 388, 387);
        lightClassmapListener2.putJumpTouchPoint(715, 390, 389);
        lightClassmapListener2.putJumpTouchPoint(715, 392, 391);
        lightClassmapListener2.putJumpTouchPoint(715, 394, 393);
        lightClassmapListener2.putJumpTouchPoint(715, 396, 395);
        lightClassmapListener2.putJumpTouchPoint(715, 398, 397);
        lightClassmapListener2.putLineTouchPoint(719, 399, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(724, 400, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(725, 401, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(727, 402, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(729, 403, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(730, 404, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(732, 405, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(734, 406, "obtainPythonDependencies", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(739, 407, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(740, 408, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(741, 409, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(743, 410, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(744, 411, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(745, 412, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(745, 414, 413);
        lightClassmapListener2.putLineTouchPoint(746, 415, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(747, 416, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(748, 417, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(749, 418, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(751, 419, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(753, 420, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(753, 422, 421);
        lightClassmapListener2.putJumpTouchPoint(753, 424, 423);
        lightClassmapListener2.putJumpTouchPoint(753, 426, 425);
        lightClassmapListener2.putLineTouchPoint(754, 427, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(756, 428, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(760, 429, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(761, 430, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(763, 431, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(764, 432, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(765, 433, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(766, 434, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(769, 435, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(769, 437, 436);
        lightClassmapListener2.putJumpTouchPoint(769, 439, 438);
        lightClassmapListener2.putJumpTouchPoint(769, 441, 440);
        lightClassmapListener2.putLineTouchPoint(771, 442, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(776, 443, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(777, 444, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(778, 445, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(780, 446, "obtainGraphlabProductKey", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(785, 447, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(786, 448, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(787, 449, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(788, 450, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(790, 451, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(790, 453, 452);
        lightClassmapListener2.putJumpTouchPoint(790, 455, 454);
        lightClassmapListener2.putLineTouchPoint(792, 456, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(792, 458, 457);
        lightClassmapListener2.putLineTouchPoint(793, 459, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(795, 460, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(796, 461, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(797, 462, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(797, 464, 463);
        lightClassmapListener2.putLineTouchPoint(798, 465, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(802, 466, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(805, 467, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(808, 468, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(809, 469, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(810, 470, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(811, 471, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(814, 472, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(815, 473, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(818, 474, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(819, 475, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(819, 477, 476);
        lightClassmapListener2.putLineTouchPoint(819, 478, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(821, 479, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(822, 480, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(823, 481, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(823, 483, 482);
        lightClassmapListener2.putJumpTouchPoint(823, 485, 484);
        lightClassmapListener2.putLineTouchPoint(825, 486, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(826, 487, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(829, 488, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(831, 489, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(832, 490, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(832, 492, 491);
        lightClassmapListener2.putLineTouchPoint(833, 493, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(834, 494, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(835, 495, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(836, 496, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(837, 497, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(841, 498, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(841, 500, 499);
        lightClassmapListener2.putLineTouchPoint(842, 501, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(847, 502, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(848, 503, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(848, 505, 504);
        lightClassmapListener2.putLineTouchPoint(849, 506, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(850, 507, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(852, 508, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(853, 509, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(854, 510, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(856, 511, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(857, 512, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(857, 514, 513);
        lightClassmapListener2.putJumpTouchPoint(857, 516, 515);
        lightClassmapListener2.putLineTouchPoint(860, 517, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(863, 518, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(866, 519, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(867, 520, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(868, 521, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(869, 522, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(872, 523, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(873, 524, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(874, 525, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(874, 527, 526);
        lightClassmapListener2.putJumpTouchPoint(874, 529, 528);
        lightClassmapListener2.putLineTouchPoint(875, 530, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(878, 531, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(879, 532, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(880, 533, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(881, 534, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(882, 535, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(883, 536, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(886, 537, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(889, 538, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(892, 539, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(893, 540, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(894, 541, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(895, 542, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(898, 543, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(898, 545, 544);
        lightClassmapListener2.putLineTouchPoint(899, 546, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(900, 547, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(901, 548, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(902, 549, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(904, 550, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(905, 551, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(907, 552, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(909, 553, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(910, 554, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(911, 555, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(913, 556, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(917, 557, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(917, 559, 558);
        lightClassmapListener2.putJumpTouchPoint(917, 561, 560);
        lightClassmapListener2.putJumpTouchPoint(917, 563, 562);
        lightClassmapListener2.putJumpTouchPoint(917, 565, 564);
        lightClassmapListener2.putLineTouchPoint(919, 566, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(924, 567, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(925, 568, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(926, 569, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(928, 570, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(929, 571, "obtainGraphlabReqs", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(940, 572, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(941, 573, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(944, 574, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(944, 576, 575);
        lightClassmapListener2.putLineTouchPoint(945, 577, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(949, 578, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(949, 580, 579);
        lightClassmapListener2.putLineTouchPoint(950, 581, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(952, 582, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(956, 583, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(957, 584, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(965, 585, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(966, 586, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(969, 587, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(969, 589, 588);
        lightClassmapListener2.putLineTouchPoint(970, 590, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(972, 591, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(975, 592, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(977, 593, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(980, 594, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(980, 596, 595);
        lightClassmapListener2.putLineTouchPoint(981, 597, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(987, 598, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(991, 599, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(993, 600, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(994, 601, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(995, 602, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(998, 603, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1005, 604, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1007, 605, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1010, 606, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1011, 607, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1015, 608, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1015, 610, 609);
        lightClassmapListener2.putLineTouchPoint(1016, 611, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1022, 612, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1023, 613, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1025, 614, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1025, 616, 615);
        lightClassmapListener2.putLineTouchPoint(1027, 617, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1033, 618, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1033, 620, 619);
        lightClassmapListener2.putLineTouchPoint(1034, 621, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1037, 622, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1037, 624, 623);
        lightClassmapListener2.putLineTouchPoint(1038, 625, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1043, 626, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1043, 628, 627);
        lightClassmapListener2.putLineTouchPoint(1044, 629, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1046, 630, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1046, 632, 631);
        lightClassmapListener2.putLineTouchPoint(1047, 633, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1051, 634, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1054, 635, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1057, 636, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1074, 637, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1077, 638, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1077, 640, 639);
        lightClassmapListener2.putLineTouchPoint(1077, 641, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1080, 642, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1081, 643, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1083, 644, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1087, 645, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1087, 647, 646);
        lightClassmapListener2.putLineTouchPoint(1088, 648, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1089, 649, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1092, 650, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1092, 652, 651);
        lightClassmapListener2.putLineTouchPoint(1093, 653, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1093, 655, 654);
        lightClassmapListener2.putLineTouchPoint(1094, 656, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1095, 657, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1097, 658, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1099, 659, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1102, 660, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1105, 661, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1106, 662, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1108, 663, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1110, 664, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1112, 665, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1113, 666, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1114, 667, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1115, 668, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1117, 669, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1117, 671, 670);
        lightClassmapListener2.putLineTouchPoint(1118, 672, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1121, 673, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1122, 674, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1125, 675, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1126, 676, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1126, 678, 677);
        lightClassmapListener2.putLineTouchPoint(1127, 679, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1128, 680, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1130, 681, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1132, 682, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1133, 683, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1134, 684, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1139, 685, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1140, 686, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1141, 687, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1142, 688, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1149, 689, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1149, 691, 690);
        lightClassmapListener2.putLineTouchPoint(1150, 692, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1151, 693, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1152, 694, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1152, 696, 695);
        lightClassmapListener2.putJumpTouchPoint(1152, 698, 697);
        lightClassmapListener2.putLineTouchPoint(1153, 699, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1158, 700, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1160, 701, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1160, 703, 702);
        lightClassmapListener2.putLineTouchPoint(1161, 704, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1161, 706, 705);
        lightClassmapListener2.putLineTouchPoint(1161, 707, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1162, 708, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1165, 709, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1166, 710, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1167, 711, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1169, 712, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1172, 713, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1175, 714, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1177, 715, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1178, 716, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1181, 717, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1189, 718, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1191, 719, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1198, 720, "run", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1205, 721, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1206, 722, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1207, 723, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1209, 724, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1212, 725, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1214, 726, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1216, 727, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1217, 728, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1218, 729, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1219, 730, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1220, 731, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1221, 732, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1222, 733, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1225, 734, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putJumpTouchPoint(1225, 736, 735);
        lightClassmapListener2.putJumpTouchPoint(1225, 738, 737);
        lightClassmapListener2.putJumpTouchPoint(1225, 740, 739);
        lightClassmapListener2.putLineTouchPoint(1226, 741, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1230, 742, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1231, 743, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1232, 744, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1233, 745, "uploadTaskArchive", "(Lorg/apache/hadoop/fs/FileSystem;Lorg/apache/hadoop/yarn/api/records/ApplicationId;Ljava/util/Map;Ljava/util/Map;)V");
        lightClassmapListener2.putLineTouchPoint(1236, 746, "convertLongToTime", "(J)Ljava/lang/String;");
        lightClassmapListener2.putJumpTouchPoint(1236, 748, 747);
        lightClassmapListener2.putLineTouchPoint(1237, 749, "convertLongToTime", "(J)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1239, 750, "convertLongToTime", "(J)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1240, 751, "convertLongToTime", "(J)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1241, 752, "convertLongToTime", "(J)Ljava/lang/String;");
        lightClassmapListener2.putLineTouchPoint(1254, 753, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1255, 754, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1256, 755, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1261, 756, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1262, 757, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1262, 759, 758);
        lightClassmapListener2.putLineTouchPoint(1263, 760, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1263, 762, 761);
        lightClassmapListener2.putJumpTouchPoint(1263, 764, 763);
        lightClassmapListener2.putLineTouchPoint(1266, 765, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1267, 766, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1267, 768, 767);
        lightClassmapListener2.putJumpTouchPoint(1267, 770, 769);
        lightClassmapListener2.putLineTouchPoint(1270, 771, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1271, 772, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1271, 774, 773);
        lightClassmapListener2.putLineTouchPoint(1272, 775, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1274, 776, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1278, 777, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1286, 778, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1288, 779, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1290, 780, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1290, 782, 781);
        lightClassmapListener2.putLineTouchPoint(1291, 783, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1298, 784, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1298, 786, 785);
        lightClassmapListener2.putLineTouchPoint(1300, 787, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1301, 788, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1302, 789, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1303, 790, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1305, 791, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1307, 792, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1309, 793, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1312, 794, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1316, 795, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1318, 796, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1320, 797, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1320, 799, 798);
        lightClassmapListener2.putLineTouchPoint(1322, 800, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1334, 801, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1336, 802, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1336, 804, 803);
        lightClassmapListener2.putLineTouchPoint(1337, 805, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1340, 806, "monitorGraphlabApplications", "()Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1361, 807, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1362, 808, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1363, 809, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1364, 810, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1367, 811, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1369, 812, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1389, 813, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1389, 815, 814);
        lightClassmapListener2.putLineTouchPoint(1390, 816, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1393, 817, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1394, 818, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1395, 819, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1396, 820, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1398, 821, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1400, 822, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1402, 823, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1405, 824, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1409, 825, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1411, 826, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1414, 827, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1415, 828, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1416, 829, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1416, 831, 830);
        lightClassmapListener2.putLineTouchPoint(1417, 832, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1417, 834, 833);
        lightClassmapListener2.putLineTouchPoint(1418, 835, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1419, 836, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1421, 837, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1424, 838, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1426, 839, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1426, 841, 840);
        lightClassmapListener2.putJumpTouchPoint(1426, 843, 842);
        lightClassmapListener2.putLineTouchPoint(1428, 844, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1431, 845, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1434, 846, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putJumpTouchPoint(1434, 848, 847);
        lightClassmapListener2.putLineTouchPoint(1435, 849, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1436, 850, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1437, 851, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1440, 852, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1441, 853, "monitorApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
        lightClassmapListener2.putLineTouchPoint(1463, 854, "forceKillApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)V");
        lightClassmapListener2.putLineTouchPoint(1464, 855, "forceKillApplication", "(Lorg/apache/hadoop/yarn/api/records/ApplicationId;)V");
        lightClassmapListener2.putLineTouchPoint(1470, 856, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1471, 857, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1472, 858, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putJumpTouchPoint(1472, 860, 859);
        lightClassmapListener2.putLineTouchPoint(1473, 861, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1475, 862, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1477, 863, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1479, 864, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1480, 865, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1481, 866, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1482, 867, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1484, 868, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1485, 869, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putJumpTouchPoint(1485, 871, 870);
        lightClassmapListener2.putLineTouchPoint(1486, 872, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1488, 873, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1492, 874, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1493, 875, "addToLocalResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;Lorg/apache/hadoop/yarn/api/records/LocalResourceType;)V");
        lightClassmapListener2.putLineTouchPoint(1518, 876, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1519, 877, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1520, 878, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(1520, 880, 879);
        lightClassmapListener2.putLineTouchPoint(1521, 881, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1523, 882, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1525, 883, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1527, 884, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1528, 885, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1529, 886, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1530, 887, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1532, 888, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1533, 889, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1537, 890, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1538, 891, "addToLocalSharedResources", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ILjava/util/Map;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1556, 892, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1559, 893, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1560, 894, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1561, 895, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1562, 896, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1563, 897, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1564, 898, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putJumpTouchPoint(1564, 900, 899);
        lightClassmapListener2.putLineTouchPoint(1566, 901, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1568, 902, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1569, 903, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1571, 904, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1572, 905, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putJumpTouchPoint(1572, 907, 906);
        lightClassmapListener2.putLineTouchPoint(1574, 908, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1576, 909, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1580, 910, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1581, 911, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putJumpTouchPoint(1581, 913, 912);
        lightClassmapListener2.putLineTouchPoint(1582, 914, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1585, 915, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1587, 916, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1589, 917, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1591, 918, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putJumpTouchPoint(1591, 920, 919);
        lightClassmapListener2.putLineTouchPoint(1592, 921, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1595, 922, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1597, 923, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1600, 924, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1602, 925, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1603, 926, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1605, 927, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1606, 928, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1607, 929, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1608, 930, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1609, 931, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1610, 932, "writeDependencyScript", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)I");
        lightClassmapListener2.putLineTouchPoint(1625, 933, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1628, 934, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1629, 935, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(1629, 937, 936);
        lightClassmapListener2.putLineTouchPoint(1630, 938, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1635, 939, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1636, 940, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1638, 941, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1639, 942, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putJumpTouchPoint(1639, 944, 943);
        lightClassmapListener2.putLineTouchPoint(1641, 945, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1643, 946, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1645, 947, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1646, 948, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1648, 949, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1649, 950, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1650, 951, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1651, 952, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1652, 953, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1653, 954, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1654, 955, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1655, 956, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1656, 957, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1657, 958, "runDependencyScript", "(Ljava/lang/String;Ljava/lang/String;)V");
        lightClassmapListener2.putLineTouchPoint(1672, 959, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1675, 960, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1677, 961, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1678, 962, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1678, 964, 963);
        lightClassmapListener2.putLineTouchPoint(1679, 965, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1680, 966, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1683, 967, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1684, 968, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1684, 970, 969);
        lightClassmapListener2.putJumpTouchPoint(1684, 972, 971);
        lightClassmapListener2.putLineTouchPoint(1685, 973, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1686, 974, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1688, 975, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1691, 976, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1691, 978, 977);
        lightClassmapListener2.putLineTouchPoint(1692, 979, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1694, 980, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1695, 981, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1695, 983, 982);
        lightClassmapListener2.putLineTouchPoint(1696, 984, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1700, 985, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1702, 986, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1703, 987, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1704, 988, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1704, 990, 989);
        lightClassmapListener2.putLineTouchPoint(1705, 991, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1707, 992, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1711, 993, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1712, 994, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1712, 996, 995);
        lightClassmapListener2.putLineTouchPoint(1712, 997, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1713, 998, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1713, 1000, 999);
        lightClassmapListener2.putLineTouchPoint(1717, 1001, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1719, 1002, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putJumpTouchPoint(1719, 1004, 1003);
        lightClassmapListener2.putLineTouchPoint(1720, 1005, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1724, 1006, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1725, 1007, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1726, 1008, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1727, 1009, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1728, 1010, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1729, 1011, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
        lightClassmapListener2.putLineTouchPoint(1730, 1012, "checkRequirementFiles", "(Lorg/apache/hadoop/fs/FileSystem;Ljava/lang/String;)Z");
    }

    public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
        LightClassmapListener lightClassmapListener2 = lightClassmapListener;
        lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/Client");
        lightClassmapListener2.setSource("Client.java");
        Client.__cobertura_classmap_0(lightClassmapListener2);
    }

    public static int[] __cobertura_get_and_reset_counters() {
        int[] nArray = __cobertura_counters;
        __cobertura_counters = new int[__cobertura_counters.length];
        return nArray;
    }

    private static final class ExitStatus
    extends Enum<ExitStatus> {
        public static final transient int[] __cobertura_counters;
        public static final /* enum */ ExitStatus FINISH_SUCCESS;
        public static final /* enum */ ExitStatus FINISH_FAIL;
        public static final /* enum */ ExitStatus RUNNING;
        public static final /* enum */ ExitStatus KILLED;
        public static final /* enum */ ExitStatus TIMEDOUT;
        public static final /* enum */ ExitStatus MONITOR;
        private static final /* synthetic */ ExitStatus[] $VALUES;

        public static ExitStatus[] values() {
            ExitStatus.__cobertura_init();
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            return (ExitStatus[])$VALUES.clone();
        }

        public static ExitStatus valueOf(String string) {
            String name;
            ExitStatus.__cobertura_init();
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            return Enum.valueOf(ExitStatus.class, name);
        }

        private ExitStatus() {
            int n2 = 0;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
        }

        static {
            ExitStatus.__cobertura_init();
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            FINISH_SUCCESS = new ExitStatus();
            FINISH_FAIL = new ExitStatus();
            RUNNING = new ExitStatus();
            KILLED = new ExitStatus();
            TIMEDOUT = new ExitStatus();
            MONITOR = new ExitStatus();
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            $VALUES = new ExitStatus[]{FINISH_SUCCESS, FINISH_FAIL, RUNNING, KILLED, TIMEDOUT, MONITOR};
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[6];
                TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/Client$ExitStatus");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(237, 1, "values", "()[Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
            lightClassmapListener2.putLineTouchPoint(237, 2, "valueOf", "(Ljava/lang/String;)Lorg/graphlab/hadoop/yarn/applications/Client$ExitStatus;");
            lightClassmapListener2.putLineTouchPoint(237, 3, "<init>", "(Ljava/lang/String;I)V");
            lightClassmapListener2.putLineTouchPoint(237, 4, "<clinit>", "()V");
            lightClassmapListener2.putLineTouchPoint(238, 5, "<clinit>", "()V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/Client$ExitStatus");
            lightClassmapListener2.setSource("Client.java");
            ExitStatus.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }

    private static final class MonitorTypes
    extends Enum<MonitorTypes> {
        public static final transient int[] __cobertura_counters;
        public static final /* enum */ MonitorTypes ALL;
        public static final /* enum */ MonitorTypes RUNNING;
        public static final /* enum */ MonitorTypes FINISHED;
        private static final /* synthetic */ MonitorTypes[] $VALUES;

        public static MonitorTypes[] values() {
            MonitorTypes.__cobertura_init();
            int n = 0;
            __cobertura_counters[1] = __cobertura_counters[1] + 1;
            return (MonitorTypes[])$VALUES.clone();
        }

        public static MonitorTypes valueOf(String string) {
            String name;
            MonitorTypes.__cobertura_init();
            int n = 0;
            __cobertura_counters[2] = __cobertura_counters[2] + 1;
            return Enum.valueOf(MonitorTypes.class, name);
        }

        private MonitorTypes() {
            int n2 = 0;
            __cobertura_counters[3] = __cobertura_counters[3] + 1;
        }

        static {
            MonitorTypes.__cobertura_init();
            int n = 0;
            __cobertura_counters[5] = __cobertura_counters[5] + 1;
            ALL = new MonitorTypes();
            RUNNING = new MonitorTypes();
            FINISHED = new MonitorTypes();
            __cobertura_counters[4] = __cobertura_counters[4] + 1;
            $VALUES = new MonitorTypes[]{ALL, RUNNING, FINISHED};
        }

        public static void __cobertura_init() {
            if (__cobertura_counters == null) {
                __cobertura_counters = new int[6];
                TouchCollector.registerClass("org/graphlab/hadoop/yarn/applications/Client$MonitorTypes");
            }
        }

        public static void __cobertura_classmap_0(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.putLineTouchPoint(232, 1, "values", "()[Lorg/graphlab/hadoop/yarn/applications/Client$MonitorTypes;");
            lightClassmapListener2.putLineTouchPoint(232, 2, "valueOf", "(Ljava/lang/String;)Lorg/graphlab/hadoop/yarn/applications/Client$MonitorTypes;");
            lightClassmapListener2.putLineTouchPoint(232, 3, "<init>", "(Ljava/lang/String;I)V");
            lightClassmapListener2.putLineTouchPoint(232, 4, "<clinit>", "()V");
            lightClassmapListener2.putLineTouchPoint(233, 5, "<clinit>", "()V");
        }

        public static void __cobertura_classmap(LightClassmapListener lightClassmapListener) {
            LightClassmapListener lightClassmapListener2 = lightClassmapListener;
            lightClassmapListener2.setClazz("org/graphlab/hadoop/yarn/applications/Client$MonitorTypes");
            lightClassmapListener2.setSource("Client.java");
            MonitorTypes.__cobertura_classmap_0(lightClassmapListener2);
        }

        public static int[] __cobertura_get_and_reset_counters() {
            int[] nArray = __cobertura_counters;
            __cobertura_counters = new int[__cobertura_counters.length];
            return nArray;
        }
    }
}

