/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.javancss;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.sourceforge.cobertura.javancss.PackageMetric;
import net.sourceforge.cobertura.javancss.ccl.Exitable;
import net.sourceforge.cobertura.javancss.ccl.Init;
import net.sourceforge.cobertura.javancss.ccl.Util;
import net.sourceforge.cobertura.javancss.parser.JavaParser;
import net.sourceforge.cobertura.javancss.parser.JavaParserInterface;
import net.sourceforge.cobertura.javancss.parser.JavaParserTokenManager;
import net.sourceforge.cobertura.javancss.parser.ParseException;
import net.sourceforge.cobertura.javancss.parser.TokenMgrError;
import net.sourceforge.cobertura.javancss.parser.debug.JavaParserDebug;
import net.sourceforge.cobertura.javancss.parser.java15.JavaParser15;
import net.sourceforge.cobertura.javancss.parser.java15.debug.JavaParser15Debug;

public class Javancss
implements Exitable {
    private static final String S_INIT__FILE_CONTENT = "[Init]\nAuthor=Chr. Clemens Lee\n\n[Help]\n; Please do not edit the Help section\nHelpUsage=@srcfiles.txt | *.java | <stdin>\nOptions=ncss,package,object,function,all,gui,xml,out,recursive,check,encoding,parser15\nncss=b,o,Counts the program NCSS (default).\npackage=b,o,Assembles a statistic on package level.\nobject=b,o,Counts the object NCSS.\nfunction=b,o,Counts the function NCSS.\nall=b,o,The same as '-function -object -package'.\ngui=b,o,Opens a gui to present the '-all' output in tabbed panels.\nxml=b,o,Output in xml format.\nout=s,o,Output file name. By default output goes to standard out.\nrecursive=b,o,Recurse to subdirs.\ncheck=b,o,Triggers a javancss self test.\nencoding=s,o,Encoding used while reading source files (default: platform encoding).\nparser15=b,o,Use new experimental Java 1.5 parser.\n\n[Colors]\nUseSystemColors=true\n";
    private boolean _bExit = false;
    private List _vJavaSourceFiles = null;
    private String encoding = null;
    private String _sErrorMessage = null;
    private Throwable _thrwError = null;
    private JavaParserInterface _pJavaParser = null;
    private int _ncss = 0;
    private int _loc = 0;
    private List _vFunctionMetrics = new ArrayList();
    private List _vObjectMetrics = new ArrayList();
    private List _vPackageMetrics = null;
    private List _vImports = null;
    private Map _htPackages = null;
    private Object[] _aoPackage = null;
    private File _sJavaSourceFile = null;
    private Init _pInit = null;

    private Reader createSourceReader(File sSourceFile_) {
        try {
            return this.newReader(sSourceFile_);
        }
        catch (IOException pIOException) {
            this._sErrorMessage = Util.isEmpty(this._sErrorMessage) ? "" : this._sErrorMessage + "\n";
            this._sErrorMessage = this._sErrorMessage + "File not found: " + sSourceFile_.getAbsolutePath();
            this._thrwError = pIOException;
            return null;
        }
    }

    private void _measureSource(File sSourceFile_) throws IOException, Exception, Error {
        Reader reader = null;
        try {
            reader = this.newReader(sSourceFile_);
        }
        catch (IOException pIOException) {
            this._sErrorMessage = Util.isEmpty(this._sErrorMessage) ? "" : this._sErrorMessage + "\n";
            this._sErrorMessage = this._sErrorMessage + "File not found: " + sSourceFile_.getAbsolutePath();
            this._thrwError = pIOException;
            throw pIOException;
        }
        String sTempErrorMessage = this._sErrorMessage;
        try {
            this._measureSource(reader);
        }
        catch (Exception pParseException) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            sTempErrorMessage = sTempErrorMessage + "ParseException in " + sSourceFile_.getAbsolutePath() + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            throw pParseException;
        }
        catch (Error pTokenMgrError) {
            if (sTempErrorMessage == null) {
                sTempErrorMessage = "";
            }
            this._sErrorMessage = sTempErrorMessage = sTempErrorMessage + "TokenMgrError in " + sSourceFile_.getAbsolutePath() + "\n" + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            throw pTokenMgrError;
        }
    }

    private void _measureSource(Reader reader) throws IOException, Exception, Error {
        Util.debug("_measureSource(Reader).ENTER");
        Util.debug("_measureSource(Reader).ENTER2");
        try {
            boolean parser15;
            boolean bl = parser15 = this._pInit != null && this._pInit.getOptions() != null && this._pInit.getOptions().get("parser15") != null;
            if (Util.isDebug()) {
                if (parser15) {
                    Util.debug("creating JavaParser15Debug");
                    this._pJavaParser = new JavaParser15Debug(reader);
                } else {
                    Util.debug("creating JavaParserDebug");
                    this._pJavaParser = new JavaParserDebug(reader);
                }
            } else if (parser15) {
                Util.debug("creating JavaParser15");
                this._pJavaParser = new JavaParser15(reader);
            } else {
                Util.debug("creating JavaParser");
                this._pJavaParser = new JavaParser(reader);
            }
            this._pJavaParser.parse();
            Util.debug("Javancss._measureSource(DataInputStream).SUCCESSFULLY_PARSED");
            this._ncss += this._pJavaParser.getNcss();
            this._loc += this._pJavaParser.getLOC();
            this._vFunctionMetrics.addAll(this._pJavaParser.getFunction());
            this._vObjectMetrics.addAll(this._pJavaParser.getObject());
            Map htNewPackages = this._pJavaParser.getPackage();
            Iterator ePackages = htNewPackages.entrySet().iterator();
            while (ePackages.hasNext()) {
                String sPackage = (String)ePackages.next().getKey();
                PackageMetric pckmNext = (PackageMetric)htNewPackages.get(sPackage);
                pckmNext.name = sPackage;
                PackageMetric pckmPrevious = (PackageMetric)this._htPackages.get(sPackage);
                pckmNext.add(pckmPrevious);
                this._htPackages.put(sPackage, pckmNext);
            }
        }
        catch (Exception pParseException) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "ParseException in STDIN";
            if (this._pJavaParser != null) {
                this._sErrorMessage = this._sErrorMessage + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            }
            this._sErrorMessage = this._sErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            throw pParseException;
        }
        catch (Error pTokenMgrError) {
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "TokenMgrError in STDIN\n";
            this._sErrorMessage = this._sErrorMessage + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            throw pTokenMgrError;
        }
    }

    private void _measureFiles(List vJavaSourceFiles_) throws IOException, ParseException, TokenMgrError {
        for (File file : vJavaSourceFiles_) {
            try {
                this._measureSource(file);
            }
            catch (Throwable pThrowable) {}
        }
    }

    private void _measureRoot(Reader reader) throws IOException, Exception, Error {
        this._htPackages = new HashMap();
        if (this._vJavaSourceFiles == null) {
            this._measureSource(reader);
        } else {
            this._measureFiles(this._vJavaSourceFiles);
        }
        this._vPackageMetrics = new ArrayList();
        for (String sPackage : this._htPackages.keySet()) {
            PackageMetric pckmNext = (PackageMetric)this._htPackages.get(sPackage);
            this._vPackageMetrics.add(pckmNext);
        }
    }

    public List getImports() {
        return this._vImports;
    }

    public Object[] getPackage() {
        return this._aoPackage;
    }

    public List getFunctions() {
        return this._vFunctionMetrics;
    }

    public Javancss(List vJavaSourceFiles_) {
        this._vJavaSourceFiles = vJavaSourceFiles_;
        try {
            this._measureRoot(this.newReader(System.in));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        catch (TokenMgrError pError) {
            pError.printStackTrace();
        }
    }

    public Javancss(File sJavaSourceFile_) {
        Util.debug("Javancss.<init>(String).sJavaSourceFile_: " + sJavaSourceFile_);
        this._sErrorMessage = null;
        this._vJavaSourceFiles = new ArrayList();
        this._vJavaSourceFiles.add(sJavaSourceFile_);
        try {
            this._measureRoot(this.newReader(System.in));
        }
        catch (Exception e) {
            Util.debug("Javancss.<init>(String).e: " + e);
            e.printStackTrace();
        }
        catch (TokenMgrError pError) {
            Util.debug("Javancss.<init>(String).pError: " + pError);
            pError.printStackTrace();
        }
    }

    public Javancss(InputStream isJavaSource_) {
        Util.debug("Javancss.<init>(InputStream).sJavaSourceFile_: " + isJavaSource_);
        this._sErrorMessage = null;
        this._vJavaSourceFiles = null;
        try {
            this._measureRoot(this.newReader(isJavaSource_));
        }
        catch (Exception e) {
            Util.debug("Javancss.<init>(InputStream).e: " + e);
            e.printStackTrace();
        }
        catch (TokenMgrError pError) {
            Util.debug("Javancss.<init>(InputStream).pError: " + pError);
            pError.printStackTrace();
        }
    }

    public Javancss() {
        this._sErrorMessage = null;
        this._thrwError = null;
    }

    public boolean parseImports() {
        if (this._sJavaSourceFile == null) {
            Util.debug("Javancss.parseImports().NO_FILE");
            return true;
        }
        Reader reader = this.createSourceReader(this._sJavaSourceFile);
        if (reader == null) {
            Util.debug("Javancss.parseImports().NO_DIS");
            return true;
        }
        try {
            Util.debug("Javancss.parseImports().START_PARSING");
            this._pJavaParser = !Util.isDebug() ? new JavaParser(reader) : new JavaParserDebug(reader);
            this._pJavaParser.parseImportUnit();
            this._vImports = this._pJavaParser.getImports();
            this._aoPackage = this._pJavaParser.getPackageObjects();
            Util.debug("Javancss.parseImports().END_PARSING");
        }
        catch (Exception pParseException) {
            Util.debug("Javancss.parseImports().PARSE_EXCEPTION");
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "ParseException in STDIN";
            if (this._pJavaParser != null) {
                this._sErrorMessage = this._sErrorMessage + "\nLast useful checkpoint: \"" + this._pJavaParser.getLastFunction() + "\"\n";
            }
            this._sErrorMessage = this._sErrorMessage + pParseException.getMessage() + "\n";
            this._thrwError = pParseException;
            return true;
        }
        catch (Error pTokenMgrError) {
            Util.debug("Javancss.parseImports().TOKEN_ERROR");
            if (this._sErrorMessage == null) {
                this._sErrorMessage = "";
            }
            this._sErrorMessage = this._sErrorMessage + "TokenMgrError in STDIN\n";
            this._sErrorMessage = this._sErrorMessage + pTokenMgrError.getMessage() + "\n";
            this._thrwError = pTokenMgrError;
            return true;
        }
        return false;
    }

    public void setSourceFile(File javaSourceFile_) {
        this._sJavaSourceFile = javaSourceFile_;
        this._vJavaSourceFiles = new ArrayList();
        this._vJavaSourceFiles.add(javaSourceFile_);
    }

    public int getNcss() {
        return this._ncss;
    }

    public int getLOC() {
        return this._loc;
    }

    public int getJvdc() {
        return this._pJavaParser.getJvdc();
    }

    public int getJdcl() {
        return JavaParserTokenManager._iFormalComments;
    }

    public int getSl() {
        return JavaParserTokenManager._iSingleComments;
    }

    public int getMl() {
        return JavaParserTokenManager._iMultiComments;
    }

    public List getFunctionMetrics() {
        return this._vFunctionMetrics;
    }

    public List getObjectMetrics() {
        return this._vObjectMetrics;
    }

    public List getPackageMetrics() {
        return this._vPackageMetrics;
    }

    public String getLastErrorMessage() {
        if (this._sErrorMessage == null) {
            return null;
        }
        return this._sErrorMessage;
    }

    public Throwable getLastError() {
        return this._thrwError;
    }

    public void setExit() {
        this._bExit = true;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private Reader newReader(InputStream stream) throws UnsupportedEncodingException {
        return this.encoding == null ? new InputStreamReader(stream) : new InputStreamReader(stream, this.encoding);
    }

    private Reader newReader(File file) throws FileNotFoundException, UnsupportedEncodingException {
        return this.newReader(new FileInputStream(file));
    }
}

