/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.tp;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.instrument.tp.TouchPointDescriptor;
import org.objectweb.asm.Label;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchTouchPointDescriptor
extends TouchPointDescriptor {
    private final Label defaultDestinationLabel;
    private final Label[] labels;
    private final String enum_type;
    private Integer counterId;
    private Map<Label, Integer> label2counterId;

    public SwitchTouchPointDescriptor(int eventId, int currentLine, Label def, Label[] labels, String enum_type) {
        super(eventId, currentLine);
        this.labels = labels;
        this.defaultDestinationLabel = def;
        this.enum_type = enum_type;
    }

    public Integer getCounterId() {
        return this.counterId;
    }

    public void setCounterId(Integer counterId) {
        this.counterId = counterId;
    }

    @Override
    public int assignCounters(AtomicInteger idGenerator) {
        this.counterId = idGenerator.incrementAndGet();
        this.label2counterId = new HashMap<Label, Integer>();
        int idp = idGenerator.incrementAndGet();
        this.label2counterId.put(this.defaultDestinationLabel, idp);
        int i = 0;
        for (Label l : this.labels) {
            ++i;
            idp = idGenerator.incrementAndGet();
            this.label2counterId.put(l, idp);
        }
        return i + 2;
    }

    public Integer getCounterIdForLabel(Label label) {
        return this.label2counterId.get(label);
    }

    public Collection<Integer> getCountersForLabels() {
        return this.label2counterId.values();
    }

    public int getCountersForLabelsCnt() {
        HashSet<Label> l = new HashSet<Label>(Arrays.asList(this.labels));
        l.add(this.defaultDestinationLabel);
        return l.size();
    }

    public String getEnumType() {
        return this.enum_type;
    }
}

