/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass2;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.instrument.AbstractFindTouchPointsClassInstrumenter;
import net.sourceforge.cobertura.instrument.FindTouchPointsMethodAdapter;
import net.sourceforge.cobertura.instrument.HistoryMethodAdapter;
import net.sourceforge.cobertura.instrument.pass2.BuildClassMapTouchPointListener;
import net.sourceforge.cobertura.instrument.tp.ClassMap;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildClassMapClassVisitor
extends AbstractFindTouchPointsClassInstrumenter {
    private final ClassMap classMap = new ClassMap();
    private final BuildClassMapTouchPointListener touchPointListener = new BuildClassMapTouchPointListener(this.classMap);
    private boolean toInstrument = true;
    private final Set<String> ignoredMethods;

    public BuildClassMapClassVisitor(ClassVisitor cv, Collection<Pattern> ignoreRegexes, Map<Integer, Map<Integer, Integer>> duplicatedLinesMap, Set<String> ignoredMethods) {
        super(cv, ignoreRegexes, duplicatedLinesMap);
        this.ignoredMethods = ignoredMethods;
    }

    public AnnotationVisitor visitAnnotation(String name, boolean arg1) {
        if (Type.getDescriptor(CoverageIgnore.class).equals(name)) {
            this.toInstrument = false;
        }
        return super.visitAnnotation(name, arg1);
    }

    public void visit(int version, int access, String name, String signature, String parent, String[] interfaces) {
        this.classMap.setClassName(name);
        if ((access & 0x200) != 0) {
            this.toInstrument = false;
        }
        super.visit(version, access, name, signature, parent, interfaces);
    }

    public void visitSource(String file, String debug) {
        this.classMap.setSource(file);
        super.visitSource(file, debug);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 8) != 0 && "__cobertura_init".equals(name)) {
            this.toInstrument = false;
        }
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.ignoredMethods.contains(name + desc)) {
            return mv;
        }
        FindTouchPointsMethodAdapter instrumenter = new FindTouchPointsMethodAdapter(new HistoryMethodAdapter(mv, 4), this.classMap.getClassName(), name, desc, this.eventIdGenerator, (Map<Integer, Map<Integer, Integer>>)this.duplicatedLinesMap, this.lineIdGenerator);
        instrumenter.setTouchPointListener(this.touchPointListener);
        instrumenter.setIgnoreRegexp(this.getIgnoreRegexp());
        return instrumenter;
    }

    public ClassMap getClassMap() {
        return this.classMap;
    }

    public boolean shouldBeInstrumented() {
        return this.toInstrument;
    }
}

