/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.instrument.pass1;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.sourceforge.cobertura.instrument.pass1.DetectDuplicatedCodeMethodVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.CheckClassAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DetectDuplicatedCodeClassVisitor
extends ClassVisitor {
    private Map<Integer, Map<Integer, Integer>> duplicatedLinesCollector = new HashMap<Integer, Map<Integer, Integer>>();
    private String className;
    private final AtomicInteger lineIdGenerator = new AtomicInteger(0);

    public DetectDuplicatedCodeClassVisitor(ClassVisitor cv) {
        super(262144, (ClassVisitor)new CheckClassAdapter(cv, false));
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String methodName, String description, String signature, String[] exceptions) {
        MethodVisitor nestedVisitor = super.visitMethod(access, methodName, description, signature, exceptions);
        return new DetectDuplicatedCodeMethodVisitor(nestedVisitor, this.duplicatedLinesCollector, this.className, methodName, description, this.lineIdGenerator);
    }

    public Map<Integer, Map<Integer, Integer>> getDuplicatesLinesCollector() {
        return this.duplicatedLinesCollector;
    }
}

