/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.LightClassmapListener;
import net.sourceforge.cobertura.coveragedata.LineData;
import net.sourceforge.cobertura.coveragedata.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CoverageIgnore
public class TouchCollector {
    private static final Logger logger = Logger.getLogger(TouchCollector.class.getCanonicalName());
    private static Map<Class<?>, Integer> registeredClasses = new ConcurrentHashMap();

    public static synchronized void registerClass(Class<?> classa) {
        registeredClasses.put(classa, 0);
    }

    public static synchronized void registerClass(String classa) throws ClassNotFoundException {
        try {
            boolean found = false;
            Class<?> clazz = Class.forName(classa.replace("/", "."), false, Thread.currentThread().getContextClassLoader());
            for (Method meth : clazz.getMethods()) {
                if (!meth.toString().contains("net.sourceforge.cobertura")) continue;
                TouchCollector.registerClass(clazz);
                found = true;
            }
            if (!found) {
                clazz = Class.forName(classa.replace("/", "."));
                TouchCollector.registerClass(clazz);
            }
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Exception when registering class: " + classa, e);
            throw e;
        }
    }

    public static synchronized void applyTouchesOnProjectData(ProjectData projectData) {
        logger.fine("=================== START OF REPORT ======================== ");
        for (Class<?> c : registeredClasses.keySet()) {
            logger.fine("Report: " + c.getName());
            ClassData cd = projectData.getOrCreateClassData(c.getName());
            TouchCollector.applyTouchesToSingleClassOnProjectData(cd, c);
        }
        logger.fine("===================  END OF REPORT  ======================== ");
    }

    private static void applyTouchesToSingleClassOnProjectData(ClassData classData, Class<?> c) {
        logger.finer("----------- " + c.getCanonicalName() + " ---------------- ");
        try {
            Method m0 = c.getDeclaredMethod("__cobertura_get_and_reset_counters", new Class[0]);
            m0.setAccessible(true);
            int[] res = (int[])m0.invoke(null, new Object[0]);
            ApplyToClassDataLightClassmapListener lightClassmap = new ApplyToClassDataLightClassmapListener(classData, res);
            Method m = c.getDeclaredMethod("__cobertura_classmap", LightClassmapListener.class);
            m.setAccessible(true);
            m.invoke(null, lightClassmap);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Cannot apply touches", e);
        }
    }

    static {
        ProjectData.getGlobalProjectData();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @CoverageIgnore
    private static class ApplyToClassDataLightClassmapListener
    implements LightClassmapListener {
        private final ClassData classData;
        private final int[] res;
        private int currentLine = 0;
        private int jumpsInLine = 0;
        private int switchesInLine = 0;

        private void updateLine(int new_line) {
            if (new_line != this.currentLine) {
                this.currentLine = new_line;
                this.jumpsInLine = 0;
                this.switchesInLine = 0;
            }
        }

        public ApplyToClassDataLightClassmapListener(ClassData cd, int[] res) {
            this.classData = cd;
            this.res = res;
        }

        @Override
        public void setSource(String source) {
            logger.fine("source: " + source);
            this.classData.setSourceFileName(source);
        }

        @Override
        public void setClazz(Class<?> clazz) {
        }

        @Override
        public void setClazz(String clazz) {
        }

        @Override
        public void putLineTouchPoint(int classLine, int counterId, String methodName, String methodDescription) {
            this.updateLine(classLine);
            LineData ld = this.classData.addLine(classLine, methodName, methodDescription);
            ld.touch(this.res[counterId]);
        }

        @Override
        public void putSwitchTouchPoint(int classLine, int maxBranches, int ... counterIds) {
            this.updateLine(classLine);
            LineData ld = this.getOrCreateLine(classLine);
            int switchId = this.switchesInLine++;
            this.classData.addLineSwitch(classLine, switchId, 0, counterIds.length - 2, maxBranches);
            for (int i = 0; i < counterIds.length; ++i) {
                ld.touchSwitch(switchId, i - 1, this.res[counterIds[i]]);
            }
        }

        @Override
        public void putJumpTouchPoint(int classLine, int trueCounterId, int falseCounterId) {
            this.updateLine(classLine);
            LineData ld = this.getOrCreateLine(classLine);
            int branchId = this.jumpsInLine++;
            this.classData.addLineJump(classLine, branchId);
            ld.touchJump(branchId, true, this.res[trueCounterId]);
            ld.touchJump(branchId, false, this.res[falseCounterId]);
        }

        private LineData getOrCreateLine(int classLine) {
            LineData ld = this.classData.getLineData(classLine);
            if (ld == null) {
                ld = this.classData.addLine(classLine, null, null);
            }
            return ld;
        }
    }
}

