/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.CoverageDataFileHandler;
import net.sourceforge.cobertura.coveragedata.LineData;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.SaveTimer;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.coveragedata.TouchCollector;
import net.sourceforge.cobertura.util.FileLocker;

@CoverageIgnore
public class ProjectData
extends CoverageDataContainer {
    private static final Logger logger = Logger.getLogger(ProjectData.class.getCanonicalName());
    private static final long serialVersionUID = 6L;
    private static ProjectData globalProjectData = null;
    private static Thread shutdownHook;
    private static final transient Lock globalProjectDataLock;
    private Map classes = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClassData(ClassData classData) {
        this.lock.lock();
        try {
            String packageName = classData.getPackageName();
            PackageData packageData = (PackageData)this.children.get(packageName);
            if (packageData == null) {
                packageData = new PackageData(packageName);
                this.children.put(packageName, packageData);
            }
            packageData.addClassData(classData);
            this.classes.put(classData.getName(), classData);
        }
        finally {
            this.lock.unlock();
        }
    }

    public ClassData getClassData(String name) {
        return (ClassData)this.classes.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassData getOrCreateClassData(String name) {
        this.lock.lock();
        try {
            ClassData classData = (ClassData)this.classes.get(name);
            if (classData == null) {
                classData = new ClassData(name);
                this.addClassData(classData);
            }
            ClassData classData2 = classData;
            return classData2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getClasses() {
        this.lock.lock();
        try {
            Collection collection = this.classes.values();
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfClasses() {
        this.lock.lock();
        try {
            int n = this.classes.size();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public int getNumberOfSourceFiles() {
        return this.getSourceFiles().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet getPackages() {
        this.lock.lock();
        try {
            TreeSet treeSet = new TreeSet(this.children.values());
            return treeSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getSourceFiles() {
        TreeSet sourceFileDatas = new TreeSet();
        this.lock.lock();
        try {
            for (PackageData packageData : this.children.values()) {
                sourceFileDatas.addAll(packageData.getSourceFiles());
            }
        }
        finally {
            this.lock.unlock();
        }
        return sourceFileDatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet getSubPackages(String packageName) {
        TreeSet<PackageData> subPackages = new TreeSet<PackageData>();
        this.lock.lock();
        try {
            for (PackageData packageData : this.children.values()) {
                if (!packageData.getName().startsWith(packageName + ".") && !packageData.getName().equals(packageName) && packageName.length() != 0) continue;
                subPackages.add(packageData);
            }
        }
        finally {
            this.lock.unlock();
        }
        return subPackages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(CoverageData coverageData) {
        if (coverageData == null) {
            return;
        }
        ProjectData projectData = (ProjectData)coverageData;
        this.getBothLocks(projectData);
        try {
            super.merge(coverageData);
            for (Object key : projectData.classes.keySet()) {
                if (this.classes.containsKey(key)) continue;
                this.classes.put(key, projectData.classes.get(key));
            }
        }
        finally {
            this.lock.unlock();
            projectData.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProjectData getGlobalProjectData() {
        globalProjectDataLock.lock();
        try {
            if (globalProjectData != null) {
                ProjectData projectData = globalProjectData;
                return projectData;
            }
            globalProjectData = new ProjectData();
            ProjectData.initialize();
            ProjectData projectData = globalProjectData;
            return projectData;
        }
        finally {
            globalProjectDataLock.unlock();
        }
    }

    private static void initialize() {
        if (System.getProperty("catalina.home") != null) {
            ProjectData.saveGlobalProjectData();
            ClassData.class.toString();
            CoverageData.class.toString();
            CoverageDataContainer.class.toString();
            FileLocker.class.toString();
            LineData.class.toString();
            PackageData.class.toString();
            SourceFileData.class.toString();
        }
        shutdownHook = new Thread(new SaveTimer());
        Runtime.getRuntime().addShutdownHook(shutdownHook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveGlobalProjectData() {
        ProjectData projectDataToSave = null;
        globalProjectDataLock.lock();
        try {
            projectDataToSave = ProjectData.getGlobalProjectData();
            globalProjectData = new ProjectData();
        }
        finally {
            globalProjectDataLock.unlock();
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        TouchCollector.applyTouchesOnProjectData(projectDataToSave);
        File dataFile = CoverageDataFileHandler.getDefaultDataFile();
        String string = dataFile.getPath().intern();
        synchronized (string) {
            FileLocker fileLocker = new FileLocker(dataFile);
            try {
                if (fileLocker.lock()) {
                    ProjectData datafileProjectData = ProjectData.loadCoverageDataFromDatafile(dataFile);
                    if (datafileProjectData == null) {
                        datafileProjectData = projectDataToSave;
                    } else {
                        datafileProjectData.merge(projectDataToSave);
                    }
                    CoverageDataFileHandler.saveCoverageData(datafileProjectData, dataFile);
                }
            }
            finally {
                fileLocker.release();
            }
        }
    }

    public static void turnOffAutoSave() {
        if (shutdownHook != null) {
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
        }
    }

    private static ProjectData loadCoverageDataFromDatafile(File dataFile) {
        ProjectData projectData = null;
        if (dataFile.isFile()) {
            projectData = CoverageDataFileHandler.loadCoverageData(dataFile);
        }
        if (projectData == null) {
            logger.info("Cobertura: Coverage data file " + dataFile.getAbsolutePath() + " either does not exist or is not readable.  Creating a new data file.");
        }
        return projectData;
    }

    static {
        globalProjectDataLock = new ReentrantLock();
    }
}

