/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.coveragedata;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sourceforge.cobertura.CoverageIgnore;
import net.sourceforge.cobertura.coveragedata.CoverageData;
import net.sourceforge.cobertura.coveragedata.CoverageDataContainer;
import net.sourceforge.cobertura.coveragedata.LineData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CoverageIgnore
public class ClassData
extends CoverageDataContainer
implements Comparable<ClassData> {
    private static final long serialVersionUID = 5L;
    private Map<Integer, LineData> branches = new HashMap<Integer, LineData>();
    private boolean containsInstrumentationInfo = false;
    private Set<String> methodNamesAndDescriptors = new HashSet<String>();
    private String name = null;
    private String sourceFileName = null;

    public ClassData() {
    }

    public ClassData(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Class name must be specified.");
        }
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineData addLine(int lineNumber, String methodName, String methodDescriptor) {
        this.lock.lock();
        try {
            LineData lineData = this.getLineData(lineNumber);
            if (lineData == null) {
                lineData = new LineData(lineNumber);
                this.children.put(new Integer(lineNumber), lineData);
            }
            lineData.setMethodNameAndDescriptor(methodName, methodDescriptor);
            if (methodName != null && methodDescriptor != null) {
                this.methodNamesAndDescriptors.add(methodName + methodDescriptor);
            }
            LineData lineData2 = lineData;
            return lineData2;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int compareTo(ClassData o) {
        if (!o.getClass().equals(ClassData.class)) {
            return Integer.MAX_VALUE;
        }
        return this.name.compareTo(o.name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsInstrumentationInfo() {
        this.lock.lock();
        try {
            boolean bl = this.containsInstrumentationInfo;
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !obj.getClass().equals(this.getClass())) {
            return false;
        }
        ClassData classData = (ClassData)obj;
        this.getBothLocks(classData);
        try {
            boolean bl = super.equals(obj) && this.branches.equals(classData.branches) && this.methodNamesAndDescriptors.equals(classData.methodNamesAndDescriptors) && this.name.equals(classData.name) && this.sourceFileName.equals(classData.sourceFileName);
            return bl;
        }
        finally {
            this.lock.unlock();
            classData.lock.unlock();
        }
    }

    public String getBaseName() {
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot == -1) {
            return this.name;
        }
        return this.name.substring(lastDot + 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getBranchCoverageRate(String methodNameAndDescriptor) {
        int total = 0;
        int covered = 0;
        this.lock.lock();
        try {
            for (LineData next : this.branches.values()) {
                if (!methodNameAndDescriptor.equals(next.getMethodName() + next.getMethodDescriptor())) continue;
                total += next.getNumberOfValidBranches();
                covered += next.getNumberOfCoveredBranches();
            }
            if (total == 0) {
                double d = 1.0;
                return d;
            }
            double d = (double)covered / (double)total;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<Integer> getBranches() {
        this.lock.lock();
        try {
            Collection<Integer> collection = Collections.unmodifiableCollection(this.branches.keySet());
            return collection;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineData getLineCoverage(int lineNumber) {
        Integer lineObject = new Integer(lineNumber);
        this.lock.lock();
        try {
            if (!this.children.containsKey(lineObject)) {
                LineData lineData = null;
                return lineData;
            }
            LineData lineData = (LineData)this.children.get(lineObject);
            return lineData;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getLineCoverageRate(String methodNameAndDescriptor) {
        int total = 0;
        int hits = 0;
        this.lock.lock();
        try {
            for (LineData next : this.children.values()) {
                if (!methodNameAndDescriptor.equals(next.getMethodName() + next.getMethodDescriptor())) continue;
                ++total;
                if (next.getHits() <= 0L) continue;
                ++hits;
            }
            if (total == 0) {
                double d = 1.0;
                return d;
            }
            double d = (double)hits / (double)total;
            return d;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineData getLineData(int lineNumber) {
        this.lock.lock();
        try {
            LineData lineData = (LineData)this.children.get(lineNumber);
            return lineData;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SortedSet<CoverageData> getLines() {
        this.lock.lock();
        try {
            TreeSet<CoverageData> treeSet = new TreeSet<CoverageData>(this.children.values());
            return treeSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<CoverageData> getLines(String methodNameAndDescriptor) {
        HashSet<CoverageData> lines = new HashSet<CoverageData>();
        this.lock.lock();
        try {
            for (LineData next : this.children.values()) {
                if (!methodNameAndDescriptor.equals(next.getMethodName() + next.getMethodDescriptor())) continue;
                lines.add(next);
            }
            HashSet<CoverageData> hashSet = lines;
            return hashSet;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getMethodNamesAndDescriptors() {
        this.lock.lock();
        try {
            Set<String> set = this.methodNamesAndDescriptors;
            return set;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfValidBranches() {
        int number = 0;
        this.lock.lock();
        try {
            Iterator<LineData> i = this.branches.values().iterator();
            while (i.hasNext()) {
                number += i.next().getNumberOfValidBranches();
            }
            int n = number;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int getNumberOfCoveredBranches() {
        int number = 0;
        this.lock.lock();
        try {
            Iterator<LineData> i = this.branches.values().iterator();
            while (i.hasNext()) {
                number += i.next().getNumberOfCoveredBranches();
            }
            int n = number;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    public String getPackageName() {
        int lastDot = this.name.lastIndexOf(46);
        if (lastDot == -1) {
            return "";
        }
        return this.name.substring(0, lastDot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourceFileName() {
        this.lock.lock();
        try {
            String baseName;
            int firstDollarSign;
            baseName = this.sourceFileName != null ? this.sourceFileName : ((firstDollarSign = (baseName = this.getBaseName()).indexOf(36)) == -1 || firstDollarSign == 0 ? baseName + ".java" : baseName.substring(0, firstDollarSign) + ".java");
            String packageName = this.getPackageName();
            if (packageName.equals("")) {
                String string = baseName;
                return string;
            }
            String string = packageName.replace('.', '/') + '/' + baseName;
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public int hashCode() {
        return this.name.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasBranch(int lineNumber) {
        this.lock.lock();
        try {
            boolean bl = this.branches.containsKey(lineNumber);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isValidSourceLineNumber(int lineNumber) {
        this.lock.lock();
        try {
            boolean bl = this.children.containsKey(lineNumber);
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineJump(int lineNumber, int branchNumber) {
        this.lock.lock();
        try {
            LineData lineData = this.getLineData(lineNumber);
            if (lineData != null) {
                lineData.addJump(branchNumber);
                this.branches.put(lineNumber, lineData);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineSwitch(int lineNumber, int switchNumber, int min, int max, int maxBranches) {
        this.lock.lock();
        try {
            LineData lineData = this.getLineData(lineNumber);
            if (lineData != null) {
                lineData.addSwitch(switchNumber, min, max, maxBranches);
                this.branches.put(lineNumber, lineData);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void merge(CoverageData coverageData) {
        ClassData classData = (ClassData)coverageData;
        if (!this.getName().equals(classData.getName())) {
            return;
        }
        this.getBothLocks(classData);
        try {
            super.merge(coverageData);
            for (Integer key : classData.branches.keySet()) {
                if (this.branches.containsKey(key)) continue;
                this.branches.put(key, classData.branches.get(key));
            }
            this.containsInstrumentationInfo |= classData.containsInstrumentationInfo;
            this.methodNamesAndDescriptors.addAll(classData.getMethodNamesAndDescriptors());
            if (classData.sourceFileName != null) {
                this.sourceFileName = classData.sourceFileName;
            }
        }
        finally {
            this.lock.unlock();
            classData.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeLine(int lineNumber) {
        Integer lineObject = lineNumber;
        this.lock.lock();
        try {
            this.children.remove(lineObject);
            this.branches.remove(lineObject);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContainsInstrumentationInfo() {
        this.lock.lock();
        try {
            this.containsInstrumentationInfo = true;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSourceFileName(String sourceFileName) {
        this.lock.lock();
        try {
            this.sourceFileName = sourceFileName;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touch(int lineNumber, int hits) {
        this.lock.lock();
        try {
            LineData lineData = this.getLineData(lineNumber);
            if (lineData == null) {
                lineData = this.addLine(lineNumber, null, null);
            }
            lineData.touch(hits);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchJump(int lineNumber, int branchNumber, boolean branch, int hits) {
        this.lock.lock();
        try {
            LineData lineData = this.getLineData(lineNumber);
            if (lineData == null) {
                lineData = this.addLine(lineNumber, null, null);
            }
            lineData.touchJump(branchNumber, branch, hits);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void touchSwitch(int lineNumber, int switchNumber, int branch, int hits) {
        this.lock.lock();
        try {
            LineData lineData = this.getLineData(lineNumber);
            if (lineData == null) {
                lineData = this.addLine(lineNumber, null, null);
            }
            lineData.touchSwitch(switchNumber, branch, hits);
        }
        finally {
            this.lock.unlock();
        }
    }
}

